// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to retrieve a list of the health checks that are associated with
// the current AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecksRequest
type ListHealthChecksInput struct {
	_ struct{} `type:"structure"`

	// If the value of IsTruncated in the previous response was true, you have more
	// health checks. To get another group, submit another ListHealthChecks request.
	//
	// For the value of marker, specify the value of NextMarker from the previous
	// response, which is the ID of the first health check that Amazon Route 53
	// will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more health checks to get.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of health checks that you want ListHealthChecks to return
	// in response to the current request. Amazon Route 53 returns a maximum of
	// 100 items. If you set MaxItems to a value greater than 100, Route 53 returns
	// only the first 100 health checks.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHealthChecksInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListHealthChecksInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxitems", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains the response to a ListHealthChecks request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecksResponse
type ListHealthChecksOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one HealthCheck element for each health check
	// that is associated with the current AWS account.
	//
	// HealthChecks is a required field
	HealthChecks []HealthCheck `locationNameList:"HealthCheck" type:"list" required:"true"`

	// A flag that indicates whether there are more health checks to be listed.
	// If the response was truncated, you can get the next group of health checks
	// by submitting another ListHealthChecks request and specifying the value of
	// NextMarker in the marker parameter.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// For the second and subsequent calls to ListHealthChecks, Marker is the value
	// that you specified for the marker parameter in the previous request.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListHealthChecks
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextMarker identifies the first health
	// check that Amazon Route 53 returns if you submit another ListHealthChecks
	// request and specify the value of NextMarker in the marker parameter.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListHealthChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListHealthChecksOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.HealthChecks) > 0 {
		v := s.HealthChecks

		metadata := protocol.Metadata{ListLocationName: "HealthCheck"}
		ls0 := e.List(protocol.BodyTarget, "HealthChecks", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.StringValue(v), metadata)
	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.StringValue(v), metadata)
	}
	return nil
}

const opListHealthChecks = "ListHealthChecks"

// ListHealthChecksRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Retrieve a list of the health checks that are associated with the current
// AWS account.
//
//    // Example sending a request using ListHealthChecksRequest.
//    req := client.ListHealthChecksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks
func (c *Client) ListHealthChecksRequest(input *ListHealthChecksInput) ListHealthChecksRequest {
	op := &aws.Operation{
		Name:       opListHealthChecks,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHealthChecksInput{}
	}

	req := c.newRequest(op, input, &ListHealthChecksOutput{})
	return ListHealthChecksRequest{Request: req, Input: input, Copy: c.ListHealthChecksRequest}
}

// ListHealthChecksRequest is the request type for the
// ListHealthChecks API operation.
type ListHealthChecksRequest struct {
	*aws.Request
	Input *ListHealthChecksInput
	Copy  func(*ListHealthChecksInput) ListHealthChecksRequest
}

// Send marshals and sends the ListHealthChecks API request.
func (r ListHealthChecksRequest) Send(ctx context.Context) (*ListHealthChecksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListHealthChecksResponse{
		ListHealthChecksOutput: r.Request.Data.(*ListHealthChecksOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListHealthChecksRequestPaginator returns a paginator for ListHealthChecks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListHealthChecksRequest(input)
//   p := route53.NewListHealthChecksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListHealthChecksPaginator(req ListHealthChecksRequest) ListHealthChecksPaginator {
	return ListHealthChecksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListHealthChecksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListHealthChecksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListHealthChecksPaginator struct {
	aws.Pager
}

func (p *ListHealthChecksPaginator) CurrentPage() *ListHealthChecksOutput {
	return p.Pager.CurrentPage().(*ListHealthChecksOutput)
}

// ListHealthChecksResponse is the response type for the
// ListHealthChecks API operation.
type ListHealthChecksResponse struct {
	*ListHealthChecksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListHealthChecks request.
func (r *ListHealthChecksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
