// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigsRequest
type ListQueryLoggingConfigsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) If you want to list the query logging configuration that is associated
	// with a hosted zone, specify the ID in HostedZoneId.
	//
	// If you don't specify a hosted zone ID, ListQueryLoggingConfigs returns all
	// of the configurations that are associated with the current AWS account.
	HostedZoneId *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// (Optional) The maximum number of query logging configurations that you want
	// Amazon Route 53 to return in response to the current request. If the current
	// AWS account has more than MaxResults configurations, use the value of NextToken
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax)
	// in the response to get the next page of results.
	//
	// If you don't specify a value for MaxResults, Route 53 returns up to 100 configurations.
	MaxResults *string `location:"querystring" locationName:"maxresults" type:"string"`

	// (Optional) If the current AWS account has more than MaxResults query logging
	// configurations, use NextToken to get the second and subsequent pages of results.
	//
	// For the first ListQueryLoggingConfigs request, omit this value.
	//
	// For the second and subsequent requests, get the value of NextToken from the
	// previous response and specify that value for NextToken in the request.
	NextToken *string `location:"querystring" locationName:"nexttoken" type:"string"`
}

// String returns the string representation
func (s ListQueryLoggingConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListQueryLoggingConfigsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "hostedzoneid", protocol.StringValue(v), metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxresults", protocol.StringValue(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nexttoken", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigsResponse
type ListQueryLoggingConfigsOutput struct {
	_ struct{} `type:"structure"`

	// If a response includes the last of the query logging configurations that
	// are associated with the current AWS account, NextToken doesn't appear in
	// the response.
	//
	// If a response doesn't include the last of the configurations, you can get
	// more configurations by submitting another ListQueryLoggingConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html)
	// request. Get the value of NextToken that Amazon Route 53 returned in the
	// previous response and include it in NextToken in the next request.
	NextToken *string `type:"string"`

	// An array that contains one QueryLoggingConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html)
	// element for each configuration for DNS query logging that is associated with
	// the current AWS account.
	//
	// QueryLoggingConfigs is a required field
	QueryLoggingConfigs []QueryLoggingConfig `locationNameList:"QueryLoggingConfig" type:"list" required:"true"`
}

// String returns the string representation
func (s ListQueryLoggingConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListQueryLoggingConfigsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.StringValue(v), metadata)
	}
	if len(s.QueryLoggingConfigs) > 0 {
		v := s.QueryLoggingConfigs

		metadata := protocol.Metadata{ListLocationName: "QueryLoggingConfig"}
		ls0 := e.List(protocol.BodyTarget, "QueryLoggingConfigs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListQueryLoggingConfigs = "ListQueryLoggingConfigs"

// ListQueryLoggingConfigsRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Lists the configurations for DNS query logging that are associated with the
// current AWS account or the configuration that is associated with a specified
// hosted zone.
//
// For more information about DNS query logs, see CreateQueryLoggingConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html).
// Additional information, including the format of DNS query logs, appears in
// Logging DNS Queries (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html)
// in the Amazon Route 53 Developer Guide.
//
//    // Example sending a request using ListQueryLoggingConfigsRequest.
//    req := client.ListQueryLoggingConfigsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs
func (c *Client) ListQueryLoggingConfigsRequest(input *ListQueryLoggingConfigsInput) ListQueryLoggingConfigsRequest {
	op := &aws.Operation{
		Name:       opListQueryLoggingConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/queryloggingconfig",
	}

	if input == nil {
		input = &ListQueryLoggingConfigsInput{}
	}

	req := c.newRequest(op, input, &ListQueryLoggingConfigsOutput{})
	return ListQueryLoggingConfigsRequest{Request: req, Input: input, Copy: c.ListQueryLoggingConfigsRequest}
}

// ListQueryLoggingConfigsRequest is the request type for the
// ListQueryLoggingConfigs API operation.
type ListQueryLoggingConfigsRequest struct {
	*aws.Request
	Input *ListQueryLoggingConfigsInput
	Copy  func(*ListQueryLoggingConfigsInput) ListQueryLoggingConfigsRequest
}

// Send marshals and sends the ListQueryLoggingConfigs API request.
func (r ListQueryLoggingConfigsRequest) Send(ctx context.Context) (*ListQueryLoggingConfigsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListQueryLoggingConfigsResponse{
		ListQueryLoggingConfigsOutput: r.Request.Data.(*ListQueryLoggingConfigsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListQueryLoggingConfigsResponse is the response type for the
// ListQueryLoggingConfigs API operation.
type ListQueryLoggingConfigsResponse struct {
	*ListQueryLoggingConfigsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListQueryLoggingConfigs request.
func (r *ListQueryLoggingConfigsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
