// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Specifies the days since the initiation of an Incomplete Multipart Upload
// that Lifecycle will wait before permanently removing all parts of the upload.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortIncompleteMultipartUpload
type AbortIncompleteMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Indicates the number of days that must pass since initiation for Lifecycle
	// to abort an Incomplete Multipart Upload.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation
func (s AbortIncompleteMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortIncompleteMultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if s.DaysAfterInitiation != nil {
		v := *s.DaysAfterInitiation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DaysAfterInitiation", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccelerateConfiguration
type AccelerateConfiguration struct {
	_ struct{} `type:"structure"`

	// The accelerate configuration of the bucket.
	Status BucketAccelerateStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s AccelerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccelerateConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccessControlPolicy
type AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessControlPolicy"}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessControlPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Grants) > 0 {
		v := s.Grants

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

// A container for information about access control for replicas.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccessControlTranslation
type AccessControlTranslation struct {
	_ struct{} `type:"structure"`

	// The override value for the owner of the replica object.
	//
	// Owner is a required field
	Owner OwnerOverride `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AccessControlTranslation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlTranslation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessControlTranslation"}
	if len(s.Owner) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Owner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessControlTranslation) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Owner) > 0 {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsAndOperator
type AnalyticsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix to use when evaluating an AND predicate.
	Prefix *string `type:"string"`

	// The list of tags to use when evaluating an AND predicate.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s AnalyticsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsConfiguration
type AnalyticsConfiguration struct {
	_ struct{} `type:"structure"`

	// The filter used to describe a set of objects for analyses. A filter must
	// have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator).
	// If no filter is provided, all objects will be considered in any analysis.
	Filter *AnalyticsFilter `type:"structure"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If present, it indicates that data related to access patterns will be collected
	// and made available to analyze the tradeoffs between different storage classes.
	//
	// StorageClassAnalysis is a required field
	StorageClassAnalysis *StorageClassAnalysis `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalyticsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsConfiguration"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.StorageClassAnalysis == nil {
		invalidParams.Add(aws.NewErrParamRequired("StorageClassAnalysis"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.StorageClassAnalysis != nil {
		if err := s.StorageClassAnalysis.Validate(); err != nil {
			invalidParams.AddNested("StorageClassAnalysis", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.StorageClassAnalysis != nil {
		v := s.StorageClassAnalysis

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StorageClassAnalysis", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsExportDestination
type AnalyticsExportDestination struct {
	_ struct{} `type:"structure"`

	// A destination signifying output to an S3 bucket.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *AnalyticsS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalyticsExportDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsExportDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsExportDestination"}

	if s.S3BucketDestination == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsExportDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3BucketDestination != nil {
		v := s.S3BucketDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3BucketDestination", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsFilter
type AnalyticsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating an
	// analytics filter. The operator must have at least two predicates.
	And *AnalyticsAndOperator `type:"structure"`

	// The prefix to use when evaluating an analytics filter.
	Prefix *string `type:"string"`

	// The tag to use when evaluating an analytics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s AnalyticsFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsS3BucketDestination
type AnalyticsS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the bucket to which data is exported.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The account ID that owns the destination bucket. If no account ID is provided,
	// the owner will not be validated prior to exporting data.
	BucketAccountId *string `type:"string"`

	// The file format used when exporting data to Amazon S3.
	//
	// Format is a required field
	Format AnalyticsS3ExportFileFormat `type:"string" required:"true" enum:"true"`

	// The prefix to use when exporting data. The exported data begins with this
	// prefix.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s AnalyticsS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsS3BucketDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsS3BucketDestination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *AnalyticsS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsS3BucketDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.BucketAccountId != nil {
		v := *s.BucketAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BucketAccountId", protocol.StringValue(v), metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Bucket
type Bucket struct {
	_ struct{} `type:"structure"`

	// Date the bucket was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Bucket) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketLifecycleConfiguration
type BucketLifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []LifecycleRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s BucketLifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLifecycleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BucketLifecycleConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketLifecycleConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketLoggingStatus
type BucketLoggingStatus struct {
	_ struct{} `type:"structure"`

	// Container for logging information. Presence of this element indicates that
	// logging is enabled. Parameters TargetBucket and TargetPrefix are required
	// in this case.
	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s BucketLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLoggingStatus) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BucketLoggingStatus"}
	if s.LoggingEnabled != nil {
		if err := s.LoggingEnabled.Validate(); err != nil {
			invalidParams.AddNested("LoggingEnabled", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketLoggingStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.LoggingEnabled != nil {
		v := s.LoggingEnabled

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LoggingEnabled", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CORSConfiguration
type CORSConfiguration struct {
	_ struct{} `type:"structure"`

	// CORSRules is a required field
	CORSRules []CORSRule `locationName:"CORSRule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s CORSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CORSConfiguration"}

	if s.CORSRules == nil {
		invalidParams.Add(aws.NewErrParamRequired("CORSRules"))
	}
	if s.CORSRules != nil {
		for i, v := range s.CORSRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CORSRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CORSConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CORSRules) > 0 {
		v := s.CORSRules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CORSRule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CORSRule
type CORSRule struct {
	_ struct{} `type:"structure"`

	// Specifies which headers are allowed in a pre-flight OPTIONS request.
	AllowedHeaders []string `locationName:"AllowedHeader" type:"list" flattened:"true"`

	// Identifies HTTP methods that the domain/origin specified in the rule is allowed
	// to execute.
	//
	// AllowedMethods is a required field
	AllowedMethods []string `locationName:"AllowedMethod" type:"list" flattened:"true" required:"true"`

	// One or more origins you want customers to be able to access the bucket from.
	//
	// AllowedOrigins is a required field
	AllowedOrigins []string `locationName:"AllowedOrigin" type:"list" flattened:"true" required:"true"`

	// One or more headers in the response that you want customers to be able to
	// access from their applications (for example, from a JavaScript XMLHttpRequest
	// object).
	ExposeHeaders []string `locationName:"ExposeHeader" type:"list" flattened:"true"`

	// The time in seconds that your browser is to cache the preflight response
	// for the specified resource.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CORSRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CORSRule"}

	if s.AllowedMethods == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowedMethods"))
	}

	if s.AllowedOrigins == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowedOrigins"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CORSRule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AllowedHeaders) > 0 {
		v := s.AllowedHeaders

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedHeader", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if len(s.AllowedMethods) > 0 {
		v := s.AllowedMethods

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedMethod", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if len(s.AllowedOrigins) > 0 {
		v := s.AllowedOrigins

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedOrigin", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if len(s.ExposeHeaders) > 0 {
		v := s.ExposeHeaders

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "ExposeHeader", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.MaxAgeSeconds != nil {
		v := *s.MaxAgeSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxAgeSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes how a CSV-formatted input object is formatted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CSVInput
type CSVInput struct {
	_ struct{} `type:"structure"`

	// Specifies that CSV field values may contain quoted record delimiters and
	// such records should be allowed. Default value is FALSE. Setting this value
	// to TRUE may lower performance.
	AllowQuotedRecordDelimiter *bool `type:"boolean"`

	// The single character used to indicate a row should be ignored when present
	// at the start of a row.
	Comments *string `type:"string"`

	// The value used to separate individual fields in a record.
	FieldDelimiter *string `type:"string"`

	// Describes the first line of input. Valid values: None, Ignore, Use.
	FileHeaderInfo FileHeaderInfo `type:"string" enum:"true"`

	// Value used for escaping where the field delimiter is part of the value.
	QuoteCharacter *string `type:"string"`

	// The single character used for escaping the quote character inside an already
	// escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// The value used to separate individual records.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CSVInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowQuotedRecordDelimiter != nil {
		v := *s.AllowQuotedRecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AllowQuotedRecordDelimiter", protocol.BoolValue(v), metadata)
	}
	if s.Comments != nil {
		v := *s.Comments

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comments", protocol.StringValue(v), metadata)
	}
	if s.FieldDelimiter != nil {
		v := *s.FieldDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldDelimiter", protocol.StringValue(v), metadata)
	}
	if len(s.FileHeaderInfo) > 0 {
		v := s.FileHeaderInfo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileHeaderInfo", v, metadata)
	}
	if s.QuoteCharacter != nil {
		v := *s.QuoteCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteCharacter", protocol.StringValue(v), metadata)
	}
	if s.QuoteEscapeCharacter != nil {
		v := *s.QuoteEscapeCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteEscapeCharacter", protocol.StringValue(v), metadata)
	}
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes how CSV-formatted results are formatted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CSVOutput
type CSVOutput struct {
	_ struct{} `type:"structure"`

	// The value used to separate individual fields in a record.
	FieldDelimiter *string `type:"string"`

	// The value used for escaping where the field delimiter is part of the value.
	QuoteCharacter *string `type:"string"`

	// Th single character used for escaping the quote character inside an already
	// escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// Indicates whether or not all output fields should be quoted.
	QuoteFields QuoteFields `type:"string" enum:"true"`

	// The value used to separate individual records.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CSVOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FieldDelimiter != nil {
		v := *s.FieldDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldDelimiter", protocol.StringValue(v), metadata)
	}
	if s.QuoteCharacter != nil {
		v := *s.QuoteCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteCharacter", protocol.StringValue(v), metadata)
	}
	if s.QuoteEscapeCharacter != nil {
		v := *s.QuoteEscapeCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteEscapeCharacter", protocol.StringValue(v), metadata)
	}
	if len(s.QuoteFields) > 0 {
		v := s.QuoteFields

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteFields", v, metadata)
	}
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CloudFunctionConfiguration
type CloudFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	CloudFunction *string `type:"string"`

	// The bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	InvocationRole *string `type:"string"`
}

// String returns the string representation
func (s CloudFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudFunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudFunction != nil {
		v := *s.CloudFunction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudFunction", protocol.StringValue(v), metadata)
	}
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.InvocationRole != nil {
		v := *s.InvocationRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvocationRole", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CommonPrefix
type CommonPrefix struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s CommonPrefix) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CommonPrefix) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompletedMultipartUpload
type CompletedMultipartUpload struct {
	_ struct{} `type:"structure"`

	Parts []CompletedPart `locationName:"Part" type:"list" flattened:"true"`
}

// String returns the string representation
func (s CompletedMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompletedMultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Parts) > 0 {
		v := s.Parts

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Part", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompletedPart
type CompletedPart struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Part number that identifies the part. This is a positive integer between
	// 1 and 10,000.
	PartNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s CompletedPart) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompletedPart) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Condition
type Condition struct {
	_ struct{} `type:"structure"`

	// The HTTP error code when the redirect is applied. In the event of an error,
	// if the error code equals this value, then the specified redirect is applied.
	// Required when parent element Condition is specified and sibling KeyPrefixEquals
	// is not specified. If both are specified, then both must be true for the redirect
	// to be applied.
	HttpErrorCodeReturnedEquals *string `type:"string"`

	// The object key name prefix when the redirect is applied. For example, to
	// redirect requests for ExamplePage.html, the key prefix will be ExamplePage.html.
	// To redirect request for all pages with the prefix docs/, the key prefix will
	// be /docs, which identifies all objects in the docs/ folder. Required when
	// the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals
	// is not specified. If both conditions are specified, both must be true for
	// the redirect to be applied.
	KeyPrefixEquals *string `type:"string"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Condition) MarshalFields(e protocol.FieldEncoder) error {
	if s.HttpErrorCodeReturnedEquals != nil {
		v := *s.HttpErrorCodeReturnedEquals

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpErrorCodeReturnedEquals", protocol.StringValue(v), metadata)
	}
	if s.KeyPrefixEquals != nil {
		v := *s.KeyPrefixEquals

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyPrefixEquals", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectResult
type CopyObjectResult struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyObjectResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyObjectResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyPartResult
type CopyPartResult struct {
	_ struct{} `type:"structure"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// Date and time at which the object was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyPartResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyPartResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketConfiguration
type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the region where the bucket will be created. If you don't specify
	// a region, the bucket is created in US East (N. Virginia) Region (us-east-1).
	LocationConstraint BucketLocationConstraint `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateBucketConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LocationConstraint) > 0 {
		v := s.LocationConstraint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocationConstraint", v, metadata)
	}
	return nil
}

// The container element for specifying the default Object Lock retention settings
// for new objects placed in the specified bucket.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DefaultRetention
type DefaultRetention struct {
	_ struct{} `type:"structure"`

	// The number of days that you want to specify for the default retention period.
	Days *int64 `type:"integer"`

	// The default Object Lock retention mode you want to apply to new objects placed
	// in the specified bucket.
	Mode ObjectLockRetentionMode `type:"string" enum:"true"`

	// The number of years that you want to specify for the default retention period.
	Years *int64 `type:"integer"`
}

// String returns the string representation
func (s DefaultRetention) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultRetention) MarshalFields(e protocol.FieldEncoder) error {
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", v, metadata)
	}
	if s.Years != nil {
		v := *s.Years

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Years", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Delete
type Delete struct {
	_ struct{} `type:"structure"`

	// Objects is a required field
	Objects []ObjectIdentifier `locationName:"Object" type:"list" flattened:"true" required:"true"`

	// Element to enable quiet mode for the request. When you add this element,
	// you must set its value to true.
	Quiet *bool `type:"boolean"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Delete"}

	if s.Objects == nil {
		invalidParams.Add(aws.NewErrParamRequired("Objects"))
	}
	if s.Objects != nil {
		for i, v := range s.Objects {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objects", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Delete) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Objects) > 0 {
		v := s.Objects

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Object", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quiet != nil {
		v := *s.Quiet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quiet", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteMarkerEntry
type DeleteMarkerEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeleteMarkerEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMarkerEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsLatest != nil {
		v := *s.IsLatest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsLatest", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies whether Amazon S3 should replicate delete makers.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteMarkerReplication
type DeleteMarkerReplication struct {
	_ struct{} `type:"structure"`

	// The status of the delete marker replication.
	//
	// In the current implementation, Amazon S3 doesn't replicate the delete markers.
	// The status must be Disabled.
	Status DeleteMarkerReplicationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteMarkerReplication) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMarkerReplication) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletedObject
type DeletedObject struct {
	_ struct{} `type:"structure"`

	DeleteMarker *bool `type:"boolean"`

	DeleteMarkerVersionId *string `type:"string"`

	Key *string `min:"1" type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeletedObject) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletedObject) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteMarker != nil {
		v := *s.DeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteMarker", protocol.BoolValue(v), metadata)
	}
	if s.DeleteMarkerVersionId != nil {
		v := *s.DeleteMarkerVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteMarkerVersionId", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// A container for information about the replication destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Destination
type Destination struct {
	_ struct{} `type:"structure"`

	// A container for information about access control for replicas.
	//
	// Use this element only in a cross-account scenario where source and destination
	// bucket owners are not the same to change replica ownership to the AWS account
	// that owns the destination bucket. If you don't add this element to the replication
	// configuration, the replicas are owned by same AWS account that owns the source
	// object.
	AccessControlTranslation *AccessControlTranslation `type:"structure"`

	// The account ID of the destination bucket. Currently, Amazon S3 verifies this
	// value only if Access Control Translation is enabled.
	//
	// In a cross-account scenario, if you change replica ownership to the AWS account
	// that owns the destination bucket by adding the AccessControlTranslation element,
	// this is the account ID of the owner of the destination bucket.
	Account *string `type:"string"`

	// The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to
	// store replicas of the object identified by the rule.
	//
	// If there are multiple rules in your replication configuration, all rules
	// must specify the same bucket as the destination. A replication configuration
	// can replicate objects to only one destination bucket.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// A container that provides information about encryption. If SourceSelectionCriteria
	// is specified, you must specify this element.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The class of storage used to store the object. By default Amazon S3 uses
	// storage class of the source object when creating a replica.
	StorageClass StorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Destination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlTranslation != nil {
		if err := s.AccessControlTranslation.Validate(); err != nil {
			invalidParams.AddNested("AccessControlTranslation", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *Destination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlTranslation != nil {
		v := s.AccessControlTranslation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AccessControlTranslation", v, metadata)
	}
	if s.Account != nil {
		v := *s.Account

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Account", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.EncryptionConfiguration != nil {
		v := s.EncryptionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EncryptionConfiguration", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Describes the server-side encryption that will be applied to the restore
// results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Encryption
type Encryption struct {
	_ struct{} `type:"structure"`

	// The server-side encryption algorithm used when storing job results in Amazon
	// S3 (e.g., AES256, aws:kms).
	//
	// EncryptionType is a required field
	EncryptionType ServerSideEncryption `type:"string" required:"true" enum:"true"`

	// If the encryption type is aws:kms, this optional value can be used to specify
	// the encryption context for the restore results.
	KMSContext *string `type:"string"`

	// If the encryption type is aws:kms, this optional value specifies the AWS
	// KMS key ID to use for encryption of job results.
	KMSKeyId *string `type:"string"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Encryption"}
	if len(s.EncryptionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EncryptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Encryption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EncryptionType) > 0 {
		v := s.EncryptionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionType", v, metadata)
	}
	if s.KMSContext != nil {
		v := *s.KMSContext

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSContext", protocol.StringValue(v), metadata)
	}
	if s.KMSKeyId != nil {
		v := *s.KMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSKeyId", protocol.StringValue(v), metadata)
	}
	return nil
}

// A container for information about the encryption-based configuration for
// replicas.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/EncryptionConfiguration
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS KMS key for the AWS Region where the destination bucket
	// resides. Amazon S3 uses this key to encrypt the replica object.
	ReplicaKmsKeyID *string `type:"string"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ReplicaKmsKeyID != nil {
		v := *s.ReplicaKmsKeyID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplicaKmsKeyID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Error
type Error struct {
	_ struct{} `type:"structure"`

	Code *string `type:"string"`

	Key *string `min:"1" type:"string"`

	Message *string `type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Error) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Code", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ErrorDocument
type ErrorDocument struct {
	_ struct{} `type:"structure"`

	// The object key name to use when a 4XX class error occurs.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDocument) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorDocument) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ErrorDocument"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorDocument) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	return nil
}

// A container for a key value pair that defines the criteria for the filter
// rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/FilterRule
type FilterRule struct {
	_ struct{} `type:"structure"`

	// The object key name prefix or suffix identifying one or more objects to which
	// the filtering rule applies. The maximum prefix length is 1,024 characters.
	// Overlapping prefixes and suffixes are not supported. For more information,
	// see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Name FilterRuleName `type:"string" enum:"true"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FilterRule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GlacierJobParameters
type GlacierJobParameters struct {
	_ struct{} `type:"structure"`

	// Glacier retrieval tier at which the restore will be processed.
	//
	// Tier is a required field
	Tier Tier `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GlacierJobParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlacierJobParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlacierJobParameters"}
	if len(s.Tier) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GlacierJobParameters) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Tier) > 0 {
		v := s.Tier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Tier", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Grant
type Grant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Specifies the permission given to the grantee.
	Permission Permission `type:"string" enum:"true"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Grant) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grantee != nil {
		v := s.Grantee
		attrs := make([]protocol.Attribute, 0, 1)

		if len(s.Grantee.Type) > 0 {

			v := s.Grantee.Type
			attrs = append(attrs, protocol.Attribute{Name: "xsi:type", Value: v, Meta: protocol.Metadata{}})
		}
		metadata := protocol.Metadata{Attributes: attrs, XMLNamespacePrefix: "xsi", XMLNamespaceURI: "http://www.w3.org/2001/XMLSchema-instance"}
		e.SetFields(protocol.BodyTarget, "Grantee", v, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Grantee
type Grantee struct {
	_ struct{} `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type Type `locationName:"xsi:type" type:"string" xmlAttribute:"true" required:"true" enum:"true"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Grantee"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Grantee) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.EmailAddress != nil {
		v := *s.EmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailAddress", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	// Skipping Type XML Attribute.
	if s.URI != nil {
		v := *s.URI

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "URI", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/IndexDocument
type IndexDocument struct {
	_ struct{} `type:"structure"`

	// A suffix that is appended to a request that is for a directory on the website
	// endpoint (e.g. if the suffix is index.html and you make a request to samplebucket/images/
	// the data that is returned will be for the object with the key name images/index.html)
	// The suffix must not be empty and must not include a slash character.
	//
	// Suffix is a required field
	Suffix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocument) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexDocument) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IndexDocument"}

	if s.Suffix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Suffix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IndexDocument) MarshalFields(e protocol.FieldEncoder) error {
	if s.Suffix != nil {
		v := *s.Suffix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Suffix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Initiator
type Initiator struct {
	_ struct{} `type:"structure"`

	// Name of the Principal.
	DisplayName *string `type:"string"`

	// If the principal is an AWS account, it provides the Canonical User ID. If
	// the principal is an IAM User, it provides a user ARN value.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Initiator) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Initiator) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes the serialization format of the object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InputSerialization
type InputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of a CSV-encoded object.
	CSV *CSVInput `type:"structure"`

	// Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default
	// Value: NONE.
	CompressionType CompressionType `type:"string" enum:"true"`

	// Specifies JSON as object's input serialization format.
	JSON *JSONInput `type:"structure"`

	// Specifies Parquet as object's input serialization format.
	Parquet *ParquetInput `type:"structure"`
}

// String returns the string representation
func (s InputSerialization) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSerialization) MarshalFields(e protocol.FieldEncoder) error {
	if s.CSV != nil {
		v := s.CSV

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CSV", v, metadata)
	}
	if len(s.CompressionType) > 0 {
		v := s.CompressionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompressionType", v, metadata)
	}
	if s.JSON != nil {
		v := s.JSON

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "JSON", v, metadata)
	}
	if s.Parquet != nil {
		v := s.Parquet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Parquet", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryConfiguration
type InventoryConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about where to publish the inventory results.
	//
	// Destination is a required field
	Destination *InventoryDestination `type:"structure" required:"true"`

	// Specifies an inventory filter. The inventory only includes objects that meet
	// the filter's criteria.
	Filter *InventoryFilter `type:"structure"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies which object version(s) to included in the inventory results.
	//
	// IncludedObjectVersions is a required field
	IncludedObjectVersions InventoryIncludedObjectVersions `type:"string" required:"true" enum:"true"`

	// Specifies whether the inventory is enabled or disabled.
	//
	// IsEnabled is a required field
	IsEnabled *bool `type:"boolean" required:"true"`

	// Contains the optional fields that are included in the inventory results.
	OptionalFields []InventoryOptionalField `locationNameList:"Field" type:"list"`

	// Specifies the schedule for generating inventory results.
	//
	// Schedule is a required field
	Schedule *InventorySchedule `type:"structure" required:"true"`
}

// String returns the string representation
func (s InventoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryConfiguration"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if len(s.IncludedObjectVersions) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("IncludedObjectVersions"))
	}

	if s.IsEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("IsEnabled"))
	}

	if s.Schedule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Schedule"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if len(s.IncludedObjectVersions) > 0 {
		v := s.IncludedObjectVersions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IncludedObjectVersions", v, metadata)
	}
	if s.IsEnabled != nil {
		v := *s.IsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.OptionalFields) > 0 {
		v := s.OptionalFields

		metadata := protocol.Metadata{ListLocationName: "Field"}
		ls0 := e.List(protocol.BodyTarget, "OptionalFields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryDestination
type InventoryDestination struct {
	_ struct{} `type:"structure"`

	// Contains the bucket name, file format, bucket owner (optional), and prefix
	// (optional) where inventory results are published.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *InventoryS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s InventoryDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryDestination"}

	if s.S3BucketDestination == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3BucketDestination != nil {
		v := s.S3BucketDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3BucketDestination", v, metadata)
	}
	return nil
}

// Contains the type of server-side encryption used to encrypt the inventory
// results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryEncryption
type InventoryEncryption struct {
	_ struct{} `type:"structure"`

	// Specifies the use of SSE-KMS to encrypt delivered Inventory reports.
	SSEKMS *SSEKMS `locationName:"SSE-KMS" type:"structure"`

	// Specifies the use of SSE-S3 to encrypt delivered Inventory reports.
	SSES3 *SSES3 `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s InventoryEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryEncryption"}
	if s.SSEKMS != nil {
		if err := s.SSEKMS.Validate(); err != nil {
			invalidParams.AddNested("SSEKMS", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.SSEKMS != nil {
		v := s.SSEKMS

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SSE-KMS", v, metadata)
	}
	if s.SSES3 != nil {
		v := s.SSES3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SSE-S3", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryFilter
type InventoryFilter struct {
	_ struct{} `type:"structure"`

	// The prefix that an object must have to be included in the inventory results.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryFilter"}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryS3BucketDestination
type InventoryS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The ID of the account that owns the destination bucket.
	AccountId *string `type:"string"`

	// The Amazon resource name (ARN) of the bucket where inventory results will
	// be published.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Contains the type of server-side encryption used to encrypt the inventory
	// results.
	Encryption *InventoryEncryption `type:"structure"`

	// Specifies the output format of the inventory results.
	//
	// Format is a required field
	Format InventoryFormat `type:"string" required:"true" enum:"true"`

	// The prefix that is prepended to all inventory results.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s InventoryS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryS3BucketDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryS3BucketDestination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *InventoryS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryS3BucketDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventorySchedule
type InventorySchedule struct {
	_ struct{} `type:"structure"`

	// Specifies how frequently inventory results are produced.
	//
	// Frequency is a required field
	Frequency InventoryFrequency `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s InventorySchedule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventorySchedule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventorySchedule"}
	if len(s.Frequency) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Frequency"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventorySchedule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Frequency) > 0 {
		v := s.Frequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Frequency", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/JSONInput
type JSONInput struct {
	_ struct{} `type:"structure"`

	// The type of JSON. Valid values: Document, Lines.
	Type JSONType `type:"string" enum:"true"`
}

// String returns the string representation
func (s JSONInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JSONInput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/JSONOutput
type JSONOutput struct {
	_ struct{} `type:"structure"`

	// The value used to separate individual records in the output.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s JSONOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JSONOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// A container for specifying the configuration for AWS Lambda notifications.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LambdaFunctionConfiguration
type LambdaFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// A container for object key name filtering rules. For information about key
	// name filtering, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Lambda cloud function that Amazon S3
	// can invoke when it detects events of the specified type.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `locationName:"CloudFunction" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaFunctionConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.LambdaFunctionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LambdaFunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaFunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LambdaFunctionArn != nil {
		v := *s.LambdaFunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudFunction", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleConfiguration
type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []Rule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleExpiration
type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired; if set to false
	// the policy takes no action. This cannot be specified with Days or Date in
	// a Lifecycle Expiration Policy.
	ExpiredObjectDeleteMarker *bool `type:"boolean"`
}

// String returns the string representation
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleExpiration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Date != nil {
		v := *s.Date

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Date", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if s.ExpiredObjectDeleteMarker != nil {
		v := *s.ExpiredObjectDeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpiredObjectDeleteMarker", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRule
type LifecycleRule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an Incomplete Multipart Upload
	// that Lifecycle will wait before permanently removing all parts of the upload.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// The Filter is used to identify objects that a Lifecycle Rule applies to.
	// A Filter must have exactly one of Prefix, Tag, or And specified.
	Filter *LifecycleRuleFilter `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	NoncurrentVersionTransitions []NoncurrentVersionTransition `locationName:"NoncurrentVersionTransition" type:"list" flattened:"true"`

	// Prefix identifying one or more objects to which the rule applies. This is
	// No longer used; use Filter instead.
	Prefix *string `deprecated:"true" type:"string"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status ExpirationStatus `type:"string" required:"true" enum:"true"`

	Transitions []Transition `locationName:"Transition" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRule"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbortIncompleteMultipartUpload != nil {
		v := s.AbortIncompleteMultipartUpload

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AbortIncompleteMultipartUpload", v, metadata)
	}
	if s.Expiration != nil {
		v := s.Expiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Expiration", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.NoncurrentVersionExpiration != nil {
		v := s.NoncurrentVersionExpiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionExpiration", v, metadata)
	}
	if len(s.NoncurrentVersionTransitions) > 0 {
		v := s.NoncurrentVersionTransitions

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "NoncurrentVersionTransition", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if len(s.Transitions) > 0 {
		v := s.Transitions

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Transition", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// This is used in a Lifecycle Rule Filter to apply a logical AND to two or
// more predicates. The Lifecycle Rule will apply to any object matching all
// of the predicates configured inside the And operator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRuleAndOperator
type LifecycleRuleAndOperator struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`

	// All of these tags must exist in the object's tag set in order for the rule
	// to apply.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRuleAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The Filter is used to identify objects that a Lifecycle Rule applies to.
// A Filter must have exactly one of Prefix, Tag, or And specified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRuleFilter
type LifecycleRuleFilter struct {
	_ struct{} `type:"structure"`

	// This is used in a Lifecycle Rule Filter to apply a logical AND to two or
	// more predicates. The Lifecycle Rule will apply to any object matching all
	// of the predicates configured inside the And operator.
	And *LifecycleRuleAndOperator `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string"`

	// This tag must exist in the object's tag set in order for the rule to apply.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s LifecycleRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRuleFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Container for logging information. Presence of this element indicates that
// logging is enabled. Parameters TargetBucket and TargetPrefix are required
// in this case.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LoggingEnabled
type LoggingEnabled struct {
	_ struct{} `type:"structure"`

	// Specifies the bucket where you want Amazon S3 to store server access logs.
	// You can have your logs delivered to any bucket that you own, including the
	// same bucket that is being logged. You can also configure multiple buckets
	// to deliver their logs to the same target bucket. In this case you should
	// choose a different TargetPrefix for each source bucket so that the delivered
	// log files can be distinguished by key.
	//
	// TargetBucket is a required field
	TargetBucket *string `type:"string" required:"true"`

	TargetGrants []TargetGrant `locationNameList:"Grant" type:"list"`

	// This element lets you specify a prefix for the keys that the log files will
	// be stored under.
	//
	// TargetPrefix is a required field
	TargetPrefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingEnabled) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingEnabled) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingEnabled"}

	if s.TargetBucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetBucket"))
	}

	if s.TargetPrefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetPrefix"))
	}
	if s.TargetGrants != nil {
		for i, v := range s.TargetGrants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetGrants", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingEnabled) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetBucket != nil {
		v := *s.TargetBucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetBucket", protocol.StringValue(v), metadata)
	}
	if len(s.TargetGrants) > 0 {
		v := s.TargetGrants

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "TargetGrants", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TargetPrefix != nil {
		v := *s.TargetPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetPrefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// A metadata key-value pair to store with an object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetadataEntry
type MetadataEntry struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s MetadataEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetadataEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsAndOperator
type MetricsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix used when evaluating an AND predicate.
	Prefix *string `type:"string"`

	// The list of tags used when evaluating an AND predicate.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s MetricsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsConfiguration
type MetricsConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies a metrics configuration filter. The metrics configuration will
	// only include objects that meet the filter's criteria. A filter must be a
	// prefix, a tag, or a conjunction (MetricsAndOperator).
	Filter *MetricsFilter `type:"structure"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsConfiguration"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsFilter
type MetricsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating a
	// metrics filter. The operator must have at least two predicates, and an object
	// must match all of the predicates in order for the filter to apply.
	And *MetricsAndOperator `type:"structure"`

	// The prefix used when evaluating a metrics filter.
	Prefix *string `type:"string"`

	// The tag used when evaluating a metrics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s MetricsFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MultipartUpload
type MultipartUpload struct {
	_ struct{} `type:"structure"`

	// Date and time at which the multipart upload was initiated.
	Initiated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Key of the object for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	Owner *Owner `type:"structure"`

	// The class of storage used to store the object.
	StorageClass StorageClass `type:"string" enum:"true"`

	// Upload ID that identifies the multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s MultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if s.Initiated != nil {
		v := *s.Initiated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Initiated", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Initiator != nil {
		v := s.Initiator

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Initiator", v, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies when noncurrent object versions expire. Upon expiration, Amazon
// S3 permanently deletes the noncurrent object versions. You set this lifecycle
// configuration action on a bucket that has versioning enabled (or suspended)
// to request that Amazon S3 delete noncurrent object versions at a specific
// period in the object's lifetime.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoncurrentVersionExpiration
type NoncurrentVersionExpiration struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon Simple Storage Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`
}

// String returns the string representation
func (s NoncurrentVersionExpiration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NoncurrentVersionExpiration) MarshalFields(e protocol.FieldEncoder) error {
	if s.NoncurrentDays != nil {
		v := *s.NoncurrentDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NoncurrentDays", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Container for the transition rule that describes when noncurrent objects
// transition to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER or
// DEEP_ARCHIVE storage class. If your bucket is versioning-enabled (or versioning
// is suspended), you can set this action to request that Amazon S3 transition
// noncurrent object versions to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING,
// GLACIER or DEEP_ARCHIVE storage class at a specific period in the object's
// lifetime.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoncurrentVersionTransition
type NoncurrentVersionTransition struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
	// in the Amazon Simple Storage Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass TransitionStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s NoncurrentVersionTransition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NoncurrentVersionTransition) MarshalFields(e protocol.FieldEncoder) error {
	if s.NoncurrentDays != nil {
		v := *s.NoncurrentDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NoncurrentDays", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// A container for specifying the notification configuration of the bucket.
// If this element is empty, notifications are turned off for the bucket.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfiguration
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	LambdaFunctionConfigurations []LambdaFunctionConfiguration `locationName:"CloudFunctionConfiguration" type:"list" flattened:"true"`

	QueueConfigurations []QueueConfiguration `locationName:"QueueConfiguration" type:"list" flattened:"true"`

	TopicConfigurations []TopicConfiguration `locationName:"TopicConfiguration" type:"list" flattened:"true"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotificationConfiguration"}
	if s.LambdaFunctionConfigurations != nil {
		for i, v := range s.LambdaFunctionConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.QueueConfigurations != nil {
		for i, v := range s.QueueConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueueConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TopicConfigurations != nil {
		for i, v := range s.TopicConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TopicConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LambdaFunctionConfigurations) > 0 {
		v := s.LambdaFunctionConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CloudFunctionConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.QueueConfigurations) > 0 {
		v := s.QueueConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "QueueConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.TopicConfigurations) > 0 {
		v := s.TopicConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "TopicConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfigurationDeprecated
type NotificationConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	CloudFunctionConfiguration *CloudFunctionConfiguration `type:"structure"`

	QueueConfiguration *QueueConfigurationDeprecated `type:"structure"`

	TopicConfiguration *TopicConfigurationDeprecated `type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationConfigurationDeprecated) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudFunctionConfiguration != nil {
		v := s.CloudFunctionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CloudFunctionConfiguration", v, metadata)
	}
	if s.QueueConfiguration != nil {
		v := s.QueueConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QueueConfiguration", v, metadata)
	}
	if s.TopicConfiguration != nil {
		v := s.TopicConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TopicConfiguration", v, metadata)
	}
	return nil
}

// A container for object key name filtering rules. For information about key
// name filtering, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
// in the Amazon Simple Storage Service Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfigurationFilter
type NotificationConfigurationFilter struct {
	_ struct{} `type:"structure"`

	// A container for object key name prefix and suffix filtering rules.
	Key *S3KeyFilter `locationName:"S3Key" type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationConfigurationFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := s.Key

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3Key", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Object
type Object struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	Key *string `min:"1" type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass ObjectStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Object) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Object) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectIdentifier
type ObjectIdentifier struct {
	_ struct{} `type:"structure"`

	// Key name of the object to delete.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// VersionId for the specific version of the object to delete.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ObjectIdentifier"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// The container element for Object Lock configuration parameters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectLockConfiguration
type ObjectLockConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether this bucket has an Object Lock configuration enabled.
	ObjectLockEnabled ObjectLockEnabled `type:"string" enum:"true"`

	// The Object Lock rule in place for the specified object.
	Rule *ObjectLockRule `type:"structure"`
}

// String returns the string representation
func (s ObjectLockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectLockConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ObjectLockEnabled) > 0 {
		v := s.ObjectLockEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectLockEnabled", v, metadata)
	}
	if s.Rule != nil {
		v := s.Rule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Rule", v, metadata)
	}
	return nil
}

// A Legal Hold configuration for an object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectLockLegalHold
type ObjectLockLegalHold struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified object has a Legal Hold in place.
	Status ObjectLockLegalHoldStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ObjectLockLegalHold) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectLockLegalHold) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// A Retention configuration for an object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectLockRetention
type ObjectLockRetention struct {
	_ struct{} `type:"structure"`

	// Indicates the Retention mode for the specified object.
	Mode ObjectLockRetentionMode `type:"string" enum:"true"`

	// The date on which this Object Lock Retention will expire.
	RetainUntilDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ObjectLockRetention) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectLockRetention) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", v, metadata)
	}
	if s.RetainUntilDate != nil {
		v := *s.RetainUntilDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RetainUntilDate", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	return nil
}

// The container element for an Object Lock rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectLockRule
type ObjectLockRule struct {
	_ struct{} `type:"structure"`

	// The default retention period that you want to apply to new objects placed
	// in the specified bucket.
	DefaultRetention *DefaultRetention `type:"structure"`
}

// String returns the string representation
func (s ObjectLockRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectLockRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultRetention != nil {
		v := s.DefaultRetention

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultRetention", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectVersion
type ObjectVersion struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Size in bytes of the object.
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass ObjectVersionStorageClass `type:"string" enum:"true"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.IsLatest != nil {
		v := *s.IsLatest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsLatest", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes the location where the restore job's output is stored.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/OutputLocation
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// Describes an S3 location that will receive the results of the restore request.
	S3 *S3Location `type:"structure"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3 != nil {
		v := s.S3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3", v, metadata)
	}
	return nil
}

// Describes how results of the Select job are serialized.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/OutputSerialization
type OutputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of CSV-encoded Select results.
	CSV *CSVOutput `type:"structure"`

	// Specifies JSON as request's output serialization format.
	JSON *JSONOutput `type:"structure"`
}

// String returns the string representation
func (s OutputSerialization) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputSerialization) MarshalFields(e protocol.FieldEncoder) error {
	if s.CSV != nil {
		v := s.CSV

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CSV", v, metadata)
	}
	if s.JSON != nil {
		v := s.JSON

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "JSON", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Owner
type Owner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `type:"string"`

	ID *string `type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Owner) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ParquetInput
type ParquetInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ParquetInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParquetInput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Part
type Part struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Date and time at which the part was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Part number identifying the part. This is a positive integer between 1 and
	// 10,000.
	PartNumber *int64 `type:"integer"`

	// Size in bytes of the uploaded part data.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s Part) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Part) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumber", protocol.Int64Value(v), metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The container element for a bucket's policy status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PolicyStatus
type PolicyStatus struct {
	_ struct{} `type:"structure"`

	// The policy status for this bucket. TRUE indicates that this bucket is public.
	// FALSE indicates that the bucket is not public.
	IsPublic *bool `locationName:"IsPublic" type:"boolean"`
}

// String returns the string representation
func (s PolicyStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsPublic != nil {
		v := *s.IsPublic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsPublic", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PublicAccessBlockConfiguration
type PublicAccessBlockConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should block public access control lists (ACLs)
	// for this bucket and objects in this bucket. Setting this element to TRUE
	// causes the following behavior:
	//
	//    * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is
	//    public.
	//
	//    * PUT Object calls fail if the request includes a public ACL.
	//
	// Enabling this setting doesn't affect existing policies or ACLs.
	BlockPublicAcls *bool `locationName:"BlockPublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should block public bucket policies for this
	// bucket. Setting this element to TRUE causes Amazon S3 to reject calls to
	// PUT Bucket policy if the specified bucket policy allows public access.
	//
	// Enabling this setting doesn't affect existing bucket policies.
	BlockPublicPolicy *bool `locationName:"BlockPublicPolicy" type:"boolean"`

	// Specifies whether Amazon S3 should ignore public ACLs for this bucket and
	// objects in this bucket. Setting this element to TRUE causes Amazon S3 to
	// ignore all public ACLs on this bucket and objects in this bucket.
	//
	// Enabling this setting doesn't affect the persistence of any existing ACLs
	// and doesn't prevent new public ACLs from being set.
	IgnorePublicAcls *bool `locationName:"IgnorePublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should restrict public bucket policies for this
	// bucket. Setting this element to TRUE restricts access to this bucket to only
	// AWS services and authorized users within this account if the bucket has a
	// public policy.
	//
	// Enabling this setting doesn't affect previously stored bucket policies, except
	// that public and cross-account access within any public bucket policy, including
	// non-public delegation to specific accounts, is blocked.
	RestrictPublicBuckets *bool `locationName:"RestrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s PublicAccessBlockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicAccessBlockConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockPublicAcls != nil {
		v := *s.BlockPublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BlockPublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.BlockPublicPolicy != nil {
		v := *s.BlockPublicPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BlockPublicPolicy", protocol.BoolValue(v), metadata)
	}
	if s.IgnorePublicAcls != nil {
		v := *s.IgnorePublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IgnorePublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.RestrictPublicBuckets != nil {
		v := *s.RestrictPublicBuckets

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RestrictPublicBuckets", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A container for specifying the configuration for publication of messages
// to an Amazon Simple Queue Service (Amazon SQS) queue.when Amazon S3 detects
// specified events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/QueueConfiguration
type QueueConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// A container for object key name filtering rules. For information about key
	// name filtering, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3
	// will publish a message when it detects events of the specified type.
	//
	// QueueArn is a required field
	QueueArn *string `locationName:"Queue" type:"string" required:"true"`
}

// String returns the string representation
func (s QueueConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueueConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueueConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.QueueArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.QueueArn != nil {
		v := *s.QueueArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Queue", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/QueueConfigurationDeprecated
type QueueConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// The bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	Queue *string `type:"string"`
}

// String returns the string representation
func (s QueueConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueConfigurationDeprecated) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Queue != nil {
		v := *s.Queue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Queue", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Redirect
type Redirect struct {
	_ struct{} `type:"structure"`

	// The host name to use in the redirect request.
	HostName *string `type:"string"`

	// The HTTP redirect code to use on the response. Not required if one of the
	// siblings is present.
	HttpRedirectCode *string `type:"string"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol Protocol `type:"string" enum:"true"`

	// The object key prefix to use in the redirect request. For example, to redirect
	// requests for all pages with prefix docs/ (objects in the docs/ folder) to
	// documents/, you can set a condition block with KeyPrefixEquals set to docs/
	// and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required
	// if one of the siblings is present. Can be present only if ReplaceKeyWith
	// is not provided.
	ReplaceKeyPrefixWith *string `type:"string"`

	// The specific object key to use in the redirect request. For example, redirect
	// request to error.html. Not required if one of the sibling is present. Can
	// be present only if ReplaceKeyPrefixWith is not provided.
	ReplaceKeyWith *string `type:"string"`
}

// String returns the string representation
func (s Redirect) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Redirect) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostName != nil {
		v := *s.HostName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostName", protocol.StringValue(v), metadata)
	}
	if s.HttpRedirectCode != nil {
		v := *s.HttpRedirectCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpRedirectCode", protocol.StringValue(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", v, metadata)
	}
	if s.ReplaceKeyPrefixWith != nil {
		v := *s.ReplaceKeyPrefixWith

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplaceKeyPrefixWith", protocol.StringValue(v), metadata)
	}
	if s.ReplaceKeyWith != nil {
		v := *s.ReplaceKeyWith

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplaceKeyWith", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RedirectAllRequestsTo
type RedirectAllRequestsTo struct {
	_ struct{} `type:"structure"`

	// Name of the host where requests will be redirected.
	//
	// HostName is a required field
	HostName *string `type:"string" required:"true"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol Protocol `type:"string" enum:"true"`
}

// String returns the string representation
func (s RedirectAllRequestsTo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedirectAllRequestsTo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RedirectAllRequestsTo"}

	if s.HostName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RedirectAllRequestsTo) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostName != nil {
		v := *s.HostName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostName", protocol.StringValue(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", v, metadata)
	}
	return nil
}

// A container for replication rules. You can add up to 1,000 rules. The maximum
// size of a replication configuration is 2 MB.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationConfiguration
type ReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that Amazon S3 can assume when replicating the objects.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// A container for one or more replication rules. A replication configuration
	// must have at least one rule and can contain a maximum of 1,000 rules.
	//
	// Rules is a required field
	Rules []ReplicationRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationConfiguration"}

	if s.Role == nil {
		invalidParams.Add(aws.NewErrParamRequired("Role"))
	}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Role != nil {
		v := *s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.StringValue(v), metadata)
	}
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A container for information about a specific replication rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationRule
type ReplicationRule struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should replicate delete makers.
	DeleteMarkerReplication *DeleteMarkerReplication `type:"structure"`

	// A container for information about the replication destination.
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// A filter that identifies the subset of objects to which the replication rule
	// applies. A Filter must specify exactly one Prefix, Tag, or an And child element.
	Filter *ReplicationRuleFilter `type:"structure"`

	// A unique identifier for the rule. The maximum value is 255 characters.
	ID *string `type:"string"`

	// An object keyname prefix that identifies the object or objects to which the
	// rule applies. The maximum prefix length is 1,024 characters.
	Prefix *string `deprecated:"true" type:"string"`

	// The priority associated with the rule. If you specify multiple rules in a
	// replication configuration, Amazon S3 prioritizes the rules to prevent conflicts
	// when filtering. If two or more rules identify the same object based on a
	// specified filter, the rule with higher priority takes precedence. For example:
	//
	//    * Same object quality prefix based filter criteria If prefixes you specified
	//    in multiple rules overlap
	//
	//    * Same object qualify tag based filter criteria specified in multiple
	//    rules
	//
	// For more information, see Cross-Region Replication (CRR) (https://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html)
	// in the Amazon S3 Developer Guide.
	Priority *int64 `type:"integer"`

	// A container that describes additional filters for identifying the source
	// objects that you want to replicate. You can choose to enable or disable the
	// replication of these objects. Currently, Amazon S3 supports only the filter
	// that you can specify for objects created with server-side encryption using
	// an AWS KMS-Managed Key (SSE-KMS).
	//
	// If you want Amazon S3 to replicate objects created with server-side encryption
	// using AWS KMS-Managed Keys.
	SourceSelectionCriteria *SourceSelectionCriteria `type:"structure"`

	// If status isn't enabled, the rule is ignored.
	//
	// Status is a required field
	Status ReplicationRuleStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ReplicationRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRule"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.SourceSelectionCriteria != nil {
		if err := s.SourceSelectionCriteria.Validate(); err != nil {
			invalidParams.AddNested("SourceSelectionCriteria", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteMarkerReplication != nil {
		v := s.DeleteMarkerReplication

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeleteMarkerReplication", v, metadata)
	}
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.SourceSelectionCriteria != nil {
		v := s.SourceSelectionCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceSelectionCriteria", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationRuleAndOperator
type ReplicationRuleAndOperator struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`

	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ReplicationRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRuleAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRuleAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A filter that identifies the subset of objects to which the replication rule
// applies. A Filter must specify exactly one Prefix, Tag, or an And child element.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationRuleFilter
type ReplicationRuleFilter struct {
	_ struct{} `type:"structure"`

	// A container for specifying rule filters. The filters determine the subset
	// of objects to which the rule applies. This element is required only if you
	// specify more than one filter. For example:
	//
	//    * If you specify both a Prefix and a Tag filter, wrap these filters in
	//    an And tag.
	//
	//    * If you specify a filter based on multiple tags, wrap the Tag elements
	//    in an And tag.
	And *ReplicationRuleAndOperator `type:"structure"`

	// An object keyname prefix that identifies the subset of objects to which the
	// rule applies.
	Prefix *string `type:"string"`

	// A container for specifying a tag key and value.
	//
	// The rule applies only to objects that have the tag in their tag set.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s ReplicationRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRuleFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRuleFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RequestPaymentConfiguration
type RequestPaymentConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	//
	// Payer is a required field
	Payer Payer `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RequestPaymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestPaymentConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestPaymentConfiguration"}
	if len(s.Payer) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Payer"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RequestPaymentConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Payer) > 0 {
		v := s.Payer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Payer", v, metadata)
	}
	return nil
}

// Container for restore job parameters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreRequest
type RestoreRequest struct {
	_ struct{} `type:"structure"`

	// Lifetime of the active copy in days. Do not use with restores that specify
	// OutputLocation.
	Days *int64 `type:"integer"`

	// The optional description for the job.
	Description *string `type:"string"`

	// Glacier related parameters pertaining to this job. Do not use with restores
	// that specify OutputLocation.
	GlacierJobParameters *GlacierJobParameters `type:"structure"`

	// Describes the location where the restore job's output is stored.
	OutputLocation *OutputLocation `type:"structure"`

	// Describes the parameters for Select job types.
	SelectParameters *SelectParameters `type:"structure"`

	// Glacier retrieval tier at which the restore will be processed.
	Tier Tier `type:"string" enum:"true"`

	// Type of restore request.
	Type RestoreRequestType `type:"string" enum:"true"`
}

// String returns the string representation
func (s RestoreRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreRequest"}
	if s.GlacierJobParameters != nil {
		if err := s.GlacierJobParameters.Validate(); err != nil {
			invalidParams.AddNested("GlacierJobParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(aws.ErrInvalidParams))
		}
	}
	if s.SelectParameters != nil {
		if err := s.SelectParameters.Validate(); err != nil {
			invalidParams.AddNested("SelectParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.StringValue(v), metadata)
	}
	if s.GlacierJobParameters != nil {
		v := s.GlacierJobParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GlacierJobParameters", v, metadata)
	}
	if s.OutputLocation != nil {
		v := s.OutputLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputLocation", v, metadata)
	}
	if s.SelectParameters != nil {
		v := s.SelectParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SelectParameters", v, metadata)
	}
	if len(s.Tier) > 0 {
		v := s.Tier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Tier", v, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RoutingRule
type RoutingRule struct {
	_ struct{} `type:"structure"`

	// A container for describing a condition that must be met for the specified
	// redirect to apply. For example, 1. If request is for pages in the /docs folder,
	// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
	// redirect request to another host where you might process the error.
	Condition *Condition `type:"structure"`

	// Container for redirect information. You can redirect requests to another
	// host, to another page, or with another protocol. In the event of an error,
	// you can specify a different error code to return.
	//
	// Redirect is a required field
	Redirect *Redirect `type:"structure" required:"true"`
}

// String returns the string representation
func (s RoutingRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoutingRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RoutingRule"}

	if s.Redirect == nil {
		invalidParams.Add(aws.NewErrParamRequired("Redirect"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RoutingRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Condition != nil {
		v := s.Condition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Condition", v, metadata)
	}
	if s.Redirect != nil {
		v := s.Redirect

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Redirect", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Rule
type Rule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an Incomplete Multipart Upload
	// that Lifecycle will wait before permanently removing all parts of the upload.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Container for the transition rule that describes when noncurrent objects
	// transition to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER or
	// DEEP_ARCHIVE storage class. If your bucket is versioning-enabled (or versioning
	// is suspended), you can set this action to request that Amazon S3 transition
	// noncurrent object versions to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING,
	// GLACIER or DEEP_ARCHIVE storage class at a specific period in the object's
	// lifetime.
	NoncurrentVersionTransition *NoncurrentVersionTransition `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status ExpirationStatus `type:"string" required:"true" enum:"true"`

	Transition *Transition `type:"structure"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Rule"}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Rule) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbortIncompleteMultipartUpload != nil {
		v := s.AbortIncompleteMultipartUpload

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AbortIncompleteMultipartUpload", v, metadata)
	}
	if s.Expiration != nil {
		v := s.Expiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Expiration", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.NoncurrentVersionExpiration != nil {
		v := s.NoncurrentVersionExpiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionExpiration", v, metadata)
	}
	if s.NoncurrentVersionTransition != nil {
		v := s.NoncurrentVersionTransition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionTransition", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.Transition != nil {
		v := s.Transition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Transition", v, metadata)
	}
	return nil
}

// A container for object key name prefix and suffix filtering rules.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/S3KeyFilter
type S3KeyFilter struct {
	_ struct{} `type:"structure"`

	// A list of containers for the key value pair that defines the criteria for
	// the filter rule.
	FilterRules []FilterRule `locationName:"FilterRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s S3KeyFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3KeyFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FilterRules) > 0 {
		v := s.FilterRules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "FilterRule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Describes an S3 location that will receive the results of the restore request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/S3Location
type S3Location struct {
	_ struct{} `type:"structure"`

	// A list of grants that control access to the staged results.
	AccessControlList []Grant `locationNameList:"Grant" type:"list"`

	// The name of the bucket where the restore results will be placed.
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The canned ACL to apply to the restore results.
	CannedACL ObjectCannedACL `type:"string" enum:"true"`

	// Describes the server-side encryption that will be applied to the restore
	// results.
	Encryption *Encryption `type:"structure"`

	// The prefix that is prepended to the restore results for this request.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// The class of storage used to store the restore results.
	StorageClass StorageClass `type:"string" enum:"true"`

	// The tag-set that is applied to the restore results.
	Tagging *Tagging `type:"structure"`

	// A list of metadata to store with the restore results in S3.
	UserMetadata []MetadataEntry `locationNameList:"MetadataEntry" type:"list"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Location"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Location) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AccessControlList) > 0 {
		v := s.AccessControlList

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.BucketName != nil {
		v := *s.BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BucketName", protocol.StringValue(v), metadata)
	}
	if len(s.CannedACL) > 0 {
		v := s.CannedACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CannedACL", v, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.Tagging != nil {
		v := s.Tagging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tagging", v, metadata)
	}
	if len(s.UserMetadata) > 0 {
		v := s.UserMetadata

		metadata := protocol.Metadata{ListLocationName: "MetadataEntry"}
		ls0 := e.List(protocol.BodyTarget, "UserMetadata", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies the use of SSE-KMS to encrypt delivered Inventory reports.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SSEKMS
type SSEKMS struct {
	_ struct{} `locationName:"SSE-KMS" type:"structure"`

	// Specifies the ID of the AWS Key Management Service (KMS) master encryption
	// key to use for encrypting Inventory reports.
	//
	// KeyId is a required field
	KeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SSEKMS) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SSEKMS) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SSEKMS"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SSEKMS) MarshalFields(e protocol.FieldEncoder) error {
	e.SetFields(protocol.BodyTarget, "SSE-KMS", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.KeyId != nil {
			v := *s.KeyId

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "KeyId", protocol.StringValue(v), metadata)
		}
		return nil
	}), protocol.Metadata{})
	return nil
}

// Specifies the use of SSE-S3 to encrypt delivered Inventory reports.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SSES3
type SSES3 struct {
	_ struct{} `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s SSES3) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SSES3) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Describes the parameters for Select job types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SelectParameters
type SelectParameters struct {
	_ struct{} `type:"structure"`

	// The expression that is used to query the object.
	//
	// Expression is a required field
	Expression *string `type:"string" required:"true"`

	// The type of the provided expression (e.g., SQL).
	//
	// ExpressionType is a required field
	ExpressionType ExpressionType `type:"string" required:"true" enum:"true"`

	// Describes the serialization format of the object.
	//
	// InputSerialization is a required field
	InputSerialization *InputSerialization `type:"structure" required:"true"`

	// Describes how the results of the Select job are serialized.
	//
	// OutputSerialization is a required field
	OutputSerialization *OutputSerialization `type:"structure" required:"true"`
}

// String returns the string representation
func (s SelectParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelectParameters"}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if len(s.ExpressionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ExpressionType"))
	}

	if s.InputSerialization == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputSerialization"))
	}

	if s.OutputSerialization == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputSerialization"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SelectParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Expression", protocol.StringValue(v), metadata)
	}
	if len(s.ExpressionType) > 0 {
		v := s.ExpressionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpressionType", v, metadata)
	}
	if s.InputSerialization != nil {
		v := s.InputSerialization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InputSerialization", v, metadata)
	}
	if s.OutputSerialization != nil {
		v := s.OutputSerialization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputSerialization", v, metadata)
	}
	return nil
}

// Describes the default server-side encryption to apply to new objects in the
// bucket. If Put Object request does not specify any server-side encryption,
// this default encryption will be applied.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionByDefault
type ServerSideEncryptionByDefault struct {
	_ struct{} `type:"structure"`

	// KMS master key ID to use for the default encryption. This parameter is allowed
	// if SSEAlgorithm is aws:kms.
	KMSMasterKeyID *string `type:"string"`

	// Server-side encryption algorithm to use for the default encryption.
	//
	// SSEAlgorithm is a required field
	SSEAlgorithm ServerSideEncryption `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionByDefault) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionByDefault) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionByDefault"}
	if len(s.SSEAlgorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SSEAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionByDefault) MarshalFields(e protocol.FieldEncoder) error {
	if s.KMSMasterKeyID != nil {
		v := *s.KMSMasterKeyID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSMasterKeyID", protocol.StringValue(v), metadata)
	}
	if len(s.SSEAlgorithm) > 0 {
		v := s.SSEAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SSEAlgorithm", v, metadata)
	}
	return nil
}

// Container for server-side encryption configuration rules. Currently S3 supports
// one rule only.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionConfiguration
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Container for information about a particular server-side encryption configuration
	// rule.
	//
	// Rules is a required field
	Rules []ServerSideEncryptionRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container for information about a particular server-side encryption configuration
// rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionRule
type ServerSideEncryptionRule struct {
	_ struct{} `type:"structure"`

	// Describes the default server-side encryption to apply to new objects in the
	// bucket. If Put Object request does not specify any server-side encryption,
	// this default encryption will be applied.
	ApplyServerSideEncryptionByDefault *ServerSideEncryptionByDefault `type:"structure"`
}

// String returns the string representation
func (s ServerSideEncryptionRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionRule"}
	if s.ApplyServerSideEncryptionByDefault != nil {
		if err := s.ApplyServerSideEncryptionByDefault.Validate(); err != nil {
			invalidParams.AddNested("ApplyServerSideEncryptionByDefault", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplyServerSideEncryptionByDefault != nil {
		v := s.ApplyServerSideEncryptionByDefault

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ApplyServerSideEncryptionByDefault", v, metadata)
	}
	return nil
}

// A container for filters that define which source objects should be replicated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SourceSelectionCriteria
type SourceSelectionCriteria struct {
	_ struct{} `type:"structure"`

	// A container for filter information for the selection of S3 objects encrypted
	// with AWS KMS. If you include SourceSelectionCriteria in the replication configuration,
	// this element is required.
	SseKmsEncryptedObjects *SseKmsEncryptedObjects `type:"structure"`
}

// String returns the string representation
func (s SourceSelectionCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceSelectionCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceSelectionCriteria"}
	if s.SseKmsEncryptedObjects != nil {
		if err := s.SseKmsEncryptedObjects.Validate(); err != nil {
			invalidParams.AddNested("SseKmsEncryptedObjects", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SourceSelectionCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.SseKmsEncryptedObjects != nil {
		v := s.SseKmsEncryptedObjects

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SseKmsEncryptedObjects", v, metadata)
	}
	return nil
}

// A container for filter information for the selection of S3 objects encrypted
// with AWS KMS.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SseKmsEncryptedObjects
type SseKmsEncryptedObjects struct {
	_ struct{} `type:"structure"`

	// If the status is not Enabled, replication for S3 objects encrypted with AWS
	// KMS is disabled.
	//
	// Status is a required field
	Status SseKmsEncryptedObjectsStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SseKmsEncryptedObjects) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SseKmsEncryptedObjects) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SseKmsEncryptedObjects"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SseKmsEncryptedObjects) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/StorageClassAnalysis
type StorageClassAnalysis struct {
	_ struct{} `type:"structure"`

	// A container used to describe how data related to the storage class analysis
	// should be exported.
	DataExport *StorageClassAnalysisDataExport `type:"structure"`
}

// String returns the string representation
func (s StorageClassAnalysis) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageClassAnalysis) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StorageClassAnalysis"}
	if s.DataExport != nil {
		if err := s.DataExport.Validate(); err != nil {
			invalidParams.AddNested("DataExport", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageClassAnalysis) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataExport != nil {
		v := s.DataExport

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DataExport", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/StorageClassAnalysisDataExport
type StorageClassAnalysisDataExport struct {
	_ struct{} `type:"structure"`

	// The place to store the data for an analysis.
	//
	// Destination is a required field
	Destination *AnalyticsExportDestination `type:"structure" required:"true"`

	// The version of the output schema to use when exporting data. Must be V_1.
	//
	// OutputSchemaVersion is a required field
	OutputSchemaVersion StorageClassAnalysisSchemaVersion `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StorageClassAnalysisDataExport) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageClassAnalysisDataExport) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StorageClassAnalysisDataExport"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if len(s.OutputSchemaVersion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("OutputSchemaVersion"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageClassAnalysisDataExport) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if len(s.OutputSchemaVersion) > 0 {
		v := s.OutputSchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutputSchemaVersion", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Tagging
type Tagging struct {
	_ struct{} `type:"structure"`

	// TagSet is a required field
	TagSet []Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s Tagging) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tagging) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tagging"}

	if s.TagSet == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagSet"))
	}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tagging) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.TagSet) > 0 {
		v := s.TagSet

		metadata := protocol.Metadata{ListLocationName: "Tag"}
		ls0 := e.List(protocol.BodyTarget, "TagSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TargetGrant
type TargetGrant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Logging permissions assigned to the Grantee for the bucket.
	Permission BucketLogsPermission `type:"string" enum:"true"`
}

// String returns the string representation
func (s TargetGrant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetGrant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetGrant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TargetGrant) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grantee != nil {
		v := s.Grantee
		attrs := make([]protocol.Attribute, 0, 1)

		if len(s.Grantee.Type) > 0 {

			v := s.Grantee.Type
			attrs = append(attrs, protocol.Attribute{Name: "xsi:type", Value: v, Meta: protocol.Metadata{}})
		}
		metadata := protocol.Metadata{Attributes: attrs, XMLNamespacePrefix: "xsi", XMLNamespaceURI: "http://www.w3.org/2001/XMLSchema-instance"}
		e.SetFields(protocol.BodyTarget, "Grantee", v, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", v, metadata)
	}
	return nil
}

// A container for specifying the configuration for publication of messages
// to an Amazon Simple Notification Service (Amazon SNS) topic.when Amazon S3
// detects specified events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TopicConfiguration
type TopicConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// A container for object key name filtering rules. For information about key
	// name filtering, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3
	// will publish a message when it detects events of the specified type.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"Topic" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TopicConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.TopicArn != nil {
		v := *s.TopicArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Topic", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TopicConfigurationDeprecated
type TopicConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic to which Amazon S3 will publish a message to report the
	// specified events for the bucket.
	Topic *string `type:"string"`
}

// String returns the string representation
func (s TopicConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicConfigurationDeprecated) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Topic != nil {
		v := *s.Topic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Topic", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Transition
type Transition struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass TransitionStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Transition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Date != nil {
		v := *s.Date

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Date", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/VersioningConfiguration
type VersioningConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete MFADelete `locationName:"MfaDelete" type:"string" enum:"true"`

	// The versioning state of the bucket.
	Status BucketVersioningStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s VersioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VersioningConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.MFADelete) > 0 {
		v := s.MFADelete

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MfaDelete", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/WebsiteConfiguration
type WebsiteConfiguration struct {
	_ struct{} `type:"structure"`

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s WebsiteConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebsiteConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WebsiteConfiguration"}
	if s.ErrorDocument != nil {
		if err := s.ErrorDocument.Validate(); err != nil {
			invalidParams.AddNested("ErrorDocument", err.(aws.ErrInvalidParams))
		}
	}
	if s.IndexDocument != nil {
		if err := s.IndexDocument.Validate(); err != nil {
			invalidParams.AddNested("IndexDocument", err.(aws.ErrInvalidParams))
		}
	}
	if s.RedirectAllRequestsTo != nil {
		if err := s.RedirectAllRequestsTo.Validate(); err != nil {
			invalidParams.AddNested("RedirectAllRequestsTo", err.(aws.ErrInvalidParams))
		}
	}
	if s.RoutingRules != nil {
		for i, v := range s.RoutingRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WebsiteConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorDocument != nil {
		v := s.ErrorDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ErrorDocument", v, metadata)
	}
	if s.IndexDocument != nil {
		v := s.IndexDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IndexDocument", v, metadata)
	}
	if s.RedirectAllRequestsTo != nil {
		v := s.RedirectAllRequestsTo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RedirectAllRequestsTo", v, metadata)
	}
	if len(s.RoutingRules) > 0 {
		v := s.RoutingRules

		metadata := protocol.Metadata{ListLocationName: "RoutingRule"}
		ls0 := e.List(protocol.BodyTarget, "RoutingRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}
