// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageInput
type CreateModelPackageInput struct {
	_ struct{} `type:"structure"`

	// Whether to certify the model package for listing on AWS Marketplace.
	CertifyForMarketplace *bool `type:"boolean"`

	// Specifies details about inference jobs that can be run with models based
	// on this model package, including the following:
	//
	//    * The Amazon ECR paths of containers that contain the inference code and
	//    model artifacts.
	//
	//    * The instance types that the model package supports for transform jobs
	//    and real-time endpoints used for inference.
	//
	//    * The input and output content formats that the model package supports
	//    for inference.
	InferenceSpecification *InferenceSpecification `type:"structure"`

	// A description of the model package.
	ModelPackageDescription *string `type:"string"`

	// The name of the model package. The name must have 1 to 63 characters. Valid
	// characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// ModelPackageName is a required field
	ModelPackageName *string `min:"1" type:"string" required:"true"`

	// Details about the algorithm that was used to create the model package.
	SourceAlgorithmSpecification *SourceAlgorithmSpecification `type:"structure"`

	// Specifies configurations for one or more transform jobs that Amazon SageMaker
	// runs to test the model package.
	ValidationSpecification *ModelPackageValidationSpecification `type:"structure"`
}

// String returns the string representation
func (s CreateModelPackageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelPackageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateModelPackageInput"}

	if s.ModelPackageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelPackageName"))
	}
	if s.ModelPackageName != nil && len(*s.ModelPackageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelPackageName", 1))
	}
	if s.InferenceSpecification != nil {
		if err := s.InferenceSpecification.Validate(); err != nil {
			invalidParams.AddNested("InferenceSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.SourceAlgorithmSpecification != nil {
		if err := s.SourceAlgorithmSpecification.Validate(); err != nil {
			invalidParams.AddNested("SourceAlgorithmSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.ValidationSpecification != nil {
		if err := s.ValidationSpecification.Validate(); err != nil {
			invalidParams.AddNested("ValidationSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageOutput
type CreateModelPackageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new model package.
	//
	// ModelPackageArn is a required field
	ModelPackageArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateModelPackageOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateModelPackage = "CreateModelPackage"

// CreateModelPackageRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates a model package that you can use to create Amazon SageMaker models
// or list on AWS Marketplace. Buyers can subscribe to model packages listed
// on AWS Marketplace to create models in Amazon SageMaker.
//
// To create a model package by specifying a Docker container that contains
// your inference code and the Amazon S3 location of your model artifacts, provide
// values for InferenceSpecification. To create a model from an algorithm resource
// that you created or subscribed to in AWS Marketplace, provide a value for
// SourceAlgorithmSpecification.
//
//    // Example sending a request using CreateModelPackageRequest.
//    req := client.CreateModelPackageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage
func (c *Client) CreateModelPackageRequest(input *CreateModelPackageInput) CreateModelPackageRequest {
	op := &aws.Operation{
		Name:       opCreateModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelPackageInput{}
	}

	req := c.newRequest(op, input, &CreateModelPackageOutput{})
	return CreateModelPackageRequest{Request: req, Input: input, Copy: c.CreateModelPackageRequest}
}

// CreateModelPackageRequest is the request type for the
// CreateModelPackage API operation.
type CreateModelPackageRequest struct {
	*aws.Request
	Input *CreateModelPackageInput
	Copy  func(*CreateModelPackageInput) CreateModelPackageRequest
}

// Send marshals and sends the CreateModelPackage API request.
func (r CreateModelPackageRequest) Send(ctx context.Context) (*CreateModelPackageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateModelPackageResponse{
		CreateModelPackageOutput: r.Request.Data.(*CreateModelPackageOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateModelPackageResponse is the response type for the
// CreateModelPackage API operation.
type CreateModelPackageResponse struct {
	*CreateModelPackageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateModelPackage request.
func (r *CreateModelPackageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
