// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Specifies the training algorithm to use in a CreateTrainingJob (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateTrainingJob.html)
// request.
//
// For more information about algorithms provided by Amazon SageMaker, see Algorithms
// (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information
// about using your own algorithms, see Using Your Own Algorithms with Amazon
// SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AlgorithmSpecification
type AlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm resource to use for the training job. This must
	// be an algorithm resource that you created or subscribe to on AWS Marketplace.
	// If you specify a value for this parameter, you can't specify a value for
	// TrainingImage.
	AlgorithmName *string `min:"1" type:"string"`

	// A list of metric definition objects. Each object specifies the metric name
	// and regular expressions used to parse algorithm logs. Amazon SageMaker publishes
	// each metric to Amazon CloudWatch.
	MetricDefinitions []MetricDefinition `type:"list"`

	// The registry path of the Docker image that contains the training algorithm.
	// For information about docker registry paths for built-in algorithms, see
	// Algorithms Provided by Amazon SageMaker: Common Parameters (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	// Amazon SageMaker supports both registry/repository[:tag] and registry/repository[@digest]
	// image path formats. For more information, see Using Your Own Algorithms with
	// Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	TrainingImage *string `type:"string"`

	// The input mode that the algorithm supports. For the input modes that Amazon
	// SageMaker algorithms support, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	// If an algorithm supports the File input mode, Amazon SageMaker downloads
	// the training data from S3 to the provisioned ML storage Volume, and mounts
	// the directory to docker volume for training container. If an algorithm supports
	// the Pipe input mode, Amazon SageMaker streams data directly from S3 to the
	// container.
	//
	// In File mode, make sure you provision ML storage volume with sufficient capacity
	// to accommodate the data download from S3. In addition to the training data,
	// the ML storage volume also stores the output model. The algorithm container
	// use ML storage volume to also store intermediate information, if any.
	//
	// For distributed algorithms using File mode, training data is distributed
	// uniformly, and your training duration is predictable if the input data objects
	// size is approximately same. Amazon SageMaker does not split the files any
	// further for model training. If the object sizes are skewed, training won't
	// be optimal as the data distribution is also skewed where one host in a training
	// cluster is overloaded, thus becoming bottleneck in training.
	//
	// TrainingInputMode is a required field
	TrainingInputMode TrainingInputMode `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AlgorithmSpecification"}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlgorithmName", 1))
	}
	if len(s.TrainingInputMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TrainingInputMode"))
	}
	if s.MetricDefinitions != nil {
		for i, v := range s.MetricDefinitions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDefinitions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the validation and image scan statuses of the algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AlgorithmStatusDetails
type AlgorithmStatusDetails struct {
	_ struct{} `type:"structure"`

	// The status of the scan of the algorithm's Docker image container.
	ImageScanStatuses []AlgorithmStatusItem `type:"list"`

	// The status of algorithm validation.
	ValidationStatuses []AlgorithmStatusItem `type:"list"`
}

// String returns the string representation
func (s AlgorithmStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// Represents the overall status of an algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AlgorithmStatusItem
type AlgorithmStatusItem struct {
	_ struct{} `type:"structure"`

	// if the overall status is Failed, the reason for the failure.
	FailureReason *string `type:"string"`

	// The name of the algorithm for which the overall status is being reported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current status.
	//
	// Status is a required field
	Status DetailedAlgorithmStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AlgorithmStatusItem) String() string {
	return awsutil.Prettify(s)
}

// Provides summary information about an algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AlgorithmSummary
type AlgorithmSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `min:"1" type:"string" required:"true"`

	// A brief description of the algorithm.
	AlgorithmDescription *string `type:"string"`

	// The name of the algorithm that is described by the summary.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// The overall status of the algorithm.
	//
	// AlgorithmStatus is a required field
	AlgorithmStatus AlgorithmStatus `type:"string" required:"true" enum:"true"`

	// A timestamp that shows when the algorithm was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s AlgorithmSummary) String() string {
	return awsutil.Prettify(s)
}

// Defines a training job and a batch transform job that Amazon SageMaker runs
// to validate your algorithm.
//
// The data provided in the validation profile is made available to your buyers
// on AWS Marketplace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AlgorithmValidationProfile
type AlgorithmValidationProfile struct {
	_ struct{} `type:"structure"`

	// The name of the profile for the algorithm. The name must have 1 to 63 characters.
	// Valid characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// ProfileName is a required field
	ProfileName *string `min:"1" type:"string" required:"true"`

	// The TrainingJobDefinition object that describes the training job that Amazon
	// SageMaker runs to validate your algorithm.
	//
	// TrainingJobDefinition is a required field
	TrainingJobDefinition *TrainingJobDefinition `type:"structure" required:"true"`

	// The TransformJobDefinition object that describes the transform job that Amazon
	// SageMaker runs to validate your algorithm.
	TransformJobDefinition *TransformJobDefinition `type:"structure"`
}

// String returns the string representation
func (s AlgorithmValidationProfile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmValidationProfile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AlgorithmValidationProfile"}

	if s.ProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfileName", 1))
	}

	if s.TrainingJobDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingJobDefinition"))
	}
	if s.TrainingJobDefinition != nil {
		if err := s.TrainingJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TrainingJobDefinition", err.(aws.ErrInvalidParams))
		}
	}
	if s.TransformJobDefinition != nil {
		if err := s.TransformJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TransformJobDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies configurations for one or more training jobs that Amazon SageMaker
// runs to test the algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AlgorithmValidationSpecification
type AlgorithmValidationSpecification struct {
	_ struct{} `type:"structure"`

	// An array of AlgorithmValidationProfile objects, each of which specifies a
	// training job and batch transform job that Amazon SageMaker runs to validate
	// your algorithm.
	//
	// ValidationProfiles is a required field
	ValidationProfiles []AlgorithmValidationProfile `min:"1" type:"list" required:"true"`

	// The IAM roles that Amazon SageMaker uses to run the training jobs.
	//
	// ValidationRole is a required field
	ValidationRole *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AlgorithmValidationSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmValidationSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AlgorithmValidationSpecification"}

	if s.ValidationProfiles == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationProfiles"))
	}
	if s.ValidationProfiles != nil && len(s.ValidationProfiles) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationProfiles", 1))
	}

	if s.ValidationRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationRole"))
	}
	if s.ValidationRole != nil && len(*s.ValidationRole) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationRole", 20))
	}
	if s.ValidationProfiles != nil {
		for i, v := range s.ValidationProfiles {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationProfiles", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configures how labels are consolidated across human workers.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AnnotationConsolidationConfig
type AnnotationConsolidationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a Lambda function implements the logic
	// for annotation consolidation.
	//
	// For the built-in bounding box, image classification, semantic segmentation,
	// and text classification task types, Amazon SageMaker Ground Truth provides
	// the following Lambda functions:
	//
	//    * Bounding box - Finds the most similar boxes from different workers based
	//    on the Jaccard index of the boxes. arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox
	//
	//    * Image classification - Uses a variant of the Expectation Maximization
	//    approach to estimate the true class of an image based on annotations from
	//    individual workers. arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass
	//
	//    * Semantic segmentation - Treats each pixel in an image as a multi-class
	//    classification and treats pixel annotations from workers as "votes" for
	//    the correct label. arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation
	//
	//    * Text classification - Uses a variant of the Expectation Maximization
	//    approach to estimate the true class of text based on annotations from
	//    individual workers. arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass
	//
	// For more information, see Annotation Consolidation (http://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html).
	//
	// AnnotationConsolidationLambdaArn is a required field
	AnnotationConsolidationLambdaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AnnotationConsolidationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnnotationConsolidationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnnotationConsolidationConfig"}

	if s.AnnotationConsolidationLambdaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnnotationConsolidationLambdaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of categorical hyperparameters to tune.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CategoricalParameterRange
type CategoricalParameterRange struct {
	_ struct{} `type:"structure"`

	// The name of the categorical hyperparameter to tune.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A list of the categories for the hyperparameter.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CategoricalParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CategoricalParameterRange"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the possible values for a categorical hyperparameter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CategoricalParameterRangeSpecification
type CategoricalParameterRangeSpecification struct {
	_ struct{} `type:"structure"`

	// The allowed categories for the hyperparameter.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CategoricalParameterRangeSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalParameterRangeSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CategoricalParameterRangeSpecification"}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A channel is a named input source that training algorithms can consume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Channel
type Channel struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// If training data is compressed, the compression type. The default value is
	// None. CompressionType is used only in Pipe input mode. In File mode, leave
	// this field unset or set it to None.
	CompressionType CompressionType `type:"string" enum:"true"`

	// The MIME type of the data.
	ContentType *string `type:"string"`

	// The location of the channel data.
	//
	// DataSource is a required field
	DataSource *DataSource `type:"structure" required:"true"`

	// (Optional) The input mode to use for the data channel in a training job.
	// If you don't set a value for InputMode, Amazon SageMaker uses the value set
	// for TrainingInputMode. Use this parameter to override the TrainingInputMode
	// setting in a AlgorithmSpecification request when you have a channel that
	// needs a different input mode from the training job's general setting. To
	// download the data from Amazon Simple Storage Service (Amazon S3) to the provisioned
	// ML storage volume, and mount the directory to a Docker volume, use File input
	// mode. To stream data directly from Amazon S3 to the container, choose Pipe
	// input mode.
	//
	// To use a model for incremental training, choose File input model.
	InputMode TrainingInputMode `type:"string" enum:"true"`

	// Specify RecordIO as the value when input data is in raw format but the training
	// algorithm requires the RecordIO format. In this case, Amazon SageMaker wraps
	// each individual S3 object in a RecordIO record. If the input data is already
	// in RecordIO format, you don't need to set this attribute. For more information,
	// see Create a Dataset Using RecordIO (https://mxnet.incubator.apache.org/architecture/note_data_loading.html#data-format).
	//
	// In File mode, leave this field unset or set it to None.
	RecordWrapperType RecordWrapper `type:"string" enum:"true"`

	// A configuration for a shuffle option for input data in a channel. If you
	// use S3Prefix for S3DataType, this shuffles the results of the S3 key prefix
	// matches. If you use ManifestFile, the order of the S3 object references in
	// the ManifestFile is shuffled. If you use AugmentedManifestFile, the order
	// of the JSON lines in the AugmentedManifestFile is shuffled. The shuffling
	// order is determined using the Seed value.
	//
	// For Pipe input mode, shuffling is done at the start of every epoch. With
	// large datasets this ensures that the order of the training data is different
	// for each epoch, it helps reduce bias and possible overfitting. In a multi-node
	// training job when ShuffleConfig is combined with S3DataDistributionType of
	// ShardedByS3Key, the data is shuffled across nodes so that the content sent
	// to a particular node on the first epoch might be sent to a different node
	// on the second epoch.
	ShuffleConfig *ShuffleConfig `type:"structure"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Channel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Channel"}

	if s.ChannelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelName", 1))
	}

	if s.DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSource"))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(aws.ErrInvalidParams))
		}
	}
	if s.ShuffleConfig != nil {
		if err := s.ShuffleConfig.Validate(); err != nil {
			invalidParams.AddNested("ShuffleConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a named input source, called a channel, to be used by an algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ChannelSpecification
type ChannelSpecification struct {
	_ struct{} `type:"structure"`

	// A brief description of the channel.
	Description *string `type:"string"`

	// Indicates whether the channel is required by the algorithm.
	IsRequired *bool `type:"boolean"`

	// The name of the channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The allowed compression types, if data compression is used.
	SupportedCompressionTypes []CompressionType `type:"list"`

	// The supported MIME types for the data.
	//
	// SupportedContentTypes is a required field
	SupportedContentTypes []string `type:"list" required:"true"`

	// The allowed input mode, either FILE or PIPE.
	//
	// In FILE mode, Amazon SageMaker copies the data from the input source onto
	// the local Amazon Elastic Block Store (Amazon EBS) volumes before starting
	// your training algorithm. This is the most commonly used input mode.
	//
	// In PIPE mode, Amazon SageMaker streams input data from the source directly
	// to your algorithm without using the EBS volume.
	//
	// SupportedInputModes is a required field
	SupportedInputModes []TrainingInputMode `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ChannelSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ChannelSpecification"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SupportedContentTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedContentTypes"))
	}

	if s.SupportedInputModes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedInputModes"))
	}
	if s.SupportedInputModes != nil && len(s.SupportedInputModes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SupportedInputModes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies summary information about a Git repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CodeRepositorySummary
type CodeRepositorySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Git repository.
	//
	// CodeRepositoryArn is a required field
	CodeRepositoryArn *string `min:"1" type:"string" required:"true"`

	// The name of the Git repository.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`

	// The date and time that the Git repository was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Configuration details for the Git repository, including the URL where it
	// is located and the ARN of the AWS Secrets Manager secret that contains the
	// credentials used to access the repository.
	GitConfig *GitConfig `type:"structure"`

	// The date and time that the Git repository was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s CodeRepositorySummary) String() string {
	return awsutil.Prettify(s)
}

// Identifies a Amazon Cognito user group. A user group can be used in on or
// more work teams.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CognitoMemberDefinition
type CognitoMemberDefinition struct {
	_ struct{} `type:"structure"`

	// An identifier for an application client. You must create the app client ID
	// using Amazon Cognito.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// An identifier for a user group.
	//
	// UserGroup is a required field
	UserGroup *string `min:"1" type:"string" required:"true"`

	// An identifier for a user pool. The user pool must be in the same region as
	// the service that you are calling.
	//
	// UserPool is a required field
	UserPool *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CognitoMemberDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoMemberDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CognitoMemberDefinition"}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}

	if s.UserGroup == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserGroup"))
	}
	if s.UserGroup != nil && len(*s.UserGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserGroup", 1))
	}

	if s.UserPool == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPool"))
	}
	if s.UserPool != nil && len(*s.UserPool) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPool", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A summary of a model compilation job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CompilationJobSummary
type CompilationJobSummary struct {
	_ struct{} `type:"structure"`

	// The time when the model compilation job completed.
	CompilationEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the model compilation job.
	//
	// CompilationJobArn is a required field
	CompilationJobArn *string `type:"string" required:"true"`

	// The name of the model compilation job that you want a summary for.
	//
	// CompilationJobName is a required field
	CompilationJobName *string `min:"1" type:"string" required:"true"`

	// The status of the model compilation job.
	//
	// CompilationJobStatus is a required field
	CompilationJobStatus CompilationJobStatus `type:"string" required:"true" enum:"true"`

	// The time when the model compilation job started.
	CompilationStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The type of device that the model will run on after compilation has completed.
	//
	// CompilationTargetDevice is a required field
	CompilationTargetDevice TargetDevice `type:"string" required:"true" enum:"true"`

	// The time when the model compilation job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The time when the model compilation job was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s CompilationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes the container, as part of model definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ContainerDefinition
type ContainerDefinition struct {
	_ struct{} `type:"structure"`

	// This parameter is ignored for models that contain only a PrimaryContainer.
	//
	// When a ContainerDefinition is part of an inference pipeline, the value of
	// ths parameter uniquely identifies the container for the purposes of logging
	// and metrics. For information, see Use Logs and Metrics to Monitor an Inference
	// Pipeline (http://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html).
	// If you don't specify a value for this parameter for a ContainerDefinition
	// that is part of an inference pipeline, a unique name is automatically assigned
	// based on the position of the ContainerDefinition in the pipeline. If you
	// specify a value for the ContainerHostName for any ContainerDefinition that
	// is part of an inference pipeline, you must specify a value for the ContainerHostName
	// parameter of every ContainerDefinition in that pipeline.
	ContainerHostname *string `type:"string"`

	// The environment variables to set in the Docker container. Each key and value
	// in the Environment string to string map can have length of up to 1024. We
	// support up to 16 entries in the map.
	Environment map[string]string `type:"map"`

	// The Amazon EC2 Container Registry (Amazon ECR) path where inference code
	// is stored. If you are using your own custom algorithm instead of an algorithm
	// provided by Amazon SageMaker, the inference code must meet Amazon SageMaker
	// requirements. Amazon SageMaker supports both registry/repository[:tag] and
	// registry/repository[@digest] image path formats. For more information, see
	// Using Your Own Algorithms with Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html)
	Image *string `type:"string"`

	// The S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix). The S3 path is required for Amazon SageMaker built-in algorithms,
	// but not if you use your own algorithms. For more information on built-in
	// algorithms, see Common Parameters (http://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	//
	// If you provide a value for this parameter, Amazon SageMaker uses AWS Security
	// Token Service to download model artifacts from the S3 path you provide. AWS
	// STS is activated in your IAM user account by default. If you previously deactivated
	// AWS STS for a region, you need to reactivate AWS STS for that region. For
	// more information, see Activating and Deactivating AWS STS in an AWS Region
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
	// in the AWS Identity and Access Management User Guide.
	//
	// If you use a built-in algorithm to create a model, Amazon SageMaker requires
	// that you provide a S3 path to the model artifacts in ModelDataUrl.
	ModelDataUrl *string `type:"string"`

	// The name of the model package to use to create the model.
	ModelPackageName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContainerDefinition"}
	if s.ModelPackageName != nil && len(*s.ModelPackageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelPackageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of continuous hyperparameters to tune.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ContinuousParameterRange
type ContinuousParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum value for the hyperparameter. The tuning job uses floating-point
	// values between MinValue value and this value for tuning.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum value for the hyperparameter. The tuning job uses floating-point
	// values between this value and MaxValuefor tuning.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`

	// The name of the continuous hyperparameter to tune.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (http://docs.aws.amazon.com//sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	//
	// Auto
	//
	// Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparemeter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have only values greater than
	// 0.
	//
	// ReverseLogarithmic
	//
	// Hyperparemeter tuning searches the values in the hyperparameter range by
	// using a reverse logarithmic scale.
	//
	// Reverse logarithmic scaling works only for ranges that are entirely within
	// the range 0<=x<1.0.
	ScalingType HyperParameterScalingType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ContinuousParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContinuousParameterRange"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the possible values for a continuous hyperparameter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ContinuousParameterRangeSpecification
type ContinuousParameterRangeSpecification struct {
	_ struct{} `type:"structure"`

	// The maximum floating-point value allowed.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum floating-point value allowed.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ContinuousParameterRangeSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousParameterRangeSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContinuousParameterRangeSpecification"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the location of the channel data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DataSource
type DataSource struct {
	_ struct{} `type:"structure"`

	// The S3 location of the data source that is associated with a channel.
	S3DataSource *S3DataSource `type:"structure"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSource"}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Gets the Amazon EC2 Container Registry path of the docker image of the model
// that is hosted in this ProductionVariant.
//
// If you used the registry/repository[:tag] form to specify the image path
// of the primary container when you created the model hosted in this ProductionVariant,
// the path resolves to a path of the form registry/repository[@digest]. A digest
// is a hash value that identifies a specific version of an image. For information
// about Amazon ECR paths, see Pulling an Image (http://docs.aws.amazon.com//AmazonECR/latest/userguide/docker-pull-ecr-image.html)
// in the Amazon ECR User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeployedImage
type DeployedImage struct {
	_ struct{} `type:"structure"`

	// The date and time when the image path for the model resolved to the ResolvedImage
	ResolutionTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The specific digest path of the image hosted in this ProductionVariant.
	ResolvedImage *string `type:"string"`

	// The image path you specified when you created the model.
	SpecifiedImage *string `type:"string"`
}

// String returns the string representation
func (s DeployedImage) String() string {
	return awsutil.Prettify(s)
}

// Specifies weight and capacity values for a production variant.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DesiredWeightAndCapacity
type DesiredWeightAndCapacity struct {
	_ struct{} `type:"structure"`

	// The variant's capacity.
	DesiredInstanceCount *int64 `min:"1" type:"integer"`

	// The variant's weight.
	DesiredWeight *float64 `type:"float"`

	// The name of the variant to update.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DesiredWeightAndCapacity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredWeightAndCapacity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DesiredWeightAndCapacity"}
	if s.DesiredInstanceCount != nil && *s.DesiredInstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("DesiredInstanceCount", 1))
	}

	if s.VariantName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VariantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information for an endpoint configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EndpointConfigSummary
type EndpointConfigSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EndpointConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides summary information for an endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EndpointSummary
type EndpointSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The status of the endpoint.
	//
	//    * OutOfService: Endpoint is not available to take incoming requests.
	//
	//    * Creating: CreateEndpoint is executing.
	//
	//    * Updating: UpdateEndpoint or UpdateEndpointWeightsAndCapacities is executing.
	//
	//    * SystemUpdating: Endpoint is undergoing maintenance and cannot be updated
	//    or deleted or re-scaled until it has completed. This maintenance operation
	//    does not change any customer-specified values such as VPC config, KMS
	//    encryption, model, instance type, or instance count.
	//
	//    * RollingBack: Endpoint fails to scale up or down or change its variant
	//    weight and is in the process of rolling back to its previous configuration.
	//    Once the rollback completes, endpoint returns to an InService status.
	//    This transitional status only applies to an endpoint that has autoscaling
	//    enabled and is undergoing variant weight or capacity changes as part of
	//    an UpdateEndpointWeightsAndCapacities call or when the UpdateEndpointWeightsAndCapacities
	//    operation is called explicitly.
	//
	//    * InService: Endpoint is available to process incoming requests.
	//
	//    * Deleting: DeleteEndpoint is executing.
	//
	//    * Failed: Endpoint could not be created, updated, or re-scaled. Use DescribeEndpointOutput$FailureReason
	//    for information about the failure. DeleteEndpoint is the only operation
	//    that can be performed on a failed endpoint.
	//
	// To get a list of endpoints with a specified status, use the ListEndpointsInput$StatusEquals
	// filter.
	//
	// EndpointStatus is a required field
	EndpointStatus EndpointStatus `type:"string" required:"true" enum:"true"`

	// A timestamp that shows when the endpoint was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s EndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// A conditional statement for a search expression that includes a Boolean operator,
// a resource property, and a value.
//
// If you don't specify an Operator and a Value, the filter searches for only
// the specified property. For example, defining a Filter for the FailureReason
// for the TrainingJob Resource searches for training job objects that have
// a value in the FailureReason field.
//
// If you specify a Value, but not an Operator, Amazon SageMaker uses the equals
// operator as the default.
//
// In search, there are several property types:
//
// Metrics
//
// To define a metric filter, enter a value using the form "Metrics.<name>",
// where <name> is a metric name. For example, the following filter searches
// for training jobs with an "accuracy" metric greater than "0.9":
//
// {
//
// "Name": "Metrics.accuracy",
//
// "Operator": "GREATER_THAN",
//
// "Value": "0.9"
//
// }
//
// HyperParameters
//
// To define a hyperparameter filter, enter a value with the form "HyperParameters.<name>".
// Decimal hyperparameter values are treated as a decimal in a comparison if
// the specified Value is also a decimal value. If the specified Value is an
// integer, the decimal hyperparameter values are treated as integers. For example,
// the following filter is satisfied by training jobs with a "learning_rate"
// hyperparameter that is less than "0.5":
//
// {
//
// "Name": "HyperParameters.learning_rate",
//
// "Operator": "LESS_THAN",
//
// "Value": "0.5"
//
// }
//
// Tags
//
// To define a tag filter, enter a value with the form "Tags.<key>".
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// A property name. For example, TrainingJobName. For the list of valid property
	// names returned in a search result for each supported resource, see TrainingJob
	// properties. You must specify a valid property name for the resource.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A Boolean binary operator that is used to evaluate the filter. The operator
	// field contains one of the following values:
	//
	// Equals
	//
	// The specified resource in Name equals the specified Value.
	//
	// NotEquals
	//
	// The specified resource in Name does not equal the specified Value.
	//
	// GreaterThan
	//
	// The specified resource in Name is greater than the specified Value. Not supported
	// for text-based properties.
	//
	// GreaterThanOrEqualTo
	//
	// The specified resource in Name is greater than or equal to the specified
	// Value. Not supported for text-based properties.
	//
	// LessThan
	//
	// The specified resource in Name is less than the specified Value. Not supported
	// for text-based properties.
	//
	// LessThanOrEqualTo
	//
	// The specified resource in Name is less than or equal to the specified Value.
	// Not supported for text-based properties.
	//
	// Contains
	//
	// Only supported for text-based properties. The word-list of the property contains
	// the specified Value.
	//
	// If you have specified a filter Value, the default is Equals.
	Operator Operator `type:"string" enum:"true"`

	// A value used with Resource and Operator to determine if objects satisfy the
	// filter's condition. For numerical properties, Value must be an integer or
	// floating-point decimal. For timestamp properties, Value must be an ISO 8601
	// date-time string of the following format: YYYY-mm-dd'T'HH:MM:SS.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Shows the final value for the objective metric for a training job that was
// launched by a hyperparameter tuning job. You define the objective metric
// in the HyperParameterTuningJobObjective parameter of HyperParameterTuningJobConfig.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/FinalHyperParameterTuningJobObjectiveMetric
type FinalHyperParameterTuningJobObjectiveMetric struct {
	_ struct{} `type:"structure"`

	// The name of the objective metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// Whether to minimize or maximize the objective metric. Valid values are Minimize
	// and Maximize.
	Type HyperParameterTuningJobObjectiveType `type:"string" enum:"true"`

	// The value of the objective metric.
	//
	// Value is a required field
	Value *float64 `type:"float" required:"true"`
}

// String returns the string representation
func (s FinalHyperParameterTuningJobObjectiveMetric) String() string {
	return awsutil.Prettify(s)
}

// Specifies configuration details for a Git repository in your AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GitConfig
type GitConfig struct {
	_ struct{} `type:"structure"`

	// The default branch for the Git repository.
	Branch *string `min:"1" type:"string"`

	// The URL where the Git repository is located.
	//
	// RepositoryUrl is a required field
	RepositoryUrl *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains
	// the credentials used to access the git repository. The secret must have a
	// staging label of AWSCURRENT and must be in the following format:
	//
	// {"username": UserName, "password": Password}
	SecretArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GitConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GitConfig"}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Branch", 1))
	}

	if s.RepositoryUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryUrl"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies configuration details for a Git repository when the repository
// is updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GitConfigForUpdate
type GitConfigForUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains
	// the credentials used to access the git repository. The secret must have a
	// staging label of AWSCURRENT and must be in the following format:
	//
	// {"username": UserName, "password": Password}
	SecretArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GitConfigForUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitConfigForUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GitConfigForUpdate"}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information required for human workers to complete a labeling task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HumanTaskConfig
type HumanTaskConfig struct {
	_ struct{} `type:"structure"`

	// Configures how labels are consolidated across human workers.
	//
	// AnnotationConsolidationConfig is a required field
	AnnotationConsolidationConfig *AnnotationConsolidationConfig `type:"structure" required:"true"`

	// Defines the maximum number of data objects that can be labeled by human workers
	// at the same time. Each object may have more than one worker at one time.
	MaxConcurrentTaskCount *int64 `min:"1" type:"integer"`

	// The number of human workers that will label an object.
	//
	// NumberOfHumanWorkersPerDataObject is a required field
	NumberOfHumanWorkersPerDataObject *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of a Lambda function that is run before a
	// data object is sent to a human worker. Use this function to provide input
	// to a custom labeling job.
	//
	// For the built-in bounding box, image classification, semantic segmentation,
	// and text classification task types, Amazon SageMaker Ground Truth provides
	// the following Lambda functions:
	//
	// US East (Northern Virginia) (us-east-1):
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass
	//
	// US East (Ohio) (us-east-2):
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass
	//
	// US West (Oregon) (us-west-2):
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass
	//
	// EU (Ireland) (eu-west-1):
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass
	//
	// Asia Pacific (Tokyo (ap-northeast-1):
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass
	//
	// Asia Pacific (Sydney (ap-southeast-1):
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass
	//
	// PreHumanTaskLambdaArn is a required field
	PreHumanTaskLambdaArn *string `type:"string" required:"true"`

	// The price that you pay for each task performed by a public worker.
	PublicWorkforceTaskPrice *PublicWorkforceTaskPrice `type:"structure"`

	// The length of time that a task remains available for labelling by human workers.
	TaskAvailabilityLifetimeInSeconds *int64 `min:"1" type:"integer"`

	// A description of the task for your human workers.
	//
	// TaskDescription is a required field
	TaskDescription *string `min:"1" type:"string" required:"true"`

	// Keywords used to describe the task so that workers on Amazon Mechanical Turk
	// can discover the task.
	TaskKeywords []string `min:"1" type:"list"`

	// The amount of time that a worker has to complete a task.
	//
	// TaskTimeLimitInSeconds is a required field
	TaskTimeLimitInSeconds *int64 `min:"1" type:"integer" required:"true"`

	// A title for the task for your human workers.
	//
	// TaskTitle is a required field
	TaskTitle *string `min:"1" type:"string" required:"true"`

	// Information about the user interface that workers use to complete the labeling
	// task.
	//
	// UiConfig is a required field
	UiConfig *UiConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the work team assigned to complete the
	// tasks.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HumanTaskConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanTaskConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HumanTaskConfig"}

	if s.AnnotationConsolidationConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnnotationConsolidationConfig"))
	}
	if s.MaxConcurrentTaskCount != nil && *s.MaxConcurrentTaskCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxConcurrentTaskCount", 1))
	}

	if s.NumberOfHumanWorkersPerDataObject == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfHumanWorkersPerDataObject"))
	}
	if s.NumberOfHumanWorkersPerDataObject != nil && *s.NumberOfHumanWorkersPerDataObject < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NumberOfHumanWorkersPerDataObject", 1))
	}

	if s.PreHumanTaskLambdaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PreHumanTaskLambdaArn"))
	}
	if s.TaskAvailabilityLifetimeInSeconds != nil && *s.TaskAvailabilityLifetimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TaskAvailabilityLifetimeInSeconds", 1))
	}

	if s.TaskDescription == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskDescription"))
	}
	if s.TaskDescription != nil && len(*s.TaskDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskDescription", 1))
	}
	if s.TaskKeywords != nil && len(s.TaskKeywords) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskKeywords", 1))
	}

	if s.TaskTimeLimitInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskTimeLimitInSeconds"))
	}
	if s.TaskTimeLimitInSeconds != nil && *s.TaskTimeLimitInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TaskTimeLimitInSeconds", 1))
	}

	if s.TaskTitle == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskTitle"))
	}
	if s.TaskTitle != nil && len(*s.TaskTitle) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskTitle", 1))
	}

	if s.UiConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("UiConfig"))
	}

	if s.WorkteamArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkteamArn"))
	}
	if s.AnnotationConsolidationConfig != nil {
		if err := s.AnnotationConsolidationConfig.Validate(); err != nil {
			invalidParams.AddNested("AnnotationConsolidationConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.UiConfig != nil {
		if err := s.UiConfig.Validate(); err != nil {
			invalidParams.AddNested("UiConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies which training algorithm to use for training jobs that a hyperparameter
// tuning job launches and the metrics to monitor.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterAlgorithmSpecification
type HyperParameterAlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the resource algorithm to use for the hyperparameter tuning job.
	// If you specify a value for this parameter, do not specify a value for TrainingImage.
	AlgorithmName *string `min:"1" type:"string"`

	// An array of MetricDefinition objects that specify the metrics that the algorithm
	// emits.
	MetricDefinitions []MetricDefinition `type:"list"`

	// The registry path of the Docker image that contains the training algorithm.
	// For information about Docker registry paths for built-in algorithms, see
	// Algorithms Provided by Amazon SageMaker: Common Parameters (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	// Amazon SageMaker supports both registry/repository[:tag] and registry/repository[@digest]
	// image path formats. For more information, see Using Your Own Algorithms with
	// Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	TrainingImage *string `type:"string"`

	// The input mode that the algorithm supports: File or Pipe. In File input mode,
	// Amazon SageMaker downloads the training data from Amazon S3 to the storage
	// volume that is attached to the training instance and mounts the directory
	// to the Docker volume for the training container. In Pipe input mode, Amazon
	// SageMaker streams data directly from Amazon S3 to the container.
	//
	// If you specify File mode, make sure that you provision the storage volume
	// that is attached to the training instance with enough capacity to accommodate
	// the training data downloaded from Amazon S3, the model artifacts, and intermediate
	// information.
	//
	// For more information about input modes, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	//
	// TrainingInputMode is a required field
	TrainingInputMode TrainingInputMode `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HyperParameterAlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterAlgorithmSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterAlgorithmSpecification"}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlgorithmName", 1))
	}
	if len(s.TrainingInputMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TrainingInputMode"))
	}
	if s.MetricDefinitions != nil {
		for i, v := range s.MetricDefinitions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDefinitions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a hyperparameter to be used by an algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterSpecification
type HyperParameterSpecification struct {
	_ struct{} `type:"structure"`

	// The default value for this hyperparameter. If a default value is specified,
	// a hyperparameter cannot be required.
	DefaultValue *string `type:"string"`

	// A brief description of the hyperparameter.
	Description *string `type:"string"`

	// Indicates whether this hyperparameter is required.
	IsRequired *bool `type:"boolean"`

	// Indicates whether this hyperparameter is tunable in a hyperparameter tuning
	// job.
	IsTunable *bool `type:"boolean"`

	// The name of this hyperparameter. The name must be unique.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The allowed range for this hyperparameter.
	Range *ParameterRange `type:"structure"`

	// The type of this hyperparameter. The valid types are Integer, Continuous,
	// Categorical, and FreeText.
	//
	// Type is a required field
	Type ParameterType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HyperParameterSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterSpecification"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the training jobs launched by a hyperparameter tuning job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterTrainingJobDefinition
type HyperParameterTrainingJobDefinition struct {
	_ struct{} `type:"structure"`

	// The HyperParameterAlgorithmSpecification object that specifies the resource
	// algorithm to use for the training jobs that the tuning job launches.
	//
	// AlgorithmSpecification is a required field
	AlgorithmSpecification *HyperParameterAlgorithmSpecification `type:"structure" required:"true"`

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use
	// a deep learning algorithm in distributed training.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// Isolates the training container. No inbound or outbound network calls can
	// be made, except for calls between peers within a training cluster for distributed
	// training. If network isolation is used for training jobs that are configured
	// to use a VPC, Amazon SageMaker downloads and uploads customer data and model
	// artifacts through the specified VPC, but the training container does not
	// have network access.
	//
	// The Semantic Segmentation built-in algorithm does not support network isolation.
	EnableNetworkIsolation *bool `type:"boolean"`

	// An array of Channel objects that specify the input for the training jobs
	// that the tuning job launches.
	InputDataConfig []Channel `min:"1" type:"list"`

	// Specifies the path to the Amazon S3 bucket where you store model artifacts
	// from the training jobs that the tuning job launches.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The resources, including the compute instances and storage volumes, to use
	// for the training jobs that the tuning job launches.
	//
	// Storage volumes store model artifacts and incremental states. Training algorithms
	// might also use storage volumes for scratch space. If you want Amazon SageMaker
	// to use the storage volume to store the training data, choose File as the
	// TrainingInputMode in the algorithm specification. For distributed training
	// algorithms, specify an instance count greater than 1.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the training
	// jobs that the tuning job launches.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the values of hyperparameters that do not change for the tuning
	// job.
	StaticHyperParameters map[string]string `type:"map"`

	// Sets a maximum duration for the training jobs that the tuning job launches.
	// Use this parameter to limit model training costs.
	//
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This
	// delays job termination for 120 seconds. Algorithms might use this 120-second
	// window to save the model artifacts.
	//
	// When Amazon SageMaker terminates a job because the stopping condition has
	// been met, training algorithms provided by Amazon SageMaker save the intermediate
	// results of the job.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// The VpcConfig object that specifies the VPC that you want the training jobs
	// that this hyperparameter tuning job launches to connect to. Control access
	// to and from your training container by configuring the VPC. For more information,
	// see Protect Training Jobs by Using an Amazon Virtual Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s HyperParameterTrainingJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTrainingJobDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTrainingJobDefinition"}

	if s.AlgorithmSpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlgorithmSpecification"))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputDataConfig", 1))
	}

	if s.OutputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputDataConfig"))
	}

	if s.ResourceConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceConfig"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.StoppingCondition == nil {
		invalidParams.Add(aws.NewErrParamRequired("StoppingCondition"))
	}
	if s.AlgorithmSpecification != nil {
		if err := s.AlgorithmSpecification.Validate(); err != nil {
			invalidParams.AddNested("AlgorithmSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(aws.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies summary information about a training job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterTrainingJobSummary
type HyperParameterTrainingJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the training job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The reason that the training job failed.
	FailureReason *string `type:"string"`

	// The FinalHyperParameterTuningJobObjectiveMetric object that specifies the
	// value of the objective metric of the tuning job that launched this training
	// job.
	FinalHyperParameterTuningJobObjectiveMetric *FinalHyperParameterTuningJobObjectiveMetric `type:"structure"`

	// The status of the objective metric for the training job:
	//
	//    * Succeeded: The final objective metric for the training job was evaluated
	//    by the hyperparameter tuning job and used in the hyperparameter tuning
	//    process.
	//
	//    * Pending: The training job is in progress and evaluation of its final
	//    objective metric is pending.
	//
	//    * Failed: The final objective metric for the training job was not evaluated,
	//    and was not used in the hyperparameter tuning process. This typically
	//    occurs when the training job failed or did not emit an objective metric.
	ObjectiveStatus ObjectiveStatus `type:"string" enum:"true"`

	// Specifies the time when the training job ends on training instances. You
	// are billed for the time interval between the value of TrainingStartTime and
	// this time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker
	// detects a job failure.
	TrainingEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`

	// The name of the training job.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the training job.
	//
	// TrainingJobStatus is a required field
	TrainingJobStatus TrainingJobStatus `type:"string" required:"true" enum:"true"`

	// The date and time that the training job started.
	TrainingStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of the hyperparameters for which you specified ranges to search.
	//
	// TunedHyperParameters is a required field
	TunedHyperParameters map[string]string `type:"map" required:"true"`

	// The HyperParameter tuning job that launched the training job.
	TuningJobName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s HyperParameterTrainingJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Configures a hyperparameter tuning job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterTuningJobConfig
type HyperParameterTuningJobConfig struct {
	_ struct{} `type:"structure"`

	// The HyperParameterTuningJobObjective object that specifies the objective
	// metric for this tuning job.
	HyperParameterTuningJobObjective *HyperParameterTuningJobObjective `type:"structure"`

	// The ParameterRanges object that specifies the ranges of hyperparameters that
	// this tuning job searches.
	ParameterRanges *ParameterRanges `type:"structure"`

	// The ResourceLimits object that specifies the maximum number of training jobs
	// and parallel training jobs for this tuning job.
	//
	// ResourceLimits is a required field
	ResourceLimits *ResourceLimits `type:"structure" required:"true"`

	// Specifies how hyperparameter tuning chooses the combinations of hyperparameter
	// values to use for the training job it launches. To use the Bayesian search
	// stategy, set this to Bayesian. To randomly search, set it to Random. For
	// information about search strategies, see How Hyperparameter Tuning Works
	// (http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
	//
	// Strategy is a required field
	Strategy HyperParameterTuningJobStrategyType `type:"string" required:"true" enum:"true"`

	// Specifies whether to use early stopping for training jobs launched by the
	// hyperparameter tuning job. This can be one of the following values (the default
	// value is OFF):
	//
	// OFF
	//
	// Training jobs launched by the hyperparameter tuning job do not use early
	// stopping.
	//
	// AUTO
	//
	// Amazon SageMaker stops training jobs launched by the hyperparameter tuning
	// job when they are unlikely to perform better than previously completed training
	// jobs. For more information, see Stop Training Jobs Early (http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html).
	TrainingJobEarlyStoppingType TrainingJobEarlyStoppingType `type:"string" enum:"true"`
}

// String returns the string representation
func (s HyperParameterTuningJobConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTuningJobConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTuningJobConfig"}

	if s.ResourceLimits == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceLimits"))
	}
	if len(s.Strategy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Strategy"))
	}
	if s.HyperParameterTuningJobObjective != nil {
		if err := s.HyperParameterTuningJobObjective.Validate(); err != nil {
			invalidParams.AddNested("HyperParameterTuningJobObjective", err.(aws.ErrInvalidParams))
		}
	}
	if s.ParameterRanges != nil {
		if err := s.ParameterRanges.Validate(); err != nil {
			invalidParams.AddNested("ParameterRanges", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceLimits != nil {
		if err := s.ResourceLimits.Validate(); err != nil {
			invalidParams.AddNested("ResourceLimits", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the objective metric for a hyperparameter tuning job. Hyperparameter
// tuning uses the value of this metric to evaluate the training jobs it launches,
// and returns the training job that results in either the highest or lowest
// value for this metric, depending on the value you specify for the Type parameter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterTuningJobObjective
type HyperParameterTuningJobObjective struct {
	_ struct{} `type:"structure"`

	// The name of the metric to use for the objective metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// Whether to minimize or maximize the objective metric.
	//
	// Type is a required field
	Type HyperParameterTuningJobObjectiveType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HyperParameterTuningJobObjective) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTuningJobObjective) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTuningJobObjective"}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MetricName", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information about a hyperparameter tuning job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterTuningJobSummary
type HyperParameterTuningJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the tuning job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The date and time that the tuning job ended.
	HyperParameterTuningEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the tuning job.
	//
	// HyperParameterTuningJobArn is a required field
	HyperParameterTuningJobArn *string `type:"string" required:"true"`

	// The name of the tuning job.
	//
	// HyperParameterTuningJobName is a required field
	HyperParameterTuningJobName *string `min:"1" type:"string" required:"true"`

	// The status of the tuning job.
	//
	// HyperParameterTuningJobStatus is a required field
	HyperParameterTuningJobStatus HyperParameterTuningJobStatus `type:"string" required:"true" enum:"true"`

	// The date and time that the tuning job was modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ObjectiveStatusCounters object that specifies the numbers of training
	// jobs, categorized by objective metric status, that this tuning job launched.
	//
	// ObjectiveStatusCounters is a required field
	ObjectiveStatusCounters *ObjectiveStatusCounters `type:"structure" required:"true"`

	// The ResourceLimits object that specifies the maximum number of training jobs
	// and parallel training jobs allowed for this tuning job.
	ResourceLimits *ResourceLimits `type:"structure"`

	// Specifies the search strategy hyperparameter tuning uses to choose which
	// hyperparameters to use for each iteration. Currently, the only valid value
	// is Bayesian.
	//
	// Strategy is a required field
	Strategy HyperParameterTuningJobStrategyType `type:"string" required:"true" enum:"true"`

	// The TrainingJobStatusCounters object that specifies the numbers of training
	// jobs, categorized by status, that this tuning job launched.
	//
	// TrainingJobStatusCounters is a required field
	TrainingJobStatusCounters *TrainingJobStatusCounters `type:"structure" required:"true"`
}

// String returns the string representation
func (s HyperParameterTuningJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Specifies the configuration for a hyperparameter tuning job that uses one
// or more previous hyperparameter tuning jobs as a starting point. The results
// of previous tuning jobs are used to inform which combinations of hyperparameters
// to search over in the new tuning job.
//
// All training jobs launched by the new hyperparameter tuning job are evaluated
// by using the objective metric, and the training job that performs the best
// is compared to the best training jobs from the parent tuning jobs. From these,
// the training job that performs the best as measured by the objective metric
// is returned as the overall best training job.
//
// All training jobs launched by parent hyperparameter tuning jobs and the new
// hyperparameter tuning jobs count against the limit of training jobs for the
// tuning job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterTuningJobWarmStartConfig
type HyperParameterTuningJobWarmStartConfig struct {
	_ struct{} `type:"structure"`

	// An array of hyperparameter tuning jobs that are used as the starting point
	// for the new hyperparameter tuning job. For more information about warm starting
	// a hyperparameter tuning job, see Using a Previous Hyperparameter Tuning Job
	// as a Starting Point (http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-warm-start.html).
	//
	// Hyperparameter tuning jobs created before October 1, 2018 cannot be used
	// as parent jobs for warm start tuning jobs.
	//
	// ParentHyperParameterTuningJobs is a required field
	ParentHyperParameterTuningJobs []ParentHyperParameterTuningJob `min:"1" type:"list" required:"true"`

	// Specifies one of the following:
	//
	// IDENTICAL_DATA_AND_ALGORITHM
	//
	// The new hyperparameter tuning job uses the same input data and training image
	// as the parent tuning jobs. You can change the hyperparameter ranges to search
	// and the maximum number of training jobs that the hyperparameter tuning job
	// launches. You cannot use a new version of the training algorithm, unless
	// the changes in the new version do not affect the algorithm itself. For example,
	// changes that improve logging or adding support for a different data format
	// are allowed. You can also change hyperparameters from tunable to static,
	// and from static to tunable, but the total number of static plus tunable hyperparameters
	// must remain the same as it is in all parent jobs. The objective metric for
	// the new tuning job must be the same as for all parent jobs.
	//
	// TRANSFER_LEARNING
	//
	// The new hyperparameter tuning job can include input data, hyperparameter
	// ranges, maximum number of concurrent training jobs, and maximum number of
	// training jobs that are different than those of its parent hyperparameter
	// tuning jobs. The training image can also be a different version from the
	// version used in the parent hyperparameter tuning job. You can also change
	// hyperparameters from tunable to static, and from static to tunable, but the
	// total number of static plus tunable hyperparameters must remain the same
	// as it is in all parent jobs. The objective metric for the new tuning job
	// must be the same as for all parent jobs.
	//
	// WarmStartType is a required field
	WarmStartType HyperParameterTuningJobWarmStartType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HyperParameterTuningJobWarmStartConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTuningJobWarmStartConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTuningJobWarmStartConfig"}

	if s.ParentHyperParameterTuningJobs == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParentHyperParameterTuningJobs"))
	}
	if s.ParentHyperParameterTuningJobs != nil && len(s.ParentHyperParameterTuningJobs) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParentHyperParameterTuningJobs", 1))
	}
	if len(s.WarmStartType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("WarmStartType"))
	}
	if s.ParentHyperParameterTuningJobs != nil {
		for i, v := range s.ParentHyperParameterTuningJobs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParentHyperParameterTuningJobs", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines how to perform inference generation after a training job is run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/InferenceSpecification
type InferenceSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon ECR registry path of the Docker image that contains the inference
	// code.
	//
	// Containers is a required field
	Containers []ModelPackageContainerDefinition `min:"1" type:"list" required:"true"`

	// The supported MIME types for the input data.
	//
	// SupportedContentTypes is a required field
	SupportedContentTypes []string `type:"list" required:"true"`

	// A list of the instance types that are used to generate inferences in real-time.
	//
	// SupportedRealtimeInferenceInstanceTypes is a required field
	SupportedRealtimeInferenceInstanceTypes []ProductionVariantInstanceType `type:"list" required:"true"`

	// The supported MIME types for the output data.
	//
	// SupportedResponseMIMETypes is a required field
	SupportedResponseMIMETypes []string `type:"list" required:"true"`

	// A list of the instance types on which a transformation job can be run or
	// on which an endpoint can be deployed.
	//
	// SupportedTransformInstanceTypes is a required field
	SupportedTransformInstanceTypes []TransformInstanceType `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InferenceSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferenceSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InferenceSpecification"}

	if s.Containers == nil {
		invalidParams.Add(aws.NewErrParamRequired("Containers"))
	}
	if s.Containers != nil && len(s.Containers) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Containers", 1))
	}

	if s.SupportedContentTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedContentTypes"))
	}

	if s.SupportedRealtimeInferenceInstanceTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedRealtimeInferenceInstanceTypes"))
	}

	if s.SupportedResponseMIMETypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedResponseMIMETypes"))
	}

	if s.SupportedTransformInstanceTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedTransformInstanceTypes"))
	}
	if s.SupportedTransformInstanceTypes != nil && len(s.SupportedTransformInstanceTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SupportedTransformInstanceTypes", 1))
	}
	if s.Containers != nil {
		for i, v := range s.Containers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Containers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about the location of input model artifacts, the name
// and shape of the expected data inputs, and the framework in which the model
// was trained.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/InputConfig
type InputConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the name and shape of the expected data inputs for your trained
	// model with a JSON dictionary form. The data inputs are InputConfig$Framework
	// specific.
	//
	//    * TensorFlow: You must specify the name and shape (NHWC format) of the
	//    expected data inputs using a dictionary format for your trained model.
	//    The dictionary formats required for the console and CLI are different.
	//    Examples for one input: If using the console, {"input":[1,1024,1024,3]}
	//    If using the CLI, {\"input\":[1,1024,1024,3]} Examples for two inputs:
	//    If using the console, {"data1": [1,28,28,1], "data2":[1,28,28,1]} If using
	//    the CLI, {\"data1\": [1,28,28,1], \"data2\":[1,28,28,1]}
	//
	//    * MXNET/ONNX: You must specify the name and shape (NCHW format) of the
	//    expected data inputs in order using a dictionary format for your trained
	//    model. The dictionary formats required for the console and CLI are different.
	//    Examples for one input: If using the console, {"data":[1,3,1024,1024]}
	//    If using the CLI, {\"data\":[1,3,1024,1024]} Examples for two inputs:
	//    If using the console, {"var1": [1,1,28,28], "var2":[1,1,28,28]} If using
	//    the CLI, {\"var1\": [1,1,28,28], \"var2\":[1,1,28,28]}
	//
	//    * PyTorch: You can either specify the name and shape (NCHW format) of
	//    expected data inputs in order using a dictionary format for your trained
	//    model or you can specify the shape only using a list format. The dictionary
	//    formats required for the console and CLI are different. The list formats
	//    for the console and CLI are the same. Examples for one input in dictionary
	//    format: If using the console, {"input0":[1,3,224,224]} If using the CLI,
	//    {\"input0\":[1,3,224,224]} Example for one input in list format: [[1,3,224,224]]
	//    Examples for two inputs in dictionary format: If using the console, {"input0":[1,3,224,224],
	//    "input1":[1,3,224,224]} If using the CLI, {\"input0\":[1,3,224,224], \"input1\":[1,3,224,224]}
	//    Example for two inputs in list format: [[1,3,224,224], [1,3,224,224]]
	//
	//    * XGBOOST: input data name and shape are not needed.
	//
	// DataInputConfig is a required field
	DataInputConfig *string `min:"1" type:"string" required:"true"`

	// Identifies the framework in which the model was trained. For example: TENSORFLOW.
	//
	// Framework is a required field
	Framework Framework `type:"string" required:"true" enum:"true"`

	// The S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix).
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputConfig"}

	if s.DataInputConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataInputConfig"))
	}
	if s.DataInputConfig != nil && len(*s.DataInputConfig) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataInputConfig", 1))
	}
	if len(s.Framework) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Framework"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For a hyperparameter of the integer type, specifies the range that a hyperparameter
// tuning job searches.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/IntegerParameterRange
type IntegerParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum value of the hyperparameter to search.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum value of the hyperparameter to search.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`

	// The name of the hyperparameter to search.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (http://docs.aws.amazon.com//sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	//
	// Auto
	//
	// Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparemeter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have only values greater than
	// 0.
	ScalingType HyperParameterScalingType `type:"string" enum:"true"`
}

// String returns the string representation
func (s IntegerParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IntegerParameterRange"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the possible values for an integer hyperparameter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/IntegerParameterRangeSpecification
type IntegerParameterRangeSpecification struct {
	_ struct{} `type:"structure"`

	// The maximum integer value allowed.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum integer value allowed.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IntegerParameterRangeSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerParameterRangeSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IntegerParameterRangeSpecification"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a breakdown of the number of objects labeled.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelCounters
type LabelCounters struct {
	_ struct{} `type:"structure"`

	// The total number of objects that could not be labeled due to an error.
	FailedNonRetryableError *int64 `type:"integer"`

	// The total number of objects labeled by a human worker.
	HumanLabeled *int64 `type:"integer"`

	// The total number of objects labeled by automated data labeling.
	MachineLabeled *int64 `type:"integer"`

	// The total number of objects labeled.
	TotalLabeled *int64 `type:"integer"`

	// The total number of objects not yet labeled.
	Unlabeled *int64 `type:"integer"`
}

// String returns the string representation
func (s LabelCounters) String() string {
	return awsutil.Prettify(s)
}

// Provides counts for human-labeled tasks in the labeling job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelCountersForWorkteam
type LabelCountersForWorkteam struct {
	_ struct{} `type:"structure"`

	// The total number of data objects labeled by a human worker.
	HumanLabeled *int64 `type:"integer"`

	// The total number of data objects that need to be labeled by a human worker.
	PendingHuman *int64 `type:"integer"`

	// The total number of tasks in the labeling job.
	Total *int64 `type:"integer"`
}

// String returns the string representation
func (s LabelCountersForWorkteam) String() string {
	return awsutil.Prettify(s)
}

// Provides configuration information for auto-labeling of your data objects.
// A LabelingJobAlgorithmsConfig object must be supplied in order to use auto-labeling.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobAlgorithmsConfig
type LabelingJobAlgorithmsConfig struct {
	_ struct{} `type:"structure"`

	// At the end of an auto-label job Amazon SageMaker Ground Truth sends the Amazon
	// Resource Nam (ARN) of the final model used for auto-labeling. You can use
	// this model as the starting point for subsequent similar jobs by providing
	// the ARN of the model here.
	InitialActiveLearningModelArn *string `min:"20" type:"string"`

	// Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling.
	// You must select one of the following ARNs:
	//
	//    * Image classification arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/image-classification
	//
	//    * Text classification arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/text-classification
	//
	//    * Object detection arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/object-detection
	//
	// LabelingJobAlgorithmSpecificationArn is a required field
	LabelingJobAlgorithmSpecificationArn *string `type:"string" required:"true"`

	// Provides configuration information for a labeling job.
	LabelingJobResourceConfig *LabelingJobResourceConfig `type:"structure"`
}

// String returns the string representation
func (s LabelingJobAlgorithmsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobAlgorithmsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobAlgorithmsConfig"}
	if s.InitialActiveLearningModelArn != nil && len(*s.InitialActiveLearningModelArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("InitialActiveLearningModelArn", 20))
	}

	if s.LabelingJobAlgorithmSpecificationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LabelingJobAlgorithmSpecificationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Attributes of the data specified by the customer. Use these to describe the
// data to be labeled.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobDataAttributes
type LabelingJobDataAttributes struct {
	_ struct{} `type:"structure"`

	// Declares that your content is free of personally identifiable information
	// or adult content. Amazon SageMaker may restrict the Amazon Mechanical Turk
	// workers that can view your task based on this information.
	ContentClassifiers []ContentClassifier `type:"list"`
}

// String returns the string representation
func (s LabelingJobDataAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides information about the location of input data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobDataSource
type LabelingJobDataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the input data objects.
	//
	// S3DataSource is a required field
	S3DataSource *LabelingJobS3DataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s LabelingJobDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobDataSource"}

	if s.S3DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information for a work team.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobForWorkteamSummary
type LabelingJobForWorkteamSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the labeling job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// A unique identifier for a labeling job. You can use this to refer to a specific
	// labeling job.
	//
	// JobReferenceCode is a required field
	JobReferenceCode *string `min:"1" type:"string" required:"true"`

	// Provides information about the progress of a labeling job.
	LabelCounters *LabelCountersForWorkteam `type:"structure"`

	// The name of the labeling job that the work team is assigned to.
	LabelingJobName *string `min:"1" type:"string"`

	// The configured number of workers per data object.
	NumberOfHumanWorkersPerDataObject *int64 `min:"1" type:"integer"`

	// WorkRequesterAccountId is a required field
	WorkRequesterAccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobForWorkteamSummary) String() string {
	return awsutil.Prettify(s)
}

// Input configuration information for a labeling job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobInputConfig
type LabelingJobInputConfig struct {
	_ struct{} `type:"structure"`

	// Attributes of the data specified by the customer.
	DataAttributes *LabelingJobDataAttributes `type:"structure"`

	// The location of the input data.
	//
	// DataSource is a required field
	DataSource *LabelingJobDataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s LabelingJobInputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobInputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobInputConfig"}

	if s.DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSource"))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the location of the output produced by the labeling job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobOutput
type LabelingJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model
	// trained as part of automated data labeling.
	FinalActiveLearningModelArn *string `min:"20" type:"string"`

	// The Amazon S3 bucket location of the manifest file for labeled data.
	//
	// OutputDatasetS3Uri is a required field
	OutputDatasetS3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// Output configuration information for a labeling job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobOutputConfig
type LabelingJobOutputConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service ID of the key used to encrypt the output data,
	// if any.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 location to write output data.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobOutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobOutputConfig"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for labeling jobs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobResourceConfig
type LabelingJobResourceConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service key ID for the key used to encrypt the output
	// data, if any.
	VolumeKmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s LabelingJobResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// The Amazon S3 location of the input data objects.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobS3DataSource
type LabelingJobS3DataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the manifest file that describes the input data
	// objects.
	//
	// ManifestS3Uri is a required field
	ManifestS3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobS3DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobS3DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobS3DataSource"}

	if s.ManifestS3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("ManifestS3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A set of conditions for stopping a labeling job. If any of the conditions
// are met, the job is automatically stopped. You can use these conditions to
// control the cost of data labeling.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobStoppingConditions
type LabelingJobStoppingConditions struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that can be labeled by human workers.
	MaxHumanLabeledObjectCount *int64 `min:"1" type:"integer"`

	// The maximum number of input data objects that should be labeled.
	MaxPercentageOfInputDatasetLabeled *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s LabelingJobStoppingConditions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobStoppingConditions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobStoppingConditions"}
	if s.MaxHumanLabeledObjectCount != nil && *s.MaxHumanLabeledObjectCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxHumanLabeledObjectCount", 1))
	}
	if s.MaxPercentageOfInputDatasetLabeled != nil && *s.MaxPercentageOfInputDatasetLabeled < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxPercentageOfInputDatasetLabeled", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information about a labeling job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/LabelingJobSummary
type LabelingJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function used to consolidate
	// the annotations from individual workers into a label for a data object. For
	// more information, see Annotation Consolidation (http://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html).
	AnnotationConsolidationLambdaArn *string `type:"string"`

	// The date and time that the job was created (timestamp).
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// If the LabelingJobStatus field is Failed, this field contains a description
	// of the error.
	FailureReason *string `type:"string"`

	// Input configuration for the labeling job.
	InputConfig *LabelingJobInputConfig `type:"structure"`

	// Counts showing the progress of the labeling job.
	//
	// LabelCounters is a required field
	LabelCounters *LabelCounters `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
	//
	// LabelingJobArn is a required field
	LabelingJobArn *string `type:"string" required:"true"`

	// The name of the labeling job.
	//
	// LabelingJobName is a required field
	LabelingJobName *string `min:"1" type:"string" required:"true"`

	// The location of the output produced by the labeling job.
	LabelingJobOutput *LabelingJobOutput `type:"structure"`

	// The current status of the labeling job.
	//
	// LabelingJobStatus is a required field
	LabelingJobStatus LabelingJobStatus `type:"string" required:"true" enum:"true"`

	// The date and time that the job was last modified (timestamp).
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of a Lambda function. The function is run
	// before each data object is sent to a worker.
	//
	// PreHumanTaskLambdaArn is a required field
	PreHumanTaskLambdaArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the work team assigned to the job.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Defines the Amazon Cognito user group that is part of a work team.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/MemberDefinition
type MemberDefinition struct {
	_ struct{} `type:"structure"`

	// The Amazon Cognito user group that is part of the work team.
	CognitoMemberDefinition *CognitoMemberDefinition `type:"structure"`
}

// String returns the string representation
func (s MemberDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MemberDefinition"}
	if s.CognitoMemberDefinition != nil {
		if err := s.CognitoMemberDefinition.Validate(); err != nil {
			invalidParams.AddNested("CognitoMemberDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The name, value, and date and time of a metric that was emitted to Amazon
// CloudWatch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/MetricData
type MetricData struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	MetricName *string `min:"1" type:"string"`

	// The date and time that the algorithm emitted the metric.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The value of the metric.
	Value *float64 `type:"float"`
}

// String returns the string representation
func (s MetricData) String() string {
	return awsutil.Prettify(s)
}

// Specifies a metric that the training algorithm writes to stderr or stdout.
// Amazon SageMakerhyperparameter tuning captures all defined metrics. You specify
// one metric that a hyperparameter tuning job uses as its objective metric
// to choose the best training job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/MetricDefinition
type MetricDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A regular expression that searches the output of a training job and gets
	// the value of the metric. For more information about using regular expressions
	// to define metrics, see Defining Objective Metrics (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html).
	//
	// Regex is a required field
	Regex *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MetricDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricDefinition"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Regex == nil {
		invalidParams.Add(aws.NewErrParamRequired("Regex"))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Regex", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about the location that is configured for storing model
// artifacts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelArtifacts
type ModelArtifacts struct {
	_ struct{} `type:"structure"`

	// The path of the S3 object that contains the model artifacts. For example,
	// s3://bucket-name/keynameprefix/model.tar.gz.
	//
	// S3ModelArtifacts is a required field
	S3ModelArtifacts *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModelArtifacts) String() string {
	return awsutil.Prettify(s)
}

// Describes the Docker container for the model package.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelPackageContainerDefinition
type ModelPackageContainerDefinition struct {
	_ struct{} `type:"structure"`

	// The DNS host name for the Docker container.
	ContainerHostname *string `type:"string"`

	// The Amazon EC2 Container Registry (Amazon ECR) path where inference code
	// is stored.
	//
	// If you are using your own custom algorithm instead of an algorithm provided
	// by Amazon SageMaker, the inference code must meet Amazon SageMaker requirements.
	// Amazon SageMaker supports both registry/repository[:tag] and registry/repository[@digest]
	// image path formats. For more information, see Using Your Own Algorithms with
	// Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	//
	// Image is a required field
	Image *string `type:"string" required:"true"`

	// An MD5 hash of the training algorithm that identifies the Docker image used
	// for training.
	ImageDigest *string `type:"string"`

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix).
	ModelDataUrl *string `type:"string"`

	// The AWS Marketplace product ID of the model package.
	ProductId *string `type:"string"`
}

// String returns the string representation
func (s ModelPackageContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelPackageContainerDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelPackageContainerDefinition"}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the validation and image scan statuses of the model package.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelPackageStatusDetails
type ModelPackageStatusDetails struct {
	_ struct{} `type:"structure"`

	// The status of the scan of the Docker image container for the model package.
	ImageScanStatuses []ModelPackageStatusItem `type:"list"`

	// The validation status of the model package.
	//
	// ValidationStatuses is a required field
	ValidationStatuses []ModelPackageStatusItem `type:"list" required:"true"`
}

// String returns the string representation
func (s ModelPackageStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// Represents the overall status of a model package.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelPackageStatusItem
type ModelPackageStatusItem struct {
	_ struct{} `type:"structure"`

	// if the overall status is Failed, the reason for the failure.
	FailureReason *string `type:"string"`

	// The name of the model package for which the overall status is being reported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current status.
	//
	// Status is a required field
	Status DetailedModelPackageStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ModelPackageStatusItem) String() string {
	return awsutil.Prettify(s)
}

// Provides summary information about a model package.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelPackageSummary
type ModelPackageSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the model package was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the model package.
	//
	// ModelPackageArn is a required field
	ModelPackageArn *string `min:"1" type:"string" required:"true"`

	// A brief description of the model package.
	ModelPackageDescription *string `type:"string"`

	// The name of the model package.
	//
	// ModelPackageName is a required field
	ModelPackageName *string `min:"1" type:"string" required:"true"`

	// The overall status of the model package.
	//
	// ModelPackageStatus is a required field
	ModelPackageStatus ModelPackageStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ModelPackageSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains data, such as the inputs and targeted instance types that are used
// in the process of validating the model package.
//
// The data provided in the validation profile is made available to your buyers
// on AWS Marketplace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelPackageValidationProfile
type ModelPackageValidationProfile struct {
	_ struct{} `type:"structure"`

	// The name of the profile for the model package.
	//
	// ProfileName is a required field
	ProfileName *string `min:"1" type:"string" required:"true"`

	// The TransformJobDefinition object that describes the transform job used for
	// the validation of the model package.
	//
	// TransformJobDefinition is a required field
	TransformJobDefinition *TransformJobDefinition `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModelPackageValidationProfile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelPackageValidationProfile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelPackageValidationProfile"}

	if s.ProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfileName", 1))
	}

	if s.TransformJobDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformJobDefinition"))
	}
	if s.TransformJobDefinition != nil {
		if err := s.TransformJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TransformJobDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies batch transform jobs that Amazon SageMaker runs to validate your
// model package.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelPackageValidationSpecification
type ModelPackageValidationSpecification struct {
	_ struct{} `type:"structure"`

	// An array of ModelPackageValidationProfile objects, each of which specifies
	// a batch transform job that Amazon SageMaker runs to validate your model package.
	//
	// ValidationProfiles is a required field
	ValidationProfiles []ModelPackageValidationProfile `min:"1" type:"list" required:"true"`

	// The IAM roles to be used for the validation of the model package.
	//
	// ValidationRole is a required field
	ValidationRole *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ModelPackageValidationSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelPackageValidationSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelPackageValidationSpecification"}

	if s.ValidationProfiles == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationProfiles"))
	}
	if s.ValidationProfiles != nil && len(s.ValidationProfiles) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationProfiles", 1))
	}

	if s.ValidationRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationRole"))
	}
	if s.ValidationRole != nil && len(*s.ValidationRole) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationRole", 20))
	}
	if s.ValidationProfiles != nil {
		for i, v := range s.ValidationProfiles {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationProfiles", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information about a model.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelSummary
type ModelSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that indicates when the model was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the model.
	//
	// ModelArn is a required field
	ModelArn *string `min:"20" type:"string" required:"true"`

	// The name of the model that you want a summary for.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModelSummary) String() string {
	return awsutil.Prettify(s)
}

// Defines a list of NestedFilters objects. To satisfy the conditions specified
// in the NestedFilters call, a resource must satisfy the conditions of all
// of the filters.
//
// For example, you could define a NestedFilters using the training job's InputDataConfig
// property to filter on Channel objects.
//
// A NestedFilters object contains multiple filters. For example, to find all
// training jobs whose name contains train and that have cat/data in their S3Uri
// (specified in InputDataConfig), you need to create a NestedFilters object
// that specifies the InputDataConfig property with the following Filter objects:
//
//    * '{Name:"InputDataConfig.ChannelName", "Operator":"EQUALS", "Value":"train"}',
//
//    * '{Name:"InputDataConfig.DataSource.S3DataSource.S3Uri", "Operator":"CONTAINS",
//    "Value":"cat/data"}'
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/NestedFilters
type NestedFilters struct {
	_ struct{} `type:"structure"`

	// A list of filters. Each filter acts on a property. Filters must contain at
	// least one Filters value. For example, a NestedFilters call might include
	// a filter on the PropertyName parameter of the InputDataConfig property: InputDataConfig.DataSource.S3DataSource.S3Uri.
	//
	// Filters is a required field
	Filters []Filter `min:"1" type:"list" required:"true"`

	// The name of the property to use in the nested filters. The value must match
	// a listed property name, such as InputDataConfig.
	//
	// NestedPropertyName is a required field
	NestedPropertyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s NestedFilters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NestedFilters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NestedFilters"}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}

	if s.NestedPropertyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NestedPropertyName"))
	}
	if s.NestedPropertyName != nil && len(*s.NestedPropertyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NestedPropertyName", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a summary of a notebook instance lifecycle configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/NotebookInstanceLifecycleConfigSummary
type NotebookInstanceLifecycleConfigSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that tells when the lifecycle configuration was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A timestamp that tells when the lifecycle configuration was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigArn is a required field
	NotebookInstanceLifecycleConfigArn *string `type:"string" required:"true"`

	// The name of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NotebookInstanceLifecycleConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains the notebook instance lifecycle configuration script.
//
// Each lifecycle configuration script has a limit of 16384 characters.
//
// The value of the $PATH environment variable that is available to both scripts
// is /sbin:bin:/usr/sbin:/usr/bin.
//
// View CloudWatch Logs for notebook instance lifecycle configurations in log
// group /aws/sagemaker/NotebookInstances in log stream [notebook-instance-name]/[LifecycleConfigHook].
//
// Lifecycle configuration scripts cannot run for longer than 5 minutes. If
// a script runs for longer than 5 minutes, it fails and the notebook instance
// is not created or started.
//
// For information about notebook instance lifestyle configurations, see Step
// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/NotebookInstanceLifecycleHook
type NotebookInstanceLifecycleHook struct {
	_ struct{} `type:"structure"`

	// A base64-encoded string that contains a shell script for a notebook instance
	// lifecycle configuration.
	Content *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotebookInstanceLifecycleHook) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotebookInstanceLifecycleHook) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotebookInstanceLifecycleHook"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information for an Amazon SageMaker notebook instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/NotebookInstanceSummary
type NotebookInstanceSummary struct {
	_ struct{} `type:"structure"`

	// An array of up to three Git repositories associated with the notebook instance.
	// These can be either the names of Git repositories stored as resources in
	// your account, or the URL of Git repositories in AWS CodeCommit (http://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
	// or in any other Git repository. These repositories are cloned at the same
	// level as the default repository of your notebook instance. For more information,
	// see Associating Git Repositories with Amazon SageMaker Notebook Instances
	// (http://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	AdditionalCodeRepositories []string `type:"list"`

	// A timestamp that shows when the notebook instance was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Git repository associated with the notebook instance as its default code
	// repository. This can be either the name of a Git repository stored as a resource
	// in your account, or the URL of a Git repository in AWS CodeCommit (http://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
	// or in any other Git repository. When you open a notebook instance, it opens
	// in the directory that contains this repository. For more information, see
	// Associating Git Repositories with Amazon SageMaker Notebook Instances (http://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	DefaultCodeRepository *string `min:"1" type:"string"`

	// The type of ML compute instance that the notebook instance is running on.
	InstanceType InstanceType `type:"string" enum:"true"`

	// A timestamp that shows when the notebook instance was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the notebook instance.
	//
	// NotebookInstanceArn is a required field
	NotebookInstanceArn *string `type:"string" required:"true"`

	// The name of a notebook instance lifecycle configuration associated with this
	// notebook instance.
	//
	// For information about notebook instance lifestyle configurations, see Step
	// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
	NotebookInstanceLifecycleConfigName *string `type:"string"`

	// The name of the notebook instance that you want a summary for.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`

	// The status of the notebook instance.
	NotebookInstanceStatus NotebookInstanceStatus `type:"string" enum:"true"`

	// The URL that you use to connect to the Jupyter instance running in your notebook
	// instance.
	Url *string `type:"string"`
}

// String returns the string representation
func (s NotebookInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// Configures SNS notifications of available or expiring work items for work
// teams.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/NotificationConfiguration
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN for the SNS topic to which notifications should be published.
	NotificationTopicArn *string `type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Specifies the number of training jobs that this hyperparameter tuning job
// launched, categorized by the status of their objective metric. The objective
// metric status shows whether the final objective metric for the training job
// has been evaluated by the tuning job and used in the hyperparameter tuning
// process.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ObjectiveStatusCounters
type ObjectiveStatusCounters struct {
	_ struct{} `type:"structure"`

	// The number of training jobs whose final objective metric was not evaluated
	// and used in the hyperparameter tuning process. This typically occurs when
	// the training job failed or did not emit an objective metric.
	Failed *int64 `type:"integer"`

	// The number of training jobs that are in progress and pending evaluation of
	// their final objective metric.
	Pending *int64 `type:"integer"`

	// The number of training jobs whose final objective metric was evaluated by
	// the hyperparameter tuning job and used in the hyperparameter tuning process.
	Succeeded *int64 `type:"integer"`
}

// String returns the string representation
func (s ObjectiveStatusCounters) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the output location for the compiled model and
// the device (target) that the model runs on.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/OutputConfig
type OutputConfig struct {
	_ struct{} `type:"structure"`

	// Identifies the S3 path where you want Amazon SageMaker to store the model
	// artifacts. For example, s3://bucket-name/key-name-prefix.
	//
	// S3OutputLocation is a required field
	S3OutputLocation *string `type:"string" required:"true"`

	// Identifies the device that you want to run your model on after it has been
	// compiled. For example: ml_c5.
	//
	// TargetDevice is a required field
	TargetDevice TargetDevice `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s OutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputConfig"}

	if s.S3OutputLocation == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputLocation"))
	}
	if len(s.TargetDevice) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TargetDevice"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about how to store model training results (model artifacts).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/OutputDataConfig
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt the model artifacts at rest using Amazon S3 server-side encryption.
	// The KmsKeyId can be any of the following formats:
	//
	//    * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // KMS Key Alias "alias/ExampleAlias"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key Alias "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	//
	// If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS
	// key for Amazon S3 for your role's account. For more information, see KMS-Managed
	// Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// The KMS key policy must grant permission to the IAM role that you specify
	// in your CreateTramsformJob request. For more information, see Using Key Policies
	// in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	// in the AWS Key Management Service Developer Guide.
	KmsKeyId *string `type:"string"`

	// Identifies the S3 path where you want Amazon SageMaker to store the model
	// artifacts. For example, s3://bucket-name/key-name-prefix.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputDataConfig"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the possible values for categorical, continuous, and integer hyperparameters
// to be used by an algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ParameterRange
type ParameterRange struct {
	_ struct{} `type:"structure"`

	// A CategoricalParameterRangeSpecification object that defines the possible
	// values for a categorical hyperparameter.
	CategoricalParameterRangeSpecification *CategoricalParameterRangeSpecification `type:"structure"`

	// A ContinuousParameterRangeSpecification object that defines the possible
	// values for a continuous hyperparameter.
	ContinuousParameterRangeSpecification *ContinuousParameterRangeSpecification `type:"structure"`

	// A IntegerParameterRangeSpecification object that defines the possible values
	// for an integer hyperparameter.
	IntegerParameterRangeSpecification *IntegerParameterRangeSpecification `type:"structure"`
}

// String returns the string representation
func (s ParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParameterRange"}
	if s.CategoricalParameterRangeSpecification != nil {
		if err := s.CategoricalParameterRangeSpecification.Validate(); err != nil {
			invalidParams.AddNested("CategoricalParameterRangeSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.ContinuousParameterRangeSpecification != nil {
		if err := s.ContinuousParameterRangeSpecification.Validate(); err != nil {
			invalidParams.AddNested("ContinuousParameterRangeSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.IntegerParameterRangeSpecification != nil {
		if err := s.IntegerParameterRangeSpecification.Validate(); err != nil {
			invalidParams.AddNested("IntegerParameterRangeSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies ranges of integer, continuous, and categorical hyperparameters
// that a hyperparameter tuning job searches. The hyperparameter tuning job
// launches training jobs with hyperparameter values within these ranges to
// find the combination of values that result in the training job with the best
// performance as measured by the objective metric of the hyperparameter tuning
// job.
//
// You can specify a maximum of 20 hyperparameters that a hyperparameter tuning
// job can search over. Every possible value of a categorical parameter range
// counts against this limit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ParameterRanges
type ParameterRanges struct {
	_ struct{} `type:"structure"`

	// The array of CategoricalParameterRange objects that specify ranges of categorical
	// hyperparameters that a hyperparameter tuning job searches.
	CategoricalParameterRanges []CategoricalParameterRange `type:"list"`

	// The array of ContinuousParameterRange objects that specify ranges of continuous
	// hyperparameters that a hyperparameter tuning job searches.
	ContinuousParameterRanges []ContinuousParameterRange `type:"list"`

	// The array of IntegerParameterRange objects that specify ranges of integer
	// hyperparameters that a hyperparameter tuning job searches.
	IntegerParameterRanges []IntegerParameterRange `type:"list"`
}

// String returns the string representation
func (s ParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterRanges) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParameterRanges"}
	if s.CategoricalParameterRanges != nil {
		for i, v := range s.CategoricalParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CategoricalParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ContinuousParameterRanges != nil {
		for i, v := range s.ContinuousParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContinuousParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.IntegerParameterRanges != nil {
		for i, v := range s.IntegerParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A previously completed or stopped hyperparameter tuning job to be used as
// a starting point for a new hyperparameter tuning job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ParentHyperParameterTuningJob
type ParentHyperParameterTuningJob struct {
	_ struct{} `type:"structure"`

	// The name of the hyperparameter tuning job to be used as a starting point
	// for a new hyperparameter tuning job.
	HyperParameterTuningJobName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ParentHyperParameterTuningJob) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParentHyperParameterTuningJob) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParentHyperParameterTuningJob"}
	if s.HyperParameterTuningJobName != nil && len(*s.HyperParameterTuningJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HyperParameterTuningJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies a model that you want to host and the resources to deploy for
// hosting it. If you are deploying multiple models, tell Amazon SageMaker how
// to distribute traffic among the models by specifying variant weights.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ProductionVariant
type ProductionVariant struct {
	_ struct{} `type:"structure"`

	// The size of the Elastic Inference (EI) instance to use for the production
	// variant. EI instances provide on-demand GPU computing for inference. For
	// more information, see Using Elastic Inference in Amazon SageMaker (http://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
	// For more information, see Using Elastic Inference in Amazon SageMaker (http://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
	AcceleratorType ProductionVariantAcceleratorType `type:"string" enum:"true"`

	// Number of instances to launch initially.
	//
	// InitialInstanceCount is a required field
	InitialInstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// Determines initial traffic distribution among all of the models that you
	// specify in the endpoint configuration. The traffic to a production variant
	// is determined by the ratio of the VariantWeight to the sum of all VariantWeight
	// values across all ProductionVariants. If unspecified, it defaults to 1.0.
	InitialVariantWeight *float64 `type:"float"`

	// The ML compute instance type.
	//
	// InstanceType is a required field
	InstanceType ProductionVariantInstanceType `type:"string" required:"true" enum:"true"`

	// The name of the model that you want to host. This is the name that you specified
	// when creating the model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// The name of the production variant.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProductionVariant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProductionVariant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProductionVariant"}

	if s.InitialInstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InitialInstanceCount"))
	}
	if s.InitialInstanceCount != nil && *s.InitialInstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InitialInstanceCount", 1))
	}
	if len(s.InstanceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if s.ModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelName"))
	}

	if s.VariantName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VariantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes weight and capacities for a production variant associated with
// an endpoint. If you sent a request to the UpdateEndpointWeightsAndCapacities
// API and the endpoint status is Updating, you get different desired and current
// values.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ProductionVariantSummary
type ProductionVariantSummary struct {
	_ struct{} `type:"structure"`

	// The number of instances associated with the variant.
	CurrentInstanceCount *int64 `min:"1" type:"integer"`

	// The weight associated with the variant.
	CurrentWeight *float64 `type:"float"`

	// An array of DeployedImage objects that specify the Amazon EC2 Container Registry
	// paths of the inference images deployed on instances of this ProductionVariant.
	DeployedImages []DeployedImage `type:"list"`

	// The number of instances requested in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredInstanceCount *int64 `min:"1" type:"integer"`

	// The requested weight, as specified in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredWeight *float64 `type:"float"`

	// The name of the variant.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProductionVariantSummary) String() string {
	return awsutil.Prettify(s)
}

// A type of SuggestionQuery. A suggestion query for retrieving property names
// that match the specified hint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/PropertyNameQuery
type PropertyNameQuery struct {
	_ struct{} `type:"structure"`

	// Text that is part of a property's name. The property names of hyperparameter,
	// metric, and tag key names that begin with the specified text in the PropertyNameHint.
	//
	// PropertyNameHint is a required field
	PropertyNameHint *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PropertyNameQuery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyNameQuery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PropertyNameQuery"}

	if s.PropertyNameHint == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyNameHint"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A property name returned from a GetSearchSuggestions call that specifies
// a value in the PropertyNameQuery field.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/PropertyNameSuggestion
type PropertyNameSuggestion struct {
	_ struct{} `type:"structure"`

	// A suggested property name based on what you entered in the search textbox
	// in the Amazon SageMaker console.
	PropertyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PropertyNameSuggestion) String() string {
	return awsutil.Prettify(s)
}

// Defines the amount of money paid to an Amazon Mechanical Turk worker for
// each task performed.
//
// Use one of the following prices for bounding box tasks. Prices are in US
// dollars.
//
//    * 0.036
//
//    * 0.048
//
//    * 0.060
//
//    * 0.072
//
//    * 0.120
//
//    * 0.240
//
//    * 0.360
//
//    * 0.480
//
//    * 0.600
//
//    * 0.720
//
//    * 0.840
//
//    * 0.960
//
//    * 1.080
//
//    * 1.200
//
// Use one of the following prices for image classification, text classification,
// and custom tasks. Prices are in US dollars.
//
//    * 0.012
//
//    * 0.024
//
//    * 0.036
//
//    * 0.048
//
//    * 0.060
//
//    * 0.072
//
//    * 0.120
//
//    * 0.240
//
//    * 0.360
//
//    * 0.480
//
//    * 0.600
//
//    * 0.720
//
//    * 0.840
//
//    * 0.960
//
//    * 1.080
//
//    * 1.200
//
// Use one of the following prices for semantic segmentation tasks. Prices are
// in US dollars.
//
//    * 0.840
//
//    * 0.960
//
//    * 1.080
//
//    * 1.200
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/PublicWorkforceTaskPrice
type PublicWorkforceTaskPrice struct {
	_ struct{} `type:"structure"`

	// Defines the amount of money paid to a worker in United States dollars.
	AmountInUsd *USD `type:"structure"`
}

// String returns the string representation
func (s PublicWorkforceTaskPrice) String() string {
	return awsutil.Prettify(s)
}

// Contains input values for a task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderableTask
type RenderableTask struct {
	_ struct{} `type:"structure"`

	// A JSON object that contains values for the variables defined in the template.
	// It is made available to the template under the substitution variable task.input.
	// For example, if you define a variable task.input.text in your template, you
	// can supply the variable in the JSON object as "text": "sample text".
	//
	// Input is a required field
	Input *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s RenderableTask) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenderableTask) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RenderableTask"}

	if s.Input == nil {
		invalidParams.Add(aws.NewErrParamRequired("Input"))
	}
	if s.Input != nil && len(*s.Input) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Input", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A description of an error that occurred while rendering the template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderingError
type RenderingError struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a specific class of errors.
	//
	// Code is a required field
	Code *string `type:"string" required:"true"`

	// A human-readable message describing the error.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RenderingError) String() string {
	return awsutil.Prettify(s)
}

// Describes the resources, including ML compute instances and ML storage volumes,
// to use for model training.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ResourceConfig
type ResourceConfig struct {
	_ struct{} `type:"structure"`

	// The number of ML compute instances to use. For distributed training, provide
	// a value greater than 1.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// The ML compute instance type.
	//
	// InstanceType is a required field
	InstanceType TrainingInstanceType `type:"string" required:"true" enum:"true"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt data on the storage volume attached to the ML compute instance(s)
	// that run the training job. The VolumeKmsKeyId can be any of the following
	// formats:
	//
	//    * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// The size of the ML storage volume that you want to provision.
	//
	// ML storage volumes store model artifacts and incremental states. Training
	// algorithms might also use the ML storage volume for scratch space. If you
	// want to store the training data in the ML storage volume, choose File as
	// the TrainingInputMode in the algorithm specification.
	//
	// You must specify sufficient ML storage for your scenario.
	//
	// Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume
	// type.
	//
	// VolumeSizeInGB is a required field
	VolumeSizeInGB *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceConfig"}

	if s.InstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InstanceCount", 1))
	}
	if len(s.InstanceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if s.VolumeSizeInGB == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeSizeInGB"))
	}
	if s.VolumeSizeInGB != nil && *s.VolumeSizeInGB < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSizeInGB", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the maximum number of training jobs and parallel training jobs
// that a hyperparameter tuning job can launch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ResourceLimits
type ResourceLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of training jobs that a hyperparameter tuning job can
	// launch.
	//
	// MaxNumberOfTrainingJobs is a required field
	MaxNumberOfTrainingJobs *int64 `min:"1" type:"integer" required:"true"`

	// The maximum number of concurrent training jobs that a hyperparameter tuning
	// job can launch.
	//
	// MaxParallelTrainingJobs is a required field
	MaxParallelTrainingJobs *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ResourceLimits) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceLimits) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceLimits"}

	if s.MaxNumberOfTrainingJobs == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxNumberOfTrainingJobs"))
	}
	if s.MaxNumberOfTrainingJobs != nil && *s.MaxNumberOfTrainingJobs < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxNumberOfTrainingJobs", 1))
	}

	if s.MaxParallelTrainingJobs == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxParallelTrainingJobs"))
	}
	if s.MaxParallelTrainingJobs != nil && *s.MaxParallelTrainingJobs < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxParallelTrainingJobs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the S3 data source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/S3DataSource
type S3DataSource struct {
	_ struct{} `type:"structure"`

	// A list of one or more attribute names to use that are found in a specified
	// augmented manifest file.
	AttributeNames []string `type:"list"`

	// If you want Amazon SageMaker to replicate the entire dataset on each ML compute
	// instance that is launched for model training, specify FullyReplicated.
	//
	// If you want Amazon SageMaker to replicate a subset of data on each ML compute
	// instance that is launched for model training, specify ShardedByS3Key. If
	// there are n ML compute instances launched for a training job, each instance
	// gets approximately 1/n of the number of S3 objects. In this case, model training
	// on each machine uses only the subset of training data.
	//
	// Don't choose more ML compute instances for training than available S3 objects.
	// If you do, some nodes won't get any data and you will pay for nodes that
	// aren't getting any training data. This applies in both File and Pipe modes.
	// Keep this in mind when developing algorithms.
	//
	// In distributed training, where you use multiple ML compute EC2 instances,
	// you might choose ShardedByS3Key. If the algorithm requires copying training
	// data to the ML storage volume (when TrainingInputMode is set to File), this
	// copies 1/n of the number of objects.
	S3DataDistributionType S3DataDistribution `type:"string" enum:"true"`

	// If you choose S3Prefix, S3Uri identifies a key name prefix. Amazon SageMaker
	// uses all objects that match the specified key name prefix for model training.
	//
	// If you choose ManifestFile, S3Uri identifies an object that is a manifest
	// file containing a list of object keys that you want Amazon SageMaker to use
	// for model training.
	//
	// If you choose AugmentedManifestFile, S3Uri identifies an object that is an
	// augmented manifest file in JSON lines format. This file contains the data
	// you want to use for model training. AugmentedManifestFile can only be used
	// if the Channel's input mode is Pipe.
	//
	// S3DataType is a required field
	S3DataType S3DataType `type:"string" required:"true" enum:"true"`

	// Depending on the value specified for the S3DataType, identifies either a
	// key name prefix or a manifest. For example:
	//
	//    * A key name prefix might look like this: s3://bucketname/exampleprefix.
	//
	//    * A manifest might look like this: s3://bucketname/example.manifest The
	//    manifest is an S3 object which is a JSON file with the following format:
	//    [ {"prefix": "s3://customer_bucket/some/prefix/"}, "relative/path/to/custdata-1",
	//    "relative/path/custdata-2", ... ] The preceding JSON matches the following
	//    s3Uris: s3://customer_bucket/some/prefix/relative/path/to/custdata-1 s3://customer_bucket/some/prefix/relative/path/custdata-2
	//    ... The complete set of s3uris in this manifest is the input data for
	//    the channel for this datasource. The object that each s3uris points to
	//    must be readable by the IAM role that Amazon SageMaker uses to perform
	//    tasks on your behalf.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3DataSource"}
	if len(s.S3DataType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("S3DataType"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A multi-expression that searches for the specified resource or resources
// in a search. All resource objects that satisfy the expression's condition
// are included in the search results. You must specify at least one subexpression,
// filter, or nested filter. A SearchExpression can contain up to twenty elements.
//
// A SearchExpression contains the following components:
//
//    * A list of Filter objects. Each filter defines a simple Boolean expression
//    comprised of a resource property name, Boolean operator, and value.
//
//    * A list of NestedFilter objects. Each nested filter defines a list of
//    Boolean expressions using a list of resource properties. A nested filter
//    is satisfied if a single object in the list satisfies all Boolean expressions.
//
//    * A list of SearchExpression objects. A search expression object can be
//    nested in a list of search expression objects.
//
//    * A Boolean operator: And or Or.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/SearchExpression
type SearchExpression struct {
	_ struct{} `type:"structure"`

	// A list of filter objects.
	Filters []Filter `min:"1" type:"list"`

	// A list of nested filter objects.
	NestedFilters []NestedFilters `min:"1" type:"list"`

	// A Boolean operator used to evaluate the search expression. If you want every
	// conditional statement in all lists to be satisfied for the entire search
	// expression to be true, specify And. If only a single conditional statement
	// needs to be true for the entire search expression to be true, specify Or.
	// The default value is And.
	Operator BooleanOperator `type:"string" enum:"true"`

	// A list of search expression objects.
	SubExpressions []SearchExpression `min:"1" type:"list"`
}

// String returns the string representation
func (s SearchExpression) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchExpression) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchExpression"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.NestedFilters != nil && len(s.NestedFilters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NestedFilters", 1))
	}
	if s.SubExpressions != nil && len(s.SubExpressions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubExpressions", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.NestedFilters != nil {
		for i, v := range s.NestedFilters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NestedFilters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SubExpressions != nil {
		for i, v := range s.SubExpressions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubExpressions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An individual search result record that contains a single resource object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/SearchRecord
type SearchRecord struct {
	_ struct{} `type:"structure"`

	// A TrainingJob object that is returned as part of a Search request.
	TrainingJob *TrainingJob `type:"structure"`
}

// String returns the string representation
func (s SearchRecord) String() string {
	return awsutil.Prettify(s)
}

// An array element of DescribeTrainingJobResponse$SecondaryStatusTransitions.
// It provides additional details about a status that the training job has transitioned
// through. A training job can be in one of several states, for example, starting,
// downloading, training, or uploading. Within each state, there are a number
// of intermediate states. For example, within the starting state, Amazon SageMaker
// could be starting the training job or launching the ML instances. These transitional
// states are referred to as the job's secondary status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/SecondaryStatusTransition
type SecondaryStatusTransition struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the training job transitioned out of this secondary
	// status state into another secondary status state or when the training job
	// has ended.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A timestamp that shows when the training job transitioned to the current
	// secondary status state.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Contains a secondary status information from a training job.
	//
	// Status might be one of the following secondary statuses:
	//
	// InProgress
	//
	//    * Starting - Starting the training job.
	//
	//    * Downloading - An optional stage for algorithms that support File training
	//    input mode. It indicates that data is being downloaded to the ML storage
	//    volumes.
	//
	//    * Training - Training is in progress.
	//
	//    * Uploading - Training is complete and the model artifacts are being uploaded
	//    to the S3 location.
	//
	// Completed
	//
	//    * Completed - The training job has completed.
	//
	// Failed
	//
	//    * Failed - The training job has failed. The reason for the failure is
	//    returned in the FailureReason field of DescribeTrainingJobResponse.
	//
	// Stopped
	//
	//    * MaxRuntimeExceeded - The job stopped because it exceeded the maximum
	//    allowed runtime.
	//
	//    * Stopped - The training job has stopped.
	//
	// Stopping
	//
	//    * Stopping - Stopping the training job.
	//
	// We no longer support the following secondary statuses:
	//
	//    * LaunchingMLInstances
	//
	//    * PreparingTrainingStack
	//
	//    * DownloadingTrainingImage
	//
	// Status is a required field
	Status SecondaryStatus `type:"string" required:"true" enum:"true"`

	// A detailed description of the progress within a secondary status.
	//
	// Amazon SageMaker provides secondary statuses and status messages that apply
	// to each of them:
	//
	// Starting
	//
	//    * Starting the training job.
	//
	//    * Launching requested ML instances.
	//
	//    * Insufficient capacity error from EC2 while launching instances, retrying!
	//
	//    * Launched instance was unhealthy, replacing it!
	//
	//    * Preparing the instances for training.
	//
	// Training
	//
	//    * Downloading the training image.
	//
	//    * Training image download completed. Training in progress.
	//
	// Status messages are subject to change. Therefore, we recommend not including
	// them in code that programmatically initiates actions. For examples, don't
	// use status messages in if statements.
	//
	// To have an overview of your training job's progress, view TrainingJobStatus
	// and SecondaryStatus in DescribeTrainingJobResponse, and StatusMessage together.
	// For example, at the start of a training job, you might see the following:
	//
	//    * TrainingJobStatus - InProgress
	//
	//    * SecondaryStatus - Training
	//
	//    * StatusMessage - Downloading the training image
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s SecondaryStatusTransition) String() string {
	return awsutil.Prettify(s)
}

// A configuration for a shuffle option for input data in a channel. If you
// use S3Prefix for S3DataType, the results of the S3 key prefix matches are
// shuffled. If you use ManifestFile, the order of the S3 object references
// in the ManifestFile is shuffled. If you use AugmentedManifestFile, the order
// of the JSON lines in the AugmentedManifestFile is shuffled. The shuffling
// order is determined using the Seed value.
//
// For Pipe input mode, shuffling is done at the start of every epoch. With
// large datasets, this ensures that the order of the training data is different
// for each epoch, and it helps reduce bias and possible overfitting. In a multi-node
// training job when ShuffleConfig is combined with S3DataDistributionType of
// ShardedByS3Key, the data is shuffled across nodes so that the content sent
// to a particular node on the first epoch might be sent to a different node
// on the second epoch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ShuffleConfig
type ShuffleConfig struct {
	_ struct{} `type:"structure"`

	// Determines the shuffling order in ShuffleConfig value.
	//
	// Seed is a required field
	Seed *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s ShuffleConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShuffleConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ShuffleConfig"}

	if s.Seed == nil {
		invalidParams.Add(aws.NewErrParamRequired("Seed"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an algorithm that was used to create the model package. The algorithm
// must be either an algorithm resource in your Amazon SageMaker account or
// an algorithm in AWS Marketplace that you are subscribed to.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/SourceAlgorithm
type SourceAlgorithm struct {
	_ struct{} `type:"structure"`

	// The name of an algorithm that was used to create the model package. The algorithm
	// must be either an algorithm resource in your Amazon SageMaker account or
	// an algorithm in AWS Marketplace that you are subscribed to.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix).
	ModelDataUrl *string `type:"string"`
}

// String returns the string representation
func (s SourceAlgorithm) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceAlgorithm) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceAlgorithm"}

	if s.AlgorithmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlgorithmName"))
	}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlgorithmName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of algorithms that were used to create a model package.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/SourceAlgorithmSpecification
type SourceAlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// A list of the algorithms that were used to create a model package.
	//
	// SourceAlgorithms is a required field
	SourceAlgorithms []SourceAlgorithm `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s SourceAlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceAlgorithmSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceAlgorithmSpecification"}

	if s.SourceAlgorithms == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceAlgorithms"))
	}
	if s.SourceAlgorithms != nil && len(s.SourceAlgorithms) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceAlgorithms", 1))
	}
	if s.SourceAlgorithms != nil {
		for i, v := range s.SourceAlgorithms {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceAlgorithms", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies how long model training can run. When model training reaches the
// limit, Amazon SageMaker ends the training job. Use this API to cap model
// training cost.
//
// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
// delays job termination for120 seconds. Algorithms might use this 120-second
// window to save the model artifacts, so the results of training is not lost.
//
// Training algorithms provided by Amazon SageMaker automatically saves the
// intermediate results of a model training job (it is best effort case, as
// model might not be ready to save as some stages, for example training just
// started). This intermediate data is a valid model artifact. You can use it
// to create a model (CreateModel).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StoppingCondition
type StoppingCondition struct {
	_ struct{} `type:"structure"`

	// The maximum length of time, in seconds, that the training job can run. If
	// model training does not complete during this time, Amazon SageMaker ends
	// the job. If value is not specified, default value is 1 day. Maximum value
	// is 28 days.
	MaxRuntimeInSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s StoppingCondition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StoppingCondition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StoppingCondition"}
	if s.MaxRuntimeInSeconds != nil && *s.MaxRuntimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRuntimeInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a work team of a vendor that does the a labelling job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/SubscribedWorkteam
type SubscribedWorkteam struct {
	_ struct{} `type:"structure"`

	ListingId *string `type:"string"`

	// The description of the vendor from the Amazon Marketplace.
	MarketplaceDescription *string `min:"1" type:"string"`

	// The title of the service provided by the vendor in the Amazon Marketplace.
	MarketplaceTitle *string `min:"1" type:"string"`

	// The name of the vendor in the Amazon Marketplace.
	SellerName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the vendor that you have subscribed.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SubscribedWorkteam) String() string {
	return awsutil.Prettify(s)
}

// Limits the property names that are included in the response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/SuggestionQuery
type SuggestionQuery struct {
	_ struct{} `type:"structure"`

	// A type of SuggestionQuery. Defines a property name hint. Only property names
	// that match the specified hint are included in the response.
	PropertyNameQuery *PropertyNameQuery `type:"structure"`
}

// String returns the string representation
func (s SuggestionQuery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SuggestionQuery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SuggestionQuery"}
	if s.PropertyNameQuery != nil {
		if err := s.PropertyNameQuery.Validate(); err != nil {
			invalidParams.AddNested("PropertyNameQuery", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The tag value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about a training job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TrainingJob
type TrainingJob struct {
	_ struct{} `type:"structure"`

	// Information about the algorithm used for training, and algorithm metadata.
	AlgorithmSpecification *AlgorithmSpecification `type:"structure"`

	// A timestamp that indicates when the training job was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use
	// a deep learning algorithm in distributed training.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// If the TrainingJob was created with network isolation, the value is set to
	// true. If network isolation is enabled, nodes can't communicate beyond the
	// VPC they run in.
	EnableNetworkIsolation *bool `type:"boolean"`

	// If the training job failed, the reason it failed.
	FailureReason *string `type:"string"`

	// A list of final metric values that are set when the training job completes.
	// Used only if the training job was configured to use metrics.
	FinalMetricDataList []MetricData `type:"list"`

	// Algorithm-specific parameters.
	HyperParameters map[string]string `type:"map"`

	// An array of Channel objects that describes each data input channel.
	InputDataConfig []Channel `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the labeling job.
	LabelingJobArn *string `type:"string"`

	// A timestamp that indicates when the status of the training job was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Information about the Amazon S3 location that is configured for storing model
	// artifacts.
	ModelArtifacts *ModelArtifacts `type:"structure"`

	// The S3 path where model artifacts that you configured when creating the job
	// are stored. Amazon SageMaker creates subfolders for model artifacts.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// Resources, including ML compute instances and ML storage volumes, that are
	// configured for model training.
	ResourceConfig *ResourceConfig `type:"structure"`

	// The AWS Identity and Access Management (IAM) role configured for the training
	// job.
	RoleArn *string `min:"20" type:"string"`

	// Provides detailed information about the state of the training job. For detailed
	// information about the secondary status of the training job, see StatusMessage
	// under SecondaryStatusTransition.
	//
	// Amazon SageMaker provides primary statuses and secondary statuses that apply
	// to each of them:
	//
	// InProgress
	//
	//    * Starting - Starting the training job.
	//
	//    * Downloading - An optional stage for algorithms that support File training
	//    input mode. It indicates that data is being downloaded to the ML storage
	//    volumes.
	//
	//    * Training - Training is in progress.
	//
	//    * Uploading - Training is complete and the model artifacts are being uploaded
	//    to the S3 location.
	//
	// Completed
	//
	//    * Completed - The training job has completed.
	//
	// Failed
	//
	//    * Failed - The training job has failed. The reason for the failure is
	//    returned in the FailureReason field of DescribeTrainingJobResponse.
	//
	// Stopped
	//
	//    * MaxRuntimeExceeded - The job stopped because it exceeded the maximum
	//    allowed runtime.
	//
	//    * Stopped - The training job has stopped.
	//
	// Stopping
	//
	//    * Stopping - Stopping the training job.
	//
	// Valid values for SecondaryStatus are subject to change.
	//
	// We no longer support the following secondary statuses:
	//
	//    * LaunchingMLInstances
	//
	//    * PreparingTrainingStack
	//
	//    * DownloadingTrainingImage
	SecondaryStatus SecondaryStatus `type:"string" enum:"true"`

	// A history of all of the secondary statuses that the training job has transitioned
	// through.
	SecondaryStatusTransitions []SecondaryStatusTransition `type:"list"`

	// The condition under which to stop the training job.
	StoppingCondition *StoppingCondition `type:"structure"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []Tag `type:"list"`

	// Indicates the time when the training job ends on training instances. You
	// are billed for the time interval between the value of TrainingStartTime and
	// this time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker
	// detects a job failure.
	TrainingEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the training job.
	TrainingJobArn *string `type:"string"`

	// The name of the training job.
	TrainingJobName *string `min:"1" type:"string"`

	// The status of the training job.
	//
	// Training job statuses are:
	//
	//    * InProgress - The training is in progress.
	//
	//    * Completed - The training job has completed.
	//
	//    * Failed - The training job has failed. To see the reason for the failure,
	//    see the FailureReason field in the response to a DescribeTrainingJobResponse
	//    call.
	//
	//    * Stopping - The training job is stopping.
	//
	//    * Stopped - The training job has stopped.
	//
	// For more detailed information, see SecondaryStatus.
	TrainingJobStatus TrainingJobStatus `type:"string" enum:"true"`

	// Indicates the time when the training job starts on training instances. You
	// are billed for the time interval between this time and the value of TrainingEndTime.
	// The start time in CloudWatch Logs might be later than this time. The difference
	// is due to the time it takes to download the training data and to the size
	// of the training container.
	TrainingStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the associated hyperparameter tuning job
	// if the training job was launched by a hyperparameter tuning job.
	TuningJobArn *string `type:"string"`

	// A VpcConfig object that specifies the VPC that this training job has access
	// to. For more information, see Protect Training Jobs by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s TrainingJob) String() string {
	return awsutil.Prettify(s)
}

// Defines the input needed to run a training job using the algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TrainingJobDefinition
type TrainingJobDefinition struct {
	_ struct{} `type:"structure"`

	// The hyperparameters used for the training job.
	HyperParameters map[string]string `type:"map"`

	// An array of Channel objects, each of which specifies an input source.
	//
	// InputDataConfig is a required field
	InputDataConfig []Channel `min:"1" type:"list" required:"true"`

	// the path to the S3 bucket where you want to store model artifacts. Amazon
	// SageMaker creates subfolders for the artifacts.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The resources, including the ML compute instances and ML storage volumes,
	// to use for model training.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// Sets a duration for training. Use this parameter to cap model training costs.
	//
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms might use this 120-second
	// window to save the model artifacts.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// The input mode used by the algorithm for the training job. For the input
	// modes that Amazon SageMaker algorithms support, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	//
	// If an algorithm supports the File input mode, Amazon SageMaker downloads
	// the training data from S3 to the provisioned ML storage Volume, and mounts
	// the directory to docker volume for training container. If an algorithm supports
	// the Pipe input mode, Amazon SageMaker streams data directly from S3 to the
	// container.
	//
	// TrainingInputMode is a required field
	TrainingInputMode TrainingInputMode `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TrainingJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingJobDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrainingJobDefinition"}

	if s.InputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputDataConfig"))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputDataConfig", 1))
	}

	if s.OutputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputDataConfig"))
	}

	if s.ResourceConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceConfig"))
	}

	if s.StoppingCondition == nil {
		invalidParams.Add(aws.NewErrParamRequired("StoppingCondition"))
	}
	if len(s.TrainingInputMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TrainingInputMode"))
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The numbers of training jobs launched by a hyperparameter tuning job, categorized
// by status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TrainingJobStatusCounters
type TrainingJobStatusCounters struct {
	_ struct{} `type:"structure"`

	// The number of completed training jobs launched by the hyperparameter tuning
	// job.
	Completed *int64 `type:"integer"`

	// The number of in-progress training jobs launched by a hyperparameter tuning
	// job.
	InProgress *int64 `type:"integer"`

	// The number of training jobs that failed and can't be retried. A failed training
	// job can't be retried if it failed because a client error occurred.
	NonRetryableError *int64 `type:"integer"`

	// The number of training jobs that failed, but can be retried. A failed training
	// job can be retried only if it failed because an internal service error occurred.
	RetryableError *int64 `type:"integer"`

	// The number of training jobs launched by a hyperparameter tuning job that
	// were manually stopped.
	Stopped *int64 `type:"integer"`
}

// String returns the string representation
func (s TrainingJobStatusCounters) String() string {
	return awsutil.Prettify(s)
}

// Provides summary information about a training job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TrainingJobSummary
type TrainingJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the training job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Timestamp when the training job was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A timestamp that shows when the training job ended. This field is set only
	// if the training job has one of the terminal statuses (Completed, Failed,
	// or Stopped).
	TrainingEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`

	// The name of the training job that you want a summary for.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the training job.
	//
	// TrainingJobStatus is a required field
	TrainingJobStatus TrainingJobStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TrainingJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Defines how the algorithm is used for a training job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TrainingSpecification
type TrainingSpecification struct {
	_ struct{} `type:"structure"`

	// A list of MetricDefinition objects, which are used for parsing metrics generated
	// by the algorithm.
	MetricDefinitions []MetricDefinition `type:"list"`

	// A list of the HyperParameterSpecification objects, that define the supported
	// hyperparameters. This is required if the algorithm supports automatic model
	// tuning.>
	SupportedHyperParameters []HyperParameterSpecification `type:"list"`

	// A list of the instance types that this algorithm can use for training.
	//
	// SupportedTrainingInstanceTypes is a required field
	SupportedTrainingInstanceTypes []TrainingInstanceType `type:"list" required:"true"`

	// A list of the metrics that the algorithm emits that can be used as the objective
	// metric in a hyperparameter tuning job.
	SupportedTuningJobObjectiveMetrics []HyperParameterTuningJobObjective `type:"list"`

	// Indicates whether the algorithm supports distributed training. If set to
	// false, buyers can’t request more than one instance during training.
	SupportsDistributedTraining *bool `type:"boolean"`

	// A list of ChannelSpecification objects, which specify the input sources to
	// be used by the algorithm.
	//
	// TrainingChannels is a required field
	TrainingChannels []ChannelSpecification `min:"1" type:"list" required:"true"`

	// The Amazon ECR registry path of the Docker image that contains the training
	// algorithm.
	//
	// TrainingImage is a required field
	TrainingImage *string `type:"string" required:"true"`

	// An MD5 hash of the training algorithm that identifies the Docker image used
	// for training.
	TrainingImageDigest *string `type:"string"`
}

// String returns the string representation
func (s TrainingSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrainingSpecification"}

	if s.SupportedTrainingInstanceTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedTrainingInstanceTypes"))
	}

	if s.TrainingChannels == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingChannels"))
	}
	if s.TrainingChannels != nil && len(s.TrainingChannels) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrainingChannels", 1))
	}

	if s.TrainingImage == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingImage"))
	}
	if s.MetricDefinitions != nil {
		for i, v := range s.MetricDefinitions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDefinitions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SupportedHyperParameters != nil {
		for i, v := range s.SupportedHyperParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SupportedHyperParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SupportedTuningJobObjectiveMetrics != nil {
		for i, v := range s.SupportedTuningJobObjectiveMetrics {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SupportedTuningJobObjectiveMetrics", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TrainingChannels != nil {
		for i, v := range s.TrainingChannels {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TrainingChannels", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the location of the channel data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TransformDataSource
type TransformDataSource struct {
	_ struct{} `type:"structure"`

	// The S3 location of the data source that is associated with a channel.
	//
	// S3DataSource is a required field
	S3DataSource *TransformS3DataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s TransformDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformDataSource"}

	if s.S3DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the input source of a transform job and the way the transform job
// consumes it.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TransformInput
type TransformInput struct {
	_ struct{} `type:"structure"`

	// If your transform data is compressed, specify the compression type. Amazon
	// SageMaker automatically decompresses the data for the transform job accordingly.
	// The default value is None.
	CompressionType CompressionType `type:"string" enum:"true"`

	// The multipurpose internet mail extension (MIME) type of the data. Amazon
	// SageMaker uses the MIME type with each http call to transfer data to the
	// transform job.
	ContentType *string `type:"string"`

	// Describes the location of the channel data, which is, the S3 location of
	// the input data that the model can consume.
	//
	// DataSource is a required field
	DataSource *TransformDataSource `type:"structure" required:"true"`

	// The method to use to split the transform job's data files into smaller batches.
	// Splitting is necessary when the total size of each object is too large to
	// fit in a single request. You can also use data splitting to improve performance
	// by processing multiple concurrent mini-batches. The default value for SplitType
	// is None, which indicates that input data files are not split, and request
	// payloads contain the entire contents of an input object. Set the value of
	// this parameter to Line to split records on a newline character boundary.
	// SplitType also supports a number of record-oriented binary data formats.
	//
	// When splitting is enabled, the size of a mini-batch depends on the values
	// of the BatchStrategy and MaxPayloadInMB parameters. When the value of BatchStrategy
	// is MultiRecord, Amazon SageMaker sends the maximum number of records in each
	// request, up to the MaxPayloadInMB limit. If the value of BatchStrategy is
	// SingleRecord, Amazon SageMaker sends individual records in each request.
	//
	// Some data formats represent a record as a binary payload wrapped with extra
	// padding bytes. When splitting is applied to a binary data format, padding
	// is removed if the value of BatchStrategy is set to SingleRecord. Padding
	// is not removed if the value of BatchStrategy is set to MultiRecord.
	//
	// For more information about the RecordIO, see Data Format (http://mxnet.io/architecture/note_data_loading.html#data-format)
	// in the MXNet documentation. For more information about the TFRecord, see
	// Consuming TFRecord data (https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data)
	// in the TensorFlow documentation.
	SplitType SplitType `type:"string" enum:"true"`
}

// String returns the string representation
func (s TransformInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformInput"}

	if s.DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSource"))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the input needed to run a transform job using the inference specification
// specified in the algorithm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TransformJobDefinition
type TransformJobDefinition struct {
	_ struct{} `type:"structure"`

	// A string that determines the number of records included in a single mini-batch.
	//
	// SingleRecord means only one record is used per mini-batch. MultiRecord means
	// a mini-batch is set to contain as many records that can fit within the MaxPayloadInMB
	// limit.
	BatchStrategy BatchStrategy `type:"string" enum:"true"`

	// The environment variables to set in the Docker container. We support up to
	// 16 key and values entries in the map.
	Environment map[string]string `type:"map"`

	// The maximum number of parallel requests that can be sent to each instance
	// in a transform job. The default value is 1.
	MaxConcurrentTransforms *int64 `type:"integer"`

	// The maximum payload size allowed, in MB. A payload is the data portion of
	// a record (without metadata).
	MaxPayloadInMB *int64 `type:"integer"`

	// A description of the input source and the way the transform job consumes
	// it.
	//
	// TransformInput is a required field
	TransformInput *TransformInput `type:"structure" required:"true"`

	// Identifies the Amazon S3 location where you want Amazon SageMaker to save
	// the results from the transform job.
	//
	// TransformOutput is a required field
	TransformOutput *TransformOutput `type:"structure" required:"true"`

	// Identifies the ML compute instances for the transform job.
	//
	// TransformResources is a required field
	TransformResources *TransformResources `type:"structure" required:"true"`
}

// String returns the string representation
func (s TransformJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformJobDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformJobDefinition"}

	if s.TransformInput == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformInput"))
	}

	if s.TransformOutput == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformOutput"))
	}

	if s.TransformResources == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformResources"))
	}
	if s.TransformInput != nil {
		if err := s.TransformInput.Validate(); err != nil {
			invalidParams.AddNested("TransformInput", err.(aws.ErrInvalidParams))
		}
	}
	if s.TransformOutput != nil {
		if err := s.TransformOutput.Validate(); err != nil {
			invalidParams.AddNested("TransformOutput", err.(aws.ErrInvalidParams))
		}
	}
	if s.TransformResources != nil {
		if err := s.TransformResources.Validate(); err != nil {
			invalidParams.AddNested("TransformResources", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a summary of a transform job. Multiple TransformJobSummary objects
// are returned as a list after in response to a ListTransformJobs call.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TransformJobSummary
type TransformJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the transform Job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// If the transform job failed, the reason it failed.
	FailureReason *string `type:"string"`

	// Indicates when the transform job was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Indicates when the transform job ends on compute instances. For successful
	// jobs and stopped jobs, this is the exact time recorded after the results
	// are uploaded. For failed jobs, this is when Amazon SageMaker detected that
	// the job failed.
	TransformEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the transform job.
	//
	// TransformJobArn is a required field
	TransformJobArn *string `type:"string" required:"true"`

	// The name of the transform job.
	//
	// TransformJobName is a required field
	TransformJobName *string `min:"1" type:"string" required:"true"`

	// The status of the transform job.
	//
	// TransformJobStatus is a required field
	TransformJobStatus TransformJobStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TransformJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes the results of a transform job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TransformOutput
type TransformOutput struct {
	_ struct{} `type:"structure"`

	// The MIME type used to specify the output data. Amazon SageMaker uses the
	// MIME type with each http call to transfer data from the transform job.
	Accept *string `type:"string"`

	// Defines how to assemble the results of the transform job as a single S3 object.
	// Choose a format that is most convenient to you. To concatenate the results
	// in binary format, specify None. To add a newline character at the end of
	// every transformed record, specify Line.
	AssembleWith AssemblyType `type:"string" enum:"true"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt the model artifacts at rest using Amazon S3 server-side encryption.
	// The KmsKeyId can be any of the following formats:
	//
	//    * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // KMS Key Alias "alias/ExampleAlias"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key Alias "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	//
	// If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS
	// key for Amazon S3 for your role's account. For more information, see KMS-Managed
	// Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// The KMS key policy must grant permission to the IAM role that you specify
	// in your CreateTramsformJob request. For more information, see Using Key Policies
	// in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	// in the AWS Key Management Service Developer Guide.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 path where you want Amazon SageMaker to store the results of
	// the transform job. For example, s3://bucket-name/key-name-prefix.
	//
	// For every S3 object used as input for the transform job, batch transform
	// stores the transformed data with an .out suffix in a corresponding subfolder
	// in the location in the output prefix. For example, for the input data stored
	// at s3://bucket-name/input-name-prefix/dataset01/data.csv, batch transform
	// stores the transformed data at s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out.
	// Batch transform doesn't upload partially processed objects. For an input
	// S3 object that contains multiple records, it creates an .out file only if
	// the transform job succeeds on the entire file. When the input contains multiple
	// S3 objects, the batch transform job processes the listed S3 objects and uploads
	// only the output for successfully processed objects. If any object fails in
	// the transform job batch transform marks the job as failed to prompt investigation.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TransformOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformOutput"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the resources, including ML instance types and ML instance count,
// to use for transform job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TransformResources
type TransformResources struct {
	_ struct{} `type:"structure"`

	// The number of ML compute instances to use in the transform job. For distributed
	// transform, provide a value greater than 1. The default value is 1.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// The ML compute instance type for the transform job. For using built-in algorithms
	// to transform moderately sized datasets, ml.m4.xlarge or ml.m5.large should
	// suffice. There is no default value for InstanceType.
	//
	// InstanceType is a required field
	InstanceType TransformInstanceType `type:"string" required:"true" enum:"true"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt data on the storage volume attached to the ML compute instance(s)
	// that run the batch transform job. The VolumeKmsKeyId can be any of the following
	// formats:
	//
	//    * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s TransformResources) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformResources) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformResources"}

	if s.InstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InstanceCount", 1))
	}
	if len(s.InstanceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the S3 data source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TransformS3DataSource
type TransformS3DataSource struct {
	_ struct{} `type:"structure"`

	// If you choose S3Prefix, S3Uri identifies a key name prefix. Amazon SageMaker
	// uses all objects with the specified key name prefix for batch transform.
	//
	// If you choose ManifestFile, S3Uri identifies an object that is a manifest
	// file containing a list of object keys that you want Amazon SageMaker to use
	// for batch transform.
	//
	// The following values are compatible: ManifestFile, S3Prefix
	//
	// The following value is not compatible: AugmentedManifestFile
	//
	// S3DataType is a required field
	S3DataType S3DataType `type:"string" required:"true" enum:"true"`

	// Depending on the value specified for the S3DataType, identifies either a
	// key name prefix or a manifest. For example:
	//
	//    * A key name prefix might look like this: s3://bucketname/exampleprefix.
	//
	//    * A manifest might look like this: s3://bucketname/example.manifest The
	//    manifest is an S3 object which is a JSON file with the following format:
	//    [ {"prefix": "s3://customer_bucket/some/prefix/"}, "relative/path/to/custdata-1",
	//    "relative/path/custdata-2", ... ] The preceding JSON matches the following
	//    S3Uris: s3://customer_bucket/some/prefix/relative/path/to/custdata-1 s3://customer_bucket/some/prefix/relative/path/custdata-1
	//    ... The complete set of S3Uris in this manifest constitutes the input
	//    data for the channel for this datasource. The object that each S3Uris
	//    points to must be readable by the IAM role that Amazon SageMaker uses
	//    to perform tasks on your behalf.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TransformS3DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformS3DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformS3DataSource"}
	if len(s.S3DataType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("S3DataType"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents an amount of money in United States dollars/
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/USD
type USD struct {
	_ struct{} `type:"structure"`

	// The fractional portion, in cents, of the amount.
	Cents *int64 `type:"integer"`

	// The whole number of dollars in the amount.
	Dollars *int64 `type:"integer"`

	// Fractions of a cent, in tenths.
	TenthFractionsOfACent *int64 `type:"integer"`
}

// String returns the string representation
func (s USD) String() string {
	return awsutil.Prettify(s)
}

// Provided configuration information for the worker UI for a labeling job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UiConfig
type UiConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket location of the UI template. For more information about
	// the contents of a UI template, see Creating Your Custom Labeling Task Template
	// (http://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html).
	//
	// UiTemplateS3Uri is a required field
	UiTemplateS3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UiConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UiConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UiConfig"}

	if s.UiTemplateS3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("UiTemplateS3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Liquid template for the worker user interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UiTemplate
type UiTemplate struct {
	_ struct{} `type:"structure"`

	// The content of the Liquid template for the worker user interface.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UiTemplate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UiTemplate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UiTemplate"}

	if s.Content == nil {
		invalidParams.Add(aws.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a VPC that your training jobs and hosted models have access to.
// Control access to and from your training and model containers by configuring
// the VPC. For more information, see Protect Endpoints by Using an Amazon Virtual
// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
// and Protect Training Jobs by Using an Amazon Virtual Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/VpcConfig
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security
	// groups for the VPC that is specified in the Subnets field.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `min:"1" type:"list" required:"true"`

	// The ID of the subnets in the VPC to which you want to connect your training
	// job or model.
	//
	// Amazon EC2 P3 accelerated computing instances are not available in the c/d/e
	// availability zones of region us-east-1. If you want to create endpoints with
	// P3 instances in VPC mode in region us-east-1, create subnets in a/b/f availability
	// zones instead.
	//
	// Subnets is a required field
	Subnets []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VpcConfig"}

	if s.SecurityGroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityGroupIds", 1))
	}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides details about a labeling work team.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Workteam
type Workteam struct {
	_ struct{} `type:"structure"`

	// The date and time that the work team was created (timestamp).
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A description of the work team.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The date and time that the work team was last updated (timestamp).
	LastUpdatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Cognito user groups that make up the work team.
	//
	// MemberDefinitions is a required field
	MemberDefinitions []MemberDefinition `min:"1" type:"list" required:"true"`

	// Configures SNS notifications of available or expiring work items for work
	// teams.
	NotificationConfiguration *NotificationConfiguration `type:"structure"`

	// The Amazon Marketplace identifier for a vendor's work team.
	ProductListingIds []string `type:"list"`

	// The URI of the labeling job's user interface. Workers open this URI to start
	// labeling your data objects.
	SubDomain *string `type:"string"`

	// The Amazon Resource Name (ARN) that identifies the work team.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`

	// The name of the work team.
	//
	// WorkteamName is a required field
	WorkteamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Workteam) String() string {
	return awsutil.Prettify(s)
}
