// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifactInput
type AssociateServiceActionWithProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The product identifier. For example, prod-abcdzk7xy33qa.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact. For example, pa-4abcdjnxjj6ne.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`

	// The self-service action identifier. For example, act-fs7abcd89wxyz.
	//
	// ServiceActionId is a required field
	ServiceActionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateServiceActionWithProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateServiceActionWithProvisioningArtifactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateServiceActionWithProvisioningArtifactInput"}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if s.ServiceActionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceActionId"))
	}
	if s.ServiceActionId != nil && len(*s.ServiceActionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceActionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifactOutput
type AssociateServiceActionWithProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateServiceActionWithProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateServiceActionWithProvisioningArtifact = "AssociateServiceActionWithProvisioningArtifact"

// AssociateServiceActionWithProvisioningArtifactRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Associates a self-service action with a provisioning artifact.
//
//    // Example sending a request using AssociateServiceActionWithProvisioningArtifactRequest.
//    req := client.AssociateServiceActionWithProvisioningArtifactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifact
func (c *Client) AssociateServiceActionWithProvisioningArtifactRequest(input *AssociateServiceActionWithProvisioningArtifactInput) AssociateServiceActionWithProvisioningArtifactRequest {
	op := &aws.Operation{
		Name:       opAssociateServiceActionWithProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateServiceActionWithProvisioningArtifactInput{}
	}

	req := c.newRequest(op, input, &AssociateServiceActionWithProvisioningArtifactOutput{})
	return AssociateServiceActionWithProvisioningArtifactRequest{Request: req, Input: input, Copy: c.AssociateServiceActionWithProvisioningArtifactRequest}
}

// AssociateServiceActionWithProvisioningArtifactRequest is the request type for the
// AssociateServiceActionWithProvisioningArtifact API operation.
type AssociateServiceActionWithProvisioningArtifactRequest struct {
	*aws.Request
	Input *AssociateServiceActionWithProvisioningArtifactInput
	Copy  func(*AssociateServiceActionWithProvisioningArtifactInput) AssociateServiceActionWithProvisioningArtifactRequest
}

// Send marshals and sends the AssociateServiceActionWithProvisioningArtifact API request.
func (r AssociateServiceActionWithProvisioningArtifactRequest) Send(ctx context.Context) (*AssociateServiceActionWithProvisioningArtifactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateServiceActionWithProvisioningArtifactResponse{
		AssociateServiceActionWithProvisioningArtifactOutput: r.Request.Data.(*AssociateServiceActionWithProvisioningArtifactOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateServiceActionWithProvisioningArtifactResponse is the response type for the
// AssociateServiceActionWithProvisioningArtifact API operation.
type AssociateServiceActionWithProvisioningArtifactResponse struct {
	*AssociateServiceActionWithProvisioningArtifactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateServiceActionWithProvisioningArtifact request.
func (r *AssociateServiceActionWithProvisioningArtifactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
