// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceActionInput
type DescribeServiceActionInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The self-service action identifier.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeServiceActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServiceActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeServiceActionInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceActionOutput
type DescribeServiceActionOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the self-service action.
	ServiceActionDetail *ServiceActionDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceActionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeServiceAction = "DescribeServiceAction"

// DescribeServiceActionRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Describes a self-service action.
//
//    // Example sending a request using DescribeServiceActionRequest.
//    req := client.DescribeServiceActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceAction
func (c *Client) DescribeServiceActionRequest(input *DescribeServiceActionInput) DescribeServiceActionRequest {
	op := &aws.Operation{
		Name:       opDescribeServiceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServiceActionInput{}
	}

	req := c.newRequest(op, input, &DescribeServiceActionOutput{})
	return DescribeServiceActionRequest{Request: req, Input: input, Copy: c.DescribeServiceActionRequest}
}

// DescribeServiceActionRequest is the request type for the
// DescribeServiceAction API operation.
type DescribeServiceActionRequest struct {
	*aws.Request
	Input *DescribeServiceActionInput
	Copy  func(*DescribeServiceActionInput) DescribeServiceActionRequest
}

// Send marshals and sends the DescribeServiceAction API request.
func (r DescribeServiceActionRequest) Send(ctx context.Context) (*DescribeServiceActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeServiceActionResponse{
		DescribeServiceActionOutput: r.Request.Data.(*DescribeServiceActionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeServiceActionResponse is the response type for the
// DescribeServiceAction API operation.
type DescribeServiceActionResponse struct {
	*DescribeServiceActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeServiceAction request.
func (r *DescribeServiceActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
