// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to delete an IP address filter. You use IP address filters
// when you receive email with Amazon SES. For more information, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilterRequest
type DeleteReceiptFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the IP address filter to delete.
	//
	// FilterName is a required field
	FilterName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReceiptFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReceiptFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteReceiptFilterInput"}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilterResponse
type DeleteReceiptFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteReceiptFilter = "DeleteReceiptFilter"

// DeleteReceiptFilterRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Deletes the specified IP address filter.
//
// For information about managing IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using DeleteReceiptFilterRequest.
//    req := client.DeleteReceiptFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter
func (c *Client) DeleteReceiptFilterRequest(input *DeleteReceiptFilterInput) DeleteReceiptFilterRequest {
	op := &aws.Operation{
		Name:       opDeleteReceiptFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptFilterInput{}
	}

	req := c.newRequest(op, input, &DeleteReceiptFilterOutput{})
	return DeleteReceiptFilterRequest{Request: req, Input: input, Copy: c.DeleteReceiptFilterRequest}
}

// DeleteReceiptFilterRequest is the request type for the
// DeleteReceiptFilter API operation.
type DeleteReceiptFilterRequest struct {
	*aws.Request
	Input *DeleteReceiptFilterInput
	Copy  func(*DeleteReceiptFilterInput) DeleteReceiptFilterRequest
}

// Send marshals and sends the DeleteReceiptFilter API request.
func (r DeleteReceiptFilterRequest) Send(ctx context.Context) (*DeleteReceiptFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteReceiptFilterResponse{
		DeleteReceiptFilterOutput: r.Request.Data.(*DeleteReceiptFilterOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteReceiptFilterResponse is the response type for the
// DeleteReceiptFilter API operation.
type DeleteReceiptFilterResponse struct {
	*DeleteReceiptFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteReceiptFilter request.
func (r *DeleteReceiptFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
