// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Represents a request to modify the reputation metric publishing settings
// for a configuration set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabledRequest
type UpdateConfigurationSetReputationMetricsEnabledInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to update.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// Describes whether or not Amazon SES will publish reputation metrics for the
	// configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s UpdateConfigurationSetReputationMetricsEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetReputationMetricsEnabledInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateConfigurationSetReputationMetricsEnabledInput"}

	if s.ConfigurationSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationSetName"))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabledOutput
type UpdateConfigurationSetReputationMetricsEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConfigurationSetReputationMetricsEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateConfigurationSetReputationMetricsEnabled = "UpdateConfigurationSetReputationMetricsEnabled"

// UpdateConfigurationSetReputationMetricsEnabledRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Enables or disables the publishing of reputation metrics for emails sent
// using a specific configuration set in a given AWS Region. Reputation metrics
// include bounce and complaint rates. These metrics are published to Amazon
// CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint
// rates exceed certain thresholds.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using UpdateConfigurationSetReputationMetricsEnabledRequest.
//    req := client.UpdateConfigurationSetReputationMetricsEnabledRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabled
func (c *Client) UpdateConfigurationSetReputationMetricsEnabledRequest(input *UpdateConfigurationSetReputationMetricsEnabledInput) UpdateConfigurationSetReputationMetricsEnabledRequest {
	op := &aws.Operation{
		Name:       opUpdateConfigurationSetReputationMetricsEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationSetReputationMetricsEnabledInput{}
	}

	req := c.newRequest(op, input, &UpdateConfigurationSetReputationMetricsEnabledOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateConfigurationSetReputationMetricsEnabledRequest{Request: req, Input: input, Copy: c.UpdateConfigurationSetReputationMetricsEnabledRequest}
}

// UpdateConfigurationSetReputationMetricsEnabledRequest is the request type for the
// UpdateConfigurationSetReputationMetricsEnabled API operation.
type UpdateConfigurationSetReputationMetricsEnabledRequest struct {
	*aws.Request
	Input *UpdateConfigurationSetReputationMetricsEnabledInput
	Copy  func(*UpdateConfigurationSetReputationMetricsEnabledInput) UpdateConfigurationSetReputationMetricsEnabledRequest
}

// Send marshals and sends the UpdateConfigurationSetReputationMetricsEnabled API request.
func (r UpdateConfigurationSetReputationMetricsEnabledRequest) Send(ctx context.Context) (*UpdateConfigurationSetReputationMetricsEnabledResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateConfigurationSetReputationMetricsEnabledResponse{
		UpdateConfigurationSetReputationMetricsEnabledOutput: r.Request.Data.(*UpdateConfigurationSetReputationMetricsEnabledOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateConfigurationSetReputationMetricsEnabledResponse is the response type for the
// UpdateConfigurationSetReputationMetricsEnabled API operation.
type UpdateConfigurationSetReputationMetricsEnabledResponse struct {
	*UpdateConfigurationSetReputationMetricsEnabledOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateConfigurationSetReputationMetricsEnabled request.
func (r *UpdateConfigurationSetReputationMetricsEnabledResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
