// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package shield

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtectionRequest
type CreateProtectionInput struct {
	_ struct{} `type:"structure"`

	// Friendly name for the Protection you are creating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The ARN (Amazon Resource Name) of the resource to be protected.
	//
	// The ARN should be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Elastic Load Balancer (Classic Load Balancer): arn:aws:elasticloadbalancing:region:account-id:loadbalancer/load-balancer-name
	//
	//    * For an AWS CloudFront distribution: arn:aws:cloudfront::account-id:distribution/distribution-id
	//
	//    * For an AWS Global Accelerator accelerator: arn:aws:globalaccelerator::account-id:accelerator/accelerator-id
	//
	//    * For Amazon Route 53: arn:aws:route53:::hostedzone/hosted-zone-id
	//
	//    * For an Elastic IP address: arn:aws:ec2:region:account-id:eip-allocation/allocation-id
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProtectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateProtectionInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtectionResponse
type CreateProtectionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) for the Protection object that is created.
	ProtectionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateProtection = "CreateProtection"

// CreateProtectionRequest returns a request value for making API operation for
// AWS Shield.
//
// Enables AWS Shield Advanced for a specific AWS resource. The resource can
// be an Amazon CloudFront distribution, Elastic Load Balancing load balancer,
// AWS Global Accelerator accelerator, Elastic IP Address, or an Amazon Route
// 53 hosted zone.
//
// You can add protection to only a single resource with each CreateProtection
// request. If you want to add protection to multiple resources at once, use
// the AWS WAF console (https://console.aws.amazon.com/waf/). For more information
// see Getting Started with AWS Shield Advanced (https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html)
// and Add AWS Shield Advanced Protection to more AWS Resources (https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html).
//
//    // Example sending a request using CreateProtectionRequest.
//    req := client.CreateProtectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection
func (c *Client) CreateProtectionRequest(input *CreateProtectionInput) CreateProtectionRequest {
	op := &aws.Operation{
		Name:       opCreateProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProtectionInput{}
	}

	req := c.newRequest(op, input, &CreateProtectionOutput{})
	return CreateProtectionRequest{Request: req, Input: input, Copy: c.CreateProtectionRequest}
}

// CreateProtectionRequest is the request type for the
// CreateProtection API operation.
type CreateProtectionRequest struct {
	*aws.Request
	Input *CreateProtectionInput
	Copy  func(*CreateProtectionInput) CreateProtectionRequest
}

// Send marshals and sends the CreateProtection API request.
func (r CreateProtectionRequest) Send(ctx context.Context) (*CreateProtectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateProtectionResponse{
		CreateProtectionOutput: r.Request.Data.(*CreateProtectionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateProtectionResponse is the response type for the
// CreateProtection API operation.
type CreateProtectionResponse struct {
	*CreateProtectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateProtection request.
func (r *CreateProtectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
