// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJobRequest
type DeleteReplicationJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the replication job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteReplicationJobInput"}

	if s.ReplicationJobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJobResponse
type DeleteReplicationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteReplicationJob = "DeleteReplicationJob"

// DeleteReplicationJobRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Deletes the specified replication job.
//
// After you delete a replication job, there are no further replication runs.
// AWS deletes the contents of the Amazon S3 bucket used to store AWS SMS artifacts.
// The AMIs created by the replication runs are not deleted.
//
//    // Example sending a request using DeleteReplicationJobRequest.
//    req := client.DeleteReplicationJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJob
func (c *Client) DeleteReplicationJobRequest(input *DeleteReplicationJobInput) DeleteReplicationJobRequest {
	op := &aws.Operation{
		Name:       opDeleteReplicationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationJobInput{}
	}

	req := c.newRequest(op, input, &DeleteReplicationJobOutput{})
	return DeleteReplicationJobRequest{Request: req, Input: input, Copy: c.DeleteReplicationJobRequest}
}

// DeleteReplicationJobRequest is the request type for the
// DeleteReplicationJob API operation.
type DeleteReplicationJobRequest struct {
	*aws.Request
	Input *DeleteReplicationJobInput
	Copy  func(*DeleteReplicationJobInput) DeleteReplicationJobRequest
}

// Send marshals and sends the DeleteReplicationJob API request.
func (r DeleteReplicationJobRequest) Send(ctx context.Context) (*DeleteReplicationJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteReplicationJobResponse{
		DeleteReplicationJobOutput: r.Request.Data.(*DeleteReplicationJobOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteReplicationJobResponse is the response type for the
// DeleteReplicationJob API operation.
type DeleteReplicationJobResponse struct {
	*DeleteReplicationJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteReplicationJob request.
func (r *DeleteReplicationJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
