// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnectorRequest
type DisassociateConnectorInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connector.
	//
	// ConnectorId is a required field
	ConnectorId *string `locationName:"connectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConnectorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateConnectorInput"}

	if s.ConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnectorResponse
type DisassociateConnectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateConnector = "DisassociateConnector"

// DisassociateConnectorRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Disassociates the specified connector from AWS SMS.
//
// After you disassociate a connector, it is no longer available to support
// replication jobs.
//
//    // Example sending a request using DisassociateConnectorRequest.
//    req := client.DisassociateConnectorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnector
func (c *Client) DisassociateConnectorRequest(input *DisassociateConnectorInput) DisassociateConnectorRequest {
	op := &aws.Operation{
		Name:       opDisassociateConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConnectorInput{}
	}

	req := c.newRequest(op, input, &DisassociateConnectorOutput{})
	return DisassociateConnectorRequest{Request: req, Input: input, Copy: c.DisassociateConnectorRequest}
}

// DisassociateConnectorRequest is the request type for the
// DisassociateConnector API operation.
type DisassociateConnectorRequest struct {
	*aws.Request
	Input *DisassociateConnectorInput
	Copy  func(*DisassociateConnectorInput) DisassociateConnectorRequest
}

// Send marshals and sends the DisassociateConnector API request.
func (r DisassociateConnectorRequest) Send(ctx context.Context) (*DisassociateConnectorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateConnectorResponse{
		DisassociateConnectorOutput: r.Request.Data.(*DisassociateConnectorOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateConnectorResponse is the response type for the
// DisassociateConnector API operation.
type DisassociateConnectorResponse struct {
	*DisassociateConnectorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateConnector request.
func (r *DisassociateConnectorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
