// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateTemplateRequest
type GenerateTemplateInput struct {
	_ struct{} `type:"structure"`

	// ID of the application associated with the Amazon CloudFormation template.
	AppId *string `locationName:"appId" type:"string"`

	// Format for generating the Amazon CloudFormation template.
	TemplateFormat OutputFormat `locationName:"templateFormat" type:"string" enum:"true"`
}

// String returns the string representation
func (s GenerateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateTemplateResponse
type GenerateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Location of the Amazon S3 object.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s GenerateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGenerateTemplate = "GenerateTemplate"

// GenerateTemplateRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Generates an Amazon CloudFormation template based on the current launch configuration
// and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.
//
//    // Example sending a request using GenerateTemplateRequest.
//    req := client.GenerateTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateTemplate
func (c *Client) GenerateTemplateRequest(input *GenerateTemplateInput) GenerateTemplateRequest {
	op := &aws.Operation{
		Name:       opGenerateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateTemplateInput{}
	}

	req := c.newRequest(op, input, &GenerateTemplateOutput{})
	return GenerateTemplateRequest{Request: req, Input: input, Copy: c.GenerateTemplateRequest}
}

// GenerateTemplateRequest is the request type for the
// GenerateTemplate API operation.
type GenerateTemplateRequest struct {
	*aws.Request
	Input *GenerateTemplateInput
	Copy  func(*GenerateTemplateInput) GenerateTemplateRequest
}

// Send marshals and sends the GenerateTemplate API request.
func (r GenerateTemplateRequest) Send(ctx context.Context) (*GenerateTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GenerateTemplateResponse{
		GenerateTemplateOutput: r.Request.Data.(*GenerateTemplateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GenerateTemplateResponse is the response type for the
// GenerateTemplate API operation.
type GenerateTemplateResponse struct {
	*GenerateTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GenerateTemplate request.
func (r *GenerateTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
