// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventoryRequest
type GetInventoryInput struct {
	_ struct{} `type:"structure"`

	// Returns counts of inventory types based on one or more expressions. For example,
	// if you aggregate by using an expression that uses the AWS:InstanceInformation.PlatformType
	// type, you can see a count of how many Windows and Linux instances exist in
	// your inventoried fleet.
	Aggregators []InventoryAggregator `min:"1" type:"list"`

	// One or more filters. Use a filter to return a more specific list of results.
	Filters []InventoryFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The list of inventory item types to return.
	ResultAttributes []ResultAttribute `min:"1" type:"list"`
}

// String returns the string representation
func (s GetInventoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInventoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetInventoryInput"}
	if s.Aggregators != nil && len(s.Aggregators) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Aggregators", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResultAttributes != nil && len(s.ResultAttributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResultAttributes", 1))
	}
	if s.Aggregators != nil {
		for i, v := range s.Aggregators {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Aggregators", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ResultAttributes != nil {
		for i, v := range s.ResultAttributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResultAttributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventoryResult
type GetInventoryOutput struct {
	_ struct{} `type:"structure"`

	// Collection of inventory entities such as a collection of instance inventory.
	Entities []InventoryResultEntity `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetInventoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetInventory = "GetInventory"

// GetInventoryRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Query inventory information.
//
//    // Example sending a request using GetInventoryRequest.
//    req := client.GetInventoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory
func (c *Client) GetInventoryRequest(input *GetInventoryInput) GetInventoryRequest {
	op := &aws.Operation{
		Name:       opGetInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInventoryInput{}
	}

	req := c.newRequest(op, input, &GetInventoryOutput{})
	return GetInventoryRequest{Request: req, Input: input, Copy: c.GetInventoryRequest}
}

// GetInventoryRequest is the request type for the
// GetInventory API operation.
type GetInventoryRequest struct {
	*aws.Request
	Input *GetInventoryInput
	Copy  func(*GetInventoryInput) GetInventoryRequest
}

// Send marshals and sends the GetInventory API request.
func (r GetInventoryRequest) Send(ctx context.Context) (*GetInventoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetInventoryResponse{
		GetInventoryOutput: r.Request.Data.(*GetInventoryOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetInventoryResponse is the response type for the
// GetInventory API operation.
type GetInventoryResponse struct {
	*GetInventoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetInventory request.
func (r *GetInventoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
