// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationsRequest
type ListAssociationsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	AssociationFilterList []AssociationFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssociationsInput"}
	if s.AssociationFilterList != nil && len(s.AssociationFilterList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssociationFilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.AssociationFilterList != nil {
		for i, v := range s.AssociationFilterList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssociationFilterList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationsResult
type ListAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The associations.
	Associations []Association `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssociations = "ListAssociations"

// ListAssociationsRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Lists the associations for the specified Systems Manager document or instance.
//
//    // Example sending a request using ListAssociationsRequest.
//    req := client.ListAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations
func (c *Client) ListAssociationsRequest(input *ListAssociationsInput) ListAssociationsRequest {
	op := &aws.Operation{
		Name:       opListAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociationsInput{}
	}

	req := c.newRequest(op, input, &ListAssociationsOutput{})
	return ListAssociationsRequest{Request: req, Input: input, Copy: c.ListAssociationsRequest}
}

// ListAssociationsRequest is the request type for the
// ListAssociations API operation.
type ListAssociationsRequest struct {
	*aws.Request
	Input *ListAssociationsInput
	Copy  func(*ListAssociationsInput) ListAssociationsRequest
}

// Send marshals and sends the ListAssociations API request.
func (r ListAssociationsRequest) Send(ctx context.Context) (*ListAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssociationsResponse{
		ListAssociationsOutput: r.Request.Data.(*ListAssociationsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAssociationsRequestPaginator returns a paginator for ListAssociations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAssociationsRequest(input)
//   p := ssm.NewListAssociationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAssociationsPaginator(req ListAssociationsRequest) ListAssociationsPaginator {
	return ListAssociationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAssociationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAssociationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAssociationsPaginator struct {
	aws.Pager
}

func (p *ListAssociationsPaginator) CurrentPage() *ListAssociationsOutput {
	return p.Pager.CurrentPage().(*ListAssociationsOutput)
}

// ListAssociationsResponse is the response type for the
// ListAssociations API operation.
type ListAssociationsResponse struct {
	*ListAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssociations request.
func (r *ListAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
