// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A JSON object containing one or more of the following fields:
//
//    * DeleteChapCredentialsInput$InitiatorName
//
//    * DeleteChapCredentialsInput$TargetARN
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentialsInput
type DeleteChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	//
	// InitiatorName is a required field
	InitiatorName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChapCredentialsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteChapCredentialsInput"}

	if s.InitiatorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InitiatorName"))
	}
	if s.InitiatorName != nil && len(*s.InitiatorName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InitiatorName", 1))
	}

	if s.TargetARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentialsOutput
type DeleteChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	InitiatorName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteChapCredentials = "DeleteChapCredentials"

// DeleteChapCredentialsRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for
// a specified iSCSI target and initiator pair.
//
//    // Example sending a request using DeleteChapCredentialsRequest.
//    req := client.DeleteChapCredentialsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentials
func (c *Client) DeleteChapCredentialsRequest(input *DeleteChapCredentialsInput) DeleteChapCredentialsRequest {
	op := &aws.Operation{
		Name:       opDeleteChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChapCredentialsInput{}
	}

	req := c.newRequest(op, input, &DeleteChapCredentialsOutput{})
	return DeleteChapCredentialsRequest{Request: req, Input: input, Copy: c.DeleteChapCredentialsRequest}
}

// DeleteChapCredentialsRequest is the request type for the
// DeleteChapCredentials API operation.
type DeleteChapCredentialsRequest struct {
	*aws.Request
	Input *DeleteChapCredentialsInput
	Copy  func(*DeleteChapCredentialsInput) DeleteChapCredentialsRequest
}

// Send marshals and sends the DeleteChapCredentials API request.
func (r DeleteChapCredentialsRequest) Send(ctx context.Context) (*DeleteChapCredentialsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteChapCredentialsResponse{
		DeleteChapCredentialsOutput: r.Request.Data.(*DeleteChapCredentialsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteChapCredentialsResponse is the response type for the
// DeleteChapCredentials API operation.
type DeleteChapCredentialsResponse struct {
	*DeleteChapCredentialsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteChapCredentials request.
func (r *DeleteChapCredentialsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
