// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package swfiface provides an interface to enable mocking the Amazon Simple Workflow Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package swfiface

import (
	"github.com/aws/aws-sdk-go-v2/service/swf"
)

// ClientAPI provides an interface to enable mocking the
// swf.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon SWF.
//    func myFunc(svc swfiface.ClientAPI) bool {
//        // Make svc.CountClosedWorkflowExecutions request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := swf.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        swfiface.ClientPI
//    }
//    func (m *mockClientClient) CountClosedWorkflowExecutions(input *swf.CountClosedWorkflowExecutionsInput) (*swf.CountClosedWorkflowExecutionsOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CountClosedWorkflowExecutionsRequest(*swf.CountClosedWorkflowExecutionsInput) swf.CountClosedWorkflowExecutionsRequest

	CountOpenWorkflowExecutionsRequest(*swf.CountOpenWorkflowExecutionsInput) swf.CountOpenWorkflowExecutionsRequest

	CountPendingActivityTasksRequest(*swf.CountPendingActivityTasksInput) swf.CountPendingActivityTasksRequest

	CountPendingDecisionTasksRequest(*swf.CountPendingDecisionTasksInput) swf.CountPendingDecisionTasksRequest

	DeprecateActivityTypeRequest(*swf.DeprecateActivityTypeInput) swf.DeprecateActivityTypeRequest

	DeprecateDomainRequest(*swf.DeprecateDomainInput) swf.DeprecateDomainRequest

	DeprecateWorkflowTypeRequest(*swf.DeprecateWorkflowTypeInput) swf.DeprecateWorkflowTypeRequest

	DescribeActivityTypeRequest(*swf.DescribeActivityTypeInput) swf.DescribeActivityTypeRequest

	DescribeDomainRequest(*swf.DescribeDomainInput) swf.DescribeDomainRequest

	DescribeWorkflowExecutionRequest(*swf.DescribeWorkflowExecutionInput) swf.DescribeWorkflowExecutionRequest

	DescribeWorkflowTypeRequest(*swf.DescribeWorkflowTypeInput) swf.DescribeWorkflowTypeRequest

	GetWorkflowExecutionHistoryRequest(*swf.GetWorkflowExecutionHistoryInput) swf.GetWorkflowExecutionHistoryRequest

	ListActivityTypesRequest(*swf.ListActivityTypesInput) swf.ListActivityTypesRequest

	ListClosedWorkflowExecutionsRequest(*swf.ListClosedWorkflowExecutionsInput) swf.ListClosedWorkflowExecutionsRequest

	ListDomainsRequest(*swf.ListDomainsInput) swf.ListDomainsRequest

	ListOpenWorkflowExecutionsRequest(*swf.ListOpenWorkflowExecutionsInput) swf.ListOpenWorkflowExecutionsRequest

	ListWorkflowTypesRequest(*swf.ListWorkflowTypesInput) swf.ListWorkflowTypesRequest

	PollForActivityTaskRequest(*swf.PollForActivityTaskInput) swf.PollForActivityTaskRequest

	PollForDecisionTaskRequest(*swf.PollForDecisionTaskInput) swf.PollForDecisionTaskRequest

	RecordActivityTaskHeartbeatRequest(*swf.RecordActivityTaskHeartbeatInput) swf.RecordActivityTaskHeartbeatRequest

	RegisterActivityTypeRequest(*swf.RegisterActivityTypeInput) swf.RegisterActivityTypeRequest

	RegisterDomainRequest(*swf.RegisterDomainInput) swf.RegisterDomainRequest

	RegisterWorkflowTypeRequest(*swf.RegisterWorkflowTypeInput) swf.RegisterWorkflowTypeRequest

	RequestCancelWorkflowExecutionRequest(*swf.RequestCancelWorkflowExecutionInput) swf.RequestCancelWorkflowExecutionRequest

	RespondActivityTaskCanceledRequest(*swf.RespondActivityTaskCanceledInput) swf.RespondActivityTaskCanceledRequest

	RespondActivityTaskCompletedRequest(*swf.RespondActivityTaskCompletedInput) swf.RespondActivityTaskCompletedRequest

	RespondActivityTaskFailedRequest(*swf.RespondActivityTaskFailedInput) swf.RespondActivityTaskFailedRequest

	RespondDecisionTaskCompletedRequest(*swf.RespondDecisionTaskCompletedInput) swf.RespondDecisionTaskCompletedRequest

	SignalWorkflowExecutionRequest(*swf.SignalWorkflowExecutionInput) swf.SignalWorkflowExecutionRequest

	StartWorkflowExecutionRequest(*swf.StartWorkflowExecutionInput) swf.StartWorkflowExecutionRequest

	TerminateWorkflowExecutionRequest(*swf.TerminateWorkflowExecutionInput) swf.TerminateWorkflowExecutionRequest
}

var _ ClientAPI = (*swf.Client)(nil)
