// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package textract

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentTextRequest
type DetectDocumentTextInput struct {
	_ struct{} `type:"structure"`

	// The input document as base64-encoded bytes or an Amazon S3 object. If you
	// use the AWS CLI to call Amazon Textract operations, you can't pass image
	// bytes. The document must be an image in JPG or PNG format.
	//
	// If you are using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes passed using the Bytes field.
	//
	// Document is a required field
	Document *Document `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetectDocumentTextInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectDocumentTextInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectDocumentTextInput"}

	if s.Document == nil {
		invalidParams.Add(aws.NewErrParamRequired("Document"))
	}
	if s.Document != nil {
		if err := s.Document.Validate(); err != nil {
			invalidParams.AddNested("Document", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentTextResponse
type DetectDocumentTextOutput struct {
	_ struct{} `type:"structure"`

	// An array of Block objects containing the text detected in the document.
	Blocks []Block `type:"list"`

	// Metadata about the document. Contains the number of pages that are detected
	// in the document.
	DocumentMetadata *DocumentMetadata `type:"structure"`
}

// String returns the string representation
func (s DetectDocumentTextOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetectDocumentText = "DetectDocumentText"

// DetectDocumentTextRequest returns a request value for making API operation for
// Amazon Textract.
//
// Detects text in the input document. Amazon Textract can detect lines of text
// and the words that make up a line of text. The input document must be an
// image in JPG or PNG format. DetectDocumentText returns the detected text
// in an array of Block objects.
//
// Each document page has as an associated Block of type PAGE. Each PAGE Block
// object is the parent of LINE Block objects that represent the lines of detected
// text on a page. A LINE Block object is a parent for each word that makes
// up the line. Words are represented by Block objects of type WORD.
//
// DetectDocumentText is a synchronous operation. To analyze documents asynchronously,
// use StartDocumentTextDetection.
//
// For more information, see Document Text Detection (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
//
//    // Example sending a request using DetectDocumentTextRequest.
//    req := client.DetectDocumentTextRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentText
func (c *Client) DetectDocumentTextRequest(input *DetectDocumentTextInput) DetectDocumentTextRequest {
	op := &aws.Operation{
		Name:       opDetectDocumentText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectDocumentTextInput{}
	}

	req := c.newRequest(op, input, &DetectDocumentTextOutput{})
	return DetectDocumentTextRequest{Request: req, Input: input, Copy: c.DetectDocumentTextRequest}
}

// DetectDocumentTextRequest is the request type for the
// DetectDocumentText API operation.
type DetectDocumentTextRequest struct {
	*aws.Request
	Input *DetectDocumentTextInput
	Copy  func(*DetectDocumentTextInput) DetectDocumentTextRequest
}

// Send marshals and sends the DetectDocumentText API request.
func (r DetectDocumentTextRequest) Send(ctx context.Context) (*DetectDocumentTextResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetectDocumentTextResponse{
		DetectDocumentTextOutput: r.Request.Data.(*DetectDocumentTextOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetectDocumentTextResponse is the response type for the
// DetectDocumentText API operation.
type DetectDocumentTextResponse struct {
	*DetectDocumentTextOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetectDocumentText request.
func (r *DetectDocumentTextResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
