// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package translate

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminologyRequest
type GetTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology being retrieved.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The data format of the custom terminology being retrieved, either CSV or
	// TMX.
	//
	// TerminologyDataFormat is a required field
	TerminologyDataFormat TerminologyDataFormat `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTerminologyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTerminologyInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.TerminologyDataFormat) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TerminologyDataFormat"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminologyResponse
type GetTerminologyOutput struct {
	_ struct{} `type:"structure"`

	// The data location of the custom terminology being retrieved. The custom terminology
	// file is returned in a presigned url that has a 30 minute expiration.
	TerminologyDataLocation *TerminologyDataLocation `type:"structure"`

	// The properties of the custom terminology being retrieved.
	TerminologyProperties *TerminologyProperties `type:"structure"`
}

// String returns the string representation
func (s GetTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTerminology = "GetTerminology"

// GetTerminologyRequest returns a request value for making API operation for
// Amazon Translate.
//
// Retrieves a custom terminology.
//
//    // Example sending a request using GetTerminologyRequest.
//    req := client.GetTerminologyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology
func (c *Client) GetTerminologyRequest(input *GetTerminologyInput) GetTerminologyRequest {
	op := &aws.Operation{
		Name:       opGetTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTerminologyInput{}
	}

	req := c.newRequest(op, input, &GetTerminologyOutput{})
	return GetTerminologyRequest{Request: req, Input: input, Copy: c.GetTerminologyRequest}
}

// GetTerminologyRequest is the request type for the
// GetTerminology API operation.
type GetTerminologyRequest struct {
	*aws.Request
	Input *GetTerminologyInput
	Copy  func(*GetTerminologyInput) GetTerminologyRequest
}

// Send marshals and sends the GetTerminology API request.
func (r GetTerminologyRequest) Send(ctx context.Context) (*GetTerminologyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTerminologyResponse{
		GetTerminologyOutput: r.Request.Data.(*GetTerminologyOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetTerminologyResponse is the response type for the
// GetTerminology API operation.
type GetTerminologyResponse struct {
	*GetTerminologyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTerminology request.
func (r *GetTerminologyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
