// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResourceRequest
type DeleteResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier associated with the organization from which the resource is
	// deleted.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier of the resource to be deleted.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteResourceInput"}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResourceResponse
type DeleteResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteResource = "DeleteResource"

// DeleteResourceRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Deletes the specified resource.
//
//    // Example sending a request using DeleteResourceRequest.
//    req := client.DeleteResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource
func (c *Client) DeleteResourceRequest(input *DeleteResourceInput) DeleteResourceRequest {
	op := &aws.Operation{
		Name:       opDeleteResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceInput{}
	}

	req := c.newRequest(op, input, &DeleteResourceOutput{})
	return DeleteResourceRequest{Request: req, Input: input, Copy: c.DeleteResourceRequest}
}

// DeleteResourceRequest is the request type for the
// DeleteResource API operation.
type DeleteResourceRequest struct {
	*aws.Request
	Input *DeleteResourceInput
	Copy  func(*DeleteResourceInput) DeleteResourceRequest
}

// Send marshals and sends the DeleteResource API request.
func (r DeleteResourceRequest) Send(ctx context.Context) (*DeleteResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteResourceResponse{
		DeleteResourceOutput: r.Request.Data.(*DeleteResourceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteResourceResponse is the response type for the
// DeleteResource API operation.
type DeleteResourceResponse struct {
	*DeleteResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteResource request.
func (r *DeleteResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
