// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesRequest
type CreateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to create. You can specify up to 25 WorkSpaces.
	//
	// Workspaces is a required field
	Workspaces []WorkspaceRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspacesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateWorkspacesInput"}

	if s.Workspaces == nil {
		invalidParams.Add(aws.NewErrParamRequired("Workspaces"))
	}
	if s.Workspaces != nil && len(s.Workspaces) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Workspaces", 1))
	}
	if s.Workspaces != nil {
		for i, v := range s.Workspaces {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Workspaces", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesResult
type CreateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be created.
	FailedRequests []FailedCreateWorkspaceRequest `type:"list"`

	// Information about the WorkSpaces that were created.
	//
	// Because this operation is asynchronous, the identifier returned is not immediately
	// available for use with other operations. For example, if you call DescribeWorkspaces
	// before the WorkSpace is created, the information returned can be incomplete.
	PendingRequests []Workspace `type:"list"`
}

// String returns the string representation
func (s CreateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateWorkspaces = "CreateWorkspaces"

// CreateWorkspacesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Creates one or more WorkSpaces.
//
// This operation is asynchronous and returns before the WorkSpaces are created.
//
//    // Example sending a request using CreateWorkspacesRequest.
//    req := client.CreateWorkspacesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *Client) CreateWorkspacesRequest(input *CreateWorkspacesInput) CreateWorkspacesRequest {
	op := &aws.Operation{
		Name:       opCreateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspacesInput{}
	}

	req := c.newRequest(op, input, &CreateWorkspacesOutput{})
	return CreateWorkspacesRequest{Request: req, Input: input, Copy: c.CreateWorkspacesRequest}
}

// CreateWorkspacesRequest is the request type for the
// CreateWorkspaces API operation.
type CreateWorkspacesRequest struct {
	*aws.Request
	Input *CreateWorkspacesInput
	Copy  func(*CreateWorkspacesInput) CreateWorkspacesRequest
}

// Send marshals and sends the CreateWorkspaces API request.
func (r CreateWorkspacesRequest) Send(ctx context.Context) (*CreateWorkspacesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateWorkspacesResponse{
		CreateWorkspacesOutput: r.Request.Data.(*CreateWorkspacesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateWorkspacesResponse is the response type for the
// CreateWorkspaces API operation.
type CreateWorkspacesResponse struct {
	*CreateWorkspacesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateWorkspaces request.
func (r *CreateWorkspacesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
