// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRulesRequest
type RevokeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to remove from the group.
	//
	// UserRules is a required field
	UserRules []string `type:"list" required:"true"`
}

// String returns the string representation
func (s RevokeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeIpRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RevokeIpRulesInput"}

	if s.GroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupId"))
	}

	if s.UserRules == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRulesResult
type RevokeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opRevokeIpRules = "RevokeIpRules"

// RevokeIpRulesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Removes one or more rules from the specified IP access control group.
//
//    // Example sending a request using RevokeIpRulesRequest.
//    req := client.RevokeIpRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *Client) RevokeIpRulesRequest(input *RevokeIpRulesInput) RevokeIpRulesRequest {
	op := &aws.Operation{
		Name:       opRevokeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeIpRulesInput{}
	}

	req := c.newRequest(op, input, &RevokeIpRulesOutput{})
	return RevokeIpRulesRequest{Request: req, Input: input, Copy: c.RevokeIpRulesRequest}
}

// RevokeIpRulesRequest is the request type for the
// RevokeIpRules API operation.
type RevokeIpRulesRequest struct {
	*aws.Request
	Input *RevokeIpRulesInput
	Copy  func(*RevokeIpRulesInput) RevokeIpRulesRequest
}

// Send marshals and sends the RevokeIpRules API request.
func (r RevokeIpRulesRequest) Send(ctx context.Context) (*RevokeIpRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeIpRulesResponse{
		RevokeIpRulesOutput: r.Request.Data.(*RevokeIpRulesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeIpRulesResponse is the response type for the
// RevokeIpRules API operation.
type RevokeIpRulesResponse struct {
	*RevokeIpRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeIpRules request.
func (r *RevokeIpRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
