// Code generated by smithy-go-codegen DO NOT EDIT.

package dynamodb

import (
	"context"
	smithy "github.com/aws/smithy-go"
	smithyauth "github.com/aws/smithy-go/auth"
	smithyendpoints "github.com/aws/smithy-go/endpoints"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"net/http"
	"net/url"
	"reflect"
	"strings"
	"testing"
)

// For region af-south-1 with FIPS disabled and DualStack disabled
func TestEndpointCase0(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("af-south-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ap-east-1 with FIPS disabled and DualStack disabled
func TestEndpointCase1(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ap-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ap-northeast-1 with FIPS disabled and DualStack disabled
func TestEndpointCase2(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-northeast-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ap-northeast-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ap-northeast-2 with FIPS disabled and DualStack disabled
func TestEndpointCase3(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-northeast-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ap-northeast-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ap-northeast-3 with FIPS disabled and DualStack disabled
func TestEndpointCase4(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-northeast-3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ap-northeast-3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ap-south-1 with FIPS disabled and DualStack disabled
func TestEndpointCase5(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-south-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ap-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ap-southeast-1 with FIPS disabled and DualStack disabled
func TestEndpointCase6(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-southeast-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ap-southeast-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ap-southeast-2 with FIPS disabled and DualStack disabled
func TestEndpointCase7(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-southeast-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ap-southeast-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ap-southeast-3 with FIPS disabled and DualStack disabled
func TestEndpointCase8(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-southeast-3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ap-southeast-3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ca-central-1 with FIPS disabled and DualStack disabled
func TestEndpointCase9(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ca-central-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.ca-central-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region ca-central-1 with FIPS enabled and DualStack disabled
func TestEndpointCase10(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ca-central-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.ca-central-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region eu-central-1 with FIPS disabled and DualStack disabled
func TestEndpointCase11(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("eu-central-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.eu-central-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region eu-north-1 with FIPS disabled and DualStack disabled
func TestEndpointCase12(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("eu-north-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.eu-north-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region eu-south-1 with FIPS disabled and DualStack disabled
func TestEndpointCase13(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("eu-south-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.eu-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region eu-west-1 with FIPS disabled and DualStack disabled
func TestEndpointCase14(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("eu-west-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.eu-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region eu-west-2 with FIPS disabled and DualStack disabled
func TestEndpointCase15(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("eu-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.eu-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region eu-west-3 with FIPS disabled and DualStack disabled
func TestEndpointCase16(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("eu-west-3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.eu-west-3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region local with FIPS disabled and DualStack disabled
func TestEndpointCase17(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("local"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region me-south-1 with FIPS disabled and DualStack disabled
func TestEndpointCase18(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("me-south-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.me-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region sa-east-1 with FIPS disabled and DualStack disabled
func TestEndpointCase19(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("sa-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.sa-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-east-1 with FIPS disabled and DualStack disabled
func TestEndpointCase20(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-east-1 with FIPS enabled and DualStack disabled
func TestEndpointCase21(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-east-2 with FIPS disabled and DualStack disabled
func TestEndpointCase22(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-east-2 with FIPS enabled and DualStack disabled
func TestEndpointCase23(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-2"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-west-1 with FIPS disabled and DualStack disabled
func TestEndpointCase24(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-west-1 with FIPS enabled and DualStack disabled
func TestEndpointCase25(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-west-2 with FIPS disabled and DualStack disabled
func TestEndpointCase26(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-west-2 with FIPS enabled and DualStack disabled
func TestEndpointCase27(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-east-1 with FIPS enabled and DualStack enabled
func TestEndpointCase28(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-east-1 with FIPS disabled and DualStack enabled
func TestEndpointCase29(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region cn-north-1 with FIPS disabled and DualStack disabled
func TestEndpointCase30(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("cn-north-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region cn-northwest-1 with FIPS disabled and DualStack disabled
func TestEndpointCase31(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("cn-northwest-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-northwest-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region cn-north-1 with FIPS enabled and DualStack enabled
func TestEndpointCase32(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("cn-north-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region cn-north-1 with FIPS enabled and DualStack disabled
func TestEndpointCase33(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("cn-north-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region cn-north-1 with FIPS disabled and DualStack enabled
func TestEndpointCase34(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("cn-north-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-gov-east-1 with FIPS disabled and DualStack disabled
func TestEndpointCase35(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-gov-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-gov-east-1 with FIPS enabled and DualStack disabled
func TestEndpointCase36(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-gov-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-gov-west-1 with FIPS disabled and DualStack disabled
func TestEndpointCase37(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-gov-west-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-gov-west-1 with FIPS enabled and DualStack disabled
func TestEndpointCase38(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-gov-west-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-gov-east-1 with FIPS enabled and DualStack enabled
func TestEndpointCase39(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-gov-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-gov-east-1 with FIPS disabled and DualStack enabled
func TestEndpointCase40(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-gov-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-iso-east-1 with FIPS disabled and DualStack disabled
func TestEndpointCase41(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-iso-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-iso-west-1 with FIPS disabled and DualStack disabled
func TestEndpointCase42(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-iso-west-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-west-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-iso-east-1 with FIPS enabled and DualStack disabled
func TestEndpointCase43(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-iso-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-isob-east-1 with FIPS disabled and DualStack disabled
func TestEndpointCase44(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-isob-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-isob-east-1.sc2s.sgov.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For region us-isob-east-1 with FIPS enabled and DualStack disabled
func TestEndpointCase45(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-isob-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-isob-east-1.sc2s.sgov.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For custom endpoint with region set and fips disabled and dualstack disabled
func TestEndpointCase46(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Endpoint:     ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For custom endpoint with region not set and fips disabled and dualstack disabled
func TestEndpointCase47(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Endpoint:     ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// For custom endpoint with fips enabled and dualstack disabled
func TestEndpointCase48(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
		Endpoint:     ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// For custom endpoint with fips disabled and dualstack enabled
func TestEndpointCase49(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
		Endpoint:     ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Missing region
func TestEndpointCase50(t *testing.T) {
	var params = EndpointParameters{}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Missing Region", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase51(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase52(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase53(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase54(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase55(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase56(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase57(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase58(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase59(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase60(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=preferred,
// Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase61(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase62(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase63(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase64(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase65(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase66(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase67(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase68(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase69(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase70(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase71(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase72(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase73(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=preferred,
// Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase74(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase75(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase76(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase77(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase78(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase79(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase80(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase81(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase82(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase83(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase84(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=disabled,
// Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase85(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase86(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase87(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase88(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase89(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase90(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase91(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase92(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase93(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase94(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase95(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase96(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase97(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=disabled,
// Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase98(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase99(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase100(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase101(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase102(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase103(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase104(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase105(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase106(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase107(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase108(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=required,
// Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase109(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase110(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase111(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase112(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase113(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase114(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase115(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase116(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase117(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase118(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase119(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase120(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase121(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=required,
// Region=us-east-1, Endpoint=https://example.com}
func TestEndpointCase122(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
		Endpoint:              ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase123(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase124(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase125(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase126(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase127(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase128(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase129(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase130(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase131(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase132(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=preferred,
// Region=local}
func TestEndpointCase133(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase134(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase135(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase136(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase137(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase138(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase139(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase140(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase141(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase142(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase143(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase144(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=local}
func TestEndpointCase145(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=preferred,
// Region=local}
func TestEndpointCase146(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase147(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase148(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase149(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase150(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase151(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase152(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase153(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase154(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase155(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase156(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=disabled,
// Region=local}
func TestEndpointCase157(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase158(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase159(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase160(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase161(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase162(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase163(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase164(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase165(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase166(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase167(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase168(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=local}
func TestEndpointCase169(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=disabled,
// Region=local}
func TestEndpointCase170(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase171(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase172(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase173(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase174(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase175(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase176(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase177(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase178(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase179(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase180(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=required,
// Region=local}
func TestEndpointCase181(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase182(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase183(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase184(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase185(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase186(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase187(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase188(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase189(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase190(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase191(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Dualstack and local endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase192(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=local}
func TestEndpointCase193(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=required,
// Region=local}
func TestEndpointCase194(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("local"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://localhost:8000")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "dynamodb")
						smithyhttp.SetSigV4ASigningName(&sp, "dynamodb")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase195(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase196(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase197(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase198(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase199(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase200(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://222222222222.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase201(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase202(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase203(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase204(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=preferred,
// Region=us-east-1}
func TestEndpointCase205(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Credentials-sourced account ID parameter is invalid", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase206(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase207(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase208(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://222222222222.ddb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase209(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://222222222222.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase210(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase211(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase212(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase213(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase214(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase215(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase216(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-east-1}
func TestEndpointCase217(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://222222222222.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=preferred,
// Region=us-east-1}
func TestEndpointCase218(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase219(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase220(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase221(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase222(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase223(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase224(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://222222222222.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase225(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase226(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase227(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase228(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=required,
// Region=us-east-1}
func TestEndpointCase229(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Credentials-sourced account ID parameter is invalid", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase230(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase231(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase232(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://222222222222.ddb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase233(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://222222222222.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase234(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountIdEndpointMode is required but no AccountID was provided or able to be loaded", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase235(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountIdEndpointMode is required but no AccountID was provided or able to be loaded", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase236(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountIdEndpointMode is required but no AccountID was provided or able to be loaded", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase237(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase238(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase239(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase240(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://333333333333.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=us-east-1}
func TestEndpointCase241(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://222222222222.ddb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=required,
// Region=us-east-1}
func TestEndpointCase242(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountIdEndpointMode is required but no AccountID was provided or able to be loaded", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase243(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase244(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase245(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase246(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase247(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase248(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase249(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase250(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase251(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase252(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=required,
// Region=cn-north-1}
func TestEndpointCase253(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase254(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase255(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase256(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase257(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase258(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase259(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase260(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase261(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase262(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase263(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase264(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=required, Region=cn-north-1}
func TestEndpointCase265(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=required,
// Region=cn-north-1}
func TestEndpointCase266(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("required"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase267(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase268(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase269(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase270(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase271(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase272(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase273(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase274(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase275(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase276(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=disabled,
// Region=us-east-1}
func TestEndpointCase277(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase278(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase279(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase280(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase281(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase282(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase283(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase284(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase285(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase286(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase287(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase288(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=disabled, Region=us-east-1}
func TestEndpointCase289(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=disabled,
// Region=us-east-1}
func TestEndpointCase290(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("disabled"),
		Region:                ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase291(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase292(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase293(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase294(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase295(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase296(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase297(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase298(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase299(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase300(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=preferred,
// Region=cn-north-1}
func TestEndpointCase301(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase302(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase303(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase304(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase305(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase306(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase307(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase308(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase309(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase310(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase311(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase312(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=cn-north-1}
func TestEndpointCase313(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=preferred,
// Region=cn-north-1}
func TestEndpointCase314(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase315(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-iso-east-1.api.aws.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase316(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase317(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.api.aws.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase318(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase319(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase320(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase321(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase322(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase323(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase324(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=preferred,
// Region=us-iso-east-1}
func TestEndpointCase325(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase326(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-iso-east-1.api.aws.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase327(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase328(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.api.aws.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase329(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase330(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase331(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase332(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase333(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-iso-east-1.api.aws.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase334(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase335(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.api.aws.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase336(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-iso-east-1}
func TestEndpointCase337(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=preferred,
// Region=us-iso-east-1}
func TestEndpointCase338(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-iso-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-iso-east-1.c2s.ic.gov")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase339(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase340(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase341(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase342(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase343(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase344(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase345(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase346(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-west-2:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase347(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-west-2:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=111111111111,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// ResourceArnList=[arn:aws:s3:us-east-1:333333333333:stream/testStream],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase348(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String("111111111111"),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		ResourceArnList:       []string{"arn:aws:s3:us-east-1:333333333333:stream/testStream"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountId=, AccountIdEndpointMode=preferred,
// Region=us-gov-east-1}
func TestEndpointCase349(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountId:             ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase350(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase351(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase352(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase353(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-west-2:222222222222:table/table_name,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase354(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-west-2:222222222222:table/table_name"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:s3:us-west-2:222222222222:stream/testStream,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase355(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:s3:us-west-2:222222222222:stream/testStream"),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, ResourceArn=,
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase356(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String(""),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase357(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb-fips.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=true, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase358(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(true),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=true,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase359(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(true),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase360(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false,
// ResourceArn=arn:aws:dynamodb:us-east-1:222222222222:table/table_name,
// ResourceArnList=[arn:aws:dynamodb:us-east-1:333333333333:table/table_name],
// AccountIdEndpointMode=preferred, Region=us-gov-east-1}
func TestEndpointCase361(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		ResourceArn:           ptr.String("arn:aws:dynamodb:us-east-1:222222222222:table/table_name"),
		ResourceArnList:       []string{"arn:aws:dynamodb:us-east-1:333333333333:table/table_name"},
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {UseFIPS=false, UseDualStack=false, AccountIdEndpointMode=preferred,
// Region=us-gov-east-1}
func TestEndpointCase362(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:               ptr.Bool(false),
		UseDualStack:          ptr.Bool(false),
		AccountIdEndpointMode: ptr.String("preferred"),
		Region:                ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://dynamodb.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {Endpoint=https://dynamodb.us-west-2.api.aws, Region=us-west-2}
func TestEndpointCase363(t *testing.T) {
	var params = EndpointParameters{
		Endpoint: ptr.String("https://dynamodb.us-west-2.api.aws"),
		Region:   ptr.String("us-west-2"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Endpoint override is not supported for dual-stack endpoints. Please enable dual-stack functionality by enabling the configuration. For more details, see: https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {Endpoint=https://dynamodb.cn-north-1.api.amazonwebservices.com.cn,
// Region=cn-north-1}
func TestEndpointCase364(t *testing.T) {
	var params = EndpointParameters{
		Endpoint: ptr.String("https://dynamodb.cn-north-1.api.amazonwebservices.com.cn"),
		Region:   ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Endpoint override is not supported for dual-stack endpoints. Please enable dual-stack functionality by enabling the configuration. For more details, see: https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {Endpoint=https://dynamodb.us-gov-east-1.api.aws, Region=us-gov-east-1}
func TestEndpointCase365(t *testing.T) {
	var params = EndpointParameters{
		Endpoint: ptr.String("https://dynamodb.us-gov-east-1.api.aws"),
		Region:   ptr.String("us-gov-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Endpoint override is not supported for dual-stack endpoints. Please enable dual-stack functionality by enabling the configuration. For more details, see: https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {Endpoint=https://dynamodb.us-east-1.api.aws, Region=us-east-1}
func TestEndpointCase366(t *testing.T) {
	var params = EndpointParameters{
		Endpoint: ptr.String("https://dynamodb.us-east-1.api.aws"),
		Region:   ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Endpoint override is not supported for dual-stack endpoints. Please enable dual-stack functionality by enabling the configuration. For more details, see: https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// {Endpoint=https://111111111111.ddb.us-east-1.api.aws, Region=us-east-1}
func TestEndpointCase367(t *testing.T) {
	var params = EndpointParameters{
		Endpoint: ptr.String("https://111111111111.ddb.us-east-1.api.aws"),
		Region:   ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://111111111111.ddb.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {Endpoint=https://vpce-1a2b3c4d-5e6f.dynamodb.us-east-1.vpce.api.aws,
// Region=us-east-1}
func TestEndpointCase368(t *testing.T) {
	var params = EndpointParameters{
		Endpoint: ptr.String("https://vpce-1a2b3c4d-5e6f.dynamodb.us-east-1.vpce.api.aws"),
		Region:   ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://vpce-1a2b3c4d-5e6f.dynamodb.us-east-1.vpce.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// {Endpoint=https://dynamodb.eu-west-1.api.aws, Region=eu-west-1}
func TestEndpointCase369(t *testing.T) {
	var params = EndpointParameters{
		Endpoint: ptr.String("https://dynamodb.eu-west-1.api.aws"),
		Region:   ptr.String("eu-west-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Endpoint override is not supported for dual-stack endpoints. Please enable dual-stack functionality by enabling the configuration. For more details, see: https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}
