// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppRequest method.
//    req, resp := client.CreateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp
func (c *Pinpoint) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for Amazon Pinpoint.
//
// Creates an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateApp for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp
func (c *Pinpoint) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the CreateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCampaign for more information on using the CreateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCampaignRequest method.
//    req, resp := client.CreateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign
func (c *Pinpoint) CreateCampaignRequest(input *CreateCampaignInput) (req *request.Request, output *CreateCampaignOutput) {
	op := &request.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/campaigns",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	output = &CreateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCampaign API operation for Amazon Pinpoint.
//
// Creates a new campaign for an application or updates the settings of an existing
// campaign for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateCampaign for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign
func (c *Pinpoint) CreateCampaign(input *CreateCampaignInput) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	return out, req.Send()
}

// CreateCampaignWithContext is the same as CreateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateCampaignWithContext(ctx aws.Context, input *CreateCampaignInput, opts ...request.Option) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEmailTemplate = "CreateEmailTemplate"

// CreateEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEmailTemplate for more information on using the CreateEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEmailTemplateRequest method.
//    req, resp := client.CreateEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateEmailTemplate
func (c *Pinpoint) CreateEmailTemplateRequest(input *CreateEmailTemplateInput) (req *request.Request, output *CreateEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/templates/{template-name}/email",
	}

	if input == nil {
		input = &CreateEmailTemplateInput{}
	}

	output = &CreateEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEmailTemplate API operation for Amazon Pinpoint.
//
// Creates a message template for messages that are sent through the email channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateEmailTemplate
func (c *Pinpoint) CreateEmailTemplate(input *CreateEmailTemplateInput) (*CreateEmailTemplateOutput, error) {
	req, out := c.CreateEmailTemplateRequest(input)
	return out, req.Send()
}

// CreateEmailTemplateWithContext is the same as CreateEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateEmailTemplateWithContext(ctx aws.Context, input *CreateEmailTemplateInput, opts ...request.Option) (*CreateEmailTemplateOutput, error) {
	req, out := c.CreateEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExportJob = "CreateExportJob"

// CreateExportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExportJob for more information on using the CreateExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateExportJobRequest method.
//    req, resp := client.CreateExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob
func (c *Pinpoint) CreateExportJobRequest(input *CreateExportJobInput) (req *request.Request, output *CreateExportJobOutput) {
	op := &request.Operation{
		Name:       opCreateExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export",
	}

	if input == nil {
		input = &CreateExportJobInput{}
	}

	output = &CreateExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExportJob API operation for Amazon Pinpoint.
//
// Creates an export job for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateExportJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob
func (c *Pinpoint) CreateExportJob(input *CreateExportJobInput) (*CreateExportJobOutput, error) {
	req, out := c.CreateExportJobRequest(input)
	return out, req.Send()
}

// CreateExportJobWithContext is the same as CreateExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateExportJobWithContext(ctx aws.Context, input *CreateExportJobInput, opts ...request.Option) (*CreateExportJobOutput, error) {
	req, out := c.CreateExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImportJob = "CreateImportJob"

// CreateImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImportJob for more information on using the CreateImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImportJobRequest method.
//    req, resp := client.CreateImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob
func (c *Pinpoint) CreateImportJobRequest(input *CreateImportJobInput) (req *request.Request, output *CreateImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import",
	}

	if input == nil {
		input = &CreateImportJobInput{}
	}

	output = &CreateImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImportJob API operation for Amazon Pinpoint.
//
// Creates an import job for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateImportJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob
func (c *Pinpoint) CreateImportJob(input *CreateImportJobInput) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	return out, req.Send()
}

// CreateImportJobWithContext is the same as CreateImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateImportJobWithContext(ctx aws.Context, input *CreateImportJobInput, opts ...request.Option) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJourney = "CreateJourney"

// CreateJourneyRequest generates a "aws/request.Request" representing the
// client's request for the CreateJourney operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJourney for more information on using the CreateJourney
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJourneyRequest method.
//    req, resp := client.CreateJourneyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateJourney
func (c *Pinpoint) CreateJourneyRequest(input *CreateJourneyInput) (req *request.Request, output *CreateJourneyOutput) {
	op := &request.Operation{
		Name:       opCreateJourney,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/journeys",
	}

	if input == nil {
		input = &CreateJourneyInput{}
	}

	output = &CreateJourneyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJourney API operation for Amazon Pinpoint.
//
// Creates a journey for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateJourney for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateJourney
func (c *Pinpoint) CreateJourney(input *CreateJourneyInput) (*CreateJourneyOutput, error) {
	req, out := c.CreateJourneyRequest(input)
	return out, req.Send()
}

// CreateJourneyWithContext is the same as CreateJourney with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJourney for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateJourneyWithContext(ctx aws.Context, input *CreateJourneyInput, opts ...request.Option) (*CreateJourneyOutput, error) {
	req, out := c.CreateJourneyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePushTemplate = "CreatePushTemplate"

// CreatePushTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreatePushTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePushTemplate for more information on using the CreatePushTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePushTemplateRequest method.
//    req, resp := client.CreatePushTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreatePushTemplate
func (c *Pinpoint) CreatePushTemplateRequest(input *CreatePushTemplateInput) (req *request.Request, output *CreatePushTemplateOutput) {
	op := &request.Operation{
		Name:       opCreatePushTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/templates/{template-name}/push",
	}

	if input == nil {
		input = &CreatePushTemplateInput{}
	}

	output = &CreatePushTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePushTemplate API operation for Amazon Pinpoint.
//
// Creates a message template for messages that are sent through a push notification
// channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreatePushTemplate for usage and error information.
//
// Returned Error Types:
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreatePushTemplate
func (c *Pinpoint) CreatePushTemplate(input *CreatePushTemplateInput) (*CreatePushTemplateOutput, error) {
	req, out := c.CreatePushTemplateRequest(input)
	return out, req.Send()
}

// CreatePushTemplateWithContext is the same as CreatePushTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePushTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreatePushTemplateWithContext(ctx aws.Context, input *CreatePushTemplateInput, opts ...request.Option) (*CreatePushTemplateOutput, error) {
	req, out := c.CreatePushTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRecommenderConfiguration = "CreateRecommenderConfiguration"

// CreateRecommenderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateRecommenderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRecommenderConfiguration for more information on using the CreateRecommenderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRecommenderConfigurationRequest method.
//    req, resp := client.CreateRecommenderConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateRecommenderConfiguration
func (c *Pinpoint) CreateRecommenderConfigurationRequest(input *CreateRecommenderConfigurationInput) (req *request.Request, output *CreateRecommenderConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateRecommenderConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/recommenders",
	}

	if input == nil {
		input = &CreateRecommenderConfigurationInput{}
	}

	output = &CreateRecommenderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRecommenderConfiguration API operation for Amazon Pinpoint.
//
// Creates an Amazon Pinpoint configuration for a recommender model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateRecommenderConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateRecommenderConfiguration
func (c *Pinpoint) CreateRecommenderConfiguration(input *CreateRecommenderConfigurationInput) (*CreateRecommenderConfigurationOutput, error) {
	req, out := c.CreateRecommenderConfigurationRequest(input)
	return out, req.Send()
}

// CreateRecommenderConfigurationWithContext is the same as CreateRecommenderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRecommenderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateRecommenderConfigurationWithContext(ctx aws.Context, input *CreateRecommenderConfigurationInput, opts ...request.Option) (*CreateRecommenderConfigurationOutput, error) {
	req, out := c.CreateRecommenderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSegment = "CreateSegment"

// CreateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSegment for more information on using the CreateSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSegmentRequest method.
//    req, resp := client.CreateSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment
func (c *Pinpoint) CreateSegmentRequest(input *CreateSegmentInput) (req *request.Request, output *CreateSegmentOutput) {
	op := &request.Operation{
		Name:       opCreateSegment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/segments",
	}

	if input == nil {
		input = &CreateSegmentInput{}
	}

	output = &CreateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSegment API operation for Amazon Pinpoint.
//
// Creates a new segment for an application or updates the configuration, dimension,
// and other settings for an existing segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateSegment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment
func (c *Pinpoint) CreateSegment(input *CreateSegmentInput) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	return out, req.Send()
}

// CreateSegmentWithContext is the same as CreateSegment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateSegmentWithContext(ctx aws.Context, input *CreateSegmentInput, opts ...request.Option) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSmsTemplate = "CreateSmsTemplate"

// CreateSmsTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateSmsTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSmsTemplate for more information on using the CreateSmsTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSmsTemplateRequest method.
//    req, resp := client.CreateSmsTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSmsTemplate
func (c *Pinpoint) CreateSmsTemplateRequest(input *CreateSmsTemplateInput) (req *request.Request, output *CreateSmsTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateSmsTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/templates/{template-name}/sms",
	}

	if input == nil {
		input = &CreateSmsTemplateInput{}
	}

	output = &CreateSmsTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSmsTemplate API operation for Amazon Pinpoint.
//
// Creates a message template for messages that are sent through the SMS channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateSmsTemplate for usage and error information.
//
// Returned Error Types:
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSmsTemplate
func (c *Pinpoint) CreateSmsTemplate(input *CreateSmsTemplateInput) (*CreateSmsTemplateOutput, error) {
	req, out := c.CreateSmsTemplateRequest(input)
	return out, req.Send()
}

// CreateSmsTemplateWithContext is the same as CreateSmsTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSmsTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateSmsTemplateWithContext(ctx aws.Context, input *CreateSmsTemplateInput, opts ...request.Option) (*CreateSmsTemplateOutput, error) {
	req, out := c.CreateSmsTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVoiceTemplate = "CreateVoiceTemplate"

// CreateVoiceTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateVoiceTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVoiceTemplate for more information on using the CreateVoiceTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVoiceTemplateRequest method.
//    req, resp := client.CreateVoiceTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateVoiceTemplate
func (c *Pinpoint) CreateVoiceTemplateRequest(input *CreateVoiceTemplateInput) (req *request.Request, output *CreateVoiceTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateVoiceTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/templates/{template-name}/voice",
	}

	if input == nil {
		input = &CreateVoiceTemplateInput{}
	}

	output = &CreateVoiceTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVoiceTemplate API operation for Amazon Pinpoint.
//
// Creates a message template for messages that are sent through the voice channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateVoiceTemplate for usage and error information.
//
// Returned Error Types:
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateVoiceTemplate
func (c *Pinpoint) CreateVoiceTemplate(input *CreateVoiceTemplateInput) (*CreateVoiceTemplateOutput, error) {
	req, out := c.CreateVoiceTemplateRequest(input)
	return out, req.Send()
}

// CreateVoiceTemplateWithContext is the same as CreateVoiceTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVoiceTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateVoiceTemplateWithContext(ctx aws.Context, input *CreateVoiceTemplateInput, opts ...request.Option) (*CreateVoiceTemplateOutput, error) {
	req, out := c.CreateVoiceTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAdmChannel = "DeleteAdmChannel"

// DeleteAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAdmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAdmChannel for more information on using the DeleteAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAdmChannelRequest method.
//    req, resp := client.DeleteAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel
func (c *Pinpoint) DeleteAdmChannelRequest(input *DeleteAdmChannelInput) (req *request.Request, output *DeleteAdmChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteAdmChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &DeleteAdmChannelInput{}
	}

	output = &DeleteAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAdmChannel API operation for Amazon Pinpoint.
//
// Disables the ADM channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteAdmChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel
func (c *Pinpoint) DeleteAdmChannel(input *DeleteAdmChannelInput) (*DeleteAdmChannelOutput, error) {
	req, out := c.DeleteAdmChannelRequest(input)
	return out, req.Send()
}

// DeleteAdmChannelWithContext is the same as DeleteAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteAdmChannelWithContext(ctx aws.Context, input *DeleteAdmChannelInput, opts ...request.Option) (*DeleteAdmChannelOutput, error) {
	req, out := c.DeleteAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsChannel = "DeleteApnsChannel"

// DeleteApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsChannel for more information on using the DeleteApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsChannelRequest method.
//    req, resp := client.DeleteApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel
func (c *Pinpoint) DeleteApnsChannelRequest(input *DeleteApnsChannelInput) (req *request.Request, output *DeleteApnsChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &DeleteApnsChannelInput{}
	}

	output = &DeleteApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsChannel API operation for Amazon Pinpoint.
//
// Disables the APNs channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel
func (c *Pinpoint) DeleteApnsChannel(input *DeleteApnsChannelInput) (*DeleteApnsChannelOutput, error) {
	req, out := c.DeleteApnsChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsChannelWithContext is the same as DeleteApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsChannelWithContext(ctx aws.Context, input *DeleteApnsChannelInput, opts ...request.Option) (*DeleteApnsChannelOutput, error) {
	req, out := c.DeleteApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsSandboxChannel = "DeleteApnsSandboxChannel"

// DeleteApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsSandboxChannel for more information on using the DeleteApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsSandboxChannelRequest method.
//    req, resp := client.DeleteApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel
func (c *Pinpoint) DeleteApnsSandboxChannelRequest(input *DeleteApnsSandboxChannelInput) (req *request.Request, output *DeleteApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsSandboxChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &DeleteApnsSandboxChannelInput{}
	}

	output = &DeleteApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Disables the APNs sandbox channel for an application and deletes any existing
// settings for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsSandboxChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel
func (c *Pinpoint) DeleteApnsSandboxChannel(input *DeleteApnsSandboxChannelInput) (*DeleteApnsSandboxChannelOutput, error) {
	req, out := c.DeleteApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsSandboxChannelWithContext is the same as DeleteApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsSandboxChannelWithContext(ctx aws.Context, input *DeleteApnsSandboxChannelInput, opts ...request.Option) (*DeleteApnsSandboxChannelOutput, error) {
	req, out := c.DeleteApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsVoipChannel = "DeleteApnsVoipChannel"

// DeleteApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsVoipChannel for more information on using the DeleteApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsVoipChannelRequest method.
//    req, resp := client.DeleteApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel
func (c *Pinpoint) DeleteApnsVoipChannelRequest(input *DeleteApnsVoipChannelInput) (req *request.Request, output *DeleteApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsVoipChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &DeleteApnsVoipChannelInput{}
	}

	output = &DeleteApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsVoipChannel API operation for Amazon Pinpoint.
//
// Disables the APNs VoIP channel for an application and deletes any existing
// settings for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsVoipChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel
func (c *Pinpoint) DeleteApnsVoipChannel(input *DeleteApnsVoipChannelInput) (*DeleteApnsVoipChannelOutput, error) {
	req, out := c.DeleteApnsVoipChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsVoipChannelWithContext is the same as DeleteApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsVoipChannelWithContext(ctx aws.Context, input *DeleteApnsVoipChannelInput, opts ...request.Option) (*DeleteApnsVoipChannelOutput, error) {
	req, out := c.DeleteApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsVoipSandboxChannel = "DeleteApnsVoipSandboxChannel"

// DeleteApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsVoipSandboxChannel for more information on using the DeleteApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsVoipSandboxChannelRequest method.
//    req, resp := client.DeleteApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel
func (c *Pinpoint) DeleteApnsVoipSandboxChannelRequest(input *DeleteApnsVoipSandboxChannelInput) (req *request.Request, output *DeleteApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsVoipSandboxChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &DeleteApnsVoipSandboxChannelInput{}
	}

	output = &DeleteApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Disables the APNs VoIP sandbox channel for an application and deletes any
// existing settings for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel
func (c *Pinpoint) DeleteApnsVoipSandboxChannel(input *DeleteApnsVoipSandboxChannelInput) (*DeleteApnsVoipSandboxChannelOutput, error) {
	req, out := c.DeleteApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsVoipSandboxChannelWithContext is the same as DeleteApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsVoipSandboxChannelWithContext(ctx aws.Context, input *DeleteApnsVoipSandboxChannelInput, opts ...request.Option) (*DeleteApnsVoipSandboxChannelOutput, error) {
	req, out := c.DeleteApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppRequest method.
//    req, resp := client.DeleteAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp
func (c *Pinpoint) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApp API operation for Amazon Pinpoint.
//
// Deletes an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApp for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp
func (c *Pinpoint) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBaiduChannel = "DeleteBaiduChannel"

// DeleteBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBaiduChannel for more information on using the DeleteBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBaiduChannelRequest method.
//    req, resp := client.DeleteBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel
func (c *Pinpoint) DeleteBaiduChannelRequest(input *DeleteBaiduChannelInput) (req *request.Request, output *DeleteBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteBaiduChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &DeleteBaiduChannelInput{}
	}

	output = &DeleteBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBaiduChannel API operation for Amazon Pinpoint.
//
// Disables the Baidu channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteBaiduChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel
func (c *Pinpoint) DeleteBaiduChannel(input *DeleteBaiduChannelInput) (*DeleteBaiduChannelOutput, error) {
	req, out := c.DeleteBaiduChannelRequest(input)
	return out, req.Send()
}

// DeleteBaiduChannelWithContext is the same as DeleteBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteBaiduChannelWithContext(ctx aws.Context, input *DeleteBaiduChannelInput, opts ...request.Option) (*DeleteBaiduChannelOutput, error) {
	req, out := c.DeleteBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCampaign for more information on using the DeleteCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCampaignRequest method.
//    req, resp := client.DeleteCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign
func (c *Pinpoint) DeleteCampaignRequest(input *DeleteCampaignInput) (req *request.Request, output *DeleteCampaignOutput) {
	op := &request.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	output = &DeleteCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCampaign API operation for Amazon Pinpoint.
//
// Deletes a campaign from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteCampaign for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign
func (c *Pinpoint) DeleteCampaign(input *DeleteCampaignInput) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	return out, req.Send()
}

// DeleteCampaignWithContext is the same as DeleteCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteCampaignWithContext(ctx aws.Context, input *DeleteCampaignInput, opts ...request.Option) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEmailChannel = "DeleteEmailChannel"

// DeleteEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEmailChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEmailChannel for more information on using the DeleteEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEmailChannelRequest method.
//    req, resp := client.DeleteEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel
func (c *Pinpoint) DeleteEmailChannelRequest(input *DeleteEmailChannelInput) (req *request.Request, output *DeleteEmailChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteEmailChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &DeleteEmailChannelInput{}
	}

	output = &DeleteEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEmailChannel API operation for Amazon Pinpoint.
//
// Disables the email channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEmailChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel
func (c *Pinpoint) DeleteEmailChannel(input *DeleteEmailChannelInput) (*DeleteEmailChannelOutput, error) {
	req, out := c.DeleteEmailChannelRequest(input)
	return out, req.Send()
}

// DeleteEmailChannelWithContext is the same as DeleteEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEmailChannelWithContext(ctx aws.Context, input *DeleteEmailChannelInput, opts ...request.Option) (*DeleteEmailChannelOutput, error) {
	req, out := c.DeleteEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEmailTemplate = "DeleteEmailTemplate"

// DeleteEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEmailTemplate for more information on using the DeleteEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEmailTemplateRequest method.
//    req, resp := client.DeleteEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailTemplate
func (c *Pinpoint) DeleteEmailTemplateRequest(input *DeleteEmailTemplateInput) (req *request.Request, output *DeleteEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteEmailTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/templates/{template-name}/email",
	}

	if input == nil {
		input = &DeleteEmailTemplateInput{}
	}

	output = &DeleteEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEmailTemplate API operation for Amazon Pinpoint.
//
// Deletes a message template for messages that were sent through the email
// channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailTemplate
func (c *Pinpoint) DeleteEmailTemplate(input *DeleteEmailTemplateInput) (*DeleteEmailTemplateOutput, error) {
	req, out := c.DeleteEmailTemplateRequest(input)
	return out, req.Send()
}

// DeleteEmailTemplateWithContext is the same as DeleteEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEmailTemplateWithContext(ctx aws.Context, input *DeleteEmailTemplateInput, opts ...request.Option) (*DeleteEmailTemplateOutput, error) {
	req, out := c.DeleteEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint
func (c *Pinpoint) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEndpoint API operation for Amazon Pinpoint.
//
// Deletes an endpoint from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint
func (c *Pinpoint) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventStream = "DeleteEventStream"

// DeleteEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventStream for more information on using the DeleteEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventStreamRequest method.
//    req, resp := client.DeleteEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream
func (c *Pinpoint) DeleteEventStreamRequest(input *DeleteEventStreamInput) (req *request.Request, output *DeleteEventStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteEventStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &DeleteEventStreamInput{}
	}

	output = &DeleteEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventStream API operation for Amazon Pinpoint.
//
// Deletes the event stream for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEventStream for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream
func (c *Pinpoint) DeleteEventStream(input *DeleteEventStreamInput) (*DeleteEventStreamOutput, error) {
	req, out := c.DeleteEventStreamRequest(input)
	return out, req.Send()
}

// DeleteEventStreamWithContext is the same as DeleteEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEventStreamWithContext(ctx aws.Context, input *DeleteEventStreamInput, opts ...request.Option) (*DeleteEventStreamOutput, error) {
	req, out := c.DeleteEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGcmChannel = "DeleteGcmChannel"

// DeleteGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGcmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGcmChannel for more information on using the DeleteGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGcmChannelRequest method.
//    req, resp := client.DeleteGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel
func (c *Pinpoint) DeleteGcmChannelRequest(input *DeleteGcmChannelInput) (req *request.Request, output *DeleteGcmChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteGcmChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &DeleteGcmChannelInput{}
	}

	output = &DeleteGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGcmChannel API operation for Amazon Pinpoint.
//
// Disables the GCM channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteGcmChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel
func (c *Pinpoint) DeleteGcmChannel(input *DeleteGcmChannelInput) (*DeleteGcmChannelOutput, error) {
	req, out := c.DeleteGcmChannelRequest(input)
	return out, req.Send()
}

// DeleteGcmChannelWithContext is the same as DeleteGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteGcmChannelWithContext(ctx aws.Context, input *DeleteGcmChannelInput, opts ...request.Option) (*DeleteGcmChannelOutput, error) {
	req, out := c.DeleteGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJourney = "DeleteJourney"

// DeleteJourneyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJourney operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJourney for more information on using the DeleteJourney
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJourneyRequest method.
//    req, resp := client.DeleteJourneyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteJourney
func (c *Pinpoint) DeleteJourneyRequest(input *DeleteJourneyInput) (req *request.Request, output *DeleteJourneyOutput) {
	op := &request.Operation{
		Name:       opDeleteJourney,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}",
	}

	if input == nil {
		input = &DeleteJourneyInput{}
	}

	output = &DeleteJourneyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteJourney API operation for Amazon Pinpoint.
//
// Deletes a journey from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteJourney for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteJourney
func (c *Pinpoint) DeleteJourney(input *DeleteJourneyInput) (*DeleteJourneyOutput, error) {
	req, out := c.DeleteJourneyRequest(input)
	return out, req.Send()
}

// DeleteJourneyWithContext is the same as DeleteJourney with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJourney for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteJourneyWithContext(ctx aws.Context, input *DeleteJourneyInput, opts ...request.Option) (*DeleteJourneyOutput, error) {
	req, out := c.DeleteJourneyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePushTemplate = "DeletePushTemplate"

// DeletePushTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeletePushTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePushTemplate for more information on using the DeletePushTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePushTemplateRequest method.
//    req, resp := client.DeletePushTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeletePushTemplate
func (c *Pinpoint) DeletePushTemplateRequest(input *DeletePushTemplateInput) (req *request.Request, output *DeletePushTemplateOutput) {
	op := &request.Operation{
		Name:       opDeletePushTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/templates/{template-name}/push",
	}

	if input == nil {
		input = &DeletePushTemplateInput{}
	}

	output = &DeletePushTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePushTemplate API operation for Amazon Pinpoint.
//
// Deletes a message template for messages that were sent through a push notification
// channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeletePushTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeletePushTemplate
func (c *Pinpoint) DeletePushTemplate(input *DeletePushTemplateInput) (*DeletePushTemplateOutput, error) {
	req, out := c.DeletePushTemplateRequest(input)
	return out, req.Send()
}

// DeletePushTemplateWithContext is the same as DeletePushTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePushTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeletePushTemplateWithContext(ctx aws.Context, input *DeletePushTemplateInput, opts ...request.Option) (*DeletePushTemplateOutput, error) {
	req, out := c.DeletePushTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecommenderConfiguration = "DeleteRecommenderConfiguration"

// DeleteRecommenderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecommenderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecommenderConfiguration for more information on using the DeleteRecommenderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRecommenderConfigurationRequest method.
//    req, resp := client.DeleteRecommenderConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteRecommenderConfiguration
func (c *Pinpoint) DeleteRecommenderConfigurationRequest(input *DeleteRecommenderConfigurationInput) (req *request.Request, output *DeleteRecommenderConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteRecommenderConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/recommenders/{recommender-id}",
	}

	if input == nil {
		input = &DeleteRecommenderConfigurationInput{}
	}

	output = &DeleteRecommenderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRecommenderConfiguration API operation for Amazon Pinpoint.
//
// Deletes an Amazon Pinpoint configuration for a recommender model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteRecommenderConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteRecommenderConfiguration
func (c *Pinpoint) DeleteRecommenderConfiguration(input *DeleteRecommenderConfigurationInput) (*DeleteRecommenderConfigurationOutput, error) {
	req, out := c.DeleteRecommenderConfigurationRequest(input)
	return out, req.Send()
}

// DeleteRecommenderConfigurationWithContext is the same as DeleteRecommenderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecommenderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteRecommenderConfigurationWithContext(ctx aws.Context, input *DeleteRecommenderConfigurationInput, opts ...request.Option) (*DeleteRecommenderConfigurationOutput, error) {
	req, out := c.DeleteRecommenderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSegment = "DeleteSegment"

// DeleteSegmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSegment for more information on using the DeleteSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSegmentRequest method.
//    req, resp := client.DeleteSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment
func (c *Pinpoint) DeleteSegmentRequest(input *DeleteSegmentInput) (req *request.Request, output *DeleteSegmentOutput) {
	op := &request.Operation{
		Name:       opDeleteSegment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &DeleteSegmentInput{}
	}

	output = &DeleteSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSegment API operation for Amazon Pinpoint.
//
// Deletes a segment from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteSegment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment
func (c *Pinpoint) DeleteSegment(input *DeleteSegmentInput) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	return out, req.Send()
}

// DeleteSegmentWithContext is the same as DeleteSegment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteSegmentWithContext(ctx aws.Context, input *DeleteSegmentInput, opts ...request.Option) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSmsChannel = "DeleteSmsChannel"

// DeleteSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSmsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSmsChannel for more information on using the DeleteSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSmsChannelRequest method.
//    req, resp := client.DeleteSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel
func (c *Pinpoint) DeleteSmsChannelRequest(input *DeleteSmsChannelInput) (req *request.Request, output *DeleteSmsChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteSmsChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &DeleteSmsChannelInput{}
	}

	output = &DeleteSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSmsChannel API operation for Amazon Pinpoint.
//
// Disables the SMS channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteSmsChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel
func (c *Pinpoint) DeleteSmsChannel(input *DeleteSmsChannelInput) (*DeleteSmsChannelOutput, error) {
	req, out := c.DeleteSmsChannelRequest(input)
	return out, req.Send()
}

// DeleteSmsChannelWithContext is the same as DeleteSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteSmsChannelWithContext(ctx aws.Context, input *DeleteSmsChannelInput, opts ...request.Option) (*DeleteSmsChannelOutput, error) {
	req, out := c.DeleteSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSmsTemplate = "DeleteSmsTemplate"

// DeleteSmsTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSmsTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSmsTemplate for more information on using the DeleteSmsTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSmsTemplateRequest method.
//    req, resp := client.DeleteSmsTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsTemplate
func (c *Pinpoint) DeleteSmsTemplateRequest(input *DeleteSmsTemplateInput) (req *request.Request, output *DeleteSmsTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteSmsTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/templates/{template-name}/sms",
	}

	if input == nil {
		input = &DeleteSmsTemplateInput{}
	}

	output = &DeleteSmsTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSmsTemplate API operation for Amazon Pinpoint.
//
// Deletes a message template for messages that were sent through the SMS channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteSmsTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsTemplate
func (c *Pinpoint) DeleteSmsTemplate(input *DeleteSmsTemplateInput) (*DeleteSmsTemplateOutput, error) {
	req, out := c.DeleteSmsTemplateRequest(input)
	return out, req.Send()
}

// DeleteSmsTemplateWithContext is the same as DeleteSmsTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSmsTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteSmsTemplateWithContext(ctx aws.Context, input *DeleteSmsTemplateInput, opts ...request.Option) (*DeleteSmsTemplateOutput, error) {
	req, out := c.DeleteSmsTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserEndpoints = "DeleteUserEndpoints"

// DeleteUserEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserEndpoints for more information on using the DeleteUserEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserEndpointsRequest method.
//    req, resp := client.DeleteUserEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints
func (c *Pinpoint) DeleteUserEndpointsRequest(input *DeleteUserEndpointsInput) (req *request.Request, output *DeleteUserEndpointsOutput) {
	op := &request.Operation{
		Name:       opDeleteUserEndpoints,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/users/{user-id}",
	}

	if input == nil {
		input = &DeleteUserEndpointsInput{}
	}

	output = &DeleteUserEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserEndpoints API operation for Amazon Pinpoint.
//
// Deletes all the endpoints that are associated with a specific user ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteUserEndpoints for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints
func (c *Pinpoint) DeleteUserEndpoints(input *DeleteUserEndpointsInput) (*DeleteUserEndpointsOutput, error) {
	req, out := c.DeleteUserEndpointsRequest(input)
	return out, req.Send()
}

// DeleteUserEndpointsWithContext is the same as DeleteUserEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteUserEndpointsWithContext(ctx aws.Context, input *DeleteUserEndpointsInput, opts ...request.Option) (*DeleteUserEndpointsOutput, error) {
	req, out := c.DeleteUserEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceChannel = "DeleteVoiceChannel"

// DeleteVoiceChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceChannel for more information on using the DeleteVoiceChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceChannelRequest method.
//    req, resp := client.DeleteVoiceChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel
func (c *Pinpoint) DeleteVoiceChannelRequest(input *DeleteVoiceChannelInput) (req *request.Request, output *DeleteVoiceChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/voice",
	}

	if input == nil {
		input = &DeleteVoiceChannelInput{}
	}

	output = &DeleteVoiceChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVoiceChannel API operation for Amazon Pinpoint.
//
// Disables the voice channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteVoiceChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel
func (c *Pinpoint) DeleteVoiceChannel(input *DeleteVoiceChannelInput) (*DeleteVoiceChannelOutput, error) {
	req, out := c.DeleteVoiceChannelRequest(input)
	return out, req.Send()
}

// DeleteVoiceChannelWithContext is the same as DeleteVoiceChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteVoiceChannelWithContext(ctx aws.Context, input *DeleteVoiceChannelInput, opts ...request.Option) (*DeleteVoiceChannelOutput, error) {
	req, out := c.DeleteVoiceChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceTemplate = "DeleteVoiceTemplate"

// DeleteVoiceTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceTemplate for more information on using the DeleteVoiceTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceTemplateRequest method.
//    req, resp := client.DeleteVoiceTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceTemplate
func (c *Pinpoint) DeleteVoiceTemplateRequest(input *DeleteVoiceTemplateInput) (req *request.Request, output *DeleteVoiceTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/templates/{template-name}/voice",
	}

	if input == nil {
		input = &DeleteVoiceTemplateInput{}
	}

	output = &DeleteVoiceTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVoiceTemplate API operation for Amazon Pinpoint.
//
// Deletes a message template for messages that were sent through the voice
// channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteVoiceTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceTemplate
func (c *Pinpoint) DeleteVoiceTemplate(input *DeleteVoiceTemplateInput) (*DeleteVoiceTemplateOutput, error) {
	req, out := c.DeleteVoiceTemplateRequest(input)
	return out, req.Send()
}

// DeleteVoiceTemplateWithContext is the same as DeleteVoiceTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteVoiceTemplateWithContext(ctx aws.Context, input *DeleteVoiceTemplateInput, opts ...request.Option) (*DeleteVoiceTemplateOutput, error) {
	req, out := c.DeleteVoiceTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAdmChannel = "GetAdmChannel"

// GetAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetAdmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAdmChannel for more information on using the GetAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAdmChannelRequest method.
//    req, resp := client.GetAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel
func (c *Pinpoint) GetAdmChannelRequest(input *GetAdmChannelInput) (req *request.Request, output *GetAdmChannelOutput) {
	op := &request.Operation{
		Name:       opGetAdmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &GetAdmChannelInput{}
	}

	output = &GetAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAdmChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the ADM channel for
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetAdmChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel
func (c *Pinpoint) GetAdmChannel(input *GetAdmChannelInput) (*GetAdmChannelOutput, error) {
	req, out := c.GetAdmChannelRequest(input)
	return out, req.Send()
}

// GetAdmChannelWithContext is the same as GetAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAdmChannelWithContext(ctx aws.Context, input *GetAdmChannelInput, opts ...request.Option) (*GetAdmChannelOutput, error) {
	req, out := c.GetAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsChannel = "GetApnsChannel"

// GetApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsChannel for more information on using the GetApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsChannelRequest method.
//    req, resp := client.GetApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel
func (c *Pinpoint) GetApnsChannelRequest(input *GetApnsChannelInput) (req *request.Request, output *GetApnsChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &GetApnsChannelInput{}
	}

	output = &GetApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs channel for
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel
func (c *Pinpoint) GetApnsChannel(input *GetApnsChannelInput) (*GetApnsChannelOutput, error) {
	req, out := c.GetApnsChannelRequest(input)
	return out, req.Send()
}

// GetApnsChannelWithContext is the same as GetApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsChannelWithContext(ctx aws.Context, input *GetApnsChannelInput, opts ...request.Option) (*GetApnsChannelOutput, error) {
	req, out := c.GetApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsSandboxChannel = "GetApnsSandboxChannel"

// GetApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsSandboxChannel for more information on using the GetApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsSandboxChannelRequest method.
//    req, resp := client.GetApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel
func (c *Pinpoint) GetApnsSandboxChannelRequest(input *GetApnsSandboxChannelInput) (req *request.Request, output *GetApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsSandboxChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &GetApnsSandboxChannelInput{}
	}

	output = &GetApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs sandbox channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsSandboxChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel
func (c *Pinpoint) GetApnsSandboxChannel(input *GetApnsSandboxChannelInput) (*GetApnsSandboxChannelOutput, error) {
	req, out := c.GetApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// GetApnsSandboxChannelWithContext is the same as GetApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsSandboxChannelWithContext(ctx aws.Context, input *GetApnsSandboxChannelInput, opts ...request.Option) (*GetApnsSandboxChannelOutput, error) {
	req, out := c.GetApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsVoipChannel = "GetApnsVoipChannel"

// GetApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsVoipChannel for more information on using the GetApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsVoipChannelRequest method.
//    req, resp := client.GetApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel
func (c *Pinpoint) GetApnsVoipChannelRequest(input *GetApnsVoipChannelInput) (req *request.Request, output *GetApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsVoipChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &GetApnsVoipChannelInput{}
	}

	output = &GetApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsVoipChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs VoIP channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsVoipChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel
func (c *Pinpoint) GetApnsVoipChannel(input *GetApnsVoipChannelInput) (*GetApnsVoipChannelOutput, error) {
	req, out := c.GetApnsVoipChannelRequest(input)
	return out, req.Send()
}

// GetApnsVoipChannelWithContext is the same as GetApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsVoipChannelWithContext(ctx aws.Context, input *GetApnsVoipChannelInput, opts ...request.Option) (*GetApnsVoipChannelOutput, error) {
	req, out := c.GetApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsVoipSandboxChannel = "GetApnsVoipSandboxChannel"

// GetApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsVoipSandboxChannel for more information on using the GetApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsVoipSandboxChannelRequest method.
//    req, resp := client.GetApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel
func (c *Pinpoint) GetApnsVoipSandboxChannelRequest(input *GetApnsVoipSandboxChannelInput) (req *request.Request, output *GetApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsVoipSandboxChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &GetApnsVoipSandboxChannelInput{}
	}

	output = &GetApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs VoIP sandbox
// channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel
func (c *Pinpoint) GetApnsVoipSandboxChannel(input *GetApnsVoipSandboxChannelInput) (*GetApnsVoipSandboxChannelOutput, error) {
	req, out := c.GetApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// GetApnsVoipSandboxChannelWithContext is the same as GetApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsVoipSandboxChannelWithContext(ctx aws.Context, input *GetApnsVoipSandboxChannelInput, opts ...request.Option) (*GetApnsVoipSandboxChannelOutput, error) {
	req, out := c.GetApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApp = "GetApp"

// GetAppRequest generates a "aws/request.Request" representing the
// client's request for the GetApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApp for more information on using the GetApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppRequest method.
//    req, resp := client.GetAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp
func (c *Pinpoint) GetAppRequest(input *GetAppInput) (req *request.Request, output *GetAppOutput) {
	op := &request.Operation{
		Name:       opGetApp,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}",
	}

	if input == nil {
		input = &GetAppInput{}
	}

	output = &GetAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApp API operation for Amazon Pinpoint.
//
// Retrieves information about an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApp for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp
func (c *Pinpoint) GetApp(input *GetAppInput) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	return out, req.Send()
}

// GetAppWithContext is the same as GetApp with the addition of
// the ability to pass a context and additional request options.
//
// See GetApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAppWithContext(ctx aws.Context, input *GetAppInput, opts ...request.Option) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationDateRangeKpi = "GetApplicationDateRangeKpi"

// GetApplicationDateRangeKpiRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationDateRangeKpi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationDateRangeKpi for more information on using the GetApplicationDateRangeKpi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationDateRangeKpiRequest method.
//    req, resp := client.GetApplicationDateRangeKpiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi
func (c *Pinpoint) GetApplicationDateRangeKpiRequest(input *GetApplicationDateRangeKpiInput) (req *request.Request, output *GetApplicationDateRangeKpiOutput) {
	op := &request.Operation{
		Name:       opGetApplicationDateRangeKpi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/kpis/daterange/{kpi-name}",
	}

	if input == nil {
		input = &GetApplicationDateRangeKpiInput{}
	}

	output = &GetApplicationDateRangeKpiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationDateRangeKpi API operation for Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard metric that applies
// to an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApplicationDateRangeKpi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi
func (c *Pinpoint) GetApplicationDateRangeKpi(input *GetApplicationDateRangeKpiInput) (*GetApplicationDateRangeKpiOutput, error) {
	req, out := c.GetApplicationDateRangeKpiRequest(input)
	return out, req.Send()
}

// GetApplicationDateRangeKpiWithContext is the same as GetApplicationDateRangeKpi with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationDateRangeKpi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApplicationDateRangeKpiWithContext(ctx aws.Context, input *GetApplicationDateRangeKpiInput, opts ...request.Option) (*GetApplicationDateRangeKpiOutput, error) {
	req, out := c.GetApplicationDateRangeKpiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationSettings = "GetApplicationSettings"

// GetApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationSettings for more information on using the GetApplicationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationSettingsRequest method.
//    req, resp := client.GetApplicationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings
func (c *Pinpoint) GetApplicationSettingsRequest(input *GetApplicationSettingsInput) (req *request.Request, output *GetApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opGetApplicationSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/settings",
	}

	if input == nil {
		input = &GetApplicationSettingsInput{}
	}

	output = &GetApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationSettings API operation for Amazon Pinpoint.
//
// Retrieves information about the settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApplicationSettings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings
func (c *Pinpoint) GetApplicationSettings(input *GetApplicationSettingsInput) (*GetApplicationSettingsOutput, error) {
	req, out := c.GetApplicationSettingsRequest(input)
	return out, req.Send()
}

// GetApplicationSettingsWithContext is the same as GetApplicationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApplicationSettingsWithContext(ctx aws.Context, input *GetApplicationSettingsInput, opts ...request.Option) (*GetApplicationSettingsOutput, error) {
	req, out := c.GetApplicationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApps = "GetApps"

// GetAppsRequest generates a "aws/request.Request" representing the
// client's request for the GetApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApps for more information on using the GetApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppsRequest method.
//    req, resp := client.GetAppsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps
func (c *Pinpoint) GetAppsRequest(input *GetAppsInput) (req *request.Request, output *GetAppsOutput) {
	op := &request.Operation{
		Name:       opGetApps,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps",
	}

	if input == nil {
		input = &GetAppsInput{}
	}

	output = &GetAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApps API operation for Amazon Pinpoint.
//
// Retrieves information about all the applications that are associated with
// your Amazon Pinpoint account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApps for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps
func (c *Pinpoint) GetApps(input *GetAppsInput) (*GetAppsOutput, error) {
	req, out := c.GetAppsRequest(input)
	return out, req.Send()
}

// GetAppsWithContext is the same as GetApps with the addition of
// the ability to pass a context and additional request options.
//
// See GetApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAppsWithContext(ctx aws.Context, input *GetAppsInput, opts ...request.Option) (*GetAppsOutput, error) {
	req, out := c.GetAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBaiduChannel = "GetBaiduChannel"

// GetBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBaiduChannel for more information on using the GetBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBaiduChannelRequest method.
//    req, resp := client.GetBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel
func (c *Pinpoint) GetBaiduChannelRequest(input *GetBaiduChannelInput) (req *request.Request, output *GetBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opGetBaiduChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &GetBaiduChannelInput{}
	}

	output = &GetBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBaiduChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the Baidu channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetBaiduChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel
func (c *Pinpoint) GetBaiduChannel(input *GetBaiduChannelInput) (*GetBaiduChannelOutput, error) {
	req, out := c.GetBaiduChannelRequest(input)
	return out, req.Send()
}

// GetBaiduChannelWithContext is the same as GetBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetBaiduChannelWithContext(ctx aws.Context, input *GetBaiduChannelInput, opts ...request.Option) (*GetBaiduChannelOutput, error) {
	req, out := c.GetBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaign = "GetCampaign"

// GetCampaignRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaign for more information on using the GetCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignRequest method.
//    req, resp := client.GetCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign
func (c *Pinpoint) GetCampaignRequest(input *GetCampaignInput) (req *request.Request, output *GetCampaignOutput) {
	op := &request.Operation{
		Name:       opGetCampaign,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &GetCampaignInput{}
	}

	output = &GetCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaign API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaign for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign
func (c *Pinpoint) GetCampaign(input *GetCampaignInput) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	return out, req.Send()
}

// GetCampaignWithContext is the same as GetCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignWithContext(ctx aws.Context, input *GetCampaignInput, opts ...request.Option) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignActivities = "GetCampaignActivities"

// GetCampaignActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignActivities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignActivities for more information on using the GetCampaignActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignActivitiesRequest method.
//    req, resp := client.GetCampaignActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities
func (c *Pinpoint) GetCampaignActivitiesRequest(input *GetCampaignActivitiesInput) (req *request.Request, output *GetCampaignActivitiesOutput) {
	op := &request.Operation{
		Name:       opGetCampaignActivities,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/activities",
	}

	if input == nil {
		input = &GetCampaignActivitiesInput{}
	}

	output = &GetCampaignActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignActivities API operation for Amazon Pinpoint.
//
// Retrieves information about all the activities for a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignActivities for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities
func (c *Pinpoint) GetCampaignActivities(input *GetCampaignActivitiesInput) (*GetCampaignActivitiesOutput, error) {
	req, out := c.GetCampaignActivitiesRequest(input)
	return out, req.Send()
}

// GetCampaignActivitiesWithContext is the same as GetCampaignActivities with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignActivitiesWithContext(ctx aws.Context, input *GetCampaignActivitiesInput, opts ...request.Option) (*GetCampaignActivitiesOutput, error) {
	req, out := c.GetCampaignActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignDateRangeKpi = "GetCampaignDateRangeKpi"

// GetCampaignDateRangeKpiRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignDateRangeKpi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignDateRangeKpi for more information on using the GetCampaignDateRangeKpi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignDateRangeKpiRequest method.
//    req, resp := client.GetCampaignDateRangeKpiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi
func (c *Pinpoint) GetCampaignDateRangeKpiRequest(input *GetCampaignDateRangeKpiInput) (req *request.Request, output *GetCampaignDateRangeKpiOutput) {
	op := &request.Operation{
		Name:       opGetCampaignDateRangeKpi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/kpis/daterange/{kpi-name}",
	}

	if input == nil {
		input = &GetCampaignDateRangeKpiInput{}
	}

	output = &GetCampaignDateRangeKpiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignDateRangeKpi API operation for Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard metric that applies
// to a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignDateRangeKpi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi
func (c *Pinpoint) GetCampaignDateRangeKpi(input *GetCampaignDateRangeKpiInput) (*GetCampaignDateRangeKpiOutput, error) {
	req, out := c.GetCampaignDateRangeKpiRequest(input)
	return out, req.Send()
}

// GetCampaignDateRangeKpiWithContext is the same as GetCampaignDateRangeKpi with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignDateRangeKpi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignDateRangeKpiWithContext(ctx aws.Context, input *GetCampaignDateRangeKpiInput, opts ...request.Option) (*GetCampaignDateRangeKpiOutput, error) {
	req, out := c.GetCampaignDateRangeKpiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignVersion = "GetCampaignVersion"

// GetCampaignVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignVersion for more information on using the GetCampaignVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignVersionRequest method.
//    req, resp := client.GetCampaignVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion
func (c *Pinpoint) GetCampaignVersionRequest(input *GetCampaignVersionInput) (req *request.Request, output *GetCampaignVersionOutput) {
	op := &request.Operation{
		Name:       opGetCampaignVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}",
	}

	if input == nil {
		input = &GetCampaignVersionInput{}
	}

	output = &GetCampaignVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignVersion API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for a specific version of a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion
func (c *Pinpoint) GetCampaignVersion(input *GetCampaignVersionInput) (*GetCampaignVersionOutput, error) {
	req, out := c.GetCampaignVersionRequest(input)
	return out, req.Send()
}

// GetCampaignVersionWithContext is the same as GetCampaignVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignVersionWithContext(ctx aws.Context, input *GetCampaignVersionInput, opts ...request.Option) (*GetCampaignVersionOutput, error) {
	req, out := c.GetCampaignVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignVersions = "GetCampaignVersions"

// GetCampaignVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignVersions for more information on using the GetCampaignVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignVersionsRequest method.
//    req, resp := client.GetCampaignVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions
func (c *Pinpoint) GetCampaignVersionsRequest(input *GetCampaignVersionsInput) (req *request.Request, output *GetCampaignVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCampaignVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/versions",
	}

	if input == nil {
		input = &GetCampaignVersionsInput{}
	}

	output = &GetCampaignVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignVersions API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for all versions of a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions
func (c *Pinpoint) GetCampaignVersions(input *GetCampaignVersionsInput) (*GetCampaignVersionsOutput, error) {
	req, out := c.GetCampaignVersionsRequest(input)
	return out, req.Send()
}

// GetCampaignVersionsWithContext is the same as GetCampaignVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignVersionsWithContext(ctx aws.Context, input *GetCampaignVersionsInput, opts ...request.Option) (*GetCampaignVersionsOutput, error) {
	req, out := c.GetCampaignVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaigns = "GetCampaigns"

// GetCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaigns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaigns for more information on using the GetCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignsRequest method.
//    req, resp := client.GetCampaignsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns
func (c *Pinpoint) GetCampaignsRequest(input *GetCampaignsInput) (req *request.Request, output *GetCampaignsOutput) {
	op := &request.Operation{
		Name:       opGetCampaigns,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns",
	}

	if input == nil {
		input = &GetCampaignsInput{}
	}

	output = &GetCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaigns API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for all the campaigns that are associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaigns for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns
func (c *Pinpoint) GetCampaigns(input *GetCampaignsInput) (*GetCampaignsOutput, error) {
	req, out := c.GetCampaignsRequest(input)
	return out, req.Send()
}

// GetCampaignsWithContext is the same as GetCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignsWithContext(ctx aws.Context, input *GetCampaignsInput, opts ...request.Option) (*GetCampaignsOutput, error) {
	req, out := c.GetCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannels = "GetChannels"

// GetChannelsRequest generates a "aws/request.Request" representing the
// client's request for the GetChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannels for more information on using the GetChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChannelsRequest method.
//    req, resp := client.GetChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels
func (c *Pinpoint) GetChannelsRequest(input *GetChannelsInput) (req *request.Request, output *GetChannelsOutput) {
	op := &request.Operation{
		Name:       opGetChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels",
	}

	if input == nil {
		input = &GetChannelsInput{}
	}

	output = &GetChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannels API operation for Amazon Pinpoint.
//
// Retrieves information about the history and status of each channel for an
// application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetChannels for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels
func (c *Pinpoint) GetChannels(input *GetChannelsInput) (*GetChannelsOutput, error) {
	req, out := c.GetChannelsRequest(input)
	return out, req.Send()
}

// GetChannelsWithContext is the same as GetChannels with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetChannelsWithContext(ctx aws.Context, input *GetChannelsInput, opts ...request.Option) (*GetChannelsOutput, error) {
	req, out := c.GetChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEmailChannel = "GetEmailChannel"

// GetEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetEmailChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEmailChannel for more information on using the GetEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEmailChannelRequest method.
//    req, resp := client.GetEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel
func (c *Pinpoint) GetEmailChannelRequest(input *GetEmailChannelInput) (req *request.Request, output *GetEmailChannelOutput) {
	op := &request.Operation{
		Name:       opGetEmailChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &GetEmailChannelInput{}
	}

	output = &GetEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEmailChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the email channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEmailChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel
func (c *Pinpoint) GetEmailChannel(input *GetEmailChannelInput) (*GetEmailChannelOutput, error) {
	req, out := c.GetEmailChannelRequest(input)
	return out, req.Send()
}

// GetEmailChannelWithContext is the same as GetEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEmailChannelWithContext(ctx aws.Context, input *GetEmailChannelInput, opts ...request.Option) (*GetEmailChannelOutput, error) {
	req, out := c.GetEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEmailTemplate = "GetEmailTemplate"

// GetEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEmailTemplate for more information on using the GetEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEmailTemplateRequest method.
//    req, resp := client.GetEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailTemplate
func (c *Pinpoint) GetEmailTemplateRequest(input *GetEmailTemplateInput) (req *request.Request, output *GetEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opGetEmailTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates/{template-name}/email",
	}

	if input == nil {
		input = &GetEmailTemplateInput{}
	}

	output = &GetEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEmailTemplate API operation for Amazon Pinpoint.
//
// Retrieves the content and settings of a message template for messages that
// are sent through the email channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailTemplate
func (c *Pinpoint) GetEmailTemplate(input *GetEmailTemplateInput) (*GetEmailTemplateOutput, error) {
	req, out := c.GetEmailTemplateRequest(input)
	return out, req.Send()
}

// GetEmailTemplateWithContext is the same as GetEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEmailTemplateWithContext(ctx aws.Context, input *GetEmailTemplateInput, opts ...request.Option) (*GetEmailTemplateOutput, error) {
	req, out := c.GetEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEndpoint = "GetEndpoint"

// GetEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEndpoint for more information on using the GetEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEndpointRequest method.
//    req, resp := client.GetEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint
func (c *Pinpoint) GetEndpointRequest(input *GetEndpointInput) (req *request.Request, output *GetEndpointOutput) {
	op := &request.Operation{
		Name:       opGetEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &GetEndpointInput{}
	}

	output = &GetEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEndpoint API operation for Amazon Pinpoint.
//
// Retrieves information about the settings and attributes of a specific endpoint
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEndpoint for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint
func (c *Pinpoint) GetEndpoint(input *GetEndpointInput) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	return out, req.Send()
}

// GetEndpointWithContext is the same as GetEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEndpointWithContext(ctx aws.Context, input *GetEndpointInput, opts ...request.Option) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventStream = "GetEventStream"

// GetEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventStream for more information on using the GetEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventStreamRequest method.
//    req, resp := client.GetEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream
func (c *Pinpoint) GetEventStreamRequest(input *GetEventStreamInput) (req *request.Request, output *GetEventStreamOutput) {
	op := &request.Operation{
		Name:       opGetEventStream,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &GetEventStreamInput{}
	}

	output = &GetEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventStream API operation for Amazon Pinpoint.
//
// Retrieves information about the event stream settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEventStream for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream
func (c *Pinpoint) GetEventStream(input *GetEventStreamInput) (*GetEventStreamOutput, error) {
	req, out := c.GetEventStreamRequest(input)
	return out, req.Send()
}

// GetEventStreamWithContext is the same as GetEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEventStreamWithContext(ctx aws.Context, input *GetEventStreamInput, opts ...request.Option) (*GetEventStreamOutput, error) {
	req, out := c.GetEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExportJob = "GetExportJob"

// GetExportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExportJob for more information on using the GetExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportJobRequest method.
//    req, resp := client.GetExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob
func (c *Pinpoint) GetExportJobRequest(input *GetExportJobInput) (req *request.Request, output *GetExportJobOutput) {
	op := &request.Operation{
		Name:       opGetExportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export/{job-id}",
	}

	if input == nil {
		input = &GetExportJobInput{}
	}

	output = &GetExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExportJob API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of a specific export
// job for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetExportJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob
func (c *Pinpoint) GetExportJob(input *GetExportJobInput) (*GetExportJobOutput, error) {
	req, out := c.GetExportJobRequest(input)
	return out, req.Send()
}

// GetExportJobWithContext is the same as GetExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetExportJobWithContext(ctx aws.Context, input *GetExportJobInput, opts ...request.Option) (*GetExportJobOutput, error) {
	req, out := c.GetExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExportJobs = "GetExportJobs"

// GetExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExportJobs for more information on using the GetExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportJobsRequest method.
//    req, resp := client.GetExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs
func (c *Pinpoint) GetExportJobsRequest(input *GetExportJobsInput) (req *request.Request, output *GetExportJobsOutput) {
	op := &request.Operation{
		Name:       opGetExportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export",
	}

	if input == nil {
		input = &GetExportJobsInput{}
	}

	output = &GetExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExportJobs API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of all the export jobs
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetExportJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs
func (c *Pinpoint) GetExportJobs(input *GetExportJobsInput) (*GetExportJobsOutput, error) {
	req, out := c.GetExportJobsRequest(input)
	return out, req.Send()
}

// GetExportJobsWithContext is the same as GetExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetExportJobsWithContext(ctx aws.Context, input *GetExportJobsInput, opts ...request.Option) (*GetExportJobsOutput, error) {
	req, out := c.GetExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGcmChannel = "GetGcmChannel"

// GetGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetGcmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGcmChannel for more information on using the GetGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGcmChannelRequest method.
//    req, resp := client.GetGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel
func (c *Pinpoint) GetGcmChannelRequest(input *GetGcmChannelInput) (req *request.Request, output *GetGcmChannelOutput) {
	op := &request.Operation{
		Name:       opGetGcmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &GetGcmChannelInput{}
	}

	output = &GetGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGcmChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the GCM channel for
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetGcmChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel
func (c *Pinpoint) GetGcmChannel(input *GetGcmChannelInput) (*GetGcmChannelOutput, error) {
	req, out := c.GetGcmChannelRequest(input)
	return out, req.Send()
}

// GetGcmChannelWithContext is the same as GetGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetGcmChannelWithContext(ctx aws.Context, input *GetGcmChannelInput, opts ...request.Option) (*GetGcmChannelOutput, error) {
	req, out := c.GetGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImportJob = "GetImportJob"

// GetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImportJob for more information on using the GetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetImportJobRequest method.
//    req, resp := client.GetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob
func (c *Pinpoint) GetImportJobRequest(input *GetImportJobInput) (req *request.Request, output *GetImportJobOutput) {
	op := &request.Operation{
		Name:       opGetImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import/{job-id}",
	}

	if input == nil {
		input = &GetImportJobInput{}
	}

	output = &GetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJob API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of a specific import
// job for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetImportJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob
func (c *Pinpoint) GetImportJob(input *GetImportJobInput) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	return out, req.Send()
}

// GetImportJobWithContext is the same as GetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetImportJobWithContext(ctx aws.Context, input *GetImportJobInput, opts ...request.Option) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImportJobs = "GetImportJobs"

// GetImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImportJobs for more information on using the GetImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetImportJobsRequest method.
//    req, resp := client.GetImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs
func (c *Pinpoint) GetImportJobsRequest(input *GetImportJobsInput) (req *request.Request, output *GetImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import",
	}

	if input == nil {
		input = &GetImportJobsInput{}
	}

	output = &GetImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJobs API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of all the import jobs
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetImportJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs
func (c *Pinpoint) GetImportJobs(input *GetImportJobsInput) (*GetImportJobsOutput, error) {
	req, out := c.GetImportJobsRequest(input)
	return out, req.Send()
}

// GetImportJobsWithContext is the same as GetImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetImportJobsWithContext(ctx aws.Context, input *GetImportJobsInput, opts ...request.Option) (*GetImportJobsOutput, error) {
	req, out := c.GetImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJourney = "GetJourney"

// GetJourneyRequest generates a "aws/request.Request" representing the
// client's request for the GetJourney operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJourney for more information on using the GetJourney
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJourneyRequest method.
//    req, resp := client.GetJourneyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourney
func (c *Pinpoint) GetJourneyRequest(input *GetJourneyInput) (req *request.Request, output *GetJourneyOutput) {
	op := &request.Operation{
		Name:       opGetJourney,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}",
	}

	if input == nil {
		input = &GetJourneyInput{}
	}

	output = &GetJourneyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJourney API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for a journey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetJourney for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourney
func (c *Pinpoint) GetJourney(input *GetJourneyInput) (*GetJourneyOutput, error) {
	req, out := c.GetJourneyRequest(input)
	return out, req.Send()
}

// GetJourneyWithContext is the same as GetJourney with the addition of
// the ability to pass a context and additional request options.
//
// See GetJourney for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetJourneyWithContext(ctx aws.Context, input *GetJourneyInput, opts ...request.Option) (*GetJourneyOutput, error) {
	req, out := c.GetJourneyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJourneyDateRangeKpi = "GetJourneyDateRangeKpi"

// GetJourneyDateRangeKpiRequest generates a "aws/request.Request" representing the
// client's request for the GetJourneyDateRangeKpi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJourneyDateRangeKpi for more information on using the GetJourneyDateRangeKpi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJourneyDateRangeKpiRequest method.
//    req, resp := client.GetJourneyDateRangeKpiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyDateRangeKpi
func (c *Pinpoint) GetJourneyDateRangeKpiRequest(input *GetJourneyDateRangeKpiInput) (req *request.Request, output *GetJourneyDateRangeKpiOutput) {
	op := &request.Operation{
		Name:       opGetJourneyDateRangeKpi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}/kpis/daterange/{kpi-name}",
	}

	if input == nil {
		input = &GetJourneyDateRangeKpiInput{}
	}

	output = &GetJourneyDateRangeKpiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJourneyDateRangeKpi API operation for Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard engagement metric
// that applies to a journey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetJourneyDateRangeKpi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyDateRangeKpi
func (c *Pinpoint) GetJourneyDateRangeKpi(input *GetJourneyDateRangeKpiInput) (*GetJourneyDateRangeKpiOutput, error) {
	req, out := c.GetJourneyDateRangeKpiRequest(input)
	return out, req.Send()
}

// GetJourneyDateRangeKpiWithContext is the same as GetJourneyDateRangeKpi with the addition of
// the ability to pass a context and additional request options.
//
// See GetJourneyDateRangeKpi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetJourneyDateRangeKpiWithContext(ctx aws.Context, input *GetJourneyDateRangeKpiInput, opts ...request.Option) (*GetJourneyDateRangeKpiOutput, error) {
	req, out := c.GetJourneyDateRangeKpiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJourneyExecutionActivityMetrics = "GetJourneyExecutionActivityMetrics"

// GetJourneyExecutionActivityMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetJourneyExecutionActivityMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJourneyExecutionActivityMetrics for more information on using the GetJourneyExecutionActivityMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJourneyExecutionActivityMetricsRequest method.
//    req, resp := client.GetJourneyExecutionActivityMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionActivityMetrics
func (c *Pinpoint) GetJourneyExecutionActivityMetricsRequest(input *GetJourneyExecutionActivityMetricsInput) (req *request.Request, output *GetJourneyExecutionActivityMetricsOutput) {
	op := &request.Operation{
		Name:       opGetJourneyExecutionActivityMetrics,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}/activities/{journey-activity-id}/execution-metrics",
	}

	if input == nil {
		input = &GetJourneyExecutionActivityMetricsInput{}
	}

	output = &GetJourneyExecutionActivityMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJourneyExecutionActivityMetrics API operation for Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard execution metric that
// applies to a journey activity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetJourneyExecutionActivityMetrics for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionActivityMetrics
func (c *Pinpoint) GetJourneyExecutionActivityMetrics(input *GetJourneyExecutionActivityMetricsInput) (*GetJourneyExecutionActivityMetricsOutput, error) {
	req, out := c.GetJourneyExecutionActivityMetricsRequest(input)
	return out, req.Send()
}

// GetJourneyExecutionActivityMetricsWithContext is the same as GetJourneyExecutionActivityMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetJourneyExecutionActivityMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetJourneyExecutionActivityMetricsWithContext(ctx aws.Context, input *GetJourneyExecutionActivityMetricsInput, opts ...request.Option) (*GetJourneyExecutionActivityMetricsOutput, error) {
	req, out := c.GetJourneyExecutionActivityMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJourneyExecutionMetrics = "GetJourneyExecutionMetrics"

// GetJourneyExecutionMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetJourneyExecutionMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJourneyExecutionMetrics for more information on using the GetJourneyExecutionMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJourneyExecutionMetricsRequest method.
//    req, resp := client.GetJourneyExecutionMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionMetrics
func (c *Pinpoint) GetJourneyExecutionMetricsRequest(input *GetJourneyExecutionMetricsInput) (req *request.Request, output *GetJourneyExecutionMetricsOutput) {
	op := &request.Operation{
		Name:       opGetJourneyExecutionMetrics,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}/execution-metrics",
	}

	if input == nil {
		input = &GetJourneyExecutionMetricsInput{}
	}

	output = &GetJourneyExecutionMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJourneyExecutionMetrics API operation for Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard execution metric that
// applies to a journey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetJourneyExecutionMetrics for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionMetrics
func (c *Pinpoint) GetJourneyExecutionMetrics(input *GetJourneyExecutionMetricsInput) (*GetJourneyExecutionMetricsOutput, error) {
	req, out := c.GetJourneyExecutionMetricsRequest(input)
	return out, req.Send()
}

// GetJourneyExecutionMetricsWithContext is the same as GetJourneyExecutionMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetJourneyExecutionMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetJourneyExecutionMetricsWithContext(ctx aws.Context, input *GetJourneyExecutionMetricsInput, opts ...request.Option) (*GetJourneyExecutionMetricsOutput, error) {
	req, out := c.GetJourneyExecutionMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPushTemplate = "GetPushTemplate"

// GetPushTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetPushTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPushTemplate for more information on using the GetPushTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPushTemplateRequest method.
//    req, resp := client.GetPushTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetPushTemplate
func (c *Pinpoint) GetPushTemplateRequest(input *GetPushTemplateInput) (req *request.Request, output *GetPushTemplateOutput) {
	op := &request.Operation{
		Name:       opGetPushTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates/{template-name}/push",
	}

	if input == nil {
		input = &GetPushTemplateInput{}
	}

	output = &GetPushTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPushTemplate API operation for Amazon Pinpoint.
//
// Retrieves the content and settings of a message template for messages that
// are sent through a push notification channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetPushTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetPushTemplate
func (c *Pinpoint) GetPushTemplate(input *GetPushTemplateInput) (*GetPushTemplateOutput, error) {
	req, out := c.GetPushTemplateRequest(input)
	return out, req.Send()
}

// GetPushTemplateWithContext is the same as GetPushTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetPushTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetPushTemplateWithContext(ctx aws.Context, input *GetPushTemplateInput, opts ...request.Option) (*GetPushTemplateOutput, error) {
	req, out := c.GetPushTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecommenderConfiguration = "GetRecommenderConfiguration"

// GetRecommenderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetRecommenderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecommenderConfiguration for more information on using the GetRecommenderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRecommenderConfigurationRequest method.
//    req, resp := client.GetRecommenderConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfiguration
func (c *Pinpoint) GetRecommenderConfigurationRequest(input *GetRecommenderConfigurationInput) (req *request.Request, output *GetRecommenderConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetRecommenderConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/recommenders/{recommender-id}",
	}

	if input == nil {
		input = &GetRecommenderConfigurationInput{}
	}

	output = &GetRecommenderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecommenderConfiguration API operation for Amazon Pinpoint.
//
// Retrieves information about an Amazon Pinpoint configuration for a recommender
// model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetRecommenderConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfiguration
func (c *Pinpoint) GetRecommenderConfiguration(input *GetRecommenderConfigurationInput) (*GetRecommenderConfigurationOutput, error) {
	req, out := c.GetRecommenderConfigurationRequest(input)
	return out, req.Send()
}

// GetRecommenderConfigurationWithContext is the same as GetRecommenderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecommenderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetRecommenderConfigurationWithContext(ctx aws.Context, input *GetRecommenderConfigurationInput, opts ...request.Option) (*GetRecommenderConfigurationOutput, error) {
	req, out := c.GetRecommenderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecommenderConfigurations = "GetRecommenderConfigurations"

// GetRecommenderConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the GetRecommenderConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecommenderConfigurations for more information on using the GetRecommenderConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRecommenderConfigurationsRequest method.
//    req, resp := client.GetRecommenderConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfigurations
func (c *Pinpoint) GetRecommenderConfigurationsRequest(input *GetRecommenderConfigurationsInput) (req *request.Request, output *GetRecommenderConfigurationsOutput) {
	op := &request.Operation{
		Name:       opGetRecommenderConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/recommenders",
	}

	if input == nil {
		input = &GetRecommenderConfigurationsInput{}
	}

	output = &GetRecommenderConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecommenderConfigurations API operation for Amazon Pinpoint.
//
// Retrieves information about all the recommender model configurations that
// are associated with your Amazon Pinpoint account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetRecommenderConfigurations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfigurations
func (c *Pinpoint) GetRecommenderConfigurations(input *GetRecommenderConfigurationsInput) (*GetRecommenderConfigurationsOutput, error) {
	req, out := c.GetRecommenderConfigurationsRequest(input)
	return out, req.Send()
}

// GetRecommenderConfigurationsWithContext is the same as GetRecommenderConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecommenderConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetRecommenderConfigurationsWithContext(ctx aws.Context, input *GetRecommenderConfigurationsInput, opts ...request.Option) (*GetRecommenderConfigurationsOutput, error) {
	req, out := c.GetRecommenderConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegment = "GetSegment"

// GetSegmentRequest generates a "aws/request.Request" representing the
// client's request for the GetSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegment for more information on using the GetSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentRequest method.
//    req, resp := client.GetSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment
func (c *Pinpoint) GetSegmentRequest(input *GetSegmentInput) (req *request.Request, output *GetSegmentOutput) {
	op := &request.Operation{
		Name:       opGetSegment,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &GetSegmentInput{}
	}

	output = &GetSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegment API operation for Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for a specific segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment
func (c *Pinpoint) GetSegment(input *GetSegmentInput) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	return out, req.Send()
}

// GetSegmentWithContext is the same as GetSegment with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentWithContext(ctx aws.Context, input *GetSegmentInput, opts ...request.Option) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentExportJobs = "GetSegmentExportJobs"

// GetSegmentExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentExportJobs for more information on using the GetSegmentExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentExportJobsRequest method.
//    req, resp := client.GetSegmentExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs
func (c *Pinpoint) GetSegmentExportJobsRequest(input *GetSegmentExportJobsInput) (req *request.Request, output *GetSegmentExportJobsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentExportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/jobs/export",
	}

	if input == nil {
		input = &GetSegmentExportJobsInput{}
	}

	output = &GetSegmentExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentExportJobs API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the export jobs for
// a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentExportJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs
func (c *Pinpoint) GetSegmentExportJobs(input *GetSegmentExportJobsInput) (*GetSegmentExportJobsOutput, error) {
	req, out := c.GetSegmentExportJobsRequest(input)
	return out, req.Send()
}

// GetSegmentExportJobsWithContext is the same as GetSegmentExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentExportJobsWithContext(ctx aws.Context, input *GetSegmentExportJobsInput, opts ...request.Option) (*GetSegmentExportJobsOutput, error) {
	req, out := c.GetSegmentExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentImportJobs = "GetSegmentImportJobs"

// GetSegmentImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentImportJobs for more information on using the GetSegmentImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentImportJobsRequest method.
//    req, resp := client.GetSegmentImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs
func (c *Pinpoint) GetSegmentImportJobsRequest(input *GetSegmentImportJobsInput) (req *request.Request, output *GetSegmentImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/jobs/import",
	}

	if input == nil {
		input = &GetSegmentImportJobsInput{}
	}

	output = &GetSegmentImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentImportJobs API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the import jobs for
// a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentImportJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs
func (c *Pinpoint) GetSegmentImportJobs(input *GetSegmentImportJobsInput) (*GetSegmentImportJobsOutput, error) {
	req, out := c.GetSegmentImportJobsRequest(input)
	return out, req.Send()
}

// GetSegmentImportJobsWithContext is the same as GetSegmentImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentImportJobsWithContext(ctx aws.Context, input *GetSegmentImportJobsInput, opts ...request.Option) (*GetSegmentImportJobsOutput, error) {
	req, out := c.GetSegmentImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentVersion = "GetSegmentVersion"

// GetSegmentVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentVersion for more information on using the GetSegmentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentVersionRequest method.
//    req, resp := client.GetSegmentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion
func (c *Pinpoint) GetSegmentVersionRequest(input *GetSegmentVersionInput) (req *request.Request, output *GetSegmentVersionOutput) {
	op := &request.Operation{
		Name:       opGetSegmentVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}",
	}

	if input == nil {
		input = &GetSegmentVersionInput{}
	}

	output = &GetSegmentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentVersion API operation for Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for a specific version of a segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion
func (c *Pinpoint) GetSegmentVersion(input *GetSegmentVersionInput) (*GetSegmentVersionOutput, error) {
	req, out := c.GetSegmentVersionRequest(input)
	return out, req.Send()
}

// GetSegmentVersionWithContext is the same as GetSegmentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentVersionWithContext(ctx aws.Context, input *GetSegmentVersionInput, opts ...request.Option) (*GetSegmentVersionOutput, error) {
	req, out := c.GetSegmentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentVersions = "GetSegmentVersions"

// GetSegmentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentVersions for more information on using the GetSegmentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentVersionsRequest method.
//    req, resp := client.GetSegmentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions
func (c *Pinpoint) GetSegmentVersionsRequest(input *GetSegmentVersionsInput) (req *request.Request, output *GetSegmentVersionsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions",
	}

	if input == nil {
		input = &GetSegmentVersionsInput{}
	}

	output = &GetSegmentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentVersions API operation for Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for all the versions of a specific segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions
func (c *Pinpoint) GetSegmentVersions(input *GetSegmentVersionsInput) (*GetSegmentVersionsOutput, error) {
	req, out := c.GetSegmentVersionsRequest(input)
	return out, req.Send()
}

// GetSegmentVersionsWithContext is the same as GetSegmentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentVersionsWithContext(ctx aws.Context, input *GetSegmentVersionsInput, opts ...request.Option) (*GetSegmentVersionsOutput, error) {
	req, out := c.GetSegmentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegments = "GetSegments"

// GetSegmentsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegments for more information on using the GetSegments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentsRequest method.
//    req, resp := client.GetSegmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments
func (c *Pinpoint) GetSegmentsRequest(input *GetSegmentsInput) (req *request.Request, output *GetSegmentsOutput) {
	op := &request.Operation{
		Name:       opGetSegments,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments",
	}

	if input == nil {
		input = &GetSegmentsInput{}
	}

	output = &GetSegmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegments API operation for Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for all the segments that are associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegments for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments
func (c *Pinpoint) GetSegments(input *GetSegmentsInput) (*GetSegmentsOutput, error) {
	req, out := c.GetSegmentsRequest(input)
	return out, req.Send()
}

// GetSegmentsWithContext is the same as GetSegments with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentsWithContext(ctx aws.Context, input *GetSegmentsInput, opts ...request.Option) (*GetSegmentsOutput, error) {
	req, out := c.GetSegmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSmsChannel = "GetSmsChannel"

// GetSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetSmsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSmsChannel for more information on using the GetSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSmsChannelRequest method.
//    req, resp := client.GetSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel
func (c *Pinpoint) GetSmsChannelRequest(input *GetSmsChannelInput) (req *request.Request, output *GetSmsChannelOutput) {
	op := &request.Operation{
		Name:       opGetSmsChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &GetSmsChannelInput{}
	}

	output = &GetSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSmsChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the SMS channel for
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSmsChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel
func (c *Pinpoint) GetSmsChannel(input *GetSmsChannelInput) (*GetSmsChannelOutput, error) {
	req, out := c.GetSmsChannelRequest(input)
	return out, req.Send()
}

// GetSmsChannelWithContext is the same as GetSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSmsChannelWithContext(ctx aws.Context, input *GetSmsChannelInput, opts ...request.Option) (*GetSmsChannelOutput, error) {
	req, out := c.GetSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSmsTemplate = "GetSmsTemplate"

// GetSmsTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetSmsTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSmsTemplate for more information on using the GetSmsTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSmsTemplateRequest method.
//    req, resp := client.GetSmsTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsTemplate
func (c *Pinpoint) GetSmsTemplateRequest(input *GetSmsTemplateInput) (req *request.Request, output *GetSmsTemplateOutput) {
	op := &request.Operation{
		Name:       opGetSmsTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates/{template-name}/sms",
	}

	if input == nil {
		input = &GetSmsTemplateInput{}
	}

	output = &GetSmsTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSmsTemplate API operation for Amazon Pinpoint.
//
// Retrieves the content and settings of a message template for messages that
// are sent through the SMS channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSmsTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsTemplate
func (c *Pinpoint) GetSmsTemplate(input *GetSmsTemplateInput) (*GetSmsTemplateOutput, error) {
	req, out := c.GetSmsTemplateRequest(input)
	return out, req.Send()
}

// GetSmsTemplateWithContext is the same as GetSmsTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetSmsTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSmsTemplateWithContext(ctx aws.Context, input *GetSmsTemplateInput, opts ...request.Option) (*GetSmsTemplateOutput, error) {
	req, out := c.GetSmsTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserEndpoints = "GetUserEndpoints"

// GetUserEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the GetUserEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserEndpoints for more information on using the GetUserEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserEndpointsRequest method.
//    req, resp := client.GetUserEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints
func (c *Pinpoint) GetUserEndpointsRequest(input *GetUserEndpointsInput) (req *request.Request, output *GetUserEndpointsOutput) {
	op := &request.Operation{
		Name:       opGetUserEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/users/{user-id}",
	}

	if input == nil {
		input = &GetUserEndpointsInput{}
	}

	output = &GetUserEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserEndpoints API operation for Amazon Pinpoint.
//
// Retrieves information about all the endpoints that are associated with a
// specific user ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetUserEndpoints for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints
func (c *Pinpoint) GetUserEndpoints(input *GetUserEndpointsInput) (*GetUserEndpointsOutput, error) {
	req, out := c.GetUserEndpointsRequest(input)
	return out, req.Send()
}

// GetUserEndpointsWithContext is the same as GetUserEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetUserEndpointsWithContext(ctx aws.Context, input *GetUserEndpointsInput, opts ...request.Option) (*GetUserEndpointsOutput, error) {
	req, out := c.GetUserEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceChannel = "GetVoiceChannel"

// GetVoiceChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceChannel for more information on using the GetVoiceChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceChannelRequest method.
//    req, resp := client.GetVoiceChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel
func (c *Pinpoint) GetVoiceChannelRequest(input *GetVoiceChannelInput) (req *request.Request, output *GetVoiceChannelOutput) {
	op := &request.Operation{
		Name:       opGetVoiceChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/voice",
	}

	if input == nil {
		input = &GetVoiceChannelInput{}
	}

	output = &GetVoiceChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the voice channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetVoiceChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel
func (c *Pinpoint) GetVoiceChannel(input *GetVoiceChannelInput) (*GetVoiceChannelOutput, error) {
	req, out := c.GetVoiceChannelRequest(input)
	return out, req.Send()
}

// GetVoiceChannelWithContext is the same as GetVoiceChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetVoiceChannelWithContext(ctx aws.Context, input *GetVoiceChannelInput, opts ...request.Option) (*GetVoiceChannelOutput, error) {
	req, out := c.GetVoiceChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceTemplate = "GetVoiceTemplate"

// GetVoiceTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceTemplate for more information on using the GetVoiceTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceTemplateRequest method.
//    req, resp := client.GetVoiceTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceTemplate
func (c *Pinpoint) GetVoiceTemplateRequest(input *GetVoiceTemplateInput) (req *request.Request, output *GetVoiceTemplateOutput) {
	op := &request.Operation{
		Name:       opGetVoiceTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates/{template-name}/voice",
	}

	if input == nil {
		input = &GetVoiceTemplateInput{}
	}

	output = &GetVoiceTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceTemplate API operation for Amazon Pinpoint.
//
// Retrieves the content and settings of a message template for messages that
// are sent through the voice channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetVoiceTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceTemplate
func (c *Pinpoint) GetVoiceTemplate(input *GetVoiceTemplateInput) (*GetVoiceTemplateOutput, error) {
	req, out := c.GetVoiceTemplateRequest(input)
	return out, req.Send()
}

// GetVoiceTemplateWithContext is the same as GetVoiceTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetVoiceTemplateWithContext(ctx aws.Context, input *GetVoiceTemplateInput, opts ...request.Option) (*GetVoiceTemplateOutput, error) {
	req, out := c.GetVoiceTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJourneys = "ListJourneys"

// ListJourneysRequest generates a "aws/request.Request" representing the
// client's request for the ListJourneys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJourneys for more information on using the ListJourneys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJourneysRequest method.
//    req, resp := client.ListJourneysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListJourneys
func (c *Pinpoint) ListJourneysRequest(input *ListJourneysInput) (req *request.Request, output *ListJourneysOutput) {
	op := &request.Operation{
		Name:       opListJourneys,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/journeys",
	}

	if input == nil {
		input = &ListJourneysInput{}
	}

	output = &ListJourneysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJourneys API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for all the journeys that are associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation ListJourneys for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListJourneys
func (c *Pinpoint) ListJourneys(input *ListJourneysInput) (*ListJourneysOutput, error) {
	req, out := c.ListJourneysRequest(input)
	return out, req.Send()
}

// ListJourneysWithContext is the same as ListJourneys with the addition of
// the ability to pass a context and additional request options.
//
// See ListJourneys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) ListJourneysWithContext(ctx aws.Context, input *ListJourneysInput, opts ...request.Option) (*ListJourneysOutput, error) {
	req, out := c.ListJourneysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource
func (c *Pinpoint) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Pinpoint.
//
// Retrieves all the tags (keys and values) that are associated with an application,
// campaign, message template, or segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource
func (c *Pinpoint) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplateVersions = "ListTemplateVersions"

// ListTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateVersions for more information on using the ListTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTemplateVersionsRequest method.
//    req, resp := client.ListTemplateVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplateVersions
func (c *Pinpoint) ListTemplateVersionsRequest(input *ListTemplateVersionsInput) (req *request.Request, output *ListTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opListTemplateVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates/{template-name}/{template-type}/versions",
	}

	if input == nil {
		input = &ListTemplateVersionsInput{}
	}

	output = &ListTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateVersions API operation for Amazon Pinpoint.
//
// Retrieves information about all the versions of a specific message template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation ListTemplateVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplateVersions
func (c *Pinpoint) ListTemplateVersions(input *ListTemplateVersionsInput) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	return out, req.Send()
}

// ListTemplateVersionsWithContext is the same as ListTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) ListTemplateVersionsWithContext(ctx aws.Context, input *ListTemplateVersionsInput, opts ...request.Option) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTemplatesRequest method.
//    req, resp := client.ListTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplates
func (c *Pinpoint) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates",
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for Amazon Pinpoint.
//
// Retrieves information about all the message templates that are associated
// with your Amazon Pinpoint account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation ListTemplates for usage and error information.
//
// Returned Error Types:
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplates
func (c *Pinpoint) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPhoneNumberValidate = "PhoneNumberValidate"

// PhoneNumberValidateRequest generates a "aws/request.Request" representing the
// client's request for the PhoneNumberValidate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PhoneNumberValidate for more information on using the PhoneNumberValidate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PhoneNumberValidateRequest method.
//    req, resp := client.PhoneNumberValidateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate
func (c *Pinpoint) PhoneNumberValidateRequest(input *PhoneNumberValidateInput) (req *request.Request, output *PhoneNumberValidateOutput) {
	op := &request.Operation{
		Name:       opPhoneNumberValidate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/phone/number/validate",
	}

	if input == nil {
		input = &PhoneNumberValidateInput{}
	}

	output = &PhoneNumberValidateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PhoneNumberValidate API operation for Amazon Pinpoint.
//
// Retrieves information about a phone number.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation PhoneNumberValidate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate
func (c *Pinpoint) PhoneNumberValidate(input *PhoneNumberValidateInput) (*PhoneNumberValidateOutput, error) {
	req, out := c.PhoneNumberValidateRequest(input)
	return out, req.Send()
}

// PhoneNumberValidateWithContext is the same as PhoneNumberValidate with the addition of
// the ability to pass a context and additional request options.
//
// See PhoneNumberValidate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) PhoneNumberValidateWithContext(ctx aws.Context, input *PhoneNumberValidateInput, opts ...request.Option) (*PhoneNumberValidateOutput, error) {
	req, out := c.PhoneNumberValidateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEventStream = "PutEventStream"

// PutEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the PutEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventStream for more information on using the PutEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventStreamRequest method.
//    req, resp := client.PutEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream
func (c *Pinpoint) PutEventStreamRequest(input *PutEventStreamInput) (req *request.Request, output *PutEventStreamOutput) {
	op := &request.Operation{
		Name:       opPutEventStream,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &PutEventStreamInput{}
	}

	output = &PutEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEventStream API operation for Amazon Pinpoint.
//
// Creates a new event stream for an application or updates the settings of
// an existing event stream for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation PutEventStream for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream
func (c *Pinpoint) PutEventStream(input *PutEventStreamInput) (*PutEventStreamOutput, error) {
	req, out := c.PutEventStreamRequest(input)
	return out, req.Send()
}

// PutEventStreamWithContext is the same as PutEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) PutEventStreamWithContext(ctx aws.Context, input *PutEventStreamInput, opts ...request.Option) (*PutEventStreamOutput, error) {
	req, out := c.PutEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEvents = "PutEvents"

// PutEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEvents for more information on using the PutEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventsRequest method.
//    req, resp := client.PutEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents
func (c *Pinpoint) PutEventsRequest(input *PutEventsInput) (req *request.Request, output *PutEventsOutput) {
	op := &request.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/events",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	output = &PutEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvents API operation for Amazon Pinpoint.
//
// Creates a new event to record for endpoints, or creates or updates endpoint
// data that existing events are associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation PutEvents for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents
func (c *Pinpoint) PutEvents(input *PutEventsInput) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	return out, req.Send()
}

// PutEventsWithContext is the same as PutEvents with the addition of
// the ability to pass a context and additional request options.
//
// See PutEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) PutEventsWithContext(ctx aws.Context, input *PutEventsInput, opts ...request.Option) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveAttributes = "RemoveAttributes"

// RemoveAttributesRequest generates a "aws/request.Request" representing the
// client's request for the RemoveAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveAttributes for more information on using the RemoveAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveAttributesRequest method.
//    req, resp := client.RemoveAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes
func (c *Pinpoint) RemoveAttributesRequest(input *RemoveAttributesInput) (req *request.Request, output *RemoveAttributesOutput) {
	op := &request.Operation{
		Name:       opRemoveAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/attributes/{attribute-type}",
	}

	if input == nil {
		input = &RemoveAttributesInput{}
	}

	output = &RemoveAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveAttributes API operation for Amazon Pinpoint.
//
// Removes one or more attributes, of the same attribute type, from all the
// endpoints that are associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation RemoveAttributes for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes
func (c *Pinpoint) RemoveAttributes(input *RemoveAttributesInput) (*RemoveAttributesOutput, error) {
	req, out := c.RemoveAttributesRequest(input)
	return out, req.Send()
}

// RemoveAttributesWithContext is the same as RemoveAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) RemoveAttributesWithContext(ctx aws.Context, input *RemoveAttributesInput, opts ...request.Option) (*RemoveAttributesOutput, error) {
	req, out := c.RemoveAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendMessages = "SendMessages"

// SendMessagesRequest generates a "aws/request.Request" representing the
// client's request for the SendMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendMessages for more information on using the SendMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendMessagesRequest method.
//    req, resp := client.SendMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages
func (c *Pinpoint) SendMessagesRequest(input *SendMessagesInput) (req *request.Request, output *SendMessagesOutput) {
	op := &request.Operation{
		Name:       opSendMessages,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/messages",
	}

	if input == nil {
		input = &SendMessagesInput{}
	}

	output = &SendMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendMessages API operation for Amazon Pinpoint.
//
// Creates and sends a direct message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation SendMessages for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages
func (c *Pinpoint) SendMessages(input *SendMessagesInput) (*SendMessagesOutput, error) {
	req, out := c.SendMessagesRequest(input)
	return out, req.Send()
}

// SendMessagesWithContext is the same as SendMessages with the addition of
// the ability to pass a context and additional request options.
//
// See SendMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) SendMessagesWithContext(ctx aws.Context, input *SendMessagesInput, opts ...request.Option) (*SendMessagesOutput, error) {
	req, out := c.SendMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendUsersMessages = "SendUsersMessages"

// SendUsersMessagesRequest generates a "aws/request.Request" representing the
// client's request for the SendUsersMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendUsersMessages for more information on using the SendUsersMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendUsersMessagesRequest method.
//    req, resp := client.SendUsersMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages
func (c *Pinpoint) SendUsersMessagesRequest(input *SendUsersMessagesInput) (req *request.Request, output *SendUsersMessagesOutput) {
	op := &request.Operation{
		Name:       opSendUsersMessages,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/users-messages",
	}

	if input == nil {
		input = &SendUsersMessagesInput{}
	}

	output = &SendUsersMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendUsersMessages API operation for Amazon Pinpoint.
//
// Creates and sends a message to a list of users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation SendUsersMessages for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages
func (c *Pinpoint) SendUsersMessages(input *SendUsersMessagesInput) (*SendUsersMessagesOutput, error) {
	req, out := c.SendUsersMessagesRequest(input)
	return out, req.Send()
}

// SendUsersMessagesWithContext is the same as SendUsersMessages with the addition of
// the ability to pass a context and additional request options.
//
// See SendUsersMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) SendUsersMessagesWithContext(ctx aws.Context, input *SendUsersMessagesInput, opts ...request.Option) (*SendUsersMessagesOutput, error) {
	req, out := c.SendUsersMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource
func (c *Pinpoint) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Pinpoint.
//
// Adds one or more tags (keys and values) to an application, campaign, message
// template, or segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource
func (c *Pinpoint) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource
func (c *Pinpoint) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Pinpoint.
//
// Removes one or more tags (keys and values) from an application, campaign,
// message template, or segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource
func (c *Pinpoint) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAdmChannel = "UpdateAdmChannel"

// UpdateAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAdmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAdmChannel for more information on using the UpdateAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAdmChannelRequest method.
//    req, resp := client.UpdateAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel
func (c *Pinpoint) UpdateAdmChannelRequest(input *UpdateAdmChannelInput) (req *request.Request, output *UpdateAdmChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateAdmChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &UpdateAdmChannelInput{}
	}

	output = &UpdateAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAdmChannel API operation for Amazon Pinpoint.
//
// Enables the ADM channel for an application or updates the status and settings
// of the ADM channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateAdmChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel
func (c *Pinpoint) UpdateAdmChannel(input *UpdateAdmChannelInput) (*UpdateAdmChannelOutput, error) {
	req, out := c.UpdateAdmChannelRequest(input)
	return out, req.Send()
}

// UpdateAdmChannelWithContext is the same as UpdateAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateAdmChannelWithContext(ctx aws.Context, input *UpdateAdmChannelInput, opts ...request.Option) (*UpdateAdmChannelOutput, error) {
	req, out := c.UpdateAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsChannel = "UpdateApnsChannel"

// UpdateApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsChannel for more information on using the UpdateApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsChannelRequest method.
//    req, resp := client.UpdateApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel
func (c *Pinpoint) UpdateApnsChannelRequest(input *UpdateApnsChannelInput) (req *request.Request, output *UpdateApnsChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &UpdateApnsChannelInput{}
	}

	output = &UpdateApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsChannel API operation for Amazon Pinpoint.
//
// Enables the APNs channel for an application or updates the status and settings
// of the APNs channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel
func (c *Pinpoint) UpdateApnsChannel(input *UpdateApnsChannelInput) (*UpdateApnsChannelOutput, error) {
	req, out := c.UpdateApnsChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsChannelWithContext is the same as UpdateApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsChannelWithContext(ctx aws.Context, input *UpdateApnsChannelInput, opts ...request.Option) (*UpdateApnsChannelOutput, error) {
	req, out := c.UpdateApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsSandboxChannel = "UpdateApnsSandboxChannel"

// UpdateApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsSandboxChannel for more information on using the UpdateApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsSandboxChannelRequest method.
//    req, resp := client.UpdateApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel
func (c *Pinpoint) UpdateApnsSandboxChannelRequest(input *UpdateApnsSandboxChannelInput) (req *request.Request, output *UpdateApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsSandboxChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &UpdateApnsSandboxChannelInput{}
	}

	output = &UpdateApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Enables the APNs sandbox channel for an application or updates the status
// and settings of the APNs sandbox channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsSandboxChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel
func (c *Pinpoint) UpdateApnsSandboxChannel(input *UpdateApnsSandboxChannelInput) (*UpdateApnsSandboxChannelOutput, error) {
	req, out := c.UpdateApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsSandboxChannelWithContext is the same as UpdateApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsSandboxChannelWithContext(ctx aws.Context, input *UpdateApnsSandboxChannelInput, opts ...request.Option) (*UpdateApnsSandboxChannelOutput, error) {
	req, out := c.UpdateApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsVoipChannel = "UpdateApnsVoipChannel"

// UpdateApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsVoipChannel for more information on using the UpdateApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsVoipChannelRequest method.
//    req, resp := client.UpdateApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel
func (c *Pinpoint) UpdateApnsVoipChannelRequest(input *UpdateApnsVoipChannelInput) (req *request.Request, output *UpdateApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsVoipChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &UpdateApnsVoipChannelInput{}
	}

	output = &UpdateApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsVoipChannel API operation for Amazon Pinpoint.
//
// Enables the APNs VoIP channel for an application or updates the status and
// settings of the APNs VoIP channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsVoipChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel
func (c *Pinpoint) UpdateApnsVoipChannel(input *UpdateApnsVoipChannelInput) (*UpdateApnsVoipChannelOutput, error) {
	req, out := c.UpdateApnsVoipChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsVoipChannelWithContext is the same as UpdateApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsVoipChannelWithContext(ctx aws.Context, input *UpdateApnsVoipChannelInput, opts ...request.Option) (*UpdateApnsVoipChannelOutput, error) {
	req, out := c.UpdateApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsVoipSandboxChannel = "UpdateApnsVoipSandboxChannel"

// UpdateApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsVoipSandboxChannel for more information on using the UpdateApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsVoipSandboxChannelRequest method.
//    req, resp := client.UpdateApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel
func (c *Pinpoint) UpdateApnsVoipSandboxChannelRequest(input *UpdateApnsVoipSandboxChannelInput) (req *request.Request, output *UpdateApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsVoipSandboxChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &UpdateApnsVoipSandboxChannelInput{}
	}

	output = &UpdateApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Enables the APNs VoIP sandbox channel for an application or updates the status
// and settings of the APNs VoIP sandbox channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel
func (c *Pinpoint) UpdateApnsVoipSandboxChannel(input *UpdateApnsVoipSandboxChannelInput) (*UpdateApnsVoipSandboxChannelOutput, error) {
	req, out := c.UpdateApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsVoipSandboxChannelWithContext is the same as UpdateApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsVoipSandboxChannelWithContext(ctx aws.Context, input *UpdateApnsVoipSandboxChannelInput, opts ...request.Option) (*UpdateApnsVoipSandboxChannelOutput, error) {
	req, out := c.UpdateApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationSettings = "UpdateApplicationSettings"

// UpdateApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplicationSettings for more information on using the UpdateApplicationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationSettingsRequest method.
//    req, resp := client.UpdateApplicationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings
func (c *Pinpoint) UpdateApplicationSettingsRequest(input *UpdateApplicationSettingsInput) (req *request.Request, output *UpdateApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/settings",
	}

	if input == nil {
		input = &UpdateApplicationSettingsInput{}
	}

	output = &UpdateApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplicationSettings API operation for Amazon Pinpoint.
//
// Updates the settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApplicationSettings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings
func (c *Pinpoint) UpdateApplicationSettings(input *UpdateApplicationSettingsInput) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	return out, req.Send()
}

// UpdateApplicationSettingsWithContext is the same as UpdateApplicationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApplicationSettingsWithContext(ctx aws.Context, input *UpdateApplicationSettingsInput, opts ...request.Option) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBaiduChannel = "UpdateBaiduChannel"

// UpdateBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBaiduChannel for more information on using the UpdateBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBaiduChannelRequest method.
//    req, resp := client.UpdateBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel
func (c *Pinpoint) UpdateBaiduChannelRequest(input *UpdateBaiduChannelInput) (req *request.Request, output *UpdateBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateBaiduChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &UpdateBaiduChannelInput{}
	}

	output = &UpdateBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBaiduChannel API operation for Amazon Pinpoint.
//
// Enables the Baidu channel for an application or updates the status and settings
// of the Baidu channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateBaiduChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel
func (c *Pinpoint) UpdateBaiduChannel(input *UpdateBaiduChannelInput) (*UpdateBaiduChannelOutput, error) {
	req, out := c.UpdateBaiduChannelRequest(input)
	return out, req.Send()
}

// UpdateBaiduChannelWithContext is the same as UpdateBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateBaiduChannelWithContext(ctx aws.Context, input *UpdateBaiduChannelInput, opts ...request.Option) (*UpdateBaiduChannelOutput, error) {
	req, out := c.UpdateBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCampaign = "UpdateCampaign"

// UpdateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaign for more information on using the UpdateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCampaignRequest method.
//    req, resp := client.UpdateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign
func (c *Pinpoint) UpdateCampaignRequest(input *UpdateCampaignInput) (req *request.Request, output *UpdateCampaignOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaign,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &UpdateCampaignInput{}
	}

	output = &UpdateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCampaign API operation for Amazon Pinpoint.
//
// Updates the configuration and other settings for a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateCampaign for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign
func (c *Pinpoint) UpdateCampaign(input *UpdateCampaignInput) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	return out, req.Send()
}

// UpdateCampaignWithContext is the same as UpdateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateCampaignWithContext(ctx aws.Context, input *UpdateCampaignInput, opts ...request.Option) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEmailChannel = "UpdateEmailChannel"

// UpdateEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEmailChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEmailChannel for more information on using the UpdateEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEmailChannelRequest method.
//    req, resp := client.UpdateEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel
func (c *Pinpoint) UpdateEmailChannelRequest(input *UpdateEmailChannelInput) (req *request.Request, output *UpdateEmailChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateEmailChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &UpdateEmailChannelInput{}
	}

	output = &UpdateEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEmailChannel API operation for Amazon Pinpoint.
//
// Enables the email channel for an application or updates the status and settings
// of the email channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEmailChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel
func (c *Pinpoint) UpdateEmailChannel(input *UpdateEmailChannelInput) (*UpdateEmailChannelOutput, error) {
	req, out := c.UpdateEmailChannelRequest(input)
	return out, req.Send()
}

// UpdateEmailChannelWithContext is the same as UpdateEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEmailChannelWithContext(ctx aws.Context, input *UpdateEmailChannelInput, opts ...request.Option) (*UpdateEmailChannelOutput, error) {
	req, out := c.UpdateEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEmailTemplate = "UpdateEmailTemplate"

// UpdateEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEmailTemplate for more information on using the UpdateEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEmailTemplateRequest method.
//    req, resp := client.UpdateEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailTemplate
func (c *Pinpoint) UpdateEmailTemplateRequest(input *UpdateEmailTemplateInput) (req *request.Request, output *UpdateEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateEmailTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/templates/{template-name}/email",
	}

	if input == nil {
		input = &UpdateEmailTemplateInput{}
	}

	output = &UpdateEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEmailTemplate API operation for Amazon Pinpoint.
//
// Updates an existing message template for messages that are sent through the
// email channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailTemplate
func (c *Pinpoint) UpdateEmailTemplate(input *UpdateEmailTemplateInput) (*UpdateEmailTemplateOutput, error) {
	req, out := c.UpdateEmailTemplateRequest(input)
	return out, req.Send()
}

// UpdateEmailTemplateWithContext is the same as UpdateEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEmailTemplateWithContext(ctx aws.Context, input *UpdateEmailTemplateInput, opts ...request.Option) (*UpdateEmailTemplateOutput, error) {
	req, out := c.UpdateEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointRequest method.
//    req, resp := client.UpdateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint
func (c *Pinpoint) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon Pinpoint.
//
// Creates a new endpoint for an application or updates the settings and attributes
// of an existing endpoint for an application. You can also use this operation
// to define custom attributes for an endpoint. If an update includes one or
// more values for a custom attribute, Amazon Pinpoint replaces (overwrites)
// any existing values with the new values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint
func (c *Pinpoint) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointsBatch = "UpdateEndpointsBatch"

// UpdateEndpointsBatchRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointsBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointsBatch for more information on using the UpdateEndpointsBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointsBatchRequest method.
//    req, resp := client.UpdateEndpointsBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch
func (c *Pinpoint) UpdateEndpointsBatchRequest(input *UpdateEndpointsBatchInput) (req *request.Request, output *UpdateEndpointsBatchOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointsBatch,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints",
	}

	if input == nil {
		input = &UpdateEndpointsBatchInput{}
	}

	output = &UpdateEndpointsBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointsBatch API operation for Amazon Pinpoint.
//
// Creates a new batch of endpoints for an application or updates the settings
// and attributes of a batch of existing endpoints for an application. You can
// also use this operation to define custom attributes for a batch of endpoints.
// If an update includes one or more values for a custom attribute, Amazon Pinpoint
// replaces (overwrites) any existing values with the new values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEndpointsBatch for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch
func (c *Pinpoint) UpdateEndpointsBatch(input *UpdateEndpointsBatchInput) (*UpdateEndpointsBatchOutput, error) {
	req, out := c.UpdateEndpointsBatchRequest(input)
	return out, req.Send()
}

// UpdateEndpointsBatchWithContext is the same as UpdateEndpointsBatch with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointsBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEndpointsBatchWithContext(ctx aws.Context, input *UpdateEndpointsBatchInput, opts ...request.Option) (*UpdateEndpointsBatchOutput, error) {
	req, out := c.UpdateEndpointsBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGcmChannel = "UpdateGcmChannel"

// UpdateGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGcmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGcmChannel for more information on using the UpdateGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGcmChannelRequest method.
//    req, resp := client.UpdateGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel
func (c *Pinpoint) UpdateGcmChannelRequest(input *UpdateGcmChannelInput) (req *request.Request, output *UpdateGcmChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateGcmChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &UpdateGcmChannelInput{}
	}

	output = &UpdateGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGcmChannel API operation for Amazon Pinpoint.
//
// Enables the GCM channel for an application or updates the status and settings
// of the GCM channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateGcmChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel
func (c *Pinpoint) UpdateGcmChannel(input *UpdateGcmChannelInput) (*UpdateGcmChannelOutput, error) {
	req, out := c.UpdateGcmChannelRequest(input)
	return out, req.Send()
}

// UpdateGcmChannelWithContext is the same as UpdateGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateGcmChannelWithContext(ctx aws.Context, input *UpdateGcmChannelInput, opts ...request.Option) (*UpdateGcmChannelOutput, error) {
	req, out := c.UpdateGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJourney = "UpdateJourney"

// UpdateJourneyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJourney operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJourney for more information on using the UpdateJourney
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJourneyRequest method.
//    req, resp := client.UpdateJourneyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourney
func (c *Pinpoint) UpdateJourneyRequest(input *UpdateJourneyInput) (req *request.Request, output *UpdateJourneyOutput) {
	op := &request.Operation{
		Name:       opUpdateJourney,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}",
	}

	if input == nil {
		input = &UpdateJourneyInput{}
	}

	output = &UpdateJourneyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateJourney API operation for Amazon Pinpoint.
//
// Updates the configuration and other settings for a journey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateJourney for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourney
func (c *Pinpoint) UpdateJourney(input *UpdateJourneyInput) (*UpdateJourneyOutput, error) {
	req, out := c.UpdateJourneyRequest(input)
	return out, req.Send()
}

// UpdateJourneyWithContext is the same as UpdateJourney with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJourney for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateJourneyWithContext(ctx aws.Context, input *UpdateJourneyInput, opts ...request.Option) (*UpdateJourneyOutput, error) {
	req, out := c.UpdateJourneyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJourneyState = "UpdateJourneyState"

// UpdateJourneyStateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJourneyState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJourneyState for more information on using the UpdateJourneyState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJourneyStateRequest method.
//    req, resp := client.UpdateJourneyStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourneyState
func (c *Pinpoint) UpdateJourneyStateRequest(input *UpdateJourneyStateInput) (req *request.Request, output *UpdateJourneyStateOutput) {
	op := &request.Operation{
		Name:       opUpdateJourneyState,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}/state",
	}

	if input == nil {
		input = &UpdateJourneyStateInput{}
	}

	output = &UpdateJourneyStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateJourneyState API operation for Amazon Pinpoint.
//
// Cancels (stops) an active journey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateJourneyState for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourneyState
func (c *Pinpoint) UpdateJourneyState(input *UpdateJourneyStateInput) (*UpdateJourneyStateOutput, error) {
	req, out := c.UpdateJourneyStateRequest(input)
	return out, req.Send()
}

// UpdateJourneyStateWithContext is the same as UpdateJourneyState with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJourneyState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateJourneyStateWithContext(ctx aws.Context, input *UpdateJourneyStateInput, opts ...request.Option) (*UpdateJourneyStateOutput, error) {
	req, out := c.UpdateJourneyStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePushTemplate = "UpdatePushTemplate"

// UpdatePushTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePushTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePushTemplate for more information on using the UpdatePushTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePushTemplateRequest method.
//    req, resp := client.UpdatePushTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdatePushTemplate
func (c *Pinpoint) UpdatePushTemplateRequest(input *UpdatePushTemplateInput) (req *request.Request, output *UpdatePushTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdatePushTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/templates/{template-name}/push",
	}

	if input == nil {
		input = &UpdatePushTemplateInput{}
	}

	output = &UpdatePushTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePushTemplate API operation for Amazon Pinpoint.
//
// Updates an existing message template for messages that are sent through a
// push notification channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdatePushTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdatePushTemplate
func (c *Pinpoint) UpdatePushTemplate(input *UpdatePushTemplateInput) (*UpdatePushTemplateOutput, error) {
	req, out := c.UpdatePushTemplateRequest(input)
	return out, req.Send()
}

// UpdatePushTemplateWithContext is the same as UpdatePushTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePushTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdatePushTemplateWithContext(ctx aws.Context, input *UpdatePushTemplateInput, opts ...request.Option) (*UpdatePushTemplateOutput, error) {
	req, out := c.UpdatePushTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecommenderConfiguration = "UpdateRecommenderConfiguration"

// UpdateRecommenderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecommenderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRecommenderConfiguration for more information on using the UpdateRecommenderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRecommenderConfigurationRequest method.
//    req, resp := client.UpdateRecommenderConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateRecommenderConfiguration
func (c *Pinpoint) UpdateRecommenderConfigurationRequest(input *UpdateRecommenderConfigurationInput) (req *request.Request, output *UpdateRecommenderConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateRecommenderConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/recommenders/{recommender-id}",
	}

	if input == nil {
		input = &UpdateRecommenderConfigurationInput{}
	}

	output = &UpdateRecommenderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRecommenderConfiguration API operation for Amazon Pinpoint.
//
// Updates an Amazon Pinpoint configuration for a recommender model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateRecommenderConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateRecommenderConfiguration
func (c *Pinpoint) UpdateRecommenderConfiguration(input *UpdateRecommenderConfigurationInput) (*UpdateRecommenderConfigurationOutput, error) {
	req, out := c.UpdateRecommenderConfigurationRequest(input)
	return out, req.Send()
}

// UpdateRecommenderConfigurationWithContext is the same as UpdateRecommenderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecommenderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateRecommenderConfigurationWithContext(ctx aws.Context, input *UpdateRecommenderConfigurationInput, opts ...request.Option) (*UpdateRecommenderConfigurationOutput, error) {
	req, out := c.UpdateRecommenderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSegment = "UpdateSegment"

// UpdateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSegment for more information on using the UpdateSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSegmentRequest method.
//    req, resp := client.UpdateSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment
func (c *Pinpoint) UpdateSegmentRequest(input *UpdateSegmentInput) (req *request.Request, output *UpdateSegmentOutput) {
	op := &request.Operation{
		Name:       opUpdateSegment,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &UpdateSegmentInput{}
	}

	output = &UpdateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSegment API operation for Amazon Pinpoint.
//
// Creates a new segment for an application or updates the configuration, dimension,
// and other settings for an existing segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateSegment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment
func (c *Pinpoint) UpdateSegment(input *UpdateSegmentInput) (*UpdateSegmentOutput, error) {
	req, out := c.UpdateSegmentRequest(input)
	return out, req.Send()
}

// UpdateSegmentWithContext is the same as UpdateSegment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateSegmentWithContext(ctx aws.Context, input *UpdateSegmentInput, opts ...request.Option) (*UpdateSegmentOutput, error) {
	req, out := c.UpdateSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSmsChannel = "UpdateSmsChannel"

// UpdateSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSmsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSmsChannel for more information on using the UpdateSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSmsChannelRequest method.
//    req, resp := client.UpdateSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel
func (c *Pinpoint) UpdateSmsChannelRequest(input *UpdateSmsChannelInput) (req *request.Request, output *UpdateSmsChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateSmsChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &UpdateSmsChannelInput{}
	}

	output = &UpdateSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSmsChannel API operation for Amazon Pinpoint.
//
// Enables the SMS channel for an application or updates the status and settings
// of the SMS channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateSmsChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel
func (c *Pinpoint) UpdateSmsChannel(input *UpdateSmsChannelInput) (*UpdateSmsChannelOutput, error) {
	req, out := c.UpdateSmsChannelRequest(input)
	return out, req.Send()
}

// UpdateSmsChannelWithContext is the same as UpdateSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateSmsChannelWithContext(ctx aws.Context, input *UpdateSmsChannelInput, opts ...request.Option) (*UpdateSmsChannelOutput, error) {
	req, out := c.UpdateSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSmsTemplate = "UpdateSmsTemplate"

// UpdateSmsTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSmsTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSmsTemplate for more information on using the UpdateSmsTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSmsTemplateRequest method.
//    req, resp := client.UpdateSmsTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsTemplate
func (c *Pinpoint) UpdateSmsTemplateRequest(input *UpdateSmsTemplateInput) (req *request.Request, output *UpdateSmsTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateSmsTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/templates/{template-name}/sms",
	}

	if input == nil {
		input = &UpdateSmsTemplateInput{}
	}

	output = &UpdateSmsTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSmsTemplate API operation for Amazon Pinpoint.
//
// Updates an existing message template for messages that are sent through the
// SMS channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateSmsTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsTemplate
func (c *Pinpoint) UpdateSmsTemplate(input *UpdateSmsTemplateInput) (*UpdateSmsTemplateOutput, error) {
	req, out := c.UpdateSmsTemplateRequest(input)
	return out, req.Send()
}

// UpdateSmsTemplateWithContext is the same as UpdateSmsTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSmsTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateSmsTemplateWithContext(ctx aws.Context, input *UpdateSmsTemplateInput, opts ...request.Option) (*UpdateSmsTemplateOutput, error) {
	req, out := c.UpdateSmsTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplateActiveVersion = "UpdateTemplateActiveVersion"

// UpdateTemplateActiveVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplateActiveVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplateActiveVersion for more information on using the UpdateTemplateActiveVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTemplateActiveVersionRequest method.
//    req, resp := client.UpdateTemplateActiveVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateTemplateActiveVersion
func (c *Pinpoint) UpdateTemplateActiveVersionRequest(input *UpdateTemplateActiveVersionInput) (req *request.Request, output *UpdateTemplateActiveVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplateActiveVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/templates/{template-name}/{template-type}/active-version",
	}

	if input == nil {
		input = &UpdateTemplateActiveVersionInput{}
	}

	output = &UpdateTemplateActiveVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplateActiveVersion API operation for Amazon Pinpoint.
//
// Changes the status of a specific version of a message template to active.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateTemplateActiveVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateTemplateActiveVersion
func (c *Pinpoint) UpdateTemplateActiveVersion(input *UpdateTemplateActiveVersionInput) (*UpdateTemplateActiveVersionOutput, error) {
	req, out := c.UpdateTemplateActiveVersionRequest(input)
	return out, req.Send()
}

// UpdateTemplateActiveVersionWithContext is the same as UpdateTemplateActiveVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplateActiveVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateTemplateActiveVersionWithContext(ctx aws.Context, input *UpdateTemplateActiveVersionInput, opts ...request.Option) (*UpdateTemplateActiveVersionOutput, error) {
	req, out := c.UpdateTemplateActiveVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceChannel = "UpdateVoiceChannel"

// UpdateVoiceChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceChannel for more information on using the UpdateVoiceChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVoiceChannelRequest method.
//    req, resp := client.UpdateVoiceChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel
func (c *Pinpoint) UpdateVoiceChannelRequest(input *UpdateVoiceChannelInput) (req *request.Request, output *UpdateVoiceChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateVoiceChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/voice",
	}

	if input == nil {
		input = &UpdateVoiceChannelInput{}
	}

	output = &UpdateVoiceChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceChannel API operation for Amazon Pinpoint.
//
// Enables the voice channel for an application or updates the status and settings
// of the voice channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateVoiceChannel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel
func (c *Pinpoint) UpdateVoiceChannel(input *UpdateVoiceChannelInput) (*UpdateVoiceChannelOutput, error) {
	req, out := c.UpdateVoiceChannelRequest(input)
	return out, req.Send()
}

// UpdateVoiceChannelWithContext is the same as UpdateVoiceChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateVoiceChannelWithContext(ctx aws.Context, input *UpdateVoiceChannelInput, opts ...request.Option) (*UpdateVoiceChannelOutput, error) {
	req, out := c.UpdateVoiceChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceTemplate = "UpdateVoiceTemplate"

// UpdateVoiceTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceTemplate for more information on using the UpdateVoiceTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVoiceTemplateRequest method.
//    req, resp := client.UpdateVoiceTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceTemplate
func (c *Pinpoint) UpdateVoiceTemplateRequest(input *UpdateVoiceTemplateInput) (req *request.Request, output *UpdateVoiceTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateVoiceTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/templates/{template-name}/voice",
	}

	if input == nil {
		input = &UpdateVoiceTemplateInput{}
	}

	output = &UpdateVoiceTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceTemplate API operation for Amazon Pinpoint.
//
// Updates an existing message template for messages that are sent through the
// voice channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateVoiceTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Provides information about an API request or response.
//
//   * InternalServerErrorException
//   Provides information about an API request or response.
//
//   * PayloadTooLargeException
//   Provides information about an API request or response.
//
//   * ForbiddenException
//   Provides information about an API request or response.
//
//   * NotFoundException
//   Provides information about an API request or response.
//
//   * MethodNotAllowedException
//   Provides information about an API request or response.
//
//   * TooManyRequestsException
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceTemplate
func (c *Pinpoint) UpdateVoiceTemplate(input *UpdateVoiceTemplateInput) (*UpdateVoiceTemplateOutput, error) {
	req, out := c.UpdateVoiceTemplateRequest(input)
	return out, req.Send()
}

// UpdateVoiceTemplateWithContext is the same as UpdateVoiceTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateVoiceTemplateWithContext(ctx aws.Context, input *UpdateVoiceTemplateInput, opts ...request.Option) (*UpdateVoiceTemplateOutput, error) {
	req, out := c.UpdateVoiceTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies the status and settings of the ADM (Amazon Device Messaging) channel
// for an application.
type ADMChannelRequest struct {
	_ struct{} `type:"structure"`

	// The Client ID that you received from Amazon to send messages by using ADM.
	//
	// ClientId is a required field
	ClientId *string `type:"string" required:"true"`

	// The Client Secret that you received from Amazon to send messages by using
	// ADM.
	//
	// ClientSecret is a required field
	ClientSecret *string `type:"string" required:"true"`

	// Specifies whether to enable the ADM channel for the application.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ADMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMChannelRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ADMChannelRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ADMChannelRequest"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSecret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *ADMChannelRequest) SetClientId(v string) *ADMChannelRequest {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *ADMChannelRequest) SetClientSecret(v string) *ADMChannelRequest {
	s.ClientSecret = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ADMChannelRequest) SetEnabled(v bool) *ADMChannelRequest {
	s.Enabled = &v
	return s
}

// Provides information about the status and settings of the ADM (Amazon Device
// Messaging) channel for an application.
type ADMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the ADM channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the ADM channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the ADM channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the ADM channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the ADM channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the ADM channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the ADM channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the ADM
	// channel, this value is ADM.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the ADM channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ADMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ADMChannelResponse) SetApplicationId(v string) *ADMChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ADMChannelResponse) SetCreationDate(v string) *ADMChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ADMChannelResponse) SetEnabled(v bool) *ADMChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *ADMChannelResponse) SetHasCredential(v bool) *ADMChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *ADMChannelResponse) SetId(v string) *ADMChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *ADMChannelResponse) SetIsArchived(v bool) *ADMChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *ADMChannelResponse) SetLastModifiedBy(v string) *ADMChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ADMChannelResponse) SetLastModifiedDate(v string) *ADMChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ADMChannelResponse) SetPlatform(v string) *ADMChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ADMChannelResponse) SetVersion(v int64) *ADMChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the ADM (Amazon Device Messaging) channel.
type ADMMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The body of the notification message.
	Body *string `type:"string"`

	// An arbitrary string that indicates that multiple messages are logically the
	// same and that Amazon Device Messaging (ADM) can drop previously enqueued
	// messages in favor of this message.
	ConsolidationKey *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]*string `type:"map"`

	// The amount of time, in seconds, that ADM should store the message if the
	// recipient's device is offline. Amazon Pinpoint specifies this value in the
	// expiresAfter parameter when it sends the notification message to ADM.
	ExpiresAfter *string `type:"string"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The base64-encoded, MD5 checksum of the value specified by the Data property.
	// ADM uses the MD5 value to verify the integrity of the data.
	MD5 *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s ADMMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ADMMessage) SetAction(v string) *ADMMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *ADMMessage) SetBody(v string) *ADMMessage {
	s.Body = &v
	return s
}

// SetConsolidationKey sets the ConsolidationKey field's value.
func (s *ADMMessage) SetConsolidationKey(v string) *ADMMessage {
	s.ConsolidationKey = &v
	return s
}

// SetData sets the Data field's value.
func (s *ADMMessage) SetData(v map[string]*string) *ADMMessage {
	s.Data = v
	return s
}

// SetExpiresAfter sets the ExpiresAfter field's value.
func (s *ADMMessage) SetExpiresAfter(v string) *ADMMessage {
	s.ExpiresAfter = &v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *ADMMessage) SetIconReference(v string) *ADMMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *ADMMessage) SetImageIconUrl(v string) *ADMMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *ADMMessage) SetImageUrl(v string) *ADMMessage {
	s.ImageUrl = &v
	return s
}

// SetMD5 sets the MD5 field's value.
func (s *ADMMessage) SetMD5(v string) *ADMMessage {
	s.MD5 = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *ADMMessage) SetRawContent(v string) *ADMMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *ADMMessage) SetSilentPush(v bool) *ADMMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *ADMMessage) SetSmallImageIconUrl(v string) *ADMMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *ADMMessage) SetSound(v string) *ADMMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *ADMMessage) SetSubstitutions(v map[string][]*string) *ADMMessage {
	s.Substitutions = v
	return s
}

// SetTitle sets the Title field's value.
func (s *ADMMessage) SetTitle(v string) *ADMMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ADMMessage) SetUrl(v string) *ADMMessage {
	s.Url = &v
	return s
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// channel for an application.
type APNSChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with APNs by using an APNs certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with APNs, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with APNs.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with APNs by using APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSChannelRequest) SetBundleId(v string) *APNSChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSChannelRequest) SetCertificate(v string) *APNSChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSChannelRequest) SetEnabled(v bool) *APNSChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSChannelRequest) SetPrivateKey(v string) *APNSChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSChannelRequest) SetTeamId(v string) *APNSChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSChannelRequest) SetTokenKey(v string) *APNSChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSChannelRequest) SetTokenKeyId(v string) *APNSChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) channel for an application.
type APNSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with APNs for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs channel is configured to communicate with APNs
	// by using APNs tokens. To provide an authentication key for APNs tokens, set
	// the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// channel, this value is APNS.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSChannelResponse) SetApplicationId(v string) *APNSChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSChannelResponse) SetCreationDate(v string) *APNSChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSChannelResponse) SetEnabled(v bool) *APNSChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSChannelResponse) SetHasCredential(v bool) *APNSChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSChannelResponse) SetHasTokenKey(v bool) *APNSChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSChannelResponse) SetId(v string) *APNSChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSChannelResponse) SetIsArchived(v bool) *APNSChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSChannelResponse) SetLastModifiedBy(v string) *APNSChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSChannelResponse) SetLastModifiedDate(v string) *APNSChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSChannelResponse) SetPlatform(v string) *APNSChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSChannelResponse) SetVersion(v int64) *APNSChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the APNs (Apple Push Notification service) channel.
type APNSMessage struct {
	_ struct{} `type:"structure"`

	// The type of push notification to send. Valid values are:
	//
	//    * alert - For a standard notification that's displayed on recipients'
	//    devices and prompts a recipient to interact with the notification.
	//
	//    * background - For a silent notification that delivers content in the
	//    background and isn't displayed on recipients' devices.
	//
	//    * complication - For a notification that contains update information for
	//    an app’s complication timeline.
	//
	//    * fileprovider - For a notification that signals changes to a File Provider
	//    extension.
	//
	//    * mdm - For a notification that tells managed devices to contact the MDM
	//    server.
	//
	//    * voip - For a notification that provides information about an incoming
	//    VoIP call.
	//
	// Amazon Pinpoint specifies this value in the apns-push-type request header
	// when it sends the notification message to APNs. If you don't specify a value
	// for this property, Amazon Pinpoint sets the value to alert or background
	// automatically, based on the value that you specify for the SilentPush or
	// RawContent property of the message.
	//
	// For more information about the apns-push-type request header, see Sending
	// Notification Requests to APNs (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/sending_notification_requests_to_apns)
	// on the Apple Developer website.
	APNSPushType *string `type:"string"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The key that indicates whether and how to modify the badge of your app's
	// icon when the recipient receives the push notification. If this key isn't
	// included in the dictionary, the badge doesn't change. To remove the badge,
	// set this value to 0.
	Badge *int64 `type:"integer"`

	// The body of the notification message.
	Body *string `type:"string"`

	// The key that indicates the notification type for the push notification. This
	// key is a value that's defined by the identifier property of one of your app's
	// registered categories.
	Category *string `type:"string"`

	// An arbitrary identifier that, if assigned to multiple messages, APNs uses
	// to coalesce the messages into a single push notification instead of delivering
	// each message individually. This value can't exceed 64 bytes.
	//
	// Amazon Pinpoint specifies this value in the apns-collapse-id request header
	// when it sends the notification message to APNs.
	CollapseId *string `type:"string"`

	// The JSON payload to use for a silent push notification. This payload is added
	// to the data.pinpoint.jsonBody object of the notification.
	Data map[string]*string `type:"map"`

	// The URL of an image or video to display in the push notification.
	MediaUrl *string `type:"string"`

	// The authentication method that you want Amazon Pinpoint to use when authenticating
	// with APNs, CERTIFICATE or TOKEN.
	PreferredAuthenticationMethod *string `type:"string"`

	// para>5 - Low priority, the notification might be delayed, delivered as part
	// of a group, or throttled.
	// /listitem>
	// 10 - High priority, the notification is sent immediately. This is the default
	// value. A high priority notification should trigger an alert, play a sound,
	// or badge your app's icon on the recipient's device.
	// /para>
	// Amazon Pinpoint specifies this value in the apns-priority request header
	// when it sends the notification message to APNs.
	//
	// The equivalent values for Firebase Cloud Messaging (FCM), formerly Google
	// Cloud Messaging (GCM), are normal, for 5, and high, for 10. If you specify
	// an FCM value for this property, Amazon Pinpoint accepts and converts the
	// value to the corresponding APNs value.
	Priority *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	//
	// If you specify the raw content of an APNs push notification, the message
	// payload has to include the content-available key. The value of the content-available
	// key has to be an integer, and can only be 0 or 1. If you're sending a standard
	// notification, set the value of content-available to 0. If you're sending
	// a silent (background) notification, set the value of content-available to
	// 1. Additionally, silent notification payloads can't include the alert, badge,
	// or sound keys. For more information, see Generating a Remote Notification
	// (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification)
	// and Pushing Background Updates to Your App (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app)
	// on the Apple Developer website.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification. A silent
	// (or background) push notification isn't displayed on recipients' devices.
	// You can use silent push notifications to make small updates to your app,
	// or to display messages in an in-app message center.
	//
	// Amazon Pinpoint uses this property to determine the correct value for the
	// apns-push-type request header when it sends the notification message to APNs.
	// If you specify a value of true for this property, Amazon Pinpoint sets the
	// value for the apns-push-type header field to background.
	//
	// If you specify the raw content of an APNs push notification, the message
	// payload has to include the content-available key. For silent (background)
	// notifications, set the value of content-available to 1. Additionally, the
	// message payload for a silent notification can't include the alert, badge,
	// or sound keys. For more information, see Generating a Remote Notification
	// (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification)
	// and Pushing Background Updates to Your App (https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app)
	// on the Apple Developer website.
	//
	// Apple has indicated that they will throttle "excessive" background notifications
	// based on current traffic volumes. To prevent your notifications being throttled,
	// Apple recommends that you send no more than 3 silent push notifications to
	// each recipient per hour.
	SilentPush *bool `type:"boolean"`

	// The key for the sound to play when the recipient receives the push notification.
	// The value for this key is the name of a sound file in your app's main bundle
	// or the Library/Sounds folder in your app's data container. If the sound file
	// can't be found or you specify default for the value, the system plays the
	// default alert sound.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override these default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The key that represents your app-specific identifier for grouping notifications.
	// If you provide a Notification Content app extension, you can use this value
	// to group your notifications together.
	ThreadId *string `type:"string"`

	// The amount of time, in seconds, that APNs should store and attempt to deliver
	// the push notification, if the service is unable to deliver the notification
	// the first time. If this value is 0, APNs treats the notification as if it
	// expires immediately and the service doesn't store or try to deliver the notification
	// again.
	//
	// Amazon Pinpoint specifies this value in the apns-expiration request header
	// when it sends the notification message to APNs.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s APNSMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSMessage) GoString() string {
	return s.String()
}

// SetAPNSPushType sets the APNSPushType field's value.
func (s *APNSMessage) SetAPNSPushType(v string) *APNSMessage {
	s.APNSPushType = &v
	return s
}

// SetAction sets the Action field's value.
func (s *APNSMessage) SetAction(v string) *APNSMessage {
	s.Action = &v
	return s
}

// SetBadge sets the Badge field's value.
func (s *APNSMessage) SetBadge(v int64) *APNSMessage {
	s.Badge = &v
	return s
}

// SetBody sets the Body field's value.
func (s *APNSMessage) SetBody(v string) *APNSMessage {
	s.Body = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *APNSMessage) SetCategory(v string) *APNSMessage {
	s.Category = &v
	return s
}

// SetCollapseId sets the CollapseId field's value.
func (s *APNSMessage) SetCollapseId(v string) *APNSMessage {
	s.CollapseId = &v
	return s
}

// SetData sets the Data field's value.
func (s *APNSMessage) SetData(v map[string]*string) *APNSMessage {
	s.Data = v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *APNSMessage) SetMediaUrl(v string) *APNSMessage {
	s.MediaUrl = &v
	return s
}

// SetPreferredAuthenticationMethod sets the PreferredAuthenticationMethod field's value.
func (s *APNSMessage) SetPreferredAuthenticationMethod(v string) *APNSMessage {
	s.PreferredAuthenticationMethod = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *APNSMessage) SetPriority(v string) *APNSMessage {
	s.Priority = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *APNSMessage) SetRawContent(v string) *APNSMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *APNSMessage) SetSilentPush(v bool) *APNSMessage {
	s.SilentPush = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *APNSMessage) SetSound(v string) *APNSMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *APNSMessage) SetSubstitutions(v map[string][]*string) *APNSMessage {
	s.Substitutions = v
	return s
}

// SetThreadId sets the ThreadId field's value.
func (s *APNSMessage) SetThreadId(v string) *APNSMessage {
	s.ThreadId = &v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *APNSMessage) SetTimeToLive(v int64) *APNSMessage {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *APNSMessage) SetTitle(v string) *APNSMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *APNSMessage) SetUrl(v string) *APNSMessage {
	s.Url = &v
	return s
}

// Specifies channel-specific content and settings for a message template that
// can be used in push notifications that are sent through the APNs (Apple Push
// Notification service) channel.
type APNSPushNotificationTemplate struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps a push notification that's based
	// on the message template. Valid values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The message body to use in push notifications that are based on the message
	// template.
	Body *string `type:"string"`

	// The URL of an image or video to display in push notifications that are based
	// on the message template.
	MediaUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for push notifications
	// that are based on the message template. If specified, this value overrides
	// all other content for the message template.
	RawContent *string `type:"string"`

	// The key for the sound to play when the recipient receives a push notification
	// that's based on the message template. The value for this key is the name
	// of a sound file in your app's main bundle or the Library/Sounds folder in
	// your app's data container. If the sound file can't be found or you specify
	// default for the value, the system plays the default alert sound.
	Sound *string `type:"string"`

	// The title to use in push notifications that are based on the message template.
	// This title appears above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps a push notification that's based on the message template and the value
	// of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s APNSPushNotificationTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSPushNotificationTemplate) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *APNSPushNotificationTemplate) SetAction(v string) *APNSPushNotificationTemplate {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *APNSPushNotificationTemplate) SetBody(v string) *APNSPushNotificationTemplate {
	s.Body = &v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *APNSPushNotificationTemplate) SetMediaUrl(v string) *APNSPushNotificationTemplate {
	s.MediaUrl = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *APNSPushNotificationTemplate) SetRawContent(v string) *APNSPushNotificationTemplate {
	s.RawContent = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *APNSPushNotificationTemplate) SetSound(v string) *APNSPushNotificationTemplate {
	s.Sound = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *APNSPushNotificationTemplate) SetTitle(v string) *APNSPushNotificationTemplate {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *APNSPushNotificationTemplate) SetUrl(v string) *APNSPushNotificationTemplate {
	s.Url = &v
	return s
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// sandbox channel for an application.
type APNSSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with the APNs sandbox environment by using an APNs
	// certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with the APNs sandbox environment, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs sandbox channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with the APNs sandbox environment.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with the APNs sandbox environment by using
	// APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSSandboxChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSSandboxChannelRequest) SetBundleId(v string) *APNSSandboxChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSSandboxChannelRequest) SetCertificate(v string) *APNSSandboxChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSSandboxChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSSandboxChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSSandboxChannelRequest) SetEnabled(v bool) *APNSSandboxChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSSandboxChannelRequest) SetPrivateKey(v string) *APNSSandboxChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSSandboxChannelRequest) SetTeamId(v string) *APNSSandboxChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSSandboxChannelRequest) SetTokenKey(v string) *APNSSandboxChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSSandboxChannelRequest) SetTokenKeyId(v string) *APNSSandboxChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) sandbox channel for an application.
type APNSSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs sandbox channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs sandbox channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with the APNs sandbox environment for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs sandbox channel is configured to communicate with
	// APNs by using APNs tokens. To provide an authentication key for APNs tokens,
	// set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs sandbox channel. This property is
	// retained only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs sandbox channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs sandbox channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs sandbox channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// sandbox channel, this value is APNS_SANDBOX.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs sandbox channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSSandboxChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSSandboxChannelResponse) SetApplicationId(v string) *APNSSandboxChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSSandboxChannelResponse) SetCreationDate(v string) *APNSSandboxChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSSandboxChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSSandboxChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSSandboxChannelResponse) SetEnabled(v bool) *APNSSandboxChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSSandboxChannelResponse) SetHasCredential(v bool) *APNSSandboxChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSSandboxChannelResponse) SetHasTokenKey(v bool) *APNSSandboxChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSSandboxChannelResponse) SetId(v string) *APNSSandboxChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSSandboxChannelResponse) SetIsArchived(v bool) *APNSSandboxChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSSandboxChannelResponse) SetLastModifiedBy(v string) *APNSSandboxChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSSandboxChannelResponse) SetLastModifiedDate(v string) *APNSSandboxChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSSandboxChannelResponse) SetPlatform(v string) *APNSSandboxChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSSandboxChannelResponse) SetVersion(v int64) *APNSSandboxChannelResponse {
	s.Version = &v
	return s
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// VoIP channel for an application.
type APNSVoipChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with APNs by using an APNs certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with APNs, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs VoIP channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with APNs.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with APNs by using APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSVoipChannelRequest) SetBundleId(v string) *APNSVoipChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSVoipChannelRequest) SetCertificate(v string) *APNSVoipChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSVoipChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipChannelRequest) SetEnabled(v bool) *APNSVoipChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSVoipChannelRequest) SetPrivateKey(v string) *APNSVoipChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSVoipChannelRequest) SetTeamId(v string) *APNSVoipChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSVoipChannelRequest) SetTokenKey(v string) *APNSVoipChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSVoipChannelRequest) SetTokenKeyId(v string) *APNSVoipChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) VoIP channel for an application.
type APNSVoipChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs VoIP channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs VoIP channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with APNs for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs VoIP channel is configured to communicate with
	// APNs by using APNs tokens. To provide an authentication key for APNs tokens,
	// set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs VoIP channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs VoIP channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs VoIP channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs VoIP channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// VoIP channel, this value is APNS_VOIP.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs VoIP channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSVoipChannelResponse) SetApplicationId(v string) *APNSVoipChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSVoipChannelResponse) SetCreationDate(v string) *APNSVoipChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSVoipChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipChannelResponse) SetEnabled(v bool) *APNSVoipChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSVoipChannelResponse) SetHasCredential(v bool) *APNSVoipChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSVoipChannelResponse) SetHasTokenKey(v bool) *APNSVoipChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSVoipChannelResponse) SetId(v string) *APNSVoipChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSVoipChannelResponse) SetIsArchived(v bool) *APNSVoipChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSVoipChannelResponse) SetLastModifiedBy(v string) *APNSVoipChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSVoipChannelResponse) SetLastModifiedDate(v string) *APNSVoipChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSVoipChannelResponse) SetPlatform(v string) *APNSVoipChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSVoipChannelResponse) SetVersion(v int64) *APNSVoipChannelResponse {
	s.Version = &v
	return s
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// VoIP sandbox channel for an application.
type APNSVoipSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with the APNs sandbox environment by using an APNs
	// certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with the APNs sandbox environment for this channel, key or
	// certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with the APNs sandbox environment.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with the APNs sandbox environment by using
	// APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipSandboxChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSVoipSandboxChannelRequest) SetBundleId(v string) *APNSVoipSandboxChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSVoipSandboxChannelRequest) SetCertificate(v string) *APNSVoipSandboxChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipSandboxChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSVoipSandboxChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipSandboxChannelRequest) SetEnabled(v bool) *APNSVoipSandboxChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSVoipSandboxChannelRequest) SetPrivateKey(v string) *APNSVoipSandboxChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSVoipSandboxChannelRequest) SetTeamId(v string) *APNSVoipSandboxChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSVoipSandboxChannelRequest) SetTokenKey(v string) *APNSVoipSandboxChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSVoipSandboxChannelRequest) SetTokenKeyId(v string) *APNSVoipSandboxChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) VoIP sandbox channel for an application.
type APNSVoipSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs VoIP sandbox channel
	// applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs VoIP sandbox channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with the APNs sandbox environment for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs VoIP sandbox channel is configured to communicate
	// with APNs by using APNs tokens. To provide an authentication key for APNs
	// tokens, set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs VoIP sandbox channel. This property
	// is retained only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs VoIP sandbox channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs VoIP sandbox channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// VoIP sandbox channel, this value is APNS_VOIP_SANDBOX.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs VoIP sandbox channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipSandboxChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSVoipSandboxChannelResponse) SetApplicationId(v string) *APNSVoipSandboxChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSVoipSandboxChannelResponse) SetCreationDate(v string) *APNSVoipSandboxChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipSandboxChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSVoipSandboxChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipSandboxChannelResponse) SetEnabled(v bool) *APNSVoipSandboxChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSVoipSandboxChannelResponse) SetHasCredential(v bool) *APNSVoipSandboxChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSVoipSandboxChannelResponse) SetHasTokenKey(v bool) *APNSVoipSandboxChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSVoipSandboxChannelResponse) SetId(v string) *APNSVoipSandboxChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSVoipSandboxChannelResponse) SetIsArchived(v bool) *APNSVoipSandboxChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSVoipSandboxChannelResponse) SetLastModifiedBy(v string) *APNSVoipSandboxChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSVoipSandboxChannelResponse) SetLastModifiedDate(v string) *APNSVoipSandboxChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSVoipSandboxChannelResponse) SetPlatform(v string) *APNSVoipSandboxChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSVoipSandboxChannelResponse) SetVersion(v int64) *APNSVoipSandboxChannelResponse {
	s.Version = &v
	return s
}

// Provides information about the activities that were performed by a campaign.
type ActivitiesResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each activity that was performed by the campaign.
	//
	// Item is a required field
	Item []*ActivityResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ActivitiesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivitiesResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ActivitiesResponse) SetItem(v []*ActivityResponse) *ActivitiesResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ActivitiesResponse) SetNextToken(v string) *ActivitiesResponse {
	s.NextToken = &v
	return s
}

// Specifies the configuration and other settings for an activity in a journey.
type Activity struct {
	_ struct{} `type:"structure"`

	// The settings for a custom message activity. This type of activity calls an
	// AWS Lambda function or web hook that sends messages to participants.
	CUSTOM *CustomMessageActivity `type:"structure"`

	// The settings for a yes/no split activity. This type of activity sends participants
	// down one of two paths in a journey, based on conditions that you specify.
	ConditionalSplit *ConditionalSplitActivity `type:"structure"`

	// The custom description of the activity.
	Description *string `type:"string"`

	// The settings for an email activity. This type of activity sends an email
	// message to participants.
	EMAIL *EmailMessageActivity `type:"structure"`

	// The settings for a holdout activity. This type of activity stops a journey
	// for a specified percentage of participants.
	Holdout *HoldoutActivity `type:"structure"`

	// The settings for a multivariate split activity. This type of activity sends
	// participants down one of as many as five paths (including a default Else
	// path) in a journey, based on conditions that you specify.
	MultiCondition *MultiConditionalSplitActivity `type:"structure"`

	// The settings for a push notification activity. This type of activity sends
	// a push notification to participants.
	PUSH *PushMessageActivity `type:"structure"`

	// The settings for a random split activity. This type of activity randomly
	// sends specified percentages of participants down one of as many as five paths
	// in a journey, based on conditions that you specify.
	RandomSplit *RandomSplitActivity `type:"structure"`

	// The settings for an SMS activity. This type of activity sends a text message
	// to participants.
	SMS *SMSMessageActivity `type:"structure"`

	// The settings for a wait activity. This type of activity waits for a certain
	// amount of time or until a specific date and time before moving participants
	// to the next activity in a journey.
	Wait *WaitActivity `type:"structure"`
}

// String returns the string representation
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Activity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Activity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Activity"}
	if s.ConditionalSplit != nil {
		if err := s.ConditionalSplit.Validate(); err != nil {
			invalidParams.AddNested("ConditionalSplit", err.(request.ErrInvalidParams))
		}
	}
	if s.Holdout != nil {
		if err := s.Holdout.Validate(); err != nil {
			invalidParams.AddNested("Holdout", err.(request.ErrInvalidParams))
		}
	}
	if s.MultiCondition != nil {
		if err := s.MultiCondition.Validate(); err != nil {
			invalidParams.AddNested("MultiCondition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCUSTOM sets the CUSTOM field's value.
func (s *Activity) SetCUSTOM(v *CustomMessageActivity) *Activity {
	s.CUSTOM = v
	return s
}

// SetConditionalSplit sets the ConditionalSplit field's value.
func (s *Activity) SetConditionalSplit(v *ConditionalSplitActivity) *Activity {
	s.ConditionalSplit = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Activity) SetDescription(v string) *Activity {
	s.Description = &v
	return s
}

// SetEMAIL sets the EMAIL field's value.
func (s *Activity) SetEMAIL(v *EmailMessageActivity) *Activity {
	s.EMAIL = v
	return s
}

// SetHoldout sets the Holdout field's value.
func (s *Activity) SetHoldout(v *HoldoutActivity) *Activity {
	s.Holdout = v
	return s
}

// SetMultiCondition sets the MultiCondition field's value.
func (s *Activity) SetMultiCondition(v *MultiConditionalSplitActivity) *Activity {
	s.MultiCondition = v
	return s
}

// SetPUSH sets the PUSH field's value.
func (s *Activity) SetPUSH(v *PushMessageActivity) *Activity {
	s.PUSH = v
	return s
}

// SetRandomSplit sets the RandomSplit field's value.
func (s *Activity) SetRandomSplit(v *RandomSplitActivity) *Activity {
	s.RandomSplit = v
	return s
}

// SetSMS sets the SMS field's value.
func (s *Activity) SetSMS(v *SMSMessageActivity) *Activity {
	s.SMS = v
	return s
}

// SetWait sets the Wait field's value.
func (s *Activity) SetWait(v *WaitActivity) *Activity {
	s.Wait = v
	return s
}

// Provides information about an activity that was performed by a campaign.
type ActivityResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the campaign applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the campaign that the activity applies to.
	//
	// CampaignId is a required field
	CampaignId *string `type:"string" required:"true"`

	// The actual time, in ISO 8601 format, when the activity was marked CANCELLED
	// or COMPLETED.
	End *string `type:"string"`

	// The unique identifier for the activity.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies whether the activity succeeded. Possible values are SUCCESS and
	// FAIL.
	Result *string `type:"string"`

	// The scheduled start time, in ISO 8601 format, for the activity.
	ScheduledStart *string `type:"string"`

	// The actual start time, in ISO 8601 format, of the activity.
	Start *string `type:"string"`

	// The current status of the activity. Possible values are: PENDING, INITIALIZING,
	// RUNNING, PAUSED, CANCELLED, and COMPLETED.
	State *string `type:"string"`

	// The total number of endpoints that the campaign successfully delivered messages
	// to.
	SuccessfulEndpointCount *int64 `type:"integer"`

	// The total number of time zones that were completed.
	TimezonesCompletedCount *int64 `type:"integer"`

	// The total number of unique time zones that are in the segment for the campaign.
	TimezonesTotalCount *int64 `type:"integer"`

	// The total number of endpoints that the campaign attempted to deliver messages
	// to.
	TotalEndpointCount *int64 `type:"integer"`

	// The unique identifier for the campaign treatment that the activity applies
	// to. A treatment is a variation of a campaign that's used for A/B testing
	// of a campaign.
	TreatmentId *string `type:"string"`
}

// String returns the string representation
func (s ActivityResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ActivityResponse) SetApplicationId(v string) *ActivityResponse {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *ActivityResponse) SetCampaignId(v string) *ActivityResponse {
	s.CampaignId = &v
	return s
}

// SetEnd sets the End field's value.
func (s *ActivityResponse) SetEnd(v string) *ActivityResponse {
	s.End = &v
	return s
}

// SetId sets the Id field's value.
func (s *ActivityResponse) SetId(v string) *ActivityResponse {
	s.Id = &v
	return s
}

// SetResult sets the Result field's value.
func (s *ActivityResponse) SetResult(v string) *ActivityResponse {
	s.Result = &v
	return s
}

// SetScheduledStart sets the ScheduledStart field's value.
func (s *ActivityResponse) SetScheduledStart(v string) *ActivityResponse {
	s.ScheduledStart = &v
	return s
}

// SetStart sets the Start field's value.
func (s *ActivityResponse) SetStart(v string) *ActivityResponse {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *ActivityResponse) SetState(v string) *ActivityResponse {
	s.State = &v
	return s
}

// SetSuccessfulEndpointCount sets the SuccessfulEndpointCount field's value.
func (s *ActivityResponse) SetSuccessfulEndpointCount(v int64) *ActivityResponse {
	s.SuccessfulEndpointCount = &v
	return s
}

// SetTimezonesCompletedCount sets the TimezonesCompletedCount field's value.
func (s *ActivityResponse) SetTimezonesCompletedCount(v int64) *ActivityResponse {
	s.TimezonesCompletedCount = &v
	return s
}

// SetTimezonesTotalCount sets the TimezonesTotalCount field's value.
func (s *ActivityResponse) SetTimezonesTotalCount(v int64) *ActivityResponse {
	s.TimezonesTotalCount = &v
	return s
}

// SetTotalEndpointCount sets the TotalEndpointCount field's value.
func (s *ActivityResponse) SetTotalEndpointCount(v int64) *ActivityResponse {
	s.TotalEndpointCount = &v
	return s
}

// SetTreatmentId sets the TreatmentId field's value.
func (s *ActivityResponse) SetTreatmentId(v string) *ActivityResponse {
	s.TreatmentId = &v
	return s
}

// Specifies address-based configuration settings for a message that's sent
// directly to an endpoint.
type AddressConfiguration struct {
	_ struct{} `type:"structure"`

	// The message body to use instead of the default message body. This value overrides
	// the default message body.
	BodyOverride *string `type:"string"`

	// The channel to use when sending the message.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// An object that maps custom attributes to attributes for the address and is
	// attached to the message. Attribute names are case sensitive.
	//
	// For a push notification, this payload is added to the data.pinpoint object.
	// For an email or text message, this payload is added to email/SMS delivery
	// receipt event attributes.
	Context map[string]*string `type:"map"`

	// The raw, JSON-formatted string to use as the payload for the message. If
	// specified, this value overrides all other values for the message.
	RawContent *string `type:"string"`

	// A map of the message variables to merge with the variables specified by properties
	// of the DefaultMessage object. The variables specified in this map take precedence
	// over all other variables.
	Substitutions map[string][]*string `type:"map"`

	// The message title to use instead of the default message title. This value
	// overrides the default message title.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s AddressConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressConfiguration) GoString() string {
	return s.String()
}

// SetBodyOverride sets the BodyOverride field's value.
func (s *AddressConfiguration) SetBodyOverride(v string) *AddressConfiguration {
	s.BodyOverride = &v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *AddressConfiguration) SetChannelType(v string) *AddressConfiguration {
	s.ChannelType = &v
	return s
}

// SetContext sets the Context field's value.
func (s *AddressConfiguration) SetContext(v map[string]*string) *AddressConfiguration {
	s.Context = v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *AddressConfiguration) SetRawContent(v string) *AddressConfiguration {
	s.RawContent = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *AddressConfiguration) SetSubstitutions(v map[string][]*string) *AddressConfiguration {
	s.Substitutions = v
	return s
}

// SetTitleOverride sets the TitleOverride field's value.
func (s *AddressConfiguration) SetTitleOverride(v string) *AddressConfiguration {
	s.TitleOverride = &v
	return s
}

// Specifies channel-specific content and settings for a message template that
// can be used in push notifications that are sent through the ADM (Amazon Device
// Messaging), Baidu (Baidu Cloud Push), or GCM (Firebase Cloud Messaging, formerly
// Google Cloud Messaging) channel.
type AndroidPushNotificationTemplate struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps a push notification that's based
	// on the message template. Valid values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The message body to use in a push notification that's based on the message
	// template.
	Body *string `type:"string"`

	// The URL of the large icon image to display in the content view of a push
	// notification that's based on the message template.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in a push notification that's based on the
	// message template.
	ImageUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for a push notification
	// that's based on the message template. If specified, this value overrides
	// all other content for the message template.
	RawContent *string `type:"string"`

	// The URL of the small icon image to display in the status bar and the content
	// view of a push notification that's based on the message template.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when a recipient receives a push notification that's based
	// on the message template. You can use the default stream or specify the file
	// name of a sound resource that's bundled in your app. On an Android platform,
	// the sound file must reside in /res/raw/.
	Sound *string `type:"string"`

	// The title to use in a push notification that's based on the message template.
	// This title appears above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in a recipient's default mobile browser, if a recipient taps
	// a push notification that's based on the message template and the value of
	// the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s AndroidPushNotificationTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AndroidPushNotificationTemplate) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *AndroidPushNotificationTemplate) SetAction(v string) *AndroidPushNotificationTemplate {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *AndroidPushNotificationTemplate) SetBody(v string) *AndroidPushNotificationTemplate {
	s.Body = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *AndroidPushNotificationTemplate) SetImageIconUrl(v string) *AndroidPushNotificationTemplate {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *AndroidPushNotificationTemplate) SetImageUrl(v string) *AndroidPushNotificationTemplate {
	s.ImageUrl = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *AndroidPushNotificationTemplate) SetRawContent(v string) *AndroidPushNotificationTemplate {
	s.RawContent = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *AndroidPushNotificationTemplate) SetSmallImageIconUrl(v string) *AndroidPushNotificationTemplate {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *AndroidPushNotificationTemplate) SetSound(v string) *AndroidPushNotificationTemplate {
	s.Sound = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *AndroidPushNotificationTemplate) SetTitle(v string) *AndroidPushNotificationTemplate {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *AndroidPushNotificationTemplate) SetUrl(v string) *AndroidPushNotificationTemplate {
	s.Url = &v
	return s
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application, and provides information about that query.
type ApplicationDateRangeKpiResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the metric, also referred to as a key performance indicator (KPI),
	// that the data was retrieved for. This value describes the associated metric
	// and consists of two or more terms, which are comprised of lowercase alphanumeric
	// characters, separated by a hyphen. For a list of possible values, see the
	// Amazon Pinpoint Developer Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
	//
	// KpiName is a required field
	KpiName *string `type:"string" required:"true"`

	// An array of objects that contains the results of the query. Each object contains
	// the value for the metric and metadata about that value.
	//
	// KpiResult is a required field
	KpiResult *BaseKpiResult `type:"structure" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null for the Application Metrics resource
	// because the resource returns all results in a single page.
	NextToken *string `type:"string"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ApplicationDateRangeKpiResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationDateRangeKpiResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationDateRangeKpiResponse) SetApplicationId(v string) *ApplicationDateRangeKpiResponse {
	s.ApplicationId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ApplicationDateRangeKpiResponse) SetEndTime(v time.Time) *ApplicationDateRangeKpiResponse {
	s.EndTime = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *ApplicationDateRangeKpiResponse) SetKpiName(v string) *ApplicationDateRangeKpiResponse {
	s.KpiName = &v
	return s
}

// SetKpiResult sets the KpiResult field's value.
func (s *ApplicationDateRangeKpiResponse) SetKpiResult(v *BaseKpiResult) *ApplicationDateRangeKpiResponse {
	s.KpiResult = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ApplicationDateRangeKpiResponse) SetNextToken(v string) *ApplicationDateRangeKpiResponse {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ApplicationDateRangeKpiResponse) SetStartTime(v time.Time) *ApplicationDateRangeKpiResponse {
	s.StartTime = &v
	return s
}

// Provides information about an application.
type ApplicationResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The unique identifier for the application. This identifier is displayed as
	// the Project ID on the Amazon Pinpoint console.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The display name of the application. This name is displayed as the Project
	// name on the Amazon Pinpoint console.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the application. Each tag consists of a required tag key
	// and an associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ApplicationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationResponse) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ApplicationResponse) SetArn(v string) *ApplicationResponse {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ApplicationResponse) SetId(v string) *ApplicationResponse {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationResponse) SetName(v string) *ApplicationResponse {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ApplicationResponse) SetTags(v map[string]*string) *ApplicationResponse {
	s.Tags = v
	return s
}

// Provides information about an application, including the default settings
// for an application.
type ApplicationSettingsResource struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application. This identifier is displayed as
	// the Project ID on the Amazon Pinpoint console.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The settings for the AWS Lambda function to invoke by default as a code hook
	// for campaigns in the application. You can use this hook to customize segments
	// that are used by campaigns in the application.
	CampaignHook *CampaignHook `type:"structure"`

	// The date and time, in ISO 8601 format, when the application's settings were
	// last modified.
	LastModifiedDate *string `type:"string"`

	// The default sending limits for campaigns and journeys in the application.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for campaigns and journeys in the application. Quiet
	// time is a specific time range when messages aren't sent to endpoints, if
	// all the following conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint is set to
	//    a valid value.
	//
	//    * The current time in the endpoint's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the application
	//    (or a campaign or journey that has custom quiet time settings).
	//
	//    * The current time in the endpoint's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the application
	//    (or a campaign or journey that has custom quiet time settings).
	//
	// If any of the preceding conditions isn't met, the endpoint will receive messages
	// from a campaign or journey, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s ApplicationSettingsResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSettingsResource) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationSettingsResource) SetApplicationId(v string) *ApplicationSettingsResource {
	s.ApplicationId = &v
	return s
}

// SetCampaignHook sets the CampaignHook field's value.
func (s *ApplicationSettingsResource) SetCampaignHook(v *CampaignHook) *ApplicationSettingsResource {
	s.CampaignHook = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ApplicationSettingsResource) SetLastModifiedDate(v string) *ApplicationSettingsResource {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *ApplicationSettingsResource) SetLimits(v *CampaignLimits) *ApplicationSettingsResource {
	s.Limits = v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *ApplicationSettingsResource) SetQuietTime(v *QuietTime) *ApplicationSettingsResource {
	s.QuietTime = v
	return s
}

// Provides information about all of your applications.
type ApplicationsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each application that was returned.
	Item []*ApplicationResponse `type:"list"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ApplicationsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ApplicationsResponse) SetItem(v []*ApplicationResponse) *ApplicationsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ApplicationsResponse) SetNextToken(v string) *ApplicationsResponse {
	s.NextToken = &v
	return s
}

// Specifies attribute-based criteria for including or excluding endpoints from
// a segment.
type AttributeDimension struct {
	_ struct{} `type:"structure"`

	// The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints
	// that match the criteria are included in the segment; and, EXCLUSIVE, endpoints
	// that match the criteria are excluded from the segment.
	AttributeType *string `type:"string" enum:"AttributeType"`

	// The criteria values to use for the segment dimension. Depending on the value
	// of the AttributeType property, endpoints are included or excluded from the
	// segment if their attribute values match the criteria values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AttributeDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeDimension"}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeType sets the AttributeType field's value.
func (s *AttributeDimension) SetAttributeType(v string) *AttributeDimension {
	s.AttributeType = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AttributeDimension) SetValues(v []*string) *AttributeDimension {
	s.Values = v
	return s
}

// Provides information about the type and the names of attributes that were
// removed from all the endpoints that are associated with an application.
type AttributesResource struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The type of attribute or attributes that were removed from the endpoints.
	// Valid values are:
	//
	//    * endpoint-custom-attributes - Custom attributes that describe endpoints.
	//
	//    * endpoint-metric-attributes - Custom metrics that your app reports to
	//    Amazon Pinpoint for endpoints.
	//
	//    * endpoint-user-attributes - Custom attributes that describe users.
	//
	// AttributeType is a required field
	AttributeType *string `type:"string" required:"true"`

	// An array that specifies the names of the attributes that were removed from
	// the endpoints.
	Attributes []*string `type:"list"`
}

// String returns the string representation
func (s AttributesResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributesResource) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *AttributesResource) SetApplicationId(v string) *AttributesResource {
	s.ApplicationId = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *AttributesResource) SetAttributeType(v string) *AttributesResource {
	s.AttributeType = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *AttributesResource) SetAttributes(v []*string) *AttributesResource {
	s.Attributes = v
	return s
}

// Provides information about an API request or response.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RequestID_ *string `locationName:"RequestID" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the status and settings of the Baidu (Baidu Cloud Push) channel
// for an application.
type BaiduChannelRequest struct {
	_ struct{} `type:"structure"`

	// The API key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// ApiKey is a required field
	ApiKey *string `type:"string" required:"true"`

	// Specifies whether to enable the Baidu channel for the application.
	Enabled *bool `type:"boolean"`

	// The secret key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// SecretKey is a required field
	SecretKey *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BaiduChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduChannelRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BaiduChannelRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BaiduChannelRequest"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}
	if s.SecretKey == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *BaiduChannelRequest) SetApiKey(v string) *BaiduChannelRequest {
	s.ApiKey = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *BaiduChannelRequest) SetEnabled(v bool) *BaiduChannelRequest {
	s.Enabled = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *BaiduChannelRequest) SetSecretKey(v string) *BaiduChannelRequest {
	s.SecretKey = &v
	return s
}

// Provides information about the status and settings of the Baidu (Baidu Cloud
// Push) channel for an application.
type BaiduChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the Baidu channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the Baidu channel was enabled.
	CreationDate *string `type:"string"`

	// The API key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// Credential is a required field
	Credential *string `type:"string" required:"true"`

	// Specifies whether the Baidu channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the Baidu channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the Baidu channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the Baidu channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the Baidu channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the Baidu
	// channel, this value is BAIDU.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the Baidu channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s BaiduChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *BaiduChannelResponse) SetApplicationId(v string) *BaiduChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *BaiduChannelResponse) SetCreationDate(v string) *BaiduChannelResponse {
	s.CreationDate = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *BaiduChannelResponse) SetCredential(v string) *BaiduChannelResponse {
	s.Credential = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *BaiduChannelResponse) SetEnabled(v bool) *BaiduChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *BaiduChannelResponse) SetHasCredential(v bool) *BaiduChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *BaiduChannelResponse) SetId(v string) *BaiduChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *BaiduChannelResponse) SetIsArchived(v bool) *BaiduChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *BaiduChannelResponse) SetLastModifiedBy(v string) *BaiduChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *BaiduChannelResponse) SetLastModifiedDate(v string) *BaiduChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *BaiduChannelResponse) SetPlatform(v string) *BaiduChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *BaiduChannelResponse) SetVersion(v int64) *BaiduChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the Baidu (Baidu Cloud Push) channel.
type BaiduMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The body of the notification message.
	Body *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]*string `type:"map"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The amount of time, in seconds, that the Baidu Cloud Push service should
	// store the message if the recipient's device is offline. The default value
	// and maximum supported time is 604,800 seconds (7 days).
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s BaiduMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *BaiduMessage) SetAction(v string) *BaiduMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *BaiduMessage) SetBody(v string) *BaiduMessage {
	s.Body = &v
	return s
}

// SetData sets the Data field's value.
func (s *BaiduMessage) SetData(v map[string]*string) *BaiduMessage {
	s.Data = v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *BaiduMessage) SetIconReference(v string) *BaiduMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *BaiduMessage) SetImageIconUrl(v string) *BaiduMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *BaiduMessage) SetImageUrl(v string) *BaiduMessage {
	s.ImageUrl = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *BaiduMessage) SetRawContent(v string) *BaiduMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *BaiduMessage) SetSilentPush(v bool) *BaiduMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *BaiduMessage) SetSmallImageIconUrl(v string) *BaiduMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *BaiduMessage) SetSound(v string) *BaiduMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *BaiduMessage) SetSubstitutions(v map[string][]*string) *BaiduMessage {
	s.Substitutions = v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *BaiduMessage) SetTimeToLive(v int64) *BaiduMessage {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *BaiduMessage) SetTitle(v string) *BaiduMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *BaiduMessage) SetUrl(v string) *BaiduMessage {
	s.Url = &v
	return s
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application, campaign, or journey.
type BaseKpiResult struct {
	_ struct{} `type:"structure"`

	// An array of objects that provides the results of a query that retrieved the
	// data for a standard metric that applies to an application, campaign, or journey.
	//
	// Rows is a required field
	Rows []*ResultRow `type:"list" required:"true"`
}

// String returns the string representation
func (s BaseKpiResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaseKpiResult) GoString() string {
	return s.String()
}

// SetRows sets the Rows field's value.
func (s *BaseKpiResult) SetRows(v []*ResultRow) *BaseKpiResult {
	s.Rows = v
	return s
}

// Specifies the contents of a message that's sent through a custom channel
// to recipients of a campaign.
type CampaignCustomMessage struct {
	_ struct{} `type:"structure"`

	// The raw, JSON-formatted string to use as the payload for the message. The
	// maximum size is 5 KB.
	Data *string `type:"string"`
}

// String returns the string representation
func (s CampaignCustomMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignCustomMessage) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *CampaignCustomMessage) SetData(v string) *CampaignCustomMessage {
	s.Data = &v
	return s
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to a campaign, and provides information about that query.
type CampaignDateRangeKpiResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the campaign that the metric applies to.
	//
	// CampaignId is a required field
	CampaignId *string `type:"string" required:"true"`

	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the metric, also referred to as a key performance indicator (KPI),
	// that the data was retrieved for. This value describes the associated metric
	// and consists of two or more terms, which are comprised of lowercase alphanumeric
	// characters, separated by a hyphen. For a list of possible values, see the
	// Amazon Pinpoint Developer Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
	//
	// KpiName is a required field
	KpiName *string `type:"string" required:"true"`

	// An array of objects that contains the results of the query. Each object contains
	// the value for the metric and metadata about that value.
	//
	// KpiResult is a required field
	KpiResult *BaseKpiResult `type:"structure" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null for the Campaign Metrics resource
	// because the resource returns all results in a single page.
	NextToken *string `type:"string"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s CampaignDateRangeKpiResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignDateRangeKpiResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CampaignDateRangeKpiResponse) SetApplicationId(v string) *CampaignDateRangeKpiResponse {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *CampaignDateRangeKpiResponse) SetCampaignId(v string) *CampaignDateRangeKpiResponse {
	s.CampaignId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CampaignDateRangeKpiResponse) SetEndTime(v time.Time) *CampaignDateRangeKpiResponse {
	s.EndTime = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *CampaignDateRangeKpiResponse) SetKpiName(v string) *CampaignDateRangeKpiResponse {
	s.KpiName = &v
	return s
}

// SetKpiResult sets the KpiResult field's value.
func (s *CampaignDateRangeKpiResponse) SetKpiResult(v *BaseKpiResult) *CampaignDateRangeKpiResponse {
	s.KpiResult = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *CampaignDateRangeKpiResponse) SetNextToken(v string) *CampaignDateRangeKpiResponse {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CampaignDateRangeKpiResponse) SetStartTime(v time.Time) *CampaignDateRangeKpiResponse {
	s.StartTime = &v
	return s
}

// Specifies the content and "From" address for an email message that's sent
// to recipients of a campaign.
type CampaignEmailMessage struct {
	_ struct{} `type:"structure"`

	// The body of the email for recipients whose email clients don't render HTML
	// content.
	Body *string `type:"string"`

	// The verified email address to send the email from. The default address is
	// the FromAddress specified for the email channel for the application.
	FromAddress *string `type:"string"`

	// The body of the email, in HTML format, for recipients whose email clients
	// render HTML content.
	HtmlBody *string `type:"string"`

	// The subject line, or title, of the email.
	Title *string `type:"string"`
}

// String returns the string representation
func (s CampaignEmailMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignEmailMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *CampaignEmailMessage) SetBody(v string) *CampaignEmailMessage {
	s.Body = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *CampaignEmailMessage) SetFromAddress(v string) *CampaignEmailMessage {
	s.FromAddress = &v
	return s
}

// SetHtmlBody sets the HtmlBody field's value.
func (s *CampaignEmailMessage) SetHtmlBody(v string) *CampaignEmailMessage {
	s.HtmlBody = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CampaignEmailMessage) SetTitle(v string) *CampaignEmailMessage {
	s.Title = &v
	return s
}

// Specifies the settings for events that cause a campaign to be sent.
type CampaignEventFilter struct {
	_ struct{} `type:"structure"`

	// The dimension settings of the event filter for the campaign.
	//
	// Dimensions is a required field
	Dimensions *EventDimensions `type:"structure" required:"true"`

	// The type of event that causes the campaign to be sent. Valid values are:
	// SYSTEM, sends the campaign when a system event occurs; and, ENDPOINT, sends
	// the campaign when an endpoint event (Events resource) occurs.
	//
	// FilterType is a required field
	FilterType *string `type:"string" required:"true" enum:"FilterType"`
}

// String returns the string representation
func (s CampaignEventFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignEventFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CampaignEventFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CampaignEventFilter"}
	if s.Dimensions == nil {
		invalidParams.Add(request.NewErrParamRequired("Dimensions"))
	}
	if s.FilterType == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterType"))
	}
	if s.Dimensions != nil {
		if err := s.Dimensions.Validate(); err != nil {
			invalidParams.AddNested("Dimensions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *CampaignEventFilter) SetDimensions(v *EventDimensions) *CampaignEventFilter {
	s.Dimensions = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *CampaignEventFilter) SetFilterType(v string) *CampaignEventFilter {
	s.FilterType = &v
	return s
}

// Specifies settings for invoking an AWS Lambda function that customizes a
// segment for a campaign.
type CampaignHook struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon
	// Pinpoint invokes to customize a segment for a campaign.
	LambdaFunctionName *string `type:"string"`

	// The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible
	// values are:
	//
	//    * FILTER - Invoke the function to customize the segment that's used by
	//    a campaign.
	//
	//    * DELIVERY - (Deprecated) Previously, invoked the function to send a campaign
	//    through a custom channel. This functionality is not supported anymore.
	//    To send a campaign through a custom channel, use the CustomDeliveryConfiguration
	//    and CampaignCustomMessage objects of the campaign.
	Mode *string `type:"string" enum:"Mode"`

	// The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function
	// over HTTPS.
	WebUrl *string `type:"string"`
}

// String returns the string representation
func (s CampaignHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignHook) GoString() string {
	return s.String()
}

// SetLambdaFunctionName sets the LambdaFunctionName field's value.
func (s *CampaignHook) SetLambdaFunctionName(v string) *CampaignHook {
	s.LambdaFunctionName = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *CampaignHook) SetMode(v string) *CampaignHook {
	s.Mode = &v
	return s
}

// SetWebUrl sets the WebUrl field's value.
func (s *CampaignHook) SetWebUrl(v string) *CampaignHook {
	s.WebUrl = &v
	return s
}

// For a campaign, specifies limits on the messages that the campaign can send.
// For an application, specifies the default limits for messages that campaigns
// and journeys in the application can send.
type CampaignLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of messages that a campaign can send to a single endpoint
	// during a 24-hour period. For an application, this value specifies the default
	// limit for the number of messages that campaigns and journeys can send to
	// a single endpoint during a 24-hour period. The maximum value is 100.
	Daily *int64 `type:"integer"`

	// The maximum amount of time, in seconds, that a campaign can attempt to deliver
	// a message after the scheduled start time for the campaign. The minimum value
	// is 60 seconds.
	MaximumDuration *int64 `type:"integer"`

	// The maximum number of messages that a campaign can send each second. For
	// an application, this value specifies the default limit for the number of
	// messages that campaigns and journeys can send each second. The minimum value
	// is 50. The maximum value is 20,000.
	MessagesPerSecond *int64 `type:"integer"`

	// The maximum number of messages that a campaign can send to a single endpoint
	// during the course of the campaign. If a campaign recurs, this setting applies
	// to all runs of the campaign. The maximum value is 100.
	Total *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignLimits) GoString() string {
	return s.String()
}

// SetDaily sets the Daily field's value.
func (s *CampaignLimits) SetDaily(v int64) *CampaignLimits {
	s.Daily = &v
	return s
}

// SetMaximumDuration sets the MaximumDuration field's value.
func (s *CampaignLimits) SetMaximumDuration(v int64) *CampaignLimits {
	s.MaximumDuration = &v
	return s
}

// SetMessagesPerSecond sets the MessagesPerSecond field's value.
func (s *CampaignLimits) SetMessagesPerSecond(v int64) *CampaignLimits {
	s.MessagesPerSecond = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *CampaignLimits) SetTotal(v int64) *CampaignLimits {
	s.Total = &v
	return s
}

// Provides information about the status, configuration, and other settings
// for a campaign.
type CampaignResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each treatment that you defined for the campaign,
	// in addition to the default treatment.
	AdditionalTreatments []*TreatmentResource `type:"list"`

	// The unique identifier for the application that the campaign applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the campaign.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The date, in ISO 8601 format, when the campaign was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The delivery configuration settings for sending the campaign through a custom
	// channel.
	CustomDeliveryConfiguration *CustomDeliveryConfiguration `type:"structure"`

	// The current status of the campaign's default treatment. This value exists
	// only for campaigns that have more than one treatment.
	DefaultState *CampaignState `type:"structure"`

	// The custom description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of users (segment members) who shouldn't receive
	// messages from the campaign.
	HoldoutPercent *int64 `type:"integer"`

	// The settings for the AWS Lambda function to use as a code hook for the campaign.
	// You can use this hook to customize the segment that's used by the campaign.
	Hook *CampaignHook `type:"structure"`

	// The unique identifier for the campaign.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies whether the campaign is paused. A paused campaign doesn't run unless
	// you resume it by changing this value to false.
	IsPaused *bool `type:"boolean"`

	// The date, in ISO 8601 format, when the campaign was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// The messaging limits for the campaign.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings for the campaign.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The name of the campaign.
	Name *string `type:"string"`

	// The schedule settings for the campaign.
	Schedule *Schedule `type:"structure"`

	// The unique identifier for the segment that's associated with the campaign.
	//
	// SegmentId is a required field
	SegmentId *string `type:"string" required:"true"`

	// The version number of the segment that's associated with the campaign.
	//
	// SegmentVersion is a required field
	SegmentVersion *int64 `type:"integer" required:"true"`

	// The current status of the campaign.
	State *CampaignState `type:"structure"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the campaign. Each tag consists of a required tag key and
	// an associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The message template that’s used for the campaign.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// The custom description of the default treatment for the campaign.
	TreatmentDescription *string `type:"string"`

	// The custom name of the default treatment for the campaign, if the campaign
	// has multiple treatments. A treatment is a variation of a campaign that's
	// used for A/B testing.
	TreatmentName *string `type:"string"`

	// The version number of the campaign.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignResponse) GoString() string {
	return s.String()
}

// SetAdditionalTreatments sets the AdditionalTreatments field's value.
func (s *CampaignResponse) SetAdditionalTreatments(v []*TreatmentResource) *CampaignResponse {
	s.AdditionalTreatments = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CampaignResponse) SetApplicationId(v string) *CampaignResponse {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CampaignResponse) SetArn(v string) *CampaignResponse {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CampaignResponse) SetCreationDate(v string) *CampaignResponse {
	s.CreationDate = &v
	return s
}

// SetCustomDeliveryConfiguration sets the CustomDeliveryConfiguration field's value.
func (s *CampaignResponse) SetCustomDeliveryConfiguration(v *CustomDeliveryConfiguration) *CampaignResponse {
	s.CustomDeliveryConfiguration = v
	return s
}

// SetDefaultState sets the DefaultState field's value.
func (s *CampaignResponse) SetDefaultState(v *CampaignState) *CampaignResponse {
	s.DefaultState = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CampaignResponse) SetDescription(v string) *CampaignResponse {
	s.Description = &v
	return s
}

// SetHoldoutPercent sets the HoldoutPercent field's value.
func (s *CampaignResponse) SetHoldoutPercent(v int64) *CampaignResponse {
	s.HoldoutPercent = &v
	return s
}

// SetHook sets the Hook field's value.
func (s *CampaignResponse) SetHook(v *CampaignHook) *CampaignResponse {
	s.Hook = v
	return s
}

// SetId sets the Id field's value.
func (s *CampaignResponse) SetId(v string) *CampaignResponse {
	s.Id = &v
	return s
}

// SetIsPaused sets the IsPaused field's value.
func (s *CampaignResponse) SetIsPaused(v bool) *CampaignResponse {
	s.IsPaused = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CampaignResponse) SetLastModifiedDate(v string) *CampaignResponse {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *CampaignResponse) SetLimits(v *CampaignLimits) *CampaignResponse {
	s.Limits = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *CampaignResponse) SetMessageConfiguration(v *MessageConfiguration) *CampaignResponse {
	s.MessageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CampaignResponse) SetName(v string) *CampaignResponse {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CampaignResponse) SetSchedule(v *Schedule) *CampaignResponse {
	s.Schedule = v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *CampaignResponse) SetSegmentId(v string) *CampaignResponse {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *CampaignResponse) SetSegmentVersion(v int64) *CampaignResponse {
	s.SegmentVersion = &v
	return s
}

// SetState sets the State field's value.
func (s *CampaignResponse) SetState(v *CampaignState) *CampaignResponse {
	s.State = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CampaignResponse) SetTags(v map[string]*string) *CampaignResponse {
	s.Tags = v
	return s
}

// SetTemplateConfiguration sets the TemplateConfiguration field's value.
func (s *CampaignResponse) SetTemplateConfiguration(v *TemplateConfiguration) *CampaignResponse {
	s.TemplateConfiguration = v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *CampaignResponse) SetTreatmentDescription(v string) *CampaignResponse {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *CampaignResponse) SetTreatmentName(v string) *CampaignResponse {
	s.TreatmentName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CampaignResponse) SetVersion(v int64) *CampaignResponse {
	s.Version = &v
	return s
}

// Specifies the content and settings for an SMS message that's sent to recipients
// of a campaign.
type CampaignSmsMessage struct {
	_ struct{} `type:"structure"`

	// The body of the SMS message.
	Body *string `type:"string"`

	// The SMS message type. Valid values are TRANSACTIONAL (for messages that are
	// critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL
	// (for messsages that aren't critical or time-sensitive, such as marketing
	// messages).
	MessageType *string `type:"string" enum:"MessageType"`

	// The sender ID to display on recipients' devices when they receive the SMS
	// message.
	SenderId *string `type:"string"`
}

// String returns the string representation
func (s CampaignSmsMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignSmsMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *CampaignSmsMessage) SetBody(v string) *CampaignSmsMessage {
	s.Body = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *CampaignSmsMessage) SetMessageType(v string) *CampaignSmsMessage {
	s.MessageType = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *CampaignSmsMessage) SetSenderId(v string) *CampaignSmsMessage {
	s.SenderId = &v
	return s
}

// Provides information about the status of a campaign.
type CampaignState struct {
	_ struct{} `type:"structure"`

	// The current status of the campaign, or the current status of a treatment
	// that belongs to an A/B test campaign.
	//
	// If a campaign uses A/B testing, the campaign has a status of COMPLETED only
	// if all campaign treatments have a status of COMPLETED. If you delete the
	// segment that's associated with a campaign, the campaign fails and has a status
	// of DELETED.
	CampaignStatus *string `type:"string" enum:"CampaignStatus"`
}

// String returns the string representation
func (s CampaignState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignState) GoString() string {
	return s.String()
}

// SetCampaignStatus sets the CampaignStatus field's value.
func (s *CampaignState) SetCampaignStatus(v string) *CampaignState {
	s.CampaignStatus = &v
	return s
}

// Provides information about the configuration and other settings for all the
// campaigns that are associated with an application.
type CampaignsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each campaign that's associated with the application.
	//
	// Item is a required field
	Item []*CampaignResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s CampaignsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *CampaignsResponse) SetItem(v []*CampaignResponse) *CampaignsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *CampaignsResponse) SetNextToken(v string) *CampaignsResponse {
	s.NextToken = &v
	return s
}

// Provides information about the general settings and status of a channel for
// an application.
type ChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application.
	ApplicationId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the channel. This property is retained only
	// for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The current version of the channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ChannelResponse) SetApplicationId(v string) *ChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ChannelResponse) SetCreationDate(v string) *ChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ChannelResponse) SetEnabled(v bool) *ChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *ChannelResponse) SetHasCredential(v bool) *ChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *ChannelResponse) SetId(v string) *ChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *ChannelResponse) SetIsArchived(v bool) *ChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *ChannelResponse) SetLastModifiedBy(v string) *ChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ChannelResponse) SetLastModifiedDate(v string) *ChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ChannelResponse) SetVersion(v int64) *ChannelResponse {
	s.Version = &v
	return s
}

// Provides information about the general settings and status of all channels
// for an application, including channels that aren't enabled for the application.
type ChannelsResponse struct {
	_ struct{} `type:"structure"`

	// A map that contains a multipart response for each channel. For each item
	// in this object, the ChannelType is the key and the Channel is the value.
	//
	// Channels is a required field
	Channels map[string]*ChannelResponse `type:"map" required:"true"`
}

// String returns the string representation
func (s ChannelsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelsResponse) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ChannelsResponse) SetChannels(v map[string]*ChannelResponse) *ChannelsResponse {
	s.Channels = v
	return s
}

// Specifies the conditions to evaluate for an activity in a journey, and how
// to evaluate those conditions.
type Condition struct {
	_ struct{} `type:"structure"`

	// The conditions to evaluate for the activity.
	Conditions []*SimpleCondition `type:"list"`

	// Specifies how to handle multiple conditions for the activity. For example,
	// if you specify two conditions for an activity, whether both or only one of
	// the conditions must be met for the activity to be performed.
	Operator *string `type:"string" enum:"Operator"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditions sets the Conditions field's value.
func (s *Condition) SetConditions(v []*SimpleCondition) *Condition {
	s.Conditions = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *Condition) SetOperator(v string) *Condition {
	s.Operator = &v
	return s
}

// Specifies the settings for a yes/no split activity in a journey. This type
// of activity sends participants down one of two paths in a journey, based
// on conditions that you specify.
type ConditionalSplitActivity struct {
	_ struct{} `type:"structure"`

	// The conditions that define the paths for the activity, and the relationship
	// between the conditions.
	Condition *Condition `type:"structure"`

	// The amount of time to wait before determining whether the conditions are
	// met, or the date and time when Amazon Pinpoint determines whether the conditions
	// are met.
	EvaluationWaitTime *WaitTime `type:"structure"`

	// The unique identifier for the activity to perform if the conditions aren't
	// met.
	FalseActivity *string `type:"string"`

	// The unique identifier for the activity to perform if the conditions are met.
	TrueActivity *string `type:"string"`
}

// String returns the string representation
func (s ConditionalSplitActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalSplitActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalSplitActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalSplitActivity"}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ConditionalSplitActivity) SetCondition(v *Condition) *ConditionalSplitActivity {
	s.Condition = v
	return s
}

// SetEvaluationWaitTime sets the EvaluationWaitTime field's value.
func (s *ConditionalSplitActivity) SetEvaluationWaitTime(v *WaitTime) *ConditionalSplitActivity {
	s.EvaluationWaitTime = v
	return s
}

// SetFalseActivity sets the FalseActivity field's value.
func (s *ConditionalSplitActivity) SetFalseActivity(v string) *ConditionalSplitActivity {
	s.FalseActivity = &v
	return s
}

// SetTrueActivity sets the TrueActivity field's value.
func (s *ConditionalSplitActivity) SetTrueActivity(v string) *ConditionalSplitActivity {
	s.TrueActivity = &v
	return s
}

type CreateAppInput struct {
	_ struct{} `type:"structure" payload:"CreateApplicationRequest"`

	// Specifies the display name of an application and the tags to associate with
	// the application.
	//
	// CreateApplicationRequest is a required field
	CreateApplicationRequest *CreateApplicationRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInput"}
	if s.CreateApplicationRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateApplicationRequest"))
	}
	if s.CreateApplicationRequest != nil {
		if err := s.CreateApplicationRequest.Validate(); err != nil {
			invalidParams.AddNested("CreateApplicationRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateApplicationRequest sets the CreateApplicationRequest field's value.
func (s *CreateAppInput) SetCreateApplicationRequest(v *CreateApplicationRequest) *CreateAppInput {
	s.CreateApplicationRequest = v
	return s
}

type CreateAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Provides information about an application.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *CreateAppOutput) SetApplicationResponse(v *ApplicationResponse) *CreateAppOutput {
	s.ApplicationResponse = v
	return s
}

// Specifies the display name of an application and the tags to associate with
// the application.
type CreateApplicationRequest struct {
	_ struct{} `type:"structure"`

	// The display name of the application. This name is displayed as the Project
	// name on the Amazon Pinpoint console.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the application. Each tag consists of a required tag key and an associated
	// tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateApplicationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationRequest"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateApplicationRequest) SetName(v string) *CreateApplicationRequest {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationRequest) SetTags(v map[string]*string) *CreateApplicationRequest {
	s.Tags = v
	return s
}

type CreateCampaignInput struct {
	_ struct{} `type:"structure" payload:"WriteCampaignRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the configuration and other settings for a campaign.
	//
	// WriteCampaignRequest is a required field
	WriteCampaignRequest *WriteCampaignRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.WriteCampaignRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCampaignRequest"))
	}
	if s.WriteCampaignRequest != nil {
		if err := s.WriteCampaignRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteCampaignRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateCampaignInput) SetApplicationId(v string) *CreateCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetWriteCampaignRequest sets the WriteCampaignRequest field's value.
func (s *CreateCampaignInput) SetWriteCampaignRequest(v *WriteCampaignRequest) *CreateCampaignInput {
	s.WriteCampaignRequest = v
	return s
}

type CreateCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *CreateCampaignOutput) SetCampaignResponse(v *CampaignResponse) *CreateCampaignOutput {
	s.CampaignResponse = v
	return s
}

type CreateEmailTemplateInput struct {
	_ struct{} `type:"structure" payload:"EmailTemplateRequest"`

	// Specifies the content and settings for a message template that can be used
	// in messages that are sent through the email channel.
	//
	// EmailTemplateRequest is a required field
	EmailTemplateRequest *EmailTemplateRequest `type:"structure" required:"true"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEmailTemplateInput"}
	if s.EmailTemplateRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailTemplateRequest"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailTemplateRequest sets the EmailTemplateRequest field's value.
func (s *CreateEmailTemplateInput) SetEmailTemplateRequest(v *EmailTemplateRequest) *CreateEmailTemplateInput {
	s.EmailTemplateRequest = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateEmailTemplateInput) SetTemplateName(v string) *CreateEmailTemplateInput {
	s.TemplateName = &v
	return s
}

type CreateEmailTemplateOutput struct {
	_ struct{} `type:"structure" payload:"CreateTemplateMessageBody"`

	// Provides information about a request to create a message template.
	//
	// CreateTemplateMessageBody is a required field
	CreateTemplateMessageBody *CreateTemplateMessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailTemplateOutput) GoString() string {
	return s.String()
}

// SetCreateTemplateMessageBody sets the CreateTemplateMessageBody field's value.
func (s *CreateEmailTemplateOutput) SetCreateTemplateMessageBody(v *CreateTemplateMessageBody) *CreateEmailTemplateOutput {
	s.CreateTemplateMessageBody = v
	return s
}

type CreateExportJobInput struct {
	_ struct{} `type:"structure" payload:"ExportJobRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the settings for a job that exports endpoint definitions to an
	// Amazon Simple Storage Service (Amazon S3) bucket.
	//
	// ExportJobRequest is a required field
	ExportJobRequest *ExportJobRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ExportJobRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportJobRequest"))
	}
	if s.ExportJobRequest != nil {
		if err := s.ExportJobRequest.Validate(); err != nil {
			invalidParams.AddNested("ExportJobRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateExportJobInput) SetApplicationId(v string) *CreateExportJobInput {
	s.ApplicationId = &v
	return s
}

// SetExportJobRequest sets the ExportJobRequest field's value.
func (s *CreateExportJobInput) SetExportJobRequest(v *ExportJobRequest) *CreateExportJobInput {
	s.ExportJobRequest = v
	return s
}

type CreateExportJobOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobResponse"`

	// Provides information about the status and settings of a job that exports
	// endpoint definitions to a file. The file can be added directly to an Amazon
	// Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API
	// or downloaded directly to a computer by using the Amazon Pinpoint console.
	//
	// ExportJobResponse is a required field
	ExportJobResponse *ExportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExportJobOutput) GoString() string {
	return s.String()
}

// SetExportJobResponse sets the ExportJobResponse field's value.
func (s *CreateExportJobOutput) SetExportJobResponse(v *ExportJobResponse) *CreateExportJobOutput {
	s.ExportJobResponse = v
	return s
}

type CreateImportJobInput struct {
	_ struct{} `type:"structure" payload:"ImportJobRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the settings for a job that imports endpoint definitions from an
	// Amazon Simple Storage Service (Amazon S3) bucket.
	//
	// ImportJobRequest is a required field
	ImportJobRequest *ImportJobRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ImportJobRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportJobRequest"))
	}
	if s.ImportJobRequest != nil {
		if err := s.ImportJobRequest.Validate(); err != nil {
			invalidParams.AddNested("ImportJobRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateImportJobInput) SetApplicationId(v string) *CreateImportJobInput {
	s.ApplicationId = &v
	return s
}

// SetImportJobRequest sets the ImportJobRequest field's value.
func (s *CreateImportJobInput) SetImportJobRequest(v *ImportJobRequest) *CreateImportJobInput {
	s.ImportJobRequest = v
	return s
}

type CreateImportJobOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobResponse"`

	// Provides information about the status and settings of a job that imports
	// endpoint definitions from one or more files. The files can be stored in an
	// Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from
	// a computer by using the Amazon Pinpoint console.
	//
	// ImportJobResponse is a required field
	ImportJobResponse *ImportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobResponse sets the ImportJobResponse field's value.
func (s *CreateImportJobOutput) SetImportJobResponse(v *ImportJobResponse) *CreateImportJobOutput {
	s.ImportJobResponse = v
	return s
}

type CreateJourneyInput struct {
	_ struct{} `type:"structure" payload:"WriteJourneyRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the configuration and other settings for a journey.
	//
	// WriteJourneyRequest is a required field
	WriteJourneyRequest *WriteJourneyRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateJourneyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJourneyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJourneyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJourneyInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.WriteJourneyRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteJourneyRequest"))
	}
	if s.WriteJourneyRequest != nil {
		if err := s.WriteJourneyRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteJourneyRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateJourneyInput) SetApplicationId(v string) *CreateJourneyInput {
	s.ApplicationId = &v
	return s
}

// SetWriteJourneyRequest sets the WriteJourneyRequest field's value.
func (s *CreateJourneyInput) SetWriteJourneyRequest(v *WriteJourneyRequest) *CreateJourneyInput {
	s.WriteJourneyRequest = v
	return s
}

type CreateJourneyOutput struct {
	_ struct{} `type:"structure" payload:"JourneyResponse"`

	// Provides information about the status, configuration, and other settings
	// for a journey.
	//
	// JourneyResponse is a required field
	JourneyResponse *JourneyResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateJourneyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJourneyOutput) GoString() string {
	return s.String()
}

// SetJourneyResponse sets the JourneyResponse field's value.
func (s *CreateJourneyOutput) SetJourneyResponse(v *JourneyResponse) *CreateJourneyOutput {
	s.JourneyResponse = v
	return s
}

type CreatePushTemplateInput struct {
	_ struct{} `type:"structure" payload:"PushNotificationTemplateRequest"`

	// Specifies the content and settings for a message template that can be used
	// in messages that are sent through a push notification channel.
	//
	// PushNotificationTemplateRequest is a required field
	PushNotificationTemplateRequest *PushNotificationTemplateRequest `type:"structure" required:"true"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePushTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePushTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePushTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePushTemplateInput"}
	if s.PushNotificationTemplateRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("PushNotificationTemplateRequest"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPushNotificationTemplateRequest sets the PushNotificationTemplateRequest field's value.
func (s *CreatePushTemplateInput) SetPushNotificationTemplateRequest(v *PushNotificationTemplateRequest) *CreatePushTemplateInput {
	s.PushNotificationTemplateRequest = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreatePushTemplateInput) SetTemplateName(v string) *CreatePushTemplateInput {
	s.TemplateName = &v
	return s
}

type CreatePushTemplateOutput struct {
	_ struct{} `type:"structure" payload:"CreateTemplateMessageBody"`

	// Provides information about a request to create a message template.
	//
	// CreateTemplateMessageBody is a required field
	CreateTemplateMessageBody *CreateTemplateMessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePushTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePushTemplateOutput) GoString() string {
	return s.String()
}

// SetCreateTemplateMessageBody sets the CreateTemplateMessageBody field's value.
func (s *CreatePushTemplateOutput) SetCreateTemplateMessageBody(v *CreateTemplateMessageBody) *CreatePushTemplateOutput {
	s.CreateTemplateMessageBody = v
	return s
}

// Specifies Amazon Pinpoint configuration settings for retrieving and processing
// recommendation data from a recommender model.
type CreateRecommenderConfiguration struct {
	_ struct{} `type:"structure"`

	// A map of key-value pairs that defines 1-10 custom endpoint or user attributes,
	// depending on the value for the RecommendationProviderIdType property. Each
	// of these attributes temporarily stores a recommended item that's retrieved
	// from the recommender model and sent to an AWS Lambda function for additional
	// processing. Each attribute can be used as a message variable in a message
	// template.
	//
	// In the map, the key is the name of a custom attribute and the value is a
	// custom display name for that attribute. The display name appears in the Attribute
	// finder of the template editor on the Amazon Pinpoint console. The following
	// restrictions apply to these names:
	//
	//    * An attribute name must start with a letter or number and it can contain
	//    up to 50 characters. The characters can be letters, numbers, underscores
	//    (_), or hyphens (-). Attribute names are case sensitive and must be unique.
	//
	//    * An attribute display name must start with a letter or number and it
	//    can contain up to 25 characters. The characters can be letters, numbers,
	//    spaces, underscores (_), or hyphens (-).
	//
	// This object is required if the configuration invokes an AWS Lambda function
	// (RecommendationTransformerUri) to process recommendation data. Otherwise,
	// don't include this object in your request.
	Attributes map[string]*string `type:"map"`

	// A custom description of the configuration for the recommender model. The
	// description can contain up to 128 characters. The characters can be letters,
	// numbers, spaces, or the following symbols: _ ; () , ‐.
	Description *string `type:"string"`

	// A custom name of the configuration for the recommender model. The name must
	// start with a letter or number and it can contain up to 128 characters. The
	// characters can be letters, numbers, spaces, underscores (_), or hyphens (-).
	Name *string `type:"string"`

	// The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender
	// model. This value enables the model to use attribute and event data that’s
	// specific to a particular endpoint or user in an Amazon Pinpoint application.
	// Valid values are:
	//
	//    * PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular
	//    endpoint in Amazon Pinpoint. The data is correlated based on endpoint
	//    IDs in Amazon Pinpoint. This is the default value.
	//
	//    * PINPOINT_USER_ID - Associate each user in the model with a particular
	//    user and endpoint in Amazon Pinpoint. The data is correlated based on
	//    user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition
	//    in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint
	//    ID. Otherwise, messages won’t be sent to the user's endpoint.
	RecommendationProviderIdType *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data
	// from the recommender model.
	//
	// RecommendationProviderRoleArn is a required field
	RecommendationProviderRoleArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation
	// data from. This value must match the ARN of an Amazon Personalize campaign.
	//
	// RecommendationProviderUri is a required field
	RecommendationProviderUri *string `type:"string" required:"true"`

	// The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke
	// for additional processing of recommendation data that's retrieved from the
	// recommender model.
	RecommendationTransformerUri *string `type:"string"`

	// A custom display name for the standard endpoint or user attribute (RecommendationItems)
	// that temporarily stores recommended items for each endpoint or user, depending
	// on the value for the RecommendationProviderIdType property. This value is
	// required if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri)
	// to perform additional processing of recommendation data.
	//
	// This name appears in the Attribute finder of the template editor on the Amazon
	// Pinpoint console. The name can contain up to 25 characters. The characters
	// can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions
	// don't apply to attribute values.
	RecommendationsDisplayName *string `type:"string"`

	// The number of recommended items to retrieve from the model for each endpoint
	// or user, depending on the value for the RecommendationProviderIdType property.
	// This number determines how many recommended items are available for use in
	// message variables. The minimum value is 1. The maximum value is 5. The default
	// value is 5.
	//
	// To use multiple recommended items and custom attributes with message variables,
	// you have to use an AWS Lambda function (RecommendationTransformerUri) to
	// perform additional processing of recommendation data.
	RecommendationsPerMessage *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateRecommenderConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRecommenderConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecommenderConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRecommenderConfiguration"}
	if s.RecommendationProviderRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationProviderRoleArn"))
	}
	if s.RecommendationProviderUri == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationProviderUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreateRecommenderConfiguration) SetAttributes(v map[string]*string) *CreateRecommenderConfiguration {
	s.Attributes = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRecommenderConfiguration) SetDescription(v string) *CreateRecommenderConfiguration {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRecommenderConfiguration) SetName(v string) *CreateRecommenderConfiguration {
	s.Name = &v
	return s
}

// SetRecommendationProviderIdType sets the RecommendationProviderIdType field's value.
func (s *CreateRecommenderConfiguration) SetRecommendationProviderIdType(v string) *CreateRecommenderConfiguration {
	s.RecommendationProviderIdType = &v
	return s
}

// SetRecommendationProviderRoleArn sets the RecommendationProviderRoleArn field's value.
func (s *CreateRecommenderConfiguration) SetRecommendationProviderRoleArn(v string) *CreateRecommenderConfiguration {
	s.RecommendationProviderRoleArn = &v
	return s
}

// SetRecommendationProviderUri sets the RecommendationProviderUri field's value.
func (s *CreateRecommenderConfiguration) SetRecommendationProviderUri(v string) *CreateRecommenderConfiguration {
	s.RecommendationProviderUri = &v
	return s
}

// SetRecommendationTransformerUri sets the RecommendationTransformerUri field's value.
func (s *CreateRecommenderConfiguration) SetRecommendationTransformerUri(v string) *CreateRecommenderConfiguration {
	s.RecommendationTransformerUri = &v
	return s
}

// SetRecommendationsDisplayName sets the RecommendationsDisplayName field's value.
func (s *CreateRecommenderConfiguration) SetRecommendationsDisplayName(v string) *CreateRecommenderConfiguration {
	s.RecommendationsDisplayName = &v
	return s
}

// SetRecommendationsPerMessage sets the RecommendationsPerMessage field's value.
func (s *CreateRecommenderConfiguration) SetRecommendationsPerMessage(v int64) *CreateRecommenderConfiguration {
	s.RecommendationsPerMessage = &v
	return s
}

type CreateRecommenderConfigurationInput struct {
	_ struct{} `type:"structure" payload:"CreateRecommenderConfiguration"`

	// Specifies Amazon Pinpoint configuration settings for retrieving and processing
	// recommendation data from a recommender model.
	//
	// CreateRecommenderConfiguration is a required field
	CreateRecommenderConfiguration *CreateRecommenderConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRecommenderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRecommenderConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecommenderConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRecommenderConfigurationInput"}
	if s.CreateRecommenderConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateRecommenderConfiguration"))
	}
	if s.CreateRecommenderConfiguration != nil {
		if err := s.CreateRecommenderConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CreateRecommenderConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateRecommenderConfiguration sets the CreateRecommenderConfiguration field's value.
func (s *CreateRecommenderConfigurationInput) SetCreateRecommenderConfiguration(v *CreateRecommenderConfiguration) *CreateRecommenderConfigurationInput {
	s.CreateRecommenderConfiguration = v
	return s
}

type CreateRecommenderConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"RecommenderConfigurationResponse"`

	// Provides information about Amazon Pinpoint configuration settings for retrieving
	// and processing data from a recommender model.
	//
	// RecommenderConfigurationResponse is a required field
	RecommenderConfigurationResponse *RecommenderConfigurationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRecommenderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRecommenderConfigurationOutput) GoString() string {
	return s.String()
}

// SetRecommenderConfigurationResponse sets the RecommenderConfigurationResponse field's value.
func (s *CreateRecommenderConfigurationOutput) SetRecommenderConfigurationResponse(v *RecommenderConfigurationResponse) *CreateRecommenderConfigurationOutput {
	s.RecommenderConfigurationResponse = v
	return s
}

type CreateSegmentInput struct {
	_ struct{} `type:"structure" payload:"WriteSegmentRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the configuration, dimension, and other settings for a segment.
	// A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups
	// object, but not both.
	//
	// WriteSegmentRequest is a required field
	WriteSegmentRequest *WriteSegmentRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.WriteSegmentRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteSegmentRequest"))
	}
	if s.WriteSegmentRequest != nil {
		if err := s.WriteSegmentRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteSegmentRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateSegmentInput) SetApplicationId(v string) *CreateSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetWriteSegmentRequest sets the WriteSegmentRequest field's value.
func (s *CreateSegmentInput) SetWriteSegmentRequest(v *WriteSegmentRequest) *CreateSegmentInput {
	s.WriteSegmentRequest = v
	return s
}

type CreateSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *CreateSegmentOutput) SetSegmentResponse(v *SegmentResponse) *CreateSegmentOutput {
	s.SegmentResponse = v
	return s
}

type CreateSmsTemplateInput struct {
	_ struct{} `type:"structure" payload:"SMSTemplateRequest"`

	// Specifies the content and settings for a message template that can be used
	// in text messages that are sent through the SMS channel.
	//
	// SMSTemplateRequest is a required field
	SMSTemplateRequest *SMSTemplateRequest `type:"structure" required:"true"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSmsTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSmsTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSmsTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSmsTemplateInput"}
	if s.SMSTemplateRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("SMSTemplateRequest"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSMSTemplateRequest sets the SMSTemplateRequest field's value.
func (s *CreateSmsTemplateInput) SetSMSTemplateRequest(v *SMSTemplateRequest) *CreateSmsTemplateInput {
	s.SMSTemplateRequest = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateSmsTemplateInput) SetTemplateName(v string) *CreateSmsTemplateInput {
	s.TemplateName = &v
	return s
}

type CreateSmsTemplateOutput struct {
	_ struct{} `type:"structure" payload:"CreateTemplateMessageBody"`

	// Provides information about a request to create a message template.
	//
	// CreateTemplateMessageBody is a required field
	CreateTemplateMessageBody *CreateTemplateMessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSmsTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSmsTemplateOutput) GoString() string {
	return s.String()
}

// SetCreateTemplateMessageBody sets the CreateTemplateMessageBody field's value.
func (s *CreateSmsTemplateOutput) SetCreateTemplateMessageBody(v *CreateTemplateMessageBody) *CreateSmsTemplateOutput {
	s.CreateTemplateMessageBody = v
	return s
}

// Provides information about a request to create a message template.
type CreateTemplateMessageBody struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template that was created.
	Arn *string `type:"string"`

	// The message that's returned from the API for the request to create the message
	// template.
	Message *string `type:"string"`

	// The unique identifier for the request to create the message template.
	RequestID *string `type:"string"`
}

// String returns the string representation
func (s CreateTemplateMessageBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTemplateMessageBody) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateTemplateMessageBody) SetArn(v string) *CreateTemplateMessageBody {
	s.Arn = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *CreateTemplateMessageBody) SetMessage(v string) *CreateTemplateMessageBody {
	s.Message = &v
	return s
}

// SetRequestID sets the RequestID field's value.
func (s *CreateTemplateMessageBody) SetRequestID(v string) *CreateTemplateMessageBody {
	s.RequestID = &v
	return s
}

type CreateVoiceTemplateInput struct {
	_ struct{} `type:"structure" payload:"VoiceTemplateRequest"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	// Specifies the content and settings for a message template that can be used
	// in messages that are sent through the voice channel.
	//
	// VoiceTemplateRequest is a required field
	VoiceTemplateRequest *VoiceTemplateRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVoiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVoiceTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVoiceTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVoiceTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.VoiceTemplateRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceTemplateRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateVoiceTemplateInput) SetTemplateName(v string) *CreateVoiceTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVoiceTemplateRequest sets the VoiceTemplateRequest field's value.
func (s *CreateVoiceTemplateInput) SetVoiceTemplateRequest(v *VoiceTemplateRequest) *CreateVoiceTemplateInput {
	s.VoiceTemplateRequest = v
	return s
}

type CreateVoiceTemplateOutput struct {
	_ struct{} `type:"structure" payload:"CreateTemplateMessageBody"`

	// Provides information about a request to create a message template.
	//
	// CreateTemplateMessageBody is a required field
	CreateTemplateMessageBody *CreateTemplateMessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVoiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVoiceTemplateOutput) GoString() string {
	return s.String()
}

// SetCreateTemplateMessageBody sets the CreateTemplateMessageBody field's value.
func (s *CreateVoiceTemplateOutput) SetCreateTemplateMessageBody(v *CreateTemplateMessageBody) *CreateVoiceTemplateOutput {
	s.CreateTemplateMessageBody = v
	return s
}

// Specifies the delivery configuration settings for sending a campaign or campaign
// treatment through a custom channel. This object is required if you use the
// CampaignCustomMessage object to define the message to send for the campaign
// or campaign treatment.
type CustomDeliveryConfiguration struct {
	_ struct{} `type:"structure"`

	// The destination to send the campaign or treatment to. This value can be one
	// of the following:
	//
	//    * The name or Amazon Resource Name (ARN) of an AWS Lambda function to
	//    invoke to handle delivery of the campaign or treatment.
	//
	//    * The URL for a web application or service that supports HTTPS and can
	//    receive the message. The URL has to be a full URL, including the HTTPS
	//    protocol.
	//
	// DeliveryUri is a required field
	DeliveryUri *string `type:"string" required:"true"`

	// The types of endpoints to send the campaign or treatment to. Each valid value
	// maps to a type of channel that you can associate with an endpoint by using
	// the ChannelType property of an endpoint.
	EndpointTypes []*string `type:"list"`
}

// String returns the string representation
func (s CustomDeliveryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomDeliveryConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomDeliveryConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomDeliveryConfiguration"}
	if s.DeliveryUri == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryUri sets the DeliveryUri field's value.
func (s *CustomDeliveryConfiguration) SetDeliveryUri(v string) *CustomDeliveryConfiguration {
	s.DeliveryUri = &v
	return s
}

// SetEndpointTypes sets the EndpointTypes field's value.
func (s *CustomDeliveryConfiguration) SetEndpointTypes(v []*string) *CustomDeliveryConfiguration {
	s.EndpointTypes = v
	return s
}

// The settings for a custom message activity. This type of activity calls an
// AWS Lambda function or web hook that sends messages to participants.
type CustomMessageActivity struct {
	_ struct{} `type:"structure"`

	// The destination to send the custom message to. This value can be one of the
	// following:
	//
	//    * The name or Amazon Resource Name (ARN) of an AWS Lambda function to
	//    invoke to handle delivery of the custom message.
	//
	//    * The URL for a web application or service that supports HTTPS and can
	//    receive the message. The URL has to be a full URL, including the HTTPS
	//    protocol.
	DeliveryUri *string `type:"string"`

	// The types of endpoints to send the custom message to. Each valid value maps
	// to a type of channel that you can associate with an endpoint by using the
	// ChannelType property of an endpoint.
	EndpointTypes []*string `type:"list"`

	// Specifies the message data included in a custom channel message that's sent
	// to participants in a journey.
	MessageConfig *JourneyCustomMessage `type:"structure"`

	// The unique identifier for the next activity to perform, after Amazon Pinpoint
	// calls the AWS Lambda function or web hook.
	NextActivity *string `type:"string"`

	// The name of the custom message template to use for the message. If specified,
	// this value must match the name of an existing message template.
	TemplateName *string `type:"string"`

	// The unique identifier for the version of the message template to use for
	// the message. If specified, this value must match the identifier for an existing
	// template version. To retrieve a list of versions and version identifiers
	// for a template, use the Template Versions resource.
	//
	// If you don't specify a value for this property, Amazon Pinpoint uses the
	// active version of the template. The active version is typically the version
	// of a template that's been most recently reviewed and approved for use, depending
	// on your workflow. It isn't necessarily the latest version of a template.
	TemplateVersion *string `type:"string"`
}

// String returns the string representation
func (s CustomMessageActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomMessageActivity) GoString() string {
	return s.String()
}

// SetDeliveryUri sets the DeliveryUri field's value.
func (s *CustomMessageActivity) SetDeliveryUri(v string) *CustomMessageActivity {
	s.DeliveryUri = &v
	return s
}

// SetEndpointTypes sets the EndpointTypes field's value.
func (s *CustomMessageActivity) SetEndpointTypes(v []*string) *CustomMessageActivity {
	s.EndpointTypes = v
	return s
}

// SetMessageConfig sets the MessageConfig field's value.
func (s *CustomMessageActivity) SetMessageConfig(v *JourneyCustomMessage) *CustomMessageActivity {
	s.MessageConfig = v
	return s
}

// SetNextActivity sets the NextActivity field's value.
func (s *CustomMessageActivity) SetNextActivity(v string) *CustomMessageActivity {
	s.NextActivity = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CustomMessageActivity) SetTemplateName(v string) *CustomMessageActivity {
	s.TemplateName = &v
	return s
}

// SetTemplateVersion sets the TemplateVersion field's value.
func (s *CustomMessageActivity) SetTemplateVersion(v string) *CustomMessageActivity {
	s.TemplateVersion = &v
	return s
}

// Specifies the default message for all channels.
type DefaultMessage struct {
	_ struct{} `type:"structure"`

	// The default body of the message.
	Body *string `type:"string"`

	// The default message variables to use in the message. You can override these
	// default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`
}

// String returns the string representation
func (s DefaultMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *DefaultMessage) SetBody(v string) *DefaultMessage {
	s.Body = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *DefaultMessage) SetSubstitutions(v map[string][]*string) *DefaultMessage {
	s.Substitutions = v
	return s
}

// Specifies the default settings and content for a push notification that's
// sent directly to an endpoint.
type DefaultPushNotificationMessage struct {
	_ struct{} `type:"structure"`

	// The default action to occur if a recipient taps the push notification. Valid
	// values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS and
	//    Android platforms.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The default body of the notification message.
	Body *string `type:"string"`

	// The JSON data payload to use for the default push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]*string `type:"map"`

	// Specifies whether the default notification is a silent push notification,
	// which is a push notification that doesn't display on a recipient's device.
	// Silent push notifications can be used for cases such as updating an app's
	// configuration or delivering messages to an in-app notification center.
	SilentPush *bool `type:"boolean"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The default title to display above the notification message on a recipient's
	// device.
	Title *string `type:"string"`

	// The default URL to open in a recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DefaultPushNotificationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultPushNotificationMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *DefaultPushNotificationMessage) SetAction(v string) *DefaultPushNotificationMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *DefaultPushNotificationMessage) SetBody(v string) *DefaultPushNotificationMessage {
	s.Body = &v
	return s
}

// SetData sets the Data field's value.
func (s *DefaultPushNotificationMessage) SetData(v map[string]*string) *DefaultPushNotificationMessage {
	s.Data = v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *DefaultPushNotificationMessage) SetSilentPush(v bool) *DefaultPushNotificationMessage {
	s.SilentPush = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *DefaultPushNotificationMessage) SetSubstitutions(v map[string][]*string) *DefaultPushNotificationMessage {
	s.Substitutions = v
	return s
}

// SetTitle sets the Title field's value.
func (s *DefaultPushNotificationMessage) SetTitle(v string) *DefaultPushNotificationMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DefaultPushNotificationMessage) SetUrl(v string) *DefaultPushNotificationMessage {
	s.Url = &v
	return s
}

// Specifies the default settings and content for a message template that can
// be used in messages that are sent through a push notification channel.
type DefaultPushNotificationTemplate struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps a push notification that's based
	// on the message template. Valid values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS and
	//    Android platforms.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The message body to use in push notifications that are based on the message
	// template.
	Body *string `type:"string"`

	// The sound to play when a recipient receives a push notification that's based
	// on the message template. You can use the default stream or specify the file
	// name of a sound resource that's bundled in your app. On an Android platform,
	// the sound file must reside in /res/raw/.
	//
	// For an iOS platform, this value is the key for the name of a sound file in
	// your app's main bundle or the Library/Sounds folder in your app's data container.
	// If the sound file can't be found or you specify default for the value, the
	// system plays the default alert sound.
	Sound *string `type:"string"`

	// The title to use in push notifications that are based on the message template.
	// This title appears above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in a recipient's default mobile browser, if a recipient taps
	// a push notification that's based on the message template and the value of
	// the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DefaultPushNotificationTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultPushNotificationTemplate) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *DefaultPushNotificationTemplate) SetAction(v string) *DefaultPushNotificationTemplate {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *DefaultPushNotificationTemplate) SetBody(v string) *DefaultPushNotificationTemplate {
	s.Body = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *DefaultPushNotificationTemplate) SetSound(v string) *DefaultPushNotificationTemplate {
	s.Sound = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *DefaultPushNotificationTemplate) SetTitle(v string) *DefaultPushNotificationTemplate {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DefaultPushNotificationTemplate) SetUrl(v string) *DefaultPushNotificationTemplate {
	s.Url = &v
	return s
}

type DeleteAdmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAdmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAdmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAdmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteAdmChannelInput) SetApplicationId(v string) *DeleteAdmChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Provides information about the status and settings of the ADM (Amazon Device
	// Messaging) channel for an application.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAdmChannelOutput) GoString() string {
	return s.String()
}

// SetADMChannelResponse sets the ADMChannelResponse field's value.
func (s *DeleteAdmChannelOutput) SetADMChannelResponse(v *ADMChannelResponse) *DeleteAdmChannelOutput {
	s.ADMChannelResponse = v
	return s
}

type DeleteApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsChannelInput) SetApplicationId(v string) *DeleteApnsChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) channel for an application.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *DeleteApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *DeleteApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

type DeleteApnsSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsSandboxChannelInput) SetApplicationId(v string) *DeleteApnsSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) sandbox channel for an application.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSSandboxChannelResponse sets the APNSSandboxChannelResponse field's value.
func (s *DeleteApnsSandboxChannelOutput) SetAPNSSandboxChannelResponse(v *APNSSandboxChannelResponse) *DeleteApnsSandboxChannelOutput {
	s.APNSSandboxChannelResponse = v
	return s
}

type DeleteApnsVoipChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsVoipChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsVoipChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsVoipChannelInput) SetApplicationId(v string) *DeleteApnsVoipChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsVoipChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP channel for an application.
	//
	// APNSVoipChannelResponse is a required field
	APNSVoipChannelResponse *APNSVoipChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipChannelResponse sets the APNSVoipChannelResponse field's value.
func (s *DeleteApnsVoipChannelOutput) SetAPNSVoipChannelResponse(v *APNSVoipChannelResponse) *DeleteApnsVoipChannelOutput {
	s.APNSVoipChannelResponse = v
	return s
}

type DeleteApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsVoipSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsVoipSandboxChannelInput) SetApplicationId(v string) *DeleteApnsVoipSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipSandboxChannelResponse sets the APNSVoipSandboxChannelResponse field's value.
func (s *DeleteApnsVoipSandboxChannelOutput) SetAPNSVoipSandboxChannelResponse(v *APNSVoipSandboxChannelResponse) *DeleteApnsVoipSandboxChannelOutput {
	s.APNSVoipSandboxChannelResponse = v
	return s
}

type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteAppInput) SetApplicationId(v string) *DeleteAppInput {
	s.ApplicationId = &v
	return s
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Provides information about an application.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *DeleteAppOutput) SetApplicationResponse(v *ApplicationResponse) *DeleteAppOutput {
	s.ApplicationResponse = v
	return s
}

type DeleteBaiduChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBaiduChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBaiduChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBaiduChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteBaiduChannelInput) SetApplicationId(v string) *DeleteBaiduChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Provides information about the status and settings of the Baidu (Baidu Cloud
	// Push) channel for an application.
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBaiduChannelOutput) GoString() string {
	return s.String()
}

// SetBaiduChannelResponse sets the BaiduChannelResponse field's value.
func (s *DeleteBaiduChannelOutput) SetBaiduChannelResponse(v *BaiduChannelResponse) *DeleteBaiduChannelOutput {
	s.BaiduChannelResponse = v
	return s
}

type DeleteCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteCampaignInput) SetApplicationId(v string) *DeleteCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *DeleteCampaignInput) SetCampaignId(v string) *DeleteCampaignInput {
	s.CampaignId = &v
	return s
}

type DeleteCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *DeleteCampaignOutput) SetCampaignResponse(v *CampaignResponse) *DeleteCampaignOutput {
	s.CampaignResponse = v
	return s
}

type DeleteEmailChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEmailChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEmailChannelInput) SetApplicationId(v string) *DeleteEmailChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Provides information about the status and settings of the email channel for
	// an application.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailChannelOutput) GoString() string {
	return s.String()
}

// SetEmailChannelResponse sets the EmailChannelResponse field's value.
func (s *DeleteEmailChannelOutput) SetEmailChannelResponse(v *EmailChannelResponse) *DeleteEmailChannelOutput {
	s.EmailChannelResponse = v
	return s
}

type DeleteEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s DeleteEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteEmailTemplateInput) SetTemplateName(v string) *DeleteEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteEmailTemplateInput) SetVersion(v string) *DeleteEmailTemplateInput {
	s.Version = &v
	return s
}

type DeleteEmailTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailTemplateOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *DeleteEmailTemplateOutput) SetMessageBody(v *MessageBody) *DeleteEmailTemplateOutput {
	s.MessageBody = v
	return s
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEndpointInput) SetApplicationId(v string) *DeleteEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DeleteEndpointInput) SetEndpointId(v string) *DeleteEndpointInput {
	s.EndpointId = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure" payload:"EndpointResponse"`

	// Provides information about the channel type and other settings for an endpoint.
	//
	// EndpointResponse is a required field
	EndpointResponse *EndpointResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointResponse sets the EndpointResponse field's value.
func (s *DeleteEndpointOutput) SetEndpointResponse(v *EndpointResponse) *DeleteEndpointOutput {
	s.EndpointResponse = v
	return s
}

type DeleteEventStreamInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEventStreamInput) SetApplicationId(v string) *DeleteEventStreamInput {
	s.ApplicationId = &v
	return s
}

type DeleteEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Specifies settings for publishing event data to an Amazon Kinesis data stream
	// or an Amazon Kinesis Data Firehose delivery stream.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *DeleteEventStreamOutput) SetEventStream(v *EventStream) *DeleteEventStreamOutput {
	s.EventStream = v
	return s
}

type DeleteGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteGcmChannelInput) SetApplicationId(v string) *DeleteGcmChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Provides information about the status and settings of the GCM channel for
	// an application. The GCM channel enables Amazon Pinpoint to send push notifications
	// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
	// (GCM), service.
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *DeleteGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *DeleteGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

type DeleteJourneyInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJourneyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJourneyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJourneyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJourneyInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JourneyId == nil {
		invalidParams.Add(request.NewErrParamRequired("JourneyId"))
	}
	if s.JourneyId != nil && len(*s.JourneyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JourneyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteJourneyInput) SetApplicationId(v string) *DeleteJourneyInput {
	s.ApplicationId = &v
	return s
}

// SetJourneyId sets the JourneyId field's value.
func (s *DeleteJourneyInput) SetJourneyId(v string) *DeleteJourneyInput {
	s.JourneyId = &v
	return s
}

type DeleteJourneyOutput struct {
	_ struct{} `type:"structure" payload:"JourneyResponse"`

	// Provides information about the status, configuration, and other settings
	// for a journey.
	//
	// JourneyResponse is a required field
	JourneyResponse *JourneyResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteJourneyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJourneyOutput) GoString() string {
	return s.String()
}

// SetJourneyResponse sets the JourneyResponse field's value.
func (s *DeleteJourneyOutput) SetJourneyResponse(v *JourneyResponse) *DeleteJourneyOutput {
	s.JourneyResponse = v
	return s
}

type DeletePushTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s DeletePushTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePushTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePushTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePushTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeletePushTemplateInput) SetTemplateName(v string) *DeletePushTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeletePushTemplateInput) SetVersion(v string) *DeletePushTemplateInput {
	s.Version = &v
	return s
}

type DeletePushTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeletePushTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePushTemplateOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *DeletePushTemplateOutput) SetMessageBody(v *MessageBody) *DeletePushTemplateOutput {
	s.MessageBody = v
	return s
}

type DeleteRecommenderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// RecommenderId is a required field
	RecommenderId *string `location:"uri" locationName:"recommender-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRecommenderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRecommenderConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecommenderConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecommenderConfigurationInput"}
	if s.RecommenderId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommenderId"))
	}
	if s.RecommenderId != nil && len(*s.RecommenderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommenderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommenderId sets the RecommenderId field's value.
func (s *DeleteRecommenderConfigurationInput) SetRecommenderId(v string) *DeleteRecommenderConfigurationInput {
	s.RecommenderId = &v
	return s
}

type DeleteRecommenderConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"RecommenderConfigurationResponse"`

	// Provides information about Amazon Pinpoint configuration settings for retrieving
	// and processing data from a recommender model.
	//
	// RecommenderConfigurationResponse is a required field
	RecommenderConfigurationResponse *RecommenderConfigurationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteRecommenderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRecommenderConfigurationOutput) GoString() string {
	return s.String()
}

// SetRecommenderConfigurationResponse sets the RecommenderConfigurationResponse field's value.
func (s *DeleteRecommenderConfigurationOutput) SetRecommenderConfigurationResponse(v *RecommenderConfigurationResponse) *DeleteRecommenderConfigurationOutput {
	s.RecommenderConfigurationResponse = v
	return s
}

type DeleteSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteSegmentInput) SetApplicationId(v string) *DeleteSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *DeleteSegmentInput) SetSegmentId(v string) *DeleteSegmentInput {
	s.SegmentId = &v
	return s
}

type DeleteSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *DeleteSegmentOutput) SetSegmentResponse(v *SegmentResponse) *DeleteSegmentOutput {
	s.SegmentResponse = v
	return s
}

type DeleteSmsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSmsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSmsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSmsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSmsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteSmsChannelInput) SetApplicationId(v string) *DeleteSmsChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteSmsChannelOutput struct {
	_ struct{} `type:"structure" payload:"SMSChannelResponse"`

	// Provides information about the status and settings of the SMS channel for
	// an application.
	//
	// SMSChannelResponse is a required field
	SMSChannelResponse *SMSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSmsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSmsChannelOutput) GoString() string {
	return s.String()
}

// SetSMSChannelResponse sets the SMSChannelResponse field's value.
func (s *DeleteSmsChannelOutput) SetSMSChannelResponse(v *SMSChannelResponse) *DeleteSmsChannelOutput {
	s.SMSChannelResponse = v
	return s
}

type DeleteSmsTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s DeleteSmsTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSmsTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSmsTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSmsTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteSmsTemplateInput) SetTemplateName(v string) *DeleteSmsTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteSmsTemplateInput) SetVersion(v string) *DeleteSmsTemplateInput {
	s.Version = &v
	return s
}

type DeleteSmsTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSmsTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSmsTemplateOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *DeleteSmsTemplateOutput) SetMessageBody(v *MessageBody) *DeleteSmsTemplateOutput {
	s.MessageBody = v
	return s
}

type DeleteUserEndpointsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// UserId is a required field
	UserId *string `location:"uri" locationName:"user-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserEndpointsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteUserEndpointsInput) SetApplicationId(v string) *DeleteUserEndpointsInput {
	s.ApplicationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserEndpointsInput) SetUserId(v string) *DeleteUserEndpointsInput {
	s.UserId = &v
	return s
}

type DeleteUserEndpointsOutput struct {
	_ struct{} `type:"structure" payload:"EndpointsResponse"`

	// Provides information about all the endpoints that are associated with a user
	// ID.
	//
	// EndpointsResponse is a required field
	EndpointsResponse *EndpointsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteUserEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpointsResponse sets the EndpointsResponse field's value.
func (s *DeleteUserEndpointsOutput) SetEndpointsResponse(v *EndpointsResponse) *DeleteUserEndpointsOutput {
	s.EndpointsResponse = v
	return s
}

type DeleteVoiceChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteVoiceChannelInput) SetApplicationId(v string) *DeleteVoiceChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteVoiceChannelOutput struct {
	_ struct{} `type:"structure" payload:"VoiceChannelResponse"`

	// Provides information about the status and settings of the voice channel for
	// an application.
	//
	// VoiceChannelResponse is a required field
	VoiceChannelResponse *VoiceChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceChannelOutput) GoString() string {
	return s.String()
}

// SetVoiceChannelResponse sets the VoiceChannelResponse field's value.
func (s *DeleteVoiceChannelOutput) SetVoiceChannelResponse(v *VoiceChannelResponse) *DeleteVoiceChannelOutput {
	s.VoiceChannelResponse = v
	return s
}

type DeleteVoiceTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s DeleteVoiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteVoiceTemplateInput) SetTemplateName(v string) *DeleteVoiceTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteVoiceTemplateInput) SetVersion(v string) *DeleteVoiceTemplateInput {
	s.Version = &v
	return s
}

type DeleteVoiceTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceTemplateOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *DeleteVoiceTemplateOutput) SetMessageBody(v *MessageBody) *DeleteVoiceTemplateOutput {
	s.MessageBody = v
	return s
}

// Specifies the settings and content for the default message and any default
// messages that you tailored for specific channels.
type DirectMessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The default push notification message for the ADM (Amazon Device Messaging)
	// channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
	ADMMessage *ADMMessage `type:"structure"`

	// The default push notification message for the APNs (Apple Push Notification
	// service) channel. This message overrides the default push notification message
	// (DefaultPushNotificationMessage).
	APNSMessage *APNSMessage `type:"structure"`

	// The default push notification message for the Baidu (Baidu Cloud Push) channel.
	// This message overrides the default push notification message (DefaultPushNotificationMessage).
	BaiduMessage *BaiduMessage `type:"structure"`

	// The default message for all channels.
	DefaultMessage *DefaultMessage `type:"structure"`

	// The default push notification message for all push notification channels.
	DefaultPushNotificationMessage *DefaultPushNotificationMessage `type:"structure"`

	// The default message for the email channel. This message overrides the default
	// message (DefaultMessage).
	EmailMessage *EmailMessage `type:"structure"`

	// The default push notification message for the GCM channel, which is used
	// to send notifications through the Firebase Cloud Messaging (FCM), formerly
	// Google Cloud Messaging (GCM), service. This message overrides the default
	// push notification message (DefaultPushNotificationMessage).
	GCMMessage *GCMMessage `type:"structure"`

	// The default message for the SMS channel. This message overrides the default
	// message (DefaultMessage).
	SMSMessage *SMSMessage `type:"structure"`

	// The default message for the voice channel. This message overrides the default
	// message (DefaultMessage).
	VoiceMessage *VoiceMessage `type:"structure"`
}

// String returns the string representation
func (s DirectMessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectMessageConfiguration) GoString() string {
	return s.String()
}

// SetADMMessage sets the ADMMessage field's value.
func (s *DirectMessageConfiguration) SetADMMessage(v *ADMMessage) *DirectMessageConfiguration {
	s.ADMMessage = v
	return s
}

// SetAPNSMessage sets the APNSMessage field's value.
func (s *DirectMessageConfiguration) SetAPNSMessage(v *APNSMessage) *DirectMessageConfiguration {
	s.APNSMessage = v
	return s
}

// SetBaiduMessage sets the BaiduMessage field's value.
func (s *DirectMessageConfiguration) SetBaiduMessage(v *BaiduMessage) *DirectMessageConfiguration {
	s.BaiduMessage = v
	return s
}

// SetDefaultMessage sets the DefaultMessage field's value.
func (s *DirectMessageConfiguration) SetDefaultMessage(v *DefaultMessage) *DirectMessageConfiguration {
	s.DefaultMessage = v
	return s
}

// SetDefaultPushNotificationMessage sets the DefaultPushNotificationMessage field's value.
func (s *DirectMessageConfiguration) SetDefaultPushNotificationMessage(v *DefaultPushNotificationMessage) *DirectMessageConfiguration {
	s.DefaultPushNotificationMessage = v
	return s
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *DirectMessageConfiguration) SetEmailMessage(v *EmailMessage) *DirectMessageConfiguration {
	s.EmailMessage = v
	return s
}

// SetGCMMessage sets the GCMMessage field's value.
func (s *DirectMessageConfiguration) SetGCMMessage(v *GCMMessage) *DirectMessageConfiguration {
	s.GCMMessage = v
	return s
}

// SetSMSMessage sets the SMSMessage field's value.
func (s *DirectMessageConfiguration) SetSMSMessage(v *SMSMessage) *DirectMessageConfiguration {
	s.SMSMessage = v
	return s
}

// SetVoiceMessage sets the VoiceMessage field's value.
func (s *DirectMessageConfiguration) SetVoiceMessage(v *VoiceMessage) *DirectMessageConfiguration {
	s.VoiceMessage = v
	return s
}

// Specifies the status and settings of the email channel for an application.
type EmailChannelRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon SES configuration set (https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html)
	// that you want to apply to messages that you send through the channel.
	ConfigurationSet *string `type:"string"`

	// Specifies whether to enable the email channel for the application.
	Enabled *bool `type:"boolean"`

	// The verified email address that you want to send email from when you send
	// email through the channel.
	//
	// FromAddress is a required field
	FromAddress *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple
	// Email Service (Amazon SES), that you want to use when you send email through
	// the channel.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that you want
	// Amazon Pinpoint to use when it submits email-related event data for the channel.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s EmailChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailChannelRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailChannelRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmailChannelRequest"}
	if s.FromAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("FromAddress"))
	}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *EmailChannelRequest) SetConfigurationSet(v string) *EmailChannelRequest {
	s.ConfigurationSet = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EmailChannelRequest) SetEnabled(v bool) *EmailChannelRequest {
	s.Enabled = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *EmailChannelRequest) SetFromAddress(v string) *EmailChannelRequest {
	s.FromAddress = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *EmailChannelRequest) SetIdentity(v string) *EmailChannelRequest {
	s.Identity = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EmailChannelRequest) SetRoleArn(v string) *EmailChannelRequest {
	s.RoleArn = &v
	return s
}

// Provides information about the status and settings of the email channel for
// an application.
type EmailChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the email channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The Amazon SES configuration set (https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html)
	// that's applied to messages that are sent through the channel.
	ConfigurationSet *string `type:"string"`

	// The date and time, in ISO 8601 format, when the email channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the email channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// The verified email address that email is sent from when you send email through
	// the channel.
	FromAddress *string `type:"string"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the email channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple
	// Email Service (Amazon SES), that's used when you send email through the channel.
	Identity *string `type:"string"`

	// Specifies whether the email channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the email channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the email channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The maximum number of emails that can be sent through the channel each second.
	MessagesPerSecond *int64 `type:"integer"`

	// The type of messaging or notification platform for the channel. For the email
	// channel, this value is EMAIL.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that Amazon
	// Pinpoint uses to submit email-related event data for the channel.
	RoleArn *string `type:"string"`

	// The current version of the email channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s EmailChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EmailChannelResponse) SetApplicationId(v string) *EmailChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *EmailChannelResponse) SetConfigurationSet(v string) *EmailChannelResponse {
	s.ConfigurationSet = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *EmailChannelResponse) SetCreationDate(v string) *EmailChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EmailChannelResponse) SetEnabled(v bool) *EmailChannelResponse {
	s.Enabled = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *EmailChannelResponse) SetFromAddress(v string) *EmailChannelResponse {
	s.FromAddress = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *EmailChannelResponse) SetHasCredential(v bool) *EmailChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *EmailChannelResponse) SetId(v string) *EmailChannelResponse {
	s.Id = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *EmailChannelResponse) SetIdentity(v string) *EmailChannelResponse {
	s.Identity = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *EmailChannelResponse) SetIsArchived(v bool) *EmailChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *EmailChannelResponse) SetLastModifiedBy(v string) *EmailChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EmailChannelResponse) SetLastModifiedDate(v string) *EmailChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetMessagesPerSecond sets the MessagesPerSecond field's value.
func (s *EmailChannelResponse) SetMessagesPerSecond(v int64) *EmailChannelResponse {
	s.MessagesPerSecond = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EmailChannelResponse) SetPlatform(v string) *EmailChannelResponse {
	s.Platform = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EmailChannelResponse) SetRoleArn(v string) *EmailChannelResponse {
	s.RoleArn = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *EmailChannelResponse) SetVersion(v int64) *EmailChannelResponse {
	s.Version = &v
	return s
}

// Specifies the default settings and content for a one-time email message that's
// sent directly to an endpoint.
type EmailMessage struct {
	_ struct{} `type:"structure"`

	// The body of the email message.
	Body *string `type:"string"`

	// The email address to forward bounces and complaints to, if feedback forwarding
	// is enabled.
	FeedbackForwardingAddress *string `type:"string"`

	// The verified email address to send the email message from. The default value
	// is the FromAddress specified for the email channel.
	FromAddress *string `type:"string"`

	// The email message, represented as a raw MIME message.
	RawEmail *RawEmail `type:"structure"`

	// The reply-to email address(es) for the email message. If a recipient replies
	// to the email, each reply-to address receives the reply.
	ReplyToAddresses []*string `type:"list"`

	// The email message, composed of a subject, a text part, and an HTML part.
	SimpleEmail *SimpleEmail `type:"structure"`

	// The default message variables to use in the email message. You can override
	// the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`
}

// String returns the string representation
func (s EmailMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *EmailMessage) SetBody(v string) *EmailMessage {
	s.Body = &v
	return s
}

// SetFeedbackForwardingAddress sets the FeedbackForwardingAddress field's value.
func (s *EmailMessage) SetFeedbackForwardingAddress(v string) *EmailMessage {
	s.FeedbackForwardingAddress = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *EmailMessage) SetFromAddress(v string) *EmailMessage {
	s.FromAddress = &v
	return s
}

// SetRawEmail sets the RawEmail field's value.
func (s *EmailMessage) SetRawEmail(v *RawEmail) *EmailMessage {
	s.RawEmail = v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *EmailMessage) SetReplyToAddresses(v []*string) *EmailMessage {
	s.ReplyToAddresses = v
	return s
}

// SetSimpleEmail sets the SimpleEmail field's value.
func (s *EmailMessage) SetSimpleEmail(v *SimpleEmail) *EmailMessage {
	s.SimpleEmail = v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *EmailMessage) SetSubstitutions(v map[string][]*string) *EmailMessage {
	s.Substitutions = v
	return s
}

// Specifies the settings for an email activity in a journey. This type of activity
// sends an email message to participants.
type EmailMessageActivity struct {
	_ struct{} `type:"structure"`

	// Specifies the sender address for an email message that's sent to participants
	// in the journey.
	MessageConfig *JourneyEmailMessage `type:"structure"`

	// The unique identifier for the next activity to perform, after the message
	// is sent.
	NextActivity *string `type:"string"`

	// The name of the email message template to use for the message. If specified,
	// this value must match the name of an existing message template.
	TemplateName *string `type:"string"`

	// The unique identifier for the version of the email template to use for the
	// message. If specified, this value must match the identifier for an existing
	// template version. To retrieve a list of versions and version identifiers
	// for a template, use the Template Versions resource.
	//
	// If you don't specify a value for this property, Amazon Pinpoint uses the
	// active version of the template. The active version is typically the version
	// of a template that's been most recently reviewed and approved for use, depending
	// on your workflow. It isn't necessarily the latest version of a template.
	TemplateVersion *string `type:"string"`
}

// String returns the string representation
func (s EmailMessageActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailMessageActivity) GoString() string {
	return s.String()
}

// SetMessageConfig sets the MessageConfig field's value.
func (s *EmailMessageActivity) SetMessageConfig(v *JourneyEmailMessage) *EmailMessageActivity {
	s.MessageConfig = v
	return s
}

// SetNextActivity sets the NextActivity field's value.
func (s *EmailMessageActivity) SetNextActivity(v string) *EmailMessageActivity {
	s.NextActivity = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EmailMessageActivity) SetTemplateName(v string) *EmailMessageActivity {
	s.TemplateName = &v
	return s
}

// SetTemplateVersion sets the TemplateVersion field's value.
func (s *EmailMessageActivity) SetTemplateVersion(v string) *EmailMessageActivity {
	s.TemplateVersion = &v
	return s
}

// Specifies the content and settings for a message template that can be used
// in messages that are sent through the email channel.
type EmailTemplateRequest struct {
	_ struct{} `type:"structure"`

	// A JSON object that specifies the default values to use for message variables
	// in the message template. This object is a set of key-value pairs. Each key
	// defines a message variable in the template. The corresponding value defines
	// the default value for that variable. When you create a message that's based
	// on the template, you can override these defaults with message-specific and
	// address-specific variables and values.
	DefaultSubstitutions *string `type:"string"`

	// The message body, in HTML format, to use in email messages that are based
	// on the message template. We recommend using HTML format for email clients
	// that render HTML content. You can include links, formatted text, and more
	// in an HTML message.
	HtmlPart *string `type:"string"`

	// The unique identifier for the recommender model to use for the message template.
	// Amazon Pinpoint uses this value to determine how to retrieve and process
	// data from a recommender model when it sends messages that use the template,
	// if the template contains message variables for recommendation data.
	RecommenderId *string `type:"string"`

	// The subject line, or title, to use in email messages that are based on the
	// message template.
	Subject *string `type:"string"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the message template. Each tag consists of a required tag key and an
	// associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The message body, in plain text format, to use in email messages that are
	// based on the message template. We recommend using plain text format for email
	// clients that don't render HTML content and clients that are connected to
	// high-latency networks, such as mobile devices.
	TextPart *string `type:"string"`
}

// String returns the string representation
func (s EmailTemplateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailTemplateRequest) GoString() string {
	return s.String()
}

// SetDefaultSubstitutions sets the DefaultSubstitutions field's value.
func (s *EmailTemplateRequest) SetDefaultSubstitutions(v string) *EmailTemplateRequest {
	s.DefaultSubstitutions = &v
	return s
}

// SetHtmlPart sets the HtmlPart field's value.
func (s *EmailTemplateRequest) SetHtmlPart(v string) *EmailTemplateRequest {
	s.HtmlPart = &v
	return s
}

// SetRecommenderId sets the RecommenderId field's value.
func (s *EmailTemplateRequest) SetRecommenderId(v string) *EmailTemplateRequest {
	s.RecommenderId = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *EmailTemplateRequest) SetSubject(v string) *EmailTemplateRequest {
	s.Subject = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EmailTemplateRequest) SetTags(v map[string]*string) *EmailTemplateRequest {
	s.Tags = v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *EmailTemplateRequest) SetTemplateDescription(v string) *EmailTemplateRequest {
	s.TemplateDescription = &v
	return s
}

// SetTextPart sets the TextPart field's value.
func (s *EmailTemplateRequest) SetTextPart(v string) *EmailTemplateRequest {
	s.TextPart = &v
	return s
}

// Provides information about the content and settings for a message template
// that can be used in messages that are sent through the email channel.
type EmailTemplateResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template.
	Arn *string `type:"string"`

	// The date, in ISO 8601 format, when the message template was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The JSON object that specifies the default values that are used for message
	// variables in the message template. This object is a set of key-value pairs.
	// Each key defines a message variable in the template. The corresponding value
	// defines the default value for that variable.
	DefaultSubstitutions *string `type:"string"`

	// The message body, in HTML format, that's used in email messages that are
	// based on the message template.
	HtmlPart *string `type:"string"`

	// The date, in ISO 8601 format, when the message template was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// The unique identifier for the recommender model that's used by the message
	// template.
	RecommenderId *string `type:"string"`

	// The subject line, or title, that's used in email messages that are based
	// on the message template.
	Subject *string `type:"string"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the message template. Each tag consists of a required tag
	// key and an associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the message template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The type of channel that the message template is designed for. For an email
	// template, this value is EMAIL.
	//
	// TemplateType is a required field
	TemplateType *string `type:"string" required:"true" enum:"TemplateType"`

	// The message body, in plain text format, that's used in email messages that
	// are based on the message template.
	TextPart *string `type:"string"`

	// The unique identifier, as an integer, for the active version of the message
	// template, or the version of the template that you specified by using the
	// version parameter in your request.
	Version *string `type:"string"`
}

// String returns the string representation
func (s EmailTemplateResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailTemplateResponse) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EmailTemplateResponse) SetArn(v string) *EmailTemplateResponse {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *EmailTemplateResponse) SetCreationDate(v string) *EmailTemplateResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultSubstitutions sets the DefaultSubstitutions field's value.
func (s *EmailTemplateResponse) SetDefaultSubstitutions(v string) *EmailTemplateResponse {
	s.DefaultSubstitutions = &v
	return s
}

// SetHtmlPart sets the HtmlPart field's value.
func (s *EmailTemplateResponse) SetHtmlPart(v string) *EmailTemplateResponse {
	s.HtmlPart = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EmailTemplateResponse) SetLastModifiedDate(v string) *EmailTemplateResponse {
	s.LastModifiedDate = &v
	return s
}

// SetRecommenderId sets the RecommenderId field's value.
func (s *EmailTemplateResponse) SetRecommenderId(v string) *EmailTemplateResponse {
	s.RecommenderId = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *EmailTemplateResponse) SetSubject(v string) *EmailTemplateResponse {
	s.Subject = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EmailTemplateResponse) SetTags(v map[string]*string) *EmailTemplateResponse {
	s.Tags = v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *EmailTemplateResponse) SetTemplateDescription(v string) *EmailTemplateResponse {
	s.TemplateDescription = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EmailTemplateResponse) SetTemplateName(v string) *EmailTemplateResponse {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *EmailTemplateResponse) SetTemplateType(v string) *EmailTemplateResponse {
	s.TemplateType = &v
	return s
}

// SetTextPart sets the TextPart field's value.
func (s *EmailTemplateResponse) SetTextPart(v string) *EmailTemplateResponse {
	s.TextPart = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *EmailTemplateResponse) SetVersion(v string) *EmailTemplateResponse {
	s.Version = &v
	return s
}

// Specifies an endpoint to create or update and the settings and attributes
// to set or change for the endpoint.
type EndpointBatchItem struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For a push-notification channel,
	// use the token provided by the push notification service, such as an Apple
	// Push Notification service (APNs) device token or a Firebase Cloud Messaging
	// (FCM) registration token. For the SMS channel, use a phone number in E.164
	// format, such as +12065550100. For the email channel, use an email address.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["Science", "Music", "Travel"]. You can use these
	// attributes as filter criteria when you create segments. Attribute names are
	// case sensitive.
	//
	// An attribute name can contain up to 50 characters. An attribute value can
	// contain up to 100 characters. When you define the name of a custom attribute,
	// avoid using the following characters: number sign (#), colon (:), question
	// mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't
	// display attribute names that contain these characters. This restriction doesn't
	// apply to attribute values.
	Attributes map[string][]*string `type:"map"`

	// The channel to use when sending messages or push notifications to the endpoint.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was created or updated.
	EffectiveDate *string `type:"string"`

	// Specifies whether to send messages or push notifications to the endpoint.
	// Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE,
	// messages aren’t sent to the endpoint.
	//
	// Amazon Pinpoint automatically sets this value to ACTIVE when you create an
	// endpoint or update an existing endpoint. Amazon Pinpoint automatically sets
	// this value to INACTIVE if you update another endpoint that has the same address
	// specified by the Address property.
	EndpointStatus *string `type:"string"`

	// The unique identifier for the endpoint in the context of the batch.
	Id *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]*float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the request to create or update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom attributes that describe the user who's associated with
	// the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointBatchItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointBatchItem) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointBatchItem) SetAddress(v string) *EndpointBatchItem {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointBatchItem) SetAttributes(v map[string][]*string) *EndpointBatchItem {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointBatchItem) SetChannelType(v string) *EndpointBatchItem {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointBatchItem) SetDemographic(v *EndpointDemographic) *EndpointBatchItem {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointBatchItem) SetEffectiveDate(v string) *EndpointBatchItem {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointBatchItem) SetEndpointStatus(v string) *EndpointBatchItem {
	s.EndpointStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *EndpointBatchItem) SetId(v string) *EndpointBatchItem {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointBatchItem) SetLocation(v *EndpointLocation) *EndpointBatchItem {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointBatchItem) SetMetrics(v map[string]*float64) *EndpointBatchItem {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointBatchItem) SetOptOut(v string) *EndpointBatchItem {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointBatchItem) SetRequestId(v string) *EndpointBatchItem {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointBatchItem) SetUser(v *EndpointUser) *EndpointBatchItem {
	s.User = v
	return s
}

// Specifies a batch of endpoints to create or update and the settings and attributes
// to set or change for each endpoint.
type EndpointBatchRequest struct {
	_ struct{} `type:"structure"`

	// An array that defines the endpoints to create or update and, for each endpoint,
	// the property values to set or change. An array can contain a maximum of 100
	// items.
	//
	// Item is a required field
	Item []*EndpointBatchItem `type:"list" required:"true"`
}

// String returns the string representation
func (s EndpointBatchRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointBatchRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointBatchRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointBatchRequest"}
	if s.Item == nil {
		invalidParams.Add(request.NewErrParamRequired("Item"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItem sets the Item field's value.
func (s *EndpointBatchRequest) SetItem(v []*EndpointBatchItem) *EndpointBatchRequest {
	s.Item = v
	return s
}

// Specifies demographic information about an endpoint, such as the applicable
// time zone and platform.
type EndpointDemographic struct {
	_ struct{} `type:"structure"`

	// The version of the app that's associated with the endpoint.
	AppVersion *string `type:"string"`

	// The locale of the endpoint, in the following format: the ISO 639-1 alpha-2
	// code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.
	Locale *string `type:"string"`

	// The manufacturer of the endpoint device, such as apple or samsung.
	Make *string `type:"string"`

	// The model name or number of the endpoint device, such as iPhone or SM-G900F.
	Model *string `type:"string"`

	// The model version of the endpoint device.
	ModelVersion *string `type:"string"`

	// The platform of the endpoint device, such as ios.
	Platform *string `type:"string"`

	// The platform version of the endpoint device.
	PlatformVersion *string `type:"string"`

	// The time zone of the endpoint, specified as a tz database name value, such
	// as America/Los_Angeles.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s EndpointDemographic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointDemographic) GoString() string {
	return s.String()
}

// SetAppVersion sets the AppVersion field's value.
func (s *EndpointDemographic) SetAppVersion(v string) *EndpointDemographic {
	s.AppVersion = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *EndpointDemographic) SetLocale(v string) *EndpointDemographic {
	s.Locale = &v
	return s
}

// SetMake sets the Make field's value.
func (s *EndpointDemographic) SetMake(v string) *EndpointDemographic {
	s.Make = &v
	return s
}

// SetModel sets the Model field's value.
func (s *EndpointDemographic) SetModel(v string) *EndpointDemographic {
	s.Model = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *EndpointDemographic) SetModelVersion(v string) *EndpointDemographic {
	s.ModelVersion = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EndpointDemographic) SetPlatform(v string) *EndpointDemographic {
	s.Platform = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EndpointDemographic) SetPlatformVersion(v string) *EndpointDemographic {
	s.PlatformVersion = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *EndpointDemographic) SetTimezone(v string) *EndpointDemographic {
	s.Timezone = &v
	return s
}

// Provides the status code and message that result from processing data for
// an endpoint.
type EndpointItemResponse struct {
	_ struct{} `type:"structure"`

	// The custom message that's returned in the response as a result of processing
	// the endpoint data.
	Message *string `type:"string"`

	// The status code that's returned in the response as a result of processing
	// the endpoint data.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s EndpointItemResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointItemResponse) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *EndpointItemResponse) SetMessage(v string) *EndpointItemResponse {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *EndpointItemResponse) SetStatusCode(v int64) *EndpointItemResponse {
	s.StatusCode = &v
	return s
}

// Specifies geographic information about an endpoint.
type EndpointLocation struct {
	_ struct{} `type:"structure"`

	// The name of the city where the endpoint is located.
	City *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the endpoint is located. For example, US for the United States.
	Country *string `type:"string"`

	// The latitude coordinate of the endpoint location, rounded to one decimal
	// place.
	Latitude *float64 `type:"double"`

	// The longitude coordinate of the endpoint location, rounded to one decimal
	// place.
	Longitude *float64 `type:"double"`

	// The postal or ZIP code for the area where the endpoint is located.
	PostalCode *string `type:"string"`

	// The name of the region where the endpoint is located. For locations in the
	// United States, this value is the name of a state.
	Region *string `type:"string"`
}

// String returns the string representation
func (s EndpointLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointLocation) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *EndpointLocation) SetCity(v string) *EndpointLocation {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *EndpointLocation) SetCountry(v string) *EndpointLocation {
	s.Country = &v
	return s
}

// SetLatitude sets the Latitude field's value.
func (s *EndpointLocation) SetLatitude(v float64) *EndpointLocation {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *EndpointLocation) SetLongitude(v float64) *EndpointLocation {
	s.Longitude = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *EndpointLocation) SetPostalCode(v string) *EndpointLocation {
	s.PostalCode = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EndpointLocation) SetRegion(v string) *EndpointLocation {
	s.Region = &v
	return s
}

// Provides information about the delivery status and results of sending a message
// directly to an endpoint.
type EndpointMessageResult struct {
	_ struct{} `type:"structure"`

	// The endpoint address that the message was delivered to.
	Address *string `type:"string"`

	// The delivery status of the message. Possible values are:
	//
	//    * DUPLICATE - The endpoint address is a duplicate of another endpoint
	//    address. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * OPT_OUT - The user who's associated with the endpoint has opted out
	//    of receiving messages from you. Amazon Pinpoint won't attempt to send
	//    the message again.
	//
	//    * PERMANENT_FAILURE - An error occurred when delivering the message to
	//    the endpoint. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * SUCCESSFUL - The message was successfully delivered to the endpoint.
	//
	//    * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't
	//    attempt to send the message again.
	//
	//    * THROTTLED - Amazon Pinpoint throttled the operation to send the message
	//    to the endpoint.
	//
	//    * TIMEOUT - The message couldn't be sent within the timeout period.
	//
	//    * UNKNOWN_FAILURE - An unknown error occurred.
	//
	// DeliveryStatus is a required field
	DeliveryStatus *string `type:"string" required:"true" enum:"DeliveryStatus"`

	// The unique identifier for the message that was sent.
	MessageId *string `type:"string"`

	// The downstream service status code for delivering the message.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The status message for delivering the message.
	StatusMessage *string `type:"string"`

	// For push notifications that are sent through the GCM channel, specifies whether
	// the endpoint's device registration token was updated as part of delivering
	// the message.
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s EndpointMessageResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointMessageResult) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointMessageResult) SetAddress(v string) *EndpointMessageResult {
	s.Address = &v
	return s
}

// SetDeliveryStatus sets the DeliveryStatus field's value.
func (s *EndpointMessageResult) SetDeliveryStatus(v string) *EndpointMessageResult {
	s.DeliveryStatus = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *EndpointMessageResult) SetMessageId(v string) *EndpointMessageResult {
	s.MessageId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *EndpointMessageResult) SetStatusCode(v int64) *EndpointMessageResult {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *EndpointMessageResult) SetStatusMessage(v string) *EndpointMessageResult {
	s.StatusMessage = &v
	return s
}

// SetUpdatedToken sets the UpdatedToken field's value.
func (s *EndpointMessageResult) SetUpdatedToken(v string) *EndpointMessageResult {
	s.UpdatedToken = &v
	return s
}

// Specifies the channel type and other settings for an endpoint.
type EndpointRequest struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For a push-notification channel,
	// use the token provided by the push notification service, such as an Apple
	// Push Notification service (APNs) device token or a Firebase Cloud Messaging
	// (FCM) registration token. For the SMS channel, use a phone number in E.164
	// format, such as +12065550100. For the email channel, use an email address.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["Science", "Music", "Travel"]. You can use these
	// attributes as filter criteria when you create segments. Attribute names are
	// case sensitive.
	//
	// An attribute name can contain up to 50 characters. An attribute value can
	// contain up to 100 characters. When you define the name of a custom attribute,
	// avoid using the following characters: number sign (#), colon (:), question
	// mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't
	// display attribute names that contain these characters. This restriction doesn't
	// apply to attribute values.
	Attributes map[string][]*string `type:"map"`

	// The channel to use when sending messages or push notifications to the endpoint.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint is updated.
	EffectiveDate *string `type:"string"`

	// Specifies whether to send messages or push notifications to the endpoint.
	// Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE,
	// messages aren’t sent to the endpoint.
	//
	// Amazon Pinpoint automatically sets this value to ACTIVE when you create an
	// endpoint or update an existing endpoint. Amazon Pinpoint automatically sets
	// this value to INACTIVE if you update another endpoint that has the same address
	// specified by the Address property.
	EndpointStatus *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]*float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom attributes that describe the user who's associated with
	// the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointRequest) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointRequest) SetAddress(v string) *EndpointRequest {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointRequest) SetAttributes(v map[string][]*string) *EndpointRequest {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointRequest) SetChannelType(v string) *EndpointRequest {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointRequest) SetDemographic(v *EndpointDemographic) *EndpointRequest {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointRequest) SetEffectiveDate(v string) *EndpointRequest {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointRequest) SetEndpointStatus(v string) *EndpointRequest {
	s.EndpointStatus = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointRequest) SetLocation(v *EndpointLocation) *EndpointRequest {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointRequest) SetMetrics(v map[string]*float64) *EndpointRequest {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointRequest) SetOptOut(v string) *EndpointRequest {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointRequest) SetRequestId(v string) *EndpointRequest {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointRequest) SetUser(v *EndpointUser) *EndpointRequest {
	s.User = v
	return s
}

// Provides information about the channel type and other settings for an endpoint.
type EndpointResponse struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For example, the address
	// for a push-notification channel is typically the token provided by a push
	// notification service, such as an Apple Push Notification service (APNs) device
	// token or a Firebase Cloud Messaging (FCM) registration token. The address
	// for the SMS channel is a phone number in E.164 format, such as +12065550100.
	// The address for the email channel is an email address.
	Address *string `type:"string"`

	// The unique identifier for the application that's associated with the endpoint.
	ApplicationId *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["Science", "Music", "Travel"]. You can use these
	// attributes as filter criteria when you create segments.
	Attributes map[string][]*string `type:"map"`

	// The channel that's used when sending messages or push notifications to the
	// endpoint.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// A number from 0-99 that represents the cohort that the endpoint is assigned
	// to. Endpoints are grouped into cohorts randomly, and each cohort contains
	// approximately 1 percent of the endpoints for an application. Amazon Pinpoint
	// assigns cohorts to the holdout or treatment allocations for campaigns.
	CohortId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the endpoint was created.
	CreationDate *string `type:"string"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was last updated.
	EffectiveDate *string `type:"string"`

	// Specifies whether messages or push notifications are sent to the endpoint.
	// Possible values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE,
	// messages aren’t sent to the endpoint.
	//
	// Amazon Pinpoint automatically sets this value to ACTIVE when you create an
	// endpoint or update an existing endpoint. Amazon Pinpoint automatically sets
	// this value to INACTIVE if you update another endpoint that has the same address
	// specified by the Address property.
	EndpointStatus *string `type:"string"`

	// The unique identifier that you assigned to the endpoint. The identifier should
	// be a globally unique identifier (GUID) to ensure that it doesn't conflict
	// with other endpoint identifiers that are associated with the application.
	Id *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]*float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom user attributes that your app reports to Amazon Pinpoint
	// for the user who's associated with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointResponse) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointResponse) SetAddress(v string) *EndpointResponse {
	s.Address = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EndpointResponse) SetApplicationId(v string) *EndpointResponse {
	s.ApplicationId = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointResponse) SetAttributes(v map[string][]*string) *EndpointResponse {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointResponse) SetChannelType(v string) *EndpointResponse {
	s.ChannelType = &v
	return s
}

// SetCohortId sets the CohortId field's value.
func (s *EndpointResponse) SetCohortId(v string) *EndpointResponse {
	s.CohortId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *EndpointResponse) SetCreationDate(v string) *EndpointResponse {
	s.CreationDate = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointResponse) SetDemographic(v *EndpointDemographic) *EndpointResponse {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointResponse) SetEffectiveDate(v string) *EndpointResponse {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointResponse) SetEndpointStatus(v string) *EndpointResponse {
	s.EndpointStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *EndpointResponse) SetId(v string) *EndpointResponse {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointResponse) SetLocation(v *EndpointLocation) *EndpointResponse {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointResponse) SetMetrics(v map[string]*float64) *EndpointResponse {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointResponse) SetOptOut(v string) *EndpointResponse {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointResponse) SetRequestId(v string) *EndpointResponse {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointResponse) SetUser(v *EndpointUser) *EndpointResponse {
	s.User = v
	return s
}

// Specifies the content, including message variables and attributes, to use
// in a message that's sent directly to an endpoint.
type EndpointSendConfiguration struct {
	_ struct{} `type:"structure"`

	// The body of the message. If specified, this value overrides the default message
	// body.
	BodyOverride *string `type:"string"`

	// A map of custom attributes to attach to the message for the address. Attribute
	// names are case sensitive.
	//
	// For a push notification, this payload is added to the data.pinpoint object.
	// For an email or text message, this payload is added to email/SMS delivery
	// receipt event attributes.
	Context map[string]*string `type:"map"`

	// The raw, JSON-formatted string to use as the payload for the message. If
	// specified, this value overrides all other values for the message.
	RawContent *string `type:"string"`

	// A map of the message variables to merge with the variables specified for
	// the default message (DefaultMessage.Substitutions). The variables specified
	// in this map take precedence over all other variables.
	Substitutions map[string][]*string `type:"map"`

	// The title or subject line of the message. If specified, this value overrides
	// the default message title or subject line.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s EndpointSendConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointSendConfiguration) GoString() string {
	return s.String()
}

// SetBodyOverride sets the BodyOverride field's value.
func (s *EndpointSendConfiguration) SetBodyOverride(v string) *EndpointSendConfiguration {
	s.BodyOverride = &v
	return s
}

// SetContext sets the Context field's value.
func (s *EndpointSendConfiguration) SetContext(v map[string]*string) *EndpointSendConfiguration {
	s.Context = v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *EndpointSendConfiguration) SetRawContent(v string) *EndpointSendConfiguration {
	s.RawContent = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *EndpointSendConfiguration) SetSubstitutions(v map[string][]*string) *EndpointSendConfiguration {
	s.Substitutions = v
	return s
}

// SetTitleOverride sets the TitleOverride field's value.
func (s *EndpointSendConfiguration) SetTitleOverride(v string) *EndpointSendConfiguration {
	s.TitleOverride = &v
	return s
}

// Specifies data for one or more attributes that describe the user who's associated
// with an endpoint.
type EndpointUser struct {
	_ struct{} `type:"structure"`

	// One or more custom attributes that describe the user by associating a name
	// with an array of values. For example, the value of an attribute named Interests
	// might be: ["Science", "Music", "Travel"]. You can use these attributes as
	// filter criteria when you create segments. Attribute names are case sensitive.
	//
	// An attribute name can contain up to 50 characters. An attribute value can
	// contain up to 100 characters. When you define the name of a custom attribute,
	// avoid using the following characters: number sign (#), colon (:), question
	// mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't
	// display attribute names that contain these characters. This restriction doesn't
	// apply to attribute values.
	UserAttributes map[string][]*string `type:"map"`

	// The unique identifier for the user.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s EndpointUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointUser) GoString() string {
	return s.String()
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *EndpointUser) SetUserAttributes(v map[string][]*string) *EndpointUser {
	s.UserAttributes = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *EndpointUser) SetUserId(v string) *EndpointUser {
	s.UserId = &v
	return s
}

// Provides information about all the endpoints that are associated with a user
// ID.
type EndpointsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each endpoint that's associated with the user
	// ID.
	//
	// Item is a required field
	Item []*EndpointResponse `type:"list" required:"true"`
}

// String returns the string representation
func (s EndpointsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *EndpointsResponse) SetItem(v []*EndpointResponse) *EndpointsResponse {
	s.Item = v
	return s
}

// Specifies information about an event that reports data to Amazon Pinpoint.
type Event struct {
	_ struct{} `type:"structure"`

	// The package name of the app that's recording the event.
	AppPackageName *string `type:"string"`

	// The title of the app that's recording the event.
	AppTitle *string `type:"string"`

	// The version number of the app that's recording the event.
	AppVersionCode *string `type:"string"`

	// One or more custom attributes that are associated with the event.
	Attributes map[string]*string `type:"map"`

	// The version of the SDK that's running on the client device.
	ClientSdkVersion *string `type:"string"`

	// The name of the event.
	//
	// EventType is a required field
	EventType *string `type:"string" required:"true"`

	// One or more custom metrics that are associated with the event.
	Metrics map[string]*float64 `type:"map"`

	// The name of the SDK that's being used to record the event.
	SdkName *string `type:"string"`

	// Information about the session in which the event occurred.
	Session *Session `type:"structure"`

	// The date and time, in ISO 8601 format, when the event occurred.
	//
	// Timestamp is a required field
	Timestamp *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Event) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Event"}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}
	if s.Session != nil {
		if err := s.Session.Validate(); err != nil {
			invalidParams.AddNested("Session", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppPackageName sets the AppPackageName field's value.
func (s *Event) SetAppPackageName(v string) *Event {
	s.AppPackageName = &v
	return s
}

// SetAppTitle sets the AppTitle field's value.
func (s *Event) SetAppTitle(v string) *Event {
	s.AppTitle = &v
	return s
}

// SetAppVersionCode sets the AppVersionCode field's value.
func (s *Event) SetAppVersionCode(v string) *Event {
	s.AppVersionCode = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Event) SetAttributes(v map[string]*string) *Event {
	s.Attributes = v
	return s
}

// SetClientSdkVersion sets the ClientSdkVersion field's value.
func (s *Event) SetClientSdkVersion(v string) *Event {
	s.ClientSdkVersion = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *Event) SetEventType(v string) *Event {
	s.EventType = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *Event) SetMetrics(v map[string]*float64) *Event {
	s.Metrics = v
	return s
}

// SetSdkName sets the SdkName field's value.
func (s *Event) SetSdkName(v string) *Event {
	s.SdkName = &v
	return s
}

// SetSession sets the Session field's value.
func (s *Event) SetSession(v *Session) *Event {
	s.Session = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Event) SetTimestamp(v string) *Event {
	s.Timestamp = &v
	return s
}

// Specifies the conditions to evaluate for an event that applies to an activity
// in a journey.
type EventCondition struct {
	_ struct{} `type:"structure"`

	// The dimensions for the event filter to use for the activity.
	//
	// Dimensions is a required field
	Dimensions *EventDimensions `type:"structure" required:"true"`

	// The message identifier (message_id) for the message to use when determining
	// whether message events meet the condition.
	MessageActivity *string `type:"string"`
}

// String returns the string representation
func (s EventCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventCondition"}
	if s.Dimensions == nil {
		invalidParams.Add(request.NewErrParamRequired("Dimensions"))
	}
	if s.Dimensions != nil {
		if err := s.Dimensions.Validate(); err != nil {
			invalidParams.AddNested("Dimensions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *EventCondition) SetDimensions(v *EventDimensions) *EventCondition {
	s.Dimensions = v
	return s
}

// SetMessageActivity sets the MessageActivity field's value.
func (s *EventCondition) SetMessageActivity(v string) *EventCondition {
	s.MessageActivity = &v
	return s
}

// Specifies the dimensions for an event filter that determines when a campaign
// is sent or a journey activity is performed.
type EventDimensions struct {
	_ struct{} `type:"structure"`

	// One or more custom attributes that your application reports to Amazon Pinpoint.
	// You can use these attributes as selection criteria when you create an event
	// filter.
	Attributes map[string]*AttributeDimension `type:"map"`

	// The name of the event that causes the campaign to be sent or the journey
	// activity to be performed. This can be a standard event that Amazon Pinpoint
	// generates, such as _email.delivered. For campaigns, this can also be a custom
	// event that's specific to your application. For information about standard
	// events, see Streaming Amazon Pinpoint Events (https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html)
	// in the Amazon Pinpoint Developer Guide.
	EventType *SetDimension `type:"structure"`

	// One or more custom metrics that your application reports to Amazon Pinpoint.
	// You can use these metrics as selection criteria when you create an event
	// filter.
	Metrics map[string]*MetricDimension `type:"map"`
}

// String returns the string representation
func (s EventDimensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDimensions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDimensions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventDimensions"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EventType != nil {
		if err := s.EventType.Validate(); err != nil {
			invalidParams.AddNested("EventType", err.(request.ErrInvalidParams))
		}
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *EventDimensions) SetAttributes(v map[string]*AttributeDimension) *EventDimensions {
	s.Attributes = v
	return s
}

// SetEventType sets the EventType field's value.
func (s *EventDimensions) SetEventType(v *SetDimension) *EventDimensions {
	s.EventType = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EventDimensions) SetMetrics(v map[string]*MetricDimension) *EventDimensions {
	s.Metrics = v
	return s
}

// Provides the status code and message that result from processing an event.
type EventItemResponse struct {
	_ struct{} `type:"structure"`

	// A custom message that's returned in the response as a result of processing
	// the event.
	Message *string `type:"string"`

	// The status code that's returned in the response as a result of processing
	// the event. Possible values are: 202, for events that were accepted; and,
	// 400, for events that weren't valid.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s EventItemResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventItemResponse) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *EventItemResponse) SetMessage(v string) *EventItemResponse {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *EventItemResponse) SetStatusCode(v int64) *EventItemResponse {
	s.StatusCode = &v
	return s
}

// Specifies settings for publishing event data to an Amazon Kinesis data stream
// or an Amazon Kinesis Data Firehose delivery stream.
type EventStream struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application to publish event data for.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon
	// Kinesis Data Firehose delivery stream to publish event data to.
	//
	// For a Kinesis data stream, the ARN format is: arn:aws:kinesis:region:account-id:stream/stream_name
	//
	// For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:region:account-id:deliverystream/stream_name
	//
	// DestinationStreamArn is a required field
	DestinationStreamArn *string `type:"string" required:"true"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when publishing event data, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The date, in ISO 8601 format, when the event stream was last modified.
	LastModifiedDate *string `type:"string"`

	// The IAM user who last modified the event stream.
	LastUpdatedBy *string `type:"string"`

	// The AWS Identity and Access Management (IAM) role that authorizes Amazon
	// Pinpoint to publish event data to the stream in your AWS account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EventStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventStream) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EventStream) SetApplicationId(v string) *EventStream {
	s.ApplicationId = &v
	return s
}

// SetDestinationStreamArn sets the DestinationStreamArn field's value.
func (s *EventStream) SetDestinationStreamArn(v string) *EventStream {
	s.DestinationStreamArn = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *EventStream) SetExternalId(v string) *EventStream {
	s.ExternalId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EventStream) SetLastModifiedDate(v string) *EventStream {
	s.LastModifiedDate = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *EventStream) SetLastUpdatedBy(v string) *EventStream {
	s.LastUpdatedBy = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EventStream) SetRoleArn(v string) *EventStream {
	s.RoleArn = &v
	return s
}

// Specifies a batch of endpoints and events to process.
type EventsBatch struct {
	_ struct{} `type:"structure"`

	// A set of properties and attributes that are associated with the endpoint.
	//
	// Endpoint is a required field
	Endpoint *PublicEndpoint `type:"structure" required:"true"`

	// A set of properties that are associated with the event.
	//
	// Events is a required field
	Events map[string]*Event `type:"map" required:"true"`
}

// String returns the string representation
func (s EventsBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventsBatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventsBatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventsBatch"}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpoint sets the Endpoint field's value.
func (s *EventsBatch) SetEndpoint(v *PublicEndpoint) *EventsBatch {
	s.Endpoint = v
	return s
}

// SetEvents sets the Events field's value.
func (s *EventsBatch) SetEvents(v map[string]*Event) *EventsBatch {
	s.Events = v
	return s
}

// Specifies a batch of events to process.
type EventsRequest struct {
	_ struct{} `type:"structure"`

	// The batch of events to process. For each item in a batch, the endpoint ID
	// acts as a key that has an EventsBatch object as its value.
	//
	// BatchItem is a required field
	BatchItem map[string]*EventsBatch `type:"map" required:"true"`
}

// String returns the string representation
func (s EventsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventsRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventsRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventsRequest"}
	if s.BatchItem == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchItem"))
	}
	if s.BatchItem != nil {
		for i, v := range s.BatchItem {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BatchItem", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchItem sets the BatchItem field's value.
func (s *EventsRequest) SetBatchItem(v map[string]*EventsBatch) *EventsRequest {
	s.BatchItem = v
	return s
}

// Provides information about endpoints and the events that they're associated
// with.
type EventsResponse struct {
	_ struct{} `type:"structure"`

	// A map that contains a multipart response for each endpoint. For each item
	// in this object, the endpoint ID is the key and the item response is the value.
	// If no item response exists, the value can also be one of the following: 202,
	// the request was processed successfully; or 400, the payload wasn't valid
	// or required fields were missing.
	Results map[string]*ItemResponse `type:"map"`
}

// String returns the string representation
func (s EventsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventsResponse) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *EventsResponse) SetResults(v map[string]*ItemResponse) *EventsResponse {
	s.Results = v
	return s
}

// Specifies the settings for a job that exports endpoint definitions to an
// Amazon Simple Storage Service (Amazon S3) bucket.
type ExportJobRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// where you want to export endpoint definitions to.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket
	// where you want to export endpoint definitions to. This location is typically
	// a folder that contains multiple files. The URL should be in the following
	// format: s3://bucket-name/folder-name/.
	//
	// S3UrlPrefix is a required field
	S3UrlPrefix *string `type:"string" required:"true"`

	// The identifier for the segment to export endpoint definitions from. If you
	// don't specify this value, Amazon Pinpoint exports definitions for all the
	// endpoints that are associated with the application.
	SegmentId *string `type:"string"`

	// The version of the segment to export endpoint definitions from, if specified.
	SegmentVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s ExportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportJobRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportJobRequest"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.S3UrlPrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("S3UrlPrefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExportJobRequest) SetRoleArn(v string) *ExportJobRequest {
	s.RoleArn = &v
	return s
}

// SetS3UrlPrefix sets the S3UrlPrefix field's value.
func (s *ExportJobRequest) SetS3UrlPrefix(v string) *ExportJobRequest {
	s.S3UrlPrefix = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ExportJobRequest) SetSegmentId(v string) *ExportJobRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *ExportJobRequest) SetSegmentVersion(v int64) *ExportJobRequest {
	s.SegmentVersion = &v
	return s
}

// Provides information about the resource settings for a job that exports endpoint
// definitions to a file. The file can be added directly to an Amazon Simple
// Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or downloaded
// directly to a computer by using the Amazon Pinpoint console.
type ExportJobResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location
	// where the endpoint definitions were exported to.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket
	// where the endpoint definitions were exported to. This location is typically
	// a folder that contains multiple files. The URL should be in the following
	// format: s3://bucket-name/folder-name/.
	//
	// S3UrlPrefix is a required field
	S3UrlPrefix *string `type:"string" required:"true"`

	// The identifier for the segment that the endpoint definitions were exported
	// from. If this value isn't present, Amazon Pinpoint exported definitions for
	// all the endpoints that are associated with the application.
	SegmentId *string `type:"string"`

	// The version of the segment that the endpoint definitions were exported from.
	SegmentVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s ExportJobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobResource) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExportJobResource) SetRoleArn(v string) *ExportJobResource {
	s.RoleArn = &v
	return s
}

// SetS3UrlPrefix sets the S3UrlPrefix field's value.
func (s *ExportJobResource) SetS3UrlPrefix(v string) *ExportJobResource {
	s.S3UrlPrefix = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ExportJobResource) SetSegmentId(v string) *ExportJobResource {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *ExportJobResource) SetSegmentVersion(v int64) *ExportJobResource {
	s.SegmentVersion = &v
	return s
}

// Provides information about the status and settings of a job that exports
// endpoint definitions to a file. The file can be added directly to an Amazon
// Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API
// or downloaded directly to a computer by using the Amazon Pinpoint console.
type ExportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that's associated with the export
	// job.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The number of pieces that were processed successfully (completed) by the
	// export job, as of the time of the request.
	CompletedPieces *int64 `type:"integer"`

	// The date, in ISO 8601 format, when the export job was completed.
	CompletionDate *string `type:"string"`

	// The date, in ISO 8601 format, when the export job was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The resource settings that apply to the export job.
	//
	// Definition is a required field
	Definition *ExportJobResource `type:"structure" required:"true"`

	// The number of pieces that weren't processed successfully (failed) by the
	// export job, as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	// An array of entries, one for each of the first 100 entries that weren't processed
	// successfully (failed) by the export job, if any.
	Failures []*string `type:"list"`

	// The unique identifier for the export job.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of the export job. The job status is FAILED if Amazon Pinpoint
	// wasn't able to process one or more pieces in the job.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`

	// The total number of endpoint definitions that weren't processed successfully
	// (failed) by the export job, typically because an error, such as a syntax
	// error, occurred.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be processed to complete the export
	// job. Each piece consists of an approximately equal portion of the endpoint
	// definitions that are part of the export job.
	TotalPieces *int64 `type:"integer"`

	// The total number of endpoint definitions that were processed by the export
	// job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. This value is EXPORT for export jobs.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ExportJobResponse) SetApplicationId(v string) *ExportJobResponse {
	s.ApplicationId = &v
	return s
}

// SetCompletedPieces sets the CompletedPieces field's value.
func (s *ExportJobResponse) SetCompletedPieces(v int64) *ExportJobResponse {
	s.CompletedPieces = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *ExportJobResponse) SetCompletionDate(v string) *ExportJobResponse {
	s.CompletionDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ExportJobResponse) SetCreationDate(v string) *ExportJobResponse {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *ExportJobResponse) SetDefinition(v *ExportJobResource) *ExportJobResponse {
	s.Definition = v
	return s
}

// SetFailedPieces sets the FailedPieces field's value.
func (s *ExportJobResponse) SetFailedPieces(v int64) *ExportJobResponse {
	s.FailedPieces = &v
	return s
}

// SetFailures sets the Failures field's value.
func (s *ExportJobResponse) SetFailures(v []*string) *ExportJobResponse {
	s.Failures = v
	return s
}

// SetId sets the Id field's value.
func (s *ExportJobResponse) SetId(v string) *ExportJobResponse {
	s.Id = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ExportJobResponse) SetJobStatus(v string) *ExportJobResponse {
	s.JobStatus = &v
	return s
}

// SetTotalFailures sets the TotalFailures field's value.
func (s *ExportJobResponse) SetTotalFailures(v int64) *ExportJobResponse {
	s.TotalFailures = &v
	return s
}

// SetTotalPieces sets the TotalPieces field's value.
func (s *ExportJobResponse) SetTotalPieces(v int64) *ExportJobResponse {
	s.TotalPieces = &v
	return s
}

// SetTotalProcessed sets the TotalProcessed field's value.
func (s *ExportJobResponse) SetTotalProcessed(v int64) *ExportJobResponse {
	s.TotalProcessed = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExportJobResponse) SetType(v string) *ExportJobResponse {
	s.Type = &v
	return s
}

// Provides information about all the export jobs that are associated with an
// application or segment. An export job is a job that exports endpoint definitions
// to a file.
type ExportJobsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each export job that's associated with the
	// application (Export Jobs resource) or segment (Segment Export Jobs resource).
	//
	// Item is a required field
	Item []*ExportJobResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ExportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ExportJobsResponse) SetItem(v []*ExportJobResponse) *ExportJobsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExportJobsResponse) SetNextToken(v string) *ExportJobsResponse {
	s.NextToken = &v
	return s
}

// Provides information about an API request or response.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RequestID_ *string `locationName:"RequestID" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the status and settings of the GCM channel for an application.
// This channel enables Amazon Pinpoint to send push notifications through the
// Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
type GCMChannelRequest struct {
	_ struct{} `type:"structure"`

	// The Web API Key, also referred to as an API_KEY or server key, that you received
	// from Google to communicate with Google services.
	//
	// ApiKey is a required field
	ApiKey *string `type:"string" required:"true"`

	// Specifies whether to enable the GCM channel for the application.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GCMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMChannelRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GCMChannelRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GCMChannelRequest"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *GCMChannelRequest) SetApiKey(v string) *GCMChannelRequest {
	s.ApiKey = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GCMChannelRequest) SetEnabled(v bool) *GCMChannelRequest {
	s.Enabled = &v
	return s
}

// Provides information about the status and settings of the GCM channel for
// an application. The GCM channel enables Amazon Pinpoint to send push notifications
// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
// (GCM), service.
type GCMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the GCM channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the GCM channel was enabled.
	CreationDate *string `type:"string"`

	// The Web API Key, also referred to as an API_KEY or server key, that you received
	// from Google to communicate with Google services.
	//
	// Credential is a required field
	Credential *string `type:"string" required:"true"`

	// Specifies whether the GCM channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the GCM channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the GCM channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the GCM channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the GCM channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the GCM
	// channel, this value is GCM.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the GCM channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s GCMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GCMChannelResponse) SetApplicationId(v string) *GCMChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GCMChannelResponse) SetCreationDate(v string) *GCMChannelResponse {
	s.CreationDate = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *GCMChannelResponse) SetCredential(v string) *GCMChannelResponse {
	s.Credential = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GCMChannelResponse) SetEnabled(v bool) *GCMChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *GCMChannelResponse) SetHasCredential(v bool) *GCMChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *GCMChannelResponse) SetId(v string) *GCMChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *GCMChannelResponse) SetIsArchived(v bool) *GCMChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *GCMChannelResponse) SetLastModifiedBy(v string) *GCMChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *GCMChannelResponse) SetLastModifiedDate(v string) *GCMChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *GCMChannelResponse) SetPlatform(v string) *GCMChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GCMChannelResponse) SetVersion(v int64) *GCMChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the GCM channel. The GCM channel enables Amazon Pinpoint
// to send messages to the Firebase Cloud Messaging (FCM), formerly Google Cloud
// Messaging (GCM), service.
type GCMMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The body of the notification message.
	Body *string `type:"string"`

	// An arbitrary string that identifies a group of messages that can be collapsed
	// to ensure that only the last message is sent when delivery can resume. This
	// helps avoid sending too many instances of the same messages when the recipient's
	// device comes online again or becomes active.
	//
	// Amazon Pinpoint specifies this value in the Firebase Cloud Messaging (FCM)
	// collapse_key parameter when it sends the notification message to FCM.
	CollapseKey *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]*string `type:"map"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// para>normal - The notification might be delayed. Delivery is optimized for
	// battery usage on the recipient's device. Use this value unless immediate
	// delivery is required.
	// /listitem>
	// high - The notification is sent immediately and might wake a sleeping device.
	// /para>
	// Amazon Pinpoint specifies this value in the FCM priority parameter when it
	// sends the notification message to FCM.
	//
	// The equivalent values for Apple Push Notification service (APNs) are 5, for
	// normal, and 10, for high. If you specify an APNs value for this property,
	// Amazon Pinpoint accepts and converts the value to the corresponding FCM value.
	Priority *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	RawContent *string `type:"string"`

	// The package name of the application where registration tokens must match
	// in order for the recipient to receive the message.
	RestrictedPackageName *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The amount of time, in seconds, that FCM should store and attempt to deliver
	// the push notification, if the service is unable to deliver the notification
	// the first time. If you don't specify this value, FCM defaults to the maximum
	// value, which is 2,419,200 seconds (28 days).
	//
	// Amazon Pinpoint specifies this value in the FCM time_to_live parameter when
	// it sends the notification message to FCM.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s GCMMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GCMMessage) SetAction(v string) *GCMMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *GCMMessage) SetBody(v string) *GCMMessage {
	s.Body = &v
	return s
}

// SetCollapseKey sets the CollapseKey field's value.
func (s *GCMMessage) SetCollapseKey(v string) *GCMMessage {
	s.CollapseKey = &v
	return s
}

// SetData sets the Data field's value.
func (s *GCMMessage) SetData(v map[string]*string) *GCMMessage {
	s.Data = v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *GCMMessage) SetIconReference(v string) *GCMMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *GCMMessage) SetImageIconUrl(v string) *GCMMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *GCMMessage) SetImageUrl(v string) *GCMMessage {
	s.ImageUrl = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GCMMessage) SetPriority(v string) *GCMMessage {
	s.Priority = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *GCMMessage) SetRawContent(v string) *GCMMessage {
	s.RawContent = &v
	return s
}

// SetRestrictedPackageName sets the RestrictedPackageName field's value.
func (s *GCMMessage) SetRestrictedPackageName(v string) *GCMMessage {
	s.RestrictedPackageName = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *GCMMessage) SetSilentPush(v bool) *GCMMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *GCMMessage) SetSmallImageIconUrl(v string) *GCMMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *GCMMessage) SetSound(v string) *GCMMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *GCMMessage) SetSubstitutions(v map[string][]*string) *GCMMessage {
	s.Substitutions = v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *GCMMessage) SetTimeToLive(v int64) *GCMMessage {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *GCMMessage) SetTitle(v string) *GCMMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *GCMMessage) SetUrl(v string) *GCMMessage {
	s.Url = &v
	return s
}

// Specifies the GPS coordinates of a location.
type GPSCoordinates struct {
	_ struct{} `type:"structure"`

	// The latitude coordinate of the location.
	//
	// Latitude is a required field
	Latitude *float64 `type:"double" required:"true"`

	// The longitude coordinate of the location.
	//
	// Longitude is a required field
	Longitude *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s GPSCoordinates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GPSCoordinates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GPSCoordinates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GPSCoordinates"}
	if s.Latitude == nil {
		invalidParams.Add(request.NewErrParamRequired("Latitude"))
	}
	if s.Longitude == nil {
		invalidParams.Add(request.NewErrParamRequired("Longitude"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatitude sets the Latitude field's value.
func (s *GPSCoordinates) SetLatitude(v float64) *GPSCoordinates {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *GPSCoordinates) SetLongitude(v float64) *GPSCoordinates {
	s.Longitude = &v
	return s
}

// Specifies GPS-based criteria for including or excluding endpoints from a
// segment.
type GPSPointDimension struct {
	_ struct{} `type:"structure"`

	// The GPS coordinates to measure distance from.
	//
	// Coordinates is a required field
	Coordinates *GPSCoordinates `type:"structure" required:"true"`

	// The range, in kilometers, from the GPS coordinates.
	RangeInKilometers *float64 `type:"double"`
}

// String returns the string representation
func (s GPSPointDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GPSPointDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GPSPointDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GPSPointDimension"}
	if s.Coordinates == nil {
		invalidParams.Add(request.NewErrParamRequired("Coordinates"))
	}
	if s.Coordinates != nil {
		if err := s.Coordinates.Validate(); err != nil {
			invalidParams.AddNested("Coordinates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoordinates sets the Coordinates field's value.
func (s *GPSPointDimension) SetCoordinates(v *GPSCoordinates) *GPSPointDimension {
	s.Coordinates = v
	return s
}

// SetRangeInKilometers sets the RangeInKilometers field's value.
func (s *GPSPointDimension) SetRangeInKilometers(v float64) *GPSPointDimension {
	s.RangeInKilometers = &v
	return s
}

type GetAdmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAdmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAdmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAdmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetAdmChannelInput) SetApplicationId(v string) *GetAdmChannelInput {
	s.ApplicationId = &v
	return s
}

type GetAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Provides information about the status and settings of the ADM (Amazon Device
	// Messaging) channel for an application.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAdmChannelOutput) GoString() string {
	return s.String()
}

// SetADMChannelResponse sets the ADMChannelResponse field's value.
func (s *GetAdmChannelOutput) SetADMChannelResponse(v *ADMChannelResponse) *GetAdmChannelOutput {
	s.ADMChannelResponse = v
	return s
}

type GetApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsChannelInput) SetApplicationId(v string) *GetApnsChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) channel for an application.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *GetApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *GetApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

type GetApnsSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsSandboxChannelInput) SetApplicationId(v string) *GetApnsSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) sandbox channel for an application.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSSandboxChannelResponse sets the APNSSandboxChannelResponse field's value.
func (s *GetApnsSandboxChannelOutput) SetAPNSSandboxChannelResponse(v *APNSSandboxChannelResponse) *GetApnsSandboxChannelOutput {
	s.APNSSandboxChannelResponse = v
	return s
}

type GetApnsVoipChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsVoipChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsVoipChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsVoipChannelInput) SetApplicationId(v string) *GetApnsVoipChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsVoipChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP channel for an application.
	//
	// APNSVoipChannelResponse is a required field
	APNSVoipChannelResponse *APNSVoipChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipChannelResponse sets the APNSVoipChannelResponse field's value.
func (s *GetApnsVoipChannelOutput) SetAPNSVoipChannelResponse(v *APNSVoipChannelResponse) *GetApnsVoipChannelOutput {
	s.APNSVoipChannelResponse = v
	return s
}

type GetApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsVoipSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsVoipSandboxChannelInput) SetApplicationId(v string) *GetApnsVoipSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipSandboxChannelResponse sets the APNSVoipSandboxChannelResponse field's value.
func (s *GetApnsVoipSandboxChannelOutput) SetAPNSVoipSandboxChannelResponse(v *APNSVoipSandboxChannelResponse) *GetApnsVoipSandboxChannelOutput {
	s.APNSVoipSandboxChannelResponse = v
	return s
}

type GetAppInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetAppInput) SetApplicationId(v string) *GetAppInput {
	s.ApplicationId = &v
	return s
}

type GetAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Provides information about an application.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *GetAppOutput) SetApplicationResponse(v *ApplicationResponse) *GetAppOutput {
	s.ApplicationResponse = v
	return s
}

type GetApplicationDateRangeKpiInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	EndTime *time.Time `location:"querystring" locationName:"end-time" type:"timestamp" timestampFormat:"iso8601"`

	// KpiName is a required field
	KpiName *string `location:"uri" locationName:"kpi-name" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	StartTime *time.Time `location:"querystring" locationName:"start-time" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetApplicationDateRangeKpiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationDateRangeKpiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationDateRangeKpiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationDateRangeKpiInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.KpiName == nil {
		invalidParams.Add(request.NewErrParamRequired("KpiName"))
	}
	if s.KpiName != nil && len(*s.KpiName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KpiName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationDateRangeKpiInput) SetApplicationId(v string) *GetApplicationDateRangeKpiInput {
	s.ApplicationId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetApplicationDateRangeKpiInput) SetEndTime(v time.Time) *GetApplicationDateRangeKpiInput {
	s.EndTime = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *GetApplicationDateRangeKpiInput) SetKpiName(v string) *GetApplicationDateRangeKpiInput {
	s.KpiName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetApplicationDateRangeKpiInput) SetNextToken(v string) *GetApplicationDateRangeKpiInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetApplicationDateRangeKpiInput) SetPageSize(v string) *GetApplicationDateRangeKpiInput {
	s.PageSize = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetApplicationDateRangeKpiInput) SetStartTime(v time.Time) *GetApplicationDateRangeKpiInput {
	s.StartTime = &v
	return s
}

type GetApplicationDateRangeKpiOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationDateRangeKpiResponse"`

	// Provides the results of a query that retrieved the data for a standard metric
	// that applies to an application, and provides information about that query.
	//
	// ApplicationDateRangeKpiResponse is a required field
	ApplicationDateRangeKpiResponse *ApplicationDateRangeKpiResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationDateRangeKpiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationDateRangeKpiOutput) GoString() string {
	return s.String()
}

// SetApplicationDateRangeKpiResponse sets the ApplicationDateRangeKpiResponse field's value.
func (s *GetApplicationDateRangeKpiOutput) SetApplicationDateRangeKpiResponse(v *ApplicationDateRangeKpiResponse) *GetApplicationDateRangeKpiOutput {
	s.ApplicationDateRangeKpiResponse = v
	return s
}

type GetApplicationSettingsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApplicationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationSettingsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationSettingsInput) SetApplicationId(v string) *GetApplicationSettingsInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationSettingsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationSettingsResource"`

	// Provides information about an application, including the default settings
	// for an application.
	//
	// ApplicationSettingsResource is a required field
	ApplicationSettingsResource *ApplicationSettingsResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationSettingsOutput) GoString() string {
	return s.String()
}

// SetApplicationSettingsResource sets the ApplicationSettingsResource field's value.
func (s *GetApplicationSettingsOutput) SetApplicationSettingsResource(v *ApplicationSettingsResource) *GetApplicationSettingsOutput {
	s.ApplicationSettingsResource = v
	return s
}

type GetAppsInput struct {
	_ struct{} `type:"structure"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppsInput) GoString() string {
	return s.String()
}

// SetPageSize sets the PageSize field's value.
func (s *GetAppsInput) SetPageSize(v string) *GetAppsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetAppsInput) SetToken(v string) *GetAppsInput {
	s.Token = &v
	return s
}

type GetAppsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationsResponse"`

	// Provides information about all of your applications.
	//
	// ApplicationsResponse is a required field
	ApplicationsResponse *ApplicationsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppsOutput) GoString() string {
	return s.String()
}

// SetApplicationsResponse sets the ApplicationsResponse field's value.
func (s *GetAppsOutput) SetApplicationsResponse(v *ApplicationsResponse) *GetAppsOutput {
	s.ApplicationsResponse = v
	return s
}

type GetBaiduChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBaiduChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBaiduChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBaiduChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetBaiduChannelInput) SetApplicationId(v string) *GetBaiduChannelInput {
	s.ApplicationId = &v
	return s
}

type GetBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Provides information about the status and settings of the Baidu (Baidu Cloud
	// Push) channel for an application.
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBaiduChannelOutput) GoString() string {
	return s.String()
}

// SetBaiduChannelResponse sets the BaiduChannelResponse field's value.
func (s *GetBaiduChannelOutput) SetBaiduChannelResponse(v *BaiduChannelResponse) *GetBaiduChannelOutput {
	s.BaiduChannelResponse = v
	return s
}

type GetCampaignActivitiesInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignActivitiesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignActivitiesInput) SetApplicationId(v string) *GetCampaignActivitiesInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignActivitiesInput) SetCampaignId(v string) *GetCampaignActivitiesInput {
	s.CampaignId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignActivitiesInput) SetPageSize(v string) *GetCampaignActivitiesInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignActivitiesInput) SetToken(v string) *GetCampaignActivitiesInput {
	s.Token = &v
	return s
}

type GetCampaignActivitiesOutput struct {
	_ struct{} `type:"structure" payload:"ActivitiesResponse"`

	// Provides information about the activities that were performed by a campaign.
	//
	// ActivitiesResponse is a required field
	ActivitiesResponse *ActivitiesResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignActivitiesOutput) GoString() string {
	return s.String()
}

// SetActivitiesResponse sets the ActivitiesResponse field's value.
func (s *GetCampaignActivitiesOutput) SetActivitiesResponse(v *ActivitiesResponse) *GetCampaignActivitiesOutput {
	s.ActivitiesResponse = v
	return s
}

type GetCampaignDateRangeKpiInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	EndTime *time.Time `location:"querystring" locationName:"end-time" type:"timestamp" timestampFormat:"iso8601"`

	// KpiName is a required field
	KpiName *string `location:"uri" locationName:"kpi-name" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	StartTime *time.Time `location:"querystring" locationName:"start-time" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetCampaignDateRangeKpiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignDateRangeKpiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignDateRangeKpiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignDateRangeKpiInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}
	if s.KpiName == nil {
		invalidParams.Add(request.NewErrParamRequired("KpiName"))
	}
	if s.KpiName != nil && len(*s.KpiName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KpiName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignDateRangeKpiInput) SetApplicationId(v string) *GetCampaignDateRangeKpiInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignDateRangeKpiInput) SetCampaignId(v string) *GetCampaignDateRangeKpiInput {
	s.CampaignId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetCampaignDateRangeKpiInput) SetEndTime(v time.Time) *GetCampaignDateRangeKpiInput {
	s.EndTime = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *GetCampaignDateRangeKpiInput) SetKpiName(v string) *GetCampaignDateRangeKpiInput {
	s.KpiName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCampaignDateRangeKpiInput) SetNextToken(v string) *GetCampaignDateRangeKpiInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignDateRangeKpiInput) SetPageSize(v string) *GetCampaignDateRangeKpiInput {
	s.PageSize = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetCampaignDateRangeKpiInput) SetStartTime(v time.Time) *GetCampaignDateRangeKpiInput {
	s.StartTime = &v
	return s
}

type GetCampaignDateRangeKpiOutput struct {
	_ struct{} `type:"structure" payload:"CampaignDateRangeKpiResponse"`

	// Provides the results of a query that retrieved the data for a standard metric
	// that applies to a campaign, and provides information about that query.
	//
	// CampaignDateRangeKpiResponse is a required field
	CampaignDateRangeKpiResponse *CampaignDateRangeKpiResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignDateRangeKpiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignDateRangeKpiOutput) GoString() string {
	return s.String()
}

// SetCampaignDateRangeKpiResponse sets the CampaignDateRangeKpiResponse field's value.
func (s *GetCampaignDateRangeKpiOutput) SetCampaignDateRangeKpiResponse(v *CampaignDateRangeKpiResponse) *GetCampaignDateRangeKpiOutput {
	s.CampaignDateRangeKpiResponse = v
	return s
}

type GetCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignInput) SetApplicationId(v string) *GetCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignInput) SetCampaignId(v string) *GetCampaignInput {
	s.CampaignId = &v
	return s
}

type GetCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *GetCampaignOutput) SetCampaignResponse(v *CampaignResponse) *GetCampaignOutput {
	s.CampaignResponse = v
	return s
}

type GetCampaignVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignVersionInput) SetApplicationId(v string) *GetCampaignVersionInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignVersionInput) SetCampaignId(v string) *GetCampaignVersionInput {
	s.CampaignId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetCampaignVersionInput) SetVersion(v string) *GetCampaignVersionInput {
	s.Version = &v
	return s
}

type GetCampaignVersionOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *GetCampaignVersionOutput) SetCampaignResponse(v *CampaignResponse) *GetCampaignVersionOutput {
	s.CampaignResponse = v
	return s
}

type GetCampaignVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignVersionsInput) SetApplicationId(v string) *GetCampaignVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignVersionsInput) SetCampaignId(v string) *GetCampaignVersionsInput {
	s.CampaignId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignVersionsInput) SetPageSize(v string) *GetCampaignVersionsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignVersionsInput) SetToken(v string) *GetCampaignVersionsInput {
	s.Token = &v
	return s
}

type GetCampaignVersionsOutput struct {
	_ struct{} `type:"structure" payload:"CampaignsResponse"`

	// Provides information about the configuration and other settings for all the
	// campaigns that are associated with an application.
	//
	// CampaignsResponse is a required field
	CampaignsResponse *CampaignsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionsOutput) GoString() string {
	return s.String()
}

// SetCampaignsResponse sets the CampaignsResponse field's value.
func (s *GetCampaignVersionsOutput) SetCampaignsResponse(v *CampaignsResponse) *GetCampaignVersionsOutput {
	s.CampaignsResponse = v
	return s
}

type GetCampaignsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignsInput) SetApplicationId(v string) *GetCampaignsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignsInput) SetPageSize(v string) *GetCampaignsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignsInput) SetToken(v string) *GetCampaignsInput {
	s.Token = &v
	return s
}

type GetCampaignsOutput struct {
	_ struct{} `type:"structure" payload:"CampaignsResponse"`

	// Provides information about the configuration and other settings for all the
	// campaigns that are associated with an application.
	//
	// CampaignsResponse is a required field
	CampaignsResponse *CampaignsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignsOutput) GoString() string {
	return s.String()
}

// SetCampaignsResponse sets the CampaignsResponse field's value.
func (s *GetCampaignsOutput) SetCampaignsResponse(v *CampaignsResponse) *GetCampaignsOutput {
	s.CampaignsResponse = v
	return s
}

type GetChannelsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetChannelsInput) SetApplicationId(v string) *GetChannelsInput {
	s.ApplicationId = &v
	return s
}

type GetChannelsOutput struct {
	_ struct{} `type:"structure" payload:"ChannelsResponse"`

	// Provides information about the general settings and status of all channels
	// for an application, including channels that aren't enabled for the application.
	//
	// ChannelsResponse is a required field
	ChannelsResponse *ChannelsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChannelsOutput) GoString() string {
	return s.String()
}

// SetChannelsResponse sets the ChannelsResponse field's value.
func (s *GetChannelsOutput) SetChannelsResponse(v *ChannelsResponse) *GetChannelsOutput {
	s.ChannelsResponse = v
	return s
}

type GetEmailChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEmailChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEmailChannelInput) SetApplicationId(v string) *GetEmailChannelInput {
	s.ApplicationId = &v
	return s
}

type GetEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Provides information about the status and settings of the email channel for
	// an application.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailChannelOutput) GoString() string {
	return s.String()
}

// SetEmailChannelResponse sets the EmailChannelResponse field's value.
func (s *GetEmailChannelOutput) SetEmailChannelResponse(v *EmailChannelResponse) *GetEmailChannelOutput {
	s.EmailChannelResponse = v
	return s
}

type GetEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s GetEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetEmailTemplateInput) SetTemplateName(v string) *GetEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetEmailTemplateInput) SetVersion(v string) *GetEmailTemplateInput {
	s.Version = &v
	return s
}

type GetEmailTemplateOutput struct {
	_ struct{} `type:"structure" payload:"EmailTemplateResponse"`

	// Provides information about the content and settings for a message template
	// that can be used in messages that are sent through the email channel.
	//
	// EmailTemplateResponse is a required field
	EmailTemplateResponse *EmailTemplateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailTemplateOutput) GoString() string {
	return s.String()
}

// SetEmailTemplateResponse sets the EmailTemplateResponse field's value.
func (s *GetEmailTemplateOutput) SetEmailTemplateResponse(v *EmailTemplateResponse) *GetEmailTemplateOutput {
	s.EmailTemplateResponse = v
	return s
}

type GetEndpointInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEndpointInput) SetApplicationId(v string) *GetEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *GetEndpointInput) SetEndpointId(v string) *GetEndpointInput {
	s.EndpointId = &v
	return s
}

type GetEndpointOutput struct {
	_ struct{} `type:"structure" payload:"EndpointResponse"`

	// Provides information about the channel type and other settings for an endpoint.
	//
	// EndpointResponse is a required field
	EndpointResponse *EndpointResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointResponse sets the EndpointResponse field's value.
func (s *GetEndpointOutput) SetEndpointResponse(v *EndpointResponse) *GetEndpointOutput {
	s.EndpointResponse = v
	return s
}

type GetEventStreamInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEventStreamInput) SetApplicationId(v string) *GetEventStreamInput {
	s.ApplicationId = &v
	return s
}

type GetEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Specifies settings for publishing event data to an Amazon Kinesis data stream
	// or an Amazon Kinesis Data Firehose delivery stream.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *GetEventStreamOutput) SetEventStream(v *EventStream) *GetEventStreamOutput {
	s.EventStream = v
	return s
}

type GetExportJobInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"job-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetExportJobInput) SetApplicationId(v string) *GetExportJobInput {
	s.ApplicationId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetExportJobInput) SetJobId(v string) *GetExportJobInput {
	s.JobId = &v
	return s
}

type GetExportJobOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobResponse"`

	// Provides information about the status and settings of a job that exports
	// endpoint definitions to a file. The file can be added directly to an Amazon
	// Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API
	// or downloaded directly to a computer by using the Amazon Pinpoint console.
	//
	// ExportJobResponse is a required field
	ExportJobResponse *ExportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobOutput) GoString() string {
	return s.String()
}

// SetExportJobResponse sets the ExportJobResponse field's value.
func (s *GetExportJobOutput) SetExportJobResponse(v *ExportJobResponse) *GetExportJobOutput {
	s.ExportJobResponse = v
	return s
}

type GetExportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetExportJobsInput) SetApplicationId(v string) *GetExportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetExportJobsInput) SetPageSize(v string) *GetExportJobsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetExportJobsInput) SetToken(v string) *GetExportJobsInput {
	s.Token = &v
	return s
}

type GetExportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobsResponse"`

	// Provides information about all the export jobs that are associated with an
	// application or segment. An export job is a job that exports endpoint definitions
	// to a file.
	//
	// ExportJobsResponse is a required field
	ExportJobsResponse *ExportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobsOutput) GoString() string {
	return s.String()
}

// SetExportJobsResponse sets the ExportJobsResponse field's value.
func (s *GetExportJobsOutput) SetExportJobsResponse(v *ExportJobsResponse) *GetExportJobsOutput {
	s.ExportJobsResponse = v
	return s
}

type GetGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetGcmChannelInput) SetApplicationId(v string) *GetGcmChannelInput {
	s.ApplicationId = &v
	return s
}

type GetGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Provides information about the status and settings of the GCM channel for
	// an application. The GCM channel enables Amazon Pinpoint to send push notifications
	// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
	// (GCM), service.
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *GetGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *GetGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

type GetImportJobInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"job-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetImportJobInput) SetApplicationId(v string) *GetImportJobInput {
	s.ApplicationId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetImportJobInput) SetJobId(v string) *GetImportJobInput {
	s.JobId = &v
	return s
}

type GetImportJobOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobResponse"`

	// Provides information about the status and settings of a job that imports
	// endpoint definitions from one or more files. The files can be stored in an
	// Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from
	// a computer by using the Amazon Pinpoint console.
	//
	// ImportJobResponse is a required field
	ImportJobResponse *ImportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobResponse sets the ImportJobResponse field's value.
func (s *GetImportJobOutput) SetImportJobResponse(v *ImportJobResponse) *GetImportJobOutput {
	s.ImportJobResponse = v
	return s
}

type GetImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetImportJobsInput) SetApplicationId(v string) *GetImportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetImportJobsInput) SetPageSize(v string) *GetImportJobsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetImportJobsInput) SetToken(v string) *GetImportJobsInput {
	s.Token = &v
	return s
}

type GetImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// Provides information about the status and settings of all the import jobs
	// that are associated with an application or segment. An import job is a job
	// that imports endpoint definitions from one or more files.
	//
	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobsResponse sets the ImportJobsResponse field's value.
func (s *GetImportJobsOutput) SetImportJobsResponse(v *ImportJobsResponse) *GetImportJobsOutput {
	s.ImportJobsResponse = v
	return s
}

type GetJourneyDateRangeKpiInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	EndTime *time.Time `location:"querystring" locationName:"end-time" type:"timestamp" timestampFormat:"iso8601"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`

	// KpiName is a required field
	KpiName *string `location:"uri" locationName:"kpi-name" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	StartTime *time.Time `location:"querystring" locationName:"start-time" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetJourneyDateRangeKpiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJourneyDateRangeKpiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJourneyDateRangeKpiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJourneyDateRangeKpiInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JourneyId == nil {
		invalidParams.Add(request.NewErrParamRequired("JourneyId"))
	}
	if s.JourneyId != nil && len(*s.JourneyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JourneyId", 1))
	}
	if s.KpiName == nil {
		invalidParams.Add(request.NewErrParamRequired("KpiName"))
	}
	if s.KpiName != nil && len(*s.KpiName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KpiName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetJourneyDateRangeKpiInput) SetApplicationId(v string) *GetJourneyDateRangeKpiInput {
	s.ApplicationId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetJourneyDateRangeKpiInput) SetEndTime(v time.Time) *GetJourneyDateRangeKpiInput {
	s.EndTime = &v
	return s
}

// SetJourneyId sets the JourneyId field's value.
func (s *GetJourneyDateRangeKpiInput) SetJourneyId(v string) *GetJourneyDateRangeKpiInput {
	s.JourneyId = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *GetJourneyDateRangeKpiInput) SetKpiName(v string) *GetJourneyDateRangeKpiInput {
	s.KpiName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetJourneyDateRangeKpiInput) SetNextToken(v string) *GetJourneyDateRangeKpiInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetJourneyDateRangeKpiInput) SetPageSize(v string) *GetJourneyDateRangeKpiInput {
	s.PageSize = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetJourneyDateRangeKpiInput) SetStartTime(v time.Time) *GetJourneyDateRangeKpiInput {
	s.StartTime = &v
	return s
}

type GetJourneyDateRangeKpiOutput struct {
	_ struct{} `type:"structure" payload:"JourneyDateRangeKpiResponse"`

	// Provides the results of a query that retrieved the data for a standard engagement
	// metric that applies to a journey, and provides information about that query.
	//
	// JourneyDateRangeKpiResponse is a required field
	JourneyDateRangeKpiResponse *JourneyDateRangeKpiResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetJourneyDateRangeKpiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJourneyDateRangeKpiOutput) GoString() string {
	return s.String()
}

// SetJourneyDateRangeKpiResponse sets the JourneyDateRangeKpiResponse field's value.
func (s *GetJourneyDateRangeKpiOutput) SetJourneyDateRangeKpiResponse(v *JourneyDateRangeKpiResponse) *GetJourneyDateRangeKpiOutput {
	s.JourneyDateRangeKpiResponse = v
	return s
}

type GetJourneyExecutionActivityMetricsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyActivityId is a required field
	JourneyActivityId *string `location:"uri" locationName:"journey-activity-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`
}

// String returns the string representation
func (s GetJourneyExecutionActivityMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJourneyExecutionActivityMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJourneyExecutionActivityMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJourneyExecutionActivityMetricsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JourneyActivityId == nil {
		invalidParams.Add(request.NewErrParamRequired("JourneyActivityId"))
	}
	if s.JourneyActivityId != nil && len(*s.JourneyActivityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JourneyActivityId", 1))
	}
	if s.JourneyId == nil {
		invalidParams.Add(request.NewErrParamRequired("JourneyId"))
	}
	if s.JourneyId != nil && len(*s.JourneyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JourneyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetJourneyExecutionActivityMetricsInput) SetApplicationId(v string) *GetJourneyExecutionActivityMetricsInput {
	s.ApplicationId = &v
	return s
}

// SetJourneyActivityId sets the JourneyActivityId field's value.
func (s *GetJourneyExecutionActivityMetricsInput) SetJourneyActivityId(v string) *GetJourneyExecutionActivityMetricsInput {
	s.JourneyActivityId = &v
	return s
}

// SetJourneyId sets the JourneyId field's value.
func (s *GetJourneyExecutionActivityMetricsInput) SetJourneyId(v string) *GetJourneyExecutionActivityMetricsInput {
	s.JourneyId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetJourneyExecutionActivityMetricsInput) SetNextToken(v string) *GetJourneyExecutionActivityMetricsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetJourneyExecutionActivityMetricsInput) SetPageSize(v string) *GetJourneyExecutionActivityMetricsInput {
	s.PageSize = &v
	return s
}

type GetJourneyExecutionActivityMetricsOutput struct {
	_ struct{} `type:"structure" payload:"JourneyExecutionActivityMetricsResponse"`

	// Provides the results of a query that retrieved the data for a standard execution
	// metric that applies to a journey activity, and provides information about
	// that query.
	//
	// JourneyExecutionActivityMetricsResponse is a required field
	JourneyExecutionActivityMetricsResponse *JourneyExecutionActivityMetricsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetJourneyExecutionActivityMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJourneyExecutionActivityMetricsOutput) GoString() string {
	return s.String()
}

// SetJourneyExecutionActivityMetricsResponse sets the JourneyExecutionActivityMetricsResponse field's value.
func (s *GetJourneyExecutionActivityMetricsOutput) SetJourneyExecutionActivityMetricsResponse(v *JourneyExecutionActivityMetricsResponse) *GetJourneyExecutionActivityMetricsOutput {
	s.JourneyExecutionActivityMetricsResponse = v
	return s
}

type GetJourneyExecutionMetricsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`
}

// String returns the string representation
func (s GetJourneyExecutionMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJourneyExecutionMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJourneyExecutionMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJourneyExecutionMetricsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JourneyId == nil {
		invalidParams.Add(request.NewErrParamRequired("JourneyId"))
	}
	if s.JourneyId != nil && len(*s.JourneyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JourneyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetJourneyExecutionMetricsInput) SetApplicationId(v string) *GetJourneyExecutionMetricsInput {
	s.ApplicationId = &v
	return s
}

// SetJourneyId sets the JourneyId field's value.
func (s *GetJourneyExecutionMetricsInput) SetJourneyId(v string) *GetJourneyExecutionMetricsInput {
	s.JourneyId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetJourneyExecutionMetricsInput) SetNextToken(v string) *GetJourneyExecutionMetricsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetJourneyExecutionMetricsInput) SetPageSize(v string) *GetJourneyExecutionMetricsInput {
	s.PageSize = &v
	return s
}

type GetJourneyExecutionMetricsOutput struct {
	_ struct{} `type:"structure" payload:"JourneyExecutionMetricsResponse"`

	// Provides the results of a query that retrieved the data for a standard execution
	// metric that applies to a journey, and provides information about that query.
	//
	// JourneyExecutionMetricsResponse is a required field
	JourneyExecutionMetricsResponse *JourneyExecutionMetricsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetJourneyExecutionMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJourneyExecutionMetricsOutput) GoString() string {
	return s.String()
}

// SetJourneyExecutionMetricsResponse sets the JourneyExecutionMetricsResponse field's value.
func (s *GetJourneyExecutionMetricsOutput) SetJourneyExecutionMetricsResponse(v *JourneyExecutionMetricsResponse) *GetJourneyExecutionMetricsOutput {
	s.JourneyExecutionMetricsResponse = v
	return s
}

type GetJourneyInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJourneyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJourneyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJourneyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJourneyInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JourneyId == nil {
		invalidParams.Add(request.NewErrParamRequired("JourneyId"))
	}
	if s.JourneyId != nil && len(*s.JourneyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JourneyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetJourneyInput) SetApplicationId(v string) *GetJourneyInput {
	s.ApplicationId = &v
	return s
}

// SetJourneyId sets the JourneyId field's value.
func (s *GetJourneyInput) SetJourneyId(v string) *GetJourneyInput {
	s.JourneyId = &v
	return s
}

type GetJourneyOutput struct {
	_ struct{} `type:"structure" payload:"JourneyResponse"`

	// Provides information about the status, configuration, and other settings
	// for a journey.
	//
	// JourneyResponse is a required field
	JourneyResponse *JourneyResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetJourneyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJourneyOutput) GoString() string {
	return s.String()
}

// SetJourneyResponse sets the JourneyResponse field's value.
func (s *GetJourneyOutput) SetJourneyResponse(v *JourneyResponse) *GetJourneyOutput {
	s.JourneyResponse = v
	return s
}

type GetPushTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s GetPushTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPushTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPushTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPushTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetPushTemplateInput) SetTemplateName(v string) *GetPushTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetPushTemplateInput) SetVersion(v string) *GetPushTemplateInput {
	s.Version = &v
	return s
}

type GetPushTemplateOutput struct {
	_ struct{} `type:"structure" payload:"PushNotificationTemplateResponse"`

	// Provides information about the content and settings for a message template
	// that can be used in messages that are sent through a push notification channel.
	//
	// PushNotificationTemplateResponse is a required field
	PushNotificationTemplateResponse *PushNotificationTemplateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetPushTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPushTemplateOutput) GoString() string {
	return s.String()
}

// SetPushNotificationTemplateResponse sets the PushNotificationTemplateResponse field's value.
func (s *GetPushTemplateOutput) SetPushNotificationTemplateResponse(v *PushNotificationTemplateResponse) *GetPushTemplateOutput {
	s.PushNotificationTemplateResponse = v
	return s
}

type GetRecommenderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// RecommenderId is a required field
	RecommenderId *string `location:"uri" locationName:"recommender-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRecommenderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecommenderConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecommenderConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecommenderConfigurationInput"}
	if s.RecommenderId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommenderId"))
	}
	if s.RecommenderId != nil && len(*s.RecommenderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommenderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommenderId sets the RecommenderId field's value.
func (s *GetRecommenderConfigurationInput) SetRecommenderId(v string) *GetRecommenderConfigurationInput {
	s.RecommenderId = &v
	return s
}

type GetRecommenderConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"RecommenderConfigurationResponse"`

	// Provides information about Amazon Pinpoint configuration settings for retrieving
	// and processing data from a recommender model.
	//
	// RecommenderConfigurationResponse is a required field
	RecommenderConfigurationResponse *RecommenderConfigurationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetRecommenderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecommenderConfigurationOutput) GoString() string {
	return s.String()
}

// SetRecommenderConfigurationResponse sets the RecommenderConfigurationResponse field's value.
func (s *GetRecommenderConfigurationOutput) SetRecommenderConfigurationResponse(v *RecommenderConfigurationResponse) *GetRecommenderConfigurationOutput {
	s.RecommenderConfigurationResponse = v
	return s
}

type GetRecommenderConfigurationsInput struct {
	_ struct{} `type:"structure"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetRecommenderConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecommenderConfigurationsInput) GoString() string {
	return s.String()
}

// SetPageSize sets the PageSize field's value.
func (s *GetRecommenderConfigurationsInput) SetPageSize(v string) *GetRecommenderConfigurationsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetRecommenderConfigurationsInput) SetToken(v string) *GetRecommenderConfigurationsInput {
	s.Token = &v
	return s
}

type GetRecommenderConfigurationsOutput struct {
	_ struct{} `type:"structure" payload:"ListRecommenderConfigurationsResponse"`

	// Provides information about all the recommender model configurations that
	// are associated with your Amazon Pinpoint account.
	//
	// ListRecommenderConfigurationsResponse is a required field
	ListRecommenderConfigurationsResponse *ListRecommenderConfigurationsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetRecommenderConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecommenderConfigurationsOutput) GoString() string {
	return s.String()
}

// SetListRecommenderConfigurationsResponse sets the ListRecommenderConfigurationsResponse field's value.
func (s *GetRecommenderConfigurationsOutput) SetListRecommenderConfigurationsResponse(v *ListRecommenderConfigurationsResponse) *GetRecommenderConfigurationsOutput {
	s.ListRecommenderConfigurationsResponse = v
	return s
}

type GetSegmentExportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentExportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentExportJobsInput) SetApplicationId(v string) *GetSegmentExportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentExportJobsInput) SetPageSize(v string) *GetSegmentExportJobsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentExportJobsInput) SetSegmentId(v string) *GetSegmentExportJobsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentExportJobsInput) SetToken(v string) *GetSegmentExportJobsInput {
	s.Token = &v
	return s
}

type GetSegmentExportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobsResponse"`

	// Provides information about all the export jobs that are associated with an
	// application or segment. An export job is a job that exports endpoint definitions
	// to a file.
	//
	// ExportJobsResponse is a required field
	ExportJobsResponse *ExportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentExportJobsOutput) GoString() string {
	return s.String()
}

// SetExportJobsResponse sets the ExportJobsResponse field's value.
func (s *GetSegmentExportJobsOutput) SetExportJobsResponse(v *ExportJobsResponse) *GetSegmentExportJobsOutput {
	s.ExportJobsResponse = v
	return s
}

type GetSegmentImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentImportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentImportJobsInput) SetApplicationId(v string) *GetSegmentImportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentImportJobsInput) SetPageSize(v string) *GetSegmentImportJobsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentImportJobsInput) SetSegmentId(v string) *GetSegmentImportJobsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentImportJobsInput) SetToken(v string) *GetSegmentImportJobsInput {
	s.Token = &v
	return s
}

type GetSegmentImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// Provides information about the status and settings of all the import jobs
	// that are associated with an application or segment. An import job is a job
	// that imports endpoint definitions from one or more files.
	//
	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobsResponse sets the ImportJobsResponse field's value.
func (s *GetSegmentImportJobsOutput) SetImportJobsResponse(v *ImportJobsResponse) *GetSegmentImportJobsOutput {
	s.ImportJobsResponse = v
	return s
}

type GetSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentInput) SetApplicationId(v string) *GetSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentInput) SetSegmentId(v string) *GetSegmentInput {
	s.SegmentId = &v
	return s
}

type GetSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *GetSegmentOutput) SetSegmentResponse(v *SegmentResponse) *GetSegmentOutput {
	s.SegmentResponse = v
	return s
}

type GetSegmentVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentVersionInput) SetApplicationId(v string) *GetSegmentVersionInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentVersionInput) SetSegmentId(v string) *GetSegmentVersionInput {
	s.SegmentId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSegmentVersionInput) SetVersion(v string) *GetSegmentVersionInput {
	s.Version = &v
	return s
}

type GetSegmentVersionOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *GetSegmentVersionOutput) SetSegmentResponse(v *SegmentResponse) *GetSegmentVersionOutput {
	s.SegmentResponse = v
	return s
}

type GetSegmentVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentVersionsInput) SetApplicationId(v string) *GetSegmentVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentVersionsInput) SetPageSize(v string) *GetSegmentVersionsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentVersionsInput) SetSegmentId(v string) *GetSegmentVersionsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentVersionsInput) SetToken(v string) *GetSegmentVersionsInput {
	s.Token = &v
	return s
}

type GetSegmentVersionsOutput struct {
	_ struct{} `type:"structure" payload:"SegmentsResponse"`

	// Provides information about all the segments that are associated with an application.
	//
	// SegmentsResponse is a required field
	SegmentsResponse *SegmentsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionsOutput) GoString() string {
	return s.String()
}

// SetSegmentsResponse sets the SegmentsResponse field's value.
func (s *GetSegmentVersionsOutput) SetSegmentsResponse(v *SegmentsResponse) *GetSegmentVersionsOutput {
	s.SegmentsResponse = v
	return s
}

type GetSegmentsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentsInput) SetApplicationId(v string) *GetSegmentsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentsInput) SetPageSize(v string) *GetSegmentsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentsInput) SetToken(v string) *GetSegmentsInput {
	s.Token = &v
	return s
}

type GetSegmentsOutput struct {
	_ struct{} `type:"structure" payload:"SegmentsResponse"`

	// Provides information about all the segments that are associated with an application.
	//
	// SegmentsResponse is a required field
	SegmentsResponse *SegmentsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentsOutput) GoString() string {
	return s.String()
}

// SetSegmentsResponse sets the SegmentsResponse field's value.
func (s *GetSegmentsOutput) SetSegmentsResponse(v *SegmentsResponse) *GetSegmentsOutput {
	s.SegmentsResponse = v
	return s
}

type GetSmsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSmsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSmsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSmsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSmsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSmsChannelInput) SetApplicationId(v string) *GetSmsChannelInput {
	s.ApplicationId = &v
	return s
}

type GetSmsChannelOutput struct {
	_ struct{} `type:"structure" payload:"SMSChannelResponse"`

	// Provides information about the status and settings of the SMS channel for
	// an application.
	//
	// SMSChannelResponse is a required field
	SMSChannelResponse *SMSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSmsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSmsChannelOutput) GoString() string {
	return s.String()
}

// SetSMSChannelResponse sets the SMSChannelResponse field's value.
func (s *GetSmsChannelOutput) SetSMSChannelResponse(v *SMSChannelResponse) *GetSmsChannelOutput {
	s.SMSChannelResponse = v
	return s
}

type GetSmsTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s GetSmsTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSmsTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSmsTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSmsTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetSmsTemplateInput) SetTemplateName(v string) *GetSmsTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSmsTemplateInput) SetVersion(v string) *GetSmsTemplateInput {
	s.Version = &v
	return s
}

type GetSmsTemplateOutput struct {
	_ struct{} `type:"structure" payload:"SMSTemplateResponse"`

	// Provides information about the content and settings for a message template
	// that can be used in text messages that are sent through the SMS channel.
	//
	// SMSTemplateResponse is a required field
	SMSTemplateResponse *SMSTemplateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSmsTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSmsTemplateOutput) GoString() string {
	return s.String()
}

// SetSMSTemplateResponse sets the SMSTemplateResponse field's value.
func (s *GetSmsTemplateOutput) SetSMSTemplateResponse(v *SMSTemplateResponse) *GetSmsTemplateOutput {
	s.SMSTemplateResponse = v
	return s
}

type GetUserEndpointsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// UserId is a required field
	UserId *string `location:"uri" locationName:"user-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserEndpointsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetUserEndpointsInput) SetApplicationId(v string) *GetUserEndpointsInput {
	s.ApplicationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetUserEndpointsInput) SetUserId(v string) *GetUserEndpointsInput {
	s.UserId = &v
	return s
}

type GetUserEndpointsOutput struct {
	_ struct{} `type:"structure" payload:"EndpointsResponse"`

	// Provides information about all the endpoints that are associated with a user
	// ID.
	//
	// EndpointsResponse is a required field
	EndpointsResponse *EndpointsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetUserEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpointsResponse sets the EndpointsResponse field's value.
func (s *GetUserEndpointsOutput) SetEndpointsResponse(v *EndpointsResponse) *GetUserEndpointsOutput {
	s.EndpointsResponse = v
	return s
}

type GetVoiceChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetVoiceChannelInput) SetApplicationId(v string) *GetVoiceChannelInput {
	s.ApplicationId = &v
	return s
}

type GetVoiceChannelOutput struct {
	_ struct{} `type:"structure" payload:"VoiceChannelResponse"`

	// Provides information about the status and settings of the voice channel for
	// an application.
	//
	// VoiceChannelResponse is a required field
	VoiceChannelResponse *VoiceChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetVoiceChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceChannelOutput) GoString() string {
	return s.String()
}

// SetVoiceChannelResponse sets the VoiceChannelResponse field's value.
func (s *GetVoiceChannelOutput) SetVoiceChannelResponse(v *VoiceChannelResponse) *GetVoiceChannelOutput {
	s.VoiceChannelResponse = v
	return s
}

type GetVoiceTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s GetVoiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetVoiceTemplateInput) SetTemplateName(v string) *GetVoiceTemplateInput {
	s.TemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetVoiceTemplateInput) SetVersion(v string) *GetVoiceTemplateInput {
	s.Version = &v
	return s
}

type GetVoiceTemplateOutput struct {
	_ struct{} `type:"structure" payload:"VoiceTemplateResponse"`

	// Provides information about the content and settings for a message template
	// that can be used in messages that are sent through the voice channel.
	//
	// VoiceTemplateResponse is a required field
	VoiceTemplateResponse *VoiceTemplateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetVoiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceTemplateOutput) GoString() string {
	return s.String()
}

// SetVoiceTemplateResponse sets the VoiceTemplateResponse field's value.
func (s *GetVoiceTemplateOutput) SetVoiceTemplateResponse(v *VoiceTemplateResponse) *GetVoiceTemplateOutput {
	s.VoiceTemplateResponse = v
	return s
}

// Specifies the settings for a holdout activity in a journey. This type of
// activity stops a journey for a specified percentage of participants.
type HoldoutActivity struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the next activity to perform, after performing
	// the holdout activity.
	NextActivity *string `type:"string"`

	// The percentage of participants who shouldn't continue the journey.
	//
	// To determine which participants are held out, Amazon Pinpoint applies a probability-based
	// algorithm to the percentage that you specify. Therefore, the actual percentage
	// of participants who are held out may not be equal to the percentage that
	// you specify.
	//
	// Percentage is a required field
	Percentage *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s HoldoutActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HoldoutActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HoldoutActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HoldoutActivity"}
	if s.Percentage == nil {
		invalidParams.Add(request.NewErrParamRequired("Percentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextActivity sets the NextActivity field's value.
func (s *HoldoutActivity) SetNextActivity(v string) *HoldoutActivity {
	s.NextActivity = &v
	return s
}

// SetPercentage sets the Percentage field's value.
func (s *HoldoutActivity) SetPercentage(v int64) *HoldoutActivity {
	s.Percentage = &v
	return s
}

// Specifies the settings for a job that imports endpoint definitions from an
// Amazon Simple Storage Service (Amazon S3) bucket.
type ImportJobRequest struct {
	_ struct{} `type:"structure"`

	// Specifies whether to create a segment that contains the endpoints, when the
	// endpoint definitions are imported.
	DefineSegment *bool `type:"boolean"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when importing endpoint definitions, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions to import.
	// Valid values are: CSV, for comma-separated values format; and, JSON, for
	// newline-delimited JSON format. If the Amazon S3 location stores multiple
	// files that use different formats, Amazon Pinpoint imports data only from
	// the files that use the specified format.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"Format"`

	// Specifies whether to register the endpoints with Amazon Pinpoint, when the
	// endpoint definitions are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// to import endpoint definitions from.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains
	// the endpoint definitions to import. This location can be a folder or a single
	// file. If the location is a folder, Amazon Pinpoint imports endpoint definitions
	// from the files in this location, including any subfolders that the folder
	// contains.
	//
	// The URL should be in the following format: s3://bucket-name/folder-name/file-name.
	// The location can end with the key for an individual object or a prefix that
	// qualifies multiple objects.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`

	// The identifier for the segment to update or add the imported endpoint definitions
	// to, if the import job is meant to update an existing segment.
	SegmentId *string `type:"string"`

	// A custom name for the segment that's created by the import job, if the value
	// of the DefineSegment property is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportJobRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportJobRequest"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.S3Url == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefineSegment sets the DefineSegment field's value.
func (s *ImportJobRequest) SetDefineSegment(v bool) *ImportJobRequest {
	s.DefineSegment = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ImportJobRequest) SetExternalId(v string) *ImportJobRequest {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportJobRequest) SetFormat(v string) *ImportJobRequest {
	s.Format = &v
	return s
}

// SetRegisterEndpoints sets the RegisterEndpoints field's value.
func (s *ImportJobRequest) SetRegisterEndpoints(v bool) *ImportJobRequest {
	s.RegisterEndpoints = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportJobRequest) SetRoleArn(v string) *ImportJobRequest {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportJobRequest) SetS3Url(v string) *ImportJobRequest {
	s.S3Url = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ImportJobRequest) SetSegmentId(v string) *ImportJobRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *ImportJobRequest) SetSegmentName(v string) *ImportJobRequest {
	s.SegmentName = &v
	return s
}

// Provides information about the resource settings for a job that imports endpoint
// definitions from one or more files. The files can be stored in an Amazon
// Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer
// by using the Amazon Pinpoint console.
type ImportJobResource struct {
	_ struct{} `type:"structure"`

	// Specifies whether the import job creates a segment that contains the endpoints,
	// when the endpoint definitions are imported.
	DefineSegment *bool `type:"boolean"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when importing endpoint definitions, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions to import.
	// Valid values are: CSV, for comma-separated values format; and, JSON, for
	// newline-delimited JSON format.
	//
	// If the files are stored in an Amazon S3 location and that location contains
	// multiple files that use different formats, Amazon Pinpoint imports data only
	// from the files that use the specified format.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"Format"`

	// Specifies whether the import job registers the endpoints with Amazon Pinpoint,
	// when the endpoint definitions are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// to import endpoint definitions from.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains
	// the endpoint definitions to import. This location can be a folder or a single
	// file. If the location is a folder, Amazon Pinpoint imports endpoint definitions
	// from the files in this location, including any subfolders that the folder
	// contains.
	//
	// The URL should be in the following format: s3://bucket-name/folder-name/file-name.
	// The location can end with the key for an individual object or a prefix that
	// qualifies multiple objects.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`

	// The identifier for the segment that the import job updates or adds endpoint
	// definitions to, if the import job updates an existing segment.
	SegmentId *string `type:"string"`

	// The custom name for the segment that's created by the import job, if the
	// value of the DefineSegment property is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobResource) GoString() string {
	return s.String()
}

// SetDefineSegment sets the DefineSegment field's value.
func (s *ImportJobResource) SetDefineSegment(v bool) *ImportJobResource {
	s.DefineSegment = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ImportJobResource) SetExternalId(v string) *ImportJobResource {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportJobResource) SetFormat(v string) *ImportJobResource {
	s.Format = &v
	return s
}

// SetRegisterEndpoints sets the RegisterEndpoints field's value.
func (s *ImportJobResource) SetRegisterEndpoints(v bool) *ImportJobResource {
	s.RegisterEndpoints = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportJobResource) SetRoleArn(v string) *ImportJobResource {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportJobResource) SetS3Url(v string) *ImportJobResource {
	s.S3Url = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ImportJobResource) SetSegmentId(v string) *ImportJobResource {
	s.SegmentId = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *ImportJobResource) SetSegmentName(v string) *ImportJobResource {
	s.SegmentName = &v
	return s
}

// Provides information about the status and settings of a job that imports
// endpoint definitions from one or more files. The files can be stored in an
// Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from
// a computer by using the Amazon Pinpoint console.
type ImportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that's associated with the import
	// job.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The number of pieces that were processed successfully (completed) by the
	// import job, as of the time of the request.
	CompletedPieces *int64 `type:"integer"`

	// The date, in ISO 8601 format, when the import job was completed.
	CompletionDate *string `type:"string"`

	// The date, in ISO 8601 format, when the import job was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The resource settings that apply to the import job.
	//
	// Definition is a required field
	Definition *ImportJobResource `type:"structure" required:"true"`

	// The number of pieces that weren't processed successfully (failed) by the
	// import job, as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	// An array of entries, one for each of the first 100 entries that weren't processed
	// successfully (failed) by the import job, if any.
	Failures []*string `type:"list"`

	// The unique identifier for the import job.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of the import job. The job status is FAILED if Amazon Pinpoint
	// wasn't able to process one or more pieces in the job.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`

	// The total number of endpoint definitions that weren't processed successfully
	// (failed) by the import job, typically because an error, such as a syntax
	// error, occurred.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be processed to complete the import
	// job. Each piece consists of an approximately equal portion of the endpoint
	// definitions that are part of the import job.
	TotalPieces *int64 `type:"integer"`

	// The total number of endpoint definitions that were processed by the import
	// job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. This value is IMPORT for import jobs.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ImportJobResponse) SetApplicationId(v string) *ImportJobResponse {
	s.ApplicationId = &v
	return s
}

// SetCompletedPieces sets the CompletedPieces field's value.
func (s *ImportJobResponse) SetCompletedPieces(v int64) *ImportJobResponse {
	s.CompletedPieces = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *ImportJobResponse) SetCompletionDate(v string) *ImportJobResponse {
	s.CompletionDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ImportJobResponse) SetCreationDate(v string) *ImportJobResponse {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *ImportJobResponse) SetDefinition(v *ImportJobResource) *ImportJobResponse {
	s.Definition = v
	return s
}

// SetFailedPieces sets the FailedPieces field's value.
func (s *ImportJobResponse) SetFailedPieces(v int64) *ImportJobResponse {
	s.FailedPieces = &v
	return s
}

// SetFailures sets the Failures field's value.
func (s *ImportJobResponse) SetFailures(v []*string) *ImportJobResponse {
	s.Failures = v
	return s
}

// SetId sets the Id field's value.
func (s *ImportJobResponse) SetId(v string) *ImportJobResponse {
	s.Id = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ImportJobResponse) SetJobStatus(v string) *ImportJobResponse {
	s.JobStatus = &v
	return s
}

// SetTotalFailures sets the TotalFailures field's value.
func (s *ImportJobResponse) SetTotalFailures(v int64) *ImportJobResponse {
	s.TotalFailures = &v
	return s
}

// SetTotalPieces sets the TotalPieces field's value.
func (s *ImportJobResponse) SetTotalPieces(v int64) *ImportJobResponse {
	s.TotalPieces = &v
	return s
}

// SetTotalProcessed sets the TotalProcessed field's value.
func (s *ImportJobResponse) SetTotalProcessed(v int64) *ImportJobResponse {
	s.TotalProcessed = &v
	return s
}

// SetType sets the Type field's value.
func (s *ImportJobResponse) SetType(v string) *ImportJobResponse {
	s.Type = &v
	return s
}

// Provides information about the status and settings of all the import jobs
// that are associated with an application or segment. An import job is a job
// that imports endpoint definitions from one or more files.
type ImportJobsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each import job that's associated with the
	// application (Import Jobs resource) or segment (Segment Import Jobs resource).
	//
	// Item is a required field
	Item []*ImportJobResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ImportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ImportJobsResponse) SetItem(v []*ImportJobResponse) *ImportJobsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ImportJobsResponse) SetNextToken(v string) *ImportJobsResponse {
	s.NextToken = &v
	return s
}

// Provides information about an API request or response.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RequestID_ *string `locationName:"RequestID" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about the results of a request to create or update an
// endpoint that's associated with an event.
type ItemResponse struct {
	_ struct{} `type:"structure"`

	// The response that was received after the endpoint data was accepted.
	EndpointItemResponse *EndpointItemResponse `type:"structure"`

	// A multipart response object that contains a key and a value for each event
	// in the request. In each object, the event ID is the key and an EventItemResponse
	// object is the value.
	EventsItemResponse map[string]*EventItemResponse `type:"map"`
}

// String returns the string representation
func (s ItemResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemResponse) GoString() string {
	return s.String()
}

// SetEndpointItemResponse sets the EndpointItemResponse field's value.
func (s *ItemResponse) SetEndpointItemResponse(v *EndpointItemResponse) *ItemResponse {
	s.EndpointItemResponse = v
	return s
}

// SetEventsItemResponse sets the EventsItemResponse field's value.
func (s *ItemResponse) SetEventsItemResponse(v map[string]*EventItemResponse) *ItemResponse {
	s.EventsItemResponse = v
	return s
}

// Specifies the message content for a custom channel message that's sent to
// participants in a journey.
type JourneyCustomMessage struct {
	_ struct{} `type:"structure"`

	// The message content that's passed to an AWS Lambda function or to a web hook.
	Data *string `type:"string"`
}

// String returns the string representation
func (s JourneyCustomMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyCustomMessage) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *JourneyCustomMessage) SetData(v string) *JourneyCustomMessage {
	s.Data = &v
	return s
}

// Provides the results of a query that retrieved the data for a standard engagement
// metric that applies to a journey, and provides information about that query.
type JourneyDateRangeKpiResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique identifier for the journey that the metric applies to.
	//
	// JourneyId is a required field
	JourneyId *string `type:"string" required:"true"`

	// The name of the metric, also referred to as a key performance indicator (KPI),
	// that the data was retrieved for. This value describes the associated metric
	// and consists of two or more terms, which are comprised of lowercase alphanumeric
	// characters, separated by a hyphen. For a list of possible values, see the
	// Amazon Pinpoint Developer Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
	//
	// KpiName is a required field
	KpiName *string `type:"string" required:"true"`

	// An array of objects that contains the results of the query. Each object contains
	// the value for the metric and metadata about that value.
	//
	// KpiResult is a required field
	KpiResult *BaseKpiResult `type:"structure" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null for the Journey Engagement Metrics
	// resource because the resource returns all results in a single page.
	NextToken *string `type:"string"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s JourneyDateRangeKpiResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyDateRangeKpiResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *JourneyDateRangeKpiResponse) SetApplicationId(v string) *JourneyDateRangeKpiResponse {
	s.ApplicationId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *JourneyDateRangeKpiResponse) SetEndTime(v time.Time) *JourneyDateRangeKpiResponse {
	s.EndTime = &v
	return s
}

// SetJourneyId sets the JourneyId field's value.
func (s *JourneyDateRangeKpiResponse) SetJourneyId(v string) *JourneyDateRangeKpiResponse {
	s.JourneyId = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *JourneyDateRangeKpiResponse) SetKpiName(v string) *JourneyDateRangeKpiResponse {
	s.KpiName = &v
	return s
}

// SetKpiResult sets the KpiResult field's value.
func (s *JourneyDateRangeKpiResponse) SetKpiResult(v *BaseKpiResult) *JourneyDateRangeKpiResponse {
	s.KpiResult = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *JourneyDateRangeKpiResponse) SetNextToken(v string) *JourneyDateRangeKpiResponse {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *JourneyDateRangeKpiResponse) SetStartTime(v time.Time) *JourneyDateRangeKpiResponse {
	s.StartTime = &v
	return s
}

// Specifies the "From" address for an email message that's sent to participants
// in a journey.
type JourneyEmailMessage struct {
	_ struct{} `type:"structure"`

	// The verified email address to send the email message from. The default address
	// is the FromAddress specified for the email channel for the application.
	FromAddress *string `type:"string"`
}

// String returns the string representation
func (s JourneyEmailMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyEmailMessage) GoString() string {
	return s.String()
}

// SetFromAddress sets the FromAddress field's value.
func (s *JourneyEmailMessage) SetFromAddress(v string) *JourneyEmailMessage {
	s.FromAddress = &v
	return s
}

// Provides the results of a query that retrieved the data for a standard execution
// metric that applies to a journey activity, and provides information about
// that query.
type JourneyExecutionActivityMetricsResponse struct {
	_ struct{} `type:"structure"`

	// The type of activity that the metric applies to. Possible values are:
	//
	//    * CONDITIONAL_SPLIT - For a yes/no split activity, which is an activity
	//    that sends participants down one of two paths in a journey.
	//
	//    * HOLDOUT - For a holdout activity, which is an activity that stops a
	//    journey for a specified percentage of participants.
	//
	//    * MESSAGE - For an email activity, which is an activity that sends an
	//    email message to participants.
	//
	//    * MULTI_CONDITIONAL_SPLIT - For a multivariate split activity, which is
	//    an activity that sends participants down one of as many as five paths
	//    in a journey.
	//
	//    * RANDOM_SPLIT - For a random split activity, which is an activity that
	//    sends specified percentages of participants down one of as many as five
	//    paths in a journey.
	//
	//    * WAIT - For a wait activity, which is an activity that waits for a certain
	//    amount of time or until a specific date and time before moving participants
	//    to the next activity in a journey.
	//
	// ActivityType is a required field
	ActivityType *string `type:"string" required:"true"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the activity that the metric applies to.
	//
	// JourneyActivityId is a required field
	JourneyActivityId *string `type:"string" required:"true"`

	// The unique identifier for the journey that the metric applies to.
	//
	// JourneyId is a required field
	JourneyId *string `type:"string" required:"true"`

	// The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated
	// the execution status of the activity and updated the data for the metric.
	//
	// LastEvaluatedTime is a required field
	LastEvaluatedTime *string `type:"string" required:"true"`

	// A JSON object that contains the results of the query. The results vary depending
	// on the type of activity (ActivityType). For information about the structure
	// and contents of the results, see the Amazon Pinpoint Developer Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
	//
	// Metrics is a required field
	Metrics map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s JourneyExecutionActivityMetricsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyExecutionActivityMetricsResponse) GoString() string {
	return s.String()
}

// SetActivityType sets the ActivityType field's value.
func (s *JourneyExecutionActivityMetricsResponse) SetActivityType(v string) *JourneyExecutionActivityMetricsResponse {
	s.ActivityType = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *JourneyExecutionActivityMetricsResponse) SetApplicationId(v string) *JourneyExecutionActivityMetricsResponse {
	s.ApplicationId = &v
	return s
}

// SetJourneyActivityId sets the JourneyActivityId field's value.
func (s *JourneyExecutionActivityMetricsResponse) SetJourneyActivityId(v string) *JourneyExecutionActivityMetricsResponse {
	s.JourneyActivityId = &v
	return s
}

// SetJourneyId sets the JourneyId field's value.
func (s *JourneyExecutionActivityMetricsResponse) SetJourneyId(v string) *JourneyExecutionActivityMetricsResponse {
	s.JourneyId = &v
	return s
}

// SetLastEvaluatedTime sets the LastEvaluatedTime field's value.
func (s *JourneyExecutionActivityMetricsResponse) SetLastEvaluatedTime(v string) *JourneyExecutionActivityMetricsResponse {
	s.LastEvaluatedTime = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *JourneyExecutionActivityMetricsResponse) SetMetrics(v map[string]*string) *JourneyExecutionActivityMetricsResponse {
	s.Metrics = v
	return s
}

// Provides the results of a query that retrieved the data for a standard execution
// metric that applies to a journey, and provides information about that query.
type JourneyExecutionMetricsResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the journey that the metric applies to.
	//
	// JourneyId is a required field
	JourneyId *string `type:"string" required:"true"`

	// The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated
	// the journey and updated the data for the metric.
	//
	// LastEvaluatedTime is a required field
	LastEvaluatedTime *string `type:"string" required:"true"`

	// A JSON object that contains the results of the query. For information about
	// the structure and contents of the results, see the Amazon Pinpoint Developer
	// Guide (https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html).
	//
	// Metrics is a required field
	Metrics map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s JourneyExecutionMetricsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyExecutionMetricsResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *JourneyExecutionMetricsResponse) SetApplicationId(v string) *JourneyExecutionMetricsResponse {
	s.ApplicationId = &v
	return s
}

// SetJourneyId sets the JourneyId field's value.
func (s *JourneyExecutionMetricsResponse) SetJourneyId(v string) *JourneyExecutionMetricsResponse {
	s.JourneyId = &v
	return s
}

// SetLastEvaluatedTime sets the LastEvaluatedTime field's value.
func (s *JourneyExecutionMetricsResponse) SetLastEvaluatedTime(v string) *JourneyExecutionMetricsResponse {
	s.LastEvaluatedTime = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *JourneyExecutionMetricsResponse) SetMetrics(v map[string]*string) *JourneyExecutionMetricsResponse {
	s.Metrics = v
	return s
}

// Specifies limits on the messages that a journey can send and the number of
// times participants can enter a journey.
type JourneyLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of messages that the journey can send to a single participant
	// during a 24-hour period. The maximum value is 100.
	DailyCap *int64 `type:"integer"`

	// The maximum number of times that a participant can enter the journey. The
	// maximum value is 100. To allow participants to enter the journey an unlimited
	// number of times, set this value to 0.
	EndpointReentryCap *int64 `type:"integer"`

	// The maximum number of messages that the journey can send each second.
	MessagesPerSecond *int64 `type:"integer"`
}

// String returns the string representation
func (s JourneyLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyLimits) GoString() string {
	return s.String()
}

// SetDailyCap sets the DailyCap field's value.
func (s *JourneyLimits) SetDailyCap(v int64) *JourneyLimits {
	s.DailyCap = &v
	return s
}

// SetEndpointReentryCap sets the EndpointReentryCap field's value.
func (s *JourneyLimits) SetEndpointReentryCap(v int64) *JourneyLimits {
	s.EndpointReentryCap = &v
	return s
}

// SetMessagesPerSecond sets the MessagesPerSecond field's value.
func (s *JourneyLimits) SetMessagesPerSecond(v int64) *JourneyLimits {
	s.MessagesPerSecond = &v
	return s
}

// Specifies the message configuration for a push notification that's sent to
// participants in a journey.
type JourneyPushMessage struct {
	_ struct{} `type:"structure"`

	// The number of seconds that the push notification service should keep the
	// message, if the service is unable to deliver the notification the first time.
	// This value is converted to an expiration value when it's sent to a push-notification
	// service. If this value is 0, the service treats the notification as if it
	// expires immediately and the service doesn't store or try to deliver the notification
	// again.
	//
	// This value doesn't apply to messages that are sent through the Amazon Device
	// Messaging (ADM) service.
	TimeToLive *string `type:"string"`
}

// String returns the string representation
func (s JourneyPushMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyPushMessage) GoString() string {
	return s.String()
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *JourneyPushMessage) SetTimeToLive(v string) *JourneyPushMessage {
	s.TimeToLive = &v
	return s
}

// Provides information about the status, configuration, and other settings
// for a journey.
type JourneyResponse struct {
	_ struct{} `type:"structure"`

	// A map that contains a set of Activity objects, one object for each activity
	// in the journey. For each Activity object, the key is the unique identifier
	// (string) for an activity and the value is the settings for the activity.
	Activities map[string]*Activity `type:"map"`

	// The unique identifier for the application that the journey applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The date, in ISO 8601 format, when the journey was created.
	CreationDate *string `type:"string"`

	// The unique identifier for the journey.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date, in ISO 8601 format, when the journey was last modified.
	LastModifiedDate *string `type:"string"`

	// The messaging and entry limits for the journey.
	Limits *JourneyLimits `type:"structure"`

	// Specifies whether the journey's scheduled start and end times use each participant's
	// local time. If this value is true, the schedule uses each participant's local
	// time.
	LocalTime *bool `type:"boolean"`

	// The name of the journey.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The quiet time settings for the journey. Quiet time is a specific time range
	// when a journey doesn't send messages to participants, if all the following
	// conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint for the participant
	//    is set to a valid value.
	//
	//    * The current time in the participant's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the journey.
	//
	//    * The current time in the participant's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the journey.
	//
	// If any of the preceding conditions isn't met, the participant will receive
	// messages from the journey, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`

	// The frequency with which Amazon Pinpoint evaluates segment and event data
	// for the journey, as a duration in ISO 8601 format.
	RefreshFrequency *string `type:"string"`

	// The schedule settings for the journey.
	Schedule *JourneySchedule `type:"structure"`

	// The unique identifier for the first activity in the journey.
	StartActivity *string `type:"string"`

	// The segment that defines which users are participants in the journey.
	StartCondition *StartCondition `type:"structure"`

	// The current status of the journey. Possible values are:
	//
	//    * DRAFT - The journey is being developed and hasn't been published yet.
	//
	//    * ACTIVE - The journey has been developed and published. Depending on
	//    the journey's schedule, the journey may currently be running or scheduled
	//    to start running at a later time. If a journey's status is ACTIVE, you
	//    can't add, change, or remove activities from it.
	//
	//    * COMPLETED - The journey has been published and has finished running.
	//    All participants have entered the journey and no participants are waiting
	//    to complete the journey or any activities in the journey.
	//
	//    * CANCELLED - The journey has been stopped. If a journey's status is CANCELLED,
	//    you can't add, change, or remove activities or segment settings from the
	//    journey.
	//
	//    * CLOSED - The journey has been published and has started running. It
	//    may have also passed its scheduled end time, or passed its scheduled start
	//    time and a refresh frequency hasn't been specified for it. If a journey's
	//    status is CLOSED, you can't add participants to it, and no existing participants
	//    can enter the journey for the first time. However, any existing participants
	//    who are currently waiting to start an activity may continue the journey.
	State *string `type:"string" enum:"State"`

	// This object is not used or supported.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s JourneyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyResponse) GoString() string {
	return s.String()
}

// SetActivities sets the Activities field's value.
func (s *JourneyResponse) SetActivities(v map[string]*Activity) *JourneyResponse {
	s.Activities = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *JourneyResponse) SetApplicationId(v string) *JourneyResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *JourneyResponse) SetCreationDate(v string) *JourneyResponse {
	s.CreationDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *JourneyResponse) SetId(v string) *JourneyResponse {
	s.Id = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *JourneyResponse) SetLastModifiedDate(v string) *JourneyResponse {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *JourneyResponse) SetLimits(v *JourneyLimits) *JourneyResponse {
	s.Limits = v
	return s
}

// SetLocalTime sets the LocalTime field's value.
func (s *JourneyResponse) SetLocalTime(v bool) *JourneyResponse {
	s.LocalTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *JourneyResponse) SetName(v string) *JourneyResponse {
	s.Name = &v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *JourneyResponse) SetQuietTime(v *QuietTime) *JourneyResponse {
	s.QuietTime = v
	return s
}

// SetRefreshFrequency sets the RefreshFrequency field's value.
func (s *JourneyResponse) SetRefreshFrequency(v string) *JourneyResponse {
	s.RefreshFrequency = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *JourneyResponse) SetSchedule(v *JourneySchedule) *JourneyResponse {
	s.Schedule = v
	return s
}

// SetStartActivity sets the StartActivity field's value.
func (s *JourneyResponse) SetStartActivity(v string) *JourneyResponse {
	s.StartActivity = &v
	return s
}

// SetStartCondition sets the StartCondition field's value.
func (s *JourneyResponse) SetStartCondition(v *StartCondition) *JourneyResponse {
	s.StartCondition = v
	return s
}

// SetState sets the State field's value.
func (s *JourneyResponse) SetState(v string) *JourneyResponse {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *JourneyResponse) SetTags(v map[string]*string) *JourneyResponse {
	s.Tags = v
	return s
}

// Specifies the sender ID and message type for an SMS message that's sent to
// participants in a journey.
type JourneySMSMessage struct {
	_ struct{} `type:"structure"`

	// The SMS message type. Valid values are TRANSACTIONAL (for messages that are
	// critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL
	// (for messsages that aren't critical or time-sensitive, such as marketing
	// messages).
	MessageType *string `type:"string" enum:"MessageType"`

	// The sender ID to display as the sender of the message on a recipient's device.
	// Support for sender IDs varies by country or region. For more information,
	// see Supported Countries and Regions (https://docs.aws.amazon.com.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html)
	// in the Amazon Pinpoint User Guide.
	SenderId *string `type:"string"`
}

// String returns the string representation
func (s JourneySMSMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneySMSMessage) GoString() string {
	return s.String()
}

// SetMessageType sets the MessageType field's value.
func (s *JourneySMSMessage) SetMessageType(v string) *JourneySMSMessage {
	s.MessageType = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *JourneySMSMessage) SetSenderId(v string) *JourneySMSMessage {
	s.SenderId = &v
	return s
}

// Specifies the schedule settings for a journey.
type JourneySchedule struct {
	_ struct{} `type:"structure"`

	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The starting UTC offset for the journey schedule, if the value of the journey's
	// LocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03,
	// UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30,
	// UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11,
	// UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02, UTC-02:30, UTC-03, UTC-03:30,
	// UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-09:30, UTC-10, and UTC-11.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s JourneySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneySchedule) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *JourneySchedule) SetEndTime(v time.Time) *JourneySchedule {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *JourneySchedule) SetStartTime(v time.Time) *JourneySchedule {
	s.StartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *JourneySchedule) SetTimezone(v string) *JourneySchedule {
	s.Timezone = &v
	return s
}

// Changes the status of a journey.
type JourneyStateRequest struct {
	_ struct{} `type:"structure"`

	// The status of the journey. Currently, the only supported value is CANCELLED.
	//
	// If you cancel a journey, Amazon Pinpoint continues to perform activities
	// that are currently in progress, until those activities are complete. Amazon
	// Pinpoint also continues to collect and aggregate analytics data for those
	// activities, until they are complete, and any activities that were complete
	// when you cancelled the journey.
	//
	// After you cancel a journey, you can't add, change, or remove any activities
	// from the journey. In addition, Amazon Pinpoint stops evaluating the journey
	// and doesn't perform any activities that haven't started.
	State *string `type:"string" enum:"State"`
}

// String returns the string representation
func (s JourneyStateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneyStateRequest) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *JourneyStateRequest) SetState(v string) *JourneyStateRequest {
	s.State = &v
	return s
}

// Provides information about the status, configuration, and other settings
// for all the journeys that are associated with an application.
type JourneysResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each journey that's associated with the application.
	//
	// Item is a required field
	Item []*JourneyResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s JourneysResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JourneysResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *JourneysResponse) SetItem(v []*JourneyResponse) *JourneysResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *JourneysResponse) SetNextToken(v string) *JourneysResponse {
	s.NextToken = &v
	return s
}

type ListJourneysInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s ListJourneysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJourneysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJourneysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJourneysInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListJourneysInput) SetApplicationId(v string) *ListJourneysInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListJourneysInput) SetPageSize(v string) *ListJourneysInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ListJourneysInput) SetToken(v string) *ListJourneysInput {
	s.Token = &v
	return s
}

type ListJourneysOutput struct {
	_ struct{} `type:"structure" payload:"JourneysResponse"`

	// Provides information about the status, configuration, and other settings
	// for all the journeys that are associated with an application.
	//
	// JourneysResponse is a required field
	JourneysResponse *JourneysResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListJourneysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJourneysOutput) GoString() string {
	return s.String()
}

// SetJourneysResponse sets the JourneysResponse field's value.
func (s *ListJourneysOutput) SetJourneysResponse(v *JourneysResponse) *ListJourneysOutput {
	s.JourneysResponse = v
	return s
}

// Provides information about all the recommender model configurations that
// are associated with your Amazon Pinpoint account.
type ListRecommenderConfigurationsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each recommender model configuration that's
	// associated with your Amazon Pinpoint account.
	//
	// Item is a required field
	Item []*RecommenderConfigurationResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListRecommenderConfigurationsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommenderConfigurationsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ListRecommenderConfigurationsResponse) SetItem(v []*RecommenderConfigurationResponse) *ListRecommenderConfigurationsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommenderConfigurationsResponse) SetNextToken(v string) *ListRecommenderConfigurationsResponse {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure" payload:"TagsModel"`

	// Specifies the tags (keys and values) for an application, campaign, message
	// template, or segment.
	//
	// TagsModel is a required field
	TagsModel *TagsModel `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagsModel sets the TagsModel field's value.
func (s *ListTagsForResourceOutput) SetTagsModel(v *TagsModel) *ListTagsForResourceOutput {
	s.TagsModel = v
	return s
}

type ListTemplateVersionsInput struct {
	_ struct{} `type:"structure"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	// TemplateType is a required field
	TemplateType *string `location:"uri" locationName:"template-type" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTemplateVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplateVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplateVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplateVersionsInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}
	if s.TemplateType != nil && len(*s.TemplateType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateVersionsInput) SetNextToken(v string) *ListTemplateVersionsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTemplateVersionsInput) SetPageSize(v string) *ListTemplateVersionsInput {
	s.PageSize = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ListTemplateVersionsInput) SetTemplateName(v string) *ListTemplateVersionsInput {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *ListTemplateVersionsInput) SetTemplateType(v string) *ListTemplateVersionsInput {
	s.TemplateType = &v
	return s
}

type ListTemplateVersionsOutput struct {
	_ struct{} `type:"structure" payload:"TemplateVersionsResponse"`

	// Provides information about all the versions of a specific message template.
	//
	// TemplateVersionsResponse is a required field
	TemplateVersionsResponse *TemplateVersionsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTemplateVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplateVersionsOutput) GoString() string {
	return s.String()
}

// SetTemplateVersionsResponse sets the TemplateVersionsResponse field's value.
func (s *ListTemplateVersionsOutput) SetTemplateVersionsResponse(v *TemplateVersionsResponse) *ListTemplateVersionsOutput {
	s.TemplateVersionsResponse = v
	return s
}

type ListTemplatesInput struct {
	_ struct{} `type:"structure"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	TemplateType *string `location:"querystring" locationName:"template-type" type:"string"`
}

// String returns the string representation
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplatesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesInput) SetNextToken(v string) *ListTemplatesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTemplatesInput) SetPageSize(v string) *ListTemplatesInput {
	s.PageSize = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListTemplatesInput) SetPrefix(v string) *ListTemplatesInput {
	s.Prefix = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *ListTemplatesInput) SetTemplateType(v string) *ListTemplatesInput {
	s.TemplateType = &v
	return s
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure" payload:"TemplatesResponse"`

	// Provides information about all the message templates that are associated
	// with your Amazon Pinpoint account.
	//
	// TemplatesResponse is a required field
	TemplatesResponse *TemplatesResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplatesOutput) GoString() string {
	return s.String()
}

// SetTemplatesResponse sets the TemplatesResponse field's value.
func (s *ListTemplatesOutput) SetTemplatesResponse(v *TemplatesResponse) *ListTemplatesOutput {
	s.TemplatesResponse = v
	return s
}

// Specifies the content and settings for a push notification that's sent to
// recipients of a campaign.
type Message struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of iOS and Android.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The body of the notification message. The maximum number of characters is
	// 200.
	Body *string `type:"string"`

	// The URL of the image to display as the push-notification icon, such as the
	// icon for the app.
	ImageIconUrl *string `type:"string"`

	// The URL of the image to display as the small, push-notification icon, such
	// as a small version of the icon for the app.
	ImageSmallIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The JSON payload to use for a silent push notification.
	JsonBody *string `type:"string"`

	// The URL of the image or video to display in the push notification.
	MediaUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. If specified, this value overrides all other content for the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration,
	// displaying messages in an in-app message center, or supporting phone home
	// functionality.
	SilentPush *bool `type:"boolean"`

	// The number of seconds that the push-notification service should keep the
	// message, if the service is unable to deliver the notification the first time.
	// This value is converted to an expiration value when it's sent to a push-notification
	// service. If this value is 0, the service treats the notification as if it
	// expires immediately and the service doesn't store or try to deliver the notification
	// again.
	//
	// This value doesn't apply to messages that are sent through the Amazon Device
	// Messaging (ADM) service.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in a recipient's default mobile browser, if a recipient taps
	// the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Message) SetAction(v string) *Message {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v string) *Message {
	s.Body = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *Message) SetImageIconUrl(v string) *Message {
	s.ImageIconUrl = &v
	return s
}

// SetImageSmallIconUrl sets the ImageSmallIconUrl field's value.
func (s *Message) SetImageSmallIconUrl(v string) *Message {
	s.ImageSmallIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *Message) SetImageUrl(v string) *Message {
	s.ImageUrl = &v
	return s
}

// SetJsonBody sets the JsonBody field's value.
func (s *Message) SetJsonBody(v string) *Message {
	s.JsonBody = &v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *Message) SetMediaUrl(v string) *Message {
	s.MediaUrl = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *Message) SetRawContent(v string) *Message {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *Message) SetSilentPush(v bool) *Message {
	s.SilentPush = &v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *Message) SetTimeToLive(v int64) *Message {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Message) SetTitle(v string) *Message {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Message) SetUrl(v string) *Message {
	s.Url = &v
	return s
}

// Provides information about an API request or response.
type MessageBody struct {
	_ struct{} `type:"structure"`

	// The message that's returned from the API.
	Message *string `type:"string"`

	// The unique identifier for the request or response.
	RequestID *string `type:"string"`
}

// String returns the string representation
func (s MessageBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageBody) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *MessageBody) SetMessage(v string) *MessageBody {
	s.Message = &v
	return s
}

// SetRequestID sets the RequestID field's value.
func (s *MessageBody) SetRequestID(v string) *MessageBody {
	s.RequestID = &v
	return s
}

// Specifies the message configuration settings for a campaign.
type MessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The message that the campaign sends through the ADM (Amazon Device Messaging)
	// channel. If specified, this message overrides the default message.
	ADMMessage *Message `type:"structure"`

	// The message that the campaign sends through the APNs (Apple Push Notification
	// service) channel. If specified, this message overrides the default message.
	APNSMessage *Message `type:"structure"`

	// The message that the campaign sends through the Baidu (Baidu Cloud Push)
	// channel. If specified, this message overrides the default message.
	BaiduMessage *Message `type:"structure"`

	// The message that the campaign sends through a custom channel, as specified
	// by the delivery configuration (CustomDeliveryConfiguration) settings for
	// the campaign. If specified, this message overrides the default message.
	CustomMessage *CampaignCustomMessage `type:"structure"`

	// The default message that the campaign sends through all the channels that
	// are configured for the campaign.
	DefaultMessage *Message `type:"structure"`

	// The message that the campaign sends through the email channel. If specified,
	// this message overrides the default message.
	EmailMessage *CampaignEmailMessage `type:"structure"`

	// The message that the campaign sends through the GCM channel, which enables
	// Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging
	// (FCM), formerly Google Cloud Messaging (GCM), service. If specified, this
	// message overrides the default message.
	GCMMessage *Message `type:"structure"`

	// The message that the campaign sends through the SMS channel. If specified,
	// this message overrides the default message.
	SMSMessage *CampaignSmsMessage `type:"structure"`
}

// String returns the string representation
func (s MessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageConfiguration) GoString() string {
	return s.String()
}

// SetADMMessage sets the ADMMessage field's value.
func (s *MessageConfiguration) SetADMMessage(v *Message) *MessageConfiguration {
	s.ADMMessage = v
	return s
}

// SetAPNSMessage sets the APNSMessage field's value.
func (s *MessageConfiguration) SetAPNSMessage(v *Message) *MessageConfiguration {
	s.APNSMessage = v
	return s
}

// SetBaiduMessage sets the BaiduMessage field's value.
func (s *MessageConfiguration) SetBaiduMessage(v *Message) *MessageConfiguration {
	s.BaiduMessage = v
	return s
}

// SetCustomMessage sets the CustomMessage field's value.
func (s *MessageConfiguration) SetCustomMessage(v *CampaignCustomMessage) *MessageConfiguration {
	s.CustomMessage = v
	return s
}

// SetDefaultMessage sets the DefaultMessage field's value.
func (s *MessageConfiguration) SetDefaultMessage(v *Message) *MessageConfiguration {
	s.DefaultMessage = v
	return s
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *MessageConfiguration) SetEmailMessage(v *CampaignEmailMessage) *MessageConfiguration {
	s.EmailMessage = v
	return s
}

// SetGCMMessage sets the GCMMessage field's value.
func (s *MessageConfiguration) SetGCMMessage(v *Message) *MessageConfiguration {
	s.GCMMessage = v
	return s
}

// SetSMSMessage sets the SMSMessage field's value.
func (s *MessageConfiguration) SetSMSMessage(v *CampaignSmsMessage) *MessageConfiguration {
	s.SMSMessage = v
	return s
}

// Specifies the configuration and other settings for a message.
type MessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of key-value pairs, where each key is an address and each value is
	// an AddressConfiguration object. An address can be a push notification token,
	// a phone number, or an email address. You can use an AddressConfiguration
	// object to tailor the message for an address by specifying settings such as
	// content overrides and message variables.
	Addresses map[string]*AddressConfiguration `type:"map"`

	// A map of custom attributes to attach to the message. For a push notification,
	// this payload is added to the data.pinpoint object. For an email or text message,
	// this payload is added to email/SMS delivery receipt event attributes.
	Context map[string]*string `type:"map"`

	// A map of key-value pairs, where each key is an endpoint ID and each value
	// is an EndpointSendConfiguration object. You can use an EndpointSendConfiguration
	// object to tailor the message for an endpoint by specifying settings such
	// as content overrides and message variables.
	Endpoints map[string]*EndpointSendConfiguration `type:"map"`

	// The settings and content for the default message and any default messages
	// that you defined for specific channels.
	//
	// MessageConfiguration is a required field
	MessageConfiguration *DirectMessageConfiguration `type:"structure" required:"true"`

	// The message template to use for the message.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// The unique identifier for tracing the message. This identifier is visible
	// to message recipients.
	TraceId *string `type:"string"`
}

// String returns the string representation
func (s MessageRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageRequest"}
	if s.MessageConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddresses sets the Addresses field's value.
func (s *MessageRequest) SetAddresses(v map[string]*AddressConfiguration) *MessageRequest {
	s.Addresses = v
	return s
}

// SetContext sets the Context field's value.
func (s *MessageRequest) SetContext(v map[string]*string) *MessageRequest {
	s.Context = v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *MessageRequest) SetEndpoints(v map[string]*EndpointSendConfiguration) *MessageRequest {
	s.Endpoints = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *MessageRequest) SetMessageConfiguration(v *DirectMessageConfiguration) *MessageRequest {
	s.MessageConfiguration = v
	return s
}

// SetTemplateConfiguration sets the TemplateConfiguration field's value.
func (s *MessageRequest) SetTemplateConfiguration(v *TemplateConfiguration) *MessageRequest {
	s.TemplateConfiguration = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *MessageRequest) SetTraceId(v string) *MessageRequest {
	s.TraceId = &v
	return s
}

// Provides information about the results of a request to send a message to
// an endpoint address.
type MessageResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that was used to send the message.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// A map that contains a multipart response for each address that the message
	// was sent to. In the map, the endpoint ID is the key and the result is the
	// value.
	EndpointResult map[string]*EndpointMessageResult `type:"map"`

	// The identifier for the original request that the message was delivered for.
	RequestId *string `type:"string"`

	// A map that contains a multipart response for each address (email address,
	// phone number, or push notification token) that the message was sent to. In
	// the map, the address is the key and the result is the value.
	Result map[string]*MessageResult `type:"map"`
}

// String returns the string representation
func (s MessageResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *MessageResponse) SetApplicationId(v string) *MessageResponse {
	s.ApplicationId = &v
	return s
}

// SetEndpointResult sets the EndpointResult field's value.
func (s *MessageResponse) SetEndpointResult(v map[string]*EndpointMessageResult) *MessageResponse {
	s.EndpointResult = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *MessageResponse) SetRequestId(v string) *MessageResponse {
	s.RequestId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *MessageResponse) SetResult(v map[string]*MessageResult) *MessageResponse {
	s.Result = v
	return s
}

// Provides information about the results of sending a message directly to an
// endpoint address.
type MessageResult struct {
	_ struct{} `type:"structure"`

	// The delivery status of the message. Possible values are:
	//
	//    * DUPLICATE - The endpoint address is a duplicate of another endpoint
	//    address. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * OPT_OUT - The user who's associated with the endpoint address has opted
	//    out of receiving messages from you. Amazon Pinpoint won't attempt to send
	//    the message again.
	//
	//    * PERMANENT_FAILURE - An error occurred when delivering the message to
	//    the endpoint address. Amazon Pinpoint won't attempt to send the message
	//    again.
	//
	//    * SUCCESSFUL - The message was successfully delivered to the endpoint
	//    address.
	//
	//    * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't
	//    attempt to send the message again.
	//
	//    * THROTTLED - Amazon Pinpoint throttled the operation to send the message
	//    to the endpoint address.
	//
	//    * TIMEOUT - The message couldn't be sent within the timeout period.
	//
	//    * UNKNOWN_FAILURE - An unknown error occurred.
	//
	// DeliveryStatus is a required field
	DeliveryStatus *string `type:"string" required:"true" enum:"DeliveryStatus"`

	// The unique identifier for the message that was sent.
	MessageId *string `type:"string"`

	// The downstream service status code for delivering the message.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The status message for delivering the message.
	StatusMessage *string `type:"string"`

	// For push notifications that are sent through the GCM channel, specifies whether
	// the endpoint's device registration token was updated as part of delivering
	// the message.
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s MessageResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageResult) GoString() string {
	return s.String()
}

// SetDeliveryStatus sets the DeliveryStatus field's value.
func (s *MessageResult) SetDeliveryStatus(v string) *MessageResult {
	s.DeliveryStatus = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *MessageResult) SetMessageId(v string) *MessageResult {
	s.MessageId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *MessageResult) SetStatusCode(v int64) *MessageResult {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *MessageResult) SetStatusMessage(v string) *MessageResult {
	s.StatusMessage = &v
	return s
}

// SetUpdatedToken sets the UpdatedToken field's value.
func (s *MessageResult) SetUpdatedToken(v string) *MessageResult {
	s.UpdatedToken = &v
	return s
}

// Provides information about an API request or response.
type MethodNotAllowedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RequestID_ *string `locationName:"RequestID" type:"string"`
}

// String returns the string representation
func (s MethodNotAllowedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodNotAllowedException) GoString() string {
	return s.String()
}

func newErrorMethodNotAllowedException(v protocol.ResponseMetadata) error {
	return &MethodNotAllowedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MethodNotAllowedException) Code() string {
	return "MethodNotAllowedException"
}

// Message returns the exception's message.
func (s *MethodNotAllowedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MethodNotAllowedException) OrigErr() error {
	return nil
}

func (s *MethodNotAllowedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MethodNotAllowedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MethodNotAllowedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies metric-based criteria for including or excluding endpoints from
// a segment. These criteria derive from custom metrics that you define for
// endpoints.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The operator to use when comparing metric values. Valid values are: GREATER_THAN,
	// LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true"`

	// The value to compare.
	//
	// Value is a required field
	Value *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDimension"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *MetricDimension) SetComparisonOperator(v string) *MetricDimension {
	s.ComparisonOperator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDimension) SetValue(v float64) *MetricDimension {
	s.Value = &v
	return s
}

// Specifies a condition to evaluate for an activity path in a journey.
type MultiConditionalBranch struct {
	_ struct{} `type:"structure"`

	// The condition to evaluate for the activity path.
	Condition *SimpleCondition `type:"structure"`

	// The unique identifier for the next activity to perform, after completing
	// the activity for the path.
	NextActivity *string `type:"string"`
}

// String returns the string representation
func (s MultiConditionalBranch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiConditionalBranch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiConditionalBranch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiConditionalBranch"}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *MultiConditionalBranch) SetCondition(v *SimpleCondition) *MultiConditionalBranch {
	s.Condition = v
	return s
}

// SetNextActivity sets the NextActivity field's value.
func (s *MultiConditionalBranch) SetNextActivity(v string) *MultiConditionalBranch {
	s.NextActivity = &v
	return s
}

// Specifies the settings for a multivariate split activity in a journey. This
// type of activity sends participants down one of as many as five paths (including
// a default Else path) in a journey, based on conditions that you specify.
type MultiConditionalSplitActivity struct {
	_ struct{} `type:"structure"`

	// The paths for the activity, including the conditions for entering each path
	// and the activity to perform for each path.
	Branches []*MultiConditionalBranch `type:"list"`

	// The unique identifier for the activity to perform for participants who don't
	// meet any of the conditions specified for other paths in the activity.
	DefaultActivity *string `type:"string"`

	// The amount of time to wait or the date and time when Amazon Pinpoint determines
	// whether the conditions are met.
	EvaluationWaitTime *WaitTime `type:"structure"`
}

// String returns the string representation
func (s MultiConditionalSplitActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiConditionalSplitActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiConditionalSplitActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiConditionalSplitActivity"}
	if s.Branches != nil {
		for i, v := range s.Branches {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Branches", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranches sets the Branches field's value.
func (s *MultiConditionalSplitActivity) SetBranches(v []*MultiConditionalBranch) *MultiConditionalSplitActivity {
	s.Branches = v
	return s
}

// SetDefaultActivity sets the DefaultActivity field's value.
func (s *MultiConditionalSplitActivity) SetDefaultActivity(v string) *MultiConditionalSplitActivity {
	s.DefaultActivity = &v
	return s
}

// SetEvaluationWaitTime sets the EvaluationWaitTime field's value.
func (s *MultiConditionalSplitActivity) SetEvaluationWaitTime(v *WaitTime) *MultiConditionalSplitActivity {
	s.EvaluationWaitTime = v
	return s
}

// Provides information about an API request or response.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RequestID_ *string `locationName:"RequestID" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies a phone number to validate and retrieve information about.
type NumberValidateRequest struct {
	_ struct{} `type:"structure"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the phone number was originally registered.
	IsoCountryCode *string `type:"string"`

	// The phone number to retrieve information about. The phone number that you
	// provide should include a valid numeric country code. Otherwise, the operation
	// might result in an error.
	PhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s NumberValidateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberValidateRequest) GoString() string {
	return s.String()
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *NumberValidateRequest) SetIsoCountryCode(v string) *NumberValidateRequest {
	s.IsoCountryCode = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *NumberValidateRequest) SetPhoneNumber(v string) *NumberValidateRequest {
	s.PhoneNumber = &v
	return s
}

// Provides information about a phone number.
type NumberValidateResponse struct {
	_ struct{} `type:"structure"`

	// The carrier or service provider that the phone number is currently registered
	// with. In some countries and regions, this value may be the carrier or service
	// provider that the phone number was originally registered with.
	Carrier *string `type:"string"`

	// The name of the city where the phone number was originally registered.
	City *string `type:"string"`

	// The cleansed phone number, in E.164 format, for the location where the phone
	// number was originally registered.
	CleansedPhoneNumberE164 *string `type:"string"`

	// The cleansed phone number, in the format for the location where the phone
	// number was originally registered.
	CleansedPhoneNumberNational *string `type:"string"`

	// The name of the country or region where the phone number was originally registered.
	Country *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the phone number was originally registered.
	CountryCodeIso2 *string `type:"string"`

	// The numeric code for the country or region where the phone number was originally
	// registered.
	CountryCodeNumeric *string `type:"string"`

	// The name of the county where the phone number was originally registered.
	County *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, that was sent in the
	// request body.
	OriginalCountryCodeIso2 *string `type:"string"`

	// The phone number that was sent in the request body.
	OriginalPhoneNumber *string `type:"string"`

	// The description of the phone type. Valid values are: MOBILE, LANDLINE, VOIP,
	// INVALID, PREPAID, and OTHER.
	PhoneType *string `type:"string"`

	// The phone type, represented by an integer. Valid values are: 0 (mobile),
	// 1 (landline), 2 (VoIP), 3 (invalid), 4 (other), and 5 (prepaid).
	PhoneTypeCode *int64 `type:"integer"`

	// The time zone for the location where the phone number was originally registered.
	Timezone *string `type:"string"`

	// The postal or ZIP code for the location where the phone number was originally
	// registered.
	ZipCode *string `type:"string"`
}

// String returns the string representation
func (s NumberValidateResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberValidateResponse) GoString() string {
	return s.String()
}

// SetCarrier sets the Carrier field's value.
func (s *NumberValidateResponse) SetCarrier(v string) *NumberValidateResponse {
	s.Carrier = &v
	return s
}

// SetCity sets the City field's value.
func (s *NumberValidateResponse) SetCity(v string) *NumberValidateResponse {
	s.City = &v
	return s
}

// SetCleansedPhoneNumberE164 sets the CleansedPhoneNumberE164 field's value.
func (s *NumberValidateResponse) SetCleansedPhoneNumberE164(v string) *NumberValidateResponse {
	s.CleansedPhoneNumberE164 = &v
	return s
}

// SetCleansedPhoneNumberNational sets the CleansedPhoneNumberNational field's value.
func (s *NumberValidateResponse) SetCleansedPhoneNumberNational(v string) *NumberValidateResponse {
	s.CleansedPhoneNumberNational = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *NumberValidateResponse) SetCountry(v string) *NumberValidateResponse {
	s.Country = &v
	return s
}

// SetCountryCodeIso2 sets the CountryCodeIso2 field's value.
func (s *NumberValidateResponse) SetCountryCodeIso2(v string) *NumberValidateResponse {
	s.CountryCodeIso2 = &v
	return s
}

// SetCountryCodeNumeric sets the CountryCodeNumeric field's value.
func (s *NumberValidateResponse) SetCountryCodeNumeric(v string) *NumberValidateResponse {
	s.CountryCodeNumeric = &v
	return s
}

// SetCounty sets the County field's value.
func (s *NumberValidateResponse) SetCounty(v string) *NumberValidateResponse {
	s.County = &v
	return s
}

// SetOriginalCountryCodeIso2 sets the OriginalCountryCodeIso2 field's value.
func (s *NumberValidateResponse) SetOriginalCountryCodeIso2(v string) *NumberValidateResponse {
	s.OriginalCountryCodeIso2 = &v
	return s
}

// SetOriginalPhoneNumber sets the OriginalPhoneNumber field's value.
func (s *NumberValidateResponse) SetOriginalPhoneNumber(v string) *NumberValidateResponse {
	s.OriginalPhoneNumber = &v
	return s
}

// SetPhoneType sets the PhoneType field's value.
func (s *NumberValidateResponse) SetPhoneType(v string) *NumberValidateResponse {
	s.PhoneType = &v
	return s
}

// SetPhoneTypeCode sets the PhoneTypeCode field's value.
func (s *NumberValidateResponse) SetPhoneTypeCode(v int64) *NumberValidateResponse {
	s.PhoneTypeCode = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *NumberValidateResponse) SetTimezone(v string) *NumberValidateResponse {
	s.Timezone = &v
	return s
}

// SetZipCode sets the ZipCode field's value.
func (s *NumberValidateResponse) SetZipCode(v string) *NumberValidateResponse {
	s.ZipCode = &v
	return s
}

// Provides information about an API request or response.
type PayloadTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RequestID_ *string `locationName:"RequestID" type:"string"`
}

// String returns the string representation
func (s PayloadTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PayloadTooLargeException) GoString() string {
	return s.String()
}

func newErrorPayloadTooLargeException(v protocol.ResponseMetadata) error {
	return &PayloadTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PayloadTooLargeException) Code() string {
	return "PayloadTooLargeException"
}

// Message returns the exception's message.
func (s *PayloadTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PayloadTooLargeException) OrigErr() error {
	return nil
}

func (s *PayloadTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PayloadTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PayloadTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PhoneNumberValidateInput struct {
	_ struct{} `type:"structure" payload:"NumberValidateRequest"`

	// Specifies a phone number to validate and retrieve information about.
	//
	// NumberValidateRequest is a required field
	NumberValidateRequest *NumberValidateRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s PhoneNumberValidateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberValidateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneNumberValidateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhoneNumberValidateInput"}
	if s.NumberValidateRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberValidateRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberValidateRequest sets the NumberValidateRequest field's value.
func (s *PhoneNumberValidateInput) SetNumberValidateRequest(v *NumberValidateRequest) *PhoneNumberValidateInput {
	s.NumberValidateRequest = v
	return s
}

type PhoneNumberValidateOutput struct {
	_ struct{} `type:"structure" payload:"NumberValidateResponse"`

	// Provides information about a phone number.
	//
	// NumberValidateResponse is a required field
	NumberValidateResponse *NumberValidateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s PhoneNumberValidateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberValidateOutput) GoString() string {
	return s.String()
}

// SetNumberValidateResponse sets the NumberValidateResponse field's value.
func (s *PhoneNumberValidateOutput) SetNumberValidateResponse(v *NumberValidateResponse) *PhoneNumberValidateOutput {
	s.NumberValidateResponse = v
	return s
}

// Specifies the properties and attributes of an endpoint that's associated
// with an event.
type PublicEndpoint struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the recipient, such as a device token, email address,
	// or mobile phone number.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. You can use these attributes as filter criteria
	// when you create segments.
	Attributes map[string][]*string `type:"map"`

	// The channel that's used when sending messages or push notifications to the
	// endpoint.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was last updated.
	EffectiveDate *string `type:"string"`

	// Specifies whether to send messages or push notifications to the endpoint.
	// Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE,
	// messages aren’t sent to the endpoint.
	//
	// Amazon Pinpoint automatically sets this value to ACTIVE when you create an
	// endpoint or update an existing endpoint. Amazon Pinpoint automatically sets
	// this value to INACTIVE if you update another endpoint that has the same address
	// specified by the Address property.
	EndpointStatus *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]*float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// A unique identifier that's generated each time the endpoint is updated.
	RequestId *string `type:"string"`

	// One or more custom user attributes that your app reports to Amazon Pinpoint
	// for the user who's associated with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s PublicEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *PublicEndpoint) SetAddress(v string) *PublicEndpoint {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *PublicEndpoint) SetAttributes(v map[string][]*string) *PublicEndpoint {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *PublicEndpoint) SetChannelType(v string) *PublicEndpoint {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *PublicEndpoint) SetDemographic(v *EndpointDemographic) *PublicEndpoint {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *PublicEndpoint) SetEffectiveDate(v string) *PublicEndpoint {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *PublicEndpoint) SetEndpointStatus(v string) *PublicEndpoint {
	s.EndpointStatus = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *PublicEndpoint) SetLocation(v *EndpointLocation) *PublicEndpoint {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *PublicEndpoint) SetMetrics(v map[string]*float64) *PublicEndpoint {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *PublicEndpoint) SetOptOut(v string) *PublicEndpoint {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PublicEndpoint) SetRequestId(v string) *PublicEndpoint {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *PublicEndpoint) SetUser(v *EndpointUser) *PublicEndpoint {
	s.User = v
	return s
}

// Specifies the settings for a push notification activity in a journey. This
// type of activity sends a push notification to participants.
type PushMessageActivity struct {
	_ struct{} `type:"structure"`

	// Specifies the time to live (TTL) value for push notifications that are sent
	// to participants in a journey.
	MessageConfig *JourneyPushMessage `type:"structure"`

	// The unique identifier for the next activity to perform, after the message
	// is sent.
	NextActivity *string `type:"string"`

	// The name of the push notification template to use for the message. If specified,
	// this value must match the name of an existing message template.
	TemplateName *string `type:"string"`

	// The unique identifier for the version of the push notification template to
	// use for the message. If specified, this value must match the identifier for
	// an existing template version. To retrieve a list of versions and version
	// identifiers for a template, use the Template Versions resource.
	//
	// If you don't specify a value for this property, Amazon Pinpoint uses the
	// active version of the template. The active version is typically the version
	// of a template that's been most recently reviewed and approved for use, depending
	// on your workflow. It isn't necessarily the latest version of a template.
	TemplateVersion *string `type:"string"`
}

// String returns the string representation
func (s PushMessageActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PushMessageActivity) GoString() string {
	return s.String()
}

// SetMessageConfig sets the MessageConfig field's value.
func (s *PushMessageActivity) SetMessageConfig(v *JourneyPushMessage) *PushMessageActivity {
	s.MessageConfig = v
	return s
}

// SetNextActivity sets the NextActivity field's value.
func (s *PushMessageActivity) SetNextActivity(v string) *PushMessageActivity {
	s.NextActivity = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *PushMessageActivity) SetTemplateName(v string) *PushMessageActivity {
	s.TemplateName = &v
	return s
}

// SetTemplateVersion sets the TemplateVersion field's value.
func (s *PushMessageActivity) SetTemplateVersion(v string) *PushMessageActivity {
	s.TemplateVersion = &v
	return s
}

// Specifies the content and settings for a message template that can be used
// in messages that are sent through a push notification channel.
type PushNotificationTemplateRequest struct {
	_ struct{} `type:"structure"`

	// The message template to use for the ADM (Amazon Device Messaging) channel.
	// This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	ADM *AndroidPushNotificationTemplate `type:"structure"`

	// The message template to use for the APNs (Apple Push Notification service)
	// channel. This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	APNS *APNSPushNotificationTemplate `type:"structure"`

	// The message template to use for the Baidu (Baidu Cloud Push) channel. This
	// message template overrides the default template for push notification channels
	// (DefaultPushNotificationTemplate).
	Baidu *AndroidPushNotificationTemplate `type:"structure"`

	// The default message template to use for push notification channels.
	Default *DefaultPushNotificationTemplate `type:"structure"`

	// A JSON object that specifies the default values to use for message variables
	// in the message template. This object is a set of key-value pairs. Each key
	// defines a message variable in the template. The corresponding value defines
	// the default value for that variable. When you create a message that's based
	// on the template, you can override these defaults with message-specific and
	// address-specific variables and values.
	DefaultSubstitutions *string `type:"string"`

	// The message template to use for the GCM channel, which is used to send notifications
	// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
	// (GCM), service. This message template overrides the default template for
	// push notification channels (DefaultPushNotificationTemplate).
	GCM *AndroidPushNotificationTemplate `type:"structure"`

	// The unique identifier for the recommender model to use for the message template.
	// Amazon Pinpoint uses this value to determine how to retrieve and process
	// data from a recommender model when it sends messages that use the template,
	// if the template contains message variables for recommendation data.
	RecommenderId *string `type:"string"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the message template. Each tag consists of a required tag key and an
	// associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A custom description of the message template.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s PushNotificationTemplateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PushNotificationTemplateRequest) GoString() string {
	return s.String()
}

// SetADM sets the ADM field's value.
func (s *PushNotificationTemplateRequest) SetADM(v *AndroidPushNotificationTemplate) *PushNotificationTemplateRequest {
	s.ADM = v
	return s
}

// SetAPNS sets the APNS field's value.
func (s *PushNotificationTemplateRequest) SetAPNS(v *APNSPushNotificationTemplate) *PushNotificationTemplateRequest {
	s.APNS = v
	return s
}

// SetBaidu sets the Baidu field's value.
func (s *PushNotificationTemplateRequest) SetBaidu(v *AndroidPushNotificationTemplate) *PushNotificationTemplateRequest {
	s.Baidu = v
	return s
}

// SetDefault sets the Default field's value.
func (s *PushNotificationTemplateRequest) SetDefault(v *DefaultPushNotificationTemplate) *PushNotificationTemplateRequest {
	s.Default = v
	return s
}

// SetDefaultSubstitutions sets the DefaultSubstitutions field's value.
func (s *PushNotificationTemplateRequest) SetDefaultSubstitutions(v string) *PushNotificationTemplateRequest {
	s.DefaultSubstitutions = &v
	return s
}

// SetGCM sets the GCM field's value.
func (s *PushNotificationTemplateRequest) SetGCM(v *AndroidPushNotificationTemplate) *PushNotificationTemplateRequest {
	s.GCM = v
	return s
}

// SetRecommenderId sets the RecommenderId field's value.
func (s *PushNotificationTemplateRequest) SetRecommenderId(v string) *PushNotificationTemplateRequest {
	s.RecommenderId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PushNotificationTemplateRequest) SetTags(v map[string]*string) *PushNotificationTemplateRequest {
	s.Tags = v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *PushNotificationTemplateRequest) SetTemplateDescription(v string) *PushNotificationTemplateRequest {
	s.TemplateDescription = &v
	return s
}

// Provides information about the content and settings for a message template
// that can be used in messages that are sent through a push notification channel.
type PushNotificationTemplateResponse struct {
	_ struct{} `type:"structure"`

	// The message template that's used for the ADM (Amazon Device Messaging) channel.
	// This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	ADM *AndroidPushNotificationTemplate `type:"structure"`

	// The message template that's used for the APNs (Apple Push Notification service)
	// channel. This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	APNS *APNSPushNotificationTemplate `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template.
	Arn *string `type:"string"`

	// The message template that's used for the Baidu (Baidu Cloud Push) channel.
	// This message template overrides the default template for push notification
	// channels (DefaultPushNotificationTemplate).
	Baidu *AndroidPushNotificationTemplate `type:"structure"`

	// The date, in ISO 8601 format, when the message template was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The default message template that's used for push notification channels.
	Default *DefaultPushNotificationTemplate `type:"structure"`

	// The JSON object that specifies the default values that are used for message
	// variables in the message template. This object is a set of key-value pairs.
	// Each key defines a message variable in the template. The corresponding value
	// defines the default value for that variable.
	DefaultSubstitutions *string `type:"string"`

	// The message template that's used for the GCM channel, which is used to send
	// notifications through the Firebase Cloud Messaging (FCM), formerly Google
	// Cloud Messaging (GCM), service. This message template overrides the default
	// template for push notification channels (DefaultPushNotificationTemplate).
	GCM *AndroidPushNotificationTemplate `type:"structure"`

	// The date, in ISO 8601 format, when the message template was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// The unique identifier for the recommender model that's used by the message
	// template.
	RecommenderId *string `type:"string"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the message template. Each tag consists of a required tag
	// key and an associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the message template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The type of channel that the message template is designed for. For a push
	// notification template, this value is PUSH.
	//
	// TemplateType is a required field
	TemplateType *string `type:"string" required:"true" enum:"TemplateType"`

	// The unique identifier, as an integer, for the active version of the message
	// template, or the version of the template that you specified by using the
	// version parameter in your request.
	Version *string `type:"string"`
}

// String returns the string representation
func (s PushNotificationTemplateResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PushNotificationTemplateResponse) GoString() string {
	return s.String()
}

// SetADM sets the ADM field's value.
func (s *PushNotificationTemplateResponse) SetADM(v *AndroidPushNotificationTemplate) *PushNotificationTemplateResponse {
	s.ADM = v
	return s
}

// SetAPNS sets the APNS field's value.
func (s *PushNotificationTemplateResponse) SetAPNS(v *APNSPushNotificationTemplate) *PushNotificationTemplateResponse {
	s.APNS = v
	return s
}

// SetArn sets the Arn field's value.
func (s *PushNotificationTemplateResponse) SetArn(v string) *PushNotificationTemplateResponse {
	s.Arn = &v
	return s
}

// SetBaidu sets the Baidu field's value.
func (s *PushNotificationTemplateResponse) SetBaidu(v *AndroidPushNotificationTemplate) *PushNotificationTemplateResponse {
	s.Baidu = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *PushNotificationTemplateResponse) SetCreationDate(v string) *PushNotificationTemplateResponse {
	s.CreationDate = &v
	return s
}

// SetDefault sets the Default field's value.
func (s *PushNotificationTemplateResponse) SetDefault(v *DefaultPushNotificationTemplate) *PushNotificationTemplateResponse {
	s.Default = v
	return s
}

// SetDefaultSubstitutions sets the DefaultSubstitutions field's value.
func (s *PushNotificationTemplateResponse) SetDefaultSubstitutions(v string) *PushNotificationTemplateResponse {
	s.DefaultSubstitutions = &v
	return s
}

// SetGCM sets the GCM field's value.
func (s *PushNotificationTemplateResponse) SetGCM(v *AndroidPushNotificationTemplate) *PushNotificationTemplateResponse {
	s.GCM = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *PushNotificationTemplateResponse) SetLastModifiedDate(v string) *PushNotificationTemplateResponse {
	s.LastModifiedDate = &v
	return s
}

// SetRecommenderId sets the RecommenderId field's value.
func (s *PushNotificationTemplateResponse) SetRecommenderId(v string) *PushNotificationTemplateResponse {
	s.RecommenderId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PushNotificationTemplateResponse) SetTags(v map[string]*string) *PushNotificationTemplateResponse {
	s.Tags = v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *PushNotificationTemplateResponse) SetTemplateDescription(v string) *PushNotificationTemplateResponse {
	s.TemplateDescription = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *PushNotificationTemplateResponse) SetTemplateName(v string) *PushNotificationTemplateResponse {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *PushNotificationTemplateResponse) SetTemplateType(v string) *PushNotificationTemplateResponse {
	s.TemplateType = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PushNotificationTemplateResponse) SetVersion(v string) *PushNotificationTemplateResponse {
	s.Version = &v
	return s
}

type PutEventStreamInput struct {
	_ struct{} `type:"structure" payload:"WriteEventStream"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the Amazon Resource Name (ARN) of an event stream to publish events
	// to and the AWS Identity and Access Management (IAM) role to use when publishing
	// those events.
	//
	// WriteEventStream is a required field
	WriteEventStream *WriteEventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.WriteEventStream == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteEventStream"))
	}
	if s.WriteEventStream != nil {
		if err := s.WriteEventStream.Validate(); err != nil {
			invalidParams.AddNested("WriteEventStream", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *PutEventStreamInput) SetApplicationId(v string) *PutEventStreamInput {
	s.ApplicationId = &v
	return s
}

// SetWriteEventStream sets the WriteEventStream field's value.
func (s *PutEventStreamInput) SetWriteEventStream(v *WriteEventStream) *PutEventStreamInput {
	s.WriteEventStream = v
	return s
}

type PutEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Specifies settings for publishing event data to an Amazon Kinesis data stream
	// or an Amazon Kinesis Data Firehose delivery stream.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *PutEventStreamOutput) SetEventStream(v *EventStream) *PutEventStreamOutput {
	s.EventStream = v
	return s
}

type PutEventsInput struct {
	_ struct{} `type:"structure" payload:"EventsRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies a batch of events to process.
	//
	// EventsRequest is a required field
	EventsRequest *EventsRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EventsRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EventsRequest"))
	}
	if s.EventsRequest != nil {
		if err := s.EventsRequest.Validate(); err != nil {
			invalidParams.AddNested("EventsRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *PutEventsInput) SetApplicationId(v string) *PutEventsInput {
	s.ApplicationId = &v
	return s
}

// SetEventsRequest sets the EventsRequest field's value.
func (s *PutEventsInput) SetEventsRequest(v *EventsRequest) *PutEventsInput {
	s.EventsRequest = v
	return s
}

type PutEventsOutput struct {
	_ struct{} `type:"structure" payload:"EventsResponse"`

	// Provides information about endpoints and the events that they're associated
	// with.
	//
	// EventsResponse is a required field
	EventsResponse *EventsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsOutput) GoString() string {
	return s.String()
}

// SetEventsResponse sets the EventsResponse field's value.
func (s *PutEventsOutput) SetEventsResponse(v *EventsResponse) *PutEventsOutput {
	s.EventsResponse = v
	return s
}

// Specifies the start and end times that define a time range when messages
// aren't sent to endpoints.
type QuietTime struct {
	_ struct{} `type:"structure"`

	// The specific time when quiet time ends. This value has to use 24-hour notation
	// and be in HH:MM format, where HH is the hour (with a leading zero, if applicable)
	// and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30
	// to represent 2:30 PM.
	End *string `type:"string"`

	// The specific time when quiet time begins. This value has to use 24-hour notation
	// and be in HH:MM format, where HH is the hour (with a leading zero, if applicable)
	// and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30
	// to represent 2:30 PM.
	Start *string `type:"string"`
}

// String returns the string representation
func (s QuietTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QuietTime) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *QuietTime) SetEnd(v string) *QuietTime {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *QuietTime) SetStart(v string) *QuietTime {
	s.Start = &v
	return s
}

// Specifies the settings for a random split activity in a journey. This type
// of activity randomly sends specified percentages of participants down one
// of as many as five paths in a journey, based on conditions that you specify.
type RandomSplitActivity struct {
	_ struct{} `type:"structure"`

	// The paths for the activity, including the percentage of participants to enter
	// each path and the activity to perform for each path.
	Branches []*RandomSplitEntry `type:"list"`
}

// String returns the string representation
func (s RandomSplitActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RandomSplitActivity) GoString() string {
	return s.String()
}

// SetBranches sets the Branches field's value.
func (s *RandomSplitActivity) SetBranches(v []*RandomSplitEntry) *RandomSplitActivity {
	s.Branches = v
	return s
}

// Specifies the settings for a path in a random split activity in a journey.
type RandomSplitEntry struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the next activity to perform, after completing
	// the activity for the path.
	NextActivity *string `type:"string"`

	// The percentage of participants to send down the activity path.
	//
	// To determine which participants are sent down each path, Amazon Pinpoint
	// applies a probability-based algorithm to the percentages that you specify
	// for the paths. Therefore, the actual percentage of participants who are sent
	// down a path may not be equal to the percentage that you specify.
	Percentage *int64 `type:"integer"`
}

// String returns the string representation
func (s RandomSplitEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RandomSplitEntry) GoString() string {
	return s.String()
}

// SetNextActivity sets the NextActivity field's value.
func (s *RandomSplitEntry) SetNextActivity(v string) *RandomSplitEntry {
	s.NextActivity = &v
	return s
}

// SetPercentage sets the Percentage field's value.
func (s *RandomSplitEntry) SetPercentage(v int64) *RandomSplitEntry {
	s.Percentage = &v
	return s
}

// Specifies the contents of an email message, represented as a raw MIME message.
type RawEmail struct {
	_ struct{} `type:"structure"`

	// Data is automatically base64 encoded/decoded by the SDK.
	Data []byte `type:"blob"`
}

// String returns the string representation
func (s RawEmail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RawEmail) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *RawEmail) SetData(v []byte) *RawEmail {
	s.Data = v
	return s
}

// Specifies criteria for including or excluding endpoints from a segment based
// on how recently an endpoint was active.
type RecencyDimension struct {
	_ struct{} `type:"structure"`

	// The duration to use when determining whether an endpoint is active or inactive.
	//
	// Duration is a required field
	Duration *string `type:"string" required:"true" enum:"Duration"`

	// The type of recency dimension to use for the segment. Valid values are: ACTIVE,
	// endpoints that were active within the specified duration are included in
	// the segment; and, INACTIVE, endpoints that weren't active within the specified
	// duration are included in the segment.
	//
	// RecencyType is a required field
	RecencyType *string `type:"string" required:"true" enum:"RecencyType"`
}

// String returns the string representation
func (s RecencyDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecencyDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecencyDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecencyDimension"}
	if s.Duration == nil {
		invalidParams.Add(request.NewErrParamRequired("Duration"))
	}
	if s.RecencyType == nil {
		invalidParams.Add(request.NewErrParamRequired("RecencyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *RecencyDimension) SetDuration(v string) *RecencyDimension {
	s.Duration = &v
	return s
}

// SetRecencyType sets the RecencyType field's value.
func (s *RecencyDimension) SetRecencyType(v string) *RecencyDimension {
	s.RecencyType = &v
	return s
}

// Provides information about Amazon Pinpoint configuration settings for retrieving
// and processing data from a recommender model.
type RecommenderConfigurationResponse struct {
	_ struct{} `type:"structure"`

	// A map that defines 1-10 custom endpoint or user attributes, depending on
	// the value for the RecommendationProviderIdType property. Each of these attributes
	// temporarily stores a recommended item that's retrieved from the recommender
	// model and sent to an AWS Lambda function for additional processing. Each
	// attribute can be used as a message variable in a message template.
	//
	// This value is null if the configuration doesn't invoke an AWS Lambda function
	// (RecommendationTransformerUri) to perform additional processing of recommendation
	// data.
	Attributes map[string]*string `type:"map"`

	// The date, in extended ISO 8601 format, when the configuration was created
	// for the recommender model.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The custom description of the configuration for the recommender model.
	Description *string `type:"string"`

	// The unique identifier for the recommender model configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date, in extended ISO 8601 format, when the configuration for the recommender
	// model was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// The custom name of the configuration for the recommender model.
	Name *string `type:"string"`

	// The type of Amazon Pinpoint ID that's associated with unique user IDs in
	// the recommender model. This value enables the model to use attribute and
	// event data that’s specific to a particular endpoint or user in an Amazon
	// Pinpoint application. Possible values are:
	//
	//    * PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular
	//    endpoint in Amazon Pinpoint. The data is correlated based on endpoint
	//    IDs in Amazon Pinpoint. This is the default value.
	//
	//    * PINPOINT_USER_ID - Each user in the model is associated with a particular
	//    user and endpoint in Amazon Pinpoint. The data is correlated based on
	//    user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition
	//    in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint
	//    ID. Otherwise, messages won’t be sent to the user's endpoint.
	RecommendationProviderIdType *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data
	// from the recommender model.
	//
	// RecommendationProviderRoleArn is a required field
	RecommendationProviderRoleArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint
	// retrieves the recommendation data from. This value is the ARN of an Amazon
	// Personalize campaign.
	//
	// RecommendationProviderUri is a required field
	RecommendationProviderUri *string `type:"string" required:"true"`

	// The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon
	// Pinpoint invokes to perform additional processing of recommendation data
	// that it retrieves from the recommender model.
	RecommendationTransformerUri *string `type:"string"`

	// The custom display name for the standard endpoint or user attribute (RecommendationItems)
	// that temporarily stores recommended items for each endpoint or user, depending
	// on the value for the RecommendationProviderIdType property. This name appears
	// in the Attribute finder of the template editor on the Amazon Pinpoint console.
	//
	// This value is null if the configuration doesn't invoke an AWS Lambda function
	// (RecommendationTransformerUri) to perform additional processing of recommendation
	// data.
	RecommendationsDisplayName *string `type:"string"`

	// The number of recommended items that are retrieved from the model for each
	// endpoint or user, depending on the value for the RecommendationProviderIdType
	// property. This number determines how many recommended items are available
	// for use in message variables.
	RecommendationsPerMessage *int64 `type:"integer"`
}

// String returns the string representation
func (s RecommenderConfigurationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommenderConfigurationResponse) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *RecommenderConfigurationResponse) SetAttributes(v map[string]*string) *RecommenderConfigurationResponse {
	s.Attributes = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *RecommenderConfigurationResponse) SetCreationDate(v string) *RecommenderConfigurationResponse {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RecommenderConfigurationResponse) SetDescription(v string) *RecommenderConfigurationResponse {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *RecommenderConfigurationResponse) SetId(v string) *RecommenderConfigurationResponse {
	s.Id = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *RecommenderConfigurationResponse) SetLastModifiedDate(v string) *RecommenderConfigurationResponse {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecommenderConfigurationResponse) SetName(v string) *RecommenderConfigurationResponse {
	s.Name = &v
	return s
}

// SetRecommendationProviderIdType sets the RecommendationProviderIdType field's value.
func (s *RecommenderConfigurationResponse) SetRecommendationProviderIdType(v string) *RecommenderConfigurationResponse {
	s.RecommendationProviderIdType = &v
	return s
}

// SetRecommendationProviderRoleArn sets the RecommendationProviderRoleArn field's value.
func (s *RecommenderConfigurationResponse) SetRecommendationProviderRoleArn(v string) *RecommenderConfigurationResponse {
	s.RecommendationProviderRoleArn = &v
	return s
}

// SetRecommendationProviderUri sets the RecommendationProviderUri field's value.
func (s *RecommenderConfigurationResponse) SetRecommendationProviderUri(v string) *RecommenderConfigurationResponse {
	s.RecommendationProviderUri = &v
	return s
}

// SetRecommendationTransformerUri sets the RecommendationTransformerUri field's value.
func (s *RecommenderConfigurationResponse) SetRecommendationTransformerUri(v string) *RecommenderConfigurationResponse {
	s.RecommendationTransformerUri = &v
	return s
}

// SetRecommendationsDisplayName sets the RecommendationsDisplayName field's value.
func (s *RecommenderConfigurationResponse) SetRecommendationsDisplayName(v string) *RecommenderConfigurationResponse {
	s.RecommendationsDisplayName = &v
	return s
}

// SetRecommendationsPerMessage sets the RecommendationsPerMessage field's value.
func (s *RecommenderConfigurationResponse) SetRecommendationsPerMessage(v int64) *RecommenderConfigurationResponse {
	s.RecommendationsPerMessage = &v
	return s
}

type RemoveAttributesInput struct {
	_ struct{} `type:"structure" payload:"UpdateAttributesRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// AttributeType is a required field
	AttributeType *string `location:"uri" locationName:"attribute-type" type:"string" required:"true"`

	// Specifies one or more attributes to remove from all the endpoints that are
	// associated with an application.
	//
	// UpdateAttributesRequest is a required field
	UpdateAttributesRequest *UpdateAttributesRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s RemoveAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAttributesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.AttributeType == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeType"))
	}
	if s.AttributeType != nil && len(*s.AttributeType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeType", 1))
	}
	if s.UpdateAttributesRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateAttributesRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *RemoveAttributesInput) SetApplicationId(v string) *RemoveAttributesInput {
	s.ApplicationId = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *RemoveAttributesInput) SetAttributeType(v string) *RemoveAttributesInput {
	s.AttributeType = &v
	return s
}

// SetUpdateAttributesRequest sets the UpdateAttributesRequest field's value.
func (s *RemoveAttributesInput) SetUpdateAttributesRequest(v *UpdateAttributesRequest) *RemoveAttributesInput {
	s.UpdateAttributesRequest = v
	return s
}

type RemoveAttributesOutput struct {
	_ struct{} `type:"structure" payload:"AttributesResource"`

	// Provides information about the type and the names of attributes that were
	// removed from all the endpoints that are associated with an application.
	//
	// AttributesResource is a required field
	AttributesResource *AttributesResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s RemoveAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributesResource sets the AttributesResource field's value.
func (s *RemoveAttributesOutput) SetAttributesResource(v *AttributesResource) *RemoveAttributesOutput {
	s.AttributesResource = v
	return s
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application, campaign, or journey.
type ResultRow struct {
	_ struct{} `type:"structure"`

	// An array of objects that defines the field and field values that were used
	// to group data in a result set that contains multiple results. This value
	// is null if the data in a result set isn’t grouped.
	//
	// GroupedBys is a required field
	GroupedBys []*ResultRowValue `type:"list" required:"true"`

	// An array of objects that provides pre-aggregated values for a standard metric
	// that applies to an application, campaign, or journey.
	//
	// Values is a required field
	Values []*ResultRowValue `type:"list" required:"true"`
}

// String returns the string representation
func (s ResultRow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultRow) GoString() string {
	return s.String()
}

// SetGroupedBys sets the GroupedBys field's value.
func (s *ResultRow) SetGroupedBys(v []*ResultRowValue) *ResultRow {
	s.GroupedBys = v
	return s
}

// SetValues sets the Values field's value.
func (s *ResultRow) SetValues(v []*ResultRowValue) *ResultRow {
	s.Values = v
	return s
}

// Provides a single value and metadata about that value as part of an array
// of query results for a standard metric that applies to an application, campaign,
// or journey.
type ResultRowValue struct {
	_ struct{} `type:"structure"`

	// The friendly name of the metric whose value is specified by the Value property.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The data type of the value specified by the Value property.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`

	// In a Values object, the value for the metric that the query retrieved data
	// for. In a GroupedBys object, the value for the field that was used to group
	// data in a result set that contains multiple results (Values objects).
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResultRowValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultRowValue) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResultRowValue) SetKey(v string) *ResultRowValue {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResultRowValue) SetType(v string) *ResultRowValue {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResultRowValue) SetValue(v string) *ResultRowValue {
	s.Value = &v
	return s
}

// Specifies the status and settings of the SMS channel for an application.
type SMSChannelRequest struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the SMS channel for the application.
	Enabled *bool `type:"boolean"`

	// The identity that you want to display on recipients' devices when they receive
	// messages from the SMS channel.
	SenderId *string `type:"string"`

	// The registered short code that you want to use when you send messages through
	// the SMS channel.
	ShortCode *string `type:"string"`
}

// String returns the string representation
func (s SMSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSChannelRequest) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SMSChannelRequest) SetEnabled(v bool) *SMSChannelRequest {
	s.Enabled = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSChannelRequest) SetSenderId(v string) *SMSChannelRequest {
	s.SenderId = &v
	return s
}

// SetShortCode sets the ShortCode field's value.
func (s *SMSChannelRequest) SetShortCode(v string) *SMSChannelRequest {
	s.ShortCode = &v
	return s
}

// Provides information about the status and settings of the SMS channel for
// an application.
type SMSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the SMS channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the SMS channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the SMS channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the SMS channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the SMS channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the SMS channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the SMS channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the SMS
	// channel, this value is SMS.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The maximum number of promotional messages that you can send through the
	// SMS channel each second.
	PromotionalMessagesPerSecond *int64 `type:"integer"`

	// The identity that displays on recipients' devices when they receive messages
	// from the SMS channel.
	SenderId *string `type:"string"`

	// The registered short code to use when you send messages through the SMS channel.
	ShortCode *string `type:"string"`

	// The maximum number of transactional messages that you can send through the
	// SMS channel each second.
	TransactionalMessagesPerSecond *int64 `type:"integer"`

	// The current version of the SMS channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SMSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SMSChannelResponse) SetApplicationId(v string) *SMSChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *SMSChannelResponse) SetCreationDate(v string) *SMSChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *SMSChannelResponse) SetEnabled(v bool) *SMSChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *SMSChannelResponse) SetHasCredential(v bool) *SMSChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *SMSChannelResponse) SetId(v string) *SMSChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *SMSChannelResponse) SetIsArchived(v bool) *SMSChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *SMSChannelResponse) SetLastModifiedBy(v string) *SMSChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SMSChannelResponse) SetLastModifiedDate(v string) *SMSChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *SMSChannelResponse) SetPlatform(v string) *SMSChannelResponse {
	s.Platform = &v
	return s
}

// SetPromotionalMessagesPerSecond sets the PromotionalMessagesPerSecond field's value.
func (s *SMSChannelResponse) SetPromotionalMessagesPerSecond(v int64) *SMSChannelResponse {
	s.PromotionalMessagesPerSecond = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSChannelResponse) SetSenderId(v string) *SMSChannelResponse {
	s.SenderId = &v
	return s
}

// SetShortCode sets the ShortCode field's value.
func (s *SMSChannelResponse) SetShortCode(v string) *SMSChannelResponse {
	s.ShortCode = &v
	return s
}

// SetTransactionalMessagesPerSecond sets the TransactionalMessagesPerSecond field's value.
func (s *SMSChannelResponse) SetTransactionalMessagesPerSecond(v int64) *SMSChannelResponse {
	s.TransactionalMessagesPerSecond = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SMSChannelResponse) SetVersion(v int64) *SMSChannelResponse {
	s.Version = &v
	return s
}

// Specifies the default settings for a one-time SMS message that's sent directly
// to an endpoint.
type SMSMessage struct {
	_ struct{} `type:"structure"`

	// The body of the SMS message.
	Body *string `type:"string"`

	// The SMS program name that you provided to AWS Support when you requested
	// your dedicated number.
	Keyword *string `type:"string"`

	// The URL of an image or video to display in the SMS message.
	MediaUrl *string `type:"string"`

	// The SMS message type. Valid values are TRANSACTIONAL (for messages that are
	// critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL
	// (for messsages that aren't critical or time-sensitive, such as marketing
	// messages).
	MessageType *string `type:"string" enum:"MessageType"`

	// The number to send the SMS message from. This value should be one of the
	// dedicated long or short codes that's assigned to your AWS account. If you
	// don't specify a long or short code, Amazon Pinpoint assigns a random long
	// code to the SMS message and sends the message from that code.
	OriginationNumber *string `type:"string"`

	// The sender ID to display as the sender of the message on a recipient's device.
	// Support for sender IDs varies by country or region.
	SenderId *string `type:"string"`

	// The message variables to use in the SMS message. You can override the default
	// variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`
}

// String returns the string representation
func (s SMSMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *SMSMessage) SetBody(v string) *SMSMessage {
	s.Body = &v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *SMSMessage) SetKeyword(v string) *SMSMessage {
	s.Keyword = &v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *SMSMessage) SetMediaUrl(v string) *SMSMessage {
	s.MediaUrl = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SMSMessage) SetMessageType(v string) *SMSMessage {
	s.MessageType = &v
	return s
}

// SetOriginationNumber sets the OriginationNumber field's value.
func (s *SMSMessage) SetOriginationNumber(v string) *SMSMessage {
	s.OriginationNumber = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSMessage) SetSenderId(v string) *SMSMessage {
	s.SenderId = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *SMSMessage) SetSubstitutions(v map[string][]*string) *SMSMessage {
	s.Substitutions = v
	return s
}

// Specifies the settings for an SMS activity in a journey. This type of activity
// sends a text message to participants.
type SMSMessageActivity struct {
	_ struct{} `type:"structure"`

	// Specifies the sender ID and message type for an SMS message that's sent to
	// participants in a journey.
	MessageConfig *JourneySMSMessage `type:"structure"`

	// The unique identifier for the next activity to perform, after the message
	// is sent.
	NextActivity *string `type:"string"`

	// The name of the SMS message template to use for the message. If specified,
	// this value must match the name of an existing message template.
	TemplateName *string `type:"string"`

	// The unique identifier for the version of the SMS template to use for the
	// message. If specified, this value must match the identifier for an existing
	// template version. To retrieve a list of versions and version identifiers
	// for a template, use the Template Versions resource.
	//
	// If you don't specify a value for this property, Amazon Pinpoint uses the
	// active version of the template. The active version is typically the version
	// of a template that's been most recently reviewed and approved for use, depending
	// on your workflow. It isn't necessarily the latest version of a template.
	TemplateVersion *string `type:"string"`
}

// String returns the string representation
func (s SMSMessageActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSMessageActivity) GoString() string {
	return s.String()
}

// SetMessageConfig sets the MessageConfig field's value.
func (s *SMSMessageActivity) SetMessageConfig(v *JourneySMSMessage) *SMSMessageActivity {
	s.MessageConfig = v
	return s
}

// SetNextActivity sets the NextActivity field's value.
func (s *SMSMessageActivity) SetNextActivity(v string) *SMSMessageActivity {
	s.NextActivity = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *SMSMessageActivity) SetTemplateName(v string) *SMSMessageActivity {
	s.TemplateName = &v
	return s
}

// SetTemplateVersion sets the TemplateVersion field's value.
func (s *SMSMessageActivity) SetTemplateVersion(v string) *SMSMessageActivity {
	s.TemplateVersion = &v
	return s
}

// Specifies the content and settings for a message template that can be used
// in text messages that are sent through the SMS channel.
type SMSTemplateRequest struct {
	_ struct{} `type:"structure"`

	// The message body to use in text messages that are based on the message template.
	Body *string `type:"string"`

	// A JSON object that specifies the default values to use for message variables
	// in the message template. This object is a set of key-value pairs. Each key
	// defines a message variable in the template. The corresponding value defines
	// the default value for that variable. When you create a message that's based
	// on the template, you can override these defaults with message-specific and
	// address-specific variables and values.
	DefaultSubstitutions *string `type:"string"`

	// The unique identifier for the recommender model to use for the message template.
	// Amazon Pinpoint uses this value to determine how to retrieve and process
	// data from a recommender model when it sends messages that use the template,
	// if the template contains message variables for recommendation data.
	RecommenderId *string `type:"string"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the message template. Each tag consists of a required tag key and an
	// associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A custom description of the message template.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s SMSTemplateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSTemplateRequest) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *SMSTemplateRequest) SetBody(v string) *SMSTemplateRequest {
	s.Body = &v
	return s
}

// SetDefaultSubstitutions sets the DefaultSubstitutions field's value.
func (s *SMSTemplateRequest) SetDefaultSubstitutions(v string) *SMSTemplateRequest {
	s.DefaultSubstitutions = &v
	return s
}

// SetRecommenderId sets the RecommenderId field's value.
func (s *SMSTemplateRequest) SetRecommenderId(v string) *SMSTemplateRequest {
	s.RecommenderId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SMSTemplateRequest) SetTags(v map[string]*string) *SMSTemplateRequest {
	s.Tags = v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *SMSTemplateRequest) SetTemplateDescription(v string) *SMSTemplateRequest {
	s.TemplateDescription = &v
	return s
}

// Provides information about the content and settings for a message template
// that can be used in text messages that are sent through the SMS channel.
type SMSTemplateResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the message template.
	Arn *string `type:"string"`

	// The message body that's used in text messages that are based on the message
	// template.
	Body *string `type:"string"`

	// The date, in ISO 8601 format, when the message template was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The JSON object that specifies the default values that are used for message
	// variables in the message template. This object is a set of key-value pairs.
	// Each key defines a message variable in the template. The corresponding value
	// defines the default value for that variable.
	DefaultSubstitutions *string `type:"string"`

	// The date, in ISO 8601 format, when the message template was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// The unique identifier for the recommender model that's used by the message
	// template.
	RecommenderId *string `type:"string"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the message template. Each tag consists of a required tag
	// key and an associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The custom description of the message template.
	TemplateDescription *string `type:"string"`

	// The name of the message template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The type of channel that the message template is designed for. For an SMS
	// template, this value is SMS.
	//
	// TemplateType is a required field
	TemplateType *string `type:"string" required:"true" enum:"TemplateType"`

	// The unique identifier, as an integer, for the active version of the message
	// template, or the version of the template that you specified by using the
	// version parameter in your request.
	Version *string `type:"string"`
}

// String returns the string representation
func (s SMSTemplateResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSTemplateResponse) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SMSTemplateResponse) SetArn(v string) *SMSTemplateResponse {
	s.Arn = &v
	return s
}

// SetBody sets the Body field's value.
func (s *SMSTemplateResponse) SetBody(v string) *SMSTemplateResponse {
	s.Body = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *SMSTemplateResponse) SetCreationDate(v string) *SMSTemplateResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultSubstitutions sets the DefaultSubstitutions field's value.
func (s *SMSTemplateResponse) SetDefaultSubstitutions(v string) *SMSTemplateResponse {
	s.DefaultSubstitutions = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SMSTemplateResponse) SetLastModifiedDate(v string) *SMSTemplateResponse {
	s.LastModifiedDate = &v
	return s
}

// SetRecommenderId sets the RecommenderId field's value.
func (s *SMSTemplateResponse) SetRecommenderId(v string) *SMSTemplateResponse {
	s.RecommenderId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SMSTemplateResponse) SetTags(v map[string]*string) *SMSTemplateResponse {
	s.Tags = v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *SMSTemplateResponse) SetTemplateDescription(v string) *SMSTemplateResponse {
	s.TemplateDescription = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *SMSTemplateResponse) SetTemplateName(v string) *SMSTemplateResponse {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *SMSTemplateResponse) SetTemplateType(v string) *SMSTemplateResponse {
	s.TemplateType = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SMSTemplateResponse) SetVersion(v string) *SMSTemplateResponse {
	s.Version = &v
	return s
}

// Specifies the schedule settings for a campaign.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The scheduled time, in ISO 8601 format, when the campaign ended or will end.
	EndTime *string `type:"string"`

	// The type of event that causes the campaign to be sent, if the value of the
	// Frequency property is EVENT.
	EventFilter *CampaignEventFilter `type:"structure"`

	// Specifies how often the campaign is sent or whether the campaign is sent
	// in response to a specific event.
	Frequency *string `type:"string" enum:"Frequency"`

	// Specifies whether the start and end times for the campaign schedule use each
	// recipient's local time. To base the schedule on each recipient's local time,
	// set this value to true.
	IsLocalTime *bool `type:"boolean"`

	// The default quiet time for the campaign. Quiet time is a specific time range
	// when a campaign doesn't send messages to endpoints, if all the following
	// conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint is set to
	//    a valid value.
	//
	//    * The current time in the endpoint's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the campaign.
	//
	//    * The current time in the endpoint's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the campaign.
	//
	// If any of the preceding conditions isn't met, the endpoint will receive messages
	// from the campaign, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`

	// The scheduled time when the campaign began or will begin. Valid values are:
	// IMMEDIATE, to start the campaign immediately; or, a specific time in ISO
	// 8601 format.
	//
	// StartTime is a required field
	StartTime *string `type:"string" required:"true"`

	// The starting UTC offs