// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchDeleteDocument = "BatchDeleteDocument"

// BatchDeleteDocumentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteDocument for more information on using the BatchDeleteDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteDocumentRequest method.
//    req, resp := client.BatchDeleteDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument
func (c *Kendra) BatchDeleteDocumentRequest(input *BatchDeleteDocumentInput) (req *request.Request, output *BatchDeleteDocumentOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteDocumentInput{}
	}

	output = &BatchDeleteDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteDocument API operation for AWSKendraFrontendService.
//
// Removes one or more documents from an index. The documents must have been
// added with the BatchPutDocument operation.
//
// The documents are deleted asynchronously. You can see the progress of the
// deletion by using Amazon Web Services CloudWatch. Any error messages related
// to the processing of the batch are sent to you CloudWatch log.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation BatchDeleteDocument for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument
func (c *Kendra) BatchDeleteDocument(input *BatchDeleteDocumentInput) (*BatchDeleteDocumentOutput, error) {
	req, out := c.BatchDeleteDocumentRequest(input)
	return out, req.Send()
}

// BatchDeleteDocumentWithContext is the same as BatchDeleteDocument with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) BatchDeleteDocumentWithContext(ctx aws.Context, input *BatchDeleteDocumentInput, opts ...request.Option) (*BatchDeleteDocumentOutput, error) {
	req, out := c.BatchDeleteDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetDocumentStatus = "BatchGetDocumentStatus"

// BatchGetDocumentStatusRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDocumentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetDocumentStatus for more information on using the BatchGetDocumentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetDocumentStatusRequest method.
//    req, resp := client.BatchGetDocumentStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchGetDocumentStatus
func (c *Kendra) BatchGetDocumentStatusRequest(input *BatchGetDocumentStatusInput) (req *request.Request, output *BatchGetDocumentStatusOutput) {
	op := &request.Operation{
		Name:       opBatchGetDocumentStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDocumentStatusInput{}
	}

	output = &BatchGetDocumentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetDocumentStatus API operation for AWSKendraFrontendService.
//
// Returns the indexing status for one or more documents submitted with the
// BatchPutDocument (https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html)
// operation.
//
// When you use the BatchPutDocument operation, documents are indexed asynchronously.
// You can use the BatchGetDocumentStatus operation to get the current status
// of a list of documents so that you can determine if they have been successfully
// indexed.
//
// You can also use the BatchGetDocumentStatus operation to check the status
// of the BatchDeleteDocument (https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html)
// operation. When a document is deleted from the index, Amazon Kendra returns
// NOT_FOUND as the status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation BatchGetDocumentStatus for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchGetDocumentStatus
func (c *Kendra) BatchGetDocumentStatus(input *BatchGetDocumentStatusInput) (*BatchGetDocumentStatusOutput, error) {
	req, out := c.BatchGetDocumentStatusRequest(input)
	return out, req.Send()
}

// BatchGetDocumentStatusWithContext is the same as BatchGetDocumentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetDocumentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) BatchGetDocumentStatusWithContext(ctx aws.Context, input *BatchGetDocumentStatusInput, opts ...request.Option) (*BatchGetDocumentStatusOutput, error) {
	req, out := c.BatchGetDocumentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutDocument = "BatchPutDocument"

// BatchPutDocumentRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutDocument for more information on using the BatchPutDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutDocumentRequest method.
//    req, resp := client.BatchPutDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument
func (c *Kendra) BatchPutDocumentRequest(input *BatchPutDocumentInput) (req *request.Request, output *BatchPutDocumentOutput) {
	op := &request.Operation{
		Name:       opBatchPutDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchPutDocumentInput{}
	}

	output = &BatchPutDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutDocument API operation for AWSKendraFrontendService.
//
// Adds one or more documents to an index.
//
// The BatchPutDocument operation enables you to ingest inline documents or
// a set of documents stored in an Amazon S3 bucket. Use this operation to ingest
// your text and unstructured text into an index, add custom attributes to the
// documents, and to attach an access control list to the documents added to
// the index.
//
// The documents are indexed asynchronously. You can see the progress of the
// batch using Amazon Web Services CloudWatch. Any error messages related to
// processing the batch are sent to your Amazon Web Services CloudWatch log.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation BatchPutDocument for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument
func (c *Kendra) BatchPutDocument(input *BatchPutDocumentInput) (*BatchPutDocumentOutput, error) {
	req, out := c.BatchPutDocumentRequest(input)
	return out, req.Send()
}

// BatchPutDocumentWithContext is the same as BatchPutDocument with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) BatchPutDocumentWithContext(ctx aws.Context, input *BatchPutDocumentInput, opts ...request.Option) (*BatchPutDocumentOutput, error) {
	req, out := c.BatchPutDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClearQuerySuggestions = "ClearQuerySuggestions"

// ClearQuerySuggestionsRequest generates a "aws/request.Request" representing the
// client's request for the ClearQuerySuggestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClearQuerySuggestions for more information on using the ClearQuerySuggestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ClearQuerySuggestionsRequest method.
//    req, resp := client.ClearQuerySuggestionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ClearQuerySuggestions
func (c *Kendra) ClearQuerySuggestionsRequest(input *ClearQuerySuggestionsInput) (req *request.Request, output *ClearQuerySuggestionsOutput) {
	op := &request.Operation{
		Name:       opClearQuerySuggestions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ClearQuerySuggestionsInput{}
	}

	output = &ClearQuerySuggestionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ClearQuerySuggestions API operation for AWSKendraFrontendService.
//
// Clears existing query suggestions from an index.
//
// This deletes existing suggestions only, not the queries in the query log.
// After you clear suggestions, Amazon Kendra learns new suggestions based on
// new queries added to the query log from the time you cleared suggestions.
// If you do not see any new suggestions, then please allow Amazon Kendra to
// collect enough queries to learn new suggestions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ClearQuerySuggestions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ConflictException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ClearQuerySuggestions
func (c *Kendra) ClearQuerySuggestions(input *ClearQuerySuggestionsInput) (*ClearQuerySuggestionsOutput, error) {
	req, out := c.ClearQuerySuggestionsRequest(input)
	return out, req.Send()
}

// ClearQuerySuggestionsWithContext is the same as ClearQuerySuggestions with the addition of
// the ability to pass a context and additional request options.
//
// See ClearQuerySuggestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ClearQuerySuggestionsWithContext(ctx aws.Context, input *ClearQuerySuggestionsInput, opts ...request.Option) (*ClearQuerySuggestionsOutput, error) {
	req, out := c.ClearQuerySuggestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSourceRequest method.
//    req, resp := client.CreateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource
func (c *Kendra) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for AWSKendraFrontendService.
//
// Creates a data source that you use to with an Amazon Kendra index.
//
// You specify a name, data source connector type and description for your data
// source. You also specify configuration information such as document metadata
// (author, source URI, and so on) and user context information.
//
// CreateDataSource is a synchronous operation. The operation returns 200 if
// the data source was successfully created. Otherwise, an exception is raised.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ResourceAlreadyExistException
//
//   * ServiceQuotaExceededException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource
func (c *Kendra) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFaq = "CreateFaq"

// CreateFaqRequest generates a "aws/request.Request" representing the
// client's request for the CreateFaq operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFaq for more information on using the CreateFaq
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFaqRequest method.
//    req, resp := client.CreateFaqRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq
func (c *Kendra) CreateFaqRequest(input *CreateFaqInput) (req *request.Request, output *CreateFaqOutput) {
	op := &request.Operation{
		Name:       opCreateFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFaqInput{}
	}

	output = &CreateFaqOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFaq API operation for AWSKendraFrontendService.
//
// Creates an new set of frequently asked question (FAQ) questions and answers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation CreateFaq for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ServiceQuotaExceededException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq
func (c *Kendra) CreateFaq(input *CreateFaqInput) (*CreateFaqOutput, error) {
	req, out := c.CreateFaqRequest(input)
	return out, req.Send()
}

// CreateFaqWithContext is the same as CreateFaq with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFaq for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) CreateFaqWithContext(ctx aws.Context, input *CreateFaqInput, opts ...request.Option) (*CreateFaqOutput, error) {
	req, out := c.CreateFaqRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIndex = "CreateIndex"

// CreateIndexRequest generates a "aws/request.Request" representing the
// client's request for the CreateIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIndex for more information on using the CreateIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIndexRequest method.
//    req, resp := client.CreateIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex
func (c *Kendra) CreateIndexRequest(input *CreateIndexInput) (req *request.Request, output *CreateIndexOutput) {
	op := &request.Operation{
		Name:       opCreateIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIndexInput{}
	}

	output = &CreateIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIndex API operation for AWSKendraFrontendService.
//
// Creates a new Amazon Kendra index. Index creation is an asynchronous operation.
// To determine if index creation has completed, check the Status field returned
// from a call to DescribeIndex. The Status field is set to ACTIVE when the
// index is ready to use.
//
// Once the index is active you can index your documents using the BatchPutDocument
// operation or using one of the supported data sources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation CreateIndex for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceAlreadyExistException
//
//   * ServiceQuotaExceededException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex
func (c *Kendra) CreateIndex(input *CreateIndexInput) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	return out, req.Send()
}

// CreateIndexWithContext is the same as CreateIndex with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) CreateIndexWithContext(ctx aws.Context, input *CreateIndexInput, opts ...request.Option) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQuerySuggestionsBlockList = "CreateQuerySuggestionsBlockList"

// CreateQuerySuggestionsBlockListRequest generates a "aws/request.Request" representing the
// client's request for the CreateQuerySuggestionsBlockList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQuerySuggestionsBlockList for more information on using the CreateQuerySuggestionsBlockList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateQuerySuggestionsBlockListRequest method.
//    req, resp := client.CreateQuerySuggestionsBlockListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateQuerySuggestionsBlockList
func (c *Kendra) CreateQuerySuggestionsBlockListRequest(input *CreateQuerySuggestionsBlockListInput) (req *request.Request, output *CreateQuerySuggestionsBlockListOutput) {
	op := &request.Operation{
		Name:       opCreateQuerySuggestionsBlockList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateQuerySuggestionsBlockListInput{}
	}

	output = &CreateQuerySuggestionsBlockListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateQuerySuggestionsBlockList API operation for AWSKendraFrontendService.
//
// Creates a block list to exlcude certain queries from suggestions.
//
// Any query that contains words or phrases specified in the block list is blocked
// or filtered out from being shown as a suggestion.
//
// You need to provide the file location of your block list text file in your
// S3 bucket. In your text file, enter each block word or phrase on a separate
// line.
//
// For information on the current quota limits for block lists, see Quotas for
// Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation CreateQuerySuggestionsBlockList for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateQuerySuggestionsBlockList
func (c *Kendra) CreateQuerySuggestionsBlockList(input *CreateQuerySuggestionsBlockListInput) (*CreateQuerySuggestionsBlockListOutput, error) {
	req, out := c.CreateQuerySuggestionsBlockListRequest(input)
	return out, req.Send()
}

// CreateQuerySuggestionsBlockListWithContext is the same as CreateQuerySuggestionsBlockList with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQuerySuggestionsBlockList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) CreateQuerySuggestionsBlockListWithContext(ctx aws.Context, input *CreateQuerySuggestionsBlockListInput, opts ...request.Option) (*CreateQuerySuggestionsBlockListOutput, error) {
	req, out := c.CreateQuerySuggestionsBlockListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThesaurus = "CreateThesaurus"

// CreateThesaurusRequest generates a "aws/request.Request" representing the
// client's request for the CreateThesaurus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThesaurus for more information on using the CreateThesaurus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThesaurusRequest method.
//    req, resp := client.CreateThesaurusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateThesaurus
func (c *Kendra) CreateThesaurusRequest(input *CreateThesaurusInput) (req *request.Request, output *CreateThesaurusOutput) {
	op := &request.Operation{
		Name:       opCreateThesaurus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateThesaurusInput{}
	}

	output = &CreateThesaurusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThesaurus API operation for AWSKendraFrontendService.
//
// Creates a thesaurus for an index. The thesaurus contains a list of synonyms
// in Solr format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation CreateThesaurus for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ServiceQuotaExceededException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateThesaurus
func (c *Kendra) CreateThesaurus(input *CreateThesaurusInput) (*CreateThesaurusOutput, error) {
	req, out := c.CreateThesaurusRequest(input)
	return out, req.Send()
}

// CreateThesaurusWithContext is the same as CreateThesaurus with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThesaurus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) CreateThesaurusWithContext(ctx aws.Context, input *CreateThesaurusInput, opts ...request.Option) (*CreateThesaurusOutput, error) {
	req, out := c.CreateThesaurusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataSourceRequest method.
//    req, resp := client.DeleteDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteDataSource
func (c *Kendra) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataSource API operation for AWSKendraFrontendService.
//
// Deletes an Amazon Kendra data source. An exception is not thrown if the data
// source is already being deleted. While the data source is being deleted,
// the Status field returned by a call to the DescribeDataSource operation is
// set to DELETING. For more information, see Deleting Data Sources (https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteDataSource
func (c *Kendra) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFaq = "DeleteFaq"

// DeleteFaqRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFaq operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFaq for more information on using the DeleteFaq
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFaqRequest method.
//    req, resp := client.DeleteFaqRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq
func (c *Kendra) DeleteFaqRequest(input *DeleteFaqInput) (req *request.Request, output *DeleteFaqOutput) {
	op := &request.Operation{
		Name:       opDeleteFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFaqInput{}
	}

	output = &DeleteFaqOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFaq API operation for AWSKendraFrontendService.
//
// Removes an FAQ from an index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DeleteFaq for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq
func (c *Kendra) DeleteFaq(input *DeleteFaqInput) (*DeleteFaqOutput, error) {
	req, out := c.DeleteFaqRequest(input)
	return out, req.Send()
}

// DeleteFaqWithContext is the same as DeleteFaq with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFaq for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DeleteFaqWithContext(ctx aws.Context, input *DeleteFaqInput, opts ...request.Option) (*DeleteFaqOutput, error) {
	req, out := c.DeleteFaqRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIndex = "DeleteIndex"

// DeleteIndexRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIndex for more information on using the DeleteIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIndexRequest method.
//    req, resp := client.DeleteIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex
func (c *Kendra) DeleteIndexRequest(input *DeleteIndexInput) (req *request.Request, output *DeleteIndexOutput) {
	op := &request.Operation{
		Name:       opDeleteIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIndexInput{}
	}

	output = &DeleteIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIndex API operation for AWSKendraFrontendService.
//
// Deletes an existing Amazon Kendra index. An exception is not thrown if the
// index is already being deleted. While the index is being deleted, the Status
// field returned by a call to the DescribeIndex operation is set to DELETING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DeleteIndex for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex
func (c *Kendra) DeleteIndex(input *DeleteIndexInput) (*DeleteIndexOutput, error) {
	req, out := c.DeleteIndexRequest(input)
	return out, req.Send()
}

// DeleteIndexWithContext is the same as DeleteIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DeleteIndexWithContext(ctx aws.Context, input *DeleteIndexInput, opts ...request.Option) (*DeleteIndexOutput, error) {
	req, out := c.DeleteIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePrincipalMapping = "DeletePrincipalMapping"

// DeletePrincipalMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeletePrincipalMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePrincipalMapping for more information on using the DeletePrincipalMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePrincipalMappingRequest method.
//    req, resp := client.DeletePrincipalMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeletePrincipalMapping
func (c *Kendra) DeletePrincipalMappingRequest(input *DeletePrincipalMappingInput) (req *request.Request, output *DeletePrincipalMappingOutput) {
	op := &request.Operation{
		Name:       opDeletePrincipalMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePrincipalMappingInput{}
	}

	output = &DeletePrincipalMappingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePrincipalMapping API operation for AWSKendraFrontendService.
//
// Deletes a group so that all users and sub groups that belong to the group
// can no longer access documents only available to that group.
//
// For example, after deleting the group "Summer Interns", all interns who belonged
// to that group no longer see intern-only documents in their search results.
//
// If you want to delete or replace users or sub groups of a group, you need
// to use the PutPrincipalMapping operation. For example, if a user in the group
// "Engineering" leaves the engineering team and another user takes their place,
// you provide an updated list of users or sub groups that belong to the "Engineering"
// group when calling PutPrincipalMapping. You can update your internal list
// of users or sub groups and input this list when calling PutPrincipalMapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DeletePrincipalMapping for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeletePrincipalMapping
func (c *Kendra) DeletePrincipalMapping(input *DeletePrincipalMappingInput) (*DeletePrincipalMappingOutput, error) {
	req, out := c.DeletePrincipalMappingRequest(input)
	return out, req.Send()
}

// DeletePrincipalMappingWithContext is the same as DeletePrincipalMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePrincipalMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DeletePrincipalMappingWithContext(ctx aws.Context, input *DeletePrincipalMappingInput, opts ...request.Option) (*DeletePrincipalMappingOutput, error) {
	req, out := c.DeletePrincipalMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQuerySuggestionsBlockList = "DeleteQuerySuggestionsBlockList"

// DeleteQuerySuggestionsBlockListRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQuerySuggestionsBlockList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQuerySuggestionsBlockList for more information on using the DeleteQuerySuggestionsBlockList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteQuerySuggestionsBlockListRequest method.
//    req, resp := client.DeleteQuerySuggestionsBlockListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteQuerySuggestionsBlockList
func (c *Kendra) DeleteQuerySuggestionsBlockListRequest(input *DeleteQuerySuggestionsBlockListInput) (req *request.Request, output *DeleteQuerySuggestionsBlockListOutput) {
	op := &request.Operation{
		Name:       opDeleteQuerySuggestionsBlockList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteQuerySuggestionsBlockListInput{}
	}

	output = &DeleteQuerySuggestionsBlockListOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteQuerySuggestionsBlockList API operation for AWSKendraFrontendService.
//
// Deletes a block list used for query suggestions for an index.
//
// A deleted block list might not take effect right away. Amazon Kendra needs
// to refresh the entire suggestions list to add back the queries that were
// previously blocked.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DeleteQuerySuggestionsBlockList for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteQuerySuggestionsBlockList
func (c *Kendra) DeleteQuerySuggestionsBlockList(input *DeleteQuerySuggestionsBlockListInput) (*DeleteQuerySuggestionsBlockListOutput, error) {
	req, out := c.DeleteQuerySuggestionsBlockListRequest(input)
	return out, req.Send()
}

// DeleteQuerySuggestionsBlockListWithContext is the same as DeleteQuerySuggestionsBlockList with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQuerySuggestionsBlockList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DeleteQuerySuggestionsBlockListWithContext(ctx aws.Context, input *DeleteQuerySuggestionsBlockListInput, opts ...request.Option) (*DeleteQuerySuggestionsBlockListOutput, error) {
	req, out := c.DeleteQuerySuggestionsBlockListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThesaurus = "DeleteThesaurus"

// DeleteThesaurusRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThesaurus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThesaurus for more information on using the DeleteThesaurus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThesaurusRequest method.
//    req, resp := client.DeleteThesaurusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteThesaurus
func (c *Kendra) DeleteThesaurusRequest(input *DeleteThesaurusInput) (req *request.Request, output *DeleteThesaurusOutput) {
	op := &request.Operation{
		Name:       opDeleteThesaurus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteThesaurusInput{}
	}

	output = &DeleteThesaurusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteThesaurus API operation for AWSKendraFrontendService.
//
// Deletes an existing Amazon Kendra thesaurus.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DeleteThesaurus for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteThesaurus
func (c *Kendra) DeleteThesaurus(input *DeleteThesaurusInput) (*DeleteThesaurusOutput, error) {
	req, out := c.DeleteThesaurusRequest(input)
	return out, req.Send()
}

// DeleteThesaurusWithContext is the same as DeleteThesaurus with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThesaurus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DeleteThesaurusWithContext(ctx aws.Context, input *DeleteThesaurusInput, opts ...request.Option) (*DeleteThesaurusOutput, error) {
	req, out := c.DeleteThesaurusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSource = "DescribeDataSource"

// DescribeDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSource for more information on using the DescribeDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSourceRequest method.
//    req, resp := client.DescribeDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource
func (c *Kendra) DescribeDataSourceRequest(input *DescribeDataSourceInput) (req *request.Request, output *DescribeDataSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDataSourceInput{}
	}

	output = &DescribeDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSource API operation for AWSKendraFrontendService.
//
// Gets information about a Amazon Kendra data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeDataSource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource
func (c *Kendra) DescribeDataSource(input *DescribeDataSourceInput) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	return out, req.Send()
}

// DescribeDataSourceWithContext is the same as DescribeDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeDataSourceWithContext(ctx aws.Context, input *DescribeDataSourceInput, opts ...request.Option) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFaq = "DescribeFaq"

// DescribeFaqRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFaq operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFaq for more information on using the DescribeFaq
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFaqRequest method.
//    req, resp := client.DescribeFaqRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq
func (c *Kendra) DescribeFaqRequest(input *DescribeFaqInput) (req *request.Request, output *DescribeFaqOutput) {
	op := &request.Operation{
		Name:       opDescribeFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFaqInput{}
	}

	output = &DescribeFaqOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFaq API operation for AWSKendraFrontendService.
//
// Gets information about an FAQ list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeFaq for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq
func (c *Kendra) DescribeFaq(input *DescribeFaqInput) (*DescribeFaqOutput, error) {
	req, out := c.DescribeFaqRequest(input)
	return out, req.Send()
}

// DescribeFaqWithContext is the same as DescribeFaq with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFaq for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeFaqWithContext(ctx aws.Context, input *DescribeFaqInput, opts ...request.Option) (*DescribeFaqOutput, error) {
	req, out := c.DescribeFaqRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIndex = "DescribeIndex"

// DescribeIndexRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIndex for more information on using the DescribeIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIndexRequest method.
//    req, resp := client.DescribeIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex
func (c *Kendra) DescribeIndexRequest(input *DescribeIndexInput) (req *request.Request, output *DescribeIndexOutput) {
	op := &request.Operation{
		Name:       opDescribeIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIndexInput{}
	}

	output = &DescribeIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIndex API operation for AWSKendraFrontendService.
//
// Describes an existing Amazon Kendra index
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeIndex for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex
func (c *Kendra) DescribeIndex(input *DescribeIndexInput) (*DescribeIndexOutput, error) {
	req, out := c.DescribeIndexRequest(input)
	return out, req.Send()
}

// DescribeIndexWithContext is the same as DescribeIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeIndexWithContext(ctx aws.Context, input *DescribeIndexInput, opts ...request.Option) (*DescribeIndexOutput, error) {
	req, out := c.DescribeIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePrincipalMapping = "DescribePrincipalMapping"

// DescribePrincipalMappingRequest generates a "aws/request.Request" representing the
// client's request for the DescribePrincipalMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePrincipalMapping for more information on using the DescribePrincipalMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePrincipalMappingRequest method.
//    req, resp := client.DescribePrincipalMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribePrincipalMapping
func (c *Kendra) DescribePrincipalMappingRequest(input *DescribePrincipalMappingInput) (req *request.Request, output *DescribePrincipalMappingOutput) {
	op := &request.Operation{
		Name:       opDescribePrincipalMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePrincipalMappingInput{}
	}

	output = &DescribePrincipalMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePrincipalMapping API operation for AWSKendraFrontendService.
//
// Describes the processing of PUT and DELETE actions for mapping users to their
// groups. This includes information on the status of actions currently processing
// or yet to be processed, when actions were last updated, when actions were
// received by Amazon Kendra, the latest action that should process and apply
// after other actions, and useful error messages if an action could not be
// processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribePrincipalMapping for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribePrincipalMapping
func (c *Kendra) DescribePrincipalMapping(input *DescribePrincipalMappingInput) (*DescribePrincipalMappingOutput, error) {
	req, out := c.DescribePrincipalMappingRequest(input)
	return out, req.Send()
}

// DescribePrincipalMappingWithContext is the same as DescribePrincipalMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePrincipalMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribePrincipalMappingWithContext(ctx aws.Context, input *DescribePrincipalMappingInput, opts ...request.Option) (*DescribePrincipalMappingOutput, error) {
	req, out := c.DescribePrincipalMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeQuerySuggestionsBlockList = "DescribeQuerySuggestionsBlockList"

// DescribeQuerySuggestionsBlockListRequest generates a "aws/request.Request" representing the
// client's request for the DescribeQuerySuggestionsBlockList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeQuerySuggestionsBlockList for more information on using the DescribeQuerySuggestionsBlockList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeQuerySuggestionsBlockListRequest method.
//    req, resp := client.DescribeQuerySuggestionsBlockListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsBlockList
func (c *Kendra) DescribeQuerySuggestionsBlockListRequest(input *DescribeQuerySuggestionsBlockListInput) (req *request.Request, output *DescribeQuerySuggestionsBlockListOutput) {
	op := &request.Operation{
		Name:       opDescribeQuerySuggestionsBlockList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeQuerySuggestionsBlockListInput{}
	}

	output = &DescribeQuerySuggestionsBlockListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeQuerySuggestionsBlockList API operation for AWSKendraFrontendService.
//
// Describes a block list used for query suggestions for an index.
//
// This is used to check the current settings that are applied to a block list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeQuerySuggestionsBlockList for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsBlockList
func (c *Kendra) DescribeQuerySuggestionsBlockList(input *DescribeQuerySuggestionsBlockListInput) (*DescribeQuerySuggestionsBlockListOutput, error) {
	req, out := c.DescribeQuerySuggestionsBlockListRequest(input)
	return out, req.Send()
}

// DescribeQuerySuggestionsBlockListWithContext is the same as DescribeQuerySuggestionsBlockList with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeQuerySuggestionsBlockList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeQuerySuggestionsBlockListWithContext(ctx aws.Context, input *DescribeQuerySuggestionsBlockListInput, opts ...request.Option) (*DescribeQuerySuggestionsBlockListOutput, error) {
	req, out := c.DescribeQuerySuggestionsBlockListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeQuerySuggestionsConfig = "DescribeQuerySuggestionsConfig"

// DescribeQuerySuggestionsConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeQuerySuggestionsConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeQuerySuggestionsConfig for more information on using the DescribeQuerySuggestionsConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeQuerySuggestionsConfigRequest method.
//    req, resp := client.DescribeQuerySuggestionsConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsConfig
func (c *Kendra) DescribeQuerySuggestionsConfigRequest(input *DescribeQuerySuggestionsConfigInput) (req *request.Request, output *DescribeQuerySuggestionsConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeQuerySuggestionsConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeQuerySuggestionsConfigInput{}
	}

	output = &DescribeQuerySuggestionsConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeQuerySuggestionsConfig API operation for AWSKendraFrontendService.
//
// Describes the settings of query suggestions for an index.
//
// This is used to check the current settings applied to query suggestions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeQuerySuggestionsConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsConfig
func (c *Kendra) DescribeQuerySuggestionsConfig(input *DescribeQuerySuggestionsConfigInput) (*DescribeQuerySuggestionsConfigOutput, error) {
	req, out := c.DescribeQuerySuggestionsConfigRequest(input)
	return out, req.Send()
}

// DescribeQuerySuggestionsConfigWithContext is the same as DescribeQuerySuggestionsConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeQuerySuggestionsConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeQuerySuggestionsConfigWithContext(ctx aws.Context, input *DescribeQuerySuggestionsConfigInput, opts ...request.Option) (*DescribeQuerySuggestionsConfigOutput, error) {
	req, out := c.DescribeQuerySuggestionsConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThesaurus = "DescribeThesaurus"

// DescribeThesaurusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThesaurus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThesaurus for more information on using the DescribeThesaurus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThesaurusRequest method.
//    req, resp := client.DescribeThesaurusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeThesaurus
func (c *Kendra) DescribeThesaurusRequest(input *DescribeThesaurusInput) (req *request.Request, output *DescribeThesaurusOutput) {
	op := &request.Operation{
		Name:       opDescribeThesaurus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeThesaurusInput{}
	}

	output = &DescribeThesaurusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThesaurus API operation for AWSKendraFrontendService.
//
// Describes an existing Amazon Kendra thesaurus.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeThesaurus for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeThesaurus
func (c *Kendra) DescribeThesaurus(input *DescribeThesaurusInput) (*DescribeThesaurusOutput, error) {
	req, out := c.DescribeThesaurusRequest(input)
	return out, req.Send()
}

// DescribeThesaurusWithContext is the same as DescribeThesaurus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThesaurus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeThesaurusWithContext(ctx aws.Context, input *DescribeThesaurusInput, opts ...request.Option) (*DescribeThesaurusOutput, error) {
	req, out := c.DescribeThesaurusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQuerySuggestions = "GetQuerySuggestions"

// GetQuerySuggestionsRequest generates a "aws/request.Request" representing the
// client's request for the GetQuerySuggestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQuerySuggestions for more information on using the GetQuerySuggestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQuerySuggestionsRequest method.
//    req, resp := client.GetQuerySuggestionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetQuerySuggestions
func (c *Kendra) GetQuerySuggestionsRequest(input *GetQuerySuggestionsInput) (req *request.Request, output *GetQuerySuggestionsOutput) {
	op := &request.Operation{
		Name:       opGetQuerySuggestions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQuerySuggestionsInput{}
	}

	output = &GetQuerySuggestionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQuerySuggestions API operation for AWSKendraFrontendService.
//
// Fetches the queries that are suggested to your users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation GetQuerySuggestions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetQuerySuggestions
func (c *Kendra) GetQuerySuggestions(input *GetQuerySuggestionsInput) (*GetQuerySuggestionsOutput, error) {
	req, out := c.GetQuerySuggestionsRequest(input)
	return out, req.Send()
}

// GetQuerySuggestionsWithContext is the same as GetQuerySuggestions with the addition of
// the ability to pass a context and additional request options.
//
// See GetQuerySuggestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) GetQuerySuggestionsWithContext(ctx aws.Context, input *GetQuerySuggestionsInput, opts ...request.Option) (*GetQuerySuggestionsOutput, error) {
	req, out := c.GetQuerySuggestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataSourceSyncJobs = "ListDataSourceSyncJobs"

// ListDataSourceSyncJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSourceSyncJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSourceSyncJobs for more information on using the ListDataSourceSyncJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSourceSyncJobsRequest method.
//    req, resp := client.ListDataSourceSyncJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs
func (c *Kendra) ListDataSourceSyncJobsRequest(input *ListDataSourceSyncJobsInput) (req *request.Request, output *ListDataSourceSyncJobsOutput) {
	op := &request.Operation{
		Name:       opListDataSourceSyncJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourceSyncJobsInput{}
	}

	output = &ListDataSourceSyncJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSourceSyncJobs API operation for AWSKendraFrontendService.
//
// Gets statistics about synchronizing Amazon Kendra with a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListDataSourceSyncJobs for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs
func (c *Kendra) ListDataSourceSyncJobs(input *ListDataSourceSyncJobsInput) (*ListDataSourceSyncJobsOutput, error) {
	req, out := c.ListDataSourceSyncJobsRequest(input)
	return out, req.Send()
}

// ListDataSourceSyncJobsWithContext is the same as ListDataSourceSyncJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSourceSyncJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListDataSourceSyncJobsWithContext(ctx aws.Context, input *ListDataSourceSyncJobsInput, opts ...request.Option) (*ListDataSourceSyncJobsOutput, error) {
	req, out := c.ListDataSourceSyncJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourceSyncJobsPages iterates over the pages of a ListDataSourceSyncJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSourceSyncJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSourceSyncJobs operation.
//    pageNum := 0
//    err := client.ListDataSourceSyncJobsPages(params,
//        func(page *kendra.ListDataSourceSyncJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kendra) ListDataSourceSyncJobsPages(input *ListDataSourceSyncJobsInput, fn func(*ListDataSourceSyncJobsOutput, bool) bool) error {
	return c.ListDataSourceSyncJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourceSyncJobsPagesWithContext same as ListDataSourceSyncJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListDataSourceSyncJobsPagesWithContext(ctx aws.Context, input *ListDataSourceSyncJobsInput, fn func(*ListDataSourceSyncJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourceSyncJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourceSyncJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourceSyncJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSourcesRequest method.
//    req, resp := client.ListDataSourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources
func (c *Kendra) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for AWSKendraFrontendService.
//
// Lists the data sources that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * AccessDeniedException
//
//   * ThrottlingException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources
func (c *Kendra) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSources operation.
//    pageNum := 0
//    err := client.ListDataSourcesPages(params,
//        func(page *kendra.ListDataSourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kendra) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFaqs = "ListFaqs"

// ListFaqsRequest generates a "aws/request.Request" representing the
// client's request for the ListFaqs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFaqs for more information on using the ListFaqs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFaqsRequest method.
//    req, resp := client.ListFaqsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs
func (c *Kendra) ListFaqsRequest(input *ListFaqsInput) (req *request.Request, output *ListFaqsOutput) {
	op := &request.Operation{
		Name:       opListFaqs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFaqsInput{}
	}

	output = &ListFaqsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFaqs API operation for AWSKendraFrontendService.
//
// Gets a list of FAQ lists associated with an index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListFaqs for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs
func (c *Kendra) ListFaqs(input *ListFaqsInput) (*ListFaqsOutput, error) {
	req, out := c.ListFaqsRequest(input)
	return out, req.Send()
}

// ListFaqsWithContext is the same as ListFaqs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFaqs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListFaqsWithContext(ctx aws.Context, input *ListFaqsInput, opts ...request.Option) (*ListFaqsOutput, error) {
	req, out := c.ListFaqsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupsOlderThanOrderingId = "ListGroupsOlderThanOrderingId"

// ListGroupsOlderThanOrderingIdRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupsOlderThanOrderingId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupsOlderThanOrderingId for more information on using the ListGroupsOlderThanOrderingId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsOlderThanOrderingIdRequest method.
//    req, resp := client.ListGroupsOlderThanOrderingIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId
func (c *Kendra) ListGroupsOlderThanOrderingIdRequest(input *ListGroupsOlderThanOrderingIdInput) (req *request.Request, output *ListGroupsOlderThanOrderingIdOutput) {
	op := &request.Operation{
		Name:       opListGroupsOlderThanOrderingId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGroupsOlderThanOrderingIdInput{}
	}

	output = &ListGroupsOlderThanOrderingIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupsOlderThanOrderingId API operation for AWSKendraFrontendService.
//
// Provides a list of groups that are mapped to users before a given ordering
// or timestamp identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListGroupsOlderThanOrderingId for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * AccessDeniedException
//
//   * ThrottlingException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId
func (c *Kendra) ListGroupsOlderThanOrderingId(input *ListGroupsOlderThanOrderingIdInput) (*ListGroupsOlderThanOrderingIdOutput, error) {
	req, out := c.ListGroupsOlderThanOrderingIdRequest(input)
	return out, req.Send()
}

// ListGroupsOlderThanOrderingIdWithContext is the same as ListGroupsOlderThanOrderingId with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupsOlderThanOrderingId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListGroupsOlderThanOrderingIdWithContext(ctx aws.Context, input *ListGroupsOlderThanOrderingIdInput, opts ...request.Option) (*ListGroupsOlderThanOrderingIdOutput, error) {
	req, out := c.ListGroupsOlderThanOrderingIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIndices = "ListIndices"

// ListIndicesRequest generates a "aws/request.Request" representing the
// client's request for the ListIndices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndices for more information on using the ListIndices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIndicesRequest method.
//    req, resp := client.ListIndicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices
func (c *Kendra) ListIndicesRequest(input *ListIndicesInput) (req *request.Request, output *ListIndicesOutput) {
	op := &request.Operation{
		Name:       opListIndices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIndicesInput{}
	}

	output = &ListIndicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndices API operation for AWSKendraFrontendService.
//
// Lists the Amazon Kendra indexes that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListIndices for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices
func (c *Kendra) ListIndices(input *ListIndicesInput) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	return out, req.Send()
}

// ListIndicesWithContext is the same as ListIndices with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListIndicesWithContext(ctx aws.Context, input *ListIndicesInput, opts ...request.Option) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIndicesPages iterates over the pages of a ListIndices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIndices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIndices operation.
//    pageNum := 0
//    err := client.ListIndicesPages(params,
//        func(page *kendra.ListIndicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kendra) ListIndicesPages(input *ListIndicesInput, fn func(*ListIndicesOutput, bool) bool) error {
	return c.ListIndicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIndicesPagesWithContext same as ListIndicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListIndicesPagesWithContext(ctx aws.Context, input *ListIndicesInput, fn func(*ListIndicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIndicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIndicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIndicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQuerySuggestionsBlockLists = "ListQuerySuggestionsBlockLists"

// ListQuerySuggestionsBlockListsRequest generates a "aws/request.Request" representing the
// client's request for the ListQuerySuggestionsBlockLists operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQuerySuggestionsBlockLists for more information on using the ListQuerySuggestionsBlockLists
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListQuerySuggestionsBlockListsRequest method.
//    req, resp := client.ListQuerySuggestionsBlockListsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists
func (c *Kendra) ListQuerySuggestionsBlockListsRequest(input *ListQuerySuggestionsBlockListsInput) (req *request.Request, output *ListQuerySuggestionsBlockListsOutput) {
	op := &request.Operation{
		Name:       opListQuerySuggestionsBlockLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListQuerySuggestionsBlockListsInput{}
	}

	output = &ListQuerySuggestionsBlockListsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQuerySuggestionsBlockLists API operation for AWSKendraFrontendService.
//
// Lists the block lists used for query suggestions for an index.
//
// For information on the current quota limits for block lists, see Quotas for
// Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListQuerySuggestionsBlockLists for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists
func (c *Kendra) ListQuerySuggestionsBlockLists(input *ListQuerySuggestionsBlockListsInput) (*ListQuerySuggestionsBlockListsOutput, error) {
	req, out := c.ListQuerySuggestionsBlockListsRequest(input)
	return out, req.Send()
}

// ListQuerySuggestionsBlockListsWithContext is the same as ListQuerySuggestionsBlockLists with the addition of
// the ability to pass a context and additional request options.
//
// See ListQuerySuggestionsBlockLists for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListQuerySuggestionsBlockListsWithContext(ctx aws.Context, input *ListQuerySuggestionsBlockListsInput, opts ...request.Option) (*ListQuerySuggestionsBlockListsOutput, error) {
	req, out := c.ListQuerySuggestionsBlockListsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListTagsForResource
func (c *Kendra) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWSKendraFrontendService.
//
// Gets a list of tags associated with a specified resource. Indexes, FAQs,
// and data sources can have tags associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceUnavailableException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListTagsForResource
func (c *Kendra) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThesauri = "ListThesauri"

// ListThesauriRequest generates a "aws/request.Request" representing the
// client's request for the ListThesauri operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThesauri for more information on using the ListThesauri
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThesauriRequest method.
//    req, resp := client.ListThesauriRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri
func (c *Kendra) ListThesauriRequest(input *ListThesauriInput) (req *request.Request, output *ListThesauriOutput) {
	op := &request.Operation{
		Name:       opListThesauri,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListThesauriInput{}
	}

	output = &ListThesauriOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThesauri API operation for AWSKendraFrontendService.
//
// Lists the Amazon Kendra thesauri associated with an index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListThesauri for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri
func (c *Kendra) ListThesauri(input *ListThesauriInput) (*ListThesauriOutput, error) {
	req, out := c.ListThesauriRequest(input)
	return out, req.Send()
}

// ListThesauriWithContext is the same as ListThesauri with the addition of
// the ability to pass a context and additional request options.
//
// See ListThesauri for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListThesauriWithContext(ctx aws.Context, input *ListThesauriInput, opts ...request.Option) (*ListThesauriOutput, error) {
	req, out := c.ListThesauriRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPrincipalMapping = "PutPrincipalMapping"

// PutPrincipalMappingRequest generates a "aws/request.Request" representing the
// client's request for the PutPrincipalMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPrincipalMapping for more information on using the PutPrincipalMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPrincipalMappingRequest method.
//    req, resp := client.PutPrincipalMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/PutPrincipalMapping
func (c *Kendra) PutPrincipalMappingRequest(input *PutPrincipalMappingInput) (req *request.Request, output *PutPrincipalMappingOutput) {
	op := &request.Operation{
		Name:       opPutPrincipalMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPrincipalMappingInput{}
	}

	output = &PutPrincipalMappingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPrincipalMapping API operation for AWSKendraFrontendService.
//
// Maps users to their groups. You can also map sub groups to groups. For example,
// the group "Company Intellectual Property Teams" includes sub groups "Research"
// and "Engineering". These sub groups include their own list of users or people
// who work in these teams. Only users who work in research and engineering,
// and therefore belong in the intellectual property group, can see top-secret
// company documents in their search results.
//
// You map users to their groups when you want to filter search results for
// different users based on their group’s access to documents. For more information
// on filtering search results for different users, see Filtering on user context
// (https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
//
// If more than five PUT actions for a group are currently processing, a validation
// exception is thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation PutPrincipalMapping for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/PutPrincipalMapping
func (c *Kendra) PutPrincipalMapping(input *PutPrincipalMappingInput) (*PutPrincipalMappingOutput, error) {
	req, out := c.PutPrincipalMappingRequest(input)
	return out, req.Send()
}

// PutPrincipalMappingWithContext is the same as PutPrincipalMapping with the addition of
// the ability to pass a context and additional request options.
//
// See PutPrincipalMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) PutPrincipalMappingWithContext(ctx aws.Context, input *PutPrincipalMappingInput, opts ...request.Option) (*PutPrincipalMappingOutput, error) {
	req, out := c.PutPrincipalMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQuery = "Query"

// QueryRequest generates a "aws/request.Request" representing the
// client's request for the Query operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Query for more information on using the Query
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QueryRequest method.
//    req, resp := client.QueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query
func (c *Kendra) QueryRequest(input *QueryInput) (req *request.Request, output *QueryOutput) {
	op := &request.Operation{
		Name:       opQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QueryInput{}
	}

	output = &QueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Query API operation for AWSKendraFrontendService.
//
// Searches an active index. Use this API to search your documents using query.
// The Query operation enables to do faceted search and to filter results based
// on document attributes.
//
// It also enables you to provide user context that Amazon Kendra uses to enforce
// document access control in the search results.
//
// Amazon Kendra searches your index for text content and question and answer
// (FAQ) content. By default the response contains three types of results.
//
//    * Relevant passages
//
//    * Matching FAQs
//
//    * Relevant documents
//
// You can specify that the query return only one type of result using the QueryResultTypeConfig
// parameter.
//
// Each query returns the 100 most relevant results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation Query for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query
func (c *Kendra) Query(input *QueryInput) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	return out, req.Send()
}

// QueryWithContext is the same as Query with the addition of
// the ability to pass a context and additional request options.
//
// See Query for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) QueryWithContext(ctx aws.Context, input *QueryInput, opts ...request.Option) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDataSourceSyncJob = "StartDataSourceSyncJob"

// StartDataSourceSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDataSourceSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDataSourceSyncJob for more information on using the StartDataSourceSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDataSourceSyncJobRequest method.
//    req, resp := client.StartDataSourceSyncJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob
func (c *Kendra) StartDataSourceSyncJobRequest(input *StartDataSourceSyncJobInput) (req *request.Request, output *StartDataSourceSyncJobOutput) {
	op := &request.Operation{
		Name:       opStartDataSourceSyncJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDataSourceSyncJobInput{}
	}

	output = &StartDataSourceSyncJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDataSourceSyncJob API operation for AWSKendraFrontendService.
//
// Starts a synchronization job for a data source. If a synchronization job
// is already in progress, Amazon Kendra returns a ResourceInUseException exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation StartDataSourceSyncJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ResourceInUseException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob
func (c *Kendra) StartDataSourceSyncJob(input *StartDataSourceSyncJobInput) (*StartDataSourceSyncJobOutput, error) {
	req, out := c.StartDataSourceSyncJobRequest(input)
	return out, req.Send()
}

// StartDataSourceSyncJobWithContext is the same as StartDataSourceSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDataSourceSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) StartDataSourceSyncJobWithContext(ctx aws.Context, input *StartDataSourceSyncJobInput, opts ...request.Option) (*StartDataSourceSyncJobOutput, error) {
	req, out := c.StartDataSourceSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDataSourceSyncJob = "StopDataSourceSyncJob"

// StopDataSourceSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the StopDataSourceSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDataSourceSyncJob for more information on using the StopDataSourceSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDataSourceSyncJobRequest method.
//    req, resp := client.StopDataSourceSyncJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob
func (c *Kendra) StopDataSourceSyncJobRequest(input *StopDataSourceSyncJobInput) (req *request.Request, output *StopDataSourceSyncJobOutput) {
	op := &request.Operation{
		Name:       opStopDataSourceSyncJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDataSourceSyncJobInput{}
	}

	output = &StopDataSourceSyncJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopDataSourceSyncJob API operation for AWSKendraFrontendService.
//
// Stops a running synchronization job. You can't stop a scheduled synchronization
// job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation StopDataSourceSyncJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob
func (c *Kendra) StopDataSourceSyncJob(input *StopDataSourceSyncJobInput) (*StopDataSourceSyncJobOutput, error) {
	req, out := c.StopDataSourceSyncJobRequest(input)
	return out, req.Send()
}

// StopDataSourceSyncJobWithContext is the same as StopDataSourceSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopDataSourceSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) StopDataSourceSyncJobWithContext(ctx aws.Context, input *StopDataSourceSyncJobInput, opts ...request.Option) (*StopDataSourceSyncJobOutput, error) {
	req, out := c.StopDataSourceSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitFeedback = "SubmitFeedback"

// SubmitFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the SubmitFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitFeedback for more information on using the SubmitFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SubmitFeedbackRequest method.
//    req, resp := client.SubmitFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback
func (c *Kendra) SubmitFeedbackRequest(input *SubmitFeedbackInput) (req *request.Request, output *SubmitFeedbackOutput) {
	op := &request.Operation{
		Name:       opSubmitFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubmitFeedbackInput{}
	}

	output = &SubmitFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SubmitFeedback API operation for AWSKendraFrontendService.
//
// Enables you to provide feedback to Amazon Kendra to improve the performance
// of your index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation SubmitFeedback for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceUnavailableException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback
func (c *Kendra) SubmitFeedback(input *SubmitFeedbackInput) (*SubmitFeedbackOutput, error) {
	req, out := c.SubmitFeedbackRequest(input)
	return out, req.Send()
}

// SubmitFeedbackWithContext is the same as SubmitFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) SubmitFeedbackWithContext(ctx aws.Context, input *SubmitFeedbackInput, opts ...request.Option) (*SubmitFeedbackOutput, error) {
	req, out := c.SubmitFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/TagResource
func (c *Kendra) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWSKendraFrontendService.
//
// Adds the specified tag to the specified index, FAQ, or data source resource.
// If the tag already exists, the existing value is replaced with the new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceUnavailableException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/TagResource
func (c *Kendra) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UntagResource
func (c *Kendra) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWSKendraFrontendService.
//
// Removes a tag from an index, FAQ, or a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceUnavailableException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UntagResource
func (c *Kendra) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSourceRequest method.
//    req, resp := client.UpdateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource
func (c *Kendra) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataSource API operation for AWSKendraFrontendService.
//
// Updates an existing Amazon Kendra data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource
func (c *Kendra) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIndex = "UpdateIndex"

// UpdateIndexRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIndex for more information on using the UpdateIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIndexRequest method.
//    req, resp := client.UpdateIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex
func (c *Kendra) UpdateIndexRequest(input *UpdateIndexInput) (req *request.Request, output *UpdateIndexOutput) {
	op := &request.Operation{
		Name:       opUpdateIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIndexInput{}
	}

	output = &UpdateIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIndex API operation for AWSKendraFrontendService.
//
// Updates an existing Amazon Kendra index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation UpdateIndex for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex
func (c *Kendra) UpdateIndex(input *UpdateIndexInput) (*UpdateIndexOutput, error) {
	req, out := c.UpdateIndexRequest(input)
	return out, req.Send()
}

// UpdateIndexWithContext is the same as UpdateIndex with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) UpdateIndexWithContext(ctx aws.Context, input *UpdateIndexInput, opts ...request.Option) (*UpdateIndexOutput, error) {
	req, out := c.UpdateIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQuerySuggestionsBlockList = "UpdateQuerySuggestionsBlockList"

// UpdateQuerySuggestionsBlockListRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQuerySuggestionsBlockList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQuerySuggestionsBlockList for more information on using the UpdateQuerySuggestionsBlockList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateQuerySuggestionsBlockListRequest method.
//    req, resp := client.UpdateQuerySuggestionsBlockListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsBlockList
func (c *Kendra) UpdateQuerySuggestionsBlockListRequest(input *UpdateQuerySuggestionsBlockListInput) (req *request.Request, output *UpdateQuerySuggestionsBlockListOutput) {
	op := &request.Operation{
		Name:       opUpdateQuerySuggestionsBlockList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateQuerySuggestionsBlockListInput{}
	}

	output = &UpdateQuerySuggestionsBlockListOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQuerySuggestionsBlockList API operation for AWSKendraFrontendService.
//
// Updates a block list used for query suggestions for an index.
//
// Updates to a block list might not take effect right away. Amazon Kendra needs
// to refresh the entire suggestions list to apply any updates to the block
// list. Other changes not related to the block list apply immediately.
//
// If a block list is updating, then you need to wait for the first update to
// finish before submitting another update.
//
// Amazon Kendra supports partial updates, so you only need to provide the fields
// you want to update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation UpdateQuerySuggestionsBlockList for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsBlockList
func (c *Kendra) UpdateQuerySuggestionsBlockList(input *UpdateQuerySuggestionsBlockListInput) (*UpdateQuerySuggestionsBlockListOutput, error) {
	req, out := c.UpdateQuerySuggestionsBlockListRequest(input)
	return out, req.Send()
}

// UpdateQuerySuggestionsBlockListWithContext is the same as UpdateQuerySuggestionsBlockList with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQuerySuggestionsBlockList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) UpdateQuerySuggestionsBlockListWithContext(ctx aws.Context, input *UpdateQuerySuggestionsBlockListInput, opts ...request.Option) (*UpdateQuerySuggestionsBlockListOutput, error) {
	req, out := c.UpdateQuerySuggestionsBlockListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQuerySuggestionsConfig = "UpdateQuerySuggestionsConfig"

// UpdateQuerySuggestionsConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQuerySuggestionsConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQuerySuggestionsConfig for more information on using the UpdateQuerySuggestionsConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateQuerySuggestionsConfigRequest method.
//    req, resp := client.UpdateQuerySuggestionsConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsConfig
func (c *Kendra) UpdateQuerySuggestionsConfigRequest(input *UpdateQuerySuggestionsConfigInput) (req *request.Request, output *UpdateQuerySuggestionsConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateQuerySuggestionsConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateQuerySuggestionsConfigInput{}
	}

	output = &UpdateQuerySuggestionsConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQuerySuggestionsConfig API operation for AWSKendraFrontendService.
//
// Updates the settings of query suggestions for an index.
//
// Amazon Kendra supports partial updates, so you only need to provide the fields
// you want to update.
//
// If an update is currently processing (i.e. 'happening'), you need to wait
// for the update to finish before making another update.
//
// Updates to query suggestions settings might not take effect right away. The
// time for your updated settings to take effect depends on the updates made
// and the number of search queries in your index.
//
// You can still enable/disable query suggestions at any time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation UpdateQuerySuggestionsConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsConfig
func (c *Kendra) UpdateQuerySuggestionsConfig(input *UpdateQuerySuggestionsConfigInput) (*UpdateQuerySuggestionsConfigOutput, error) {
	req, out := c.UpdateQuerySuggestionsConfigRequest(input)
	return out, req.Send()
}

// UpdateQuerySuggestionsConfigWithContext is the same as UpdateQuerySuggestionsConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQuerySuggestionsConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) UpdateQuerySuggestionsConfigWithContext(ctx aws.Context, input *UpdateQuerySuggestionsConfigInput, opts ...request.Option) (*UpdateQuerySuggestionsConfigOutput, error) {
	req, out := c.UpdateQuerySuggestionsConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThesaurus = "UpdateThesaurus"

// UpdateThesaurusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThesaurus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThesaurus for more information on using the UpdateThesaurus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThesaurusRequest method.
//    req, resp := client.UpdateThesaurusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateThesaurus
func (c *Kendra) UpdateThesaurusRequest(input *UpdateThesaurusInput) (req *request.Request, output *UpdateThesaurusOutput) {
	op := &request.Operation{
		Name:       opUpdateThesaurus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateThesaurusInput{}
	}

	output = &UpdateThesaurusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateThesaurus API operation for AWSKendraFrontendService.
//
// Updates a thesaurus file associated with an index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation UpdateThesaurus for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateThesaurus
func (c *Kendra) UpdateThesaurus(input *UpdateThesaurusInput) (*UpdateThesaurusOutput, error) {
	req, out := c.UpdateThesaurusRequest(input)
	return out, req.Send()
}

// UpdateThesaurusWithContext is the same as UpdateThesaurus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThesaurus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) UpdateThesaurusWithContext(ctx aws.Context, input *UpdateThesaurusInput, opts ...request.Option) (*UpdateThesaurusOutput, error) {
	req, out := c.UpdateThesaurusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access Control List files for the documents in a data source. For the format
// of the file, see Access control for S3 data sources (https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html).
type AccessControlListConfiguration struct {
	_ struct{} `type:"structure"`

	// Path to the Amazon Web Services S3 bucket that contains the ACL files.
	KeyPath *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlListConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlListConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlListConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlListConfiguration"}
	if s.KeyPath != nil && len(*s.KeyPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPath sets the KeyPath field's value.
func (s *AccessControlListConfiguration) SetKeyPath(v string) *AccessControlListConfiguration {
	s.KeyPath = &v
	return s
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about the column that should be used for filtering the
// query response by groups.
type AclConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of groups, separated by semi-colons, that filters a query response
	// based on user context. The document is only returned to users that are in
	// one of the groups specified in the UserContext field of the Query operation.
	//
	// AllowedGroupsColumnName is a required field
	AllowedGroupsColumnName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AclConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AclConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AclConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AclConfiguration"}
	if s.AllowedGroupsColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedGroupsColumnName"))
	}
	if s.AllowedGroupsColumnName != nil && len(*s.AllowedGroupsColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedGroupsColumnName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedGroupsColumnName sets the AllowedGroupsColumnName field's value.
func (s *AclConfiguration) SetAllowedGroupsColumnName(v string) *AclConfiguration {
	s.AllowedGroupsColumnName = &v
	return s
}

// An attribute returned from an index query.
type AdditionalResultAttribute struct {
	_ struct{} `type:"structure"`

	// The key that identifies the attribute.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An object that contains the attribute value.
	//
	// Value is a required field
	Value *AdditionalResultAttributeValue `type:"structure" required:"true"`

	// The data type of the Value property.
	//
	// ValueType is a required field
	ValueType *string `type:"string" required:"true" enum:"AdditionalResultAttributeValueType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalResultAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalResultAttribute) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *AdditionalResultAttribute) SetKey(v string) *AdditionalResultAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AdditionalResultAttribute) SetValue(v *AdditionalResultAttributeValue) *AdditionalResultAttribute {
	s.Value = v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *AdditionalResultAttribute) SetValueType(v string) *AdditionalResultAttribute {
	s.ValueType = &v
	return s
}

// An attribute returned with a document from a search.
type AdditionalResultAttributeValue struct {
	_ struct{} `type:"structure"`

	// The text associated with the attribute and information about the highlight
	// to apply to the text.
	TextWithHighlightsValue *TextWithHighlights `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalResultAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalResultAttributeValue) GoString() string {
	return s.String()
}

// SetTextWithHighlightsValue sets the TextWithHighlightsValue field's value.
func (s *AdditionalResultAttributeValue) SetTextWithHighlightsValue(v *TextWithHighlights) *AdditionalResultAttributeValue {
	s.TextWithHighlightsValue = v
	return s
}

// Provides filtering the query results based on document attributes.
//
// When you use the AndAllFilters or OrAllFilters, filters you can use 2 layers
// under the first attribute filter. For example, you can use:
//
// <AndAllFilters>
//
// <OrAllFilters>
//
// <EqualTo>
//
// If you use more than 2 layers, you receive a ValidationException exception
// with the message "AttributeFilter cannot have a depth of more than 2."
//
// If you use more than 10 attribute filters, you receive a ValidationException
// exception with the message "AttributeFilter cannot have a length of more
// than 10".
type AttributeFilter struct {
	_ struct{} `type:"structure"`

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []*AttributeFilter `type:"list"`

	// Returns true when a document contains all of the specified document attributes.
	// This filter is only applicable to StringListValue metadata.
	ContainsAll *DocumentAttribute `type:"structure"`

	// Returns true when a document contains any of the specified document attributes.
	// This filter is only applicable to StringListValue metadata.
	ContainsAny *DocumentAttribute `type:"structure"`

	// Performs an equals operation on two document attributes.
	EqualsTo *DocumentAttribute `type:"structure"`

	// Performs a greater than operation on two document attributes. Use with a
	// document attribute of type Integer or Long.
	GreaterThan *DocumentAttribute `type:"structure"`

	// Performs a greater or equals than operation on two document attributes. Use
	// with a document attribute of type Integer or Long.
	GreaterThanOrEquals *DocumentAttribute `type:"structure"`

	// Performs a less than operation on two document attributes. Use with a document
	// attribute of type Integer or Long.
	LessThan *DocumentAttribute `type:"structure"`

	// Performs a less than or equals operation on two document attributes. Use
	// with a document attribute of type Integer or Long.
	LessThanOrEquals *DocumentAttribute `type:"structure"`

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter `type:"structure"`

	// Performs a logical OR operation on all supplied filters.
	OrAllFilters []*AttributeFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeFilter"}
	if s.ContainsAll != nil {
		if err := s.ContainsAll.Validate(); err != nil {
			invalidParams.AddNested("ContainsAll", err.(request.ErrInvalidParams))
		}
	}
	if s.ContainsAny != nil {
		if err := s.ContainsAny.Validate(); err != nil {
			invalidParams.AddNested("ContainsAny", err.(request.ErrInvalidParams))
		}
	}
	if s.EqualsTo != nil {
		if err := s.EqualsTo.Validate(); err != nil {
			invalidParams.AddNested("EqualsTo", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThan != nil {
		if err := s.GreaterThan.Validate(); err != nil {
			invalidParams.AddNested("GreaterThan", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThanOrEquals != nil {
		if err := s.GreaterThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("GreaterThanOrEquals", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThan != nil {
		if err := s.LessThan.Validate(); err != nil {
			invalidParams.AddNested("LessThan", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThanOrEquals != nil {
		if err := s.LessThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("LessThanOrEquals", err.(request.ErrInvalidParams))
		}
	}
	if s.NotFilter != nil {
		if err := s.NotFilter.Validate(); err != nil {
			invalidParams.AddNested("NotFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.OrAllFilters != nil {
		for i, v := range s.OrAllFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrAllFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAndAllFilters sets the AndAllFilters field's value.
func (s *AttributeFilter) SetAndAllFilters(v []*AttributeFilter) *AttributeFilter {
	s.AndAllFilters = v
	return s
}

// SetContainsAll sets the ContainsAll field's value.
func (s *AttributeFilter) SetContainsAll(v *DocumentAttribute) *AttributeFilter {
	s.ContainsAll = v
	return s
}

// SetContainsAny sets the ContainsAny field's value.
func (s *AttributeFilter) SetContainsAny(v *DocumentAttribute) *AttributeFilter {
	s.ContainsAny = v
	return s
}

// SetEqualsTo sets the EqualsTo field's value.
func (s *AttributeFilter) SetEqualsTo(v *DocumentAttribute) *AttributeFilter {
	s.EqualsTo = v
	return s
}

// SetGreaterThan sets the GreaterThan field's value.
func (s *AttributeFilter) SetGreaterThan(v *DocumentAttribute) *AttributeFilter {
	s.GreaterThan = v
	return s
}

// SetGreaterThanOrEquals sets the GreaterThanOrEquals field's value.
func (s *AttributeFilter) SetGreaterThanOrEquals(v *DocumentAttribute) *AttributeFilter {
	s.GreaterThanOrEquals = v
	return s
}

// SetLessThan sets the LessThan field's value.
func (s *AttributeFilter) SetLessThan(v *DocumentAttribute) *AttributeFilter {
	s.LessThan = v
	return s
}

// SetLessThanOrEquals sets the LessThanOrEquals field's value.
func (s *AttributeFilter) SetLessThanOrEquals(v *DocumentAttribute) *AttributeFilter {
	s.LessThanOrEquals = v
	return s
}

// SetNotFilter sets the NotFilter field's value.
func (s *AttributeFilter) SetNotFilter(v *AttributeFilter) *AttributeFilter {
	s.NotFilter = v
	return s
}

// SetOrAllFilters sets the OrAllFilters field's value.
func (s *AttributeFilter) SetOrAllFilters(v []*AttributeFilter) *AttributeFilter {
	s.OrAllFilters = v
	return s
}

// Provides the configuration information to connect to websites that require
// user authentication.
type AuthenticationConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of configuration information that's required to connect to and crawl
	// a website host using basic authentication credentials.
	//
	// The list includes the name and port number of the website host.
	BasicAuthentication []*BasicAuthenticationConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthenticationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthenticationConfiguration"}
	if s.BasicAuthentication != nil {
		for i, v := range s.BasicAuthentication {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BasicAuthentication", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasicAuthentication sets the BasicAuthentication field's value.
func (s *AuthenticationConfiguration) SetBasicAuthentication(v []*BasicAuthenticationConfiguration) *AuthenticationConfiguration {
	s.BasicAuthentication = v
	return s
}

// Provides the configuration information to connect to websites that require
// basic user authentication.
type BasicAuthenticationConfiguration struct {
	_ struct{} `type:"structure"`

	// Your secret ARN, which you can create in AWS Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	//
	// You use a secret if basic authentication credentials are required to connect
	// to a website. The secret stores your credentials of user name and password.
	//
	// Credentials is a required field
	Credentials *string `min:"1" type:"string" required:"true"`

	// The name of the website host you want to connect to using authentication
	// credentials.
	//
	// For example, the host name of https://a.example.com/page1.html is "a.example.com".
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// The port number of the website host you want to connect to using authentication
	// credentials.
	//
	// For example, the port for https://a.example.com/page1.html is 443, the standard
	// port for HTTPS.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BasicAuthenticationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BasicAuthenticationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BasicAuthenticationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BasicAuthenticationConfiguration"}
	if s.Credentials == nil {
		invalidParams.Add(request.NewErrParamRequired("Credentials"))
	}
	if s.Credentials != nil && len(*s.Credentials) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Credentials", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentials sets the Credentials field's value.
func (s *BasicAuthenticationConfiguration) SetCredentials(v string) *BasicAuthenticationConfiguration {
	s.Credentials = &v
	return s
}

// SetHost sets the Host field's value.
func (s *BasicAuthenticationConfiguration) SetHost(v string) *BasicAuthenticationConfiguration {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *BasicAuthenticationConfiguration) SetPort(v int64) *BasicAuthenticationConfiguration {
	s.Port = &v
	return s
}

type BatchDeleteDocumentInput struct {
	_ struct{} `type:"structure"`

	// Maps a particular data source sync job to a particular data source.
	DataSourceSyncJobMetricTarget *DataSourceSyncJobMetricTarget `type:"structure"`

	// One or more identifiers for documents to delete from the index.
	//
	// DocumentIdList is a required field
	DocumentIdList []*string `min:"1" type:"list" required:"true"`

	// The identifier of the index that contains the documents to delete.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteDocumentInput"}
	if s.DocumentIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentIdList"))
	}
	if s.DocumentIdList != nil && len(s.DocumentIdList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentIdList", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.DataSourceSyncJobMetricTarget != nil {
		if err := s.DataSourceSyncJobMetricTarget.Validate(); err != nil {
			invalidParams.AddNested("DataSourceSyncJobMetricTarget", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceSyncJobMetricTarget sets the DataSourceSyncJobMetricTarget field's value.
func (s *BatchDeleteDocumentInput) SetDataSourceSyncJobMetricTarget(v *DataSourceSyncJobMetricTarget) *BatchDeleteDocumentInput {
	s.DataSourceSyncJobMetricTarget = v
	return s
}

// SetDocumentIdList sets the DocumentIdList field's value.
func (s *BatchDeleteDocumentInput) SetDocumentIdList(v []*string) *BatchDeleteDocumentInput {
	s.DocumentIdList = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *BatchDeleteDocumentInput) SetIndexId(v string) *BatchDeleteDocumentInput {
	s.IndexId = &v
	return s
}

type BatchDeleteDocumentOutput struct {
	_ struct{} `type:"structure"`

	// A list of documents that could not be removed from the index. Each entry
	// contains an error message that indicates why the document couldn't be removed
	// from the index.
	FailedDocuments []*BatchDeleteDocumentResponseFailedDocument `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentOutput) GoString() string {
	return s.String()
}

// SetFailedDocuments sets the FailedDocuments field's value.
func (s *BatchDeleteDocumentOutput) SetFailedDocuments(v []*BatchDeleteDocumentResponseFailedDocument) *BatchDeleteDocumentOutput {
	s.FailedDocuments = v
	return s
}

// Provides information about documents that could not be removed from an index
// by the BatchDeleteDocument operation.
type BatchDeleteDocumentResponseFailedDocument struct {
	_ struct{} `type:"structure"`

	// The error code for why the document couldn't be removed from the index.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// An explanation for why the document couldn't be removed from the index.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the document that couldn't be removed from the index.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentResponseFailedDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentResponseFailedDocument) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchDeleteDocumentResponseFailedDocument) SetErrorCode(v string) *BatchDeleteDocumentResponseFailedDocument {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchDeleteDocumentResponseFailedDocument) SetErrorMessage(v string) *BatchDeleteDocumentResponseFailedDocument {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *BatchDeleteDocumentResponseFailedDocument) SetId(v string) *BatchDeleteDocumentResponseFailedDocument {
	s.Id = &v
	return s
}

type BatchGetDocumentStatusInput struct {
	_ struct{} `type:"structure"`

	// A list of DocumentInfo objects that identify the documents for which to get
	// the status. You identify the documents by their document ID and optional
	// attributes.
	//
	// DocumentInfoList is a required field
	DocumentInfoList []*DocumentInfo `min:"1" type:"list" required:"true"`

	// The identifier of the index to add documents to. The index ID is returned
	// by the CreateIndex (https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html)
	// operation.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDocumentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDocumentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDocumentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDocumentStatusInput"}
	if s.DocumentInfoList == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentInfoList"))
	}
	if s.DocumentInfoList != nil && len(s.DocumentInfoList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentInfoList", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.DocumentInfoList != nil {
		for i, v := range s.DocumentInfoList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentInfoList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentInfoList sets the DocumentInfoList field's value.
func (s *BatchGetDocumentStatusInput) SetDocumentInfoList(v []*DocumentInfo) *BatchGetDocumentStatusInput {
	s.DocumentInfoList = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *BatchGetDocumentStatusInput) SetIndexId(v string) *BatchGetDocumentStatusInput {
	s.IndexId = &v
	return s
}

type BatchGetDocumentStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of documents. The status indicates if the document is waiting
	// to be indexed, is in the process of indexing, has completed indexing, or
	// failed indexing. If a document failed indexing, the status provides the reason
	// why.
	DocumentStatusList []*Status `type:"list"`

	// A list of documents that Amazon Kendra couldn't get the status for. The list
	// includes the ID of the document and the reason that the status couldn't be
	// found.
	Errors []*BatchGetDocumentStatusResponseError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDocumentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDocumentStatusOutput) GoString() string {
	return s.String()
}

// SetDocumentStatusList sets the DocumentStatusList field's value.
func (s *BatchGetDocumentStatusOutput) SetDocumentStatusList(v []*Status) *BatchGetDocumentStatusOutput {
	s.DocumentStatusList = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetDocumentStatusOutput) SetErrors(v []*BatchGetDocumentStatusResponseError) *BatchGetDocumentStatusOutput {
	s.Errors = v
	return s
}

// Provides a response when the status of a document could not be retrieved.
type BatchGetDocumentStatusResponseError struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the document whose status could not be retrieved.
	DocumentId *string `min:"1" type:"string"`

	// Indicates the source of the error.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// States that the API could not get the status of a document. This could be
	// because the request is not valid or there is a system error.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDocumentStatusResponseError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDocumentStatusResponseError) GoString() string {
	return s.String()
}

// SetDocumentId sets the DocumentId field's value.
func (s *BatchGetDocumentStatusResponseError) SetDocumentId(v string) *BatchGetDocumentStatusResponseError {
	s.DocumentId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetDocumentStatusResponseError) SetErrorCode(v string) *BatchGetDocumentStatusResponseError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetDocumentStatusResponseError) SetErrorMessage(v string) *BatchGetDocumentStatusResponseError {
	s.ErrorMessage = &v
	return s
}

type BatchPutDocumentInput struct {
	_ struct{} `type:"structure"`

	// One or more documents to add to the index.
	//
	// Documents can include custom attributes. For example, 'DataSourceId' and
	// 'DataSourceSyncJobId' are custom attributes that provide information on the
	// synchronization of documents running on a data source. Note, 'DataSourceSyncJobId'
	// could be an optional custom attribute as Amazon Kendra will use the ID of
	// a running sync job.
	//
	// Documents have the following file size limits.
	//
	//    * 5 MB total size for inline documents
	//
	//    * 50 MB total size for files from an S3 bucket
	//
	//    * 5 MB extracted text for any file
	//
	// For more information about file size and transaction per second quotas, see
	// Quotas (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
	//
	// Documents is a required field
	Documents []*Document `min:"1" type:"list" required:"true"`

	// The identifier of the index to add the documents to. You need to create the
	// index first using the CreateIndex operation.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role that is allowed to run the BatchPutDocument
	// operation. For more information, see IAM Roles for Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutDocumentInput"}
	if s.Documents == nil {
		invalidParams.Add(request.NewErrParamRequired("Documents"))
	}
	if s.Documents != nil && len(s.Documents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Documents", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Documents != nil {
		for i, v := range s.Documents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Documents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocuments sets the Documents field's value.
func (s *BatchPutDocumentInput) SetDocuments(v []*Document) *BatchPutDocumentInput {
	s.Documents = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *BatchPutDocumentInput) SetIndexId(v string) *BatchPutDocumentInput {
	s.IndexId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *BatchPutDocumentInput) SetRoleArn(v string) *BatchPutDocumentInput {
	s.RoleArn = &v
	return s
}

type BatchPutDocumentOutput struct {
	_ struct{} `type:"structure"`

	// A list of documents that were not added to the index because the document
	// failed a validation check. Each document contains an error message that indicates
	// why the document couldn't be added to the index.
	//
	// If there was an error adding a document to an index the error is reported
	// in your Amazon Web Services CloudWatch log. For more information, see Monitoring
	// Amazon Kendra with Amazon CloudWatch Logs (https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html)
	FailedDocuments []*BatchPutDocumentResponseFailedDocument `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentOutput) GoString() string {
	return s.String()
}

// SetFailedDocuments sets the FailedDocuments field's value.
func (s *BatchPutDocumentOutput) SetFailedDocuments(v []*BatchPutDocumentResponseFailedDocument) *BatchPutDocumentOutput {
	s.FailedDocuments = v
	return s
}

// Provides information about a document that could not be indexed.
type BatchPutDocumentResponseFailedDocument struct {
	_ struct{} `type:"structure"`

	// The type of error that caused the document to fail to be indexed.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// A description of the reason why the document could not be indexed.
	ErrorMessage *string `min:"1" type:"string"`

	// The unique identifier of the document.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentResponseFailedDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentResponseFailedDocument) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchPutDocumentResponseFailedDocument) SetErrorCode(v string) *BatchPutDocumentResponseFailedDocument {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchPutDocumentResponseFailedDocument) SetErrorMessage(v string) *BatchPutDocumentResponseFailedDocument {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *BatchPutDocumentResponseFailedDocument) SetId(v string) *BatchPutDocumentResponseFailedDocument {
	s.Id = &v
	return s
}

// Specifies capacity units configured for your enterprise edition index. You
// can add and remove capacity units to tune an index to your requirements.
type CapacityUnitsConfiguration struct {
	_ struct{} `type:"structure"`

	// The amount of extra query capacity for an index and GetQuerySuggestions (https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html)
	// capacity.
	//
	// A single extra capacity unit for an index provides 0.1 queries per second
	// or approximately 8,000 queries per day.
	//
	// GetQuerySuggestions capacity is five times the provisioned query capacity
	// for an index, or the base capacity of 2.5 calls per second, whichever is
	// higher. For example, the base capacity for an index is 0.1 queries per second,
	// and GetQuerySuggestions capacity has a base of 2.5 calls per second. If you
	// add another 0.1 queries per second to total 0.2 queries per second for an
	// index, the GetQuerySuggestions capacity is 2.5 calls per second (higher than
	// five times 0.2 queries per second).
	//
	// QueryCapacityUnits is a required field
	QueryCapacityUnits *int64 `type:"integer" required:"true"`

	// The amount of extra storage capacity for an index. A single capacity unit
	// provides 30 GB of storage space or 100,000 documents, whichever is reached
	// first.
	//
	// StorageCapacityUnits is a required field
	StorageCapacityUnits *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityUnitsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityUnitsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityUnitsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityUnitsConfiguration"}
	if s.QueryCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryCapacityUnits"))
	}
	if s.StorageCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageCapacityUnits"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryCapacityUnits sets the QueryCapacityUnits field's value.
func (s *CapacityUnitsConfiguration) SetQueryCapacityUnits(v int64) *CapacityUnitsConfiguration {
	s.QueryCapacityUnits = &v
	return s
}

// SetStorageCapacityUnits sets the StorageCapacityUnits field's value.
func (s *CapacityUnitsConfiguration) SetStorageCapacityUnits(v int64) *CapacityUnitsConfiguration {
	s.StorageCapacityUnits = &v
	return s
}

type ClearQuerySuggestionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index you want to clear query suggestions from.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClearQuerySuggestionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClearQuerySuggestionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClearQuerySuggestionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClearQuerySuggestionsInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *ClearQuerySuggestionsInput) SetIndexId(v string) *ClearQuerySuggestionsInput {
	s.IndexId = &v
	return s
}

type ClearQuerySuggestionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClearQuerySuggestionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClearQuerySuggestionsOutput) GoString() string {
	return s.String()
}

// Gathers information about when a particular result was clicked by a user.
// Your application uses the SubmitFeedback operation to provide click information.
type ClickFeedback struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp of the date and time that the result was clicked.
	//
	// ClickTime is a required field
	ClickTime *time.Time `type:"timestamp" required:"true"`

	// The unique identifier of the search result that was clicked.
	//
	// ResultId is a required field
	ResultId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClickFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClickFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClickFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClickFeedback"}
	if s.ClickTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ClickTime"))
	}
	if s.ResultId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultId"))
	}
	if s.ResultId != nil && len(*s.ResultId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResultId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClickTime sets the ClickTime field's value.
func (s *ClickFeedback) SetClickTime(v time.Time) *ClickFeedback {
	s.ClickTime = &v
	return s
}

// SetResultId sets the ResultId field's value.
func (s *ClickFeedback) SetResultId(v string) *ClickFeedback {
	s.ResultId = &v
	return s
}

// Provides information about how Amazon Kendra should use the columns of a
// database in an index.
type ColumnConfiguration struct {
	_ struct{} `type:"structure"`

	// One to five columns that indicate when a document in the database has changed.
	//
	// ChangeDetectingColumns is a required field
	ChangeDetectingColumns []*string `min:"1" type:"list" required:"true"`

	// The column that contains the contents of the document.
	//
	// DocumentDataColumnName is a required field
	DocumentDataColumnName *string `min:"1" type:"string" required:"true"`

	// The column that provides the document's unique identifier.
	//
	// DocumentIdColumnName is a required field
	DocumentIdColumnName *string `min:"1" type:"string" required:"true"`

	// The column that contains the title of the document.
	DocumentTitleColumnName *string `min:"1" type:"string"`

	// An array of objects that map database column names to the corresponding fields
	// in an index. You must first create the fields in the index using the UpdateIndex
	// operation.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnConfiguration"}
	if s.ChangeDetectingColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeDetectingColumns"))
	}
	if s.ChangeDetectingColumns != nil && len(s.ChangeDetectingColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeDetectingColumns", 1))
	}
	if s.DocumentDataColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentDataColumnName"))
	}
	if s.DocumentDataColumnName != nil && len(*s.DocumentDataColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentDataColumnName", 1))
	}
	if s.DocumentIdColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentIdColumnName"))
	}
	if s.DocumentIdColumnName != nil && len(*s.DocumentIdColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentIdColumnName", 1))
	}
	if s.DocumentTitleColumnName != nil && len(*s.DocumentTitleColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleColumnName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeDetectingColumns sets the ChangeDetectingColumns field's value.
func (s *ColumnConfiguration) SetChangeDetectingColumns(v []*string) *ColumnConfiguration {
	s.ChangeDetectingColumns = v
	return s
}

// SetDocumentDataColumnName sets the DocumentDataColumnName field's value.
func (s *ColumnConfiguration) SetDocumentDataColumnName(v string) *ColumnConfiguration {
	s.DocumentDataColumnName = &v
	return s
}

// SetDocumentIdColumnName sets the DocumentIdColumnName field's value.
func (s *ColumnConfiguration) SetDocumentIdColumnName(v string) *ColumnConfiguration {
	s.DocumentIdColumnName = &v
	return s
}

// SetDocumentTitleColumnName sets the DocumentTitleColumnName field's value.
func (s *ColumnConfiguration) SetDocumentTitleColumnName(v string) *ColumnConfiguration {
	s.DocumentTitleColumnName = &v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *ColumnConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *ColumnConfiguration {
	s.FieldMappings = v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the attachment settings for the Confluence data source. Attachment
// settings are optional, if you don't specify settings attachments, Amazon
// Kendra won't index them.
type ConfluenceAttachmentConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines how attachment metadata fields should be mapped to index fields.
	// Before you can map a field, you must first create an index field with a matching
	// type using the console or the UpdateIndex operation.
	//
	// If you specify the AttachentFieldMappings parameter, you must specify at
	// least one field mapping.
	AttachmentFieldMappings []*ConfluenceAttachmentToIndexFieldMapping `min:"1" type:"list"`

	// Indicates whether Amazon Kendra indexes attachments to the pages and blogs
	// in the Confluence data source.
	CrawlAttachments *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceAttachmentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceAttachmentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceAttachmentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceAttachmentConfiguration"}
	if s.AttachmentFieldMappings != nil && len(s.AttachmentFieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttachmentFieldMappings", 1))
	}
	if s.AttachmentFieldMappings != nil {
		for i, v := range s.AttachmentFieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttachmentFieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentFieldMappings sets the AttachmentFieldMappings field's value.
func (s *ConfluenceAttachmentConfiguration) SetAttachmentFieldMappings(v []*ConfluenceAttachmentToIndexFieldMapping) *ConfluenceAttachmentConfiguration {
	s.AttachmentFieldMappings = v
	return s
}

// SetCrawlAttachments sets the CrawlAttachments field's value.
func (s *ConfluenceAttachmentConfiguration) SetCrawlAttachments(v bool) *ConfluenceAttachmentConfiguration {
	s.CrawlAttachments = &v
	return s
}

// Defines the mapping between a field in the Confluence data source to a Amazon
// Kendra index field.
//
// You must first create the index field using the UpdateIndex operation.
type ConfluenceAttachmentToIndexFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in the data source.
	//
	// You must first create the index field using the UpdateIndex operation.
	DataSourceFieldName *string `type:"string" enum:"ConfluenceAttachmentFieldName"`

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If
	// the field is not a date field, an exception is thrown.
	DateFieldFormat *string `min:"4" type:"string"`

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceAttachmentToIndexFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceAttachmentToIndexFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceAttachmentToIndexFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceAttachmentToIndexFieldMapping"}
	if s.DateFieldFormat != nil && len(*s.DateFieldFormat) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("DateFieldFormat", 4))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceFieldName sets the DataSourceFieldName field's value.
func (s *ConfluenceAttachmentToIndexFieldMapping) SetDataSourceFieldName(v string) *ConfluenceAttachmentToIndexFieldMapping {
	s.DataSourceFieldName = &v
	return s
}

// SetDateFieldFormat sets the DateFieldFormat field's value.
func (s *ConfluenceAttachmentToIndexFieldMapping) SetDateFieldFormat(v string) *ConfluenceAttachmentToIndexFieldMapping {
	s.DateFieldFormat = &v
	return s
}

// SetIndexFieldName sets the IndexFieldName field's value.
func (s *ConfluenceAttachmentToIndexFieldMapping) SetIndexFieldName(v string) *ConfluenceAttachmentToIndexFieldMapping {
	s.IndexFieldName = &v
	return s
}

// Specifies the blog settings for the Confluence data source. Blogs are always
// indexed unless filtered from the index by the ExclusionPatterns or InclusionPatterns
// fields in the ConfluenceConfiguration type.
type ConfluenceBlogConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines how blog metadata fields should be mapped to index fields. Before
	// you can map a field, you must first create an index field with a matching
	// type using the console or the UpdateIndex operation.
	//
	// If you specify the BlogFieldMappings parameter, you must specify at least
	// one field mapping.
	BlogFieldMappings []*ConfluenceBlogToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceBlogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceBlogConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceBlogConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceBlogConfiguration"}
	if s.BlogFieldMappings != nil && len(s.BlogFieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlogFieldMappings", 1))
	}
	if s.BlogFieldMappings != nil {
		for i, v := range s.BlogFieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BlogFieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlogFieldMappings sets the BlogFieldMappings field's value.
func (s *ConfluenceBlogConfiguration) SetBlogFieldMappings(v []*ConfluenceBlogToIndexFieldMapping) *ConfluenceBlogConfiguration {
	s.BlogFieldMappings = v
	return s
}

// Defines the mapping between a blog field in the Confluence data source to
// a Amazon Kendra index field.
//
// You must first create the index field using the UpdateIndex operation.
type ConfluenceBlogToIndexFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in the data source.
	DataSourceFieldName *string `type:"string" enum:"ConfluenceBlogFieldName"`

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If
	// the field is not a date field, an exception is thrown.
	DateFieldFormat *string `min:"4" type:"string"`

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceBlogToIndexFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceBlogToIndexFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceBlogToIndexFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceBlogToIndexFieldMapping"}
	if s.DateFieldFormat != nil && len(*s.DateFieldFormat) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("DateFieldFormat", 4))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceFieldName sets the DataSourceFieldName field's value.
func (s *ConfluenceBlogToIndexFieldMapping) SetDataSourceFieldName(v string) *ConfluenceBlogToIndexFieldMapping {
	s.DataSourceFieldName = &v
	return s
}

// SetDateFieldFormat sets the DateFieldFormat field's value.
func (s *ConfluenceBlogToIndexFieldMapping) SetDateFieldFormat(v string) *ConfluenceBlogToIndexFieldMapping {
	s.DateFieldFormat = &v
	return s
}

// SetIndexFieldName sets the IndexFieldName field's value.
func (s *ConfluenceBlogToIndexFieldMapping) SetIndexFieldName(v string) *ConfluenceBlogToIndexFieldMapping {
	s.IndexFieldName = &v
	return s
}

// Provides configuration information for data sources that connect to Confluence.
type ConfluenceConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies configuration information for indexing attachments to Confluence
	// blogs and pages.
	AttachmentConfiguration *ConfluenceAttachmentConfiguration `type:"structure"`

	// Specifies configuration information for indexing Confluence blogs.
	BlogConfiguration *ConfluenceBlogConfiguration `type:"structure"`

	// A list of regular expression patterns that apply to a URL on the Confluence
	// server. An exclusion pattern can apply to a blog post, a page, a space, or
	// an attachment. Items that match the pattern are excluded from the index.
	// Items that don't match the pattern are included in the index. If a item matches
	// both an exclusion pattern and an inclusion pattern, the item isn't included
	// in the index.
	ExclusionPatterns []*string `type:"list"`

	// A list of regular expression patterns that apply to a URL on the Confluence
	// server. An inclusion pattern can apply to a blog post, a page, a space, or
	// an attachment. Items that match the patterns are included in the index. Items
	// that don't match the pattern are excluded from the index. If an item matches
	// both an inclusion pattern and an exclusion pattern, the item isn't included
	// in the index.
	InclusionPatterns []*string `type:"list"`

	// Specifies configuration information for indexing Confluence pages.
	PageConfiguration *ConfluencePageConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of an Secrets Managersecret that contains
	// the key/value pairs required to connect to your Confluence server. The secret
	// must contain a JSON structure with the following keys:
	//
	//    * username - The user name or email address of a user with administrative
	//    privileges for the Confluence server.
	//
	//    * password - The password associated with the user logging in to the Confluence
	//    server.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The URL of your Confluence instance. Use the full URL of the server. For
	// example, https://server.example.com:port/. You can also use an IP address,
	// for example, https://192.168.1.113/.
	//
	// ServerUrl is a required field
	ServerUrl *string `min:"1" type:"string" required:"true"`

	// Specifies configuration information for indexing Confluence spaces.
	SpaceConfiguration *ConfluenceSpaceConfiguration `type:"structure"`

	// Specifies the version of the Confluence installation that you are connecting
	// to.
	//
	// Version is a required field
	Version *string `type:"string" required:"true" enum:"ConfluenceVersion"`

	// Specifies the information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceConfiguration"}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.ServerUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerUrl"))
	}
	if s.ServerUrl != nil && len(*s.ServerUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerUrl", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.AttachmentConfiguration != nil {
		if err := s.AttachmentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AttachmentConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.BlogConfiguration != nil {
		if err := s.BlogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("BlogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PageConfiguration != nil {
		if err := s.PageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PageConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SpaceConfiguration != nil {
		if err := s.SpaceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SpaceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentConfiguration sets the AttachmentConfiguration field's value.
func (s *ConfluenceConfiguration) SetAttachmentConfiguration(v *ConfluenceAttachmentConfiguration) *ConfluenceConfiguration {
	s.AttachmentConfiguration = v
	return s
}

// SetBlogConfiguration sets the BlogConfiguration field's value.
func (s *ConfluenceConfiguration) SetBlogConfiguration(v *ConfluenceBlogConfiguration) *ConfluenceConfiguration {
	s.BlogConfiguration = v
	return s
}

// SetExclusionPatterns sets the ExclusionPatterns field's value.
func (s *ConfluenceConfiguration) SetExclusionPatterns(v []*string) *ConfluenceConfiguration {
	s.ExclusionPatterns = v
	return s
}

// SetInclusionPatterns sets the InclusionPatterns field's value.
func (s *ConfluenceConfiguration) SetInclusionPatterns(v []*string) *ConfluenceConfiguration {
	s.InclusionPatterns = v
	return s
}

// SetPageConfiguration sets the PageConfiguration field's value.
func (s *ConfluenceConfiguration) SetPageConfiguration(v *ConfluencePageConfiguration) *ConfluenceConfiguration {
	s.PageConfiguration = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ConfluenceConfiguration) SetSecretArn(v string) *ConfluenceConfiguration {
	s.SecretArn = &v
	return s
}

// SetServerUrl sets the ServerUrl field's value.
func (s *ConfluenceConfiguration) SetServerUrl(v string) *ConfluenceConfiguration {
	s.ServerUrl = &v
	return s
}

// SetSpaceConfiguration sets the SpaceConfiguration field's value.
func (s *ConfluenceConfiguration) SetSpaceConfiguration(v *ConfluenceSpaceConfiguration) *ConfluenceConfiguration {
	s.SpaceConfiguration = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ConfluenceConfiguration) SetVersion(v string) *ConfluenceConfiguration {
	s.Version = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *ConfluenceConfiguration) SetVpcConfiguration(v *DataSourceVpcConfiguration) *ConfluenceConfiguration {
	s.VpcConfiguration = v
	return s
}

// Specifies the page settings for the Confluence data source.
type ConfluencePageConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines how page metadata fields should be mapped to index fields. Before
	// you can map a field, you must first create an index field with a matching
	// type using the console or the UpdateIndex operation.
	//
	// If you specify the PageFieldMappings parameter, you must specify at least
	// one field mapping.
	PageFieldMappings []*ConfluencePageToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluencePageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluencePageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluencePageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluencePageConfiguration"}
	if s.PageFieldMappings != nil && len(s.PageFieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PageFieldMappings", 1))
	}
	if s.PageFieldMappings != nil {
		for i, v := range s.PageFieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PageFieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageFieldMappings sets the PageFieldMappings field's value.
func (s *ConfluencePageConfiguration) SetPageFieldMappings(v []*ConfluencePageToIndexFieldMapping) *ConfluencePageConfiguration {
	s.PageFieldMappings = v
	return s
}

// Defines the mapping between a field in the Confluence data source to a Amazon
// Kendra index field.
//
// You must first create the index field using the UpdateIndex operation.
type ConfluencePageToIndexFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in the data source.
	DataSourceFieldName *string `type:"string" enum:"ConfluencePageFieldName"`

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If
	// the field is not a date field, an exception is thrown.
	DateFieldFormat *string `min:"4" type:"string"`

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluencePageToIndexFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluencePageToIndexFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluencePageToIndexFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluencePageToIndexFieldMapping"}
	if s.DateFieldFormat != nil && len(*s.DateFieldFormat) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("DateFieldFormat", 4))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceFieldName sets the DataSourceFieldName field's value.
func (s *ConfluencePageToIndexFieldMapping) SetDataSourceFieldName(v string) *ConfluencePageToIndexFieldMapping {
	s.DataSourceFieldName = &v
	return s
}

// SetDateFieldFormat sets the DateFieldFormat field's value.
func (s *ConfluencePageToIndexFieldMapping) SetDateFieldFormat(v string) *ConfluencePageToIndexFieldMapping {
	s.DateFieldFormat = &v
	return s
}

// SetIndexFieldName sets the IndexFieldName field's value.
func (s *ConfluencePageToIndexFieldMapping) SetIndexFieldName(v string) *ConfluencePageToIndexFieldMapping {
	s.IndexFieldName = &v
	return s
}

// Specifies the configuration for indexing Confluence spaces.
type ConfluenceSpaceConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon Kendra should index archived spaces.
	CrawlArchivedSpaces *bool `type:"boolean"`

	// Specifies whether Amazon Kendra should index personal spaces. Users can add
	// restrictions to items in personal spaces. If personal spaces are indexed,
	// queries without user context information may return restricted items from
	// a personal space in their results. For more information, see Filtering on
	// user context (https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
	CrawlPersonalSpaces *bool `type:"boolean"`

	// A list of space keys of Confluence spaces. If you include a key, the blogs,
	// documents, and attachments in the space are not indexed. If a space is in
	// both the ExcludeSpaces and the IncludeSpaces list, the space is excluded.
	ExcludeSpaces []*string `min:"1" type:"list"`

	// A list of space keys for Confluence spaces. If you include a key, the blogs,
	// documents, and attachments in the space are indexed. Spaces that aren't in
	// the list aren't indexed. A space in the list must exist. Otherwise, Amazon
	// Kendra logs an error when the data source is synchronized. If a space is
	// in both the IncludeSpaces and the ExcludeSpaces list, the space is excluded.
	IncludeSpaces []*string `min:"1" type:"list"`

	// Defines how space metadata fields should be mapped to index fields. Before
	// you can map a field, you must first create an index field with a matching
	// type using the console or the UpdateIndex operation.
	//
	// If you specify the SpaceFieldMappings parameter, you must specify at least
	// one field mapping.
	SpaceFieldMappings []*ConfluenceSpaceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceSpaceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceSpaceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceSpaceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceSpaceConfiguration"}
	if s.ExcludeSpaces != nil && len(s.ExcludeSpaces) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExcludeSpaces", 1))
	}
	if s.IncludeSpaces != nil && len(s.IncludeSpaces) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IncludeSpaces", 1))
	}
	if s.SpaceFieldMappings != nil && len(s.SpaceFieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpaceFieldMappings", 1))
	}
	if s.SpaceFieldMappings != nil {
		for i, v := range s.SpaceFieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SpaceFieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlArchivedSpaces sets the CrawlArchivedSpaces field's value.
func (s *ConfluenceSpaceConfiguration) SetCrawlArchivedSpaces(v bool) *ConfluenceSpaceConfiguration {
	s.CrawlArchivedSpaces = &v
	return s
}

// SetCrawlPersonalSpaces sets the CrawlPersonalSpaces field's value.
func (s *ConfluenceSpaceConfiguration) SetCrawlPersonalSpaces(v bool) *ConfluenceSpaceConfiguration {
	s.CrawlPersonalSpaces = &v
	return s
}

// SetExcludeSpaces sets the ExcludeSpaces field's value.
func (s *ConfluenceSpaceConfiguration) SetExcludeSpaces(v []*string) *ConfluenceSpaceConfiguration {
	s.ExcludeSpaces = v
	return s
}

// SetIncludeSpaces sets the IncludeSpaces field's value.
func (s *ConfluenceSpaceConfiguration) SetIncludeSpaces(v []*string) *ConfluenceSpaceConfiguration {
	s.IncludeSpaces = v
	return s
}

// SetSpaceFieldMappings sets the SpaceFieldMappings field's value.
func (s *ConfluenceSpaceConfiguration) SetSpaceFieldMappings(v []*ConfluenceSpaceToIndexFieldMapping) *ConfluenceSpaceConfiguration {
	s.SpaceFieldMappings = v
	return s
}

// Defines the mapping between a field in the Confluence data source to a Amazon
// Kendra index field.
//
// You must first create the index field using the UpdateIndex operation.
type ConfluenceSpaceToIndexFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in the data source.
	DataSourceFieldName *string `type:"string" enum:"ConfluenceSpaceFieldName"`

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If
	// the field is not a date field, an exception is thrown.
	DateFieldFormat *string `min:"4" type:"string"`

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceSpaceToIndexFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceSpaceToIndexFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceSpaceToIndexFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceSpaceToIndexFieldMapping"}
	if s.DateFieldFormat != nil && len(*s.DateFieldFormat) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("DateFieldFormat", 4))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceFieldName sets the DataSourceFieldName field's value.
func (s *ConfluenceSpaceToIndexFieldMapping) SetDataSourceFieldName(v string) *ConfluenceSpaceToIndexFieldMapping {
	s.DataSourceFieldName = &v
	return s
}

// SetDateFieldFormat sets the DateFieldFormat field's value.
func (s *ConfluenceSpaceToIndexFieldMapping) SetDateFieldFormat(v string) *ConfluenceSpaceToIndexFieldMapping {
	s.DateFieldFormat = &v
	return s
}

// SetIndexFieldName sets the IndexFieldName field's value.
func (s *ConfluenceSpaceToIndexFieldMapping) SetIndexFieldName(v string) *ConfluenceSpaceToIndexFieldMapping {
	s.IndexFieldName = &v
	return s
}

// Provides the information necessary to connect to a database.
type ConnectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the host for the database. Can be either a string (host.subdomain.domain.tld)
	// or an IPv4 or IPv6 address.
	//
	// DatabaseHost is a required field
	DatabaseHost *string `min:"1" type:"string" required:"true"`

	// The name of the database containing the document data.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The port that the database uses for connections.
	//
	// DatabasePort is a required field
	DatabasePort *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of credentials stored in Secrets Manager.
	// The credentials should be a user/password pair. For more information, see
	// Using a Database Data Source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html).
	// For more information about Secrets Manager, see What Is Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// in the Secrets Manager user guide.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The name of the table that contains the document data.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectionConfiguration"}
	if s.DatabaseHost == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseHost"))
	}
	if s.DatabaseHost != nil && len(*s.DatabaseHost) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseHost", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.DatabasePort == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabasePort"))
	}
	if s.DatabasePort != nil && *s.DatabasePort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DatabasePort", 1))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseHost sets the DatabaseHost field's value.
func (s *ConnectionConfiguration) SetDatabaseHost(v string) *ConnectionConfiguration {
	s.DatabaseHost = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ConnectionConfiguration) SetDatabaseName(v string) *ConnectionConfiguration {
	s.DatabaseName = &v
	return s
}

// SetDatabasePort sets the DatabasePort field's value.
func (s *ConnectionConfiguration) SetDatabasePort(v int64) *ConnectionConfiguration {
	s.DatabasePort = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ConnectionConfiguration) SetSecretArn(v string) *ConnectionConfiguration {
	s.SecretArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ConnectionConfiguration) SetTableName(v string) *ConnectionConfiguration {
	s.TableName = &v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// A token that you provide to identify the request to create a data source.
	// Multiple calls to the CreateDataSource operation with the same client token
	// will create only one data source.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The connector configuration information that is required to access the repository.
	//
	// You can't specify the Configuration parameter when the Type parameter is
	// set to CUSTOM. If you do, you receive a ValidationException exception.
	//
	// The Configuration parameter is required for all other data sources.
	Configuration *DataSourceConfiguration `type:"structure"`

	// A description for the data source.
	Description *string `type:"string"`

	// The identifier of the index that should be associated with this data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// A unique name for the data source. A data source name can't be changed without
	// deleting and recreating the data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source. For more information, see IAM Roles for Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	//
	// You can't specify the RoleArn parameter when the Type parameter is set to
	// CUSTOM. If you do, you receive a ValidationException exception.
	//
	// The RoleArn parameter is required for all other data sources.
	RoleArn *string `min:"1" type:"string"`

	// Sets the frequency that Amazon Kendra will check the documents in your repository
	// and update the index. If you don't set a schedule Amazon Kendra will not
	// periodically update the index. You can call the StartDataSourceSyncJob operation
	// to update the index.
	//
	// You can't specify the Schedule parameter when the Type parameter is set to
	// CUSTOM. If you do, you receive a ValidationException exception.
	Schedule *string `type:"string"`

	// A list of key-value pairs that identify the data source. You can use the
	// tags to identify and organize your resources and to control access to resources.
	Tags []*Tag `type:"list"`

	// The type of repository that contains the data source.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataSourceInput) SetClientToken(v string) *CreateDataSourceInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateDataSourceInput) SetConfiguration(v *DataSourceConfiguration) *CreateDataSourceInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSourceInput) SetDescription(v string) *CreateDataSourceInput {
	s.Description = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *CreateDataSourceInput) SetIndexId(v string) *CreateDataSourceInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDataSourceInput) SetRoleArn(v string) *CreateDataSourceInput {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateDataSourceInput) SetSchedule(v string) *CreateDataSourceInput {
	s.Schedule = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSourceInput) SetTags(v []*Tag) *CreateDataSourceInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataSourceInput) SetType(v string) *CreateDataSourceInput {
	s.Type = &v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the data source.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateDataSourceOutput) SetId(v string) *CreateDataSourceOutput {
	s.Id = &v
	return s
}

type CreateFaqInput struct {
	_ struct{} `type:"structure"`

	// A token that you provide to identify the request to create a FAQ. Multiple
	// calls to the CreateFaqRequest operation with the same client token will create
	// only one FAQ.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description of the FAQ.
	Description *string `type:"string"`

	// The format of the input file. You can choose between a basic CSV format,
	// a CSV format that includes customs attributes in a header, and a JSON format
	// that includes custom attributes.
	//
	// The format must match the format of the file stored in the S3 bucket identified
	// in the S3Path parameter.
	//
	// For more information, see Adding questions and answers (https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html).
	FileFormat *string `type:"string" enum:"FaqFileFormat"`

	// The identifier of the index that contains the FAQ.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The name that should be associated with the FAQ.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the S3
	// bucket that contains the FAQs. For more information, see IAM Roles for Amazon
	// Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The S3 location of the FAQ input data.
	//
	// S3Path is a required field
	S3Path *S3Path `type:"structure" required:"true"`

	// A list of key-value pairs that identify the FAQ. You can use the tags to
	// identify and organize your resources and to control access to resources.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFaqInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFaqInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFaqInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFaqInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.S3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Path"))
	}
	if s.S3Path != nil {
		if err := s.S3Path.Validate(); err != nil {
			invalidParams.AddNested("S3Path", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFaqInput) SetClientToken(v string) *CreateFaqInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFaqInput) SetDescription(v string) *CreateFaqInput {
	s.Description = &v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *CreateFaqInput) SetFileFormat(v string) *CreateFaqInput {
	s.FileFormat = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *CreateFaqInput) SetIndexId(v string) *CreateFaqInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFaqInput) SetName(v string) *CreateFaqInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateFaqInput) SetRoleArn(v string) *CreateFaqInput {
	s.RoleArn = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *CreateFaqInput) SetS3Path(v *S3Path) *CreateFaqInput {
	s.S3Path = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFaqInput) SetTags(v []*Tag) *CreateFaqInput {
	s.Tags = v
	return s
}

type CreateFaqOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the FAQ.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFaqOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFaqOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateFaqOutput) SetId(v string) *CreateFaqOutput {
	s.Id = &v
	return s
}

type CreateIndexInput struct {
	_ struct{} `type:"structure"`

	// A token that you provide to identify the request to create an index. Multiple
	// calls to the CreateIndex operation with the same client token will create
	// only one index.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description for the index.
	Description *string `type:"string"`

	// The Amazon Kendra edition to use for the index. Choose DEVELOPER_EDITION
	// for indexes intended for development, testing, or proof of concept. Use ENTERPRISE_EDITION
	// for your production databases. Once you set the edition for an index, it
	// can't be changed.
	//
	// The Edition parameter is optional. If you don't supply a value, the default
	// is ENTERPRISE_EDITION.
	//
	// For more information on quota limits for enterprise and developer editions,
	// see Quotas (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
	Edition *string `type:"string" enum:"IndexEdition"`

	// The name for the new index.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An Identity and Access Management(IAM) role that gives Amazon Kendra permissions
	// to access your Amazon CloudWatch logs and metrics. This is also the role
	// used when you use the BatchPutDocument operation to index documents from
	// an Amazon S3 bucket.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The identifier of the KMScustomer managed key (CMK) to use to encrypt data
	// indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`

	// A list of key-value pairs that identify the index. You can use the tags to
	// identify and organize your resources and to control access to resources.
	Tags []*Tag `type:"list"`

	// The user context policy.
	//
	// ATTRIBUTE_FILTER
	//
	// All indexed content is searchable and displayable for all users. If there
	// is an access control list, it is ignored. You can filter on user and group
	// attributes.
	//
	// USER_TOKEN
	//
	// Enables SSO and token-based user access control. All documents with no access
	// control and all documents accessible to the user will be searchable and displayable.
	UserContextPolicy *string `type:"string" enum:"UserContextPolicy"`

	// The user token configuration.
	UserTokenConfigurations []*UserTokenConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIndexInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserTokenConfigurations != nil {
		for i, v := range s.UserTokenConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserTokenConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIndexInput) SetClientToken(v string) *CreateIndexInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIndexInput) SetDescription(v string) *CreateIndexInput {
	s.Description = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *CreateIndexInput) SetEdition(v string) *CreateIndexInput {
	s.Edition = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIndexInput) SetName(v string) *CreateIndexInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateIndexInput) SetRoleArn(v string) *CreateIndexInput {
	s.RoleArn = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *CreateIndexInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *CreateIndexInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIndexInput) SetTags(v []*Tag) *CreateIndexInput {
	s.Tags = v
	return s
}

// SetUserContextPolicy sets the UserContextPolicy field's value.
func (s *CreateIndexInput) SetUserContextPolicy(v string) *CreateIndexInput {
	s.UserContextPolicy = &v
	return s
}

// SetUserTokenConfigurations sets the UserTokenConfigurations field's value.
func (s *CreateIndexInput) SetUserTokenConfigurations(v []*UserTokenConfiguration) *CreateIndexInput {
	s.UserTokenConfigurations = v
	return s
}

type CreateIndexOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the index. Use this identifier when you query an
	// index, set up a data source, or index a document.
	Id *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateIndexOutput) SetId(v string) *CreateIndexOutput {
	s.Id = &v
	return s
}

type CreateQuerySuggestionsBlockListInput struct {
	_ struct{} `type:"structure"`

	// A token that you provide to identify the request to create a query suggestions
	// block list.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A user-friendly description for the block list.
	//
	// For example, the description "List of all offensive words that can appear
	// in user queries and need to be blocked from suggestions."
	Description *string `type:"string"`

	// The identifier of the index you want to create a query suggestions block
	// list for.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// A user friendly name for the block list.
	//
	// For example, the block list named 'offensive-words' includes all offensive
	// words that could appear in user queries and need to be blocked from suggestions.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The IAM (Identity and Access Management) role used by Amazon Kendra to access
	// the block list text file in your S3 bucket.
	//
	// You need permissions to the role ARN (Amazon Resource Name). The role needs
	// S3 read permissions to your file in S3 and needs to give STS (Security Token
	// Service) assume role permissions to Amazon Kendra.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The S3 path to your block list text file in your S3 bucket.
	//
	// Each block word or phrase should be on a separate line in a text file.
	//
	// For information on the current quota limits for block lists, see Quotas for
	// Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
	//
	// SourceS3Path is a required field
	SourceS3Path *S3Path `type:"structure" required:"true"`

	// A tag that you can assign to a block list that categorizes the block list.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQuerySuggestionsBlockListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQuerySuggestionsBlockListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQuerySuggestionsBlockListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQuerySuggestionsBlockListInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.SourceS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceS3Path"))
	}
	if s.SourceS3Path != nil {
		if err := s.SourceS3Path.Validate(); err != nil {
			invalidParams.AddNested("SourceS3Path", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateQuerySuggestionsBlockListInput) SetClientToken(v string) *CreateQuerySuggestionsBlockListInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateQuerySuggestionsBlockListInput) SetDescription(v string) *CreateQuerySuggestionsBlockListInput {
	s.Description = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *CreateQuerySuggestionsBlockListInput) SetIndexId(v string) *CreateQuerySuggestionsBlockListInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateQuerySuggestionsBlockListInput) SetName(v string) *CreateQuerySuggestionsBlockListInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateQuerySuggestionsBlockListInput) SetRoleArn(v string) *CreateQuerySuggestionsBlockListInput {
	s.RoleArn = &v
	return s
}

// SetSourceS3Path sets the SourceS3Path field's value.
func (s *CreateQuerySuggestionsBlockListInput) SetSourceS3Path(v *S3Path) *CreateQuerySuggestionsBlockListInput {
	s.SourceS3Path = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateQuerySuggestionsBlockListInput) SetTags(v []*Tag) *CreateQuerySuggestionsBlockListInput {
	s.Tags = v
	return s
}

type CreateQuerySuggestionsBlockListOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the created block list.
	Id *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQuerySuggestionsBlockListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQuerySuggestionsBlockListOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateQuerySuggestionsBlockListOutput) SetId(v string) *CreateQuerySuggestionsBlockListOutput {
	s.Id = &v
	return s
}

type CreateThesaurusInput struct {
	_ struct{} `type:"structure"`

	// A token that you provide to identify the request to create a thesaurus. Multiple
	// calls to the CreateThesaurus operation with the same client token will create
	// only one index.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description for the new thesaurus.
	Description *string `type:"string"`

	// The unique identifier of the index for the new thesaurus.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The name for the new thesaurus.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An AWS Identity and Access Management (IAM) role that gives Amazon Kendra
	// permissions to access thesaurus file specified in SourceS3Path.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The thesaurus file Amazon S3 source path.
	//
	// SourceS3Path is a required field
	SourceS3Path *S3Path `type:"structure" required:"true"`

	// A list of key-value pairs that identify the thesaurus. You can use the tags
	// to identify and organize your resources and to control access to resources.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThesaurusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThesaurusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThesaurusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThesaurusInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.SourceS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceS3Path"))
	}
	if s.SourceS3Path != nil {
		if err := s.SourceS3Path.Validate(); err != nil {
			invalidParams.AddNested("SourceS3Path", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateThesaurusInput) SetClientToken(v string) *CreateThesaurusInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateThesaurusInput) SetDescription(v string) *CreateThesaurusInput {
	s.Description = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *CreateThesaurusInput) SetIndexId(v string) *CreateThesaurusInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateThesaurusInput) SetName(v string) *CreateThesaurusInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateThesaurusInput) SetRoleArn(v string) *CreateThesaurusInput {
	s.RoleArn = &v
	return s
}

// SetSourceS3Path sets the SourceS3Path field's value.
func (s *CreateThesaurusInput) SetSourceS3Path(v *S3Path) *CreateThesaurusInput {
	s.SourceS3Path = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateThesaurusInput) SetTags(v []*Tag) *CreateThesaurusInput {
	s.Tags = v
	return s
}

type CreateThesaurusOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the thesaurus.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThesaurusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThesaurusOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateThesaurusOutput) SetId(v string) *CreateThesaurusOutput {
	s.Id = &v
	return s
}

// Configuration information for a Amazon Kendra data source.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides configuration information for connecting to a Confluence data source.
	ConfluenceConfiguration *ConfluenceConfiguration `type:"structure"`

	// Provides information necessary to create a data source connector for a database.
	DatabaseConfiguration *DatabaseConfiguration `type:"structure"`

	// Provides configuration for data sources that connect to Google Drive.
	GoogleDriveConfiguration *GoogleDriveConfiguration `type:"structure"`

	// Provides configuration for data sources that connect to Microsoft OneDrive.
	OneDriveConfiguration *OneDriveConfiguration `type:"structure"`

	// Provides information to create a data source connector for a document repository
	// in an Amazon S3 bucket.
	S3Configuration *S3DataSourceConfiguration `type:"structure"`

	// Provides configuration information for data sources that connect to a Salesforce
	// site.
	SalesforceConfiguration *SalesforceConfiguration `type:"structure"`

	// Provides configuration for data sources that connect to ServiceNow instances.
	ServiceNowConfiguration *ServiceNowConfiguration `type:"structure"`

	// Provides information necessary to create a data source connector for a Microsoft
	// SharePoint site.
	SharePointConfiguration *SharePointConfiguration `type:"structure"`

	// Provides the configuration information required for Amazon Kendra web crawler.
	WebCrawlerConfiguration *WebCrawlerConfiguration `type:"structure"`

	// Provides the configuration information to connect to WorkDocs as your data
	// source.
	WorkDocsConfiguration *WorkDocsConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfiguration"}
	if s.ConfluenceConfiguration != nil {
		if err := s.ConfluenceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ConfluenceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DatabaseConfiguration != nil {
		if err := s.DatabaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DatabaseConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.GoogleDriveConfiguration != nil {
		if err := s.GoogleDriveConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GoogleDriveConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OneDriveConfiguration != nil {
		if err := s.OneDriveConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OneDriveConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.SalesforceConfiguration != nil {
		if err := s.SalesforceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SalesforceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceNowConfiguration != nil {
		if err := s.ServiceNowConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServiceNowConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SharePointConfiguration != nil {
		if err := s.SharePointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SharePointConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.WebCrawlerConfiguration != nil {
		if err := s.WebCrawlerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WebCrawlerConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.WorkDocsConfiguration != nil {
		if err := s.WorkDocsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WorkDocsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfluenceConfiguration sets the ConfluenceConfiguration field's value.
func (s *DataSourceConfiguration) SetConfluenceConfiguration(v *ConfluenceConfiguration) *DataSourceConfiguration {
	s.ConfluenceConfiguration = v
	return s
}

// SetDatabaseConfiguration sets the DatabaseConfiguration field's value.
func (s *DataSourceConfiguration) SetDatabaseConfiguration(v *DatabaseConfiguration) *DataSourceConfiguration {
	s.DatabaseConfiguration = v
	return s
}

// SetGoogleDriveConfiguration sets the GoogleDriveConfiguration field's value.
func (s *DataSourceConfiguration) SetGoogleDriveConfiguration(v *GoogleDriveConfiguration) *DataSourceConfiguration {
	s.GoogleDriveConfiguration = v
	return s
}

// SetOneDriveConfiguration sets the OneDriveConfiguration field's value.
func (s *DataSourceConfiguration) SetOneDriveConfiguration(v *OneDriveConfiguration) *DataSourceConfiguration {
	s.OneDriveConfiguration = v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *DataSourceConfiguration) SetS3Configuration(v *S3DataSourceConfiguration) *DataSourceConfiguration {
	s.S3Configuration = v
	return s
}

// SetSalesforceConfiguration sets the SalesforceConfiguration field's value.
func (s *DataSourceConfiguration) SetSalesforceConfiguration(v *SalesforceConfiguration) *DataSourceConfiguration {
	s.SalesforceConfiguration = v
	return s
}

// SetServiceNowConfiguration sets the ServiceNowConfiguration field's value.
func (s *DataSourceConfiguration) SetServiceNowConfiguration(v *ServiceNowConfiguration) *DataSourceConfiguration {
	s.ServiceNowConfiguration = v
	return s
}

// SetSharePointConfiguration sets the SharePointConfiguration field's value.
func (s *DataSourceConfiguration) SetSharePointConfiguration(v *SharePointConfiguration) *DataSourceConfiguration {
	s.SharePointConfiguration = v
	return s
}

// SetWebCrawlerConfiguration sets the WebCrawlerConfiguration field's value.
func (s *DataSourceConfiguration) SetWebCrawlerConfiguration(v *WebCrawlerConfiguration) *DataSourceConfiguration {
	s.WebCrawlerConfiguration = v
	return s
}

// SetWorkDocsConfiguration sets the WorkDocsConfiguration field's value.
func (s *DataSourceConfiguration) SetWorkDocsConfiguration(v *WorkDocsConfiguration) *DataSourceConfiguration {
	s.WorkDocsConfiguration = v
	return s
}

// Data source information for user context filtering.
type DataSourceGroup struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source group you want to add to your list of data
	// source groups. This is for filtering search results based on the groups'
	// access to documents in that data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`

	// The identifier of the group you want to add to your list of groups. This
	// is for filtering search results based on the groups' access to documents.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceGroup"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSourceGroup) SetDataSourceId(v string) *DataSourceGroup {
	s.DataSourceId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *DataSourceGroup) SetGroupId(v string) *DataSourceGroup {
	s.GroupId = &v
	return s
}

// Summary information for a Amazon Kendra data source. Returned in a call to
// the DescribeDataSource operation.
type DataSourceSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime that the data source was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The unique identifier for the data source.
	Id *string `min:"1" type:"string"`

	// The name of the data source.
	Name *string `min:"1" type:"string"`

	// The status of the data source. When the status is ACTIVE the data source
	// is ready to use.
	Status *string `type:"string" enum:"DataSourceStatus"`

	// The type of the data source.
	Type *string `type:"string" enum:"DataSourceType"`

	// The UNIX datetime that the data source was lasted updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSourceSummary) SetCreatedAt(v time.Time) *DataSourceSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *DataSourceSummary) SetId(v string) *DataSourceSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSourceSummary) SetName(v string) *DataSourceSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceSummary) SetStatus(v string) *DataSourceSummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSourceSummary) SetType(v string) *DataSourceSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSourceSummary) SetUpdatedAt(v time.Time) *DataSourceSummary {
	s.UpdatedAt = &v
	return s
}

// Provides information about a synchronization job.
type DataSourceSyncJob struct {
	_ struct{} `type:"structure"`

	// If the reason that the synchronization failed is due to an error with the
	// underlying data source, this field contains a code that identifies the error.
	DataSourceErrorCode *string `min:"1" type:"string"`

	// The UNIX datetime that the synchronization job was completed.
	EndTime *time.Time `type:"timestamp"`

	// If the Status field is set to FAILED, the ErrorCode field contains a the
	// reason that the synchronization failed.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// If the Status field is set to ERROR, the ErrorMessage field contains a description
	// of the error that caused the synchronization to fail.
	ErrorMessage *string `min:"1" type:"string"`

	// A unique identifier for the synchronization job.
	ExecutionId *string `min:"1" type:"string"`

	// Maps a batch delete document request to a specific data source sync job.
	// This is optional and should only be supplied when documents are deleted by
	// a data source connector.
	Metrics *DataSourceSyncJobMetrics `type:"structure"`

	// The UNIX datetime that the synchronization job was started.
	StartTime *time.Time `type:"timestamp"`

	// The execution status of the synchronization job. When the Status field is
	// set to SUCCEEDED, the synchronization job is done. If the status code is
	// set to FAILED, the ErrorCode and ErrorMessage fields give you the reason
	// for the failure.
	Status *string `type:"string" enum:"DataSourceSyncJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJob) GoString() string {
	return s.String()
}

// SetDataSourceErrorCode sets the DataSourceErrorCode field's value.
func (s *DataSourceSyncJob) SetDataSourceErrorCode(v string) *DataSourceSyncJob {
	s.DataSourceErrorCode = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DataSourceSyncJob) SetEndTime(v time.Time) *DataSourceSyncJob {
	s.EndTime = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *DataSourceSyncJob) SetErrorCode(v string) *DataSourceSyncJob {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DataSourceSyncJob) SetErrorMessage(v string) *DataSourceSyncJob {
	s.ErrorMessage = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *DataSourceSyncJob) SetExecutionId(v string) *DataSourceSyncJob {
	s.ExecutionId = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *DataSourceSyncJob) SetMetrics(v *DataSourceSyncJobMetrics) *DataSourceSyncJob {
	s.Metrics = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DataSourceSyncJob) SetStartTime(v time.Time) *DataSourceSyncJob {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceSyncJob) SetStatus(v string) *DataSourceSyncJob {
	s.Status = &v
	return s
}

// Maps a particular data source sync job to a particular data source.
type DataSourceSyncJobMetricTarget struct {
	_ struct{} `type:"structure"`

	// The ID of the data source that is running the sync job.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`

	// The ID of the sync job that is running on the data source.
	//
	// If the ID of a sync job is not provided and there is a sync job running,
	// then the ID of this sync job is used and metrics are generated for this sync
	// job.
	//
	// If the ID of a sync job is not provided and there is no sync job running,
	// then no metrics are generated and documents are indexed/deleted at the index
	// level without sync job metrics included.
	DataSourceSyncJobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJobMetricTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJobMetricTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceSyncJobMetricTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceSyncJobMetricTarget"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.DataSourceSyncJobId != nil && len(*s.DataSourceSyncJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceSyncJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSourceSyncJobMetricTarget) SetDataSourceId(v string) *DataSourceSyncJobMetricTarget {
	s.DataSourceId = &v
	return s
}

// SetDataSourceSyncJobId sets the DataSourceSyncJobId field's value.
func (s *DataSourceSyncJobMetricTarget) SetDataSourceSyncJobId(v string) *DataSourceSyncJobMetricTarget {
	s.DataSourceSyncJobId = &v
	return s
}

// Maps a batch delete document request to a specific data source sync job.
// This is optional and should only be supplied when documents are deleted by
// a data source connector.
type DataSourceSyncJobMetrics struct {
	_ struct{} `type:"structure"`

	// The number of documents added from the data source up to now in the data
	// source sync.
	DocumentsAdded *string `type:"string"`

	// The number of documents deleted from the data source up to now in the data
	// source sync run.
	DocumentsDeleted *string `type:"string"`

	// The number of documents that failed to sync from the data source up to now
	// in the data source sync run.
	DocumentsFailed *string `type:"string"`

	// The number of documents modified in the data source up to now in the data
	// source sync run.
	DocumentsModified *string `type:"string"`

	// The current number of documents crawled by the current sync job in the data
	// source.
	DocumentsScanned *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJobMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJobMetrics) GoString() string {
	return s.String()
}

// SetDocumentsAdded sets the DocumentsAdded field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsAdded(v string) *DataSourceSyncJobMetrics {
	s.DocumentsAdded = &v
	return s
}

// SetDocumentsDeleted sets the DocumentsDeleted field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsDeleted(v string) *DataSourceSyncJobMetrics {
	s.DocumentsDeleted = &v
	return s
}

// SetDocumentsFailed sets the DocumentsFailed field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsFailed(v string) *DataSourceSyncJobMetrics {
	s.DocumentsFailed = &v
	return s
}

// SetDocumentsModified sets the DocumentsModified field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsModified(v string) *DataSourceSyncJobMetrics {
	s.DocumentsModified = &v
	return s
}

// SetDocumentsScanned sets the DocumentsScanned field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsScanned(v string) *DataSourceSyncJobMetrics {
	s.DocumentsScanned = &v
	return s
}

// Maps a column or attribute in the data source to an index field. You must
// first create the fields in the index using the UpdateIndex operation.
type DataSourceToIndexFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the column or attribute in the data source.
	//
	// DataSourceFieldName is a required field
	DataSourceFieldName *string `min:"1" type:"string" required:"true"`

	// The type of data stored in the column or attribute.
	DateFieldFormat *string `min:"4" type:"string"`

	// The name of the field in the index.
	//
	// IndexFieldName is a required field
	IndexFieldName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceToIndexFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceToIndexFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceToIndexFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceToIndexFieldMapping"}
	if s.DataSourceFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceFieldName"))
	}
	if s.DataSourceFieldName != nil && len(*s.DataSourceFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceFieldName", 1))
	}
	if s.DateFieldFormat != nil && len(*s.DateFieldFormat) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("DateFieldFormat", 4))
	}
	if s.IndexFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexFieldName"))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceFieldName sets the DataSourceFieldName field's value.
func (s *DataSourceToIndexFieldMapping) SetDataSourceFieldName(v string) *DataSourceToIndexFieldMapping {
	s.DataSourceFieldName = &v
	return s
}

// SetDateFieldFormat sets the DateFieldFormat field's value.
func (s *DataSourceToIndexFieldMapping) SetDateFieldFormat(v string) *DataSourceToIndexFieldMapping {
	s.DateFieldFormat = &v
	return s
}

// SetIndexFieldName sets the IndexFieldName field's value.
func (s *DataSourceToIndexFieldMapping) SetIndexFieldName(v string) *DataSourceToIndexFieldMapping {
	s.IndexFieldName = &v
	return s
}

// Provides information for connecting to an Amazon VPC.
type DataSourceVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of identifiers of security groups within your Amazon VPC. The security
	// groups should enable Amazon Kendra to connect to the data source.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`

	// A list of identifiers for subnets within your Amazon VPC. The subnets should
	// be able to connect to each other in the VPC, and they should have outgoing
	// access to the Internet through a NAT device.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceVpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceVpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceVpcConfiguration"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *DataSourceVpcConfiguration) SetSecurityGroupIds(v []*string) *DataSourceVpcConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DataSourceVpcConfiguration) SetSubnetIds(v []*string) *DataSourceVpcConfiguration {
	s.SubnetIds = v
	return s
}

// Provides the information necessary to connect a database to an index.
type DatabaseConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about the database column that provides information for user
	// context filtering.
	AclConfiguration *AclConfiguration `type:"structure"`

	// Information about where the index should get the document information from
	// the database.
	//
	// ColumnConfiguration is a required field
	ColumnConfiguration *ColumnConfiguration `type:"structure" required:"true"`

	// The information necessary to connect to a database.
	//
	// ConnectionConfiguration is a required field
	ConnectionConfiguration *ConnectionConfiguration `type:"structure" required:"true"`

	// The type of database engine that runs the database.
	//
	// DatabaseEngineType is a required field
	DatabaseEngineType *string `type:"string" required:"true" enum:"DatabaseEngineType"`

	// Provides information about how Amazon Kendra uses quote marks around SQL
	// identifiers when querying a database data source.
	SqlConfiguration *SqlConfiguration `type:"structure"`

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseConfiguration"}
	if s.ColumnConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnConfiguration"))
	}
	if s.ConnectionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionConfiguration"))
	}
	if s.DatabaseEngineType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseEngineType"))
	}
	if s.AclConfiguration != nil {
		if err := s.AclConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AclConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ColumnConfiguration != nil {
		if err := s.ColumnConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ColumnConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ConnectionConfiguration != nil {
		if err := s.ConnectionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ConnectionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAclConfiguration sets the AclConfiguration field's value.
func (s *DatabaseConfiguration) SetAclConfiguration(v *AclConfiguration) *DatabaseConfiguration {
	s.AclConfiguration = v
	return s
}

// SetColumnConfiguration sets the ColumnConfiguration field's value.
func (s *DatabaseConfiguration) SetColumnConfiguration(v *ColumnConfiguration) *DatabaseConfiguration {
	s.ColumnConfiguration = v
	return s
}

// SetConnectionConfiguration sets the ConnectionConfiguration field's value.
func (s *DatabaseConfiguration) SetConnectionConfiguration(v *ConnectionConfiguration) *DatabaseConfiguration {
	s.ConnectionConfiguration = v
	return s
}

// SetDatabaseEngineType sets the DatabaseEngineType field's value.
func (s *DatabaseConfiguration) SetDatabaseEngineType(v string) *DatabaseConfiguration {
	s.DatabaseEngineType = &v
	return s
}

// SetSqlConfiguration sets the SqlConfiguration field's value.
func (s *DatabaseConfiguration) SetSqlConfiguration(v *SqlConfiguration) *DatabaseConfiguration {
	s.SqlConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *DatabaseConfiguration) SetVpcConfiguration(v *DataSourceVpcConfiguration) *DatabaseConfiguration {
	s.VpcConfiguration = v
	return s
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source to delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the index associated with the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteDataSourceInput) SetId(v string) *DeleteDataSourceInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeleteDataSourceInput) SetIndexId(v string) *DeleteDataSourceInput {
	s.IndexId = &v
	return s
}

type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

type DeleteFaqInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the FAQ to remove.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The index to remove the FAQ from.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFaqInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFaqInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFaqInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFaqInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteFaqInput) SetId(v string) *DeleteFaqInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeleteFaqInput) SetIndexId(v string) *DeleteFaqInput {
	s.IndexId = &v
	return s
}

type DeleteFaqOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFaqOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFaqOutput) GoString() string {
	return s.String()
}

type DeleteIndexInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index to delete.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIndexInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteIndexInput) SetId(v string) *DeleteIndexInput {
	s.Id = &v
	return s
}

type DeleteIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexOutput) GoString() string {
	return s.String()
}

type DeletePrincipalMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source you want to delete a group from.
	//
	// This is useful if a group is tied to multiple data sources and you want to
	// delete a group from accessing documents in a certain data source. For example,
	// the groups "Research", "Engineering", and "Sales and Marketing" are all tied
	// to the company's documents stored in the data sources Confluence and Salesforce.
	// You want to delete "Research" and "Engineering" groups from Salesforce, so
	// that these groups cannot access customer-related documents stored in Salesforce.
	// Only "Sales and Marketing" should access documents in the Salesforce data
	// source.
	DataSourceId *string `min:"1" type:"string"`

	// The identifier of the group you want to delete.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The identifier of the index you want to delete a group from.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The timestamp identifier you specify to ensure Amazon Kendra does not override
	// the latest DELETE action with previous actions. The highest number ID, which
	// is the ordering ID, is the latest action you want to process and apply on
	// top of other actions with lower number IDs. This prevents previous actions
	// with lower number IDs from possibly overriding the latest action.
	//
	// The ordering ID can be the UNIX time of the last update you made to a group
	// members list. You would then provide this list when calling PutPrincipalMapping.
	// This ensures your DELETE action for that updated group with the latest members
	// list doesn't get overwritten by earlier DELETE actions for the same group
	// which are yet to be processed.
	//
	// The default ordering ID is the current UNIX time in milliseconds that the
	// action was received by Amazon Kendra.
	OrderingId *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrincipalMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrincipalMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePrincipalMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePrincipalMappingInput"}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeletePrincipalMappingInput) SetDataSourceId(v string) *DeletePrincipalMappingInput {
	s.DataSourceId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *DeletePrincipalMappingInput) SetGroupId(v string) *DeletePrincipalMappingInput {
	s.GroupId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeletePrincipalMappingInput) SetIndexId(v string) *DeletePrincipalMappingInput {
	s.IndexId = &v
	return s
}

// SetOrderingId sets the OrderingId field's value.
func (s *DeletePrincipalMappingInput) SetOrderingId(v int64) *DeletePrincipalMappingInput {
	s.OrderingId = &v
	return s
}

type DeletePrincipalMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrincipalMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePrincipalMappingOutput) GoString() string {
	return s.String()
}

type DeleteQuerySuggestionsBlockListInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the block list that needs to be deleted.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`

	// The identifier of the you want to delete a block list from.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQuerySuggestionsBlockListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQuerySuggestionsBlockListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQuerySuggestionsBlockListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteQuerySuggestionsBlockListInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteQuerySuggestionsBlockListInput) SetId(v string) *DeleteQuerySuggestionsBlockListInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeleteQuerySuggestionsBlockListInput) SetIndexId(v string) *DeleteQuerySuggestionsBlockListInput {
	s.IndexId = &v
	return s
}

type DeleteQuerySuggestionsBlockListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQuerySuggestionsBlockListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQuerySuggestionsBlockListOutput) GoString() string {
	return s.String()
}

type DeleteThesaurusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the thesaurus to delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index associated with the thesaurus to delete.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThesaurusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThesaurusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThesaurusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThesaurusInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteThesaurusInput) SetId(v string) *DeleteThesaurusInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeleteThesaurusInput) SetIndexId(v string) *DeleteThesaurusInput {
	s.IndexId = &v
	return s
}

type DeleteThesaurusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThesaurusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThesaurusOutput) GoString() string {
	return s.String()
}

type DescribeDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source to describe.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSourceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeDataSourceInput) SetId(v string) *DescribeDataSourceInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeDataSourceInput) SetIndexId(v string) *DescribeDataSourceInput {
	s.IndexId = &v
	return s
}

type DescribeDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Information that describes where the data source is located and how the data
	// source is configured. The specific information in the description depends
	// on the data source provider.
	Configuration *DataSourceConfiguration `type:"structure"`

	// The Unix timestamp of when the data source was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the data source.
	Description *string `type:"string"`

	// When the Status field value is FAILED, the ErrorMessage field contains a
	// description of the error that caused the data source to fail.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the data source.
	Id *string `min:"1" type:"string"`

	// The identifier of the index that contains the data source.
	IndexId *string `min:"36" type:"string"`

	// The name that you gave the data source when it was created.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that enables the data source to
	// access its resources.
	RoleArn *string `min:"1" type:"string"`

	// The schedule that Amazon Kendra will update the data source.
	Schedule *string `type:"string"`

	// The current status of the data source. When the status is ACTIVE the data
	// source is ready to use. When the status is FAILED, the ErrorMessage field
	// contains the reason that the data source failed.
	Status *string `type:"string" enum:"DataSourceStatus"`

	// The type of the data source.
	Type *string `type:"string" enum:"DataSourceType"`

	// The Unix timestamp of when the data source was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourceOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *DescribeDataSourceOutput) SetConfiguration(v *DataSourceConfiguration) *DescribeDataSourceOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeDataSourceOutput) SetCreatedAt(v time.Time) *DescribeDataSourceOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeDataSourceOutput) SetDescription(v string) *DescribeDataSourceOutput {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeDataSourceOutput) SetErrorMessage(v string) *DescribeDataSourceOutput {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeDataSourceOutput) SetId(v string) *DescribeDataSourceOutput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeDataSourceOutput) SetIndexId(v string) *DescribeDataSourceOutput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeDataSourceOutput) SetName(v string) *DescribeDataSourceOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeDataSourceOutput) SetRoleArn(v string) *DescribeDataSourceOutput {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *DescribeDataSourceOutput) SetSchedule(v string) *DescribeDataSourceOutput {
	s.Schedule = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSourceOutput) SetStatus(v string) *DescribeDataSourceOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeDataSourceOutput) SetType(v string) *DescribeDataSourceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeDataSourceOutput) SetUpdatedAt(v time.Time) *DescribeDataSourceOutput {
	s.UpdatedAt = &v
	return s
}

type DescribeFaqInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the FAQ.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the FAQ.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFaqInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFaqInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFaqInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFaqInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeFaqInput) SetId(v string) *DescribeFaqInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeFaqInput) SetIndexId(v string) *DescribeFaqInput {
	s.IndexId = &v
	return s
}

type DescribeFaqOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the FAQ was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the FAQ that you provided when it was created.
	Description *string `type:"string"`

	// If the Status field is FAILED, the ErrorMessage field contains the reason
	// why the FAQ failed.
	ErrorMessage *string `min:"1" type:"string"`

	// The file format used by the input files for the FAQ.
	FileFormat *string `type:"string" enum:"FaqFileFormat"`

	// The identifier of the FAQ.
	Id *string `min:"1" type:"string"`

	// The identifier of the index that contains the FAQ.
	IndexId *string `min:"36" type:"string"`

	// The name that you gave the FAQ when it was created.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that provides access to the S3
	// bucket containing the input files for the FAQ.
	RoleArn *string `min:"1" type:"string"`

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path `type:"structure"`

	// The status of the FAQ. It is ready to use when the status is ACTIVE.
	Status *string `type:"string" enum:"FaqStatus"`

	// The date and time that the FAQ was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFaqOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFaqOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeFaqOutput) SetCreatedAt(v time.Time) *DescribeFaqOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeFaqOutput) SetDescription(v string) *DescribeFaqOutput {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeFaqOutput) SetErrorMessage(v string) *DescribeFaqOutput {
	s.ErrorMessage = &v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *DescribeFaqOutput) SetFileFormat(v string) *DescribeFaqOutput {
	s.FileFormat = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeFaqOutput) SetId(v string) *DescribeFaqOutput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeFaqOutput) SetIndexId(v string) *DescribeFaqOutput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeFaqOutput) SetName(v string) *DescribeFaqOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeFaqOutput) SetRoleArn(v string) *DescribeFaqOutput {
	s.RoleArn = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *DescribeFaqOutput) SetS3Path(v *S3Path) *DescribeFaqOutput {
	s.S3Path = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeFaqOutput) SetStatus(v string) *DescribeFaqOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeFaqOutput) SetUpdatedAt(v time.Time) *DescribeFaqOutput {
	s.UpdatedAt = &v
	return s
}

type DescribeIndexInput struct {
	_ struct{} `type:"structure"`

	// The name of the index to describe.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIndexInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeIndexInput) SetId(v string) *DescribeIndexInput {
	s.Id = &v
	return s
}

type DescribeIndexOutput struct {
	_ struct{} `type:"structure"`

	// For Enterprise edition indexes, you can choose to use additional capacity
	// to meet the needs of your application. This contains the capacity units used
	// for the index. A 0 for the query capacity or the storage capacity indicates
	// that the index is using the default capacity for the index.
	CapacityUnits *CapacityUnitsConfiguration `type:"structure"`

	// The Unix datetime that the index was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the index.
	Description *string `type:"string"`

	// Configuration settings for any metadata applied to the documents in the index.
	DocumentMetadataConfigurations []*DocumentMetadataConfiguration `type:"list"`

	// The Amazon Kendra edition used for the index. You decide the edition when
	// you create the index.
	Edition *string `type:"string" enum:"IndexEdition"`

	// When th eStatus field value is FAILED, the ErrorMessage field contains a
	// message that explains why.
	ErrorMessage *string `min:"1" type:"string"`

	// The name of the index.
	Id *string `min:"36" type:"string"`

	// Provides information about the number of FAQ questions and answers and the
	// number of text documents indexed.
	IndexStatistics *IndexStatistics `type:"structure"`

	// The name of the index.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission
	// to write to your Amazon Cloudwatch logs.
	RoleArn *string `min:"1" type:"string"`

	// The identifier of the KMScustomer master key (CMK) used to encrypt your data.
	// Amazon Kendra doesn't support asymmetric CMKs.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`

	// The current status of the index. When the value is ACTIVE, the index is ready
	// for use. If the Status field value is FAILED, the ErrorMessage field contains
	// a message that explains why.
	Status *string `type:"string" enum:"IndexStatus"`

	// The Unix datetime that the index was last updated.
	UpdatedAt *time.Time `type:"timestamp"`

	// The user context policy for the Amazon Kendra index.
	UserContextPolicy *string `type:"string" enum:"UserContextPolicy"`

	// The user token configuration for the Amazon Kendra index.
	UserTokenConfigurations []*UserTokenConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIndexOutput) GoString() string {
	return s.String()
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *DescribeIndexOutput) SetCapacityUnits(v *CapacityUnitsConfiguration) *DescribeIndexOutput {
	s.CapacityUnits = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeIndexOutput) SetCreatedAt(v time.Time) *DescribeIndexOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeIndexOutput) SetDescription(v string) *DescribeIndexOutput {
	s.Description = &v
	return s
}

// SetDocumentMetadataConfigurations sets the DocumentMetadataConfigurations field's value.
func (s *DescribeIndexOutput) SetDocumentMetadataConfigurations(v []*DocumentMetadataConfiguration) *DescribeIndexOutput {
	s.DocumentMetadataConfigurations = v
	return s
}

// SetEdition sets the Edition field's value.
func (s *DescribeIndexOutput) SetEdition(v string) *DescribeIndexOutput {
	s.Edition = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeIndexOutput) SetErrorMessage(v string) *DescribeIndexOutput {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeIndexOutput) SetId(v string) *DescribeIndexOutput {
	s.Id = &v
	return s
}

// SetIndexStatistics sets the IndexStatistics field's value.
func (s *DescribeIndexOutput) SetIndexStatistics(v *IndexStatistics) *DescribeIndexOutput {
	s.IndexStatistics = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeIndexOutput) SetName(v string) *DescribeIndexOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeIndexOutput) SetRoleArn(v string) *DescribeIndexOutput {
	s.RoleArn = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *DescribeIndexOutput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *DescribeIndexOutput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeIndexOutput) SetStatus(v string) *DescribeIndexOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeIndexOutput) SetUpdatedAt(v time.Time) *DescribeIndexOutput {
	s.UpdatedAt = &v
	return s
}

// SetUserContextPolicy sets the UserContextPolicy field's value.
func (s *DescribeIndexOutput) SetUserContextPolicy(v string) *DescribeIndexOutput {
	s.UserContextPolicy = &v
	return s
}

// SetUserTokenConfigurations sets the UserTokenConfigurations field's value.
func (s *DescribeIndexOutput) SetUserTokenConfigurations(v []*UserTokenConfiguration) *DescribeIndexOutput {
	s.UserTokenConfigurations = v
	return s
}

type DescribePrincipalMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source to check the processing of PUT and DELETE
	// actions for mapping users to their groups.
	DataSourceId *string `min:"1" type:"string"`

	// The identifier of the group required to check the processing of PUT and DELETE
	// actions for mapping users to their groups.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The identifier of the index required to check the processing of PUT and DELETE
	// actions for mapping users to their groups.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePrincipalMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePrincipalMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePrincipalMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePrincipalMappingInput"}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DescribePrincipalMappingInput) SetDataSourceId(v string) *DescribePrincipalMappingInput {
	s.DataSourceId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *DescribePrincipalMappingInput) SetGroupId(v string) *DescribePrincipalMappingInput {
	s.GroupId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribePrincipalMappingInput) SetIndexId(v string) *DescribePrincipalMappingInput {
	s.IndexId = &v
	return s
}

type DescribePrincipalMappingOutput struct {
	_ struct{} `type:"structure"`

	// Shows the identifier of the data source to see information on the processing
	// of PUT and DELETE actions for mapping users to their groups.
	DataSourceId *string `min:"1" type:"string"`

	// Shows the identifier of the group to see information on the processing of
	// PUT and DELETE actions for mapping users to their groups.
	GroupId *string `min:"1" type:"string"`

	// Shows the following information on the processing of PUT and DELETE actions
	// for mapping users to their groups:
	//
	//    * Status – the status can be either PROCESSING, SUCCEEDED, DELETING,
	//    DELETED, or FAILED.
	//
	//    * Last updated – the last date-time an action was updated.
	//
	//    * Received – the last date-time an action was received or submitted.
	//
	//    * Ordering ID – the latest action that should process and apply after
	//    other actions.
	//
	//    * Failure reason – the reason an action could not be processed.
	GroupOrderingIdSummaries []*GroupOrderingIdSummary `type:"list"`

	// Shows the identifier of the index to see information on the processing of
	// PUT and DELETE actions for mapping users to their groups.
	IndexId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePrincipalMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePrincipalMappingOutput) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DescribePrincipalMappingOutput) SetDataSourceId(v string) *DescribePrincipalMappingOutput {
	s.DataSourceId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *DescribePrincipalMappingOutput) SetGroupId(v string) *DescribePrincipalMappingOutput {
	s.GroupId = &v
	return s
}

// SetGroupOrderingIdSummaries sets the GroupOrderingIdSummaries field's value.
func (s *DescribePrincipalMappingOutput) SetGroupOrderingIdSummaries(v []*GroupOrderingIdSummary) *DescribePrincipalMappingOutput {
	s.GroupOrderingIdSummaries = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribePrincipalMappingOutput) SetIndexId(v string) *DescribePrincipalMappingOutput {
	s.IndexId = &v
	return s
}

type DescribeQuerySuggestionsBlockListInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the block list.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`

	// The identifier of the index for the block list.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeQuerySuggestionsBlockListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeQuerySuggestionsBlockListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeQuerySuggestionsBlockListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeQuerySuggestionsBlockListInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeQuerySuggestionsBlockListInput) SetId(v string) *DescribeQuerySuggestionsBlockListInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeQuerySuggestionsBlockListInput) SetIndexId(v string) *DescribeQuerySuggestionsBlockListInput {
	s.IndexId = &v
	return s
}

type DescribeQuerySuggestionsBlockListOutput struct {
	_ struct{} `type:"structure"`

	// Shows the date-time a block list for query suggestions was last created.
	CreatedAt *time.Time `type:"timestamp"`

	// Shows the description for the block list.
	Description *string `type:"string"`

	// Shows the error message with details when there are issues in processing
	// the block list.
	ErrorMessage *string `min:"1" type:"string"`

	// Shows the current size of the block list text file in S3.
	FileSizeBytes *int64 `type:"long"`

	// Shows the unique identifier of the block list.
	Id *string `min:"36" type:"string"`

	// Shows the identifier of the index for the block list.
	IndexId *string `min:"36" type:"string"`

	// Shows the current number of valid, non-empty words or phrases in the block
	// list text file.
	ItemCount *int64 `type:"integer"`

	// Shows the name of the block list.
	Name *string `min:"1" type:"string"`

	// Shows the current IAM (Identity and Access Management) role used by Amazon
	// Kendra to access the block list text file in S3.
	//
	// The role needs S3 read permissions to your file in S3 and needs to give STS
	// (Security Token Service) assume role permissions to Amazon Kendra.
	RoleArn *string `min:"1" type:"string"`

	// Shows the current S3 path to your block list text file in your S3 bucket.
	//
	// Each block word or phrase should be on a separate line in a text file.
	//
	// For information on the current quota limits for block lists, see Quotas for
	// Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
	SourceS3Path *S3Path `type:"structure"`

	// Shows whether the current status of the block list is ACTIVE or INACTIVE.
	Status *string `type:"string" enum:"QuerySuggestionsBlockListStatus"`

	// Shows the date-time a block list for query suggestions was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeQuerySuggestionsBlockListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeQuerySuggestionsBlockListOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetCreatedAt(v time.Time) *DescribeQuerySuggestionsBlockListOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetDescription(v string) *DescribeQuerySuggestionsBlockListOutput {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetErrorMessage(v string) *DescribeQuerySuggestionsBlockListOutput {
	s.ErrorMessage = &v
	return s
}

// SetFileSizeBytes sets the FileSizeBytes field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetFileSizeBytes(v int64) *DescribeQuerySuggestionsBlockListOutput {
	s.FileSizeBytes = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetId(v string) *DescribeQuerySuggestionsBlockListOutput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetIndexId(v string) *DescribeQuerySuggestionsBlockListOutput {
	s.IndexId = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetItemCount(v int64) *DescribeQuerySuggestionsBlockListOutput {
	s.ItemCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetName(v string) *DescribeQuerySuggestionsBlockListOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetRoleArn(v string) *DescribeQuerySuggestionsBlockListOutput {
	s.RoleArn = &v
	return s
}

// SetSourceS3Path sets the SourceS3Path field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetSourceS3Path(v *S3Path) *DescribeQuerySuggestionsBlockListOutput {
	s.SourceS3Path = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetStatus(v string) *DescribeQuerySuggestionsBlockListOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeQuerySuggestionsBlockListOutput) SetUpdatedAt(v time.Time) *DescribeQuerySuggestionsBlockListOutput {
	s.UpdatedAt = &v
	return s
}

type DescribeQuerySuggestionsConfigInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index you want to describe query suggestions settings
	// for.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeQuerySuggestionsConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeQuerySuggestionsConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeQuerySuggestionsConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeQuerySuggestionsConfigInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeQuerySuggestionsConfigInput) SetIndexId(v string) *DescribeQuerySuggestionsConfigInput {
	s.IndexId = &v
	return s
}

type DescribeQuerySuggestionsConfigOutput struct {
	_ struct{} `type:"structure"`

	// Shows whether Amazon Kendra uses all queries or only uses queries that include
	// user information to generate query suggestions.
	IncludeQueriesWithoutUserInformation *bool `type:"boolean"`

	// Shows the date-time query suggestions for an index was last cleared.
	//
	// After you clear suggestions, Amazon Kendra learns new suggestions based on
	// new queries added to the query log from the time you cleared suggestions.
	// Amazon Kendra only considers re-occurences of a query from the time you cleared
	// suggestions.
	LastClearTime *time.Time `type:"timestamp"`

	// Shows the date-time query suggestions for an index was last updated.
	LastSuggestionsBuildTime *time.Time `type:"timestamp"`

	// Shows the minimum number of unique users who must search a query in order
	// for the query to be eligible to suggest to your users.
	MinimumNumberOfQueryingUsers *int64 `min:"1" type:"integer"`

	// Shows the minimum number of times a query must be searched in order for the
	// query to be eligible to suggest to your users.
	MinimumQueryCount *int64 `min:"1" type:"integer"`

	// Shows whether query suggestions are currently in ENABLED mode or LEARN_ONLY
	// mode.
	//
	// By default, Amazon Kendra enables query suggestions.LEARN_ONLY turns off
	// query suggestions for your users. You can change the mode using the UpdateQuerySuggestionsConfig
	// (https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html)
	// operation.
	Mode *string `type:"string" enum:"Mode"`

	// Shows how recent your queries are in your query log time window (in days).
	QueryLogLookBackWindowInDays *int64 `type:"integer"`

	// Shows whether the status of query suggestions settings is currently Active
	// or Updating.
	//
	// Active means the current settings apply and Updating means your changed settings
	// are in the process of applying.
	Status *string `type:"string" enum:"QuerySuggestionsStatus"`

	// Shows the current total count of query suggestions for an index.
	//
	// This count can change when you update your query suggestions settings, if
	// you filter out certain queries from suggestions using a block list, and as
	// the query log accumulates more queries for Amazon Kendra to learn from.
	TotalSuggestionsCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeQuerySuggestionsConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeQuerySuggestionsConfigOutput) GoString() string {
	return s.String()
}

// SetIncludeQueriesWithoutUserInformation sets the IncludeQueriesWithoutUserInformation field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetIncludeQueriesWithoutUserInformation(v bool) *DescribeQuerySuggestionsConfigOutput {
	s.IncludeQueriesWithoutUserInformation = &v
	return s
}

// SetLastClearTime sets the LastClearTime field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetLastClearTime(v time.Time) *DescribeQuerySuggestionsConfigOutput {
	s.LastClearTime = &v
	return s
}

// SetLastSuggestionsBuildTime sets the LastSuggestionsBuildTime field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetLastSuggestionsBuildTime(v time.Time) *DescribeQuerySuggestionsConfigOutput {
	s.LastSuggestionsBuildTime = &v
	return s
}

// SetMinimumNumberOfQueryingUsers sets the MinimumNumberOfQueryingUsers field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetMinimumNumberOfQueryingUsers(v int64) *DescribeQuerySuggestionsConfigOutput {
	s.MinimumNumberOfQueryingUsers = &v
	return s
}

// SetMinimumQueryCount sets the MinimumQueryCount field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetMinimumQueryCount(v int64) *DescribeQuerySuggestionsConfigOutput {
	s.MinimumQueryCount = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetMode(v string) *DescribeQuerySuggestionsConfigOutput {
	s.Mode = &v
	return s
}

// SetQueryLogLookBackWindowInDays sets the QueryLogLookBackWindowInDays field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetQueryLogLookBackWindowInDays(v int64) *DescribeQuerySuggestionsConfigOutput {
	s.QueryLogLookBackWindowInDays = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetStatus(v string) *DescribeQuerySuggestionsConfigOutput {
	s.Status = &v
	return s
}

// SetTotalSuggestionsCount sets the TotalSuggestionsCount field's value.
func (s *DescribeQuerySuggestionsConfigOutput) SetTotalSuggestionsCount(v int64) *DescribeQuerySuggestionsConfigOutput {
	s.TotalSuggestionsCount = &v
	return s
}

type DescribeThesaurusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the thesaurus to describe.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index associated with the thesaurus to describe.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThesaurusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThesaurusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThesaurusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThesaurusInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeThesaurusInput) SetId(v string) *DescribeThesaurusInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeThesaurusInput) SetIndexId(v string) *DescribeThesaurusInput {
	s.IndexId = &v
	return s
}

type DescribeThesaurusOutput struct {
	_ struct{} `type:"structure"`

	// The Unix datetime that the thesaurus was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The thesaurus description.
	Description *string `type:"string"`

	// When the Status field value is FAILED, the ErrorMessage field provides more
	// information.
	ErrorMessage *string `min:"1" type:"string"`

	// The size of the thesaurus file in bytes.
	FileSizeBytes *int64 `type:"long"`

	// The identifier of the thesaurus.
	Id *string `min:"1" type:"string"`

	// The identifier of the index associated with the thesaurus to describe.
	IndexId *string `min:"36" type:"string"`

	// The thesaurus name.
	Name *string `min:"1" type:"string"`

	// An AWS Identity and Access Management (IAM) role that gives Amazon Kendra
	// permissions to access thesaurus file specified in SourceS3Path.
	RoleArn *string `min:"1" type:"string"`

	// Information required to find a specific file in an Amazon S3 bucket.
	SourceS3Path *S3Path `type:"structure"`

	// The current status of the thesaurus. When the value is ACTIVE, queries are
	// able to use the thesaurus. If the Status field value is FAILED, the ErrorMessage
	// field provides more information.
	//
	// If the status is ACTIVE_BUT_UPDATE_FAILED, it means that Amazon Kendra could
	// not ingest the new thesaurus file. The old thesaurus file is still active.
	Status *string `type:"string" enum:"ThesaurusStatus"`

	// The number of synonym rules in the thesaurus file.
	SynonymRuleCount *int64 `type:"long"`

	// The number of unique terms in the thesaurus file. For example, the synonyms
	// a,b,c and a=>d, the term count would be 4.
	TermCount *int64 `type:"long"`

	// The Unix datetime that the thesaurus was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThesaurusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThesaurusOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeThesaurusOutput) SetCreatedAt(v time.Time) *DescribeThesaurusOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeThesaurusOutput) SetDescription(v string) *DescribeThesaurusOutput {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeThesaurusOutput) SetErrorMessage(v string) *DescribeThesaurusOutput {
	s.ErrorMessage = &v
	return s
}

// SetFileSizeBytes sets the FileSizeBytes field's value.
func (s *DescribeThesaurusOutput) SetFileSizeBytes(v int64) *DescribeThesaurusOutput {
	s.FileSizeBytes = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeThesaurusOutput) SetId(v string) *DescribeThesaurusOutput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeThesaurusOutput) SetIndexId(v string) *DescribeThesaurusOutput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeThesaurusOutput) SetName(v string) *DescribeThesaurusOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeThesaurusOutput) SetRoleArn(v string) *DescribeThesaurusOutput {
	s.RoleArn = &v
	return s
}

// SetSourceS3Path sets the SourceS3Path field's value.
func (s *DescribeThesaurusOutput) SetSourceS3Path(v *S3Path) *DescribeThesaurusOutput {
	s.SourceS3Path = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeThesaurusOutput) SetStatus(v string) *DescribeThesaurusOutput {
	s.Status = &v
	return s
}

// SetSynonymRuleCount sets the SynonymRuleCount field's value.
func (s *DescribeThesaurusOutput) SetSynonymRuleCount(v int64) *DescribeThesaurusOutput {
	s.SynonymRuleCount = &v
	return s
}

// SetTermCount sets the TermCount field's value.
func (s *DescribeThesaurusOutput) SetTermCount(v int64) *DescribeThesaurusOutput {
	s.TermCount = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeThesaurusOutput) SetUpdatedAt(v time.Time) *DescribeThesaurusOutput {
	s.UpdatedAt = &v
	return s
}

// A document in an index.
type Document struct {
	_ struct{} `type:"structure"`

	// Information on user and group access rights, which is used for user context
	// filtering.
	AccessControlList []*Principal `type:"list"`

	// Custom attributes to apply to the document. Use the custom attributes to
	// provide additional information for searching, to provide facets for refining
	// searches, and to provide additional information in the query response.
	Attributes []*DocumentAttribute `type:"list"`

	// The contents of the document.
	//
	// Documents passed to the Blob parameter must be base64 encoded. Your code
	// might not need to encode the document file bytes if you're using an Amazon
	// Web Services SDK to call Amazon Kendra operations. If you are calling the
	// Amazon Kendra endpoint directly using REST, you must base64 encode the contents
	// before sending.
	// Blob is automatically base64 encoded/decoded by the SDK.
	Blob []byte `type:"blob"`

	// The file type of the document in the Blob field.
	ContentType *string `type:"string" enum:"ContentType"`

	// The list of principal (https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html)
	// lists that define the hierarchy for which documents users should have access
	// to.
	HierarchicalAccessControlList []*HierarchicalPrincipal `min:"1" type:"list"`

	// A unique identifier of the document in the index.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path `type:"structure"`

	// The title of the document.
	Title *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Document"}
	if s.HierarchicalAccessControlList != nil && len(s.HierarchicalAccessControlList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchicalAccessControlList", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.HierarchicalAccessControlList != nil {
		for i, v := range s.HierarchicalAccessControlList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HierarchicalAccessControlList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.S3Path != nil {
		if err := s.S3Path.Validate(); err != nil {
			invalidParams.AddNested("S3Path", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlList sets the AccessControlList field's value.
func (s *Document) SetAccessControlList(v []*Principal) *Document {
	s.AccessControlList = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Document) SetAttributes(v []*DocumentAttribute) *Document {
	s.Attributes = v
	return s
}

// SetBlob sets the Blob field's value.
func (s *Document) SetBlob(v []byte) *Document {
	s.Blob = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Document) SetContentType(v string) *Document {
	s.ContentType = &v
	return s
}

// SetHierarchicalAccessControlList sets the HierarchicalAccessControlList field's value.
func (s *Document) SetHierarchicalAccessControlList(v []*HierarchicalPrincipal) *Document {
	s.HierarchicalAccessControlList = v
	return s
}

// SetId sets the Id field's value.
func (s *Document) SetId(v string) *Document {
	s.Id = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *Document) SetS3Path(v *S3Path) *Document {
	s.S3Path = v
	return s
}

// SetTitle sets the Title field's value.
func (s *Document) SetTitle(v string) *Document {
	s.Title = &v
	return s
}

// A custom attribute value assigned to a document.
type DocumentAttribute struct {
	_ struct{} `type:"structure"`

	// The identifier for the attribute.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *DocumentAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttribute"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *DocumentAttribute) SetKey(v string) *DocumentAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DocumentAttribute) SetValue(v *DocumentAttributeValue) *DocumentAttribute {
	s.Value = v
	return s
}

// The value of a custom document attribute. You can only provide one value
// for a custom attribute.
type DocumentAttributeValue struct {
	_ struct{} `type:"structure"`

	// A date expressed as an ISO 8601 string.
	//
	// It is important for the time zone to be included in the ISO 8601 date-time
	// format. For example, 20120325T123010+01:00 is the ISO 8601 date-time format
	// for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
	DateValue *time.Time `type:"timestamp"`

	// A long integer value.
	LongValue *int64 `type:"long"`

	// A list of strings.
	StringListValue []*string `type:"list"`

	// A string, such as "department".
	StringValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttributeValue"}
	if s.StringValue != nil && len(*s.StringValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StringValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateValue sets the DateValue field's value.
func (s *DocumentAttributeValue) SetDateValue(v time.Time) *DocumentAttributeValue {
	s.DateValue = &v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *DocumentAttributeValue) SetLongValue(v int64) *DocumentAttributeValue {
	s.LongValue = &v
	return s
}

// SetStringListValue sets the StringListValue field's value.
func (s *DocumentAttributeValue) SetStringListValue(v []*string) *DocumentAttributeValue {
	s.StringListValue = v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *DocumentAttributeValue) SetStringValue(v string) *DocumentAttributeValue {
	s.StringValue = &v
	return s
}

// Provides the count of documents that match a particular attribute when doing
// a faceted search.
type DocumentAttributeValueCountPair struct {
	_ struct{} `type:"structure"`

	// The number of documents in the response that have the attribute value for
	// the key.
	Count *int64 `type:"integer"`

	// The value of the attribute. For example, "HR."
	DocumentAttributeValue *DocumentAttributeValue `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeValueCountPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeValueCountPair) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *DocumentAttributeValueCountPair) SetCount(v int64) *DocumentAttributeValueCountPair {
	s.Count = &v
	return s
}

// SetDocumentAttributeValue sets the DocumentAttributeValue field's value.
func (s *DocumentAttributeValueCountPair) SetDocumentAttributeValue(v *DocumentAttributeValue) *DocumentAttributeValueCountPair {
	s.DocumentAttributeValue = v
	return s
}

// Identifies a document for which to retrieve status information
type DocumentInfo struct {
	_ struct{} `type:"structure"`

	// Attributes that identify a specific version of a document to check.
	//
	// The only valid attributes are:
	//
	//    * version
	//
	//    * datasourceId
	//
	//    * jobExecutionId
	//
	// The attributes follow these rules:
	//
	//    * dataSourceId and jobExecutionId must be used together.
	//
	//    * version is ignored if dataSourceId and jobExecutionId are not provided.
	//
	//    * If dataSourceId and jobExecutionId are provided, but version is not,
	//    the version defaults to "0".
	Attributes []*DocumentAttribute `type:"list"`

	// The unique identifier of the document.
	//
	// DocumentId is a required field
	DocumentId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentInfo"}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *DocumentInfo) SetAttributes(v []*DocumentAttribute) *DocumentInfo {
	s.Attributes = v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *DocumentInfo) SetDocumentId(v string) *DocumentInfo {
	s.DocumentId = &v
	return s
}

// Specifies the properties of a custom index field.
type DocumentMetadataConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the index field.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Provides manual tuning parameters to determine how the field affects the
	// search results.
	Relevance *Relevance `type:"structure"`

	// Provides information about how the field is used during a search.
	Search *Search `type:"structure"`

	// The data type of the index field.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DocumentAttributeValueType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentMetadataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentMetadataConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentMetadataConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentMetadataConfiguration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Relevance != nil {
		if err := s.Relevance.Validate(); err != nil {
			invalidParams.AddNested("Relevance", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DocumentMetadataConfiguration) SetName(v string) *DocumentMetadataConfiguration {
	s.Name = &v
	return s
}

// SetRelevance sets the Relevance field's value.
func (s *DocumentMetadataConfiguration) SetRelevance(v *Relevance) *DocumentMetadataConfiguration {
	s.Relevance = v
	return s
}

// SetSearch sets the Search field's value.
func (s *DocumentMetadataConfiguration) SetSearch(v *Search) *DocumentMetadataConfiguration {
	s.Search = v
	return s
}

// SetType sets the Type field's value.
func (s *DocumentMetadataConfiguration) SetType(v string) *DocumentMetadataConfiguration {
	s.Type = &v
	return s
}

// Overrides the document relevance properties of a custom index field.
type DocumentRelevanceConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the tuning configuration to override document relevance at the
	// index level.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Provides information for manually tuning the relevance of a field in a search.
	// When a query includes terms that match the field, the results are given a
	// boost in the response based on these tuning parameters.
	//
	// Relevance is a required field
	Relevance *Relevance `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentRelevanceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentRelevanceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentRelevanceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentRelevanceConfiguration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Relevance == nil {
		invalidParams.Add(request.NewErrParamRequired("Relevance"))
	}
	if s.Relevance != nil {
		if err := s.Relevance.Validate(); err != nil {
			invalidParams.AddNested("Relevance", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DocumentRelevanceConfiguration) SetName(v string) *DocumentRelevanceConfiguration {
	s.Name = &v
	return s
}

// SetRelevance sets the Relevance field's value.
func (s *DocumentRelevanceConfiguration) SetRelevance(v *Relevance) *DocumentRelevanceConfiguration {
	s.Relevance = v
	return s
}

// Document metadata files that contain information such as the document access
// control information, source URI, document author, and custom attributes.
// Each metadata file contains metadata about a single document.
type DocumentsMetadataConfiguration struct {
	_ struct{} `type:"structure"`

	// A prefix used to filter metadata configuration files in the Amazon Web Services
	// S3 bucket. The S3 bucket might contain multiple metadata files. Use S3Prefix
	// to include only the desired metadata files.
	S3Prefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentsMetadataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentsMetadataConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentsMetadataConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentsMetadataConfiguration"}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *DocumentsMetadataConfiguration) SetS3Prefix(v string) *DocumentsMetadataConfiguration {
	s.S3Prefix = &v
	return s
}

// Information about a document attribute
type Facet struct {
	_ struct{} `type:"structure"`

	// The unique key for the document attribute.
	DocumentAttributeKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Facet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Facet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Facet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Facet"}
	if s.DocumentAttributeKey != nil && len(*s.DocumentAttributeKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentAttributeKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentAttributeKey sets the DocumentAttributeKey field's value.
func (s *Facet) SetDocumentAttributeKey(v string) *Facet {
	s.DocumentAttributeKey = &v
	return s
}

// The facet values for the documents in the response.
type FacetResult struct {
	_ struct{} `type:"structure"`

	// The key for the facet values. This is the same as the DocumentAttributeKey
	// provided in the query.
	DocumentAttributeKey *string `min:"1" type:"string"`

	// An array of key/value pairs, where the key is the value of the attribute
	// and the count is the number of documents that share the key value.
	DocumentAttributeValueCountPairs []*DocumentAttributeValueCountPair `type:"list"`

	// The data type of the facet value. This is the same as the type defined for
	// the index field when it was created.
	DocumentAttributeValueType *string `type:"string" enum:"DocumentAttributeValueType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FacetResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FacetResult) GoString() string {
	return s.String()
}

// SetDocumentAttributeKey sets the DocumentAttributeKey field's value.
func (s *FacetResult) SetDocumentAttributeKey(v string) *FacetResult {
	s.DocumentAttributeKey = &v
	return s
}

// SetDocumentAttributeValueCountPairs sets the DocumentAttributeValueCountPairs field's value.
func (s *FacetResult) SetDocumentAttributeValueCountPairs(v []*DocumentAttributeValueCountPair) *FacetResult {
	s.DocumentAttributeValueCountPairs = v
	return s
}

// SetDocumentAttributeValueType sets the DocumentAttributeValueType field's value.
func (s *FacetResult) SetDocumentAttributeValueType(v string) *FacetResult {
	s.DocumentAttributeValueType = &v
	return s
}

// Provides statistical information about the FAQ questions and answers contained
// in an index.
type FaqStatistics struct {
	_ struct{} `type:"structure"`

	// The total number of FAQ questions and answers contained in the index.
	//
	// IndexedQuestionAnswersCount is a required field
	IndexedQuestionAnswersCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaqStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaqStatistics) GoString() string {
	return s.String()
}

// SetIndexedQuestionAnswersCount sets the IndexedQuestionAnswersCount field's value.
func (s *FaqStatistics) SetIndexedQuestionAnswersCount(v int64) *FaqStatistics {
	s.IndexedQuestionAnswersCount = &v
	return s
}

// Provides information about a frequently asked questions and answer contained
// in an index.
type FaqSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime that the FAQ was added to the index.
	CreatedAt *time.Time `type:"timestamp"`

	// The file type used to create the FAQ.
	FileFormat *string `type:"string" enum:"FaqFileFormat"`

	// The unique identifier of the FAQ.
	Id *string `min:"1" type:"string"`

	// The name that you assigned the FAQ when you created or updated the FAQ.
	Name *string `min:"1" type:"string"`

	// The current status of the FAQ. When the status is ACTIVE the FAQ is ready
	// for use.
	Status *string `type:"string" enum:"FaqStatus"`

	// The UNIX datetime that the FAQ was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaqSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaqSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FaqSummary) SetCreatedAt(v time.Time) *FaqSummary {
	s.CreatedAt = &v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *FaqSummary) SetFileFormat(v string) *FaqSummary {
	s.FileFormat = &v
	return s
}

// SetId sets the Id field's value.
func (s *FaqSummary) SetId(v string) *FaqSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *FaqSummary) SetName(v string) *FaqSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FaqSummary) SetStatus(v string) *FaqSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FaqSummary) SetUpdatedAt(v time.Time) *FaqSummary {
	s.UpdatedAt = &v
	return s
}

type GetQuerySuggestionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index you want to get query suggestions from.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of query suggestions you want to show to your users.
	MaxSuggestionsCount *int64 `type:"integer"`

	// The text of a user's query to generate query suggestions.
	//
	// A query is suggested if the query prefix matches what a user starts to type
	// as their query.
	//
	// Amazon Kendra does not show any suggestions if a user types fewer than two
	// characters or more than 60 characters. A query must also have at least one
	// search result and contain at least one word of more than four characters.
	//
	// QueryText is a required field
	QueryText *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQuerySuggestionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQuerySuggestionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQuerySuggestionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQuerySuggestionsInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.QueryText == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryText"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *GetQuerySuggestionsInput) SetIndexId(v string) *GetQuerySuggestionsInput {
	s.IndexId = &v
	return s
}

// SetMaxSuggestionsCount sets the MaxSuggestionsCount field's value.
func (s *GetQuerySuggestionsInput) SetMaxSuggestionsCount(v int64) *GetQuerySuggestionsInput {
	s.MaxSuggestionsCount = &v
	return s
}

// SetQueryText sets the QueryText field's value.
func (s *GetQuerySuggestionsInput) SetQueryText(v string) *GetQuerySuggestionsInput {
	s.QueryText = &v
	return s
}

type GetQuerySuggestionsOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for a list of query suggestions for an index.
	QuerySuggestionsId *string `min:"1" type:"string"`

	// A list of query suggestions for an index.
	Suggestions []*Suggestion `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQuerySuggestionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQuerySuggestionsOutput) GoString() string {
	return s.String()
}

// SetQuerySuggestionsId sets the QuerySuggestionsId field's value.
func (s *GetQuerySuggestionsOutput) SetQuerySuggestionsId(v string) *GetQuerySuggestionsOutput {
	s.QuerySuggestionsId = &v
	return s
}

// SetSuggestions sets the Suggestions field's value.
func (s *GetQuerySuggestionsOutput) SetSuggestions(v []*Suggestion) *GetQuerySuggestionsOutput {
	s.Suggestions = v
	return s
}

// Provides configuration information for data sources that connect to Google
// Drive.
type GoogleDriveConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of MIME types to exclude from the index. All documents matching the
	// specified MIME type are excluded.
	//
	// For a list of MIME types, see Using a Google Workspace Drive data source
	// (https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).
	ExcludeMimeTypes []*string `type:"list"`

	// A list of identifiers or shared drives to exclude from the index. All files
	// and folders stored on the shared drive are excluded.
	ExcludeSharedDrives []*string `type:"list"`

	// A list of email addresses of the users. Documents owned by these users are
	// excluded from the index. Documents shared with excluded users are indexed
	// unless they are excluded in another way.
	ExcludeUserAccounts []*string `type:"list"`

	// A list of regular expression patterns that apply to the path on Google Drive.
	// Items that match the pattern are excluded from the index from both shared
	// drives and users' My Drives. Items that don't match the pattern are included
	// in the index. If an item matches both an exclusion pattern and an inclusion
	// pattern, it is excluded from the index.
	ExclusionPatterns []*string `type:"list"`

	// Defines mapping between a field in the Google Drive and a Amazon Kendra index
	// field.
	//
	// If you are using the console, you can define index fields when creating the
	// mapping. If you are using the API, you must first create the field using
	// the UpdateIndex operation.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A list of regular expression patterns that apply to path on Google Drive.
	// Items that match the pattern are included in the index from both shared drives
	// and users' My Drives. Items that don't match the pattern are excluded from
	// the index. If an item matches both an inclusion pattern and an exclusion
	// pattern, it is excluded from the index.
	InclusionPatterns []*string `type:"list"`

	// The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the
	// credentials required to connect to Google Drive. For more information, see
	// Using a Google Workspace Drive data source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GoogleDriveConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GoogleDriveConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GoogleDriveConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GoogleDriveConfiguration"}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludeMimeTypes sets the ExcludeMimeTypes field's value.
func (s *GoogleDriveConfiguration) SetExcludeMimeTypes(v []*string) *GoogleDriveConfiguration {
	s.ExcludeMimeTypes = v
	return s
}

// SetExcludeSharedDrives sets the ExcludeSharedDrives field's value.
func (s *GoogleDriveConfiguration) SetExcludeSharedDrives(v []*string) *GoogleDriveConfiguration {
	s.ExcludeSharedDrives = v
	return s
}

// SetExcludeUserAccounts sets the ExcludeUserAccounts field's value.
func (s *GoogleDriveConfiguration) SetExcludeUserAccounts(v []*string) *GoogleDriveConfiguration {
	s.ExcludeUserAccounts = v
	return s
}

// SetExclusionPatterns sets the ExclusionPatterns field's value.
func (s *GoogleDriveConfiguration) SetExclusionPatterns(v []*string) *GoogleDriveConfiguration {
	s.ExclusionPatterns = v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *GoogleDriveConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *GoogleDriveConfiguration {
	s.FieldMappings = v
	return s
}

// SetInclusionPatterns sets the InclusionPatterns field's value.
func (s *GoogleDriveConfiguration) SetInclusionPatterns(v []*string) *GoogleDriveConfiguration {
	s.InclusionPatterns = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *GoogleDriveConfiguration) SetSecretArn(v string) *GoogleDriveConfiguration {
	s.SecretArn = &v
	return s
}

// A list of users or sub groups that belong to a group. Users and groups are
// useful for filtering search results to different users based on their group's
// access to documents.
type GroupMembers struct {
	_ struct{} `type:"structure"`

	// A list of sub groups that belong to a group. For example, the sub groups
	// "Research", "Engineering", and "Sales and Marketing" all belong to the group
	// "Company".
	MemberGroups []*MemberGroup `min:"1" type:"list"`

	// A list of users that belong to a group. For example, a list of interns all
	// belong to the "Interns" group.
	MemberUsers []*MemberUser `min:"1" type:"list"`

	// If you have more than 1000 users and/or sub groups for a single group, you
	// need to provide the path to the S3 file that lists your users and sub groups
	// for a group. Your sub groups can contain more than 1000 users, but the list
	// of sub groups that belong to a group (and/or users) must be no more than
	// 1000.
	S3PathforGroupMembers *S3Path `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMembers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMembers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupMembers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupMembers"}
	if s.MemberGroups != nil && len(s.MemberGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberGroups", 1))
	}
	if s.MemberUsers != nil && len(s.MemberUsers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberUsers", 1))
	}
	if s.MemberGroups != nil {
		for i, v := range s.MemberGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MemberGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MemberUsers != nil {
		for i, v := range s.MemberUsers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MemberUsers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.S3PathforGroupMembers != nil {
		if err := s.S3PathforGroupMembers.Validate(); err != nil {
			invalidParams.AddNested("S3PathforGroupMembers", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberGroups sets the MemberGroups field's value.
func (s *GroupMembers) SetMemberGroups(v []*MemberGroup) *GroupMembers {
	s.MemberGroups = v
	return s
}

// SetMemberUsers sets the MemberUsers field's value.
func (s *GroupMembers) SetMemberUsers(v []*MemberUser) *GroupMembers {
	s.MemberUsers = v
	return s
}

// SetS3PathforGroupMembers sets the S3PathforGroupMembers field's value.
func (s *GroupMembers) SetS3PathforGroupMembers(v *S3Path) *GroupMembers {
	s.S3PathforGroupMembers = v
	return s
}

// Information on the processing of PUT and DELETE actions for mapping users
// to their groups.
type GroupOrderingIdSummary struct {
	_ struct{} `type:"structure"`

	// The reason an action could not be processed. An action can be a PUT or DELETE
	// action for mapping users to their groups.
	FailureReason *string `min:"1" type:"string"`

	// The last date-time an action was updated. An action can be a PUT or DELETE
	// action for mapping users to their groups.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The order in which actions should complete processing. An action can be a
	// PUT or DELETE action for mapping users to their groups.
	OrderingId *int64 `type:"long"`

	// The date-time an action was received by Amazon Kendra. An action can be a
	// PUT or DELETE action for mapping users to their groups.
	ReceivedAt *time.Time `type:"timestamp"`

	// The current processing status of actions for mapping users to their groups.
	// The status can be either PROCESSING, SUCCEEDED, DELETING, DELETED, or FAILED.
	Status *string `type:"string" enum:"PrincipalMappingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupOrderingIdSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupOrderingIdSummary) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *GroupOrderingIdSummary) SetFailureReason(v string) *GroupOrderingIdSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GroupOrderingIdSummary) SetLastUpdatedAt(v time.Time) *GroupOrderingIdSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetOrderingId sets the OrderingId field's value.
func (s *GroupOrderingIdSummary) SetOrderingId(v int64) *GroupOrderingIdSummary {
	s.OrderingId = &v
	return s
}

// SetReceivedAt sets the ReceivedAt field's value.
func (s *GroupOrderingIdSummary) SetReceivedAt(v time.Time) *GroupOrderingIdSummary {
	s.ReceivedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GroupOrderingIdSummary) SetStatus(v string) *GroupOrderingIdSummary {
	s.Status = &v
	return s
}

// Group summary information.
type GroupSummary struct {
	_ struct{} `type:"structure"`

	// The identifier of the group you want group summary information on.
	GroupId *string `min:"1" type:"string"`

	// The timestamp identifier used for the latest PUT or DELETE action.
	OrderingId *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupSummary) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *GroupSummary) SetGroupId(v string) *GroupSummary {
	s.GroupId = &v
	return s
}

// SetOrderingId sets the OrderingId field's value.
func (s *GroupSummary) SetOrderingId(v int64) *GroupSummary {
	s.OrderingId = &v
	return s
}

// Information to define the hierarchy for which documents users should have
// access to.
type HierarchicalPrincipal struct {
	_ struct{} `type:"structure"`

	// A list of principal (https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html)
	// lists that define the hierarchy for which documents users should have access
	// to. Each hierarchical list specifies which user or group has allow or deny
	// access for each document.
	//
	// PrincipalList is a required field
	PrincipalList []*Principal `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HierarchicalPrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HierarchicalPrincipal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HierarchicalPrincipal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HierarchicalPrincipal"}
	if s.PrincipalList == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalList"))
	}
	if s.PrincipalList != nil {
		for i, v := range s.PrincipalList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PrincipalList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipalList sets the PrincipalList field's value.
func (s *HierarchicalPrincipal) SetPrincipalList(v []*Principal) *HierarchicalPrincipal {
	s.PrincipalList = v
	return s
}

// Provides information that you can use to highlight a search result so that
// your users can quickly identify terms in the response.
type Highlight struct {
	_ struct{} `type:"structure"`

	// The zero-based location in the response string where the highlight starts.
	//
	// BeginOffset is a required field
	BeginOffset *int64 `type:"integer" required:"true"`

	// The zero-based location in the response string where the highlight ends.
	//
	// EndOffset is a required field
	EndOffset *int64 `type:"integer" required:"true"`

	// Indicates whether the response is the best response. True if this is the
	// best response; otherwise, false.
	TopAnswer *bool `type:"boolean"`

	// The highlight type.
	Type *string `type:"string" enum:"HighlightType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Highlight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Highlight) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Highlight) SetBeginOffset(v int64) *Highlight {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Highlight) SetEndOffset(v int64) *Highlight {
	s.EndOffset = &v
	return s
}

// SetTopAnswer sets the TopAnswer field's value.
func (s *Highlight) SetTopAnswer(v bool) *Highlight {
	s.TopAnswer = &v
	return s
}

// SetType sets the Type field's value.
func (s *Highlight) SetType(v string) *Highlight {
	s.Type = &v
	return s
}

// A summary of information about an index.
type IndexConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp when the index was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// Indicates whether the index is a enterprise edition index or a developer
	// edition index.
	Edition *string `type:"string" enum:"IndexEdition"`

	// A unique identifier for the index. Use this to identify the index when you
	// are using operations such as Query, DescribeIndex, UpdateIndex, and DeleteIndex.
	Id *string `min:"36" type:"string"`

	// The name of the index.
	Name *string `min:"1" type:"string"`

	// The current status of the index. When the status is ACTIVE, the index is
	// ready to search.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"IndexStatus"`

	// The Unix timestamp when the index was last updated by the UpdateIndex operation.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexConfigurationSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *IndexConfigurationSummary) SetCreatedAt(v time.Time) *IndexConfigurationSummary {
	s.CreatedAt = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *IndexConfigurationSummary) SetEdition(v string) *IndexConfigurationSummary {
	s.Edition = &v
	return s
}

// SetId sets the Id field's value.
func (s *IndexConfigurationSummary) SetId(v string) *IndexConfigurationSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *IndexConfigurationSummary) SetName(v string) *IndexConfigurationSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IndexConfigurationSummary) SetStatus(v string) *IndexConfigurationSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IndexConfigurationSummary) SetUpdatedAt(v time.Time) *IndexConfigurationSummary {
	s.UpdatedAt = &v
	return s
}

// Provides information about the number of documents and the number of questions
// and answers in an index.
type IndexStatistics struct {
	_ struct{} `type:"structure"`

	// The number of question and answer topics in the index.
	//
	// FaqStatistics is a required field
	FaqStatistics *FaqStatistics `type:"structure" required:"true"`

	// The number of text documents indexed.
	//
	// TextDocumentStatistics is a required field
	TextDocumentStatistics *TextDocumentStatistics `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexStatistics) GoString() string {
	return s.String()
}

// SetFaqStatistics sets the FaqStatistics field's value.
func (s *IndexStatistics) SetFaqStatistics(v *FaqStatistics) *IndexStatistics {
	s.FaqStatistics = v
	return s
}

// SetTextDocumentStatistics sets the TextDocumentStatistics field's value.
func (s *IndexStatistics) SetTextDocumentStatistics(v *TextDocumentStatistics) *IndexStatistics {
	s.TextDocumentStatistics = v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration information for the JSON token type.
type JsonTokenTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The group attribute field.
	//
	// GroupAttributeField is a required field
	GroupAttributeField *string `min:"1" type:"string" required:"true"`

	// The user name attribute field.
	//
	// UserNameAttributeField is a required field
	UserNameAttributeField *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JsonTokenTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JsonTokenTypeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JsonTokenTypeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JsonTokenTypeConfiguration"}
	if s.GroupAttributeField == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupAttributeField"))
	}
	if s.GroupAttributeField != nil && len(*s.GroupAttributeField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupAttributeField", 1))
	}
	if s.UserNameAttributeField == nil {
		invalidParams.Add(request.NewErrParamRequired("UserNameAttributeField"))
	}
	if s.UserNameAttributeField != nil && len(*s.UserNameAttributeField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserNameAttributeField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupAttributeField sets the GroupAttributeField field's value.
func (s *JsonTokenTypeConfiguration) SetGroupAttributeField(v string) *JsonTokenTypeConfiguration {
	s.GroupAttributeField = &v
	return s
}

// SetUserNameAttributeField sets the UserNameAttributeField field's value.
func (s *JsonTokenTypeConfiguration) SetUserNameAttributeField(v string) *JsonTokenTypeConfiguration {
	s.UserNameAttributeField = &v
	return s
}

// Configuration information for the JWT token type.
type JwtTokenTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The regular expression that identifies the claim.
	ClaimRegex *string `min:"1" type:"string"`

	// The group attribute field.
	GroupAttributeField *string `min:"1" type:"string"`

	// The issuer of the token.
	Issuer *string `min:"1" type:"string"`

	// The location of the key.
	//
	// KeyLocation is a required field
	KeyLocation *string `type:"string" required:"true" enum:"KeyLocation"`

	// The Amazon Resource Name (arn) of the secret.
	SecretManagerArn *string `min:"1" type:"string"`

	// The signing key URL.
	URL *string `min:"1" type:"string"`

	// The user name attribute field.
	UserNameAttributeField *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JwtTokenTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JwtTokenTypeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JwtTokenTypeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JwtTokenTypeConfiguration"}
	if s.ClaimRegex != nil && len(*s.ClaimRegex) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClaimRegex", 1))
	}
	if s.GroupAttributeField != nil && len(*s.GroupAttributeField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupAttributeField", 1))
	}
	if s.Issuer != nil && len(*s.Issuer) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Issuer", 1))
	}
	if s.KeyLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyLocation"))
	}
	if s.SecretManagerArn != nil && len(*s.SecretManagerArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretManagerArn", 1))
	}
	if s.URL != nil && len(*s.URL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("URL", 1))
	}
	if s.UserNameAttributeField != nil && len(*s.UserNameAttributeField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserNameAttributeField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClaimRegex sets the ClaimRegex field's value.
func (s *JwtTokenTypeConfiguration) SetClaimRegex(v string) *JwtTokenTypeConfiguration {
	s.ClaimRegex = &v
	return s
}

// SetGroupAttributeField sets the GroupAttributeField field's value.
func (s *JwtTokenTypeConfiguration) SetGroupAttributeField(v string) *JwtTokenTypeConfiguration {
	s.GroupAttributeField = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *JwtTokenTypeConfiguration) SetIssuer(v string) *JwtTokenTypeConfiguration {
	s.Issuer = &v
	return s
}

// SetKeyLocation sets the KeyLocation field's value.
func (s *JwtTokenTypeConfiguration) SetKeyLocation(v string) *JwtTokenTypeConfiguration {
	s.KeyLocation = &v
	return s
}

// SetSecretManagerArn sets the SecretManagerArn field's value.
func (s *JwtTokenTypeConfiguration) SetSecretManagerArn(v string) *JwtTokenTypeConfiguration {
	s.SecretManagerArn = &v
	return s
}

// SetURL sets the URL field's value.
func (s *JwtTokenTypeConfiguration) SetURL(v string) *JwtTokenTypeConfiguration {
	s.URL = &v
	return s
}

// SetUserNameAttributeField sets the UserNameAttributeField field's value.
func (s *JwtTokenTypeConfiguration) SetUserNameAttributeField(v string) *JwtTokenTypeConfiguration {
	s.UserNameAttributeField = &v
	return s
}

type ListDataSourceSyncJobsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of synchronization jobs to return in the response. If
	// there are fewer results in the list, this response contains only the actual
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to GetDataSourceSyncJobHistory was
	// truncated, include the NextToken to fetch the next set of jobs.
	NextToken *string `min:"1" type:"string"`

	// When specified, the synchronization jobs returned in the list are limited
	// to jobs between the specified dates.
	StartTimeFilter *TimeRange `type:"structure"`

	// When specified, only returns synchronization jobs with the Status field equal
	// to the specified status.
	StatusFilter *string `type:"string" enum:"DataSourceSyncJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourceSyncJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourceSyncJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourceSyncJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourceSyncJobsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ListDataSourceSyncJobsInput) SetId(v string) *ListDataSourceSyncJobsInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *ListDataSourceSyncJobsInput) SetIndexId(v string) *ListDataSourceSyncJobsInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourceSyncJobsInput) SetMaxResults(v int64) *ListDataSourceSyncJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourceSyncJobsInput) SetNextToken(v string) *ListDataSourceSyncJobsInput {
	s.NextToken = &v
	return s
}

// SetStartTimeFilter sets the StartTimeFilter field's value.
func (s *ListDataSourceSyncJobsInput) SetStartTimeFilter(v *TimeRange) *ListDataSourceSyncJobsInput {
	s.StartTimeFilter = v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListDataSourceSyncJobsInput) SetStatusFilter(v string) *ListDataSourceSyncJobsInput {
	s.StatusFilter = &v
	return s
}

type ListDataSourceSyncJobsOutput struct {
	_ struct{} `type:"structure"`

	// A history of synchronization jobs for the data source.
	History []*DataSourceSyncJob `type:"list"`

	// The GetDataSourceSyncJobHistory operation returns a page of vocabularies
	// at a time. The maximum size of the page is set by the MaxResults parameter.
	// If there are more jobs in the list than the page size, Amazon Kendra returns
	// the NextPage token. Include the token in the next request to the GetDataSourceSyncJobHistory
	// operation to return in the next page of jobs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourceSyncJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourceSyncJobsOutput) GoString() string {
	return s.String()
}

// SetHistory sets the History field's value.
func (s *ListDataSourceSyncJobsOutput) SetHistory(v []*DataSourceSyncJob) *ListDataSourceSyncJobsOutput {
	s.History = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourceSyncJobsOutput) SetNextToken(v string) *ListDataSourceSyncJobsOutput {
	s.NextToken = &v
	return s
}

type ListDataSourcesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of data sources to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Kendra returns a pagination token in the response. You can use this
	// pagination token to retrieve the next set of data sources (DataSourceSummaryItems).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourcesInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *ListDataSourcesInput) SetIndexId(v string) *ListDataSourcesInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourcesInput) SetMaxResults(v int64) *ListDataSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesInput) SetNextToken(v string) *ListDataSourcesInput {
	s.NextToken = &v
	return s
}

type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Kendra returns this token that you can
	// use in the subsequent request to retrieve the next set of data sources.
	NextToken *string `min:"1" type:"string"`

	// An array of summary information for one or more data sources.
	SummaryItems []*DataSourceSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesOutput) SetNextToken(v string) *ListDataSourcesOutput {
	s.NextToken = &v
	return s
}

// SetSummaryItems sets the SummaryItems field's value.
func (s *ListDataSourcesOutput) SetSummaryItems(v []*DataSourceSummary) *ListDataSourcesOutput {
	s.SummaryItems = v
	return s
}

type ListFaqsInput struct {
	_ struct{} `type:"structure"`

	// The index that contains the FAQ lists.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of FAQs to return in the response. If there are fewer
	// results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to ListFaqs was truncated, include
	// the NextToken to fetch the next set of FAQs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFaqsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFaqsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFaqsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFaqsInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *ListFaqsInput) SetIndexId(v string) *ListFaqsInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFaqsInput) SetMaxResults(v int64) *ListFaqsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFaqsInput) SetNextToken(v string) *ListFaqsInput {
	s.NextToken = &v
	return s
}

type ListFaqsOutput struct {
	_ struct{} `type:"structure"`

	// information about the FAQs associated with the specified index.
	FaqSummaryItems []*FaqSummary `type:"list"`

	// The ListFaqs operation returns a page of FAQs at a time. The maximum size
	// of the page is set by the MaxResults parameter. If there are more jobs in
	// the list than the page size, Amazon Kendra returns the NextPage token. Include
	// the token in the next request to the ListFaqs operation to return the next
	// page of FAQs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFaqsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFaqsOutput) GoString() string {
	return s.String()
}

// SetFaqSummaryItems sets the FaqSummaryItems field's value.
func (s *ListFaqsOutput) SetFaqSummaryItems(v []*FaqSummary) *ListFaqsOutput {
	s.FaqSummaryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFaqsOutput) SetNextToken(v string) *ListFaqsOutput {
	s.NextToken = &v
	return s
}

type ListGroupsOlderThanOrderingIdInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source for getting a list of groups mapped to
	// users before a given ordering timestamp identifier.
	DataSourceId *string `min:"1" type:"string"`

	// The identifier of the index for getting a list of groups mapped to users
	// before a given ordering or timestamp identifier.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum results shown for a list of groups that are mapped to users before
	// a given ordering or timestamp identifier.
	MaxResults *int64 `min:"1" type:"integer"`

	// The next items in the list of groups that go beyond the maximum.
	NextToken *string `min:"1" type:"string"`

	// The timestamp identifier used for the latest PUT or DELETE action for mapping
	// users to their groups.
	//
	// OrderingId is a required field
	OrderingId *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOlderThanOrderingIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOlderThanOrderingIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsOlderThanOrderingIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsOlderThanOrderingIdInput"}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrderingId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *ListGroupsOlderThanOrderingIdInput) SetDataSourceId(v string) *ListGroupsOlderThanOrderingIdInput {
	s.DataSourceId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *ListGroupsOlderThanOrderingIdInput) SetIndexId(v string) *ListGroupsOlderThanOrderingIdInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsOlderThanOrderingIdInput) SetMaxResults(v int64) *ListGroupsOlderThanOrderingIdInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOlderThanOrderingIdInput) SetNextToken(v string) *ListGroupsOlderThanOrderingIdInput {
	s.NextToken = &v
	return s
}

// SetOrderingId sets the OrderingId field's value.
func (s *ListGroupsOlderThanOrderingIdInput) SetOrderingId(v int64) *ListGroupsOlderThanOrderingIdInput {
	s.OrderingId = &v
	return s
}

type ListGroupsOlderThanOrderingIdOutput struct {
	_ struct{} `type:"structure"`

	// Summary information for list of groups that are mapped to users before a
	// given ordering or timestamp identifier.
	GroupsSummaries []*GroupSummary `type:"list"`

	// The next items in the list of groups that go beyond the maximum.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOlderThanOrderingIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOlderThanOrderingIdOutput) GoString() string {
	return s.String()
}

// SetGroupsSummaries sets the GroupsSummaries field's value.
func (s *ListGroupsOlderThanOrderingIdOutput) SetGroupsSummaries(v []*GroupSummary) *ListGroupsOlderThanOrderingIdOutput {
	s.GroupsSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOlderThanOrderingIdOutput) SetNextToken(v string) *ListGroupsOlderThanOrderingIdOutput {
	s.NextToken = &v
	return s
}

type ListIndicesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of data sources to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Kendra returns a pagination token in the response. You can use this
	// pagination token to retrieve the next set of indexes (DataSourceSummaryItems).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIndicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIndicesInput) SetMaxResults(v int64) *ListIndicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicesInput) SetNextToken(v string) *ListIndicesInput {
	s.NextToken = &v
	return s
}

type ListIndicesOutput struct {
	_ struct{} `type:"structure"`

	// An array of summary information for one or more indexes.
	IndexConfigurationSummaryItems []*IndexConfigurationSummary `type:"list"`

	// If the response is truncated, Amazon Kendra returns this token that you can
	// use in the subsequent request to retrieve the next set of indexes.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicesOutput) GoString() string {
	return s.String()
}

// SetIndexConfigurationSummaryItems sets the IndexConfigurationSummaryItems field's value.
func (s *ListIndicesOutput) SetIndexConfigurationSummaryItems(v []*IndexConfigurationSummary) *ListIndicesOutput {
	s.IndexConfigurationSummaryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicesOutput) SetNextToken(v string) *ListIndicesOutput {
	s.NextToken = &v
	return s
}

type ListQuerySuggestionsBlockListsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index for a list of all block lists that exist for
	// that index.
	//
	// For information on the current quota limits for block lists, see Quotas for
	// Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of block lists to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Kendra returns a pagination token in the response. You can use this
	// pagination token to retrieve the next set of block lists (BlockListSummaryItems).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQuerySuggestionsBlockListsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQuerySuggestionsBlockListsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQuerySuggestionsBlockListsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQuerySuggestionsBlockListsInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *ListQuerySuggestionsBlockListsInput) SetIndexId(v string) *ListQuerySuggestionsBlockListsInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQuerySuggestionsBlockListsInput) SetMaxResults(v int64) *ListQuerySuggestionsBlockListsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQuerySuggestionsBlockListsInput) SetNextToken(v string) *ListQuerySuggestionsBlockListsInput {
	s.NextToken = &v
	return s
}

type ListQuerySuggestionsBlockListsOutput struct {
	_ struct{} `type:"structure"`

	// Summary items for a block list.
	//
	// This includes summary items on the block list ID, block list name, when the
	// block list was created, when the block list was last updated, and the count
	// of block words/phrases in the block list.
	//
	// For information on the current quota limits for block lists, see Quotas for
	// Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
	BlockListSummaryItems []*QuerySuggestionsBlockListSummary `type:"list"`

	// If the response is truncated, Amazon Kendra returns this token that you can
	// use in the subsequent request to retrieve the next set of block lists.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQuerySuggestionsBlockListsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQuerySuggestionsBlockListsOutput) GoString() string {
	return s.String()
}

// SetBlockListSummaryItems sets the BlockListSummaryItems field's value.
func (s *ListQuerySuggestionsBlockListsOutput) SetBlockListSummaryItems(v []*QuerySuggestionsBlockListSummary) *ListQuerySuggestionsBlockListsOutput {
	s.BlockListSummaryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQuerySuggestionsBlockListsOutput) SetNextToken(v string) *ListQuerySuggestionsBlockListsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the index, FAQ, or data source to get a
	// list of tags for.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the index, FAQ, or data source.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListThesauriInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index associated with the thesaurus to list.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of thesauri to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Kendra returns a pagination token in the response. You can use this
	// pagination token to retrieve the next set of thesauri (ThesaurusSummaryItems).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThesauriInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThesauriInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThesauriInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListThesauriInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *ListThesauriInput) SetIndexId(v string) *ListThesauriInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListThesauriInput) SetMaxResults(v int64) *ListThesauriInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListThesauriInput) SetNextToken(v string) *ListThesauriInput {
	s.NextToken = &v
	return s
}

type ListThesauriOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Kendra returns this token that you can
	// use in the subsequent request to retrieve the next set of thesauri.
	NextToken *string `min:"1" type:"string"`

	// An array of summary information for one or more thesauruses.
	ThesaurusSummaryItems []*ThesaurusSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThesauriOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThesauriOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListThesauriOutput) SetNextToken(v string) *ListThesauriOutput {
	s.NextToken = &v
	return s
}

// SetThesaurusSummaryItems sets the ThesaurusSummaryItems field's value.
func (s *ListThesauriOutput) SetThesaurusSummaryItems(v []*ThesaurusSummary) *ListThesauriOutput {
	s.ThesaurusSummaryItems = v
	return s
}

// The sub groups that belong to a group.
type MemberGroup struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source for the sub group you want to map to a
	// group.
	DataSourceId *string `min:"1" type:"string"`

	// The identifier of the sub group you want to map to a group.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberGroup"}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *MemberGroup) SetDataSourceId(v string) *MemberGroup {
	s.DataSourceId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *MemberGroup) SetGroupId(v string) *MemberGroup {
	s.GroupId = &v
	return s
}

// The users that belong to a group.
type MemberUser struct {
	_ struct{} `type:"structure"`

	// The identifier of the user you want to map to a group.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberUser) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberUser) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberUser"}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserId sets the UserId field's value.
func (s *MemberUser) SetUserId(v string) *MemberUser {
	s.UserId = &v
	return s
}

// Provides configuration information for data sources that connect to OneDrive.
type OneDriveConfiguration struct {
	_ struct{} `type:"structure"`

	// A Boolean value that specifies whether local groups are disabled (True) or
	// enabled (False).
	DisableLocalGroups *bool `type:"boolean"`

	// List of regular expressions applied to documents. Items that match the exclusion
	// pattern are not indexed. If you provide both an inclusion pattern and an
	// exclusion pattern, any item that matches the exclusion pattern isn't indexed.
	//
	// The exclusion pattern is applied to the file name.
	ExclusionPatterns []*string `type:"list"`

	// A list of DataSourceToIndexFieldMapping objects that map Microsoft OneDrive
	// fields to custom fields in the Amazon Kendra index. You must first create
	// the index fields before you map OneDrive fields.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A list of regular expression patterns. Documents that match the pattern are
	// included in the index. Documents that don't match the pattern are excluded
	// from the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index.
	//
	// The exclusion pattern is applied to the file name.
	InclusionPatterns []*string `type:"list"`

	// A list of user accounts whose documents should be indexed.
	//
	// OneDriveUsers is a required field
	OneDriveUsers *OneDriveUsers `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an Secrets Managersecret that contains
	// the user name and password to connect to OneDrive. The user namd should be
	// the application ID for the OneDrive application, and the password is the
	// application key for the OneDrive application.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The Azure Active Directory domain of the organization.
	//
	// TenantDomain is a required field
	TenantDomain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OneDriveConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OneDriveConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OneDriveConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OneDriveConfiguration"}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.OneDriveUsers == nil {
		invalidParams.Add(request.NewErrParamRequired("OneDriveUsers"))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.TenantDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("TenantDomain"))
	}
	if s.TenantDomain != nil && len(*s.TenantDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TenantDomain", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OneDriveUsers != nil {
		if err := s.OneDriveUsers.Validate(); err != nil {
			invalidParams.AddNested("OneDriveUsers", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisableLocalGroups sets the DisableLocalGroups field's value.
func (s *OneDriveConfiguration) SetDisableLocalGroups(v bool) *OneDriveConfiguration {
	s.DisableLocalGroups = &v
	return s
}

// SetExclusionPatterns sets the ExclusionPatterns field's value.
func (s *OneDriveConfiguration) SetExclusionPatterns(v []*string) *OneDriveConfiguration {
	s.ExclusionPatterns = v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *OneDriveConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *OneDriveConfiguration {
	s.FieldMappings = v
	return s
}

// SetInclusionPatterns sets the InclusionPatterns field's value.
func (s *OneDriveConfiguration) SetInclusionPatterns(v []*string) *OneDriveConfiguration {
	s.InclusionPatterns = v
	return s
}

// SetOneDriveUsers sets the OneDriveUsers field's value.
func (s *OneDriveConfiguration) SetOneDriveUsers(v *OneDriveUsers) *OneDriveConfiguration {
	s.OneDriveUsers = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *OneDriveConfiguration) SetSecretArn(v string) *OneDriveConfiguration {
	s.SecretArn = &v
	return s
}

// SetTenantDomain sets the TenantDomain field's value.
func (s *OneDriveConfiguration) SetTenantDomain(v string) *OneDriveConfiguration {
	s.TenantDomain = &v
	return s
}

// User accounts whose documents should be indexed.
type OneDriveUsers struct {
	_ struct{} `type:"structure"`

	// A list of users whose documents should be indexed. Specify the user names
	// in email format, for example, username@tenantdomain. If you need to index
	// the documents of more than 100 users, use the OneDriveUserS3Path field to
	// specify the location of a file containing a list of users.
	OneDriveUserList []*string `min:"1" type:"list"`

	// The S3 bucket location of a file containing a list of users whose documents
	// should be indexed.
	OneDriveUserS3Path *S3Path `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OneDriveUsers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OneDriveUsers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OneDriveUsers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OneDriveUsers"}
	if s.OneDriveUserList != nil && len(s.OneDriveUserList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OneDriveUserList", 1))
	}
	if s.OneDriveUserS3Path != nil {
		if err := s.OneDriveUserS3Path.Validate(); err != nil {
			invalidParams.AddNested("OneDriveUserS3Path", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOneDriveUserList sets the OneDriveUserList field's value.
func (s *OneDriveUsers) SetOneDriveUserList(v []*string) *OneDriveUsers {
	s.OneDriveUserList = v
	return s
}

// SetOneDriveUserS3Path sets the OneDriveUserS3Path field's value.
func (s *OneDriveUsers) SetOneDriveUserS3Path(v *S3Path) *OneDriveUsers {
	s.OneDriveUserS3Path = v
	return s
}

// Provides user and group information for document access filtering.
type Principal struct {
	_ struct{} `type:"structure"`

	// Whether to allow or deny access to the principal.
	//
	// Access is a required field
	Access *string `type:"string" required:"true" enum:"ReadAccessType"`

	// The identifier of the data source the principal should access documents from.
	DataSourceId *string `min:"1" type:"string"`

	// The name of the user or group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of principal.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Principal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Principal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Principal"}
	if s.Access == nil {
		invalidParams.Add(request.NewErrParamRequired("Access"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccess sets the Access field's value.
func (s *Principal) SetAccess(v string) *Principal {
	s.Access = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *Principal) SetDataSourceId(v string) *Principal {
	s.DataSourceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Principal) SetName(v string) *Principal {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Principal) SetType(v string) *Principal {
	s.Type = &v
	return s
}

// Provides the configuration information for a web proxy to connect to website
// hosts.
type ProxyConfiguration struct {
	_ struct{} `type:"structure"`

	// Your secret ARN, which you can create in AWS Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	//
	// The credentials are optional. You use a secret if web proxy credentials are
	// required to connect to a website host. Amazon Kendra currently support basic
	// authentication to connect to a web proxy server. The secret stores your credentials.
	Credentials *string `min:"1" type:"string"`

	// The name of the website host you want to connect to via a web proxy server.
	//
	// For example, the host name of https://a.example.com/page1.html is "a.example.com".
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// The port number of the website host you want to connect to via a web proxy
	// server.
	//
	// For example, the port for https://a.example.com/page1.html is 443, the standard
	// port for HTTPS.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProxyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProxyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProxyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProxyConfiguration"}
	if s.Credentials != nil && len(*s.Credentials) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Credentials", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentials sets the Credentials field's value.
func (s *ProxyConfiguration) SetCredentials(v string) *ProxyConfiguration {
	s.Credentials = &v
	return s
}

// SetHost sets the Host field's value.
func (s *ProxyConfiguration) SetHost(v string) *ProxyConfiguration {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ProxyConfiguration) SetPort(v int64) *ProxyConfiguration {
	s.Port = &v
	return s
}

type PutPrincipalMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source you want to map users to their groups.
	//
	// This is useful if a group is tied to multiple data sources, but you only
	// want the group to access documents of a certain data source. For example,
	// the groups "Research", "Engineering", and "Sales and Marketing" are all tied
	// to the company's documents stored in the data sources Confluence and Salesforce.
	// However, "Sales and Marketing" team only needs access to customer-related
	// documents stored in Salesforce.
	DataSourceId *string `min:"1" type:"string"`

	// The identifier of the group you want to map its users to.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The list that contains your users or sub groups that belong the same group.
	//
	// For example, the group "Company" includes the user "CEO" and the sub groups
	// "Research", "Engineering", and "Sales and Marketing".
	//
	// If you have more than 1000 users and/or sub groups for a single group, you
	// need to provide the path to the S3 file that lists your users and sub groups
	// for a group. Your sub groups can contain more than 1000 users, but the list
	// of sub groups that belong to a group (and/or users) must be no more than
	// 1000.
	//
	// GroupMembers is a required field
	GroupMembers *GroupMembers `type:"structure" required:"true"`

	// The identifier of the index you want to map users to their groups.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The timestamp identifier you specify to ensure Amazon Kendra does not override
	// the latest PUT action with previous actions. The highest number ID, which
	// is the ordering ID, is the latest action you want to process and apply on
	// top of other actions with lower number IDs. This prevents previous actions
	// with lower number IDs from possibly overriding the latest action.
	//
	// The ordering ID can be the UNIX time of the last update you made to a group
	// members list. You would then provide this list when calling PutPrincipalMapping.
	// This ensures your PUT action for that updated group with the latest members
	// list doesn't get overwritten by earlier PUT actions for the same group which
	// are yet to be processed.
	//
	// The default ordering ID is the current UNIX time in milliseconds that the
	// action was received by Amazon Kendra.
	OrderingId *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of a role that has access to the S3 file that
	// contains your list of users or sub groups that belong to a group.
	//
	// For more information, see IAM roles for Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds).
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPrincipalMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPrincipalMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPrincipalMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPrincipalMappingInput"}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.GroupMembers == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupMembers"))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.GroupMembers != nil {
		if err := s.GroupMembers.Validate(); err != nil {
			invalidParams.AddNested("GroupMembers", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *PutPrincipalMappingInput) SetDataSourceId(v string) *PutPrincipalMappingInput {
	s.DataSourceId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *PutPrincipalMappingInput) SetGroupId(v string) *PutPrincipalMappingInput {
	s.GroupId = &v
	return s
}

// SetGroupMembers sets the GroupMembers field's value.
func (s *PutPrincipalMappingInput) SetGroupMembers(v *GroupMembers) *PutPrincipalMappingInput {
	s.GroupMembers = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *PutPrincipalMappingInput) SetIndexId(v string) *PutPrincipalMappingInput {
	s.IndexId = &v
	return s
}

// SetOrderingId sets the OrderingId field's value.
func (s *PutPrincipalMappingInput) SetOrderingId(v int64) *PutPrincipalMappingInput {
	s.OrderingId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PutPrincipalMappingInput) SetRoleArn(v string) *PutPrincipalMappingInput {
	s.RoleArn = &v
	return s
}

type PutPrincipalMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPrincipalMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPrincipalMappingOutput) GoString() string {
	return s.String()
}

type QueryInput struct {
	_ struct{} `type:"structure"`

	// Enables filtered searches based on document attributes. You can only provide
	// one attribute filter; however, the AndAllFilters, NotFilter, and OrAllFilters
	// parameters contain a list of other filters.
	//
	// The AttributeFilter parameter enables you to create a set of filtering rules
	// that a document must satisfy to be included in the query results.
	AttributeFilter *AttributeFilter `type:"structure"`

	// Overrides relevance tuning configurations of fields or attributes set at
	// the index level.
	//
	// If you use this API to override the relevance tuning configured at the index
	// level, but there is no relevance tuning configured at the index level, then
	// Amazon Kendra does not apply any relevance tuning.
	//
	// If there is relevance tuning configured at the index level, but you do not
	// use this API to override any relevance tuning in the index, then Amazon Kendra
	// uses the relevance tuning that is configured at the index level.
	//
	// If there is relevance tuning configured for fields at the index level, but
	// you use this API to override only some of these fields, then for the fields
	// you did not override, the importance is set to 1.
	DocumentRelevanceOverrideConfigurations []*DocumentRelevanceConfiguration `type:"list"`

	// An array of documents attributes. Amazon Kendra returns a count for each
	// attribute key specified. You can use this information to help narrow the
	// search for your user.
	Facets []*Facet `type:"list"`

	// The unique identifier of the index to search. The identifier is returned
	// in the response from the CreateIndex operation.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// Query results are returned in pages the size of the PageSize parameter. By
	// default, Amazon Kendra returns the first page of results. Use this parameter
	// to get result pages after the first one.
	PageNumber *int64 `type:"integer"`

	// Sets the number of results that are returned in each page of results. The
	// default page size is 10. The maximum number of results returned is 100. If
	// you ask for more than 100 results, only 100 are returned.
	PageSize *int64 `type:"integer"`

	// Sets the type of query. Only results for the specified query type are returned.
	QueryResultTypeFilter *string `type:"string" enum:"QueryResultType"`

	// The text to search for.
	//
	// QueryText is a required field
	QueryText *string `min:"1" type:"string" required:"true"`

	// An array of document attributes to include in the response. No other document
	// attributes are included in the response. By default all document attributes
	// are included in the response.
	RequestedDocumentAttributes []*string `min:"1" type:"list"`

	// Provides information that determines how the results of the query are sorted.
	// You can set the field that Amazon Kendra should sort the results on, and
	// specify whether the results should be sorted in ascending or descending order.
	// In the case of ties in sorting the results, the results are sorted by relevance.
	//
	// If you don't provide sorting configuration, the results are sorted by the
	// relevance that Amazon Kendra determines for the result.
	SortingConfiguration *SortingConfiguration `type:"structure"`

	// The user context token.
	UserContext *UserContext `type:"structure"`

	// Provides an identifier for a specific user. The VisitorId should be a unique
	// identifier, such as a GUID. Don't use personally identifiable information,
	// such as the user's email address, as the VisitorId.
	VisitorId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.QueryText == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryText"))
	}
	if s.QueryText != nil && len(*s.QueryText) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryText", 1))
	}
	if s.RequestedDocumentAttributes != nil && len(s.RequestedDocumentAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestedDocumentAttributes", 1))
	}
	if s.VisitorId != nil && len(*s.VisitorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VisitorId", 1))
	}
	if s.AttributeFilter != nil {
		if err := s.AttributeFilter.Validate(); err != nil {
			invalidParams.AddNested("AttributeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentRelevanceOverrideConfigurations != nil {
		for i, v := range s.DocumentRelevanceOverrideConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentRelevanceOverrideConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Facets != nil {
		for i, v := range s.Facets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Facets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortingConfiguration != nil {
		if err := s.SortingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SortingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.UserContext != nil {
		if err := s.UserContext.Validate(); err != nil {
			invalidParams.AddNested("UserContext", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeFilter sets the AttributeFilter field's value.
func (s *QueryInput) SetAttributeFilter(v *AttributeFilter) *QueryInput {
	s.AttributeFilter = v
	return s
}

// SetDocumentRelevanceOverrideConfigurations sets the DocumentRelevanceOverrideConfigurations field's value.
func (s *QueryInput) SetDocumentRelevanceOverrideConfigurations(v []*DocumentRelevanceConfiguration) *QueryInput {
	s.DocumentRelevanceOverrideConfigurations = v
	return s
}

// SetFacets sets the Facets field's value.
func (s *QueryInput) SetFacets(v []*Facet) *QueryInput {
	s.Facets = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *QueryInput) SetIndexId(v string) *QueryInput {
	s.IndexId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *QueryInput) SetPageNumber(v int64) *QueryInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *QueryInput) SetPageSize(v int64) *QueryInput {
	s.PageSize = &v
	return s
}

// SetQueryResultTypeFilter sets the QueryResultTypeFilter field's value.
func (s *QueryInput) SetQueryResultTypeFilter(v string) *QueryInput {
	s.QueryResultTypeFilter = &v
	return s
}

// SetQueryText sets the QueryText field's value.
func (s *QueryInput) SetQueryText(v string) *QueryInput {
	s.QueryText = &v
	return s
}

// SetRequestedDocumentAttributes sets the RequestedDocumentAttributes field's value.
func (s *QueryInput) SetRequestedDocumentAttributes(v []*string) *QueryInput {
	s.RequestedDocumentAttributes = v
	return s
}

// SetSortingConfiguration sets the SortingConfiguration field's value.
func (s *QueryInput) SetSortingConfiguration(v *SortingConfiguration) *QueryInput {
	s.SortingConfiguration = v
	return s
}

// SetUserContext sets the UserContext field's value.
func (s *QueryInput) SetUserContext(v *UserContext) *QueryInput {
	s.UserContext = v
	return s
}

// SetVisitorId sets the VisitorId field's value.
func (s *QueryInput) SetVisitorId(v string) *QueryInput {
	s.VisitorId = &v
	return s
}

type QueryOutput struct {
	_ struct{} `type:"structure"`

	// Contains the facet results. A FacetResult contains the counts for each attribute
	// key that was specified in the Facets input parameter.
	FacetResults []*FacetResult `type:"list"`

	// The unique identifier for the search. You use QueryId to identify the search
	// when using the feedback API.
	QueryId *string `min:"1" type:"string"`

	// The results of the search.
	ResultItems []*QueryResultItem `type:"list"`

	// The total number of items found by the search; however, you can only retrieve
	// up to 100 items. For example, if the search found 192 items, you can only
	// retrieve the first 100 of the items.
	TotalNumberOfResults *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryOutput) GoString() string {
	return s.String()
}

// SetFacetResults sets the FacetResults field's value.
func (s *QueryOutput) SetFacetResults(v []*FacetResult) *QueryOutput {
	s.FacetResults = v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *QueryOutput) SetQueryId(v string) *QueryOutput {
	s.QueryId = &v
	return s
}

// SetResultItems sets the ResultItems field's value.
func (s *QueryOutput) SetResultItems(v []*QueryResultItem) *QueryOutput {
	s.ResultItems = v
	return s
}

// SetTotalNumberOfResults sets the TotalNumberOfResults field's value.
func (s *QueryOutput) SetTotalNumberOfResults(v int64) *QueryOutput {
	s.TotalNumberOfResults = &v
	return s
}

// A single query result.
//
// A query result contains information about a document returned by the query.
// This includes the original location of the document, a list of attributes
// assigned to the document, and relevant text from the document that satisfies
// the query.
type QueryResultItem struct {
	_ struct{} `type:"structure"`

	// One or more additional attributes associated with the query result.
	AdditionalAttributes []*AdditionalResultAttribute `type:"list"`

	// An array of document attributes for the document that the query result maps
	// to. For example, the document author (Author) or the source URI (SourceUri)
	// of the document.
	DocumentAttributes []*DocumentAttribute `type:"list"`

	// An extract of the text in the document. Contains information about highlighting
	// the relevant terms in the excerpt.
	DocumentExcerpt *TextWithHighlights `type:"structure"`

	// The unique identifier for the document.
	DocumentId *string `min:"1" type:"string"`

	// The title of the document. Contains the text of the title and information
	// for highlighting the relevant terms in the title.
	DocumentTitle *TextWithHighlights `type:"structure"`

	// The URI of the original location of the document.
	DocumentURI *string `min:"1" type:"string"`

	// A token that identifies a particular result from a particular query. Use
	// this token to provide click-through feedback for the result. For more information,
	// see Submitting feedback (https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html).
	FeedbackToken *string `min:"1" type:"string"`

	// The unique identifier for the query result.
	Id *string `min:"1" type:"string"`

	// Indicates the confidence that Amazon Kendra has that a result matches the
	// query that you provided. Each result is placed into a bin that indicates
	// the confidence, VERY_HIGH, HIGH, MEDIUM and LOW. You can use the score to
	// determine if a response meets the confidence needed for your application.
	//
	// The field is only set to LOW when the Type field is set to DOCUMENT and Amazon
	// Kendra is not confident that the result matches the query.
	ScoreAttributes *ScoreAttributes `type:"structure"`

	// The type of document.
	Type *string `type:"string" enum:"QueryResultType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryResultItem) GoString() string {
	return s.String()
}

// SetAdditionalAttributes sets the AdditionalAttributes field's value.
func (s *QueryResultItem) SetAdditionalAttributes(v []*AdditionalResultAttribute) *QueryResultItem {
	s.AdditionalAttributes = v
	return s
}

// SetDocumentAttributes sets the DocumentAttributes field's value.
func (s *QueryResultItem) SetDocumentAttributes(v []*DocumentAttribute) *QueryResultItem {
	s.DocumentAttributes = v
	return s
}

// SetDocumentExcerpt sets the DocumentExcerpt field's value.
func (s *QueryResultItem) SetDocumentExcerpt(v *TextWithHighlights) *QueryResultItem {
	s.DocumentExcerpt = v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *QueryResultItem) SetDocumentId(v string) *QueryResultItem {
	s.DocumentId = &v
	return s
}

// SetDocumentTitle sets the DocumentTitle field's value.
func (s *QueryResultItem) SetDocumentTitle(v *TextWithHighlights) *QueryResultItem {
	s.DocumentTitle = v
	return s
}

// SetDocumentURI sets the DocumentURI field's value.
func (s *QueryResultItem) SetDocumentURI(v string) *QueryResultItem {
	s.DocumentURI = &v
	return s
}

// SetFeedbackToken sets the FeedbackToken field's value.
func (s *QueryResultItem) SetFeedbackToken(v string) *QueryResultItem {
	s.FeedbackToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *QueryResultItem) SetId(v string) *QueryResultItem {
	s.Id = &v
	return s
}

// SetScoreAttributes sets the ScoreAttributes field's value.
func (s *QueryResultItem) SetScoreAttributes(v *ScoreAttributes) *QueryResultItem {
	s.ScoreAttributes = v
	return s
}

// SetType sets the Type field's value.
func (s *QueryResultItem) SetType(v string) *QueryResultItem {
	s.Type = &v
	return s
}

// Summary information on a query suggestions block list.
//
// This includes information on the block list ID, block list name, when the
// block list was created, when the block list was last updated, and the count
// of block words/phrases in the block list.
//
// For information on the current quota limits for block lists, see Quotas for
// Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
type QuerySuggestionsBlockListSummary struct {
	_ struct{} `type:"structure"`

	// The date-time summary information for a query suggestions block list was
	// last created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of a block list.
	Id *string `min:"36" type:"string"`

	// The number of items in the block list file.
	ItemCount *int64 `type:"integer"`

	// The name of the block list.
	Name *string `min:"1" type:"string"`

	// The status of the block list.
	Status *string `type:"string" enum:"QuerySuggestionsBlockListStatus"`

	// The date-time the block list was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuerySuggestionsBlockListSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuerySuggestionsBlockListSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *QuerySuggestionsBlockListSummary) SetCreatedAt(v time.Time) *QuerySuggestionsBlockListSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *QuerySuggestionsBlockListSummary) SetId(v string) *QuerySuggestionsBlockListSummary {
	s.Id = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *QuerySuggestionsBlockListSummary) SetItemCount(v int64) *QuerySuggestionsBlockListSummary {
	s.ItemCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *QuerySuggestionsBlockListSummary) SetName(v string) *QuerySuggestionsBlockListSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *QuerySuggestionsBlockListSummary) SetStatus(v string) *QuerySuggestionsBlockListSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *QuerySuggestionsBlockListSummary) SetUpdatedAt(v time.Time) *QuerySuggestionsBlockListSummary {
	s.UpdatedAt = &v
	return s
}

// Provides information for manually tuning the relevance of a field in a search.
// When a query includes terms that match the field, the results are given a
// boost in the response based on these tuning parameters.
type Relevance struct {
	_ struct{} `type:"structure"`

	// Specifies the time period that the boost applies to. For example, to make
	// the boost apply to documents with the field value within the last month,
	// you would use "2628000s". Once the field value is beyond the specified range,
	// the effect of the boost drops off. The higher the importance, the faster
	// the effect drops off. If you don't specify a value, the default is 3 months.
	// The value of the field is a numeric string followed by the character "s",
	// for example "86400s" for one day, or "604800s" for one week.
	//
	// Only applies to DATE fields.
	Duration *string `min:"1" type:"string"`

	// Indicates that this field determines how "fresh" a document is. For example,
	// if document 1 was created on November 5, and document 2 was created on October
	// 31, document 1 is "fresher" than document 2. You can only set the Freshness
	// field on one DATE type field. Only applies to DATE fields.
	Freshness *bool `type:"boolean"`

	// The relative importance of the field in the search. Larger numbers provide
	// more of a boost than smaller numbers.
	Importance *int64 `min:"1" type:"integer"`

	// Determines how values should be interpreted.
	//
	// When the RankOrder field is ASCENDING, higher numbers are better. For example,
	// a document with a rating score of 10 is higher ranking than a document with
	// a rating score of 1.
	//
	// When the RankOrder field is DESCENDING, lower numbers are better. For example,
	// in a task tracking application, a priority 1 task is more important than
	// a priority 5 task.
	//
	// Only applies to LONG and DOUBLE fields.
	RankOrder *string `type:"string" enum:"Order"`

	// A list of values that should be given a different boost when they appear
	// in the result list. For example, if you are boosting a field called "department,"
	// query terms that match the department field are boosted in the result. However,
	// you can add entries from the department field to boost documents with those
	// values higher.
	//
	// For example, you can add entries to the map with names of departments. If
	// you add "HR",5 and "Legal",3 those departments are given special attention
	// when they appear in the metadata of a document. When those terms appear they
	// are given the specified importance instead of the regular importance for
	// the boost.
	ValueImportanceMap map[string]*int64 `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Relevance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Relevance) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Relevance) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Relevance"}
	if s.Duration != nil && len(*s.Duration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Duration", 1))
	}
	if s.Importance != nil && *s.Importance < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Importance", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *Relevance) SetDuration(v string) *Relevance {
	s.Duration = &v
	return s
}

// SetFreshness sets the Freshness field's value.
func (s *Relevance) SetFreshness(v bool) *Relevance {
	s.Freshness = &v
	return s
}

// SetImportance sets the Importance field's value.
func (s *Relevance) SetImportance(v int64) *Relevance {
	s.Importance = &v
	return s
}

// SetRankOrder sets the RankOrder field's value.
func (s *Relevance) SetRankOrder(v string) *Relevance {
	s.RankOrder = &v
	return s
}

// SetValueImportanceMap sets the ValueImportanceMap field's value.
func (s *Relevance) SetValueImportanceMap(v map[string]*int64) *Relevance {
	s.ValueImportanceMap = v
	return s
}

// Provides feedback on how relevant a document is to a search. Your application
// uses the SubmitFeedback operation to provide relevance information.
type RelevanceFeedback struct {
	_ struct{} `type:"structure"`

	// Whether to document was relevant or not relevant to the search.
	//
	// RelevanceValue is a required field
	RelevanceValue *string `type:"string" required:"true" enum:"RelevanceType"`

	// The unique identifier of the search result that the user provided relevance
	// feedback for.
	//
	// ResultId is a required field
	ResultId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelevanceFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelevanceFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelevanceFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelevanceFeedback"}
	if s.RelevanceValue == nil {
		invalidParams.Add(request.NewErrParamRequired("RelevanceValue"))
	}
	if s.ResultId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultId"))
	}
	if s.ResultId != nil && len(*s.ResultId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResultId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelevanceValue sets the RelevanceValue field's value.
func (s *RelevanceFeedback) SetRelevanceValue(v string) *RelevanceFeedback {
	s.RelevanceValue = &v
	return s
}

// SetResultId sets the ResultId field's value.
func (s *RelevanceFeedback) SetResultId(v string) *RelevanceFeedback {
	s.ResultId = &v
	return s
}

type ResourceAlreadyExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistException) Code() string {
	return "ResourceAlreadyExistException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides configuration information for a data source to index documents in
// an Amazon S3 bucket.
type S3DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides the path to the S3 bucket that contains the user context filtering
	// files for the data source. For the format of the file, see Access control
	// for S3 data sources (https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html).
	AccessControlListConfiguration *AccessControlListConfiguration `type:"structure"`

	// The name of the bucket that contains the documents.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// Document metadata files that contain information such as the document access
	// control information, source URI, document author, and custom attributes.
	// Each metadata file contains metadata about a single document.
	DocumentsMetadataConfiguration *DocumentsMetadataConfiguration `type:"structure"`

	// A list of glob patterns for documents that should not be indexed. If a document
	// that matches an inclusion prefix or inclusion pattern also matches an exclusion
	// pattern, the document is not indexed.
	//
	// Some examples (https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters)
	// are:
	//
	//    * *.png , *.jpg will exclude all PNG and JPEG image files in a directory
	//    (files with the extensions .png and .jpg).
	//
	//    * *internal* will exclude all files in a directory that contain 'internal'
	//    in the file name, such as 'internal', 'internal_only', 'company_internal'.
	//
	//    * **/*internal* will exclude all internal-related files in a directory
	//    and its subdirectories.
	ExclusionPatterns []*string `type:"list"`

	// A list of glob patterns for documents that should be indexed. If a document
	// that matches an inclusion pattern also matches an exclusion pattern, the
	// document is not indexed.
	//
	// Some examples (https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters)
	// are:
	//
	//    * *.txt will include all text files in a directory (files with the extension
	//    .txt).
	//
	//    * **/*.txt will include all text files in a directory and its subdirectories.
	//
	//    * *tax* will include all files in a directory that contain 'tax' in the
	//    file name, such as 'tax', 'taxes', 'income_tax'.
	InclusionPatterns []*string `type:"list"`

	// A list of S3 prefixes for the documents that should be included in the index.
	InclusionPrefixes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DataSourceConfiguration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.AccessControlListConfiguration != nil {
		if err := s.AccessControlListConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AccessControlListConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentsMetadataConfiguration != nil {
		if err := s.DocumentsMetadataConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DocumentsMetadataConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlListConfiguration sets the AccessControlListConfiguration field's value.
func (s *S3DataSourceConfiguration) SetAccessControlListConfiguration(v *AccessControlListConfiguration) *S3DataSourceConfiguration {
	s.AccessControlListConfiguration = v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *S3DataSourceConfiguration) SetBucketName(v string) *S3DataSourceConfiguration {
	s.BucketName = &v
	return s
}

// SetDocumentsMetadataConfiguration sets the DocumentsMetadataConfiguration field's value.
func (s *S3DataSourceConfiguration) SetDocumentsMetadataConfiguration(v *DocumentsMetadataConfiguration) *S3DataSourceConfiguration {
	s.DocumentsMetadataConfiguration = v
	return s
}

// SetExclusionPatterns sets the ExclusionPatterns field's value.
func (s *S3DataSourceConfiguration) SetExclusionPatterns(v []*string) *S3DataSourceConfiguration {
	s.ExclusionPatterns = v
	return s
}

// SetInclusionPatterns sets the InclusionPatterns field's value.
func (s *S3DataSourceConfiguration) SetInclusionPatterns(v []*string) *S3DataSourceConfiguration {
	s.InclusionPatterns = v
	return s
}

// SetInclusionPrefixes sets the InclusionPrefixes field's value.
func (s *S3DataSourceConfiguration) SetInclusionPrefixes(v []*string) *S3DataSourceConfiguration {
	s.InclusionPrefixes = v
	return s
}

// Information required to find a specific file in an Amazon S3 bucket.
type S3Path struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that contains the file.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name of the file.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Path) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Path) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Path) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Path"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Path) SetBucket(v string) *S3Path {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Path) SetKey(v string) *S3Path {
	s.Key = &v
	return s
}

// Defines configuration for syncing a Salesforce chatter feed. The contents
// of the object comes from the Salesforce FeedItem table.
type SalesforceChatterFeedConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the column in the Salesforce FeedItem table that contains the
	// content to index. Typically this is the Body column.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the column in the Salesforce FeedItem table that contains the
	// title of the document. This is typically the Title column.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// Filters the documents in the feed based on status of the user. When you specify
	// ACTIVE_USERS only documents from users who have an active account are indexed.
	// When you specify STANDARD_USER only documents for Salesforce standard users
	// are documented. You can specify both.
	IncludeFilterTypes []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceChatterFeedConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceChatterFeedConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceChatterFeedConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceChatterFeedConfiguration"}
	if s.DocumentDataFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.IncludeFilterTypes != nil && len(s.IncludeFilterTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IncludeFilterTypes", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentDataFieldName sets the DocumentDataFieldName field's value.
func (s *SalesforceChatterFeedConfiguration) SetDocumentDataFieldName(v string) *SalesforceChatterFeedConfiguration {
	s.DocumentDataFieldName = &v
	return s
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *SalesforceChatterFeedConfiguration) SetDocumentTitleFieldName(v string) *SalesforceChatterFeedConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *SalesforceChatterFeedConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *SalesforceChatterFeedConfiguration {
	s.FieldMappings = v
	return s
}

// SetIncludeFilterTypes sets the IncludeFilterTypes field's value.
func (s *SalesforceChatterFeedConfiguration) SetIncludeFilterTypes(v []*string) *SalesforceChatterFeedConfiguration {
	s.IncludeFilterTypes = v
	return s
}

// Provides configuration information for connecting to a Salesforce data source.
type SalesforceConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies configuration information for Salesforce chatter feeds.
	ChatterFeedConfiguration *SalesforceChatterFeedConfiguration `type:"structure"`

	// Indicates whether Amazon Kendra should index attachments to Salesforce objects.
	CrawlAttachments *bool `type:"boolean"`

	// A list of regular expression patterns. Documents that match the patterns
	// are excluded from the index. Documents that don't match the patterns are
	// included in the index. If a document matches both an exclusion pattern and
	// an inclusion pattern, the document is not included in the index.
	//
	// The regex is applied to the name of the attached file.
	ExcludeAttachmentFilePatterns []*string `type:"list"`

	// A list of regular expression patterns. Documents that match the patterns
	// are included in the index. Documents that don't match the patterns are excluded
	// from the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index.
	//
	// The regex is applied to the name of the attached file.
	IncludeAttachmentFilePatterns []*string `type:"list"`

	// Specifies configuration information for the knowledge article types that
	// Amazon Kendra indexes. Amazon Kendra indexes standard knowledge articles
	// and the standard fields of knowledge articles, or the custom fields of custom
	// knowledge articles, but not both.
	KnowledgeArticleConfiguration *SalesforceKnowledgeArticleConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of an Secrets Managersecret that contains
	// the key/value pairs required to connect to your Salesforce instance. The
	// secret must contain a JSON structure with the following keys:
	//
	//    * authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to
	//    get an OAUTH token.
	//
	//    * consumerKey - The application public key generated when you created
	//    your Salesforce application.
	//
	//    * consumerSecret - The application private key generated when you created
	//    your Salesforce application.
	//
	//    * password - The password associated with the user logging in to the Salesforce
	//    instance.
	//
	//    * securityToken - The token associated with the user account logging in
	//    to the Salesforce instance.
	//
	//    * username - The user name of the user logging in to the Salesforce instance.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The instance URL for the Salesforce site that you want to index.
	//
	// ServerUrl is a required field
	ServerUrl *string `min:"1" type:"string" required:"true"`

	// Provides configuration information for processing attachments to Salesforce
	// standard objects.
	StandardObjectAttachmentConfiguration *SalesforceStandardObjectAttachmentConfiguration `type:"structure"`

	// Specifies the Salesforce standard objects that Amazon Kendra indexes.
	StandardObjectConfigurations []*SalesforceStandardObjectConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceConfiguration"}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.ServerUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerUrl"))
	}
	if s.ServerUrl != nil && len(*s.ServerUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerUrl", 1))
	}
	if s.StandardObjectConfigurations != nil && len(s.StandardObjectConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardObjectConfigurations", 1))
	}
	if s.ChatterFeedConfiguration != nil {
		if err := s.ChatterFeedConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChatterFeedConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.KnowledgeArticleConfiguration != nil {
		if err := s.KnowledgeArticleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeArticleConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StandardObjectAttachmentConfiguration != nil {
		if err := s.StandardObjectAttachmentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StandardObjectAttachmentConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StandardObjectConfigurations != nil {
		for i, v := range s.StandardObjectConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StandardObjectConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatterFeedConfiguration sets the ChatterFeedConfiguration field's value.
func (s *SalesforceConfiguration) SetChatterFeedConfiguration(v *SalesforceChatterFeedConfiguration) *SalesforceConfiguration {
	s.ChatterFeedConfiguration = v
	return s
}

// SetCrawlAttachments sets the CrawlAttachments field's value.
func (s *SalesforceConfiguration) SetCrawlAttachments(v bool) *SalesforceConfiguration {
	s.CrawlAttachments = &v
	return s
}

// SetExcludeAttachmentFilePatterns sets the ExcludeAttachmentFilePatterns field's value.
func (s *SalesforceConfiguration) SetExcludeAttachmentFilePatterns(v []*string) *SalesforceConfiguration {
	s.ExcludeAttachmentFilePatterns = v
	return s
}

// SetIncludeAttachmentFilePatterns sets the IncludeAttachmentFilePatterns field's value.
func (s *SalesforceConfiguration) SetIncludeAttachmentFilePatterns(v []*string) *SalesforceConfiguration {
	s.IncludeAttachmentFilePatterns = v
	return s
}

// SetKnowledgeArticleConfiguration sets the KnowledgeArticleConfiguration field's value.
func (s *SalesforceConfiguration) SetKnowledgeArticleConfiguration(v *SalesforceKnowledgeArticleConfiguration) *SalesforceConfiguration {
	s.KnowledgeArticleConfiguration = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *SalesforceConfiguration) SetSecretArn(v string) *SalesforceConfiguration {
	s.SecretArn = &v
	return s
}

// SetServerUrl sets the ServerUrl field's value.
func (s *SalesforceConfiguration) SetServerUrl(v string) *SalesforceConfiguration {
	s.ServerUrl = &v
	return s
}

// SetStandardObjectAttachmentConfiguration sets the StandardObjectAttachmentConfiguration field's value.
func (s *SalesforceConfiguration) SetStandardObjectAttachmentConfiguration(v *SalesforceStandardObjectAttachmentConfiguration) *SalesforceConfiguration {
	s.StandardObjectAttachmentConfiguration = v
	return s
}

// SetStandardObjectConfigurations sets the StandardObjectConfigurations field's value.
func (s *SalesforceConfiguration) SetStandardObjectConfigurations(v []*SalesforceStandardObjectConfiguration) *SalesforceConfiguration {
	s.StandardObjectConfigurations = v
	return s
}

// Provides configuration information for indexing Salesforce custom articles.
type SalesforceCustomKnowledgeArticleTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the field in the custom knowledge article that contains the document
	// data to index.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the field in the custom knowledge article that contains the document
	// title.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// One or more objects that map fields in the custom knowledge article to fields
	// in the Amazon Kendra index.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// The name of the configuration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceCustomKnowledgeArticleTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceCustomKnowledgeArticleTypeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceCustomKnowledgeArticleTypeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceCustomKnowledgeArticleTypeConfiguration"}
	if s.DocumentDataFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentDataFieldName sets the DocumentDataFieldName field's value.
func (s *SalesforceCustomKnowledgeArticleTypeConfiguration) SetDocumentDataFieldName(v string) *SalesforceCustomKnowledgeArticleTypeConfiguration {
	s.DocumentDataFieldName = &v
	return s
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *SalesforceCustomKnowledgeArticleTypeConfiguration) SetDocumentTitleFieldName(v string) *SalesforceCustomKnowledgeArticleTypeConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *SalesforceCustomKnowledgeArticleTypeConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *SalesforceCustomKnowledgeArticleTypeConfiguration {
	s.FieldMappings = v
	return s
}

// SetName sets the Name field's value.
func (s *SalesforceCustomKnowledgeArticleTypeConfiguration) SetName(v string) *SalesforceCustomKnowledgeArticleTypeConfiguration {
	s.Name = &v
	return s
}

// Specifies configuration information for the knowledge article types that
// Amazon Kendra indexes. Amazon Kendra indexes standard knowledge articles
// and the standard fields of knowledge articles, or the custom fields of custom
// knowledge articles, but not both
type SalesforceKnowledgeArticleConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides configuration information for custom Salesforce knowledge articles.
	CustomKnowledgeArticleTypeConfigurations []*SalesforceCustomKnowledgeArticleTypeConfiguration `min:"1" type:"list"`

	// Specifies the document states that should be included when Amazon Kendra
	// indexes knowledge articles. You must specify at least one state.
	//
	// IncludedStates is a required field
	IncludedStates []*string `min:"1" type:"list" required:"true"`

	// Provides configuration information for standard Salesforce knowledge articles.
	StandardKnowledgeArticleTypeConfiguration *SalesforceStandardKnowledgeArticleTypeConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceKnowledgeArticleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceKnowledgeArticleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceKnowledgeArticleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceKnowledgeArticleConfiguration"}
	if s.CustomKnowledgeArticleTypeConfigurations != nil && len(s.CustomKnowledgeArticleTypeConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKnowledgeArticleTypeConfigurations", 1))
	}
	if s.IncludedStates == nil {
		invalidParams.Add(request.NewErrParamRequired("IncludedStates"))
	}
	if s.IncludedStates != nil && len(s.IncludedStates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IncludedStates", 1))
	}
	if s.CustomKnowledgeArticleTypeConfigurations != nil {
		for i, v := range s.CustomKnowledgeArticleTypeConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomKnowledgeArticleTypeConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StandardKnowledgeArticleTypeConfiguration != nil {
		if err := s.StandardKnowledgeArticleTypeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StandardKnowledgeArticleTypeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKnowledgeArticleTypeConfigurations sets the CustomKnowledgeArticleTypeConfigurations field's value.
func (s *SalesforceKnowledgeArticleConfiguration) SetCustomKnowledgeArticleTypeConfigurations(v []*SalesforceCustomKnowledgeArticleTypeConfiguration) *SalesforceKnowledgeArticleConfiguration {
	s.CustomKnowledgeArticleTypeConfigurations = v
	return s
}

// SetIncludedStates sets the IncludedStates field's value.
func (s *SalesforceKnowledgeArticleConfiguration) SetIncludedStates(v []*string) *SalesforceKnowledgeArticleConfiguration {
	s.IncludedStates = v
	return s
}

// SetStandardKnowledgeArticleTypeConfiguration sets the StandardKnowledgeArticleTypeConfiguration field's value.
func (s *SalesforceKnowledgeArticleConfiguration) SetStandardKnowledgeArticleTypeConfiguration(v *SalesforceStandardKnowledgeArticleTypeConfiguration) *SalesforceKnowledgeArticleConfiguration {
	s.StandardKnowledgeArticleTypeConfiguration = v
	return s
}

// Provides configuration information for standard Salesforce knowledge articles.
type SalesforceStandardKnowledgeArticleTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the field that contains the document data to index.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the field that contains the document title.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// One or more objects that map fields in the knowledge article to Amazon Kendra
	// index fields. The index field must exist before you can map a Salesforce
	// field to it.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceStandardKnowledgeArticleTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceStandardKnowledgeArticleTypeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceStandardKnowledgeArticleTypeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceStandardKnowledgeArticleTypeConfiguration"}
	if s.DocumentDataFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentDataFieldName sets the DocumentDataFieldName field's value.
func (s *SalesforceStandardKnowledgeArticleTypeConfiguration) SetDocumentDataFieldName(v string) *SalesforceStandardKnowledgeArticleTypeConfiguration {
	s.DocumentDataFieldName = &v
	return s
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *SalesforceStandardKnowledgeArticleTypeConfiguration) SetDocumentTitleFieldName(v string) *SalesforceStandardKnowledgeArticleTypeConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *SalesforceStandardKnowledgeArticleTypeConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *SalesforceStandardKnowledgeArticleTypeConfiguration {
	s.FieldMappings = v
	return s
}

// Provides configuration information for processing attachments to Salesforce
// standard objects.
type SalesforceStandardObjectAttachmentConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the field used for the document title.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// One or more objects that map fields in attachments to Amazon Kendra index
	// fields.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceStandardObjectAttachmentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceStandardObjectAttachmentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceStandardObjectAttachmentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceStandardObjectAttachmentConfiguration"}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *SalesforceStandardObjectAttachmentConfiguration) SetDocumentTitleFieldName(v string) *SalesforceStandardObjectAttachmentConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *SalesforceStandardObjectAttachmentConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *SalesforceStandardObjectAttachmentConfiguration {
	s.FieldMappings = v
	return s
}

// Specifies configuration information for indexing a single standard object.
type SalesforceStandardObjectConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the field in the standard object table that contains the document
	// contents.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the field in the standard object table that contains the document
	// title.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// One or more objects that map fields in the standard object to Amazon Kendra
	// index fields. The index field must exist before you can map a Salesforce
	// field to it.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// The name of the standard object.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"SalesforceStandardObjectName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceStandardObjectConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceStandardObjectConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceStandardObjectConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceStandardObjectConfiguration"}
	if s.DocumentDataFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentDataFieldName sets the DocumentDataFieldName field's value.
func (s *SalesforceStandardObjectConfiguration) SetDocumentDataFieldName(v string) *SalesforceStandardObjectConfiguration {
	s.DocumentDataFieldName = &v
	return s
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *SalesforceStandardObjectConfiguration) SetDocumentTitleFieldName(v string) *SalesforceStandardObjectConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *SalesforceStandardObjectConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *SalesforceStandardObjectConfiguration {
	s.FieldMappings = v
	return s
}

// SetName sets the Name field's value.
func (s *SalesforceStandardObjectConfiguration) SetName(v string) *SalesforceStandardObjectConfiguration {
	s.Name = &v
	return s
}

// Provides a relative ranking that indicates how confident Amazon Kendra is
// that the response matches the query.
type ScoreAttributes struct {
	_ struct{} `type:"structure"`

	// A relative ranking for how well the response matches the query.
	ScoreConfidence *string `type:"string" enum:"ScoreConfidence"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScoreAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScoreAttributes) GoString() string {
	return s.String()
}

// SetScoreConfidence sets the ScoreConfidence field's value.
func (s *ScoreAttributes) SetScoreConfidence(v string) *ScoreAttributes {
	s.ScoreConfidence = &v
	return s
}

// Provides information about how a custom index field is used during a search.
type Search struct {
	_ struct{} `type:"structure"`

	// Determines whether the field is returned in the query response. The default
	// is true.
	Displayable *bool `type:"boolean"`

	// Indicates that the field can be used to create search facets, a count of
	// results for each value in the field. The default is false .
	Facetable *bool `type:"boolean"`

	// Determines whether the field is used in the search. If the Searchable field
	// is true, you can use relevance tuning to manually tune how Amazon Kendra
	// weights the field in the search. The default is true for string fields and
	// false for number and date fields.
	Searchable *bool `type:"boolean"`

	// Determines whether the field can be used to sort the results of a query.
	// If you specify sorting on a field that does not have Sortable set to true,
	// Amazon Kendra returns an exception. The default is false.
	Sortable *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Search) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Search) GoString() string {
	return s.String()
}

// SetDisplayable sets the Displayable field's value.
func (s *Search) SetDisplayable(v bool) *Search {
	s.Displayable = &v
	return s
}

// SetFacetable sets the Facetable field's value.
func (s *Search) SetFacetable(v bool) *Search {
	s.Facetable = &v
	return s
}

// SetSearchable sets the Searchable field's value.
func (s *Search) SetSearchable(v bool) *Search {
	s.Searchable = &v
	return s
}

// SetSortable sets the Sortable field's value.
func (s *Search) SetSortable(v bool) *Search {
	s.Sortable = &v
	return s
}

// Provides the configuration information of the seed or starting point URLs
// to crawl.
//
// When selecting websites to index, you must adhere to the Amazon Acceptable
// Use Policy (https://aws.amazon.com/aup/) and all other Amazon terms. Remember
// that you must only use the Amazon Kendra web crawler to index your own webpages,
// or webpages that you have authorization to index.
type SeedUrlConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of seed or starting point URLs of the websites you want to crawl.
	//
	// The list can include a maximum of 100 seed URLs.
	//
	// SeedUrls is a required field
	SeedUrls []*string `type:"list" required:"true"`

	// You can choose one of the following modes:
	//
	//    * HOST_ONLY – crawl only the website host names. For example, if the
	//    seed URL is "abc.example.com", then only URLs with host name "abc.example.com"
	//    are crawled.
	//
	//    * SUBDOMAINS – crawl the website host names with subdomains. For example,
	//    if the seed URL is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com"
	//    are also crawled.
	//
	//    * EVERYTHING – crawl the website host names with subdomains and other
	//    domains that the webpages link to.
	//
	// The default mode is set to HOST_ONLY.
	WebCrawlerMode *string `type:"string" enum:"WebCrawlerMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SeedUrlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SeedUrlConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SeedUrlConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SeedUrlConfiguration"}
	if s.SeedUrls == nil {
		invalidParams.Add(request.NewErrParamRequired("SeedUrls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSeedUrls sets the SeedUrls field's value.
func (s *SeedUrlConfiguration) SetSeedUrls(v []*string) *SeedUrlConfiguration {
	s.SeedUrls = v
	return s
}

// SetWebCrawlerMode sets the WebCrawlerMode field's value.
func (s *SeedUrlConfiguration) SetWebCrawlerMode(v string) *SeedUrlConfiguration {
	s.WebCrawlerMode = &v
	return s
}

// Provides the identifier of the KMScustomer master key (CMK) used to encrypt
// data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The identifier of the KMScustomer master key (CMK). Amazon Kendra doesn't
	// support asymmetric CMKs.
	//
	// KmsKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServerSideEncryptionConfiguration's
	// String and GoString methods.
	KmsKeyId *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ServerSideEncryptionConfiguration) SetKmsKeyId(v string) *ServerSideEncryptionConfiguration {
	s.KmsKeyId = &v
	return s
}

// Provides configuration information required to connect to a ServiceNow data
// source.
type ServiceNowConfiguration struct {
	_ struct{} `type:"structure"`

	// Determines the type of authentication used to connect to the ServiceNow instance.
	// If you choose HTTP_BASIC, Amazon Kendra is authenticated using the user name
	// and password provided in the AWS Secrets Manager secret in the SecretArn
	// field. When you choose OAUTH2, Amazon Kendra is authenticated using the OAuth
	// token and secret provided in the Secrets Manager secret, and the user name
	// and password are used to determine which information Amazon Kendra has access
	// to.
	//
	// When you use OAUTH2 authentication, you must generate a token and a client
	// secret using the ServiceNow console. For more information, see Using a ServiceNow
	// data source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html).
	AuthenticationType *string `type:"string" enum:"ServiceNowAuthenticationType"`

	// The ServiceNow instance that the data source connects to. The host endpoint
	// should look like the following: {instance}.service-now.com.
	//
	// HostUrl is a required field
	HostUrl *string `min:"1" type:"string" required:"true"`

	// Provides configuration information for crawling knowledge articles in the
	// ServiceNow site.
	KnowledgeArticleConfiguration *ServiceNowKnowledgeArticleConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the Secrets Manager secret that contains
	// the user name and password required to connect to the ServiceNow instance.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// Provides configuration information for crawling service catalogs in the ServiceNow
	// site.
	ServiceCatalogConfiguration *ServiceNowServiceCatalogConfiguration `type:"structure"`

	// The identifier of the release that the ServiceNow host is running. If the
	// host is not running the LONDON release, use OTHERS.
	//
	// ServiceNowBuildVersion is a required field
	ServiceNowBuildVersion *string `type:"string" required:"true" enum:"ServiceNowBuildVersionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNowConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNowConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowConfiguration"}
	if s.HostUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("HostUrl"))
	}
	if s.HostUrl != nil && len(*s.HostUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostUrl", 1))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.ServiceNowBuildVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNowBuildVersion"))
	}
	if s.KnowledgeArticleConfiguration != nil {
		if err := s.KnowledgeArticleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeArticleConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceCatalogConfiguration != nil {
		if err := s.ServiceCatalogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServiceCatalogConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *ServiceNowConfiguration) SetAuthenticationType(v string) *ServiceNowConfiguration {
	s.AuthenticationType = &v
	return s
}

// SetHostUrl sets the HostUrl field's value.
func (s *ServiceNowConfiguration) SetHostUrl(v string) *ServiceNowConfiguration {
	s.HostUrl = &v
	return s
}

// SetKnowledgeArticleConfiguration sets the KnowledgeArticleConfiguration field's value.
func (s *ServiceNowConfiguration) SetKnowledgeArticleConfiguration(v *ServiceNowKnowledgeArticleConfiguration) *ServiceNowConfiguration {
	s.KnowledgeArticleConfiguration = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ServiceNowConfiguration) SetSecretArn(v string) *ServiceNowConfiguration {
	s.SecretArn = &v
	return s
}

// SetServiceCatalogConfiguration sets the ServiceCatalogConfiguration field's value.
func (s *ServiceNowConfiguration) SetServiceCatalogConfiguration(v *ServiceNowServiceCatalogConfiguration) *ServiceNowConfiguration {
	s.ServiceCatalogConfiguration = v
	return s
}

// SetServiceNowBuildVersion sets the ServiceNowBuildVersion field's value.
func (s *ServiceNowConfiguration) SetServiceNowBuildVersion(v string) *ServiceNowConfiguration {
	s.ServiceNowBuildVersion = &v
	return s
}

// Provides configuration information for crawling knowledge articles in the
// ServiceNow site.
type ServiceNowKnowledgeArticleConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon Kendra should index attachments to knowledge articles.
	CrawlAttachments *bool `type:"boolean"`

	// The name of the ServiceNow field that is mapped to the index document contents
	// field in the Amazon Kendra index.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the ServiceNow field that is mapped to the index document title
	// field.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// List of regular expressions applied to knowledge articles. Items that don't
	// match the inclusion pattern are not indexed. The regex is applied to the
	// field specified in the PatternTargetField
	ExcludeAttachmentFilePatterns []*string `type:"list"`

	// Mapping between ServiceNow fields and Amazon Kendra index fields. You must
	// create the index field before you map the field.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A query that selects the knowledge articles to index. The query can return
	// articles from multiple knowledge bases, and the knowledge bases can be public
	// or private.
	//
	// The query string must be one generated by the ServiceNow console. For more
	// information, see Specifying documents to index with a query (https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html).
	FilterQuery *string `min:"1" type:"string"`

	// List of regular expressions applied to knowledge articles. Items that don't
	// match the inclusion pattern are not indexed. The regex is applied to the
	// field specified in the PatternTargetField.
	IncludeAttachmentFilePatterns []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNowKnowledgeArticleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNowKnowledgeArticleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowKnowledgeArticleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowKnowledgeArticleConfiguration"}
	if s.DocumentDataFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FilterQuery != nil && len(*s.FilterQuery) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterQuery", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlAttachments sets the CrawlAttachments field's value.
func (s *ServiceNowKnowledgeArticleConfiguration) SetCrawlAttachments(v bool) *ServiceNowKnowledgeArticleConfiguration {
	s.CrawlAttachments = &v
	return s
}

// SetDocumentDataFieldName sets the DocumentDataFieldName field's value.
func (s *ServiceNowKnowledgeArticleConfiguration) SetDocumentDataFieldName(v string) *ServiceNowKnowledgeArticleConfiguration {
	s.DocumentDataFieldName = &v
	return s
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *ServiceNowKnowledgeArticleConfiguration) SetDocumentTitleFieldName(v string) *ServiceNowKnowledgeArticleConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetExcludeAttachmentFilePatterns sets the ExcludeAttachmentFilePatterns field's value.
func (s *ServiceNowKnowledgeArticleConfiguration) SetExcludeAttachmentFilePatterns(v []*string) *ServiceNowKnowledgeArticleConfiguration {
	s.ExcludeAttachmentFilePatterns = v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *ServiceNowKnowledgeArticleConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *ServiceNowKnowledgeArticleConfiguration {
	s.FieldMappings = v
	return s
}

// SetFilterQuery sets the FilterQuery field's value.
func (s *ServiceNowKnowledgeArticleConfiguration) SetFilterQuery(v string) *ServiceNowKnowledgeArticleConfiguration {
	s.FilterQuery = &v
	return s
}

// SetIncludeAttachmentFilePatterns sets the IncludeAttachmentFilePatterns field's value.
func (s *ServiceNowKnowledgeArticleConfiguration) SetIncludeAttachmentFilePatterns(v []*string) *ServiceNowKnowledgeArticleConfiguration {
	s.IncludeAttachmentFilePatterns = v
	return s
}

// Provides configuration information for crawling service catalog items in
// the ServiceNow site
type ServiceNowServiceCatalogConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon Kendra should crawl attachments to the service catalog
	// items.
	CrawlAttachments *bool `type:"boolean"`

	// The name of the ServiceNow field that is mapped to the index document contents
	// field in the Amazon Kendra index.
	//
	// DocumentDataFieldName is a required field
	DocumentDataFieldName *string `min:"1" type:"string" required:"true"`

	// The name of the ServiceNow field that is mapped to the index document title
	// field.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// A list of regular expression patterns. Documents that match the patterns
	// are excluded from the index. Documents that don't match the patterns are
	// included in the index. If a document matches both an exclusion pattern and
	// an inclusion pattern, the document is not included in the index.
	//
	// The regex is applied to the file name of the attachment.
	ExcludeAttachmentFilePatterns []*string `type:"list"`

	// Mapping between ServiceNow fields and Amazon Kendra index fields. You must
	// create the index field before you map the field.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A list of regular expression patterns. Documents that match the patterns
	// are included in the index. Documents that don't match the patterns are excluded
	// from the index. If a document matches both an exclusion pattern and an inclusion
	// pattern, the document is not included in the index.
	//
	// The regex is applied to the file name of the attachment.
	IncludeAttachmentFilePatterns []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNowServiceCatalogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNowServiceCatalogConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowServiceCatalogConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowServiceCatalogConfiguration"}
	if s.DocumentDataFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentDataFieldName"))
	}
	if s.DocumentDataFieldName != nil && len(*s.DocumentDataFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentDataFieldName", 1))
	}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlAttachments sets the CrawlAttachments field's value.
func (s *ServiceNowServiceCatalogConfiguration) SetCrawlAttachments(v bool) *ServiceNowServiceCatalogConfiguration {
	s.CrawlAttachments = &v
	return s
}

// SetDocumentDataFieldName sets the DocumentDataFieldName field's value.
func (s *ServiceNowServiceCatalogConfiguration) SetDocumentDataFieldName(v string) *ServiceNowServiceCatalogConfiguration {
	s.DocumentDataFieldName = &v
	return s
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *ServiceNowServiceCatalogConfiguration) SetDocumentTitleFieldName(v string) *ServiceNowServiceCatalogConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetExcludeAttachmentFilePatterns sets the ExcludeAttachmentFilePatterns field's value.
func (s *ServiceNowServiceCatalogConfiguration) SetExcludeAttachmentFilePatterns(v []*string) *ServiceNowServiceCatalogConfiguration {
	s.ExcludeAttachmentFilePatterns = v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *ServiceNowServiceCatalogConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *ServiceNowServiceCatalogConfiguration {
	s.FieldMappings = v
	return s
}

// SetIncludeAttachmentFilePatterns sets the IncludeAttachmentFilePatterns field's value.
func (s *ServiceNowServiceCatalogConfiguration) SetIncludeAttachmentFilePatterns(v []*string) *ServiceNowServiceCatalogConfiguration {
	s.IncludeAttachmentFilePatterns = v
	return s
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides configuration information for connecting to a Microsoft SharePoint
// data source.
type SharePointConfiguration struct {
	_ struct{} `type:"structure"`

	// TRUE to include attachments to documents stored in your Microsoft SharePoint
	// site in the index; otherwise, FALSE.
	CrawlAttachments *bool `type:"boolean"`

	// A Boolean value that specifies whether local groups are disabled (True) or
	// enabled (False).
	DisableLocalGroups *bool `type:"boolean"`

	// The Microsoft SharePoint attribute field that contains the title of the document.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// A list of regular expression patterns. Documents that match the patterns
	// are excluded from the index. Documents that don't match the patterns are
	// included in the index. If a document matches both an exclusion pattern and
	// an inclusion pattern, the document is not included in the index.
	//
	// The regex is applied to the display URL of the SharePoint document.
	ExclusionPatterns []*string `type:"list"`

	// A list of DataSourceToIndexFieldMapping objects that map Microsoft SharePoint
	// attributes to custom fields in the Amazon Kendra index. You must first create
	// the index fields using the UpdateIndex operation before you map SharePoint
	// attributes. For more information, see Mapping Data Source Fields (https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html).
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A list of regular expression patterns. Documents that match the patterns
	// are included in the index. Documents that don't match the patterns are excluded
	// from the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index.
	//
	// The regex is applied to the display URL of the SharePoint document.
	InclusionPatterns []*string `type:"list"`

	// The Amazon Resource Name (ARN) of credentials stored in Secrets Manager.
	// The credentials should be a user/password pair. If you use SharePoint Server,
	// you also need to provide the sever domain name as part of the credentials.
	// For more information, see Using a Microsoft SharePoint Data Source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html).
	// For more information about Secrets Manager, see What Is Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// in the Secrets Manager user guide.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The version of Microsoft SharePoint that you are using as a data source.
	//
	// SharePointVersion is a required field
	SharePointVersion *string `type:"string" required:"true" enum:"SharePointVersion"`

	// Information required to find a specific file in an Amazon S3 bucket.
	SslCertificateS3Path *S3Path `type:"structure"`

	// The URLs of the Microsoft SharePoint site that contains the documents that
	// should be indexed.
	//
	// Urls is a required field
	Urls []*string `min:"1" type:"list" required:"true"`

	// Set to TRUE to use the Microsoft SharePoint change log to determine the documents
	// that need to be updated in the index. Depending on the size of the SharePoint
	// change log, it may take longer for Amazon Kendra to use the change log than
	// it takes it to determine the changed documents using the Amazon Kendra document
	// crawler.
	UseChangeLog *bool `type:"boolean"`

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharePointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharePointConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePointConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SharePointConfiguration"}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.SharePointVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SharePointVersion"))
	}
	if s.Urls == nil {
		invalidParams.Add(request.NewErrParamRequired("Urls"))
	}
	if s.Urls != nil && len(s.Urls) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Urls", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SslCertificateS3Path != nil {
		if err := s.SslCertificateS3Path.Validate(); err != nil {
			invalidParams.AddNested("SslCertificateS3Path", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlAttachments sets the CrawlAttachments field's value.
func (s *SharePointConfiguration) SetCrawlAttachments(v bool) *SharePointConfiguration {
	s.CrawlAttachments = &v
	return s
}

// SetDisableLocalGroups sets the DisableLocalGroups field's value.
func (s *SharePointConfiguration) SetDisableLocalGroups(v bool) *SharePointConfiguration {
	s.DisableLocalGroups = &v
	return s
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *SharePointConfiguration) SetDocumentTitleFieldName(v string) *SharePointConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetExclusionPatterns sets the ExclusionPatterns field's value.
func (s *SharePointConfiguration) SetExclusionPatterns(v []*string) *SharePointConfiguration {
	s.ExclusionPatterns = v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *SharePointConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *SharePointConfiguration {
	s.FieldMappings = v
	return s
}

// SetInclusionPatterns sets the InclusionPatterns field's value.
func (s *SharePointConfiguration) SetInclusionPatterns(v []*string) *SharePointConfiguration {
	s.InclusionPatterns = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *SharePointConfiguration) SetSecretArn(v string) *SharePointConfiguration {
	s.SecretArn = &v
	return s
}

// SetSharePointVersion sets the SharePointVersion field's value.
func (s *SharePointConfiguration) SetSharePointVersion(v string) *SharePointConfiguration {
	s.SharePointVersion = &v
	return s
}

// SetSslCertificateS3Path sets the SslCertificateS3Path field's value.
func (s *SharePointConfiguration) SetSslCertificateS3Path(v *S3Path) *SharePointConfiguration {
	s.SslCertificateS3Path = v
	return s
}

// SetUrls sets the Urls field's value.
func (s *SharePointConfiguration) SetUrls(v []*string) *SharePointConfiguration {
	s.Urls = v
	return s
}

// SetUseChangeLog sets the UseChangeLog field's value.
func (s *SharePointConfiguration) SetUseChangeLog(v bool) *SharePointConfiguration {
	s.UseChangeLog = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *SharePointConfiguration) SetVpcConfiguration(v *DataSourceVpcConfiguration) *SharePointConfiguration {
	s.VpcConfiguration = v
	return s
}

// Provides the configuration information of the sitemap URLs to crawl.
//
// When selecting websites to index, you must adhere to the Amazon Acceptable
// Use Policy (https://aws.amazon.com/aup/) and all other Amazon terms. Remember
// that you must only use the Amazon Kendra web crawler to index your own webpages,
// or webpages that you have authorization to index.
type SiteMapsConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of sitemap URLs of the websites you want to crawl.
	//
	// The list can include a maximum of three sitemap URLs.
	//
	// SiteMaps is a required field
	SiteMaps []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SiteMapsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SiteMapsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SiteMapsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SiteMapsConfiguration"}
	if s.SiteMaps == nil {
		invalidParams.Add(request.NewErrParamRequired("SiteMaps"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSiteMaps sets the SiteMaps field's value.
func (s *SiteMapsConfiguration) SetSiteMaps(v []*string) *SiteMapsConfiguration {
	s.SiteMaps = v
	return s
}

// Specifies the document attribute to use to sort the response to a Amazon
// Kendra query. You can specify a single attribute for sorting. The attribute
// must have the Sortable flag set to true, otherwise Amazon Kendra returns
// an exception.
//
// You can sort attributes of the following types.
//
//    * Date value
//
//    * Long value
//
//    * String value
//
// You can't sort attributes of the following type.
//
//    * String list value
type SortingConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the document attribute used to sort the response. You can use
	// any field that has the Sortable flag set to true.
	//
	// You can also sort by any of the following built-in attributes:
	//
	//    * _category
	//
	//    * _created_at
	//
	//    * _last_updated_at
	//
	//    * _version
	//
	//    * _view_count
	//
	// DocumentAttributeKey is a required field
	DocumentAttributeKey *string `min:"1" type:"string" required:"true"`

	// The order that the results should be returned in. In case of ties, the relevance
	// assigned to the result by Amazon Kendra is used as the tie-breaker.
	//
	// SortOrder is a required field
	SortOrder *string `type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SortingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SortingConfiguration"}
	if s.DocumentAttributeKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentAttributeKey"))
	}
	if s.DocumentAttributeKey != nil && len(*s.DocumentAttributeKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentAttributeKey", 1))
	}
	if s.SortOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentAttributeKey sets the DocumentAttributeKey field's value.
func (s *SortingConfiguration) SetDocumentAttributeKey(v string) *SortingConfiguration {
	s.DocumentAttributeKey = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SortingConfiguration) SetSortOrder(v string) *SortingConfiguration {
	s.SortOrder = &v
	return s
}

// Provides information that configures Amazon Kendra to use a SQL database.
type SqlConfiguration struct {
	_ struct{} `type:"structure"`

	// Determines whether Amazon Kendra encloses SQL identifiers for tables and
	// column names in double quotes (") when making a database query.
	//
	// By default, Amazon Kendra passes SQL identifiers the way that they are entered
	// into the data source configuration. It does not change the case of identifiers
	// or enclose them in quotes.
	//
	// PostgreSQL internally converts uppercase characters to lower case characters
	// in identifiers unless they are quoted. Choosing this option encloses identifiers
	// in quotes so that PostgreSQL does not convert the character's case.
	//
	// For MySQL databases, you must enable the ansi_quotes option when you set
	// this field to DOUBLE_QUOTES.
	QueryIdentifiersEnclosingOption *string `type:"string" enum:"QueryIdentifiersEnclosingOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlConfiguration) GoString() string {
	return s.String()
}

// SetQueryIdentifiersEnclosingOption sets the QueryIdentifiersEnclosingOption field's value.
func (s *SqlConfiguration) SetQueryIdentifiersEnclosingOption(v string) *SqlConfiguration {
	s.QueryIdentifiersEnclosingOption = &v
	return s
}

type StartDataSourceSyncJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source to synchronize.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataSourceSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataSourceSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDataSourceSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDataSourceSyncJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StartDataSourceSyncJobInput) SetId(v string) *StartDataSourceSyncJobInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *StartDataSourceSyncJobInput) SetIndexId(v string) *StartDataSourceSyncJobInput {
	s.IndexId = &v
	return s
}

type StartDataSourceSyncJobOutput struct {
	_ struct{} `type:"structure"`

	// Identifies a particular synchronization job.
	ExecutionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataSourceSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataSourceSyncJobOutput) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *StartDataSourceSyncJobOutput) SetExecutionId(v string) *StartDataSourceSyncJobOutput {
	s.ExecutionId = &v
	return s
}

// Provides information about the status of documents submitted for indexing.
type Status struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the document.
	DocumentId *string `min:"1" type:"string"`

	// The current status of a document.
	//
	// If the document was submitted for deletion, the status is NOT_FOUND after
	// the document is deleted.
	DocumentStatus *string `type:"string" enum:"DocumentStatus"`

	// Indicates the source of the error.
	FailureCode *string `min:"1" type:"string"`

	// Provides detailed information about why the document couldn't be indexed.
	// Use this information to correct the error before you resubmit the document
	// for indexing.
	FailureReason *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Status) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Status) GoString() string {
	return s.String()
}

// SetDocumentId sets the DocumentId field's value.
func (s *Status) SetDocumentId(v string) *Status {
	s.DocumentId = &v
	return s
}

// SetDocumentStatus sets the DocumentStatus field's value.
func (s *Status) SetDocumentStatus(v string) *Status {
	s.DocumentStatus = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *Status) SetFailureCode(v string) *Status {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *Status) SetFailureReason(v string) *Status {
	s.FailureReason = &v
	return s
}

type StopDataSourceSyncJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source for which to stop the synchronization jobs.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDataSourceSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDataSourceSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDataSourceSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDataSourceSyncJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StopDataSourceSyncJobInput) SetId(v string) *StopDataSourceSyncJobInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *StopDataSourceSyncJobInput) SetIndexId(v string) *StopDataSourceSyncJobInput {
	s.IndexId = &v
	return s
}

type StopDataSourceSyncJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDataSourceSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDataSourceSyncJobOutput) GoString() string {
	return s.String()
}

type SubmitFeedbackInput struct {
	_ struct{} `type:"structure"`

	// Tells Amazon Kendra that a particular search result link was chosen by the
	// user.
	ClickFeedbackItems []*ClickFeedback `type:"list"`

	// The identifier of the index that was queried.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The identifier of the specific query for which you are submitting feedback.
	// The query ID is returned in the response to the Query operation.
	//
	// QueryId is a required field
	QueryId *string `min:"1" type:"string" required:"true"`

	// Provides Amazon Kendra with relevant or not relevant feedback for whether
	// a particular item was relevant to the search.
	RelevanceFeedbackItems []*RelevanceFeedback `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubmitFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubmitFeedbackInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}
	if s.ClickFeedbackItems != nil {
		for i, v := range s.ClickFeedbackItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ClickFeedbackItems", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RelevanceFeedbackItems != nil {
		for i, v := range s.RelevanceFeedbackItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelevanceFeedbackItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClickFeedbackItems sets the ClickFeedbackItems field's value.
func (s *SubmitFeedbackInput) SetClickFeedbackItems(v []*ClickFeedback) *SubmitFeedbackInput {
	s.ClickFeedbackItems = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *SubmitFeedbackInput) SetIndexId(v string) *SubmitFeedbackInput {
	s.IndexId = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *SubmitFeedbackInput) SetQueryId(v string) *SubmitFeedbackInput {
	s.QueryId = &v
	return s
}

// SetRelevanceFeedbackItems sets the RelevanceFeedbackItems field's value.
func (s *SubmitFeedbackInput) SetRelevanceFeedbackItems(v []*RelevanceFeedback) *SubmitFeedbackInput {
	s.RelevanceFeedbackItems = v
	return s
}

type SubmitFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitFeedbackOutput) GoString() string {
	return s.String()
}

// A single query suggestion.
type Suggestion struct {
	_ struct{} `type:"structure"`

	// The unique UUID (universally unique identifier) of a single query suggestion.
	Id *string `min:"1" type:"string"`

	// The value for the unique UUID (universally unique identifier) of a single
	// query suggestion.
	//
	// The value is the text string of a suggestion.
	Value *SuggestionValue `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Suggestion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Suggestion) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Suggestion) SetId(v string) *Suggestion {
	s.Id = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Suggestion) SetValue(v *SuggestionValue) *Suggestion {
	s.Value = v
	return s
}

// The text highlights for a single query suggestion.
type SuggestionHighlight struct {
	_ struct{} `type:"structure"`

	// The zero-based location in the response string where the highlight starts.
	BeginOffset *int64 `type:"integer"`

	// The zero-based location in the response string where the highlight ends.
	EndOffset *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestionHighlight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestionHighlight) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *SuggestionHighlight) SetBeginOffset(v int64) *SuggestionHighlight {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *SuggestionHighlight) SetEndOffset(v int64) *SuggestionHighlight {
	s.EndOffset = &v
	return s
}

// Provides text and information about where to highlight the query suggestion
// text.
type SuggestionTextWithHighlights struct {
	_ struct{} `type:"structure"`

	// The beginning and end of the query suggestion text that should be highlighted.
	Highlights []*SuggestionHighlight `type:"list"`

	// The query suggestion text to display to the user.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestionTextWithHighlights) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestionTextWithHighlights) GoString() string {
	return s.String()
}

// SetHighlights sets the Highlights field's value.
func (s *SuggestionTextWithHighlights) SetHighlights(v []*SuggestionHighlight) *SuggestionTextWithHighlights {
	s.Highlights = v
	return s
}

// SetText sets the Text field's value.
func (s *SuggestionTextWithHighlights) SetText(v string) *SuggestionTextWithHighlights {
	s.Text = &v
	return s
}

// The SuggestionTextWithHighlights structure information.
type SuggestionValue struct {
	_ struct{} `type:"structure"`

	// The SuggestionTextWithHighlights structure that contains the query suggestion
	// text and highlights.
	Text *SuggestionTextWithHighlights `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestionValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestionValue) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *SuggestionValue) SetText(v *SuggestionTextWithHighlights) *SuggestionValue {
	s.Text = v
	return s
}

// A list of key/value pairs that identify an index, FAQ, or data source. Tag
// keys and values can consist of Unicode letters, digits, white space, and
// any of the following symbols: _ . : / = + - @.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag. Keys are not case sensitive and must be unique for the
	// index, FAQ, or data source.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value associated with the tag. The value may be an empty string but it
	// can't be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tag keys to add to the index, FAQ, or data source. If a tag already
	// exists, the existing value is replaced with the new value.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Provides information about text documents indexed in an index.
type TextDocumentStatistics struct {
	_ struct{} `type:"structure"`

	// The total size, in bytes, of the indexed documents.
	//
	// IndexedTextBytes is a required field
	IndexedTextBytes *int64 `type:"long" required:"true"`

	// The number of text documents indexed.
	//
	// IndexedTextDocumentsCount is a required field
	IndexedTextDocumentsCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextDocumentStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextDocumentStatistics) GoString() string {
	return s.String()
}

// SetIndexedTextBytes sets the IndexedTextBytes field's value.
func (s *TextDocumentStatistics) SetIndexedTextBytes(v int64) *TextDocumentStatistics {
	s.IndexedTextBytes = &v
	return s
}

// SetIndexedTextDocumentsCount sets the IndexedTextDocumentsCount field's value.
func (s *TextDocumentStatistics) SetIndexedTextDocumentsCount(v int64) *TextDocumentStatistics {
	s.IndexedTextDocumentsCount = &v
	return s
}

// Provides text and information about where to highlight the text.
type TextWithHighlights struct {
	_ struct{} `type:"structure"`

	// The beginning and end of the text that should be highlighted.
	Highlights []*Highlight `type:"list"`

	// The text to display to the user.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextWithHighlights) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextWithHighlights) GoString() string {
	return s.String()
}

// SetHighlights sets the Highlights field's value.
func (s *TextWithHighlights) SetHighlights(v []*Highlight) *TextWithHighlights {
	s.Highlights = v
	return s
}

// SetText sets the Text field's value.
func (s *TextWithHighlights) SetText(v string) *TextWithHighlights {
	s.Text = &v
	return s
}

// An array of summary information for one or more thesauruses.
type ThesaurusSummary struct {
	_ struct{} `type:"structure"`

	// The Unix datetime that the thesaurus was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the thesaurus.
	Id *string `min:"1" type:"string"`

	// The name of the thesaurus.
	Name *string `min:"1" type:"string"`

	// The status of the thesaurus.
	Status *string `type:"string" enum:"ThesaurusStatus"`

	// The Unix datetime that the thesaurus was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThesaurusSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThesaurusSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ThesaurusSummary) SetCreatedAt(v time.Time) *ThesaurusSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *ThesaurusSummary) SetId(v string) *ThesaurusSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ThesaurusSummary) SetName(v string) *ThesaurusSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ThesaurusSummary) SetStatus(v string) *ThesaurusSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ThesaurusSummary) SetUpdatedAt(v time.Time) *ThesaurusSummary {
	s.UpdatedAt = &v
	return s
}

type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides a range of time.
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime of the end of the time range.
	EndTime *time.Time `type:"timestamp"`

	// The UNIX datetime of the beginning of the time range.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRange) SetEndTime(v time.Time) *TimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRange) SetStartTime(v time.Time) *TimeRange {
	s.StartTime = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the index, FAQ, or data source to remove
	// the tag from.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tag keys to remove from the index, FAQ, or data source. If a tag
	// key does not exist on the resource, it is ignored.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// Configuration information for a Amazon Kendra data source.
	Configuration *DataSourceConfiguration `type:"structure"`

	// The new description for the data source.
	Description *string `type:"string"`

	// The unique identifier of the data source to update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source to update.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The name of the data source to update. The name of the data source can't
	// be updated. To rename a data source you must delete the data source and re-create
	// it.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the new role to use when the data source
	// is accessing resources on your behalf.
	RoleArn *string `min:"1" type:"string"`

	// The new update schedule for the data source.
	Schedule *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateDataSourceInput) SetConfiguration(v *DataSourceConfiguration) *UpdateDataSourceInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSourceInput) SetDescription(v string) *UpdateDataSourceInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDataSourceInput) SetId(v string) *UpdateDataSourceInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *UpdateDataSourceInput) SetIndexId(v string) *UpdateDataSourceInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSourceInput) SetName(v string) *UpdateDataSourceInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateDataSourceInput) SetRoleArn(v string) *UpdateDataSourceInput {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateDataSourceInput) SetSchedule(v string) *UpdateDataSourceInput {
	s.Schedule = &v
	return s
}

type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

type UpdateIndexInput struct {
	_ struct{} `type:"structure"`

	// Sets the number of additional storage and query capacity units that should
	// be used by the index. You can change the capacity of the index up to 5 times
	// per day.
	//
	// If you are using extra storage units, you can't reduce the storage capacity
	// below that required to meet the storage needs for your index.
	CapacityUnits *CapacityUnitsConfiguration `type:"structure"`

	// A new description for the index.
	Description *string `type:"string"`

	// The document metadata to update.
	DocumentMetadataConfigurationUpdates []*DocumentMetadataConfiguration `type:"list"`

	// The identifier of the index to update.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`

	// The name of the index to update.
	Name *string `min:"1" type:"string"`

	// A new IAM role that gives Amazon Kendra permission to access your Amazon
	// CloudWatch logs.
	RoleArn *string `min:"1" type:"string"`

	// The user user token context policy.
	UserContextPolicy *string `type:"string" enum:"UserContextPolicy"`

	// The user token configuration.
	UserTokenConfigurations []*UserTokenConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIndexInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.CapacityUnits != nil {
		if err := s.CapacityUnits.Validate(); err != nil {
			invalidParams.AddNested("CapacityUnits", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentMetadataConfigurationUpdates != nil {
		for i, v := range s.DocumentMetadataConfigurationUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentMetadataConfigurationUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserTokenConfigurations != nil {
		for i, v := range s.UserTokenConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserTokenConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *UpdateIndexInput) SetCapacityUnits(v *CapacityUnitsConfiguration) *UpdateIndexInput {
	s.CapacityUnits = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateIndexInput) SetDescription(v string) *UpdateIndexInput {
	s.Description = &v
	return s
}

// SetDocumentMetadataConfigurationUpdates sets the DocumentMetadataConfigurationUpdates field's value.
func (s *UpdateIndexInput) SetDocumentMetadataConfigurationUpdates(v []*DocumentMetadataConfiguration) *UpdateIndexInput {
	s.DocumentMetadataConfigurationUpdates = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateIndexInput) SetId(v string) *UpdateIndexInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateIndexInput) SetName(v string) *UpdateIndexInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateIndexInput) SetRoleArn(v string) *UpdateIndexInput {
	s.RoleArn = &v
	return s
}

// SetUserContextPolicy sets the UserContextPolicy field's value.
func (s *UpdateIndexInput) SetUserContextPolicy(v string) *UpdateIndexInput {
	s.UserContextPolicy = &v
	return s
}

// SetUserTokenConfigurations sets the UserTokenConfigurations field's value.
func (s *UpdateIndexInput) SetUserTokenConfigurations(v []*UserTokenConfiguration) *UpdateIndexInput {
	s.UserTokenConfigurations = v
	return s
}

type UpdateIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexOutput) GoString() string {
	return s.String()
}

type UpdateQuerySuggestionsBlockListInput struct {
	_ struct{} `type:"structure"`

	// The description for a block list.
	Description *string `type:"string"`

	// The unique identifier of a block list.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`

	// The identifier of the index for a block list.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The name of a block list.
	Name *string `min:"1" type:"string"`

	// The IAM (Identity and Access Management) role used to access the block list
	// text file in S3.
	RoleArn *string `min:"1" type:"string"`

	// The S3 path where your block list text file sits in S3.
	//
	// If you update your block list and provide the same path to the block list
	// text file in S3, then Amazon Kendra reloads the file to refresh the block
	// list. Amazon Kendra does not automatically refresh your block list. You need
	// to call the UpdateQuerySuggestionsBlockList API to refresh you block list.
	//
	// If you update your block list, then Amazon Kendra asynchronously refreshes
	// all query suggestions with the latest content in the S3 file. This means
	// changes might not take effect immediately.
	SourceS3Path *S3Path `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQuerySuggestionsBlockListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQuerySuggestionsBlockListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateQuerySuggestionsBlockListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateQuerySuggestionsBlockListInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.SourceS3Path != nil {
		if err := s.SourceS3Path.Validate(); err != nil {
			invalidParams.AddNested("SourceS3Path", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateQuerySuggestionsBlockListInput) SetDescription(v string) *UpdateQuerySuggestionsBlockListInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateQuerySuggestionsBlockListInput) SetId(v string) *UpdateQuerySuggestionsBlockListInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *UpdateQuerySuggestionsBlockListInput) SetIndexId(v string) *UpdateQuerySuggestionsBlockListInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateQuerySuggestionsBlockListInput) SetName(v string) *UpdateQuerySuggestionsBlockListInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateQuerySuggestionsBlockListInput) SetRoleArn(v string) *UpdateQuerySuggestionsBlockListInput {
	s.RoleArn = &v
	return s
}

// SetSourceS3Path sets the SourceS3Path field's value.
func (s *UpdateQuerySuggestionsBlockListInput) SetSourceS3Path(v *S3Path) *UpdateQuerySuggestionsBlockListInput {
	s.SourceS3Path = v
	return s
}

type UpdateQuerySuggestionsBlockListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQuerySuggestionsBlockListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQuerySuggestionsBlockListOutput) GoString() string {
	return s.String()
}

type UpdateQuerySuggestionsConfigInput struct {
	_ struct{} `type:"structure"`

	// TRUE to include queries without user information (i.e. all queries, irrespective
	// of the user), otherwise FALSE to only include queries with user information.
	//
	// If you pass user information to Amazon Kendra along with the queries, you
	// can set this flag to FALSE and instruct Amazon Kendra to only consider queries
	// with user information.
	//
	// If you set to FALSE, Amazon Kendra only considers queries searched at least
	// MinimumQueryCount times across MinimumNumberOfQueryingUsers unique users
	// for suggestions.
	//
	// If you set to TRUE, Amazon Kendra ignores all user information and learns
	// from all queries.
	IncludeQueriesWithoutUserInformation *bool `type:"boolean"`

	// The identifier of the index you want to update query suggestions settings
	// for.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The minimum number of unique users who must search a query in order for the
	// query to be eligible to suggest to your users.
	//
	// Increasing this number might decrease the number of suggestions. However,
	// this ensures a query is searched by many users and is truly popular to suggest
	// to users.
	//
	// How you tune this setting depends on your specific needs.
	MinimumNumberOfQueryingUsers *int64 `min:"1" type:"integer"`

	// The the minimum number of times a query must be searched in order to be eligible
	// to suggest to your users.
	//
	// Decreasing this number increases the number of suggestions. However, this
	// affects the quality of suggestions as it sets a low bar for a query to be
	// considered popular to suggest to users.
	//
	// How you tune this setting depends on your specific needs.
	MinimumQueryCount *int64 `min:"1" type:"integer"`

	// Set the mode to ENABLED or LEARN_ONLY.
	//
	// By default, Amazon Kendra enables query suggestions. LEARN_ONLY mode allows
	// you to turn off query suggestions. You can to update this at any time.
	//
	// In LEARN_ONLY mode, Amazon Kendra continues to learn from new queries to
	// keep suggestions up to date for when you are ready to switch to ENABLED mode
	// again.
	Mode *string `type:"string" enum:"Mode"`

	// How recent your queries are in your query log time window.
	//
	// The time window is the number of days from current day to past days.
	//
	// By default, Amazon Kendra sets this to 180.
	QueryLogLookBackWindowInDays *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQuerySuggestionsConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQuerySuggestionsConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateQuerySuggestionsConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateQuerySuggestionsConfigInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MinimumNumberOfQueryingUsers != nil && *s.MinimumNumberOfQueryingUsers < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumNumberOfQueryingUsers", 1))
	}
	if s.MinimumQueryCount != nil && *s.MinimumQueryCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumQueryCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeQueriesWithoutUserInformation sets the IncludeQueriesWithoutUserInformation field's value.
func (s *UpdateQuerySuggestionsConfigInput) SetIncludeQueriesWithoutUserInformation(v bool) *UpdateQuerySuggestionsConfigInput {
	s.IncludeQueriesWithoutUserInformation = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *UpdateQuerySuggestionsConfigInput) SetIndexId(v string) *UpdateQuerySuggestionsConfigInput {
	s.IndexId = &v
	return s
}

// SetMinimumNumberOfQueryingUsers sets the MinimumNumberOfQueryingUsers field's value.
func (s *UpdateQuerySuggestionsConfigInput) SetMinimumNumberOfQueryingUsers(v int64) *UpdateQuerySuggestionsConfigInput {
	s.MinimumNumberOfQueryingUsers = &v
	return s
}

// SetMinimumQueryCount sets the MinimumQueryCount field's value.
func (s *UpdateQuerySuggestionsConfigInput) SetMinimumQueryCount(v int64) *UpdateQuerySuggestionsConfigInput {
	s.MinimumQueryCount = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *UpdateQuerySuggestionsConfigInput) SetMode(v string) *UpdateQuerySuggestionsConfigInput {
	s.Mode = &v
	return s
}

// SetQueryLogLookBackWindowInDays sets the QueryLogLookBackWindowInDays field's value.
func (s *UpdateQuerySuggestionsConfigInput) SetQueryLogLookBackWindowInDays(v int64) *UpdateQuerySuggestionsConfigInput {
	s.QueryLogLookBackWindowInDays = &v
	return s
}

type UpdateQuerySuggestionsConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQuerySuggestionsConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQuerySuggestionsConfigOutput) GoString() string {
	return s.String()
}

type UpdateThesaurusInput struct {
	_ struct{} `type:"structure"`

	// The updated description of the thesaurus.
	Description *string `type:"string"`

	// The identifier of the thesaurus to update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index associated with the thesaurus to update.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The updated name of the thesaurus.
	Name *string `min:"1" type:"string"`

	// The updated role ARN of the thesaurus.
	RoleArn *string `min:"1" type:"string"`

	// Information required to find a specific file in an Amazon S3 bucket.
	SourceS3Path *S3Path `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThesaurusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThesaurusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThesaurusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateThesaurusInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.SourceS3Path != nil {
		if err := s.SourceS3Path.Validate(); err != nil {
			invalidParams.AddNested("SourceS3Path", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateThesaurusInput) SetDescription(v string) *UpdateThesaurusInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateThesaurusInput) SetId(v string) *UpdateThesaurusInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *UpdateThesaurusInput) SetIndexId(v string) *UpdateThesaurusInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateThesaurusInput) SetName(v string) *UpdateThesaurusInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateThesaurusInput) SetRoleArn(v string) *UpdateThesaurusInput {
	s.RoleArn = &v
	return s
}

// SetSourceS3Path sets the SourceS3Path field's value.
func (s *UpdateThesaurusInput) SetSourceS3Path(v *S3Path) *UpdateThesaurusInput {
	s.SourceS3Path = v
	return s
}

type UpdateThesaurusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThesaurusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThesaurusOutput) GoString() string {
	return s.String()
}

// Provides the configuration information of the URLs to crawl.
//
// When selecting websites to index, you must adhere to the Amazon Acceptable
// Use Policy (https://aws.amazon.com/aup/) and all other Amazon terms. Remember
// that you must only use the Amazon Kendra web crawler to index your own webpages,
// or webpages that you have authorization to index.
type Urls struct {
	_ struct{} `type:"structure"`

	// Provides the configuration of the seed or starting point URLs of the websites
	// you want to crawl.
	//
	// You can choose to crawl only the website host names, or the website host
	// names with subdomains, or the website host names with subdomains and other
	// domains that the webpages link to.
	//
	// You can list up to 100 seed URLs.
	SeedUrlConfiguration *SeedUrlConfiguration `type:"structure"`

	// Provides the configuration of the sitemap URLs of the websites you want to
	// crawl.
	//
	// Only URLs belonging to the same website host names are crawled. You can list
	// up to three sitemap URLs.
	SiteMapsConfiguration *SiteMapsConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Urls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Urls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Urls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Urls"}
	if s.SeedUrlConfiguration != nil {
		if err := s.SeedUrlConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SeedUrlConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SiteMapsConfiguration != nil {
		if err := s.SiteMapsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SiteMapsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSeedUrlConfiguration sets the SeedUrlConfiguration field's value.
func (s *Urls) SetSeedUrlConfiguration(v *SeedUrlConfiguration) *Urls {
	s.SeedUrlConfiguration = v
	return s
}

// SetSiteMapsConfiguration sets the SiteMapsConfiguration field's value.
func (s *Urls) SetSiteMapsConfiguration(v *SiteMapsConfiguration) *Urls {
	s.SiteMapsConfiguration = v
	return s
}

// Provides information about the user context for a Amazon Kendra index.
//
// This is used for filtering search results for different users based on their
// access to documents.
//
// You provide one of the following:
//
//    * User token
//
//    * User ID, the groups the user belongs to, and the data sources the groups
//    can access
//
// If you provide both, an exception is thrown.
type UserContext struct {
	_ struct{} `type:"structure"`

	// The list of data source groups you want to filter search results based on
	// groups' access to documents in that data source.
	DataSourceGroups []*DataSourceGroup `min:"1" type:"list"`

	// The list of groups you want to filter search results based on the groups'
	// access to documents.
	Groups []*string `min:"1" type:"list"`

	// The user context token for filtering search results for a user. It must be
	// a JWT or a JSON token.
	Token *string `min:"1" type:"string"`

	// The identifier of the user you want to filter search results based on their
	// access to documents.
	UserId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserContext"}
	if s.DataSourceGroups != nil && len(s.DataSourceGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceGroups", 1))
	}
	if s.Groups != nil && len(s.Groups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Groups", 1))
	}
	if s.Token != nil && len(*s.Token) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Token", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.DataSourceGroups != nil {
		for i, v := range s.DataSourceGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSourceGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceGroups sets the DataSourceGroups field's value.
func (s *UserContext) SetDataSourceGroups(v []*DataSourceGroup) *UserContext {
	s.DataSourceGroups = v
	return s
}

// SetGroups sets the Groups field's value.
func (s *UserContext) SetGroups(v []*string) *UserContext {
	s.Groups = v
	return s
}

// SetToken sets the Token field's value.
func (s *UserContext) SetToken(v string) *UserContext {
	s.Token = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UserContext) SetUserId(v string) *UserContext {
	s.UserId = &v
	return s
}

// Provides configuration information for a token configuration.
type UserTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about the JSON token type configuration.
	JsonTokenTypeConfiguration *JsonTokenTypeConfiguration `type:"structure"`

	// Information about the JWT token type configuration.
	JwtTokenTypeConfiguration *JwtTokenTypeConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserTokenConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserTokenConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserTokenConfiguration"}
	if s.JsonTokenTypeConfiguration != nil {
		if err := s.JsonTokenTypeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("JsonTokenTypeConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.JwtTokenTypeConfiguration != nil {
		if err := s.JwtTokenTypeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("JwtTokenTypeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJsonTokenTypeConfiguration sets the JsonTokenTypeConfiguration field's value.
func (s *UserTokenConfiguration) SetJsonTokenTypeConfiguration(v *JsonTokenTypeConfiguration) *UserTokenConfiguration {
	s.JsonTokenTypeConfiguration = v
	return s
}

// SetJwtTokenTypeConfiguration sets the JwtTokenTypeConfiguration field's value.
func (s *UserTokenConfiguration) SetJwtTokenTypeConfiguration(v *JwtTokenTypeConfiguration) *UserTokenConfiguration {
	s.JwtTokenTypeConfiguration = v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides the configuration information required for Amazon Kendra web crawler.
type WebCrawlerConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides configuration information required to connect to websites using
	// authentication.
	//
	// You can connect to websites using basic authentication of user name and password.
	//
	// You must provide the website host name and port number. For example, the
	// host name of https://a.example.com/page1.html is "a.example.com" and the
	// port is 443, the standard port for HTTPS. You use a secret in AWS Secrets
	// Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// to store your authentication credentials.
	AuthenticationConfiguration *AuthenticationConfiguration `type:"structure"`

	// Specifies the number of levels in a website that you want to crawl.
	//
	// The first level begins from the website seed or starting point URL. For example,
	// if a website has 3 levels – index level (i.e. seed in this example), sections
	// level, and subsections level – and you are only interested in crawling
	// information up to the sections level (i.e. levels 0-1), you can set your
	// depth to 1.
	//
	// The default crawl depth is set to 2.
	CrawlDepth *int64 `type:"integer"`

	// The maximum size (in MB) of a webpage or attachment to crawl.
	//
	// Files larger than this size (in MB) are skipped/not crawled.
	//
	// The default maximum size of a webpage or attachment is set to 50 MB.
	MaxContentSizePerPageInMegaBytes *float64 `min:"1e-06" type:"float"`

	// The maximum number of URLs on a webpage to include when crawling a website.
	// This number is per webpage.
	//
	// As a website’s webpages are crawled, any URLs the webpages link to are
	// also crawled. URLs on a webpage are crawled in order of appearance.
	//
	// The default maximum links per page is 100.
	MaxLinksPerPage *int64 `min:"1" type:"integer"`

	// The maximum number of URLs crawled per website host per minute.
	//
	// A minimum of one URL is required.
	//
	// The default maximum number of URLs crawled per website host per minute is
	// 300.
	MaxUrlsPerMinuteCrawlRate *int64 `min:"1" type:"integer"`

	// Provides configuration information required to connect to your internal websites
	// via a web proxy.
	//
	// You must provide the website host name and port number. For example, the
	// host name of https://a.example.com/page1.html is "a.example.com" and the
	// port is 443, the standard port for HTTPS.
	//
	// Web proxy credentials are optional and you can use them to connect to a web
	// proxy server that requires basic authentication. To store web proxy credentials,
	// you use a secret in AWS Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
	ProxyConfiguration *ProxyConfiguration `type:"structure"`

	// The regular expression pattern to exclude certain URLs to crawl.
	//
	// If there is a regular expression pattern to include certain URLs that conflicts
	// with the exclude pattern, the exclude pattern takes precedence.
	UrlExclusionPatterns []*string `type:"list"`

	// The regular expression pattern to include certain URLs to crawl.
	//
	// If there is a regular expression pattern to exclude certain URLs that conflicts
	// with the include pattern, the exclude pattern takes precedence.
	UrlInclusionPatterns []*string `type:"list"`

	// Specifies the seed or starting point URLs of the websites or the sitemap
	// URLs of the websites you want to crawl.
	//
	// You can include website subdomains. You can list up to 100 seed URLs and
	// up to three sitemap URLs.
	//
	// When selecting websites to index, you must adhere to the Amazon Acceptable
	// Use Policy (https://aws.amazon.com/aup/) and all other Amazon terms. Remember
	// that you must only use the Amazon Kendra web crawler to index your own webpages,
	// or webpages that you have authorization to index.
	//
	// Urls is a required field
	Urls *Urls `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebCrawlerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebCrawlerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebCrawlerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebCrawlerConfiguration"}
	if s.MaxContentSizePerPageInMegaBytes != nil && *s.MaxContentSizePerPageInMegaBytes < 1e-06 {
		invalidParams.Add(request.NewErrParamMinValue("MaxContentSizePerPageInMegaBytes", 1e-06))
	}
	if s.MaxLinksPerPage != nil && *s.MaxLinksPerPage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxLinksPerPage", 1))
	}
	if s.MaxUrlsPerMinuteCrawlRate != nil && *s.MaxUrlsPerMinuteCrawlRate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxUrlsPerMinuteCrawlRate", 1))
	}
	if s.Urls == nil {
		invalidParams.Add(request.NewErrParamRequired("Urls"))
	}
	if s.AuthenticationConfiguration != nil {
		if err := s.AuthenticationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AuthenticationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProxyConfiguration != nil {
		if err := s.ProxyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProxyConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Urls != nil {
		if err := s.Urls.Validate(); err != nil {
			invalidParams.AddNested("Urls", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationConfiguration sets the AuthenticationConfiguration field's value.
func (s *WebCrawlerConfiguration) SetAuthenticationConfiguration(v *AuthenticationConfiguration) *WebCrawlerConfiguration {
	s.AuthenticationConfiguration = v
	return s
}

// SetCrawlDepth sets the CrawlDepth field's value.
func (s *WebCrawlerConfiguration) SetCrawlDepth(v int64) *WebCrawlerConfiguration {
	s.CrawlDepth = &v
	return s
}

// SetMaxContentSizePerPageInMegaBytes sets the MaxContentSizePerPageInMegaBytes field's value.
func (s *WebCrawlerConfiguration) SetMaxContentSizePerPageInMegaBytes(v float64) *WebCrawlerConfiguration {
	s.MaxContentSizePerPageInMegaBytes = &v
	return s
}

// SetMaxLinksPerPage sets the MaxLinksPerPage field's value.
func (s *WebCrawlerConfiguration) SetMaxLinksPerPage(v int64) *WebCrawlerConfiguration {
	s.MaxLinksPerPage = &v
	return s
}

// SetMaxUrlsPerMinuteCrawlRate sets the MaxUrlsPerMinuteCrawlRate field's value.
func (s *WebCrawlerConfiguration) SetMaxUrlsPerMinuteCrawlRate(v int64) *WebCrawlerConfiguration {
	s.MaxUrlsPerMinuteCrawlRate = &v
	return s
}

// SetProxyConfiguration sets the ProxyConfiguration field's value.
func (s *WebCrawlerConfiguration) SetProxyConfiguration(v *ProxyConfiguration) *WebCrawlerConfiguration {
	s.ProxyConfiguration = v
	return s
}

// SetUrlExclusionPatterns sets the UrlExclusionPatterns field's value.
func (s *WebCrawlerConfiguration) SetUrlExclusionPatterns(v []*string) *WebCrawlerConfiguration {
	s.UrlExclusionPatterns = v
	return s
}

// SetUrlInclusionPatterns sets the UrlInclusionPatterns field's value.
func (s *WebCrawlerConfiguration) SetUrlInclusionPatterns(v []*string) *WebCrawlerConfiguration {
	s.UrlInclusionPatterns = v
	return s
}

// SetUrls sets the Urls field's value.
func (s *WebCrawlerConfiguration) SetUrls(v *Urls) *WebCrawlerConfiguration {
	s.Urls = v
	return s
}

// Provides the configuration information to connect to Amazon WorkDocs as your
// data source.
//
// Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney,
// Singapore and Ireland regions.
type WorkDocsConfiguration struct {
	_ struct{} `type:"structure"`

	// TRUE to include comments on documents in your index. Including comments in
	// your index means each comment is a document that can be searched on.
	//
	// The default is set to FALSE.
	CrawlComments *bool `type:"boolean"`

	// A list of regular expression patterns to exclude certain files in your Amazon
	// WorkDocs site repository. Files that match the patterns are excluded from
	// the index. Files that don’t match the patterns are included in the index.
	// If a file matches both an inclusion pattern and an exclusion pattern, the
	// exclusion pattern takes precedence and the file isn’t included in the index.
	ExclusionPatterns []*string `type:"list"`

	// A list of DataSourceToIndexFieldMapping objects that map Amazon WorkDocs
	// field names to custom index field names in Amazon Kendra. You must first
	// create the custom index fields using the UpdateIndex operation before you
	// map to Amazon WorkDocs fields. For more information, see Mapping Data Source
	// Fields (https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html).
	// The Amazon WorkDocs data source field names need to exist in your Amazon
	// WorkDocs custom metadata.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A list of regular expression patterns to include certain files in your Amazon
	// WorkDocs site repository. Files that match the patterns are included in the
	// index. Files that don't match the patterns are excluded from the index. If
	// a file matches both an inclusion pattern and an exclusion pattern, the exclusion
	// pattern takes precedence and the file isn’t included in the index.
	InclusionPatterns []*string `type:"list"`

	// The identifier of the directory corresponding to your Amazon WorkDocs site
	// repository.
	//
	// You can find the organization ID in the AWS Directory Service (https://console.aws.amazon.com/directoryservicev2/)
	// by going to Active Directory, then Directories. Your Amazon WorkDocs site
	// directory has an ID, which is the organization ID. You can also set up a
	// new Amazon WorkDocs directory in the AWS Directory Service console and enable
	// a Amazon WorkDocs site for the directory in the Amazon WorkDocs console.
	//
	// OrganizationId is a required field
	OrganizationId *string `min:"12" type:"string" required:"true"`

	// TRUE to use the change logs to update documents in your index instead of
	// scanning all documents.
	//
	// If you are syncing your Amazon WorkDocs data source with your index for the
	// first time, all documents are scanned. After your first sync, you can use
	// the change logs to update your documents in your index for future syncs.
	//
	// The default is set to FALSE.
	UseChangeLog *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkDocsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkDocsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkDocsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkDocsConfiguration"}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 12))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlComments sets the CrawlComments field's value.
func (s *WorkDocsConfiguration) SetCrawlComments(v bool) *WorkDocsConfiguration {
	s.CrawlComments = &v
	return s
}

// SetExclusionPatterns sets the ExclusionPatterns field's value.
func (s *WorkDocsConfiguration) SetExclusionPatterns(v []*string) *WorkDocsConfiguration {
	s.ExclusionPatterns = v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *WorkDocsConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *WorkDocsConfiguration {
	s.FieldMappings = v
	return s
}

// SetInclusionPatterns sets the InclusionPatterns field's value.
func (s *WorkDocsConfiguration) SetInclusionPatterns(v []*string) *WorkDocsConfiguration {
	s.InclusionPatterns = v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *WorkDocsConfiguration) SetOrganizationId(v string) *WorkDocsConfiguration {
	s.OrganizationId = &v
	return s
}

// SetUseChangeLog sets the UseChangeLog field's value.
func (s *WorkDocsConfiguration) SetUseChangeLog(v bool) *WorkDocsConfiguration {
	s.UseChangeLog = &v
	return s
}

const (
	// AdditionalResultAttributeValueTypeTextWithHighlightsValue is a AdditionalResultAttributeValueType enum value
	AdditionalResultAttributeValueTypeTextWithHighlightsValue = "TEXT_WITH_HIGHLIGHTS_VALUE"
)

// AdditionalResultAttributeValueType_Values returns all elements of the AdditionalResultAttributeValueType enum
func AdditionalResultAttributeValueType_Values() []string {
	return []string{
		AdditionalResultAttributeValueTypeTextWithHighlightsValue,
	}
}

const (
	// ConfluenceAttachmentFieldNameAuthor is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameAuthor = "AUTHOR"

	// ConfluenceAttachmentFieldNameContentType is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameContentType = "CONTENT_TYPE"

	// ConfluenceAttachmentFieldNameCreatedDate is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameCreatedDate = "CREATED_DATE"

	// ConfluenceAttachmentFieldNameDisplayUrl is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameDisplayUrl = "DISPLAY_URL"

	// ConfluenceAttachmentFieldNameFileSize is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameFileSize = "FILE_SIZE"

	// ConfluenceAttachmentFieldNameItemType is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameItemType = "ITEM_TYPE"

	// ConfluenceAttachmentFieldNameParentId is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameParentId = "PARENT_ID"

	// ConfluenceAttachmentFieldNameSpaceKey is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameSpaceKey = "SPACE_KEY"

	// ConfluenceAttachmentFieldNameSpaceName is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameSpaceName = "SPACE_NAME"

	// ConfluenceAttachmentFieldNameUrl is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameUrl = "URL"

	// ConfluenceAttachmentFieldNameVersion is a ConfluenceAttachmentFieldName enum value
	ConfluenceAttachmentFieldNameVersion = "VERSION"
)

// ConfluenceAttachmentFieldName_Values returns all elements of the ConfluenceAttachmentFieldName enum
func ConfluenceAttachmentFieldName_Values() []string {
	return []string{
		ConfluenceAttachmentFieldNameAuthor,
		ConfluenceAttachmentFieldNameContentType,
		ConfluenceAttachmentFieldNameCreatedDate,
		ConfluenceAttachmentFieldNameDisplayUrl,
		ConfluenceAttachmentFieldNameFileSize,
		ConfluenceAttachmentFieldNameItemType,
		ConfluenceAttachmentFieldNameParentId,
		ConfluenceAttachmentFieldNameSpaceKey,
		ConfluenceAttachmentFieldNameSpaceName,
		ConfluenceAttachmentFieldNameUrl,
		ConfluenceAttachmentFieldNameVersion,
	}
}

const (
	// ConfluenceBlogFieldNameAuthor is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNameAuthor = "AUTHOR"

	// ConfluenceBlogFieldNameDisplayUrl is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNameDisplayUrl = "DISPLAY_URL"

	// ConfluenceBlogFieldNameItemType is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNameItemType = "ITEM_TYPE"

	// ConfluenceBlogFieldNameLabels is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNameLabels = "LABELS"

	// ConfluenceBlogFieldNamePublishDate is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNamePublishDate = "PUBLISH_DATE"

	// ConfluenceBlogFieldNameSpaceKey is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNameSpaceKey = "SPACE_KEY"

	// ConfluenceBlogFieldNameSpaceName is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNameSpaceName = "SPACE_NAME"

	// ConfluenceBlogFieldNameUrl is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNameUrl = "URL"

	// ConfluenceBlogFieldNameVersion is a ConfluenceBlogFieldName enum value
	ConfluenceBlogFieldNameVersion = "VERSION"
)

// ConfluenceBlogFieldName_Values returns all elements of the ConfluenceBlogFieldName enum
func ConfluenceBlogFieldName_Values() []string {
	return []string{
		ConfluenceBlogFieldNameAuthor,
		ConfluenceBlogFieldNameDisplayUrl,
		ConfluenceBlogFieldNameItemType,
		ConfluenceBlogFieldNameLabels,
		ConfluenceBlogFieldNamePublishDate,
		ConfluenceBlogFieldNameSpaceKey,
		ConfluenceBlogFieldNameSpaceName,
		ConfluenceBlogFieldNameUrl,
		ConfluenceBlogFieldNameVersion,
	}
}

const (
	// ConfluencePageFieldNameAuthor is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameAuthor = "AUTHOR"

	// ConfluencePageFieldNameContentStatus is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameContentStatus = "CONTENT_STATUS"

	// ConfluencePageFieldNameCreatedDate is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameCreatedDate = "CREATED_DATE"

	// ConfluencePageFieldNameDisplayUrl is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameDisplayUrl = "DISPLAY_URL"

	// ConfluencePageFieldNameItemType is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameItemType = "ITEM_TYPE"

	// ConfluencePageFieldNameLabels is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameLabels = "LABELS"

	// ConfluencePageFieldNameModifiedDate is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameModifiedDate = "MODIFIED_DATE"

	// ConfluencePageFieldNameParentId is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameParentId = "PARENT_ID"

	// ConfluencePageFieldNameSpaceKey is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameSpaceKey = "SPACE_KEY"

	// ConfluencePageFieldNameSpaceName is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameSpaceName = "SPACE_NAME"

	// ConfluencePageFieldNameUrl is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameUrl = "URL"

	// ConfluencePageFieldNameVersion is a ConfluencePageFieldName enum value
	ConfluencePageFieldNameVersion = "VERSION"
)

// ConfluencePageFieldName_Values returns all elements of the ConfluencePageFieldName enum
func ConfluencePageFieldName_Values() []string {
	return []string{
		ConfluencePageFieldNameAuthor,
		ConfluencePageFieldNameContentStatus,
		ConfluencePageFieldNameCreatedDate,
		ConfluencePageFieldNameDisplayUrl,
		ConfluencePageFieldNameItemType,
		ConfluencePageFieldNameLabels,
		ConfluencePageFieldNameModifiedDate,
		ConfluencePageFieldNameParentId,
		ConfluencePageFieldNameSpaceKey,
		ConfluencePageFieldNameSpaceName,
		ConfluencePageFieldNameUrl,
		ConfluencePageFieldNameVersion,
	}
}

const (
	// ConfluenceSpaceFieldNameDisplayUrl is a ConfluenceSpaceFieldName enum value
	ConfluenceSpaceFieldNameDisplayUrl = "DISPLAY_URL"

	// ConfluenceSpaceFieldNameItemType is a ConfluenceSpaceFieldName enum value
	ConfluenceSpaceFieldNameItemType = "ITEM_TYPE"

	// ConfluenceSpaceFieldNameSpaceKey is a ConfluenceSpaceFieldName enum value
	ConfluenceSpaceFieldNameSpaceKey = "SPACE_KEY"

	// ConfluenceSpaceFieldNameUrl is a ConfluenceSpaceFieldName enum value
	ConfluenceSpaceFieldNameUrl = "URL"
)

// ConfluenceSpaceFieldName_Values returns all elements of the ConfluenceSpaceFieldName enum
func ConfluenceSpaceFieldName_Values() []string {
	return []string{
		ConfluenceSpaceFieldNameDisplayUrl,
		ConfluenceSpaceFieldNameItemType,
		ConfluenceSpaceFieldNameSpaceKey,
		ConfluenceSpaceFieldNameUrl,
	}
}

const (
	// ConfluenceVersionCloud is a ConfluenceVersion enum value
	ConfluenceVersionCloud = "CLOUD"

	// ConfluenceVersionServer is a ConfluenceVersion enum value
	ConfluenceVersionServer = "SERVER"
)

// ConfluenceVersion_Values returns all elements of the ConfluenceVersion enum
func ConfluenceVersion_Values() []string {
	return []string{
		ConfluenceVersionCloud,
		ConfluenceVersionServer,
	}
}

const (
	// ContentTypePdf is a ContentType enum value
	ContentTypePdf = "PDF"

	// ContentTypeHtml is a ContentType enum value
	ContentTypeHtml = "HTML"

	// ContentTypeMsWord is a ContentType enum value
	ContentTypeMsWord = "MS_WORD"

	// ContentTypePlainText is a ContentType enum value
	ContentTypePlainText = "PLAIN_TEXT"

	// ContentTypePpt is a ContentType enum value
	ContentTypePpt = "PPT"
)

// ContentType_Values returns all elements of the ContentType enum
func ContentType_Values() []string {
	return []string{
		ContentTypePdf,
		ContentTypeHtml,
		ContentTypeMsWord,
		ContentTypePlainText,
		ContentTypePpt,
	}
}

const (
	// DataSourceStatusCreating is a DataSourceStatus enum value
	DataSourceStatusCreating = "CREATING"

	// DataSourceStatusDeleting is a DataSourceStatus enum value
	DataSourceStatusDeleting = "DELETING"

	// DataSourceStatusFailed is a DataSourceStatus enum value
	DataSourceStatusFailed = "FAILED"

	// DataSourceStatusUpdating is a DataSourceStatus enum value
	DataSourceStatusUpdating = "UPDATING"

	// DataSourceStatusActive is a DataSourceStatus enum value
	DataSourceStatusActive = "ACTIVE"
)

// DataSourceStatus_Values returns all elements of the DataSourceStatus enum
func DataSourceStatus_Values() []string {
	return []string{
		DataSourceStatusCreating,
		DataSourceStatusDeleting,
		DataSourceStatusFailed,
		DataSourceStatusUpdating,
		DataSourceStatusActive,
	}
}

const (
	// DataSourceSyncJobStatusFailed is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusFailed = "FAILED"

	// DataSourceSyncJobStatusSucceeded is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusSucceeded = "SUCCEEDED"

	// DataSourceSyncJobStatusSyncing is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusSyncing = "SYNCING"

	// DataSourceSyncJobStatusIncomplete is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusIncomplete = "INCOMPLETE"

	// DataSourceSyncJobStatusStopping is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusStopping = "STOPPING"

	// DataSourceSyncJobStatusAborted is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusAborted = "ABORTED"

	// DataSourceSyncJobStatusSyncingIndexing is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusSyncingIndexing = "SYNCING_INDEXING"
)

// DataSourceSyncJobStatus_Values returns all elements of the DataSourceSyncJobStatus enum
func DataSourceSyncJobStatus_Values() []string {
	return []string{
		DataSourceSyncJobStatusFailed,
		DataSourceSyncJobStatusSucceeded,
		DataSourceSyncJobStatusSyncing,
		DataSourceSyncJobStatusIncomplete,
		DataSourceSyncJobStatusStopping,
		DataSourceSyncJobStatusAborted,
		DataSourceSyncJobStatusSyncingIndexing,
	}
}

const (
	// DataSourceTypeS3 is a DataSourceType enum value
	DataSourceTypeS3 = "S3"

	// DataSourceTypeSharepoint is a DataSourceType enum value
	DataSourceTypeSharepoint = "SHAREPOINT"

	// DataSourceTypeDatabase is a DataSourceType enum value
	DataSourceTypeDatabase = "DATABASE"

	// DataSourceTypeSalesforce is a DataSourceType enum value
	DataSourceTypeSalesforce = "SALESFORCE"

	// DataSourceTypeOnedrive is a DataSourceType enum value
	DataSourceTypeOnedrive = "ONEDRIVE"

	// DataSourceTypeServicenow is a DataSourceType enum value
	DataSourceTypeServicenow = "SERVICENOW"

	// DataSourceTypeCustom is a DataSourceType enum value
	DataSourceTypeCustom = "CUSTOM"

	// DataSourceTypeConfluence is a DataSourceType enum value
	DataSourceTypeConfluence = "CONFLUENCE"

	// DataSourceTypeGoogledrive is a DataSourceType enum value
	DataSourceTypeGoogledrive = "GOOGLEDRIVE"

	// DataSourceTypeWebcrawler is a DataSourceType enum value
	DataSourceTypeWebcrawler = "WEBCRAWLER"

	// DataSourceTypeWorkdocs is a DataSourceType enum value
	DataSourceTypeWorkdocs = "WORKDOCS"
)

// DataSourceType_Values returns all elements of the DataSourceType enum
func DataSourceType_Values() []string {
	return []string{
		DataSourceTypeS3,
		DataSourceTypeSharepoint,
		DataSourceTypeDatabase,
		DataSourceTypeSalesforce,
		DataSourceTypeOnedrive,
		DataSourceTypeServicenow,
		DataSourceTypeCustom,
		DataSourceTypeConfluence,
		DataSourceTypeGoogledrive,
		DataSourceTypeWebcrawler,
		DataSourceTypeWorkdocs,
	}
}

const (
	// DatabaseEngineTypeRdsAuroraMysql is a DatabaseEngineType enum value
	DatabaseEngineTypeRdsAuroraMysql = "RDS_AURORA_MYSQL"

	// DatabaseEngineTypeRdsAuroraPostgresql is a DatabaseEngineType enum value
	DatabaseEngineTypeRdsAuroraPostgresql = "RDS_AURORA_POSTGRESQL"

	// DatabaseEngineTypeRdsMysql is a DatabaseEngineType enum value
	DatabaseEngineTypeRdsMysql = "RDS_MYSQL"

	// DatabaseEngineTypeRdsPostgresql is a DatabaseEngineType enum value
	DatabaseEngineTypeRdsPostgresql = "RDS_POSTGRESQL"
)

// DatabaseEngineType_Values returns all elements of the DatabaseEngineType enum
func DatabaseEngineType_Values() []string {
	return []string{
		DatabaseEngineTypeRdsAuroraMysql,
		DatabaseEngineTypeRdsAuroraPostgresql,
		DatabaseEngineTypeRdsMysql,
		DatabaseEngineTypeRdsPostgresql,
	}
}

const (
	// DocumentAttributeValueTypeStringValue is a DocumentAttributeValueType enum value
	DocumentAttributeValueTypeStringValue = "STRING_VALUE"

	// DocumentAttributeValueTypeStringListValue is a DocumentAttributeValueType enum value
	DocumentAttributeValueTypeStringListValue = "STRING_LIST_VALUE"

	// DocumentAttributeValueTypeLongValue is a DocumentAttributeValueType enum value
	DocumentAttributeValueTypeLongValue = "LONG_VALUE"

	// DocumentAttributeValueTypeDateValue is a DocumentAttributeValueType enum value
	DocumentAttributeValueTypeDateValue = "DATE_VALUE"
)

// DocumentAttributeValueType_Values returns all elements of the DocumentAttributeValueType enum
func DocumentAttributeValueType_Values() []string {
	return []string{
		DocumentAttributeValueTypeStringValue,
		DocumentAttributeValueTypeStringListValue,
		DocumentAttributeValueTypeLongValue,
		DocumentAttributeValueTypeDateValue,
	}
}

const (
	// DocumentStatusNotFound is a DocumentStatus enum value
	DocumentStatusNotFound = "NOT_FOUND"

	// DocumentStatusProcessing is a DocumentStatus enum value
	DocumentStatusProcessing = "PROCESSING"

	// DocumentStatusIndexed is a DocumentStatus enum value
	DocumentStatusIndexed = "INDEXED"

	// DocumentStatusUpdated is a DocumentStatus enum value
	DocumentStatusUpdated = "UPDATED"

	// DocumentStatusFailed is a DocumentStatus enum value
	DocumentStatusFailed = "FAILED"

	// DocumentStatusUpdateFailed is a DocumentStatus enum value
	DocumentStatusUpdateFailed = "UPDATE_FAILED"
)

// DocumentStatus_Values returns all elements of the DocumentStatus enum
func DocumentStatus_Values() []string {
	return []string{
		DocumentStatusNotFound,
		DocumentStatusProcessing,
		DocumentStatusIndexed,
		DocumentStatusUpdated,
		DocumentStatusFailed,
		DocumentStatusUpdateFailed,
	}
}

const (
	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "InternalError"

	// ErrorCodeInvalidRequest is a ErrorCode enum value
	ErrorCodeInvalidRequest = "InvalidRequest"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeInternalError,
		ErrorCodeInvalidRequest,
	}
}

const (
	// FaqFileFormatCsv is a FaqFileFormat enum value
	FaqFileFormatCsv = "CSV"

	// FaqFileFormatCsvWithHeader is a FaqFileFormat enum value
	FaqFileFormatCsvWithHeader = "CSV_WITH_HEADER"

	// FaqFileFormatJson is a FaqFileFormat enum value
	FaqFileFormatJson = "JSON"
)

// FaqFileFormat_Values returns all elements of the FaqFileFormat enum
func FaqFileFormat_Values() []string {
	return []string{
		FaqFileFormatCsv,
		FaqFileFormatCsvWithHeader,
		FaqFileFormatJson,
	}
}

const (
	// FaqStatusCreating is a FaqStatus enum value
	FaqStatusCreating = "CREATING"

	// FaqStatusUpdating is a FaqStatus enum value
	FaqStatusUpdating = "UPDATING"

	// FaqStatusActive is a FaqStatus enum value
	FaqStatusActive = "ACTIVE"

	// FaqStatusDeleting is a FaqStatus enum value
	FaqStatusDeleting = "DELETING"

	// FaqStatusFailed is a FaqStatus enum value
	FaqStatusFailed = "FAILED"
)

// FaqStatus_Values returns all elements of the FaqStatus enum
func FaqStatus_Values() []string {
	return []string{
		FaqStatusCreating,
		FaqStatusUpdating,
		FaqStatusActive,
		FaqStatusDeleting,
		FaqStatusFailed,
	}
}

const (
	// HighlightTypeStandard is a HighlightType enum value
	HighlightTypeStandard = "STANDARD"

	// HighlightTypeThesaurusSynonym is a HighlightType enum value
	HighlightTypeThesaurusSynonym = "THESAURUS_SYNONYM"
)

// HighlightType_Values returns all elements of the HighlightType enum
func HighlightType_Values() []string {
	return []string{
		HighlightTypeStandard,
		HighlightTypeThesaurusSynonym,
	}
}

const (
	// IndexEditionDeveloperEdition is a IndexEdition enum value
	IndexEditionDeveloperEdition = "DEVELOPER_EDITION"

	// IndexEditionEnterpriseEdition is a IndexEdition enum value
	IndexEditionEnterpriseEdition = "ENTERPRISE_EDITION"
)

// IndexEdition_Values returns all elements of the IndexEdition enum
func IndexEdition_Values() []string {
	return []string{
		IndexEditionDeveloperEdition,
		IndexEditionEnterpriseEdition,
	}
}

const (
	// IndexStatusCreating is a IndexStatus enum value
	IndexStatusCreating = "CREATING"

	// IndexStatusActive is a IndexStatus enum value
	IndexStatusActive = "ACTIVE"

	// IndexStatusDeleting is a IndexStatus enum value
	IndexStatusDeleting = "DELETING"

	// IndexStatusFailed is a IndexStatus enum value
	IndexStatusFailed = "FAILED"

	// IndexStatusUpdating is a IndexStatus enum value
	IndexStatusUpdating = "UPDATING"

	// IndexStatusSystemUpdating is a IndexStatus enum value
	IndexStatusSystemUpdating = "SYSTEM_UPDATING"
)

// IndexStatus_Values returns all elements of the IndexStatus enum
func IndexStatus_Values() []string {
	return []string{
		IndexStatusCreating,
		IndexStatusActive,
		IndexStatusDeleting,
		IndexStatusFailed,
		IndexStatusUpdating,
		IndexStatusSystemUpdating,
	}
}

const (
	// KeyLocationUrl is a KeyLocation enum value
	KeyLocationUrl = "URL"

	// KeyLocationSecretManager is a KeyLocation enum value
	KeyLocationSecretManager = "SECRET_MANAGER"
)

// KeyLocation_Values returns all elements of the KeyLocation enum
func KeyLocation_Values() []string {
	return []string{
		KeyLocationUrl,
		KeyLocationSecretManager,
	}
}

const (
	// ModeEnabled is a Mode enum value
	ModeEnabled = "ENABLED"

	// ModeLearnOnly is a Mode enum value
	ModeLearnOnly = "LEARN_ONLY"
)

// Mode_Values returns all elements of the Mode enum
func Mode_Values() []string {
	return []string{
		ModeEnabled,
		ModeLearnOnly,
	}
}

const (
	// OrderAscending is a Order enum value
	OrderAscending = "ASCENDING"

	// OrderDescending is a Order enum value
	OrderDescending = "DESCENDING"
)

// Order_Values returns all elements of the Order enum
func Order_Values() []string {
	return []string{
		OrderAscending,
		OrderDescending,
	}
}

const (
	// PrincipalMappingStatusFailed is a PrincipalMappingStatus enum value
	PrincipalMappingStatusFailed = "FAILED"

	// PrincipalMappingStatusSucceeded is a PrincipalMappingStatus enum value
	PrincipalMappingStatusSucceeded = "SUCCEEDED"

	// PrincipalMappingStatusProcessing is a PrincipalMappingStatus enum value
	PrincipalMappingStatusProcessing = "PROCESSING"

	// PrincipalMappingStatusDeleting is a PrincipalMappingStatus enum value
	PrincipalMappingStatusDeleting = "DELETING"

	// PrincipalMappingStatusDeleted is a PrincipalMappingStatus enum value
	PrincipalMappingStatusDeleted = "DELETED"
)

// PrincipalMappingStatus_Values returns all elements of the PrincipalMappingStatus enum
func PrincipalMappingStatus_Values() []string {
	return []string{
		PrincipalMappingStatusFailed,
		PrincipalMappingStatusSucceeded,
		PrincipalMappingStatusProcessing,
		PrincipalMappingStatusDeleting,
		PrincipalMappingStatusDeleted,
	}
}

const (
	// PrincipalTypeUser is a PrincipalType enum value
	PrincipalTypeUser = "USER"

	// PrincipalTypeGroup is a PrincipalType enum value
	PrincipalTypeGroup = "GROUP"
)

// PrincipalType_Values returns all elements of the PrincipalType enum
func PrincipalType_Values() []string {
	return []string{
		PrincipalTypeUser,
		PrincipalTypeGroup,
	}
}

const (
	// QueryIdentifiersEnclosingOptionDoubleQuotes is a QueryIdentifiersEnclosingOption enum value
	QueryIdentifiersEnclosingOptionDoubleQuotes = "DOUBLE_QUOTES"

	// QueryIdentifiersEnclosingOptionNone is a QueryIdentifiersEnclosingOption enum value
	QueryIdentifiersEnclosingOptionNone = "NONE"
)

// QueryIdentifiersEnclosingOption_Values returns all elements of the QueryIdentifiersEnclosingOption enum
func QueryIdentifiersEnclosingOption_Values() []string {
	return []string{
		QueryIdentifiersEnclosingOptionDoubleQuotes,
		QueryIdentifiersEnclosingOptionNone,
	}
}

const (
	// QueryResultTypeDocument is a QueryResultType enum value
	QueryResultTypeDocument = "DOCUMENT"

	// QueryResultTypeQuestionAnswer is a QueryResultType enum value
	QueryResultTypeQuestionAnswer = "QUESTION_ANSWER"

	// QueryResultTypeAnswer is a QueryResultType enum value
	QueryResultTypeAnswer = "ANSWER"
)

// QueryResultType_Values returns all elements of the QueryResultType enum
func QueryResultType_Values() []string {
	return []string{
		QueryResultTypeDocument,
		QueryResultTypeQuestionAnswer,
		QueryResultTypeAnswer,
	}
}

const (
	// QuerySuggestionsBlockListStatusActive is a QuerySuggestionsBlockListStatus enum value
	QuerySuggestionsBlockListStatusActive = "ACTIVE"

	// QuerySuggestionsBlockListStatusCreating is a QuerySuggestionsBlockListStatus enum value
	QuerySuggestionsBlockListStatusCreating = "CREATING"

	// QuerySuggestionsBlockListStatusDeleting is a QuerySuggestionsBlockListStatus enum value
	QuerySuggestionsBlockListStatusDeleting = "DELETING"

	// QuerySuggestionsBlockListStatusUpdating is a QuerySuggestionsBlockListStatus enum value
	QuerySuggestionsBlockListStatusUpdating = "UPDATING"

	// QuerySuggestionsBlockListStatusActiveButUpdateFailed is a QuerySuggestionsBlockListStatus enum value
	QuerySuggestionsBlockListStatusActiveButUpdateFailed = "ACTIVE_BUT_UPDATE_FAILED"

	// QuerySuggestionsBlockListStatusFailed is a QuerySuggestionsBlockListStatus enum value
	QuerySuggestionsBlockListStatusFailed = "FAILED"
)

// QuerySuggestionsBlockListStatus_Values returns all elements of the QuerySuggestionsBlockListStatus enum
func QuerySuggestionsBlockListStatus_Values() []string {
	return []string{
		QuerySuggestionsBlockListStatusActive,
		QuerySuggestionsBlockListStatusCreating,
		QuerySuggestionsBlockListStatusDeleting,
		QuerySuggestionsBlockListStatusUpdating,
		QuerySuggestionsBlockListStatusActiveButUpdateFailed,
		QuerySuggestionsBlockListStatusFailed,
	}
}

const (
	// QuerySuggestionsStatusActive is a QuerySuggestionsStatus enum value
	QuerySuggestionsStatusActive = "ACTIVE"

	// QuerySuggestionsStatusUpdating is a QuerySuggestionsStatus enum value
	QuerySuggestionsStatusUpdating = "UPDATING"
)

// QuerySuggestionsStatus_Values returns all elements of the QuerySuggestionsStatus enum
func QuerySuggestionsStatus_Values() []string {
	return []string{
		QuerySuggestionsStatusActive,
		QuerySuggestionsStatusUpdating,
	}
}

const (
	// ReadAccessTypeAllow is a ReadAccessType enum value
	ReadAccessTypeAllow = "ALLOW"

	// ReadAccessTypeDeny is a ReadAccessType enum value
	ReadAccessTypeDeny = "DENY"
)

// ReadAccessType_Values returns all elements of the ReadAccessType enum
func ReadAccessType_Values() []string {
	return []string{
		ReadAccessTypeAllow,
		ReadAccessTypeDeny,
	}
}

const (
	// RelevanceTypeRelevant is a RelevanceType enum value
	RelevanceTypeRelevant = "RELEVANT"

	// RelevanceTypeNotRelevant is a RelevanceType enum value
	RelevanceTypeNotRelevant = "NOT_RELEVANT"
)

// RelevanceType_Values returns all elements of the RelevanceType enum
func RelevanceType_Values() []string {
	return []string{
		RelevanceTypeRelevant,
		RelevanceTypeNotRelevant,
	}
}

const (
	// SalesforceChatterFeedIncludeFilterTypeActiveUser is a SalesforceChatterFeedIncludeFilterType enum value
	SalesforceChatterFeedIncludeFilterTypeActiveUser = "ACTIVE_USER"

	// SalesforceChatterFeedIncludeFilterTypeStandardUser is a SalesforceChatterFeedIncludeFilterType enum value
	SalesforceChatterFeedIncludeFilterTypeStandardUser = "STANDARD_USER"
)

// SalesforceChatterFeedIncludeFilterType_Values returns all elements of the SalesforceChatterFeedIncludeFilterType enum
func SalesforceChatterFeedIncludeFilterType_Values() []string {
	return []string{
		SalesforceChatterFeedIncludeFilterTypeActiveUser,
		SalesforceChatterFeedIncludeFilterTypeStandardUser,
	}
}

const (
	// SalesforceKnowledgeArticleStateDraft is a SalesforceKnowledgeArticleState enum value
	SalesforceKnowledgeArticleStateDraft = "DRAFT"

	// SalesforceKnowledgeArticleStatePublished is a SalesforceKnowledgeArticleState enum value
	SalesforceKnowledgeArticleStatePublished = "PUBLISHED"

	// SalesforceKnowledgeArticleStateArchived is a SalesforceKnowledgeArticleState enum value
	SalesforceKnowledgeArticleStateArchived = "ARCHIVED"
)

// SalesforceKnowledgeArticleState_Values returns all elements of the SalesforceKnowledgeArticleState enum
func SalesforceKnowledgeArticleState_Values() []string {
	return []string{
		SalesforceKnowledgeArticleStateDraft,
		SalesforceKnowledgeArticleStatePublished,
		SalesforceKnowledgeArticleStateArchived,
	}
}

const (
	// SalesforceStandardObjectNameAccount is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameAccount = "ACCOUNT"

	// SalesforceStandardObjectNameCampaign is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameCampaign = "CAMPAIGN"

	// SalesforceStandardObjectNameCase is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameCase = "CASE"

	// SalesforceStandardObjectNameContact is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameContact = "CONTACT"

	// SalesforceStandardObjectNameContract is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameContract = "CONTRACT"

	// SalesforceStandardObjectNameDocument is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameDocument = "DOCUMENT"

	// SalesforceStandardObjectNameGroup is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameGroup = "GROUP"

	// SalesforceStandardObjectNameIdea is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameIdea = "IDEA"

	// SalesforceStandardObjectNameLead is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameLead = "LEAD"

	// SalesforceStandardObjectNameOpportunity is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameOpportunity = "OPPORTUNITY"

	// SalesforceStandardObjectNamePartner is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNamePartner = "PARTNER"

	// SalesforceStandardObjectNamePricebook is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNamePricebook = "PRICEBOOK"

	// SalesforceStandardObjectNameProduct is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameProduct = "PRODUCT"

	// SalesforceStandardObjectNameProfile is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameProfile = "PROFILE"

	// SalesforceStandardObjectNameSolution is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameSolution = "SOLUTION"

	// SalesforceStandardObjectNameTask is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameTask = "TASK"

	// SalesforceStandardObjectNameUser is a SalesforceStandardObjectName enum value
	SalesforceStandardObjectNameUser = "USER"
)

// SalesforceStandardObjectName_Values returns all elements of the SalesforceStandardObjectName enum
func SalesforceStandardObjectName_Values() []string {
	return []string{
		SalesforceStandardObjectNameAccount,
		SalesforceStandardObjectNameCampaign,
		SalesforceStandardObjectNameCase,
		SalesforceStandardObjectNameContact,
		SalesforceStandardObjectNameContract,
		SalesforceStandardObjectNameDocument,
		SalesforceStandardObjectNameGroup,
		SalesforceStandardObjectNameIdea,
		SalesforceStandardObjectNameLead,
		SalesforceStandardObjectNameOpportunity,
		SalesforceStandardObjectNamePartner,
		SalesforceStandardObjectNamePricebook,
		SalesforceStandardObjectNameProduct,
		SalesforceStandardObjectNameProfile,
		SalesforceStandardObjectNameSolution,
		SalesforceStandardObjectNameTask,
		SalesforceStandardObjectNameUser,
	}
}

// Enumeration for query score confidence.
const (
	// ScoreConfidenceVeryHigh is a ScoreConfidence enum value
	ScoreConfidenceVeryHigh = "VERY_HIGH"

	// ScoreConfidenceHigh is a ScoreConfidence enum value
	ScoreConfidenceHigh = "HIGH"

	// ScoreConfidenceMedium is a ScoreConfidence enum value
	ScoreConfidenceMedium = "MEDIUM"

	// ScoreConfidenceLow is a ScoreConfidence enum value
	ScoreConfidenceLow = "LOW"
)

// ScoreConfidence_Values returns all elements of the ScoreConfidence enum
func ScoreConfidence_Values() []string {
	return []string{
		ScoreConfidenceVeryHigh,
		ScoreConfidenceHigh,
		ScoreConfidenceMedium,
		ScoreConfidenceLow,
	}
}

const (
	// ServiceNowAuthenticationTypeHttpBasic is a ServiceNowAuthenticationType enum value
	ServiceNowAuthenticationTypeHttpBasic = "HTTP_BASIC"

	// ServiceNowAuthenticationTypeOauth2 is a ServiceNowAuthenticationType enum value
	ServiceNowAuthenticationTypeOauth2 = "OAUTH2"
)

// ServiceNowAuthenticationType_Values returns all elements of the ServiceNowAuthenticationType enum
func ServiceNowAuthenticationType_Values() []string {
	return []string{
		ServiceNowAuthenticationTypeHttpBasic,
		ServiceNowAuthenticationTypeOauth2,
	}
}

const (
	// ServiceNowBuildVersionTypeLondon is a ServiceNowBuildVersionType enum value
	ServiceNowBuildVersionTypeLondon = "LONDON"

	// ServiceNowBuildVersionTypeOthers is a ServiceNowBuildVersionType enum value
	ServiceNowBuildVersionTypeOthers = "OTHERS"
)

// ServiceNowBuildVersionType_Values returns all elements of the ServiceNowBuildVersionType enum
func ServiceNowBuildVersionType_Values() []string {
	return []string{
		ServiceNowBuildVersionTypeLondon,
		ServiceNowBuildVersionTypeOthers,
	}
}

const (
	// SharePointVersionSharepoint2013 is a SharePointVersion enum value
	SharePointVersionSharepoint2013 = "SHAREPOINT_2013"

	// SharePointVersionSharepoint2016 is a SharePointVersion enum value
	SharePointVersionSharepoint2016 = "SHAREPOINT_2016"

	// SharePointVersionSharepointOnline is a SharePointVersion enum value
	SharePointVersionSharepointOnline = "SHAREPOINT_ONLINE"
)

// SharePointVersion_Values returns all elements of the SharePointVersion enum
func SharePointVersion_Values() []string {
	return []string{
		SharePointVersionSharepoint2013,
		SharePointVersionSharepoint2016,
		SharePointVersionSharepointOnline,
	}
}

const (
	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "DESC"

	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "ASC"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderDesc,
		SortOrderAsc,
	}
}

const (
	// ThesaurusStatusCreating is a ThesaurusStatus enum value
	ThesaurusStatusCreating = "CREATING"

	// ThesaurusStatusActive is a ThesaurusStatus enum value
	ThesaurusStatusActive = "ACTIVE"

	// ThesaurusStatusDeleting is a ThesaurusStatus enum value
	ThesaurusStatusDeleting = "DELETING"

	// ThesaurusStatusUpdating is a ThesaurusStatus enum value
	ThesaurusStatusUpdating = "UPDATING"

	// ThesaurusStatusActiveButUpdateFailed is a ThesaurusStatus enum value
	ThesaurusStatusActiveButUpdateFailed = "ACTIVE_BUT_UPDATE_FAILED"

	// ThesaurusStatusFailed is a ThesaurusStatus enum value
	ThesaurusStatusFailed = "FAILED"
)

// ThesaurusStatus_Values returns all elements of the ThesaurusStatus enum
func ThesaurusStatus_Values() []string {
	return []string{
		ThesaurusStatusCreating,
		ThesaurusStatusActive,
		ThesaurusStatusDeleting,
		ThesaurusStatusUpdating,
		ThesaurusStatusActiveButUpdateFailed,
		ThesaurusStatusFailed,
	}
}

const (
	// UserContextPolicyAttributeFilter is a UserContextPolicy enum value
	UserContextPolicyAttributeFilter = "ATTRIBUTE_FILTER"

	// UserContextPolicyUserToken is a UserContextPolicy enum value
	UserContextPolicyUserToken = "USER_TOKEN"
)

// UserContextPolicy_Values returns all elements of the UserContextPolicy enum
func UserContextPolicy_Values() []string {
	return []string{
		UserContextPolicyAttributeFilter,
		UserContextPolicyUserToken,
	}
}

const (
	// WebCrawlerModeHostOnly is a WebCrawlerMode enum value
	WebCrawlerModeHostOnly = "HOST_ONLY"

	// WebCrawlerModeSubdomains is a WebCrawlerMode enum value
	WebCrawlerModeSubdomains = "SUBDOMAINS"

	// WebCrawlerModeEverything is a WebCrawlerMode enum value
	WebCrawlerModeEverything = "EVERYTHING"
)

// WebCrawlerMode_Values returns all elements of the WebCrawlerMode enum
func WebCrawlerMode_Values() []string {
	return []string{
		WebCrawlerModeHostOnly,
		WebCrawlerModeSubdomains,
		WebCrawlerModeEverything,
	}
}
