// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package signer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddProfilePermission = "AddProfilePermission"

// AddProfilePermissionRequest generates a "aws/request.Request" representing the
// client's request for the AddProfilePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddProfilePermission for more information on using the AddProfilePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddProfilePermissionRequest method.
//    req, resp := client.AddProfilePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/AddProfilePermission
func (c *Signer) AddProfilePermissionRequest(input *AddProfilePermissionInput) (req *request.Request, output *AddProfilePermissionOutput) {
	op := &request.Operation{
		Name:       opAddProfilePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/signing-profiles/{profileName}/permissions",
	}

	if input == nil {
		input = &AddProfilePermissionInput{}
	}

	output = &AddProfilePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddProfilePermission API operation for AWS Signer.
//
// Adds cross-account permissions to a signing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation AddProfilePermission for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceLimitExceededException
//   The client is making a request that exceeds service limits.
//
//   * ConflictException
//   The resource encountered a conflicting state.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/AddProfilePermission
func (c *Signer) AddProfilePermission(input *AddProfilePermissionInput) (*AddProfilePermissionOutput, error) {
	req, out := c.AddProfilePermissionRequest(input)
	return out, req.Send()
}

// AddProfilePermissionWithContext is the same as AddProfilePermission with the addition of
// the ability to pass a context and additional request options.
//
// See AddProfilePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) AddProfilePermissionWithContext(ctx aws.Context, input *AddProfilePermissionInput, opts ...request.Option) (*AddProfilePermissionOutput, error) {
	req, out := c.AddProfilePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSigningProfile = "CancelSigningProfile"

// CancelSigningProfileRequest generates a "aws/request.Request" representing the
// client's request for the CancelSigningProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSigningProfile for more information on using the CancelSigningProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelSigningProfileRequest method.
//    req, resp := client.CancelSigningProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/CancelSigningProfile
func (c *Signer) CancelSigningProfileRequest(input *CancelSigningProfileInput) (req *request.Request, output *CancelSigningProfileOutput) {
	op := &request.Operation{
		Name:       opCancelSigningProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/signing-profiles/{profileName}",
	}

	if input == nil {
		input = &CancelSigningProfileInput{}
	}

	output = &CancelSigningProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelSigningProfile API operation for AWS Signer.
//
// Changes the state of an ACTIVE signing profile to CANCELED. A canceled profile
// is still viewable with the ListSigningProfiles operation, but it cannot perform
// new signing jobs, and is deleted two years after cancelation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation CancelSigningProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/CancelSigningProfile
func (c *Signer) CancelSigningProfile(input *CancelSigningProfileInput) (*CancelSigningProfileOutput, error) {
	req, out := c.CancelSigningProfileRequest(input)
	return out, req.Send()
}

// CancelSigningProfileWithContext is the same as CancelSigningProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSigningProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) CancelSigningProfileWithContext(ctx aws.Context, input *CancelSigningProfileInput, opts ...request.Option) (*CancelSigningProfileOutput, error) {
	req, out := c.CancelSigningProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSigningJob = "DescribeSigningJob"

// DescribeSigningJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSigningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSigningJob for more information on using the DescribeSigningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSigningJobRequest method.
//    req, resp := client.DescribeSigningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/DescribeSigningJob
func (c *Signer) DescribeSigningJobRequest(input *DescribeSigningJobInput) (req *request.Request, output *DescribeSigningJobOutput) {
	op := &request.Operation{
		Name:       opDescribeSigningJob,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeSigningJobInput{}
	}

	output = &DescribeSigningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSigningJob API operation for AWS Signer.
//
// Returns information about a specific code signing job. You specify the job
// by using the jobId value that is returned by the StartSigningJob operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation DescribeSigningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/DescribeSigningJob
func (c *Signer) DescribeSigningJob(input *DescribeSigningJobInput) (*DescribeSigningJobOutput, error) {
	req, out := c.DescribeSigningJobRequest(input)
	return out, req.Send()
}

// DescribeSigningJobWithContext is the same as DescribeSigningJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSigningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) DescribeSigningJobWithContext(ctx aws.Context, input *DescribeSigningJobInput, opts ...request.Option) (*DescribeSigningJobOutput, error) {
	req, out := c.DescribeSigningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSigningPlatform = "GetSigningPlatform"

// GetSigningPlatformRequest generates a "aws/request.Request" representing the
// client's request for the GetSigningPlatform operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSigningPlatform for more information on using the GetSigningPlatform
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSigningPlatformRequest method.
//    req, resp := client.GetSigningPlatformRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/GetSigningPlatform
func (c *Signer) GetSigningPlatformRequest(input *GetSigningPlatformInput) (req *request.Request, output *GetSigningPlatformOutput) {
	op := &request.Operation{
		Name:       opGetSigningPlatform,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-platforms/{platformId}",
	}

	if input == nil {
		input = &GetSigningPlatformInput{}
	}

	output = &GetSigningPlatformOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSigningPlatform API operation for AWS Signer.
//
// Returns information on a specific signing platform.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation GetSigningPlatform for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/GetSigningPlatform
func (c *Signer) GetSigningPlatform(input *GetSigningPlatformInput) (*GetSigningPlatformOutput, error) {
	req, out := c.GetSigningPlatformRequest(input)
	return out, req.Send()
}

// GetSigningPlatformWithContext is the same as GetSigningPlatform with the addition of
// the ability to pass a context and additional request options.
//
// See GetSigningPlatform for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) GetSigningPlatformWithContext(ctx aws.Context, input *GetSigningPlatformInput, opts ...request.Option) (*GetSigningPlatformOutput, error) {
	req, out := c.GetSigningPlatformRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSigningProfile = "GetSigningProfile"

// GetSigningProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetSigningProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSigningProfile for more information on using the GetSigningProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSigningProfileRequest method.
//    req, resp := client.GetSigningProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/GetSigningProfile
func (c *Signer) GetSigningProfileRequest(input *GetSigningProfileInput) (req *request.Request, output *GetSigningProfileOutput) {
	op := &request.Operation{
		Name:       opGetSigningProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-profiles/{profileName}",
	}

	if input == nil {
		input = &GetSigningProfileInput{}
	}

	output = &GetSigningProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSigningProfile API operation for AWS Signer.
//
// Returns information on a specific signing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation GetSigningProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/GetSigningProfile
func (c *Signer) GetSigningProfile(input *GetSigningProfileInput) (*GetSigningProfileOutput, error) {
	req, out := c.GetSigningProfileRequest(input)
	return out, req.Send()
}

// GetSigningProfileWithContext is the same as GetSigningProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetSigningProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) GetSigningProfileWithContext(ctx aws.Context, input *GetSigningProfileInput, opts ...request.Option) (*GetSigningProfileOutput, error) {
	req, out := c.GetSigningProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfilePermissions = "ListProfilePermissions"

// ListProfilePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListProfilePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfilePermissions for more information on using the ListProfilePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProfilePermissionsRequest method.
//    req, resp := client.ListProfilePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListProfilePermissions
func (c *Signer) ListProfilePermissionsRequest(input *ListProfilePermissionsInput) (req *request.Request, output *ListProfilePermissionsOutput) {
	op := &request.Operation{
		Name:       opListProfilePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-profiles/{profileName}/permissions",
	}

	if input == nil {
		input = &ListProfilePermissionsInput{}
	}

	output = &ListProfilePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfilePermissions API operation for AWS Signer.
//
// Lists the cross-account permissions associated with a signing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation ListProfilePermissions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListProfilePermissions
func (c *Signer) ListProfilePermissions(input *ListProfilePermissionsInput) (*ListProfilePermissionsOutput, error) {
	req, out := c.ListProfilePermissionsRequest(input)
	return out, req.Send()
}

// ListProfilePermissionsWithContext is the same as ListProfilePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfilePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListProfilePermissionsWithContext(ctx aws.Context, input *ListProfilePermissionsInput, opts ...request.Option) (*ListProfilePermissionsOutput, error) {
	req, out := c.ListProfilePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSigningJobs = "ListSigningJobs"

// ListSigningJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSigningJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSigningJobs for more information on using the ListSigningJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSigningJobsRequest method.
//    req, resp := client.ListSigningJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningJobs
func (c *Signer) ListSigningJobsRequest(input *ListSigningJobsInput) (req *request.Request, output *ListSigningJobsOutput) {
	op := &request.Operation{
		Name:       opListSigningJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSigningJobsInput{}
	}

	output = &ListSigningJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSigningJobs API operation for AWS Signer.
//
// Lists all your signing jobs. You can use the maxResults parameter to limit
// the number of signing jobs that are returned in the response. If additional
// jobs remain to be listed, code signing returns a nextToken value. Use this
// value in subsequent calls to ListSigningJobs to fetch the remaining values.
// You can continue calling ListSigningJobs with your maxResults parameter and
// with new values that code signing returns in the nextToken parameter until
// all of your signing jobs have been returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation ListSigningJobs for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningJobs
func (c *Signer) ListSigningJobs(input *ListSigningJobsInput) (*ListSigningJobsOutput, error) {
	req, out := c.ListSigningJobsRequest(input)
	return out, req.Send()
}

// ListSigningJobsWithContext is the same as ListSigningJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSigningJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningJobsWithContext(ctx aws.Context, input *ListSigningJobsInput, opts ...request.Option) (*ListSigningJobsOutput, error) {
	req, out := c.ListSigningJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSigningJobsPages iterates over the pages of a ListSigningJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSigningJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSigningJobs operation.
//    pageNum := 0
//    err := client.ListSigningJobsPages(params,
//        func(page *signer.ListSigningJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Signer) ListSigningJobsPages(input *ListSigningJobsInput, fn func(*ListSigningJobsOutput, bool) bool) error {
	return c.ListSigningJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSigningJobsPagesWithContext same as ListSigningJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningJobsPagesWithContext(ctx aws.Context, input *ListSigningJobsInput, fn func(*ListSigningJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSigningJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSigningJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSigningJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSigningPlatforms = "ListSigningPlatforms"

// ListSigningPlatformsRequest generates a "aws/request.Request" representing the
// client's request for the ListSigningPlatforms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSigningPlatforms for more information on using the ListSigningPlatforms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSigningPlatformsRequest method.
//    req, resp := client.ListSigningPlatformsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningPlatforms
func (c *Signer) ListSigningPlatformsRequest(input *ListSigningPlatformsInput) (req *request.Request, output *ListSigningPlatformsOutput) {
	op := &request.Operation{
		Name:       opListSigningPlatforms,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-platforms",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSigningPlatformsInput{}
	}

	output = &ListSigningPlatformsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSigningPlatforms API operation for AWS Signer.
//
// Lists all signing platforms available in code signing that match the request
// parameters. If additional jobs remain to be listed, code signing returns
// a nextToken value. Use this value in subsequent calls to ListSigningJobs
// to fetch the remaining values. You can continue calling ListSigningJobs with
// your maxResults parameter and with new values that code signing returns in
// the nextToken parameter until all of your signing jobs have been returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation ListSigningPlatforms for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningPlatforms
func (c *Signer) ListSigningPlatforms(input *ListSigningPlatformsInput) (*ListSigningPlatformsOutput, error) {
	req, out := c.ListSigningPlatformsRequest(input)
	return out, req.Send()
}

// ListSigningPlatformsWithContext is the same as ListSigningPlatforms with the addition of
// the ability to pass a context and additional request options.
//
// See ListSigningPlatforms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningPlatformsWithContext(ctx aws.Context, input *ListSigningPlatformsInput, opts ...request.Option) (*ListSigningPlatformsOutput, error) {
	req, out := c.ListSigningPlatformsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSigningPlatformsPages iterates over the pages of a ListSigningPlatforms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSigningPlatforms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSigningPlatforms operation.
//    pageNum := 0
//    err := client.ListSigningPlatformsPages(params,
//        func(page *signer.ListSigningPlatformsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Signer) ListSigningPlatformsPages(input *ListSigningPlatformsInput, fn func(*ListSigningPlatformsOutput, bool) bool) error {
	return c.ListSigningPlatformsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSigningPlatformsPagesWithContext same as ListSigningPlatformsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningPlatformsPagesWithContext(ctx aws.Context, input *ListSigningPlatformsInput, fn func(*ListSigningPlatformsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSigningPlatformsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSigningPlatformsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSigningPlatformsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSigningProfiles = "ListSigningProfiles"

// ListSigningProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListSigningProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSigningProfiles for more information on using the ListSigningProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSigningProfilesRequest method.
//    req, resp := client.ListSigningProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningProfiles
func (c *Signer) ListSigningProfilesRequest(input *ListSigningProfilesInput) (req *request.Request, output *ListSigningProfilesOutput) {
	op := &request.Operation{
		Name:       opListSigningProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSigningProfilesInput{}
	}

	output = &ListSigningProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSigningProfiles API operation for AWS Signer.
//
// Lists all available signing profiles in your AWS account. Returns only profiles
// with an ACTIVE status unless the includeCanceled request field is set to
// true. If additional jobs remain to be listed, code signing returns a nextToken
// value. Use this value in subsequent calls to ListSigningJobs to fetch the
// remaining values. You can continue calling ListSigningJobs with your maxResults
// parameter and with new values that code signing returns in the nextToken
// parameter until all of your signing jobs have been returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation ListSigningProfiles for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningProfiles
func (c *Signer) ListSigningProfiles(input *ListSigningProfilesInput) (*ListSigningProfilesOutput, error) {
	req, out := c.ListSigningProfilesRequest(input)
	return out, req.Send()
}

// ListSigningProfilesWithContext is the same as ListSigningProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListSigningProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningProfilesWithContext(ctx aws.Context, input *ListSigningProfilesInput, opts ...request.Option) (*ListSigningProfilesOutput, error) {
	req, out := c.ListSigningProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSigningProfilesPages iterates over the pages of a ListSigningProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSigningProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSigningProfiles operation.
//    pageNum := 0
//    err := client.ListSigningProfilesPages(params,
//        func(page *signer.ListSigningProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Signer) ListSigningProfilesPages(input *ListSigningProfilesInput, fn func(*ListSigningProfilesOutput, bool) bool) error {
	return c.ListSigningProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSigningProfilesPagesWithContext same as ListSigningProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningProfilesPagesWithContext(ctx aws.Context, input *ListSigningProfilesInput, fn func(*ListSigningProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSigningProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSigningProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSigningProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListTagsForResource
func (c *Signer) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Signer.
//
// Returns a list of the tags associated with a signing profile resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServiceErrorException
//   An internal error occurred.
//
//   * BadRequestException
//   The request contains invalid parameters for the ARN or tags. This exception
//   also occurs when you call a tagging API on a cancelled signing profile.
//
//   * NotFoundException
//   The signing profile was not found.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListTagsForResource
func (c *Signer) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSigningProfile = "PutSigningProfile"

// PutSigningProfileRequest generates a "aws/request.Request" representing the
// client's request for the PutSigningProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSigningProfile for more information on using the PutSigningProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSigningProfileRequest method.
//    req, resp := client.PutSigningProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/PutSigningProfile
func (c *Signer) PutSigningProfileRequest(input *PutSigningProfileInput) (req *request.Request, output *PutSigningProfileOutput) {
	op := &request.Operation{
		Name:       opPutSigningProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/signing-profiles/{profileName}",
	}

	if input == nil {
		input = &PutSigningProfileInput{}
	}

	output = &PutSigningProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSigningProfile API operation for AWS Signer.
//
// Creates a signing profile. A signing profile is a code signing template that
// can be used to carry out a pre-defined signing job. For more information,
// see http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html
// (http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation PutSigningProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/PutSigningProfile
func (c *Signer) PutSigningProfile(input *PutSigningProfileInput) (*PutSigningProfileOutput, error) {
	req, out := c.PutSigningProfileRequest(input)
	return out, req.Send()
}

// PutSigningProfileWithContext is the same as PutSigningProfile with the addition of
// the ability to pass a context and additional request options.
//
// See PutSigningProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) PutSigningProfileWithContext(ctx aws.Context, input *PutSigningProfileInput, opts ...request.Option) (*PutSigningProfileOutput, error) {
	req, out := c.PutSigningProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveProfilePermission = "RemoveProfilePermission"

// RemoveProfilePermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemoveProfilePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveProfilePermission for more information on using the RemoveProfilePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveProfilePermissionRequest method.
//    req, resp := client.RemoveProfilePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/RemoveProfilePermission
func (c *Signer) RemoveProfilePermissionRequest(input *RemoveProfilePermissionInput) (req *request.Request, output *RemoveProfilePermissionOutput) {
	op := &request.Operation{
		Name:       opRemoveProfilePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/signing-profiles/{profileName}/permissions/{statementId}",
	}

	if input == nil {
		input = &RemoveProfilePermissionInput{}
	}

	output = &RemoveProfilePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveProfilePermission API operation for AWS Signer.
//
// Removes cross-account permissions from a signing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation RemoveProfilePermission for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   The resource encountered a conflicting state.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/RemoveProfilePermission
func (c *Signer) RemoveProfilePermission(input *RemoveProfilePermissionInput) (*RemoveProfilePermissionOutput, error) {
	req, out := c.RemoveProfilePermissionRequest(input)
	return out, req.Send()
}

// RemoveProfilePermissionWithContext is the same as RemoveProfilePermission with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveProfilePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) RemoveProfilePermissionWithContext(ctx aws.Context, input *RemoveProfilePermissionInput, opts ...request.Option) (*RemoveProfilePermissionOutput, error) {
	req, out := c.RemoveProfilePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeSignature = "RevokeSignature"

// RevokeSignatureRequest generates a "aws/request.Request" representing the
// client's request for the RevokeSignature operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeSignature for more information on using the RevokeSignature
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeSignatureRequest method.
//    req, resp := client.RevokeSignatureRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/RevokeSignature
func (c *Signer) RevokeSignatureRequest(input *RevokeSignatureInput) (req *request.Request, output *RevokeSignatureOutput) {
	op := &request.Operation{
		Name:       opRevokeSignature,
		HTTPMethod: "PUT",
		HTTPPath:   "/signing-jobs/{jobId}/revoke",
	}

	if input == nil {
		input = &RevokeSignatureInput{}
	}

	output = &RevokeSignatureOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeSignature API operation for AWS Signer.
//
// Changes the state of a signing job to REVOKED. This indicates that the signature
// is no longer valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation RevokeSignature for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/RevokeSignature
func (c *Signer) RevokeSignature(input *RevokeSignatureInput) (*RevokeSignatureOutput, error) {
	req, out := c.RevokeSignatureRequest(input)
	return out, req.Send()
}

// RevokeSignatureWithContext is the same as RevokeSignature with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeSignature for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) RevokeSignatureWithContext(ctx aws.Context, input *RevokeSignatureInput, opts ...request.Option) (*RevokeSignatureOutput, error) {
	req, out := c.RevokeSignatureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeSigningProfile = "RevokeSigningProfile"

// RevokeSigningProfileRequest generates a "aws/request.Request" representing the
// client's request for the RevokeSigningProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeSigningProfile for more information on using the RevokeSigningProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeSigningProfileRequest method.
//    req, resp := client.RevokeSigningProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/RevokeSigningProfile
func (c *Signer) RevokeSigningProfileRequest(input *RevokeSigningProfileInput) (req *request.Request, output *RevokeSigningProfileOutput) {
	op := &request.Operation{
		Name:       opRevokeSigningProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/signing-profiles/{profileName}/revoke",
	}

	if input == nil {
		input = &RevokeSigningProfileInput{}
	}

	output = &RevokeSigningProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeSigningProfile API operation for AWS Signer.
//
// Changes the state of a signing profile to REVOKED. This indicates that signatures
// generated using the signing profile after an effective start date are no
// longer valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation RevokeSigningProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/RevokeSigningProfile
func (c *Signer) RevokeSigningProfile(input *RevokeSigningProfileInput) (*RevokeSigningProfileOutput, error) {
	req, out := c.RevokeSigningProfileRequest(input)
	return out, req.Send()
}

// RevokeSigningProfileWithContext is the same as RevokeSigningProfile with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeSigningProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) RevokeSigningProfileWithContext(ctx aws.Context, input *RevokeSigningProfileInput, opts ...request.Option) (*RevokeSigningProfileOutput, error) {
	req, out := c.RevokeSigningProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSigningJob = "StartSigningJob"

// StartSigningJobRequest generates a "aws/request.Request" representing the
// client's request for the StartSigningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSigningJob for more information on using the StartSigningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSigningJobRequest method.
//    req, resp := client.StartSigningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/StartSigningJob
func (c *Signer) StartSigningJobRequest(input *StartSigningJobInput) (req *request.Request, output *StartSigningJobOutput) {
	op := &request.Operation{
		Name:       opStartSigningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/signing-jobs",
	}

	if input == nil {
		input = &StartSigningJobInput{}
	}

	output = &StartSigningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSigningJob API operation for AWS Signer.
//
// Initiates a signing job to be performed on the code provided. Signing jobs
// are viewable by the ListSigningJobs operation for two years after they are
// performed. Note the following requirements:
//
//    * You must create an Amazon S3 source bucket. For more information, see
//    Create a Bucket (http://docs.aws.amazon.com/AmazonS3/latest/gsg/CreatingABucket.html)
//    in the Amazon S3 Getting Started Guide.
//
//    * Your S3 source bucket must be version enabled.
//
//    * You must create an S3 destination bucket. Code signing uses your S3
//    destination bucket to write your signed code.
//
//    * You specify the name of the source and destination buckets when calling
//    the StartSigningJob operation.
//
//    * You must also specify a request token that identifies your request to
//    code signing.
//
// You can call the DescribeSigningJob and the ListSigningJobs actions after
// you call StartSigningJob.
//
// For a Java example that shows how to use this action, see http://docs.aws.amazon.com/acm/latest/userguide/
// (http://docs.aws.amazon.com/acm/latest/userguide/)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation StartSigningJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   You signing certificate could not be validated.
//
//   * ResourceNotFoundException
//   A specified resource could not be found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   Instead of this error, TooManyRequestsException should be used.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
//   * InternalServiceErrorException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/StartSigningJob
func (c *Signer) StartSigningJob(input *StartSigningJobInput) (*StartSigningJobOutput, error) {
	req, out := c.StartSigningJobRequest(input)
	return out, req.Send()
}

// StartSigningJobWithContext is the same as StartSigningJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartSigningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) StartSigningJobWithContext(ctx aws.Context, input *StartSigningJobInput, opts ...request.Option) (*StartSigningJobOutput, error) {
	req, out := c.StartSigningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/TagResource
func (c *Signer) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Signer.
//
// Adds one or more tags to a signing profile. Tags are labels that you can
// use to identify and organize your AWS resources. Each tag consists of a key
// and an optional value. To specify the signing profile, use its Amazon Resource
// Name (ARN). To specify the tag, use a key-value pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServiceErrorException
//   An internal error occurred.
//
//   * BadRequestException
//   The request contains invalid parameters for the ARN or tags. This exception
//   also occurs when you call a tagging API on a cancelled signing profile.
//
//   * NotFoundException
//   The signing profile was not found.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/TagResource
func (c *Signer) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/UntagResource
func (c *Signer) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Signer.
//
// Removes one or more tags from a signing profile. To remove the tags, specify
// a list of tag keys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServiceErrorException
//   An internal error occurred.
//
//   * BadRequestException
//   The request contains invalid parameters for the ARN or tags. This exception
//   also occurs when you call a tagging API on a cancelled signing profile.
//
//   * NotFoundException
//   The signing profile was not found.
//
//   * TooManyRequestsException
//   The allowed number of job-signing requests has been exceeded.
//
//   This error supersedes the error ThrottlingException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/UntagResource
func (c *Signer) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddProfilePermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS Signer action permitted as part of cross-account permissions.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true"`

	// The AWS principal receiving cross-account permissions. This may be an IAM
	// role or another AWS account ID.
	//
	// Principal is a required field
	Principal *string `locationName:"principal" type:"string" required:"true"`

	// The human-readable name of the signing profile.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`

	// The version of the signing profile.
	ProfileVersion *string `locationName:"profileVersion" min:"10" type:"string"`

	// A unique identifier for the current profile revision.
	RevisionId *string `locationName:"revisionId" type:"string"`

	// A unique identifier for the cross-account permission statement.
	//
	// StatementId is a required field
	StatementId *string `locationName:"statementId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddProfilePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddProfilePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddProfilePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddProfilePermissionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}
	if s.ProfileVersion != nil && len(*s.ProfileVersion) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileVersion", 10))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AddProfilePermissionInput) SetAction(v string) *AddProfilePermissionInput {
	s.Action = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AddProfilePermissionInput) SetPrincipal(v string) *AddProfilePermissionInput {
	s.Principal = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *AddProfilePermissionInput) SetProfileName(v string) *AddProfilePermissionInput {
	s.ProfileName = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *AddProfilePermissionInput) SetProfileVersion(v string) *AddProfilePermissionInput {
	s.ProfileVersion = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AddProfilePermissionInput) SetRevisionId(v string) *AddProfilePermissionInput {
	s.RevisionId = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *AddProfilePermissionInput) SetStatementId(v string) *AddProfilePermissionInput {
	s.StatementId = &v
	return s
}

type AddProfilePermissionOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the current profile revision.
	RevisionId *string `locationName:"revisionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddProfilePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddProfilePermissionOutput) GoString() string {
	return s.String()
}

// SetRevisionId sets the RevisionId field's value.
func (s *AddProfilePermissionOutput) SetRevisionId(v string) *AddProfilePermissionOutput {
	s.RevisionId = &v
	return s
}

// The request contains invalid parameters for the ARN or tags. This exception
// also occurs when you call a tagging API on a cancelled signing profile.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelSigningProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the signing profile to be canceled.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSigningProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSigningProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSigningProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSigningProfileInput"}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileName sets the ProfileName field's value.
func (s *CancelSigningProfileInput) SetProfileName(v string) *CancelSigningProfileInput {
	s.ProfileName = &v
	return s
}

type CancelSigningProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSigningProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSigningProfileOutput) GoString() string {
	return s.String()
}

// The resource encountered a conflicting state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeSigningJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the signing job on input.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSigningJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSigningJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSigningJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSigningJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeSigningJobInput) SetJobId(v string) *DescribeSigningJobInput {
	s.JobId = &v
	return s
}

type DescribeSigningJobOutput struct {
	_ struct{} `type:"structure"`

	// Date and time that the signing job was completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// Date and time that the signing job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the signing job on output.
	JobId *string `locationName:"jobId" type:"string"`

	// The IAM entity that initiated the signing job.
	JobInvoker *string `locationName:"jobInvoker" min:"12" type:"string"`

	// The AWS account ID of the job owner.
	JobOwner *string `locationName:"jobOwner" min:"12" type:"string"`

	// A list of any overrides that were applied to the signing operation.
	Overrides *SigningPlatformOverrides `locationName:"overrides" type:"structure"`

	// A human-readable name for the signing platform associated with the signing
	// job.
	PlatformDisplayName *string `locationName:"platformDisplayName" type:"string"`

	// The microcontroller platform to which your signed code image will be distributed.
	PlatformId *string `locationName:"platformId" type:"string"`

	// The name of the profile that initiated the signing operation.
	ProfileName *string `locationName:"profileName" min:"2" type:"string"`

	// The version of the signing profile used to initiate the signing job.
	ProfileVersion *string `locationName:"profileVersion" min:"10" type:"string"`

	// The IAM principal that requested the signing job.
	RequestedBy *string `locationName:"requestedBy" type:"string"`

	// A revocation record if the signature generated by the signing job has been
	// revoked. Contains a timestamp and the ID of the IAM entity that revoked the
	// signature.
	RevocationRecord *SigningJobRevocationRecord `locationName:"revocationRecord" type:"structure"`

	// Thr expiration timestamp for the signature generated by the signing job.
	SignatureExpiresAt *time.Time `locationName:"signatureExpiresAt" type:"timestamp"`

	// Name of the S3 bucket where the signed code image is saved by code signing.
	SignedObject *SignedObject `locationName:"signedObject" type:"structure"`

	// The Amazon Resource Name (ARN) of your code signing certificate.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// Map of user-assigned key-value pairs used during signing. These values contain
	// any information that you specified for use in your signing job.
	SigningParameters map[string]*string `locationName:"signingParameters" type:"map"`

	// The object that contains the name of your S3 bucket or your raw code.
	Source *Source `locationName:"source" type:"structure"`

	// Status of the signing job.
	Status *string `locationName:"status" type:"string" enum:"SigningStatus"`

	// String value that contains the status reason.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSigningJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSigningJobOutput) GoString() string {
	return s.String()
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *DescribeSigningJobOutput) SetCompletedAt(v time.Time) *DescribeSigningJobOutput {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeSigningJobOutput) SetCreatedAt(v time.Time) *DescribeSigningJobOutput {
	s.CreatedAt = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeSigningJobOutput) SetJobId(v string) *DescribeSigningJobOutput {
	s.JobId = &v
	return s
}

// SetJobInvoker sets the JobInvoker field's value.
func (s *DescribeSigningJobOutput) SetJobInvoker(v string) *DescribeSigningJobOutput {
	s.JobInvoker = &v
	return s
}

// SetJobOwner sets the JobOwner field's value.
func (s *DescribeSigningJobOutput) SetJobOwner(v string) *DescribeSigningJobOutput {
	s.JobOwner = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *DescribeSigningJobOutput) SetOverrides(v *SigningPlatformOverrides) *DescribeSigningJobOutput {
	s.Overrides = v
	return s
}

// SetPlatformDisplayName sets the PlatformDisplayName field's value.
func (s *DescribeSigningJobOutput) SetPlatformDisplayName(v string) *DescribeSigningJobOutput {
	s.PlatformDisplayName = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *DescribeSigningJobOutput) SetPlatformId(v string) *DescribeSigningJobOutput {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *DescribeSigningJobOutput) SetProfileName(v string) *DescribeSigningJobOutput {
	s.ProfileName = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *DescribeSigningJobOutput) SetProfileVersion(v string) *DescribeSigningJobOutput {
	s.ProfileVersion = &v
	return s
}

// SetRequestedBy sets the RequestedBy field's value.
func (s *DescribeSigningJobOutput) SetRequestedBy(v string) *DescribeSigningJobOutput {
	s.RequestedBy = &v
	return s
}

// SetRevocationRecord sets the RevocationRecord field's value.
func (s *DescribeSigningJobOutput) SetRevocationRecord(v *SigningJobRevocationRecord) *DescribeSigningJobOutput {
	s.RevocationRecord = v
	return s
}

// SetSignatureExpiresAt sets the SignatureExpiresAt field's value.
func (s *DescribeSigningJobOutput) SetSignatureExpiresAt(v time.Time) *DescribeSigningJobOutput {
	s.SignatureExpiresAt = &v
	return s
}

// SetSignedObject sets the SignedObject field's value.
func (s *DescribeSigningJobOutput) SetSignedObject(v *SignedObject) *DescribeSigningJobOutput {
	s.SignedObject = v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *DescribeSigningJobOutput) SetSigningMaterial(v *SigningMaterial) *DescribeSigningJobOutput {
	s.SigningMaterial = v
	return s
}

// SetSigningParameters sets the SigningParameters field's value.
func (s *DescribeSigningJobOutput) SetSigningParameters(v map[string]*string) *DescribeSigningJobOutput {
	s.SigningParameters = v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeSigningJobOutput) SetSource(v *Source) *DescribeSigningJobOutput {
	s.Source = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeSigningJobOutput) SetStatus(v string) *DescribeSigningJobOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeSigningJobOutput) SetStatusReason(v string) *DescribeSigningJobOutput {
	s.StatusReason = &v
	return s
}

// Points to an S3Destination object that contains information about your S3
// bucket.
type Destination struct {
	_ struct{} `type:"structure"`

	// The S3Destination object.
	S3 *S3Destination `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// SetS3 sets the S3 field's value.
func (s *Destination) SetS3(v *S3Destination) *Destination {
	s.S3 = v
	return s
}

// The encryption algorithm options that are available to a code signing job.
type EncryptionAlgorithmOptions struct {
	_ struct{} `type:"structure"`

	// The set of accepted encryption algorithms that are allowed in a code signing
	// job.
	//
	// AllowedValues is a required field
	AllowedValues []*string `locationName:"allowedValues" type:"list" required:"true"`

	// The default encryption algorithm that is used by a code signing job.
	//
	// DefaultValue is a required field
	DefaultValue *string `locationName:"defaultValue" type:"string" required:"true" enum:"EncryptionAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAlgorithmOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAlgorithmOptions) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *EncryptionAlgorithmOptions) SetAllowedValues(v []*string) *EncryptionAlgorithmOptions {
	s.AllowedValues = v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *EncryptionAlgorithmOptions) SetDefaultValue(v string) *EncryptionAlgorithmOptions {
	s.DefaultValue = &v
	return s
}

type GetSigningPlatformInput struct {
	_ struct{} `type:"structure"`

	// The ID of the target signing platform.
	//
	// PlatformId is a required field
	PlatformId *string `location:"uri" locationName:"platformId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningPlatformInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningPlatformInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSigningPlatformInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSigningPlatformInput"}
	if s.PlatformId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformId"))
	}
	if s.PlatformId != nil && len(*s.PlatformId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlatformId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlatformId sets the PlatformId field's value.
func (s *GetSigningPlatformInput) SetPlatformId(v string) *GetSigningPlatformInput {
	s.PlatformId = &v
	return s
}

type GetSigningPlatformOutput struct {
	_ struct{} `type:"structure"`

	// The category type of the target signing platform.
	Category *string `locationName:"category" type:"string" enum:"Category"`

	// The display name of the target signing platform.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The maximum size (in MB) of the payload that can be signed by the target
	// platform.
	MaxSizeInMB *int64 `locationName:"maxSizeInMB" type:"integer"`

	// A list of partner entities that use the target signing platform.
	Partner *string `locationName:"partner" type:"string"`

	// The ID of the target signing platform.
	PlatformId *string `locationName:"platformId" type:"string"`

	// A flag indicating whether signatures generated for the signing platform can
	// be revoked.
	RevocationSupported *bool `locationName:"revocationSupported" type:"boolean"`

	// A list of configurations applied to the target platform at signing.
	SigningConfiguration *SigningConfiguration `locationName:"signingConfiguration" type:"structure"`

	// The format of the target platform's signing image.
	SigningImageFormat *SigningImageFormat `locationName:"signingImageFormat" type:"structure"`

	// The validation template that is used by the target signing platform.
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningPlatformOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningPlatformOutput) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *GetSigningPlatformOutput) SetCategory(v string) *GetSigningPlatformOutput {
	s.Category = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetSigningPlatformOutput) SetDisplayName(v string) *GetSigningPlatformOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSizeInMB sets the MaxSizeInMB field's value.
func (s *GetSigningPlatformOutput) SetMaxSizeInMB(v int64) *GetSigningPlatformOutput {
	s.MaxSizeInMB = &v
	return s
}

// SetPartner sets the Partner field's value.
func (s *GetSigningPlatformOutput) SetPartner(v string) *GetSigningPlatformOutput {
	s.Partner = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *GetSigningPlatformOutput) SetPlatformId(v string) *GetSigningPlatformOutput {
	s.PlatformId = &v
	return s
}

// SetRevocationSupported sets the RevocationSupported field's value.
func (s *GetSigningPlatformOutput) SetRevocationSupported(v bool) *GetSigningPlatformOutput {
	s.RevocationSupported = &v
	return s
}

// SetSigningConfiguration sets the SigningConfiguration field's value.
func (s *GetSigningPlatformOutput) SetSigningConfiguration(v *SigningConfiguration) *GetSigningPlatformOutput {
	s.SigningConfiguration = v
	return s
}

// SetSigningImageFormat sets the SigningImageFormat field's value.
func (s *GetSigningPlatformOutput) SetSigningImageFormat(v *SigningImageFormat) *GetSigningPlatformOutput {
	s.SigningImageFormat = v
	return s
}

// SetTarget sets the Target field's value.
func (s *GetSigningPlatformOutput) SetTarget(v string) *GetSigningPlatformOutput {
	s.Target = &v
	return s
}

type GetSigningProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the target signing profile.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`

	// The AWS account ID of the profile owner.
	ProfileOwner *string `location:"querystring" locationName:"profileOwner" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSigningProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSigningProfileInput"}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}
	if s.ProfileOwner != nil && len(*s.ProfileOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileOwner", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileName sets the ProfileName field's value.
func (s *GetSigningProfileInput) SetProfileName(v string) *GetSigningProfileInput {
	s.ProfileName = &v
	return s
}

// SetProfileOwner sets the ProfileOwner field's value.
func (s *GetSigningProfileInput) SetProfileOwner(v string) *GetSigningProfileInput {
	s.ProfileOwner = &v
	return s
}

type GetSigningProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the signing profile.
	Arn *string `locationName:"arn" type:"string"`

	// A list of overrides applied by the target signing profile for signing operations.
	Overrides *SigningPlatformOverrides `locationName:"overrides" type:"structure"`

	// A human-readable name for the signing platform associated with the signing
	// profile.
	PlatformDisplayName *string `locationName:"platformDisplayName" type:"string"`

	// The ID of the platform that is used by the target signing profile.
	PlatformId *string `locationName:"platformId" type:"string"`

	// The name of the target signing profile.
	ProfileName *string `locationName:"profileName" min:"2" type:"string"`

	// The current version of the signing profile.
	ProfileVersion *string `locationName:"profileVersion" min:"10" type:"string"`

	// The signing profile ARN, including the profile version.
	ProfileVersionArn *string `locationName:"profileVersionArn" min:"20" type:"string"`

	// Revocation information for a signing profile.
	RevocationRecord *SigningProfileRevocationRecord `locationName:"revocationRecord" type:"structure"`

	// The validity period for a signing job.
	SignatureValidityPeriod *SignatureValidityPeriod `locationName:"signatureValidityPeriod" type:"structure"`

	// The ARN of the certificate that the target profile uses for signing operations.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// A map of key-value pairs for signing operations that is attached to the target
	// signing profile.
	SigningParameters map[string]*string `locationName:"signingParameters" type:"map"`

	// The status of the target signing profile.
	Status *string `locationName:"status" type:"string" enum:"SigningProfileStatus"`

	// Reason for the status of the target signing profile.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// A list of tags associated with the signing profile.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningProfileOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSigningProfileOutput) SetArn(v string) *GetSigningProfileOutput {
	s.Arn = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *GetSigningProfileOutput) SetOverrides(v *SigningPlatformOverrides) *GetSigningProfileOutput {
	s.Overrides = v
	return s
}

// SetPlatformDisplayName sets the PlatformDisplayName field's value.
func (s *GetSigningProfileOutput) SetPlatformDisplayName(v string) *GetSigningProfileOutput {
	s.PlatformDisplayName = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *GetSigningProfileOutput) SetPlatformId(v string) *GetSigningProfileOutput {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *GetSigningProfileOutput) SetProfileName(v string) *GetSigningProfileOutput {
	s.ProfileName = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *GetSigningProfileOutput) SetProfileVersion(v string) *GetSigningProfileOutput {
	s.ProfileVersion = &v
	return s
}

// SetProfileVersionArn sets the ProfileVersionArn field's value.
func (s *GetSigningProfileOutput) SetProfileVersionArn(v string) *GetSigningProfileOutput {
	s.ProfileVersionArn = &v
	return s
}

// SetRevocationRecord sets the RevocationRecord field's value.
func (s *GetSigningProfileOutput) SetRevocationRecord(v *SigningProfileRevocationRecord) *GetSigningProfileOutput {
	s.RevocationRecord = v
	return s
}

// SetSignatureValidityPeriod sets the SignatureValidityPeriod field's value.
func (s *GetSigningProfileOutput) SetSignatureValidityPeriod(v *SignatureValidityPeriod) *GetSigningProfileOutput {
	s.SignatureValidityPeriod = v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *GetSigningProfileOutput) SetSigningMaterial(v *SigningMaterial) *GetSigningProfileOutput {
	s.SigningMaterial = v
	return s
}

// SetSigningParameters sets the SigningParameters field's value.
func (s *GetSigningProfileOutput) SetSigningParameters(v map[string]*string) *GetSigningProfileOutput {
	s.SigningParameters = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSigningProfileOutput) SetStatus(v string) *GetSigningProfileOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetSigningProfileOutput) SetStatusReason(v string) *GetSigningProfileOutput {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSigningProfileOutput) SetTags(v map[string]*string) *GetSigningProfileOutput {
	s.Tags = v
	return s
}

// The hash algorithms that are available to a code signing job.
type HashAlgorithmOptions struct {
	_ struct{} `type:"structure"`

	// The set of accepted hash algorithms allowed in a code signing job.
	//
	// AllowedValues is a required field
	AllowedValues []*string `locationName:"allowedValues" type:"list" required:"true"`

	// The default hash algorithm that is used in a code signing job.
	//
	// DefaultValue is a required field
	DefaultValue *string `locationName:"defaultValue" type:"string" required:"true" enum:"HashAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HashAlgorithmOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HashAlgorithmOptions) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *HashAlgorithmOptions) SetAllowedValues(v []*string) *HashAlgorithmOptions {
	s.AllowedValues = v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *HashAlgorithmOptions) SetDefaultValue(v string) *HashAlgorithmOptions {
	s.DefaultValue = &v
	return s
}

// An internal error occurred.
type InternalServiceErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s *InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListProfilePermissionsInput struct {
	_ struct{} `type:"structure"`

	// String for specifying the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Name of the signing profile containing the cross-account permissions.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfilePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfilePermissionsInput"}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilePermissionsInput) SetNextToken(v string) *ListProfilePermissionsInput {
	s.NextToken = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *ListProfilePermissionsInput) SetProfileName(v string) *ListProfilePermissionsInput {
	s.ProfileName = &v
	return s
}

type ListProfilePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// String for specifying the next set of paginated results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of permissions associated with the Signing Profile.
	Permissions []*Permission `locationName:"permissions" type:"list"`

	// Total size of the policy associated with the Signing Profile in bytes.
	PolicySizeBytes *int64 `locationName:"policySizeBytes" type:"integer"`

	// The identifier for the current revision of profile permissions.
	RevisionId *string `locationName:"revisionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilePermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilePermissionsOutput) SetNextToken(v string) *ListProfilePermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListProfilePermissionsOutput) SetPermissions(v []*Permission) *ListProfilePermissionsOutput {
	s.Permissions = v
	return s
}

// SetPolicySizeBytes sets the PolicySizeBytes field's value.
func (s *ListProfilePermissionsOutput) SetPolicySizeBytes(v int64) *ListProfilePermissionsOutput {
	s.PolicySizeBytes = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ListProfilePermissionsOutput) SetRevisionId(v string) *ListProfilePermissionsOutput {
	s.RevisionId = &v
	return s
}

type ListSigningJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters results to return only signing jobs with revoked signatures.
	IsRevoked *bool `location:"querystring" locationName:"isRevoked" type:"boolean"`

	// Filters results to return only signing jobs initiated by a specified IAM
	// entity.
	JobInvoker *string `location:"querystring" locationName:"jobInvoker" min:"12" type:"string"`

	// Specifies the maximum number of items to return in the response. Use this
	// parameter when paginating results. If additional items exist beyond the number
	// you specify, the nextToken element is set in the response. Use the nextToken
	// value in a subsequent request to retrieve additional items.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// String for specifying the next set of paginated results to return. After
	// you receive a response with truncated results, use this parameter in a subsequent
	// request. Set it to the value of nextToken from the response that you just
	// received.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of microcontroller platform that you specified for the distribution
	// of your code image.
	PlatformId *string `location:"querystring" locationName:"platformId" type:"string"`

	// The IAM principal that requested the signing job.
	RequestedBy *string `location:"querystring" locationName:"requestedBy" type:"string"`

	// Filters results to return only signing jobs with signatures expiring after
	// a specified timestamp.
	SignatureExpiresAfter *time.Time `location:"querystring" locationName:"signatureExpiresAfter" type:"timestamp"`

	// Filters results to return only signing jobs with signatures expiring before
	// a specified timestamp.
	SignatureExpiresBefore *time.Time `location:"querystring" locationName:"signatureExpiresBefore" type:"timestamp"`

	// A status value with which to filter your results.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"SigningStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSigningJobsInput"}
	if s.JobInvoker != nil && len(*s.JobInvoker) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("JobInvoker", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsRevoked sets the IsRevoked field's value.
func (s *ListSigningJobsInput) SetIsRevoked(v bool) *ListSigningJobsInput {
	s.IsRevoked = &v
	return s
}

// SetJobInvoker sets the JobInvoker field's value.
func (s *ListSigningJobsInput) SetJobInvoker(v string) *ListSigningJobsInput {
	s.JobInvoker = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSigningJobsInput) SetMaxResults(v int64) *ListSigningJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningJobsInput) SetNextToken(v string) *ListSigningJobsInput {
	s.NextToken = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *ListSigningJobsInput) SetPlatformId(v string) *ListSigningJobsInput {
	s.PlatformId = &v
	return s
}

// SetRequestedBy sets the RequestedBy field's value.
func (s *ListSigningJobsInput) SetRequestedBy(v string) *ListSigningJobsInput {
	s.RequestedBy = &v
	return s
}

// SetSignatureExpiresAfter sets the SignatureExpiresAfter field's value.
func (s *ListSigningJobsInput) SetSignatureExpiresAfter(v time.Time) *ListSigningJobsInput {
	s.SignatureExpiresAfter = &v
	return s
}

// SetSignatureExpiresBefore sets the SignatureExpiresBefore field's value.
func (s *ListSigningJobsInput) SetSignatureExpiresBefore(v time.Time) *ListSigningJobsInput {
	s.SignatureExpiresBefore = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListSigningJobsInput) SetStatus(v string) *ListSigningJobsInput {
	s.Status = &v
	return s
}

type ListSigningJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of your signing jobs.
	Jobs []*SigningJob `locationName:"jobs" type:"list"`

	// String for specifying the next set of paginated results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListSigningJobsOutput) SetJobs(v []*SigningJob) *ListSigningJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningJobsOutput) SetNextToken(v string) *ListSigningJobsOutput {
	s.NextToken = &v
	return s
}

type ListSigningPlatformsInput struct {
	_ struct{} `type:"structure"`

	// The category type of a signing platform.
	Category *string `location:"querystring" locationName:"category" type:"string"`

	// The maximum number of results to be returned by this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Value for specifying the next set of paginated results to return. After you
	// receive a response with truncated results, use this parameter in a subsequent
	// request. Set it to the value of nextToken from the response that you just
	// received.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Any partner entities connected to a signing platform.
	Partner *string `location:"querystring" locationName:"partner" type:"string"`

	// The validation template that is used by the target signing platform.
	Target *string `location:"querystring" locationName:"target" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningPlatformsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningPlatformsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningPlatformsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSigningPlatformsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *ListSigningPlatformsInput) SetCategory(v string) *ListSigningPlatformsInput {
	s.Category = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSigningPlatformsInput) SetMaxResults(v int64) *ListSigningPlatformsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningPlatformsInput) SetNextToken(v string) *ListSigningPlatformsInput {
	s.NextToken = &v
	return s
}

// SetPartner sets the Partner field's value.
func (s *ListSigningPlatformsInput) SetPartner(v string) *ListSigningPlatformsInput {
	s.Partner = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ListSigningPlatformsInput) SetTarget(v string) *ListSigningPlatformsInput {
	s.Target = &v
	return s
}

type ListSigningPlatformsOutput struct {
	_ struct{} `type:"structure"`

	// Value for specifying the next set of paginated results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all platforms that match the request parameters.
	Platforms []*SigningPlatform `locationName:"platforms" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningPlatformsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningPlatformsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningPlatformsOutput) SetNextToken(v string) *ListSigningPlatformsOutput {
	s.NextToken = &v
	return s
}

// SetPlatforms sets the Platforms field's value.
func (s *ListSigningPlatformsOutput) SetPlatforms(v []*SigningPlatform) *ListSigningPlatformsOutput {
	s.Platforms = v
	return s
}

type ListSigningProfilesInput struct {
	_ struct{} `type:"structure"`

	// Designates whether to include profiles with the status of CANCELED.
	IncludeCanceled *bool `location:"querystring" locationName:"includeCanceled" type:"boolean"`

	// The maximum number of profiles to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Value for specifying the next set of paginated results to return. After you
	// receive a response with truncated results, use this parameter in a subsequent
	// request. Set it to the value of nextToken from the response that you just
	// received.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Filters results to return only signing jobs initiated for a specified signing
	// platform.
	PlatformId *string `location:"querystring" locationName:"platformId" type:"string"`

	// Filters results to return only signing jobs with statuses in the specified
	// list.
	Statuses []*string `location:"querystring" locationName:"statuses" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSigningProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeCanceled sets the IncludeCanceled field's value.
func (s *ListSigningProfilesInput) SetIncludeCanceled(v bool) *ListSigningProfilesInput {
	s.IncludeCanceled = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSigningProfilesInput) SetMaxResults(v int64) *ListSigningProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningProfilesInput) SetNextToken(v string) *ListSigningProfilesInput {
	s.NextToken = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *ListSigningProfilesInput) SetPlatformId(v string) *ListSigningProfilesInput {
	s.PlatformId = &v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *ListSigningProfilesInput) SetStatuses(v []*string) *ListSigningProfilesInput {
	s.Statuses = v
	return s
}

type ListSigningProfilesOutput struct {
	_ struct{} `type:"structure"`

	// Value for specifying the next set of paginated results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of profiles that are available in the AWS account. This includes profiles
	// with the status of CANCELED if the includeCanceled parameter is set to true.
	Profiles []*SigningProfile `locationName:"profiles" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSigningProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningProfilesOutput) SetNextToken(v string) *ListSigningProfilesOutput {
	s.NextToken = &v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *ListSigningProfilesOutput) SetProfiles(v []*SigningProfile) *ListSigningProfilesOutput {
	s.Profiles = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the signing profile.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the signing profile.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The signing profile was not found.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A cross-account permission for a signing profile.
type Permission struct {
	_ struct{} `type:"structure"`

	// An AWS Signer action permitted as part of cross-account permissions.
	Action *string `locationName:"action" type:"string"`

	// The AWS principal that has been granted a cross-account permission.
	Principal *string `locationName:"principal" type:"string"`

	// The signing profile version that a permission applies to.
	ProfileVersion *string `locationName:"profileVersion" min:"10" type:"string"`

	// A unique identifier for a cross-account permission statement.
	StatementId *string `locationName:"statementId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Permission) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Permission) SetAction(v string) *Permission {
	s.Action = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *Permission) SetPrincipal(v string) *Permission {
	s.Principal = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *Permission) SetProfileVersion(v string) *Permission {
	s.ProfileVersion = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *Permission) SetStatementId(v string) *Permission {
	s.StatementId = &v
	return s
}

type PutSigningProfileInput struct {
	_ struct{} `type:"structure"`

	// A subfield of platform. This specifies any different configuration options
	// that you want to apply to the chosen platform (such as a different hash-algorithm
	// or signing-algorithm).
	Overrides *SigningPlatformOverrides `locationName:"overrides" type:"structure"`

	// The ID of the signing platform to be created.
	//
	// PlatformId is a required field
	PlatformId *string `locationName:"platformId" type:"string" required:"true"`

	// The name of the signing profile to be created.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`

	// The default validity period override for any signature generated using this
	// signing profile. If unspecified, the default is 135 months.
	SignatureValidityPeriod *SignatureValidityPeriod `locationName:"signatureValidityPeriod" type:"structure"`

	// The AWS Certificate Manager certificate that will be used to sign code with
	// the new signing profile.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// Map of key-value pairs for signing. These can include any information that
	// you want to use during signing.
	SigningParameters map[string]*string `locationName:"signingParameters" type:"map"`

	// Tags to be associated with the signing profile that is being created.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSigningProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSigningProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSigningProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSigningProfileInput"}
	if s.PlatformId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformId"))
	}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.SigningMaterial != nil {
		if err := s.SigningMaterial.Validate(); err != nil {
			invalidParams.AddNested("SigningMaterial", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOverrides sets the Overrides field's value.
func (s *PutSigningProfileInput) SetOverrides(v *SigningPlatformOverrides) *PutSigningProfileInput {
	s.Overrides = v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *PutSigningProfileInput) SetPlatformId(v string) *PutSigningProfileInput {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *PutSigningProfileInput) SetProfileName(v string) *PutSigningProfileInput {
	s.ProfileName = &v
	return s
}

// SetSignatureValidityPeriod sets the SignatureValidityPeriod field's value.
func (s *PutSigningProfileInput) SetSignatureValidityPeriod(v *SignatureValidityPeriod) *PutSigningProfileInput {
	s.SignatureValidityPeriod = v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *PutSigningProfileInput) SetSigningMaterial(v *SigningMaterial) *PutSigningProfileInput {
	s.SigningMaterial = v
	return s
}

// SetSigningParameters sets the SigningParameters field's value.
func (s *PutSigningProfileInput) SetSigningParameters(v map[string]*string) *PutSigningProfileInput {
	s.SigningParameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutSigningProfileInput) SetTags(v map[string]*string) *PutSigningProfileInput {
	s.Tags = v
	return s
}

type PutSigningProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the signing profile created.
	Arn *string `locationName:"arn" type:"string"`

	// The version of the signing profile being created.
	ProfileVersion *string `locationName:"profileVersion" min:"10" type:"string"`

	// The signing profile ARN, including the profile version.
	ProfileVersionArn *string `locationName:"profileVersionArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSigningProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSigningProfileOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PutSigningProfileOutput) SetArn(v string) *PutSigningProfileOutput {
	s.Arn = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *PutSigningProfileOutput) SetProfileVersion(v string) *PutSigningProfileOutput {
	s.ProfileVersion = &v
	return s
}

// SetProfileVersionArn sets the ProfileVersionArn field's value.
func (s *PutSigningProfileOutput) SetProfileVersionArn(v string) *PutSigningProfileOutput {
	s.ProfileVersionArn = &v
	return s
}

type RemoveProfilePermissionInput struct {
	_ struct{} `type:"structure"`

	// A human-readable name for the signing profile with permissions to be removed.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`

	// An identifier for the current revision of the signing profile permissions.
	//
	// RevisionId is a required field
	RevisionId *string `location:"querystring" locationName:"revisionId" type:"string" required:"true"`

	// A unique identifier for the cross-account permissions statement.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"statementId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveProfilePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveProfilePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveProfilePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveProfilePermissionInput"}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileName sets the ProfileName field's value.
func (s *RemoveProfilePermissionInput) SetProfileName(v string) *RemoveProfilePermissionInput {
	s.ProfileName = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *RemoveProfilePermissionInput) SetRevisionId(v string) *RemoveProfilePermissionInput {
	s.RevisionId = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *RemoveProfilePermissionInput) SetStatementId(v string) *RemoveProfilePermissionInput {
	s.StatementId = &v
	return s
}

type RemoveProfilePermissionOutput struct {
	_ struct{} `type:"structure"`

	// An identifier for the current revision of the profile permissions.
	RevisionId *string `locationName:"revisionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveProfilePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveProfilePermissionOutput) GoString() string {
	return s.String()
}

// SetRevisionId sets the RevisionId field's value.
func (s *RemoveProfilePermissionOutput) SetRevisionId(v string) *RemoveProfilePermissionOutput {
	s.RevisionId = &v
	return s
}

// A specified resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RevokeSignatureInput struct {
	_ struct{} `type:"structure"`

	// ID of the signing job to be revoked.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// AWS account ID of the job owner.
	JobOwner *string `locationName:"jobOwner" min:"12" type:"string"`

	// The reason for revoking the signing job.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeSignatureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeSignatureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeSignatureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeSignatureInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.JobOwner != nil && len(*s.JobOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("JobOwner", 12))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}
	if s.Reason != nil && len(*s.Reason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Reason", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *RevokeSignatureInput) SetJobId(v string) *RevokeSignatureInput {
	s.JobId = &v
	return s
}

// SetJobOwner sets the JobOwner field's value.
func (s *RevokeSignatureInput) SetJobOwner(v string) *RevokeSignatureInput {
	s.JobOwner = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *RevokeSignatureInput) SetReason(v string) *RevokeSignatureInput {
	s.Reason = &v
	return s
}

type RevokeSignatureOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeSignatureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeSignatureOutput) GoString() string {
	return s.String()
}

type RevokeSigningProfileInput struct {
	_ struct{} `type:"structure"`

	// A timestamp for when revocation of a Signing Profile should become effective.
	// Signatures generated using the signing profile after this timestamp are not
	// trusted.
	//
	// EffectiveTime is a required field
	EffectiveTime *time.Time `locationName:"effectiveTime" type:"timestamp" required:"true"`

	// The name of the signing profile to be revoked.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`

	// The version of the signing profile to be revoked.
	//
	// ProfileVersion is a required field
	ProfileVersion *string `locationName:"profileVersion" min:"10" type:"string" required:"true"`

	// The reason for revoking a signing profile.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeSigningProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeSigningProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeSigningProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeSigningProfileInput"}
	if s.EffectiveTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EffectiveTime"))
	}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}
	if s.ProfileVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileVersion"))
	}
	if s.ProfileVersion != nil && len(*s.ProfileVersion) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileVersion", 10))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}
	if s.Reason != nil && len(*s.Reason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Reason", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *RevokeSigningProfileInput) SetEffectiveTime(v time.Time) *RevokeSigningProfileInput {
	s.EffectiveTime = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *RevokeSigningProfileInput) SetProfileName(v string) *RevokeSigningProfileInput {
	s.ProfileName = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *RevokeSigningProfileInput) SetProfileVersion(v string) *RevokeSigningProfileInput {
	s.ProfileVersion = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *RevokeSigningProfileInput) SetReason(v string) *RevokeSigningProfileInput {
	s.Reason = &v
	return s
}

type RevokeSigningProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeSigningProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeSigningProfileOutput) GoString() string {
	return s.String()
}

// The name and prefix of the S3 bucket where code signing saves your signed
// objects.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket.
	BucketName *string `locationName:"bucketName" type:"string"`

	// An Amazon S3 prefix that you can use to limit responses to those that begin
	// with the specified prefix.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *S3Destination) SetBucketName(v string) *S3Destination {
	s.BucketName = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Destination) SetPrefix(v string) *S3Destination {
	s.Prefix = &v
	return s
}

// The S3 bucket name and key where code signing saved your signed code image.
type S3SignedObject struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket.
	BucketName *string `locationName:"bucketName" type:"string"`

	// Key name that uniquely identifies a signed code image in your bucket.
	Key *string `locationName:"key" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3SignedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3SignedObject) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *S3SignedObject) SetBucketName(v string) *S3SignedObject {
	s.BucketName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3SignedObject) SetKey(v string) *S3SignedObject {
	s.Key = &v
	return s
}

// Information about the S3 bucket where you saved your unsigned code.
type S3Source struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// Key name of the bucket object that contains your unsigned code.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// Version of your source image in your version enabled S3 bucket.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Source"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Source) SetBucketName(v string) *S3Source {
	s.BucketName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Source) SetKey(v string) *S3Source {
	s.Key = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *S3Source) SetVersion(v string) *S3Source {
	s.Version = &v
	return s
}

// The client is making a request that exceeds service limits.
type ServiceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorServiceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ServiceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceLimitExceededException) Code() string {
	return "ServiceLimitExceededException"
}

// Message returns the exception's message.
func (s *ServiceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ServiceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The validity period for a signing job.
type SignatureValidityPeriod struct {
	_ struct{} `type:"structure"`

	// The time unit for signature validity.
	Type *string `locationName:"type" type:"string" enum:"ValidityType"`

	// The numerical value of the time unit for signature validity.
	Value *int64 `locationName:"value" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignatureValidityPeriod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignatureValidityPeriod) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *SignatureValidityPeriod) SetType(v string) *SignatureValidityPeriod {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SignatureValidityPeriod) SetValue(v int64) *SignatureValidityPeriod {
	s.Value = &v
	return s
}

// Points to an S3SignedObject object that contains information about your signed
// code image.
type SignedObject struct {
	_ struct{} `type:"structure"`

	// The S3SignedObject.
	S3 *S3SignedObject `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignedObject) GoString() string {
	return s.String()
}

// SetS3 sets the S3 field's value.
func (s *SignedObject) SetS3(v *S3SignedObject) *SignedObject {
	s.S3 = v
	return s
}

// The configuration of a code signing operation.
type SigningConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption algorithm options that are available for a code signing job.
	//
	// EncryptionAlgorithmOptions is a required field
	EncryptionAlgorithmOptions *EncryptionAlgorithmOptions `locationName:"encryptionAlgorithmOptions" type:"structure" required:"true"`

	// The hash algorithm options that are available for a code signing job.
	//
	// HashAlgorithmOptions is a required field
	HashAlgorithmOptions *HashAlgorithmOptions `locationName:"hashAlgorithmOptions" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningConfiguration) GoString() string {
	return s.String()
}

// SetEncryptionAlgorithmOptions sets the EncryptionAlgorithmOptions field's value.
func (s *SigningConfiguration) SetEncryptionAlgorithmOptions(v *EncryptionAlgorithmOptions) *SigningConfiguration {
	s.EncryptionAlgorithmOptions = v
	return s
}

// SetHashAlgorithmOptions sets the HashAlgorithmOptions field's value.
func (s *SigningConfiguration) SetHashAlgorithmOptions(v *HashAlgorithmOptions) *SigningConfiguration {
	s.HashAlgorithmOptions = v
	return s
}

// A signing configuration that overrides the default encryption or hash algorithm
// of a signing job.
type SigningConfigurationOverrides struct {
	_ struct{} `type:"structure"`

	// A specified override of the default encryption algorithm that is used in
	// a code signing job.
	EncryptionAlgorithm *string `locationName:"encryptionAlgorithm" type:"string" enum:"EncryptionAlgorithm"`

	// A specified override of the default hash algorithm that is used in a code
	// signing job.
	HashAlgorithm *string `locationName:"hashAlgorithm" type:"string" enum:"HashAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningConfigurationOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningConfigurationOverrides) GoString() string {
	return s.String()
}

// SetEncryptionAlgorithm sets the EncryptionAlgorithm field's value.
func (s *SigningConfigurationOverrides) SetEncryptionAlgorithm(v string) *SigningConfigurationOverrides {
	s.EncryptionAlgorithm = &v
	return s
}

// SetHashAlgorithm sets the HashAlgorithm field's value.
func (s *SigningConfigurationOverrides) SetHashAlgorithm(v string) *SigningConfigurationOverrides {
	s.HashAlgorithm = &v
	return s
}

// The image format of a code signing platform or profile.
type SigningImageFormat struct {
	_ struct{} `type:"structure"`

	// The default format of a code signing image.
	//
	// DefaultFormat is a required field
	DefaultFormat *string `locationName:"defaultFormat" type:"string" required:"true" enum:"ImageFormat"`

	// The supported formats of a code signing image.
	//
	// SupportedFormats is a required field
	SupportedFormats []*string `locationName:"supportedFormats" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningImageFormat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningImageFormat) GoString() string {
	return s.String()
}

// SetDefaultFormat sets the DefaultFormat field's value.
func (s *SigningImageFormat) SetDefaultFormat(v string) *SigningImageFormat {
	s.DefaultFormat = &v
	return s
}

// SetSupportedFormats sets the SupportedFormats field's value.
func (s *SigningImageFormat) SetSupportedFormats(v []*string) *SigningImageFormat {
	s.SupportedFormats = v
	return s
}

// Contains information about a signing job.
type SigningJob struct {
	_ struct{} `type:"structure"`

	// The date and time that the signing job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Indicates whether the signing job is revoked.
	IsRevoked *bool `locationName:"isRevoked" type:"boolean"`

	// The ID of the signing job.
	JobId *string `locationName:"jobId" type:"string"`

	// The AWS account ID of the job invoker.
	JobInvoker *string `locationName:"jobInvoker" min:"12" type:"string"`

	// The AWS account ID of the job owner.
	JobOwner *string `locationName:"jobOwner" min:"12" type:"string"`

	// The name of a signing platform.
	PlatformDisplayName *string `locationName:"platformDisplayName" type:"string"`

	// The unique identifier for a signing platform.
	PlatformId *string `locationName:"platformId" type:"string"`

	// The name of the signing profile that created a signing job.
	ProfileName *string `locationName:"profileName" min:"2" type:"string"`

	// The version of the signing profile that created a signing job.
	ProfileVersion *string `locationName:"profileVersion" min:"10" type:"string"`

	// The time when the signature of a signing job expires.
	SignatureExpiresAt *time.Time `locationName:"signatureExpiresAt" type:"timestamp"`

	// A SignedObject structure that contains information about a signing job's
	// signed code image.
	SignedObject *SignedObject `locationName:"signedObject" type:"structure"`

	// A SigningMaterial object that contains the Amazon Resource Name (ARN) of
	// the certificate used for the signing job.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// A Source that contains information about a signing job's code image source.
	Source *Source `locationName:"source" type:"structure"`

	// The status of the signing job.
	Status *string `locationName:"status" type:"string" enum:"SigningStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningJob) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SigningJob) SetCreatedAt(v time.Time) *SigningJob {
	s.CreatedAt = &v
	return s
}

// SetIsRevoked sets the IsRevoked field's value.
func (s *SigningJob) SetIsRevoked(v bool) *SigningJob {
	s.IsRevoked = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *SigningJob) SetJobId(v string) *SigningJob {
	s.JobId = &v
	return s
}

// SetJobInvoker sets the JobInvoker field's value.
func (s *SigningJob) SetJobInvoker(v string) *SigningJob {
	s.JobInvoker = &v
	return s
}

// SetJobOwner sets the JobOwner field's value.
func (s *SigningJob) SetJobOwner(v string) *SigningJob {
	s.JobOwner = &v
	return s
}

// SetPlatformDisplayName sets the PlatformDisplayName field's value.
func (s *SigningJob) SetPlatformDisplayName(v string) *SigningJob {
	s.PlatformDisplayName = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *SigningJob) SetPlatformId(v string) *SigningJob {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *SigningJob) SetProfileName(v string) *SigningJob {
	s.ProfileName = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *SigningJob) SetProfileVersion(v string) *SigningJob {
	s.ProfileVersion = &v
	return s
}

// SetSignatureExpiresAt sets the SignatureExpiresAt field's value.
func (s *SigningJob) SetSignatureExpiresAt(v time.Time) *SigningJob {
	s.SignatureExpiresAt = &v
	return s
}

// SetSignedObject sets the SignedObject field's value.
func (s *SigningJob) SetSignedObject(v *SignedObject) *SigningJob {
	s.SignedObject = v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *SigningJob) SetSigningMaterial(v *SigningMaterial) *SigningJob {
	s.SigningMaterial = v
	return s
}

// SetSource sets the Source field's value.
func (s *SigningJob) SetSource(v *Source) *SigningJob {
	s.Source = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SigningJob) SetStatus(v string) *SigningJob {
	s.Status = &v
	return s
}

// Revocation information for a signing job.
type SigningJobRevocationRecord struct {
	_ struct{} `type:"structure"`

	// A caller-supplied reason for revocation.
	Reason *string `locationName:"reason" type:"string"`

	// The time of revocation.
	RevokedAt *time.Time `locationName:"revokedAt" type:"timestamp"`

	// The identity of the revoker.
	RevokedBy *string `locationName:"revokedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningJobRevocationRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningJobRevocationRecord) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *SigningJobRevocationRecord) SetReason(v string) *SigningJobRevocationRecord {
	s.Reason = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *SigningJobRevocationRecord) SetRevokedAt(v time.Time) *SigningJobRevocationRecord {
	s.RevokedAt = &v
	return s
}

// SetRevokedBy sets the RevokedBy field's value.
func (s *SigningJobRevocationRecord) SetRevokedBy(v string) *SigningJobRevocationRecord {
	s.RevokedBy = &v
	return s
}

// The ACM certificate that is used to sign your code.
type SigningMaterial struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificates that is used to sign your
	// code.
	//
	// CertificateArn is a required field
	CertificateArn *string `locationName:"certificateArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningMaterial) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningMaterial) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SigningMaterial) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SigningMaterial"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *SigningMaterial) SetCertificateArn(v string) *SigningMaterial {
	s.CertificateArn = &v
	return s
}

// Contains information about the signing configurations and parameters that
// are used to perform a code signing job.
type SigningPlatform struct {
	_ struct{} `type:"structure"`

	// The category of a code signing platform.
	Category *string `locationName:"category" type:"string" enum:"Category"`

	// The display name of a code signing platform.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The maximum size (in MB) of code that can be signed by a code signing platform.
	MaxSizeInMB *int64 `locationName:"maxSizeInMB" type:"integer"`

	// Any partner entities linked to a code signing platform.
	Partner *string `locationName:"partner" type:"string"`

	// The ID of a code signing; platform.
	PlatformId *string `locationName:"platformId" type:"string"`

	// Indicates whether revocation is supported for the platform.
	RevocationSupported *bool `locationName:"revocationSupported" type:"boolean"`

	// The configuration of a code signing platform. This includes the designated
	// hash algorithm and encryption algorithm of a signing platform.
	SigningConfiguration *SigningConfiguration `locationName:"signingConfiguration" type:"structure"`

	// The image format of a code signing platform or profile.
	SigningImageFormat *SigningImageFormat `locationName:"signingImageFormat" type:"structure"`

	// The types of targets that can be signed by a code signing platform.
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningPlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningPlatform) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *SigningPlatform) SetCategory(v string) *SigningPlatform {
	s.Category = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *SigningPlatform) SetDisplayName(v string) *SigningPlatform {
	s.DisplayName = &v
	return s
}

// SetMaxSizeInMB sets the MaxSizeInMB field's value.
func (s *SigningPlatform) SetMaxSizeInMB(v int64) *SigningPlatform {
	s.MaxSizeInMB = &v
	return s
}

// SetPartner sets the Partner field's value.
func (s *SigningPlatform) SetPartner(v string) *SigningPlatform {
	s.Partner = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *SigningPlatform) SetPlatformId(v string) *SigningPlatform {
	s.PlatformId = &v
	return s
}

// SetRevocationSupported sets the RevocationSupported field's value.
func (s *SigningPlatform) SetRevocationSupported(v bool) *SigningPlatform {
	s.RevocationSupported = &v
	return s
}

// SetSigningConfiguration sets the SigningConfiguration field's value.
func (s *SigningPlatform) SetSigningConfiguration(v *SigningConfiguration) *SigningPlatform {
	s.SigningConfiguration = v
	return s
}

// SetSigningImageFormat sets the SigningImageFormat field's value.
func (s *SigningPlatform) SetSigningImageFormat(v *SigningImageFormat) *SigningPlatform {
	s.SigningImageFormat = v
	return s
}

// SetTarget sets the Target field's value.
func (s *SigningPlatform) SetTarget(v string) *SigningPlatform {
	s.Target = &v
	return s
}

// Any overrides that are applied to the signing configuration of a code signing
// platform.
type SigningPlatformOverrides struct {
	_ struct{} `type:"structure"`

	// A signing configuration that overrides the default encryption or hash algorithm
	// of a signing job.
	SigningConfiguration *SigningConfigurationOverrides `locationName:"signingConfiguration" type:"structure"`

	// A signed image is a JSON object. When overriding the default signing platform
	// configuration, a customer can select either of two signing formats, JSONEmbedded
	// or JSONDetached. (A third format value, JSON, is reserved for future use.)
	// With JSONEmbedded, the signing image has the payload embedded in it. With
	// JSONDetached, the payload is not be embedded in the signing image.
	SigningImageFormat *string `locationName:"signingImageFormat" type:"string" enum:"ImageFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningPlatformOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningPlatformOverrides) GoString() string {
	return s.String()
}

// SetSigningConfiguration sets the SigningConfiguration field's value.
func (s *SigningPlatformOverrides) SetSigningConfiguration(v *SigningConfigurationOverrides) *SigningPlatformOverrides {
	s.SigningConfiguration = v
	return s
}

// SetSigningImageFormat sets the SigningImageFormat field's value.
func (s *SigningPlatformOverrides) SetSigningImageFormat(v string) *SigningPlatformOverrides {
	s.SigningImageFormat = &v
	return s
}

// Contains information about the ACM certificates and code signing configuration
// parameters that can be used by a given code signing user.
type SigningProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the signing profile.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the signing platform.
	PlatformDisplayName *string `locationName:"platformDisplayName" type:"string"`

	// The ID of a platform that is available for use by a signing profile.
	PlatformId *string `locationName:"platformId" type:"string"`

	// The name of the signing profile.
	ProfileName *string `locationName:"profileName" min:"2" type:"string"`

	// The version of a signing profile.
	ProfileVersion *string `locationName:"profileVersion" min:"10" type:"string"`

	// The ARN of a signing profile, including the profile version.
	ProfileVersionArn *string `locationName:"profileVersionArn" min:"20" type:"string"`

	// The validity period for a signing job created using this signing profile.
	SignatureValidityPeriod *SignatureValidityPeriod `locationName:"signatureValidityPeriod" type:"structure"`

	// The ACM certificate that is available for use by a signing profile.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// The parameters that are available for use by a code signing user.
	SigningParameters map[string]*string `locationName:"signingParameters" type:"map"`

	// The status of a code signing profile.
	Status *string `locationName:"status" type:"string" enum:"SigningProfileStatus"`

	// A list of tags associated with the signing profile.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SigningProfile) SetArn(v string) *SigningProfile {
	s.Arn = &v
	return s
}

// SetPlatformDisplayName sets the PlatformDisplayName field's value.
func (s *SigningProfile) SetPlatformDisplayName(v string) *SigningProfile {
	s.PlatformDisplayName = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *SigningProfile) SetPlatformId(v string) *SigningProfile {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *SigningProfile) SetProfileName(v string) *SigningProfile {
	s.ProfileName = &v
	return s
}

// SetProfileVersion sets the ProfileVersion field's value.
func (s *SigningProfile) SetProfileVersion(v string) *SigningProfile {
	s.ProfileVersion = &v
	return s
}

// SetProfileVersionArn sets the ProfileVersionArn field's value.
func (s *SigningProfile) SetProfileVersionArn(v string) *SigningProfile {
	s.ProfileVersionArn = &v
	return s
}

// SetSignatureValidityPeriod sets the SignatureValidityPeriod field's value.
func (s *SigningProfile) SetSignatureValidityPeriod(v *SignatureValidityPeriod) *SigningProfile {
	s.SignatureValidityPeriod = v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *SigningProfile) SetSigningMaterial(v *SigningMaterial) *SigningProfile {
	s.SigningMaterial = v
	return s
}

// SetSigningParameters sets the SigningParameters field's value.
func (s *SigningProfile) SetSigningParameters(v map[string]*string) *SigningProfile {
	s.SigningParameters = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SigningProfile) SetStatus(v string) *SigningProfile {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SigningProfile) SetTags(v map[string]*string) *SigningProfile {
	s.Tags = v
	return s
}

// Revocation information for a signing profile.
type SigningProfileRevocationRecord struct {
	_ struct{} `type:"structure"`

	// The time when revocation becomes effective.
	RevocationEffectiveFrom *time.Time `locationName:"revocationEffectiveFrom" type:"timestamp"`

	// The time when the signing profile was revoked.
	RevokedAt *time.Time `locationName:"revokedAt" type:"timestamp"`

	// The identity of the revoker.
	RevokedBy *string `locationName:"revokedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningProfileRevocationRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SigningProfileRevocationRecord) GoString() string {
	return s.String()
}

// SetRevocationEffectiveFrom sets the RevocationEffectiveFrom field's value.
func (s *SigningProfileRevocationRecord) SetRevocationEffectiveFrom(v time.Time) *SigningProfileRevocationRecord {
	s.RevocationEffectiveFrom = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *SigningProfileRevocationRecord) SetRevokedAt(v time.Time) *SigningProfileRevocationRecord {
	s.RevokedAt = &v
	return s
}

// SetRevokedBy sets the RevokedBy field's value.
func (s *SigningProfileRevocationRecord) SetRevokedBy(v string) *SigningProfileRevocationRecord {
	s.RevokedBy = &v
	return s
}

// An S3Source object that contains information about the S3 bucket where you
// saved your unsigned code.
type Source struct {
	_ struct{} `type:"structure"`

	// The S3Source object.
	S3 *S3Source `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Source"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *Source) SetS3(v *S3Source) *Source {
	s.S3 = v
	return s
}

type StartSigningJobInput struct {
	_ struct{} `type:"structure"`

	// String that identifies the signing request. All calls after the first that
	// use this token return the same response as the first call.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The S3 bucket in which to save your signed object. The destination contains
	// the name of your bucket and an optional prefix.
	//
	// Destination is a required field
	Destination *Destination `locationName:"destination" type:"structure" required:"true"`

	// The name of the signing profile.
	//
	// ProfileName is a required field
	ProfileName *string `locationName:"profileName" min:"2" type:"string" required:"true"`

	// The AWS account ID of the signing profile owner.
	ProfileOwner *string `locationName:"profileOwner" min:"12" type:"string"`

	// The S3 bucket that contains the object to sign or a BLOB that contains your
	// raw code.
	//
	// Source is a required field
	Source *Source `locationName:"source" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSigningJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSigningJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSigningJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSigningJobInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}
	if s.ProfileOwner != nil && len(*s.ProfileOwner) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileOwner", 12))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSigningJobInput) SetClientRequestToken(v string) *StartSigningJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *StartSigningJobInput) SetDestination(v *Destination) *StartSigningJobInput {
	s.Destination = v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *StartSigningJobInput) SetProfileName(v string) *StartSigningJobInput {
	s.ProfileName = &v
	return s
}

// SetProfileOwner sets the ProfileOwner field's value.
func (s *StartSigningJobInput) SetProfileOwner(v string) *StartSigningJobInput {
	s.ProfileOwner = &v
	return s
}

// SetSource sets the Source field's value.
func (s *StartSigningJobInput) SetSource(v *Source) *StartSigningJobInput {
	s.Source = v
	return s
}

type StartSigningJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID of your signing job.
	JobId *string `locationName:"jobId" type:"string"`

	// The AWS account ID of the signing job owner.
	JobOwner *string `locationName:"jobOwner" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSigningJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSigningJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartSigningJobOutput) SetJobId(v string) *StartSigningJobOutput {
	s.JobId = &v
	return s
}

// SetJobOwner sets the JobOwner field's value.
func (s *StartSigningJobOutput) SetJobOwner(v string) *StartSigningJobOutput {
	s.JobOwner = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the signing profile.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// One or more tags to be associated with the signing profile.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
//
// Instead of this error, TooManyRequestsException should be used.
//
// Deprecated: Instead of this error, TooManyRequestsException should be used.
type ThrottlingException struct {
	_            struct{}                  `deprecated:"true" type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The allowed number of job-signing requests has been exceeded.
//
// This error supersedes the error ThrottlingException.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the signing profile.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of tag keys to be removed from the signing profile.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// You signing certificate could not be validated.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// CategoryAwsioT is a Category enum value
	CategoryAwsioT = "AWSIoT"
)

// Category_Values returns all elements of the Category enum
func Category_Values() []string {
	return []string{
		CategoryAwsioT,
	}
}

const (
	// EncryptionAlgorithmRsa is a EncryptionAlgorithm enum value
	EncryptionAlgorithmRsa = "RSA"

	// EncryptionAlgorithmEcdsa is a EncryptionAlgorithm enum value
	EncryptionAlgorithmEcdsa = "ECDSA"
)

// EncryptionAlgorithm_Values returns all elements of the EncryptionAlgorithm enum
func EncryptionAlgorithm_Values() []string {
	return []string{
		EncryptionAlgorithmRsa,
		EncryptionAlgorithmEcdsa,
	}
}

const (
	// HashAlgorithmSha1 is a HashAlgorithm enum value
	HashAlgorithmSha1 = "SHA1"

	// HashAlgorithmSha256 is a HashAlgorithm enum value
	HashAlgorithmSha256 = "SHA256"
)

// HashAlgorithm_Values returns all elements of the HashAlgorithm enum
func HashAlgorithm_Values() []string {
	return []string{
		HashAlgorithmSha1,
		HashAlgorithmSha256,
	}
}

const (
	// ImageFormatJson is a ImageFormat enum value
	ImageFormatJson = "JSON"

	// ImageFormatJsonembedded is a ImageFormat enum value
	ImageFormatJsonembedded = "JSONEmbedded"

	// ImageFormatJsondetached is a ImageFormat enum value
	ImageFormatJsondetached = "JSONDetached"
)

// ImageFormat_Values returns all elements of the ImageFormat enum
func ImageFormat_Values() []string {
	return []string{
		ImageFormatJson,
		ImageFormatJsonembedded,
		ImageFormatJsondetached,
	}
}

const (
	// SigningProfileStatusActive is a SigningProfileStatus enum value
	SigningProfileStatusActive = "Active"

	// SigningProfileStatusCanceled is a SigningProfileStatus enum value
	SigningProfileStatusCanceled = "Canceled"

	// SigningProfileStatusRevoked is a SigningProfileStatus enum value
	SigningProfileStatusRevoked = "Revoked"
)

// SigningProfileStatus_Values returns all elements of the SigningProfileStatus enum
func SigningProfileStatus_Values() []string {
	return []string{
		SigningProfileStatusActive,
		SigningProfileStatusCanceled,
		SigningProfileStatusRevoked,
	}
}

const (
	// SigningStatusInProgress is a SigningStatus enum value
	SigningStatusInProgress = "InProgress"

	// SigningStatusFailed is a SigningStatus enum value
	SigningStatusFailed = "Failed"

	// SigningStatusSucceeded is a SigningStatus enum value
	SigningStatusSucceeded = "Succeeded"
)

// SigningStatus_Values returns all elements of the SigningStatus enum
func SigningStatus_Values() []string {
	return []string{
		SigningStatusInProgress,
		SigningStatusFailed,
		SigningStatusSucceeded,
	}
}

const (
	// ValidityTypeDays is a ValidityType enum value
	ValidityTypeDays = "DAYS"

	// ValidityTypeMonths is a ValidityType enum value
	ValidityTypeMonths = "MONTHS"

	// ValidityTypeYears is a ValidityType enum value
	ValidityTypeYears = "YEARS"
)

// ValidityType_Values returns all elements of the ValidityType enum
func ValidityType_Values() []string {
	return []string{
		ValidityTypeDays,
		ValidityTypeMonths,
		ValidityTypeYears,
	}
}
