// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package bsky

import (
	"fmt"
	"io"
	"math"
	"sort"

	atproto "github.com/bluesky-social/indigo/api/atproto"
	util "github.com/bluesky-social/indigo/lex/util"
	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

func (t *FeedPost) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 10

	if t.Embed == nil {
		fieldCount--
	}

	if t.Entities == nil {
		fieldCount--
	}

	if t.Facets == nil {
		fieldCount--
	}

	if t.Labels == nil {
		fieldCount--
	}

	if t.Langs == nil {
		fieldCount--
	}

	if t.Reply == nil {
		fieldCount--
	}

	if t.Tags == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Tags ([]string) (slice)
	if t.Tags != nil {

		if len("tags") > 1000000 {
			return xerrors.Errorf("Value in field \"tags\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("tags"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("tags")); err != nil {
			return err
		}

		if len(t.Tags) > 8192 {
			return xerrors.Errorf("Slice value in field t.Tags was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Tags))); err != nil {
			return err
		}
		for _, v := range t.Tags {
			if len(v) > 1000000 {
				return xerrors.Errorf("Value in field v was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(v))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(v)); err != nil {
				return err
			}

		}
	}

	// t.Text (string) (string)
	if len("text") > 1000000 {
		return xerrors.Errorf("Value in field \"text\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("text"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("text")); err != nil {
		return err
	}

	if len(t.Text) > 1000000 {
		return xerrors.Errorf("Value in field t.Text was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Text))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Text)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.post"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.post")); err != nil {
		return err
	}

	// t.Embed (bsky.FeedPost_Embed) (struct)
	if t.Embed != nil {

		if len("embed") > 1000000 {
			return xerrors.Errorf("Value in field \"embed\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("embed"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("embed")); err != nil {
			return err
		}

		if err := t.Embed.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Langs ([]string) (slice)
	if t.Langs != nil {

		if len("langs") > 1000000 {
			return xerrors.Errorf("Value in field \"langs\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("langs"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("langs")); err != nil {
			return err
		}

		if len(t.Langs) > 8192 {
			return xerrors.Errorf("Slice value in field t.Langs was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Langs))); err != nil {
			return err
		}
		for _, v := range t.Langs {
			if len(v) > 1000000 {
				return xerrors.Errorf("Value in field v was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(v))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(v)); err != nil {
				return err
			}

		}
	}

	// t.Reply (bsky.FeedPost_ReplyRef) (struct)
	if t.Reply != nil {

		if len("reply") > 1000000 {
			return xerrors.Errorf("Value in field \"reply\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("reply"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("reply")); err != nil {
			return err
		}

		if err := t.Reply.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Facets ([]*bsky.RichtextFacet) (slice)
	if t.Facets != nil {

		if len("facets") > 1000000 {
			return xerrors.Errorf("Value in field \"facets\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("facets"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("facets")); err != nil {
			return err
		}

		if len(t.Facets) > 8192 {
			return xerrors.Errorf("Slice value in field t.Facets was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Facets))); err != nil {
			return err
		}
		for _, v := range t.Facets {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.Labels (bsky.FeedPost_Labels) (struct)
	if t.Labels != nil {

		if len("labels") > 1000000 {
			return xerrors.Errorf("Value in field \"labels\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("labels"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("labels")); err != nil {
			return err
		}

		if err := t.Labels.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Entities ([]*bsky.FeedPost_Entity) (slice)
	if t.Entities != nil {

		if len("entities") > 1000000 {
			return xerrors.Errorf("Value in field \"entities\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("entities"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("entities")); err != nil {
			return err
		}

		if len(t.Entities) > 8192 {
			return xerrors.Errorf("Slice value in field t.Entities was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Entities))); err != nil {
			return err
		}
		for _, v := range t.Entities {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}
	return nil
}

func (t *FeedPost) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedPost{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedPost: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 9)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Tags ([]string) (slice)
		case "tags":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Tags: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Tags = make([]string, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{
						sval, err := cbg.ReadStringWithMax(cr, 1000000)
						if err != nil {
							return err
						}

						t.Tags[i] = string(sval)
					}

				}
			}
			// t.Text (string) (string)
		case "text":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Text = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Embed (bsky.FeedPost_Embed) (struct)
		case "embed":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Embed = new(FeedPost_Embed)
					if err := t.Embed.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Embed pointer: %w", err)
					}
				}

			}
			// t.Langs ([]string) (slice)
		case "langs":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Langs: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Langs = make([]string, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{
						sval, err := cbg.ReadStringWithMax(cr, 1000000)
						if err != nil {
							return err
						}

						t.Langs[i] = string(sval)
					}

				}
			}
			// t.Reply (bsky.FeedPost_ReplyRef) (struct)
		case "reply":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Reply = new(FeedPost_ReplyRef)
					if err := t.Reply.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Reply pointer: %w", err)
					}
				}

			}
			// t.Facets ([]*bsky.RichtextFacet) (slice)
		case "facets":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Facets: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Facets = make([]*RichtextFacet, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Facets[i] = new(RichtextFacet)
							if err := t.Facets[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Facets[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.Labels (bsky.FeedPost_Labels) (struct)
		case "labels":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Labels = new(FeedPost_Labels)
					if err := t.Labels.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Labels pointer: %w", err)
					}
				}

			}
			// t.Entities ([]*bsky.FeedPost_Entity) (slice)
		case "entities":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Entities: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Entities = make([]*FeedPost_Entity, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Entities[i] = new(FeedPost_Entity)
							if err := t.Entities[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Entities[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedRepost) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 4

	if t.Via == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Via (atproto.RepoStrongRef) (struct)
	if t.Via != nil {

		if len("via") > 1000000 {
			return xerrors.Errorf("Value in field \"via\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("via"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("via")); err != nil {
			return err
		}

		if err := t.Via.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.repost"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.repost")); err != nil {
		return err
	}

	// t.Subject (atproto.RepoStrongRef) (struct)
	if len("subject") > 1000000 {
		return xerrors.Errorf("Value in field \"subject\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subject"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("subject")); err != nil {
		return err
	}

	if err := t.Subject.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}
	return nil
}

func (t *FeedRepost) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedRepost{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedRepost: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 9)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Via (atproto.RepoStrongRef) (struct)
		case "via":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Via = new(atproto.RepoStrongRef)
					if err := t.Via.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Via pointer: %w", err)
					}
				}

			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Subject (atproto.RepoStrongRef) (struct)
		case "subject":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Subject = new(atproto.RepoStrongRef)
					if err := t.Subject.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Subject pointer: %w", err)
					}
				}

			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedPost_Entity) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.Type (string) (string)
	if len("type") > 1000000 {
		return xerrors.Errorf("Value in field \"type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("type")); err != nil {
		return err
	}

	if len(t.Type) > 1000000 {
		return xerrors.Errorf("Value in field t.Type was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Type))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Type)); err != nil {
		return err
	}

	// t.Index (bsky.FeedPost_TextSlice) (struct)
	if len("index") > 1000000 {
		return xerrors.Errorf("Value in field \"index\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("index"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("index")); err != nil {
		return err
	}

	if err := t.Index.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Value (string) (string)
	if len("value") > 1000000 {
		return xerrors.Errorf("Value in field \"value\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("value"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("value")); err != nil {
		return err
	}

	if len(t.Value) > 1000000 {
		return xerrors.Errorf("Value in field t.Value was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Value))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Value)); err != nil {
		return err
	}
	return nil
}

func (t *FeedPost_Entity) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedPost_Entity{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedPost_Entity: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Type (string) (string)
		case "type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Type = string(sval)
			}
			// t.Index (bsky.FeedPost_TextSlice) (struct)
		case "index":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Index = new(FeedPost_TextSlice)
					if err := t.Index.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Index pointer: %w", err)
					}
				}

			}
			// t.Value (string) (string)
		case "value":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Value = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedPost_ReplyRef) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Root (atproto.RepoStrongRef) (struct)
	if len("root") > 1000000 {
		return xerrors.Errorf("Value in field \"root\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("root"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("root")); err != nil {
		return err
	}

	if err := t.Root.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Parent (atproto.RepoStrongRef) (struct)
	if len("parent") > 1000000 {
		return xerrors.Errorf("Value in field \"parent\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("parent"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("parent")); err != nil {
		return err
	}

	if err := t.Parent.MarshalCBOR(cw); err != nil {
		return err
	}
	return nil
}

func (t *FeedPost_ReplyRef) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedPost_ReplyRef{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedPost_ReplyRef: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 6)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Root (atproto.RepoStrongRef) (struct)
		case "root":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Root = new(atproto.RepoStrongRef)
					if err := t.Root.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Root pointer: %w", err)
					}
				}

			}
			// t.Parent (atproto.RepoStrongRef) (struct)
		case "parent":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Parent = new(atproto.RepoStrongRef)
					if err := t.Parent.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Parent pointer: %w", err)
					}
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedPost_TextSlice) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.End (int64) (int64)
	if len("end") > 1000000 {
		return xerrors.Errorf("Value in field \"end\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("end"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("end")); err != nil {
		return err
	}

	if t.End >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.End)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.End-1)); err != nil {
			return err
		}
	}

	// t.Start (int64) (int64)
	if len("start") > 1000000 {
		return xerrors.Errorf("Value in field \"start\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("start"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("start")); err != nil {
		return err
	}

	if t.Start >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Start)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Start-1)); err != nil {
			return err
		}
	}

	return nil
}

func (t *FeedPost_TextSlice) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedPost_TextSlice{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedPost_TextSlice: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.End (int64) (int64)
		case "end":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.End = int64(extraI)
			}
			// t.Start (int64) (int64)
		case "start":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Start = int64(extraI)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedImages) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.embed.images"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.embed.images")); err != nil {
		return err
	}

	// t.Images ([]*bsky.EmbedImages_Image) (slice)
	if len("images") > 1000000 {
		return xerrors.Errorf("Value in field \"images\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("images"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("images")); err != nil {
		return err
	}

	if len(t.Images) > 8192 {
		return xerrors.Errorf("Slice value in field t.Images was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Images))); err != nil {
		return err
	}
	for _, v := range t.Images {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}
	return nil
}

func (t *EmbedImages) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedImages{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedImages: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 6)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Images ([]*bsky.EmbedImages_Image) (slice)
		case "images":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Images: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Images = make([]*EmbedImages_Image, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Images[i] = new(EmbedImages_Image)
							if err := t.Images[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Images[i] pointer: %w", err)
							}
						}

					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedExternal) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.embed.external"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.embed.external")); err != nil {
		return err
	}

	// t.External (bsky.EmbedExternal_External) (struct)
	if len("external") > 1000000 {
		return xerrors.Errorf("Value in field \"external\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("external"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("external")); err != nil {
		return err
	}

	if err := t.External.MarshalCBOR(cw); err != nil {
		return err
	}
	return nil
}

func (t *EmbedExternal) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedExternal{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedExternal: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 8)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.External (bsky.EmbedExternal_External) (struct)
		case "external":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.External = new(EmbedExternal_External)
					if err := t.External.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.External pointer: %w", err)
					}
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedExternal_External) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 4

	if t.Thumb == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Uri (string) (string)
	if len("uri") > 1000000 {
		return xerrors.Errorf("Value in field \"uri\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("uri"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("uri")); err != nil {
		return err
	}

	if len(t.Uri) > 1000000 {
		return xerrors.Errorf("Value in field t.Uri was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Uri))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Uri)); err != nil {
		return err
	}

	// t.Thumb (util.LexBlob) (struct)
	if t.Thumb != nil {

		if len("thumb") > 1000000 {
			return xerrors.Errorf("Value in field \"thumb\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("thumb"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("thumb")); err != nil {
			return err
		}

		if err := t.Thumb.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Title (string) (string)
	if len("title") > 1000000 {
		return xerrors.Errorf("Value in field \"title\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("title"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("title")); err != nil {
		return err
	}

	if len(t.Title) > 1000000 {
		return xerrors.Errorf("Value in field t.Title was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Title))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Title)); err != nil {
		return err
	}

	// t.Description (string) (string)
	if len("description") > 1000000 {
		return xerrors.Errorf("Value in field \"description\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("description"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("description")); err != nil {
		return err
	}

	if len(t.Description) > 1000000 {
		return xerrors.Errorf("Value in field t.Description was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Description))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Description)); err != nil {
		return err
	}
	return nil
}

func (t *EmbedExternal_External) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedExternal_External{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedExternal_External: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 11)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Uri (string) (string)
		case "uri":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Uri = string(sval)
			}
			// t.Thumb (util.LexBlob) (struct)
		case "thumb":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Thumb = new(util.LexBlob)
					if err := t.Thumb.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Thumb pointer: %w", err)
					}
				}

			}
			// t.Title (string) (string)
		case "title":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Title = string(sval)
			}
			// t.Description (string) (string)
		case "description":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Description = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedImages_Image) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 3

	if t.AspectRatio == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Alt (string) (string)
	if len("alt") > 1000000 {
		return xerrors.Errorf("Value in field \"alt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("alt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("alt")); err != nil {
		return err
	}

	if len(t.Alt) > 1000000 {
		return xerrors.Errorf("Value in field t.Alt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Alt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Alt)); err != nil {
		return err
	}

	// t.Image (util.LexBlob) (struct)
	if len("image") > 1000000 {
		return xerrors.Errorf("Value in field \"image\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("image"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("image")); err != nil {
		return err
	}

	if err := t.Image.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.AspectRatio (bsky.EmbedDefs_AspectRatio) (struct)
	if t.AspectRatio != nil {

		if len("aspectRatio") > 1000000 {
			return xerrors.Errorf("Value in field \"aspectRatio\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("aspectRatio"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("aspectRatio")); err != nil {
			return err
		}

		if err := t.AspectRatio.MarshalCBOR(cw); err != nil {
			return err
		}
	}
	return nil
}

func (t *EmbedImages_Image) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedImages_Image{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedImages_Image: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 11)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Alt (string) (string)
		case "alt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Alt = string(sval)
			}
			// t.Image (util.LexBlob) (struct)
		case "image":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Image = new(util.LexBlob)
					if err := t.Image.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Image pointer: %w", err)
					}
				}

			}
			// t.AspectRatio (bsky.EmbedDefs_AspectRatio) (struct)
		case "aspectRatio":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.AspectRatio = new(EmbedDefs_AspectRatio)
					if err := t.AspectRatio.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.AspectRatio pointer: %w", err)
					}
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *GraphFollow) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.graph.follow"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.graph.follow")); err != nil {
		return err
	}

	// t.Subject (string) (string)
	if len("subject") > 1000000 {
		return xerrors.Errorf("Value in field \"subject\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subject"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("subject")); err != nil {
		return err
	}

	if len(t.Subject) > 1000000 {
		return xerrors.Errorf("Value in field t.Subject was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Subject))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Subject)); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}
	return nil
}

func (t *GraphFollow) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GraphFollow{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GraphFollow: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 9)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Subject (string) (string)
		case "subject":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Subject = string(sval)
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *ActorProfile) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 9

	if t.Avatar == nil {
		fieldCount--
	}

	if t.Banner == nil {
		fieldCount--
	}

	if t.CreatedAt == nil {
		fieldCount--
	}

	if t.Description == nil {
		fieldCount--
	}

	if t.DisplayName == nil {
		fieldCount--
	}

	if t.JoinedViaStarterPack == nil {
		fieldCount--
	}

	if t.Labels == nil {
		fieldCount--
	}

	if t.PinnedPost == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.actor.profile"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.actor.profile")); err != nil {
		return err
	}

	// t.Avatar (util.LexBlob) (struct)
	if t.Avatar != nil {

		if len("avatar") > 1000000 {
			return xerrors.Errorf("Value in field \"avatar\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("avatar"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("avatar")); err != nil {
			return err
		}

		if err := t.Avatar.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Banner (util.LexBlob) (struct)
	if t.Banner != nil {

		if len("banner") > 1000000 {
			return xerrors.Errorf("Value in field \"banner\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("banner"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("banner")); err != nil {
			return err
		}

		if err := t.Banner.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Labels (bsky.ActorProfile_Labels) (struct)
	if t.Labels != nil {

		if len("labels") > 1000000 {
			return xerrors.Errorf("Value in field \"labels\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("labels"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("labels")); err != nil {
			return err
		}

		if err := t.Labels.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.CreatedAt (string) (string)
	if t.CreatedAt != nil {

		if len("createdAt") > 1000000 {
			return xerrors.Errorf("Value in field \"createdAt\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("createdAt")); err != nil {
			return err
		}

		if t.CreatedAt == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.CreatedAt) > 1000000 {
				return xerrors.Errorf("Value in field t.CreatedAt was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.CreatedAt))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.CreatedAt)); err != nil {
				return err
			}
		}
	}

	// t.PinnedPost (atproto.RepoStrongRef) (struct)
	if t.PinnedPost != nil {

		if len("pinnedPost") > 1000000 {
			return xerrors.Errorf("Value in field \"pinnedPost\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("pinnedPost"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("pinnedPost")); err != nil {
			return err
		}

		if err := t.PinnedPost.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Description (string) (string)
	if t.Description != nil {

		if len("description") > 1000000 {
			return xerrors.Errorf("Value in field \"description\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("description"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("description")); err != nil {
			return err
		}

		if t.Description == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Description) > 1000000 {
				return xerrors.Errorf("Value in field t.Description was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Description))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Description)); err != nil {
				return err
			}
		}
	}

	// t.DisplayName (string) (string)
	if t.DisplayName != nil {

		if len("displayName") > 1000000 {
			return xerrors.Errorf("Value in field \"displayName\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("displayName"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("displayName")); err != nil {
			return err
		}

		if t.DisplayName == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.DisplayName) > 1000000 {
				return xerrors.Errorf("Value in field t.DisplayName was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.DisplayName))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.DisplayName)); err != nil {
				return err
			}
		}
	}

	// t.JoinedViaStarterPack (atproto.RepoStrongRef) (struct)
	if t.JoinedViaStarterPack != nil {

		if len("joinedViaStarterPack") > 1000000 {
			return xerrors.Errorf("Value in field \"joinedViaStarterPack\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("joinedViaStarterPack"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("joinedViaStarterPack")); err != nil {
			return err
		}

		if err := t.JoinedViaStarterPack.MarshalCBOR(cw); err != nil {
			return err
		}
	}
	return nil
}

func (t *ActorProfile) UnmarshalCBOR(r io.Reader) (err error) {
	*t = ActorProfile{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("ActorProfile: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 20)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Avatar (util.LexBlob) (struct)
		case "avatar":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Avatar = new(util.LexBlob)
					if err := t.Avatar.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Avatar pointer: %w", err)
					}
				}

			}
			// t.Banner (util.LexBlob) (struct)
		case "banner":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Banner = new(util.LexBlob)
					if err := t.Banner.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Banner pointer: %w", err)
					}
				}

			}
			// t.Labels (bsky.ActorProfile_Labels) (struct)
		case "labels":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Labels = new(ActorProfile_Labels)
					if err := t.Labels.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Labels pointer: %w", err)
					}
				}

			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.CreatedAt = (*string)(&sval)
				}
			}
			// t.PinnedPost (atproto.RepoStrongRef) (struct)
		case "pinnedPost":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.PinnedPost = new(atproto.RepoStrongRef)
					if err := t.PinnedPost.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.PinnedPost pointer: %w", err)
					}
				}

			}
			// t.Description (string) (string)
		case "description":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Description = (*string)(&sval)
				}
			}
			// t.DisplayName (string) (string)
		case "displayName":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.DisplayName = (*string)(&sval)
				}
			}
			// t.JoinedViaStarterPack (atproto.RepoStrongRef) (struct)
		case "joinedViaStarterPack":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.JoinedViaStarterPack = new(atproto.RepoStrongRef)
					if err := t.JoinedViaStarterPack.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.JoinedViaStarterPack pointer: %w", err)
					}
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedRecord) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.embed.record"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.embed.record")); err != nil {
		return err
	}

	// t.Record (atproto.RepoStrongRef) (struct)
	if len("record") > 1000000 {
		return xerrors.Errorf("Value in field \"record\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("record"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("record")); err != nil {
		return err
	}

	if err := t.Record.MarshalCBOR(cw); err != nil {
		return err
	}
	return nil
}

func (t *EmbedRecord) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedRecord{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedRecord: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 6)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Record (atproto.RepoStrongRef) (struct)
		case "record":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Record = new(atproto.RepoStrongRef)
					if err := t.Record.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Record pointer: %w", err)
					}
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedLike) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 4

	if t.Via == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Via (atproto.RepoStrongRef) (struct)
	if t.Via != nil {

		if len("via") > 1000000 {
			return xerrors.Errorf("Value in field \"via\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("via"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("via")); err != nil {
			return err
		}

		if err := t.Via.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.like"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.like")); err != nil {
		return err
	}

	// t.Subject (atproto.RepoStrongRef) (struct)
	if len("subject") > 1000000 {
		return xerrors.Errorf("Value in field \"subject\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subject"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("subject")); err != nil {
		return err
	}

	if err := t.Subject.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}
	return nil
}

func (t *FeedLike) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedLike{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedLike: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 9)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Via (atproto.RepoStrongRef) (struct)
		case "via":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Via = new(atproto.RepoStrongRef)
					if err := t.Via.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Via pointer: %w", err)
					}
				}

			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Subject (atproto.RepoStrongRef) (struct)
		case "subject":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Subject = new(atproto.RepoStrongRef)
					if err := t.Subject.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Subject pointer: %w", err)
					}
				}

			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *RichtextFacet) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Index (bsky.RichtextFacet_ByteSlice) (struct)
	if len("index") > 1000000 {
		return xerrors.Errorf("Value in field \"index\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("index"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("index")); err != nil {
		return err
	}

	if err := t.Index.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Features ([]*bsky.RichtextFacet_Features_Elem) (slice)
	if len("features") > 1000000 {
		return xerrors.Errorf("Value in field \"features\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("features"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("features")); err != nil {
		return err
	}

	if len(t.Features) > 8192 {
		return xerrors.Errorf("Slice value in field t.Features was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Features))); err != nil {
		return err
	}
	for _, v := range t.Features {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}
	return nil
}

func (t *RichtextFacet) UnmarshalCBOR(r io.Reader) (err error) {
	*t = RichtextFacet{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("RichtextFacet: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 8)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Index (bsky.RichtextFacet_ByteSlice) (struct)
		case "index":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Index = new(RichtextFacet_ByteSlice)
					if err := t.Index.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Index pointer: %w", err)
					}
				}

			}
			// t.Features ([]*bsky.RichtextFacet_Features_Elem) (slice)
		case "features":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Features: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Features = make([]*RichtextFacet_Features_Elem, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Features[i] = new(RichtextFacet_Features_Elem)
							if err := t.Features[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Features[i] pointer: %w", err)
							}
						}

					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *RichtextFacet_ByteSlice) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.ByteEnd (int64) (int64)
	if len("byteEnd") > 1000000 {
		return xerrors.Errorf("Value in field \"byteEnd\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("byteEnd"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("byteEnd")); err != nil {
		return err
	}

	if t.ByteEnd >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.ByteEnd)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.ByteEnd-1)); err != nil {
			return err
		}
	}

	// t.ByteStart (int64) (int64)
	if len("byteStart") > 1000000 {
		return xerrors.Errorf("Value in field \"byteStart\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("byteStart"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("byteStart")); err != nil {
		return err
	}

	if t.ByteStart >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.ByteStart)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.ByteStart-1)); err != nil {
			return err
		}
	}

	return nil
}

func (t *RichtextFacet_ByteSlice) UnmarshalCBOR(r io.Reader) (err error) {
	*t = RichtextFacet_ByteSlice{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("RichtextFacet_ByteSlice: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 9)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.ByteEnd (int64) (int64)
		case "byteEnd":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.ByteEnd = int64(extraI)
			}
			// t.ByteStart (int64) (int64)
		case "byteStart":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.ByteStart = int64(extraI)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *RichtextFacet_Link) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Uri (string) (string)
	if len("uri") > 1000000 {
		return xerrors.Errorf("Value in field \"uri\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("uri"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("uri")); err != nil {
		return err
	}

	if len(t.Uri) > 1000000 {
		return xerrors.Errorf("Value in field t.Uri was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Uri))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Uri)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.richtext.facet#link"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.richtext.facet#link")); err != nil {
		return err
	}
	return nil
}

func (t *RichtextFacet_Link) UnmarshalCBOR(r io.Reader) (err error) {
	*t = RichtextFacet_Link{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("RichtextFacet_Link: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Uri (string) (string)
		case "uri":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Uri = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *RichtextFacet_Mention) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Did (string) (string)
	if len("did") > 1000000 {
		return xerrors.Errorf("Value in field \"did\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("did"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("did")); err != nil {
		return err
	}

	if len(t.Did) > 1000000 {
		return xerrors.Errorf("Value in field t.Did was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Did))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Did)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.richtext.facet#mention"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.richtext.facet#mention")); err != nil {
		return err
	}
	return nil
}

func (t *RichtextFacet_Mention) UnmarshalCBOR(r io.Reader) (err error) {
	*t = RichtextFacet_Mention{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("RichtextFacet_Mention: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Did (string) (string)
		case "did":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Did = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *RichtextFacet_Tag) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Tag (string) (string)
	if len("tag") > 1000000 {
		return xerrors.Errorf("Value in field \"tag\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("tag"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("tag")); err != nil {
		return err
	}

	if len(t.Tag) > 1000000 {
		return xerrors.Errorf("Value in field t.Tag was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Tag))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Tag)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.richtext.facet#tag"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.richtext.facet#tag")); err != nil {
		return err
	}
	return nil
}

func (t *RichtextFacet_Tag) UnmarshalCBOR(r io.Reader) (err error) {
	*t = RichtextFacet_Tag{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("RichtextFacet_Tag: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Tag (string) (string)
		case "tag":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Tag = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedRecordWithMedia) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.embed.recordWithMedia"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.embed.recordWithMedia")); err != nil {
		return err
	}

	// t.Media (bsky.EmbedRecordWithMedia_Media) (struct)
	if len("media") > 1000000 {
		return xerrors.Errorf("Value in field \"media\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("media"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("media")); err != nil {
		return err
	}

	if err := t.Media.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Record (bsky.EmbedRecord) (struct)
	if len("record") > 1000000 {
		return xerrors.Errorf("Value in field \"record\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("record"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("record")); err != nil {
		return err
	}

	if err := t.Record.MarshalCBOR(cw); err != nil {
		return err
	}
	return nil
}

func (t *EmbedRecordWithMedia) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedRecordWithMedia{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedRecordWithMedia: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 6)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Media (bsky.EmbedRecordWithMedia_Media) (struct)
		case "media":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Media = new(EmbedRecordWithMedia_Media)
					if err := t.Media.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Media pointer: %w", err)
					}
				}

			}
			// t.Record (bsky.EmbedRecord) (struct)
		case "record":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Record = new(EmbedRecord)
					if err := t.Record.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Record pointer: %w", err)
					}
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedDefs_NotFoundPost) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.Uri (string) (string)
	if len("uri") > 1000000 {
		return xerrors.Errorf("Value in field \"uri\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("uri"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("uri")); err != nil {
		return err
	}

	if len(t.Uri) > 1000000 {
		return xerrors.Errorf("Value in field t.Uri was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Uri))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Uri)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.defs#notFoundPost"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.defs#notFoundPost")); err != nil {
		return err
	}

	// t.NotFound (bool) (bool)
	if len("notFound") > 1000000 {
		return xerrors.Errorf("Value in field \"notFound\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("notFound"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("notFound")); err != nil {
		return err
	}

	if err := cbg.WriteBool(w, t.NotFound); err != nil {
		return err
	}
	return nil
}

func (t *FeedDefs_NotFoundPost) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedDefs_NotFoundPost{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedDefs_NotFoundPost: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 8)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Uri (string) (string)
		case "uri":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Uri = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.NotFound (bool) (bool)
		case "notFound":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajOther {
				return fmt.Errorf("booleans must be major type 7")
			}
			switch extra {
			case 20:
				t.NotFound = false
			case 21:
				t.NotFound = true
			default:
				return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *GraphBlock) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.graph.block"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.graph.block")); err != nil {
		return err
	}

	// t.Subject (string) (string)
	if len("subject") > 1000000 {
		return xerrors.Errorf("Value in field \"subject\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subject"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("subject")); err != nil {
		return err
	}

	if len(t.Subject) > 1000000 {
		return xerrors.Errorf("Value in field t.Subject was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Subject))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Subject)); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}
	return nil
}

func (t *GraphBlock) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GraphBlock{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GraphBlock: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 9)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Subject (string) (string)
		case "subject":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Subject = string(sval)
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *GraphList) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 8

	if t.Avatar == nil {
		fieldCount--
	}

	if t.Description == nil {
		fieldCount--
	}

	if t.DescriptionFacets == nil {
		fieldCount--
	}

	if t.Labels == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Name (string) (string)
	if len("name") > 1000000 {
		return xerrors.Errorf("Value in field \"name\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("name"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("name")); err != nil {
		return err
	}

	if len(t.Name) > 1000000 {
		return xerrors.Errorf("Value in field t.Name was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Name))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Name)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.graph.list"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.graph.list")); err != nil {
		return err
	}

	// t.Avatar (util.LexBlob) (struct)
	if t.Avatar != nil {

		if len("avatar") > 1000000 {
			return xerrors.Errorf("Value in field \"avatar\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("avatar"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("avatar")); err != nil {
			return err
		}

		if err := t.Avatar.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Labels (bsky.GraphList_Labels) (struct)
	if t.Labels != nil {

		if len("labels") > 1000000 {
			return xerrors.Errorf("Value in field \"labels\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("labels"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("labels")); err != nil {
			return err
		}

		if err := t.Labels.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Purpose (string) (string)
	if len("purpose") > 1000000 {
		return xerrors.Errorf("Value in field \"purpose\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("purpose"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("purpose")); err != nil {
		return err
	}

	if t.Purpose == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if len(*t.Purpose) > 1000000 {
			return xerrors.Errorf("Value in field t.Purpose was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Purpose))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string(*t.Purpose)); err != nil {
			return err
		}
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.Description (string) (string)
	if t.Description != nil {

		if len("description") > 1000000 {
			return xerrors.Errorf("Value in field \"description\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("description"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("description")); err != nil {
			return err
		}

		if t.Description == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Description) > 1000000 {
				return xerrors.Errorf("Value in field t.Description was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Description))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Description)); err != nil {
				return err
			}
		}
	}

	// t.DescriptionFacets ([]*bsky.RichtextFacet) (slice)
	if t.DescriptionFacets != nil {

		if len("descriptionFacets") > 1000000 {
			return xerrors.Errorf("Value in field \"descriptionFacets\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("descriptionFacets"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("descriptionFacets")); err != nil {
			return err
		}

		if len(t.DescriptionFacets) > 8192 {
			return xerrors.Errorf("Slice value in field t.DescriptionFacets was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.DescriptionFacets))); err != nil {
			return err
		}
		for _, v := range t.DescriptionFacets {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}
	return nil
}

func (t *GraphList) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GraphList{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GraphList: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 17)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Name (string) (string)
		case "name":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Name = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Avatar (util.LexBlob) (struct)
		case "avatar":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Avatar = new(util.LexBlob)
					if err := t.Avatar.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Avatar pointer: %w", err)
					}
				}

			}
			// t.Labels (bsky.GraphList_Labels) (struct)
		case "labels":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Labels = new(GraphList_Labels)
					if err := t.Labels.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Labels pointer: %w", err)
					}
				}

			}
			// t.Purpose (string) (string)
		case "purpose":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Purpose = (*string)(&sval)
				}
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.Description (string) (string)
		case "description":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Description = (*string)(&sval)
				}
			}
			// t.DescriptionFacets ([]*bsky.RichtextFacet) (slice)
		case "descriptionFacets":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.DescriptionFacets: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.DescriptionFacets = make([]*RichtextFacet, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.DescriptionFacets[i] = new(RichtextFacet)
							if err := t.DescriptionFacets[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.DescriptionFacets[i] pointer: %w", err)
							}
						}

					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *GraphListitem) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{164}); err != nil {
		return err
	}

	// t.List (string) (string)
	if len("list") > 1000000 {
		return xerrors.Errorf("Value in field \"list\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("list"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("list")); err != nil {
		return err
	}

	if len(t.List) > 1000000 {
		return xerrors.Errorf("Value in field t.List was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.List))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.List)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.graph.listitem"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.graph.listitem")); err != nil {
		return err
	}

	// t.Subject (string) (string)
	if len("subject") > 1000000 {
		return xerrors.Errorf("Value in field \"subject\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subject"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("subject")); err != nil {
		return err
	}

	if len(t.Subject) > 1000000 {
		return xerrors.Errorf("Value in field t.Subject was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Subject))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Subject)); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}
	return nil
}

func (t *GraphListitem) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GraphListitem{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GraphListitem: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 9)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.List (string) (string)
		case "list":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.List = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Subject (string) (string)
		case "subject":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Subject = string(sval)
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedGenerator) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 10

	if t.AcceptsInteractions == nil {
		fieldCount--
	}

	if t.Avatar == nil {
		fieldCount--
	}

	if t.ContentMode == nil {
		fieldCount--
	}

	if t.Description == nil {
		fieldCount--
	}

	if t.DescriptionFacets == nil {
		fieldCount--
	}

	if t.Labels == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Did (string) (string)
	if len("did") > 1000000 {
		return xerrors.Errorf("Value in field \"did\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("did"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("did")); err != nil {
		return err
	}

	if len(t.Did) > 1000000 {
		return xerrors.Errorf("Value in field t.Did was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Did))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Did)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.generator"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.generator")); err != nil {
		return err
	}

	// t.Avatar (util.LexBlob) (struct)
	if t.Avatar != nil {

		if len("avatar") > 1000000 {
			return xerrors.Errorf("Value in field \"avatar\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("avatar"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("avatar")); err != nil {
			return err
		}

		if err := t.Avatar.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Labels (bsky.FeedGenerator_Labels) (struct)
	if t.Labels != nil {

		if len("labels") > 1000000 {
			return xerrors.Errorf("Value in field \"labels\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("labels"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("labels")); err != nil {
			return err
		}

		if err := t.Labels.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.ContentMode (string) (string)
	if t.ContentMode != nil {

		if len("contentMode") > 1000000 {
			return xerrors.Errorf("Value in field \"contentMode\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("contentMode"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("contentMode")); err != nil {
			return err
		}

		if t.ContentMode == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.ContentMode) > 1000000 {
				return xerrors.Errorf("Value in field t.ContentMode was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.ContentMode))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.ContentMode)); err != nil {
				return err
			}
		}
	}

	// t.Description (string) (string)
	if t.Description != nil {

		if len("description") > 1000000 {
			return xerrors.Errorf("Value in field \"description\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("description"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("description")); err != nil {
			return err
		}

		if t.Description == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Description) > 1000000 {
				return xerrors.Errorf("Value in field t.Description was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Description))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Description)); err != nil {
				return err
			}
		}
	}

	// t.DisplayName (string) (string)
	if len("displayName") > 1000000 {
		return xerrors.Errorf("Value in field \"displayName\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("displayName"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("displayName")); err != nil {
		return err
	}

	if len(t.DisplayName) > 1000000 {
		return xerrors.Errorf("Value in field t.DisplayName was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.DisplayName))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.DisplayName)); err != nil {
		return err
	}

	// t.DescriptionFacets ([]*bsky.RichtextFacet) (slice)
	if t.DescriptionFacets != nil {

		if len("descriptionFacets") > 1000000 {
			return xerrors.Errorf("Value in field \"descriptionFacets\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("descriptionFacets"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("descriptionFacets")); err != nil {
			return err
		}

		if len(t.DescriptionFacets) > 8192 {
			return xerrors.Errorf("Slice value in field t.DescriptionFacets was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.DescriptionFacets))); err != nil {
			return err
		}
		for _, v := range t.DescriptionFacets {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.AcceptsInteractions (bool) (bool)
	if t.AcceptsInteractions != nil {

		if len("acceptsInteractions") > 1000000 {
			return xerrors.Errorf("Value in field \"acceptsInteractions\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("acceptsInteractions"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("acceptsInteractions")); err != nil {
			return err
		}

		if t.AcceptsInteractions == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if err := cbg.WriteBool(w, *t.AcceptsInteractions); err != nil {
				return err
			}
		}
	}
	return nil
}

func (t *FeedGenerator) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedGenerator{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedGenerator: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 19)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Did (string) (string)
		case "did":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Did = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Avatar (util.LexBlob) (struct)
		case "avatar":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Avatar = new(util.LexBlob)
					if err := t.Avatar.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Avatar pointer: %w", err)
					}
				}

			}
			// t.Labels (bsky.FeedGenerator_Labels) (struct)
		case "labels":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Labels = new(FeedGenerator_Labels)
					if err := t.Labels.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Labels pointer: %w", err)
					}
				}

			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.ContentMode (string) (string)
		case "contentMode":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.ContentMode = (*string)(&sval)
				}
			}
			// t.Description (string) (string)
		case "description":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Description = (*string)(&sval)
				}
			}
			// t.DisplayName (string) (string)
		case "displayName":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.DisplayName = string(sval)
			}
			// t.DescriptionFacets ([]*bsky.RichtextFacet) (slice)
		case "descriptionFacets":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.DescriptionFacets: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.DescriptionFacets = make([]*RichtextFacet, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.DescriptionFacets[i] = new(RichtextFacet)
							if err := t.DescriptionFacets[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.DescriptionFacets[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.AcceptsInteractions (bool) (bool)
		case "acceptsInteractions":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}
					if maj != cbg.MajOther {
						return fmt.Errorf("booleans must be major type 7")
					}

					var val bool
					switch extra {
					case 20:
						val = false
					case 21:
						val = true
					default:
						return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
					}
					t.AcceptsInteractions = &val
				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *GraphListblock) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{163}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.graph.listblock"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.graph.listblock")); err != nil {
		return err
	}

	// t.Subject (string) (string)
	if len("subject") > 1000000 {
		return xerrors.Errorf("Value in field \"subject\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subject"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("subject")); err != nil {
		return err
	}

	if len(t.Subject) > 1000000 {
		return xerrors.Errorf("Value in field t.Subject was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Subject))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Subject)); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}
	return nil
}

func (t *GraphListblock) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GraphListblock{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GraphListblock: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 9)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Subject (string) (string)
		case "subject":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Subject = string(sval)
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedDefs_AspectRatio) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Width (int64) (int64)
	if len("width") > 1000000 {
		return xerrors.Errorf("Value in field \"width\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("width"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("width")); err != nil {
		return err
	}

	if t.Width >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Width)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Width-1)); err != nil {
			return err
		}
	}

	// t.Height (int64) (int64)
	if len("height") > 1000000 {
		return xerrors.Errorf("Value in field \"height\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("height"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("height")); err != nil {
		return err
	}

	if t.Height >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Height)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Height-1)); err != nil {
			return err
		}
	}

	return nil
}

func (t *EmbedDefs_AspectRatio) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedDefs_AspectRatio{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedDefs_AspectRatio: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 6)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Width (int64) (int64)
		case "width":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Width = int64(extraI)
			}
			// t.Height (int64) (int64)
		case "height":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Height = int64(extraI)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedThreadgate) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 5

	if t.Allow == nil {
		fieldCount--
	}

	if t.HiddenReplies == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Post (string) (string)
	if len("post") > 1000000 {
		return xerrors.Errorf("Value in field \"post\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("post"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("post")); err != nil {
		return err
	}

	if len(t.Post) > 1000000 {
		return xerrors.Errorf("Value in field t.Post was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Post))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Post)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.threadgate"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.threadgate")); err != nil {
		return err
	}

	// t.Allow ([]*bsky.FeedThreadgate_Allow_Elem) (slice)
	if t.Allow != nil {

		if len("allow") > 1000000 {
			return xerrors.Errorf("Value in field \"allow\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("allow"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("allow")); err != nil {
			return err
		}

		if len(t.Allow) > 8192 {
			return xerrors.Errorf("Slice value in field t.Allow was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Allow))); err != nil {
			return err
		}
		for _, v := range t.Allow {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.HiddenReplies ([]string) (slice)
	if t.HiddenReplies != nil {

		if len("hiddenReplies") > 1000000 {
			return xerrors.Errorf("Value in field \"hiddenReplies\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("hiddenReplies"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("hiddenReplies")); err != nil {
			return err
		}

		if len(t.HiddenReplies) > 8192 {
			return xerrors.Errorf("Slice value in field t.HiddenReplies was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.HiddenReplies))); err != nil {
			return err
		}
		for _, v := range t.HiddenReplies {
			if len(v) > 1000000 {
				return xerrors.Errorf("Value in field v was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(v))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(v)); err != nil {
				return err
			}

		}
	}
	return nil
}

func (t *FeedThreadgate) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedThreadgate{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedThreadgate: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 13)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Post (string) (string)
		case "post":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Post = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Allow ([]*bsky.FeedThreadgate_Allow_Elem) (slice)
		case "allow":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Allow: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Allow = make([]*FeedThreadgate_Allow_Elem, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Allow[i] = new(FeedThreadgate_Allow_Elem)
							if err := t.Allow[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Allow[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.HiddenReplies ([]string) (slice)
		case "hiddenReplies":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.HiddenReplies: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.HiddenReplies = make([]string, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{
						sval, err := cbg.ReadStringWithMax(cr, 1000000)
						if err != nil {
							return err
						}

						t.HiddenReplies[i] = string(sval)
					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedThreadgate_ListRule) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.List (string) (string)
	if len("list") > 1000000 {
		return xerrors.Errorf("Value in field \"list\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("list"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("list")); err != nil {
		return err
	}

	if len(t.List) > 1000000 {
		return xerrors.Errorf("Value in field t.List was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.List))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.List)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.threadgate#listRule"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.threadgate#listRule")); err != nil {
		return err
	}
	return nil
}

func (t *FeedThreadgate_ListRule) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedThreadgate_ListRule{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedThreadgate_ListRule: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.List (string) (string)
		case "list":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.List = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedThreadgate_MentionRule) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.threadgate#mentionRule"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.threadgate#mentionRule")); err != nil {
		return err
	}
	return nil
}

func (t *FeedThreadgate_MentionRule) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedThreadgate_MentionRule{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedThreadgate_MentionRule: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedThreadgate_FollowerRule) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.threadgate#followerRule"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.threadgate#followerRule")); err != nil {
		return err
	}
	return nil
}

func (t *FeedThreadgate_FollowerRule) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedThreadgate_FollowerRule{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedThreadgate_FollowerRule: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedThreadgate_FollowingRule) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.threadgate#followingRule"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.threadgate#followingRule")); err != nil {
		return err
	}
	return nil
}

func (t *FeedThreadgate_FollowingRule) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedThreadgate_FollowingRule{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedThreadgate_FollowingRule: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *GraphStarterpack_FeedItem) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.Uri (string) (string)
	if len("uri") > 1000000 {
		return xerrors.Errorf("Value in field \"uri\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("uri"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("uri")); err != nil {
		return err
	}

	if len(t.Uri) > 1000000 {
		return xerrors.Errorf("Value in field t.Uri was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Uri))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Uri)); err != nil {
		return err
	}
	return nil
}

func (t *GraphStarterpack_FeedItem) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GraphStarterpack_FeedItem{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GraphStarterpack_FeedItem: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 3)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Uri (string) (string)
		case "uri":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Uri = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *GraphStarterpack) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 7

	if t.Description == nil {
		fieldCount--
	}

	if t.DescriptionFacets == nil {
		fieldCount--
	}

	if t.Feeds == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.List (string) (string)
	if len("list") > 1000000 {
		return xerrors.Errorf("Value in field \"list\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("list"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("list")); err != nil {
		return err
	}

	if len(t.List) > 1000000 {
		return xerrors.Errorf("Value in field t.List was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.List))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.List)); err != nil {
		return err
	}

	// t.Name (string) (string)
	if len("name") > 1000000 {
		return xerrors.Errorf("Value in field \"name\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("name"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("name")); err != nil {
		return err
	}

	if len(t.Name) > 1000000 {
		return xerrors.Errorf("Value in field t.Name was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Name))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Name)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.graph.starterpack"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.graph.starterpack")); err != nil {
		return err
	}

	// t.Feeds ([]*bsky.GraphStarterpack_FeedItem) (slice)
	if t.Feeds != nil {

		if len("feeds") > 1000000 {
			return xerrors.Errorf("Value in field \"feeds\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("feeds"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("feeds")); err != nil {
			return err
		}

		if len(t.Feeds) > 8192 {
			return xerrors.Errorf("Slice value in field t.Feeds was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Feeds))); err != nil {
			return err
		}
		for _, v := range t.Feeds {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.Description (string) (string)
	if t.Description != nil {

		if len("description") > 1000000 {
			return xerrors.Errorf("Value in field \"description\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("description"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("description")); err != nil {
			return err
		}

		if t.Description == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Description) > 1000000 {
				return xerrors.Errorf("Value in field t.Description was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Description))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Description)); err != nil {
				return err
			}
		}
	}

	// t.DescriptionFacets ([]*bsky.RichtextFacet) (slice)
	if t.DescriptionFacets != nil {

		if len("descriptionFacets") > 1000000 {
			return xerrors.Errorf("Value in field \"descriptionFacets\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("descriptionFacets"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("descriptionFacets")); err != nil {
			return err
		}

		if len(t.DescriptionFacets) > 8192 {
			return xerrors.Errorf("Slice value in field t.DescriptionFacets was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.DescriptionFacets))); err != nil {
			return err
		}
		for _, v := range t.DescriptionFacets {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}
	return nil
}

func (t *GraphStarterpack) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GraphStarterpack{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GraphStarterpack: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 17)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.List (string) (string)
		case "list":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.List = string(sval)
			}
			// t.Name (string) (string)
		case "name":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Name = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Feeds ([]*bsky.GraphStarterpack_FeedItem) (slice)
		case "feeds":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Feeds: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Feeds = make([]*GraphStarterpack_FeedItem, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Feeds[i] = new(GraphStarterpack_FeedItem)
							if err := t.Feeds[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Feeds[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.Description (string) (string)
		case "description":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Description = (*string)(&sval)
				}
			}
			// t.DescriptionFacets ([]*bsky.RichtextFacet) (slice)
		case "descriptionFacets":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.DescriptionFacets: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.DescriptionFacets = make([]*RichtextFacet, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.DescriptionFacets[i] = new(RichtextFacet)
							if err := t.DescriptionFacets[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.DescriptionFacets[i] pointer: %w", err)
							}
						}

					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *LabelerService) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 7

	if t.Labels == nil {
		fieldCount--
	}

	if t.ReasonTypes == nil {
		fieldCount--
	}

	if t.SubjectCollections == nil {
		fieldCount--
	}

	if t.SubjectTypes == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.labeler.service"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.labeler.service")); err != nil {
		return err
	}

	// t.Labels (bsky.LabelerService_Labels) (struct)
	if t.Labels != nil {

		if len("labels") > 1000000 {
			return xerrors.Errorf("Value in field \"labels\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("labels"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("labels")); err != nil {
			return err
		}

		if err := t.Labels.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Policies (bsky.LabelerDefs_LabelerPolicies) (struct)
	if len("policies") > 1000000 {
		return xerrors.Errorf("Value in field \"policies\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("policies"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("policies")); err != nil {
		return err
	}

	if err := t.Policies.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.ReasonTypes ([]*string) (slice)
	if t.ReasonTypes != nil {

		if len("reasonTypes") > 1000000 {
			return xerrors.Errorf("Value in field \"reasonTypes\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("reasonTypes"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("reasonTypes")); err != nil {
			return err
		}

		if len(t.ReasonTypes) > 8192 {
			return xerrors.Errorf("Slice value in field t.ReasonTypes was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.ReasonTypes))); err != nil {
			return err
		}
		for _, v := range t.ReasonTypes {
			if v == nil {
				if _, err := cw.Write(cbg.CborNull); err != nil {
					return err
				}
			} else {
				if len(*v) > 1000000 {
					return xerrors.Errorf("Value in field v was too long")
				}

				if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*v))); err != nil {
					return err
				}
				if _, err := cw.WriteString(string(*v)); err != nil {
					return err
				}
			}

		}
	}

	// t.SubjectTypes ([]*string) (slice)
	if t.SubjectTypes != nil {

		if len("subjectTypes") > 1000000 {
			return xerrors.Errorf("Value in field \"subjectTypes\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subjectTypes"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("subjectTypes")); err != nil {
			return err
		}

		if len(t.SubjectTypes) > 8192 {
			return xerrors.Errorf("Slice value in field t.SubjectTypes was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.SubjectTypes))); err != nil {
			return err
		}
		for _, v := range t.SubjectTypes {
			if v == nil {
				if _, err := cw.Write(cbg.CborNull); err != nil {
					return err
				}
			} else {
				if len(*v) > 1000000 {
					return xerrors.Errorf("Value in field v was too long")
				}

				if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*v))); err != nil {
					return err
				}
				if _, err := cw.WriteString(string(*v)); err != nil {
					return err
				}
			}

		}
	}

	// t.SubjectCollections ([]string) (slice)
	if t.SubjectCollections != nil {

		if len("subjectCollections") > 1000000 {
			return xerrors.Errorf("Value in field \"subjectCollections\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subjectCollections"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("subjectCollections")); err != nil {
			return err
		}

		if len(t.SubjectCollections) > 8192 {
			return xerrors.Errorf("Slice value in field t.SubjectCollections was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.SubjectCollections))); err != nil {
			return err
		}
		for _, v := range t.SubjectCollections {
			if len(v) > 1000000 {
				return xerrors.Errorf("Value in field v was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(v))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(v)); err != nil {
				return err
			}

		}
	}
	return nil
}

func (t *LabelerService) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelerService{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelerService: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 18)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Labels (bsky.LabelerService_Labels) (struct)
		case "labels":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Labels = new(LabelerService_Labels)
					if err := t.Labels.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Labels pointer: %w", err)
					}
				}

			}
			// t.Policies (bsky.LabelerDefs_LabelerPolicies) (struct)
		case "policies":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Policies = new(LabelerDefs_LabelerPolicies)
					if err := t.Policies.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Policies pointer: %w", err)
					}
				}

			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.ReasonTypes ([]*string) (slice)
		case "reasonTypes":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.ReasonTypes: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.ReasonTypes = make([]*string, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{
						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}

							sval, err := cbg.ReadStringWithMax(cr, 1000000)
							if err != nil {
								return err
							}

							t.ReasonTypes[i] = (*string)(&sval)
						}
					}

				}
			}
			// t.SubjectTypes ([]*string) (slice)
		case "subjectTypes":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.SubjectTypes: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.SubjectTypes = make([]*string, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{
						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}

							sval, err := cbg.ReadStringWithMax(cr, 1000000)
							if err != nil {
								return err
							}

							t.SubjectTypes[i] = (*string)(&sval)
						}
					}

				}
			}
			// t.SubjectCollections ([]string) (slice)
		case "subjectCollections":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.SubjectCollections: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.SubjectCollections = make([]string, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{
						sval, err := cbg.ReadStringWithMax(cr, 1000000)
						if err != nil {
							return err
						}

						t.SubjectCollections[i] = string(sval)
					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *LabelerDefs_LabelerPolicies) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 2

	if t.LabelValueDefinitions == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.LabelValues ([]*string) (slice)
	if len("labelValues") > 1000000 {
		return xerrors.Errorf("Value in field \"labelValues\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("labelValues"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("labelValues")); err != nil {
		return err
	}

	if len(t.LabelValues) > 8192 {
		return xerrors.Errorf("Slice value in field t.LabelValues was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.LabelValues))); err != nil {
		return err
	}
	for _, v := range t.LabelValues {
		if v == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*v) > 1000000 {
				return xerrors.Errorf("Value in field v was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*v))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*v)); err != nil {
				return err
			}
		}

	}

	// t.LabelValueDefinitions ([]*atproto.LabelDefs_LabelValueDefinition) (slice)
	if t.LabelValueDefinitions != nil {

		if len("labelValueDefinitions") > 1000000 {
			return xerrors.Errorf("Value in field \"labelValueDefinitions\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("labelValueDefinitions"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("labelValueDefinitions")); err != nil {
			return err
		}

		if len(t.LabelValueDefinitions) > 8192 {
			return xerrors.Errorf("Slice value in field t.LabelValueDefinitions was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.LabelValueDefinitions))); err != nil {
			return err
		}
		for _, v := range t.LabelValueDefinitions {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}
	return nil
}

func (t *LabelerDefs_LabelerPolicies) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LabelerDefs_LabelerPolicies{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LabelerDefs_LabelerPolicies: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 21)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LabelValues ([]*string) (slice)
		case "labelValues":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.LabelValues: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.LabelValues = make([]*string, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{
						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}

							sval, err := cbg.ReadStringWithMax(cr, 1000000)
							if err != nil {
								return err
							}

							t.LabelValues[i] = (*string)(&sval)
						}
					}

				}
			}
			// t.LabelValueDefinitions ([]*atproto.LabelDefs_LabelValueDefinition) (slice)
		case "labelValueDefinitions":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.LabelValueDefinitions: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.LabelValueDefinitions = make([]*atproto.LabelDefs_LabelValueDefinition, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.LabelValueDefinitions[i] = new(atproto.LabelDefs_LabelValueDefinition)
							if err := t.LabelValueDefinitions[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.LabelValueDefinitions[i] pointer: %w", err)
							}
						}

					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedVideo) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 5

	if t.Alt == nil {
		fieldCount--
	}

	if t.AspectRatio == nil {
		fieldCount--
	}

	if t.Captions == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Alt (string) (string)
	if t.Alt != nil {

		if len("alt") > 1000000 {
			return xerrors.Errorf("Value in field \"alt\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("alt"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("alt")); err != nil {
			return err
		}

		if t.Alt == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Alt) > 1000000 {
				return xerrors.Errorf("Value in field t.Alt was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Alt))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Alt)); err != nil {
				return err
			}
		}
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.embed.video"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.embed.video")); err != nil {
		return err
	}

	// t.Video (util.LexBlob) (struct)
	if len("video") > 1000000 {
		return xerrors.Errorf("Value in field \"video\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("video"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("video")); err != nil {
		return err
	}

	if err := t.Video.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Captions ([]*bsky.EmbedVideo_Caption) (slice)
	if t.Captions != nil {

		if len("captions") > 1000000 {
			return xerrors.Errorf("Value in field \"captions\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("captions"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("captions")); err != nil {
			return err
		}

		if len(t.Captions) > 8192 {
			return xerrors.Errorf("Slice value in field t.Captions was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Captions))); err != nil {
			return err
		}
		for _, v := range t.Captions {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.AspectRatio (bsky.EmbedDefs_AspectRatio) (struct)
	if t.AspectRatio != nil {

		if len("aspectRatio") > 1000000 {
			return xerrors.Errorf("Value in field \"aspectRatio\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("aspectRatio"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("aspectRatio")); err != nil {
			return err
		}

		if err := t.AspectRatio.MarshalCBOR(cw); err != nil {
			return err
		}
	}
	return nil
}

func (t *EmbedVideo) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedVideo{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedVideo: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 11)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Alt (string) (string)
		case "alt":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Alt = (*string)(&sval)
				}
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Video (util.LexBlob) (struct)
		case "video":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Video = new(util.LexBlob)
					if err := t.Video.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Video pointer: %w", err)
					}
				}

			}
			// t.Captions ([]*bsky.EmbedVideo_Caption) (slice)
		case "captions":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Captions: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Captions = make([]*EmbedVideo_Caption, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.Captions[i] = new(EmbedVideo_Caption)
							if err := t.Captions[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.Captions[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.AspectRatio (bsky.EmbedDefs_AspectRatio) (struct)
		case "aspectRatio":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.AspectRatio = new(EmbedDefs_AspectRatio)
					if err := t.AspectRatio.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.AspectRatio pointer: %w", err)
					}
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EmbedVideo_Caption) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.File (util.LexBlob) (struct)
	if len("file") > 1000000 {
		return xerrors.Errorf("Value in field \"file\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("file"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("file")); err != nil {
		return err
	}

	if err := t.File.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Lang (string) (string)
	if len("lang") > 1000000 {
		return xerrors.Errorf("Value in field \"lang\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("lang"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("lang")); err != nil {
		return err
	}

	if len(t.Lang) > 1000000 {
		return xerrors.Errorf("Value in field t.Lang was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Lang))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Lang)); err != nil {
		return err
	}
	return nil
}

func (t *EmbedVideo_Caption) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EmbedVideo_Caption{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EmbedVideo_Caption: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 4)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.File (util.LexBlob) (struct)
		case "file":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.File = new(util.LexBlob)
					if err := t.File.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.File pointer: %w", err)
					}
				}

			}
			// t.Lang (string) (string)
		case "lang":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Lang = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedPostgate) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 5

	if t.DetachedEmbeddingUris == nil {
		fieldCount--
	}

	if t.EmbeddingRules == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Post (string) (string)
	if len("post") > 1000000 {
		return xerrors.Errorf("Value in field \"post\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("post"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("post")); err != nil {
		return err
	}

	if len(t.Post) > 1000000 {
		return xerrors.Errorf("Value in field t.Post was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Post))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Post)); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.postgate"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.postgate")); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.EmbeddingRules ([]*bsky.FeedPostgate_EmbeddingRules_Elem) (slice)
	if t.EmbeddingRules != nil {

		if len("embeddingRules") > 1000000 {
			return xerrors.Errorf("Value in field \"embeddingRules\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("embeddingRules"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("embeddingRules")); err != nil {
			return err
		}

		if len(t.EmbeddingRules) > 8192 {
			return xerrors.Errorf("Slice value in field t.EmbeddingRules was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.EmbeddingRules))); err != nil {
			return err
		}
		for _, v := range t.EmbeddingRules {
			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.DetachedEmbeddingUris ([]string) (slice)
	if t.DetachedEmbeddingUris != nil {

		if len("detachedEmbeddingUris") > 1000000 {
			return xerrors.Errorf("Value in field \"detachedEmbeddingUris\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("detachedEmbeddingUris"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("detachedEmbeddingUris")); err != nil {
			return err
		}

		if len(t.DetachedEmbeddingUris) > 8192 {
			return xerrors.Errorf("Slice value in field t.DetachedEmbeddingUris was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.DetachedEmbeddingUris))); err != nil {
			return err
		}
		for _, v := range t.DetachedEmbeddingUris {
			if len(v) > 1000000 {
				return xerrors.Errorf("Value in field v was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(v))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(v)); err != nil {
				return err
			}

		}
	}
	return nil
}

func (t *FeedPostgate) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedPostgate{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedPostgate: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 21)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Post (string) (string)
		case "post":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Post = string(sval)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.EmbeddingRules ([]*bsky.FeedPostgate_EmbeddingRules_Elem) (slice)
		case "embeddingRules":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.EmbeddingRules: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.EmbeddingRules = make([]*FeedPostgate_EmbeddingRules_Elem, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}
							t.EmbeddingRules[i] = new(FeedPostgate_EmbeddingRules_Elem)
							if err := t.EmbeddingRules[i].UnmarshalCBOR(cr); err != nil {
								return xerrors.Errorf("unmarshaling t.EmbeddingRules[i] pointer: %w", err)
							}
						}

					}

				}
			}
			// t.DetachedEmbeddingUris ([]string) (slice)
		case "detachedEmbeddingUris":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.DetachedEmbeddingUris: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.DetachedEmbeddingUris = make([]string, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{
						sval, err := cbg.ReadStringWithMax(cr, 1000000)
						if err != nil {
							return err
						}

						t.DetachedEmbeddingUris[i] = string(sval)
					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *FeedPostgate_DisableRule) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.feed.postgate#disableRule"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.feed.postgate#disableRule")); err != nil {
		return err
	}
	return nil
}

func (t *FeedPostgate_DisableRule) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FeedPostgate_DisableRule{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("FeedPostgate_DisableRule: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 5)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *GraphVerification) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{165}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.graph.verification"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.graph.verification")); err != nil {
		return err
	}

	// t.Handle (string) (string)
	if len("handle") > 1000000 {
		return xerrors.Errorf("Value in field \"handle\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("handle"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("handle")); err != nil {
		return err
	}

	if len(t.Handle) > 1000000 {
		return xerrors.Errorf("Value in field t.Handle was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Handle))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Handle)); err != nil {
		return err
	}

	// t.Subject (string) (string)
	if len("subject") > 1000000 {
		return xerrors.Errorf("Value in field \"subject\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("subject"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("subject")); err != nil {
		return err
	}

	if len(t.Subject) > 1000000 {
		return xerrors.Errorf("Value in field t.Subject was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Subject))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Subject)); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.DisplayName (string) (string)
	if len("displayName") > 1000000 {
		return xerrors.Errorf("Value in field \"displayName\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("displayName"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("displayName")); err != nil {
		return err
	}

	if len(t.DisplayName) > 1000000 {
		return xerrors.Errorf("Value in field t.DisplayName was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.DisplayName))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.DisplayName)); err != nil {
		return err
	}
	return nil
}

func (t *GraphVerification) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GraphVerification{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GraphVerification: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 11)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Handle (string) (string)
		case "handle":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Handle = string(sval)
			}
			// t.Subject (string) (string)
		case "subject":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Subject = string(sval)
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.DisplayName (string) (string)
		case "displayName":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.DisplayName = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *ActorStatus) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 5

	if t.DurationMinutes == nil {
		fieldCount--
	}

	if t.Embed == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.actor.status"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.actor.status")); err != nil {
		return err
	}

	// t.Embed (bsky.ActorStatus_Embed) (struct)
	if t.Embed != nil {

		if len("embed") > 1000000 {
			return xerrors.Errorf("Value in field \"embed\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("embed"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("embed")); err != nil {
			return err
		}

		if err := t.Embed.MarshalCBOR(cw); err != nil {
			return err
		}
	}

	// t.Status (string) (string)
	if len("status") > 1000000 {
		return xerrors.Errorf("Value in field \"status\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("status"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("status")); err != nil {
		return err
	}

	if len(t.Status) > 1000000 {
		return xerrors.Errorf("Value in field t.Status was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Status))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Status)); err != nil {
		return err
	}

	// t.CreatedAt (string) (string)
	if len("createdAt") > 1000000 {
		return xerrors.Errorf("Value in field \"createdAt\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("createdAt"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("createdAt")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.DurationMinutes (int64) (int64)
	if t.DurationMinutes != nil {

		if len("durationMinutes") > 1000000 {
			return xerrors.Errorf("Value in field \"durationMinutes\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("durationMinutes"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("durationMinutes")); err != nil {
			return err
		}

		if t.DurationMinutes == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if *t.DurationMinutes >= 0 {
				if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(*t.DurationMinutes)); err != nil {
					return err
				}
			} else {
				if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-*t.DurationMinutes-1)); err != nil {
					return err
				}
			}
		}

	}
	return nil
}

func (t *ActorStatus) UnmarshalCBOR(r io.Reader) (err error) {
	*t = ActorStatus{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("ActorStatus: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 15)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.Embed (bsky.ActorStatus_Embed) (struct)
		case "embed":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Embed = new(ActorStatus_Embed)
					if err := t.Embed.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Embed pointer: %w", err)
					}
				}

			}
			// t.Status (string) (string)
		case "status":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Status = string(sval)
			}
			// t.CreatedAt (string) (string)
		case "createdAt":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.DurationMinutes (int64) (int64)
		case "durationMinutes":
			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					maj, extra, err := cr.ReadHeader()
					if err != nil {
						return err
					}
					var extraI int64
					switch maj {
					case cbg.MajUnsignedInt:
						extraI = int64(extra)
						if extraI < 0 {
							return fmt.Errorf("int64 positive overflow")
						}
					case cbg.MajNegativeInt:
						extraI = int64(extra)
						if extraI < 0 {
							return fmt.Errorf("int64 negative overflow")
						}
						extraI = -1 - extraI
					default:
						return fmt.Errorf("wrong type for int64 field: %d", maj)
					}

					t.DurationMinutes = (*int64)(&extraI)
				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *NotificationDeclaration) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("app.bsky.notification.declaration"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("app.bsky.notification.declaration")); err != nil {
		return err
	}

	// t.AllowSubscriptions (string) (string)
	if len("allowSubscriptions") > 1000000 {
		return xerrors.Errorf("Value in field \"allowSubscriptions\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("allowSubscriptions"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("allowSubscriptions")); err != nil {
		return err
	}

	if len(t.AllowSubscriptions) > 1000000 {
		return xerrors.Errorf("Value in field t.AllowSubscriptions was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.AllowSubscriptions))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.AllowSubscriptions)); err != nil {
		return err
	}
	return nil
}

func (t *NotificationDeclaration) UnmarshalCBOR(r io.Reader) (err error) {
	*t = NotificationDeclaration{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("NotificationDeclaration: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 18)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.AllowSubscriptions (string) (string)
		case "allowSubscriptions":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.AllowSubscriptions = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
