// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package bsky

// schema: app.bsky.unspecced.getPostThreadV2

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/bluesky-social/indigo/lex/util"
)

// UnspeccedGetPostThreadV2_Output is the output of a app.bsky.unspecced.getPostThreadV2 call.
type UnspeccedGetPostThreadV2_Output struct {
	// hasOtherReplies: Whether this thread has additional replies. If true, a call can be made to the `getPostThreadOtherV2` endpoint to retrieve them.
	HasOtherReplies bool `json:"hasOtherReplies" cborgen:"hasOtherReplies"`
	// thread: A flat list of thread items. The depth of each item is indicated by the depth property inside the item.
	Thread     []*UnspeccedGetPostThreadV2_ThreadItem `json:"thread" cborgen:"thread"`
	Threadgate *FeedDefs_ThreadgateView               `json:"threadgate,omitempty" cborgen:"threadgate,omitempty"`
}

// UnspeccedGetPostThreadV2_ThreadItem is a "threadItem" in the app.bsky.unspecced.getPostThreadV2 schema.
type UnspeccedGetPostThreadV2_ThreadItem struct {
	// depth: The nesting level of this item in the thread. Depth 0 means the anchor item. Items above have negative depths, items below have positive depths.
	Depth int64                                      `json:"depth" cborgen:"depth"`
	Uri   string                                     `json:"uri" cborgen:"uri"`
	Value *UnspeccedGetPostThreadV2_ThreadItem_Value `json:"value" cborgen:"value"`
}

type UnspeccedGetPostThreadV2_ThreadItem_Value struct {
	UnspeccedDefs_ThreadItemPost              *UnspeccedDefs_ThreadItemPost
	UnspeccedDefs_ThreadItemNoUnauthenticated *UnspeccedDefs_ThreadItemNoUnauthenticated
	UnspeccedDefs_ThreadItemNotFound          *UnspeccedDefs_ThreadItemNotFound
	UnspeccedDefs_ThreadItemBlocked           *UnspeccedDefs_ThreadItemBlocked
}

func (t *UnspeccedGetPostThreadV2_ThreadItem_Value) MarshalJSON() ([]byte, error) {
	if t.UnspeccedDefs_ThreadItemPost != nil {
		t.UnspeccedDefs_ThreadItemPost.LexiconTypeID = "app.bsky.unspecced.defs#threadItemPost"
		return json.Marshal(t.UnspeccedDefs_ThreadItemPost)
	}
	if t.UnspeccedDefs_ThreadItemNoUnauthenticated != nil {
		t.UnspeccedDefs_ThreadItemNoUnauthenticated.LexiconTypeID = "app.bsky.unspecced.defs#threadItemNoUnauthenticated"
		return json.Marshal(t.UnspeccedDefs_ThreadItemNoUnauthenticated)
	}
	if t.UnspeccedDefs_ThreadItemNotFound != nil {
		t.UnspeccedDefs_ThreadItemNotFound.LexiconTypeID = "app.bsky.unspecced.defs#threadItemNotFound"
		return json.Marshal(t.UnspeccedDefs_ThreadItemNotFound)
	}
	if t.UnspeccedDefs_ThreadItemBlocked != nil {
		t.UnspeccedDefs_ThreadItemBlocked.LexiconTypeID = "app.bsky.unspecced.defs#threadItemBlocked"
		return json.Marshal(t.UnspeccedDefs_ThreadItemBlocked)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *UnspeccedGetPostThreadV2_ThreadItem_Value) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.unspecced.defs#threadItemPost":
		t.UnspeccedDefs_ThreadItemPost = new(UnspeccedDefs_ThreadItemPost)
		return json.Unmarshal(b, t.UnspeccedDefs_ThreadItemPost)
	case "app.bsky.unspecced.defs#threadItemNoUnauthenticated":
		t.UnspeccedDefs_ThreadItemNoUnauthenticated = new(UnspeccedDefs_ThreadItemNoUnauthenticated)
		return json.Unmarshal(b, t.UnspeccedDefs_ThreadItemNoUnauthenticated)
	case "app.bsky.unspecced.defs#threadItemNotFound":
		t.UnspeccedDefs_ThreadItemNotFound = new(UnspeccedDefs_ThreadItemNotFound)
		return json.Unmarshal(b, t.UnspeccedDefs_ThreadItemNotFound)
	case "app.bsky.unspecced.defs#threadItemBlocked":
		t.UnspeccedDefs_ThreadItemBlocked = new(UnspeccedDefs_ThreadItemBlocked)
		return json.Unmarshal(b, t.UnspeccedDefs_ThreadItemBlocked)

	default:
		return nil
	}
}

// UnspeccedGetPostThreadV2 calls the XRPC method "app.bsky.unspecced.getPostThreadV2".
//
// above: Whether to include parents above the anchor.
// anchor: Reference (AT-URI) to post record. This is the anchor post, and the thread will be built around it. It can be any post in the tree, not necessarily a root post.
// below: How many levels of replies to include below the anchor.
// branchingFactor: Maximum of replies to include at each level of the thread, except for the direct replies to the anchor, which are (NOTE: currently, during unspecced phase) all returned (NOTE: later they might be paginated).
// prioritizeFollowedUsers: Whether to prioritize posts from followed users. It only has effect when the user is authenticated.
// sort: Sorting for the thread replies.
func UnspeccedGetPostThreadV2(ctx context.Context, c util.LexClient, above bool, anchor string, below int64, branchingFactor int64, prioritizeFollowedUsers bool, sort string) (*UnspeccedGetPostThreadV2_Output, error) {
	var out UnspeccedGetPostThreadV2_Output

	params := map[string]interface{}{}
	if above {
		params["above"] = above
	}
	params["anchor"] = anchor
	if below != 0 {
		params["below"] = below
	}
	if branchingFactor != 0 {
		params["branchingFactor"] = branchingFactor
	}
	if prioritizeFollowedUsers {
		params["prioritizeFollowedUsers"] = prioritizeFollowedUsers
	}
	if sort != "" {
		params["sort"] = sort
	}
	if err := c.LexDo(ctx, util.Query, "", "app.bsky.unspecced.getPostThreadV2", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
