package words

// generated by github.com/clipperhouse/uax29/v2
// from https://www.unicode.org/Public/15.0.0/ucd/auxiliary/WordBreakProperty.txt

import "github.com/clipperhouse/uax29/v2/internal/iterators"

type property uint32

const (
	_ALetter property = 1 << iota
	_BleveIdeographic
	_CR
	_DoubleQuote
	_Extend
	_ExtendNumLet
	_ExtendedPictographic
	_Format
	_HebrewLetter
	_Katakana
	_LF
	_MidLetter
	_MidNum
	_MidNumLet
	_Newline
	_Numeric
	_RegionalIndicator
	_SingleQuote
	_WSegSpace
	_ZWJ
)

// lookup returns the trie value for the first UTF-8 encoding in s and
// the width in bytes of this encoding. The size will be 0 if s does not
// hold enough bytes to complete the encoding. len(s) must be greater than 0.
func lookup[T iterators.Stringish](s T) (v property, sz int) {
	c0 := s[0]
	switch {
	case c0 < 0x80: // is ASCII
		return wordsValues[c0], 1
	case c0 < 0xC2:
		return 0, 1 // Illegal UTF-8: not a starter, not ASCII.
	case c0 < 0xE0: // 2-byte UTF-8
		if len(s) < 2 {
			return 0, 0
		}
		i := wordsIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c1), 2
	case c0 < 0xF0: // 3-byte UTF-8
		if len(s) < 3 {
			return 0, 0
		}
		i := wordsIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = wordsIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c2), 3
	case c0 < 0xF8: // 4-byte UTF-8
		if len(s) < 4 {
			return 0, 0
		}
		i := wordsIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = wordsIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		o = uint32(i)<<6 + uint32(c2)
		i = wordsIndex[o]
		c3 := s[3]
		if c3 < 0x80 || 0xC0 <= c3 {
			return 0, 3 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c3), 4
	}
	// Illegal rune
	return 0, 1
}

// wordsTrie. Total size: 94464 bytes (92.25 KiB). Checksum: ef6ff72028f76377.
// type wordsTrie struct { }

// func newWordsTrie(i int) *wordsTrie {
// 	return &wordsTrie{}
// }

// lookupValue determines the type of block n and looks up the value for b.
func lookupValue(n uint32, b byte) property {
	switch {
	default:
		return property(wordsValues[n<<6+uint32(b)])
	}
}

// wordsValues: 351 blocks, 22464 entries, 89856 bytes
// The third block is the zero block.
var wordsValues = [22464]property{
	// Block 0x0, offset 0x0
	0x0a: 0x0400, 0x0b: 0x4000,
	0x0c: 0x4000, 0x0d: 0x0004,
	0x20: 0x40000, 0x22: 0x0008,
	0x27: 0x20000,
	0x2c: 0x1000, 0x2e: 0x2000,
	0x30: 0x8000, 0x31: 0x8000, 0x32: 0x8000, 0x33: 0x8000, 0x34: 0x8000, 0x35: 0x8000,
	0x36: 0x8000, 0x37: 0x8000, 0x38: 0x8000, 0x39: 0x8000, 0x3a: 0x0800, 0x3b: 0x1000,
	// Block 0x1, offset 0x40
	0x41: 0x0001, 0x42: 0x0001, 0x43: 0x0001, 0x44: 0x0001, 0x45: 0x0001,
	0x46: 0x0001, 0x47: 0x0001, 0x48: 0x0001, 0x49: 0x0001, 0x4a: 0x0001, 0x4b: 0x0001,
	0x4c: 0x0001, 0x4d: 0x0001, 0x4e: 0x0001, 0x4f: 0x0001, 0x50: 0x0001, 0x51: 0x0001,
	0x52: 0x0001, 0x53: 0x0001, 0x54: 0x0001, 0x55: 0x0001, 0x56: 0x0001, 0x57: 0x0001,
	0x58: 0x0001, 0x59: 0x0001, 0x5a: 0x0001,
	0x5f: 0x0020, 0x61: 0x0001, 0x62: 0x0001, 0x63: 0x0001,
	0x64: 0x0001, 0x65: 0x0001, 0x66: 0x0001, 0x67: 0x0001, 0x68: 0x0001, 0x69: 0x0001,
	0x6a: 0x0001, 0x6b: 0x0001, 0x6c: 0x0001, 0x6d: 0x0001, 0x6e: 0x0001, 0x6f: 0x0001,
	0x70: 0x0001, 0x71: 0x0001, 0x72: 0x0001, 0x73: 0x0001, 0x74: 0x0001, 0x75: 0x0001,
	0x76: 0x0001, 0x77: 0x0001, 0x78: 0x0001, 0x79: 0x0001, 0x7a: 0x0001,
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc5: 0x4000,
	0xe9: 0x0040,
	0xea: 0x0001, 0xed: 0x0080, 0xee: 0x0040,
	0xf5: 0x0001,
	0xf7: 0x0800, 0xfa: 0x0001,
	// Block 0x4, offset 0x100
	0x100: 0x0001, 0x101: 0x0001, 0x102: 0x0001, 0x103: 0x0001, 0x104: 0x0001, 0x105: 0x0001,
	0x106: 0x0001, 0x107: 0x0001, 0x108: 0x0001, 0x109: 0x0001, 0x10a: 0x0001, 0x10b: 0x0001,
	0x10c: 0x0001, 0x10d: 0x0001, 0x10e: 0x0001, 0x10f: 0x0001, 0x110: 0x0001, 0x111: 0x0001,
	0x112: 0x0001, 0x113: 0x0001, 0x114: 0x0001, 0x115: 0x0001, 0x116: 0x0001,
	0x118: 0x0001, 0x119: 0x0001, 0x11a: 0x0001, 0x11b: 0x0001, 0x11c: 0x0001, 0x11d: 0x0001,
	0x11e: 0x0001, 0x11f: 0x0001, 0x120: 0x0001, 0x121: 0x0001, 0x122: 0x0001, 0x123: 0x0001,
	0x124: 0x0001, 0x125: 0x0001, 0x126: 0x0001, 0x127: 0x0001, 0x128: 0x0001, 0x129: 0x0001,
	0x12a: 0x0001, 0x12b: 0x0001, 0x12c: 0x0001, 0x12d: 0x0001, 0x12e: 0x0001, 0x12f: 0x0001,
	0x130: 0x0001, 0x131: 0x0001, 0x132: 0x0001, 0x133: 0x0001, 0x134: 0x0001, 0x135: 0x0001,
	0x136: 0x0001, 0x138: 0x0001, 0x139: 0x0001, 0x13a: 0x0001, 0x13b: 0x0001,
	0x13c: 0x0001, 0x13d: 0x0001, 0x13e: 0x0001, 0x13f: 0x0001,
	// Block 0x5, offset 0x140
	0x140: 0x0001, 0x141: 0x0001, 0x142: 0x0001, 0x143: 0x0001, 0x144: 0x0001, 0x145: 0x0001,
	0x146: 0x0001, 0x147: 0x0001, 0x148: 0x0001, 0x149: 0x0001, 0x14a: 0x0001, 0x14b: 0x0001,
	0x14c: 0x0001, 0x14d: 0x0001, 0x14e: 0x0001, 0x14f: 0x0001, 0x150: 0x0001, 0x151: 0x0001,
	0x152: 0x0001, 0x153: 0x0001, 0x154: 0x0001, 0x155: 0x0001, 0x156: 0x0001, 0x157: 0x0001,
	0x158: 0x0001, 0x159: 0x0001, 0x15a: 0x0001, 0x15b: 0x0001, 0x15c: 0x0001, 0x15d: 0x0001,
	0x15e: 0x0001, 0x15f: 0x0001, 0x160: 0x0001, 0x161: 0x0001, 0x162: 0x0001, 0x163: 0x0001,
	0x164: 0x0001, 0x165: 0x0001, 0x166: 0x0001, 0x167: 0x0001, 0x168: 0x0001, 0x169: 0x0001,
	0x16a: 0x0001, 0x16b: 0x0001, 0x16c: 0x0001, 0x16d: 0x0001, 0x16e: 0x0001, 0x16f: 0x0001,
	0x170: 0x0001, 0x171: 0x0001, 0x172: 0x0001, 0x173: 0x0001, 0x174: 0x0001, 0x175: 0x0001,
	0x176: 0x0001, 0x177: 0x0001, 0x178: 0x0001, 0x179: 0x0001, 0x17a: 0x0001, 0x17b: 0x0001,
	0x17c: 0x0001, 0x17d: 0x0001, 0x17e: 0x0001, 0x17f: 0x0001,
	// Block 0x6, offset 0x180
	0x180: 0x0001, 0x181: 0x0001, 0x182: 0x0001, 0x183: 0x0001, 0x184: 0x0001, 0x185: 0x0001,
	0x186: 0x0001, 0x187: 0x0001, 0x188: 0x0001, 0x189: 0x0001, 0x18a: 0x0001, 0x18b: 0x0001,
	0x18c: 0x0001, 0x18d: 0x0001, 0x18e: 0x0001, 0x18f: 0x0001, 0x190: 0x0001, 0x191: 0x0001,
	0x192: 0x0001, 0x193: 0x0001, 0x194: 0x0001, 0x195: 0x0001, 0x196: 0x0001, 0x197: 0x0001,
	0x19e: 0x0001, 0x19f: 0x0001, 0x1a0: 0x0001, 0x1a1: 0x0001, 0x1a2: 0x0001, 0x1a3: 0x0001,
	0x1a4: 0x0001, 0x1a5: 0x0001, 0x1a6: 0x0001, 0x1a7: 0x0001, 0x1a8: 0x0001, 0x1a9: 0x0001,
	0x1aa: 0x0001, 0x1ab: 0x0001, 0x1ac: 0x0001, 0x1ad: 0x0001, 0x1ae: 0x0001, 0x1af: 0x0001,
	0x1b0: 0x0001, 0x1b1: 0x0001, 0x1b2: 0x0001, 0x1b3: 0x0001, 0x1b4: 0x0001, 0x1b5: 0x0001,
	0x1b6: 0x0001, 0x1b7: 0x0001, 0x1b8: 0x0001, 0x1b9: 0x0001, 0x1ba: 0x0001, 0x1bb: 0x0001,
	0x1bc: 0x0001, 0x1bd: 0x0001, 0x1be: 0x0001, 0x1bf: 0x0001,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x0010, 0x1c1: 0x0010, 0x1c2: 0x0010, 0x1c3: 0x0010, 0x1c4: 0x0010, 0x1c5: 0x0010,
	0x1c6: 0x0010, 0x1c7: 0x0010, 0x1c8: 0x0010, 0x1c9: 0x0010, 0x1ca: 0x0010, 0x1cb: 0x0010,
	0x1cc: 0x0010, 0x1cd: 0x0010, 0x1ce: 0x0010, 0x1cf: 0x0010, 0x1d0: 0x0010, 0x1d1: 0x0010,
	0x1d2: 0x0010, 0x1d3: 0x0010, 0x1d4: 0x0010, 0x1d5: 0x0010, 0x1d6: 0x0010, 0x1d7: 0x0010,
	0x1d8: 0x0010, 0x1d9: 0x0010, 0x1da: 0x0010, 0x1db: 0x0010, 0x1dc: 0x0010, 0x1dd: 0x0010,
	0x1de: 0x0010, 0x1df: 0x0010, 0x1e0: 0x0010, 0x1e1: 0x0010, 0x1e2: 0x0010, 0x1e3: 0x0010,
	0x1e4: 0x0010, 0x1e5: 0x0010, 0x1e6: 0x0010, 0x1e7: 0x0010, 0x1e8: 0x0010, 0x1e9: 0x0010,
	0x1ea: 0x0010, 0x1eb: 0x0010, 0x1ec: 0x0010, 0x1ed: 0x0010, 0x1ee: 0x0010, 0x1ef: 0x0010,
	0x1f0: 0x0010, 0x1f1: 0x0010, 0x1f2: 0x0010, 0x1f3: 0x0010, 0x1f4: 0x0010, 0x1f5: 0x0010,
	0x1f6: 0x0010, 0x1f7: 0x0010, 0x1f8: 0x0010, 0x1f9: 0x0010, 0x1fa: 0x0010, 0x1fb: 0x0010,
	0x1fc: 0x0010, 0x1fd: 0x0010, 0x1fe: 0x0010, 0x1ff: 0x0010,
	// Block 0x8, offset 0x200
	0x200: 0x0010, 0x201: 0x0010, 0x202: 0x0010, 0x203: 0x0010, 0x204: 0x0010, 0x205: 0x0010,
	0x206: 0x0010, 0x207: 0x0010, 0x208: 0x0010, 0x209: 0x0010, 0x20a: 0x0010, 0x20b: 0x0010,
	0x20c: 0x0010, 0x20d: 0x0010, 0x20e: 0x0010, 0x20f: 0x0010, 0x210: 0x0010, 0x211: 0x0010,
	0x212: 0x0010, 0x213: 0x0010, 0x214: 0x0010, 0x215: 0x0010, 0x216: 0x0010, 0x217: 0x0010,
	0x218: 0x0010, 0x219: 0x0010, 0x21a: 0x0010, 0x21b: 0x0010, 0x21c: 0x0010, 0x21d: 0x0010,
	0x21e: 0x0010, 0x21f: 0x0010, 0x220: 0x0010, 0x221: 0x0010, 0x222: 0x0010, 0x223: 0x0010,
	0x224: 0x0010, 0x225: 0x0010, 0x226: 0x0010, 0x227: 0x0010, 0x228: 0x0010, 0x229: 0x0010,
	0x22a: 0x0010, 0x22b: 0x0010, 0x22c: 0x0010, 0x22d: 0x0010, 0x22e: 0x0010, 0x22f: 0x0010,
	0x230: 0x0001, 0x231: 0x0001, 0x232: 0x0001, 0x233: 0x0001, 0x234: 0x0001,
	0x236: 0x0001, 0x237: 0x0001, 0x23a: 0x0001, 0x23b: 0x0001,
	0x23c: 0x0001, 0x23d: 0x0001, 0x23e: 0x1000, 0x23f: 0x0001,
	// Block 0x9, offset 0x240
	0x246: 0x0001, 0x247: 0x0800, 0x248: 0x0001, 0x249: 0x0001, 0x24a: 0x0001,
	0x24c: 0x0001, 0x24e: 0x0001, 0x24f: 0x0001, 0x250: 0x0001, 0x251: 0x0001,
	0x252: 0x0001, 0x253: 0x0001, 0x254: 0x0001, 0x255: 0x0001, 0x256: 0x0001, 0x257: 0x0001,
	0x258: 0x0001, 0x259: 0x0001, 0x25a: 0x0001, 0x25b: 0x0001, 0x25c: 0x0001, 0x25d: 0x0001,
	0x25e: 0x0001, 0x25f: 0x0001, 0x260: 0x0001, 0x261: 0x0001, 0x263: 0x0001,
	0x264: 0x0001, 0x265: 0x0001, 0x266: 0x0001, 0x267: 0x0001, 0x268: 0x0001, 0x269: 0x0001,
	0x26a: 0x0001, 0x26b: 0x0001, 0x26c: 0x0001, 0x26d: 0x0001, 0x26e: 0x0001, 0x26f: 0x0001,
	0x270: 0x0001, 0x271: 0x0001, 0x272: 0x0001, 0x273: 0x0001, 0x274: 0x0001, 0x275: 0x0001,
	0x276: 0x0001, 0x277: 0x0001, 0x278: 0x0001, 0x279: 0x0001, 0x27a: 0x0001, 0x27b: 0x0001,
	0x27c: 0x0001, 0x27d: 0x0001, 0x27e: 0x0001, 0x27f: 0x0001,
	// Block 0xa, offset 0x280
	0x280: 0x0001, 0x281: 0x0001, 0x282: 0x0001, 0x283: 0x0001, 0x284: 0x0001, 0x285: 0x0001,
	0x286: 0x0001, 0x287: 0x0001, 0x288: 0x0001, 0x289: 0x0001, 0x28a: 0x0001, 0x28b: 0x0001,
	0x28c: 0x0001, 0x28d: 0x0001, 0x28e: 0x0001, 0x28f: 0x0001, 0x290: 0x0001, 0x291: 0x0001,
	0x292: 0x0001, 0x293: 0x0001, 0x294: 0x0001, 0x295: 0x0001, 0x296: 0x0001, 0x297: 0x0001,
	0x298: 0x0001, 0x299: 0x0001, 0x29a: 0x0001, 0x29b: 0x0001, 0x29c: 0x0001, 0x29d: 0x0001,
	0x29e: 0x0001, 0x29f: 0x0001, 0x2a0: 0x0001, 0x2a1: 0x0001, 0x2a2: 0x0001, 0x2a3: 0x0001,
	0x2a4: 0x0001, 0x2a5: 0x0001, 0x2a6: 0x0001, 0x2a7: 0x0001, 0x2a8: 0x0001, 0x2a9: 0x0001,
	0x2aa: 0x0001, 0x2ab: 0x0001, 0x2ac: 0x0001, 0x2ad: 0x0001, 0x2ae: 0x0001, 0x2af: 0x0001,
	0x2b0: 0x0001, 0x2b1: 0x0001, 0x2b2: 0x0001, 0x2b3: 0x0001, 0x2b4: 0x0001, 0x2b5: 0x0001,
	0x2b7: 0x0001, 0x2b8: 0x0001, 0x2b9: 0x0001, 0x2ba: 0x0001, 0x2bb: 0x0001,
	0x2bc: 0x0001, 0x2bd: 0x0001, 0x2be: 0x0001, 0x2bf: 0x0001,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x0001, 0x2c1: 0x0001, 0x2c3: 0x0010, 0x2c4: 0x0010, 0x2c5: 0x0010,
	0x2c6: 0x0010, 0x2c7: 0x0010, 0x2c8: 0x0010, 0x2c9: 0x0010, 0x2ca: 0x0001, 0x2cb: 0x0001,
	0x2cc: 0x0001, 0x2cd: 0x0001, 0x2ce: 0x0001, 0x2cf: 0x0001, 0x2d0: 0x0001, 0x2d1: 0x0001,
	0x2d2: 0x0001, 0x2d3: 0x0001, 0x2d4: 0x0001, 0x2d5: 0x0001, 0x2d6: 0x0001, 0x2d7: 0x0001,
	0x2d8: 0x0001, 0x2d9: 0x0001, 0x2da: 0x0001, 0x2db: 0x0001, 0x2dc: 0x0001, 0x2dd: 0x0001,
	0x2de: 0x0001, 0x2df: 0x0001, 0x2e0: 0x0001, 0x2e1: 0x0001, 0x2e2: 0x0001, 0x2e3: 0x0001,
	0x2e4: 0x0001, 0x2e5: 0x0001, 0x2e6: 0x0001, 0x2e7: 0x0001, 0x2e8: 0x0001, 0x2e9: 0x0001,
	0x2ea: 0x0001, 0x2eb: 0x0001, 0x2ec: 0x0001, 0x2ed: 0x0001, 0x2ee: 0x0001, 0x2ef: 0x0001,
	0x2f0: 0x0001, 0x2f1: 0x0001, 0x2f2: 0x0001, 0x2f3: 0x0001, 0x2f4: 0x0001, 0x2f5: 0x0001,
	0x2f6: 0x0001, 0x2f7: 0x0001, 0x2f8: 0x0001, 0x2f9: 0x0001, 0x2fa: 0x0001, 0x2fb: 0x0001,
	0x2fc: 0x0001, 0x2fd: 0x0001, 0x2fe: 0x0001, 0x2ff: 0x0001,
	// Block 0xc, offset 0x300
	0x300: 0x0001, 0x301: 0x0001, 0x302: 0x0001, 0x303: 0x0001, 0x304: 0x0001, 0x305: 0x0001,
	0x306: 0x0001, 0x307: 0x0001, 0x308: 0x0001, 0x309: 0x0001, 0x30a: 0x0001, 0x30b: 0x0001,
	0x30c: 0x0001, 0x30d: 0x0001, 0x30e: 0x0001, 0x30f: 0x0001, 0x310: 0x0001, 0x311: 0x0001,
	0x312: 0x0001, 0x313: 0x0001, 0x314: 0x0001, 0x315: 0x0001, 0x316: 0x0001, 0x317: 0x0001,
	0x318: 0x0001, 0x319: 0x0001, 0x31a: 0x0001, 0x31b: 0x0001, 0x31c: 0x0001, 0x31d: 0x0001,
	0x31e: 0x0001, 0x31f: 0x0001, 0x320: 0x0001, 0x321: 0x0001, 0x322: 0x0001, 0x323: 0x0001,
	0x324: 0x0001, 0x325: 0x0001, 0x326: 0x0001, 0x327: 0x0001, 0x328: 0x0001, 0x329: 0x0001,
	0x32a: 0x0001, 0x32b: 0x0001, 0x32c: 0x0001, 0x32d: 0x0001, 0x32e: 0x0001, 0x32f: 0x0001,
	0x331: 0x0001, 0x332: 0x0001, 0x333: 0x0001, 0x334: 0x0001, 0x335: 0x0001,
	0x336: 0x0001, 0x337: 0x0001, 0x338: 0x0001, 0x339: 0x0001, 0x33a: 0x0001, 0x33b: 0x0001,
	0x33c: 0x0001, 0x33d: 0x0001, 0x33e: 0x0001, 0x33f: 0x0001,
	// Block 0xd, offset 0x340
	0x340: 0x0001, 0x341: 0x0001, 0x342: 0x0001, 0x343: 0x0001, 0x344: 0x0001, 0x345: 0x0001,
	0x346: 0x0001, 0x347: 0x0001, 0x348: 0x0001, 0x349: 0x0001, 0x34a: 0x0001, 0x34b: 0x0001,
	0x34c: 0x0001, 0x34d: 0x0001, 0x34e: 0x0001, 0x34f: 0x0001, 0x350: 0x0001, 0x351: 0x0001,
	0x352: 0x0001, 0x353: 0x0001, 0x354: 0x0001, 0x355: 0x0001, 0x356: 0x0001,
	0x359: 0x0001, 0x35a: 0x0001, 0x35b: 0x0001, 0x35c: 0x0001,
	0x35e: 0x0001, 0x35f: 0x0800, 0x360: 0x0001, 0x361: 0x0001, 0x362: 0x0001, 0x363: 0x0001,
	0x364: 0x0001, 0x365: 0x0001, 0x366: 0x0001, 0x367: 0x0001, 0x368: 0x0001, 0x369: 0x0001,
	0x36a: 0x0001, 0x36b: 0x0001, 0x36c: 0x0001, 0x36d: 0x0001, 0x36e: 0x0001, 0x36f: 0x0001,
	0x370: 0x0001, 0x371: 0x0001, 0x372: 0x0001, 0x373: 0x0001, 0x374: 0x0001, 0x375: 0x0001,
	0x376: 0x0001, 0x377: 0x0001, 0x378: 0x0001, 0x379: 0x0001, 0x37a: 0x0001, 0x37b: 0x0001,
	0x37c: 0x0001, 0x37d: 0x0001, 0x37e: 0x0001, 0x37f: 0x0001,
	// Block 0xe, offset 0x380
	0x380: 0x0001, 0x381: 0x0001, 0x382: 0x0001, 0x383: 0x0001, 0x384: 0x0001, 0x385: 0x0001,
	0x386: 0x0001, 0x387: 0x0001, 0x388: 0x0001, 0x389: 0x1000, 0x38a: 0x0001,
	0x391: 0x0010,
	0x392: 0x0010, 0x393: 0x0010, 0x394: 0x0010, 0x395: 0x0010, 0x396: 0x0010, 0x397: 0x0010,
	0x398: 0x0010, 0x399: 0x0010, 0x39a: 0x0010, 0x39b: 0x0010, 0x39c: 0x0010, 0x39d: 0x0010,
	0x39e: 0x0010, 0x39f: 0x0010, 0x3a0: 0x0010, 0x3a1: 0x0010, 0x3a2: 0x0010, 0x3a3: 0x0010,
	0x3a4: 0x0010, 0x3a5: 0x0010, 0x3a6: 0x0010, 0x3a7: 0x0010, 0x3a8: 0x0010, 0x3a9: 0x0010,
	0x3aa: 0x0010, 0x3ab: 0x0010, 0x3ac: 0x0010, 0x3ad: 0x0010, 0x3ae: 0x0010, 0x3af: 0x0010,
	0x3b0: 0x0010, 0x3b1: 0x0010, 0x3b2: 0x0010, 0x3b3: 0x0010, 0x3b4: 0x0010, 0x3b5: 0x0010,
	0x3b6: 0x0010, 0x3b7: 0x0010, 0x3b8: 0x0010, 0x3b9: 0x0010, 0x3ba: 0x0010, 0x3bb: 0x0010,
	0x3bc: 0x0010, 0x3bd: 0x0010, 0x3bf: 0x0010,
	// Block 0xf, offset 0x3c0
	0x3c1: 0x0010, 0x3c2: 0x0010, 0x3c4: 0x0010, 0x3c5: 0x0010,
	0x3c7: 0x0010,
	0x3d0: 0x0100, 0x3d1: 0x0100,
	0x3d2: 0x0100, 0x3d3: 0x0100, 0x3d4: 0x0100, 0x3d5: 0x0100, 0x3d6: 0x0100, 0x3d7: 0x0100,
	0x3d8: 0x0100, 0x3d9: 0x0100, 0x3da: 0x0100, 0x3db: 0x0100, 0x3dc: 0x0100, 0x3dd: 0x0100,
	0x3de: 0x0100, 0x3df: 0x0100, 0x3e0: 0x0100, 0x3e1: 0x0100, 0x3e2: 0x0100, 0x3e3: 0x0100,
	0x3e4: 0x0100, 0x3e5: 0x0100, 0x3e6: 0x0100, 0x3e7: 0x0100, 0x3e8: 0x0100, 0x3e9: 0x0100,
	0x3ea: 0x0100, 0x3ef: 0x0100,
	0x3f0: 0x0100, 0x3f1: 0x0100, 0x3f2: 0x0100, 0x3f3: 0x0001, 0x3f4: 0x0800,
	// Block 0x10, offset 0x400
	0x400: 0x0080, 0x401: 0x0080, 0x402: 0x0080, 0x403: 0x0080, 0x404: 0x0080, 0x405: 0x0080,
	0x40c: 0x1000, 0x40d: 0x1000, 0x410: 0x0010, 0x411: 0x0010,
	0x412: 0x0010, 0x413: 0x0010, 0x414: 0x0010, 0x415: 0x0010, 0x416: 0x0010, 0x417: 0x0010,
	0x418: 0x0010, 0x419: 0x0010, 0x41a: 0x0010, 0x41c: 0x0080,
	0x420: 0x0001, 0x421: 0x0001, 0x422: 0x0001, 0x423: 0x0001,
	0x424: 0x0001, 0x425: 0x0001, 0x426: 0x0001, 0x427: 0x0001, 0x428: 0x0001, 0x429: 0x0001,
	0x42a: 0x0001, 0x42b: 0x0001, 0x42c: 0x0001, 0x42d: 0x0001, 0x42e: 0x0001, 0x42f: 0x0001,
	0x430: 0x0001, 0x431: 0x0001, 0x432: 0x0001, 0x433: 0x0001, 0x434: 0x0001, 0x435: 0x0001,
	0x436: 0x0001, 0x437: 0x0001, 0x438: 0x0001, 0x439: 0x0001, 0x43a: 0x0001, 0x43b: 0x0001,
	0x43c: 0x0001, 0x43d: 0x0001, 0x43e: 0x0001, 0x43f: 0x0001,
	// Block 0x11, offset 0x440
	0x440: 0x0001, 0x441: 0x0001, 0x442: 0x0001, 0x443: 0x0001, 0x444: 0x0001, 0x445: 0x0001,
	0x446: 0x0001, 0x447: 0x0001, 0x448: 0x0001, 0x449: 0x0001, 0x44a: 0x0001, 0x44b: 0x0010,
	0x44c: 0x0010, 0x44d: 0x0010, 0x44e: 0x0010, 0x44f: 0x0010, 0x450: 0x0010, 0x451: 0x0010,
	0x452: 0x0010, 0x453: 0x0010, 0x454: 0x0010, 0x455: 0x0010, 0x456: 0x0010, 0x457: 0x0010,
	0x458: 0x0010, 0x459: 0x0010, 0x45a: 0x0010, 0x45b: 0x0010, 0x45c: 0x0010, 0x45d: 0x0010,
	0x45e: 0x0010, 0x45f: 0x0010, 0x460: 0x8000, 0x461: 0x8000, 0x462: 0x8000, 0x463: 0x8000,
	0x464: 0x8000, 0x465: 0x8000, 0x466: 0x8000, 0x467: 0x8000, 0x468: 0x8000, 0x469: 0x8000,
	0x46b: 0x8000, 0x46c: 0x1000, 0x46e: 0x0001, 0x46f: 0x0001,
	0x470: 0x0010, 0x471: 0x0001, 0x472: 0x0001, 0x473: 0x0001, 0x474: 0x0001, 0x475: 0x0001,
	0x476: 0x0001, 0x477: 0x0001, 0x478: 0x0001, 0x479: 0x0001, 0x47a: 0x0001, 0x47b: 0x0001,
	0x47c: 0x0001, 0x47d: 0x0001, 0x47e: 0x0001, 0x47f: 0x0001,
	// Block 0x12, offset 0x480
	0x480: 0x0001, 0x481: 0x0001, 0x482: 0x0001, 0x483: 0x0001, 0x484: 0x0001, 0x485: 0x0001,
	0x486: 0x0001, 0x487: 0x0001, 0x488: 0x0001, 0x489: 0x0001, 0x48a: 0x0001, 0x48b: 0x0001,
	0x48c: 0x0001, 0x48d: 0x0001, 0x48e: 0x0001, 0x48f: 0x0001, 0x490: 0x0001, 0x491: 0x0001,
	0x492: 0x0001, 0x493: 0x0001, 0x495: 0x0001, 0x496: 0x0010, 0x497: 0x0010,
	0x498: 0x0010, 0x499: 0x0010, 0x49a: 0x0010, 0x49b: 0x0010, 0x49c: 0x0010, 0x49d: 0x0080,
	0x49f: 0x0010, 0x4a0: 0x0010, 0x4a1: 0x0010, 0x4a2: 0x0010, 0x4a3: 0x0010,
	0x4a4: 0x0010, 0x4a5: 0x0001, 0x4a6: 0x0001, 0x4a7: 0x0010, 0x4a8: 0x0010,
	0x4aa: 0x0010, 0x4ab: 0x0010, 0x4ac: 0x0010, 0x4ad: 0x0010, 0x4ae: 0x0001, 0x4af: 0x0001,
	0x4b0: 0x8000, 0x4b1: 0x8000, 0x4b2: 0x8000, 0x4b3: 0x8000, 0x4b4: 0x8000, 0x4b5: 0x8000,
	0x4b6: 0x8000, 0x4b7: 0x8000, 0x4b8: 0x8000, 0x4b9: 0x8000, 0x4ba: 0x0001, 0x4bb: 0x0001,
	0x4bc: 0x0001, 0x4bf: 0x0001,
	// Block 0x13, offset 0x4c0
	0x4cf: 0x0080, 0x4d0: 0x0001, 0x4d1: 0x0010,
	0x4d2: 0x0001, 0x4d3: 0x0001, 0x4d4: 0x0001, 0x4d5: 0x0001, 0x4d6: 0x0001, 0x4d7: 0x0001,
	0x4d8: 0x0001, 0x4d9: 0x0001, 0x4da: 0x0001, 0x4db: 0x0001, 0x4dc: 0x0001, 0x4dd: 0x0001,
	0x4de: 0x0001, 0x4df: 0x0001, 0x4e0: 0x0001, 0x4e1: 0x0001, 0x4e2: 0x0001, 0x4e3: 0x0001,
	0x4e4: 0x0001, 0x4e5: 0x0001, 0x4e6: 0x0001, 0x4e7: 0x0001, 0x4e8: 0x0001, 0x4e9: 0x0001,
	0x4ea: 0x0001, 0x4eb: 0x0001, 0x4ec: 0x0001, 0x4ed: 0x0001, 0x4ee: 0x0001, 0x4ef: 0x0001,
	0x4f0: 0x0010, 0x4f1: 0x0010, 0x4f2: 0x0010, 0x4f3: 0x0010, 0x4f4: 0x0010, 0x4f5: 0x0010,
	0x4f6: 0x0010, 0x4f7: 0x0010, 0x4f8: 0x0010, 0x4f9: 0x0010, 0x4fa: 0x0010, 0x4fb: 0x0010,
	0x4fc: 0x0010, 0x4fd: 0x0010, 0x4fe: 0x0010, 0x4ff: 0x0010,
	// Block 0x14, offset 0x500
	0x500: 0x0010, 0x501: 0x0010, 0x502: 0x0010, 0x503: 0x0010, 0x504: 0x0010, 0x505: 0x0010,
	0x506: 0x0010, 0x507: 0x0010, 0x508: 0x0010, 0x509: 0x0010, 0x50a: 0x0010,
	0x50d: 0x0001, 0x50e: 0x0001, 0x50f: 0x0001, 0x510: 0x0001, 0x511: 0x0001,
	0x512: 0x0001, 0x513: 0x0001, 0x514: 0x0001, 0x515: 0x0001, 0x516: 0x0001, 0x517: 0x0001,
	0x518: 0x0001, 0x519: 0x0001, 0x51a: 0x0001, 0x51b: 0x0001, 0x51c: 0x0001, 0x51d: 0x0001,
	0x51e: 0x0001, 0x51f: 0x0001, 0x520: 0x0001, 0x521: 0x0001, 0x522: 0x0001, 0x523: 0x0001,
	0x524: 0x0001, 0x525: 0x0001, 0x526: 0x0001, 0x527: 0x0001, 0x528: 0x0001, 0x529: 0x0001,
	0x52a: 0x0001, 0x52b: 0x0001, 0x52c: 0x0001, 0x52d: 0x0001, 0x52e: 0x0001, 0x52f: 0x0001,
	0x530: 0x0001, 0x531: 0x0001, 0x532: 0x0001, 0x533: 0x0001, 0x534: 0x0001, 0x535: 0x0001,
	0x536: 0x0001, 0x537: 0x0001, 0x538: 0x0001, 0x539: 0x0001, 0x53a: 0x0001, 0x53b: 0x0001,
	0x53c: 0x0001, 0x53d: 0x0001, 0x53e: 0x0001, 0x53f: 0x0001,
	// Block 0x15, offset 0x540
	0x540: 0x0001, 0x541: 0x0001, 0x542: 0x0001, 0x543: 0x0001, 0x544: 0x0001, 0x545: 0x0001,
	0x546: 0x0001, 0x547: 0x0001, 0x548: 0x0001, 0x549: 0x0001, 0x54a: 0x0001, 0x54b: 0x0001,
	0x54c: 0x0001, 0x54d: 0x0001, 0x54e: 0x0001, 0x54f: 0x0001, 0x550: 0x0001, 0x551: 0x0001,
	0x552: 0x0001, 0x553: 0x0001, 0x554: 0x0001, 0x555: 0x0001, 0x556: 0x0001, 0x557: 0x0001,
	0x558: 0x0001, 0x559: 0x0001, 0x55a: 0x0001, 0x55b: 0x0001, 0x55c: 0x0001, 0x55d: 0x0001,
	0x55e: 0x0001, 0x55f: 0x0001, 0x560: 0x0001, 0x561: 0x0001, 0x562: 0x0001, 0x563: 0x0001,
	0x564: 0x0001, 0x565: 0x0001, 0x566: 0x0010, 0x567: 0x0010, 0x568: 0x0010, 0x569: 0x0010,
	0x56a: 0x0010, 0x56b: 0x0010, 0x56c: 0x0010, 0x56d: 0x0010, 0x56e: 0x0010, 0x56f: 0x0010,
	0x570: 0x0010, 0x571: 0x0001,
	// Block 0x16, offset 0x580
	0x580: 0x8000, 0x581: 0x8000, 0x582: 0x8000, 0x583: 0x8000, 0x584: 0x8000, 0x585: 0x8000,
	0x586: 0x8000, 0x587: 0x8000, 0x588: 0x8000, 0x589: 0x8000, 0x58a: 0x0001, 0x58b: 0x0001,
	0x58c: 0x0001, 0x58d: 0x0001, 0x58e: 0x0001, 0x58f: 0x0001, 0x590: 0x0001, 0x591: 0x0001,
	0x592: 0x0001, 0x593: 0x0001, 0x594: 0x0001, 0x595: 0x0001, 0x596: 0x0001, 0x597: 0x0001,
	0x598: 0x0001, 0x599: 0x0001, 0x59a: 0x0001, 0x59b: 0x0001, 0x59c: 0x0001, 0x59d: 0x0001,
	0x59e: 0x0001, 0x59f: 0x0001, 0x5a0: 0x0001, 0x5a1: 0x0001, 0x5a2: 0x0001, 0x5a3: 0x0001,
	0x5a4: 0x0001, 0x5a5: 0x0001, 0x5a6: 0x0001, 0x5a7: 0x0001, 0x5a8: 0x0001, 0x5a9: 0x0001,
	0x5aa: 0x0001, 0x5ab: 0x0010, 0x5ac: 0x0010, 0x5ad: 0x0010, 0x5ae: 0x0010, 0x5af: 0x0010,
	0x5b0: 0x0010, 0x5b1: 0x0010, 0x5b2: 0x0010, 0x5b3: 0x0010, 0x5b4: 0x0001, 0x5b5: 0x0001,
	0x5b8: 0x1000, 0x5ba: 0x0001,
	0x5bd: 0x0010,
	// Block 0x17, offset 0x5c0
	0x5c0: 0x0001, 0x5c1: 0x0001, 0x5c2: 0x0001, 0x5c3: 0x0001, 0x5c4: 0x0001, 0x5c5: 0x0001,
	0x5c6: 0x0001, 0x5c7: 0x0001, 0x5c8: 0x0001, 0x5c9: 0x0001, 0x5ca: 0x0001, 0x5cb: 0x0001,
	0x5cc: 0x0001, 0x5cd: 0x0001, 0x5ce: 0x0001, 0x5cf: 0x0001, 0x5d0: 0x0001, 0x5d1: 0x0001,
	0x5d2: 0x0001, 0x5d3: 0x0001, 0x5d4: 0x0001, 0x5d5: 0x0001, 0x5d6: 0x0010, 0x5d7: 0x0010,
	0x5d8: 0x0010, 0x5d9: 0x0010, 0x5da: 0x0001, 0x5db: 0x0010, 0x5dc: 0x0010, 0x5dd: 0x0010,
	0x5de: 0x0010, 0x5df: 0x0010, 0x5e0: 0x0010, 0x5e1: 0x0010, 0x5e2: 0x0010, 0x5e3: 0x0010,
	0x5e4: 0x0001, 0x5e5: 0x0010, 0x5e6: 0x0010, 0x5e7: 0x0010, 0x5e8: 0x0001, 0x5e9: 0x0010,
	0x5ea: 0x0010, 0x5eb: 0x0010, 0x5ec: 0x0010, 0x5ed: 0x0010,
	// Block 0x18, offset 0x600
	0x600: 0x0001, 0x601: 0x0001, 0x602: 0x0001, 0x603: 0x0001, 0x604: 0x0001, 0x605: 0x0001,
	0x606: 0x0001, 0x607: 0x0001, 0x608: 0x0001, 0x609: 0x0001, 0x60a: 0x0001, 0x60b: 0x0001,
	0x60c: 0x0001, 0x60d: 0x0001, 0x60e: 0x0001, 0x60f: 0x0001, 0x610: 0x0001, 0x611: 0x0001,
	0x612: 0x0001, 0x613: 0x0001, 0x614: 0x0001, 0x615: 0x0001, 0x616: 0x0001, 0x617: 0x0001,
	0x618: 0x0001, 0x619: 0x0010, 0x61a: 0x0010, 0x61b: 0x0010,
	0x620: 0x0001, 0x621: 0x0001, 0x622: 0x0001, 0x623: 0x0001,
	0x624: 0x0001, 0x625: 0x0001, 0x626: 0x0001, 0x627: 0x0001, 0x628: 0x0001, 0x629: 0x0001,
	0x62a: 0x0001,
	0x630: 0x0001, 0x631: 0x0001, 0x632: 0x0001, 0x633: 0x0001, 0x634: 0x0001, 0x635: 0x0001,
	0x636: 0x0001, 0x637: 0x0001, 0x638: 0x0001, 0x639: 0x0001, 0x63a: 0x0001, 0x63b: 0x0001,
	0x63c: 0x0001, 0x63d: 0x0001, 0x63e: 0x0001, 0x63f: 0x0001,
	// Block 0x19, offset 0x640
	0x640: 0x0001, 0x641: 0x0001, 0x642: 0x0001, 0x643: 0x0001, 0x644: 0x0001, 0x645: 0x0001,
	0x646: 0x0001, 0x647: 0x0001, 0x649: 0x0001, 0x64a: 0x0001, 0x64b: 0x0001,
	0x64c: 0x0001, 0x64d: 0x0001, 0x64e: 0x0001, 0x650: 0x0080, 0x651: 0x0080,
	0x658: 0x0010, 0x659: 0x0010, 0x65a: 0x0010, 0x65b: 0x0010, 0x65c: 0x0010, 0x65d: 0x0010,
	0x65e: 0x0010, 0x65f: 0x0010, 0x660: 0x0001, 0x661: 0x0001, 0x662: 0x0001, 0x663: 0x0001,
	0x664: 0x0001, 0x665: 0x0001, 0x666: 0x0001, 0x667: 0x0001, 0x668: 0x0001, 0x669: 0x0001,
	0x66a: 0x0001, 0x66b: 0x0001, 0x66c: 0x0001, 0x66d: 0x0001, 0x66e: 0x0001, 0x66f: 0x0001,
	0x670: 0x0001, 0x671: 0x0001, 0x672: 0x0001, 0x673: 0x0001, 0x674: 0x0001, 0x675: 0x0001,
	0x676: 0x0001, 0x677: 0x0001, 0x678: 0x0001, 0x679: 0x0001, 0x67a: 0x0001, 0x67b: 0x0001,
	0x67c: 0x0001, 0x67d: 0x0001, 0x67e: 0x0001, 0x67f: 0x0001,
	// Block 0x1a, offset 0x680
	0x680: 0x0001, 0x681: 0x0001, 0x682: 0x0001, 0x683: 0x0001, 0x684: 0x0001, 0x685: 0x0001,
	0x686: 0x0001, 0x687: 0x0001, 0x688: 0x0001, 0x689: 0x0001, 0x68a: 0x0010, 0x68b: 0x0010,
	0x68c: 0x0010, 0x68d: 0x0010, 0x68e: 0x0010, 0x68f: 0x0010, 0x690: 0x0010, 0x691: 0x0010,
	0x692: 0x0010, 0x693: 0x0010, 0x694: 0x0010, 0x695: 0x0010, 0x696: 0x0010, 0x697: 0x0010,
	0x698: 0x0010, 0x699: 0x0010, 0x69a: 0x0010, 0x69b: 0x0010, 0x69c: 0x0010, 0x69d: 0x0010,
	0x69e: 0x0010, 0x69f: 0x0010, 0x6a0: 0x0010, 0x6a1: 0x0010, 0x6a2: 0x0080, 0x6a3: 0x0010,
	0x6a4: 0x0010, 0x6a5: 0x0010, 0x6a6: 0x0010, 0x6a7: 0x0010, 0x6a8: 0x0010, 0x6a9: 0x0010,
	0x6aa: 0x0010, 0x6ab: 0x0010, 0x6ac: 0x0010, 0x6ad: 0x0010, 0x6ae: 0x0010, 0x6af: 0x0010,
	0x6b0: 0x0010, 0x6b1: 0x0010, 0x6b2: 0x0010, 0x6b3: 0x0010, 0x6b4: 0x0010, 0x6b5: 0x0010,
	0x6b6: 0x0010, 0x6b7: 0x0010, 0x6b8: 0x0010, 0x6b9: 0x0010, 0x6ba: 0x0010, 0x6bb: 0x0010,
	0x6bc: 0x0010, 0x6bd: 0x0010, 0x6be: 0x0010, 0x6bf: 0x0010,
	// Block 0x1b, offset 0x6c0
	0x6c0: 0x0010, 0x6c1: 0x0010, 0x6c2: 0x0010, 0x6c3: 0x0010, 0x6c4: 0x0001, 0x6c5: 0x0001,
	0x6c6: 0x0001, 0x6c7: 0x0001, 0x6c8: 0x0001, 0x6c9: 0x0001, 0x6ca: 0x0001, 0x6cb: 0x0001,
	0x6cc: 0x0001, 0x6cd: 0x0001, 0x6ce: 0x0001, 0x6cf: 0x0001, 0x6d0: 0x0001, 0x6d1: 0x0001,
	0x6d2: 0x0001, 0x6d3: 0x0001, 0x6d4: 0x0001, 0x6d5: 0x0001, 0x6d6: 0x0001, 0x6d7: 0x0001,
	0x6d8: 0x0001, 0x6d9: 0x0001, 0x6da: 0x0001, 0x6db: 0x0001, 0x6dc: 0x0001, 0x6dd: 0x0001,
	0x6de: 0x0001, 0x6df: 0x0001, 0x6e0: 0x0001, 0x6e1: 0x0001, 0x6e2: 0x0001, 0x6e3: 0x0001,
	0x6e4: 0x0001, 0x6e5: 0x0001, 0x6e6: 0x0001, 0x6e7: 0x0001, 0x6e8: 0x0001, 0x6e9: 0x0001,
	0x6ea: 0x0001, 0x6eb: 0x0001, 0x6ec: 0x0001, 0x6ed: 0x0001, 0x6ee: 0x0001, 0x6ef: 0x0001,
	0x6f0: 0x0001, 0x6f1: 0x0001, 0x6f2: 0x0001, 0x6f3: 0x0001, 0x6f4: 0x0001, 0x6f5: 0x0001,
	0x6f6: 0x0001, 0x6f7: 0x0001, 0x6f8: 0x0001, 0x6f9: 0x0001, 0x6fa: 0x0010, 0x6fb: 0x0010,
	0x6fc: 0x0010, 0x6fd: 0x0001, 0x6fe: 0x0010, 0x6ff: 0x0010,
	// Block 0x1c, offset 0x700
	0x700: 0x0010, 0x701: 0x0010, 0x702: 0x0010, 0x703: 0x0010, 0x704: 0x0010, 0x705: 0x0010,
	0x706: 0x0010, 0x707: 0x0010, 0x708: 0x0010, 0x709: 0x0010, 0x70a: 0x0010, 0x70b: 0x0010,
	0x70c: 0x0010, 0x70d: 0x0010, 0x70e: 0x0010, 0x70f: 0x0010, 0x710: 0x0001, 0x711: 0x0010,
	0x712: 0x0010, 0x713: 0x0010, 0x714: 0x0010, 0x715: 0x0010, 0x716: 0x0010, 0x717: 0x0010,
	0x718: 0x0001, 0x719: 0x0001, 0x71a: 0x0001, 0x71b: 0x0001, 0x71c: 0x0001, 0x71d: 0x0001,
	0x71e: 0x0001, 0x71f: 0x0001, 0x720: 0x0001, 0x721: 0x0001, 0x722: 0x0010, 0x723: 0x0010,
	0x726: 0x8000, 0x727: 0x8000, 0x728: 0x8000, 0x729: 0x8000,
	0x72a: 0x8000, 0x72b: 0x8000, 0x72c: 0x8000, 0x72d: 0x8000, 0x72e: 0x8000, 0x72f: 0x8000,
	0x731: 0x0001, 0x732: 0x0001, 0x733: 0x0001, 0x734: 0x0001, 0x735: 0x0001,
	0x736: 0x0001, 0x737: 0x0001, 0x738: 0x0001, 0x739: 0x0001, 0x73a: 0x0001, 0x73b: 0x0001,
	0x73c: 0x0001, 0x73d: 0x0001, 0x73e: 0x0001, 0x73f: 0x0001,
	// Block 0x1d, offset 0x740
	0x740: 0x0001, 0x741: 0x0010, 0x742: 0x0010, 0x743: 0x0010, 0x745: 0x0001,
	0x746: 0x0001, 0x747: 0x0001, 0x748: 0x0001, 0x749: 0x0001, 0x74a: 0x0001, 0x74b: 0x0001,
	0x74c: 0x0001, 0x74f: 0x0001, 0x750: 0x0001,
	0x753: 0x0001, 0x754: 0x0001, 0x755: 0x0001, 0x756: 0x0001, 0x757: 0x0001,
	0x758: 0x0001, 0x759: 0x0001, 0x75a: 0x0001, 0x75b: 0x0001, 0x75c: 0x0001, 0x75d: 0x0001,
	0x75e: 0x0001, 0x75f: 0x0001, 0x760: 0x0001, 0x761: 0x0001, 0x762: 0x0001, 0x763: 0x0001,
	0x764: 0x0001, 0x765: 0x0001, 0x766: 0x0001, 0x767: 0x0001, 0x768: 0x0001,
	0x76a: 0x0001, 0x76b: 0x0001, 0x76c: 0x0001, 0x76d: 0x0001, 0x76e: 0x0001, 0x76f: 0x0001,
	0x770: 0x0001, 0x772: 0x0001,
	0x776: 0x0001, 0x777: 0x0001, 0x778: 0x0001, 0x779: 0x0001,
	0x77c: 0x0010, 0x77d: 0x0001, 0x77e: 0x0010, 0x77f: 0x0010,
	// Block 0x1e, offset 0x780
	0x780: 0x0010, 0x781: 0x0010, 0x782: 0x0010, 0x783: 0x0010, 0x784: 0x0010,
	0x787: 0x0010, 0x788: 0x0010, 0x78b: 0x0010,
	0x78c: 0x0010, 0x78d: 0x0010, 0x78e: 0x0001,
	0x797: 0x0010,
	0x79c: 0x0001, 0x79d: 0x0001,
	0x79f: 0x0001, 0x7a0: 0x0001, 0x7a1: 0x0001, 0x7a2: 0x0010, 0x7a3: 0x0010,
	0x7a6: 0x8000, 0x7a7: 0x8000, 0x7a8: 0x8000, 0x7a9: 0x8000,
	0x7aa: 0x8000, 0x7ab: 0x8000, 0x7ac: 0x8000, 0x7ad: 0x8000, 0x7ae: 0x8000, 0x7af: 0x8000,
	0x7b0: 0x0001, 0x7b1: 0x0001,
	0x7bc: 0x0001, 0x7be: 0x0010,
	// Block 0x1f, offset 0x7c0
	0x7c1: 0x0010, 0x7c2: 0x0010, 0x7c3: 0x0010, 0x7c5: 0x0001,
	0x7c6: 0x0001, 0x7c7: 0x0001, 0x7c8: 0x0001, 0x7c9: 0x0001, 0x7ca: 0x0001,
	0x7cf: 0x0001, 0x7d0: 0x0001,
	0x7d3: 0x0001, 0x7d4: 0x0001, 0x7d5: 0x0001, 0x7d6: 0x0001, 0x7d7: 0x0001,
	0x7d8: 0x0001, 0x7d9: 0x0001, 0x7da: 0x0001, 0x7db: 0x0001, 0x7dc: 0x0001, 0x7dd: 0x0001,
	0x7de: 0x0001, 0x7df: 0x0001, 0x7e0: 0x0001, 0x7e1: 0x0001, 0x7e2: 0x0001, 0x7e3: 0x0001,
	0x7e4: 0x0001, 0x7e5: 0x0001, 0x7e6: 0x0001, 0x7e7: 0x0001, 0x7e8: 0x0001,
	0x7ea: 0x0001, 0x7eb: 0x0001, 0x7ec: 0x0001, 0x7ed: 0x0001, 0x7ee: 0x0001, 0x7ef: 0x0001,
	0x7f0: 0x0001, 0x7f2: 0x0001, 0x7f3: 0x0001, 0x7f5: 0x0001,
	0x7f6: 0x0001, 0x7f8: 0x0001, 0x7f9: 0x0001,
	0x7fc: 0x0010, 0x7fe: 0x0010, 0x7ff: 0x0010,
	// Block 0x20, offset 0x800
	0x800: 0x0010, 0x801: 0x0010, 0x802: 0x0010,
	0x807: 0x0010, 0x808: 0x0010, 0x80b: 0x0010,
	0x80c: 0x0010, 0x80d: 0x0010, 0x811: 0x0010,
	0x819: 0x0001, 0x81a: 0x0001, 0x81b: 0x0001, 0x81c: 0x0001,
	0x81e: 0x0001,
	0x826: 0x8000, 0x827: 0x8000, 0x828: 0x8000, 0x829: 0x8000,
	0x82a: 0x8000, 0x82b: 0x8000, 0x82c: 0x8000, 0x82d: 0x8000, 0x82e: 0x8000, 0x82f: 0x8000,
	0x830: 0x0010, 0x831: 0x0010, 0x832: 0x0001, 0x833: 0x0001, 0x834: 0x0001, 0x835: 0x0010,
	// Block 0x21, offset 0x840
	0x841: 0x0010, 0x842: 0x0010, 0x843: 0x0010, 0x845: 0x0001,
	0x846: 0x0001, 0x847: 0x0001, 0x848: 0x0001, 0x849: 0x0001, 0x84a: 0x0001, 0x84b: 0x0001,
	0x84c: 0x0001, 0x84d: 0x0001, 0x84f: 0x0001, 0x850: 0x0001, 0x851: 0x0001,
	0x853: 0x0001, 0x854: 0x0001, 0x855: 0x0001, 0x856: 0x0001, 0x857: 0x0001,
	0x858: 0x0001, 0x859: 0x0001, 0x85a: 0x0001, 0x85b: 0x0001, 0x85c: 0x0001, 0x85d: 0x0001,
	0x85e: 0x0001, 0x85f: 0x0001, 0x860: 0x0001, 0x861: 0x0001, 0x862: 0x0001, 0x863: 0x0001,
	0x864: 0x0001, 0x865: 0x0001, 0x866: 0x0001, 0x867: 0x0001, 0x868: 0x0001,
	0x86a: 0x0001, 0x86b: 0x0001, 0x86c: 0x0001, 0x86d: 0x0001, 0x86e: 0x0001, 0x86f: 0x0001,
	0x870: 0x0001, 0x872: 0x0001, 0x873: 0x0001, 0x875: 0x0001,
	0x876: 0x0001, 0x877: 0x0001, 0x878: 0x0001, 0x879: 0x0001,
	0x87c: 0x0010, 0x87d: 0x0001, 0x87e: 0x0010, 0x87f: 0x0010,
	// Block 0x22, offset 0x880
	0x880: 0x0010, 0x881: 0x0010, 0x882: 0x0010, 0x883: 0x0010, 0x884: 0x0010, 0x885: 0x0010,
	0x887: 0x0010, 0x888: 0x0010, 0x889: 0x0010, 0x88b: 0x0010,
	0x88c: 0x0010, 0x88d: 0x0010, 0x890: 0x0001,
	0x8a0: 0x0001, 0x8a1: 0x0001, 0x8a2: 0x0010, 0x8a3: 0x0010,
	0x8a6: 0x8000, 0x8a7: 0x8000, 0x8a8: 0x8000, 0x8a9: 0x8000,
	0x8aa: 0x8000, 0x8ab: 0x8000, 0x8ac: 0x8000, 0x8ad: 0x8000, 0x8ae: 0x8000, 0x8af: 0x8000,
	0x8b9: 0x0001, 0x8ba: 0x0010, 0x8bb: 0x0010,
	0x8bc: 0x0010, 0x8bd: 0x0010, 0x8be: 0x0010, 0x8bf: 0x0010,
	// Block 0x23, offset 0x8c0
	0x8c1: 0x0010, 0x8c2: 0x0010, 0x8c3: 0x0010, 0x8c5: 0x0001,
	0x8c6: 0x0001, 0x8c7: 0x0001, 0x8c8: 0x0001, 0x8c9: 0x0001, 0x8ca: 0x0001, 0x8cb: 0x0001,
	0x8cc: 0x0001, 0x8cf: 0x0001, 0x8d0: 0x0001,
	0x8d3: 0x0001, 0x8d4: 0x0001, 0x8d5: 0x0001, 0x8d6: 0x0001, 0x8d7: 0x0001,
	0x8d8: 0x0001, 0x8d9: 0x0001, 0x8da: 0x0001, 0x8db: 0x0001, 0x8dc: 0x0001, 0x8dd: 0x0001,
	0x8de: 0x0001, 0x8df: 0x0001, 0x8e0: 0x0001, 0x8e1: 0x0001, 0x8e2: 0x0001, 0x8e3: 0x0001,
	0x8e4: 0x0001, 0x8e5: 0x0001, 0x8e6: 0x0001, 0x8e7: 0x0001, 0x8e8: 0x0001,
	0x8ea: 0x0001, 0x8eb: 0x0001, 0x8ec: 0x0001, 0x8ed: 0x0001, 0x8ee: 0x0001, 0x8ef: 0x0001,
	0x8f0: 0x0001, 0x8f2: 0x0001, 0x8f3: 0x0001, 0x8f5: 0x0001,
	0x8f6: 0x0001, 0x8f7: 0x0001, 0x8f8: 0x0001, 0x8f9: 0x0001,
	0x8fc: 0x0010, 0x8fd: 0x0001, 0x8fe: 0x0010, 0x8ff: 0x0010,
	// Block 0x24, offset 0x900
	0x900: 0x0010, 0x901: 0x0010, 0x902: 0x0010, 0x903: 0x0010, 0x904: 0x0010,
	0x907: 0x0010, 0x908: 0x0010, 0x90b: 0x0010,
	0x90c: 0x0010, 0x90d: 0x0010,
	0x915: 0x0010, 0x916: 0x0010, 0x917: 0x0010,
	0x91c: 0x0001, 0x91d: 0x0001,
	0x91f: 0x0001, 0x920: 0x0001, 0x921: 0x0001, 0x922: 0x0010, 0x923: 0x0010,
	0x926: 0x8000, 0x927: 0x8000, 0x928: 0x8000, 0x929: 0x8000,
	0x92a: 0x8000, 0x92b: 0x8000, 0x92c: 0x8000, 0x92d: 0x8000, 0x92e: 0x8000, 0x92f: 0x8000,
	0x931: 0x0001,
	// Block 0x25, offset 0x940
	0x942: 0x0010, 0x943: 0x0001, 0x945: 0x0001,
	0x946: 0x0001, 0x947: 0x0001, 0x948: 0x0001, 0x949: 0x0001, 0x94a: 0x0001,
	0x94e: 0x0001, 0x94f: 0x0001, 0x950: 0x0001,
	0x952: 0x0001, 0x953: 0x0001, 0x954: 0x0001, 0x955: 0x0001,
	0x959: 0x0001, 0x95a: 0x0001, 0x95c: 0x0001,
	0x95e: 0x0001, 0x95f: 0x0001, 0x963: 0x0001,
	0x964: 0x0001, 0x968: 0x0001, 0x969: 0x0001,
	0x96a: 0x0001, 0x96e: 0x0001, 0x96f: 0x0001,
	0x970: 0x0001, 0x971: 0x0001, 0x972: 0x0001, 0x973: 0x0001, 0x974: 0x0001, 0x975: 0x0001,
	0x976: 0x0001, 0x977: 0x0001, 0x978: 0x0001, 0x979: 0x0001,
	0x97e: 0x0010, 0x97f: 0x0010,
	// Block 0x26, offset 0x980
	0x980: 0x0010, 0x981: 0x0010, 0x982: 0x0010,
	0x986: 0x0010, 0x987: 0x0010, 0x988: 0x0010, 0x98a: 0x0010, 0x98b: 0x0010,
	0x98c: 0x0010, 0x98d: 0x0010, 0x990: 0x0001,
	0x997: 0x0010,
	0x9a6: 0x8000, 0x9a7: 0x8000, 0x9a8: 0x8000, 0x9a9: 0x8000,
	0x9aa: 0x8000, 0x9ab: 0x8000, 0x9ac: 0x8000, 0x9ad: 0x8000, 0x9ae: 0x8000, 0x9af: 0x8000,
	// Block 0x27, offset 0x9c0
	0x9c0: 0x0010, 0x9c1: 0x0010, 0x9c2: 0x0010, 0x9c3: 0x0010, 0x9c4: 0x0010, 0x9c5: 0x0001,
	0x9c6: 0x0001, 0x9c7: 0x0001, 0x9c8: 0x0001, 0x9c9: 0x0001, 0x9ca: 0x0001, 0x9cb: 0x0001,
	0x9cc: 0x0001, 0x9ce: 0x0001, 0x9cf: 0x0001, 0x9d0: 0x0001,
	0x9d2: 0x0001, 0x9d3: 0x0001, 0x9d4: 0x0001, 0x9d5: 0x0001, 0x9d6: 0x0001, 0x9d7: 0x0001,
	0x9d8: 0x0001, 0x9d9: 0x0001, 0x9da: 0x0001, 0x9db: 0x0001, 0x9dc: 0x0001, 0x9dd: 0x0001,
	0x9de: 0x0001, 0x9df: 0x0001, 0x9e0: 0x0001, 0x9e1: 0x0001, 0x9e2: 0x0001, 0x9e3: 0x0001,
	0x9e4: 0x0001, 0x9e5: 0x0001, 0x9e6: 0x0001, 0x9e7: 0x0001, 0x9e8: 0x0001,
	0x9ea: 0x0001, 0x9eb: 0x0001, 0x9ec: 0x0001, 0x9ed: 0x0001, 0x9ee: 0x0001, 0x9ef: 0x0001,
	0x9f0: 0x0001, 0x9f1: 0x0001, 0x9f2: 0x0001, 0x9f3: 0x0001, 0x9f4: 0x0001, 0x9f5: 0x0001,
	0x9f6: 0x0001, 0x9f7: 0x0001, 0x9f8: 0x0001, 0x9f9: 0x0001,
	0x9fc: 0x0010, 0x9fd: 0x0001, 0x9fe: 0x0010, 0x9ff: 0x0010,
	// Block 0x28, offset 0xa00
	0xa00: 0x0010, 0xa01: 0x0010, 0xa02: 0x0010, 0xa03: 0x0010, 0xa04: 0x0010,
	0xa06: 0x0010, 0xa07: 0x0010, 0xa08: 0x0010, 0xa0a: 0x0010, 0xa0b: 0x0010,
	0xa0c: 0x0010, 0xa0d: 0x0010,
	0xa15: 0x0010, 0xa16: 0x0010,
	0xa18: 0x0001, 0xa19: 0x0001, 0xa1a: 0x0001, 0xa1d: 0x0001,
	0xa20: 0x0001, 0xa21: 0x0001, 0xa22: 0x0010, 0xa23: 0x0010,
	0xa26: 0x8000, 0xa27: 0x8000, 0xa28: 0x8000, 0xa29: 0x8000,
	0xa2a: 0x8000, 0xa2b: 0x8000, 0xa2c: 0x8000, 0xa2d: 0x8000, 0xa2e: 0x8000, 0xa2f: 0x8000,
	// Block 0x29, offset 0xa40
	0xa40: 0x0001, 0xa41: 0x0010, 0xa42: 0x0010, 0xa43: 0x0010, 0xa45: 0x0001,
	0xa46: 0x0001, 0xa47: 0x0001, 0xa48: 0x0001, 0xa49: 0x0001, 0xa4a: 0x0001, 0xa4b: 0x0001,
	0xa4c: 0x0001, 0xa4e: 0x0001, 0xa4f: 0x0001, 0xa50: 0x0001,
	0xa52: 0x0001, 0xa53: 0x0001, 0xa54: 0x0001, 0xa55: 0x0001, 0xa56: 0x0001, 0xa57: 0x0001,
	0xa58: 0x0001, 0xa59: 0x0001, 0xa5a: 0x0001, 0xa5b: 0x0001, 0xa5c: 0x0001, 0xa5d: 0x0001,
	0xa5e: 0x0001, 0xa5f: 0x0001, 0xa60: 0x0001, 0xa61: 0x0001, 0xa62: 0x0001, 0xa63: 0x0001,
	0xa64: 0x0001, 0xa65: 0x0001, 0xa66: 0x0001, 0xa67: 0x0001, 0xa68: 0x0001,
	0xa6a: 0x0001, 0xa6b: 0x0001, 0xa6c: 0x0001, 0xa6d: 0x0001, 0xa6e: 0x0001, 0xa6f: 0x0001,
	0xa70: 0x0001, 0xa71: 0x0001, 0xa72: 0x0001, 0xa73: 0x0001, 0xa75: 0x0001,
	0xa76: 0x0001, 0xa77: 0x0001, 0xa78: 0x0001, 0xa79: 0x0001,
	0xa7c: 0x0010, 0xa7d: 0x0001, 0xa7e: 0x0010, 0xa7f: 0x0010,
	// Block 0x2a, offset 0xa80
	0xa80: 0x0010, 0xa81: 0x0010, 0xa82: 0x0010, 0xa83: 0x0010, 0xa84: 0x0010,
	0xa86: 0x0010, 0xa87: 0x0010, 0xa88: 0x0010, 0xa8a: 0x0010, 0xa8b: 0x0010,
	0xa8c: 0x0010, 0xa8d: 0x0010,
	0xa95: 0x0010, 0xa96: 0x0010,
	0xa9d: 0x0001,
	0xa9e: 0x0001, 0xaa0: 0x0001, 0xaa1: 0x0001, 0xaa2: 0x0010, 0xaa3: 0x0010,
	0xaa6: 0x8000, 0xaa7: 0x8000, 0xaa8: 0x8000, 0xaa9: 0x8000,
	0xaaa: 0x8000, 0xaab: 0x8000, 0xaac: 0x8000, 0xaad: 0x8000, 0xaae: 0x8000, 0xaaf: 0x8000,
	0xab1: 0x0001, 0xab2: 0x0001, 0xab3: 0x0010,
	// Block 0x2b, offset 0xac0
	0xac0: 0x0010, 0xac1: 0x0010, 0xac2: 0x0010, 0xac3: 0x0010, 0xac4: 0x0001, 0xac5: 0x0001,
	0xac6: 0x0001, 0xac7: 0x0001, 0xac8: 0x0001, 0xac9: 0x0001, 0xaca: 0x0001, 0xacb: 0x0001,
	0xacc: 0x0001, 0xace: 0x0001, 0xacf: 0x0001, 0xad0: 0x0001,
	0xad2: 0x0001, 0xad3: 0x0001, 0xad4: 0x0001, 0xad5: 0x0001, 0xad6: 0x0001, 0xad7: 0x0001,
	0xad8: 0x0001, 0xad9: 0x0001, 0xada: 0x0001, 0xadb: 0x0001, 0xadc: 0x0001, 0xadd: 0x0001,
	0xade: 0x0001, 0xadf: 0x0001, 0xae0: 0x0001, 0xae1: 0x0001, 0xae2: 0x0001, 0xae3: 0x0001,
	0xae4: 0x0001, 0xae5: 0x0001, 0xae6: 0x0001, 0xae7: 0x0001, 0xae8: 0x0001, 0xae9: 0x0001,
	0xaea: 0x0001, 0xaeb: 0x0001, 0xaec: 0x0001, 0xaed: 0x0001, 0xaee: 0x0001, 0xaef: 0x0001,
	0xaf0: 0x0001, 0xaf1: 0x0001, 0xaf2: 0x0001, 0xaf3: 0x0001, 0xaf4: 0x0001, 0xaf5: 0x0001,
	0xaf6: 0x0001, 0xaf7: 0x0001, 0xaf8: 0x0001, 0xaf9: 0x0001, 0xafa: 0x0001, 0xafb: 0x0010,
	0xafc: 0x0010, 0xafd: 0x0001, 0xafe: 0x0010, 0xaff: 0x0010,
	// Block 0x2c, offset 0xb00
	0xb00: 0x0010, 0xb01: 0x0010, 0xb02: 0x0010, 0xb03: 0x0010, 0xb04: 0x0010,
	0xb06: 0x0010, 0xb07: 0x0010, 0xb08: 0x0010, 0xb0a: 0x0010, 0xb0b: 0x0010,
	0xb0c: 0x0010, 0xb0d: 0x0010, 0xb0e: 0x0001,
	0xb14: 0x0001, 0xb15: 0x0001, 0xb16: 0x0001, 0xb17: 0x0010,
	0xb1f: 0x0001, 0xb20: 0x0001, 0xb21: 0x0001, 0xb22: 0x0010, 0xb23: 0x0010,
	0xb26: 0x8000, 0xb27: 0x8000, 0xb28: 0x8000, 0xb29: 0x8000,
	0xb2a: 0x8000, 0xb2b: 0x8000, 0xb2c: 0x8000, 0xb2d: 0x8000, 0xb2e: 0x8000, 0xb2f: 0x8000,
	0xb3a: 0x0001, 0xb3b: 0x0001,
	0xb3c: 0x0001, 0xb3d: 0x0001, 0xb3e: 0x0001, 0xb3f: 0x0001,
	// Block 0x2d, offset 0xb40
	0xb41: 0x0010, 0xb42: 0x0010, 0xb43: 0x0010, 0xb45: 0x0001,
	0xb46: 0x0001, 0xb47: 0x0001, 0xb48: 0x0001, 0xb49: 0x0001, 0xb4a: 0x0001, 0xb4b: 0x0001,
	0xb4c: 0x0001, 0xb4d: 0x0001, 0xb4e: 0x0001, 0xb4f: 0x0001, 0xb50: 0x0001, 0xb51: 0x0001,
	0xb52: 0x0001, 0xb53: 0x0001, 0xb54: 0x0001, 0xb55: 0x0001, 0xb56: 0x0001,
	0xb5a: 0x0001, 0xb5b: 0x0001, 0xb5c: 0x0001, 0xb5d: 0x0001,
	0xb5e: 0x0001, 0xb5f: 0x0001, 0xb60: 0x0001, 0xb61: 0x0001, 0xb62: 0x0001, 0xb63: 0x0001,
	0xb64: 0x0001, 0xb65: 0x0001, 0xb66: 0x0001, 0xb67: 0x0001, 0xb68: 0x0001, 0xb69: 0x0001,
	0xb6a: 0x0001, 0xb6b: 0x0001, 0xb6c: 0x0001, 0xb6d: 0x0001, 0xb6e: 0x0001, 0xb6f: 0x0001,
	0xb70: 0x0001, 0xb71: 0x0001, 0xb73: 0x0001, 0xb74: 0x0001, 0xb75: 0x0001,
	0xb76: 0x0001, 0xb77: 0x0001, 0xb78: 0x0001, 0xb79: 0x0001, 0xb7a: 0x0001, 0xb7b: 0x0001,
	0xb7d: 0x0001,
	// Block 0x2e, offset 0xb80
	0xb80: 0x0001, 0xb81: 0x0001, 0xb82: 0x0001, 0xb83: 0x0001, 0xb84: 0x0001, 0xb85: 0x0001,
	0xb86: 0x0001, 0xb8a: 0x0010,
	0xb8f: 0x0010, 0xb90: 0x0010, 0xb91: 0x0010,
	0xb92: 0x0010, 0xb93: 0x0010, 0xb94: 0x0010, 0xb96: 0x0010,
	0xb98: 0x0010, 0xb99: 0x0010, 0xb9a: 0x0010, 0xb9b: 0x0010, 0xb9c: 0x0010, 0xb9d: 0x0010,
	0xb9e: 0x0010, 0xb9f: 0x0010,
	0xba6: 0x8000, 0xba7: 0x8000, 0xba8: 0x8000, 0xba9: 0x8000,
	0xbaa: 0x8000, 0xbab: 0x8000, 0xbac: 0x8000, 0xbad: 0x8000, 0xbae: 0x8000, 0xbaf: 0x8000,
	0xbb2: 0x0010, 0xbb3: 0x0010,
	// Block 0x2f, offset 0xbc0
	0xbf1: 0x0010, 0xbf4: 0x0010, 0xbf5: 0x0010,
	0xbf6: 0x0010, 0xbf7: 0x0010, 0xbf8: 0x0010, 0xbf9: 0x0010, 0xbfa: 0x0010,
	// Block 0x30, offset 0xc00
	0xc07: 0x0010, 0xc08: 0x0010, 0xc09: 0x0010, 0xc0a: 0x0010, 0xc0b: 0x0010,
	0xc0c: 0x0010, 0xc0d: 0x0010, 0xc0e: 0x0010, 0xc10: 0x8000, 0xc11: 0x8000,
	0xc12: 0x8000, 0xc13: 0x8000, 0xc14: 0x8000, 0xc15: 0x8000, 0xc16: 0x8000, 0xc17: 0x8000,
	0xc18: 0x8000, 0xc19: 0x8000,
	// Block 0x31, offset 0xc40
	0xc71: 0x0010, 0xc74: 0x0010, 0xc75: 0x0010,
	0xc76: 0x0010, 0xc77: 0x0010, 0xc78: 0x0010, 0xc79: 0x0010, 0xc7a: 0x0010, 0xc7b: 0x0010,
	0xc7c: 0x0010,
	// Block 0x32, offset 0xc80
	0xc88: 0x0010, 0xc89: 0x0010, 0xc8a: 0x0010, 0xc8b: 0x0010,
	0xc8c: 0x0010, 0xc8d: 0x0010, 0xc8e: 0x0010, 0xc90: 0x8000, 0xc91: 0x8000,
	0xc92: 0x8000, 0xc93: 0x8000, 0xc94: 0x8000, 0xc95: 0x8000, 0xc96: 0x8000, 0xc97: 0x8000,
	0xc98: 0x8000, 0xc99: 0x8000,
	// Block 0x33, offset 0xcc0
	0xcc0: 0x0001,
	0xcd8: 0x0010, 0xcd9: 0x0010,
	0xce0: 0x8000, 0xce1: 0x8000, 0xce2: 0x8000, 0xce3: 0x8000,
	0xce4: 0x8000, 0xce5: 0x8000, 0xce6: 0x8000, 0xce7: 0x8000, 0xce8: 0x8000, 0xce9: 0x8000,
	0xcf5: 0x0010,
	0xcf7: 0x0010, 0xcf9: 0x0010,
	0xcfe: 0x0010, 0xcff: 0x0010,
	// Block 0x34, offset 0xd00
	0xd00: 0x0001, 0xd01: 0x0001, 0xd02: 0x0001, 0xd03: 0x0001, 0xd04: 0x0001, 0xd05: 0x0001,
	0xd06: 0x0001, 0xd07: 0x0001, 0xd09: 0x0001, 0xd0a: 0x0001, 0xd0b: 0x0001,
	0xd0c: 0x0001, 0xd0d: 0x0001, 0xd0e: 0x0001, 0xd0f: 0x0001, 0xd10: 0x0001, 0xd11: 0x0001,
	0xd12: 0x0001, 0xd13: 0x0001, 0xd14: 0x0001, 0xd15: 0x0001, 0xd16: 0x0001, 0xd17: 0x0001,
	0xd18: 0x0001, 0xd19: 0x0001, 0xd1a: 0x0001, 0xd1b: 0x0001, 0xd1c: 0x0001, 0xd1d: 0x0001,
	0xd1e: 0x0001, 0xd1f: 0x0001, 0xd20: 0x0001, 0xd21: 0x0001, 0xd22: 0x0001, 0xd23: 0x0001,
	0xd24: 0x0001, 0xd25: 0x0001, 0xd26: 0x0001, 0xd27: 0x0001, 0xd28: 0x0001, 0xd29: 0x0001,
	0xd2a: 0x0001, 0xd2b: 0x0001, 0xd2c: 0x0001,
	0xd31: 0x0010, 0xd32: 0x0010, 0xd33: 0x0010, 0xd34: 0x0010, 0xd35: 0x0010,
	0xd36: 0x0010, 0xd37: 0x0010, 0xd38: 0x0010, 0xd39: 0x0010, 0xd3a: 0x0010, 0xd3b: 0x0010,
	0xd3c: 0x0010, 0xd3d: 0x0010, 0xd3e: 0x0010, 0xd3f: 0x0010,
	// Block 0x35, offset 0xd40
	0xd40: 0x0010, 0xd41: 0x0010, 0xd42: 0x0010, 0xd43: 0x0010, 0xd44: 0x0010,
	0xd46: 0x0010, 0xd47: 0x0010, 0xd48: 0x0001, 0xd49: 0x0001, 0xd4a: 0x0001, 0xd4b: 0x0001,
	0xd4c: 0x0001, 0xd4d: 0x0010, 0xd4e: 0x0010, 0xd4f: 0x0010, 0xd50: 0x0010, 0xd51: 0x0010,
	0xd52: 0x0010, 0xd53: 0x0010, 0xd54: 0x0010, 0xd55: 0x0010, 0xd56: 0x0010, 0xd57: 0x0010,
	0xd59: 0x0010, 0xd5a: 0x0010, 0xd5b: 0x0010, 0xd5c: 0x0010, 0xd5d: 0x0010,
	0xd5e: 0x0010, 0xd5f: 0x0010, 0xd60: 0x0010, 0xd61: 0x0010, 0xd62: 0x0010, 0xd63: 0x0010,
	0xd64: 0x0010, 0xd65: 0x0010, 0xd66: 0x0010, 0xd67: 0x0010, 0xd68: 0x0010, 0xd69: 0x0010,
	0xd6a: 0x0010, 0xd6b: 0x0010, 0xd6c: 0x0010, 0xd6d: 0x0010, 0xd6e: 0x0010, 0xd6f: 0x0010,
	0xd70: 0x0010, 0xd71: 0x0010, 0xd72: 0x0010, 0xd73: 0x0010, 0xd74: 0x0010, 0xd75: 0x0010,
	0xd76: 0x0010, 0xd77: 0x0010, 0xd78: 0x0010, 0xd79: 0x0010, 0xd7a: 0x0010, 0xd7b: 0x0010,
	0xd7c: 0x0010,
	// Block 0x36, offset 0xd80
	0xd86: 0x0010,
	// Block 0x37, offset 0xdc0
	0xdeb: 0x0010, 0xdec: 0x0010, 0xded: 0x0010, 0xdee: 0x0010, 0xdef: 0x0010,
	0xdf0: 0x0010, 0xdf1: 0x0010, 0xdf2: 0x0010, 0xdf3: 0x0010, 0xdf4: 0x0010, 0xdf5: 0x0010,
	0xdf6: 0x0010, 0xdf7: 0x0010, 0xdf8: 0x0010, 0xdf9: 0x0010, 0xdfa: 0x0010, 0xdfb: 0x0010,
	0xdfc: 0x0010, 0xdfd: 0x0010, 0xdfe: 0x0010,
	// Block 0x38, offset 0xe00
	0xe00: 0x8000, 0xe01: 0x8000, 0xe02: 0x8000, 0xe03: 0x8000, 0xe04: 0x8000, 0xe05: 0x8000,
	0xe06: 0x8000, 0xe07: 0x8000, 0xe08: 0x8000, 0xe09: 0x8000,
	0xe16: 0x0010, 0xe17: 0x0010,
	0xe18: 0x0010, 0xe19: 0x0010,
	0xe1e: 0x0010, 0xe1f: 0x0010, 0xe20: 0x0010, 0xe22: 0x0010, 0xe23: 0x0010,
	0xe24: 0x0010, 0xe27: 0x0010, 0xe28: 0x0010, 0xe29: 0x0010,
	0xe2a: 0x0010, 0xe2b: 0x0010, 0xe2c: 0x0010, 0xe2d: 0x0010,
	0xe31: 0x0010, 0xe32: 0x0010, 0xe33: 0x0010, 0xe34: 0x0010,
	// Block 0x39, offset 0xe40
	0xe42: 0x0010, 0xe43: 0x0010, 0xe44: 0x0010, 0xe45: 0x0010,
	0xe46: 0x0010, 0xe47: 0x0010, 0xe48: 0x0010, 0xe49: 0x0010, 0xe4a: 0x0010, 0xe4b: 0x0010,
	0xe4c: 0x0010, 0xe4d: 0x0010, 0xe4f: 0x0010, 0xe50: 0x8000, 0xe51: 0x8000,
	0xe52: 0x8000, 0xe53: 0x8000, 0xe54: 0x8000, 0xe55: 0x8000, 0xe56: 0x8000, 0xe57: 0x8000,
	0xe58: 0x8000, 0xe59: 0x8000, 0xe5a: 0x0010, 0xe5b: 0x0010, 0xe5c: 0x0010, 0xe5d: 0x0010,
	0xe60: 0x0001, 0xe61: 0x0001, 0xe62: 0x0001, 0xe63: 0x0001,
	0xe64: 0x0001, 0xe65: 0x0001, 0xe66: 0x0001, 0xe67: 0x0001, 0xe68: 0x0001, 0xe69: 0x0001,
	0xe6a: 0x0001, 0xe6b: 0x0001, 0xe6c: 0x0001, 0xe6d: 0x0001, 0xe6e: 0x0001, 0xe6f: 0x0001,
	0xe70: 0x0001, 0xe71: 0x0001, 0xe72: 0x0001, 0xe73: 0x0001, 0xe74: 0x0001, 0xe75: 0x0001,
	0xe76: 0x0001, 0xe77: 0x0001, 0xe78: 0x0001, 0xe79: 0x0001, 0xe7a: 0x0001, 0xe7b: 0x0001,
	0xe7c: 0x0001, 0xe7d: 0x0001, 0xe7e: 0x0001, 0xe7f: 0x0001,
	// Block 0x3a, offset 0xe80
	0xe80: 0x0001, 0xe81: 0x0001, 0xe82: 0x0001, 0xe83: 0x0001, 0xe84: 0x0001, 0xe85: 0x0001,
	0xe87: 0x0001,
	0xe8d: 0x0001, 0xe90: 0x0001, 0xe91: 0x0001,
	0xe92: 0x0001, 0xe93: 0x0001, 0xe94: 0x0001, 0xe95: 0x0001, 0xe96: 0x0001, 0xe97: 0x0001,
	0xe98: 0x0001, 0xe99: 0x0001, 0xe9a: 0x0001, 0xe9b: 0x0001, 0xe9c: 0x0001, 0xe9d: 0x0001,
	0xe9e: 0x0001, 0xe9f: 0x0001, 0xea0: 0x0001, 0xea1: 0x0001, 0xea2: 0x0001, 0xea3: 0x0001,
	0xea4: 0x0001, 0xea5: 0x0001, 0xea6: 0x0001, 0xea7: 0x0001, 0xea8: 0x0001, 0xea9: 0x0001,
	0xeaa: 0x0001, 0xeab: 0x0001, 0xeac: 0x0001, 0xead: 0x0001, 0xeae: 0x0001, 0xeaf: 0x0001,
	0xeb0: 0x0001, 0xeb1: 0x0001, 0xeb2: 0x0001, 0xeb3: 0x0001, 0xeb4: 0x0001, 0xeb5: 0x0001,
	0xeb6: 0x0001, 0xeb7: 0x0001, 0xeb8: 0x0001, 0xeb9: 0x0001, 0xeba: 0x0001,
	0xebc: 0x0001, 0xebd: 0x0001, 0xebe: 0x0001, 0xebf: 0x0001,
	// Block 0x3b, offset 0xec0
	0xec0: 0x0001, 0xec1: 0x0001, 0xec2: 0x0001, 0xec3: 0x0001, 0xec4: 0x0001, 0xec5: 0x0001,
	0xec6: 0x0001, 0xec7: 0x0001, 0xec8: 0x0001, 0xeca: 0x0001, 0xecb: 0x0001,
	0xecc: 0x0001, 0xecd: 0x0001, 0xed0: 0x0001, 0xed1: 0x0001,
	0xed2: 0x0001, 0xed3: 0x0001, 0xed4: 0x0001, 0xed5: 0x0001, 0xed6: 0x0001,
	0xed8: 0x0001, 0xeda: 0x0001, 0xedb: 0x0001, 0xedc: 0x0001, 0xedd: 0x0001,
	0xee0: 0x0001, 0xee1: 0x0001, 0xee2: 0x0001, 0xee3: 0x0001,
	0xee4: 0x0001, 0xee5: 0x0001, 0xee6: 0x0001, 0xee7: 0x0001, 0xee8: 0x0001, 0xee9: 0x0001,
	0xeea: 0x0001, 0xeeb: 0x0001, 0xeec: 0x0001, 0xeed: 0x0001, 0xeee: 0x0001, 0xeef: 0x0001,
	0xef0: 0x0001, 0xef1: 0x0001, 0xef2: 0x0001, 0xef3: 0x0001, 0xef4: 0x0001, 0xef5: 0x0001,
	0xef6: 0x0001, 0xef7: 0x0001, 0xef8: 0x0001, 0xef9: 0x0001, 0xefa: 0x0001, 0xefb: 0x0001,
	0xefc: 0x0001, 0xefd: 0x0001, 0xefe: 0x0001, 0xeff: 0x0001,
	// Block 0x3c, offset 0xf00
	0xf00: 0x0001, 0xf01: 0x0001, 0xf02: 0x0001, 0xf03: 0x0001, 0xf04: 0x0001, 0xf05: 0x0001,
	0xf06: 0x0001, 0xf07: 0x0001, 0xf08: 0x0001, 0xf0a: 0x0001, 0xf0b: 0x0001,
	0xf0c: 0x0001, 0xf0d: 0x0001, 0xf10: 0x0001, 0xf11: 0x0001,
	0xf12: 0x0001, 0xf13: 0x0001, 0xf14: 0x0001, 0xf15: 0x0001, 0xf16: 0x0001, 0xf17: 0x0001,
	0xf18: 0x0001, 0xf19: 0x0001, 0xf1a: 0x0001, 0xf1b: 0x0001, 0xf1c: 0x0001, 0xf1d: 0x0001,
	0xf1e: 0x0001, 0xf1f: 0x0001, 0xf20: 0x0001, 0xf21: 0x0001, 0xf22: 0x0001, 0xf23: 0x0001,
	0xf24: 0x0001, 0xf25: 0x0001, 0xf26: 0x0001, 0xf27: 0x0001, 0xf28: 0x0001, 0xf29: 0x0001,
	0xf2a: 0x0001, 0xf2b: 0x0001, 0xf2c: 0x0001, 0xf2d: 0x0001, 0xf2e: 0x0001, 0xf2f: 0x0001,
	0xf30: 0x0001, 0xf32: 0x0001, 0xf33: 0x0001, 0xf34: 0x0001, 0xf35: 0x0001,
	0xf38: 0x0001, 0xf39: 0x0001, 0xf3a: 0x0001, 0xf3b: 0x0001,
	0xf3c: 0x0001, 0xf3d: 0x0001, 0xf3e: 0x0001,
	// Block 0x3d, offset 0xf40
	0xf40: 0x0001, 0xf42: 0x0001, 0xf43: 0x0001, 0xf44: 0x0001, 0xf45: 0x0001,
	0xf48: 0x0001, 0xf49: 0x0001, 0xf4a: 0x0001, 0xf4b: 0x0001,
	0xf4c: 0x0001, 0xf4d: 0x0001, 0xf4e: 0x0001, 0xf4f: 0x0001, 0xf50: 0x0001, 0xf51: 0x0001,
	0xf52: 0x0001, 0xf53: 0x0001, 0xf54: 0x0001, 0xf55: 0x0001, 0xf56: 0x0001,
	0xf58: 0x0001, 0xf59: 0x0001, 0xf5a: 0x0001, 0xf5b: 0x0001, 0xf5c: 0x0001, 0xf5d: 0x0001,
	0xf5e: 0x0001, 0xf5f: 0x0001, 0xf60: 0x0001, 0xf61: 0x0001, 0xf62: 0x0001, 0xf63: 0x0001,
	0xf64: 0x0001, 0xf65: 0x0001, 0xf66: 0x0001, 0xf67: 0x0001, 0xf68: 0x0001, 0xf69: 0x0001,
	0xf6a: 0x0001, 0xf6b: 0x0001, 0xf6c: 0x0001, 0xf6d: 0x0001, 0xf6e: 0x0001, 0xf6f: 0x0001,
	0xf70: 0x0001, 0xf71: 0x0001, 0xf72: 0x0001, 0xf73: 0x0001, 0xf74: 0x0001, 0xf75: 0x0001,
	0xf76: 0x0001, 0xf77: 0x0001, 0xf78: 0x0001, 0xf79: 0x0001, 0xf7a: 0x0001, 0xf7b: 0x0001,
	0xf7c: 0x0001, 0xf7d: 0x0001, 0xf7e: 0x0001, 0xf7f: 0x0001,
	// Block 0x3e, offset 0xf80
	0xf80: 0x0001, 0xf81: 0x0001, 0xf82: 0x0001, 0xf83: 0x0001, 0xf84: 0x0001, 0xf85: 0x0001,
	0xf86: 0x0001, 0xf87: 0x0001, 0xf88: 0x0001, 0xf89: 0x0001, 0xf8a: 0x0001, 0xf8b: 0x0001,
	0xf8c: 0x0001, 0xf8d: 0x0001, 0xf8e: 0x0001, 0xf8f: 0x0001, 0xf90: 0x0001,
	0xf92: 0x0001, 0xf93: 0x0001, 0xf94: 0x0001, 0xf95: 0x0001,
	0xf98: 0x0001, 0xf99: 0x0001, 0xf9a: 0x0001, 0xf9b: 0x0001, 0xf9c: 0x0001, 0xf9d: 0x0001,
	0xf9e: 0x0001, 0xf9f: 0x0001, 0xfa0: 0x0001, 0xfa1: 0x0001, 0xfa2: 0x0001, 0xfa3: 0x0001,
	0xfa4: 0x0001, 0xfa5: 0x0001, 0xfa6: 0x0001, 0xfa7: 0x0001, 0xfa8: 0x0001, 0xfa9: 0x0001,
	0xfaa: 0x0001, 0xfab: 0x0001, 0xfac: 0x0001, 0xfad: 0x0001, 0xfae: 0x0001, 0xfaf: 0x0001,
	0xfb0: 0x0001, 0xfb1: 0x0001, 0xfb2: 0x0001, 0xfb3: 0x0001, 0xfb4: 0x0001, 0xfb5: 0x0001,
	0xfb6: 0x0001, 0xfb7: 0x0001, 0xfb8: 0x0001, 0xfb9: 0x0001, 0xfba: 0x0001, 0xfbb: 0x0001,
	0xfbc: 0x0001, 0xfbd: 0x0001, 0xfbe: 0x0001, 0xfbf: 0x0001,
	// Block 0x3f, offset 0xfc0
	0xfc0: 0x0001, 0xfc1: 0x0001, 0xfc2: 0x0001, 0xfc3: 0x0001, 0xfc4: 0x0001, 0xfc5: 0x0001,
	0xfc6: 0x0001, 0xfc7: 0x0001, 0xfc8: 0x0001, 0xfc9: 0x0001, 0xfca: 0x0001, 0xfcb: 0x0001,
	0xfcc: 0x0001, 0xfcd: 0x0001, 0xfce: 0x0001, 0xfcf: 0x0001, 0xfd0: 0x0001, 0xfd1: 0x0001,
	0xfd2: 0x0001, 0xfd3: 0x0001, 0xfd4: 0x0001, 0xfd5: 0x0001, 0xfd6: 0x0001, 0xfd7: 0x0001,
	0xfd8: 0x0001, 0xfd9: 0x0001, 0xfda: 0x0001, 0xfdd: 0x0010,
	0xfde: 0x0010, 0xfdf: 0x0010,
	// Block 0x40, offset 0x1000
	0x1000: 0x0001, 0x1001: 0x0001, 0x1002: 0x0001, 0x1003: 0x0001, 0x1004: 0x0001, 0x1005: 0x0001,
	0x1006: 0x0001, 0x1007: 0x0001, 0x1008: 0x0001, 0x1009: 0x0001, 0x100a: 0x0001, 0x100b: 0x0001,
	0x100c: 0x0001, 0x100d: 0x0001, 0x100e: 0x0001, 0x100f: 0x0001,
	0x1020: 0x0001, 0x1021: 0x0001, 0x1022: 0x0001, 0x1023: 0x0001,
	0x1024: 0x0001, 0x1025: 0x0001, 0x1026: 0x0001, 0x1027: 0x0001, 0x1028: 0x0001, 0x1029: 0x0001,
	0x102a: 0x0001, 0x102b: 0x0001, 0x102c: 0x0001, 0x102d: 0x0001, 0x102e: 0x0001, 0x102f: 0x0001,
	0x1030: 0x0001, 0x1031: 0x0001, 0x1032: 0x0001, 0x1033: 0x0001, 0x1034: 0x0001, 0x1035: 0x0001,
	0x1036: 0x0001, 0x1037: 0x0001, 0x1038: 0x0001, 0x1039: 0x0001, 0x103a: 0x0001, 0x103b: 0x0001,
	0x103c: 0x0001, 0x103d: 0x0001, 0x103e: 0x0001, 0x103f: 0x0001,
	// Block 0x41, offset 0x1040
	0x1040: 0x0001, 0x1041: 0x0001, 0x1042: 0x0001, 0x1043: 0x0001, 0x1044: 0x0001, 0x1045: 0x0001,
	0x1046: 0x0001, 0x1047: 0x0001, 0x1048: 0x0001, 0x1049: 0x0001, 0x104a: 0x0001, 0x104b: 0x0001,
	0x104c: 0x0001, 0x104d: 0x0001, 0x104e: 0x0001, 0x104f: 0x0001, 0x1050: 0x0001, 0x1051: 0x0001,
	0x1052: 0x0001, 0x1053: 0x0001, 0x1054: 0x0001, 0x1055: 0x0001, 0x1056: 0x0001, 0x1057: 0x0001,
	0x1058: 0x0001, 0x1059: 0x0001, 0x105a: 0x0001, 0x105b: 0x0001, 0x105c: 0x0001, 0x105d: 0x0001,
	0x105e: 0x0001, 0x105f: 0x0001, 0x1060: 0x0001, 0x1061: 0x0001, 0x1062: 0x0001, 0x1063: 0x0001,
	0x1064: 0x0001, 0x1065: 0x0001, 0x1066: 0x0001, 0x1067: 0x0001, 0x1068: 0x0001, 0x1069: 0x0001,
	0x106a: 0x0001, 0x106b: 0x0001, 0x106c: 0x0001, 0x106d: 0x0001, 0x106e: 0x0001, 0x106f: 0x0001,
	0x1070: 0x0001, 0x1071: 0x0001, 0x1072: 0x0001, 0x1073: 0x0001, 0x1074: 0x0001, 0x1075: 0x0001,
	0x1078: 0x0001, 0x1079: 0x0001, 0x107a: 0x0001, 0x107b: 0x0001,
	0x107c: 0x0001, 0x107d: 0x0001,
	// Block 0x42, offset 0x1080
	0x1081: 0x0001, 0x1082: 0x0001, 0x1083: 0x0001, 0x1084: 0x0001, 0x1085: 0x0001,
	0x1086: 0x0001, 0x1087: 0x0001, 0x1088: 0x0001, 0x1089: 0x0001, 0x108a: 0x0001, 0x108b: 0x0001,
	0x108c: 0x0001, 0x108d: 0x0001, 0x108e: 0x0001, 0x108f: 0x0001, 0x1090: 0x0001, 0x1091: 0x0001,
	0x1092: 0x0001, 0x1093: 0x0001, 0x1094: 0x0001, 0x1095: 0x0001, 0x1096: 0x0001, 0x1097: 0x0001,
	0x1098: 0x0001, 0x1099: 0x0001, 0x109a: 0x0001, 0x109b: 0x0001, 0x109c: 0x0001, 0x109d: 0x0001,
	0x109e: 0x0001, 0x109f: 0x0001, 0x10a0: 0x0001, 0x10a1: 0x0001, 0x10a2: 0x0001, 0x10a3: 0x0001,
	0x10a4: 0x0001, 0x10a5: 0x0001, 0x10a6: 0x0001, 0x10a7: 0x0001, 0x10a8: 0x0001, 0x10a9: 0x0001,
	0x10aa: 0x0001, 0x10ab: 0x0001, 0x10ac: 0x0001, 0x10ad: 0x0001, 0x10ae: 0x0001, 0x10af: 0x0001,
	0x10b0: 0x0001, 0x10b1: 0x0001, 0x10b2: 0x0001, 0x10b3: 0x0001, 0x10b4: 0x0001, 0x10b5: 0x0001,
	0x10b6: 0x0001, 0x10b7: 0x0001, 0x10b8: 0x0001, 0x10b9: 0x0001, 0x10ba: 0x0001, 0x10bb: 0x0001,
	0x10bc: 0x0001, 0x10bd: 0x0001, 0x10be: 0x0001, 0x10bf: 0x0001,
	// Block 0x43, offset 0x10c0
	0x10c0: 0x0001, 0x10c1: 0x0001, 0x10c2: 0x0001, 0x10c3: 0x0001, 0x10c4: 0x0001, 0x10c5: 0x0001,
	0x10c6: 0x0001, 0x10c7: 0x0001, 0x10c8: 0x0001, 0x10c9: 0x0001, 0x10ca: 0x0001, 0x10cb: 0x0001,
	0x10cc: 0x0001, 0x10cd: 0x0001, 0x10ce: 0x0001, 0x10cf: 0x0001, 0x10d0: 0x0001, 0x10d1: 0x0001,
	0x10d2: 0x0001, 0x10d3: 0x0001, 0x10d4: 0x0001, 0x10d5: 0x0001, 0x10d6: 0x0001, 0x10d7: 0x0001,
	0x10d8: 0x0001, 0x10d9: 0x0001, 0x10da: 0x0001, 0x10db: 0x0001, 0x10dc: 0x0001, 0x10dd: 0x0001,
	0x10de: 0x0001, 0x10df: 0x0001, 0x10e0: 0x0001, 0x10e1: 0x0001, 0x10e2: 0x0001, 0x10e3: 0x0001,
	0x10e4: 0x0001, 0x10e5: 0x0001, 0x10e6: 0x0001, 0x10e7: 0x0001, 0x10e8: 0x0001, 0x10e9: 0x0001,
	0x10ea: 0x0001, 0x10eb: 0x0001, 0x10ec: 0x0001, 0x10ef: 0x0001,
	0x10f0: 0x0001, 0x10f1: 0x0001, 0x10f2: 0x0001, 0x10f3: 0x0001, 0x10f4: 0x0001, 0x10f5: 0x0001,
	0x10f6: 0x0001, 0x10f7: 0x0001, 0x10f8: 0x0001, 0x10f9: 0x0001, 0x10fa: 0x0001, 0x10fb: 0x0001,
	0x10fc: 0x0001, 0x10fd: 0x0001, 0x10fe: 0x0001, 0x10ff: 0x0001,
	// Block 0x44, offset 0x1100
	0x1100: 0x40000, 0x1101: 0x0001, 0x1102: 0x0001, 0x1103: 0x0001, 0x1104: 0x0001, 0x1105: 0x0001,
	0x1106: 0x0001, 0x1107: 0x0001, 0x1108: 0x0001, 0x1109: 0x0001, 0x110a: 0x0001, 0x110b: 0x0001,
	0x110c: 0x0001, 0x110d: 0x0001, 0x110e: 0x0001, 0x110f: 0x0001, 0x1110: 0x0001, 0x1111: 0x0001,
	0x1112: 0x0001, 0x1113: 0x0001, 0x1114: 0x0001, 0x1115: 0x0001, 0x1116: 0x0001, 0x1117: 0x0001,
	0x1118: 0x0001, 0x1119: 0x0001, 0x111a: 0x0001,
	0x1120: 0x0001, 0x1121: 0x0001, 0x1122: 0x0001, 0x1123: 0x0001,
	0x1124: 0x0001, 0x1125: 0x0001, 0x1126: 0x0001, 0x1127: 0x0001, 0x1128: 0x0001, 0x1129: 0x0001,
	0x112a: 0x0001, 0x112b: 0x0001, 0x112c: 0x0001, 0x112d: 0x0001, 0x112e: 0x0001, 0x112f: 0x0001,
	0x1130: 0x0001, 0x1131: 0x0001, 0x1132: 0x0001, 0x1133: 0x0001, 0x1134: 0x0001, 0x1135: 0x0001,
	0x1136: 0x0001, 0x1137: 0x0001, 0x1138: 0x0001, 0x1139: 0x0001, 0x113a: 0x0001, 0x113b: 0x0001,
	0x113c: 0x0001, 0x113d: 0x0001, 0x113e: 0x0001, 0x113f: 0x0001,
	// Block 0x45, offset 0x1140
	0x1140: 0x0001, 0x1141: 0x0001, 0x1142: 0x0001, 0x1143: 0x0001, 0x1144: 0x0001, 0x1145: 0x0001,
	0x1146: 0x0001, 0x1147: 0x0001, 0x1148: 0x0001, 0x1149: 0x0001, 0x114a: 0x0001, 0x114b: 0x0001,
	0x114c: 0x0001, 0x114d: 0x0001, 0x114e: 0x0001, 0x114f: 0x0001, 0x1150: 0x0001, 0x1151: 0x0001,
	0x1152: 0x0001, 0x1153: 0x0001, 0x1154: 0x0001, 0x1155: 0x0001, 0x1156: 0x0001, 0x1157: 0x0001,
	0x1158: 0x0001, 0x1159: 0x0001, 0x115a: 0x0001, 0x115b: 0x0001, 0x115c: 0x0001, 0x115d: 0x0001,
	0x115e: 0x0001, 0x115f: 0x0001, 0x1160: 0x0001, 0x1161: 0x0001, 0x1162: 0x0001, 0x1163: 0x0001,
	0x1164: 0x0001, 0x1165: 0x0001, 0x1166: 0x0001, 0x1167: 0x0001, 0x1168: 0x0001, 0x1169: 0x0001,
	0x116a: 0x0001, 0x116e: 0x0001, 0x116f: 0x0001,
	0x1170: 0x0001, 0x1171: 0x0001, 0x1172: 0x0001, 0x1173: 0x0001, 0x1174: 0x0001, 0x1175: 0x0001,
	0x1176: 0x0001, 0x1177: 0x0001, 0x1178: 0x0001,
	// Block 0x46, offset 0x1180
	0x1180: 0x0001, 0x1181: 0x0001, 0x1182: 0x0001, 0x1183: 0x0001, 0x1184: 0x0001, 0x1185: 0x0001,
	0x1186: 0x0001, 0x1187: 0x0001, 0x1188: 0x0001, 0x1189: 0x0001, 0x118a: 0x0001, 0x118b: 0x0001,
	0x118c: 0x0001, 0x118d: 0x0001, 0x118e: 0x0001, 0x118f: 0x0001, 0x1190: 0x0001, 0x1191: 0x0001,
	0x1192: 0x0010, 0x1193: 0x0010, 0x1194: 0x0010, 0x1195: 0x0010,
	0x119f: 0x0001, 0x11a0: 0x0001, 0x11a1: 0x0001, 0x11a2: 0x0001, 0x11a3: 0x0001,
	0x11a4: 0x0001, 0x11a5: 0x0001, 0x11a6: 0x0001, 0x11a7: 0x0001, 0x11a8: 0x0001, 0x11a9: 0x0001,
	0x11aa: 0x0001, 0x11ab: 0x0001, 0x11ac: 0x0001, 0x11ad: 0x0001, 0x11ae: 0x0001, 0x11af: 0x0001,
	0x11b0: 0x0001, 0x11b1: 0x0001, 0x11b2: 0x0010, 0x11b3: 0x0010, 0x11b4: 0x0010,
	// Block 0x47, offset 0x11c0
	0x11c0: 0x0001, 0x11c1: 0x0001, 0x11c2: 0x0001, 0x11c3: 0x0001, 0x11c4: 0x0001, 0x11c5: 0x0001,
	0x11c6: 0x0001, 0x11c7: 0x0001, 0x11c8: 0x0001, 0x11c9: 0x0001, 0x11ca: 0x0001, 0x11cb: 0x0001,
	0x11cc: 0x0001, 0x11cd: 0x0001, 0x11ce: 0x0001, 0x11cf: 0x0001, 0x11d0: 0x0001, 0x11d1: 0x0001,
	0x11d2: 0x0010, 0x11d3: 0x0010,
	0x11e0: 0x0001, 0x11e1: 0x0001, 0x11e2: 0x0001, 0x11e3: 0x0001,
	0x11e4: 0x0001, 0x11e5: 0x0001, 0x11e6: 0x0001, 0x11e7: 0x0001, 0x11e8: 0x0001, 0x11e9: 0x0001,
	0x11ea: 0x0001, 0x11eb: 0x0001, 0x11ec: 0x0001, 0x11ee: 0x0001, 0x11ef: 0x0001,
	0x11f0: 0x0001, 0x11f2: 0x0010, 0x11f3: 0x0010,
	// Block 0x48, offset 0x1200
	0x1234: 0x0010, 0x1235: 0x0010,
	0x1236: 0x0010, 0x1237: 0x0010, 0x1238: 0x0010, 0x1239: 0x0010, 0x123a: 0x0010, 0x123b: 0x0010,
	0x123c: 0x0010, 0x123d: 0x0010, 0x123e: 0x0010, 0x123f: 0x0010,
	// Block 0x49, offset 0x1240
	0x1240: 0x0010, 0x1241: 0x0010, 0x1242: 0x0010, 0x1243: 0x0010, 0x1244: 0x0010, 0x1245: 0x0010,
	0x1246: 0x0010, 0x1247: 0x0010, 0x1248: 0x0010, 0x1249: 0x0010, 0x124a: 0x0010, 0x124b: 0x0010,
	0x124c: 0x0010, 0x124d: 0x0010, 0x124e: 0x0010, 0x124f: 0x0010, 0x1250: 0x0010, 0x1251: 0x0010,
	0x1252: 0x0010, 0x1253: 0x0010,
	0x125d: 0x0010,
	0x1260: 0x8000, 0x1261: 0x8000, 0x1262: 0x8000, 0x1263: 0x8000,
	0x1264: 0x8000, 0x1265: 0x8000, 0x1266: 0x8000, 0x1267: 0x8000, 0x1268: 0x8000, 0x1269: 0x8000,
	// Block 0x4a, offset 0x1280
	0x128b: 0x0010,
	0x128c: 0x0010, 0x128d: 0x0010, 0x128e: 0x0080, 0x128f: 0x0010, 0x1290: 0x8000, 0x1291: 0x8000,
	0x1292: 0x8000, 0x1293: 0x8000, 0x1294: 0x8000, 0x1295: 0x8000, 0x1296: 0x8000, 0x1297: 0x8000,
	0x1298: 0x8000, 0x1299: 0x8000,
	0x12a0: 0x0001, 0x12a1: 0x0001, 0x12a2: 0x0001, 0x12a3: 0x0001,
	0x12a4: 0x0001, 0x12a5: 0x0001, 0x12a6: 0x0001, 0x12a7: 0x0001, 0x12a8: 0x0001, 0x12a9: 0x0001,
	0x12aa: 0x0001, 0x12ab: 0x0001, 0x12ac: 0x0001, 0x12ad: 0x0001, 0x12ae: 0x0001, 0x12af: 0x0001,
	0x12b0: 0x0001, 0x12b1: 0x0001, 0x12b2: 0x0001, 0x12b3: 0x0001, 0x12b4: 0x0001, 0x12b5: 0x0001,
	0x12b6: 0x0001, 0x12b7: 0x0001, 0x12b8: 0x0001, 0x12b9: 0x0001, 0x12ba: 0x0001, 0x12bb: 0x0001,
	0x12bc: 0x0001, 0x12bd: 0x0001, 0x12be: 0x0001, 0x12bf: 0x0001,
	// Block 0x4b, offset 0x12c0
	0x12c0: 0x0001, 0x12c1: 0x0001, 0x12c2: 0x0001, 0x12c3: 0x0001, 0x12c4: 0x0001, 0x12c5: 0x0001,
	0x12c6: 0x0001, 0x12c7: 0x0001, 0x12c8: 0x0001, 0x12c9: 0x0001, 0x12ca: 0x0001, 0x12cb: 0x0001,
	0x12cc: 0x0001, 0x12cd: 0x0001, 0x12ce: 0x0001, 0x12cf: 0x0001, 0x12d0: 0x0001, 0x12d1: 0x0001,
	0x12d2: 0x0001, 0x12d3: 0x0001, 0x12d4: 0x0001, 0x12d5: 0x0001, 0x12d6: 0x0001, 0x12d7: 0x0001,
	0x12d8: 0x0001, 0x12d9: 0x0001, 0x12da: 0x0001, 0x12db: 0x0001, 0x12dc: 0x0001, 0x12dd: 0x0001,
	0x12de: 0x0001, 0x12df: 0x0001, 0x12e0: 0x0001, 0x12e1: 0x0001, 0x12e2: 0x0001, 0x12e3: 0x0001,
	0x12e4: 0x0001, 0x12e5: 0x0001, 0x12e6: 0x0001, 0x12e7: 0x0001, 0x12e8: 0x0001, 0x12e9: 0x0001,
	0x12ea: 0x0001, 0x12eb: 0x0001, 0x12ec: 0x0001, 0x12ed: 0x0001, 0x12ee: 0x0001, 0x12ef: 0x0001,
	0x12f0: 0x0001, 0x12f1: 0x0001, 0x12f2: 0x0001, 0x12f3: 0x0001, 0x12f4: 0x0001, 0x12f5: 0x0001,
	0x12f6: 0x0001, 0x12f7: 0x0001, 0x12f8: 0x0001,
	// Block 0x4c, offset 0x1300
	0x1300: 0x0001, 0x1301: 0x0001, 0x1302: 0x0001, 0x1303: 0x0001, 0x1304: 0x0001, 0x1305: 0x0010,
	0x1306: 0x0010, 0x1307: 0x0001, 0x1308: 0x0001, 0x1309: 0x0001, 0x130a: 0x0001, 0x130b: 0x0001,
	0x130c: 0x0001, 0x130d: 0x0001, 0x130e: 0x0001, 0x130f: 0x0001, 0x1310: 0x0001, 0x1311: 0x0001,
	0x1312: 0x0001, 0x1313: 0x0001, 0x1314: 0x0001, 0x1315: 0x0001, 0x1316: 0x0001, 0x1317: 0x0001,
	0x1318: 0x0001, 0x1319: 0x0001, 0x131a: 0x0001, 0x131b: 0x0001, 0x131c: 0x0001, 0x131d: 0x0001,
	0x131e: 0x0001, 0x131f: 0x0001, 0x1320: 0x0001, 0x1321: 0x0001, 0x1322: 0x0001, 0x1323: 0x0001,
	0x1324: 0x0001, 0x1325: 0x0001, 0x1326: 0x0001, 0x1327: 0x0001, 0x1328: 0x0001, 0x1329: 0x0010,
	0x132a: 0x0001,
	0x1330: 0x0001, 0x1331: 0x0001, 0x1332: 0x0001, 0x1333: 0x0001, 0x1334: 0x0001, 0x1335: 0x0001,
	0x1336: 0x0001, 0x1337: 0x0001, 0x1338: 0x0001, 0x1339: 0x0001, 0x133a: 0x0001, 0x133b: 0x0001,
	0x133c: 0x0001, 0x133d: 0x0001, 0x133e: 0x0001, 0x133f: 0x0001,
	// Block 0x4d, offset 0x1340
	0x1340: 0x0001, 0x1341: 0x0001, 0x1342: 0x0001, 0x1343: 0x0001, 0x1344: 0x0001, 0x1345: 0x0001,
	0x1346: 0x0001, 0x1347: 0x0001, 0x1348: 0x0001, 0x1349: 0x0001, 0x134a: 0x0001, 0x134b: 0x0001,
	0x134c: 0x0001, 0x134d: 0x0001, 0x134e: 0x0001, 0x134f: 0x0001, 0x1350: 0x0001, 0x1351: 0x0001,
	0x1352: 0x0001, 0x1353: 0x0001, 0x1354: 0x0001, 0x1355: 0x0001, 0x1356: 0x0001, 0x1357: 0x0001,
	0x1358: 0x0001, 0x1359: 0x0001, 0x135a: 0x0001, 0x135b: 0x0001, 0x135c: 0x0001, 0x135d: 0x0001,
	0x135e: 0x0001, 0x135f: 0x0001, 0x1360: 0x0001, 0x1361: 0x0001, 0x1362: 0x0001, 0x1363: 0x0001,
	0x1364: 0x0001, 0x1365: 0x0001, 0x1366: 0x0001, 0x1367: 0x0001, 0x1368: 0x0001, 0x1369: 0x0001,
	0x136a: 0x0001, 0x136b: 0x0001, 0x136c: 0x0001, 0x136d: 0x0001, 0x136e: 0x0001, 0x136f: 0x0001,
	0x1370: 0x0001, 0x1371: 0x0001, 0x1372: 0x0001, 0x1373: 0x0001, 0x1374: 0x0001, 0x1375: 0x0001,
	// Block 0x4e, offset 0x1380
	0x1380: 0x0001, 0x1381: 0x0001, 0x1382: 0x0001, 0x1383: 0x0001, 0x1384: 0x0001, 0x1385: 0x0001,
	0x1386: 0x0001, 0x1387: 0x0001, 0x1388: 0x0001, 0x1389: 0x0001, 0x138a: 0x0001, 0x138b: 0x0001,
	0x138c: 0x0001, 0x138d: 0x0001, 0x138e: 0x0001, 0x138f: 0x0001, 0x1390: 0x0001, 0x1391: 0x0001,
	0x1392: 0x0001, 0x1393: 0x0001, 0x1394: 0x0001, 0x1395: 0x0001, 0x1396: 0x0001, 0x1397: 0x0001,
	0x1398: 0x0001, 0x1399: 0x0001, 0x139a: 0x0001, 0x139b: 0x0001, 0x139c: 0x0001, 0x139d: 0x0001,
	0x139e: 0x0001, 0x13a0: 0x0010, 0x13a1: 0x0010, 0x13a2: 0x0010, 0x13a3: 0x0010,
	0x13a4: 0x0010, 0x13a5: 0x0010, 0x13a6: 0x0010, 0x13a7: 0x0010, 0x13a8: 0x0010, 0x13a9: 0x0010,
	0x13aa: 0x0010, 0x13ab: 0x0010,
	0x13b0: 0x0010, 0x13b1: 0x0010, 0x13b2: 0x0010, 0x13b3: 0x0010, 0x13b4: 0x0010, 0x13b5: 0x0010,
	0x13b6: 0x0010, 0x13b7: 0x0010, 0x13b8: 0x0010, 0x13b9: 0x0010, 0x13ba: 0x0010, 0x13bb: 0x0010,
	// Block 0x4f, offset 0x13c0
	0x13c6: 0x8000, 0x13c7: 0x8000, 0x13c8: 0x8000, 0x13c9: 0x8000, 0x13ca: 0x8000, 0x13cb: 0x8000,
	0x13cc: 0x8000, 0x13cd: 0x8000, 0x13ce: 0x8000, 0x13cf: 0x8000,
	// Block 0x50, offset 0x1400
	0x1410: 0x8000, 0x1411: 0x8000,
	0x1412: 0x8000, 0x1413: 0x8000, 0x1414: 0x8000, 0x1415: 0x8000, 0x1416: 0x8000, 0x1417: 0x8000,
	0x1418: 0x8000, 0x1419: 0x8000,
	// Block 0x51, offset 0x1440
	0x1440: 0x0001, 0x1441: 0x0001, 0x1442: 0x0001, 0x1443: 0x0001, 0x1444: 0x0001, 0x1445: 0x0001,
	0x1446: 0x0001, 0x1447: 0x0001, 0x1448: 0x0001, 0x1449: 0x0001, 0x144a: 0x0001, 0x144b: 0x0001,
	0x144c: 0x0001, 0x144d: 0x0001, 0x144e: 0x0001, 0x144f: 0x0001, 0x1450: 0x0001, 0x1451: 0x0001,
	0x1452: 0x0001, 0x1453: 0x0001, 0x1454: 0x0001, 0x1455: 0x0001, 0x1456: 0x0001, 0x1457: 0x0010,
	0x1458: 0x0010, 0x1459: 0x0010, 0x145a: 0x0010, 0x145b: 0x0010,
	// Block 0x52, offset 0x1480
	0x1495: 0x0010, 0x1496: 0x0010, 0x1497: 0x0010,
	0x1498: 0x0010, 0x1499: 0x0010, 0x149a: 0x0010, 0x149b: 0x0010, 0x149c: 0x0010, 0x149d: 0x0010,
	0x149e: 0x0010, 0x14a0: 0x0010, 0x14a1: 0x0010, 0x14a2: 0x0010, 0x14a3: 0x0010,
	0x14a4: 0x0010, 0x14a5: 0x0010, 0x14a6: 0x0010, 0x14a7: 0x0010, 0x14a8: 0x0010, 0x14a9: 0x0010,
	0x14aa: 0x0010, 0x14ab: 0x0010, 0x14ac: 0x0010, 0x14ad: 0x0010, 0x14ae: 0x0010, 0x14af: 0x0010,
	0x14b0: 0x0010, 0x14b1: 0x0010, 0x14b2: 0x0010, 0x14b3: 0x0010, 0x14b4: 0x0010, 0x14b5: 0x0010,
	0x14b6: 0x0010, 0x14b7: 0x0010, 0x14b8: 0x0010, 0x14b9: 0x0010, 0x14ba: 0x0010, 0x14bb: 0x0010,
	0x14bc: 0x0010, 0x14bf: 0x0010,
	// Block 0x53, offset 0x14c0
	0x14c0: 0x8000, 0x14c1: 0x8000, 0x14c2: 0x8000, 0x14c3: 0x8000, 0x14c4: 0x8000, 0x14c5: 0x8000,
	0x14c6: 0x8000, 0x14c7: 0x8000, 0x14c8: 0x8000, 0x14c9: 0x8000,
	0x14d0: 0x8000, 0x14d1: 0x8000,
	0x14d2: 0x8000, 0x14d3: 0x8000, 0x14d4: 0x8000, 0x14d5: 0x8000, 0x14d6: 0x8000, 0x14d7: 0x8000,
	0x14d8: 0x8000, 0x14d9: 0x8000,
	0x14f0: 0x0010, 0x14f1: 0x0010, 0x14f2: 0x0010, 0x14f3: 0x0010, 0x14f4: 0x0010, 0x14f5: 0x0010,
	0x14f6: 0x0010, 0x14f7: 0x0010, 0x14f8: 0x0010, 0x14f9: 0x0010, 0x14fa: 0x0010, 0x14fb: 0x0010,
	0x14fc: 0x0010, 0x14fd: 0x0010, 0x14fe: 0x0010, 0x14ff: 0x0010,
	// Block 0x54, offset 0x1500
	0x1500: 0x0010, 0x1501: 0x0010, 0x1502: 0x0010, 0x1503: 0x0010, 0x1504: 0x0010, 0x1505: 0x0010,
	0x1506: 0x0010, 0x1507: 0x0010, 0x1508: 0x0010, 0x1509: 0x0010, 0x150a: 0x0010, 0x150b: 0x0010,
	0x150c: 0x0010, 0x150d: 0x0010, 0x150e: 0x0010,
	// Block 0x55, offset 0x1540
	0x1540: 0x0010, 0x1541: 0x0010, 0x1542: 0x0010, 0x1543: 0x0010, 0x1544: 0x0010, 0x1545: 0x0001,
	0x1546: 0x0001, 0x1547: 0x0001, 0x1548: 0x0001, 0x1549: 0x0001, 0x154a: 0x0001, 0x154b: 0x0001,
	0x154c: 0x0001, 0x154d: 0x0001, 0x154e: 0x0001, 0x154f: 0x0001, 0x1550: 0x0001, 0x1551: 0x0001,
	0x1552: 0x0001, 0x1553: 0x0001, 0x1554: 0x0001, 0x1555: 0x0001, 0x1556: 0x0001, 0x1557: 0x0001,
	0x1558: 0x0001, 0x1559: 0x0001, 0x155a: 0x0001, 0x155b: 0x0001, 0x155c: 0x0001, 0x155d: 0x0001,
	0x155e: 0x0001, 0x155f: 0x0001, 0x1560: 0x0001, 0x1561: 0x0001, 0x1562: 0x0001, 0x1563: 0x0001,
	0x1564: 0x0001, 0x1565: 0x0001, 0x1566: 0x0001, 0x1567: 0x0001, 0x1568: 0x0001, 0x1569: 0x0001,
	0x156a: 0x0001, 0x156b: 0x0001, 0x156c: 0x0001, 0x156d: 0x0001, 0x156e: 0x0001, 0x156f: 0x0001,
	0x1570: 0x0001, 0x1571: 0x0001, 0x1572: 0x0001, 0x1573: 0x0001, 0x1574: 0x0010, 0x1575: 0x0010,
	0x1576: 0x0010, 0x1577: 0x0010, 0x1578: 0x0010, 0x1579: 0x0010, 0x157a: 0x0010, 0x157b: 0x0010,
	0x157c: 0x0010, 0x157d: 0x0010, 0x157e: 0x0010, 0x157f: 0x0010,
	// Block 0x56, offset 0x1580
	0x1580: 0x0010, 0x1581: 0x0010, 0x1582: 0x0010, 0x1583: 0x0010, 0x1584: 0x0010, 0x1585: 0x0001,
	0x1586: 0x0001, 0x1587: 0x0001, 0x1588: 0x0001, 0x1589: 0x0001, 0x158a: 0x0001, 0x158b: 0x0001,
	0x158c: 0x0001, 0x1590: 0x8000, 0x1591: 0x8000,
	0x1592: 0x8000, 0x1593: 0x8000, 0x1594: 0x8000, 0x1595: 0x8000, 0x1596: 0x8000, 0x1597: 0x8000,
	0x1598: 0x8000, 0x1599: 0x8000,
	0x15ab: 0x0010, 0x15ac: 0x0010, 0x15ad: 0x0010, 0x15ae: 0x0010, 0x15af: 0x0010,
	0x15b0: 0x0010, 0x15b1: 0x0010, 0x15b2: 0x0010, 0x15b3: 0x0010,
	// Block 0x57, offset 0x15c0
	0x15c0: 0x0010, 0x15c1: 0x0010, 0x15c2: 0x0010, 0x15c3: 0x0001, 0x15c4: 0x0001, 0x15c5: 0x0001,
	0x15c6: 0x0001, 0x15c7: 0x0001, 0x15c8: 0x0001, 0x15c9: 0x0001, 0x15ca: 0x0001, 0x15cb: 0x0001,
	0x15cc: 0x0001, 0x15cd: 0x0001, 0x15ce: 0x0001, 0x15cf: 0x0001, 0x15d0: 0x0001, 0x15d1: 0x0001,
	0x15d2: 0x0001, 0x15d3: 0x0001, 0x15d4: 0x0001, 0x15d5: 0x0001, 0x15d6: 0x0001, 0x15d7: 0x0001,
	0x15d8: 0x0001, 0x15d9: 0x0001, 0x15da: 0x0001, 0x15db: 0x0001, 0x15dc: 0x0001, 0x15dd: 0x0001,
	0x15de: 0x0001, 0x15df: 0x0001, 0x15e0: 0x0001, 0x15e1: 0x0010, 0x15e2: 0x0010, 0x15e3: 0x0010,
	0x15e4: 0x0010, 0x15e5: 0x0010, 0x15e6: 0x0010, 0x15e7: 0x0010, 0x15e8: 0x0010, 0x15e9: 0x0010,
	0x15ea: 0x0010, 0x15eb: 0x0010, 0x15ec: 0x0010, 0x15ed: 0x0010, 0x15ee: 0x0001, 0x15ef: 0x0001,
	0x15f0: 0x8000, 0x15f1: 0x8000, 0x15f2: 0x8000, 0x15f3: 0x8000, 0x15f4: 0x8000, 0x15f5: 0x8000,
	0x15f6: 0x8000, 0x15f7: 0x8000, 0x15f8: 0x8000, 0x15f9: 0x8000, 0x15fa: 0x0001, 0x15fb: 0x0001,
	0x15fc: 0x0001, 0x15fd: 0x0001, 0x15fe: 0x0001, 0x15ff: 0x0001,
	// Block 0x58, offset 0x1600
	0x1600: 0x0001, 0x1601: 0x0001, 0x1602: 0x0001, 0x1603: 0x0001, 0x1604: 0x0001, 0x1605: 0x0001,
	0x1606: 0x0001, 0x1607: 0x0001, 0x1608: 0x0001, 0x1609: 0x0001, 0x160a: 0x0001, 0x160b: 0x0001,
	0x160c: 0x0001, 0x160d: 0x0001, 0x160e: 0x0001, 0x160f: 0x0001, 0x1610: 0x0001, 0x1611: 0x0001,
	0x1612: 0x0001, 0x1613: 0x0001, 0x1614: 0x0001, 0x1615: 0x0001, 0x1616: 0x0001, 0x1617: 0x0001,
	0x1618: 0x0001, 0x1619: 0x0001, 0x161a: 0x0001, 0x161b: 0x0001, 0x161c: 0x0001, 0x161d: 0x0001,
	0x161e: 0x0001, 0x161f: 0x0001, 0x1620: 0x0001, 0x1621: 0x0001, 0x1622: 0x0001, 0x1623: 0x0001,
	0x1624: 0x0001, 0x1625: 0x0001, 0x1626: 0x0010, 0x1627: 0x0010, 0x1628: 0x0010, 0x1629: 0x0010,
	0x162a: 0x0010, 0x162b: 0x0010, 0x162c: 0x0010, 0x162d: 0x0010, 0x162e: 0x0010, 0x162f: 0x0010,
	0x1630: 0x0010, 0x1631: 0x0010, 0x1632: 0x0010, 0x1633: 0x0010,
	// Block 0x59, offset 0x1640
	0x1640: 0x0001, 0x1641: 0x0001, 0x1642: 0x0001, 0x1643: 0x0001, 0x1644: 0x0001, 0x1645: 0x0001,
	0x1646: 0x0001, 0x1647: 0x0001, 0x1648: 0x0001, 0x1649: 0x0001, 0x164a: 0x0001, 0x164b: 0x0001,
	0x164c: 0x0001, 0x164d: 0x0001, 0x164e: 0x0001, 0x164f: 0x0001, 0x1650: 0x0001, 0x1651: 0x0001,
	0x1652: 0x0001, 0x1653: 0x0001, 0x1654: 0x0001, 0x1655: 0x0001, 0x1656: 0x0001, 0x1657: 0x0001,
	0x1658: 0x0001, 0x1659: 0x0001, 0x165a: 0x0001, 0x165b: 0x0001, 0x165c: 0x0001, 0x165d: 0x0001,
	0x165e: 0x0001, 0x165f: 0x0001, 0x1660: 0x0001, 0x1661: 0x0001, 0x1662: 0x0001, 0x1663: 0x0001,
	0x1664: 0x0010, 0x1665: 0x0010, 0x1666: 0x0010, 0x1667: 0x0010, 0x1668: 0x0010, 0x1669: 0x0010,
	0x166a: 0x0010, 0x166b: 0x0010, 0x166c: 0x0010, 0x166d: 0x0010, 0x166e: 0x0010, 0x166f: 0x0010,
	0x1670: 0x0010, 0x1671: 0x0010, 0x1672: 0x0010, 0x1673: 0x0010, 0x1674: 0x0010, 0x1675: 0x0010,
	0x1676: 0x0010, 0x1677: 0x0010,
	// Block 0x5a, offset 0x1680
	0x1680: 0x8000, 0x1681: 0x8000, 0x1682: 0x8000, 0x1683: 0x8000, 0x1684: 0x8000, 0x1685: 0x8000,
	0x1686: 0x8000, 0x1687: 0x8000, 0x1688: 0x8000, 0x1689: 0x8000,
	0x168d: 0x0001, 0x168e: 0x0001, 0x168f: 0x0001, 0x1690: 0x8000, 0x1691: 0x8000,
	0x1692: 0x8000, 0x1693: 0x8000, 0x1694: 0x8000, 0x1695: 0x8000, 0x1696: 0x8000, 0x1697: 0x8000,
	0x1698: 0x8000, 0x1699: 0x8000, 0x169a: 0x0001, 0x169b: 0x0001, 0x169c: 0x0001, 0x169d: 0x0001,
	0x169e: 0x0001, 0x169f: 0x0001, 0x16a0: 0x0001, 0x16a1: 0x0001, 0x16a2: 0x0001, 0x16a3: 0x0001,
	0x16a4: 0x0001, 0x16a5: 0x0001, 0x16a6: 0x0001, 0x16a7: 0x0001, 0x16a8: 0x0001, 0x16a9: 0x0001,
	0x16aa: 0x0001, 0x16ab: 0x0001, 0x16ac: 0x0001, 0x16ad: 0x0001, 0x16ae: 0x0001, 0x16af: 0x0001,
	0x16b0: 0x0001, 0x16b1: 0x0001, 0x16b2: 0x0001, 0x16b3: 0x0001, 0x16b4: 0x0001, 0x16b5: 0x0001,
	0x16b6: 0x0001, 0x16b7: 0x0001, 0x16b8: 0x0001, 0x16b9: 0x0001, 0x16ba: 0x0001, 0x16bb: 0x0001,
	0x16bc: 0x0001, 0x16bd: 0x0001,
	// Block 0x5b, offset 0x16c0
	0x16c0: 0x0001, 0x16c1: 0x0001, 0x16c2: 0x0001, 0x16c3: 0x0001, 0x16c4: 0x0001, 0x16c5: 0x0001,
	0x16c6: 0x0001, 0x16c7: 0x0001, 0x16c8: 0x0001,
	0x16d0: 0x0001, 0x16d1: 0x0001,
	0x16d2: 0x0001, 0x16d3: 0x0001, 0x16d4: 0x0001, 0x16d5: 0x0001, 0x16d6: 0x0001, 0x16d7: 0x0001,
	0x16d8: 0x0001, 0x16d9: 0x0001, 0x16da: 0x0001, 0x16db: 0x0001, 0x16dc: 0x0001, 0x16dd: 0x0001,
	0x16de: 0x0001, 0x16df: 0x0001, 0x16e0: 0x0001, 0x16e1: 0x0001, 0x16e2: 0x0001, 0x16e3: 0x0001,
	0x16e4: 0x0001, 0x16e5: 0x0001, 0x16e6: 0x0001, 0x16e7: 0x0001, 0x16e8: 0x0001, 0x16e9: 0x0001,
	0x16ea: 0x0001, 0x16eb: 0x0001, 0x16ec: 0x0001, 0x16ed: 0x0001, 0x16ee: 0x0001, 0x16ef: 0x0001,
	0x16f0: 0x0001, 0x16f1: 0x0001, 0x16f2: 0x0001, 0x16f3: 0x0001, 0x16f4: 0x0001, 0x16f5: 0x0001,
	0x16f6: 0x0001, 0x16f7: 0x0001, 0x16f8: 0x0001, 0x16f9: 0x0001, 0x16fa: 0x0001,
	0x16fd: 0x0001, 0x16fe: 0x0001, 0x16ff: 0x0001,
	// Block 0x5c, offset 0x1700
	0x1710: 0x0010, 0x1711: 0x0010,
	0x1712: 0x0010, 0x1714: 0x0010, 0x1715: 0x0010, 0x1716: 0x0010, 0x1717: 0x0010,
	0x1718: 0x0010, 0x1719: 0x0010, 0x171a: 0x0010, 0x171b: 0x0010, 0x171c: 0x0010, 0x171d: 0x0010,
	0x171e: 0x0010, 0x171f: 0x0010, 0x1720: 0x0010, 0x1721: 0x0010, 0x1722: 0x0010, 0x1723: 0x0010,
	0x1724: 0x0010, 0x1725: 0x0010, 0x1726: 0x0010, 0x1727: 0x0010, 0x1728: 0x0010, 0x1729: 0x0001,
	0x172a: 0x0001, 0x172b: 0x0001, 0x172c: 0x0001, 0x172d: 0x0010, 0x172e: 0x0001, 0x172f: 0x0001,
	0x1730: 0x0001, 0x1731: 0x0001, 0x1732: 0x0001, 0x1733: 0x0001, 0x1734: 0x0010, 0x1735: 0x0001,
	0x1736: 0x0001, 0x1737: 0x0010, 0x1738: 0x0010, 0x1739: 0x0010, 0x173a: 0x0001,
	// Block 0x5d, offset 0x1740
	0x1740: 0x0001, 0x1741: 0x0001, 0x1742: 0x0001, 0x1743: 0x0001, 0x1744: 0x0001, 0x1745: 0x0001,
	0x1746: 0x0001, 0x1747: 0x0001, 0x1748: 0x0001, 0x1749: 0x0001, 0x174a: 0x0001, 0x174b: 0x0001,
	0x174c: 0x0001, 0x174d: 0x0001, 0x174e: 0x0001, 0x174f: 0x0001, 0x1750: 0x0001, 0x1751: 0x0001,
	0x1752: 0x0001, 0x1753: 0x0001, 0x1754: 0x0001, 0x1755: 0x0001,
	0x1758: 0x0001, 0x1759: 0x0001, 0x175a: 0x0001, 0x175b: 0x0001, 0x175c: 0x0001, 0x175d: 0x0001,
	0x1760: 0x0001, 0x1761: 0x0001, 0x1762: 0x0001, 0x1763: 0x0001,
	0x1764: 0x0001, 0x1765: 0x0001, 0x1766: 0x0001, 0x1767: 0x0001, 0x1768: 0x0001, 0x1769: 0x0001,
	0x176a: 0x0001, 0x176b: 0x0001, 0x176c: 0x0001, 0x176d: 0x0001, 0x176e: 0x0001, 0x176f: 0x0001,
	0x1770: 0x0001, 0x1771: 0x0001, 0x1772: 0x0001, 0x1773: 0x0001, 0x1774: 0x0001, 0x1775: 0x0001,
	0x1776: 0x0001, 0x1777: 0x0001, 0x1778: 0x0001, 0x1779: 0x0001, 0x177a: 0x0001, 0x177b: 0x0001,
	0x177c: 0x0001, 0x177d: 0x0001, 0x177e: 0x0001, 0x177f: 0x0001,
	// Block 0x5e, offset 0x1780
	0x1780: 0x0001, 0x1781: 0x0001, 0x1782: 0x0001, 0x1783: 0x0001, 0x1784: 0x0001, 0x1785: 0x0001,
	0x1788: 0x0001, 0x1789: 0x0001, 0x178a: 0x0001, 0x178b: 0x0001,
	0x178c: 0x0001, 0x178d: 0x0001, 0x1790: 0x0001, 0x1791: 0x0001,
	0x1792: 0x0001, 0x1793: 0x0001, 0x1794: 0x0001, 0x1795: 0x0001, 0x1796: 0x0001, 0x1797: 0x0001,
	0x1799: 0x0001, 0x179b: 0x0001, 0x179d: 0x0001,
	0x179f: 0x0001, 0x17a0: 0x0001, 0x17a1: 0x0001, 0x17a2: 0x0001, 0x17a3: 0x0001,
	0x17a4: 0x0001, 0x17a5: 0x0001, 0x17a6: 0x0001, 0x17a7: 0x0001, 0x17a8: 0x0001, 0x17a9: 0x0001,
	0x17aa: 0x0001, 0x17ab: 0x0001, 0x17ac: 0x0001, 0x17ad: 0x0001, 0x17ae: 0x0001, 0x17af: 0x0001,
	0x17b0: 0x0001, 0x17b1: 0x0001, 0x17b2: 0x0001, 0x17b3: 0x0001, 0x17b4: 0x0001, 0x17b5: 0x0001,
	0x17b6: 0x0001, 0x17b7: 0x0001, 0x17b8: 0x0001, 0x17b9: 0x0001, 0x17ba: 0x0001, 0x17bb: 0x0001,
	0x17bc: 0x0001, 0x17bd: 0x0001,
	// Block 0x5f, offset 0x17c0
	0x17c0: 0x0001, 0x17c1: 0x0001, 0x17c2: 0x0001, 0x17c3: 0x0001, 0x17c4: 0x0001, 0x17c5: 0x0001,
	0x17c6: 0x0001, 0x17c7: 0x0001, 0x17c8: 0x0001, 0x17c9: 0x0001, 0x17ca: 0x0001, 0x17cb: 0x0001,
	0x17cc: 0x0001, 0x17cd: 0x0001, 0x17ce: 0x0001, 0x17cf: 0x0001, 0x17d0: 0x0001, 0x17d1: 0x0001,
	0x17d2: 0x0001, 0x17d3: 0x0001, 0x17d4: 0x0001, 0x17d5: 0x0001, 0x17d6: 0x0001, 0x17d7: 0x0001,
	0x17d8: 0x0001, 0x17d9: 0x0001, 0x17da: 0x0001, 0x17db: 0x0001, 0x17dc: 0x0001, 0x17dd: 0x0001,
	0x17de: 0x0001, 0x17df: 0x0001, 0x17e0: 0x0001, 0x17e1: 0x0001, 0x17e2: 0x0001, 0x17e3: 0x0001,
	0x17e4: 0x0001, 0x17e5: 0x0001, 0x17e6: 0x0001, 0x17e7: 0x0001, 0x17e8: 0x0001, 0x17e9: 0x0001,
	0x17ea: 0x0001, 0x17eb: 0x0001, 0x17ec: 0x0001, 0x17ed: 0x0001, 0x17ee: 0x0001, 0x17ef: 0x0001,
	0x17f0: 0x0001, 0x17f1: 0x0001, 0x17f2: 0x0001, 0x17f3: 0x0001, 0x17f4: 0x0001,
	0x17f6: 0x0001, 0x17f7: 0x0001, 0x17f8: 0x0001, 0x17f9: 0x0001, 0x17fa: 0x0001, 0x17fb: 0x0001,
	0x17fc: 0x0001, 0x17fe: 0x0001,
	// Block 0x60, offset 0x1800
	0x1802: 0x0001, 0x1803: 0x0001, 0x1804: 0x0001,
	0x1806: 0x0001, 0x1807: 0x0001, 0x1808: 0x0001, 0x1809: 0x0001, 0x180a: 0x0001, 0x180b: 0x0001,
	0x180c: 0x0001, 0x1810: 0x0001, 0x1811: 0x0001,
	0x1812: 0x0001, 0x1813: 0x0001, 0x1816: 0x0001, 0x1817: 0x0001,
	0x1818: 0x0001, 0x1819: 0x0001, 0x181a: 0x0001, 0x181b: 0x0001,
	0x1820: 0x0001, 0x1821: 0x0001, 0x1822: 0x0001, 0x1823: 0x0001,
	0x1824: 0x0001, 0x1825: 0x0001, 0x1826: 0x0001, 0x1827: 0x0001, 0x1828: 0x0001, 0x1829: 0x0001,
	0x182a: 0x0001, 0x182b: 0x0001, 0x182c: 0x0001,
	0x1832: 0x0001, 0x1833: 0x0001, 0x1834: 0x0001,
	0x1836: 0x0001, 0x1837: 0x0001, 0x1838: 0x0001, 0x1839: 0x0001, 0x183a: 0x0001, 0x183b: 0x0001,
	0x183c: 0x0001,
	// Block 0x61, offset 0x1840
	0x1840: 0x40000, 0x1841: 0x40000, 0x1842: 0x40000, 0x1843: 0x40000, 0x1844: 0x40000, 0x1845: 0x40000,
	0x1846: 0x40000, 0x1848: 0x40000, 0x1849: 0x40000, 0x184a: 0x40000,
	0x184c: 0x0010, 0x184d: 0x80000, 0x184e: 0x0080, 0x184f: 0x0080,
	0x1858: 0x2000, 0x1859: 0x2000,
	0x1864: 0x2000, 0x1867: 0x0800, 0x1868: 0x4000, 0x1869: 0x4000,
	0x186a: 0x0080, 0x186b: 0x0080, 0x186c: 0x0080, 0x186d: 0x0080, 0x186e: 0x0080, 0x186f: 0x0020,
	0x187c: 0x0040, 0x187f: 0x0020,
	// Block 0x62, offset 0x1880
	0x1880: 0x0020, 0x1884: 0x1000,
	0x1889: 0x0040,
	0x1894: 0x0020,
	0x189f: 0x40000, 0x18a0: 0x0080, 0x18a1: 0x0080, 0x18a2: 0x0080, 0x18a3: 0x0080,
	0x18a4: 0x0080, 0x18a6: 0x0080, 0x18a7: 0x0080, 0x18a8: 0x0080, 0x18a9: 0x0080,
	0x18aa: 0x0080, 0x18ab: 0x0080, 0x18ac: 0x0080, 0x18ad: 0x0080, 0x18ae: 0x0080, 0x18af: 0x0080,
	0x18b1: 0x0001,
	0x18bf: 0x0001,
	// Block 0x63, offset 0x18c0
	0x18d0: 0x0001, 0x18d1: 0x0001,
	0x18d2: 0x0001, 0x18d3: 0x0001, 0x18d4: 0x0001, 0x18d5: 0x0001, 0x18d6: 0x0001, 0x18d7: 0x0001,
	0x18d8: 0x0001, 0x18d9: 0x0001, 0x18da: 0x0001, 0x18db: 0x0001, 0x18dc: 0x0001,
	// Block 0x64, offset 0x1900
	0x1910: 0x0010, 0x1911: 0x0010,
	0x1912: 0x0010, 0x1913: 0x0010, 0x1914: 0x0010, 0x1915: 0x0010, 0x1916: 0x0010, 0x1917: 0x0010,
	0x1918: 0x0010, 0x1919: 0x0010, 0x191a: 0x0010, 0x191b: 0x0010, 0x191c: 0x0010, 0x191d: 0x0010,
	0x191e: 0x0010, 0x191f: 0x0010, 0x1920: 0x0010, 0x1921: 0x0010, 0x1922: 0x0010, 0x1923: 0x0010,
	0x1924: 0x0010, 0x1925: 0x0010, 0x1926: 0x0010, 0x1927: 0x0010, 0x1928: 0x0010, 0x1929: 0x0010,
	0x192a: 0x0010, 0x192b: 0x0010, 0x192c: 0x0010, 0x192d: 0x0010, 0x192e: 0x0010, 0x192f: 0x0010,
	0x1930: 0x0010,
	// Block 0x65, offset 0x1940
	0x1942: 0x0001,
	0x1947: 0x0001, 0x194a: 0x0001, 0x194b: 0x0001,
	0x194c: 0x0001, 0x194d: 0x0001, 0x194e: 0x0001, 0x194f: 0x0001, 0x1950: 0x0001, 0x1951: 0x0001,
	0x1952: 0x0001, 0x1953: 0x0001, 0x1955: 0x0001,
	0x1959: 0x0001, 0x195a: 0x0001, 0x195b: 0x0001, 0x195c: 0x0001, 0x195d: 0x0001,
	0x1962: 0x0040,
	0x1964: 0x0001, 0x1966: 0x0001, 0x1968: 0x0001,
	0x196a: 0x0001, 0x196b: 0x0001, 0x196c: 0x0001, 0x196d: 0x0001, 0x196f: 0x0001,
	0x1970: 0x0001, 0x1971: 0x0001, 0x1972: 0x0001, 0x1973: 0x0001, 0x1974: 0x0001, 0x1975: 0x0001,
	0x1976: 0x0001, 0x1977: 0x0001, 0x1978: 0x0001, 0x1979: 0x0041,
	0x197c: 0x0001, 0x197d: 0x0001, 0x197e: 0x0001, 0x197f: 0x0001,
	// Block 0x66, offset 0x1980
	0x1985: 0x0001,
	0x1986: 0x0001, 0x1987: 0x0001, 0x1988: 0x0001, 0x1989: 0x0001,
	0x198e: 0x0001,
	0x19a0: 0x0001, 0x19a1: 0x0001, 0x19a2: 0x0001, 0x19a3: 0x0001,
	0x19a4: 0x0001, 0x19a5: 0x0001, 0x19a6: 0x0001, 0x19a7: 0x0001, 0x19a8: 0x0001, 0x19a9: 0x0001,
	0x19aa: 0x0001, 0x19ab: 0x0001, 0x19ac: 0x0001, 0x19ad: 0x0001, 0x19ae: 0x0001, 0x19af: 0x0001,
	0x19b0: 0x0001, 0x19b1: 0x0001, 0x19b2: 0x0001, 0x19b3: 0x0001, 0x19b4: 0x0001, 0x19b5: 0x0001,
	0x19b6: 0x0001, 0x19b7: 0x0001, 0x19b8: 0x0001, 0x19b9: 0x0001, 0x19ba: 0x0001, 0x19bb: 0x0001,
	0x19bc: 0x0001, 0x19bd: 0x0001, 0x19be: 0x0001, 0x19bf: 0x0001,
	// Block 0x67, offset 0x19c0
	0x19c0: 0x0001, 0x19c1: 0x0001, 0x19c2: 0x0001, 0x19c3: 0x0001, 0x19c4: 0x0001, 0x19c5: 0x0001,
	0x19c6: 0x0001, 0x19c7: 0x0001, 0x19c8: 0x0001,
	0x19d4: 0x0040, 0x19d5: 0x0040, 0x19d6: 0x0040, 0x19d7: 0x0040,
	0x19d8: 0x0040, 0x19d9: 0x0040,
	0x19e9: 0x0040,
	0x19ea: 0x0040,
	// Block 0x68, offset 0x1a00
	0x1a1a: 0x0040, 0x1a1b: 0x0040,
	0x1a28: 0x0040,
	// Block 0x69, offset 0x1a40
	0x1a48: 0x0040,
	// Block 0x6a, offset 0x1a80
	0x1a8f: 0x0040,
	0x1aa9: 0x0040,
	0x1aaa: 0x0040, 0x1aab: 0x0040, 0x1aac: 0x0040, 0x1aad: 0x0040, 0x1aae: 0x0040, 0x1aaf: 0x0040,
	0x1ab0: 0x0040, 0x1ab1: 0x0040, 0x1ab2: 0x0040, 0x1ab3: 0x0040,
	0x1ab8: 0x0040, 0x1ab9: 0x0040, 0x1aba: 0x0040,
	// Block 0x6b, offset 0x1ac0
	0x1af6: 0x0001, 0x1af7: 0x0001, 0x1af8: 0x0001, 0x1af9: 0x0001, 0x1afa: 0x0001, 0x1afb: 0x0001,
	0x1afc: 0x0001, 0x1afd: 0x0001, 0x1afe: 0x0001, 0x1aff: 0x0001,
	// Block 0x6c, offset 0x1b00
	0x1b00: 0x0001, 0x1b01: 0x0001, 0x1b02: 0x0041, 0x1b03: 0x0001, 0x1b04: 0x0001, 0x1b05: 0x0001,
	0x1b06: 0x0001, 0x1b07: 0x0001, 0x1b08: 0x0001, 0x1b09: 0x0001, 0x1b0a: 0x0001, 0x1b0b: 0x0001,
	0x1b0c: 0x0001, 0x1b0d: 0x0001, 0x1b0e: 0x0001, 0x1b0f: 0x0001, 0x1b10: 0x0001, 0x1b11: 0x0001,
	0x1b12: 0x0001, 0x1b13: 0x0001, 0x1b14: 0x0001, 0x1b15: 0x0001, 0x1b16: 0x0001, 0x1b17: 0x0001,
	0x1b18: 0x0001, 0x1b19: 0x0001, 0x1b1a: 0x0001, 0x1b1b: 0x0001, 0x1b1c: 0x0001, 0x1b1d: 0x0001,
	0x1b1e: 0x0001, 0x1b1f: 0x0001, 0x1b20: 0x0001, 0x1b21: 0x0001, 0x1b22: 0x0001, 0x1b23: 0x0001,
	0x1b24: 0x0001, 0x1b25: 0x0001, 0x1b26: 0x0001, 0x1b27: 0x0001, 0x1b28: 0x0001, 0x1b29: 0x0001,
	// Block 0x6d, offset 0x1b40
	0x1b6a: 0x0040, 0x1b6b: 0x0040,
	0x1b76: 0x0040,
	// Block 0x6e, offset 0x1b80
	0x1b80: 0x0040,
	0x1bbb: 0x0040,
	0x1bbc: 0x0040, 0x1bbd: 0x0040, 0x1bbe: 0x0040,
	// Block 0x6f, offset 0x1bc0
	0x1bc0: 0x0040, 0x1bc1: 0x0040, 0x1bc2: 0x0040, 0x1bc3: 0x0040, 0x1bc4: 0x0040, 0x1bc5: 0x0040,
	0x1bc7: 0x0040, 0x1bc8: 0x0040, 0x1bc9: 0x0040, 0x1bca: 0x0040, 0x1bcb: 0x0040,
	0x1bcc: 0x0040, 0x1bcd: 0x0040, 0x1bce: 0x0040, 0x1bcf: 0x0040, 0x1bd0: 0x0040, 0x1bd1: 0x0040,
	0x1bd2: 0x0040, 0x1bd4: 0x0040, 0x1bd5: 0x0040, 0x1bd6: 0x0040, 0x1bd7: 0x0040,
	0x1bd8: 0x0040, 0x1bd9: 0x0040, 0x1bda: 0x0040, 0x1bdb: 0x0040, 0x1bdc: 0x0040, 0x1bdd: 0x0040,
	0x1bde: 0x0040, 0x1bdf: 0x0040, 0x1be0: 0x0040, 0x1be1: 0x0040, 0x1be2: 0x0040, 0x1be3: 0x0040,
	0x1be4: 0x0040, 0x1be5: 0x0040, 0x1be6: 0x0040, 0x1be7: 0x0040, 0x1be8: 0x0040, 0x1be9: 0x0040,
	0x1bea: 0x0040, 0x1beb: 0x0040, 0x1bec: 0x0040, 0x1bed: 0x0040, 0x1bee: 0x0040, 0x1bef: 0x0040,
	0x1bf0: 0x0040, 0x1bf1: 0x0040, 0x1bf2: 0x0040, 0x1bf3: 0x0040, 0x1bf4: 0x0040, 0x1bf5: 0x0040,
	0x1bf6: 0x0040, 0x1bf7: 0x0040, 0x1bf8: 0x0040, 0x1bf9: 0x0040, 0x1bfa: 0x0040, 0x1bfb: 0x0040,
	0x1bfc: 0x0040, 0x1bfd: 0x0040, 0x1bfe: 0x0040, 0x1bff: 0x0040,
	// Block 0x70, offset 0x1c00
	0x1c00: 0x0040, 0x1c01: 0x0040, 0x1c02: 0x0040, 0x1c03: 0x0040, 0x1c04: 0x0040, 0x1c05: 0x0040,
	0x1c06: 0x0040, 0x1c07: 0x0040, 0x1c08: 0x0040, 0x1c09: 0x0040, 0x1c0a: 0x0040, 0x1c0b: 0x0040,
	0x1c0c: 0x0040, 0x1c0d: 0x0040, 0x1c0e: 0x0040, 0x1c0f: 0x0040, 0x1c10: 0x0040, 0x1c11: 0x0040,
	0x1c12: 0x0040, 0x1c13: 0x0040, 0x1c14: 0x0040, 0x1c15: 0x0040, 0x1c16: 0x0040, 0x1c17: 0x0040,
	0x1c18: 0x0040, 0x1c19: 0x0040, 0x1c1a: 0x0040, 0x1c1b: 0x0040, 0x1c1c: 0x0040, 0x1c1d: 0x0040,
	0x1c1e: 0x0040, 0x1c1f: 0x0040, 0x1c20: 0x0040, 0x1c21: 0x0040, 0x1c22: 0x0040, 0x1c23: 0x0040,
	0x1c24: 0x0040, 0x1c25: 0x0040, 0x1c26: 0x0040, 0x1c27: 0x0040, 0x1c28: 0x0040, 0x1c29: 0x0040,
	0x1c2a: 0x0040, 0x1c2b: 0x0040, 0x1c2c: 0x0040, 0x1c2d: 0x0040, 0x1c2e: 0x0040, 0x1c2f: 0x0040,
	0x1c30: 0x0040, 0x1c31: 0x0040, 0x1c32: 0x0040, 0x1c33: 0x0040, 0x1c34: 0x0040, 0x1c35: 0x0040,
	0x1c36: 0x0040, 0x1c37: 0x0040, 0x1c38: 0x0040, 0x1c39: 0x0040, 0x1c3a: 0x0040, 0x1c3b: 0x0040,
	0x1c3c: 0x0040, 0x1c3d: 0x0040, 0x1c3e: 0x0040, 0x1c3f: 0x0040,
	// Block 0x71, offset 0x1c40
	0x1c40: 0x0040, 0x1c41: 0x0040, 0x1c42: 0x0040, 0x1c43: 0x0040, 0x1c44: 0x0040, 0x1c45: 0x0040,
	0x1c50: 0x0040, 0x1c51: 0x0040,
	0x1c52: 0x0040, 0x1c53: 0x0040, 0x1c54: 0x0040, 0x1c55: 0x0040, 0x1c56: 0x0040, 0x1c57: 0x0040,
	0x1c58: 0x0040, 0x1c59: 0x0040, 0x1c5a: 0x0040, 0x1c5b: 0x0040, 0x1c5c: 0x0040, 0x1c5d: 0x0040,
	0x1c5e: 0x0040, 0x1c5f: 0x0040, 0x1c60: 0x0040, 0x1c61: 0x0040, 0x1c62: 0x0040, 0x1c63: 0x0040,
	0x1c64: 0x0040, 0x1c65: 0x0040, 0x1c66: 0x0040, 0x1c67: 0x0040, 0x1c68: 0x0040, 0x1c69: 0x0040,
	0x1c6a: 0x0040, 0x1c6b: 0x0040, 0x1c6c: 0x0040, 0x1c6d: 0x0040, 0x1c6e: 0x0040, 0x1c6f: 0x0040,
	0x1c70: 0x0040, 0x1c71: 0x0040, 0x1c72: 0x0040, 0x1c73: 0x0040, 0x1c74: 0x0040, 0x1c75: 0x0040,
	0x1c76: 0x0040, 0x1c77: 0x0040, 0x1c78: 0x0040, 0x1c79: 0x0040, 0x1c7a: 0x0040, 0x1c7b: 0x0040,
	0x1c7c: 0x0040, 0x1c7d: 0x0040, 0x1c7e: 0x0040, 0x1c7f: 0x0040,
	// Block 0x72, offset 0x1c80
	0x1c80: 0x0040, 0x1c81: 0x0040, 0x1c82: 0x0040, 0x1c83: 0x0040, 0x1c84: 0x0040, 0x1c85: 0x0040,
	0x1c88: 0x0040, 0x1c89: 0x0040, 0x1c8a: 0x0040, 0x1c8b: 0x0040,
	0x1c8c: 0x0040, 0x1c8d: 0x0040, 0x1c8e: 0x0040, 0x1c8f: 0x0040, 0x1c90: 0x0040, 0x1c91: 0x0040,
	0x1c92: 0x0040, 0x1c94: 0x0040, 0x1c96: 0x0040,
	0x1c9d: 0x0040,
	0x1ca1: 0x0040,
	0x1ca8: 0x0040,
	0x1cb3: 0x0040, 0x1cb4: 0x0040,
	// Block 0x73, offset 0x1cc0
	0x1cc4: 0x0040,
	0x1cc7: 0x0040,
	0x1ccc: 0x0040, 0x1cce: 0x0040,
	0x1cd3: 0x0040, 0x1cd4: 0x0040, 0x1cd5: 0x0040, 0x1cd7: 0x0040,
	0x1ce3: 0x0040,
	0x1ce4: 0x0040, 0x1ce5: 0x0040, 0x1ce6: 0x0040, 0x1ce7: 0x0040,
	// Block 0x74, offset 0x1d00
	0x1d15: 0x0040, 0x1d16: 0x0040, 0x1d17: 0x0040,
	0x1d21: 0x0040,
	0x1d30: 0x0040,
	0x1d3f: 0x0040,
	// Block 0x75, offset 0x1d40
	0x1d74: 0x0040, 0x1d75: 0x0040,
	// Block 0x76, offset 0x1d80
	0x1d85: 0x0040,
	0x1d86: 0x0040, 0x1d87: 0x0040,
	0x1d9b: 0x0040, 0x1d9c: 0x0040,
	// Block 0x77, offset 0x1dc0
	0x1dd0: 0x0040,
	0x1dd5: 0x0040,
	// Block 0x78, offset 0x1e00
	0x1e00: 0x0001, 0x1e01: 0x0001, 0x1e02: 0x0001, 0x1e03: 0x0001, 0x1e04: 0x0001, 0x1e05: 0x0001,
	0x1e06: 0x0001, 0x1e07: 0x0001, 0x1e08: 0x0001, 0x1e09: 0x0001, 0x1e0a: 0x0001, 0x1e0b: 0x0001,
	0x1e0c: 0x0001, 0x1e0d: 0x0001, 0x1e0e: 0x0001, 0x1e0f: 0x0001, 0x1e10: 0x0001, 0x1e11: 0x0001,
	0x1e12: 0x0001, 0x1e13: 0x0001, 0x1e14: 0x0001, 0x1e15: 0x0001, 0x1e16: 0x0001, 0x1e17: 0x0001,
	0x1e18: 0x0001, 0x1e19: 0x0001, 0x1e1a: 0x0001, 0x1e1b: 0x0001, 0x1e1c: 0x0001, 0x1e1d: 0x0001,
	0x1e1e: 0x0001, 0x1e1f: 0x0001, 0x1e20: 0x0001, 0x1e21: 0x0001, 0x1e22: 0x0001, 0x1e23: 0x0001,
	0x1e24: 0x0001,
	0x1e2b: 0x0001, 0x1e2c: 0x0001, 0x1e2d: 0x0001, 0x1e2e: 0x0001, 0x1e2f: 0x0010,
	0x1e30: 0x0010, 0x1e31: 0x0010, 0x1e32: 0x0001, 0x1e33: 0x0001,
	// Block 0x79, offset 0x1e40
	0x1e40: 0x0001, 0x1e41: 0x0001, 0x1e42: 0x0001, 0x1e43: 0x0001, 0x1e44: 0x0001, 0x1e45: 0x0001,
	0x1e46: 0x0001, 0x1e47: 0x0001, 0x1e48: 0x0001, 0x1e49: 0x0001, 0x1e4a: 0x0001, 0x1e4b: 0x0001,
	0x1e4c: 0x0001, 0x1e4d: 0x0001, 0x1e4e: 0x0001, 0x1e4f: 0x0001, 0x1e50: 0x0001, 0x1e51: 0x0001,
	0x1e52: 0x0001, 0x1e53: 0x0001, 0x1e54: 0x0001, 0x1e55: 0x0001, 0x1e56: 0x0001, 0x1e57: 0x0001,
	0x1e58: 0x0001, 0x1e59: 0x0001, 0x1e5a: 0x0001, 0x1e5b: 0x0001, 0x1e5c: 0x0001, 0x1e5d: 0x0001,
	0x1e5e: 0x0001, 0x1e5f: 0x0001, 0x1e60: 0x0001, 0x1e61: 0x0001, 0x1e62: 0x0001, 0x1e63: 0x0001,
	0x1e64: 0x0001, 0x1e65: 0x0001, 0x1e67: 0x0001,
	0x1e6d: 0x0001,
	0x1e70: 0x0001, 0x1e71: 0x0001, 0x1e72: 0x0001, 0x1e73: 0x0001, 0x1e74: 0x0001, 0x1e75: 0x0001,
	0x1e76: 0x0001, 0x1e77: 0x0001, 0x1e78: 0x0001, 0x1e79: 0x0001, 0x1e7a: 0x0001, 0x1e7b: 0x0001,
	0x1e7c: 0x0001, 0x1e7d: 0x0001, 0x1e7e: 0x0001, 0x1e7f: 0x0001,
	// Block 0x7a, offset 0x1e80
	0x1e80: 0x0001, 0x1e81: 0x0001, 0x1e82: 0x0001, 0x1e83: 0x0001, 0x1e84: 0x0001, 0x1e85: 0x0001,
	0x1e86: 0x0001, 0x1e87: 0x0001, 0x1e88: 0x0001, 0x1e89: 0x0001, 0x1e8a: 0x0001, 0x1e8b: 0x0001,
	0x1e8c: 0x0001, 0x1e8d: 0x0001, 0x1e8e: 0x0001, 0x1e8f: 0x0001, 0x1e90: 0x0001, 0x1e91: 0x0001,
	0x1e92: 0x0001, 0x1e93: 0x0001, 0x1e94: 0x0001, 0x1e95: 0x0001, 0x1e96: 0x0001, 0x1e97: 0x0001,
	0x1e98: 0x0001, 0x1e99: 0x0001, 0x1e9a: 0x0001, 0x1e9b: 0x0001, 0x1e9c: 0x0001, 0x1e9d: 0x0001,
	0x1e9e: 0x0001, 0x1e9f: 0x0001, 0x1ea0: 0x0001, 0x1ea1: 0x0001, 0x1ea2: 0x0001, 0x1ea3: 0x0001,
	0x1ea4: 0x0001, 0x1ea5: 0x0001, 0x1ea6: 0x0001, 0x1ea7: 0x0001,
	0x1eaf: 0x0001,
	0x1ebf: 0x0010,
	// Block 0x7b, offset 0x1ec0
	0x1ec0: 0x0001, 0x1ec1: 0x0001, 0x1ec2: 0x0001, 0x1ec3: 0x0001, 0x1ec4: 0x0001, 0x1ec5: 0x0001,
	0x1ec6: 0x0001, 0x1ec7: 0x0001, 0x1ec8: 0x0001, 0x1ec9: 0x0001, 0x1eca: 0x0001, 0x1ecb: 0x0001,
	0x1ecc: 0x0001, 0x1ecd: 0x0001, 0x1ece: 0x0001, 0x1ecf: 0x0001, 0x1ed0: 0x0001, 0x1ed1: 0x0001,
	0x1ed2: 0x0001, 0x1ed3: 0x0001, 0x1ed4: 0x0001, 0x1ed5: 0x0001, 0x1ed6: 0x0001,
	0x1ee0: 0x0001, 0x1ee1: 0x0001, 0x1ee2: 0x0001, 0x1ee3: 0x0001,
	0x1ee4: 0x0001, 0x1ee5: 0x0001, 0x1ee6: 0x0001, 0x1ee8: 0x0001, 0x1ee9: 0x0001,
	0x1eea: 0x0001, 0x1eeb: 0x0001, 0x1eec: 0x0001, 0x1eed: 0x0001, 0x1eee: 0x0001,
	0x1ef0: 0x0001, 0x1ef1: 0x0001, 0x1ef2: 0x0001, 0x1ef3: 0x0001, 0x1ef4: 0x0001, 0x1ef5: 0x0001,
	0x1ef6: 0x0001, 0x1ef8: 0x0001, 0x1ef9: 0x0001, 0x1efa: 0x0001, 0x1efb: 0x0001,
	0x1efc: 0x0001, 0x1efd: 0x0001, 0x1efe: 0x0001,
	// Block 0x7c, offset 0x1f00
	0x1f00: 0x0001, 0x1f01: 0x0001, 0x1f02: 0x0001, 0x1f03: 0x0001, 0x1f04: 0x0001, 0x1f05: 0x0001,
	0x1f06: 0x0001, 0x1f08: 0x0001, 0x1f09: 0x0001, 0x1f0a: 0x0001, 0x1f0b: 0x0001,
	0x1f0c: 0x0001, 0x1f0d: 0x0001, 0x1f0e: 0x0001, 0x1f10: 0x0001, 0x1f11: 0x0001,
	0x1f12: 0x0001, 0x1f13: 0x0001, 0x1f14: 0x0001, 0x1f15: 0x0001, 0x1f16: 0x0001,
	0x1f18: 0x0001, 0x1f19: 0x0001, 0x1f1a: 0x0001, 0x1f1b: 0x0001, 0x1f1c: 0x0001, 0x1f1d: 0x0001,
	0x1f1e: 0x0001, 0x1f20: 0x0010, 0x1f21: 0x0010, 0x1f22: 0x0010, 0x1f23: 0x0010,
	0x1f24: 0x0010, 0x1f25: 0x0010, 0x1f26: 0x0010, 0x1f27: 0x0010, 0x1f28: 0x0010, 0x1f29: 0x0010,
	0x1f2a: 0x0010, 0x1f2b: 0x0010, 0x1f2c: 0x0010, 0x1f2d: 0x0010, 0x1f2e: 0x0010, 0x1f2f: 0x0010,
	0x1f30: 0x0010, 0x1f31: 0x0010, 0x1f32: 0x0010, 0x1f33: 0x0010, 0x1f34: 0x0010, 0x1f35: 0x0010,
	0x1f36: 0x0010, 0x1f37: 0x0010, 0x1f38: 0x0010, 0x1f39: 0x0010, 0x1f3a: 0x0010, 0x1f3b: 0x0010,
	0x1f3c: 0x0010, 0x1f3d: 0x0010, 0x1f3e: 0x0010, 0x1f3f: 0x0010,
	// Block 0x7d, offset 0x1f40
	0x1f6f: 0x0001,
	// Block 0x7e, offset 0x1f80
	0x1f80: 0x0002, 0x1f81: 0x0002, 0x1f82: 0x0002, 0x1f83: 0x0002, 0x1f84: 0x0002, 0x1f85: 0x0002,
	0x1f86: 0x0002, 0x1f87: 0x0002, 0x1f88: 0x0002, 0x1f89: 0x0002, 0x1f8a: 0x0002, 0x1f8b: 0x0002,
	0x1f8c: 0x0002, 0x1f8d: 0x0002, 0x1f8e: 0x0002, 0x1f8f: 0x0002, 0x1f90: 0x0002, 0x1f91: 0x0002,
	0x1f92: 0x0002, 0x1f93: 0x0002, 0x1f94: 0x0002, 0x1f95: 0x0002, 0x1f96: 0x0002, 0x1f97: 0x0002,
	0x1f98: 0x0002, 0x1f99: 0x0002, 0x1f9b: 0x0002, 0x1f9c: 0x0002, 0x1f9d: 0x0002,
	0x1f9e: 0x0002, 0x1f9f: 0x0002, 0x1fa0: 0x0002, 0x1fa1: 0x0002, 0x1fa2: 0x0002, 0x1fa3: 0x0002,
	0x1fa4: 0x0002, 0x1fa5: 0x0002, 0x1fa6: 0x0002, 0x1fa7: 0x0002, 0x1fa8: 0x0002, 0x1fa9: 0x0002,
	0x1faa: 0x0002, 0x1fab: 0x0002, 0x1fac: 0x0002, 0x1fad: 0x0002, 0x1fae: 0x0002, 0x1faf: 0x0002,
	0x1fb0: 0x0002, 0x1fb1: 0x0002, 0x1fb2: 0x0002, 0x1fb3: 0x0002, 0x1fb4: 0x0002, 0x1fb5: 0x0002,
	0x1fb6: 0x0002, 0x1fb7: 0x0002, 0x1fb8: 0x0002, 0x1fb9: 0x0002, 0x1fba: 0x0002, 0x1fbb: 0x0002,
	0x1fbc: 0x0002, 0x1fbd: 0x0002, 0x1fbe: 0x0002, 0x1fbf: 0x0002,
	// Block 0x7f, offset 0x1fc0
	0x1fc0: 0x0002, 0x1fc1: 0x0002, 0x1fc2: 0x0002, 0x1fc3: 0x0002, 0x1fc4: 0x0002, 0x1fc5: 0x0002,
	0x1fc6: 0x0002, 0x1fc7: 0x0002, 0x1fc8: 0x0002, 0x1fc9: 0x0002, 0x1fca: 0x0002, 0x1fcb: 0x0002,
	0x1fcc: 0x0002, 0x1fcd: 0x0002, 0x1fce: 0x0002, 0x1fcf: 0x0002, 0x1fd0: 0x0002, 0x1fd1: 0x0002,
	0x1fd2: 0x0002, 0x1fd3: 0x0002, 0x1fd4: 0x0002, 0x1fd5: 0x0002, 0x1fd6: 0x0002, 0x1fd7: 0x0002,
	0x1fd8: 0x0002, 0x1fd9: 0x0002, 0x1fda: 0x0002, 0x1fdb: 0x0002, 0x1fdc: 0x0002, 0x1fdd: 0x0002,
	0x1fde: 0x0002, 0x1fdf: 0x0002, 0x1fe0: 0x0002, 0x1fe1: 0x0002, 0x1fe2: 0x0002, 0x1fe3: 0x0002,
	0x1fe4: 0x0002, 0x1fe5: 0x0002, 0x1fe6: 0x0002, 0x1fe7: 0x0002, 0x1fe8: 0x0002, 0x1fe9: 0x0002,
	0x1fea: 0x0002, 0x1feb: 0x0002, 0x1fec: 0x0002, 0x1fed: 0x0002, 0x1fee: 0x0002, 0x1fef: 0x0002,
	0x1ff0: 0x0002, 0x1ff1: 0x0002, 0x1ff2: 0x0002, 0x1ff3: 0x0002,
	// Block 0x80, offset 0x2000
	0x2000: 0x0002, 0x2001: 0x0002, 0x2002: 0x0002, 0x2003: 0x0002, 0x2004: 0x0002, 0x2005: 0x0002,
	0x2006: 0x0002, 0x2007: 0x0002, 0x2008: 0x0002, 0x2009: 0x0002, 0x200a: 0x0002, 0x200b: 0x0002,
	0x200c: 0x0002, 0x200d: 0x0002, 0x200e: 0x0002, 0x200f: 0x0002, 0x2010: 0x0002, 0x2011: 0x0002,
	0x2012: 0x0002, 0x2013: 0x0002, 0x2014: 0x0002, 0x2015: 0x0002, 0x2016: 0x0002, 0x2017: 0x0002,
	0x2018: 0x0002, 0x2019: 0x0002, 0x201a: 0x0002, 0x201b: 0x0002, 0x201c: 0x0002, 0x201d: 0x0002,
	0x201e: 0x0002, 0x201f: 0x0002, 0x2020: 0x0002, 0x2021: 0x0002, 0x2022: 0x0002, 0x2023: 0x0002,
	0x2024: 0x0002, 0x2025: 0x0002, 0x2026: 0x0002, 0x2027: 0x0002, 0x2028: 0x0002, 0x2029: 0x0002,
	0x202a: 0x0002, 0x202b: 0x0002, 0x202c: 0x0002, 0x202d: 0x0002, 0x202e: 0x0002, 0x202f: 0x0002,
	0x2030: 0x0002, 0x2031: 0x0002, 0x2032: 0x0002, 0x2033: 0x0002, 0x2034: 0x0002, 0x2035: 0x0002,
	0x2036: 0x0002, 0x2037: 0x0002, 0x2038: 0x0002, 0x2039: 0x0002, 0x203a: 0x0002, 0x203b: 0x0002,
	0x203c: 0x0002, 0x203d: 0x0002, 0x203e: 0x0002, 0x203f: 0x0002,
	// Block 0x81, offset 0x2040
	0x2040: 0x0002, 0x2041: 0x0002, 0x2042: 0x0002, 0x2043: 0x0002, 0x2044: 0x0002, 0x2045: 0x0002,
	0x2046: 0x0002, 0x2047: 0x0002, 0x2048: 0x0002, 0x2049: 0x0002, 0x204a: 0x0002, 0x204b: 0x0002,
	0x204c: 0x0002, 0x204d: 0x0002, 0x204e: 0x0002, 0x204f: 0x0002, 0x2050: 0x0002, 0x2051: 0x0002,
	0x2052: 0x0002, 0x2053: 0x0002, 0x2054: 0x0002, 0x2055: 0x0002,
	// Block 0x82, offset 0x2080
	0x2080: 0x40000, 0x2085: 0x0003,
	0x2087: 0x0002,
	0x20a1: 0x0002, 0x20a2: 0x0002, 0x20a3: 0x0002,
	0x20a4: 0x0002, 0x20a5: 0x0002, 0x20a6: 0x0002, 0x20a7: 0x0002, 0x20a8: 0x0002, 0x20a9: 0x0002,
	0x20aa: 0x0010, 0x20ab: 0x0010, 0x20ac: 0x0010, 0x20ad: 0x0010, 0x20ae: 0x0010, 0x20af: 0x0010,
	0x20b0: 0x0040, 0x20b1: 0x0202, 0x20b2: 0x0202, 0x20b3: 0x0202, 0x20b4: 0x0202, 0x20b5: 0x0202,
	0x20b8: 0x0002, 0x20b9: 0x0002, 0x20ba: 0x0002, 0x20bb: 0x0003,
	0x20bc: 0x0001, 0x20bd: 0x0040,
	// Block 0x83, offset 0x20c0
	0x20c1: 0x0002, 0x20c2: 0x0002, 0x20c3: 0x0002, 0x20c4: 0x0002, 0x20c5: 0x0002,
	0x20c6: 0x0002, 0x20c7: 0x0002, 0x20c8: 0x0002, 0x20c9: 0x0002, 0x20ca: 0x0002, 0x20cb: 0x0002,
	0x20cc: 0x0002, 0x20cd: 0x0002, 0x20ce: 0x0002, 0x20cf: 0x0002, 0x20d0: 0x0002, 0x20d1: 0x0002,
	0x20d2: 0x0002, 0x20d3: 0x0002, 0x20d4: 0x0002, 0x20d5: 0x0002, 0x20d6: 0x0002, 0x20d7: 0x0002,
	0x20d8: 0x0002, 0x20d9: 0x0002, 0x20da: 0x0002, 0x20db: 0x0002, 0x20dc: 0x0002, 0x20dd: 0x0002,
	0x20de: 0x0002, 0x20df: 0x0002, 0x20e0: 0x0002, 0x20e1: 0x0002, 0x20e2: 0x0002, 0x20e3: 0x0002,
	0x20e4: 0x0002, 0x20e5: 0x0002, 0x20e6: 0x0002, 0x20e7: 0x0002, 0x20e8: 0x0002, 0x20e9: 0x0002,
	0x20ea: 0x0002, 0x20eb: 0x0002, 0x20ec: 0x0002, 0x20ed: 0x0002, 0x20ee: 0x0002, 0x20ef: 0x0002,
	0x20f0: 0x0002, 0x20f1: 0x0002, 0x20f2: 0x0002, 0x20f3: 0x0002, 0x20f4: 0x0002, 0x20f5: 0x0002,
	0x20f6: 0x0002, 0x20f7: 0x0002, 0x20f8: 0x0002, 0x20f9: 0x0002, 0x20fa: 0x0002, 0x20fb: 0x0002,
	0x20fc: 0x0002, 0x20fd: 0x0002, 0x20fe: 0x0002, 0x20ff: 0x0002,
	// Block 0x84, offset 0x2100
	0x2100: 0x0002, 0x2101: 0x0002, 0x2102: 0x0002, 0x2103: 0x0002, 0x2104: 0x0002, 0x2105: 0x0002,
	0x2106: 0x0002, 0x2107: 0x0002, 0x2108: 0x0002, 0x2109: 0x0002, 0x210a: 0x0002, 0x210b: 0x0002,
	0x210c: 0x0002, 0x210d: 0x0002, 0x210e: 0x0002, 0x210f: 0x0002, 0x2110: 0x0002, 0x2111: 0x0002,
	0x2112: 0x0002, 0x2113: 0x0002, 0x2114: 0x0002, 0x2115: 0x0002, 0x2116: 0x0002,
	0x2119: 0x0010, 0x211a: 0x0010, 0x211b: 0x0202, 0x211c: 0x0202, 0x211d: 0x0002,
	0x211e: 0x0002, 0x211f: 0x0002, 0x2120: 0x0202, 0x2121: 0x0202, 0x2122: 0x0202, 0x2123: 0x0202,
	0x2124: 0x0202, 0x2125: 0x0202, 0x2126: 0x0202, 0x2127: 0x0202, 0x2128: 0x0202, 0x2129: 0x0202,
	0x212a: 0x0202, 0x212b: 0x0202, 0x212c: 0x0202, 0x212d: 0x0202, 0x212e: 0x0202, 0x212f: 0x0202,
	0x2130: 0x0202, 0x2131: 0x0202, 0x2132: 0x0202, 0x2133: 0x0202, 0x2134: 0x0202, 0x2135: 0x0202,
	0x2136: 0x0202, 0x2137: 0x0202, 0x2138: 0x0202, 0x2139: 0x0202, 0x213a: 0x0202, 0x213b: 0x0202,
	0x213c: 0x0202, 0x213d: 0x0202, 0x213e: 0x0202, 0x213f: 0x0202,
	// Block 0x85, offset 0x2140
	0x2140: 0x0202, 0x2141: 0x0202, 0x2142: 0x0202, 0x2143: 0x0202, 0x2144: 0x0202, 0x2145: 0x0202,
	0x2146: 0x0202, 0x2147: 0x0202, 0x2148: 0x0202, 0x2149: 0x0202, 0x214a: 0x0202, 0x214b: 0x0202,
	0x214c: 0x0202, 0x214d: 0x0202, 0x214e: 0x0202, 0x214f: 0x0202, 0x2150: 0x0202, 0x2151: 0x0202,
	0x2152: 0x0202, 0x2153: 0x0202, 0x2154: 0x0202, 0x2155: 0x0202, 0x2156: 0x0202, 0x2157: 0x0202,
	0x2158: 0x0202, 0x2159: 0x0202, 0x215a: 0x0202, 0x215b: 0x0202, 0x215c: 0x0202, 0x215d: 0x0202,
	0x215e: 0x0202, 0x215f: 0x0202, 0x2160: 0x0202, 0x2161: 0x0202, 0x2162: 0x0202, 0x2163: 0x0202,
	0x2164: 0x0202, 0x2165: 0x0202, 0x2166: 0x0202, 0x2167: 0x0202, 0x2168: 0x0202, 0x2169: 0x0202,
	0x216a: 0x0202, 0x216b: 0x0202, 0x216c: 0x0202, 0x216d: 0x0202, 0x216e: 0x0202, 0x216f: 0x0202,
	0x2170: 0x0202, 0x2171: 0x0202, 0x2172: 0x0202, 0x2173: 0x0202, 0x2174: 0x0202, 0x2175: 0x0202,
	0x2176: 0x0202, 0x2177: 0x0202, 0x2178: 0x0202, 0x2179: 0x0202, 0x217a: 0x0202,
	0x217c: 0x0202, 0x217d: 0x0202, 0x217e: 0x0202, 0x217f: 0x0202,
	// Block 0x86, offset 0x2180
	0x2185: 0x0001,
	0x2186: 0x0001, 0x2187: 0x0001, 0x2188: 0x0001, 0x2189: 0x0001, 0x218a: 0x0001, 0x218b: 0x0001,
	0x218c: 0x0001, 0x218d: 0x0001, 0x218e: 0x0001, 0x218f: 0x0001, 0x2190: 0x0001, 0x2191: 0x0001,
	0x2192: 0x0001, 0x2193: 0x0001, 0x2194: 0x0001, 0x2195: 0x0001, 0x2196: 0x0001, 0x2197: 0x0001,
	0x2198: 0x0001, 0x2199: 0x0001, 0x219a: 0x0001, 0x219b: 0x0001, 0x219c: 0x0001, 0x219d: 0x0001,
	0x219e: 0x0001, 0x219f: 0x0001, 0x21a0: 0x0001, 0x21a1: 0x0001, 0x21a2: 0x0001, 0x21a3: 0x0001,
	0x21a4: 0x0001, 0x21a5: 0x0001, 0x21a6: 0x0001, 0x21a7: 0x0001, 0x21a8: 0x0001, 0x21a9: 0x0001,
	0x21aa: 0x0001, 0x21ab: 0x0001, 0x21ac: 0x0001, 0x21ad: 0x0001, 0x21ae: 0x0001, 0x21af: 0x0001,
	0x21b1: 0x0001, 0x21b2: 0x0001, 0x21b3: 0x0001, 0x21b4: 0x0001, 0x21b5: 0x0001,
	0x21b6: 0x0001, 0x21b7: 0x0001, 0x21b8: 0x0001, 0x21b9: 0x0001, 0x21ba: 0x0001, 0x21bb: 0x0001,
	0x21bc: 0x0001, 0x21bd: 0x0001, 0x21be: 0x0001, 0x21bf: 0x0001,
	// Block 0x87, offset 0x21c0
	0x21c0: 0x0001, 0x21c1: 0x0001, 0x21c2: 0x0001, 0x21c3: 0x0001, 0x21c4: 0x0001, 0x21c5: 0x0001,
	0x21c6: 0x0001, 0x21c7: 0x0001, 0x21c8: 0x0001, 0x21c9: 0x0001, 0x21ca: 0x0001, 0x21cb: 0x0001,
	0x21cc: 0x0001, 0x21cd: 0x0001, 0x21ce: 0x0001,
	0x21e0: 0x0001, 0x21e1: 0x0001, 0x21e2: 0x0001, 0x21e3: 0x0001,
	0x21e4: 0x0001, 0x21e5: 0x0001, 0x21e6: 0x0001, 0x21e7: 0x0001, 0x21e8: 0x0001, 0x21e9: 0x0001,
	0x21ea: 0x0001, 0x21eb: 0x0001, 0x21ec: 0x0001, 0x21ed: 0x0001, 0x21ee: 0x0001, 0x21ef: 0x0001,
	0x21f0: 0x0001, 0x21f1: 0x0001, 0x21f2: 0x0001, 0x21f3: 0x0001, 0x21f4: 0x0001, 0x21f5: 0x0001,
	0x21f6: 0x0001, 0x21f7: 0x0001, 0x21f8: 0x0001, 0x21f9: 0x0001, 0x21fa: 0x0001, 0x21fb: 0x0001,
	0x21fc: 0x0001, 0x21fd: 0x0001, 0x21fe: 0x0001, 0x21ff: 0x0001,
	// Block 0x88, offset 0x2200
	0x2230: 0x0202, 0x2231: 0x0202, 0x2232: 0x0202, 0x2233: 0x0202, 0x2234: 0x0202, 0x2235: 0x0202,
	0x2236: 0x0202, 0x2237: 0x0202, 0x2238: 0x0202, 0x2239: 0x0202, 0x223a: 0x0202, 0x223b: 0x0202,
	0x223c: 0x0202, 0x223d: 0x0202, 0x223e: 0x0202, 0x223f: 0x0202,
	// Block 0x89, offset 0x2240
	0x2257: 0x0040,
	0x2259: 0x0040,
	// Block 0x8a, offset 0x2280
	0x2290: 0x0202, 0x2291: 0x0202,
	0x2292: 0x0202, 0x2293: 0x0202, 0x2294: 0x0202, 0x2295: 0x0202, 0x2296: 0x0202, 0x2297: 0x0202,
	0x2298: 0x0202, 0x2299: 0x0202, 0x229a: 0x0202, 0x229b: 0x0202, 0x229c: 0x0202, 0x229d: 0x0202,
	0x229e: 0x0202, 0x229f: 0x0202, 0x22a0: 0x0202, 0x22a1: 0x0202, 0x22a2: 0x0202, 0x22a3: 0x0202,
	0x22a4: 0x0202, 0x22a5: 0x0202, 0x22a6: 0x0202, 0x22a7: 0x0202, 0x22a8: 0x0202, 0x22a9: 0x0202,
	0x22aa: 0x0202, 0x22ab: 0x0202, 0x22ac: 0x0202, 0x22ad: 0x0202, 0x22ae: 0x0202, 0x22af: 0x0202,
	0x22b0: 0x0202, 0x22b1: 0x0202, 0x22b2: 0x0202, 0x22b3: 0x0202, 0x22b4: 0x0202, 0x22b5: 0x0202,
	0x22b6: 0x0202, 0x22b7: 0x0202, 0x22b8: 0x0202, 0x22b9: 0x0202, 0x22ba: 0x0202, 0x22bb: 0x0202,
	0x22bc: 0x0202, 0x22bd: 0x0202, 0x22be: 0x0202,
	// Block 0x8b, offset 0x22c0
	0x22c0: 0x0202, 0x22c1: 0x0202, 0x22c2: 0x0202, 0x22c3: 0x0202, 0x22c4: 0x0202, 0x22c5: 0x0202,
	0x22c6: 0x0202, 0x22c7: 0x0202, 0x22c8: 0x0202, 0x22c9: 0x0202, 0x22ca: 0x0202, 0x22cb: 0x0202,
	0x22cc: 0x0202, 0x22cd: 0x0202, 0x22ce: 0x0202, 0x22cf: 0x0202, 0x22d0: 0x0202, 0x22d1: 0x0202,
	0x22d2: 0x0202, 0x22d3: 0x0202, 0x22d4: 0x0202, 0x22d5: 0x0202, 0x22d6: 0x0202, 0x22d7: 0x0202,
	0x22d8: 0x0202, 0x22d9: 0x0202, 0x22da: 0x0202, 0x22db: 0x0202, 0x22dc: 0x0202, 0x22dd: 0x0202,
	0x22de: 0x0202, 0x22df: 0x0202, 0x22e0: 0x0202, 0x22e1: 0x0202, 0x22e2: 0x0202, 0x22e3: 0x0202,
	0x22e4: 0x0202, 0x22e5: 0x0202, 0x22e6: 0x0202, 0x22e7: 0x0202, 0x22e8: 0x0202, 0x22e9: 0x0202,
	0x22ea: 0x0202, 0x22eb: 0x0202, 0x22ec: 0x0202, 0x22ed: 0x0202, 0x22ee: 0x0202, 0x22ef: 0x0202,
	0x22f0: 0x0202, 0x22f1: 0x0202, 0x22f2: 0x0202, 0x22f3: 0x0202, 0x22f4: 0x0202, 0x22f5: 0x0202,
	0x22f6: 0x0202, 0x22f7: 0x0202, 0x22f8: 0x0202, 0x22f9: 0x0202, 0x22fa: 0x0202, 0x22fb: 0x0202,
	0x22fc: 0x0202, 0x22fd: 0x0202, 0x22fe: 0x0202, 0x22ff: 0x0202,
	// Block 0x8c, offset 0x2300
	0x2300: 0x0202, 0x2301: 0x0202, 0x2302: 0x0202, 0x2303: 0x0202, 0x2304: 0x0202, 0x2305: 0x0202,
	0x2306: 0x0202, 0x2307: 0x0202, 0x2308: 0x0202, 0x2309: 0x0202, 0x230a: 0x0202, 0x230b: 0x0202,
	0x230c: 0x0202, 0x230d: 0x0202, 0x230e: 0x0202, 0x230f: 0x0202, 0x2310: 0x0202, 0x2311: 0x0202,
	0x2312: 0x0202, 0x2313: 0x0202, 0x2314: 0x0202, 0x2315: 0x0202, 0x2316: 0x0202, 0x2317: 0x0202,
	// Block 0x8d, offset 0x2340
	0x2340: 0x0001, 0x2341: 0x0001, 0x2342: 0x0001, 0x2343: 0x0001, 0x2344: 0x0001, 0x2345: 0x0001,
	0x2346: 0x0001, 0x2347: 0x0001, 0x2348: 0x0001, 0x2349: 0x0001, 0x234a: 0x0001, 0x234b: 0x0001,
	0x234c: 0x0001,
	// Block 0x8e, offset 0x2380
	0x2390: 0x0001, 0x2391: 0x0001,
	0x2392: 0x0001, 0x2393: 0x0001, 0x2394: 0x0001, 0x2395: 0x0001, 0x2396: 0x0001, 0x2397: 0x0001,
	0x2398: 0x0001, 0x2399: 0x0001, 0x239a: 0x0001, 0x239b: 0x0001, 0x239c: 0x0001, 0x239d: 0x0001,
	0x239e: 0x0001, 0x239f: 0x0001, 0x23a0: 0x0001, 0x23a1: 0x0001, 0x23a2: 0x0001, 0x23a3: 0x0001,
	0x23a4: 0x0001, 0x23a5: 0x0001, 0x23a6: 0x0001, 0x23a7: 0x0001, 0x23a8: 0x0001, 0x23a9: 0x0001,
	0x23aa: 0x0001, 0x23ab: 0x0001, 0x23ac: 0x0001, 0x23ad: 0x0001, 0x23ae: 0x0001, 0x23af: 0x0001,
	0x23b0: 0x0001, 0x23b1: 0x0001, 0x23b2: 0x0001, 0x23b3: 0x0001, 0x23b4: 0x0001, 0x23b5: 0x0001,
	0x23b6: 0x0001, 0x23b7: 0x0001, 0x23b8: 0x0001, 0x23b9: 0x0001, 0x23ba: 0x0001, 0x23bb: 0x0001,
	0x23bc: 0x0001, 0x23bd: 0x0001,
	// Block 0x8f, offset 0x23c0
	0x23c0: 0x0001, 0x23c1: 0x0001, 0x23c2: 0x0001, 0x23c3: 0x0001, 0x23c4: 0x0001, 0x23c5: 0x0001,
	0x23c6: 0x0001, 0x23c7: 0x0001, 0x23c8: 0x0001, 0x23c9: 0x0001, 0x23ca: 0x0001, 0x23cb: 0x0001,
	0x23cc: 0x0001, 0x23d0: 0x0001, 0x23d1: 0x0001,
	0x23d2: 0x0001, 0x23d3: 0x0001, 0x23d4: 0x0001, 0x23d5: 0x0001, 0x23d6: 0x0001, 0x23d7: 0x0001,
	0x23d8: 0x0001, 0x23d9: 0x0001, 0x23da: 0x0001, 0x23db: 0x0001, 0x23dc: 0x0001, 0x23dd: 0x0001,
	0x23de: 0x0001, 0x23df: 0x0001, 0x23e0: 0x8000, 0x23e1: 0x8000, 0x23e2: 0x8000, 0x23e3: 0x8000,
	0x23e4: 0x8000, 0x23e5: 0x8000, 0x23e6: 0x8000, 0x23e7: 0x8000, 0x23e8: 0x8000, 0x23e9: 0x8000,
	0x23ea: 0x0001, 0x23eb: 0x0001,
	// Block 0x90, offset 0x2400
	0x2400: 0x0001, 0x2401: 0x0001, 0x2402: 0x0001, 0x2403: 0x0001, 0x2404: 0x0001, 0x2405: 0x0001,
	0x2406: 0x0001, 0x2407: 0x0001, 0x2408: 0x0001, 0x2409: 0x0001, 0x240a: 0x0001, 0x240b: 0x0001,
	0x240c: 0x0001, 0x240d: 0x0001, 0x240e: 0x0001, 0x240f: 0x0001, 0x2410: 0x0001, 0x2411: 0x0001,
	0x2412: 0x0001, 0x2413: 0x0001, 0x2414: 0x0001, 0x2415: 0x0001, 0x2416: 0x0001, 0x2417: 0x0001,
	0x2418: 0x0001, 0x2419: 0x0001, 0x241a: 0x0001, 0x241b: 0x0001, 0x241c: 0x0001, 0x241d: 0x0001,
	0x241e: 0x0001, 0x241f: 0x0001, 0x2420: 0x0001, 0x2421: 0x0001, 0x2422: 0x0001, 0x2423: 0x0001,
	0x2424: 0x0001, 0x2425: 0x0001, 0x2426: 0x0001, 0x2427: 0x0001, 0x2428: 0x0001, 0x2429: 0x0001,
	0x242a: 0x0001, 0x242b: 0x0001, 0x242c: 0x0001, 0x242d: 0x0001, 0x242e: 0x0001, 0x242f: 0x0010,
	0x2430: 0x0010, 0x2431: 0x0010, 0x2432: 0x0010, 0x2434: 0x0010, 0x2435: 0x0010,
	0x2436: 0x0010, 0x2437: 0x0010, 0x2438: 0x0010, 0x2439: 0x0010, 0x243a: 0x0010, 0x243b: 0x0010,
	0x243c: 0x0010, 0x243d: 0x0010, 0x243f: 0x0001,
	// Block 0x91, offset 0x2440
	0x2440: 0x0001, 0x2441: 0x0001, 0x2442: 0x0001, 0x2443: 0x0001, 0x2444: 0x0001, 0x2445: 0x0001,
	0x2446: 0x0001, 0x2447: 0x0001, 0x2448: 0x0001, 0x2449: 0x0001, 0x244a: 0x0001, 0x244b: 0x0001,
	0x244c: 0x0001, 0x244d: 0x0001, 0x244e: 0x0001, 0x244f: 0x0001, 0x2450: 0x0001, 0x2451: 0x0001,
	0x2452: 0x0001, 0x2453: 0x0001, 0x2454: 0x0001, 0x2455: 0x0001, 0x2456: 0x0001, 0x2457: 0x0001,
	0x2458: 0x0001, 0x2459: 0x0001, 0x245a: 0x0001, 0x245b: 0x0001, 0x245c: 0x0001, 0x245d: 0x0001,
	0x245e: 0x0010, 0x245f: 0x0010, 0x2460: 0x0001, 0x2461: 0x0001, 0x2462: 0x0001, 0x2463: 0x0001,
	0x2464: 0x0001, 0x2465: 0x0001, 0x2466: 0x0001, 0x2467: 0x0001, 0x2468: 0x0001, 0x2469: 0x0001,
	0x246a: 0x0001, 0x246b: 0x0001, 0x246c: 0x0001, 0x246d: 0x0001, 0x246e: 0x0001, 0x246f: 0x0001,
	0x2470: 0x0001, 0x2471: 0x0001, 0x2472: 0x0001, 0x2473: 0x0001, 0x2474: 0x0001, 0x2475: 0x0001,
	0x2476: 0x0001, 0x2477: 0x0001, 0x2478: 0x0001, 0x2479: 0x0001, 0x247a: 0x0001, 0x247b: 0x0001,
	0x247c: 0x0001, 0x247d: 0x0001, 0x247e: 0x0001, 0x247f: 0x0001,
	// Block 0x92, offset 0x2480
	0x2480: 0x0001, 0x2481: 0x0001, 0x2482: 0x0001, 0x2483: 0x0001, 0x2484: 0x0001, 0x2485: 0x0001,
	0x2486: 0x0001, 0x2487: 0x0001, 0x2488: 0x0001, 0x2489: 0x0001, 0x248a: 0x0001, 0x248b: 0x0001,
	0x248c: 0x0001, 0x248d: 0x0001, 0x248e: 0x0001, 0x248f: 0x0001, 0x2490: 0x0001, 0x2491: 0x0001,
	0x2492: 0x0001, 0x2493: 0x0001, 0x2494: 0x0001, 0x2495: 0x0001, 0x2496: 0x0001, 0x2497: 0x0001,
	0x2498: 0x0001, 0x2499: 0x0001, 0x249a: 0x0001, 0x249b: 0x0001, 0x249c: 0x0001, 0x249d: 0x0001,
	0x249e: 0x0001, 0x249f: 0x0001, 0x24a0: 0x0001, 0x24a1: 0x0001, 0x24a2: 0x0001, 0x24a3: 0x0001,
	0x24a4: 0x0001, 0x24a5: 0x0001, 0x24a6: 0x0001, 0x24a7: 0x0001, 0x24a8: 0x0001, 0x24a9: 0x0001,
	0x24aa: 0x0001, 0x24ab: 0x0001, 0x24ac: 0x0001, 0x24ad: 0x0001, 0x24ae: 0x0001, 0x24af: 0x0001,
	0x24b0: 0x0010, 0x24b1: 0x0010,
	// Block 0x93, offset 0x24c0
	0x24c8: 0x0001, 0x24c9: 0x0001, 0x24ca: 0x0001, 0x24cb: 0x0001,
	0x24cc: 0x0001, 0x24cd: 0x0001, 0x24ce: 0x0001, 0x24cf: 0x0001, 0x24d0: 0x0001, 0x24d1: 0x0001,
	0x24d2: 0x0001, 0x24d3: 0x0001, 0x24d4: 0x0001, 0x24d5: 0x0001, 0x24d6: 0x0001, 0x24d7: 0x0001,
	0x24d8: 0x0001, 0x24d9: 0x0001, 0x24da: 0x0001, 0x24db: 0x0001, 0x24dc: 0x0001, 0x24dd: 0x0001,
	0x24de: 0x0001, 0x24df: 0x0001, 0x24e0: 0x0001, 0x24e1: 0x0001, 0x24e2: 0x0001, 0x24e3: 0x0001,
	0x24e4: 0x0001, 0x24e5: 0x0001, 0x24e6: 0x0001, 0x24e7: 0x0001, 0x24e8: 0x0001, 0x24e9: 0x0001,
	0x24ea: 0x0001, 0x24eb: 0x0001, 0x24ec: 0x0001, 0x24ed: 0x0001, 0x24ee: 0x0001, 0x24ef: 0x0001,
	0x24f0: 0x0001, 0x24f1: 0x0001, 0x24f2: 0x0001, 0x24f3: 0x0001, 0x24f4: 0x0001, 0x24f5: 0x0001,
	0x24f6: 0x0001, 0x24f7: 0x0001, 0x24f8: 0x0001, 0x24f9: 0x0001, 0x24fa: 0x0001, 0x24fb: 0x0001,
	0x24fc: 0x0001, 0x24fd: 0x0001, 0x24fe: 0x0001, 0x24ff: 0x0001,
	// Block 0x94, offset 0x2500
	0x2500: 0x0001, 0x2501: 0x0001, 0x2502: 0x0001, 0x2503: 0x0001, 0x2504: 0x0001, 0x2505: 0x0001,
	0x2506: 0x0001, 0x2507: 0x0001, 0x2508: 0x0001, 0x2509: 0x0001, 0x250a: 0x0001,
	0x2510: 0x0001, 0x2511: 0x0001,
	0x2513: 0x0001, 0x2515: 0x0001, 0x2516: 0x0001, 0x2517: 0x0001,
	0x2518: 0x0001, 0x2519: 0x0001,
	0x2532: 0x0001, 0x2533: 0x0001, 0x2534: 0x0001, 0x2535: 0x0001,
	0x2536: 0x0001, 0x2537: 0x0001, 0x2538: 0x0001, 0x2539: 0x0001, 0x253a: 0x0001, 0x253b: 0x0001,
	0x253c: 0x0001, 0x253d: 0x0001, 0x253e: 0x0001, 0x253f: 0x0001,
	// Block 0x95, offset 0x2540
	0x2540: 0x0001, 0x2541: 0x0001, 0x2542: 0x0010, 0x2543: 0x0001, 0x2544: 0x0001, 0x2545: 0x0001,
	0x2546: 0x0010, 0x2547: 0x0001, 0x2548: 0x0001, 0x2549: 0x0001, 0x254a: 0x0001, 0x254b: 0x0010,
	0x254c: 0x0001, 0x254d: 0x0001, 0x254e: 0x0001, 0x254f: 0x0001, 0x2550: 0x0001, 0x2551: 0x0001,
	0x2552: 0x0001, 0x2553: 0x0001, 0x2554: 0x0001, 0x2555: 0x0001, 0x2556: 0x0001, 0x2557: 0x0001,
	0x2558: 0x0001, 0x2559: 0x0001, 0x255a: 0x0001, 0x255b: 0x0001, 0x255c: 0x0001, 0x255d: 0x0001,
	0x255e: 0x0001, 0x255f: 0x0001, 0x2560: 0x0001, 0x2561: 0x0001, 0x2562: 0x0001, 0x2563: 0x0010,
	0x2564: 0x0010, 0x2565: 0x0010, 0x2566: 0x0010, 0x2567: 0x0010,
	0x256c: 0x0010,
	// Block 0x96, offset 0x2580
	0x2580: 0x0001, 0x2581: 0x0001, 0x2582: 0x0001, 0x2583: 0x0001, 0x2584: 0x0001, 0x2585: 0x0001,
	0x2586: 0x0001, 0x2587: 0x0001, 0x2588: 0x0001, 0x2589: 0x0001, 0x258a: 0x0001, 0x258b: 0x0001,
	0x258c: 0x0001, 0x258d: 0x0001, 0x258e: 0x0001, 0x258f: 0x0001, 0x2590: 0x0001, 0x2591: 0x0001,
	0x2592: 0x0001, 0x2593: 0x0001, 0x2594: 0x0001, 0x2595: 0x0001, 0x2596: 0x0001, 0x2597: 0x0001,
	0x2598: 0x0001, 0x2599: 0x0001, 0x259a: 0x0001, 0x259b: 0x0001, 0x259c: 0x0001, 0x259d: 0x0001,
	0x259e: 0x0001, 0x259f: 0x0001, 0x25a0: 0x0001, 0x25a1: 0x0001, 0x25a2: 0x0001, 0x25a3: 0x0001,
	0x25a4: 0x0001, 0x25a5: 0x0001, 0x25a6: 0x0001, 0x25a7: 0x0001, 0x25a8: 0x0001, 0x25a9: 0x0001,
	0x25aa: 0x0001, 0x25ab: 0x0001, 0x25ac: 0x0001, 0x25ad: 0x0001, 0x25ae: 0x0001, 0x25af: 0x0001,
	0x25b0: 0x0001, 0x25b1: 0x0001, 0x25b2: 0x0001, 0x25b3: 0x0001,
	// Block 0x97, offset 0x25c0
	0x25c0: 0x0010, 0x25c1: 0x0010, 0x25c2: 0x0001, 0x25c3: 0x0001, 0x25c4: 0x0001, 0x25c5: 0x0001,
	0x25c6: 0x0001, 0x25c7: 0x0001, 0x25c8: 0x0001, 0x25c9: 0x0001, 0x25ca: 0x0001, 0x25cb: 0x0001,
	0x25cc: 0x0001, 0x25cd: 0x0001, 0x25ce: 0x0001, 0x25cf: 0x0001, 0x25d0: 0x0001, 0x25d1: 0x0001,
	0x25d2: 0x0001, 0x25d3: 0x0001, 0x25d4: 0x0001, 0x25d5: 0x0001, 0x25d6: 0x0001, 0x25d7: 0x0001,
	0x25d8: 0x0001, 0x25d9: 0x0001, 0x25da: 0x0001, 0x25db: 0x0001, 0x25dc: 0x0001, 0x25dd: 0x0001,
	0x25de: 0x0001, 0x25df: 0x0001, 0x25e0: 0x0001, 0x25e1: 0x0001, 0x25e2: 0x0001, 0x25e3: 0x0001,
	0x25e4: 0x0001, 0x25e5: 0x0001, 0x25e6: 0x0001, 0x25e7: 0x0001, 0x25e8: 0x0001, 0x25e9: 0x0001,
	0x25ea: 0x0001, 0x25eb: 0x0001, 0x25ec: 0x0001, 0x25ed: 0x0001, 0x25ee: 0x0001, 0x25ef: 0x0001,
	0x25f0: 0x0001, 0x25f1: 0x0001, 0x25f2: 0x0001, 0x25f3: 0x0001, 0x25f4: 0x0010, 0x25f5: 0x0010,
	0x25f6: 0x0010, 0x25f7: 0x0010, 0x25f8: 0x0010, 0x25f9: 0x0010, 0x25fa: 0x0010, 0x25fb: 0x0010,
	0x25fc: 0x0010, 0x25fd: 0x0010, 0x25fe: 0x0010, 0x25ff: 0x0010,
	// Block 0x98, offset 0x2600
	0x2600: 0x0010, 0x2601: 0x0010, 0x2602: 0x0010, 0x2603: 0x0010, 0x2604: 0x0010, 0x2605: 0x0010,
	0x2610: 0x8000, 0x2611: 0x8000,
	0x2612: 0x8000, 0x2613: 0x8000, 0x2614: 0x8000, 0x2615: 0x8000, 0x2616: 0x8000, 0x2617: 0x8000,
	0x2618: 0x8000, 0x2619: 0x8000,
	0x2620: 0x0010, 0x2621: 0x0010, 0x2622: 0x0010, 0x2623: 0x0010,
	0x2624: 0x0010, 0x2625: 0x0010, 0x2626: 0x0010, 0x2627: 0x0010, 0x2628: 0x0010, 0x2629: 0x0010,
	0x262a: 0x0010, 0x262b: 0x0010, 0x262c: 0x0010, 0x262d: 0x0010, 0x262e: 0x0010, 0x262f: 0x0010,
	0x2630: 0x0010, 0x2631: 0x0010, 0x2632: 0x0001, 0x2633: 0x0001, 0x2634: 0x0001, 0x2635: 0x0001,
	0x2636: 0x0001, 0x2637: 0x0001, 0x263b: 0x0001,
	0x263d: 0x0001, 0x263e: 0x0001, 0x263f: 0x0010,
	// Block 0x99, offset 0x2640
	0x2640: 0x8000, 0x2641: 0x8000, 0x2642: 0x8000, 0x2643: 0x8000, 0x2644: 0x8000, 0x2645: 0x8000,
	0x2646: 0x8000, 0x2647: 0x8000, 0x2648: 0x8000, 0x2649: 0x8000, 0x264a: 0x0001, 0x264b: 0x0001,
	0x264c: 0x0001, 0x264d: 0x0001, 0x264e: 0x0001, 0x264f: 0x0001, 0x2650: 0x0001, 0x2651: 0x0001,
	0x2652: 0x0001, 0x2653: 0x0001, 0x2654: 0x0001, 0x2655: 0x0001, 0x2656: 0x0001, 0x2657: 0x0001,
	0x2658: 0x0001, 0x2659: 0x0001, 0x265a: 0x0001, 0x265b: 0x0001, 0x265c: 0x0001, 0x265d: 0x0001,
	0x265e: 0x0001, 0x265f: 0x0001, 0x2660: 0x0001, 0x2661: 0x0001, 0x2662: 0x0001, 0x2663: 0x0001,
	0x2664: 0x0001, 0x2665: 0x0001, 0x2666: 0x0010, 0x2667: 0x0010, 0x2668: 0x0010, 0x2669: 0x0010,
	0x266a: 0x0010, 0x266b: 0x0010, 0x266c: 0x0010, 0x266d: 0x0010,
	0x2670: 0x0001, 0x2671: 0x0001, 0x2672: 0x0001, 0x2673: 0x0001, 0x2674: 0x0001, 0x2675: 0x0001,
	0x2676: 0x0001, 0x2677: 0x0001, 0x2678: 0x0001, 0x2679: 0x0001, 0x267a: 0x0001, 0x267b: 0x0001,
	0x267c: 0x0001, 0x267d: 0x0001, 0x267e: 0x0001, 0x267f: 0x0001,
	// Block 0x9a, offset 0x2680
	0x2680: 0x0001, 0x2681: 0x0001, 0x2682: 0x0001, 0x2683: 0x0001, 0x2684: 0x0001, 0x2685: 0x0001,
	0x2686: 0x0001, 0x2687: 0x0010, 0x2688: 0x0010, 0x2689: 0x0010, 0x268a: 0x0010, 0x268b: 0x0010,
	0x268c: 0x0010, 0x268d: 0x0010, 0x268e: 0x0010, 0x268f: 0x0010, 0x2690: 0x0010, 0x2691: 0x0010,
	0x2692: 0x0010, 0x2693: 0x0010,
	0x26a0: 0x0001, 0x26a1: 0x0001, 0x26a2: 0x0001, 0x26a3: 0x0001,
	0x26a4: 0x0001, 0x26a5: 0x0001, 0x26a6: 0x0001, 0x26a7: 0x0001, 0x26a8: 0x0001, 0x26a9: 0x0001,
	0x26aa: 0x0001, 0x26ab: 0x0001, 0x26ac: 0x0001, 0x26ad: 0x0001, 0x26ae: 0x0001, 0x26af: 0x0001,
	0x26b0: 0x0001, 0x26b1: 0x0001, 0x26b2: 0x0001, 0x26b3: 0x0001, 0x26b4: 0x0001, 0x26b5: 0x0001,
	0x26b6: 0x0001, 0x26b7: 0x0001, 0x26b8: 0x0001, 0x26b9: 0x0001, 0x26ba: 0x0001, 0x26bb: 0x0001,
	0x26bc: 0x0001,
	// Block 0x9b, offset 0x26c0
	0x26c0: 0x0010, 0x26c1: 0x0010, 0x26c2: 0x0010, 0x26c3: 0x0010, 0x26c4: 0x0001, 0x26c5: 0x0001,
	0x26c6: 0x0001, 0x26c7: 0x0001, 0x26c8: 0x0001, 0x26c9: 0x0001, 0x26ca: 0x0001, 0x26cb: 0x0001,
	0x26cc: 0x0001, 0x26cd: 0x0001, 0x26ce: 0x0001, 0x26cf: 0x0001, 0x26d0: 0x0001, 0x26d1: 0x0001,
	0x26d2: 0x0001, 0x26d3: 0x0001, 0x26d4: 0x0001, 0x26d5: 0x0001, 0x26d6: 0x0001, 0x26d7: 0x0001,
	0x26d8: 0x0001, 0x26d9: 0x0001, 0x26da: 0x0001, 0x26db: 0x0001, 0x26dc: 0x0001, 0x26dd: 0x0001,
	0x26de: 0x0001, 0x26df: 0x0001, 0x26e0: 0x0001, 0x26e1: 0x0001, 0x26e2: 0x0001, 0x26e3: 0x0001,
	0x26e4: 0x0001, 0x26e5: 0x0001, 0x26e6: 0x0001, 0x26e7: 0x0001, 0x26e8: 0x0001, 0x26e9: 0x0001,
	0x26ea: 0x0001, 0x26eb: 0x0001, 0x26ec: 0x0001, 0x26ed: 0x0001, 0x26ee: 0x0001, 0x26ef: 0x0001,
	0x26f0: 0x0001, 0x26f1: 0x0001, 0x26f2: 0x0001, 0x26f3: 0x0010, 0x26f4: 0x0010, 0x26f5: 0x0010,
	0x26f6: 0x0010, 0x26f7: 0x0010, 0x26f8: 0x0010, 0x26f9: 0x0010, 0x26fa: 0x0010, 0x26fb: 0x0010,
	0x26fc: 0x0010, 0x26fd: 0x0010, 0x26fe: 0x0010, 0x26ff: 0x0010,
	// Block 0x9c, offset 0x2700
	0x2700: 0x0010,
	0x270f: 0x0001, 0x2710: 0x8000, 0x2711: 0x8000,
	0x2712: 0x8000, 0x2713: 0x8000, 0x2714: 0x8000, 0x2715: 0x8000, 0x2716: 0x8000, 0x2717: 0x8000,
	0x2718: 0x8000, 0x2719: 0x8000,
	0x2725: 0x0010,
	0x2730: 0x8000, 0x2731: 0x8000, 0x2732: 0x8000, 0x2733: 0x8000, 0x2734: 0x8000, 0x2735: 0x8000,
	0x2736: 0x8000, 0x2737: 0x8000, 0x2738: 0x8000, 0x2739: 0x8000,
	// Block 0x9d, offset 0x2740
	0x2740: 0x0001, 0x2741: 0x0001, 0x2742: 0x0001, 0x2743: 0x0001, 0x2744: 0x0001, 0x2745: 0x0001,
	0x2746: 0x0001, 0x2747: 0x0001, 0x2748: 0x0001, 0x2749: 0x0001, 0x274a: 0x0001, 0x274b: 0x0001,
	0x274c: 0x0001, 0x274d: 0x0001, 0x274e: 0x0001, 0x274f: 0x0001, 0x2750: 0x0001, 0x2751: 0x0001,
	0x2752: 0x0001, 0x2753: 0x0001, 0x2754: 0x0001, 0x2755: 0x0001, 0x2756: 0x0001, 0x2757: 0x0001,
	0x2758: 0x0001, 0x2759: 0x0001, 0x275a: 0x0001, 0x275b: 0x0001, 0x275c: 0x0001, 0x275d: 0x0001,
	0x275e: 0x0001, 0x275f: 0x0001, 0x2760: 0x0001, 0x2761: 0x0001, 0x2762: 0x0001, 0x2763: 0x0001,
	0x2764: 0x0001, 0x2765: 0x0001, 0x2766: 0x0001, 0x2767: 0x0001, 0x2768: 0x0001, 0x2769: 0x0010,
	0x276a: 0x0010, 0x276b: 0x0010, 0x276c: 0x0010, 0x276d: 0x0010, 0x276e: 0x0010, 0x276f: 0x0010,
	0x2770: 0x0010, 0x2771: 0x0010, 0x2772: 0x0010, 0x2773: 0x0010, 0x2774: 0x0010, 0x2775: 0x0010,
	0x2776: 0x0010,
	// Block 0x9e, offset 0x2780
	0x2780: 0x0001, 0x2781: 0x0001, 0x2782: 0x0001, 0x2783: 0x0010, 0x2784: 0x0001, 0x2785: 0x0001,
	0x2786: 0x0001, 0x2787: 0x0001, 0x2788: 0x0001, 0x2789: 0x0001, 0x278a: 0x0001, 0x278b: 0x0001,
	0x278c: 0x0010, 0x278d: 0x0010, 0x2790: 0x8000, 0x2791: 0x8000,
	0x2792: 0x8000, 0x2793: 0x8000, 0x2794: 0x8000, 0x2795: 0x8000, 0x2796: 0x8000, 0x2797: 0x8000,
	0x2798: 0x8000, 0x2799: 0x8000,
	0x27bb: 0x0010,
	0x27bc: 0x0010, 0x27bd: 0x0010,
	// Block 0x9f, offset 0x27c0
	0x27f0: 0x0010, 0x27f2: 0x0010, 0x27f3: 0x0010, 0x27f4: 0x0010,
	0x27f7: 0x0010, 0x27f8: 0x0010,
	0x27fe: 0x0010, 0x27ff: 0x0010,
	// Block 0xa0, offset 0x2800
	0x2801: 0x0010,
	0x2820: 0x0001, 0x2821: 0x0001, 0x2822: 0x0001, 0x2823: 0x0001,
	0x2824: 0x0001, 0x2825: 0x0001, 0x2826: 0x0001, 0x2827: 0x0001, 0x2828: 0x0001, 0x2829: 0x0001,
	0x282a: 0x0001, 0x282b: 0x0010, 0x282c: 0x0010, 0x282d: 0x0010, 0x282e: 0x0010, 0x282f: 0x0010,
	0x2832: 0x0001, 0x2833: 0x0001, 0x2834: 0x0001, 0x2835: 0x0010,
	0x2836: 0x0010,
	// Block 0xa1, offset 0x2840
	0x2841: 0x0001, 0x2842: 0x0001, 0x2843: 0x0001, 0x2844: 0x0001, 0x2845: 0x0001,
	0x2846: 0x0001, 0x2849: 0x0001, 0x284a: 0x0001, 0x284b: 0x0001,
	0x284c: 0x0001, 0x284d: 0x0001, 0x284e: 0x0001, 0x2851: 0x0001,
	0x2852: 0x0001, 0x2853: 0x0001, 0x2854: 0x0001, 0x2855: 0x0001, 0x2856: 0x0001,
	0x2860: 0x0001, 0x2861: 0x0001, 0x2862: 0x0001, 0x2863: 0x0001,
	0x2864: 0x0001, 0x2865: 0x0001, 0x2866: 0x0001, 0x2868: 0x0001, 0x2869: 0x0001,
	0x286a: 0x0001, 0x286b: 0x0001, 0x286c: 0x0001, 0x286d: 0x0001, 0x286e: 0x0001,
	0x2870: 0x0001, 0x2871: 0x0001, 0x2872: 0x0001, 0x2873: 0x0001, 0x2874: 0x0001, 0x2875: 0x0001,
	0x2876: 0x0001, 0x2877: 0x0001, 0x2878: 0x0001, 0x2879: 0x0001, 0x287a: 0x0001, 0x287b: 0x0001,
	0x287c: 0x0001, 0x287d: 0x0001, 0x287e: 0x0001, 0x287f: 0x0001,
	// Block 0xa2, offset 0x2880
	0x2880: 0x0001, 0x2881: 0x0001, 0x2882: 0x0001, 0x2883: 0x0001, 0x2884: 0x0001, 0x2885: 0x0001,
	0x2886: 0x0001, 0x2887: 0x0001, 0x2888: 0x0001, 0x2889: 0x0001, 0x288a: 0x0001, 0x288b: 0x0001,
	0x288c: 0x0001, 0x288d: 0x0001, 0x288e: 0x0001, 0x288f: 0x0001, 0x2890: 0x0001, 0x2891: 0x0001,
	0x2892: 0x0001, 0x2893: 0x0001, 0x2894: 0x0001, 0x2895: 0x0001, 0x2896: 0x0001, 0x2897: 0x0001,
	0x2898: 0x0001, 0x2899: 0x0001, 0x289a: 0x0001, 0x289b: 0x0001, 0x289c: 0x0001, 0x289d: 0x0001,
	0x289e: 0x0001, 0x289f: 0x0001, 0x28a0: 0x0001, 0x28a1: 0x0001, 0x28a2: 0x0001, 0x28a3: 0x0001,
	0x28a4: 0x0001, 0x28a5: 0x0001, 0x28a6: 0x0001, 0x28a7: 0x0001, 0x28a8: 0x0001, 0x28a9: 0x0001,
	0x28b0: 0x0001, 0x28b1: 0x0001, 0x28b2: 0x0001, 0x28b3: 0x0001, 0x28b4: 0x0001, 0x28b5: 0x0001,
	0x28b6: 0x0001, 0x28b7: 0x0001, 0x28b8: 0x0001, 0x28b9: 0x0001, 0x28ba: 0x0001, 0x28bb: 0x0001,
	0x28bc: 0x0001, 0x28bd: 0x0001, 0x28be: 0x0001, 0x28bf: 0x0001,
	// Block 0xa3, offset 0x28c0
	0x28c0: 0x0001, 0x28c1: 0x0001, 0x28c2: 0x0001, 0x28c3: 0x0001, 0x28c4: 0x0001, 0x28c5: 0x0001,
	0x28c6: 0x0001, 0x28c7: 0x0001, 0x28c8: 0x0001, 0x28c9: 0x0001, 0x28ca: 0x0001, 0x28cb: 0x0001,
	0x28cc: 0x0001, 0x28cd: 0x0001, 0x28ce: 0x0001, 0x28cf: 0x0001, 0x28d0: 0x0001, 0x28d1: 0x0001,
	0x28d2: 0x0001, 0x28d3: 0x0001, 0x28d4: 0x0001, 0x28d5: 0x0001, 0x28d6: 0x0001, 0x28d7: 0x0001,
	0x28d8: 0x0001, 0x28d9: 0x0001, 0x28da: 0x0001, 0x28db: 0x0001, 0x28dc: 0x0001, 0x28dd: 0x0001,
	0x28de: 0x0001, 0x28df: 0x0001, 0x28e0: 0x0001, 0x28e1: 0x0001, 0x28e2: 0x0001, 0x28e3: 0x0010,
	0x28e4: 0x0010, 0x28e5: 0x0010, 0x28e6: 0x0010, 0x28e7: 0x0010, 0x28e8: 0x0010, 0x28e9: 0x0010,
	0x28ea: 0x0010, 0x28ec: 0x0010, 0x28ed: 0x0010,
	0x28f0: 0x8000, 0x28f1: 0x8000, 0x28f2: 0x8000, 0x28f3: 0x8000, 0x28f4: 0x8000, 0x28f5: 0x8000,
	0x28f6: 0x8000, 0x28f7: 0x8000, 0x28f8: 0x8000, 0x28f9: 0x8000,
	// Block 0xa4, offset 0x2900
	0x2900: 0x0001, 0x2901: 0x0001, 0x2902: 0x0001, 0x2903: 0x0001, 0x2904: 0x0001, 0x2905: 0x0001,
	0x2906: 0x0001, 0x2907: 0x0001, 0x2908: 0x0001, 0x2909: 0x0001, 0x290a: 0x0001, 0x290b: 0x0001,
	0x290c: 0x0001, 0x290d: 0x0001, 0x290e: 0x0001, 0x290f: 0x0001, 0x2910: 0x0001, 0x2911: 0x0001,
	0x2912: 0x0001, 0x2913: 0x0001, 0x2914: 0x0001, 0x2915: 0x0001, 0x2916: 0x0001, 0x2917: 0x0001,
	0x2918: 0x0001, 0x2919: 0x0001, 0x291a: 0x0001, 0x291b: 0x0001, 0x291c: 0x0001, 0x291d: 0x0001,
	0x291e: 0x0001, 0x291f: 0x0001, 0x2920: 0x0001, 0x2921: 0x0001, 0x2922: 0x0001, 0x2923: 0x0001,
	0x2930: 0x0001, 0x2931: 0x0001, 0x2932: 0x0001, 0x2933: 0x0001, 0x2934: 0x0001, 0x2935: 0x0001,
	0x2936: 0x0001, 0x2937: 0x0001, 0x2938: 0x0001, 0x2939: 0x0001, 0x293a: 0x0001, 0x293b: 0x0001,
	0x293c: 0x0001, 0x293d: 0x0001, 0x293e: 0x0001, 0x293f: 0x0001,
	// Block 0xa5, offset 0x2940
	0x2940: 0x0001, 0x2941: 0x0001, 0x2942: 0x0001, 0x2943: 0x0001, 0x2944: 0x0001, 0x2945: 0x0001,
	0x2946: 0x0001, 0x294b: 0x0001,
	0x294c: 0x0001, 0x294d: 0x0001, 0x294e: 0x0001, 0x294f: 0x0001, 0x2950: 0x0001, 0x2951: 0x0001,
	0x2952: 0x0001, 0x2953: 0x0001, 0x2954: 0x0001, 0x2955: 0x0001, 0x2956: 0x0001, 0x2957: 0x0001,
	0x2958: 0x0001, 0x2959: 0x0001, 0x295a: 0x0001, 0x295b: 0x0001, 0x295c: 0x0001, 0x295d: 0x0001,
	0x295e: 0x0001, 0x295f: 0x0001, 0x2960: 0x0001, 0x2961: 0x0001, 0x2962: 0x0001, 0x2963: 0x0001,
	0x2964: 0x0001, 0x2965: 0x0001, 0x2966: 0x0001, 0x2967: 0x0001, 0x2968: 0x0001, 0x2969: 0x0001,
	0x296a: 0x0001, 0x296b: 0x0001, 0x296c: 0x0001, 0x296d: 0x0001, 0x296e: 0x0001, 0x296f: 0x0001,
	0x2970: 0x0001, 0x2971: 0x0001, 0x2972: 0x0001, 0x2973: 0x0001, 0x2974: 0x0001, 0x2975: 0x0001,
	0x2976: 0x0001, 0x2977: 0x0001, 0x2978: 0x0001, 0x2979: 0x0001, 0x297a: 0x0001, 0x297b: 0x0001,
	// Block 0xa6, offset 0x2980
	0x2980: 0x0002, 0x2981: 0x0002, 0x2982: 0x0002, 0x2983: 0x0002, 0x2984: 0x0002, 0x2985: 0x0002,
	0x2986: 0x0002, 0x2987: 0x0002, 0x2988: 0x0002, 0x2989: 0x0002, 0x298a: 0x0002, 0x298b: 0x0002,
	0x298c: 0x0002, 0x298d: 0x0002, 0x298e: 0x0002, 0x298f: 0x0002, 0x2990: 0x0002, 0x2991: 0x0002,
	0x2992: 0x0002, 0x2993: 0x0002, 0x2994: 0x0002, 0x2995: 0x0002, 0x2996: 0x0002, 0x2997: 0x0002,
	0x2998: 0x0002, 0x2999: 0x0002, 0x299a: 0x0002, 0x299b: 0x0002, 0x299c: 0x0002, 0x299d: 0x0002,
	0x299e: 0x0002, 0x299f: 0x0002, 0x29a0: 0x0002, 0x29a1: 0x0002, 0x29a2: 0x0002, 0x29a3: 0x0002,
	0x29a4: 0x0002, 0x29a5: 0x0002, 0x29a6: 0x0002, 0x29a7: 0x0002, 0x29a8: 0x0002, 0x29a9: 0x0002,
	0x29aa: 0x0002, 0x29ab: 0x0002, 0x29ac: 0x0002, 0x29ad: 0x0002,
	0x29b0: 0x0002, 0x29b1: 0x0002, 0x29b2: 0x0002, 0x29b3: 0x0002, 0x29b4: 0x0002, 0x29b5: 0x0002,
	0x29b6: 0x0002, 0x29b7: 0x0002, 0x29b8: 0x0002, 0x29b9: 0x0002, 0x29ba: 0x0002, 0x29bb: 0x0002,
	0x29bc: 0x0002, 0x29bd: 0x0002, 0x29be: 0x0002, 0x29bf: 0x0002,
	// Block 0xa7, offset 0x29c0
	0x29c0: 0x0002, 0x29c1: 0x0002, 0x29c2: 0x0002, 0x29c3: 0x0002, 0x29c4: 0x0002, 0x29c5: 0x0002,
	0x29c6: 0x0002, 0x29c7: 0x0002, 0x29c8: 0x0002, 0x29c9: 0x0002, 0x29ca: 0x0002, 0x29cb: 0x0002,
	0x29cc: 0x0002, 0x29cd: 0x0002, 0x29ce: 0x0002, 0x29cf: 0x0002, 0x29d0: 0x0002, 0x29d1: 0x0002,
	0x29d2: 0x0002, 0x29d3: 0x0002, 0x29d4: 0x0002, 0x29d5: 0x0002, 0x29d6: 0x0002, 0x29d7: 0x0002,
	0x29d8: 0x0002, 0x29d9: 0x0002,
	// Block 0xa8, offset 0x2a00
	0x2a00: 0x0001, 0x2a01: 0x0001, 0x2a02: 0x0001, 0x2a03: 0x0001, 0x2a04: 0x0001, 0x2a05: 0x0001,
	0x2a06: 0x0001,
	0x2a13: 0x0001, 0x2a14: 0x0001, 0x2a15: 0x0001, 0x2a16: 0x0001, 0x2a17: 0x0001,
	0x2a1d: 0x0100,
	0x2a1e: 0x0010, 0x2a1f: 0x0100, 0x2a20: 0x0100, 0x2a21: 0x0100, 0x2a22: 0x0100, 0x2a23: 0x0100,
	0x2a24: 0x0100, 0x2a25: 0x0100, 0x2a26: 0x0100, 0x2a27: 0x0100, 0x2a28: 0x0100,
	0x2a2a: 0x0100, 0x2a2b: 0x0100, 0x2a2c: 0x0100, 0x2a2d: 0x0100, 0x2a2e: 0x0100, 0x2a2f: 0x0100,
	0x2a30: 0x0100, 0x2a31: 0x0100, 0x2a32: 0x0100, 0x2a33: 0x0100, 0x2a34: 0x0100, 0x2a35: 0x0100,
	0x2a36: 0x0100, 0x2a38: 0x0100, 0x2a39: 0x0100, 0x2a3a: 0x0100, 0x2a3b: 0x0100,
	0x2a3c: 0x0100, 0x2a3e: 0x0100,
	// Block 0xa9, offset 0x2a40
	0x2a40: 0x0100, 0x2a41: 0x0100, 0x2a43: 0x0100, 0x2a44: 0x0100,
	0x2a46: 0x0100, 0x2a47: 0x0100, 0x2a48: 0x0100, 0x2a49: 0x0100, 0x2a4a: 0x0100, 0x2a4b: 0x0100,
	0x2a4c: 0x0100, 0x2a4d: 0x0100, 0x2a4e: 0x0100, 0x2a4f: 0x0100, 0x2a50: 0x0001, 0x2a51: 0x0001,
	0x2a52: 0x0001, 0x2a53: 0x0001, 0x2a54: 0x0001, 0x2a55: 0x0001, 0x2a56: 0x0001, 0x2a57: 0x0001,
	0x2a58: 0x0001, 0x2a59: 0x0001, 0x2a5a: 0x0001, 0x2a5b: 0x0001, 0x2a5c: 0x0001, 0x2a5d: 0x0001,
	0x2a5e: 0x0001, 0x2a5f: 0x0001, 0x2a60: 0x0001, 0x2a61: 0x0001, 0x2a62: 0x0001, 0x2a63: 0x0001,
	0x2a64: 0x0001, 0x2a65: 0x0001, 0x2a66: 0x0001, 0x2a67: 0x0001, 0x2a68: 0x0001, 0x2a69: 0x0001,
	0x2a6a: 0x0001, 0x2a6b: 0x0001, 0x2a6c: 0x0001, 0x2a6d: 0x0001, 0x2a6e: 0x0001, 0x2a6f: 0x0001,
	0x2a70: 0x0001, 0x2a71: 0x0001, 0x2a72: 0x0001, 0x2a73: 0x0001, 0x2a74: 0x0001, 0x2a75: 0x0001,
	0x2a76: 0x0001, 0x2a77: 0x0001, 0x2a78: 0x0001, 0x2a79: 0x0001, 0x2a7a: 0x0001, 0x2a7b: 0x0001,
	0x2a7c: 0x0001, 0x2a7d: 0x0001, 0x2a7e: 0x0001, 0x2a7f: 0x0001,
	// Block 0xaa, offset 0x2a80
	0x2a80: 0x0001, 0x2a81: 0x0001, 0x2a82: 0x0001, 0x2a83: 0x0001, 0x2a84: 0x0001, 0x2a85: 0x0001,
	0x2a86: 0x0001, 0x2a87: 0x0001, 0x2a88: 0x0001, 0x2a89: 0x0001, 0x2a8a: 0x0001, 0x2a8b: 0x0001,
	0x2a8c: 0x0001, 0x2a8d: 0x0001, 0x2a8e: 0x0001, 0x2a8f: 0x0001, 0x2a90: 0x0001, 0x2a91: 0x0001,
	0x2a92: 0x0001, 0x2a93: 0x0001, 0x2a94: 0x0001, 0x2a95: 0x0001, 0x2a96: 0x0001, 0x2a97: 0x0001,
	0x2a98: 0x0001, 0x2a99: 0x0001, 0x2a9a: 0x0001, 0x2a9b: 0x0001, 0x2a9c: 0x0001, 0x2a9d: 0x0001,
	0x2a9e: 0x0001, 0x2a9f: 0x0001, 0x2aa0: 0x0001, 0x2aa1: 0x0001, 0x2aa2: 0x0001, 0x2aa3: 0x0001,
	0x2aa4: 0x0001, 0x2aa5: 0x0001, 0x2aa6: 0x0001, 0x2aa7: 0x0001, 0x2aa8: 0x0001, 0x2aa9: 0x0001,
	0x2aaa: 0x0001, 0x2aab: 0x0001, 0x2aac: 0x0001, 0x2aad: 0x0001, 0x2aae: 0x0001, 0x2aaf: 0x0001,
	0x2ab0: 0x0001, 0x2ab1: 0x0001,
	// Block 0xab, offset 0x2ac0
	0x2ad3: 0x0001, 0x2ad4: 0x0001, 0x2ad5: 0x0001, 0x2ad6: 0x0001, 0x2ad7: 0x0001,
	0x2ad8: 0x0001, 0x2ad9: 0x0001, 0x2ada: 0x0001, 0x2adb: 0x0001, 0x2adc: 0x0001, 0x2add: 0x0001,
	0x2ade: 0x0001, 0x2adf: 0x0001, 0x2ae0: 0x0001, 0x2ae1: 0x0001, 0x2ae2: 0x0001, 0x2ae3: 0x0001,
	0x2ae4: 0x0001, 0x2ae5: 0x0001, 0x2ae6: 0x0001, 0x2ae7: 0x0001, 0x2ae8: 0x0001, 0x2ae9: 0x0001,
	0x2aea: 0x0001, 0x2aeb: 0x0001, 0x2aec: 0x0001, 0x2aed: 0x0001, 0x2aee: 0x0001, 0x2aef: 0x0001,
	0x2af0: 0x0001, 0x2af1: 0x0001, 0x2af2: 0x0001, 0x2af3: 0x0001, 0x2af4: 0x0001, 0x2af5: 0x0001,
	0x2af6: 0x0001, 0x2af7: 0x0001, 0x2af8: 0x0001, 0x2af9: 0x0001, 0x2afa: 0x0001, 0x2afb: 0x0001,
	0x2afc: 0x0001, 0x2afd: 0x0001, 0x2afe: 0x0001, 0x2aff: 0x0001,
	// Block 0xac, offset 0x2b00
	0x2b00: 0x0001, 0x2b01: 0x0001, 0x2b02: 0x0001, 0x2b03: 0x0001, 0x2b04: 0x0001, 0x2b05: 0x0001,
	0x2b06: 0x0001, 0x2b07: 0x0001, 0x2b08: 0x0001, 0x2b09: 0x0001, 0x2b0a: 0x0001, 0x2b0b: 0x0001,
	0x2b0c: 0x0001, 0x2b0d: 0x0001, 0x2b0e: 0x0001, 0x2b0f: 0x0001, 0x2b10: 0x0001, 0x2b11: 0x0001,
	0x2b12: 0x0001, 0x2b13: 0x0001, 0x2b14: 0x0001, 0x2b15: 0x0001, 0x2b16: 0x0001, 0x2b17: 0x0001,
	0x2b18: 0x0001, 0x2b19: 0x0001, 0x2b1a: 0x0001, 0x2b1b: 0x0001, 0x2b1c: 0x0001, 0x2b1d: 0x0001,
	0x2b1e: 0x0001, 0x2b1f: 0x0001, 0x2b20: 0x0001, 0x2b21: 0x0001, 0x2b22: 0x0001, 0x2b23: 0x0001,
	0x2b24: 0x0001, 0x2b25: 0x0001, 0x2b26: 0x0001, 0x2b27: 0x0001, 0x2b28: 0x0001, 0x2b29: 0x0001,
	0x2b2a: 0x0001, 0x2b2b: 0x0001, 0x2b2c: 0x0001, 0x2b2d: 0x0001, 0x2b2e: 0x0001, 0x2b2f: 0x0001,
	0x2b30: 0x0001, 0x2b31: 0x0001, 0x2b32: 0x0001, 0x2b33: 0x0001, 0x2b34: 0x0001, 0x2b35: 0x0001,
	0x2b36: 0x0001, 0x2b37: 0x0001, 0x2b38: 0x0001, 0x2b39: 0x0001, 0x2b3a: 0x0001, 0x2b3b: 0x0001,
	0x2b3c: 0x0001, 0x2b3d: 0x0001,
	// Block 0xad, offset 0x2b40
	0x2b50: 0x0001, 0x2b51: 0x0001,
	0x2b52: 0x0001, 0x2b53: 0x0001, 0x2b54: 0x0001, 0x2b55: 0x0001, 0x2b56: 0x0001, 0x2b57: 0x0001,
	0x2b58: 0x0001, 0x2b59: 0x0001, 0x2b5a: 0x0001, 0x2b5b: 0x0001, 0x2b5c: 0x0001, 0x2b5d: 0x0001,
	0x2b5e: 0x0001, 0x2b5f: 0x0001, 0x2b60: 0x0001, 0x2b61: 0x0001, 0x2b62: 0x0001, 0x2b63: 0x0001,
	0x2b64: 0x0001, 0x2b65: 0x0001, 0x2b66: 0x0001, 0x2b67: 0x0001, 0x2b68: 0x0001, 0x2b69: 0x0001,
	0x2b6a: 0x0001, 0x2b6b: 0x0001, 0x2b6c: 0x0001, 0x2b6d: 0x0001, 0x2b6e: 0x0001, 0x2b6f: 0x0001,
	0x2b70: 0x0001, 0x2b71: 0x0001, 0x2b72: 0x0001, 0x2b73: 0x0001, 0x2b74: 0x0001, 0x2b75: 0x0001,
	0x2b76: 0x0001, 0x2b77: 0x0001, 0x2b78: 0x0001, 0x2b79: 0x0001, 0x2b7a: 0x0001, 0x2b7b: 0x0001,
	0x2b7c: 0x0001, 0x2b7d: 0x0001, 0x2b7e: 0x0001, 0x2b7f: 0x0001,
	// Block 0xae, offset 0x2b80
	0x2b80: 0x0001, 0x2b81: 0x0001, 0x2b82: 0x0001, 0x2b83: 0x0001, 0x2b84: 0x0001, 0x2b85: 0x0001,
	0x2b86: 0x0001, 0x2b87: 0x0001, 0x2b88: 0x0001, 0x2b89: 0x0001, 0x2b8a: 0x0001, 0x2b8b: 0x0001,
	0x2b8c: 0x0001, 0x2b8d: 0x0001, 0x2b8e: 0x0001, 0x2b8f: 0x0001,
	0x2b92: 0x0001, 0x2b93: 0x0001, 0x2b94: 0x0001, 0x2b95: 0x0001, 0x2b96: 0x0001, 0x2b97: 0x0001,
	0x2b98: 0x0001, 0x2b99: 0x0001, 0x2b9a: 0x0001, 0x2b9b: 0x0001, 0x2b9c: 0x0001, 0x2b9d: 0x0001,
	0x2b9e: 0x0001, 0x2b9f: 0x0001, 0x2ba0: 0x0001, 0x2ba1: 0x0001, 0x2ba2: 0x0001, 0x2ba3: 0x0001,
	0x2ba4: 0x0001, 0x2ba5: 0x0001, 0x2ba6: 0x0001, 0x2ba7: 0x0001, 0x2ba8: 0x0001, 0x2ba9: 0x0001,
	0x2baa: 0x0001, 0x2bab: 0x0001, 0x2bac: 0x0001, 0x2bad: 0x0001, 0x2bae: 0x0001, 0x2baf: 0x0001,
	0x2bb0: 0x0001, 0x2bb1: 0x0001, 0x2bb2: 0x0001, 0x2bb3: 0x0001, 0x2bb4: 0x0001, 0x2bb5: 0x0001,
	0x2bb6: 0x0001, 0x2bb7: 0x0001, 0x2bb8: 0x0001, 0x2bb9: 0x0001, 0x2bba: 0x0001, 0x2bbb: 0x0001,
	0x2bbc: 0x0001, 0x2bbd: 0x0001, 0x2bbe: 0x0001, 0x2bbf: 0x0001,
	// Block 0xaf, offset 0x2bc0
	0x2bc0: 0x0001, 0x2bc1: 0x0001, 0x2bc2: 0x0001, 0x2bc3: 0x0001, 0x2bc4: 0x0001, 0x2bc5: 0x0001,
	0x2bc6: 0x0001, 0x2bc7: 0x0001,
	0x2bf0: 0x0001, 0x2bf1: 0x0001, 0x2bf2: 0x0001, 0x2bf3: 0x0001, 0x2bf4: 0x0001, 0x2bf5: 0x0001,
	0x2bf6: 0x0001, 0x2bf7: 0x0001, 0x2bf8: 0x0001, 0x2bf9: 0x0001, 0x2bfa: 0x0001, 0x2bfb: 0x0001,
	// Block 0xb0, offset 0x2c00
	0x2c00: 0x0010, 0x2c01: 0x0010, 0x2c02: 0x0010, 0x2c03: 0x0010, 0x2c04: 0x0010, 0x2c05: 0x0010,
	0x2c06: 0x0010, 0x2c07: 0x0010, 0x2c08: 0x0010, 0x2c09: 0x0010, 0x2c0a: 0x0010, 0x2c0b: 0x0010,
	0x2c0c: 0x0010, 0x2c0d: 0x0010, 0x2c0e: 0x0010, 0x2c0f: 0x0010, 0x2c10: 0x1000,
	0x2c13: 0x0800, 0x2c14: 0x1000,
	0x2c20: 0x0010, 0x2c21: 0x0010, 0x2c22: 0x0010, 0x2c23: 0x0010,
	0x2c24: 0x0010, 0x2c25: 0x0010, 0x2c26: 0x0010, 0x2c27: 0x0010, 0x2c28: 0x0010, 0x2c29: 0x0010,
	0x2c2a: 0x0010, 0x2c2b: 0x0010, 0x2c2c: 0x0010, 0x2c2d: 0x0010, 0x2c2e: 0x0010, 0x2c2f: 0x0010,
	0x2c33: 0x0020, 0x2c34: 0x0020,
	// Block 0xb1, offset 0x2c40
	0x2c4d: 0x0020, 0x2c4e: 0x0020, 0x2c4f: 0x0020, 0x2c50: 0x1000,
	0x2c52: 0x2000, 0x2c54: 0x1000, 0x2c55: 0x0800,
	0x2c70: 0x0001, 0x2c71: 0x0001, 0x2c72: 0x0001, 0x2c73: 0x0001, 0x2c74: 0x0001,
	0x2c76: 0x0001, 0x2c77: 0x0001, 0x2c78: 0x0001, 0x2c79: 0x0001, 0x2c7a: 0x0001, 0x2c7b: 0x0001,
	0x2c7c: 0x0001, 0x2c7d: 0x0001, 0x2c7e: 0x0001, 0x2c7f: 0x0001,
	// Block 0xb2, offset 0x2c80
	0x2c80: 0x0001, 0x2c81: 0x0001, 0x2c82: 0x0001, 0x2c83: 0x0001, 0x2c84: 0x0001, 0x2c85: 0x0001,
	0x2c86: 0x0001, 0x2c87: 0x0001, 0x2c88: 0x0001, 0x2c89: 0x0001, 0x2c8a: 0x0001, 0x2c8b: 0x0001,
	0x2c8c: 0x0001, 0x2c8d: 0x0001, 0x2c8e: 0x0001, 0x2c8f: 0x0001, 0x2c90: 0x0001, 0x2c91: 0x0001,
	0x2c92: 0x0001, 0x2c93: 0x0001, 0x2c94: 0x0001, 0x2c95: 0x0001, 0x2c96: 0x0001, 0x2c97: 0x0001,
	0x2c98: 0x0001, 0x2c99: 0x0001, 0x2c9a: 0x0001, 0x2c9b: 0x0001, 0x2c9c: 0x0001, 0x2c9d: 0x0001,
	0x2c9e: 0x0001, 0x2c9f: 0x0001, 0x2ca0: 0x0001, 0x2ca1: 0x0001, 0x2ca2: 0x0001, 0x2ca3: 0x0001,
	0x2ca4: 0x0001, 0x2ca5: 0x0001, 0x2ca6: 0x0001, 0x2ca7: 0x0001, 0x2ca8: 0x0001, 0x2ca9: 0x0001,
	0x2caa: 0x0001, 0x2cab: 0x0001, 0x2cac: 0x0001, 0x2cad: 0x0001, 0x2cae: 0x0001, 0x2caf: 0x0001,
	0x2cb0: 0x0001, 0x2cb1: 0x0001, 0x2cb2: 0x0001, 0x2cb3: 0x0001, 0x2cb4: 0x0001, 0x2cb5: 0x0001,
	0x2cb6: 0x0001, 0x2cb7: 0x0001, 0x2cb8: 0x0001, 0x2cb9: 0x0001, 0x2cba: 0x0001, 0x2cbb: 0x0001,
	0x2cbc: 0x0001, 0x2cbf: 0x0080,
	// Block 0xb3, offset 0x2cc0
	0x2cc7: 0x2000,
	0x2ccc: 0x1000, 0x2cce: 0x2000, 0x2cd0: 0x8000, 0x2cd1: 0x8000,
	0x2cd2: 0x8000, 0x2cd3: 0x8000, 0x2cd4: 0x8000, 0x2cd5: 0x8000, 0x2cd6: 0x8000, 0x2cd7: 0x8000,
	0x2cd8: 0x8000, 0x2cd9: 0x8000, 0x2cda: 0x0800, 0x2cdb: 0x1000,
	0x2ce1: 0x0001, 0x2ce2: 0x0001, 0x2ce3: 0x0001,
	0x2ce4: 0x0001, 0x2ce5: 0x0001, 0x2ce6: 0x0001, 0x2ce7: 0x0001, 0x2ce8: 0x0001, 0x2ce9: 0x0001,
	0x2cea: 0x0001, 0x2ceb: 0x0001, 0x2cec: 0x0001, 0x2ced: 0x0001, 0x2cee: 0x0001, 0x2cef: 0x0001,
	0x2cf0: 0x0001, 0x2cf1: 0x0001, 0x2cf2: 0x0001, 0x2cf3: 0x0001, 0x2cf4: 0x0001, 0x2cf5: 0x0001,
	0x2cf6: 0x0001, 0x2cf7: 0x0001, 0x2cf8: 0x0001, 0x2cf9: 0x0001, 0x2cfa: 0x0001,
	0x2cff: 0x0020,
	// Block 0xb4, offset 0x2d00
	0x2d01: 0x0001, 0x2d02: 0x0001, 0x2d03: 0x0001, 0x2d04: 0x0001, 0x2d05: 0x0001,
	0x2d06: 0x0001, 0x2d07: 0x0001, 0x2d08: 0x0001, 0x2d09: 0x0001, 0x2d0a: 0x0001, 0x2d0b: 0x0001,
	0x2d0c: 0x0001, 0x2d0d: 0x0001, 0x2d0e: 0x0001, 0x2d0f: 0x0001, 0x2d10: 0x0001, 0x2d11: 0x0001,
	0x2d12: 0x0001, 0x2d13: 0x0001, 0x2d14: 0x0001, 0x2d15: 0x0001, 0x2d16: 0x0001, 0x2d17: 0x0001,
	0x2d18: 0x0001, 0x2d19: 0x0001, 0x2d1a: 0x0001,
	0x2d26: 0x0202, 0x2d27: 0x0202, 0x2d28: 0x0202, 0x2d29: 0x0202,
	0x2d2a: 0x0202, 0x2d2b: 0x0202, 0x2d2c: 0x0202, 0x2d2d: 0x0202, 0x2d2e: 0x0202, 0x2d2f: 0x0202,
	0x2d30: 0x0202, 0x2d31: 0x0202, 0x2d32: 0x0202, 0x2d33: 0x0202, 0x2d34: 0x0202, 0x2d35: 0x0202,
	0x2d36: 0x0202, 0x2d37: 0x0202, 0x2d38: 0x0202, 0x2d39: 0x0202, 0x2d3a: 0x0202, 0x2d3b: 0x0202,
	0x2d3c: 0x0202, 0x2d3d: 0x0202, 0x2d3e: 0x0202, 0x2d3f: 0x0202,
	// Block 0xb5, offset 0x2d40
	0x2d40: 0x0202, 0x2d41: 0x0202, 0x2d42: 0x0202, 0x2d43: 0x0202, 0x2d44: 0x0202, 0x2d45: 0x0202,
	0x2d46: 0x0202, 0x2d47: 0x0202, 0x2d48: 0x0202, 0x2d49: 0x0202, 0x2d4a: 0x0202, 0x2d4b: 0x0202,
	0x2d4c: 0x0202, 0x2d4d: 0x0202, 0x2d4e: 0x0202, 0x2d4f: 0x0202, 0x2d50: 0x0202, 0x2d51: 0x0202,
	0x2d52: 0x0202, 0x2d53: 0x0202, 0x2d54: 0x0202, 0x2d55: 0x0202, 0x2d56: 0x0202, 0x2d57: 0x0202,
	0x2d58: 0x0202, 0x2d59: 0x0202, 0x2d5a: 0x0202, 0x2d5b: 0x0202, 0x2d5c: 0x0202, 0x2d5d: 0x0202,
	0x2d5e: 0x0010, 0x2d5f: 0x0010, 0x2d60: 0x0001, 0x2d61: 0x0001, 0x2d62: 0x0001, 0x2d63: 0x0001,
	0x2d64: 0x0001, 0x2d65: 0x0001, 0x2d66: 0x0001, 0x2d67: 0x0001, 0x2d68: 0x0001, 0x2d69: 0x0001,
	0x2d6a: 0x0001, 0x2d6b: 0x0001, 0x2d6c: 0x0001, 0x2d6d: 0x0001, 0x2d6e: 0x0001, 0x2d6f: 0x0001,
	0x2d70: 0x0001, 0x2d71: 0x0001, 0x2d72: 0x0001, 0x2d73: 0x0001, 0x2d74: 0x0001, 0x2d75: 0x0001,
	0x2d76: 0x0001, 0x2d77: 0x0001, 0x2d78: 0x0001, 0x2d79: 0x0001, 0x2d7a: 0x0001, 0x2d7b: 0x0001,
	0x2d7c: 0x0001, 0x2d7d: 0x0001, 0x2d7e: 0x0001,
	// Block 0xb6, offset 0x2d80
	0x2d82: 0x0001, 0x2d83: 0x0001, 0x2d84: 0x0001, 0x2d85: 0x0001,
	0x2d86: 0x0001, 0x2d87: 0x0001, 0x2d8a: 0x0001, 0x2d8b: 0x0001,
	0x2d8c: 0x0001, 0x2d8d: 0x0001, 0x2d8e: 0x0001, 0x2d8f: 0x0001,
	0x2d92: 0x0001, 0x2d93: 0x0001, 0x2d94: 0x0001, 0x2d95: 0x0001, 0x2d96: 0x0001, 0x2d97: 0x0001,
	0x2d9a: 0x0001, 0x2d9b: 0x0001, 0x2d9c: 0x0001,
	0x2db9: 0x0080, 0x2dba: 0x0080, 0x2dbb: 0x0080,
	// Block 0xb7, offset 0x2dc0
	0x2dc0: 0x0001, 0x2dc1: 0x0001, 0x2dc2: 0x0001, 0x2dc3: 0x0001, 0x2dc4: 0x0001, 0x2dc5: 0x0001,
	0x2dc6: 0x0001, 0x2dc7: 0x0001, 0x2dc8: 0x0001, 0x2dc9: 0x0001, 0x2dca: 0x0001, 0x2dcb: 0x0001,
	0x2dcd: 0x0001, 0x2dce: 0x0001, 0x2dcf: 0x0001, 0x2dd0: 0x0001, 0x2dd1: 0x0001,
	0x2dd2: 0x0001, 0x2dd3: 0x0001, 0x2dd4: 0x0001, 0x2dd5: 0x0001, 0x2dd6: 0x0001, 0x2dd7: 0x0001,
	0x2dd8: 0x0001, 0x2dd9: 0x0001, 0x2dda: 0x0001, 0x2ddb: 0x0001, 0x2ddc: 0x0001, 0x2ddd: 0x0001,
	0x2dde: 0x0001, 0x2ddf: 0x0001, 0x2de0: 0x0001, 0x2de1: 0x0001, 0x2de2: 0x0001, 0x2de3: 0x0001,
	0x2de4: 0x0001, 0x2de5: 0x0001, 0x2de6: 0x0001, 0x2de8: 0x0001, 0x2de9: 0x0001,
	0x2dea: 0x0001, 0x2deb: 0x0001, 0x2dec: 0x0001, 0x2ded: 0x0001, 0x2dee: 0x0001, 0x2def: 0x0001,
	0x2df0: 0x0001, 0x2df1: 0x0001, 0x2df2: 0x0001, 0x2df3: 0x0001, 0x2df4: 0x0001, 0x2df5: 0x0001,
	0x2df6: 0x0001, 0x2df7: 0x0001, 0x2df8: 0x0001, 0x2df9: 0x0001, 0x2dfa: 0x0001,
	0x2dfc: 0x0001, 0x2dfd: 0x0001, 0x2dff: 0x0001,
	// Block 0xb8, offset 0x2e00
	0x2e00: 0x0001, 0x2e01: 0x0001, 0x2e02: 0x0001, 0x2e03: 0x0001, 0x2e04: 0x0001, 0x2e05: 0x0001,
	0x2e06: 0x0001, 0x2e07: 0x0001, 0x2e08: 0x0001, 0x2e09: 0x0001, 0x2e0a: 0x0001, 0x2e0b: 0x0001,
	0x2e0c: 0x0001, 0x2e0d: 0x0001, 0x2e10: 0x0001, 0x2e11: 0x0001,
	0x2e12: 0x0001, 0x2e13: 0x0001, 0x2e14: 0x0001, 0x2e15: 0x0001, 0x2e16: 0x0001, 0x2e17: 0x0001,
	0x2e18: 0x0001, 0x2e19: 0x0001, 0x2e1a: 0x0001, 0x2e1b: 0x0001, 0x2e1c: 0x0001, 0x2e1d: 0x0001,
	// Block 0xb9, offset 0x2e40
	0x2e40: 0x0001, 0x2e41: 0x0001, 0x2e42: 0x0001, 0x2e43: 0x0001, 0x2e44: 0x0001, 0x2e45: 0x0001,
	0x2e46: 0x0001, 0x2e47: 0x0001, 0x2e48: 0x0001, 0x2e49: 0x0001, 0x2e4a: 0x0001, 0x2e4b: 0x0001,
	0x2e4c: 0x0001, 0x2e4d: 0x0001, 0x2e4e: 0x0001, 0x2e4f: 0x0001, 0x2e50: 0x0001, 0x2e51: 0x0001,
	0x2e52: 0x0001, 0x2e53: 0x0001, 0x2e54: 0x0001, 0x2e55: 0x0001, 0x2e56: 0x0001, 0x2e57: 0x0001,
	0x2e58: 0x0001, 0x2e59: 0x0001, 0x2e5a: 0x0001, 0x2e5b: 0x0001, 0x2e5c: 0x0001, 0x2e5d: 0x0001,
	0x2e5e: 0x0001, 0x2e5f: 0x0001, 0x2e60: 0x0001, 0x2e61: 0x0001, 0x2e62: 0x0001, 0x2e63: 0x0001,
	0x2e64: 0x0001, 0x2e65: 0x0001, 0x2e66: 0x0001, 0x2e67: 0x0001, 0x2e68: 0x0001, 0x2e69: 0x0001,
	0x2e6a: 0x0001, 0x2e6b: 0x0001, 0x2e6c: 0x0001, 0x2e6d: 0x0001, 0x2e6e: 0x0001, 0x2e6f: 0x0001,
	0x2e70: 0x0001, 0x2e71: 0x0001, 0x2e72: 0x0001, 0x2e73: 0x0001, 0x2e74: 0x0001, 0x2e75: 0x0001,
	0x2e76: 0x0001, 0x2e77: 0x0001, 0x2e78: 0x0001, 0x2e79: 0x0001, 0x2e7a: 0x0001,
	// Block 0xba, offset 0x2e80
	0x2e80: 0x0001, 0x2e81: 0x0001, 0x2e82: 0x0001, 0x2e83: 0x0001, 0x2e84: 0x0001, 0x2e85: 0x0001,
	0x2e86: 0x0001, 0x2e87: 0x0001, 0x2e88: 0x0001, 0x2e89: 0x0001, 0x2e8a: 0x0001, 0x2e8b: 0x0001,
	0x2e8c: 0x0001, 0x2e8d: 0x0001, 0x2e8e: 0x0001, 0x2e8f: 0x0001, 0x2e90: 0x0001, 0x2e91: 0x0001,
	0x2e92: 0x0001, 0x2e93: 0x0001, 0x2e94: 0x0001, 0x2e95: 0x0001, 0x2e96: 0x0001, 0x2e97: 0x0001,
	0x2e98: 0x0001, 0x2e99: 0x0001, 0x2e9a: 0x0001, 0x2e9b: 0x0001, 0x2e9c: 0x0001, 0x2e9d: 0x0001,
	0x2e9e: 0x0001, 0x2e9f: 0x0001, 0x2ea0: 0x0001, 0x2ea1: 0x0001, 0x2ea2: 0x0001, 0x2ea3: 0x0001,
	0x2ea4: 0x0001, 0x2ea5: 0x0001, 0x2ea6: 0x0001, 0x2ea7: 0x0001, 0x2ea8: 0x0001, 0x2ea9: 0x0001,
	0x2eaa: 0x0001, 0x2eab: 0x0001, 0x2eac: 0x0001, 0x2ead: 0x0001, 0x2eae: 0x0001, 0x2eaf: 0x0001,
	0x2eb0: 0x0001, 0x2eb1: 0x0001, 0x2eb2: 0x0001, 0x2eb3: 0x0001, 0x2eb4: 0x0001,
	// Block 0xbb, offset 0x2ec0
	0x2efd: 0x0010,
	// Block 0xbc, offset 0x2f00
	0x2f00: 0x0001, 0x2f01: 0x0001, 0x2f02: 0x0001, 0x2f03: 0x0001, 0x2f04: 0x0001, 0x2f05: 0x0001,
	0x2f06: 0x0001, 0x2f07: 0x0001, 0x2f08: 0x0001, 0x2f09: 0x0001, 0x2f0a: 0x0001, 0x2f0b: 0x0001,
	0x2f0c: 0x0001, 0x2f0d: 0x0001, 0x2f0e: 0x0001, 0x2f0f: 0x0001, 0x2f10: 0x0001, 0x2f11: 0x0001,
	0x2f12: 0x0001, 0x2f13: 0x0001, 0x2f14: 0x0001, 0x2f15: 0x0001, 0x2f16: 0x0001, 0x2f17: 0x0001,
	0x2f18: 0x0001, 0x2f19: 0x0001, 0x2f1a: 0x0001, 0x2f1b: 0x0001, 0x2f1c: 0x0001,
	0x2f20: 0x0001, 0x2f21: 0x0001, 0x2f22: 0x0001, 0x2f23: 0x0001,
	0x2f24: 0x0001, 0x2f25: 0x0001, 0x2f26: 0x0001, 0x2f27: 0x0001, 0x2f28: 0x0001, 0x2f29: 0x0001,
	0x2f2a: 0x0001, 0x2f2b: 0x0001, 0x2f2c: 0x0001, 0x2f2d: 0x0001, 0x2f2e: 0x0001, 0x2f2f: 0x0001,
	0x2f30: 0x0001, 0x2f31: 0x0001, 0x2f32: 0x0001, 0x2f33: 0x0001, 0x2f34: 0x0001, 0x2f35: 0x0001,
	0x2f36: 0x0001, 0x2f37: 0x0001, 0x2f38: 0x0001, 0x2f39: 0x0001, 0x2f3a: 0x0001, 0x2f3b: 0x0001,
	0x2f3c: 0x0001, 0x2f3d: 0x0001, 0x2f3e: 0x0001, 0x2f3f: 0x0001,
	// Block 0xbd, offset 0x2f40
	0x2f40: 0x0001, 0x2f41: 0x0001, 0x2f42: 0x0001, 0x2f43: 0x0001, 0x2f44: 0x0001, 0x2f45: 0x0001,
	0x2f46: 0x0001, 0x2f47: 0x0001, 0x2f48: 0x0001, 0x2f49: 0x0001, 0x2f4a: 0x0001, 0x2f4b: 0x0001,
	0x2f4c: 0x0001, 0x2f4d: 0x0001, 0x2f4e: 0x0001, 0x2f4f: 0x0001, 0x2f50: 0x0001,
	0x2f60: 0x0010,
	// Block 0xbe, offset 0x2f80
	0x2f80: 0x0001, 0x2f81: 0x0001, 0x2f82: 0x0001, 0x2f83: 0x0001, 0x2f84: 0x0001, 0x2f85: 0x0001,
	0x2f86: 0x0001, 0x2f87: 0x0001, 0x2f88: 0x0001, 0x2f89: 0x0001, 0x2f8a: 0x0001, 0x2f8b: 0x0001,
	0x2f8c: 0x0001, 0x2f8d: 0x0001, 0x2f8e: 0x0001, 0x2f8f: 0x0001, 0x2f90: 0x0001, 0x2f91: 0x0001,
	0x2f92: 0x0001, 0x2f93: 0x0001, 0x2f94: 0x0001, 0x2f95: 0x0001, 0x2f96: 0x0001, 0x2f97: 0x0001,
	0x2f98: 0x0001, 0x2f99: 0x0001, 0x2f9a: 0x0001, 0x2f9b: 0x0001, 0x2f9c: 0x0001, 0x2f9d: 0x0001,
	0x2f9e: 0x0001, 0x2f9f: 0x0001,
	0x2fad: 0x0001, 0x2fae: 0x0001, 0x2faf: 0x0001,
	0x2fb0: 0x0001, 0x2fb1: 0x0001, 0x2fb2: 0x0001, 0x2fb3: 0x0001, 0x2fb4: 0x0001, 0x2fb5: 0x0001,
	0x2fb6: 0x0001, 0x2fb7: 0x0001, 0x2fb8: 0x0001, 0x2fb9: 0x0001, 0x2fba: 0x0001, 0x2fbb: 0x0001,
	0x2fbc: 0x0001, 0x2fbd: 0x0001, 0x2fbe: 0x0001, 0x2fbf: 0x0001,
	// Block 0xbf, offset 0x2fc0
	0x2fc0: 0x0001, 0x2fc1: 0x0001, 0x2fc2: 0x0001, 0x2fc3: 0x0001, 0x2fc4: 0x0001, 0x2fc5: 0x0001,
	0x2fc6: 0x0001, 0x2fc7: 0x0001, 0x2fc8: 0x0001, 0x2fc9: 0x0001, 0x2fca: 0x0001,
	0x2fd0: 0x0001, 0x2fd1: 0x0001,
	0x2fd2: 0x0001, 0x2fd3: 0x0001, 0x2fd4: 0x0001, 0x2fd5: 0x0001, 0x2fd6: 0x0001, 0x2fd7: 0x0001,
	0x2fd8: 0x0001, 0x2fd9: 0x0001, 0x2fda: 0x0001, 0x2fdb: 0x0001, 0x2fdc: 0x0001, 0x2fdd: 0x0001,
	0x2fde: 0x0001, 0x2fdf: 0x0001, 0x2fe0: 0x0001, 0x2fe1: 0x0001, 0x2fe2: 0x0001, 0x2fe3: 0x0001,
	0x2fe4: 0x0001, 0x2fe5: 0x0001, 0x2fe6: 0x0001, 0x2fe7: 0x0001, 0x2fe8: 0x0001, 0x2fe9: 0x0001,
	0x2fea: 0x0001, 0x2feb: 0x0001, 0x2fec: 0x0001, 0x2fed: 0x0001, 0x2fee: 0x0001, 0x2fef: 0x0001,
	0x2ff0: 0x0001, 0x2ff1: 0x0001, 0x2ff2: 0x0001, 0x2ff3: 0x0001, 0x2ff4: 0x0001, 0x2ff5: 0x0001,
	0x2ff6: 0x0010, 0x2ff7: 0x0010, 0x2ff8: 0x0010, 0x2ff9: 0x0010, 0x2ffa: 0x0010,
	// Block 0xc0, offset 0x3000
	0x3000: 0x0001, 0x3001: 0x0001, 0x3002: 0x0001, 0x3003: 0x0001, 0x3004: 0x0001, 0x3005: 0x0001,
	0x3006: 0x0001, 0x3007: 0x0001, 0x3008: 0x0001, 0x3009: 0x0001, 0x300a: 0x0001, 0x300b: 0x0001,
	0x300c: 0x0001, 0x300d: 0x0001, 0x300e: 0x0001, 0x300f: 0x0001, 0x3010: 0x0001, 0x3011: 0x0001,
	0x3012: 0x0001, 0x3013: 0x0001, 0x3014: 0x0001, 0x3015: 0x0001, 0x3016: 0x0001, 0x3017: 0x0001,
	0x3018: 0x0001, 0x3019: 0x0001, 0x301a: 0x0001, 0x301b: 0x0001, 0x301c: 0x0001, 0x301d: 0x0001,
	0x3020: 0x0001, 0x3021: 0x0001, 0x3022: 0x0001, 0x3023: 0x0001,
	0x3024: 0x0001, 0x3025: 0x0001, 0x3026: 0x0001, 0x3027: 0x0001, 0x3028: 0x0001, 0x3029: 0x0001,
	0x302a: 0x0001, 0x302b: 0x0001, 0x302c: 0x0001, 0x302d: 0x0001, 0x302e: 0x0001, 0x302f: 0x0001,
	0x3030: 0x0001, 0x3031: 0x0001, 0x3032: 0x0001, 0x3033: 0x0001, 0x3034: 0x0001, 0x3035: 0x0001,
	0x3036: 0x0001, 0x3037: 0x0001, 0x3038: 0x0001, 0x3039: 0x0001, 0x303a: 0x0001, 0x303b: 0x0001,
	0x303c: 0x0001, 0x303d: 0x0001, 0x303e: 0x0001, 0x303f: 0x0001,
	// Block 0xc1, offset 0x3040
	0x3040: 0x0001, 0x3041: 0x0001, 0x3042: 0x0001, 0x3043: 0x0001,
	0x3048: 0x0001, 0x3049: 0x0001, 0x304a: 0x0001, 0x304b: 0x0001,
	0x304c: 0x0001, 0x304d: 0x0001, 0x304e: 0x0001, 0x304f: 0x0001, 0x3051: 0x0001,
	0x3052: 0x0001, 0x3053: 0x0001, 0x3054: 0x0001, 0x3055: 0x0001,
	// Block 0xc2, offset 0x3080
	0x3080: 0x0001, 0x3081: 0x0001, 0x3082: 0x0001, 0x3083: 0x0001, 0x3084: 0x0001, 0x3085: 0x0001,
	0x3086: 0x0001, 0x3087: 0x0001, 0x3088: 0x0001, 0x3089: 0x0001, 0x308a: 0x0001, 0x308b: 0x0001,
	0x308c: 0x0001, 0x308d: 0x0001, 0x308e: 0x0001, 0x308f: 0x0001, 0x3090: 0x0001, 0x3091: 0x0001,
	0x3092: 0x0001, 0x3093: 0x0001, 0x3094: 0x0001, 0x3095: 0x0001, 0x3096: 0x0001, 0x3097: 0x0001,
	0x3098: 0x0001, 0x3099: 0x0001, 0x309a: 0x0001, 0x309b: 0x0001, 0x309c: 0x0001, 0x309d: 0x0001,
	0x30a0: 0x8000, 0x30a1: 0x8000, 0x30a2: 0x8000, 0x30a3: 0x8000,
	0x30a4: 0x8000, 0x30a5: 0x8000, 0x30a6: 0x8000, 0x30a7: 0x8000, 0x30a8: 0x8000, 0x30a9: 0x8000,
	0x30b0: 0x0001, 0x30b1: 0x0001, 0x30b2: 0x0001, 0x30b3: 0x0001, 0x30b4: 0x0001, 0x30b5: 0x0001,
	0x30b6: 0x0001, 0x30b7: 0x0001, 0x30b8: 0x0001, 0x30b9: 0x0001, 0x30ba: 0x0001, 0x30bb: 0x0001,
	0x30bc: 0x0001, 0x30bd: 0x0001, 0x30be: 0x0001, 0x30bf: 0x0001,
	// Block 0xc3, offset 0x30c0
	0x30c0: 0x0001, 0x30c1: 0x0001, 0x30c2: 0x0001, 0x30c3: 0x0001, 0x30c4: 0x0001, 0x30c5: 0x0001,
	0x30c6: 0x0001, 0x30c7: 0x0001, 0x30c8: 0x0001, 0x30c9: 0x0001, 0x30ca: 0x0001, 0x30cb: 0x0001,
	0x30cc: 0x0001, 0x30cd: 0x0001, 0x30ce: 0x0001, 0x30cf: 0x0001, 0x30d0: 0x0001, 0x30d1: 0x0001,
	0x30d2: 0x0001, 0x30d3: 0x0001,
	0x30d8: 0x0001, 0x30d9: 0x0001, 0x30da: 0x0001, 0x30db: 0x0001, 0x30dc: 0x0001, 0x30dd: 0x0001,
	0x30de: 0x0001, 0x30df: 0x0001, 0x30e0: 0x0001, 0x30e1: 0x0001, 0x30e2: 0x0001, 0x30e3: 0x0001,
	0x30e4: 0x0001, 0x30e5: 0x0001, 0x30e6: 0x0001, 0x30e7: 0x0001, 0x30e8: 0x0001, 0x30e9: 0x0001,
	0x30ea: 0x0001, 0x30eb: 0x0001, 0x30ec: 0x0001, 0x30ed: 0x0001, 0x30ee: 0x0001, 0x30ef: 0x0001,
	0x30f0: 0x0001, 0x30f1: 0x0001, 0x30f2: 0x0001, 0x30f3: 0x0001, 0x30f4: 0x0001, 0x30f5: 0x0001,
	0x30f6: 0x0001, 0x30f7: 0x0001, 0x30f8: 0x0001, 0x30f9: 0x0001, 0x30fa: 0x0001, 0x30fb: 0x0001,
	// Block 0xc4, offset 0x3100
	0x3100: 0x0001, 0x3101: 0x0001, 0x3102: 0x0001, 0x3103: 0x0001, 0x3104: 0x0001, 0x3105: 0x0001,
	0x3106: 0x0001, 0x3107: 0x0001, 0x3108: 0x0001, 0x3109: 0x0001, 0x310a: 0x0001, 0x310b: 0x0001,
	0x310c: 0x0001, 0x310d: 0x0001, 0x310e: 0x0001, 0x310f: 0x0001, 0x3110: 0x0001, 0x3111: 0x0001,
	0x3112: 0x0001, 0x3113: 0x0001, 0x3114: 0x0001, 0x3115: 0x0001, 0x3116: 0x0001, 0x3117: 0x0001,
	0x3118: 0x0001, 0x3119: 0x0001, 0x311a: 0x0001, 0x311b: 0x0001, 0x311c: 0x0001, 0x311d: 0x0001,
	0x311e: 0x0001, 0x311f: 0x0001, 0x3120: 0x0001, 0x3121: 0x0001, 0x3122: 0x0001, 0x3123: 0x0001,
	0x3124: 0x0001, 0x3125: 0x0001, 0x3126: 0x0001, 0x3127: 0x0001,
	0x3130: 0x0001, 0x3131: 0x0001, 0x3132: 0x0001, 0x3133: 0x0001, 0x3134: 0x0001, 0x3135: 0x0001,
	0x3136: 0x0001, 0x3137: 0x0001, 0x3138: 0x0001, 0x3139: 0x0001, 0x313a: 0x0001, 0x313b: 0x0001,
	0x313c: 0x0001, 0x313d: 0x0001, 0x313e: 0x0001, 0x313f: 0x0001,
	// Block 0xc5, offset 0x3140
	0x3140: 0x0001, 0x3141: 0x0001, 0x3142: 0x0001, 0x3143: 0x0001, 0x3144: 0x0001, 0x3145: 0x0001,
	0x3146: 0x0001, 0x3147: 0x0001, 0x3148: 0x0001, 0x3149: 0x0001, 0x314a: 0x0001, 0x314b: 0x0001,
	0x314c: 0x0001, 0x314d: 0x0001, 0x314e: 0x0001, 0x314f: 0x0001, 0x3150: 0x0001, 0x3151: 0x0001,
	0x3152: 0x0001, 0x3153: 0x0001, 0x3154: 0x0001, 0x3155: 0x0001, 0x3156: 0x0001, 0x3157: 0x0001,
	0x3158: 0x0001, 0x3159: 0x0001, 0x315a: 0x0001, 0x315b: 0x0001, 0x315c: 0x0001, 0x315d: 0x0001,
	0x315e: 0x0001, 0x315f: 0x0001, 0x3160: 0x0001, 0x3161: 0x0001, 0x3162: 0x0001, 0x3163: 0x0001,
	0x3170: 0x0001, 0x3171: 0x0001, 0x3172: 0x0001, 0x3173: 0x0001, 0x3174: 0x0001, 0x3175: 0x0001,
	0x3176: 0x0001, 0x3177: 0x0001, 0x3178: 0x0001, 0x3179: 0x0001, 0x317a: 0x0001,
	0x317c: 0x0001, 0x317d: 0x0001, 0x317e: 0x0001, 0x317f: 0x0001,
	// Block 0xc6, offset 0x3180
	0x3180: 0x0001, 0x3181: 0x0001, 0x3182: 0x0001, 0x3183: 0x0001, 0x3184: 0x0001, 0x3185: 0x0001,
	0x3186: 0x0001, 0x3187: 0x0001, 0x3188: 0x0001, 0x3189: 0x0001, 0x318a: 0x0001,
	0x318c: 0x0001, 0x318d: 0x0001, 0x318e: 0x0001, 0x318f: 0x0001, 0x3190: 0x0001, 0x3191: 0x0001,
	0x3192: 0x0001, 0x3194: 0x0001, 0x3195: 0x0001, 0x3197: 0x0001,
	0x3198: 0x0001, 0x3199: 0x0001, 0x319a: 0x0001, 0x319b: 0x0001, 0x319c: 0x0001, 0x319d: 0x0001,
	0x319e: 0x0001, 0x319f: 0x0001, 0x31a0: 0x0001, 0x31a1: 0x0001, 0x31a3: 0x0001,
	0x31a4: 0x0001, 0x31a5: 0x0001, 0x31a6: 0x0001, 0x31a7: 0x0001, 0x31a8: 0x0001, 0x31a9: 0x0001,
	0x31aa: 0x0001, 0x31ab: 0x0001, 0x31ac: 0x0001, 0x31ad: 0x0001, 0x31ae: 0x0001, 0x31af: 0x0001,
	0x31b0: 0x0001, 0x31b1: 0x0001, 0x31b3: 0x0001, 0x31b4: 0x0001, 0x31b5: 0x0001,
	0x31b6: 0x0001, 0x31b7: 0x0001, 0x31b8: 0x0001, 0x31b9: 0x0001, 0x31bb: 0x0001,
	0x31bc: 0x0001,
	// Block 0xc7, offset 0x31c0
	0x31c0: 0x0001, 0x31c1: 0x0001, 0x31c2: 0x0001, 0x31c3: 0x0001, 0x31c4: 0x0001, 0x31c5: 0x0001,
	0x31c6: 0x0001, 0x31c7: 0x0001, 0x31c8: 0x0001, 0x31c9: 0x0001, 0x31ca: 0x0001, 0x31cb: 0x0001,
	0x31cc: 0x0001, 0x31cd: 0x0001, 0x31ce: 0x0001, 0x31cf: 0x0001, 0x31d0: 0x0001, 0x31d1: 0x0001,
	0x31d2: 0x0001, 0x31d3: 0x0001, 0x31d4: 0x0001, 0x31d5: 0x0001, 0x31d6: 0x0001, 0x31d7: 0x0001,
	0x31d8: 0x0001, 0x31d9: 0x0001, 0x31da: 0x0001, 0x31db: 0x0001, 0x31dc: 0x0001, 0x31dd: 0x0001,
	0x31de: 0x0001, 0x31df: 0x0001, 0x31e0: 0x0001, 0x31e1: 0x0001, 0x31e2: 0x0001, 0x31e3: 0x0001,
	0x31e4: 0x0001, 0x31e5: 0x0001, 0x31e6: 0x0001, 0x31e7: 0x0001, 0x31e8: 0x0001, 0x31e9: 0x0001,
	0x31ea: 0x0001, 0x31eb: 0x0001, 0x31ec: 0x0001, 0x31ed: 0x0001, 0x31ee: 0x0001, 0x31ef: 0x0001,
	0x31f0: 0x0001, 0x31f1: 0x0001, 0x31f2: 0x0001, 0x31f3: 0x0001, 0x31f4: 0x0001, 0x31f5: 0x0001,
	0x31f6: 0x0001,
	// Block 0xc8, offset 0x3200
	0x3200: 0x0001, 0x3201: 0x0001, 0x3202: 0x0001, 0x3203: 0x0001, 0x3204: 0x0001, 0x3205: 0x0001,
	0x3206: 0x0001, 0x3207: 0x0001, 0x3208: 0x0001, 0x3209: 0x0001, 0x320a: 0x0001, 0x320b: 0x0001,
	0x320c: 0x0001, 0x320d: 0x0001, 0x320e: 0x0001, 0x320f: 0x0001, 0x3210: 0x0001, 0x3211: 0x0001,
	0x3212: 0x0001, 0x3213: 0x0001, 0x3214: 0x0001, 0x3215: 0x0001,
	0x3220: 0x0001, 0x3221: 0x0001, 0x3222: 0x0001, 0x3223: 0x0001,
	0x3224: 0x0001, 0x3225: 0x0001, 0x3226: 0x0001, 0x3227: 0x0001,
	// Block 0xc9, offset 0x3240
	0x3240: 0x0001, 0x3241: 0x0001, 0x3242: 0x0001, 0x3243: 0x0001, 0x3244: 0x0001, 0x3245: 0x0001,
	0x3247: 0x0001, 0x3248: 0x0001, 0x3249: 0x0001, 0x324a: 0x0001, 0x324b: 0x0001,
	0x324c: 0x0001, 0x324d: 0x0001, 0x324e: 0x0001, 0x324f: 0x0001, 0x3250: 0x0001, 0x3251: 0x0001,
	0x3252: 0x0001, 0x3253: 0x0001, 0x3254: 0x0001, 0x3255: 0x0001, 0x3256: 0x0001, 0x3257: 0x0001,
	0x3258: 0x0001, 0x3259: 0x0001, 0x325a: 0x0001, 0x325b: 0x0001, 0x325c: 0x0001, 0x325d: 0x0001,
	0x325e: 0x0001, 0x325f: 0x0001, 0x3260: 0x0001, 0x3261: 0x0001, 0x3262: 0x0001, 0x3263: 0x0001,
	0x3264: 0x0001, 0x3265: 0x0001, 0x3266: 0x0001, 0x3267: 0x0001, 0x3268: 0x0001, 0x3269: 0x0001,
	0x326a: 0x0001, 0x326b: 0x0001, 0x326c: 0x0001, 0x326d: 0x0001, 0x326e: 0x0001, 0x326f: 0x0001,
	0x3270: 0x0001, 0x3272: 0x0001, 0x3273: 0x0001, 0x3274: 0x0001, 0x3275: 0x0001,
	0x3276: 0x0001, 0x3277: 0x0001, 0x3278: 0x0001, 0x3279: 0x0001, 0x327a: 0x0001,
	// Block 0xca, offset 0x3280
	0x3280: 0x0001, 0x3281: 0x0001, 0x3282: 0x0001, 0x3283: 0x0001, 0x3284: 0x0001, 0x3285: 0x0001,
	0x3288: 0x0001, 0x328a: 0x0001, 0x328b: 0x0001,
	0x328c: 0x0001, 0x328d: 0x0001, 0x328e: 0x0001, 0x328f: 0x0001, 0x3290: 0x0001, 0x3291: 0x0001,
	0x3292: 0x0001, 0x3293: 0x0001, 0x3294: 0x0001, 0x3295: 0x0001, 0x3296: 0x0001, 0x3297: 0x0001,
	0x3298: 0x0001, 0x3299: 0x0001, 0x329a: 0x0001, 0x329b: 0x0001, 0x329c: 0x0001, 0x329d: 0x0001,
	0x329e: 0x0001, 0x329f: 0x0001, 0x32a0: 0x0001, 0x32a1: 0x0001, 0x32a2: 0x0001, 0x32a3: 0x0001,
	0x32a4: 0x0001, 0x32a5: 0x0001, 0x32a6: 0x0001, 0x32a7: 0x0001, 0x32a8: 0x0001, 0x32a9: 0x0001,
	0x32aa: 0x0001, 0x32ab: 0x0001, 0x32ac: 0x0001, 0x32ad: 0x0001, 0x32ae: 0x0001, 0x32af: 0x0001,
	0x32b0: 0x0001, 0x32b1: 0x0001, 0x32b2: 0x0001, 0x32b3: 0x0001, 0x32b4: 0x0001, 0x32b5: 0x0001,
	0x32b7: 0x0001, 0x32b8: 0x0001,
	0x32bc: 0x0001, 0x32bf: 0x0001,
	// Block 0xcb, offset 0x32c0
	0x32c0: 0x0001, 0x32c1: 0x0001, 0x32c2: 0x0001, 0x32c3: 0x0001, 0x32c4: 0x0001, 0x32c5: 0x0001,
	0x32c6: 0x0001, 0x32c7: 0x0001, 0x32c8: 0x0001, 0x32c9: 0x0001, 0x32ca: 0x0001, 0x32cb: 0x0001,
	0x32cc: 0x0001, 0x32cd: 0x0001, 0x32ce: 0x0001, 0x32cf: 0x0001, 0x32d0: 0x0001, 0x32d1: 0x0001,
	0x32d2: 0x0001, 0x32d3: 0x0001, 0x32d4: 0x0001, 0x32d5: 0x0001,
	0x32e0: 0x0001, 0x32e1: 0x0001, 0x32e2: 0x0001, 0x32e3: 0x0001,
	0x32e4: 0x0001, 0x32e5: 0x0001, 0x32e6: 0x0001, 0x32e7: 0x0001, 0x32e8: 0x0001, 0x32e9: 0x0001,
	0x32ea: 0x0001, 0x32eb: 0x0001, 0x32ec: 0x0001, 0x32ed: 0x0001, 0x32ee: 0x0001, 0x32ef: 0x0001,
	0x32f0: 0x0001, 0x32f1: 0x0001, 0x32f2: 0x0001, 0x32f3: 0x0001, 0x32f4: 0x0001, 0x32f5: 0x0001,
	0x32f6: 0x0001,
	// Block 0xcc, offset 0x3300
	0x3300: 0x0001, 0x3301: 0x0001, 0x3302: 0x0001, 0x3303: 0x0001, 0x3304: 0x0001, 0x3305: 0x0001,
	0x3306: 0x0001, 0x3307: 0x0001, 0x3308: 0x0001, 0x3309: 0x0001, 0x330a: 0x0001, 0x330b: 0x0001,
	0x330c: 0x0001, 0x330d: 0x0001, 0x330e: 0x0001, 0x330f: 0x0001, 0x3310: 0x0001, 0x3311: 0x0001,
	0x3312: 0x0001, 0x3313: 0x0001, 0x3314: 0x0001, 0x3315: 0x0001, 0x3316: 0x0001, 0x3317: 0x0001,
	0x3318: 0x0001, 0x3319: 0x0001, 0x331a: 0x0001, 0x331b: 0x0001, 0x331c: 0x0001, 0x331d: 0x0001,
	0x331e: 0x0001,
	// Block 0xcd, offset 0x3340
	0x3360: 0x0001, 0x3361: 0x0001, 0x3362: 0x0001, 0x3363: 0x0001,
	0x3364: 0x0001, 0x3365: 0x0001, 0x3366: 0x0001, 0x3367: 0x0001, 0x3368: 0x0001, 0x3369: 0x0001,
	0x336a: 0x0001, 0x336b: 0x0001, 0x336c: 0x0001, 0x336d: 0x0001, 0x336e: 0x0001, 0x336f: 0x0001,
	0x3370: 0x0001, 0x3371: 0x0001, 0x3372: 0x0001, 0x3374: 0x0001, 0x3375: 0x0001,
	// Block 0xce, offset 0x3380
	0x3380: 0x0001, 0x3381: 0x0001, 0x3382: 0x0001, 0x3383: 0x0001, 0x3384: 0x0001, 0x3385: 0x0001,
	0x3386: 0x0001, 0x3387: 0x0001, 0x3388: 0x0001, 0x3389: 0x0001, 0x338a: 0x0001, 0x338b: 0x0001,
	0x338c: 0x0001, 0x338d: 0x0001, 0x338e: 0x0001, 0x338f: 0x0001, 0x3390: 0x0001, 0x3391: 0x0001,
	0x3392: 0x0001, 0x3393: 0x0001, 0x3394: 0x0001, 0x3395: 0x0001,
	0x33a0: 0x0001, 0x33a1: 0x0001, 0x33a2: 0x0001, 0x33a3: 0x0001,
	0x33a4: 0x0001, 0x33a5: 0x0001, 0x33a6: 0x0001, 0x33a7: 0x0001, 0x33a8: 0x0001, 0x33a9: 0x0001,
	0x33aa: 0x0001, 0x33ab: 0x0001, 0x33ac: 0x0001, 0x33ad: 0x0001, 0x33ae: 0x0001, 0x33af: 0x0001,
	0x33b0: 0x0001, 0x33b1: 0x0001, 0x33b2: 0x0001, 0x33b3: 0x0001, 0x33b4: 0x0001, 0x33b5: 0x0001,
	0x33b6: 0x0001, 0x33b7: 0x0001, 0x33b8: 0x0001, 0x33b9: 0x0001,
	// Block 0xcf, offset 0x33c0
	0x33c0: 0x0001, 0x33c1: 0x0001, 0x33c2: 0x0001, 0x33c3: 0x0001, 0x33c4: 0x0001, 0x33c5: 0x0001,
	0x33c6: 0x0001, 0x33c7: 0x0001, 0x33c8: 0x0001, 0x33c9: 0x0001, 0x33ca: 0x0001, 0x33cb: 0x0001,
	0x33cc: 0x0001, 0x33cd: 0x0001, 0x33ce: 0x0001, 0x33cf: 0x0001, 0x33d0: 0x0001, 0x33d1: 0x0001,
	0x33d2: 0x0001, 0x33d3: 0x0001, 0x33d4: 0x0001, 0x33d5: 0x0001, 0x33d6: 0x0001, 0x33d7: 0x0001,
	0x33d8: 0x0001, 0x33d9: 0x0001, 0x33da: 0x0001, 0x33db: 0x0001, 0x33dc: 0x0001, 0x33dd: 0x0001,
	0x33de: 0x0001, 0x33df: 0x0001, 0x33e0: 0x0001, 0x33e1: 0x0001, 0x33e2: 0x0001, 0x33e3: 0x0001,
	0x33e4: 0x0001, 0x33e5: 0x0001, 0x33e6: 0x0001, 0x33e7: 0x0001, 0x33e8: 0x0001, 0x33e9: 0x0001,
	0x33ea: 0x0001, 0x33eb: 0x0001, 0x33ec: 0x0001, 0x33ed: 0x0001, 0x33ee: 0x0001, 0x33ef: 0x0001,
	0x33f0: 0x0001, 0x33f1: 0x0001, 0x33f2: 0x0001, 0x33f3: 0x0001, 0x33f4: 0x0001, 0x33f5: 0x0001,
	0x33f6: 0x0001, 0x33f7: 0x0001,
	0x33fe: 0x0001, 0x33ff: 0x0001,
	// Block 0xd0, offset 0x3400
	0x3400: 0x0001, 0x3401: 0x0010, 0x3402: 0x0010, 0x3403: 0x0010, 0x3405: 0x0010,
	0x3406: 0x0010,
	0x340c: 0x0010, 0x340d: 0x0010, 0x340e: 0x0010, 0x340f: 0x0010, 0x3410: 0x0001, 0x3411: 0x0001,
	0x3412: 0x0001, 0x3413: 0x0001, 0x3415: 0x0001, 0x3416: 0x0001, 0x3417: 0x0001,
	0x3419: 0x0001, 0x341a: 0x0001, 0x341b: 0x0001, 0x341c: 0x0001, 0x341d: 0x0001,
	0x341e: 0x0001, 0x341f: 0x0001, 0x3420: 0x0001, 0x3421: 0x0001, 0x3422: 0x0001, 0x3423: 0x0001,
	0x3424: 0x0001, 0x3425: 0x0001, 0x3426: 0x0001, 0x3427: 0x0001, 0x3428: 0x0001, 0x3429: 0x0001,
	0x342a: 0x0001, 0x342b: 0x0001, 0x342c: 0x0001, 0x342d: 0x0001, 0x342e: 0x0001, 0x342f: 0x0001,
	0x3430: 0x0001, 0x3431: 0x0001, 0x3432: 0x0001, 0x3433: 0x0001, 0x3434: 0x0001, 0x3435: 0x0001,
	0x3438: 0x0010, 0x3439: 0x0010, 0x343a: 0x0010,
	0x343f: 0x0010,
	// Block 0xd1, offset 0x3440
	0x3460: 0x0001, 0x3461: 0x0001, 0x3462: 0x0001, 0x3463: 0x0001,
	0x3464: 0x0001, 0x3465: 0x0001, 0x3466: 0x0001, 0x3467: 0x0001, 0x3468: 0x0001, 0x3469: 0x0001,
	0x346a: 0x0001, 0x346b: 0x0001, 0x346c: 0x0001, 0x346d: 0x0001, 0x346e: 0x0001, 0x346f: 0x0001,
	0x3470: 0x0001, 0x3471: 0x0001, 0x3472: 0x0001, 0x3473: 0x0001, 0x3474: 0x0001, 0x3475: 0x0001,
	0x3476: 0x0001, 0x3477: 0x0001, 0x3478: 0x0001, 0x3479: 0x0001, 0x347a: 0x0001, 0x347b: 0x0001,
	0x347c: 0x0001,
	// Block 0xd2, offset 0x3480
	0x3480: 0x0001, 0x3481: 0x0001, 0x3482: 0x0001, 0x3483: 0x0001, 0x3484: 0x0001, 0x3485: 0x0001,
	0x3486: 0x0001, 0x3487: 0x0001, 0x3488: 0x0001, 0x3489: 0x0001, 0x348a: 0x0001, 0x348b: 0x0001,
	0x348c: 0x0001, 0x348d: 0x0001, 0x348e: 0x0001, 0x348f: 0x0001, 0x3490: 0x0001, 0x3491: 0x0001,
	0x3492: 0x0001, 0x3493: 0x0001, 0x3494: 0x0001, 0x3495: 0x0001, 0x3496: 0x0001, 0x3497: 0x0001,
	0x3498: 0x0001, 0x3499: 0x0001, 0x349a: 0x0001, 0x349b: 0x0001, 0x349c: 0x0001,
	// Block 0xd3, offset 0x34c0
	0x34c0: 0x0001, 0x34c1: 0x0001, 0x34c2: 0x0001, 0x34c3: 0x0001, 0x34c4: 0x0001, 0x34c5: 0x0001,
	0x34c6: 0x0001, 0x34c7: 0x0001, 0x34c9: 0x0001, 0x34ca: 0x0001, 0x34cb: 0x0001,
	0x34cc: 0x0001, 0x34cd: 0x0001, 0x34ce: 0x0001, 0x34cf: 0x0001, 0x34d0: 0x0001, 0x34d1: 0x0001,
	0x34d2: 0x0001, 0x34d3: 0x0001, 0x34d4: 0x0001, 0x34d5: 0x0001, 0x34d6: 0x0001, 0x34d7: 0x0001,
	0x34d8: 0x0001, 0x34d9: 0x0001, 0x34da: 0x0001, 0x34db: 0x0001, 0x34dc: 0x0001, 0x34dd: 0x0001,
	0x34de: 0x0001, 0x34df: 0x0001, 0x34e0: 0x0001, 0x34e1: 0x0001, 0x34e2: 0x0001, 0x34e3: 0x0001,
	0x34e4: 0x0001, 0x34e5: 0x0010, 0x34e6: 0x0010,
	// Block 0xd4, offset 0x3500
	0x3500: 0x0001, 0x3501: 0x0001, 0x3502: 0x0001, 0x3503: 0x0001, 0x3504: 0x0001, 0x3505: 0x0001,
	0x3506: 0x0001, 0x3507: 0x0001, 0x3508: 0x0001, 0x3509: 0x0001, 0x350a: 0x0001, 0x350b: 0x0001,
	0x350c: 0x0001, 0x350d: 0x0001, 0x350e: 0x0001, 0x350f: 0x0001, 0x3510: 0x0001, 0x3511: 0x0001,
	0x3512: 0x0001, 0x3513: 0x0001, 0x3514: 0x0001, 0x3515: 0x0001,
	0x3520: 0x0001, 0x3521: 0x0001, 0x3522: 0x0001, 0x3523: 0x0001,
	0x3524: 0x0001, 0x3525: 0x0001, 0x3526: 0x0001, 0x3527: 0x0001, 0x3528: 0x0001, 0x3529: 0x0001,
	0x352a: 0x0001, 0x352b: 0x0001, 0x352c: 0x0001, 0x352d: 0x0001, 0x352e: 0x0001, 0x352f: 0x0001,
	0x3530: 0x0001, 0x3531: 0x0001, 0x3532: 0x0001,
	// Block 0xd5, offset 0x3540
	0x3540: 0x0001, 0x3541: 0x0001, 0x3542: 0x0001, 0x3543: 0x0001, 0x3544: 0x0001, 0x3545: 0x0001,
	0x3546: 0x0001, 0x3547: 0x0001, 0x3548: 0x0001, 0x3549: 0x0001, 0x354a: 0x0001, 0x354b: 0x0001,
	0x354c: 0x0001, 0x354d: 0x0001, 0x354e: 0x0001, 0x354f: 0x0001, 0x3550: 0x0001, 0x3551: 0x0001,
	// Block 0xd6, offset 0x3580
	0x3580: 0x0001, 0x3581: 0x0001, 0x3582: 0x0001, 0x3583: 0x0001, 0x3584: 0x0001, 0x3585: 0x0001,
	0x3586: 0x0001, 0x3587: 0x0001, 0x3588: 0x0001,
	// Block 0xd7, offset 0x35c0
	0x35c0: 0x0001, 0x35c1: 0x0001, 0x35c2: 0x0001, 0x35c3: 0x0001, 0x35c4: 0x0001, 0x35c5: 0x0001,
	0x35c6: 0x0001, 0x35c7: 0x0001, 0x35c8: 0x0001, 0x35c9: 0x0001, 0x35ca: 0x0001, 0x35cb: 0x0001,
	0x35cc: 0x0001, 0x35cd: 0x0001, 0x35ce: 0x0001, 0x35cf: 0x0001, 0x35d0: 0x0001, 0x35d1: 0x0001,
	0x35d2: 0x0001, 0x35d3: 0x0001, 0x35d4: 0x0001, 0x35d5: 0x0001, 0x35d6: 0x0001, 0x35d7: 0x0001,
	0x35d8: 0x0001, 0x35d9: 0x0001, 0x35da: 0x0001, 0x35db: 0x0001, 0x35dc: 0x0001, 0x35dd: 0x0001,
	0x35de: 0x0001, 0x35df: 0x0001, 0x35e0: 0x0001, 0x35e1: 0x0001, 0x35e2: 0x0001, 0x35e3: 0x0001,
	0x35e4: 0x0001, 0x35e5: 0x0001, 0x35e6: 0x0001, 0x35e7: 0x0001, 0x35e8: 0x0001, 0x35e9: 0x0001,
	0x35ea: 0x0001, 0x35eb: 0x0001, 0x35ec: 0x0001, 0x35ed: 0x0001, 0x35ee: 0x0001, 0x35ef: 0x0001,
	0x35f0: 0x0001, 0x35f1: 0x0001, 0x35f2: 0x0001,
	// Block 0xd8, offset 0x3600
	0x3600: 0x0001, 0x3601: 0x0001, 0x3602: 0x0001, 0x3603: 0x0001, 0x3604: 0x0001, 0x3605: 0x0001,
	0x3606: 0x0001, 0x3607: 0x0001, 0x3608: 0x0001, 0x3609: 0x0001, 0x360a: 0x0001, 0x360b: 0x0001,
	0x360c: 0x0001, 0x360d: 0x0001, 0x360e: 0x0001, 0x360f: 0x0001, 0x3610: 0x0001, 0x3611: 0x0001,
	0x3612: 0x0001, 0x3613: 0x0001, 0x3614: 0x0001, 0x3615: 0x0001, 0x3616: 0x0001, 0x3617: 0x0001,
	0x3618: 0x0001, 0x3619: 0x0001, 0x361a: 0x0001, 0x361b: 0x0001, 0x361c: 0x0001, 0x361d: 0x0001,
	0x361e: 0x0001, 0x361f: 0x0001, 0x3620: 0x0001, 0x3621: 0x0001, 0x3622: 0x0001, 0x3623: 0x0001,
	0x3624: 0x0010, 0x3625: 0x0010, 0x3626: 0x0010, 0x3627: 0x0010,
	0x3630: 0x8000, 0x3631: 0x8000, 0x3632: 0x8000, 0x3633: 0x8000, 0x3634: 0x8000, 0x3635: 0x8000,
	0x3636: 0x8000, 0x3637: 0x8000, 0x3638: 0x8000, 0x3639: 0x8000,
	// Block 0xd9, offset 0x3640
	0x3640: 0x0001, 0x3641: 0x0001, 0x3642: 0x0001, 0x3643: 0x0001, 0x3644: 0x0001, 0x3645: 0x0001,
	0x3646: 0x0001, 0x3647: 0x0001, 0x3648: 0x0001, 0x3649: 0x0001, 0x364a: 0x0001, 0x364b: 0x0001,
	0x364c: 0x0001, 0x364d: 0x0001, 0x364e: 0x0001, 0x364f: 0x0001, 0x3650: 0x0001, 0x3651: 0x0001,
	0x3652: 0x0001, 0x3653: 0x0001, 0x3654: 0x0001, 0x3655: 0x0001, 0x3656: 0x0001, 0x3657: 0x0001,
	0x3658: 0x0001, 0x3659: 0x0001, 0x365a: 0x0001, 0x365b: 0x0001, 0x365c: 0x0001, 0x365d: 0x0001,
	0x365e: 0x0001, 0x365f: 0x0001, 0x3660: 0x0001, 0x3661: 0x0001, 0x3662: 0x0001, 0x3663: 0x0001,
	0x3664: 0x0001, 0x3665: 0x0001, 0x3666: 0x0001, 0x3667: 0x0001, 0x3668: 0x0001, 0x3669: 0x0001,
	0x366b: 0x0010, 0x366c: 0x0010,
	0x3670: 0x0001, 0x3671: 0x0001,
	// Block 0xda, offset 0x3680
	0x36bd: 0x0010, 0x36be: 0x0010, 0x36bf: 0x0010,
	// Block 0xdb, offset 0x36c0
	0x36c0: 0x0001, 0x36c1: 0x0001, 0x36c2: 0x0001, 0x36c3: 0x0001, 0x36c4: 0x0001, 0x36c5: 0x0001,
	0x36c6: 0x0001, 0x36c7: 0x0001, 0x36c8: 0x0001, 0x36c9: 0x0001, 0x36ca: 0x0001, 0x36cb: 0x0001,
	0x36cc: 0x0001, 0x36cd: 0x0001, 0x36ce: 0x0001, 0x36cf: 0x0001, 0x36d0: 0x0001, 0x36d1: 0x0001,
	0x36d2: 0x0001, 0x36d3: 0x0001, 0x36d4: 0x0001, 0x36d5: 0x0001, 0x36d6: 0x0001, 0x36d7: 0x0001,
	0x36d8: 0x0001, 0x36d9: 0x0001, 0x36da: 0x0001, 0x36db: 0x0001, 0x36dc: 0x0001,
	0x36e7: 0x0001,
	0x36f0: 0x0001, 0x36f1: 0x0001, 0x36f2: 0x0001, 0x36f3: 0x0001, 0x36f4: 0x0001, 0x36f5: 0x0001,
	0x36f6: 0x0001, 0x36f7: 0x0001, 0x36f8: 0x0001, 0x36f9: 0x0001, 0x36fa: 0x0001, 0x36fb: 0x0001,
	0x36fc: 0x0001, 0x36fd: 0x0001, 0x36fe: 0x0001, 0x36ff: 0x0001,
	// Block 0xdc, offset 0x3700
	0x3700: 0x0001, 0x3701: 0x0001, 0x3702: 0x0001, 0x3703: 0x0001, 0x3704: 0x0001, 0x3705: 0x0001,
	0x3706: 0x0010, 0x3707: 0x0010, 0x3708: 0x0010, 0x3709: 0x0010, 0x370a: 0x0010, 0x370b: 0x0010,
	0x370c: 0x0010, 0x370d: 0x0010, 0x370e: 0x0010, 0x370f: 0x0010, 0x3710: 0x0010,
	0x3730: 0x0001, 0x3731: 0x0001, 0x3732: 0x0001, 0x3733: 0x0001, 0x3734: 0x0001, 0x3735: 0x0001,
	0x3736: 0x0001, 0x3737: 0x0001, 0x3738: 0x0001, 0x3739: 0x0001, 0x373a: 0x0001, 0x373b: 0x0001,
	0x373c: 0x0001, 0x373d: 0x0001, 0x373e: 0x0001, 0x373f: 0x0001,
	// Block 0xdd, offset 0x3740
	0x3740: 0x0001, 0x3741: 0x0001, 0x3742: 0x0010, 0x3743: 0x0010, 0x3744: 0x0010, 0x3745: 0x0010,
	0x3770: 0x0001, 0x3771: 0x0001, 0x3772: 0x0001, 0x3773: 0x0001, 0x3774: 0x0001, 0x3775: 0x0001,
	0x3776: 0x0001, 0x3777: 0x0001, 0x3778: 0x0001, 0x3779: 0x0001, 0x377a: 0x0001, 0x377b: 0x0001,
	0x377c: 0x0001, 0x377d: 0x0001, 0x377e: 0x0001, 0x377f: 0x0001,
	// Block 0xde, offset 0x3780
	0x3780: 0x0001, 0x3781: 0x0001, 0x3782: 0x0001, 0x3783: 0x0001, 0x3784: 0x0001,
	0x37a0: 0x0001, 0x37a1: 0x0001, 0x37a2: 0x0001, 0x37a3: 0x0001,
	0x37a4: 0x0001, 0x37a5: 0x0001, 0x37a6: 0x0001, 0x37a7: 0x0001, 0x37a8: 0x0001, 0x37a9: 0x0001,
	0x37aa: 0x0001, 0x37ab: 0x0001, 0x37ac: 0x0001, 0x37ad: 0x0001, 0x37ae: 0x0001, 0x37af: 0x0001,
	0x37b0: 0x0001, 0x37b1: 0x0001, 0x37b2: 0x0001, 0x37b3: 0x0001, 0x37b4: 0x0001, 0x37b5: 0x0001,
	0x37b6: 0x0001,
	// Block 0xdf, offset 0x37c0
	0x37c0: 0x0010, 0x37c1: 0x0010, 0x37c2: 0x0010, 0x37c3: 0x0001, 0x37c4: 0x0001, 0x37c5: 0x0001,
	0x37c6: 0x0001, 0x37c7: 0x0001, 0x37c8: 0x0001, 0x37c9: 0x0001, 0x37ca: 0x0001, 0x37cb: 0x0001,
	0x37cc: 0x0001, 0x37cd: 0x0001, 0x37ce: 0x0001, 0x37cf: 0x0001, 0x37d0: 0x0001, 0x37d1: 0x0001,
	0x37d2: 0x0001, 0x37d3: 0x0001, 0x37d4: 0x0001, 0x37d5: 0x0001, 0x37d6: 0x0001, 0x37d7: 0x0001,
	0x37d8: 0x0001, 0x37d9: 0x0001, 0x37da: 0x0001, 0x37db: 0x0001, 0x37dc: 0x0001, 0x37dd: 0x0001,
	0x37de: 0x0001, 0x37df: 0x0001, 0x37e0: 0x0001, 0x37e1: 0x0001, 0x37e2: 0x0001, 0x37e3: 0x0001,
	0x37e4: 0x0001, 0x37e5: 0x0001, 0x37e6: 0x0001, 0x37e7: 0x0001, 0x37e8: 0x0001, 0x37e9: 0x0001,
	0x37ea: 0x0001, 0x37eb: 0x0001, 0x37ec: 0x0001, 0x37ed: 0x0001, 0x37ee: 0x0001, 0x37ef: 0x0001,
	0x37f0: 0x0001, 0x37f1: 0x0001, 0x37f2: 0x0001, 0x37f3: 0x0001, 0x37f4: 0x0001, 0x37f5: 0x0001,
	0x37f6: 0x0001, 0x37f7: 0x0001, 0x37f8: 0x0010, 0x37f9: 0x0010, 0x37fa: 0x0010, 0x37fb: 0x0010,
	0x37fc: 0x0010, 0x37fd: 0x0010, 0x37fe: 0x0010, 0x37ff: 0x0010,
	// Block 0xe0, offset 0x3800
	0x3800: 0x0010, 0x3801: 0x0010, 0x3802: 0x0010, 0x3803: 0x0010, 0x3804: 0x0010, 0x3805: 0x0010,
	0x3806: 0x0010,
	0x3826: 0x8000, 0x3827: 0x8000, 0x3828: 0x8000, 0x3829: 0x8000,
	0x382a: 0x8000, 0x382b: 0x8000, 0x382c: 0x8000, 0x382d: 0x8000, 0x382e: 0x8000, 0x382f: 0x8000,
	0x3830: 0x0010, 0x3831: 0x0001, 0x3832: 0x0001, 0x3833: 0x0010, 0x3834: 0x0010, 0x3835: 0x0001,
	0x383f: 0x0010,
	// Block 0xe1, offset 0x3840
	0x3840: 0x0010, 0x3841: 0x0010, 0x3842: 0x0010, 0x3843: 0x0001, 0x3844: 0x0001, 0x3845: 0x0001,
	0x3846: 0x0001, 0x3847: 0x0001, 0x3848: 0x0001, 0x3849: 0x0001, 0x384a: 0x0001, 0x384b: 0x0001,
	0x384c: 0x0001, 0x384d: 0x0001, 0x384e: 0x0001, 0x384f: 0x0001, 0x3850: 0x0001, 0x3851: 0x0001,
	0x3852: 0x0001, 0x3853: 0x0001, 0x3854: 0x0001, 0x3855: 0x0001, 0x3856: 0x0001, 0x3857: 0x0001,
	0x3858: 0x0001, 0x3859: 0x0001, 0x385a: 0x0001, 0x385b: 0x0001, 0x385c: 0x0001, 0x385d: 0x0001,
	0x385e: 0x0001, 0x385f: 0x0001, 0x3860: 0x0001, 0x3861: 0x0001, 0x3862: 0x0001, 0x3863: 0x0001,
	0x3864: 0x0001, 0x3865: 0x0001, 0x3866: 0x0001, 0x3867: 0x0001, 0x3868: 0x0001, 0x3869: 0x0001,
	0x386a: 0x0001, 0x386b: 0x0001, 0x386c: 0x0001, 0x386d: 0x0001, 0x386e: 0x0001, 0x386f: 0x0001,
	0x3870: 0x0010, 0x3871: 0x0010, 0x3872: 0x0010, 0x3873: 0x0010, 0x3874: 0x0010, 0x3875: 0x0010,
	0x3876: 0x0010, 0x3877: 0x0010, 0x3878: 0x0010, 0x3879: 0x0010, 0x387a: 0x0010,
	0x387d: 0x0080,
	// Block 0xe2, offset 0x3880
	0x3882: 0x0010,
	0x388d: 0x0080, 0x3890: 0x0001, 0x3891: 0x0001,
	0x3892: 0x0001, 0x3893: 0x0001, 0x3894: 0x0001, 0x3895: 0x0001, 0x3896: 0x0001, 0x3897: 0x0001,
	0x3898: 0x0001, 0x3899: 0x0001, 0x389a: 0x0001, 0x389b: 0x0001, 0x389c: 0x0001, 0x389d: 0x0001,
	0x389e: 0x0001, 0x389f: 0x0001, 0x38a0: 0x0001, 0x38a1: 0x0001, 0x38a2: 0x0001, 0x38a3: 0x0001,
	0x38a4: 0x0001, 0x38a5: 0x0001, 0x38a6: 0x0001, 0x38a7: 0x0001, 0x38a8: 0x0001,
	0x38b0: 0x8000, 0x38b1: 0x8000, 0x38b2: 0x8000, 0x38b3: 0x8000, 0x38b4: 0x8000, 0x38b5: 0x8000,
	0x38b6: 0x8000, 0x38b7: 0x8000, 0x38b8: 0x8000, 0x38b9: 0x8000,
	// Block 0xe3, offset 0x38c0
	0x38c0: 0x0010, 0x38c1: 0x0010, 0x38c2: 0x0010, 0x38c3: 0x0001, 0x38c4: 0x0001, 0x38c5: 0x0001,
	0x38c6: 0x0001, 0x38c7: 0x0001, 0x38c8: 0x0001, 0x38c9: 0x0001, 0x38ca: 0x0001, 0x38cb: 0x0001,
	0x38cc: 0x0001, 0x38cd: 0x0001, 0x38ce: 0x0001, 0x38cf: 0x0001, 0x38d0: 0x0001, 0x38d1: 0x0001,
	0x38d2: 0x0001, 0x38d3: 0x0001, 0x38d4: 0x0001, 0x38d5: 0x0001, 0x38d6: 0x0001, 0x38d7: 0x0001,
	0x38d8: 0x0001, 0x38d9: 0x0001, 0x38da: 0x0001, 0x38db: 0x0001, 0x38dc: 0x0001, 0x38dd: 0x0001,
	0x38de: 0x0001, 0x38df: 0x0001, 0x38e0: 0x0001, 0x38e1: 0x0001, 0x38e2: 0x0001, 0x38e3: 0x0001,
	0x38e4: 0x0001, 0x38e5: 0x0001, 0x38e6: 0x0001, 0x38e7: 0x0010, 0x38e8: 0x0010, 0x38e9: 0x0010,
	0x38ea: 0x0010, 0x38eb: 0x0010, 0x38ec: 0x0010, 0x38ed: 0x0010, 0x38ee: 0x0010, 0x38ef: 0x0010,
	0x38f0: 0x0010, 0x38f1: 0x0010, 0x38f2: 0x0010, 0x38f3: 0x0010, 0x38f4: 0x0010,
	0x38f6: 0x8000, 0x38f7: 0x8000, 0x38f8: 0x8000, 0x38f9: 0x8000, 0x38fa: 0x8000, 0x38fb: 0x8000,
	0x38fc: 0x8000, 0x38fd: 0x8000, 0x38fe: 0x8000, 0x38ff: 0x8000,
	// Block 0xe4, offset 0x3900
	0x3904: 0x0001, 0x3905: 0x0010,
	0x3906: 0x0010, 0x3907: 0x0001,
	0x3910: 0x0001, 0x3911: 0x0001,
	0x3912: 0x0001, 0x3913: 0x0001, 0x3914: 0x0001, 0x3915: 0x0001, 0x3916: 0x0001, 0x3917: 0x0001,
	0x3918: 0x0001, 0x3919: 0x0001, 0x391a: 0x0001, 0x391b: 0x0001, 0x391c: 0x0001, 0x391d: 0x0001,
	0x391e: 0x0001, 0x391f: 0x0001, 0x3920: 0x0001, 0x3921: 0x0001, 0x3922: 0x0001, 0x3923: 0x0001,
	0x3924: 0x0001, 0x3925: 0x0001, 0x3926: 0x0001, 0x3927: 0x0001, 0x3928: 0x0001, 0x3929: 0x0001,
	0x392a: 0x0001, 0x392b: 0x0001, 0x392c: 0x0001, 0x392d: 0x0001, 0x392e: 0x0001, 0x392f: 0x0001,
	0x3930: 0x0001, 0x3931: 0x0001, 0x3932: 0x0001, 0x3933: 0x0010,
	0x3936: 0x0001,
	// Block 0xe5, offset 0x3940
	0x3940: 0x0010, 0x3941: 0x0010, 0x3942: 0x0010, 0x3943: 0x0001, 0x3944: 0x0001, 0x3945: 0x0001,
	0x3946: 0x0001, 0x3947: 0x0001, 0x3948: 0x0001, 0x3949: 0x0001, 0x394a: 0x0001, 0x394b: 0x0001,
	0x394c: 0x0001, 0x394d: 0x0001, 0x394e: 0x0001, 0x394f: 0x0001, 0x3950: 0x0001, 0x3951: 0x0001,
	0x3952: 0x0001, 0x3953: 0x0001, 0x3954: 0x0001, 0x3955: 0x0001, 0x3956: 0x0001, 0x3957: 0x0001,
	0x3958: 0x0001, 0x3959: 0x0001, 0x395a: 0x0001, 0x395b: 0x0001, 0x395c: 0x0001, 0x395d: 0x0001,
	0x395e: 0x0001, 0x395f: 0x0001, 0x3960: 0x0001, 0x3961: 0x0001, 0x3962: 0x0001, 0x3963: 0x0001,
	0x3964: 0x0001, 0x3965: 0x0001, 0x3966: 0x0001, 0x3967: 0x0001, 0x3968: 0x0001, 0x3969: 0x0001,
	0x396a: 0x0001, 0x396b: 0x0001, 0x396c: 0x0001, 0x396d: 0x0001, 0x396e: 0x0001, 0x396f: 0x0001,
	0x3970: 0x0001, 0x3971: 0x0001, 0x3972: 0x0001, 0x3973: 0x0010, 0x3974: 0x0010, 0x3975: 0x0010,
	0x3976: 0x0010, 0x3977: 0x0010, 0x3978: 0x0010, 0x3979: 0x0010, 0x397a: 0x0010, 0x397b: 0x0010,
	0x397c: 0x0010, 0x397d: 0x0010, 0x397e: 0x0010, 0x397f: 0x0010,
	// Block 0xe6, offset 0x3980
	0x3980: 0x0010, 0x3981: 0x0001, 0x3982: 0x0001, 0x3983: 0x0001, 0x3984: 0x0001,
	0x3989: 0x0010, 0x398a: 0x0010, 0x398b: 0x0010,
	0x398c: 0x0010, 0x398e: 0x0010, 0x398f: 0x0010, 0x3990: 0x8000, 0x3991: 0x8000,
	0x3992: 0x8000, 0x3993: 0x8000, 0x3994: 0x8000, 0x3995: 0x8000, 0x3996: 0x8000, 0x3997: 0x8000,
	0x3998: 0x8000, 0x3999: 0x8000, 0x399a: 0x0001, 0x399c: 0x0001,
	// Block 0xe7, offset 0x39c0
	0x39c0: 0x0001, 0x39c1: 0x0001, 0x39c2: 0x0001, 0x39c3: 0x0001, 0x39c4: 0x0001, 0x39c5: 0x0001,
	0x39c6: 0x0001, 0x39c7: 0x0001, 0x39c8: 0x0001, 0x39c9: 0x0001, 0x39ca: 0x0001, 0x39cb: 0x0001,
	0x39cc: 0x0001, 0x39cd: 0x0001, 0x39ce: 0x0001, 0x39cf: 0x0001, 0x39d0: 0x0001, 0x39d1: 0x0001,
	0x39d3: 0x0001, 0x39d4: 0x0001, 0x39d5: 0x0001, 0x39d6: 0x0001, 0x39d7: 0x0001,
	0x39d8: 0x0001, 0x39d9: 0x0001, 0x39da: 0x0001, 0x39db: 0x0001, 0x39dc: 0x0001, 0x39dd: 0x0001,
	0x39de: 0x0001, 0x39df: 0x0001, 0x39e0: 0x0001, 0x39e1: 0x0001, 0x39e2: 0x0001, 0x39e3: 0x0001,
	0x39e4: 0x0001, 0x39e5: 0x0001, 0x39e6: 0x0001, 0x39e7: 0x0001, 0x39e8: 0x0001, 0x39e9: 0x0001,
	0x39ea: 0x0001, 0x39eb: 0x0001, 0x39ec: 0x0010, 0x39ed: 0x0010, 0x39ee: 0x0010, 0x39ef: 0x0010,
	0x39f0: 0x0010, 0x39f1: 0x0010, 0x39f2: 0x0010, 0x39f3: 0x0010, 0x39f4: 0x0010, 0x39f5: 0x0010,
	0x39f6: 0x0010, 0x39f7: 0x0010,
	0x39fe: 0x0010, 0x39ff: 0x0001,
	// Block 0xe8, offset 0x3a00
	0x3a00: 0x0001, 0x3a01: 0x0010,
	// Block 0xe9, offset 0x3a40
	0x3a40: 0x0001, 0x3a41: 0x0001, 0x3a42: 0x0001, 0x3a43: 0x0001, 0x3a44: 0x0001, 0x3a45: 0x0001,
	0x3a46: 0x0001, 0x3a48: 0x0001, 0x3a4a: 0x0001, 0x3a4b: 0x0001,
	0x3a4c: 0x0001, 0x3a4d: 0x0001, 0x3a4f: 0x0001, 0x3a50: 0x0001, 0x3a51: 0x0001,
	0x3a52: 0x0001, 0x3a53: 0x0001, 0x3a54: 0x0001, 0x3a55: 0x0001, 0x3a56: 0x0001, 0x3a57: 0x0001,
	0x3a58: 0x0001, 0x3a59: 0x0001, 0x3a5a: 0x0001, 0x3a5b: 0x0001, 0x3a5c: 0x0001, 0x3a5d: 0x0001,
	0x3a5f: 0x0001, 0x3a60: 0x0001, 0x3a61: 0x0001, 0x3a62: 0x0001, 0x3a63: 0x0001,
	0x3a64: 0x0001, 0x3a65: 0x0001, 0x3a66: 0x0001, 0x3a67: 0x0001, 0x3a68: 0x0001,
	0x3a70: 0x0001, 0x3a71: 0x0001, 0x3a72: 0x0001, 0x3a73: 0x0001, 0x3a74: 0x0001, 0x3a75: 0x0001,
	0x3a76: 0x0001, 0x3a77: 0x0001, 0x3a78: 0x0001, 0x3a79: 0x0001, 0x3a7a: 0x0001, 0x3a7b: 0x0001,
	0x3a7c: 0x0001, 0x3a7d: 0x0001, 0x3a7e: 0x0001, 0x3a7f: 0x0001,
	// Block 0xea, offset 0x3a80
	0x3a80: 0x0001, 0x3a81: 0x0001, 0x3a82: 0x0001, 0x3a83: 0x0001, 0x3a84: 0x0001, 0x3a85: 0x0001,
	0x3a86: 0x0001, 0x3a87: 0x0001, 0x3a88: 0x0001, 0x3a89: 0x0001, 0x3a8a: 0x0001, 0x3a8b: 0x0001,
	0x3a8c: 0x0001, 0x3a8d: 0x0001, 0x3a8e: 0x0001, 0x3a8f: 0x0001, 0x3a90: 0x0001, 0x3a91: 0x0001,
	0x3a92: 0x0001, 0x3a93: 0x0001, 0x3a94: 0x0001, 0x3a95: 0x0001, 0x3a96: 0x0001, 0x3a97: 0x0001,
	0x3a98: 0x0001, 0x3a99: 0x0001, 0x3a9a: 0x0001, 0x3a9b: 0x0001, 0x3a9c: 0x0001, 0x3a9d: 0x0001,
	0x3a9e: 0x0001, 0x3a9f: 0x0010, 0x3aa0: 0x0010, 0x3aa1: 0x0010, 0x3aa2: 0x0010, 0x3aa3: 0x0010,
	0x3aa4: 0x0010, 0x3aa5: 0x0010, 0x3aa6: 0x0010, 0x3aa7: 0x0010, 0x3aa8: 0x0010, 0x3aa9: 0x0010,
	0x3aaa: 0x0010,
	0x3ab0: 0x8000, 0x3ab1: 0x8000, 0x3ab2: 0x8000, 0x3ab3: 0x8000, 0x3ab4: 0x8000, 0x3ab5: 0x8000,
	0x3ab6: 0x8000, 0x3ab7: 0x8000, 0x3ab8: 0x8000, 0x3ab9: 0x8000,
	// Block 0xeb, offset 0x3ac0
	0x3ac0: 0x0010, 0x3ac1: 0x0010, 0x3ac2: 0x0010, 0x3ac3: 0x0010, 0x3ac5: 0x0001,
	0x3ac6: 0x0001, 0x3ac7: 0x0001, 0x3ac8: 0x0001, 0x3ac9: 0x0001, 0x3aca: 0x0001, 0x3acb: 0x0001,
	0x3acc: 0x0001, 0x3acf: 0x0001, 0x3ad0: 0x0001,
	0x3ad3: 0x0001, 0x3ad4: 0x0001, 0x3ad5: 0x0001, 0x3ad6: 0x0001, 0x3ad7: 0x0001,
	0x3ad8: 0x0001, 0x3ad9: 0x0001, 0x3ada: 0x0001, 0x3adb: 0x0001, 0x3adc: 0x0001, 0x3add: 0x0001,
	0x3ade: 0x0001, 0x3adf: 0x0001, 0x3ae0: 0x0001, 0x3ae1: 0x0001, 0x3ae2: 0x0001, 0x3ae3: 0x0001,
	0x3ae4: 0x0001, 0x3ae5: 0x0001, 0x3ae6: 0x0001, 0x3ae7: 0x0001, 0x3ae8: 0x0001,
	0x3aea: 0x0001, 0x3aeb: 0x0001, 0x3aec: 0x0001, 0x3aed: 0x0001, 0x3aee: 0x0001, 0x3aef: 0x0001,
	0x3af0: 0x0001, 0x3af2: 0x0001, 0x3af3: 0x0001, 0x3af5: 0x0001,
	0x3af6: 0x0001, 0x3af7: 0x0001, 0x3af8: 0x0001, 0x3af9: 0x0001, 0x3afb: 0x0010,
	0x3afc: 0x0010, 0x3afd: 0x0001, 0x3afe: 0x0010, 0x3aff: 0x0010,
	// Block 0xec, offset 0x3b00
	0x3b00: 0x0010, 0x3b01: 0x0010, 0x3b02: 0x0010, 0x3b03: 0x0010, 0x3b04: 0x0010,
	0x3b07: 0x0010, 0x3b08: 0x0010, 0x3b0b: 0x0010,
	0x3b0c: 0x0010, 0x3b0d: 0x0010, 0x3b10: 0x0001,
	0x3b17: 0x0010,
	0x3b1d: 0x0001,
	0x3b1e: 0x0001, 0x3b1f: 0x0001, 0x3b20: 0x0001, 0x3b21: 0x0001, 0x3b22: 0x0010, 0x3b23: 0x0010,
	0x3b26: 0x0010, 0x3b27: 0x0010, 0x3b28: 0x0010, 0x3b29: 0x0010,
	0x3b2a: 0x0010, 0x3b2b: 0x0010, 0x3b2c: 0x0010,
	0x3b30: 0x0010, 0x3b31: 0x0010, 0x3b32: 0x0010, 0x3b33: 0x0010, 0x3b34: 0x0010,
	// Block 0xed, offset 0x3b40
	0x3b40: 0x0001, 0x3b41: 0x0001, 0x3b42: 0x0001, 0x3b43: 0x0001, 0x3b44: 0x0001, 0x3b45: 0x0001,
	0x3b46: 0x0001, 0x3b47: 0x0001, 0x3b48: 0x0001, 0x3b49: 0x0001, 0x3b4a: 0x0001, 0x3b4b: 0x0001,
	0x3b4c: 0x0001, 0x3b4d: 0x0001, 0x3b4e: 0x0001, 0x3b4f: 0x0001, 0x3b50: 0x0001, 0x3b51: 0x0001,
	0x3b52: 0x0001, 0x3b53: 0x0001, 0x3b54: 0x0001, 0x3b55: 0x0001, 0x3b56: 0x0001, 0x3b57: 0x0001,
	0x3b58: 0x0001, 0x3b59: 0x0001, 0x3b5a: 0x0001, 0x3b5b: 0x0001, 0x3b5c: 0x0001, 0x3b5d: 0x0001,
	0x3b5e: 0x0001, 0x3b5f: 0x0001, 0x3b60: 0x0001, 0x3b61: 0x0001, 0x3b62: 0x0001, 0x3b63: 0x0001,
	0x3b64: 0x0001, 0x3b65: 0x0001, 0x3b66: 0x0001, 0x3b67: 0x0001, 0x3b68: 0x0001, 0x3b69: 0x0001,
	0x3b6a: 0x0001, 0x3b6b: 0x0001, 0x3b6c: 0x0001, 0x3b6d: 0x0001, 0x3b6e: 0x0001, 0x3b6f: 0x0001,
	0x3b70: 0x0001, 0x3b71: 0x0001, 0x3b72: 0x0001, 0x3b73: 0x0001, 0x3b74: 0x0001, 0x3b75: 0x0010,
	0x3b76: 0x0010, 0x3b77: 0x0010, 0x3b78: 0x0010, 0x3b79: 0x0010, 0x3b7a: 0x0010, 0x3b7b: 0x0010,
	0x3b7c: 0x0010, 0x3b7d: 0x0010, 0x3b7e: 0x0010, 0x3b7f: 0x0010,
	// Block 0xee, offset 0x3b80
	0x3b80: 0x0010, 0x3b81: 0x0010, 0x3b82: 0x0010, 0x3b83: 0x0010, 0x3b84: 0x0010, 0x3b85: 0x0010,
	0x3b86: 0x0010, 0x3b87: 0x0001, 0x3b88: 0x0001, 0x3b89: 0x0001, 0x3b8a: 0x0001,
	0x3b90: 0x8000, 0x3b91: 0x8000,
	0x3b92: 0x8000, 0x3b93: 0x8000, 0x3b94: 0x8000, 0x3b95: 0x8000, 0x3b96: 0x8000, 0x3b97: 0x8000,
	0x3b98: 0x8000, 0x3b99: 0x8000,
	0x3b9e: 0x0010, 0x3b9f: 0x0001, 0x3ba0: 0x0001, 0x3ba1: 0x0001,
	// Block 0xef, offset 0x3bc0
	0x3bc0: 0x0001, 0x3bc1: 0x0001, 0x3bc2: 0x0001, 0x3bc3: 0x0001, 0x3bc4: 0x0001, 0x3bc5: 0x0001,
	0x3bc6: 0x0001, 0x3bc7: 0x0001, 0x3bc8: 0x0001, 0x3bc9: 0x0001, 0x3bca: 0x0001, 0x3bcb: 0x0001,
	0x3bcc: 0x0001, 0x3bcd: 0x0001, 0x3bce: 0x0001, 0x3bcf: 0x0001, 0x3bd0: 0x0001, 0x3bd1: 0x0001,
	0x3bd2: 0x0001, 0x3bd3: 0x0001, 0x3bd4: 0x0001, 0x3bd5: 0x0001, 0x3bd6: 0x0001, 0x3bd7: 0x0001,
	0x3bd8: 0x0001, 0x3bd9: 0x0001, 0x3bda: 0x0001, 0x3bdb: 0x0001, 0x3bdc: 0x0001, 0x3bdd: 0x0001,
	0x3bde: 0x0001, 0x3bdf: 0x0001, 0x3be0: 0x0001, 0x3be1: 0x0001, 0x3be2: 0x0001, 0x3be3: 0x0001,
	0x3be4: 0x0001, 0x3be5: 0x0001, 0x3be6: 0x0001, 0x3be7: 0x0001, 0x3be8: 0x0001, 0x3be9: 0x0001,
	0x3bea: 0x0001, 0x3beb: 0x0001, 0x3bec: 0x0001, 0x3bed: 0x0001, 0x3bee: 0x0001, 0x3bef: 0x0001,
	0x3bf0: 0x0010, 0x3bf1: 0x0010, 0x3bf2: 0x0010, 0x3bf3: 0x0010, 0x3bf4: 0x0010, 0x3bf5: 0x0010,
	0x3bf6: 0x0010, 0x3bf7: 0x0010, 0x3bf8: 0x0010, 0x3bf9: 0x0010, 0x3bfa: 0x0010, 0x3bfb: 0x0010,
	0x3bfc: 0x0010, 0x3bfd: 0x0010, 0x3bfe: 0x0010, 0x3bff: 0x0010,
	// Block 0xf0, offset 0x3c00
	0x3c00: 0x0010, 0x3c01: 0x0010, 0x3c02: 0x0010, 0x3c03: 0x0010, 0x3c04: 0x0001, 0x3c05: 0x0001,
	0x3c07: 0x0001,
	0x3c10: 0x8000, 0x3c11: 0x8000,
	0x3c12: 0x8000, 0x3c13: 0x8000, 0x3c14: 0x8000, 0x3c15: 0x8000, 0x3c16: 0x8000, 0x3c17: 0x8000,
	0x3c18: 0x8000, 0x3c19: 0x8000,
	// Block 0xf1, offset 0x3c40
	0x3c40: 0x0001, 0x3c41: 0x0001, 0x3c42: 0x0001, 0x3c43: 0x0001, 0x3c44: 0x0001, 0x3c45: 0x0001,
	0x3c46: 0x0001, 0x3c47: 0x0001, 0x3c48: 0x0001, 0x3c49: 0x0001, 0x3c4a: 0x0001, 0x3c4b: 0x0001,
	0x3c4c: 0x0001, 0x3c4d: 0x0001, 0x3c4e: 0x0001, 0x3c4f: 0x0001, 0x3c50: 0x0001, 0x3c51: 0x0001,
	0x3c52: 0x0001, 0x3c53: 0x0001, 0x3c54: 0x0001, 0x3c55: 0x0001, 0x3c56: 0x0001, 0x3c57: 0x0001,
	0x3c58: 0x0001, 0x3c59: 0x0001, 0x3c5a: 0x0001, 0x3c5b: 0x0001, 0x3c5c: 0x0001, 0x3c5d: 0x0001,
	0x3c5e: 0x0001, 0x3c5f: 0x0001, 0x3c60: 0x0001, 0x3c61: 0x0001, 0x3c62: 0x0001, 0x3c63: 0x0001,
	0x3c64: 0x0001, 0x3c65: 0x0001, 0x3c66: 0x0001, 0x3c67: 0x0001, 0x3c68: 0x0001, 0x3c69: 0x0001,
	0x3c6a: 0x0001, 0x3c6b: 0x0001, 0x3c6c: 0x0001, 0x3c6d: 0x0001, 0x3c6e: 0x0001, 0x3c6f: 0x0010,
	0x3c70: 0x0010, 0x3c71: 0x0010, 0x3c72: 0x0010, 0x3c73: 0x0010, 0x3c74: 0x0010, 0x3c75: 0x0010,
	0x3c78: 0x0010, 0x3c79: 0x0010, 0x3c7a: 0x0010, 0x3c7b: 0x0010,
	0x3c7c: 0x0010, 0x3c7d: 0x0010, 0x3c7e: 0x0010, 0x3c7f: 0x0010,
	// Block 0xf2, offset 0x3c80
	0x3c80: 0x0010,
	0x3c98: 0x0001, 0x3c99: 0x0001, 0x3c9a: 0x0001, 0x3c9b: 0x0001, 0x3c9c: 0x0010, 0x3c9d: 0x0010,
	// Block 0xf3, offset 0x3cc0
	0x3cc0: 0x0010, 0x3cc4: 0x0001,
	0x3cd0: 0x8000, 0x3cd1: 0x8000,
	0x3cd2: 0x8000, 0x3cd3: 0x8000, 0x3cd4: 0x8000, 0x3cd5: 0x8000, 0x3cd6: 0x8000, 0x3cd7: 0x8000,
	0x3cd8: 0x8000, 0x3cd9: 0x8000,
	// Block 0xf4, offset 0x3d00
	0x3d00: 0x0001, 0x3d01: 0x0001, 0x3d02: 0x0001, 0x3d03: 0x0001, 0x3d04: 0x0001, 0x3d05: 0x0001,
	0x3d06: 0x0001, 0x3d07: 0x0001, 0x3d08: 0x0001, 0x3d09: 0x0001, 0x3d0a: 0x0001, 0x3d0b: 0x0001,
	0x3d0c: 0x0001, 0x3d0d: 0x0001, 0x3d0e: 0x0001, 0x3d0f: 0x0001, 0x3d10: 0x0001, 0x3d11: 0x0001,
	0x3d12: 0x0001, 0x3d13: 0x0001, 0x3d14: 0x0001, 0x3d15: 0x0001, 0x3d16: 0x0001, 0x3d17: 0x0001,
	0x3d18: 0x0001, 0x3d19: 0x0001, 0x3d1a: 0x0001, 0x3d1b: 0x0001, 0x3d1c: 0x0001, 0x3d1d: 0x0001,
	0x3d1e: 0x0001, 0x3d1f: 0x0001, 0x3d20: 0x0001, 0x3d21: 0x0001, 0x3d22: 0x0001, 0x3d23: 0x0001,
	0x3d24: 0x0001, 0x3d25: 0x0001, 0x3d26: 0x0001, 0x3d27: 0x0001, 0x3d28: 0x0001, 0x3d29: 0x0001,
	0x3d2a: 0x0001, 0x3d2b: 0x0010, 0x3d2c: 0x0010, 0x3d2d: 0x0010, 0x3d2e: 0x0010, 0x3d2f: 0x0010,
	0x3d30: 0x0010, 0x3d31: 0x0010, 0x3d32: 0x0010, 0x3d33: 0x0010, 0x3d34: 0x0010, 0x3d35: 0x0010,
	0x3d36: 0x0010, 0x3d37: 0x0010, 0x3d38: 0x0001,
	// Block 0xf5, offset 0x3d40
	0x3d40: 0x8000, 0x3d41: 0x8000, 0x3d42: 0x8000, 0x3d43: 0x8000, 0x3d44: 0x8000, 0x3d45: 0x8000,
	0x3d46: 0x8000, 0x3d47: 0x8000, 0x3d48: 0x8000, 0x3d49: 0x8000,
	// Block 0xf6, offset 0x3d80
	0x3d9d: 0x0010,
	0x3d9e: 0x0010, 0x3d9f: 0x0010, 0x3da0: 0x0010, 0x3da1: 0x0010, 0x3da2: 0x0010, 0x3da3: 0x0010,
	0x3da4: 0x0010, 0x3da5: 0x0010, 0x3da6: 0x0010, 0x3da7: 0x0010, 0x3da8: 0x0010, 0x3da9: 0x0010,
	0x3daa: 0x0010, 0x3dab: 0x0010,
	0x3db0: 0x8000, 0x3db1: 0x8000, 0x3db2: 0x8000, 0x3db3: 0x8000, 0x3db4: 0x8000, 0x3db5: 0x8000,
	0x3db6: 0x8000, 0x3db7: 0x8000, 0x3db8: 0x8000, 0x3db9: 0x8000,
	// Block 0xf7, offset 0x3dc0
	0x3dc0: 0x0001, 0x3dc1: 0x0001, 0x3dc2: 0x0001, 0x3dc3: 0x0001, 0x3dc4: 0x0001, 0x3dc5: 0x0001,
	0x3dc6: 0x0001, 0x3dc7: 0x0001, 0x3dc8: 0x0001, 0x3dc9: 0x0001, 0x3dca: 0x0001, 0x3dcb: 0x0001,
	0x3dcc: 0x0001, 0x3dcd: 0x0001, 0x3dce: 0x0001, 0x3dcf: 0x0001, 0x3dd0: 0x0001, 0x3dd1: 0x0001,
	0x3dd2: 0x0001, 0x3dd3: 0x0001, 0x3dd4: 0x0001, 0x3dd5: 0x0001, 0x3dd6: 0x0001, 0x3dd7: 0x0001,
	0x3dd8: 0x0001, 0x3dd9: 0x0001, 0x3dda: 0x0001, 0x3ddb: 0x0001, 0x3ddc: 0x0001, 0x3ddd: 0x0001,
	0x3dde: 0x0001, 0x3ddf: 0x0001, 0x3de0: 0x0001, 0x3de1: 0x0001, 0x3de2: 0x0001, 0x3de3: 0x0001,
	0x3de4: 0x0001, 0x3de5: 0x0001, 0x3de6: 0x0001, 0x3de7: 0x0001, 0x3de8: 0x0001, 0x3de9: 0x0001,
	0x3dea: 0x0001, 0x3deb: 0x0001, 0x3dec: 0x0010, 0x3ded: 0x0010, 0x3dee: 0x0010, 0x3def: 0x0010,
	0x3df0: 0x0010, 0x3df1: 0x0010, 0x3df2: 0x0010, 0x3df3: 0x0010, 0x3df4: 0x0010, 0x3df5: 0x0010,
	0x3df6: 0x0010, 0x3df7: 0x0010, 0x3df8: 0x0010, 0x3df9: 0x0010, 0x3dfa: 0x0010,
	// Block 0xf8, offset 0x3e00
	0x3e20: 0x0001, 0x3e21: 0x0001, 0x3e22: 0x0001, 0x3e23: 0x0001,
	0x3e24: 0x0001, 0x3e25: 0x0001, 0x3e26: 0x0001, 0x3e27: 0x0001, 0x3e28: 0x0001, 0x3e29: 0x0001,
	0x3e2a: 0x0001, 0x3e2b: 0x0001, 0x3e2c: 0x0001, 0x3e2d: 0x0001, 0x3e2e: 0x0001, 0x3e2f: 0x0001,
	0x3e30: 0x0001, 0x3e31: 0x0001, 0x3e32: 0x0001, 0x3e33: 0x0001, 0x3e34: 0x0001, 0x3e35: 0x0001,
	0x3e36: 0x0001, 0x3e37: 0x0001, 0x3e38: 0x0001, 0x3e39: 0x0001, 0x3e3a: 0x0001, 0x3e3b: 0x0001,
	0x3e3c: 0x0001, 0x3e3d: 0x0001, 0x3e3e: 0x0001, 0x3e3f: 0x0001,
	// Block 0xf9, offset 0x3e40
	0x3e40: 0x0001, 0x3e41: 0x0001, 0x3e42: 0x0001, 0x3e43: 0x0001, 0x3e44: 0x0001, 0x3e45: 0x0001,
	0x3e46: 0x0001, 0x3e47: 0x0001, 0x3e48: 0x0001, 0x3e49: 0x0001, 0x3e4a: 0x0001, 0x3e4b: 0x0001,
	0x3e4c: 0x0001, 0x3e4d: 0x0001, 0x3e4e: 0x0001, 0x3e4f: 0x0001, 0x3e50: 0x0001, 0x3e51: 0x0001,
	0x3e52: 0x0001, 0x3e53: 0x0001, 0x3e54: 0x0001, 0x3e55: 0x0001, 0x3e56: 0x0001, 0x3e57: 0x0001,
	0x3e58: 0x0001, 0x3e59: 0x0001, 0x3e5a: 0x0001, 0x3e5b: 0x0001, 0x3e5c: 0x0001, 0x3e5d: 0x0001,
	0x3e5e: 0x0001, 0x3e5f: 0x0001, 0x3e60: 0x8000, 0x3e61: 0x8000, 0x3e62: 0x8000, 0x3e63: 0x8000,
	0x3e64: 0x8000, 0x3e65: 0x8000, 0x3e66: 0x8000, 0x3e67: 0x8000, 0x3e68: 0x8000, 0x3e69: 0x8000,
	0x3e7f: 0x0001,
	// Block 0xfa, offset 0x3e80
	0x3e80: 0x0001, 0x3e81: 0x0001, 0x3e82: 0x0001, 0x3e83: 0x0001, 0x3e84: 0x0001, 0x3e85: 0x0001,
	0x3e86: 0x0001, 0x3e89: 0x0001,
	0x3e8c: 0x0001, 0x3e8d: 0x0001, 0x3e8e: 0x0001, 0x3e8f: 0x0001, 0x3e90: 0x0001, 0x3e91: 0x0001,
	0x3e92: 0x0001, 0x3e93: 0x0001, 0x3e95: 0x0001, 0x3e96: 0x0001,
	0x3e98: 0x0001, 0x3e99: 0x0001, 0x3e9a: 0x0001, 0x3e9b: 0x0001, 0x3e9c: 0x0001, 0x3e9d: 0x0001,
	0x3e9e: 0x0001, 0x3e9f: 0x0001, 0x3ea0: 0x0001, 0x3ea1: 0x0001, 0x3ea2: 0x0001, 0x3ea3: 0x0001,
	0x3ea4: 0x0001, 0x3ea5: 0x0001, 0x3ea6: 0x0001, 0x3ea7: 0x0001, 0x3ea8: 0x0001, 0x3ea9: 0x0001,
	0x3eaa: 0x0001, 0x3eab: 0x0001, 0x3eac: 0x0001, 0x3ead: 0x0001, 0x3eae: 0x0001, 0x3eaf: 0x0001,
	0x3eb0: 0x0010, 0x3eb1: 0x0010, 0x3eb2: 0x0010, 0x3eb3: 0x0010, 0x3eb4: 0x0010, 0x3eb5: 0x0010,
	0x3eb7: 0x0010, 0x3eb8: 0x0010, 0x3ebb: 0x0010,
	0x3ebc: 0x0010, 0x3ebd: 0x0010, 0x3ebe: 0x0010, 0x3ebf: 0x0001,
	// Block 0xfb, offset 0x3ec0
	0x3ec0: 0x0010, 0x3ec1: 0x0001, 0x3ec2: 0x0010, 0x3ec3: 0x0010,
	0x3ed0: 0x8000, 0x3ed1: 0x8000,
	0x3ed2: 0x8000, 0x3ed3: 0x8000, 0x3ed4: 0x8000, 0x3ed5: 0x8000, 0x3ed6: 0x8000, 0x3ed7: 0x8000,
	0x3ed8: 0x8000, 0x3ed9: 0x8000,
	// Block 0xfc, offset 0x3f00
	0x3f20: 0x0001, 0x3f21: 0x0001, 0x3f22: 0x0001, 0x3f23: 0x0001,
	0x3f24: 0x0001, 0x3f25: 0x0001, 0x3f26: 0x0001, 0x3f27: 0x0001,
	0x3f2a: 0x0001, 0x3f2b: 0x0001, 0x3f2c: 0x0001, 0x3f2d: 0x0001, 0x3f2e: 0x0001, 0x3f2f: 0x0001,
	0x3f30: 0x0001, 0x3f31: 0x0001, 0x3f32: 0x0001, 0x3f33: 0x0001, 0x3f34: 0x0001, 0x3f35: 0x0001,
	0x3f36: 0x0001, 0x3f37: 0x0001, 0x3f38: 0x0001, 0x3f39: 0x0001, 0x3f3a: 0x0001, 0x3f3b: 0x0001,
	0x3f3c: 0x0001, 0x3f3d: 0x0001, 0x3f3e: 0x0001, 0x3f3f: 0x0001,
	// Block 0xfd, offset 0x3f40
	0x3f40: 0x0001, 0x3f41: 0x0001, 0x3f42: 0x0001, 0x3f43: 0x0001, 0x3f44: 0x0001, 0x3f45: 0x0001,
	0x3f46: 0x0001, 0x3f47: 0x0001, 0x3f48: 0x0001, 0x3f49: 0x0001, 0x3f4a: 0x0001, 0x3f4b: 0x0001,
	0x3f4c: 0x0001, 0x3f4d: 0x0001, 0x3f4e: 0x0001, 0x3f4f: 0x0001, 0x3f50: 0x0001, 0x3f51: 0x0010,
	0x3f52: 0x0010, 0x3f53: 0x0010, 0x3f54: 0x0010, 0x3f55: 0x0010, 0x3f56: 0x0010, 0x3f57: 0x0010,
	0x3f5a: 0x0010, 0x3f5b: 0x0010, 0x3f5c: 0x0010, 0x3f5d: 0x0010,
	0x3f5e: 0x0010, 0x3f5f: 0x0010, 0x3f60: 0x0010, 0x3f61: 0x0001, 0x3f63: 0x0001,
	0x3f64: 0x0010,
	// Block 0xfe, offset 0x3f80
	0x3f80: 0x0001, 0x3f81: 0x0010, 0x3f82: 0x0010, 0x3f83: 0x0010, 0x3f84: 0x0010, 0x3f85: 0x0010,
	0x3f86: 0x0010, 0x3f87: 0x0010, 0x3f88: 0x0010, 0x3f89: 0x0010, 0x3f8a: 0x0010, 0x3f8b: 0x0001,
	0x3f8c: 0x0001, 0x3f8d: 0x0001, 0x3f8e: 0x0001, 0x3f8f: 0x0001, 0x3f90: 0x0001, 0x3f91: 0x0001,
	0x3f92: 0x0001, 0x3f93: 0x0001, 0x3f94: 0x0001, 0x3f95: 0x0001, 0x3f96: 0x0001, 0x3f97: 0x0001,
	0x3f98: 0x0001, 0x3f99: 0x0001, 0x3f9a: 0x0001, 0x3f9b: 0x0001, 0x3f9c: 0x0001, 0x3f9d: 0x0001,
	0x3f9e: 0x0001, 0x3f9f: 0x0001, 0x3fa0: 0x0001, 0x3fa1: 0x0001, 0x3fa2: 0x0001, 0x3fa3: 0x0001,
	0x3fa4: 0x0001, 0x3fa5: 0x0001, 0x3fa6: 0x0001, 0x3fa7: 0x0001, 0x3fa8: 0x0001, 0x3fa9: 0x0001,
	0x3faa: 0x0001, 0x3fab: 0x0001, 0x3fac: 0x0001, 0x3fad: 0x0001, 0x3fae: 0x0001, 0x3faf: 0x0001,
	0x3fb0: 0x0001, 0x3fb1: 0x0001, 0x3fb2: 0x0001, 0x3fb3: 0x0010, 0x3fb4: 0x0010, 0x3fb5: 0x0010,
	0x3fb6: 0x0010, 0x3fb7: 0x0010, 0x3fb8: 0x0010, 0x3fb9: 0x0010, 0x3fba: 0x0001, 0x3fbb: 0x0010,
	0x3fbc: 0x0010, 0x3fbd: 0x0010, 0x3fbe: 0x0010,
	// Block 0xff, offset 0x3fc0
	0x3fc7: 0x0010,
	0x3fd0: 0x0001, 0x3fd1: 0x0010,
	0x3fd2: 0x0010, 0x3fd3: 0x0010, 0x3fd4: 0x0010, 0x3fd5: 0x0010, 0x3fd6: 0x0010, 0x3fd7: 0x0010,
	0x3fd8: 0x0010, 0x3fd9: 0x0010, 0x3fda: 0x0010, 0x3fdb: 0x0010, 0x3fdc: 0x0001, 0x3fdd: 0x0001,
	0x3fde: 0x0001, 0x3fdf: 0x0001, 0x3fe0: 0x0001, 0x3fe1: 0x0001, 0x3fe2: 0x0001, 0x3fe3: 0x0001,
	0x3fe4: 0x0001, 0x3fe5: 0x0001, 0x3fe6: 0x0001, 0x3fe7: 0x0001, 0x3fe8: 0x0001, 0x3fe9: 0x0001,
	0x3fea: 0x0001, 0x3feb: 0x0001, 0x3fec: 0x0001, 0x3fed: 0x0001, 0x3fee: 0x0001, 0x3fef: 0x0001,
	0x3ff0: 0x0001, 0x3ff1: 0x0001, 0x3ff2: 0x0001, 0x3ff3: 0x0001, 0x3ff4: 0x0001, 0x3ff5: 0x0001,
	0x3ff6: 0x0001, 0x3ff7: 0x0001, 0x3ff8: 0x0001, 0x3ff9: 0x0001, 0x3ffa: 0x0001, 0x3ffb: 0x0001,
	0x3ffc: 0x0001, 0x3ffd: 0x0001, 0x3ffe: 0x0001, 0x3fff: 0x0001,
	// Block 0x100, offset 0x4000
	0x4000: 0x0001, 0x4001: 0x0001, 0x4002: 0x0001, 0x4003: 0x0001, 0x4004: 0x0001, 0x4005: 0x0001,
	0x4006: 0x0001, 0x4007: 0x0001, 0x4008: 0x0001, 0x4009: 0x0001, 0x400a: 0x0010, 0x400b: 0x0010,
	0x400c: 0x0010, 0x400d: 0x0010, 0x400e: 0x0010, 0x400f: 0x0010, 0x4010: 0x0010, 0x4011: 0x0010,
	0x4012: 0x0010, 0x4013: 0x0010, 0x4014: 0x0010, 0x4015: 0x0010, 0x4016: 0x0010, 0x4017: 0x0010,
	0x4018: 0x0010, 0x4019: 0x0010, 0x401d: 0x0001,
	0x4030: 0x0001, 0x4031: 0x0001, 0x4032: 0x0001, 0x4033: 0x0001, 0x4034: 0x0001, 0x4035: 0x0001,
	0x4036: 0x0001, 0x4037: 0x0001, 0x4038: 0x0001, 0x4039: 0x0001, 0x403a: 0x0001, 0x403b: 0x0001,
	0x403c: 0x0001, 0x403d: 0x0001, 0x403e: 0x0001, 0x403f: 0x0001,
	// Block 0x101, offset 0x4040
	0x4040: 0x0001, 0x4041: 0x0001, 0x4042: 0x0001, 0x4043: 0x0001, 0x4044: 0x0001, 0x4045: 0x0001,
	0x4046: 0x0001, 0x4047: 0x0001, 0x4048: 0x0001, 0x404a: 0x0001, 0x404b: 0x0001,
	0x404c: 0x0001, 0x404d: 0x0001, 0x404e: 0x0001, 0x404f: 0x0001, 0x4050: 0x0001, 0x4051: 0x0001,
	0x4052: 0x0001, 0x4053: 0x0001, 0x4054: 0x0001, 0x4055: 0x0001, 0x4056: 0x0001, 0x4057: 0x0001,
	0x4058: 0x0001, 0x4059: 0x0001, 0x405a: 0x0001, 0x405b: 0x0001, 0x405c: 0x0001, 0x405d: 0x0001,
	0x405e: 0x0001, 0x405f: 0x0001, 0x4060: 0x0001, 0x4061: 0x0001, 0x4062: 0x0001, 0x4063: 0x0001,
	0x4064: 0x0001, 0x4065: 0x0001, 0x4066: 0x0001, 0x4067: 0x0001, 0x4068: 0x0001, 0x4069: 0x0001,
	0x406a: 0x0001, 0x406b: 0x0001, 0x406c: 0x0001, 0x406d: 0x0001, 0x406e: 0x0001, 0x406f: 0x0010,
	0x4070: 0x0010, 0x4071: 0x0010, 0x4072: 0x0010, 0x4073: 0x0010, 0x4074: 0x0010, 0x4075: 0x0010,
	0x4076: 0x0010, 0x4078: 0x0010, 0x4079: 0x0010, 0x407a: 0x0010, 0x407b: 0x0010,
	0x407c: 0x0010, 0x407d: 0x0010, 0x407e: 0x0010, 0x407f: 0x0010,
	// Block 0x102, offset 0x4080
	0x4080: 0x0001,
	0x4090: 0x8000, 0x4091: 0x8000,
	0x4092: 0x8000, 0x4093: 0x8000, 0x4094: 0x8000, 0x4095: 0x8000, 0x4096: 0x8000, 0x4097: 0x8000,
	0x4098: 0x8000, 0x4099: 0x8000,
	0x40b2: 0x0001, 0x40b3: 0x0001, 0x40b4: 0x0001, 0x40b5: 0x0001,
	0x40b6: 0x0001, 0x40b7: 0x0001, 0x40b8: 0x0001, 0x40b9: 0x0001, 0x40ba: 0x0001, 0x40bb: 0x0001,
	0x40bc: 0x0001, 0x40bd: 0x0001, 0x40be: 0x0001, 0x40bf: 0x0001,
	// Block 0x103, offset 0x40c0
	0x40c0: 0x0001, 0x40c1: 0x0001, 0x40c2: 0x0001, 0x40c3: 0x0001, 0x40c4: 0x0001, 0x40c5: 0x0001,
	0x40c6: 0x0001, 0x40c7: 0x0001, 0x40c8: 0x0001, 0x40c9: 0x0001, 0x40ca: 0x0001, 0x40cb: 0x0001,
	0x40cc: 0x0001, 0x40cd: 0x0001, 0x40ce: 0x0001, 0x40cf: 0x0001,
	0x40d2: 0x0010, 0x40d3: 0x0010, 0x40d4: 0x0010, 0x40d5: 0x0010, 0x40d6: 0x0010, 0x40d7: 0x0010,
	0x40d8: 0x0010, 0x40d9: 0x0010, 0x40da: 0x0010, 0x40db: 0x0010, 0x40dc: 0x0010, 0x40dd: 0x0010,
	0x40de: 0x0010, 0x40df: 0x0010, 0x40e0: 0x0010, 0x40e1: 0x0010, 0x40e2: 0x0010, 0x40e3: 0x0010,
	0x40e4: 0x0010, 0x40e5: 0x0010, 0x40e6: 0x0010, 0x40e7: 0x0010, 0x40e9: 0x0010,
	0x40ea: 0x0010, 0x40eb: 0x0010, 0x40ec: 0x0010, 0x40ed: 0x0010, 0x40ee: 0x0010, 0x40ef: 0x0010,
	0x40f0: 0x0010, 0x40f1: 0x0010, 0x40f2: 0x0010, 0x40f3: 0x0010, 0x40f4: 0x0010, 0x40f5: 0x0010,
	0x40f6: 0x0010,
	// Block 0x104, offset 0x4100
	0x4100: 0x0001, 0x4101: 0x0001, 0x4102: 0x0001, 0x4103: 0x0001, 0x4104: 0x0001, 0x4105: 0x0001,
	0x4106: 0x0001, 0x4108: 0x0001, 0x4109: 0x0001, 0x410b: 0x0001,
	0x410c: 0x0001, 0x410d: 0x0001, 0x410e: 0x0001, 0x410f: 0x0001, 0x4110: 0x0001, 0x4111: 0x0001,
	0x4112: 0x0001, 0x4113: 0x0001, 0x4114: 0x0001, 0x4115: 0x0001, 0x4116: 0x0001, 0x4117: 0x0001,
	0x4118: 0x0001, 0x4119: 0x0001, 0x411a: 0x0001, 0x411b: 0x0001, 0x411c: 0x0001, 0x411d: 0x0001,
	0x411e: 0x0001, 0x411f: 0x0001, 0x4120: 0x0001, 0x4121: 0x0001, 0x4122: 0x0001, 0x4123: 0x0001,
	0x4124: 0x0001, 0x4125: 0x0001, 0x4126: 0x0001, 0x4127: 0x0001, 0x4128: 0x0001, 0x4129: 0x0001,
	0x412a: 0x0001, 0x412b: 0x0001, 0x412c: 0x0001, 0x412d: 0x0001, 0x412e: 0x0001, 0x412f: 0x0001,
	0x4130: 0x0001, 0x4131: 0x0010, 0x4132: 0x0010, 0x4133: 0x0010, 0x4134: 0x0010, 0x4135: 0x0010,
	0x4136: 0x0010, 0x413a: 0x0010,
	0x413c: 0x0010, 0x413d: 0x0010, 0x413f: 0x0010,
	// Block 0x105, offset 0x4140
	0x4140: 0x0010, 0x4141: 0x0010, 0x4142: 0x0010, 0x4143: 0x0010, 0x4144: 0x0010, 0x4145: 0x0010,
	0x4146: 0x0001, 0x4147: 0x0010,
	0x4150: 0x8000, 0x4151: 0x8000,
	0x4152: 0x8000, 0x4153: 0x8000, 0x4154: 0x8000, 0x4155: 0x8000, 0x4156: 0x8000, 0x4157: 0x8000,
	0x4158: 0x8000, 0x4159: 0x8000,
	0x4160: 0x0001, 0x4161: 0x0001, 0x4162: 0x0001, 0x4163: 0x0001,
	0x4164: 0x0001, 0x4165: 0x0001, 0x4167: 0x0001, 0x4168: 0x0001,
	0x416a: 0x0001, 0x416b: 0x0001, 0x416c: 0x0001, 0x416d: 0x0001, 0x416e: 0x0001, 0x416f: 0x0001,
	0x4170: 0x0001, 0x4171: 0x0001, 0x4172: 0x0001, 0x4173: 0x0001, 0x4174: 0x0001, 0x4175: 0x0001,
	0x4176: 0x0001, 0x4177: 0x0001, 0x4178: 0x0001, 0x4179: 0x0001, 0x417a: 0x0001, 0x417b: 0x0001,
	0x417c: 0x0001, 0x417d: 0x0001, 0x417e: 0x0001, 0x417f: 0x0001,
	// Block 0x106, offset 0x4180
	0x4180: 0x0001, 0x4181: 0x0001, 0x4182: 0x0001, 0x4183: 0x0001, 0x4184: 0x0001, 0x4185: 0x0001,
	0x4186: 0x0001, 0x4187: 0x0001, 0x4188: 0x0001, 0x4189: 0x0001, 0x418a: 0x0010, 0x418b: 0x0010,
	0x418c: 0x0010, 0x418d: 0x0010, 0x418e: 0x0010, 0x4190: 0x0010, 0x4191: 0x0010,
	0x4193: 0x0010, 0x4194: 0x0010, 0x4195: 0x0010, 0x4196: 0x0010, 0x4197: 0x0010,
	0x4198: 0x0001,
	0x41a0: 0x8000, 0x41a1: 0x8000, 0x41a2: 0x8000, 0x41a3: 0x8000,
	0x41a4: 0x8000, 0x41a5: 0x8000, 0x41a6: 0x8000, 0x41a7: 0x8000, 0x41a8: 0x8000, 0x41a9: 0x8000,
	// Block 0x107, offset 0x41c0
	0x41e0: 0x0001, 0x41e1: 0x0001, 0x41e2: 0x0001, 0x41e3: 0x0001,
	0x41e4: 0x0001, 0x41e5: 0x0001, 0x41e6: 0x0001, 0x41e7: 0x0001, 0x41e8: 0x0001, 0x41e9: 0x0001,
	0x41ea: 0x0001, 0x41eb: 0x0001, 0x41ec: 0x0001, 0x41ed: 0x0001, 0x41ee: 0x0001, 0x41ef: 0x0001,
	0x41f0: 0x0001, 0x41f1: 0x0001, 0x41f2: 0x0001, 0x41f3: 0x0010, 0x41f4: 0x0010, 0x41f5: 0x0010,
	0x41f6: 0x0010,
	// Block 0x108, offset 0x4200
	0x4200: 0x0010, 0x4201: 0x0010, 0x4202: 0x0001, 0x4203: 0x0010, 0x4204: 0x0001, 0x4205: 0x0001,
	0x4206: 0x0001, 0x4207: 0x0001, 0x4208: 0x0001, 0x4209: 0x0001, 0x420a: 0x0001, 0x420b: 0x0001,
	0x420c: 0x0001, 0x420d: 0x0001, 0x420e: 0x0001, 0x420f: 0x0001, 0x4210: 0x0001,
	0x4212: 0x0001, 0x4213: 0x0001, 0x4214: 0x0001, 0x4215: 0x0001, 0x4216: 0x0001, 0x4217: 0x0001,
	0x4218: 0x0001, 0x4219: 0x0001, 0x421a: 0x0001, 0x421b: 0x0001, 0x421c: 0x0001, 0x421d: 0x0001,
	0x421e: 0x0001, 0x421f: 0x0001, 0x4220: 0x0001, 0x4221: 0x0001, 0x4222: 0x0001, 0x4223: 0x0001,
	0x4224: 0x0001, 0x4225: 0x0001, 0x4226: 0x0001, 0x4227: 0x0001, 0x4228: 0x0001, 0x4229: 0x0001,
	0x422a: 0x0001, 0x422b: 0x0001, 0x422c: 0x0001, 0x422d: 0x0001, 0x422e: 0x0001, 0x422f: 0x0001,
	0x4230: 0x0001, 0x4231: 0x0001, 0x4232: 0x0001, 0x4233: 0x0001, 0x4234: 0x0010, 0x4235: 0x0010,
	0x4236: 0x0010, 0x4237: 0x0010, 0x4238: 0x0010, 0x4239: 0x0010, 0x423a: 0x0010,
	0x423e: 0x0010, 0x423f: 0x0010,
	// Block 0x109, offset 0x4240
	0x4240: 0x0010, 0x4241: 0x0010, 0x4242: 0x0010,
	0x4250: 0x8000, 0x4251: 0x8000,
	0x4252: 0x8000, 0x4253: 0x8000, 0x4254: 0x8000, 0x4255: 0x8000, 0x4256: 0x8000, 0x4257: 0x8000,
	0x4258: 0x8000, 0x4259: 0x8000,
	// Block 0x10a, offset 0x4280
	0x42b0: 0x0001,
	// Block 0x10b, offset 0x42c0
	0x42c0: 0x0001, 0x42c1: 0x0001, 0x42c2: 0x0001, 0x42c3: 0x0001, 0x42c4: 0x0001, 0x42c5: 0x0001,
	0x42c6: 0x0001, 0x42c7: 0x0001, 0x42c8: 0x0001, 0x42c9: 0x0001, 0x42ca: 0x0001, 0x42cb: 0x0001,
	0x42cc: 0x0001, 0x42cd: 0x0001, 0x42ce: 0x0001, 0x42cf: 0x0001, 0x42d0: 0x0001, 0x42d1: 0x0001,
	0x42d2: 0x0001, 0x42d3: 0x0001, 0x42d4: 0x0001, 0x42d5: 0x0001, 0x42d6: 0x0001, 0x42d7: 0x0001,
	0x42d8: 0x0001, 0x42d9: 0x0001,
	// Block 0x10c, offset 0x4300
	0x4300: 0x0001, 0x4301: 0x0001, 0x4302: 0x0001, 0x4303: 0x0001, 0x4304: 0x0001, 0x4305: 0x0001,
	0x4306: 0x0001, 0x4307: 0x0001, 0x4308: 0x0001, 0x4309: 0x0001, 0x430a: 0x0001, 0x430b: 0x0001,
	0x430c: 0x0001, 0x430d: 0x0001, 0x430e: 0x0001, 0x430f: 0x0001, 0x4310: 0x0001, 0x4311: 0x0001,
	0x4312: 0x0001, 0x4313: 0x0001, 0x4314: 0x0001, 0x4315: 0x0001, 0x4316: 0x0001, 0x4317: 0x0001,
	0x4318: 0x0001, 0x4319: 0x0001, 0x431a: 0x0001, 0x431b: 0x0001, 0x431c: 0x0001, 0x431d: 0x0001,
	0x431e: 0x0001, 0x431f: 0x0001, 0x4320: 0x0001, 0x4321: 0x0001, 0x4322: 0x0001, 0x4323: 0x0001,
	0x4324: 0x0001, 0x4325: 0x0001, 0x4326: 0x0001, 0x4327: 0x0001, 0x4328: 0x0001, 0x4329: 0x0001,
	0x432a: 0x0001, 0x432b: 0x0001, 0x432c: 0x0001, 0x432d: 0x0001, 0x432e: 0x0001,
	// Block 0x10d, offset 0x4340
	0x4340: 0x0001, 0x4341: 0x0001, 0x4342: 0x0001, 0x4343: 0x0001,
	// Block 0x10e, offset 0x4380
	0x4380: 0x0001, 0x4381: 0x0001, 0x4382: 0x0001, 0x4383: 0x0001, 0x4384: 0x0001, 0x4385: 0x0001,
	0x4386: 0x0001, 0x4387: 0x0001, 0x4388: 0x0001, 0x4389: 0x0001, 0x438a: 0x0001, 0x438b: 0x0001,
	0x438c: 0x0001, 0x438d: 0x0001, 0x438e: 0x0001, 0x438f: 0x0001, 0x4390: 0x0001, 0x4391: 0x0001,
	0x4392: 0x0001, 0x4393: 0x0001, 0x4394: 0x0001, 0x4395: 0x0001, 0x4396: 0x0001, 0x4397: 0x0001,
	0x4398: 0x0001, 0x4399: 0x0001, 0x439a: 0x0001, 0x439b: 0x0001, 0x439c: 0x0001, 0x439d: 0x0001,
	0x439e: 0x0001, 0x439f: 0x0001, 0x43a0: 0x0001, 0x43a1: 0x0001, 0x43a2: 0x0001, 0x43a3: 0x0001,
	0x43a4: 0x0001, 0x43a5: 0x0001, 0x43a6: 0x0001, 0x43a7: 0x0001, 0x43a8: 0x0001, 0x43a9: 0x0001,
	0x43aa: 0x0001, 0x43ab: 0x0001, 0x43ac: 0x0001, 0x43ad: 0x0001, 0x43ae: 0x0001, 0x43af: 0x0001,
	0x43b0: 0x0001,
	// Block 0x10f, offset 0x43c0
	0x43c0: 0x0001, 0x43c1: 0x0001, 0x43c2: 0x0001, 0x43c3: 0x0001, 0x43c4: 0x0001, 0x43c5: 0x0001,
	0x43c6: 0x0001, 0x43c7: 0x0001, 0x43c8: 0x0001, 0x43c9: 0x0001, 0x43ca: 0x0001, 0x43cb: 0x0001,
	0x43cc: 0x0001, 0x43cd: 0x0001, 0x43ce: 0x0001, 0x43cf: 0x0001, 0x43d0: 0x0001, 0x43d1: 0x0001,
	0x43d2: 0x0001, 0x43d3: 0x0001, 0x43d4: 0x0001, 0x43d5: 0x0001, 0x43d6: 0x0001, 0x43d7: 0x0001,
	0x43d8: 0x0001, 0x43d9: 0x0001, 0x43da: 0x0001, 0x43db: 0x0001, 0x43dc: 0x0001, 0x43dd: 0x0001,
	0x43de: 0x0001, 0x43df: 0x0001, 0x43e0: 0x0001, 0x43e1: 0x0001, 0x43e2: 0x0001, 0x43e3: 0x0001,
	0x43e4: 0x0001, 0x43e5: 0x0001, 0x43e6: 0x0001, 0x43e7: 0x0001, 0x43e8: 0x0001, 0x43e9: 0x0001,
	0x43ea: 0x0001, 0x43eb: 0x0001, 0x43ec: 0x0001, 0x43ed: 0x0001, 0x43ee: 0x0001, 0x43ef: 0x0001,
	0x43f0: 0x0080, 0x43f1: 0x0080, 0x43f2: 0x0080, 0x43f3: 0x0080, 0x43f4: 0x0080, 0x43f5: 0x0080,
	0x43f6: 0x0080, 0x43f7: 0x0080, 0x43f8: 0x0080, 0x43f9: 0x0080, 0x43fa: 0x0080, 0x43fb: 0x0080,
	0x43fc: 0x0080, 0x43fd: 0x0080, 0x43fe: 0x0080, 0x43ff: 0x0080,
	// Block 0x110, offset 0x4400
	0x4400: 0x0010, 0x4401: 0x0001, 0x4402: 0x0001, 0x4403: 0x0001, 0x4404: 0x0001, 0x4405: 0x0001,
	0x4406: 0x0001, 0x4407: 0x0010, 0x4408: 0x0010, 0x4409: 0x0010, 0x440a: 0x0010, 0x440b: 0x0010,
	0x440c: 0x0010, 0x440d: 0x0010, 0x440e: 0x0010, 0x440f: 0x0010, 0x4410: 0x0010, 0x4411: 0x0010,
	0x4412: 0x0010, 0x4413: 0x0010, 0x4414: 0x0010, 0x4415: 0x0010,
	// Block 0x111, offset 0x4440
	0x4440: 0x0001, 0x4441: 0x0001, 0x4442: 0x0001, 0x4443: 0x0001, 0x4444: 0x0001, 0x4445: 0x0001,
	0x4446: 0x0001,
	// Block 0x112, offset 0x4480
	0x4480: 0x0001, 0x4481: 0x0001, 0x4482: 0x0001, 0x4483: 0x0001, 0x4484: 0x0001, 0x4485: 0x0001,
	0x4486: 0x0001, 0x4487: 0x0001, 0x4488: 0x0001, 0x4489: 0x0001, 0x448a: 0x0001, 0x448b: 0x0001,
	0x448c: 0x0001, 0x448d: 0x0001, 0x448e: 0x0001, 0x448f: 0x0001, 0x4490: 0x0001, 0x4491: 0x0001,
	0x4492: 0x0001, 0x4493: 0x0001, 0x4494: 0x0001, 0x4495: 0x0001, 0x4496: 0x0001, 0x4497: 0x0001,
	0x4498: 0x0001, 0x4499: 0x0001, 0x449a: 0x0001, 0x449b: 0x0001, 0x449c: 0x0001, 0x449d: 0x0001,
	0x449e: 0x0001, 0x44a0: 0x8000, 0x44a1: 0x8000, 0x44a2: 0x8000, 0x44a3: 0x8000,
	0x44a4: 0x8000, 0x44a5: 0x8000, 0x44a6: 0x8000, 0x44a7: 0x8000, 0x44a8: 0x8000, 0x44a9: 0x8000,
	0x44b0: 0x0001, 0x44b1: 0x0001, 0x44b2: 0x0001, 0x44b3: 0x0001, 0x44b4: 0x0001, 0x44b5: 0x0001,
	0x44b6: 0x0001, 0x44b7: 0x0001, 0x44b8: 0x0001, 0x44b9: 0x0001, 0x44ba: 0x0001, 0x44bb: 0x0001,
	0x44bc: 0x0001, 0x44bd: 0x0001, 0x44be: 0x0001, 0x44bf: 0x0001,
	// Block 0x113, offset 0x44c0
	0x44c0: 0x0001, 0x44c1: 0x0001, 0x44c2: 0x0001, 0x44c3: 0x0001, 0x44c4: 0x0001, 0x44c5: 0x0001,
	0x44c6: 0x0001, 0x44c7: 0x0001, 0x44c8: 0x0001, 0x44c9: 0x0001, 0x44ca: 0x0001, 0x44cb: 0x0001,
	0x44cc: 0x0001, 0x44cd: 0x0001, 0x44ce: 0x0001, 0x44cf: 0x0001, 0x44d0: 0x0001, 0x44d1: 0x0001,
	0x44d2: 0x0001, 0x44d3: 0x0001, 0x44d4: 0x0001, 0x44d5: 0x0001, 0x44d6: 0x0001, 0x44d7: 0x0001,
	0x44d8: 0x0001, 0x44d9: 0x0001, 0x44da: 0x0001, 0x44db: 0x0001, 0x44dc: 0x0001, 0x44dd: 0x0001,
	0x44de: 0x0001, 0x44df: 0x0001, 0x44e0: 0x0001, 0x44e1: 0x0001, 0x44e2: 0x0001, 0x44e3: 0x0001,
	0x44e4: 0x0001, 0x44e5: 0x0001, 0x44e6: 0x0001, 0x44e7: 0x0001, 0x44e8: 0x0001, 0x44e9: 0x0001,
	0x44ea: 0x0001, 0x44eb: 0x0001, 0x44ec: 0x0001, 0x44ed: 0x0001, 0x44ee: 0x0001, 0x44ef: 0x0001,
	0x44f0: 0x0001, 0x44f1: 0x0001, 0x44f2: 0x0001, 0x44f3: 0x0001, 0x44f4: 0x0001, 0x44f5: 0x0001,
	0x44f6: 0x0001, 0x44f7: 0x0001, 0x44f8: 0x0001, 0x44f9: 0x0001, 0x44fa: 0x0001, 0x44fb: 0x0001,
	0x44fc: 0x0001, 0x44fd: 0x0001, 0x44fe: 0x0001,
	// Block 0x114, offset 0x4500
	0x4500: 0x8000, 0x4501: 0x8000, 0x4502: 0x8000, 0x4503: 0x8000, 0x4504: 0x8000, 0x4505: 0x8000,
	0x4506: 0x8000, 0x4507: 0x8000, 0x4508: 0x8000, 0x4509: 0x8000,
	0x4510: 0x0001, 0x4511: 0x0001,
	0x4512: 0x0001, 0x4513: 0x0001, 0x4514: 0x0001, 0x4515: 0x0001, 0x4516: 0x0001, 0x4517: 0x0001,
	0x4518: 0x0001, 0x4519: 0x0001, 0x451a: 0x0001, 0x451b: 0x0001, 0x451c: 0x0001, 0x451d: 0x0001,
	0x451e: 0x0001, 0x451f: 0x0001, 0x4520: 0x0001, 0x4521: 0x0001, 0x4522: 0x0001, 0x4523: 0x0001,
	0x4524: 0x0001, 0x4525: 0x0001, 0x4526: 0x0001, 0x4527: 0x0001, 0x4528: 0x0001, 0x4529: 0x0001,
	0x452a: 0x0001, 0x452b: 0x0001, 0x452c: 0x0001, 0x452d: 0x0001,
	0x4530: 0x0010, 0x4531: 0x0010, 0x4532: 0x0010, 0x4533: 0x0010, 0x4534: 0x0010,
	// Block 0x115, offset 0x4540
	0x4540: 0x0001, 0x4541: 0x0001, 0x4542: 0x0001, 0x4543: 0x0001, 0x4544: 0x0001, 0x4545: 0x0001,
	0x4546: 0x0001, 0x4547: 0x0001, 0x4548: 0x0001, 0x4549: 0x0001, 0x454a: 0x0001, 0x454b: 0x0001,
	0x454c: 0x0001, 0x454d: 0x0001, 0x454e: 0x0001, 0x454f: 0x0001, 0x4550: 0x0001, 0x4551: 0x0001,
	0x4552: 0x0001, 0x4553: 0x0001, 0x4554: 0x0001, 0x4555: 0x0001, 0x4556: 0x0001, 0x4557: 0x0001,
	0x4558: 0x0001, 0x4559: 0x0001, 0x455a: 0x0001, 0x455b: 0x0001, 0x455c: 0x0001, 0x455d: 0x0001,
	0x455e: 0x0001, 0x455f: 0x0001, 0x4560: 0x0001, 0x4561: 0x0001, 0x4562: 0x0001, 0x4563: 0x0001,
	0x4564: 0x0001, 0x4565: 0x0001, 0x4566: 0x0001, 0x4567: 0x0001, 0x4568: 0x0001, 0x4569: 0x0001,
	0x456a: 0x0001, 0x456b: 0x0001, 0x456c: 0x0001, 0x456d: 0x0001, 0x456e: 0x0001, 0x456f: 0x0001,
	0x4570: 0x0010, 0x4571: 0x0010, 0x4572: 0x0010, 0x4573: 0x0010, 0x4574: 0x0010, 0x4575: 0x0010,
	0x4576: 0x0010,
	// Block 0x116, offset 0x4580
	0x4580: 0x0001, 0x4581: 0x0001, 0x4582: 0x0001, 0x4583: 0x0001,
	0x4590: 0x8000, 0x4591: 0x8000,
	0x4592: 0x8000, 0x4593: 0x8000, 0x4594: 0x8000, 0x4595: 0x8000, 0x4596: 0x8000, 0x4597: 0x8000,
	0x4598: 0x8000, 0x4599: 0x8000,
	0x45a3: 0x0001,
	0x45a4: 0x0001, 0x45a5: 0x0001, 0x45a6: 0x0001, 0x45a7: 0x0001, 0x45a8: 0x0001, 0x45a9: 0x0001,
	0x45aa: 0x0001, 0x45ab: 0x0001, 0x45ac: 0x0001, 0x45ad: 0x0001, 0x45ae: 0x0001, 0x45af: 0x0001,
	0x45b0: 0x0001, 0x45b1: 0x0001, 0x45b2: 0x0001, 0x45b3: 0x0001, 0x45b4: 0x0001, 0x45b5: 0x0001,
	0x45b6: 0x0001, 0x45b7: 0x0001,
	0x45bd: 0x0001, 0x45be: 0x0001, 0x45bf: 0x0001,
	// Block 0x117, offset 0x45c0
	0x45c0: 0x0001, 0x45c1: 0x0001, 0x45c2: 0x0001, 0x45c3: 0x0001, 0x45c4: 0x0001, 0x45c5: 0x0001,
	0x45c6: 0x0001, 0x45c7: 0x0001, 0x45c8: 0x0001, 0x45c9: 0x0001, 0x45ca: 0x0001, 0x45cb: 0x0001,
	0x45cc: 0x0001, 0x45cd: 0x0001, 0x45ce: 0x0001, 0x45cf: 0x0001,
	// Block 0x118, offset 0x4600
	0x4600: 0x0001, 0x4601: 0x0001, 0x4602: 0x0001, 0x4603: 0x0001, 0x4604: 0x0001, 0x4605: 0x0001,
	0x4606: 0x0001, 0x4607: 0x0001, 0x4608: 0x0001, 0x4609: 0x0001, 0x460a: 0x0001,
	0x460f: 0x0010, 0x4610: 0x0001, 0x4611: 0x0010,
	0x4612: 0x0010, 0x4613: 0x0010, 0x4614: 0x0010, 0x4615: 0x0010, 0x4616: 0x0010, 0x4617: 0x0010,
	0x4618: 0x0010, 0x4619: 0x0010, 0x461a: 0x0010, 0x461b: 0x0010, 0x461c: 0x0010, 0x461d: 0x0010,
	0x461e: 0x0010, 0x461f: 0x0010, 0x4620: 0x0010, 0x4621: 0x0010, 0x4622: 0x0010, 0x4623: 0x0010,
	0x4624: 0x0010, 0x4625: 0x0010, 0x4626: 0x0010, 0x4627: 0x0010, 0x4628: 0x0010, 0x4629: 0x0010,
	0x462a: 0x0010, 0x462b: 0x0010, 0x462c: 0x0010, 0x462d: 0x0010, 0x462e: 0x0010, 0x462f: 0x0010,
	0x4630: 0x0010, 0x4631: 0x0010, 0x4632: 0x0010, 0x4633: 0x0010, 0x4634: 0x0010, 0x4635: 0x0010,
	0x4636: 0x0010, 0x4637: 0x0010, 0x4638: 0x0010, 0x4639: 0x0010, 0x463a: 0x0010, 0x463b: 0x0010,
	0x463c: 0x0010, 0x463d: 0x0010, 0x463e: 0x0010, 0x463f: 0x0010,
	// Block 0x119, offset 0x4640
	0x4640: 0x0010, 0x4641: 0x0010, 0x4642: 0x0010, 0x4643: 0x0010, 0x4644: 0x0010, 0x4645: 0x0010,
	0x4646: 0x0010, 0x4647: 0x0010,
	0x464f: 0x0010, 0x4650: 0x0010, 0x4651: 0x0010,
	0x4652: 0x0010, 0x4653: 0x0001, 0x4654: 0x0001, 0x4655: 0x0001, 0x4656: 0x0001, 0x4657: 0x0001,
	0x4658: 0x0001, 0x4659: 0x0001, 0x465a: 0x0001, 0x465b: 0x0001, 0x465c: 0x0001, 0x465d: 0x0001,
	0x465e: 0x0001, 0x465f: 0x0001,
	// Block 0x11a, offset 0x4680
	0x46a0: 0x0001, 0x46a1: 0x0001, 0x46a2: 0x0002, 0x46a3: 0x0003,
	0x46a4: 0x0010,
	0x46b0: 0x0012, 0x46b1: 0x0012,
	// Block 0x11b, offset 0x46c0
	0x46f0: 0x0202, 0x46f1: 0x0202, 0x46f2: 0x0202, 0x46f3: 0x0202, 0x46f5: 0x0202,
	0x46f6: 0x0202, 0x46f7: 0x0202, 0x46f8: 0x0202, 0x46f9: 0x0202, 0x46fa: 0x0202, 0x46fb: 0x0202,
	0x46fd: 0x0202, 0x46fe: 0x0202,
	// Block 0x11c, offset 0x4700
	0x4700: 0x0202, 0x4701: 0x0002, 0x4702: 0x0002, 0x4703: 0x0002, 0x4704: 0x0002, 0x4705: 0x0002,
	0x4706: 0x0002, 0x4707: 0x0002, 0x4708: 0x0002, 0x4709: 0x0002, 0x470a: 0x0002, 0x470b: 0x0002,
	0x470c: 0x0002, 0x470d: 0x0002, 0x470e: 0x0002, 0x470f: 0x0002, 0x4710: 0x0002, 0x4711: 0x0002,
	0x4712: 0x0002, 0x4713: 0x0002, 0x4714: 0x0002, 0x4715: 0x0002, 0x4716: 0x0002, 0x4717: 0x0002,
	0x4718: 0x0002, 0x4719: 0x0002, 0x471a: 0x0002, 0x471b: 0x0002, 0x471c: 0x0002, 0x471d: 0x0002,
	0x471e: 0x0002, 0x471f: 0x0002, 0x4720: 0x0002, 0x4721: 0x0002, 0x4722: 0x0002, 0x4723: 0x0002,
	0x4724: 0x0002, 0x4725: 0x0002, 0x4726: 0x0002, 0x4727: 0x0002, 0x4728: 0x0002, 0x4729: 0x0002,
	0x472a: 0x0002, 0x472b: 0x0002, 0x472c: 0x0002, 0x472d: 0x0002, 0x472e: 0x0002, 0x472f: 0x0002,
	0x4730: 0x0002, 0x4731: 0x0002, 0x4732: 0x0002, 0x4733: 0x0002, 0x4734: 0x0002, 0x4735: 0x0002,
	0x4736: 0x0002, 0x4737: 0x0002, 0x4738: 0x0002, 0x4739: 0x0002, 0x473a: 0x0002, 0x473b: 0x0002,
	0x473c: 0x0002, 0x473d: 0x0002, 0x473e: 0x0002, 0x473f: 0x0002,
	// Block 0x11d, offset 0x4740
	0x4740: 0x0002, 0x4741: 0x0002, 0x4742: 0x0002, 0x4743: 0x0002, 0x4744: 0x0002, 0x4745: 0x0002,
	0x4746: 0x0002, 0x4747: 0x0002, 0x4748: 0x0002, 0x4749: 0x0002, 0x474a: 0x0002, 0x474b: 0x0002,
	0x474c: 0x0002, 0x474d: 0x0002, 0x474e: 0x0002, 0x474f: 0x0002, 0x4750: 0x0002, 0x4751: 0x0002,
	0x4752: 0x0002, 0x4753: 0x0002, 0x4754: 0x0002, 0x4755: 0x0002, 0x4756: 0x0002, 0x4757: 0x0002,
	0x4758: 0x0002, 0x4759: 0x0002, 0x475a: 0x0002, 0x475b: 0x0002, 0x475c: 0x0002, 0x475d: 0x0002,
	0x475e: 0x0002, 0x475f: 0x0002, 0x4760: 0x0202, 0x4761: 0x0202, 0x4762: 0x0202,
	0x4772: 0x0002,
	// Block 0x11e, offset 0x4780
	0x4790: 0x0002, 0x4791: 0x0002,
	0x4792: 0x0002, 0x4795: 0x0202,
	0x47a4: 0x0202, 0x47a5: 0x0202, 0x47a6: 0x0202, 0x47a7: 0x0202,
	// Block 0x11f, offset 0x47c0
	0x47c0: 0x0001, 0x47c1: 0x0001, 0x47c2: 0x0001, 0x47c3: 0x0001, 0x47c4: 0x0001, 0x47c5: 0x0001,
	0x47c6: 0x0001, 0x47c7: 0x0001, 0x47c8: 0x0001, 0x47c9: 0x0001, 0x47ca: 0x0001, 0x47cb: 0x0001,
	0x47cc: 0x0001, 0x47cd: 0x0001, 0x47ce: 0x0001, 0x47cf: 0x0001, 0x47d0: 0x0001, 0x47d1: 0x0001,
	0x47d2: 0x0001, 0x47d3: 0x0001, 0x47d4: 0x0001, 0x47d5: 0x0001, 0x47d6: 0x0001, 0x47d7: 0x0001,
	0x47d8: 0x0001, 0x47d9: 0x0001, 0x47da: 0x0001, 0x47db: 0x0001, 0x47dc: 0x0001, 0x47dd: 0x0001,
	0x47de: 0x0001, 0x47df: 0x0001, 0x47e0: 0x0001, 0x47e1: 0x0001, 0x47e2: 0x0001, 0x47e3: 0x0001,
	0x47e4: 0x0001, 0x47e5: 0x0001, 0x47e6: 0x0001, 0x47e7: 0x0001, 0x47e8: 0x0001, 0x47e9: 0x0001,
	0x47ea: 0x0001,
	0x47f0: 0x0001, 0x47f1: 0x0001, 0x47f2: 0x0001, 0x47f3: 0x0001, 0x47f4: 0x0001, 0x47f5: 0x0001,
	0x47f6: 0x0001, 0x47f7: 0x0001, 0x47f8: 0x0001, 0x47f9: 0x0001, 0x47fa: 0x0001, 0x47fb: 0x0001,
	0x47fc: 0x0001,
	// Block 0x120, offset 0x4800
	0x4800: 0x0001, 0x4801: 0x0001, 0x4802: 0x0001, 0x4803: 0x0001, 0x4804: 0x0001, 0x4805: 0x0001,
	0x4806: 0x0001, 0x4807: 0x0001, 0x4808: 0x0001,
	0x4810: 0x0001, 0x4811: 0x0001,
	0x4812: 0x0001, 0x4813: 0x0001, 0x4814: 0x0001, 0x4815: 0x0001, 0x4816: 0x0001, 0x4817: 0x0001,
	0x4818: 0x0001, 0x4819: 0x0001, 0x481d: 0x0010,
	0x481e: 0x0010, 0x4820: 0x0080, 0x4821: 0x0080, 0x4822: 0x0080, 0x4823: 0x0080,
	// Block 0x121, offset 0x4840
	0x4840: 0x0010, 0x4841: 0x0010, 0x4842: 0x0010, 0x4843: 0x0010, 0x4844: 0x0010, 0x4845: 0x0010,
	0x4846: 0x0010, 0x4847: 0x0010, 0x4848: 0x0010, 0x4849: 0x0010, 0x484a: 0x0010, 0x484b: 0x0010,
	0x484c: 0x0010, 0x484d: 0x0010, 0x484e: 0x0010, 0x484f: 0x0010, 0x4850: 0x0010, 0x4851: 0x0010,
	0x4852: 0x0010, 0x4853: 0x0010, 0x4854: 0x0010, 0x4855: 0x0010, 0x4856: 0x0010, 0x4857: 0x0010,
	0x4858: 0x0010, 0x4859: 0x0010, 0x485a: 0x0010, 0x485b: 0x0010, 0x485c: 0x0010, 0x485d: 0x0010,
	0x485e: 0x0010, 0x485f: 0x0010, 0x4860: 0x0010, 0x4861: 0x0010, 0x4862: 0x0010, 0x4863: 0x0010,
	0x4864: 0x0010, 0x4865: 0x0010, 0x4866: 0x0010, 0x4867: 0x0010, 0x4868: 0x0010, 0x4869: 0x0010,
	0x486a: 0x0010, 0x486b: 0x0010, 0x486c: 0x0010, 0x486d: 0x0010,
	0x4870: 0x0010, 0x4871: 0x0010, 0x4872: 0x0010, 0x4873: 0x0010, 0x4874: 0x0010, 0x4875: 0x0010,
	0x4876: 0x0010, 0x4877: 0x0010, 0x4878: 0x0010, 0x4879: 0x0010, 0x487a: 0x0010, 0x487b: 0x0010,
	0x487c: 0x0010, 0x487d: 0x0010, 0x487e: 0x0010, 0x487f: 0x0010,
	// Block 0x122, offset 0x4880
	0x4880: 0x0010, 0x4881: 0x0010, 0x4882: 0x0010, 0x4883: 0x0010, 0x4884: 0x0010, 0x4885: 0x0010,
	0x4886: 0x0010,
	// Block 0x123, offset 0x48c0
	0x48e5: 0x0010, 0x48e6: 0x0010, 0x48e7: 0x0010, 0x48e8: 0x0010, 0x48e9: 0x0010,
	0x48ed: 0x0010, 0x48ee: 0x0010, 0x48ef: 0x0010,
	0x48f0: 0x0010, 0x48f1: 0x0010, 0x48f2: 0x0010, 0x48f3: 0x0080, 0x48f4: 0x0080, 0x48f5: 0x0080,
	0x48f6: 0x0080, 0x48f7: 0x0080, 0x48f8: 0x0080, 0x48f9: 0x0080, 0x48fa: 0x0080, 0x48fb: 0x0010,
	0x48fc: 0x0010, 0x48fd: 0x0010, 0x48fe: 0x0010, 0x48ff: 0x0010,
	// Block 0x124, offset 0x4900
	0x4900: 0x0010, 0x4901: 0x0010, 0x4902: 0x0010, 0x4905: 0x0010,
	0x4906: 0x0010, 0x4907: 0x0010, 0x4908: 0x0010, 0x4909: 0x0010, 0x490a: 0x0010, 0x490b: 0x0010,
	0x492a: 0x0010, 0x492b: 0x0010, 0x492c: 0x0010, 0x492d: 0x0010,
	// Block 0x125, offset 0x4940
	0x4942: 0x0010, 0x4943: 0x0010, 0x4944: 0x0010,
	// Block 0x126, offset 0x4980
	0x4980: 0x0001, 0x4981: 0x0001, 0x4982: 0x0001, 0x4983: 0x0001, 0x4984: 0x0001, 0x4985: 0x0001,
	0x4986: 0x0001, 0x4987: 0x0001, 0x4988: 0x0001, 0x4989: 0x0001, 0x498a: 0x0001, 0x498b: 0x0001,
	0x498c: 0x0001, 0x498d: 0x0001, 0x498e: 0x0001, 0x498f: 0x0001, 0x4990: 0x0001, 0x4991: 0x0001,
	0x4992: 0x0001, 0x4993: 0x0001, 0x4994: 0x0001, 0x4996: 0x0001, 0x4997: 0x0001,
	0x4998: 0x0001, 0x4999: 0x0001, 0x499a: 0x0001, 0x499b: 0x0001, 0x499c: 0x0001, 0x499d: 0x0001,
	0x499e: 0x0001, 0x499f: 0x0001, 0x49a0: 0x0001, 0x49a1: 0x0001, 0x49a2: 0x0001, 0x49a3: 0x0001,
	0x49a4: 0x0001, 0x49a5: 0x0001, 0x49a6: 0x0001, 0x49a7: 0x0001, 0x49a8: 0x0001, 0x49a9: 0x0001,
	0x49aa: 0x0001, 0x49ab: 0x0001, 0x49ac: 0x0001, 0x49ad: 0x0001, 0x49ae: 0x0001, 0x49af: 0x0001,
	0x49b0: 0x0001, 0x49b1: 0x0001, 0x49b2: 0x0001, 0x49b3: 0x0001, 0x49b4: 0x0001, 0x49b5: 0x0001,
	0x49b6: 0x0001, 0x49b7: 0x0001, 0x49b8: 0x0001, 0x49b9: 0x0001, 0x49ba: 0x0001, 0x49bb: 0x0001,
	0x49bc: 0x0001, 0x49bd: 0x0001, 0x49be: 0x0001, 0x49bf: 0x0001,
	// Block 0x127, offset 0x49c0
	0x49c0: 0x0001, 0x49c1: 0x0001, 0x49c2: 0x0001, 0x49c3: 0x0001, 0x49c4: 0x0001, 0x49c5: 0x0001,
	0x49c6: 0x0001, 0x49c7: 0x0001, 0x49c8: 0x0001, 0x49c9: 0x0001, 0x49ca: 0x0001, 0x49cb: 0x0001,
	0x49cc: 0x0001, 0x49cd: 0x0001, 0x49ce: 0x0001, 0x49cf: 0x0001, 0x49d0: 0x0001, 0x49d1: 0x0001,
	0x49d2: 0x0001, 0x49d3: 0x0001, 0x49d4: 0x0001, 0x49d5: 0x0001, 0x49d6: 0x0001, 0x49d7: 0x0001,
	0x49d8: 0x0001, 0x49d9: 0x0001, 0x49da: 0x0001, 0x49db: 0x0001, 0x49dc: 0x0001,
	0x49de: 0x0001, 0x49df: 0x0001, 0x49e2: 0x0001,
	0x49e5: 0x0001, 0x49e6: 0x0001, 0x49e9: 0x0001,
	0x49ea: 0x0001, 0x49eb: 0x0001, 0x49ec: 0x0001, 0x49ee: 0x0001, 0x49ef: 0x0001,
	0x49f0: 0x0001, 0x49f1: 0x0001, 0x49f2: 0x0001, 0x49f3: 0x0001, 0x49f4: 0x0001, 0x49f5: 0x0001,
	0x49f6: 0x0001, 0x49f7: 0x0001, 0x49f8: 0x0001, 0x49f9: 0x0001, 0x49fb: 0x0001,
	0x49fd: 0x0001, 0x49fe: 0x0001, 0x49ff: 0x0001,
	// Block 0x128, offset 0x4a00
	0x4a00: 0x0001, 0x4a01: 0x0001, 0x4a02: 0x0001, 0x4a03: 0x0001, 0x4a05: 0x0001,
	0x4a06: 0x0001, 0x4a07: 0x0001, 0x4a08: 0x0001, 0x4a09: 0x0001, 0x4a0a: 0x0001, 0x4a0b: 0x0001,
	0x4a0c: 0x0001, 0x4a0d: 0x0001, 0x4a0e: 0x0001, 0x4a0f: 0x0001, 0x4a10: 0x0001, 0x4a11: 0x0001,
	0x4a12: 0x0001, 0x4a13: 0x0001, 0x4a14: 0x0001, 0x4a15: 0x0001, 0x4a16: 0x0001, 0x4a17: 0x0001,
	0x4a18: 0x0001, 0x4a19: 0x0001, 0x4a1a: 0x0001, 0x4a1b: 0x0001, 0x4a1c: 0x0001, 0x4a1d: 0x0001,
	0x4a1e: 0x0001, 0x4a1f: 0x0001, 0x4a20: 0x0001, 0x4a21: 0x0001, 0x4a22: 0x0001, 0x4a23: 0x0001,
	0x4a24: 0x0001, 0x4a25: 0x0001, 0x4a26: 0x0001, 0x4a27: 0x0001, 0x4a28: 0x0001, 0x4a29: 0x0001,
	0x4a2a: 0x0001, 0x4a2b: 0x0001, 0x4a2c: 0x0001, 0x4a2d: 0x0001, 0x4a2e: 0x0001, 0x4a2f: 0x0001,
	0x4a30: 0x0001, 0x4a31: 0x0001, 0x4a32: 0x0001, 0x4a33: 0x0001, 0x4a34: 0x0001, 0x4a35: 0x0001,
	0x4a36: 0x0001, 0x4a37: 0x0001, 0x4a38: 0x0001, 0x4a39: 0x0001, 0x4a3a: 0x0001, 0x4a3b: 0x0001,
	0x4a3c: 0x0001, 0x4a3d: 0x0001, 0x4a3e: 0x0001, 0x4a3f: 0x0001,
	// Block 0x129, offset 0x4a40
	0x4a40: 0x0001, 0x4a41: 0x0001, 0x4a42: 0x0001, 0x4a43: 0x0001, 0x4a44: 0x0001, 0x4a45: 0x0001,
	0x4a47: 0x0001, 0x4a48: 0x0001, 0x4a49: 0x0001, 0x4a4a: 0x0001,
	0x4a4d: 0x0001, 0x4a4e: 0x0001, 0x4a4f: 0x0001, 0x4a50: 0x0001, 0x4a51: 0x0001,
	0x4a52: 0x0001, 0x4a53: 0x0001, 0x4a54: 0x0001, 0x4a56: 0x0001, 0x4a57: 0x0001,
	0x4a58: 0x0001, 0x4a59: 0x0001, 0x4a5a: 0x0001, 0x4a5b: 0x0001, 0x4a5c: 0x0001,
	0x4a5e: 0x0001, 0x4a5f: 0x0001, 0x4a60: 0x0001, 0x4a61: 0x0001, 0x4a62: 0x0001, 0x4a63: 0x0001,
	0x4a64: 0x0001, 0x4a65: 0x0001, 0x4a66: 0x0001, 0x4a67: 0x0001, 0x4a68: 0x0001, 0x4a69: 0x0001,
	0x4a6a: 0x0001, 0x4a6b: 0x0001, 0x4a6c: 0x0001, 0x4a6d: 0x0001, 0x4a6e: 0x0001, 0x4a6f: 0x0001,
	0x4a70: 0x0001, 0x4a71: 0x0001, 0x4a72: 0x0001, 0x4a73: 0x0001, 0x4a74: 0x0001, 0x4a75: 0x0001,
	0x4a76: 0x0001, 0x4a77: 0x0001, 0x4a78: 0x0001, 0x4a79: 0x0001, 0x4a7b: 0x0001,
	0x4a7c: 0x0001, 0x4a7d: 0x0001, 0x4a7e: 0x0001,
	// Block 0x12a, offset 0x4a80
	0x4a80: 0x0001, 0x4a81: 0x0001, 0x4a82: 0x0001, 0x4a83: 0x0001, 0x4a84: 0x0001,
	0x4a86: 0x0001, 0x4a8a: 0x0001, 0x4a8b: 0x0001,
	0x4a8c: 0x0001, 0x4a8d: 0x0001, 0x4a8e: 0x0001, 0x4a8f: 0x0001, 0x4a90: 0x0001,
	0x4a92: 0x0001, 0x4a93: 0x0001, 0x4a94: 0x0001, 0x4a95: 0x0001, 0x4a96: 0x0001, 0x4a97: 0x0001,
	0x4a98: 0x0001, 0x4a99: 0x0001, 0x4a9a: 0x0001, 0x4a9b: 0x0001, 0x4a9c: 0x0001, 0x4a9d: 0x0001,
	0x4a9e: 0x0001, 0x4a9f: 0x0001, 0x4aa0: 0x0001, 0x4aa1: 0x0001, 0x4aa2: 0x0001, 0x4aa3: 0x0001,
	0x4aa4: 0x0001, 0x4aa5: 0x0001, 0x4aa6: 0x0001, 0x4aa7: 0x0001, 0x4aa8: 0x0001, 0x4aa9: 0x0001,
	0x4aaa: 0x0001, 0x4aab: 0x0001, 0x4aac: 0x0001, 0x4aad: 0x0001, 0x4aae: 0x0001, 0x4aaf: 0x0001,
	0x4ab0: 0x0001, 0x4ab1: 0x0001, 0x4ab2: 0x0001, 0x4ab3: 0x0001, 0x4ab4: 0x0001, 0x4ab5: 0x0001,
	0x4ab6: 0x0001, 0x4ab7: 0x0001, 0x4ab8: 0x0001, 0x4ab9: 0x0001, 0x4aba: 0x0001, 0x4abb: 0x0001,
	0x4abc: 0x0001, 0x4abd: 0x0001, 0x4abe: 0x0001, 0x4abf: 0x0001,
	// Block 0x12b, offset 0x4ac0
	0x4ac0: 0x0001, 0x4ac1: 0x0001, 0x4ac2: 0x0001, 0x4ac3: 0x0001, 0x4ac4: 0x0001, 0x4ac5: 0x0001,
	0x4ac6: 0x0001, 0x4ac7: 0x0001, 0x4ac8: 0x0001, 0x4ac9: 0x0001, 0x4aca: 0x0001, 0x4acb: 0x0001,
	0x4acc: 0x0001, 0x4acd: 0x0001, 0x4ace: 0x0001, 0x4acf: 0x0001, 0x4ad0: 0x0001, 0x4ad1: 0x0001,
	0x4ad2: 0x0001, 0x4ad3: 0x0001, 0x4ad4: 0x0001, 0x4ad5: 0x0001, 0x4ad6: 0x0001, 0x4ad7: 0x0001,
	0x4ad8: 0x0001, 0x4ad9: 0x0001, 0x4ada: 0x0001, 0x4adb: 0x0001, 0x4adc: 0x0001, 0x4add: 0x0001,
	0x4ade: 0x0001, 0x4adf: 0x0001, 0x4ae0: 0x0001, 0x4ae1: 0x0001, 0x4ae2: 0x0001, 0x4ae3: 0x0001,
	0x4ae4: 0x0001, 0x4ae5: 0x0001, 0x4ae8: 0x0001, 0x4ae9: 0x0001,
	0x4aea: 0x0001, 0x4aeb: 0x0001, 0x4aec: 0x0001, 0x4aed: 0x0001, 0x4aee: 0x0001, 0x4aef: 0x0001,
	0x4af0: 0x0001, 0x4af1: 0x0001, 0x4af2: 0x0001, 0x4af3: 0x0001, 0x4af4: 0x0001, 0x4af5: 0x0001,
	0x4af6: 0x0001, 0x4af7: 0x0001, 0x4af8: 0x0001, 0x4af9: 0x0001, 0x4afa: 0x0001, 0x4afb: 0x0001,
	0x4afc: 0x0001, 0x4afd: 0x0001, 0x4afe: 0x0001, 0x4aff: 0x0001,
	// Block 0x12c, offset 0x4b00
	0x4b00: 0x0001, 0x4b02: 0x0001, 0x4b03: 0x0001, 0x4b04: 0x0001, 0x4b05: 0x0001,
	0x4b06: 0x0001, 0x4b07: 0x0001, 0x4b08: 0x0001, 0x4b09: 0x0001, 0x4b0a: 0x0001, 0x4b0b: 0x0001,
	0x4b0c: 0x0001, 0x4b0d: 0x0001, 0x4b0e: 0x0001, 0x4b0f: 0x0001, 0x4b10: 0x0001, 0x4b11: 0x0001,
	0x4b12: 0x0001, 0x4b13: 0x0001, 0x4b14: 0x0001, 0x4b15: 0x0001, 0x4b16: 0x0001, 0x4b17: 0x0001,
	0x4b18: 0x0001, 0x4b19: 0x0001, 0x4b1a: 0x0001, 0x4b1c: 0x0001, 0x4b1d: 0x0001,
	0x4b1e: 0x0001, 0x4b1f: 0x0001, 0x4b20: 0x0001, 0x4b21: 0x0001, 0x4b22: 0x0001, 0x4b23: 0x0001,
	0x4b24: 0x0001, 0x4b25: 0x0001, 0x4b26: 0x0001, 0x4b27: 0x0001, 0x4b28: 0x0001, 0x4b29: 0x0001,
	0x4b2a: 0x0001, 0x4b2b: 0x0001, 0x4b2c: 0x0001, 0x4b2d: 0x0001, 0x4b2e: 0x0001, 0x4b2f: 0x0001,
	0x4b30: 0x0001, 0x4b31: 0x0001, 0x4b32: 0x0001, 0x4b33: 0x0001, 0x4b34: 0x0001, 0x4b35: 0x0001,
	0x4b36: 0x0001, 0x4b37: 0x0001, 0x4b38: 0x0001, 0x4b39: 0x0001, 0x4b3a: 0x0001,
	0x4b3c: 0x0001, 0x4b3d: 0x0001, 0x4b3e: 0x0001, 0x4b3f: 0x0001,
	// Block 0x12d, offset 0x4b40
	0x4b40: 0x0001, 0x4b41: 0x0001, 0x4b42: 0x0001, 0x4b43: 0x0001, 0x4b44: 0x0001, 0x4b45: 0x0001,
	0x4b46: 0x0001, 0x4b47: 0x0001, 0x4b48: 0x0001, 0x4b49: 0x0001, 0x4b4a: 0x0001, 0x4b4b: 0x0001,
	0x4b4c: 0x0001, 0x4b4d: 0x0001, 0x4b4e: 0x0001, 0x4b4f: 0x0001, 0x4b50: 0x0001, 0x4b51: 0x0001,
	0x4b52: 0x0001, 0x4b53: 0x0001, 0x4b54: 0x0001, 0x4b56: 0x0001, 0x4b57: 0x0001,
	0x4b58: 0x0001, 0x4b59: 0x0001, 0x4b5a: 0x0001, 0x4b5b: 0x0001, 0x4b5c: 0x0001, 0x4b5d: 0x0001,
	0x4b5e: 0x0001, 0x4b5f: 0x0001, 0x4b60: 0x0001, 0x4b61: 0x0001, 0x4b62: 0x0001, 0x4b63: 0x0001,
	0x4b64: 0x0001, 0x4b65: 0x0001, 0x4b66: 0x0001, 0x4b67: 0x0001, 0x4b68: 0x0001, 0x4b69: 0x0001,
	0x4b6a: 0x0001, 0x4b6b: 0x0001, 0x4b6c: 0x0001, 0x4b6d: 0x0001, 0x4b6e: 0x0001, 0x4b6f: 0x0001,
	0x4b70: 0x0001, 0x4b71: 0x0001, 0x4b72: 0x0001, 0x4b73: 0x0001, 0x4b74: 0x0001,
	0x4b76: 0x0001, 0x4b77: 0x0001, 0x4b78: 0x0001, 0x4b79: 0x0001, 0x4b7a: 0x0001, 0x4b7b: 0x0001,
	0x4b7c: 0x0001, 0x4b7d: 0x0001, 0x4b7e: 0x0001, 0x4b7f: 0x0001,
	// Block 0x12e, offset 0x4b80
	0x4b80: 0x0001, 0x4b81: 0x0001, 0x4b82: 0x0001, 0x4b83: 0x0001, 0x4b84: 0x0001, 0x4b85: 0x0001,
	0x4b86: 0x0001, 0x4b87: 0x0001, 0x4b88: 0x0001, 0x4b89: 0x0001, 0x4b8a: 0x0001, 0x4b8b: 0x0001,
	0x4b8c: 0x0001, 0x4b8d: 0x0001, 0x4b8e: 0x0001, 0x4b90: 0x0001, 0x4b91: 0x0001,
	0x4b92: 0x0001, 0x4b93: 0x0001, 0x4b94: 0x0001, 0x4b95: 0x0001, 0x4b96: 0x0001, 0x4b97: 0x0001,
	0x4b98: 0x0001, 0x4b99: 0x0001, 0x4b9a: 0x0001, 0x4b9b: 0x0001, 0x4b9c: 0x0001, 0x4b9d: 0x0001,
	0x4b9e: 0x0001, 0x4b9f: 0x0001, 0x4ba0: 0x0001, 0x4ba1: 0x0001, 0x4ba2: 0x0001, 0x4ba3: 0x0001,
	0x4ba4: 0x0001, 0x4ba5: 0x0001, 0x4ba6: 0x0001, 0x4ba7: 0x0001, 0x4ba8: 0x0001, 0x4ba9: 0x0001,
	0x4baa: 0x0001, 0x4bab: 0x0001, 0x4bac: 0x0001, 0x4bad: 0x0001, 0x4bae: 0x0001,
	0x4bb0: 0x0001, 0x4bb1: 0x0001, 0x4bb2: 0x0001, 0x4bb3: 0x0001, 0x4bb4: 0x0001, 0x4bb5: 0x0001,
	0x4bb6: 0x0001, 0x4bb7: 0x0001, 0x4bb8: 0x0001, 0x4bb9: 0x0001, 0x4bba: 0x0001, 0x4bbb: 0x0001,
	0x4bbc: 0x0001, 0x4bbd: 0x0001, 0x4bbe: 0x0001, 0x4bbf: 0x0001,
	// Block 0x12f, offset 0x4bc0
	0x4bc0: 0x0001, 0x4bc1: 0x0001, 0x4bc2: 0x0001, 0x4bc3: 0x0001, 0x4bc4: 0x0001, 0x4bc5: 0x0001,
	0x4bc6: 0x0001, 0x4bc7: 0x0001, 0x4bc8: 0x0001, 0x4bca: 0x0001, 0x4bcb: 0x0001,
	0x4bcc: 0x0001, 0x4bcd: 0x0001, 0x4bce: 0x0001, 0x4bcf: 0x0001, 0x4bd0: 0x0001, 0x4bd1: 0x0001,
	0x4bd2: 0x0001, 0x4bd3: 0x0001, 0x4bd4: 0x0001, 0x4bd5: 0x0001, 0x4bd6: 0x0001, 0x4bd7: 0x0001,
	0x4bd8: 0x0001, 0x4bd9: 0x0001, 0x4bda: 0x0001, 0x4bdb: 0x0001, 0x4bdc: 0x0001, 0x4bdd: 0x0001,
	0x4bde: 0x0001, 0x4bdf: 0x0001, 0x4be0: 0x0001, 0x4be1: 0x0001, 0x4be2: 0x0001, 0x4be3: 0x0001,
	0x4be4: 0x0001, 0x4be5: 0x0001, 0x4be6: 0x0001, 0x4be7: 0x0001, 0x4be8: 0x0001,
	0x4bea: 0x0001, 0x4beb: 0x0001, 0x4bec: 0x0001, 0x4bed: 0x0001, 0x4bee: 0x0001, 0x4bef: 0x0001,
	0x4bf0: 0x0001, 0x4bf1: 0x0001, 0x4bf2: 0x0001, 0x4bf3: 0x0001, 0x4bf4: 0x0001, 0x4bf5: 0x0001,
	0x4bf6: 0x0001, 0x4bf7: 0x0001, 0x4bf8: 0x0001, 0x4bf9: 0x0001, 0x4bfa: 0x0001, 0x4bfb: 0x0001,
	0x4bfc: 0x0001, 0x4bfd: 0x0001, 0x4bfe: 0x0001, 0x4bff: 0x0001,
	// Block 0x130, offset 0x4c00
	0x4c00: 0x0001, 0x4c01: 0x0001, 0x4c02: 0x0001, 0x4c04: 0x0001, 0x4c05: 0x0001,
	0x4c06: 0x0001, 0x4c07: 0x0001, 0x4c08: 0x0001, 0x4c09: 0x0001, 0x4c0a: 0x0001, 0x4c0b: 0x0001,
	0x4c0e: 0x8000, 0x4c0f: 0x8000, 0x4c10: 0x8000, 0x4c11: 0x8000,
	0x4c12: 0x8000, 0x4c13: 0x8000, 0x4c14: 0x8000, 0x4c15: 0x8000, 0x4c16: 0x8000, 0x4c17: 0x8000,
	0x4c18: 0x8000, 0x4c19: 0x8000, 0x4c1a: 0x8000, 0x4c1b: 0x8000, 0x4c1c: 0x8000, 0x4c1d: 0x8000,
	0x4c1e: 0x8000, 0x4c1f: 0x8000, 0x4c20: 0x8000, 0x4c21: 0x8000, 0x4c22: 0x8000, 0x4c23: 0x8000,
	0x4c24: 0x8000, 0x4c25: 0x8000, 0x4c26: 0x8000, 0x4c27: 0x8000, 0x4c28: 0x8000, 0x4c29: 0x8000,
	0x4c2a: 0x8000, 0x4c2b: 0x8000, 0x4c2c: 0x8000, 0x4c2d: 0x8000, 0x4c2e: 0x8000, 0x4c2f: 0x8000,
	0x4c30: 0x8000, 0x4c31: 0x8000, 0x4c32: 0x8000, 0x4c33: 0x8000, 0x4c34: 0x8000, 0x4c35: 0x8000,
	0x4c36: 0x8000, 0x4c37: 0x8000, 0x4c38: 0x8000, 0x4c39: 0x8000, 0x4c3a: 0x8000, 0x4c3b: 0x8000,
	0x4c3c: 0x8000, 0x4c3d: 0x8000, 0x4c3e: 0x8000, 0x4c3f: 0x8000,
	// Block 0x131, offset 0x4c40
	0x4c40: 0x0010, 0x4c41: 0x0010, 0x4c42: 0x0010, 0x4c43: 0x0010, 0x4c44: 0x0010, 0x4c45: 0x0010,
	0x4c46: 0x0010, 0x4c47: 0x0010, 0x4c48: 0x0010, 0x4c49: 0x0010, 0x4c4a: 0x0010, 0x4c4b: 0x0010,
	0x4c4c: 0x0010, 0x4c4d: 0x0010, 0x4c4e: 0x0010, 0x4c4f: 0x0010, 0x4c50: 0x0010, 0x4c51: 0x0010,
	0x4c52: 0x0010, 0x4c53: 0x0010, 0x4c54: 0x0010, 0x4c55: 0x0010, 0x4c56: 0x0010, 0x4c57: 0x0010,
	0x4c58: 0x0010, 0x4c59: 0x0010, 0x4c5a: 0x0010, 0x4c5b: 0x0010, 0x4c5c: 0x0010, 0x4c5d: 0x0010,
	0x4c5e: 0x0010, 0x4c5f: 0x0010, 0x4c60: 0x0010, 0x4c61: 0x0010, 0x4c62: 0x0010, 0x4c63: 0x0010,
	0x4c64: 0x0010, 0x4c65: 0x0010, 0x4c66: 0x0010, 0x4c67: 0x0010, 0x4c68: 0x0010, 0x4c69: 0x0010,
	0x4c6a: 0x0010, 0x4c6b: 0x0010, 0x4c6c: 0x0010, 0x4c6d: 0x0010, 0x4c6e: 0x0010, 0x4c6f: 0x0010,
	0x4c70: 0x0010, 0x4c71: 0x0010, 0x4c72: 0x0010, 0x4c73: 0x0010, 0x4c74: 0x0010, 0x4c75: 0x0010,
	0x4c76: 0x0010, 0x4c7b: 0x0010,
	0x4c7c: 0x0010, 0x4c7d: 0x0010, 0x4c7e: 0x0010, 0x4c7f: 0x0010,
	// Block 0x132, offset 0x4c80
	0x4c80: 0x0010, 0x4c81: 0x0010, 0x4c82: 0x0010, 0x4c83: 0x0010, 0x4c84: 0x0010, 0x4c85: 0x0010,
	0x4c86: 0x0010, 0x4c87: 0x0010, 0x4c88: 0x0010, 0x4c89: 0x0010, 0x4c8a: 0x0010, 0x4c8b: 0x0010,
	0x4c8c: 0x0010, 0x4c8d: 0x0010, 0x4c8e: 0x0010, 0x4c8f: 0x0010, 0x4c90: 0x0010, 0x4c91: 0x0010,
	0x4c92: 0x0010, 0x4c93: 0x0010, 0x4c94: 0x0010, 0x4c95: 0x0010, 0x4c96: 0x0010, 0x4c97: 0x0010,
	0x4c98: 0x0010, 0x4c99: 0x0010, 0x4c9a: 0x0010, 0x4c9b: 0x0010, 0x4c9c: 0x0010, 0x4c9d: 0x0010,
	0x4c9e: 0x0010, 0x4c9f: 0x0010, 0x4ca0: 0x0010, 0x4ca1: 0x0010, 0x4ca2: 0x0010, 0x4ca3: 0x0010,
	0x4ca4: 0x0010, 0x4ca5: 0x0010, 0x4ca6: 0x0010, 0x4ca7: 0x0010, 0x4ca8: 0x0010, 0x4ca9: 0x0010,
	0x4caa: 0x0010, 0x4cab: 0x0010, 0x4cac: 0x0010,
	0x4cb5: 0x0010,
	// Block 0x133, offset 0x4cc0
	0x4cc4: 0x0010,
	0x4cdb: 0x0010, 0x4cdc: 0x0010, 0x4cdd: 0x0010,
	0x4cde: 0x0010, 0x4cdf: 0x0010, 0x4ce1: 0x0010, 0x4ce2: 0x0010, 0x4ce3: 0x0010,
	0x4ce4: 0x0010, 0x4ce5: 0x0010, 0x4ce6: 0x0010, 0x4ce7: 0x0010, 0x4ce8: 0x0010, 0x4ce9: 0x0010,
	0x4cea: 0x0010, 0x4ceb: 0x0010, 0x4cec: 0x0010, 0x4ced: 0x0010, 0x4cee: 0x0010, 0x4cef: 0x0010,
	// Block 0x134, offset 0x4d00
	0x4d00: 0x0001, 0x4d01: 0x0001, 0x4d02: 0x0001, 0x4d03: 0x0001, 0x4d04: 0x0001, 0x4d05: 0x0001,
	0x4d06: 0x0001, 0x4d07: 0x0001, 0x4d08: 0x0001, 0x4d09: 0x0001, 0x4d0a: 0x0001, 0x4d0b: 0x0001,
	0x4d0c: 0x0001, 0x4d0d: 0x0001, 0x4d0e: 0x0001, 0x4d0f: 0x0001, 0x4d10: 0x0001, 0x4d11: 0x0001,
	0x4d12: 0x0001, 0x4d13: 0x0001, 0x4d14: 0x0001, 0x4d15: 0x0001, 0x4d16: 0x0001, 0x4d17: 0x0001,
	0x4d18: 0x0001, 0x4d19: 0x0001, 0x4d1a: 0x0001, 0x4d1b: 0x0001, 0x4d1c: 0x0001, 0x4d1d: 0x0001,
	0x4d1e: 0x0001,
	0x4d25: 0x0001, 0x4d26: 0x0001, 0x4d27: 0x0001, 0x4d28: 0x0001, 0x4d29: 0x0001,
	0x4d2a: 0x0001,
	// Block 0x135, offset 0x4d40
	0x4d40: 0x0010, 0x4d41: 0x0010, 0x4d42: 0x0010, 0x4d43: 0x0010, 0x4d44: 0x0010, 0x4d45: 0x0010,
	0x4d46: 0x0010, 0x4d48: 0x0010, 0x4d49: 0x0010, 0x4d4a: 0x0010, 0x4d4b: 0x0010,
	0x4d4c: 0x0010, 0x4d4d: 0x0010, 0x4d4e: 0x0010, 0x4d4f: 0x0010, 0x4d50: 0x0010, 0x4d51: 0x0010,
	0x4d52: 0x0010, 0x4d53: 0x0010, 0x4d54: 0x0010, 0x4d55: 0x0010, 0x4d56: 0x0010, 0x4d57: 0x0010,
	0x4d58: 0x0010, 0x4d5b: 0x0010, 0x4d5c: 0x0010, 0x4d5d: 0x0010,
	0x4d5e: 0x0010, 0x4d5f: 0x0010, 0x4d60: 0x0010, 0x4d61: 0x0010, 0x4d63: 0x0010,
	0x4d64: 0x0010, 0x4d66: 0x0010, 0x4d67: 0x0010, 0x4d68: 0x0010, 0x4d69: 0x0010,
	0x4d6a: 0x0010,
	0x4d70: 0x0001, 0x4d71: 0x0001, 0x4d72: 0x0001, 0x4d73: 0x0001, 0x4d74: 0x0001, 0x4d75: 0x0001,
	0x4d76: 0x0001, 0x4d77: 0x0001, 0x4d78: 0x0001, 0x4d79: 0x0001, 0x4d7a: 0x0001, 0x4d7b: 0x0001,
	0x4d7c: 0x0001, 0x4d7d: 0x0001, 0x4d7e: 0x0001, 0x4d7f: 0x0001,
	// Block 0x136, offset 0x4d80
	0x4d80: 0x0001, 0x4d81: 0x0001, 0x4d82: 0x0001, 0x4d83: 0x0001, 0x4d84: 0x0001, 0x4d85: 0x0001,
	0x4d86: 0x0001, 0x4d87: 0x0001, 0x4d88: 0x0001, 0x4d89: 0x0001, 0x4d8a: 0x0001, 0x4d8b: 0x0001,
	0x4d8c: 0x0001, 0x4d8d: 0x0001, 0x4d8e: 0x0001, 0x4d8f: 0x0001, 0x4d90: 0x0001, 0x4d91: 0x0001,
	0x4d92: 0x0001, 0x4d93: 0x0001, 0x4d94: 0x0001, 0x4d95: 0x0001, 0x4d96: 0x0001, 0x4d97: 0x0001,
	0x4d98: 0x0001, 0x4d99: 0x0001, 0x4d9a: 0x0001, 0x4d9b: 0x0001, 0x4d9c: 0x0001, 0x4d9d: 0x0001,
	0x4d9e: 0x0001, 0x4d9f: 0x0001, 0x4da0: 0x0001, 0x4da1: 0x0001, 0x4da2: 0x0001, 0x4da3: 0x0001,
	0x4da4: 0x0001, 0x4da5: 0x0001, 0x4da6: 0x0001, 0x4da7: 0x0001, 0x4da8: 0x0001, 0x4da9: 0x0001,
	0x4daa: 0x0001, 0x4dab: 0x0001, 0x4dac: 0x0001, 0x4dad: 0x0001,
	// Block 0x137, offset 0x4dc0
	0x4dcf: 0x0010,
	// Block 0x138, offset 0x4e00
	0x4e00: 0x0001, 0x4e01: 0x0001, 0x4e02: 0x0001, 0x4e03: 0x0001, 0x4e04: 0x0001, 0x4e05: 0x0001,
	0x4e06: 0x0001, 0x4e07: 0x0001, 0x4e08: 0x0001, 0x4e09: 0x0001, 0x4e0a: 0x0001, 0x4e0b: 0x0001,
	0x4e0c: 0x0001, 0x4e0d: 0x0001, 0x4e0e: 0x0001, 0x4e0f: 0x0001, 0x4e10: 0x0001, 0x4e11: 0x0001,
	0x4e12: 0x0001, 0x4e13: 0x0001, 0x4e14: 0x0001, 0x4e15: 0x0001, 0x4e16: 0x0001, 0x4e17: 0x0001,
	0x4e18: 0x0001, 0x4e19: 0x0001, 0x4e1a: 0x0001, 0x4e1b: 0x0001, 0x4e1c: 0x0001, 0x4e1d: 0x0001,
	0x4e1e: 0x0001, 0x4e1f: 0x0001, 0x4e20: 0x0001, 0x4e21: 0x0001, 0x4e22: 0x0001, 0x4e23: 0x0001,
	0x4e24: 0x0001, 0x4e25: 0x0001, 0x4e26: 0x0001, 0x4e27: 0x0001, 0x4e28: 0x0001, 0x4e29: 0x0001,
	0x4e2a: 0x0001, 0x4e2b: 0x0001, 0x4e2c: 0x0001,
	0x4e30: 0x0010, 0x4e31: 0x0010, 0x4e32: 0x0010, 0x4e33: 0x0010, 0x4e34: 0x0010, 0x4e35: 0x0010,
	0x4e36: 0x0010, 0x4e37: 0x0001, 0x4e38: 0x0001, 0x4e39: 0x0001, 0x4e3a: 0x0001, 0x4e3b: 0x0001,
	0x4e3c: 0x0001, 0x4e3d: 0x0001,
	// Block 0x139, offset 0x4e40
	0x4e40: 0x8000, 0x4e41: 0x8000, 0x4e42: 0x8000, 0x4e43: 0x8000, 0x4e44: 0x8000, 0x4e45: 0x8000,
	0x4e46: 0x8000, 0x4e47: 0x8000, 0x4e48: 0x8000, 0x4e49: 0x8000,
	0x4e4e: 0x0001,
	// Block 0x13a, offset 0x4e80
	0x4e90: 0x0001, 0x4e91: 0x0001,
	0x4e92: 0x0001, 0x4e93: 0x0001, 0x4e94: 0x0001, 0x4e95: 0x0001, 0x4e96: 0x0001, 0x4e97: 0x0001,
	0x4e98: 0x0001, 0x4e99: 0x0001, 0x4e9a: 0x0001, 0x4e9b: 0x0001, 0x4e9c: 0x0001, 0x4e9d: 0x0001,
	0x4e9e: 0x0001, 0x4e9f: 0x0001, 0x4ea0: 0x0001, 0x4ea1: 0x0001, 0x4ea2: 0x0001, 0x4ea3: 0x0001,
	0x4ea4: 0x0001, 0x4ea5: 0x0001, 0x4ea6: 0x0001, 0x4ea7: 0x0001, 0x4ea8: 0x0001, 0x4ea9: 0x0001,
	0x4eaa: 0x0001, 0x4eab: 0x0001, 0x4eac: 0x0001, 0x4ead: 0x0001, 0x4eae: 0x0010,
	// Block 0x13b, offset 0x4ec0
	0x4ec0: 0x0001, 0x4ec1: 0x0001, 0x4ec2: 0x0001, 0x4ec3: 0x0001, 0x4ec4: 0x0001, 0x4ec5: 0x0001,
	0x4ec6: 0x0001, 0x4ec7: 0x0001, 0x4ec8: 0x0001, 0x4ec9: 0x0001, 0x4eca: 0x0001, 0x4ecb: 0x0001,
	0x4ecc: 0x0001, 0x4ecd: 0x0001, 0x4ece: 0x0001, 0x4ecf: 0x0001, 0x4ed0: 0x0001, 0x4ed1: 0x0001,
	0x4ed2: 0x0001, 0x4ed3: 0x0001, 0x4ed4: 0x0001, 0x4ed5: 0x0001, 0x4ed6: 0x0001, 0x4ed7: 0x0001,
	0x4ed8: 0x0001, 0x4ed9: 0x0001, 0x4eda: 0x0001, 0x4edb: 0x0001, 0x4edc: 0x0001, 0x4edd: 0x0001,
	0x4ede: 0x0001, 0x4edf: 0x0001, 0x4ee0: 0x0001, 0x4ee1: 0x0001, 0x4ee2: 0x0001, 0x4ee3: 0x0001,
	0x4ee4: 0x0001, 0x4ee5: 0x0001, 0x4ee6: 0x0001, 0x4ee7: 0x0001, 0x4ee8: 0x0001, 0x4ee9: 0x0001,
	0x4eea: 0x0001, 0x4eeb: 0x0001, 0x4eec: 0x0010, 0x4eed: 0x0010, 0x4eee: 0x0010, 0x4eef: 0x0010,
	0x4ef0: 0x8000, 0x4ef1: 0x8000, 0x4ef2: 0x8000, 0x4ef3: 0x8000, 0x4ef4: 0x8000, 0x4ef5: 0x8000,
	0x4ef6: 0x8000, 0x4ef7: 0x8000, 0x4ef8: 0x8000, 0x4ef9: 0x8000,
	// Block 0x13c, offset 0x4f00
	0x4f10: 0x0001, 0x4f11: 0x0001,
	0x4f12: 0x0001, 0x4f13: 0x0001, 0x4f14: 0x0001, 0x4f15: 0x0001, 0x4f16: 0x0001, 0x4f17: 0x0001,
	0x4f18: 0x0001, 0x4f19: 0x0001, 0x4f1a: 0x0001, 0x4f1b: 0x0001, 0x4f1c: 0x0001, 0x4f1d: 0x0001,
	0x4f1e: 0x0001, 0x4f1f: 0x0001, 0x4f20: 0x0001, 0x4f21: 0x0001, 0x4f22: 0x0001, 0x4f23: 0x0001,
	0x4f24: 0x0001, 0x4f25: 0x0001, 0x4f26: 0x0001, 0x4f27: 0x0001, 0x4f28: 0x0001, 0x4f29: 0x0001,
	0x4f2a: 0x0001, 0x4f2b: 0x0001, 0x4f2c: 0x0010, 0x4f2d: 0x0010, 0x4f2e: 0x0010, 0x4f2f: 0x0010,
	0x4f30: 0x8000, 0x4f31: 0x8000, 0x4f32: 0x8000, 0x4f33: 0x8000, 0x4f34: 0x8000, 0x4f35: 0x8000,
	0x4f36: 0x8000, 0x4f37: 0x8000, 0x4f38: 0x8000, 0x4f39: 0x8000,
	// Block 0x13d, offset 0x4f40
	0x4f60: 0x0001, 0x4f61: 0x0001, 0x4f62: 0x0001, 0x4f63: 0x0001,
	0x4f64: 0x0001, 0x4f65: 0x0001, 0x4f66: 0x0001, 0x4f68: 0x0001, 0x4f69: 0x0001,
	0x4f6a: 0x0001, 0x4f6b: 0x0001, 0x4f6d: 0x0001, 0x4f6e: 0x0001,
	0x4f70: 0x0001, 0x4f71: 0x0001, 0x4f72: 0x0001, 0x4f73: 0x0001, 0x4f74: 0x0001, 0x4f75: 0x0001,
	0x4f76: 0x0001, 0x4f77: 0x0001, 0x4f78: 0x0001, 0x4f79: 0x0001, 0x4f7a: 0x0001, 0x4f7b: 0x0001,
	0x4f7c: 0x0001, 0x4f7d: 0x0001, 0x4f7e: 0x0001,
	// Block 0x13e, offset 0x4f80
	0x4f80: 0x0001, 0x4f81: 0x0001, 0x4f82: 0x0001, 0x4f83: 0x0001, 0x4f84: 0x0001,
	0x4f90: 0x0010, 0x4f91: 0x0010,
	0x4f92: 0x0010, 0x4f93: 0x0010, 0x4f94: 0x0010, 0x4f95: 0x0010, 0x4f96: 0x0010,
	// Block 0x13f, offset 0x4fc0
	0x4fc0: 0x0001, 0x4fc1: 0x0001, 0x4fc2: 0x0001, 0x4fc3: 0x0001, 0x4fc4: 0x0010, 0x4fc5: 0x0010,
	0x4fc6: 0x0010, 0x4fc7: 0x0010, 0x4fc8: 0x0010, 0x4fc9: 0x0010, 0x4fca: 0x0010, 0x4fcb: 0x0001,
	0x4fd0: 0x8000, 0x4fd1: 0x8000,
	0x4fd2: 0x8000, 0x4fd3: 0x8000, 0x4fd4: 0x8000, 0x4fd5: 0x8000, 0x4fd6: 0x8000, 0x4fd7: 0x8000,
	0x4fd8: 0x8000, 0x4fd9: 0x8000,
	// Block 0x140, offset 0x5000
	0x5000: 0x0001, 0x5001: 0x0001, 0x5002: 0x0001, 0x5003: 0x0001, 0x5005: 0x0001,
	0x5006: 0x0001, 0x5007: 0x0001, 0x5008: 0x0001, 0x5009: 0x0001, 0x500a: 0x0001, 0x500b: 0x0001,
	0x500c: 0x0001, 0x500d: 0x0001, 0x500e: 0x0001, 0x500f: 0x0001, 0x5010: 0x0001, 0x5011: 0x0001,
	0x5012: 0x0001, 0x5013: 0x0001, 0x5014: 0x0001, 0x5015: 0x0001, 0x5016: 0x0001, 0x5017: 0x0001,
	0x5018: 0x0001, 0x5019: 0x0001, 0x501a: 0x0001, 0x501b: 0x0001, 0x501c: 0x0001, 0x501d: 0x0001,
	0x501e: 0x0001, 0x501f: 0x0001, 0x5021: 0x0001, 0x5022: 0x0001,
	0x5024: 0x0001, 0x5027: 0x0001, 0x5029: 0x0001,
	0x502a: 0x0001, 0x502b: 0x0001, 0x502c: 0x0001, 0x502d: 0x0001, 0x502e: 0x0001, 0x502f: 0x0001,
	0x5030: 0x0001, 0x5031: 0x0001, 0x5032: 0x0001, 0x5034: 0x0001, 0x5035: 0x0001,
	0x5036: 0x0001, 0x5037: 0x0001, 0x5039: 0x0001, 0x503b: 0x0001,
	// Block 0x141, offset 0x5040
	0x5042: 0x0001,
	0x5047: 0x0001, 0x5049: 0x0001, 0x504b: 0x0001,
	0x504d: 0x0001, 0x504e: 0x0001, 0x504f: 0x0001, 0x5051: 0x0001,
	0x5052: 0x0001, 0x5054: 0x0001, 0x5057: 0x0001,
	0x5059: 0x0001, 0x505b: 0x0001, 0x505d: 0x0001,
	0x505f: 0x0001, 0x5061: 0x0001, 0x5062: 0x0001,
	0x5064: 0x0001, 0x5067: 0x0001, 0x5068: 0x0001, 0x5069: 0x0001,
	0x506a: 0x0001, 0x506c: 0x0001, 0x506d: 0x0001, 0x506e: 0x0001, 0x506f: 0x0001,
	0x5070: 0x0001, 0x5071: 0x0001, 0x5072: 0x0001, 0x5074: 0x0001, 0x5075: 0x0001,
	0x5076: 0x0001, 0x5077: 0x0001, 0x5079: 0x0001, 0x507a: 0x0001, 0x507b: 0x0001,
	0x507c: 0x0001, 0x507e: 0x0001,
	// Block 0x142, offset 0x5080
	0x5080: 0x0001, 0x5081: 0x0001, 0x5082: 0x0001, 0x5083: 0x0001, 0x5084: 0x0001, 0x5085: 0x0001,
	0x5086: 0x0001, 0x5087: 0x0001, 0x5088: 0x0001, 0x5089: 0x0001, 0x508b: 0x0001,
	0x508c: 0x0001, 0x508d: 0x0001, 0x508e: 0x0001, 0x508f: 0x0001, 0x5090: 0x0001, 0x5091: 0x0001,
	0x5092: 0x0001, 0x5093: 0x0001, 0x5094: 0x0001, 0x5095: 0x0001, 0x5096: 0x0001, 0x5097: 0x0001,
	0x5098: 0x0001, 0x5099: 0x0001, 0x509a: 0x0001, 0x509b: 0x0001,
	0x50a1: 0x0001, 0x50a2: 0x0001, 0x50a3: 0x0001,
	0x50a5: 0x0001, 0x50a6: 0x0001, 0x50a7: 0x0001, 0x50a8: 0x0001, 0x50a9: 0x0001,
	0x50ab: 0x0001, 0x50ac: 0x0001, 0x50ad: 0x0001, 0x50ae: 0x0001, 0x50af: 0x0001,
	0x50b0: 0x0001, 0x50b1: 0x0001, 0x50b2: 0x0001, 0x50b3: 0x0001, 0x50b4: 0x0001, 0x50b5: 0x0001,
	0x50b6: 0x0001, 0x50b7: 0x0001, 0x50b8: 0x0001, 0x50b9: 0x0001, 0x50ba: 0x0001, 0x50bb: 0x0001,
	// Block 0x143, offset 0x50c0
	0x50cd: 0x0040, 0x50ce: 0x0040, 0x50cf: 0x0040,
	0x50ef: 0x0040,
	0x50f0: 0x0001, 0x50f1: 0x0001, 0x50f2: 0x0001, 0x50f3: 0x0001, 0x50f4: 0x0001, 0x50f5: 0x0001,
	0x50f6: 0x0001, 0x50f7: 0x0001, 0x50f8: 0x0001, 0x50f9: 0x0001, 0x50fa: 0x0001, 0x50fb: 0x0001,
	0x50fc: 0x0001, 0x50fd: 0x0001, 0x50fe: 0x0001, 0x50ff: 0x0001,
	// Block 0x144, offset 0x5100
	0x5100: 0x0001, 0x5101: 0x0001, 0x5102: 0x0001, 0x5103: 0x0001, 0x5104: 0x0001, 0x5105: 0x0001,
	0x5106: 0x0001, 0x5107: 0x0001, 0x5108: 0x0001, 0x5109: 0x0001,
	0x5110: 0x0001, 0x5111: 0x0001,
	0x5112: 0x0001, 0x5113: 0x0001, 0x5114: 0x0001, 0x5115: 0x0001, 0x5116: 0x0001, 0x5117: 0x0001,
	0x5118: 0x0001, 0x5119: 0x0001, 0x511a: 0x0001, 0x511b: 0x0001, 0x511c: 0x0001, 0x511d: 0x0001,
	0x511e: 0x0001, 0x511f: 0x0001, 0x5120: 0x0001, 0x5121: 0x0001, 0x5122: 0x0001, 0x5123: 0x0001,
	0x5124: 0x0001, 0x5125: 0x0001, 0x5126: 0x0001, 0x5127: 0x0001, 0x5128: 0x0001, 0x5129: 0x0001,
	0x512c: 0x0040, 0x512d: 0x0040, 0x512e: 0x0040, 0x512f: 0x0040,
	0x5130: 0x0041, 0x5131: 0x0041, 0x5132: 0x0001, 0x5133: 0x0001, 0x5134: 0x0001, 0x5135: 0x0001,
	0x5136: 0x0001, 0x5137: 0x0001, 0x5138: 0x0001, 0x5139: 0x0001, 0x513a: 0x0001, 0x513b: 0x0001,
	0x513c: 0x0001, 0x513d: 0x0001, 0x513e: 0x0041, 0x513f: 0x0041,
	// Block 0x145, offset 0x5140
	0x5140: 0x0001, 0x5141: 0x0001, 0x5142: 0x0001, 0x5143: 0x0001, 0x5144: 0x0001, 0x5145: 0x0001,
	0x5146: 0x0001, 0x5147: 0x0001, 0x5148: 0x0001, 0x5149: 0x0001,
	0x514e: 0x0040, 0x5151: 0x0040,
	0x5152: 0x0040, 0x5153: 0x0040, 0x5154: 0x0040, 0x5155: 0x0040, 0x5156: 0x0040, 0x5157: 0x0040,
	0x5158: 0x0040, 0x5159: 0x0040, 0x515a: 0x0040,
	0x516d: 0x0040, 0x516e: 0x0040, 0x516f: 0x0040,
	0x5170: 0x0040, 0x5171: 0x0040, 0x5172: 0x0040, 0x5173: 0x0040, 0x5174: 0x0040, 0x5175: 0x0040,
	0x5176: 0x0040, 0x5177: 0x0040, 0x5178: 0x0040, 0x5179: 0x0040, 0x517a: 0x0040, 0x517b: 0x0040,
	0x517c: 0x0040, 0x517d: 0x0040, 0x517e: 0x0040, 0x517f: 0x0040,
	// Block 0x146, offset 0x5180
	0x5180: 0x0040, 0x5181: 0x0040, 0x5182: 0x0040, 0x5183: 0x0040, 0x5184: 0x0040, 0x5185: 0x0040,
	0x5186: 0x0040, 0x5187: 0x0040, 0x5188: 0x0040, 0x5189: 0x0040, 0x518a: 0x0040, 0x518b: 0x0040,
	0x518c: 0x0040, 0x518d: 0x0040, 0x518e: 0x0040, 0x518f: 0x0040, 0x5190: 0x0040, 0x5191: 0x0040,
	0x5192: 0x0040, 0x5193: 0x0040, 0x5194: 0x0040, 0x5195: 0x0040, 0x5196: 0x0040, 0x5197: 0x0040,
	0x5198: 0x0040, 0x5199: 0x0040, 0x519a: 0x0040, 0x519b: 0x0040, 0x519c: 0x0040, 0x519d: 0x0040,
	0x519e: 0x0040, 0x519f: 0x0040, 0x51a0: 0x0040, 0x51a1: 0x0040, 0x51a2: 0x0040, 0x51a3: 0x0040,
	0x51a4: 0x0040, 0x51a5: 0x0040, 0x51a6: 0x10000, 0x51a7: 0x10000, 0x51a8: 0x10000, 0x51a9: 0x10000,
	0x51aa: 0x10000, 0x51ab: 0x10000, 0x51ac: 0x10000, 0x51ad: 0x10000, 0x51ae: 0x10000, 0x51af: 0x10000,
	0x51b0: 0x10000, 0x51b1: 0x10000, 0x51b2: 0x10000, 0x51b3: 0x10000, 0x51b4: 0x10000, 0x51b5: 0x10000,
	0x51b6: 0x10000, 0x51b7: 0x10000, 0x51b8: 0x10000, 0x51b9: 0x10000, 0x51ba: 0x10000, 0x51bb: 0x10000,
	0x51bc: 0x10000, 0x51bd: 0x10000, 0x51be: 0x10000, 0x51bf: 0x10000,
	// Block 0x147, offset 0x51c0
	0x51c0: 0x0002, 0x51c1: 0x0040, 0x51c2: 0x0040, 0x51c3: 0x0040, 0x51c4: 0x0040, 0x51c5: 0x0040,
	0x51c6: 0x0040, 0x51c7: 0x0040, 0x51c8: 0x0040, 0x51c9: 0x0040, 0x51ca: 0x0040, 0x51cb: 0x0040,
	0x51cc: 0x0040, 0x51cd: 0x0040, 0x51ce: 0x0040, 0x51cf: 0x0040,
	0x51da: 0x0040,
	0x51ef: 0x0040,
	0x51f2: 0x0040, 0x51f3: 0x0040, 0x51f4: 0x0040, 0x51f5: 0x0040,
	0x51f6: 0x0040, 0x51f7: 0x0040, 0x51f8: 0x0040, 0x51f9: 0x0040, 0x51fa: 0x0040,
	0x51fc: 0x0040, 0x51fd: 0x0040, 0x51fe: 0x0040, 0x51ff: 0x0040,
	// Block 0x148, offset 0x5200
	0x5209: 0x0040, 0x520a: 0x0040, 0x520b: 0x0040,
	0x520c: 0x0040, 0x520d: 0x0040, 0x520e: 0x0040, 0x520f: 0x0040, 0x5210: 0x0040, 0x5211: 0x0040,
	0x5212: 0x0040, 0x5213: 0x0040, 0x5214: 0x0040, 0x5215: 0x0040, 0x5216: 0x0040, 0x5217: 0x0040,
	0x5218: 0x0040, 0x5219: 0x0040, 0x521a: 0x0040, 0x521b: 0x0040, 0x521c: 0x0040, 0x521d: 0x0040,
	0x521e: 0x0040, 0x521f: 0x0040, 0x5220: 0x0040, 0x5221: 0x0040, 0x5222: 0x0040, 0x5223: 0x0040,
	0x5224: 0x0040, 0x5225: 0x0040, 0x5226: 0x0040, 0x5227: 0x0040, 0x5228: 0x0040, 0x5229: 0x0040,
	0x522a: 0x0040, 0x522b: 0x0040, 0x522c: 0x0040, 0x522d: 0x0040, 0x522e: 0x0040, 0x522f: 0x0040,
	0x5230: 0x0040, 0x5231: 0x0040, 0x5232: 0x0040, 0x5233: 0x0040, 0x5234: 0x0040, 0x5235: 0x0040,
	0x5236: 0x0040, 0x5237: 0x0040, 0x5238: 0x0040, 0x5239: 0x0040, 0x523a: 0x0040, 0x523b: 0x0040,
	0x523c: 0x0040, 0x523d: 0x0040, 0x523e: 0x0040, 0x523f: 0x0040,
	// Block 0x149, offset 0x5240
	0x5240: 0x0040, 0x5241: 0x0040, 0x5242: 0x0040, 0x5243: 0x0040, 0x5244: 0x0040, 0x5245: 0x0040,
	0x5246: 0x0040, 0x5247: 0x0040, 0x5248: 0x0040, 0x5249: 0x0040, 0x524a: 0x0040, 0x524b: 0x0040,
	0x524c: 0x0040, 0x524d: 0x0040, 0x524e: 0x0040, 0x524f: 0x0040, 0x5250: 0x0040, 0x5251: 0x0040,
	0x5252: 0x0040, 0x5253: 0x0040, 0x5254: 0x0040, 0x5255: 0x0040, 0x5256: 0x0040, 0x5257: 0x0040,
	0x5258: 0x0040, 0x5259: 0x0040, 0x525a: 0x0040, 0x525b: 0x0040, 0x525c: 0x0040, 0x525d: 0x0040,
	0x525e: 0x0040, 0x525f: 0x0040, 0x5260: 0x0040, 0x5261: 0x0040, 0x5262: 0x0040, 0x5263: 0x0040,
	0x5264: 0x0040, 0x5265: 0x0040, 0x5266: 0x0040, 0x5267: 0x0040, 0x5268: 0x0040, 0x5269: 0x0040,
	0x526a: 0x0040, 0x526b: 0x0040, 0x526c: 0x0040, 0x526d: 0x0040, 0x526e: 0x0040, 0x526f: 0x0040,
	0x5270: 0x0040, 0x5271: 0x0040, 0x5272: 0x0040, 0x5273: 0x0040, 0x5274: 0x0040, 0x5275: 0x0040,
	0x5276: 0x0040, 0x5277: 0x0040, 0x5278: 0x0040, 0x5279: 0x0040, 0x527a: 0x0040, 0x527b: 0x0010,
	0x527c: 0x0010, 0x527d: 0x0010, 0x527e: 0x0010, 0x527f: 0x0010,
	// Block 0x14a, offset 0x5280
	0x5280: 0x0040, 0x5281: 0x0040, 0x5282: 0x0040, 0x5283: 0x0040, 0x5284: 0x0040, 0x5285: 0x0040,
	0x5286: 0x0040, 0x5287: 0x0040, 0x5288: 0x0040, 0x5289: 0x0040, 0x528a: 0x0040, 0x528b: 0x0040,
	0x528c: 0x0040, 0x528d: 0x0040, 0x528e: 0x0040, 0x528f: 0x0040, 0x5290: 0x0040, 0x5291: 0x0040,
	0x5292: 0x0040, 0x5293: 0x0040, 0x5294: 0x0040, 0x5295: 0x0040, 0x5296: 0x0040, 0x5297: 0x0040,
	0x5298: 0x0040, 0x5299: 0x0040, 0x529a: 0x0040, 0x529b: 0x0040, 0x529c: 0x0040, 0x529d: 0x0040,
	0x529e: 0x0040, 0x529f: 0x0040, 0x52a0: 0x0040, 0x52a1: 0x0040, 0x52a2: 0x0040, 0x52a3: 0x0040,
	0x52a4: 0x0040, 0x52a5: 0x0040, 0x52a6: 0x0040, 0x52a7: 0x0040, 0x52a8: 0x0040, 0x52a9: 0x0040,
	0x52aa: 0x0040, 0x52ab: 0x0040, 0x52ac: 0x0040, 0x52ad: 0x0040, 0x52ae: 0x0040, 0x52af: 0x0040,
	0x52b0: 0x0040, 0x52b1: 0x0040, 0x52b2: 0x0040, 0x52b3: 0x0040, 0x52b4: 0x0040, 0x52b5: 0x0040,
	0x52b6: 0x0040, 0x52b7: 0x0040, 0x52b8: 0x0040, 0x52b9: 0x0040, 0x52ba: 0x0040, 0x52bb: 0x0040,
	0x52bc: 0x0040, 0x52bd: 0x0040,
	// Block 0x14b, offset 0x52c0
	0x52c6: 0x0040, 0x52c7: 0x0040, 0x52c8: 0x0040, 0x52c9: 0x0040, 0x52ca: 0x0040, 0x52cb: 0x0040,
	0x52cc: 0x0040, 0x52cd: 0x0040, 0x52ce: 0x0040, 0x52cf: 0x0040, 0x52d0: 0x0040, 0x52d1: 0x0040,
	0x52d2: 0x0040, 0x52d3: 0x0040, 0x52d4: 0x0040, 0x52d5: 0x0040, 0x52d6: 0x0040, 0x52d7: 0x0040,
	0x52d8: 0x0040, 0x52d9: 0x0040, 0x52da: 0x0040, 0x52db: 0x0040, 0x52dc: 0x0040, 0x52dd: 0x0040,
	0x52de: 0x0040, 0x52df: 0x0040, 0x52e0: 0x0040, 0x52e1: 0x0040, 0x52e2: 0x0040, 0x52e3: 0x0040,
	0x52e4: 0x0040, 0x52e5: 0x0040, 0x52e6: 0x0040, 0x52e7: 0x0040, 0x52e8: 0x0040, 0x52e9: 0x0040,
	0x52ea: 0x0040, 0x52eb: 0x0040, 0x52ec: 0x0040, 0x52ed: 0x0040, 0x52ee: 0x0040, 0x52ef: 0x0040,
	0x52f0: 0x0040, 0x52f1: 0x0040, 0x52f2: 0x0040, 0x52f3: 0x0040, 0x52f4: 0x0040, 0x52f5: 0x0040,
	0x52f6: 0x0040, 0x52f7: 0x0040, 0x52f8: 0x0040, 0x52f9: 0x0040, 0x52fa: 0x0040, 0x52fb: 0x0040,
	0x52fc: 0x0040, 0x52fd: 0x0040, 0x52fe: 0x0040, 0x52ff: 0x0040,
	// Block 0x14c, offset 0x5300
	0x5300: 0x0040, 0x5301: 0x0040, 0x5302: 0x0040, 0x5303: 0x0040, 0x5304: 0x0040, 0x5305: 0x0040,
	0x5306: 0x0040, 0x5307: 0x0040, 0x5308: 0x0040, 0x5309: 0x0040, 0x530a: 0x0040, 0x530b: 0x0040,
	0x530c: 0x0040, 0x530d: 0x0040, 0x530e: 0x0040, 0x530f: 0x0040,
	// Block 0x14d, offset 0x5340
	0x5374: 0x0040, 0x5375: 0x0040,
	0x5376: 0x0040, 0x5377: 0x0040, 0x5378: 0x0040, 0x5379: 0x0040, 0x537a: 0x0040, 0x537b: 0x0040,
	0x537c: 0x0040, 0x537d: 0x0040, 0x537e: 0x0040, 0x537f: 0x0040,
	// Block 0x14e, offset 0x5380
	0x5395: 0x0040, 0x5396: 0x0040, 0x5397: 0x0040,
	0x5398: 0x0040, 0x5399: 0x0040, 0x539a: 0x0040, 0x539b: 0x0040, 0x539c: 0x0040, 0x539d: 0x0040,
	0x539e: 0x0040, 0x539f: 0x0040, 0x53a0: 0x0040, 0x53a1: 0x0040, 0x53a2: 0x0040, 0x53a3: 0x0040,
	0x53a4: 0x0040, 0x53a5: 0x0040, 0x53a6: 0x0040, 0x53a7: 0x0040, 0x53a8: 0x0040, 0x53a9: 0x0040,
	0x53aa: 0x0040, 0x53ab: 0x0040, 0x53ac: 0x0040, 0x53ad: 0x0040, 0x53ae: 0x0040, 0x53af: 0x0040,
	0x53b0: 0x0040, 0x53b1: 0x0040, 0x53b2: 0x0040, 0x53b3: 0x0040, 0x53b4: 0x0040, 0x53b5: 0x0040,
	0x53b6: 0x0040, 0x53b7: 0x0040, 0x53b8: 0x0040, 0x53b9: 0x0040, 0x53ba: 0x0040, 0x53bb: 0x0040,
	0x53bc: 0x0040, 0x53bd: 0x0040, 0x53be: 0x0040, 0x53bf: 0x0040,
	// Block 0x14f, offset 0x53c0
	0x53cc: 0x0040, 0x53cd: 0x0040, 0x53ce: 0x0040, 0x53cf: 0x0040,
	// Block 0x150, offset 0x5400
	0x5408: 0x0040, 0x5409: 0x0040, 0x540a: 0x0040, 0x540b: 0x0040,
	0x540c: 0x0040, 0x540d: 0x0040, 0x540e: 0x0040, 0x540f: 0x0040,
	0x541a: 0x0040, 0x541b: 0x0040, 0x541c: 0x0040, 0x541d: 0x0040,
	0x541e: 0x0040, 0x541f: 0x0040,
	// Block 0x151, offset 0x5440
	0x5448: 0x0040, 0x5449: 0x0040, 0x544a: 0x0040, 0x544b: 0x0040,
	0x544c: 0x0040, 0x544d: 0x0040, 0x544e: 0x0040, 0x544f: 0x0040,
	0x546e: 0x0040, 0x546f: 0x0040,
	0x5470: 0x0040, 0x5471: 0x0040, 0x5472: 0x0040, 0x5473: 0x0040, 0x5474: 0x0040, 0x5475: 0x0040,
	0x5476: 0x0040, 0x5477: 0x0040, 0x5478: 0x0040, 0x5479: 0x0040, 0x547a: 0x0040, 0x547b: 0x0040,
	0x547c: 0x0040, 0x547d: 0x0040, 0x547e: 0x0040, 0x547f: 0x0040,
	// Block 0x152, offset 0x5480
	0x548c: 0x0040, 0x548d: 0x0040, 0x548e: 0x0040, 0x548f: 0x0040, 0x5490: 0x0040, 0x5491: 0x0040,
	0x5492: 0x0040, 0x5493: 0x0040, 0x5494: 0x0040, 0x5495: 0x0040, 0x5496: 0x0040, 0x5497: 0x0040,
	0x5498: 0x0040, 0x5499: 0x0040, 0x549a: 0x0040, 0x549b: 0x0040, 0x549c: 0x0040, 0x549d: 0x0040,
	0x549e: 0x0040, 0x549f: 0x0040, 0x54a0: 0x0040, 0x54a1: 0x0040, 0x54a2: 0x0040, 0x54a3: 0x0040,
	0x54a4: 0x0040, 0x54a5: 0x0040, 0x54a6: 0x0040, 0x54a7: 0x0040, 0x54a8: 0x0040, 0x54a9: 0x0040,
	0x54aa: 0x0040, 0x54ab: 0x0040, 0x54ac: 0x0040, 0x54ad: 0x0040, 0x54ae: 0x0040, 0x54af: 0x0040,
	0x54b0: 0x0040, 0x54b1: 0x0040, 0x54b2: 0x0040, 0x54b3: 0x0040, 0x54b4: 0x0040, 0x54b5: 0x0040,
	0x54b6: 0x0040, 0x54b7: 0x0040, 0x54b8: 0x0040, 0x54b9: 0x0040, 0x54ba: 0x0040,
	0x54bc: 0x0040, 0x54bd: 0x0040, 0x54be: 0x0040, 0x54bf: 0x0040,
	// Block 0x153, offset 0x54c0
	0x54c0: 0x0040, 0x54c1: 0x0040, 0x54c2: 0x0040, 0x54c3: 0x0040, 0x54c4: 0x0040, 0x54c5: 0x0040,
	0x54c7: 0x0040, 0x54c8: 0x0040, 0x54c9: 0x0040, 0x54ca: 0x0040, 0x54cb: 0x0040,
	0x54cc: 0x0040, 0x54cd: 0x0040, 0x54ce: 0x0040, 0x54cf: 0x0040, 0x54d0: 0x0040, 0x54d1: 0x0040,
	0x54d2: 0x0040, 0x54d3: 0x0040, 0x54d4: 0x0040, 0x54d5: 0x0040, 0x54d6: 0x0040, 0x54d7: 0x0040,
	0x54d8: 0x0040, 0x54d9: 0x0040, 0x54da: 0x0040, 0x54db: 0x0040, 0x54dc: 0x0040, 0x54dd: 0x0040,
	0x54de: 0x0040, 0x54df: 0x0040, 0x54e0: 0x0040, 0x54e1: 0x0040, 0x54e2: 0x0040, 0x54e3: 0x0040,
	0x54e4: 0x0040, 0x54e5: 0x0040, 0x54e6: 0x0040, 0x54e7: 0x0040, 0x54e8: 0x0040, 0x54e9: 0x0040,
	0x54ea: 0x0040, 0x54eb: 0x0040, 0x54ec: 0x0040, 0x54ed: 0x0040, 0x54ee: 0x0040, 0x54ef: 0x0040,
	0x54f0: 0x0040, 0x54f1: 0x0040, 0x54f2: 0x0040, 0x54f3: 0x0040, 0x54f4: 0x0040, 0x54f5: 0x0040,
	0x54f6: 0x0040, 0x54f7: 0x0040, 0x54f8: 0x0040, 0x54f9: 0x0040, 0x54fa: 0x0040, 0x54fb: 0x0040,
	0x54fc: 0x0040, 0x54fd: 0x0040, 0x54fe: 0x0040, 0x54ff: 0x0040,
	// Block 0x154, offset 0x5500
	0x5530: 0x8000, 0x5531: 0x8000, 0x5532: 0x8000, 0x5533: 0x8000, 0x5534: 0x8000, 0x5535: 0x8000,
	0x5536: 0x8000, 0x5537: 0x8000, 0x5538: 0x8000, 0x5539: 0x8000,
	// Block 0x155, offset 0x5540
	0x5540: 0x0002, 0x5541: 0x0002, 0x5542: 0x0002, 0x5543: 0x0002, 0x5544: 0x0002, 0x5545: 0x0002,
	0x5546: 0x0002, 0x5547: 0x0002, 0x5548: 0x0002, 0x5549: 0x0002, 0x554a: 0x0002, 0x554b: 0x0002,
	0x554c: 0x0002, 0x554d: 0x0002, 0x554e: 0x0002, 0x554f: 0x0002, 0x5550: 0x0002, 0x5551: 0x0002,
	0x5552: 0x0002, 0x5553: 0x0002, 0x5554: 0x0002, 0x5555: 0x0002, 0x5556: 0x0002, 0x5557: 0x0002,
	0x5558: 0x0002, 0x5559: 0x0002, 0x555a: 0x0002, 0x555b: 0x0002, 0x555c: 0x0002, 0x555d: 0x0002,
	0x555e: 0x0002, 0x555f: 0x0002,
	// Block 0x156, offset 0x5580
	0x5580: 0x0002, 0x5581: 0x0002, 0x5582: 0x0002, 0x5583: 0x0002, 0x5584: 0x0002, 0x5585: 0x0002,
	0x5586: 0x0002, 0x5587: 0x0002, 0x5588: 0x0002, 0x5589: 0x0002, 0x558a: 0x0002, 0x558b: 0x0002,
	0x558c: 0x0002, 0x558d: 0x0002, 0x558e: 0x0002, 0x558f: 0x0002, 0x5590: 0x0002, 0x5591: 0x0002,
	0x5592: 0x0002, 0x5593: 0x0002, 0x5594: 0x0002, 0x5595: 0x0002, 0x5596: 0x0002, 0x5597: 0x0002,
	0x5598: 0x0002, 0x5599: 0x0002, 0x559a: 0x0002, 0x559b: 0x0002, 0x559c: 0x0002, 0x559d: 0x0002,
	0x559e: 0x0002, 0x559f: 0x0002, 0x55a0: 0x0002, 0x55a1: 0x0002, 0x55a2: 0x0002, 0x55a3: 0x0002,
	0x55a4: 0x0002, 0x55a5: 0x0002, 0x55a6: 0x0002, 0x55a7: 0x0002, 0x55a8: 0x0002, 0x55a9: 0x0002,
	0x55aa: 0x0002, 0x55ab: 0x0002, 0x55ac: 0x0002, 0x55ad: 0x0002, 0x55ae: 0x0002, 0x55af: 0x0002,
	0x55b0: 0x0002, 0x55b1: 0x0002, 0x55b2: 0x0002, 0x55b3: 0x0002, 0x55b4: 0x0002, 0x55b5: 0x0002,
	0x55b6: 0x0002, 0x55b7: 0x0002, 0x55b8: 0x0002, 0x55b9: 0x0002,
	// Block 0x157, offset 0x55c0
	0x55c0: 0x0002, 0x55c1: 0x0002, 0x55c2: 0x0002, 0x55c3: 0x0002, 0x55c4: 0x0002, 0x55c5: 0x0002,
	0x55c6: 0x0002, 0x55c7: 0x0002, 0x55c8: 0x0002, 0x55c9: 0x0002, 0x55ca: 0x0002, 0x55cb: 0x0002,
	0x55cc: 0x0002, 0x55cd: 0x0002, 0x55ce: 0x0002, 0x55cf: 0x0002, 0x55d0: 0x0002, 0x55d1: 0x0002,
	0x55d2: 0x0002, 0x55d3: 0x0002, 0x55d4: 0x0002, 0x55d5: 0x0002, 0x55d6: 0x0002, 0x55d7: 0x0002,
	0x55d8: 0x0002, 0x55d9: 0x0002, 0x55da: 0x0002, 0x55db: 0x0002, 0x55dc: 0x0002, 0x55dd: 0x0002,
	0x55e0: 0x0002, 0x55e1: 0x0002, 0x55e2: 0x0002, 0x55e3: 0x0002,
	0x55e4: 0x0002, 0x55e5: 0x0002, 0x55e6: 0x0002, 0x55e7: 0x0002, 0x55e8: 0x0002, 0x55e9: 0x0002,
	0x55ea: 0x0002, 0x55eb: 0x0002, 0x55ec: 0x0002, 0x55ed: 0x0002, 0x55ee: 0x0002, 0x55ef: 0x0002,
	0x55f0: 0x0002, 0x55f1: 0x0002, 0x55f2: 0x0002, 0x55f3: 0x0002, 0x55f4: 0x0002, 0x55f5: 0x0002,
	0x55f6: 0x0002, 0x55f7: 0x0002, 0x55f8: 0x0002, 0x55f9: 0x0002, 0x55fa: 0x0002, 0x55fb: 0x0002,
	0x55fc: 0x0002, 0x55fd: 0x0002, 0x55fe: 0x0002, 0x55ff: 0x0002,
	// Block 0x158, offset 0x5600
	0x5600: 0x0002, 0x5601: 0x0002, 0x5602: 0x0002, 0x5603: 0x0002, 0x5604: 0x0002, 0x5605: 0x0002,
	0x5606: 0x0002, 0x5607: 0x0002, 0x5608: 0x0002, 0x5609: 0x0002, 0x560a: 0x0002, 0x560b: 0x0002,
	0x560c: 0x0002, 0x560d: 0x0002, 0x560e: 0x0002, 0x560f: 0x0002, 0x5610: 0x0002, 0x5611: 0x0002,
	0x5612: 0x0002, 0x5613: 0x0002, 0x5614: 0x0002, 0x5615: 0x0002, 0x5616: 0x0002, 0x5617: 0x0002,
	0x5618: 0x0002, 0x5619: 0x0002, 0x561a: 0x0002, 0x561b: 0x0002, 0x561c: 0x0002, 0x561d: 0x0002,
	0x561e: 0x0002, 0x561f: 0x0002, 0x5620: 0x0002, 0x5621: 0x0002,
	0x5630: 0x0002, 0x5631: 0x0002, 0x5632: 0x0002, 0x5633: 0x0002, 0x5634: 0x0002, 0x5635: 0x0002,
	0x5636: 0x0002, 0x5637: 0x0002, 0x5638: 0x0002, 0x5639: 0x0002, 0x563a: 0x0002, 0x563b: 0x0002,
	0x563c: 0x0002, 0x563d: 0x0002, 0x563e: 0x0002, 0x563f: 0x0002,
	// Block 0x159, offset 0x5640
	0x5640: 0x0002, 0x5641: 0x0002, 0x5642: 0x0002, 0x5643: 0x0002, 0x5644: 0x0002, 0x5645: 0x0002,
	0x5646: 0x0002, 0x5647: 0x0002, 0x5648: 0x0002, 0x5649: 0x0002, 0x564a: 0x0002, 0x564b: 0x0002,
	0x564c: 0x0002, 0x564d: 0x0002, 0x564e: 0x0002, 0x564f: 0x0002, 0x5650: 0x0002, 0x5651: 0x0002,
	0x5652: 0x0002, 0x5653: 0x0002, 0x5654: 0x0002, 0x5655: 0x0002, 0x5656: 0x0002, 0x5657: 0x0002,
	0x5658: 0x0002, 0x5659: 0x0002, 0x565a: 0x0002, 0x565b: 0x0002, 0x565c: 0x0002, 0x565d: 0x0002,
	0x565e: 0x0002, 0x565f: 0x0002, 0x5660: 0x0002,
	// Block 0x15a, offset 0x5680
	0x5680: 0x0002, 0x5681: 0x0002, 0x5682: 0x0002, 0x5683: 0x0002, 0x5684: 0x0002, 0x5685: 0x0002,
	0x5686: 0x0002, 0x5687: 0x0002, 0x5688: 0x0002, 0x5689: 0x0002, 0x568a: 0x0002, 0x568b: 0x0002,
	0x568c: 0x0002, 0x568d: 0x0002, 0x568e: 0x0002, 0x568f: 0x0002, 0x5690: 0x0002, 0x5691: 0x0002,
	0x5692: 0x0002, 0x5693: 0x0002, 0x5694: 0x0002, 0x5695: 0x0002, 0x5696: 0x0002, 0x5697: 0x0002,
	0x5698: 0x0002, 0x5699: 0x0002, 0x569a: 0x0002, 0x569b: 0x0002, 0x569c: 0x0002, 0x569d: 0x0002,
	// Block 0x15b, offset 0x56c0
	0x56c0: 0x0002, 0x56c1: 0x0002, 0x56c2: 0x0002, 0x56c3: 0x0002, 0x56c4: 0x0002, 0x56c5: 0x0002,
	0x56c6: 0x0002, 0x56c7: 0x0002, 0x56c8: 0x0002, 0x56c9: 0x0002, 0x56ca: 0x0002,
	0x56d0: 0x0002, 0x56d1: 0x0002,
	0x56d2: 0x0002, 0x56d3: 0x0002, 0x56d4: 0x0002, 0x56d5: 0x0002, 0x56d6: 0x0002, 0x56d7: 0x0002,
	0x56d8: 0x0002, 0x56d9: 0x0002, 0x56da: 0x0002, 0x56db: 0x0002, 0x56dc: 0x0002, 0x56dd: 0x0002,
	0x56de: 0x0002, 0x56df: 0x0002, 0x56e0: 0x0002, 0x56e1: 0x0002, 0x56e2: 0x0002, 0x56e3: 0x0002,
	0x56e4: 0x0002, 0x56e5: 0x0002, 0x56e6: 0x0002, 0x56e7: 0x0002, 0x56e8: 0x0002, 0x56e9: 0x0002,
	0x56ea: 0x0002, 0x56eb: 0x0002, 0x56ec: 0x0002, 0x56ed: 0x0002, 0x56ee: 0x0002, 0x56ef: 0x0002,
	0x56f0: 0x0002, 0x56f1: 0x0002, 0x56f2: 0x0002, 0x56f3: 0x0002, 0x56f4: 0x0002, 0x56f5: 0x0002,
	0x56f6: 0x0002, 0x56f7: 0x0002, 0x56f8: 0x0002, 0x56f9: 0x0002, 0x56fa: 0x0002, 0x56fb: 0x0002,
	0x56fc: 0x0002, 0x56fd: 0x0002, 0x56fe: 0x0002, 0x56ff: 0x0002,
	// Block 0x15c, offset 0x5700
	0x5700: 0x0002, 0x5701: 0x0002, 0x5702: 0x0002, 0x5703: 0x0002, 0x5704: 0x0002, 0x5705: 0x0002,
	0x5706: 0x0002, 0x5707: 0x0002, 0x5708: 0x0002, 0x5709: 0x0002, 0x570a: 0x0002, 0x570b: 0x0002,
	0x570c: 0x0002, 0x570d: 0x0002, 0x570e: 0x0002, 0x570f: 0x0002, 0x5710: 0x0002, 0x5711: 0x0002,
	0x5712: 0x0002, 0x5713: 0x0002, 0x5714: 0x0002, 0x5715: 0x0002, 0x5716: 0x0002, 0x5717: 0x0002,
	0x5718: 0x0002, 0x5719: 0x0002, 0x571a: 0x0002, 0x571b: 0x0002, 0x571c: 0x0002, 0x571d: 0x0002,
	0x571e: 0x0002, 0x571f: 0x0002, 0x5720: 0x0002, 0x5721: 0x0002, 0x5722: 0x0002, 0x5723: 0x0002,
	0x5724: 0x0002, 0x5725: 0x0002, 0x5726: 0x0002, 0x5727: 0x0002, 0x5728: 0x0002, 0x5729: 0x0002,
	0x572a: 0x0002, 0x572b: 0x0002, 0x572c: 0x0002, 0x572d: 0x0002, 0x572e: 0x0002, 0x572f: 0x0002,
	// Block 0x15d, offset 0x5740
	0x5741: 0x0080,
	0x5760: 0x0010, 0x5761: 0x0010, 0x5762: 0x0010, 0x5763: 0x0010,
	0x5764: 0x0010, 0x5765: 0x0010, 0x5766: 0x0010, 0x5767: 0x0010, 0x5768: 0x0010, 0x5769: 0x0010,
	0x576a: 0x0010, 0x576b: 0x0010, 0x576c: 0x0010, 0x576d: 0x0010, 0x576e: 0x0010, 0x576f: 0x0010,
	0x5770: 0x0010, 0x5771: 0x0010, 0x5772: 0x0010, 0x5773: 0x0010, 0x5774: 0x0010, 0x5775: 0x0010,
	0x5776: 0x0010, 0x5777: 0x0010, 0x5778: 0x0010, 0x5779: 0x0010, 0x577a: 0x0010, 0x577b: 0x0010,
	0x577c: 0x0010, 0x577d: 0x0010, 0x577e: 0x0010, 0x577f: 0x0010,
	// Block 0x15e, offset 0x5780
	0x5780: 0x0010, 0x5781: 0x0010, 0x5782: 0x0010, 0x5783: 0x0010, 0x5784: 0x0010, 0x5785: 0x0010,
	0x5786: 0x0010, 0x5787: 0x0010, 0x5788: 0x0010, 0x5789: 0x0010, 0x578a: 0x0010, 0x578b: 0x0010,
	0x578c: 0x0010, 0x578d: 0x0010, 0x578e: 0x0010, 0x578f: 0x0010, 0x5790: 0x0010, 0x5791: 0x0010,
	0x5792: 0x0010, 0x5793: 0x0010, 0x5794: 0x0010, 0x5795: 0x0010, 0x5796: 0x0010, 0x5797: 0x0010,
	0x5798: 0x0010, 0x5799: 0x0010, 0x579a: 0x0010, 0x579b: 0x0010, 0x579c: 0x0010, 0x579d: 0x0010,
	0x579e: 0x0010, 0x579f: 0x0010, 0x57a0: 0x0010, 0x57a1: 0x0010, 0x57a2: 0x0010, 0x57a3: 0x0010,
	0x57a4: 0x0010, 0x57a5: 0x0010, 0x57a6: 0x0010, 0x57a7: 0x0010, 0x57a8: 0x0010, 0x57a9: 0x0010,
	0x57aa: 0x0010, 0x57ab: 0x0010, 0x57ac: 0x0010, 0x57ad: 0x0010, 0x57ae: 0x0010, 0x57af: 0x0010,
}

// wordsIndex: 36 blocks, 2304 entries, 4608 bytes
// Block 0 is the zero block.
var wordsIndex = [2304]property{
	// Block 0x0, offset 0x0
	// Block 0x1, offset 0x40
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc2: 0x01, 0xc3: 0x02, 0xc4: 0x03, 0xc5: 0x03, 0xc6: 0x03, 0xc7: 0x03,
	0xc8: 0x03, 0xc9: 0x03, 0xca: 0x03, 0xcb: 0x04, 0xcc: 0x05, 0xcd: 0x06, 0xce: 0x07, 0xcf: 0x08,
	0xd0: 0x03, 0xd1: 0x03, 0xd2: 0x09, 0xd3: 0x03, 0xd4: 0x0a, 0xd5: 0x0b, 0xd6: 0x0c, 0xd7: 0x0d,
	0xd8: 0x0e, 0xd9: 0x0f, 0xda: 0x03, 0xdb: 0x10, 0xdc: 0x11, 0xdd: 0x12, 0xde: 0x13, 0xdf: 0x14,
	0xe0: 0x02, 0xe1: 0x03, 0xe2: 0x04, 0xe3: 0x05, 0xe4: 0x06, 0xe5: 0x07, 0xe6: 0x07, 0xe7: 0x07,
	0xe8: 0x07, 0xe9: 0x07, 0xea: 0x08, 0xeb: 0x09, 0xec: 0x09, 0xed: 0x0a, 0xef: 0x0b,
	0xf0: 0x1f, 0xf3: 0x21,
	// Block 0x4, offset 0x100
	0x120: 0x15, 0x121: 0x16, 0x122: 0x17, 0x123: 0x18, 0x124: 0x19, 0x125: 0x1a, 0x126: 0x1b, 0x127: 0x1c,
	0x128: 0x1d, 0x129: 0x1e, 0x12a: 0x1f, 0x12b: 0x20, 0x12c: 0x21, 0x12d: 0x22, 0x12e: 0x23, 0x12f: 0x24,
	0x130: 0x25, 0x131: 0x26, 0x132: 0x27, 0x133: 0x28, 0x134: 0x29, 0x135: 0x2a, 0x136: 0x2b, 0x137: 0x2c,
	0x138: 0x2d, 0x139: 0x2e, 0x13a: 0x2f, 0x13b: 0x30, 0x13c: 0x31, 0x13d: 0x32, 0x13e: 0x33, 0x13f: 0x34,
	// Block 0x5, offset 0x140
	0x140: 0x35, 0x141: 0x36, 0x142: 0x37, 0x143: 0x38, 0x144: 0x03, 0x145: 0x03, 0x146: 0x03, 0x147: 0x03,
	0x148: 0x03, 0x149: 0x39, 0x14a: 0x3a, 0x14b: 0x3b, 0x14c: 0x3c, 0x14d: 0x3d, 0x14e: 0x3e, 0x14f: 0x3f,
	0x150: 0x40, 0x151: 0x03, 0x152: 0x03, 0x153: 0x03, 0x154: 0x03, 0x155: 0x03, 0x156: 0x03, 0x157: 0x03,
	0x158: 0x03, 0x159: 0x41, 0x15a: 0x42, 0x15b: 0x43, 0x15c: 0x44, 0x15d: 0x45, 0x15e: 0x46, 0x15f: 0x47,
	0x160: 0x48, 0x161: 0x49, 0x162: 0x4a, 0x163: 0x4b, 0x164: 0x4c, 0x165: 0x4d, 0x167: 0x4e,
	0x168: 0x4f, 0x169: 0x50, 0x16a: 0x51, 0x16b: 0x52, 0x16c: 0x53, 0x16d: 0x54, 0x16e: 0x55, 0x16f: 0x56,
	0x170: 0x57, 0x171: 0x58, 0x172: 0x59, 0x173: 0x5a, 0x174: 0x03, 0x175: 0x03, 0x176: 0x03, 0x177: 0x05,
	0x178: 0x03, 0x179: 0x03, 0x17a: 0x03, 0x17b: 0x03, 0x17c: 0x5b, 0x17d: 0x5c, 0x17e: 0x5d, 0x17f: 0x5e,
	// Block 0x6, offset 0x180
	0x180: 0x5f, 0x181: 0x60, 0x182: 0x61, 0x183: 0x62, 0x184: 0x63, 0x185: 0x64, 0x186: 0x65,
	0x18c: 0x66, 0x18e: 0x67, 0x18f: 0x68,
	0x192: 0x69, 0x193: 0x6a, 0x196: 0x6b, 0x197: 0x6c,
	0x198: 0x6d, 0x199: 0x6e, 0x19a: 0x6f, 0x19b: 0x6e, 0x19c: 0x70, 0x19d: 0x71, 0x19e: 0x72,
	0x1a4: 0x73,
	0x1ac: 0x74, 0x1ad: 0x75,
	0x1b0: 0x03, 0x1b1: 0x03, 0x1b2: 0x03, 0x1b3: 0x76, 0x1b4: 0x77, 0x1b5: 0x78, 0x1b6: 0x79, 0x1b7: 0x7a,
	0x1b8: 0x7b, 0x1ba: 0x7c, 0x1bb: 0x7d, 0x1bc: 0x7e, 0x1bd: 0x7e, 0x1be: 0x7e, 0x1bf: 0x7f,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x80, 0x1c1: 0x81, 0x1c2: 0x82, 0x1c3: 0x83, 0x1c4: 0x84, 0x1c5: 0x03, 0x1c6: 0x85, 0x1c7: 0x86,
	0x1ca: 0x87, 0x1cb: 0x88, 0x1cc: 0x89, 0x1cd: 0x8a,
	0x1d0: 0x7e, 0x1d1: 0x7e, 0x1d2: 0x7e, 0x1d3: 0x7e, 0x1d4: 0x7e, 0x1d5: 0x7e, 0x1d6: 0x7e, 0x1d7: 0x7e,
	0x1d8: 0x7e, 0x1d9: 0x7e, 0x1da: 0x7e, 0x1db: 0x7e, 0x1dc: 0x7e, 0x1dd: 0x7e, 0x1de: 0x7e, 0x1df: 0x7e,
	0x1e0: 0x7e, 0x1e1: 0x7e, 0x1e2: 0x7e, 0x1e3: 0x7e, 0x1e4: 0x7e, 0x1e5: 0x7e, 0x1e6: 0x7e, 0x1e7: 0x7e,
	0x1e8: 0x7e, 0x1e9: 0x7e, 0x1ea: 0x7e, 0x1eb: 0x7e, 0x1ec: 0x7e, 0x1ed: 0x7e, 0x1ee: 0x7e, 0x1ef: 0x7e,
	0x1f0: 0x7e, 0x1f1: 0x7e, 0x1f2: 0x7e, 0x1f3: 0x7e, 0x1f4: 0x7e, 0x1f5: 0x7e, 0x1f6: 0x7e, 0x1f7: 0x7e,
	0x1f8: 0x7e, 0x1f9: 0x7e, 0x1fa: 0x7e, 0x1fb: 0x7e, 0x1fc: 0x7e, 0x1fd: 0x7e, 0x1fe: 0x7e, 0x1ff: 0x7e,
	// Block 0x8, offset 0x200
	0x200: 0x7e, 0x201: 0x7e, 0x202: 0x7e, 0x203: 0x7e, 0x204: 0x7e, 0x205: 0x7e, 0x206: 0x7e, 0x207: 0x7e,
	0x208: 0x7e, 0x209: 0x7e, 0x20a: 0x7e, 0x20b: 0x7e, 0x20c: 0x7e, 0x20d: 0x7e, 0x20e: 0x7e, 0x20f: 0x7e,
	0x210: 0x7e, 0x211: 0x7e, 0x212: 0x7e, 0x213: 0x7e, 0x214: 0x7e, 0x215: 0x7e, 0x216: 0x7e, 0x217: 0x7e,
	0x218: 0x7e, 0x219: 0x7e, 0x21a: 0x7e, 0x21b: 0x7e, 0x21c: 0x7e, 0x21d: 0x7e, 0x21e: 0x7e, 0x21f: 0x7e,
	0x220: 0x7e, 0x221: 0x7e, 0x222: 0x7e, 0x223: 0x7e, 0x224: 0x7e, 0x225: 0x7e, 0x226: 0x7e, 0x227: 0x7e,
	0x228: 0x7e, 0x229: 0x7e, 0x22a: 0x7e, 0x22b: 0x7e, 0x22c: 0x7e, 0x22d: 0x7e, 0x22e: 0x7e, 0x22f: 0x7e,
	0x230: 0x7e, 0x231: 0x7e, 0x232: 0x7e, 0x233: 0x7e, 0x234: 0x7e, 0x235: 0x7e, 0x236: 0x7e,
	0x238: 0x7e, 0x239: 0x7e, 0x23a: 0x7e, 0x23b: 0x7e, 0x23c: 0x7e, 0x23d: 0x7e, 0x23e: 0x7e, 0x23f: 0x7e,
	// Block 0x9, offset 0x240
	0x240: 0x7e, 0x241: 0x7e, 0x242: 0x7e, 0x243: 0x7e, 0x244: 0x7e, 0x245: 0x7e, 0x246: 0x7e, 0x247: 0x7e,
	0x248: 0x7e, 0x249: 0x7e, 0x24a: 0x7e, 0x24b: 0x7e, 0x24c: 0x7e, 0x24d: 0x7e, 0x24e: 0x7e, 0x24f: 0x7e,
	0x250: 0x7e, 0x251: 0x7e, 0x252: 0x7e, 0x253: 0x7e, 0x254: 0x7e, 0x255: 0x7e, 0x256: 0x7e, 0x257: 0x7e,
	0x258: 0x7e, 0x259: 0x7e, 0x25a: 0x7e, 0x25b: 0x7e, 0x25c: 0x7e, 0x25d: 0x7e, 0x25e: 0x7e, 0x25f: 0x7e,
	0x260: 0x7e, 0x261: 0x7e, 0x262: 0x7e, 0x263: 0x7e, 0x264: 0x7e, 0x265: 0x7e, 0x266: 0x7e, 0x267: 0x7e,
	0x268: 0x7e, 0x269: 0x7e, 0x26a: 0x7e, 0x26b: 0x7e, 0x26c: 0x7e, 0x26d: 0x7e, 0x26e: 0x7e, 0x26f: 0x7e,
	0x270: 0x7e, 0x271: 0x7e, 0x272: 0x7e, 0x273: 0x7e, 0x274: 0x7e, 0x275: 0x7e, 0x276: 0x7e, 0x277: 0x7e,
	0x278: 0x7e, 0x279: 0x7e, 0x27a: 0x7e, 0x27b: 0x7e, 0x27c: 0x7e, 0x27d: 0x7e, 0x27e: 0x7e, 0x27f: 0x7e,
	// Block 0xa, offset 0x280
	0x280: 0x03, 0x281: 0x03, 0x282: 0x03, 0x283: 0x03, 0x284: 0x03, 0x285: 0x03, 0x286: 0x03, 0x287: 0x03,
	0x288: 0x03, 0x289: 0x03, 0x28a: 0x03, 0x28b: 0x03, 0x28c: 0x03, 0x28d: 0x03, 0x28e: 0x03, 0x28f: 0x03,
	0x290: 0x03, 0x291: 0x03, 0x292: 0x8b, 0x293: 0x8c, 0x294: 0x03, 0x295: 0x03, 0x296: 0x03, 0x297: 0x03,
	0x298: 0x8d, 0x299: 0x8e, 0x29a: 0x8f, 0x29b: 0x90, 0x29c: 0x91, 0x29d: 0x03, 0x29e: 0x03, 0x29f: 0x92,
	0x2a0: 0x93, 0x2a1: 0x94, 0x2a2: 0x95, 0x2a3: 0x96, 0x2a4: 0x97, 0x2a5: 0x98, 0x2a6: 0x99, 0x2a7: 0x9a,
	0x2a8: 0x9b, 0x2a9: 0x9c, 0x2aa: 0x9d, 0x2ab: 0x9e, 0x2ac: 0x9f, 0x2ad: 0xa0, 0x2ae: 0x03, 0x2af: 0xa1,
	0x2b0: 0x03, 0x2b1: 0x03, 0x2b2: 0x03, 0x2b3: 0x03, 0x2b4: 0x03, 0x2b5: 0x03, 0x2b6: 0x03, 0x2b7: 0x03,
	0x2b8: 0x03, 0x2b9: 0x03, 0x2ba: 0x03, 0x2bb: 0x03, 0x2bc: 0x03, 0x2bd: 0x03, 0x2be: 0x03, 0x2bf: 0x03,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x03, 0x2c1: 0x03, 0x2c2: 0x03, 0x2c3: 0x03, 0x2c4: 0x03, 0x2c5: 0x03, 0x2c6: 0x03, 0x2c7: 0x03,
	0x2c8: 0x03, 0x2c9: 0x03, 0x2ca: 0x03, 0x2cb: 0x03, 0x2cc: 0x03, 0x2cd: 0x03, 0x2ce: 0x03, 0x2cf: 0x03,
	0x2d0: 0x03, 0x2d1: 0x03, 0x2d2: 0x03, 0x2d3: 0x03, 0x2d4: 0x03, 0x2d5: 0x03, 0x2d6: 0x03, 0x2d7: 0x03,
	0x2d8: 0x03, 0x2d9: 0x03, 0x2da: 0x03, 0x2db: 0x03, 0x2dc: 0x03, 0x2dd: 0x03, 0x2de: 0x03, 0x2df: 0x03,
	0x2e0: 0x03, 0x2e1: 0x03, 0x2e2: 0x03, 0x2e3: 0x03, 0x2e4: 0x03, 0x2e5: 0x03, 0x2e6: 0x03, 0x2e7: 0x03,
	0x2e8: 0x03, 0x2e9: 0x03, 0x2ea: 0x03, 0x2eb: 0x03, 0x2ec: 0x03, 0x2ed: 0x03, 0x2ee: 0x03, 0x2ef: 0x03,
	0x2f0: 0x03, 0x2f1: 0x03, 0x2f2: 0x03, 0x2f3: 0x03, 0x2f4: 0x03, 0x2f5: 0x03, 0x2f6: 0x03, 0x2f7: 0x03,
	0x2f8: 0x03, 0x2f9: 0x03, 0x2fa: 0x03, 0x2fb: 0x03, 0x2fc: 0x03, 0x2fd: 0x03, 0x2fe: 0x03, 0x2ff: 0x03,
	// Block 0xc, offset 0x300
	0x300: 0x03, 0x301: 0x03, 0x302: 0x03, 0x303: 0x03, 0x304: 0x03, 0x305: 0x03, 0x306: 0x03, 0x307: 0x03,
	0x308: 0x03, 0x309: 0x03, 0x30a: 0x03, 0x30b: 0x03, 0x30c: 0x03, 0x30d: 0x03, 0x30e: 0x03, 0x30f: 0x03,
	0x310: 0x03, 0x311: 0x03, 0x312: 0x03, 0x313: 0x03, 0x314: 0x03, 0x315: 0x03, 0x316: 0x03, 0x317: 0x03,
	0x318: 0x03, 0x319: 0x03, 0x31a: 0x03, 0x31b: 0x03, 0x31c: 0x03, 0x31d: 0x03, 0x31e: 0xa2, 0x31f: 0xa3,
	// Block 0xd, offset 0x340
	0x364: 0x7e, 0x365: 0x7e, 0x366: 0x7e, 0x367: 0x7e,
	0x368: 0x7e, 0x369: 0xa4, 0x36a: 0x7e, 0x36b: 0xa5, 0x36c: 0xa6, 0x36d: 0xa7, 0x36e: 0xa8, 0x36f: 0xa9,
	0x370: 0x03, 0x371: 0x03, 0x372: 0x03, 0x373: 0x03, 0x374: 0xaa, 0x375: 0xab, 0x376: 0xac, 0x377: 0xad,
	0x378: 0xae, 0x379: 0xaf, 0x37a: 0x03, 0x37b: 0xb0, 0x37c: 0xb1, 0x37d: 0xb2, 0x37e: 0xb3, 0x37f: 0xb4,
	// Block 0xe, offset 0x380
	0x380: 0xb5, 0x381: 0xb6, 0x382: 0x03, 0x383: 0xb7, 0x385: 0xb8, 0x387: 0xb9,
	0x38a: 0xba, 0x38b: 0xbb, 0x38c: 0xbc, 0x38d: 0xbd, 0x38e: 0xbe, 0x38f: 0xbf,
	0x390: 0x03, 0x391: 0x03, 0x392: 0xc0, 0x393: 0xc1, 0x394: 0xc2, 0x395: 0xc3, 0x396: 0xc4,
	0x398: 0x03, 0x399: 0x03, 0x39a: 0x03, 0x39b: 0x03, 0x39c: 0xc5, 0x39d: 0xc6, 0x39e: 0xc7,
	0x3a0: 0xc8, 0x3a1: 0xc9, 0x3a2: 0xca, 0x3a3: 0xcb, 0x3a4: 0xcc, 0x3a6: 0xcd,
	0x3a8: 0xce, 0x3a9: 0xcf, 0x3aa: 0xd0, 0x3ab: 0xd1, 0x3ac: 0x4b, 0x3ad: 0xd2, 0x3ae: 0xd3,
	0x3b0: 0x03, 0x3b1: 0xd4, 0x3b2: 0xd5, 0x3b3: 0xd5, 0x3b4: 0xd6,
	0x3ba: 0xd7, 0x3bb: 0xd8, 0x3bc: 0xd9, 0x3bd: 0xda, 0x3be: 0xdb, 0x3bf: 0xdc,
	// Block 0xf, offset 0x3c0
	0x3c0: 0xdd, 0x3c1: 0xde, 0x3c2: 0xdf, 0x3c3: 0xe0, 0x3c4: 0xe1, 0x3c5: 0xe2, 0x3c6: 0xe3, 0x3c7: 0xe4,
	0x3c8: 0xe5, 0x3c9: 0xe6, 0x3ca: 0xe7, 0x3cb: 0xe8, 0x3cc: 0xe9, 0x3cd: 0xea,
	0x3d0: 0xeb, 0x3d1: 0xec, 0x3d2: 0xed, 0x3d3: 0xee, 0x3d6: 0xef, 0x3d7: 0xf0,
	0x3d8: 0xed, 0x3d9: 0xf1, 0x3da: 0xf2, 0x3db: 0xf3, 0x3dc: 0xf4,
	0x3e0: 0xf5, 0x3e2: 0xf6, 0x3e3: 0xf7, 0x3e4: 0xf8, 0x3e5: 0xf9, 0x3e6: 0xfa, 0x3e7: 0xfb,
	0x3e8: 0xfc, 0x3e9: 0xfd, 0x3ea: 0xfe, 0x3eb: 0x49,
	0x3f0: 0xff, 0x3f1: 0x100, 0x3f2: 0x101, 0x3f4: 0x102, 0x3f5: 0x103, 0x3f6: 0x104,
	0x3fb: 0x105, 0x3fc: 0x106, 0x3fd: 0x107, 0x3fe: 0x108,
	// Block 0x10, offset 0x400
	0x400: 0x03, 0x401: 0x03, 0x402: 0x03, 0x403: 0x03, 0x404: 0x03, 0x405: 0x03, 0x406: 0x03, 0x407: 0x03,
	0x408: 0x03, 0x409: 0x03, 0x40a: 0x03, 0x40b: 0x03, 0x40c: 0x03, 0x40d: 0x03, 0x40e: 0x109,
	0x410: 0x03, 0x411: 0x10a, 0x412: 0x03, 0x413: 0x03, 0x414: 0x03, 0x415: 0x10b,
	0x43e: 0xab, 0x43f: 0x10c,
	// Block 0x11, offset 0x440
	0x440: 0x03, 0x441: 0x03, 0x442: 0x03, 0x443: 0x03, 0x444: 0x03, 0x445: 0x03, 0x446: 0x03, 0x447: 0x03,
	0x448: 0x03, 0x449: 0x03, 0x44a: 0x03, 0x44b: 0x03, 0x44c: 0x03, 0x44d: 0x03, 0x44e: 0x03, 0x44f: 0x03,
	0x450: 0x10d, 0x451: 0x10e,
	// Block 0x12, offset 0x480
	0x490: 0x03, 0x491: 0x03, 0x492: 0x03, 0x493: 0x03, 0x494: 0x03, 0x495: 0x03, 0x496: 0x03, 0x497: 0x03,
	0x498: 0x03, 0x499: 0x10f,
	// Block 0x13, offset 0x4c0
	0x4e0: 0x03, 0x4e1: 0x03, 0x4e2: 0x03, 0x4e3: 0x03, 0x4e4: 0x03, 0x4e5: 0x03, 0x4e6: 0x03, 0x4e7: 0x03,
	0x4e8: 0x49, 0x4e9: 0x110, 0x4ea: 0x111, 0x4eb: 0x112, 0x4ec: 0x113, 0x4ed: 0x114, 0x4ee: 0x115,
	0x4f9: 0x03, 0x4fc: 0x03, 0x4fd: 0x116, 0x4fe: 0x117, 0x4ff: 0x118,
	// Block 0x14, offset 0x500
	0x53f: 0x119,
	// Block 0x15, offset 0x540
	0x540: 0x11a, 0x541: 0x7e, 0x542: 0x7e, 0x543: 0x7e, 0x544: 0x11b, 0x545: 0x11c,
	0x570: 0x03, 0x571: 0x11d, 0x572: 0x11e,
	// Block 0x16, offset 0x580
	0x5bc: 0x11f, 0x5bd: 0x120,
	// Block 0x17, offset 0x5c0
	0x5c5: 0x121, 0x5c6: 0x122,
	0x5c9: 0x123,
	0x5d0: 0x03, 0x5d1: 0x124, 0x5d2: 0x125, 0x5d3: 0x126, 0x5d4: 0x127, 0x5d5: 0x128, 0x5d6: 0x03, 0x5d7: 0x03,
	0x5d8: 0x03, 0x5d9: 0x03, 0x5da: 0x129, 0x5db: 0x12a, 0x5dc: 0x12b, 0x5dd: 0x12c, 0x5de: 0x12d, 0x5df: 0x12e,
	0x5e8: 0x12f, 0x5e9: 0x130, 0x5ea: 0x131,
	0x5fc: 0x132,
	// Block 0x18, offset 0x600
	0x600: 0x133, 0x601: 0x134, 0x602: 0x135, 0x604: 0x136, 0x605: 0x137,
	0x60a: 0x138, 0x60b: 0x139,
	0x613: 0x13a,
	0x61f: 0x13b,
	0x620: 0x03, 0x621: 0x03, 0x622: 0x03, 0x623: 0x13c, 0x624: 0x03, 0x625: 0x13d,
	0x638: 0x13e, 0x639: 0x13f, 0x63a: 0x140,
	// Block 0x19, offset 0x640
	0x640: 0x6e, 0x641: 0x6e, 0x642: 0x6e, 0x643: 0x6e, 0x644: 0x141, 0x645: 0x142, 0x646: 0x143, 0x647: 0x144,
	0x648: 0x145, 0x649: 0x146, 0x64a: 0x6e, 0x64b: 0x6e, 0x64c: 0x6e, 0x64d: 0x6e, 0x64e: 0x6e, 0x64f: 0x147,
	0x650: 0x6e, 0x651: 0x6e, 0x652: 0x6e, 0x653: 0x6e, 0x654: 0x148, 0x655: 0x149, 0x656: 0x6e, 0x657: 0x6e,
	0x658: 0x6e, 0x659: 0x14a, 0x65a: 0x6e, 0x65b: 0x6e, 0x65d: 0x14b, 0x65f: 0x14c,
	0x660: 0x14d, 0x661: 0x14e, 0x662: 0x14f, 0x663: 0x6e, 0x664: 0x150, 0x665: 0x151, 0x666: 0x6e, 0x667: 0x6e,
	0x668: 0x6e, 0x669: 0x6e, 0x66a: 0x6e, 0x66b: 0x6e, 0x66f: 0x152,
	0x670: 0x6e, 0x671: 0x6e, 0x672: 0x6e, 0x673: 0x6e, 0x674: 0x6e, 0x675: 0x6e, 0x676: 0x6e, 0x677: 0x6e,
	0x678: 0x6e, 0x679: 0x6e, 0x67a: 0x6e, 0x67b: 0x6e, 0x67c: 0x6e, 0x67d: 0x6e, 0x67e: 0x6e, 0x67f: 0x148,
	// Block 0x1a, offset 0x680
	0x680: 0x7e, 0x681: 0x7e, 0x682: 0x7e, 0x683: 0x7e, 0x684: 0x7e, 0x685: 0x7e, 0x686: 0x7e, 0x687: 0x7e,
	0x688: 0x7e, 0x689: 0x7e, 0x68a: 0x7e, 0x68b: 0x7e, 0x68c: 0x7e, 0x68d: 0x7e, 0x68e: 0x7e, 0x68f: 0x7e,
	0x690: 0x7e, 0x691: 0x7e, 0x692: 0x7e, 0x693: 0x7e, 0x694: 0x7e, 0x695: 0x7e, 0x696: 0x7e, 0x697: 0x7e,
	0x698: 0x7e, 0x699: 0x7e, 0x69a: 0x7e, 0x69b: 0x153, 0x69c: 0x7e, 0x69d: 0x7e, 0x69e: 0x7e, 0x69f: 0x7e,
	0x6a0: 0x7e, 0x6a1: 0x7e, 0x6a2: 0x7e, 0x6a3: 0x7e, 0x6a4: 0x7e, 0x6a5: 0x7e, 0x6a6: 0x7e, 0x6a7: 0x7e,
	0x6a8: 0x7e, 0x6a9: 0x7e, 0x6aa: 0x7e, 0x6ab: 0x7e, 0x6ac: 0x7e, 0x6ad: 0x7e, 0x6ae: 0x7e, 0x6af: 0x7e,
	0x6b0: 0x7e, 0x6b1: 0x7e, 0x6b2: 0x7e, 0x6b3: 0x7e, 0x6b4: 0x7e, 0x6b5: 0x7e, 0x6b6: 0x7e, 0x6b7: 0x7e,
	0x6b8: 0x7e, 0x6b9: 0x7e, 0x6ba: 0x7e, 0x6bb: 0x7e, 0x6bc: 0x7e, 0x6bd: 0x7e, 0x6be: 0x7e, 0x6bf: 0x7e,
	// Block 0x1b, offset 0x6c0
	0x6c0: 0x7e, 0x6c1: 0x7e, 0x6c2: 0x7e, 0x6c3: 0x7e, 0x6c4: 0x7e, 0x6c5: 0x7e, 0x6c6: 0x7e, 0x6c7: 0x7e,
	0x6c8: 0x7e, 0x6c9: 0x7e, 0x6ca: 0x7e, 0x6cb: 0x7e, 0x6cc: 0x7e, 0x6cd: 0x7e, 0x6ce: 0x7e, 0x6cf: 0x7e,
	0x6d0: 0x7e, 0x6d1: 0x7e, 0x6d2: 0x7e, 0x6d3: 0x7e, 0x6d4: 0x7e, 0x6d5: 0x7e, 0x6d6: 0x7e, 0x6d7: 0x7e,
	0x6d8: 0x7e, 0x6d9: 0x7e, 0x6da: 0x7e, 0x6db: 0x7e, 0x6dc: 0x154, 0x6dd: 0x7e, 0x6de: 0x7e, 0x6df: 0x7e,
	0x6e0: 0x155, 0x6e1: 0x7e, 0x6e2: 0x7e, 0x6e3: 0x7e, 0x6e4: 0x7e, 0x6e5: 0x7e, 0x6e6: 0x7e, 0x6e7: 0x7e,
	0x6e8: 0x7e, 0x6e9: 0x7e, 0x6ea: 0x7e, 0x6eb: 0x7e, 0x6ec: 0x7e, 0x6ed: 0x7e, 0x6ee: 0x7e, 0x6ef: 0x7e,
	0x6f0: 0x7e, 0x6f1: 0x7e, 0x6f2: 0x7e, 0x6f3: 0x7e, 0x6f4: 0x7e, 0x6f5: 0x7e, 0x6f6: 0x7e, 0x6f7: 0x7e,
	0x6f8: 0x7e, 0x6f9: 0x7e, 0x6fa: 0x7e, 0x6fb: 0x7e, 0x6fc: 0x7e, 0x6fd: 0x7e, 0x6fe: 0x7e, 0x6ff: 0x7e,
	// Block 0x1c, offset 0x700
	0x700: 0x7e, 0x701: 0x7e, 0x702: 0x7e, 0x703: 0x7e, 0x704: 0x7e, 0x705: 0x7e, 0x706: 0x7e, 0x707: 0x7e,
	0x708: 0x7e, 0x709: 0x7e, 0x70a: 0x7e, 0x70b: 0x7e, 0x70c: 0x7e, 0x70d: 0x7e, 0x70e: 0x7e, 0x70f: 0x7e,
	0x710: 0x7e, 0x711: 0x7e, 0x712: 0x7e, 0x713: 0x7e, 0x714: 0x7e, 0x715: 0x7e, 0x716: 0x7e, 0x717: 0x7e,
	0x718: 0x7e, 0x719: 0x7e, 0x71a: 0x7e, 0x71b: 0x7e, 0x71c: 0x7e, 0x71d: 0x7e, 0x71e: 0x7e, 0x71f: 0x7e,
	0x720: 0x7e, 0x721: 0x7e, 0x722: 0x7e, 0x723: 0x7e, 0x724: 0x7e, 0x725: 0x7e, 0x726: 0x7e, 0x727: 0x7e,
	0x728: 0x7e, 0x729: 0x7e, 0x72a: 0x7e, 0x72b: 0x7e, 0x72c: 0x7e, 0x72d: 0x7e, 0x72e: 0x7e, 0x72f: 0x7e,
	0x730: 0x7e, 0x731: 0x7e, 0x732: 0x7e, 0x733: 0x7e, 0x734: 0x7e, 0x735: 0x7e, 0x736: 0x7e, 0x737: 0x7e,
	0x738: 0x7e, 0x739: 0x7e, 0x73a: 0x156, 0x73b: 0x7e, 0x73c: 0x7e, 0x73d: 0x7e, 0x73e: 0x7e, 0x73f: 0x7e,
	// Block 0x1d, offset 0x740
	0x740: 0x7e, 0x741: 0x7e, 0x742: 0x7e, 0x743: 0x7e, 0x744: 0x7e, 0x745: 0x7e, 0x746: 0x7e, 0x747: 0x7e,
	0x748: 0x7e, 0x749: 0x7e, 0x74a: 0x7e, 0x74b: 0x7e, 0x74c: 0x7e, 0x74d: 0x7e, 0x74e: 0x7e, 0x74f: 0x7e,
	0x750: 0x7e, 0x751: 0x7e, 0x752: 0x7e, 0x753: 0x7e, 0x754: 0x7e, 0x755: 0x7e, 0x756: 0x7e, 0x757: 0x7e,
	0x758: 0x7e, 0x759: 0x7e, 0x75a: 0x7e, 0x75b: 0x7e, 0x75c: 0x7e, 0x75d: 0x7e, 0x75e: 0x7e, 0x75f: 0x7e,
	0x760: 0x7e, 0x761: 0x7e, 0x762: 0x7e, 0x763: 0x7e, 0x764: 0x7e, 0x765: 0x7e, 0x766: 0x7e, 0x767: 0x7e,
	0x768: 0x7e, 0x769: 0x7e, 0x76a: 0x7e, 0x76b: 0x7e, 0x76c: 0x7e, 0x76d: 0x7e, 0x76e: 0x7e, 0x76f: 0x157,
	// Block 0x1e, offset 0x780
	0x7a0: 0x7e, 0x7a1: 0x7e, 0x7a2: 0x7e, 0x7a3: 0x7e, 0x7a4: 0x7e, 0x7a5: 0x7e, 0x7a6: 0x7e, 0x7a7: 0x7e,
	0x7a8: 0x158,
	// Block 0x1f, offset 0x7c0
	0x7c0: 0x7e, 0x7c1: 0x7e, 0x7c2: 0x7e, 0x7c3: 0x7e, 0x7c4: 0x7e, 0x7c5: 0x7e, 0x7c6: 0x7e, 0x7c7: 0x7e,
	0x7c8: 0x7e, 0x7c9: 0x7e, 0x7ca: 0x7e, 0x7cb: 0x7e, 0x7cc: 0x7e, 0x7cd: 0x159, 0x7ce: 0x7e, 0x7cf: 0x7e,
	0x7d0: 0x7e, 0x7d1: 0x7e, 0x7d2: 0x7e, 0x7d3: 0x7e, 0x7d4: 0x7e, 0x7d5: 0x7e, 0x7d6: 0x7e, 0x7d7: 0x7e,
	0x7d8: 0x7e, 0x7d9: 0x7e, 0x7da: 0x7e, 0x7db: 0x7e, 0x7dc: 0x7e, 0x7dd: 0x7e, 0x7de: 0x7e, 0x7df: 0x7e,
	0x7e0: 0x7e, 0x7e1: 0x7e, 0x7e2: 0x7e, 0x7e3: 0x7e, 0x7e4: 0x7e, 0x7e5: 0x7e, 0x7e6: 0x7e, 0x7e7: 0x7e,
	0x7e8: 0x7e, 0x7e9: 0x7e, 0x7ea: 0x7e, 0x7eb: 0x7e, 0x7ec: 0x7e, 0x7ed: 0x7e, 0x7ee: 0x7e, 0x7ef: 0x7e,
	0x7f0: 0x7e, 0x7f1: 0x7e, 0x7f2: 0x7e, 0x7f3: 0x7e, 0x7f4: 0x7e, 0x7f5: 0x7e, 0x7f6: 0x7e, 0x7f7: 0x7e,
	0x7f8: 0x7e, 0x7f9: 0x7e, 0x7fa: 0x7e, 0x7fb: 0x7e, 0x7fc: 0x7e, 0x7fd: 0x7e, 0x7fe: 0x7e, 0x7ff: 0x7e,
	// Block 0x20, offset 0x800
	0x800: 0x7e, 0x801: 0x7e, 0x802: 0x7e, 0x803: 0x7e, 0x804: 0x7e, 0x805: 0x7e, 0x806: 0x7e, 0x807: 0x7e,
	0x808: 0x7e, 0x809: 0x7e, 0x80a: 0x7e, 0x80b: 0x7e, 0x80c: 0x7e, 0x80d: 0x7e, 0x80e: 0x15a,
	// Block 0x21, offset 0x840
	0x850: 0x0c, 0x851: 0x0d, 0x852: 0x0e, 0x853: 0x0f, 0x854: 0x10, 0x856: 0x11,
	0x85a: 0x12, 0x85b: 0x13, 0x85c: 0x14, 0x85d: 0x15, 0x85e: 0x16, 0x85f: 0x17,
	0x860: 0x07, 0x861: 0x07, 0x862: 0x07, 0x863: 0x07, 0x864: 0x07, 0x865: 0x07, 0x866: 0x07, 0x867: 0x07,
	0x868: 0x07, 0x869: 0x07, 0x86a: 0x18, 0x86b: 0x19, 0x86c: 0x1a, 0x86d: 0x07, 0x86e: 0x1b, 0x86f: 0x1c,
	0x870: 0x07, 0x871: 0x1d, 0x872: 0x1e,
	// Block 0x22, offset 0x880
	0x880: 0x15b, 0x881: 0x05, 0x884: 0x05, 0x885: 0x05, 0x886: 0x05, 0x887: 0x15c,
	// Block 0x23, offset 0x8c0
	0x8e0: 0x20,
}
