# seccomp-profiler

seccomp-profiler reads Go binaries compiled for Linux (amd64 and 386 only) to
determine what system calls it uses. Then it generates a whitelist seccomp
profile for the binary.

It can output the whitelist as either Go code or YAML (by using `-format=code`
or `-format=config`).

## Usage

`go get -u github.com/elastic/go-seccomp-bpf/cmd/seccomp-profiler`

Now run the tool against a Go binary.

```
$ seccomp-profiler metricbeat > seccomp_linux_amd64.go
2018/05/01 11:49:56 Binary file: metricbeat
2018/05/01 11:49:56 Binary is dynamically linked with libpthread.so.0, libdl.so.2, libc.so.6
2018/05/01 11:49:56 Detected architecture: x86_64
2018/05/01 11:49:56 SHA256: 4ccbb96a122c69042c3345d58f6957f90b9c30d9535a46b2109d84fb33c851b1
2018/05/01 11:49:56 Using cached objdump.
2018/05/01 11:49:56 Objdump File: /Users/akroh/.seccomp-profiler/metricbeat-5f70d335eb
2018/05/01 11:49:58 Found 268 total syscalls
2018/05/01 11:49:58 Found 93 unique syscalls
```

This will write seccomp policy that whitelists the system calls found in the
binary's object code.

```go
// Code generated by seccomp-profiler - DO NOT EDIT.

// +build linux,amd64

package main

import (
    "github.com/elastic/go-seccomp-bpf"
)

var SeccompProfile = seccomp.Policy{
    DefaultAction: seccomp.ActionErrno,
    Syscalls: []seccomp.SyscallGroup{
        {
            Action: seccomp.ActionAllow,
            Names:  []string{
                "accept",
                "accept4",
                "arch_prctl",
                "bind",
                "brk",
                "chdir",
                "chroot",
                "clone",
                "close",
                "connect",
                "dup",
                "dup2",
                "epoll_create",
                "epoll_create1",
                "epoll_ctl",
                "epoll_wait",
                "execve",
                "exit",
                "exit_group",
                "fchdir",
                "fchmod",
                "fchown",
                "fcntl",
                "fstat",
                "fsync",
                "ftruncate",
                "futex",
                "getcwd",
                "getdents64",
                "geteuid",
                "getgid",
                "getpeername",
                "getpid",
                "getppid",
                "getrandom",
                "getrusage",
                "getsockname",
                "getsockopt",
                "gettid",
                "getuid",
                "ioctl",
                "kill",
                "listen",
                "lseek",
                "lstat",
                "madvise",
                "mincore",
                "mkdirat",
                "mmap",
                "mount",
                "munmap",
                "open",
                "openat",
                "pipe",
                "pipe2",
                "prctl",
                "pread64",
                "pselect6",
                "ptrace",
                "pwrite64",
                "read",
                "readlinkat",
                "recvfrom",
                "recvmsg",
                "renameat",
                "rt_sigaction",
                "rt_sigprocmask",
                "rt_sigreturn",
                "sched_getaffinity",
                "sched_yield",
                "sendfile",
                "sendmsg",
                "sendto",
                "setgid",
                "setgroups",
                "setitimer",
                "setpgid",
                "setsid",
                "setsockopt",
                "setuid",
                "shutdown",
                "sigaltstack",
                "socket",
                "stat",
                "statfs",
                "sysinfo",
                "tkill",
                "unlinkat",
                "unshare",
                "wait4",
                "waitid",
                "write",
                "writev",
            },
        },
    },
}
```

### Filtering

If there are system calls that you wish to remove from the policy you can use
the `-b` flag to blacklist system calls. The system call will always be
filtered from the policy that is generated. The number of filtered system calls
will be logged in the output.

```sh
seccomp-profiler -b "execve fork vfork ptrace" metricbeat
...
2018/05/01 12:00:10 Filtered 2 blacklisted syscalls
...
```
