# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_qos_elements(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-elements - based on the path /openconfig-qos-elements. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines configuration and operational state
data associated with QoS elements.  The primary elements of
the model include:

 classifiers: match packets with a specific characteristic

 forwarding groups: logical class of packets that receive
 common forwarding treatment

 queues:  collection of packets to be scheduled, including
 a queue management scheme

 schedulers: sequence of one more elements that schedule
 packets for transmission, including policer and shaper
 functions
  """
  _pyangbind_elements = {}

  

class openconfig_qos_mem_mgmt(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-mem-mgmt - based on the path /openconfig-qos-mem-mgmt. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines configuration and operational state
data associated related to queue management features of QoS
particularly:

- buffer-allocation-profiles: these profiles are applied on
 a per-interface basis, and determine how memory is to be managed
 across the queues that are instantiated on the system.

- queue-management-profiles: these profiles are applied on a per-interface
 per-queue basis, and determine how packets are marked/dropped within
 the queue instantiation.
  """
  _pyangbind_elements = {}

  

class openconfig_qos_elements(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-elements - based on the path /openconfig-qos-elements. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines configuration and operational state
data associated with QoS elements.  The primary elements of
the model include:

 classifiers: match packets with a specific characteristic

 forwarding groups: logical class of packets that receive
 common forwarding treatment

 queues:  collection of packets to be scheduled, including
 a queue management scheme

 schedulers: sequence of one more elements that schedule
 packets for transmission, including policer and shaper
 functions
  """
  _pyangbind_elements = {}

  

class openconfig_qos_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-interfaces - based on the path /openconfig-qos-interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines data related to quality-of-service
configuration and operational state associated with
interfaces.
  """
  _pyangbind_elements = {}

  

class openconfig_qos_elements(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-elements - based on the path /openconfig-qos-elements. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines configuration and operational state
data associated with QoS elements.  The primary elements of
the model include:

 classifiers: match packets with a specific characteristic

 forwarding groups: logical class of packets that receive
 common forwarding treatment

 queues:  collection of packets to be scheduled, including
 a queue management scheme

 schedulers: sequence of one more elements that schedule
 packets for transmission, including policer and shaper
 functions
  """
  _pyangbind_elements = {}

  

class openconfig_qos_mem_mgmt(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-mem-mgmt - based on the path /openconfig-qos-mem-mgmt. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines configuration and operational state
data associated related to queue management features of QoS
particularly:

- buffer-allocation-profiles: these profiles are applied on
 a per-interface basis, and determine how memory is to be managed
 across the queues that are instantiated on the system.

- queue-management-profiles: these profiles are applied on a per-interface
 per-queue basis, and determine how packets are marked/dropped within
 the queue instantiation.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_qos__qos_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_id',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'config']

  def _get_interface_id(self):
    """
    Getter method for interface_id, mapped from YANG variable /qos/interfaces/interface/config/interface_id (string)

    YANG Description: Identifier for the interface.
    """
    return self.__interface_id
      
  def _set_interface_id(self, v, load=False):
    """
    Setter method for interface_id, mapped from YANG variable /qos/interfaces/interface/config/interface_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_id() directly.

    YANG Description: Identifier for the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_id(self):
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

  interface_id = __builtin__.property(_get_interface_id, _set_interface_id)


  _pyangbind_elements = OrderedDict([('interface_id', interface_id), ])


class yc_state_openconfig_qos__qos_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_id',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'state']

  def _get_interface_id(self):
    """
    Getter method for interface_id, mapped from YANG variable /qos/interfaces/interface/state/interface_id (string)

    YANG Description: Identifier for the interface.
    """
    return self.__interface_id
      
  def _set_interface_id(self, v, load=False):
    """
    Setter method for interface_id, mapped from YANG variable /qos/interfaces/interface/state/interface_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_id() directly.

    YANG Description: Identifier for the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_id(self):
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

  interface_id = __builtin__.property(_get_interface_id)


  _pyangbind_elements = OrderedDict([('interface_id', interface_id), ])


class yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /qos/interfaces/interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /qos/interfaces/interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /qos/interfaces/interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /qos/interfaces/interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /qos/interfaces/interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /qos/interfaces/interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /qos/interfaces/interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /qos/interfaces/interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for QoS on ingress interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__buffer_allocation_profile','__multicast_buffer_allocation_profile','__unicast_buffer_allocation_profile',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'config']

  def _get_buffer_allocation_profile(self):
    """
    Getter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the input (rx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    return self.__buffer_allocation_profile
      
  def _set_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the input (rx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_buffer_allocation_profile(self):
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_multicast_buffer_allocation_profile(self):
    """
    Getter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/multicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__multicast_buffer_allocation_profile
      
  def _set_multicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/multicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__multicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_buffer_allocation_profile(self):
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_unicast_buffer_allocation_profile(self):
    """
    Getter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/unicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__unicast_buffer_allocation_profile
      
  def _set_unicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/unicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__unicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_buffer_allocation_profile(self):
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  buffer_allocation_profile = __builtin__.property(_get_buffer_allocation_profile, _set_buffer_allocation_profile)
  multicast_buffer_allocation_profile = __builtin__.property(_get_multicast_buffer_allocation_profile, _set_multicast_buffer_allocation_profile)
  unicast_buffer_allocation_profile = __builtin__.property(_get_unicast_buffer_allocation_profile, _set_unicast_buffer_allocation_profile)


  _pyangbind_elements = OrderedDict([('buffer_allocation_profile', buffer_allocation_profile), ('multicast_buffer_allocation_profile', multicast_buffer_allocation_profile), ('unicast_buffer_allocation_profile', unicast_buffer_allocation_profile), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for QoS on ingress interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__buffer_allocation_profile','__multicast_buffer_allocation_profile','__unicast_buffer_allocation_profile',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'state']

  def _get_buffer_allocation_profile(self):
    """
    Getter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the input (rx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    return self.__buffer_allocation_profile
      
  def _set_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the input (rx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_buffer_allocation_profile(self):
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_multicast_buffer_allocation_profile(self):
    """
    Getter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/multicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__multicast_buffer_allocation_profile
      
  def _set_multicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/multicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__multicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_buffer_allocation_profile(self):
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_unicast_buffer_allocation_profile(self):
    """
    Getter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/unicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__unicast_buffer_allocation_profile
      
  def _set_unicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/unicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__unicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_buffer_allocation_profile(self):
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  buffer_allocation_profile = __builtin__.property(_get_buffer_allocation_profile)
  multicast_buffer_allocation_profile = __builtin__.property(_get_multicast_buffer_allocation_profile)
  unicast_buffer_allocation_profile = __builtin__.property(_get_unicast_buffer_allocation_profile)


  _pyangbind_elements = OrderedDict([('buffer_allocation_profile', buffer_allocation_profile), ('multicast_buffer_allocation_profile', multicast_buffer_allocation_profile), ('unicast_buffer_allocation_profile', unicast_buffer_allocation_profile), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for the list of classifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config/name (leafref)

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config/type (enumeration)

    YANG Description: Type of packets matched by the classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of packets matched by the classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters for the list of classifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state/name (leafref)

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state/type (enumeration)

    YANG Description: Type of packets matched by the classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of packets matched by the classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/terms/term/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for match terms in the classifier
associated with an interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__matched_packets','__matched_octets',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'terms', 'term', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/id (leafref)

    YANG Description: Reference to match terms in the classifier
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to match terms in the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_matched_packets(self):
    """
    Getter method for matched_packets, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/matched_packets (oc-yang:counter64)

    YANG Description: Count of the number of packets matching this classifier
match term on the interface.
    """
    return self.__matched_packets
      
  def _set_matched_packets(self, v, load=False):
    """
    Setter method for matched_packets, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/matched_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_packets() directly.

    YANG Description: Count of the number of packets matching this classifier
match term on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_packets(self):
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_matched_octets(self):
    """
    Getter method for matched_octets, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/matched_octets (oc-yang:counter64)

    YANG Description: Count of the number of octets (bytes) matching this
classifier match term on the interface.
    """
    return self.__matched_octets
      
  def _set_matched_octets(self, v, load=False):
    """
    Setter method for matched_octets, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/matched_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_octets() directly.

    YANG Description: Count of the number of octets (bytes) matching this
classifier match term on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_octets(self):
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  id = __builtin__.property(_get_id)
  matched_packets = __builtin__.property(_get_matched_packets)
  matched_octets = __builtin__.property(_get_matched_octets)


  _pyangbind_elements = OrderedDict([('id', id), ('matched_packets', matched_packets), ('matched_octets', matched_octets), ])


class yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/terms/term. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of match terms in the classifier associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state',)

  _yang_name = 'term'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'terms', 'term']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/id (leafref)

    YANG Description: Reference to match term id list key
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to match term id list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state (container)

    YANG Description: Operational state data for match terms in the classifier
associated with an interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for match terms in the classifier
associated with an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ])


class yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/terms. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of match terms in the
classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__term',)

  _yang_name = 'terms'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'terms']

  def _get_term(self):
    """
    Getter method for term, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term (list)

    YANG Description: List of match terms in the classifier associated with the
interface
    """
    return self.__term
      
  def _set_term(self, v, load=False):
    """
    Setter method for term, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_term is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_term() directly.

    YANG Description: List of match terms in the classifier associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """term must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__term = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_term(self):
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  term = __builtin__.property(_get_term, _set_term)


  _pyangbind_elements = OrderedDict([('term', term), ])


class yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A list of classifiers that should be applied to the interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__config','__state','__terms',)

  _yang_name = 'classifier'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/type (leafref)

    YANG Description: Reference to the classifier name.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the classifier name.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config (container)

    YANG Description: Configuration parameters for the list of classifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters for the list of classifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state (container)

    YANG Description: Operational state parameters for the list of classifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters for the list of classifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_terms(self):
    """
    Getter method for terms, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms (container)

    YANG Description: Enclosing container for the list of match terms in the
classifier
    """
    return self.__terms
      
  def _set_terms(self, v, load=False):
    """
    Setter method for terms, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_terms is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_terms() directly.

    YANG Description: Enclosing container for the list of match terms in the
classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """terms must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__terms = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_terms(self):
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  type = __builtin__.property(_get_type, _set_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  terms = __builtin__.property(_get_terms, _set_terms)


  _pyangbind_elements = OrderedDict([('type', type), ('config', config), ('state', state), ('terms', terms), ])


class yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Classifiers to be applied to the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__classifier',)

  _yang_name = 'classifiers'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__classifier = YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers']

  def _get_classifier(self):
    """
    Getter method for classifier, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier (list)

    YANG Description: A list of classifiers that should be applied to the interface
    """
    return self.__classifier
      
  def _set_classifier(self, v, load=False):
    """
    Setter method for classifier, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifier() directly.

    YANG Description: A list of classifiers that should be applied to the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifier must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__classifier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifier(self):
    self.__classifier = YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  classifier = __builtin__.property(_get_classifier, _set_classifier)


  _pyangbind_elements = OrderedDict([('classifier', classifier), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/queues/queue/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__queue_management_profile',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'queues', 'queue', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)


  def _get_queue_management_profile(self):
    """
    Getter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config/queue_management_profile (leafref)

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    return self.__queue_management_profile
      
  def _set_queue_management_profile(self, v, load=False):
    """
    Setter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config/queue_management_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_management_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_management_profile() directly.

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_management_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__queue_management_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_management_profile(self):
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  queue_management_profile = __builtin__.property(_get_queue_management_profile, _set_queue_management_profile)


  _pyangbind_elements = OrderedDict([('name', name), ('queue_management_profile', queue_management_profile), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/queues/queue/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__queue_management_profile','__max_queue_len','__avg_queue_len','__transmit_pkts','__transmit_octets','__dropped_pkts','__dropped_octets',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'queues', 'queue', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)


  def _get_queue_management_profile(self):
    """
    Getter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/queue_management_profile (leafref)

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    return self.__queue_management_profile
      
  def _set_queue_management_profile(self, v, load=False):
    """
    Setter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/queue_management_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_management_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_management_profile() directly.

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_management_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__queue_management_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_management_profile(self):
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_max_queue_len(self):
    """
    Getter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/max_queue_len (oc-yang:counter64)

    YANG Description: Maximum observed queue length
    """
    return self.__max_queue_len
      
  def _set_max_queue_len(self, v, load=False):
    """
    Setter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/max_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_queue_len() directly.

    YANG Description: Maximum observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__max_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_queue_len(self):
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_avg_queue_len(self):
    """
    Getter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/avg_queue_len (oc-yang:counter64)

    YANG Description: Average observed queue length
    """
    return self.__avg_queue_len
      
  def _set_avg_queue_len(self, v, load=False):
    """
    Setter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/avg_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg_queue_len() directly.

    YANG Description: Average observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__avg_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg_queue_len(self):
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_pkts(self):
    """
    Getter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/transmit_pkts (oc-yang:counter64)

    YANG Description: Number of packets transmitted by this queue
    """
    return self.__transmit_pkts
      
  def _set_transmit_pkts(self, v, load=False):
    """
    Setter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/transmit_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_pkts() directly.

    YANG Description: Number of packets transmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_pkts(self):
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_octets(self):
    """
    Getter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/transmit_octets (oc-yang:counter64)

    YANG Description: Number of octets trasmitted by this queue
    """
    return self.__transmit_octets
      
  def _set_transmit_octets(self, v, load=False):
    """
    Setter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/transmit_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_octets() directly.

    YANG Description: Number of octets trasmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_octets(self):
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_pkts(self):
    """
    Getter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/dropped_pkts (oc-yang:counter64)

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    return self.__dropped_pkts
      
  def _set_dropped_pkts(self, v, load=False):
    """
    Setter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/dropped_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_pkts() directly.

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_pkts(self):
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_octets(self):
    """
    Getter method for dropped_octets, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/dropped_octets (oc-yang:counter64)

    YANG Description: Number of octets dropped by the queue due to overrun
    """
    return self.__dropped_octets
      
  def _set_dropped_octets(self, v, load=False):
    """
    Setter method for dropped_octets, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/dropped_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_octets() directly.

    YANG Description: Number of octets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_octets(self):
    self.__dropped_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  name = __builtin__.property(_get_name)
  queue_management_profile = __builtin__.property(_get_queue_management_profile)
  max_queue_len = __builtin__.property(_get_max_queue_len)
  avg_queue_len = __builtin__.property(_get_avg_queue_len)
  transmit_pkts = __builtin__.property(_get_transmit_pkts)
  transmit_octets = __builtin__.property(_get_transmit_octets)
  dropped_pkts = __builtin__.property(_get_dropped_pkts)
  dropped_octets = __builtin__.property(_get_dropped_octets)


  _pyangbind_elements = OrderedDict([('name', name), ('queue_management_profile', queue_management_profile), ('max_queue_len', max_queue_len), ('avg_queue_len', avg_queue_len), ('transmit_pkts', transmit_pkts), ('transmit_octets', transmit_octets), ('dropped_pkts', dropped_pkts), ('dropped_octets', dropped_octets), ])


class yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/queues/queue. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for the queue associated with this
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'queue'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'queues', 'queue']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/name (leafref)

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config (container)

    YANG Description: Configuration data for the queue associated with the
interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state (container)

    YANG Description: Operational state data for the queue associated with the
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_queues_openconfig_qos__qos_interfaces_interface_input_queues(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/queues. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__queue',)

  _yang_name = 'queues'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'queues']

  def _get_queue(self):
    """
    Getter method for queue, mapped from YANG variable /qos/interfaces/interface/input/queues/queue (list)

    YANG Description: Top-level container for the queue associated with this
interface
    """
    return self.__queue
      
  def _set_queue(self, v, load=False):
    """
    Setter method for queue, mapped from YANG variable /qos/interfaces/interface/input/queues/queue (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue() directly.

    YANG Description: Top-level container for the queue associated with this
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue(self):
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  queue = __builtin__.property(_get_queue, _set_queue)


  _pyangbind_elements = OrderedDict([('queue', queue), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/config/name (leafref)

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/state/name (leafref)

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  name = __builtin__.property(_get_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/schedulers/scheduler/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to the scheduler
policy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__conforming_pkts','__conforming_octets','__exceeding_pkts','__exceeding_octets','__violating_pkts','__violating_octets',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__conforming_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__conforming_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__exceeding_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__exceeding_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__violating_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__violating_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'schedulers', 'scheduler', 'state']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/sequence (leafref)

    YANG Description: Reference to the sequence ID of the scheduler within
the current scheduler policy.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/sequence (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Reference to the sequence ID of the scheduler within
the current scheduler policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_conforming_pkts(self):
    """
    Getter method for conforming_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/conforming_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered conforming by
the scheduler.
    """
    return self.__conforming_pkts
      
  def _set_conforming_pkts(self, v, load=False):
    """
    Setter method for conforming_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/conforming_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conforming_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conforming_pkts() directly.

    YANG Description: The number of packets that were considered conforming by
the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conforming_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__conforming_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conforming_pkts(self):
    self.__conforming_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_conforming_octets(self):
    """
    Getter method for conforming_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/conforming_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
conforming by the scheduler.
    """
    return self.__conforming_octets
      
  def _set_conforming_octets(self, v, load=False):
    """
    Setter method for conforming_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/conforming_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conforming_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conforming_octets() directly.

    YANG Description: The number of octets in packets that were considered
conforming by the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conforming_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__conforming_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conforming_octets(self):
    self.__conforming_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_exceeding_pkts(self):
    """
    Getter method for exceeding_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/exceeding_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered exceeding by
the scheduler.
    """
    return self.__exceeding_pkts
      
  def _set_exceeding_pkts(self, v, load=False):
    """
    Setter method for exceeding_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/exceeding_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exceeding_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exceeding_pkts() directly.

    YANG Description: The number of packets that were considered exceeding by
the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exceeding_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__exceeding_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exceeding_pkts(self):
    self.__exceeding_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_exceeding_octets(self):
    """
    Getter method for exceeding_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/exceeding_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
exceeding by the scheduler.
    """
    return self.__exceeding_octets
      
  def _set_exceeding_octets(self, v, load=False):
    """
    Setter method for exceeding_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/exceeding_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exceeding_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exceeding_octets() directly.

    YANG Description: The number of octets in packets that were considered
exceeding by the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exceeding_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__exceeding_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exceeding_octets(self):
    self.__exceeding_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_violating_pkts(self):
    """
    Getter method for violating_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/violating_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered violating by
the policer.
    """
    return self.__violating_pkts
      
  def _set_violating_pkts(self, v, load=False):
    """
    Setter method for violating_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/violating_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_violating_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_violating_pkts() directly.

    YANG Description: The number of packets that were considered violating by
the policer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """violating_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__violating_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_violating_pkts(self):
    self.__violating_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_violating_octets(self):
    """
    Getter method for violating_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/violating_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
violating by the policer.
    """
    return self.__violating_octets
      
  def _set_violating_octets(self, v, load=False):
    """
    Setter method for violating_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/violating_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_violating_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_violating_octets() directly.

    YANG Description: The number of octets in packets that were considered
violating by the policer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """violating_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__violating_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_violating_octets(self):
    self.__violating_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  sequence = __builtin__.property(_get_sequence)
  conforming_pkts = __builtin__.property(_get_conforming_pkts)
  conforming_octets = __builtin__.property(_get_conforming_octets)
  exceeding_pkts = __builtin__.property(_get_exceeding_pkts)
  exceeding_octets = __builtin__.property(_get_exceeding_octets)
  violating_pkts = __builtin__.property(_get_violating_pkts)
  violating_octets = __builtin__.property(_get_violating_octets)


  _pyangbind_elements = OrderedDict([('sequence', sequence), ('conforming_pkts', conforming_pkts), ('conforming_octets', conforming_octets), ('exceeding_pkts', exceeding_pkts), ('exceeding_octets', exceeding_octets), ('violating_pkts', violating_pkts), ('violating_octets', violating_octets), ])


class yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/schedulers/scheduler. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__state',)

  _yang_name = 'scheduler'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'schedulers', 'scheduler']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/sequence (leafref)

    YANG Description: Reference to the sequence ID for the scheduler.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/sequence (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Reference to the sequence ID for the scheduler.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state (container)

    YANG Description: Operational state parameters relating to the scheduler
policy.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to the scheduler
policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

  sequence = __builtin__.property(_get_sequence)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('sequence', sequence), ('state', state), ])


class yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/schedulers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Schedulers within the applied scheduler-policy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__scheduler',)

  _yang_name = 'schedulers'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__scheduler = YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'schedulers']

  def _get_scheduler(self):
    """
    Getter method for scheduler, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler (list)

    YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
    """
    return self.__scheduler
      
  def _set_scheduler(self, v, load=False):
    """
    Setter method for scheduler, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scheduler is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scheduler() directly.

    YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scheduler must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)""",
        })

    self.__scheduler = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scheduler(self):
    self.__scheduler = YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)

  scheduler = __builtin__.property(_get_scheduler)


  _pyangbind_elements = OrderedDict([('scheduler', scheduler), ])


class yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Scheduler policy associated with the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__schedulers',)

  _yang_name = 'scheduler-policy'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__schedulers = YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/config (container)

    YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/state (container)

    YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_schedulers(self):
    """
    Getter method for schedulers, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers (container)

    YANG Description: Schedulers within the applied scheduler-policy.
    """
    return self.__schedulers
      
  def _set_schedulers(self, v, load=False):
    """
    Setter method for schedulers, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_schedulers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_schedulers() directly.

    YANG Description: Schedulers within the applied scheduler-policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """schedulers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__schedulers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_schedulers(self):
    self.__schedulers = YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  schedulers = __builtin__.property(_get_schedulers, _set_schedulers)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('schedulers', schedulers), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to the interface
for which the VOQs are instantiated.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/config/name (string)

    YANG Description: Name used to refer to the egress interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name used to refer to the egress interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to the interface
for which the VOQs are instantiated.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/state/name (string)

    YANG Description: Name used to refer to the egress interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name used to refer to the egress interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

  name = __builtin__.property(_get_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/queues/queue/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'queues', 'queue', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/config/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/queues/queue/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__max_queue_len','__avg_queue_len','__transmit_pkts','__transmit_octets','__dropped_pkts','__dropped_octets',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'queues', 'queue', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)


  def _get_max_queue_len(self):
    """
    Getter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/max_queue_len (oc-yang:counter64)

    YANG Description: Maximum observed queue length
    """
    return self.__max_queue_len
      
  def _set_max_queue_len(self, v, load=False):
    """
    Setter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/max_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_queue_len() directly.

    YANG Description: Maximum observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__max_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_queue_len(self):
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_avg_queue_len(self):
    """
    Getter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/avg_queue_len (oc-yang:counter64)

    YANG Description: Average observed queue length
    """
    return self.__avg_queue_len
      
  def _set_avg_queue_len(self, v, load=False):
    """
    Setter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/avg_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg_queue_len() directly.

    YANG Description: Average observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__avg_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg_queue_len(self):
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_pkts(self):
    """
    Getter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/transmit_pkts (oc-yang:counter64)

    YANG Description: Number of packets transmitted by this queue
    """
    return self.__transmit_pkts
      
  def _set_transmit_pkts(self, v, load=False):
    """
    Setter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/transmit_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_pkts() directly.

    YANG Description: Number of packets transmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_pkts(self):
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_octets(self):
    """
    Getter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/transmit_octets (oc-yang:counter64)

    YANG Description: Number of octets trasmitted by this queue
    """
    return self.__transmit_octets
      
  def _set_transmit_octets(self, v, load=False):
    """
    Setter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/transmit_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_octets() directly.

    YANG Description: Number of octets trasmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_octets(self):
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_pkts(self):
    """
    Getter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/dropped_pkts (oc-yang:counter64)

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    return self.__dropped_pkts
      
  def _set_dropped_pkts(self, v, load=False):
    """
    Setter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/dropped_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_pkts() directly.

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_pkts(self):
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_octets(self):
    """
    Getter method for dropped_octets, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/dropped_octets (oc-yang:counter64)

    YANG Description: Number of octets dropped by the queue due to overrun
    """
    return self.__dropped_octets
      
  def _set_dropped_octets(self, v, load=False):
    """
    Setter method for dropped_octets, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/dropped_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_octets() directly.

    YANG Description: Number of octets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_octets(self):
    self.__dropped_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  name = __builtin__.property(_get_name)
  max_queue_len = __builtin__.property(_get_max_queue_len)
  avg_queue_len = __builtin__.property(_get_avg_queue_len)
  transmit_pkts = __builtin__.property(_get_transmit_pkts)
  transmit_octets = __builtin__.property(_get_transmit_octets)
  dropped_pkts = __builtin__.property(_get_dropped_pkts)
  dropped_octets = __builtin__.property(_get_dropped_octets)


  _pyangbind_elements = OrderedDict([('name', name), ('max_queue_len', max_queue_len), ('avg_queue_len', avg_queue_len), ('transmit_pkts', transmit_pkts), ('transmit_octets', transmit_octets), ('dropped_pkts', dropped_pkts), ('dropped_octets', dropped_octets), ])


class yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/queues/queue. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for the queue associated with this
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'queue'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'queues', 'queue']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/name (leafref)

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/config (container)

    YANG Description: Configuration data for the queue associated with the
interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state (container)

    YANG Description: Operational state data for the queue associated with the
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/queues. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__queue',)

  _yang_name = 'queues'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'queues']

  def _get_queue(self):
    """
    Getter method for queue, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue (list)

    YANG Description: Top-level container for the queue associated with this
interface
    """
    return self.__queue
      
  def _set_queue(self, v, load=False):
    """
    Setter method for queue, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue() directly.

    YANG Description: Top-level container for the queue associated with this
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue(self):
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  queue = __builtin__.property(_get_queue, _set_queue)


  _pyangbind_elements = OrderedDict([('queue', queue), ])


class yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of egress interfaces for which a virtual output
queue is instantiated at this interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__queues',)

  _yang_name = 'voq-interface'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/name (leafref)

    YANG Description: Name used to refer to the egress interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name used to refer to the egress interface.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/config (container)

    YANG Description: Configuration parameters relating to the interface
for which the VOQs are instantiated.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to the interface
for which the VOQs are instantiated.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/state (container)

    YANG Description: Operational state parameters relating to the interface
for which the VOQs are instantiated.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to the interface
for which the VOQs are instantiated.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_queues(self):
    """
    Getter method for queues, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues (container)

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    return self.__queues
      
  def _set_queues(self, v, load=False):
    """
    Setter method for queues, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queues is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queues() directly.

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queues must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__queues = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queues(self):
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  queues = __builtin__.property(_get_queues, _set_queues)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('queues', queues), ])


class yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Surrounding container for the list of egress interfaces
for which virtual output queues are instantiated on this
interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__voq_interface',)

  _yang_name = 'virtual-output-queues'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__voq_interface = YANGDynClass(base=YANGListType("name",yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface, yang_name="voq-interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="voq-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues']

  def _get_voq_interface(self):
    """
    Getter method for voq_interface, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface (list)

    YANG Description: List of egress interfaces for which a virtual output
queue is instantiated at this interface.
    """
    return self.__voq_interface
      
  def _set_voq_interface(self, v, load=False):
    """
    Setter method for voq_interface, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_voq_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_voq_interface() directly.

    YANG Description: List of egress interfaces for which a virtual output
queue is instantiated at this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface, yang_name="voq-interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="voq-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """voq_interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface, yang_name="voq-interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="voq-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__voq_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_voq_interface(self):
    self.__voq_interface = YANGDynClass(base=YANGListType("name",yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface, yang_name="voq-interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="voq-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  voq_interface = __builtin__.property(_get_voq_interface, _set_voq_interface)


  _pyangbind_elements = OrderedDict([('voq_interface', voq_interface), ])


class yc_input_openconfig_qos__qos_interfaces_interface_input(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for QoS data for the ingress
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__classifiers','__queues','__scheduler_policy','__virtual_output_queues',)

  _yang_name = 'input'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__classifiers = YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__scheduler_policy = YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__virtual_output_queues = YANGDynClass(base=yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues, is_container='container', yang_name="virtual-output-queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/config (container)

    YANG Description: Configuration data for QoS on ingress interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for QoS on ingress interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/state (container)

    YANG Description: Operational state data for QoS on ingress interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for QoS on ingress interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_classifiers(self):
    """
    Getter method for classifiers, mapped from YANG variable /qos/interfaces/interface/input/classifiers (container)

    YANG Description: Classifiers to be applied to the interface.
    """
    return self.__classifiers
      
  def _set_classifiers(self, v, load=False):
    """
    Setter method for classifiers, mapped from YANG variable /qos/interfaces/interface/input/classifiers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifiers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifiers() directly.

    YANG Description: Classifiers to be applied to the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifiers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__classifiers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifiers(self):
    self.__classifiers = YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_queues(self):
    """
    Getter method for queues, mapped from YANG variable /qos/interfaces/interface/input/queues (container)

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    return self.__queues
      
  def _set_queues(self, v, load=False):
    """
    Setter method for queues, mapped from YANG variable /qos/interfaces/interface/input/queues (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queues is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queues() directly.

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_queues_openconfig_qos__qos_interfaces_interface_input_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queues must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__queues = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queues(self):
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_scheduler_policy(self):
    """
    Getter method for scheduler_policy, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy (container)

    YANG Description: Scheduler policy associated with the interface.
    """
    return self.__scheduler_policy
      
  def _set_scheduler_policy(self, v, load=False):
    """
    Setter method for scheduler_policy, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scheduler_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scheduler_policy() directly.

    YANG Description: Scheduler policy associated with the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scheduler_policy must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__scheduler_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scheduler_policy(self):
    self.__scheduler_policy = YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_virtual_output_queues(self):
    """
    Getter method for virtual_output_queues, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues (container)

    YANG Description: Surrounding container for the list of egress interfaces
for which virtual output queues are instantiated on this
interface.
    """
    return self.__virtual_output_queues
      
  def _set_virtual_output_queues(self, v, load=False):
    """
    Setter method for virtual_output_queues, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_virtual_output_queues is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_virtual_output_queues() directly.

    YANG Description: Surrounding container for the list of egress interfaces
for which virtual output queues are instantiated on this
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues, is_container='container', yang_name="virtual-output-queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """virtual_output_queues must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues, is_container='container', yang_name="virtual-output-queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__virtual_output_queues = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_virtual_output_queues(self):
    self.__virtual_output_queues = YANGDynClass(base=yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues, is_container='container', yang_name="virtual-output-queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  classifiers = __builtin__.property(_get_classifiers, _set_classifiers)
  queues = __builtin__.property(_get_queues, _set_queues)
  scheduler_policy = __builtin__.property(_get_scheduler_policy, _set_scheduler_policy)
  virtual_output_queues = __builtin__.property(_get_virtual_output_queues, _set_virtual_output_queues)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('classifiers', classifiers), ('queues', queues), ('scheduler_policy', scheduler_policy), ('virtual_output_queues', virtual_output_queues), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for QoS on the egress interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__buffer_allocation_profile','__multicast_buffer_allocation_profile','__unicast_buffer_allocation_profile',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'config']

  def _get_buffer_allocation_profile(self):
    """
    Getter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    return self.__buffer_allocation_profile
      
  def _set_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_buffer_allocation_profile(self):
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_multicast_buffer_allocation_profile(self):
    """
    Getter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/multicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__multicast_buffer_allocation_profile
      
  def _set_multicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/multicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__multicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_buffer_allocation_profile(self):
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_unicast_buffer_allocation_profile(self):
    """
    Getter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/unicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__unicast_buffer_allocation_profile
      
  def _set_unicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/unicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__unicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_buffer_allocation_profile(self):
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  buffer_allocation_profile = __builtin__.property(_get_buffer_allocation_profile, _set_buffer_allocation_profile)
  multicast_buffer_allocation_profile = __builtin__.property(_get_multicast_buffer_allocation_profile, _set_multicast_buffer_allocation_profile)
  unicast_buffer_allocation_profile = __builtin__.property(_get_unicast_buffer_allocation_profile, _set_unicast_buffer_allocation_profile)


  _pyangbind_elements = OrderedDict([('buffer_allocation_profile', buffer_allocation_profile), ('multicast_buffer_allocation_profile', multicast_buffer_allocation_profile), ('unicast_buffer_allocation_profile', unicast_buffer_allocation_profile), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for QoS on the egress interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__buffer_allocation_profile','__multicast_buffer_allocation_profile','__unicast_buffer_allocation_profile',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'state']

  def _get_buffer_allocation_profile(self):
    """
    Getter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    return self.__buffer_allocation_profile
      
  def _set_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_buffer_allocation_profile(self):
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_multicast_buffer_allocation_profile(self):
    """
    Getter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/multicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__multicast_buffer_allocation_profile
      
  def _set_multicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/multicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__multicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_buffer_allocation_profile(self):
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_unicast_buffer_allocation_profile(self):
    """
    Getter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/unicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__unicast_buffer_allocation_profile
      
  def _set_unicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/unicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__unicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_buffer_allocation_profile(self):
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  buffer_allocation_profile = __builtin__.property(_get_buffer_allocation_profile)
  multicast_buffer_allocation_profile = __builtin__.property(_get_multicast_buffer_allocation_profile)
  unicast_buffer_allocation_profile = __builtin__.property(_get_unicast_buffer_allocation_profile)


  _pyangbind_elements = OrderedDict([('buffer_allocation_profile', buffer_allocation_profile), ('multicast_buffer_allocation_profile', multicast_buffer_allocation_profile), ('unicast_buffer_allocation_profile', unicast_buffer_allocation_profile), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for the list of classifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config/name (leafref)

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config/type (enumeration)

    YANG Description: Type of packets matched by the classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of packets matched by the classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters for the list of classifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state/name (leafref)

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state/type (enumeration)

    YANG Description: Type of packets matched by the classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of packets matched by the classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/terms/term/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for match terms in the classifier
associated with an interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__matched_packets','__matched_octets',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'terms', 'term', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/id (leafref)

    YANG Description: Reference to match terms in the classifier
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to match terms in the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_matched_packets(self):
    """
    Getter method for matched_packets, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/matched_packets (oc-yang:counter64)

    YANG Description: Count of the number of packets matching this classifier
match term on the interface.
    """
    return self.__matched_packets
      
  def _set_matched_packets(self, v, load=False):
    """
    Setter method for matched_packets, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/matched_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_packets() directly.

    YANG Description: Count of the number of packets matching this classifier
match term on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_packets(self):
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_matched_octets(self):
    """
    Getter method for matched_octets, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/matched_octets (oc-yang:counter64)

    YANG Description: Count of the number of octets (bytes) matching this
classifier match term on the interface.
    """
    return self.__matched_octets
      
  def _set_matched_octets(self, v, load=False):
    """
    Setter method for matched_octets, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/matched_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_octets() directly.

    YANG Description: Count of the number of octets (bytes) matching this
classifier match term on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_octets(self):
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  id = __builtin__.property(_get_id)
  matched_packets = __builtin__.property(_get_matched_packets)
  matched_octets = __builtin__.property(_get_matched_octets)


  _pyangbind_elements = OrderedDict([('id', id), ('matched_packets', matched_packets), ('matched_octets', matched_octets), ])


class yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/terms/term. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of match terms in the classifier associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state',)

  _yang_name = 'term'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'terms', 'term']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/id (leafref)

    YANG Description: Reference to match term id list key
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to match term id list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state (container)

    YANG Description: Operational state data for match terms in the classifier
associated with an interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for match terms in the classifier
associated with an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ])


class yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/terms. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of match terms in the
classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__term',)

  _yang_name = 'terms'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'terms']

  def _get_term(self):
    """
    Getter method for term, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term (list)

    YANG Description: List of match terms in the classifier associated with the
interface
    """
    return self.__term
      
  def _set_term(self, v, load=False):
    """
    Setter method for term, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_term is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_term() directly.

    YANG Description: List of match terms in the classifier associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """term must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__term = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_term(self):
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  term = __builtin__.property(_get_term, _set_term)


  _pyangbind_elements = OrderedDict([('term', term), ])


class yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A list of classifiers that should be applied to the interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__config','__state','__terms',)

  _yang_name = 'classifier'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/type (leafref)

    YANG Description: Reference to the classifier name.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the classifier name.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config (container)

    YANG Description: Configuration parameters for the list of classifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters for the list of classifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state (container)

    YANG Description: Operational state parameters for the list of classifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters for the list of classifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_terms(self):
    """
    Getter method for terms, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms (container)

    YANG Description: Enclosing container for the list of match terms in the
classifier
    """
    return self.__terms
      
  def _set_terms(self, v, load=False):
    """
    Setter method for terms, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_terms is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_terms() directly.

    YANG Description: Enclosing container for the list of match terms in the
classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """terms must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__terms = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_terms(self):
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  type = __builtin__.property(_get_type, _set_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  terms = __builtin__.property(_get_terms, _set_terms)


  _pyangbind_elements = OrderedDict([('type', type), ('config', config), ('state', state), ('terms', terms), ])


class yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Classifiers to be applied to the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__classifier',)

  _yang_name = 'classifiers'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__classifier = YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers']

  def _get_classifier(self):
    """
    Getter method for classifier, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier (list)

    YANG Description: A list of classifiers that should be applied to the interface
    """
    return self.__classifier
      
  def _set_classifier(self, v, load=False):
    """
    Setter method for classifier, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifier() directly.

    YANG Description: A list of classifiers that should be applied to the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifier must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__classifier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifier(self):
    self.__classifier = YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  classifier = __builtin__.property(_get_classifier, _set_classifier)


  _pyangbind_elements = OrderedDict([('classifier', classifier), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/queues/queue/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__queue_management_profile',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'queues', 'queue', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)


  def _get_queue_management_profile(self):
    """
    Getter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config/queue_management_profile (leafref)

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    return self.__queue_management_profile
      
  def _set_queue_management_profile(self, v, load=False):
    """
    Setter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config/queue_management_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_management_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_management_profile() directly.

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_management_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__queue_management_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_management_profile(self):
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  queue_management_profile = __builtin__.property(_get_queue_management_profile, _set_queue_management_profile)


  _pyangbind_elements = OrderedDict([('name', name), ('queue_management_profile', queue_management_profile), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/queues/queue/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__queue_management_profile','__max_queue_len','__avg_queue_len','__transmit_pkts','__transmit_octets','__dropped_pkts','__dropped_octets',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'queues', 'queue', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)


  def _get_queue_management_profile(self):
    """
    Getter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/queue_management_profile (leafref)

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    return self.__queue_management_profile
      
  def _set_queue_management_profile(self, v, load=False):
    """
    Setter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/queue_management_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_management_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_management_profile() directly.

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_management_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__queue_management_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_management_profile(self):
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_max_queue_len(self):
    """
    Getter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/max_queue_len (oc-yang:counter64)

    YANG Description: Maximum observed queue length
    """
    return self.__max_queue_len
      
  def _set_max_queue_len(self, v, load=False):
    """
    Setter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/max_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_queue_len() directly.

    YANG Description: Maximum observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__max_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_queue_len(self):
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_avg_queue_len(self):
    """
    Getter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/avg_queue_len (oc-yang:counter64)

    YANG Description: Average observed queue length
    """
    return self.__avg_queue_len
      
  def _set_avg_queue_len(self, v, load=False):
    """
    Setter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/avg_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg_queue_len() directly.

    YANG Description: Average observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__avg_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg_queue_len(self):
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_pkts(self):
    """
    Getter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/transmit_pkts (oc-yang:counter64)

    YANG Description: Number of packets transmitted by this queue
    """
    return self.__transmit_pkts
      
  def _set_transmit_pkts(self, v, load=False):
    """
    Setter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/transmit_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_pkts() directly.

    YANG Description: Number of packets transmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_pkts(self):
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_octets(self):
    """
    Getter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/transmit_octets (oc-yang:counter64)

    YANG Description: Number of octets trasmitted by this queue
    """
    return self.__transmit_octets
      
  def _set_transmit_octets(self, v, load=False):
    """
    Setter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/transmit_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_octets() directly.

    YANG Description: Number of octets trasmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_octets(self):
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_pkts(self):
    """
    Getter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/dropped_pkts (oc-yang:counter64)

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    return self.__dropped_pkts
      
  def _set_dropped_pkts(self, v, load=False):
    """
    Setter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/dropped_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_pkts() directly.

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_pkts(self):
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_octets(self):
    """
    Getter method for dropped_octets, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/dropped_octets (oc-yang:counter64)

    YANG Description: Number of octets dropped by the queue due to overrun
    """
    return self.__dropped_octets
      
  def _set_dropped_octets(self, v, load=False):
    """
    Setter method for dropped_octets, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/dropped_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_octets() directly.

    YANG Description: Number of octets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_octets(self):
    self.__dropped_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  name = __builtin__.property(_get_name)
  queue_management_profile = __builtin__.property(_get_queue_management_profile)
  max_queue_len = __builtin__.property(_get_max_queue_len)
  avg_queue_len = __builtin__.property(_get_avg_queue_len)
  transmit_pkts = __builtin__.property(_get_transmit_pkts)
  transmit_octets = __builtin__.property(_get_transmit_octets)
  dropped_pkts = __builtin__.property(_get_dropped_pkts)
  dropped_octets = __builtin__.property(_get_dropped_octets)


  _pyangbind_elements = OrderedDict([('name', name), ('queue_management_profile', queue_management_profile), ('max_queue_len', max_queue_len), ('avg_queue_len', avg_queue_len), ('transmit_pkts', transmit_pkts), ('transmit_octets', transmit_octets), ('dropped_pkts', dropped_pkts), ('dropped_octets', dropped_octets), ])


class yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/queues/queue. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for the queue associated with this
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'queue'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'queues', 'queue']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/name (leafref)

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config (container)

    YANG Description: Configuration data for the queue associated with the
interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state (container)

    YANG Description: Operational state data for the queue associated with the
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_queues_openconfig_qos__qos_interfaces_interface_output_queues(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/queues. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__queue',)

  _yang_name = 'queues'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'queues']

  def _get_queue(self):
    """
    Getter method for queue, mapped from YANG variable /qos/interfaces/interface/output/queues/queue (list)

    YANG Description: Top-level container for the queue associated with this
interface
    """
    return self.__queue
      
  def _set_queue(self, v, load=False):
    """
    Setter method for queue, mapped from YANG variable /qos/interfaces/interface/output/queues/queue (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue() directly.

    YANG Description: Top-level container for the queue associated with this
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue(self):
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  queue = __builtin__.property(_get_queue, _set_queue)


  _pyangbind_elements = OrderedDict([('queue', queue), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/config/name (leafref)

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/state/name (leafref)

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  name = __builtin__.property(_get_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/schedulers/scheduler/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to the scheduler
policy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__conforming_pkts','__conforming_octets','__exceeding_pkts','__exceeding_octets','__violating_pkts','__violating_octets',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__conforming_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__conforming_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__exceeding_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__exceeding_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__violating_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__violating_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'schedulers', 'scheduler', 'state']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/sequence (leafref)

    YANG Description: Reference to the sequence ID of the scheduler within
the current scheduler policy.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/sequence (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Reference to the sequence ID of the scheduler within
the current scheduler policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_conforming_pkts(self):
    """
    Getter method for conforming_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/conforming_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered conforming by
the scheduler.
    """
    return self.__conforming_pkts
      
  def _set_conforming_pkts(self, v, load=False):
    """
    Setter method for conforming_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/conforming_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conforming_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conforming_pkts() directly.

    YANG Description: The number of packets that were considered conforming by
the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conforming_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__conforming_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conforming_pkts(self):
    self.__conforming_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_conforming_octets(self):
    """
    Getter method for conforming_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/conforming_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
conforming by the scheduler.
    """
    return self.__conforming_octets
      
  def _set_conforming_octets(self, v, load=False):
    """
    Setter method for conforming_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/conforming_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conforming_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conforming_octets() directly.

    YANG Description: The number of octets in packets that were considered
conforming by the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conforming_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__conforming_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conforming_octets(self):
    self.__conforming_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_exceeding_pkts(self):
    """
    Getter method for exceeding_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/exceeding_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered exceeding by
the scheduler.
    """
    return self.__exceeding_pkts
      
  def _set_exceeding_pkts(self, v, load=False):
    """
    Setter method for exceeding_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/exceeding_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exceeding_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exceeding_pkts() directly.

    YANG Description: The number of packets that were considered exceeding by
the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exceeding_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__exceeding_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exceeding_pkts(self):
    self.__exceeding_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_exceeding_octets(self):
    """
    Getter method for exceeding_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/exceeding_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
exceeding by the scheduler.
    """
    return self.__exceeding_octets
      
  def _set_exceeding_octets(self, v, load=False):
    """
    Setter method for exceeding_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/exceeding_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exceeding_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exceeding_octets() directly.

    YANG Description: The number of octets in packets that were considered
exceeding by the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exceeding_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__exceeding_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exceeding_octets(self):
    self.__exceeding_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_violating_pkts(self):
    """
    Getter method for violating_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/violating_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered violating by
the policer.
    """
    return self.__violating_pkts
      
  def _set_violating_pkts(self, v, load=False):
    """
    Setter method for violating_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/violating_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_violating_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_violating_pkts() directly.

    YANG Description: The number of packets that were considered violating by
the policer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """violating_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__violating_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_violating_pkts(self):
    self.__violating_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_violating_octets(self):
    """
    Getter method for violating_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/violating_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
violating by the policer.
    """
    return self.__violating_octets
      
  def _set_violating_octets(self, v, load=False):
    """
    Setter method for violating_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/violating_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_violating_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_violating_octets() directly.

    YANG Description: The number of octets in packets that were considered
violating by the policer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """violating_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__violating_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_violating_octets(self):
    self.__violating_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  sequence = __builtin__.property(_get_sequence)
  conforming_pkts = __builtin__.property(_get_conforming_pkts)
  conforming_octets = __builtin__.property(_get_conforming_octets)
  exceeding_pkts = __builtin__.property(_get_exceeding_pkts)
  exceeding_octets = __builtin__.property(_get_exceeding_octets)
  violating_pkts = __builtin__.property(_get_violating_pkts)
  violating_octets = __builtin__.property(_get_violating_octets)


  _pyangbind_elements = OrderedDict([('sequence', sequence), ('conforming_pkts', conforming_pkts), ('conforming_octets', conforming_octets), ('exceeding_pkts', exceeding_pkts), ('exceeding_octets', exceeding_octets), ('violating_pkts', violating_pkts), ('violating_octets', violating_octets), ])


class yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/schedulers/scheduler. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__state',)

  _yang_name = 'scheduler'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'schedulers', 'scheduler']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/sequence (leafref)

    YANG Description: Reference to the sequence ID for the scheduler.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/sequence (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Reference to the sequence ID for the scheduler.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state (container)

    YANG Description: Operational state parameters relating to the scheduler
policy.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to the scheduler
policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

  sequence = __builtin__.property(_get_sequence)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('sequence', sequence), ('state', state), ])


class yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/schedulers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Schedulers within the applied scheduler-policy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__scheduler',)

  _yang_name = 'schedulers'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__scheduler = YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'schedulers']

  def _get_scheduler(self):
    """
    Getter method for scheduler, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler (list)

    YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
    """
    return self.__scheduler
      
  def _set_scheduler(self, v, load=False):
    """
    Setter method for scheduler, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scheduler is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scheduler() directly.

    YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scheduler must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)""",
        })

    self.__scheduler = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scheduler(self):
    self.__scheduler = YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)

  scheduler = __builtin__.property(_get_scheduler)


  _pyangbind_elements = OrderedDict([('scheduler', scheduler), ])


class yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Scheduler policy associated with the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__schedulers',)

  _yang_name = 'scheduler-policy'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__schedulers = YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/config (container)

    YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/state (container)

    YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_schedulers(self):
    """
    Getter method for schedulers, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers (container)

    YANG Description: Schedulers within the applied scheduler-policy.
    """
    return self.__schedulers
      
  def _set_schedulers(self, v, load=False):
    """
    Setter method for schedulers, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_schedulers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_schedulers() directly.

    YANG Description: Schedulers within the applied scheduler-policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """schedulers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__schedulers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_schedulers(self):
    self.__schedulers = YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  schedulers = __builtin__.property(_get_schedulers, _set_schedulers)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('schedulers', schedulers), ])


class yc_output_openconfig_qos__qos_interfaces_interface_output(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for QoS data related to the egress
interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__classifiers','__queues','__scheduler_policy',)

  _yang_name = 'output'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__classifiers = YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_output_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__scheduler_policy = YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/config (container)

    YANG Description: Configuration data for QoS on the egress interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for QoS on the egress interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/state (container)

    YANG Description: Operational state data for QoS on the egress interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for QoS on the egress interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_classifiers(self):
    """
    Getter method for classifiers, mapped from YANG variable /qos/interfaces/interface/output/classifiers (container)

    YANG Description: Classifiers to be applied to the interface.
    """
    return self.__classifiers
      
  def _set_classifiers(self, v, load=False):
    """
    Setter method for classifiers, mapped from YANG variable /qos/interfaces/interface/output/classifiers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifiers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifiers() directly.

    YANG Description: Classifiers to be applied to the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifiers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__classifiers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifiers(self):
    self.__classifiers = YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_queues(self):
    """
    Getter method for queues, mapped from YANG variable /qos/interfaces/interface/output/queues (container)

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    return self.__queues
      
  def _set_queues(self, v, load=False):
    """
    Setter method for queues, mapped from YANG variable /qos/interfaces/interface/output/queues (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queues is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queues() directly.

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_queues_openconfig_qos__qos_interfaces_interface_output_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queues must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_output_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__queues = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queues(self):
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_output_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_scheduler_policy(self):
    """
    Getter method for scheduler_policy, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy (container)

    YANG Description: Scheduler policy associated with the interface.
    """
    return self.__scheduler_policy
      
  def _set_scheduler_policy(self, v, load=False):
    """
    Setter method for scheduler_policy, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scheduler_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scheduler_policy() directly.

    YANG Description: Scheduler policy associated with the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scheduler_policy must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__scheduler_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scheduler_policy(self):
    self.__scheduler_policy = YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  classifiers = __builtin__.property(_get_classifiers, _set_classifiers)
  queues = __builtin__.property(_get_queues, _set_queues)
  scheduler_policy = __builtin__.property(_get_scheduler_policy, _set_scheduler_policy)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('classifiers', classifiers), ('queues', queues), ('scheduler_policy', scheduler_policy), ])


class yc_interface_openconfig_qos__qos_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces referenced by QoS entities.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_id','__config','__state','__interface_ref','__input','__output',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__input = YANGDynClass(base=yc_input_openconfig_qos__qos_interfaces_interface_input, is_container='container', yang_name="input", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__output = YANGDynClass(base=yc_output_openconfig_qos__qos_interfaces_interface_output, is_container='container', yang_name="output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface']

  def _get_interface_id(self):
    """
    Getter method for interface_id, mapped from YANG variable /qos/interfaces/interface/interface_id (leafref)

    YANG Description: Reference to the interface-id list key
    """
    return self.__interface_id
      
  def _set_interface_id(self, v, load=False):
    """
    Setter method for interface_id, mapped from YANG variable /qos/interfaces/interface/interface_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_id() directly.

    YANG Description: Reference to the interface-id list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_id(self):
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /qos/interfaces/interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /qos/interfaces/interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_input(self):
    """
    Getter method for input, mapped from YANG variable /qos/interfaces/interface/input (container)

    YANG Description: Top-level container for QoS data for the ingress
interface
    """
    return self.__input
      
  def _set_input(self, v, load=False):
    """
    Setter method for input, mapped from YANG variable /qos/interfaces/interface/input (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input() directly.

    YANG Description: Top-level container for QoS data for the ingress
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_input_openconfig_qos__qos_interfaces_interface_input, is_container='container', yang_name="input", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_input_openconfig_qos__qos_interfaces_interface_input, is_container='container', yang_name="input", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__input = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input(self):
    self.__input = YANGDynClass(base=yc_input_openconfig_qos__qos_interfaces_interface_input, is_container='container', yang_name="input", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_output(self):
    """
    Getter method for output, mapped from YANG variable /qos/interfaces/interface/output (container)

    YANG Description: Top-level container for QoS data related to the egress
interface.
    """
    return self.__output
      
  def _set_output(self, v, load=False):
    """
    Setter method for output, mapped from YANG variable /qos/interfaces/interface/output (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output() directly.

    YANG Description: Top-level container for QoS data related to the egress
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_output_openconfig_qos__qos_interfaces_interface_output, is_container='container', yang_name="output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_output_openconfig_qos__qos_interfaces_interface_output, is_container='container', yang_name="output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__output = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output(self):
    self.__output = YANGDynClass(base=yc_output_openconfig_qos__qos_interfaces_interface_output, is_container='container', yang_name="output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  interface_id = __builtin__.property(_get_interface_id, _set_interface_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)
  input = __builtin__.property(_get_input, _set_input)
  output = __builtin__.property(_get_output, _set_output)


  _pyangbind_elements = OrderedDict([('interface_id', interface_id), ('config', config), ('state', state), ('interface_ref', interface_ref), ('input', input), ('output', output), ])


class yc_interfaces_openconfig_qos__qos_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interface references
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("interface_id",yc_interface_openconfig_qos__qos_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface-id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /qos/interfaces/interface (list)

    YANG Description: List of interfaces referenced by QoS entities.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /qos/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces referenced by QoS entities.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("interface_id",yc_interface_openconfig_qos__qos_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface-id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("interface_id",yc_interface_openconfig_qos__qos_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface-id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("interface_id",yc_interface_openconfig_qos__qos_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface-id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for classifers
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/classifiers/classifier/config/name (string)

    YANG Description: User-assigned name of the classifier
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/classifiers/classifier/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: User-assigned name of the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/classifiers/classifier/config/type (enumeration)

    YANG Description: Type of classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/classifiers/classifier/config/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for classifiers
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/classifiers/classifier/state/name (string)

    YANG Description: User-assigned name of the classifier
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/classifiers/classifier/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: User-assigned name of the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/classifiers/classifier/state/type (enumeration)

    YANG Description: Type of classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/classifiers/classifier/state/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for list of match criteria in a QoS
classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__id',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'config']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/config/id (string)

    YANG Description: Identifier for the match term
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/config/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Identifier for the match term
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

  id = __builtin__.property(_get_id, _set_id)


  _pyangbind_elements = OrderedDict([('id', id), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for list of match criteria in a
QoS classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__id',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/state/id (string)

    YANG Description: Identifier for the match term
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Identifier for the match term
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

  id = __builtin__.property(_get_id)


  _pyangbind_elements = OrderedDict([('id', id), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/l2/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_mac','__source_mac_mask','__destination_mac','__destination_mac_mask','__ethertype',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'l2', 'config']

  def _get_source_mac(self):
    """
    Getter method for source_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/source_mac (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address.
    """
    return self.__source_mac
      
  def _set_source_mac(self, v, load=False):
    """
    Setter method for source_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/source_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac() directly.

    YANG Description: Source IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__source_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac(self):
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)


  def _get_source_mac_mask(self):
    """
    Getter method for source_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/source_mac_mask (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address mask.
    """
    return self.__source_mac_mask
      
  def _set_source_mac_mask(self, v, load=False):
    """
    Setter method for source_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/source_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac_mask() directly.

    YANG Description: Source IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__source_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac_mask(self):
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)


  def _get_destination_mac(self):
    """
    Getter method for destination_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/destination_mac (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address.
    """
    return self.__destination_mac
      
  def _set_destination_mac(self, v, load=False):
    """
    Setter method for destination_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/destination_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac() directly.

    YANG Description: Destination IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__destination_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac(self):
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)


  def _get_destination_mac_mask(self):
    """
    Getter method for destination_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/destination_mac_mask (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    return self.__destination_mac_mask
      
  def _set_destination_mac_mask(self, v, load=False):
    """
    Setter method for destination_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/destination_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac_mask() directly.

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__destination_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac_mask(self):
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)


  def _get_ethertype(self):
    """
    Getter method for ethertype, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/ethertype (oc-pkt-match-types:ethertype-type)

    YANG Description: Ethertype field to match in Ethernet packets
    """
    return self.__ethertype
      
  def _set_ethertype(self, v, load=False):
    """
    Setter method for ethertype, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/ethertype (oc-pkt-match-types:ethertype-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethertype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethertype() directly.

    YANG Description: Ethertype field to match in Ethernet packets
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethertype must be of a type compatible with oc-pkt-match-types:ethertype-type""",
          'defined-type': "oc-pkt-match-types:ethertype-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)""",
        })

    self.__ethertype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethertype(self):
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)

  source_mac = __builtin__.property(_get_source_mac, _set_source_mac)
  source_mac_mask = __builtin__.property(_get_source_mac_mask, _set_source_mac_mask)
  destination_mac = __builtin__.property(_get_destination_mac, _set_destination_mac)
  destination_mac_mask = __builtin__.property(_get_destination_mac_mask, _set_destination_mac_mask)
  ethertype = __builtin__.property(_get_ethertype, _set_ethertype)


  _pyangbind_elements = OrderedDict([('source_mac', source_mac), ('source_mac_mask', source_mac_mask), ('destination_mac', destination_mac), ('destination_mac_mask', destination_mac_mask), ('ethertype', ethertype), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/l2/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State Information.
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_mac','__source_mac_mask','__destination_mac','__destination_mac_mask','__ethertype',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'l2', 'state']

  def _get_source_mac(self):
    """
    Getter method for source_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/source_mac (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address.
    """
    return self.__source_mac
      
  def _set_source_mac(self, v, load=False):
    """
    Setter method for source_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/source_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac() directly.

    YANG Description: Source IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__source_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac(self):
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)


  def _get_source_mac_mask(self):
    """
    Getter method for source_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/source_mac_mask (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address mask.
    """
    return self.__source_mac_mask
      
  def _set_source_mac_mask(self, v, load=False):
    """
    Setter method for source_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/source_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac_mask() directly.

    YANG Description: Source IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__source_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac_mask(self):
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)


  def _get_destination_mac(self):
    """
    Getter method for destination_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/destination_mac (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address.
    """
    return self.__destination_mac
      
  def _set_destination_mac(self, v, load=False):
    """
    Setter method for destination_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/destination_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac() directly.

    YANG Description: Destination IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__destination_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac(self):
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)


  def _get_destination_mac_mask(self):
    """
    Getter method for destination_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/destination_mac_mask (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    return self.__destination_mac_mask
      
  def _set_destination_mac_mask(self, v, load=False):
    """
    Setter method for destination_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/destination_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac_mask() directly.

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__destination_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac_mask(self):
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)


  def _get_ethertype(self):
    """
    Getter method for ethertype, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/ethertype (oc-pkt-match-types:ethertype-type)

    YANG Description: Ethertype field to match in Ethernet packets
    """
    return self.__ethertype
      
  def _set_ethertype(self, v, load=False):
    """
    Setter method for ethertype, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/ethertype (oc-pkt-match-types:ethertype-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethertype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethertype() directly.

    YANG Description: Ethertype field to match in Ethernet packets
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethertype must be of a type compatible with oc-pkt-match-types:ethertype-type""",
          'defined-type': "oc-pkt-match-types:ethertype-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)""",
        })

    self.__ethertype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethertype(self):
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)

  source_mac = __builtin__.property(_get_source_mac)
  source_mac_mask = __builtin__.property(_get_source_mac_mask)
  destination_mac = __builtin__.property(_get_destination_mac)
  destination_mac_mask = __builtin__.property(_get_destination_mac_mask)
  ethertype = __builtin__.property(_get_ethertype)


  _pyangbind_elements = OrderedDict([('source_mac', source_mac), ('source_mac_mask', source_mac_mask), ('destination_mac', destination_mac), ('destination_mac_mask', destination_mac_mask), ('ethertype', ethertype), ])


class yc_l2_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/l2. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Ethernet header fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'l2'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'l2']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config (container)

    YANG Description: Configuration data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state (container)

    YANG Description: State Information.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State Information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv4 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_address_prefix_set','__destination_address','__destination_address_prefix_set','__dscp','__dscp_set','__length','__protocol','__hop_limit',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=True)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4', 'config']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/source_address (oc-inet:ipv4-prefix)

    YANG Description: Source IPv4 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/source_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_source_address_prefix_set(self):
    """
    Getter method for source_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/source_address_prefix_set (leafref)

    YANG Description: Reference to a IPv4 address prefix Set
to match the source address
    """
    return self.__source_address_prefix_set
      
  def _set_source_address_prefix_set(self, v, load=False):
    """
    Setter method for source_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/source_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address_prefix_set() directly.

    YANG Description: Reference to a IPv4 address prefix Set
to match the source address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__source_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address_prefix_set(self):
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/destination_address (oc-inet:ipv4-prefix)

    YANG Description: Destination IPv4 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/destination_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_destination_address_prefix_set(self):
    """
    Getter method for destination_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/destination_address_prefix_set (leafref)

    YANG Description: Reference to a IPv4 address prefix set
to match the destination address
    """
    return self.__destination_address_prefix_set
      
  def _set_destination_address_prefix_set(self, v, load=False):
    """
    Setter method for destination_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/destination_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address_prefix_set() directly.

    YANG Description: Reference to a IPv4 address prefix set
to match the destination address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__destination_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address_prefix_set(self):
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)


  def _get_length(self):
    """
    Getter method for length, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/length (uint16)

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    return self.__length
      
  def _set_length(self, v, load=False):
    """
    Setter method for length, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/length (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_length is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_length() directly.

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """length must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=True)""",
        })

    self.__length = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_length(self):
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

  source_address = __builtin__.property(_get_source_address, _set_source_address)
  source_address_prefix_set = __builtin__.property(_get_source_address_prefix_set, _set_source_address_prefix_set)
  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  destination_address_prefix_set = __builtin__.property(_get_destination_address_prefix_set, _set_destination_address_prefix_set)
  dscp = __builtin__.property(_get_dscp, _set_dscp)
  dscp_set = __builtin__.property(_get_dscp_set, _set_dscp_set)
  length = __builtin__.property(_get_length, _set_length)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  hop_limit = __builtin__.property(_get_hop_limit, _set_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_address_prefix_set', source_address_prefix_set), ('destination_address', destination_address), ('destination_address_prefix_set', destination_address_prefix_set), ('dscp', dscp), ('dscp_set', dscp_set), ('length', length), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information for IPv4 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_address_prefix_set','__destination_address','__destination_address_prefix_set','__dscp','__dscp_set','__length','__protocol','__hop_limit',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=False)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4', 'state']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/source_address (oc-inet:ipv4-prefix)

    YANG Description: Source IPv4 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/source_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_source_address_prefix_set(self):
    """
    Getter method for source_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/source_address_prefix_set (leafref)

    YANG Description: Reference to a IPv4 address prefix Set
to match the source address
    """
    return self.__source_address_prefix_set
      
  def _set_source_address_prefix_set(self, v, load=False):
    """
    Setter method for source_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/source_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address_prefix_set() directly.

    YANG Description: Reference to a IPv4 address prefix Set
to match the source address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__source_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address_prefix_set(self):
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/destination_address (oc-inet:ipv4-prefix)

    YANG Description: Destination IPv4 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/destination_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_destination_address_prefix_set(self):
    """
    Getter method for destination_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/destination_address_prefix_set (leafref)

    YANG Description: Reference to a IPv4 address prefix set
to match the destination address
    """
    return self.__destination_address_prefix_set
      
  def _set_destination_address_prefix_set(self, v, load=False):
    """
    Setter method for destination_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/destination_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address_prefix_set() directly.

    YANG Description: Reference to a IPv4 address prefix set
to match the destination address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__destination_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address_prefix_set(self):
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)


  def _get_length(self):
    """
    Getter method for length, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/length (uint16)

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    return self.__length
      
  def _set_length(self, v, load=False):
    """
    Setter method for length, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/length (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_length is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_length() directly.

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """length must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=False)""",
        })

    self.__length = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_length(self):
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

  source_address = __builtin__.property(_get_source_address)
  source_address_prefix_set = __builtin__.property(_get_source_address_prefix_set)
  destination_address = __builtin__.property(_get_destination_address)
  destination_address_prefix_set = __builtin__.property(_get_destination_address_prefix_set)
  dscp = __builtin__.property(_get_dscp)
  dscp_set = __builtin__.property(_get_dscp_set)
  length = __builtin__.property(_get_length)
  protocol = __builtin__.property(_get_protocol)
  hop_limit = __builtin__.property(_get_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_address_prefix_set', source_address_prefix_set), ('destination_address', destination_address), ('destination_address_prefix_set', destination_address_prefix_set), ('dscp', dscp), ('dscp_set', dscp_set), ('length', length), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration attributes for ICMPv4 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__code',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4', 'icmpv4', 'config']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/config/type (identityref)

    YANG Description: ICMPv4 type to be matched.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: ICMPv4 type to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-qos:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)


  def _get_code(self):
    """
    Getter method for code, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/config/code (identityref)

    YANG Description: ICMPv4 code to be matched.
    """
    return self.__code
      
  def _set_code(self, v, load=False):
    """
    Setter method for code, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/config/code (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_code() directly.

    YANG Description: ICMPv4 code to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """code must be of a type compatible with identityref""",
          'defined-type': "openconfig-qos:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)""",
        })

    self.__code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_code(self):
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)

  type = __builtin__.property(_get_type, _set_type)
  code = __builtin__.property(_get_code, _set_code)


  _pyangbind_elements = OrderedDict([('type', type), ('code', code), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State attributes for ICMPv4 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__code',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4', 'icmpv4', 'state']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/state/type (identityref)

    YANG Description: ICMPv4 type to be matched.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: ICMPv4 type to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-qos:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)


  def _get_code(self):
    """
    Getter method for code, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/state/code (identityref)

    YANG Description: ICMPv4 code to be matched.
    """
    return self.__code
      
  def _set_code(self, v, load=False):
    """
    Setter method for code, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/state/code (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_code() directly.

    YANG Description: ICMPv4 code to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """code must be of a type compatible with identityref""",
          'defined-type': "openconfig-qos:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)""",
        })

    self.__code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_code(self):
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)

  type = __builtin__.property(_get_type)
  code = __builtin__.property(_get_code)


  _pyangbind_elements = OrderedDict([('type', type), ('code', code), ])


class yc_icmpv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top container for ICMPv4 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'icmpv4'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4', 'icmpv4']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/config (container)

    YANG Description: Configuration attributes for ICMPv4 filtering
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration attributes for ICMPv4 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/state (container)

    YANG Description: State attributes for ICMPv4 filtering
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State attributes for ICMPv4 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_ipv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for IPv4 match field data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__icmpv4',)

  _yang_name = 'ipv4'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__icmpv4 = YANGDynClass(base=yc_icmpv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4, is_container='container', yang_name="icmpv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config (container)

    YANG Description: Configuration data for IPv4 match fields
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv4 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state (container)

    YANG Description: State information for IPv4 match fields
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information for IPv4 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_icmpv4(self):
    """
    Getter method for icmpv4, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4 (container)

    YANG Description: Top container for ICMPv4 filtering
    """
    return self.__icmpv4
      
  def _set_icmpv4(self, v, load=False):
    """
    Setter method for icmpv4, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/icmpv4 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_icmpv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_icmpv4() directly.

    YANG Description: Top container for ICMPv4 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_icmpv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4, is_container='container', yang_name="icmpv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """icmpv4 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_icmpv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4, is_container='container', yang_name="icmpv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__icmpv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_icmpv4(self):
    self.__icmpv4 = YANGDynClass(base=yc_icmpv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_icmpv4, is_container='container', yang_name="icmpv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  icmpv4 = __builtin__.property(_get_icmpv4, _set_icmpv4)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('icmpv4', icmpv4), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv6/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv6 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_address_prefix_set','__source_flow_label','__destination_address','__destination_address_prefix_set','__destination_flow_label','__dscp','__dscp_set','__length','__protocol','__hop_limit',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=True)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv6', 'config']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_address (oc-inet:ipv6-prefix)

    YANG Description: Source IPv6 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_source_address_prefix_set(self):
    """
    Getter method for source_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_address_prefix_set (leafref)

    YANG Description: Reference to a IPv6 address prefix set
to match the source address
    """
    return self.__source_address_prefix_set
      
  def _set_source_address_prefix_set(self, v, load=False):
    """
    Setter method for source_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address_prefix_set() directly.

    YANG Description: Reference to a IPv6 address prefix set
to match the source address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__source_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address_prefix_set(self):
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_source_flow_label(self):
    """
    Getter method for source_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Source IPv6 Flow label.
    """
    return self.__source_flow_label
      
  def _set_source_flow_label(self, v, load=False):
    """
    Setter method for source_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_flow_label() directly.

    YANG Description: Source IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)""",
        })

    self.__source_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_flow_label(self):
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_address (oc-inet:ipv6-prefix)

    YANG Description: Destination IPv6 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_destination_address_prefix_set(self):
    """
    Getter method for destination_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_address_prefix_set (leafref)

    YANG Description: Reference to a IPv6 address prefix set
to match the destination address
    """
    return self.__destination_address_prefix_set
      
  def _set_destination_address_prefix_set(self, v, load=False):
    """
    Setter method for destination_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address_prefix_set() directly.

    YANG Description: Reference to a IPv6 address prefix set
to match the destination address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__destination_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address_prefix_set(self):
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_destination_flow_label(self):
    """
    Getter method for destination_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Destination IPv6 Flow label.
    """
    return self.__destination_flow_label
      
  def _set_destination_flow_label(self, v, load=False):
    """
    Setter method for destination_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_flow_label() directly.

    YANG Description: Destination IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)""",
        })

    self.__destination_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_flow_label(self):
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)


  def _get_length(self):
    """
    Getter method for length, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/length (uint16)

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    return self.__length
      
  def _set_length(self, v, load=False):
    """
    Setter method for length, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/length (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_length is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_length() directly.

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """length must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=True)""",
        })

    self.__length = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_length(self):
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

  source_address = __builtin__.property(_get_source_address, _set_source_address)
  source_address_prefix_set = __builtin__.property(_get_source_address_prefix_set, _set_source_address_prefix_set)
  source_flow_label = __builtin__.property(_get_source_flow_label, _set_source_flow_label)
  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  destination_address_prefix_set = __builtin__.property(_get_destination_address_prefix_set, _set_destination_address_prefix_set)
  destination_flow_label = __builtin__.property(_get_destination_flow_label, _set_destination_flow_label)
  dscp = __builtin__.property(_get_dscp, _set_dscp)
  dscp_set = __builtin__.property(_get_dscp_set, _set_dscp_set)
  length = __builtin__.property(_get_length, _set_length)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  hop_limit = __builtin__.property(_get_hop_limit, _set_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_address_prefix_set', source_address_prefix_set), ('source_flow_label', source_flow_label), ('destination_address', destination_address), ('destination_address_prefix_set', destination_address_prefix_set), ('destination_flow_label', destination_flow_label), ('dscp', dscp), ('dscp_set', dscp_set), ('length', length), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv6/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for IPv6 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_address_prefix_set','__source_flow_label','__destination_address','__destination_address_prefix_set','__destination_flow_label','__dscp','__dscp_set','__length','__protocol','__hop_limit',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=False)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv6', 'state']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_address (oc-inet:ipv6-prefix)

    YANG Description: Source IPv6 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_source_address_prefix_set(self):
    """
    Getter method for source_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_address_prefix_set (leafref)

    YANG Description: Reference to a IPv6 address prefix set
to match the source address
    """
    return self.__source_address_prefix_set
      
  def _set_source_address_prefix_set(self, v, load=False):
    """
    Setter method for source_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address_prefix_set() directly.

    YANG Description: Reference to a IPv6 address prefix set
to match the source address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__source_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address_prefix_set(self):
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_source_flow_label(self):
    """
    Getter method for source_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Source IPv6 Flow label.
    """
    return self.__source_flow_label
      
  def _set_source_flow_label(self, v, load=False):
    """
    Setter method for source_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_flow_label() directly.

    YANG Description: Source IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)""",
        })

    self.__source_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_flow_label(self):
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_address (oc-inet:ipv6-prefix)

    YANG Description: Destination IPv6 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_destination_address_prefix_set(self):
    """
    Getter method for destination_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_address_prefix_set (leafref)

    YANG Description: Reference to a IPv6 address prefix set
to match the destination address
    """
    return self.__destination_address_prefix_set
      
  def _set_destination_address_prefix_set(self, v, load=False):
    """
    Setter method for destination_address_prefix_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address_prefix_set() directly.

    YANG Description: Reference to a IPv6 address prefix set
to match the destination address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__destination_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address_prefix_set(self):
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_destination_flow_label(self):
    """
    Getter method for destination_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Destination IPv6 Flow label.
    """
    return self.__destination_flow_label
      
  def _set_destination_flow_label(self, v, load=False):
    """
    Setter method for destination_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_flow_label() directly.

    YANG Description: Destination IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)""",
        })

    self.__destination_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_flow_label(self):
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)


  def _get_length(self):
    """
    Getter method for length, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/length (uint16)

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    return self.__length
      
  def _set_length(self, v, load=False):
    """
    Setter method for length, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/length (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_length is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_length() directly.

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """length must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=False)""",
        })

    self.__length = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_length(self):
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint16', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

  source_address = __builtin__.property(_get_source_address)
  source_address_prefix_set = __builtin__.property(_get_source_address_prefix_set)
  source_flow_label = __builtin__.property(_get_source_flow_label)
  destination_address = __builtin__.property(_get_destination_address)
  destination_address_prefix_set = __builtin__.property(_get_destination_address_prefix_set)
  destination_flow_label = __builtin__.property(_get_destination_flow_label)
  dscp = __builtin__.property(_get_dscp)
  dscp_set = __builtin__.property(_get_dscp_set)
  length = __builtin__.property(_get_length)
  protocol = __builtin__.property(_get_protocol)
  hop_limit = __builtin__.property(_get_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_address_prefix_set', source_address_prefix_set), ('source_flow_label', source_flow_label), ('destination_address', destination_address), ('destination_address_prefix_set', destination_address_prefix_set), ('destination_flow_label', destination_flow_label), ('dscp', dscp), ('dscp_set', dscp_set), ('length', length), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_icmpv6_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv6/icmpv6/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration attributes for ICMPv6 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__code',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/qos'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconf