# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_ap_manager__provision_aps_provision_ap_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ap-manager - based on the path /provision-aps/provision-ap/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Config container for assigning hostnames to APs.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac','__hostname','__country_code',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/ap-manager'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=True)
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=True)
    self.__country_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[A-Z]{2}'}), is_leaf=True, yang_name="country-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['provision-aps', 'provision-ap', 'config']

  def _get_mac(self):
    """
    Getter method for mac, mapped from YANG variable /provision_aps/provision_ap/config/mac (oc-yang:mac-address)

    YANG Description: MAC address of the AP primary Ethernet interface. If AP
has multiple Ethernet interfaces, this would be the MAC printed
on the unit label and referenced within the management system.
Vendors MUST reject attempts to configure this leaf.
    """
    return self.__mac
      
  def _set_mac(self, v, load=False):
    """
    Setter method for mac, mapped from YANG variable /provision_aps/provision_ap/config/mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac() directly.

    YANG Description: MAC address of the AP primary Ethernet interface. If AP
has multiple Ethernet interfaces, this would be the MAC printed
on the unit label and referenced within the management system.
Vendors MUST reject attempts to configure this leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac(self):
    self.__mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=True)


  def _get_hostname(self):
    """
    Getter method for hostname, mapped from YANG variable /provision_aps/provision_ap/config/hostname (oc-inet:domain-name)

    YANG Description: Hostname of the Access Point.
    """
    return self.__hostname
      
  def _set_hostname(self, v, load=False):
    """
    Setter method for hostname, mapped from YANG variable /provision_aps/provision_ap/config/hostname (oc-inet:domain-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hostname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hostname() directly.

    YANG Description: Hostname of the Access Point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hostname must be of a type compatible with oc-inet:domain-name""",
          'defined-type': "oc-inet:domain-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=True)""",
        })

    self.__hostname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hostname(self):
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=True)


  def _get_country_code(self):
    """
    Getter method for country_code, mapped from YANG variable /provision_aps/provision_ap/config/country_code (string)

    YANG Description: Country code where the AP operates in ISO 3166-1 alpha-2
format.
    """
    return self.__country_code
      
  def _set_country_code(self, v, load=False):
    """
    Setter method for country_code, mapped from YANG variable /provision_aps/provision_ap/config/country_code (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_country_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_country_code() directly.

    YANG Description: Country code where the AP operates in ISO 3166-1 alpha-2
format.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[A-Z]{2}'}), is_leaf=True, yang_name="country-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """country_code must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[A-Z]{2}'}), is_leaf=True, yang_name="country-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=True)""",
        })

    self.__country_code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_country_code(self):
    self.__country_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[A-Z]{2}'}), is_leaf=True, yang_name="country-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=True)

  mac = __builtin__.property(_get_mac, _set_mac)
  hostname = __builtin__.property(_get_hostname, _set_hostname)
  country_code = __builtin__.property(_get_country_code, _set_country_code)


  _pyangbind_elements = OrderedDict([('mac', mac), ('hostname', hostname), ('country_code', country_code), ])


class yc_state_openconfig_ap_manager__provision_aps_provision_ap_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ap-manager - based on the path /provision-aps/provision-ap/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for assigning hostnames to APs.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac','__hostname','__country_code',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/ap-manager'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=False)
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=False)
    self.__country_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[A-Z]{2}'}), is_leaf=True, yang_name="country-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['provision-aps', 'provision-ap', 'state']

  def _get_mac(self):
    """
    Getter method for mac, mapped from YANG variable /provision_aps/provision_ap/state/mac (oc-yang:mac-address)

    YANG Description: MAC address of the AP primary Ethernet interface. If AP
has multiple Ethernet interfaces, this would be the MAC printed
on the unit label and referenced within the management system.
Vendors MUST reject attempts to configure this leaf.
    """
    return self.__mac
      
  def _set_mac(self, v, load=False):
    """
    Setter method for mac, mapped from YANG variable /provision_aps/provision_ap/state/mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac() directly.

    YANG Description: MAC address of the AP primary Ethernet interface. If AP
has multiple Ethernet interfaces, this would be the MAC printed
on the unit label and referenced within the management system.
Vendors MUST reject attempts to configure this leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac(self):
    self.__mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=False)


  def _get_hostname(self):
    """
    Getter method for hostname, mapped from YANG variable /provision_aps/provision_ap/state/hostname (oc-inet:domain-name)

    YANG Description: Hostname of the Access Point.
    """
    return self.__hostname
      
  def _set_hostname(self, v, load=False):
    """
    Setter method for hostname, mapped from YANG variable /provision_aps/provision_ap/state/hostname (oc-inet:domain-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hostname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hostname() directly.

    YANG Description: Hostname of the Access Point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hostname must be of a type compatible with oc-inet:domain-name""",
          'defined-type': "oc-inet:domain-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=False)""",
        })

    self.__hostname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hostname(self):
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=False)


  def _get_country_code(self):
    """
    Getter method for country_code, mapped from YANG variable /provision_aps/provision_ap/state/country_code (string)

    YANG Description: Country code where the AP operates in ISO 3166-1 alpha-2
format.
    """
    return self.__country_code
      
  def _set_country_code(self, v, load=False):
    """
    Setter method for country_code, mapped from YANG variable /provision_aps/provision_ap/state/country_code (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_country_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_country_code() directly.

    YANG Description: Country code where the AP operates in ISO 3166-1 alpha-2
format.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[A-Z]{2}'}), is_leaf=True, yang_name="country-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """country_code must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[A-Z]{2}'}), is_leaf=True, yang_name="country-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)""",
        })

    self.__country_code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_country_code(self):
    self.__country_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[A-Z]{2}'}), is_leaf=True, yang_name="country-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)

  mac = __builtin__.property(_get_mac)
  hostname = __builtin__.property(_get_hostname)
  country_code = __builtin__.property(_get_country_code)


  _pyangbind_elements = OrderedDict([('mac', mac), ('hostname', hostname), ('country_code', country_code), ])


class yc_provision_ap_openconfig_ap_manager__provision_aps_provision_ap(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ap-manager - based on the path /provision-aps/provision-ap. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of MAC addresses that will have hostnames assigned.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac','__config','__state',)

  _yang_name = 'provision-ap'
  _yang_namespace = 'http://openconfig.net/yang/ap-manager'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_ap_manager__provision_aps_provision_ap_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_ap_manager__provision_aps_provision_ap_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['provision-aps', 'provision-ap']

  def _get_mac(self):
    """
    Getter method for mac, mapped from YANG variable /provision_aps/provision_ap/mac (leafref)

    YANG Description: Reference to the MAC address list key. This leaf is a reference
only and not to be configured.
    """
    return self.__mac
      
  def _set_mac(self, v, load=False):
    """
    Setter method for mac, mapped from YANG variable /provision_aps/provision_ap/mac (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac() directly.

    YANG Description: Reference to the MAC address list key. This leaf is a reference
only and not to be configured.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='leafref', is_config=True)""",
        })

    self.__mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac(self):
    self.__mac = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /provision_aps/provision_ap/config (container)

    YANG Description: Config container for assigning hostnames to APs.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /provision_aps/provision_ap/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Config container for assigning hostnames to APs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_ap_manager__provision_aps_provision_ap_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_ap_manager__provision_aps_provision_ap_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_ap_manager__provision_aps_provision_ap_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /provision_aps/provision_ap/state (container)

    YANG Description: State container for assigning hostnames to APs.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /provision_aps/provision_ap/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for assigning hostnames to APs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_ap_manager__provision_aps_provision_ap_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_ap_manager__provision_aps_provision_ap_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_ap_manager__provision_aps_provision_ap_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)

  mac = __builtin__.property(_get_mac, _set_mac)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('mac', mac), ('config', config), ('state', state), ])


class yc_provision_aps_openconfig_ap_manager__provision_aps(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ap-manager - based on the path /provision-aps. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top most container for assigning hostnames to APs.
  """
  __slots__ = ('_path_helper', '_extmethods', '__provision_ap',)

  _yang_name = 'provision-aps'
  _yang_namespace = 'http://openconfig.net/yang/ap-manager'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__provision_ap = YANGDynClass(base=YANGListType("mac",yc_provision_ap_openconfig_ap_manager__provision_aps_provision_ap, yang_name="provision-ap", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac', extensions=None), is_container='list', yang_name="provision-ap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['provision-aps']

  def _get_provision_ap(self):
    """
    Getter method for provision_ap, mapped from YANG variable /provision_aps/provision_ap (list)

    YANG Description: List of MAC addresses that will have hostnames assigned.
    """
    return self.__provision_ap
      
  def _set_provision_ap(self, v, load=False):
    """
    Setter method for provision_ap, mapped from YANG variable /provision_aps/provision_ap (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_provision_ap is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_provision_ap() directly.

    YANG Description: List of MAC addresses that will have hostnames assigned.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("mac",yc_provision_ap_openconfig_ap_manager__provision_aps_provision_ap, yang_name="provision-ap", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac', extensions=None), is_container='list', yang_name="provision-ap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """provision_ap must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("mac",yc_provision_ap_openconfig_ap_manager__provision_aps_provision_ap, yang_name="provision-ap", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac', extensions=None), is_container='list', yang_name="provision-ap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='list', is_config=True)""",
        })

    self.__provision_ap = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_provision_ap(self):
    self.__provision_ap = YANGDynClass(base=YANGListType("mac",yc_provision_ap_openconfig_ap_manager__provision_aps_provision_ap, yang_name="provision-ap", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac', extensions=None), is_container='list', yang_name="provision-ap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='list', is_config=True)

  provision_ap = __builtin__.property(_get_provision_ap, _set_provision_ap)


  _pyangbind_elements = OrderedDict([('provision_ap', provision_ap), ])


class yc_state_openconfig_ap_manager__joined_aps_joined_ap_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ap-manager - based on the path /joined-aps/joined-ap/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for Joined APs.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac','__hostname','__opstate','__up_time','__uptime','__enabled','__serial','__model','__software_version','__ipv4','__ipv6','__power_source',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/ap-manager'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=False)
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=False)
    self.__opstate = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="opstate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='identityref', is_config=False)
    self.__up_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-types:timeticks64', is_config=False)
    self.__uptime = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="uptime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='uint32', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='boolean', is_config=False)
    self.__serial = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)
    self.__model = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="model", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)
    self.__ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__power_source = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AT': {}, 'AF': {}, 'BT_TYPE3': {}, 'BT_TYPE4': {}, 'PLUG': {}},), is_leaf=True, yang_name="power-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['joined-aps', 'joined-ap', 'state']

  def _get_mac(self):
    """
    Getter method for mac, mapped from YANG variable /joined_aps/joined_ap/state/mac (oc-yang:mac-address)

    YANG Description: MAC address of the AP primary Ethernet interface. If AP
has multiple Ethernet interfaces, this would be the MAC printed
on the unit label and referenced within the management system.
Vendors MUST reject attempts to configure this leaf.
    """
    return self.__mac
      
  def _set_mac(self, v, load=False):
    """
    Setter method for mac, mapped from YANG variable /joined_aps/joined_ap/state/mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac() directly.

    YANG Description: MAC address of the AP primary Ethernet interface. If AP
has multiple Ethernet interfaces, this would be the MAC printed
on the unit label and referenced within the management system.
Vendors MUST reject attempts to configure this leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac(self):
    self.__mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-yang:mac-address', is_config=False)


  def _get_hostname(self):
    """
    Getter method for hostname, mapped from YANG variable /joined_aps/joined_ap/state/hostname (oc-inet:domain-name)

    YANG Description: Hostname of the Access Point.
    """
    return self.__hostname
      
  def _set_hostname(self, v, load=False):
    """
    Setter method for hostname, mapped from YANG variable /joined_aps/joined_ap/state/hostname (oc-inet:domain-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hostname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hostname() directly.

    YANG Description: Hostname of the Access Point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hostname must be of a type compatible with oc-inet:domain-name""",
          'defined-type': "oc-inet:domain-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=False)""",
        })

    self.__hostname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hostname(self):
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:domain-name', is_config=False)


  def _get_opstate(self):
    """
    Getter method for opstate, mapped from YANG variable /joined_aps/joined_ap/state/opstate (identityref)

    YANG Description: The current operational state of the AP.
    """
    return self.__opstate
      
  def _set_opstate(self, v, load=False):
    """
    Setter method for opstate, mapped from YANG variable /joined_aps/joined_ap/state/opstate (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_opstate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_opstate() directly.

    YANG Description: The current operational state of the AP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="opstate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """opstate must be of a type compatible with identityref""",
          'defined-type': "openconfig-ap-manager:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="opstate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='identityref', is_config=False)""",
        })

    self.__opstate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_opstate(self):
    self.__opstate = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:UP': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:DOWN': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:UPGRADING': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="opstate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='identityref', is_config=False)


  def _get_up_time(self):
    """
    Getter method for up_time, mapped from YANG variable /joined_aps/joined_ap/state/up_time (oc-types:timeticks64)

    YANG Description: Timestamp when this AP last changed its op-state to 'UP'. The value is
the timestamp in nanoseconds relative to the Unix Epoch (Jan 1, 1970
00:00:00 UTC).
    """
    return self.__up_time
      
  def _set_up_time(self, v, load=False):
    """
    Setter method for up_time, mapped from YANG variable /joined_aps/joined_ap/state/up_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up_time() directly.

    YANG Description: Timestamp when this AP last changed its op-state to 'UP'. The value is
the timestamp in nanoseconds relative to the Unix Epoch (Jan 1, 1970
00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__up_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up_time(self):
    self.__up_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-types:timeticks64', is_config=False)


  def _get_uptime(self):
    """
    Getter method for uptime, mapped from YANG variable /joined_aps/joined_ap/state/uptime (uint32)

    YANG Description: Seconds this AP has been in the op-state of 'UP'.
    """
    return self.__uptime
      
  def _set_uptime(self, v, load=False):
    """
    Setter method for uptime, mapped from YANG variable /joined_aps/joined_ap/state/uptime (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_uptime is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_uptime() directly.

    YANG Description: Seconds this AP has been in the op-state of 'UP'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="uptime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """uptime must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="uptime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='uint32', is_config=False)""",
        })

    self.__uptime = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_uptime(self):
    self.__uptime = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="uptime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='uint32', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /joined_aps/joined_ap/state/enabled (boolean)

    YANG Description: Wheather the AP is enabled or disabled.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /joined_aps/joined_ap/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Wheather the AP is enabled or disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='boolean', is_config=False)


  def _get_serial(self):
    """
    Getter method for serial, mapped from YANG variable /joined_aps/joined_ap/state/serial (string)

    YANG Description: Serial number of the Access Point.
    """
    return self.__serial
      
  def _set_serial(self, v, load=False):
    """
    Setter method for serial, mapped from YANG variable /joined_aps/joined_ap/state/serial (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_serial is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_serial() directly.

    YANG Description: Serial number of the Access Point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="serial", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """serial must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)""",
        })

    self.__serial = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_serial(self):
    self.__serial = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)


  def _get_model(self):
    """
    Getter method for model, mapped from YANG variable /joined_aps/joined_ap/state/model (string)

    YANG Description: Model number of the Access Point.
    """
    return self.__model
      
  def _set_model(self, v, load=False):
    """
    Setter method for model, mapped from YANG variable /joined_aps/joined_ap/state/model (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_model is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_model() directly.

    YANG Description: Model number of the Access Point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="model", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """model must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="model", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)""",
        })

    self.__model = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_model(self):
    self.__model = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="model", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)


  def _get_software_version(self):
    """
    Getter method for software_version, mapped from YANG variable /joined_aps/joined_ap/state/software_version (string)

    YANG Description: Software version of the Access Point.
    """
    return self.__software_version
      
  def _set_software_version(self, v, load=False):
    """
    Setter method for software_version, mapped from YANG variable /joined_aps/joined_ap/state/software_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_software_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_software_version() directly.

    YANG Description: Software version of the Access Point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """software_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)""",
        })

    self.__software_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_software_version(self):
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='string', is_config=False)


  def _get_ipv4(self):
    """
    Getter method for ipv4, mapped from YANG variable /joined_aps/joined_ap/state/ipv4 (oc-inet:ipv4-address)

    YANG Description: The IPv4 address of the Access Point.
    """
    return self.__ipv4
      
  def _set_ipv4(self, v, load=False):
    """
    Setter method for ipv4, mapped from YANG variable /joined_aps/joined_ap/state/ipv4 (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv4() directly.

    YANG Description: The IPv4 address of the Access Point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv4 must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv4(self):
    self.__ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_ipv6(self):
    """
    Getter method for ipv6, mapped from YANG variable /joined_aps/joined_ap/state/ipv6 (oc-inet:ipv6-address)

    YANG Description: The IPv6 address of the Access Point.
    """
    return self.__ipv6
      
  def _set_ipv6(self, v, load=False):
    """
    Setter method for ipv6, mapped from YANG variable /joined_aps/joined_ap/state/ipv6 (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6() directly.

    YANG Description: The IPv6 address of the Access Point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6 must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6(self):
    self.__ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_power_source(self):
    """
    Getter method for power_source, mapped from YANG variable /joined_aps/joined_ap/state/power_source (enumeration)

    YANG Description: Enumerate how the AP is being powered.
    """
    return self.__power_source
      
  def _set_power_source(self, v, load=False):
    """
    Setter method for power_source, mapped from YANG variable /joined_aps/joined_ap/state/power_source (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_power_source is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_power_source() directly.

    YANG Description: Enumerate how the AP is being powered.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AT': {}, 'AF': {}, 'BT_TYPE3': {}, 'BT_TYPE4': {}, 'PLUG': {}},), is_leaf=True, yang_name="power-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """power_source must be of a type compatible with enumeration""",
          'defined-type': "openconfig-ap-manager:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AT': {}, 'AF': {}, 'BT_TYPE3': {}, 'BT_TYPE4': {}, 'PLUG': {}},), is_leaf=True, yang_name="power-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='enumeration', is_config=False)""",
        })

    self.__power_source = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_power_source(self):
    self.__power_source = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AT': {}, 'AF': {}, 'BT_TYPE3': {}, 'BT_TYPE4': {}, 'PLUG': {}},), is_leaf=True, yang_name="power-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='enumeration', is_config=False)

  mac = __builtin__.property(_get_mac)
  hostname = __builtin__.property(_get_hostname)
  opstate = __builtin__.property(_get_opstate)
  up_time = __builtin__.property(_get_up_time)
  uptime = __builtin__.property(_get_uptime)
  enabled = __builtin__.property(_get_enabled)
  serial = __builtin__.property(_get_serial)
  model = __builtin__.property(_get_model)
  software_version = __builtin__.property(_get_software_version)
  ipv4 = __builtin__.property(_get_ipv4)
  ipv6 = __builtin__.property(_get_ipv6)
  power_source = __builtin__.property(_get_power_source)


  _pyangbind_elements = OrderedDict([('mac', mac), ('hostname', hostname), ('opstate', opstate), ('up_time', up_time), ('uptime', uptime), ('enabled', enabled), ('serial', serial), ('model', model), ('software_version', software_version), ('ipv4', ipv4), ('ipv6', ipv6), ('power_source', power_source), ])


class yc_joined_ap_openconfig_ap_manager__joined_aps_joined_ap(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ap-manager - based on the path /joined-aps/joined-ap. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of access points that have joined the controller.
  """
  __slots__ = ('_path_helper', '_extmethods', '__hostname','__state',)

  _yang_name = 'joined-ap'
  _yang_namespace = 'http://openconfig.net/yang/ap-manager'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__hostname = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_ap_manager__joined_aps_joined_ap_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['joined-aps', 'joined-ap']

  def _get_hostname(self):
    """
    Getter method for hostname, mapped from YANG variable /joined_aps/joined_ap/hostname (leafref)

    YANG Description: Reference to the MAC address list key.
    """
    return self.__hostname
      
  def _set_hostname(self, v, load=False):
    """
    Setter method for hostname, mapped from YANG variable /joined_aps/joined_ap/hostname (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hostname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hostname() directly.

    YANG Description: Reference to the MAC address list key.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hostname must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='leafref', is_config=False)""",
        })

    self.__hostname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hostname(self):
    self.__hostname = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /joined_aps/joined_ap/state (container)

    YANG Description: State container for Joined APs.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /joined_aps/joined_ap/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for Joined APs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_ap_manager__joined_aps_joined_ap_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_ap_manager__joined_aps_joined_ap_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_ap_manager__joined_aps_joined_ap_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=False)

  hostname = __builtin__.property(_get_hostname)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('hostname', hostname), ('state', state), ])


class yc_joined_aps_openconfig_ap_manager__joined_aps(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ap-manager - based on the path /joined-aps. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top most container for joined-aps.
  """
  __slots__ = ('_path_helper', '_extmethods', '__joined_ap',)

  _yang_name = 'joined-aps'
  _yang_namespace = 'http://openconfig.net/yang/ap-manager'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__joined_ap = YANGDynClass(base=YANGListType("hostname",yc_joined_ap_openconfig_ap_manager__joined_aps_joined_ap, yang_name="joined-ap", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='hostname', extensions=None), is_container='list', yang_name="joined-ap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['joined-aps']

  def _get_joined_ap(self):
    """
    Getter method for joined_ap, mapped from YANG variable /joined_aps/joined_ap (list)

    YANG Description: List of access points that have joined the controller.
    """
    return self.__joined_ap
      
  def _set_joined_ap(self, v, load=False):
    """
    Setter method for joined_ap, mapped from YANG variable /joined_aps/joined_ap (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_joined_ap is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_joined_ap() directly.

    YANG Description: List of access points that have joined the controller.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("hostname",yc_joined_ap_openconfig_ap_manager__joined_aps_joined_ap, yang_name="joined-ap", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='hostname', extensions=None), is_container='list', yang_name="joined-ap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """joined_ap must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("hostname",yc_joined_ap_openconfig_ap_manager__joined_aps_joined_ap, yang_name="joined-ap", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='hostname', extensions=None), is_container='list', yang_name="joined-ap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='list', is_config=True)""",
        })

    self.__joined_ap = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_joined_ap(self):
    self.__joined_ap = YANGDynClass(base=YANGListType("hostname",yc_joined_ap_openconfig_ap_manager__joined_aps_joined_ap, yang_name="joined-ap", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='hostname', extensions=None), is_container='list', yang_name="joined-ap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='list', is_config=True)

  joined_ap = __builtin__.property(_get_joined_ap, _set_joined_ap)


  _pyangbind_elements = OrderedDict([('joined_ap', joined_ap), ])


class openconfig_ap_manager(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ap-manager - based on the path /openconfig-ap-manager. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines the top level configuration and state data for a
system which manages Access Points.
  """
  __slots__ = ('_path_helper', '_extmethods', '__provision_aps','__joined_aps',)

  _yang_name = 'openconfig-ap-manager'
  _yang_namespace = 'http://openconfig.net/yang/ap-manager'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__provision_aps = YANGDynClass(base=yc_provision_aps_openconfig_ap_manager__provision_aps, is_container='container', yang_name="provision-aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)
    self.__joined_aps = YANGDynClass(base=yc_joined_aps_openconfig_ap_manager__joined_aps, is_container='container', yang_name="joined-aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_provision_aps(self):
    """
    Getter method for provision_aps, mapped from YANG variable /provision_aps (container)

    YANG Description: Top most container for assigning hostnames to APs.
    """
    return self.__provision_aps
      
  def _set_provision_aps(self, v, load=False):
    """
    Setter method for provision_aps, mapped from YANG variable /provision_aps (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_provision_aps is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_provision_aps() directly.

    YANG Description: Top most container for assigning hostnames to APs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_provision_aps_openconfig_ap_manager__provision_aps, is_container='container', yang_name="provision-aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """provision_aps must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_provision_aps_openconfig_ap_manager__provision_aps, is_container='container', yang_name="provision-aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)""",
        })

    self.__provision_aps = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_provision_aps(self):
    self.__provision_aps = YANGDynClass(base=yc_provision_aps_openconfig_ap_manager__provision_aps, is_container='container', yang_name="provision-aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)


  def _get_joined_aps(self):
    """
    Getter method for joined_aps, mapped from YANG variable /joined_aps (container)

    YANG Description: Top most container for joined-aps.
    """
    return self.__joined_aps
      
  def _set_joined_aps(self, v, load=False):
    """
    Setter method for joined_aps, mapped from YANG variable /joined_aps (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_joined_aps is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_joined_aps() directly.

    YANG Description: Top most container for joined-aps.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_joined_aps_openconfig_ap_manager__joined_aps, is_container='container', yang_name="joined-aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """joined_aps must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_joined_aps_openconfig_ap_manager__joined_aps, is_container='container', yang_name="joined-aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)""",
        })

    self.__joined_aps = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_joined_aps(self):
    self.__joined_aps = YANGDynClass(base=yc_joined_aps_openconfig_ap_manager__joined_aps, is_container='container', yang_name="joined-aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ap-manager', defining_module='openconfig-ap-manager', yang_type='container', is_config=True)

  provision_aps = __builtin__.property(_get_provision_aps, _set_provision_aps)
  joined_aps = __builtin__.property(_get_joined_aps, _set_joined_aps)


  _pyangbind_elements = OrderedDict([('provision_aps', provision_aps), ('joined_aps', joined_aps), ])


class yc_config_openconfig_access_points__access_points_access_point_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Config items at the global, Access Point level.
  """
  __slots__ = ('_path_helper', '_extmethods', '__hostname',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__hostname = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'config']

  def _get_hostname(self):
    """
    Getter method for hostname, mapped from YANG variable /access_points/access_point/config/hostname (leafref)

    YANG Description: Access Point FQDN.  This leaf is only valid when the type of the
component is WIFI_ACCESS_POINT, and should be used instead of
/oc-sys:system/oc-sys:state/oc-sys:hostname.
    """
    return self.__hostname
      
  def _set_hostname(self, v, load=False):
    """
    Setter method for hostname, mapped from YANG variable /access_points/access_point/config/hostname (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hostname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hostname() directly.

    YANG Description: Access Point FQDN.  This leaf is only valid when the type of the
component is WIFI_ACCESS_POINT, and should be used instead of
/oc-sys:system/oc-sys:state/oc-sys:hostname.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hostname must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)""",
        })

    self.__hostname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hostname(self):
    self.__hostname = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)

  hostname = __builtin__.property(_get_hostname, _set_hostname)


  _pyangbind_elements = OrderedDict([('hostname', hostname), ])


class yc_state_openconfig_access_points__access_points_access_point_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State items at the global, Access Point level.
  """
  __slots__ = ('_path_helper', '_extmethods', '__hostname',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__hostname = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'state']

  def _get_hostname(self):
    """
    Getter method for hostname, mapped from YANG variable /access_points/access_point/state/hostname (leafref)

    YANG Description: Access Point FQDN.  This leaf is only valid when the type of the
component is WIFI_ACCESS_POINT, and should be used instead of
/oc-sys:system/oc-sys:state/oc-sys:hostname.
    """
    return self.__hostname
      
  def _set_hostname(self, v, load=False):
    """
    Setter method for hostname, mapped from YANG variable /access_points/access_point/state/hostname (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hostname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hostname() directly.

    YANG Description: Access Point FQDN.  This leaf is only valid when the type of the
component is WIFI_ACCESS_POINT, and should be used instead of
/oc-sys:system/oc-sys:state/oc-sys:hostname.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hostname must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=False)""",
        })

    self.__hostname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hostname(self):
    self.__hostname = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=False)

  hostname = __builtin__.property(_get_hostname)


  _pyangbind_elements = OrderedDict([('hostname', hostname), ])


class yc_config_openconfig_access_points__access_points_access_point_radios_radio_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/radios/radio/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configurable items at the global, radio interface
level.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__operating_frequency','__enabled','__transmit_power','__transmit_eirp','__channel','__channel_width','__bss_coloring','__bss_color_id','__dca','__allowed_channels','__dtp','__dtp_min','__dtp_max','__antenna_gain','__scanning','__scanning_interval','__scanning_dwell_time','__scanning_defer_clients','__scanning_defer_traffic',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    self.__operating_frequency = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__transmit_power = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(9), is_leaf=True, yang_name="transmit-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)
    self.__transmit_eirp = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="transmit-eirp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    self.__channel = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..233']}), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    self.__channel_width = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(20), is_leaf=True, yang_name="channel-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    self.__bss_coloring = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="bss-coloring", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__bss_color_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    self.__dca = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dca", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__allowed_channels = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=True)
    self.__dtp = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dtp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__dtp_min = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(3), is_leaf=True, yang_name="dtp-min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)
    self.__dtp_max = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(15), is_leaf=True, yang_name="dtp-max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)
    self.__antenna_gain = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="antenna-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)
    self.__scanning = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="scanning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__scanning_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    self.__scanning_dwell_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="scanning-dwell-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)
    self.__scanning_defer_clients = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-defer-clients", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    self.__scanning_defer_traffic = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="scanning-defer-traffic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'radios', 'radio', 'config']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /access_points/access_point/radios/radio/config/id (uint8)

    YANG Description: Unique ID of the radio. Each ID has a corresponding
operating-frequency.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /access_points/access_point/radios/radio/config/id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Unique ID of the radio. Each ID has a corresponding
operating-frequency.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)


  def _get_operating_frequency(self):
    """
    Getter method for operating_frequency, mapped from YANG variable /access_points/access_point/radios/radio/config/operating_frequency (identityref)

    YANG Description: Operating frequency of this radio.
    """
    return self.__operating_frequency
      
  def _set_operating_frequency(self, v, load=False):
    """
    Setter method for operating_frequency, mapped from YANG variable /access_points/access_point/radios/radio/config/operating_frequency (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_operating_frequency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_operating_frequency() directly.

    YANG Description: Operating frequency of this radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """operating_frequency must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)""",
        })

    self.__operating_frequency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_operating_frequency(self):
    self.__operating_frequency = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /access_points/access_point/radios/radio/config/enabled (boolean)

    YANG Description: The configured state (enabled/disabled) of this radio
interface.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /access_points/access_point/radios/radio/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: The configured state (enabled/disabled) of this radio
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_transmit_power(self):
    """
    Getter method for transmit_power, mapped from YANG variable /access_points/access_point/radios/radio/config/transmit_power (int8)

    YANG Description: Transmit power of the radio, in dBm.
    """
    return self.__transmit_power
      
  def _set_transmit_power(self, v, load=False):
    """
    Setter method for transmit_power, mapped from YANG variable /access_points/access_point/radios/radio/config/transmit_power (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_power() directly.

    YANG Description: Transmit power of the radio, in dBm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(9), is_leaf=True, yang_name="transmit-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_power must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(9), is_leaf=True, yang_name="transmit-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)""",
        })

    self.__transmit_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_power(self):
    self.__transmit_power = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(9), is_leaf=True, yang_name="transmit-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)


  def _get_transmit_eirp(self):
    """
    Getter method for transmit_eirp, mapped from YANG variable /access_points/access_point/radios/radio/config/transmit_eirp (uint8)

    YANG Description: Transmit eirp of the radio + antenna, in dBm.
    """
    return self.__transmit_eirp
      
  def _set_transmit_eirp(self, v, load=False):
    """
    Setter method for transmit_eirp, mapped from YANG variable /access_points/access_point/radios/radio/config/transmit_eirp (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_eirp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_eirp() directly.

    YANG Description: Transmit eirp of the radio + antenna, in dBm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="transmit-eirp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_eirp must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="transmit-eirp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)""",
        })

    self.__transmit_eirp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_eirp(self):
    self.__transmit_eirp = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="transmit-eirp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)


  def _get_channel(self):
    """
    Getter method for channel, mapped from YANG variable /access_points/access_point/radios/radio/config/channel (uint8)

    YANG Description: Operating channel of this radio. If using channel-bonding
this will represent the Primary 20MHz channel of the
40,80,160MHz channel.
    """
    return self.__channel
      
  def _set_channel(self, v, load=False):
    """
    Setter method for channel, mapped from YANG variable /access_points/access_point/radios/radio/config/channel (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_channel() directly.

    YANG Description: Operating channel of this radio. If using channel-bonding
this will represent the Primary 20MHz channel of the
40,80,160MHz channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..233']}), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """channel must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..233']}), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)""",
        })

    self.__channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_channel(self):
    self.__channel = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..233']}), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)


  def _get_channel_width(self):
    """
    Getter method for channel_width, mapped from YANG variable /access_points/access_point/radios/radio/config/channel_width (uint8)

    YANG Description: Operating channel-width of this radio.
    """
    return self.__channel_width
      
  def _set_channel_width(self, v, load=False):
    """
    Setter method for channel_width, mapped from YANG variable /access_points/access_point/radios/radio/config/channel_width (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_channel_width is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_channel_width() directly.

    YANG Description: Operating channel-width of this radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(20), is_leaf=True, yang_name="channel-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """channel_width must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(20), is_leaf=True, yang_name="channel-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)""",
        })

    self.__channel_width = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_channel_width(self):
    self.__channel_width = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(20), is_leaf=True, yang_name="channel-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)


  def _get_bss_coloring(self):
    """
    Getter method for bss_coloring, mapped from YANG variable /access_points/access_point/radios/radio/config/bss_coloring (boolean)

    YANG Description: Utilize BSS coloring on this radio.
    """
    return self.__bss_coloring
      
  def _set_bss_coloring(self, v, load=False):
    """
    Setter method for bss_coloring, mapped from YANG variable /access_points/access_point/radios/radio/config/bss_coloring (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bss_coloring is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bss_coloring() directly.

    YANG Description: Utilize BSS coloring on this radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="bss-coloring", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bss_coloring must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="bss-coloring", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__bss_coloring = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bss_coloring(self):
    self.__bss_coloring = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="bss-coloring", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_bss_color_id(self):
    """
    Getter method for bss_color_id, mapped from YANG variable /access_points/access_point/radios/radio/config/bss_color_id (uint8)

    YANG Description: Numerical identifier of the BSS.
    """
    return self.__bss_color_id
      
  def _set_bss_color_id(self, v, load=False):
    """
    Setter method for bss_color_id, mapped from YANG variable /access_points/access_point/radios/radio/config/bss_color_id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bss_color_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bss_color_id() directly.

    YANG Description: Numerical identifier of the BSS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bss_color_id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)""",
        })

    self.__bss_color_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bss_color_id(self):
    self.__bss_color_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)


  def _get_dca(self):
    """
    Getter method for dca, mapped from YANG variable /access_points/access_point/radios/radio/config/dca (boolean)

    YANG Description: Utilize Dynamic Channel Assignment on this Radio.
    """
    return self.__dca
      
  def _set_dca(self, v, load=False):
    """
    Setter method for dca, mapped from YANG variable /access_points/access_point/radios/radio/config/dca (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dca is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dca() directly.

    YANG Description: Utilize Dynamic Channel Assignment on this Radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dca", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dca must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dca", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__dca = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dca(self):
    self.__dca = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dca", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_allowed_channels(self):
    """
    Getter method for allowed_channels, mapped from YANG variable /access_points/access_point/radios/radio/config/allowed_channels (oc-wifi-types:channels-type)

    YANG Description: Allowed channel list for this Radio to utilize.
    """
    return self.__allowed_channels
      
  def _set_allowed_channels(self, v, load=False):
    """
    Setter method for allowed_channels, mapped from YANG variable /access_points/access_point/radios/radio/config/allowed_channels (oc-wifi-types:channels-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_allowed_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_allowed_channels() directly.

    YANG Description: Allowed channel list for this Radio to utilize.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """allowed_channels must be of a type compatible with oc-wifi-types:channels-type""",
          'defined-type': "oc-wifi-types:channels-type",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=True)""",
        })

    self.__allowed_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_allowed_channels(self):
    self.__allowed_channels = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=True)


  def _get_dtp(self):
    """
    Getter method for dtp, mapped from YANG variable /access_points/access_point/radios/radio/config/dtp (boolean)

    YANG Description: Utilize dynamic transmit-power on this Radio.
    """
    return self.__dtp
      
  def _set_dtp(self, v, load=False):
    """
    Setter method for dtp, mapped from YANG variable /access_points/access_point/radios/radio/config/dtp (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dtp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dtp() directly.

    YANG Description: Utilize dynamic transmit-power on this Radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dtp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dtp must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dtp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__dtp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dtp(self):
    self.__dtp = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dtp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_dtp_min(self):
    """
    Getter method for dtp_min, mapped from YANG variable /access_points/access_point/radios/radio/config/dtp_min (int8)

    YANG Description: Minimum allowed transmit-power on this radio, if utilizing
dtp. Expressed in dBm.
    """
    return self.__dtp_min
      
  def _set_dtp_min(self, v, load=False):
    """
    Setter method for dtp_min, mapped from YANG variable /access_points/access_point/radios/radio/config/dtp_min (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dtp_min is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dtp_min() directly.

    YANG Description: Minimum allowed transmit-power on this radio, if utilizing
dtp. Expressed in dBm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(3), is_leaf=True, yang_name="dtp-min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dtp_min must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(3), is_leaf=True, yang_name="dtp-min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)""",
        })

    self.__dtp_min = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dtp_min(self):
    self.__dtp_min = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(3), is_leaf=True, yang_name="dtp-min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)


  def _get_dtp_max(self):
    """
    Getter method for dtp_max, mapped from YANG variable /access_points/access_point/radios/radio/config/dtp_max (int8)

    YANG Description: Maximum allowed transmit-power on this radio, if utilizing
dtp. Expressed in dBm.
    """
    return self.__dtp_max
      
  def _set_dtp_max(self, v, load=False):
    """
    Setter method for dtp_max, mapped from YANG variable /access_points/access_point/radios/radio/config/dtp_max (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dtp_max is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dtp_max() directly.

    YANG Description: Maximum allowed transmit-power on this radio, if utilizing
dtp. Expressed in dBm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(15), is_leaf=True, yang_name="dtp-max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dtp_max must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(15), is_leaf=True, yang_name="dtp-max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)""",
        })

    self.__dtp_max = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dtp_max(self):
    self.__dtp_max = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(15), is_leaf=True, yang_name="dtp-max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)


  def _get_antenna_gain(self):
    """
    Getter method for antenna_gain, mapped from YANG variable /access_points/access_point/radios/radio/config/antenna_gain (int8)

    YANG Description: Antenna gain applied to this Radio; typically used when
external antennae connected.
    """
    return self.__antenna_gain
      
  def _set_antenna_gain(self, v, load=False):
    """
    Setter method for antenna_gain, mapped from YANG variable /access_points/access_point/radios/radio/config/antenna_gain (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_antenna_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_antenna_gain() directly.

    YANG Description: Antenna gain applied to this Radio; typically used when
external antennae connected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="antenna-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """antenna_gain must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="antenna-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)""",
        })

    self.__antenna_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_antenna_gain(self):
    self.__antenna_gain = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="antenna-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=True)


  def _get_scanning(self):
    """
    Getter method for scanning, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning (boolean)

    YANG Description: Whether the radio will perform off-channel scanning, to
collect neighboring RF information.
    """
    return self.__scanning
      
  def _set_scanning(self, v, load=False):
    """
    Setter method for scanning, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning() directly.

    YANG Description: Whether the radio will perform off-channel scanning, to
collect neighboring RF information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="scanning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="scanning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__scanning = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning(self):
    self.__scanning = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="scanning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_scanning_interval(self):
    """
    Getter method for scanning_interval, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning_interval (uint8)

    YANG Description: How often, in seconds, the radio will go off-channel to
perform scanning.
    """
    return self.__scanning_interval
      
  def _set_scanning_interval(self, v, load=False):
    """
    Setter method for scanning_interval, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning_interval (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning_interval() directly.

    YANG Description: How often, in seconds, the radio will go off-channel to
perform scanning.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning_interval must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)""",
        })

    self.__scanning_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning_interval(self):
    self.__scanning_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)


  def _get_scanning_dwell_time(self):
    """
    Getter method for scanning_dwell_time, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning_dwell_time (uint16)

    YANG Description: Amount of time, in milliseconds, the radio will spend on a
channel during scanning-interval. If a Monitor-mode Radio, it
will cycle through scanning-allowed-channels spending this
amount of time on each.
    """
    return self.__scanning_dwell_time
      
  def _set_scanning_dwell_time(self, v, load=False):
    """
    Setter method for scanning_dwell_time, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning_dwell_time (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning_dwell_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning_dwell_time() directly.

    YANG Description: Amount of time, in milliseconds, the radio will spend on a
channel during scanning-interval. If a Monitor-mode Radio, it
will cycle through scanning-allowed-channels spending this
amount of time on each.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="scanning-dwell-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning_dwell_time must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="scanning-dwell-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)""",
        })

    self.__scanning_dwell_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning_dwell_time(self):
    self.__scanning_dwell_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="scanning-dwell-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)


  def _get_scanning_defer_clients(self):
    """
    Getter method for scanning_defer_clients, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning_defer_clients (uint8)

    YANG Description: Sets the number of associated stations after which the radio
should not perform scanning.
    """
    return self.__scanning_defer_clients
      
  def _set_scanning_defer_clients(self, v, load=False):
    """
    Setter method for scanning_defer_clients, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning_defer_clients (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning_defer_clients is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning_defer_clients() directly.

    YANG Description: Sets the number of associated stations after which the radio
should not perform scanning.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-defer-clients", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning_defer_clients must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-defer-clients", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)""",
        })

    self.__scanning_defer_clients = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning_defer_clients(self):
    self.__scanning_defer_clients = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-defer-clients", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=True)


  def _get_scanning_defer_traffic(self):
    """
    Getter method for scanning_defer_traffic, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning_defer_traffic (boolean)

    YANG Description: Do not perform scanning if any traffic received from an
active Station in the past 100ms marked as AC_VO or AC_VI.
    """
    return self.__scanning_defer_traffic
      
  def _set_scanning_defer_traffic(self, v, load=False):
    """
    Setter method for scanning_defer_traffic, mapped from YANG variable /access_points/access_point/radios/radio/config/scanning_defer_traffic (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning_defer_traffic is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning_defer_traffic() directly.

    YANG Description: Do not perform scanning if any traffic received from an
active Station in the past 100ms marked as AC_VO or AC_VI.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="scanning-defer-traffic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning_defer_traffic must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="scanning-defer-traffic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__scanning_defer_traffic = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning_defer_traffic(self):
    self.__scanning_defer_traffic = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="scanning-defer-traffic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  operating_frequency = __builtin__.property(_get_operating_frequency, _set_operating_frequency)
  enabled = __builtin__.property(_get_enabled, _set_enabled)
  transmit_power = __builtin__.property(_get_transmit_power, _set_transmit_power)
  transmit_eirp = __builtin__.property(_get_transmit_eirp, _set_transmit_eirp)
  channel = __builtin__.property(_get_channel, _set_channel)
  channel_width = __builtin__.property(_get_channel_width, _set_channel_width)
  bss_coloring = __builtin__.property(_get_bss_coloring, _set_bss_coloring)
  bss_color_id = __builtin__.property(_get_bss_color_id, _set_bss_color_id)
  dca = __builtin__.property(_get_dca, _set_dca)
  allowed_channels = __builtin__.property(_get_allowed_channels, _set_allowed_channels)
  dtp = __builtin__.property(_get_dtp, _set_dtp)
  dtp_min = __builtin__.property(_get_dtp_min, _set_dtp_min)
  dtp_max = __builtin__.property(_get_dtp_max, _set_dtp_max)
  antenna_gain = __builtin__.property(_get_antenna_gain, _set_antenna_gain)
  scanning = __builtin__.property(_get_scanning, _set_scanning)
  scanning_interval = __builtin__.property(_get_scanning_interval, _set_scanning_interval)
  scanning_dwell_time = __builtin__.property(_get_scanning_dwell_time, _set_scanning_dwell_time)
  scanning_defer_clients = __builtin__.property(_get_scanning_defer_clients, _set_scanning_defer_clients)
  scanning_defer_traffic = __builtin__.property(_get_scanning_defer_traffic, _set_scanning_defer_traffic)


  _pyangbind_elements = OrderedDict([('id', id), ('operating_frequency', operating_frequency), ('enabled', enabled), ('transmit_power', transmit_power), ('transmit_eirp', transmit_eirp), ('channel', channel), ('channel_width', channel_width), ('bss_coloring', bss_coloring), ('bss_color_id', bss_color_id), ('dca', dca), ('allowed_channels', allowed_channels), ('dtp', dtp), ('dtp_min', dtp_min), ('dtp_max', dtp_max), ('antenna_gain', antenna_gain), ('scanning', scanning), ('scanning_interval', scanning_interval), ('scanning_dwell_time', scanning_dwell_time), ('scanning_defer_clients', scanning_defer_clients), ('scanning_defer_traffic', scanning_defer_traffic), ])


class yc_counters_openconfig_access_points__access_points_access_point_radios_radio_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/radios/radio/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A collection of radio-related statistics objects.
  """
  __slots__ = ('_path_helper', '_extmethods', '__failed_fcs_frames','__noise_floor',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__failed_fcs_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failed-fcs-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__noise_floor = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="noise-floor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'radios', 'radio', 'state', 'counters']

  def _get_failed_fcs_frames(self):
    """
    Getter method for failed_fcs_frames, mapped from YANG variable /access_points/access_point/radios/radio/state/counters/failed_fcs_frames (oc-yang:counter64)

    YANG Description: Number of frames that failed the FCS.
    """
    return self.__failed_fcs_frames
      
  def _set_failed_fcs_frames(self, v, load=False):
    """
    Setter method for failed_fcs_frames, mapped from YANG variable /access_points/access_point/radios/radio/state/counters/failed_fcs_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_failed_fcs_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_failed_fcs_frames() directly.

    YANG Description: Number of frames that failed the FCS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failed-fcs-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """failed_fcs_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failed-fcs-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__failed_fcs_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_failed_fcs_frames(self):
    self.__failed_fcs_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failed-fcs-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_noise_floor(self):
    """
    Getter method for noise_floor, mapped from YANG variable /access_points/access_point/radios/radio/state/counters/noise_floor (int8)

    YANG Description: Noise Floor, as measured by this radio.
    """
    return self.__noise_floor
      
  def _set_noise_floor(self, v, load=False):
    """
    Setter method for noise_floor, mapped from YANG variable /access_points/access_point/radios/radio/state/counters/noise_floor (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_noise_floor is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_noise_floor() directly.

    YANG Description: Noise Floor, as measured by this radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="noise-floor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """noise_floor must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="noise-floor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)""",
        })

    self.__noise_floor = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_noise_floor(self):
    self.__noise_floor = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="noise-floor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)

  failed_fcs_frames = __builtin__.property(_get_failed_fcs_frames)
  noise_floor = __builtin__.property(_get_noise_floor)


  _pyangbind_elements = OrderedDict([('failed_fcs_frames', failed_fcs_frames), ('noise_floor', noise_floor), ])


class yc_state_openconfig_access_points__access_points_access_point_radios_radio_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/radios/radio/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data at the global radio level.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__operating_frequency','__enabled','__transmit_power','__transmit_eirp','__channel','__channel_width','__bss_coloring','__bss_color_id','__dca','__allowed_channels','__dtp','__dtp_min','__dtp_max','__antenna_gain','__scanning','__scanning_interval','__scanning_dwell_time','__scanning_defer_clients','__scanning_defer_traffic','__base_radio_mac','__allowed_regulatory_channels','__software_selectable','__dfs_hit_time','__supported_channels','__channel_change_reason','__total_channel_utilization','__rx_dot11_channel_utilization','__rx_noise_channel_utilization','__tx_dot11_channel_utilization','__obss_rx','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    self.__operating_frequency = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__transmit_power = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(9), is_leaf=True, yang_name="transmit-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    self.__transmit_eirp = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="transmit-eirp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    self.__channel = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..233']}), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    self.__channel_width = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(20), is_leaf=True, yang_name="channel-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    self.__bss_coloring = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="bss-coloring", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__bss_color_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    self.__dca = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dca", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__allowed_channels = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)
    self.__dtp = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dtp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__dtp_min = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(3), is_leaf=True, yang_name="dtp-min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    self.__dtp_max = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(15), is_leaf=True, yang_name="dtp-max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    self.__antenna_gain = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="antenna-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    self.__scanning = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="scanning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__scanning_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    self.__scanning_dwell_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="scanning-dwell-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    self.__scanning_defer_clients = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-defer-clients", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    self.__scanning_defer_traffic = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="scanning-defer-traffic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__base_radio_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="base-radio-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:mac-address', is_config=False)
    self.__allowed_regulatory_channels = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-regulatory-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)
    self.__software_selectable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="software-selectable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__dfs_hit_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dfs-hit-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:timeticks64', is_config=False)
    self.__supported_channels = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="supported-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)
    self.__channel_change_reason = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="channel-change-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__total_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="total-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    self.__rx_dot11_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    self.__rx_noise_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-noise-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    self.__tx_dot11_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="tx-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    self.__obss_rx = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="obss-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_access_points__access_points_access_point_radios_radio_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'radios', 'radio', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /access_points/access_point/radios/radio/state/id (uint8)

    YANG Description: Unique ID of the radio. Each ID has a corresponding
operating-frequency.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /access_points/access_point/radios/radio/state/id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Unique ID of the radio. Each ID has a corresponding
operating-frequency.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)


  def _get_operating_frequency(self):
    """
    Getter method for operating_frequency, mapped from YANG variable /access_points/access_point/radios/radio/state/operating_frequency (identityref)

    YANG Description: Operating frequency of this radio.
    """
    return self.__operating_frequency
      
  def _set_operating_frequency(self, v, load=False):
    """
    Setter method for operating_frequency, mapped from YANG variable /access_points/access_point/radios/radio/state/operating_frequency (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_operating_frequency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_operating_frequency() directly.

    YANG Description: Operating frequency of this radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """operating_frequency must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__operating_frequency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_operating_frequency(self):
    self.__operating_frequency = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /access_points/access_point/radios/radio/state/enabled (boolean)

    YANG Description: The configured state (enabled/disabled) of this radio
interface.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /access_points/access_point/radios/radio/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: The configured state (enabled/disabled) of this radio
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_transmit_power(self):
    """
    Getter method for transmit_power, mapped from YANG variable /access_points/access_point/radios/radio/state/transmit_power (int8)

    YANG Description: Transmit power of the radio, in dBm.
    """
    return self.__transmit_power
      
  def _set_transmit_power(self, v, load=False):
    """
    Setter method for transmit_power, mapped from YANG variable /access_points/access_point/radios/radio/state/transmit_power (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_power() directly.

    YANG Description: Transmit power of the radio, in dBm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(9), is_leaf=True, yang_name="transmit-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_power must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(9), is_leaf=True, yang_name="transmit-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)""",
        })

    self.__transmit_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_power(self):
    self.__transmit_power = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(9), is_leaf=True, yang_name="transmit-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)


  def _get_transmit_eirp(self):
    """
    Getter method for transmit_eirp, mapped from YANG variable /access_points/access_point/radios/radio/state/transmit_eirp (uint8)

    YANG Description: Transmit eirp of the radio + antenna, in dBm.
    """
    return self.__transmit_eirp
      
  def _set_transmit_eirp(self, v, load=False):
    """
    Setter method for transmit_eirp, mapped from YANG variable /access_points/access_point/radios/radio/state/transmit_eirp (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_eirp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_eirp() directly.

    YANG Description: Transmit eirp of the radio + antenna, in dBm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="transmit-eirp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_eirp must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="transmit-eirp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)""",
        })

    self.__transmit_eirp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_eirp(self):
    self.__transmit_eirp = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="transmit-eirp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)


  def _get_channel(self):
    """
    Getter method for channel, mapped from YANG variable /access_points/access_point/radios/radio/state/channel (uint8)

    YANG Description: Operating channel of this radio. If using channel-bonding
this will represent the Primary 20MHz channel of the
40,80,160MHz channel.
    """
    return self.__channel
      
  def _set_channel(self, v, load=False):
    """
    Setter method for channel, mapped from YANG variable /access_points/access_point/radios/radio/state/channel (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_channel() directly.

    YANG Description: Operating channel of this radio. If using channel-bonding
this will represent the Primary 20MHz channel of the
40,80,160MHz channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..233']}), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """channel must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..233']}), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)""",
        })

    self.__channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_channel(self):
    self.__channel = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..233']}), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)


  def _get_channel_width(self):
    """
    Getter method for channel_width, mapped from YANG variable /access_points/access_point/radios/radio/state/channel_width (uint8)

    YANG Description: Operating channel-width of this radio.
    """
    return self.__channel_width
      
  def _set_channel_width(self, v, load=False):
    """
    Setter method for channel_width, mapped from YANG variable /access_points/access_point/radios/radio/state/channel_width (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_channel_width is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_channel_width() directly.

    YANG Description: Operating channel-width of this radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(20), is_leaf=True, yang_name="channel-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """channel_width must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(20), is_leaf=True, yang_name="channel-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)""",
        })

    self.__channel_width = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_channel_width(self):
    self.__channel_width = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(20), is_leaf=True, yang_name="channel-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)


  def _get_bss_coloring(self):
    """
    Getter method for bss_coloring, mapped from YANG variable /access_points/access_point/radios/radio/state/bss_coloring (boolean)

    YANG Description: Utilize BSS coloring on this radio.
    """
    return self.__bss_coloring
      
  def _set_bss_coloring(self, v, load=False):
    """
    Setter method for bss_coloring, mapped from YANG variable /access_points/access_point/radios/radio/state/bss_coloring (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bss_coloring is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bss_coloring() directly.

    YANG Description: Utilize BSS coloring on this radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="bss-coloring", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bss_coloring must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="bss-coloring", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__bss_coloring = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bss_coloring(self):
    self.__bss_coloring = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="bss-coloring", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_bss_color_id(self):
    """
    Getter method for bss_color_id, mapped from YANG variable /access_points/access_point/radios/radio/state/bss_color_id (uint8)

    YANG Description: Numerical identifier of the BSS.
    """
    return self.__bss_color_id
      
  def _set_bss_color_id(self, v, load=False):
    """
    Setter method for bss_color_id, mapped from YANG variable /access_points/access_point/radios/radio/state/bss_color_id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bss_color_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bss_color_id() directly.

    YANG Description: Numerical identifier of the BSS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bss_color_id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)""",
        })

    self.__bss_color_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bss_color_id(self):
    self.__bss_color_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)


  def _get_dca(self):
    """
    Getter method for dca, mapped from YANG variable /access_points/access_point/radios/radio/state/dca (boolean)

    YANG Description: Utilize Dynamic Channel Assignment on this Radio.
    """
    return self.__dca
      
  def _set_dca(self, v, load=False):
    """
    Setter method for dca, mapped from YANG variable /access_points/access_point/radios/radio/state/dca (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dca is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dca() directly.

    YANG Description: Utilize Dynamic Channel Assignment on this Radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dca", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dca must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dca", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__dca = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dca(self):
    self.__dca = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dca", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_allowed_channels(self):
    """
    Getter method for allowed_channels, mapped from YANG variable /access_points/access_point/radios/radio/state/allowed_channels (oc-wifi-types:channels-type)

    YANG Description: Allowed channel list for this Radio to utilize.
    """
    return self.__allowed_channels
      
  def _set_allowed_channels(self, v, load=False):
    """
    Setter method for allowed_channels, mapped from YANG variable /access_points/access_point/radios/radio/state/allowed_channels (oc-wifi-types:channels-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_allowed_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_allowed_channels() directly.

    YANG Description: Allowed channel list for this Radio to utilize.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """allowed_channels must be of a type compatible with oc-wifi-types:channels-type""",
          'defined-type': "oc-wifi-types:channels-type",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)""",
        })

    self.__allowed_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_allowed_channels(self):
    self.__allowed_channels = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)


  def _get_dtp(self):
    """
    Getter method for dtp, mapped from YANG variable /access_points/access_point/radios/radio/state/dtp (boolean)

    YANG Description: Utilize dynamic transmit-power on this Radio.
    """
    return self.__dtp
      
  def _set_dtp(self, v, load=False):
    """
    Setter method for dtp, mapped from YANG variable /access_points/access_point/radios/radio/state/dtp (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dtp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dtp() directly.

    YANG Description: Utilize dynamic transmit-power on this Radio.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dtp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dtp must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dtp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__dtp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dtp(self):
    self.__dtp = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="dtp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_dtp_min(self):
    """
    Getter method for dtp_min, mapped from YANG variable /access_points/access_point/radios/radio/state/dtp_min (int8)

    YANG Description: Minimum allowed transmit-power on this radio, if utilizing
dtp. Expressed in dBm.
    """
    return self.__dtp_min
      
  def _set_dtp_min(self, v, load=False):
    """
    Setter method for dtp_min, mapped from YANG variable /access_points/access_point/radios/radio/state/dtp_min (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dtp_min is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dtp_min() directly.

    YANG Description: Minimum allowed transmit-power on this radio, if utilizing
dtp. Expressed in dBm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(3), is_leaf=True, yang_name="dtp-min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dtp_min must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(3), is_leaf=True, yang_name="dtp-min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)""",
        })

    self.__dtp_min = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dtp_min(self):
    self.__dtp_min = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(3), is_leaf=True, yang_name="dtp-min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)


  def _get_dtp_max(self):
    """
    Getter method for dtp_max, mapped from YANG variable /access_points/access_point/radios/radio/state/dtp_max (int8)

    YANG Description: Maximum allowed transmit-power on this radio, if utilizing
dtp. Expressed in dBm.
    """
    return self.__dtp_max
      
  def _set_dtp_max(self, v, load=False):
    """
    Setter method for dtp_max, mapped from YANG variable /access_points/access_point/radios/radio/state/dtp_max (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dtp_max is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dtp_max() directly.

    YANG Description: Maximum allowed transmit-power on this radio, if utilizing
dtp. Expressed in dBm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(15), is_leaf=True, yang_name="dtp-max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dtp_max must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(15), is_leaf=True, yang_name="dtp-max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)""",
        })

    self.__dtp_max = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dtp_max(self):
    self.__dtp_max = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8)(15), is_leaf=True, yang_name="dtp-max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)


  def _get_antenna_gain(self):
    """
    Getter method for antenna_gain, mapped from YANG variable /access_points/access_point/radios/radio/state/antenna_gain (int8)

    YANG Description: Antenna gain applied to this Radio; typically used when
external antennae connected.
    """
    return self.__antenna_gain
      
  def _set_antenna_gain(self, v, load=False):
    """
    Setter method for antenna_gain, mapped from YANG variable /access_points/access_point/radios/radio/state/antenna_gain (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_antenna_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_antenna_gain() directly.

    YANG Description: Antenna gain applied to this Radio; typically used when
external antennae connected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="antenna-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """antenna_gain must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="antenna-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)""",
        })

    self.__antenna_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_antenna_gain(self):
    self.__antenna_gain = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="antenna-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)


  def _get_scanning(self):
    """
    Getter method for scanning, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning (boolean)

    YANG Description: Whether the radio will perform off-channel scanning, to
collect neighboring RF information.
    """
    return self.__scanning
      
  def _set_scanning(self, v, load=False):
    """
    Setter method for scanning, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning() directly.

    YANG Description: Whether the radio will perform off-channel scanning, to
collect neighboring RF information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="scanning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="scanning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__scanning = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning(self):
    self.__scanning = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="scanning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_scanning_interval(self):
    """
    Getter method for scanning_interval, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning_interval (uint8)

    YANG Description: How often, in seconds, the radio will go off-channel to
perform scanning.
    """
    return self.__scanning_interval
      
  def _set_scanning_interval(self, v, load=False):
    """
    Setter method for scanning_interval, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning_interval (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning_interval() directly.

    YANG Description: How often, in seconds, the radio will go off-channel to
perform scanning.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning_interval must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)""",
        })

    self.__scanning_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning_interval(self):
    self.__scanning_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)


  def _get_scanning_dwell_time(self):
    """
    Getter method for scanning_dwell_time, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning_dwell_time (uint16)

    YANG Description: Amount of time, in milliseconds, the radio will spend on a
channel during scanning-interval. If a Monitor-mode Radio, it
will cycle through scanning-allowed-channels spending this
amount of time on each.
    """
    return self.__scanning_dwell_time
      
  def _set_scanning_dwell_time(self, v, load=False):
    """
    Setter method for scanning_dwell_time, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning_dwell_time (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning_dwell_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning_dwell_time() directly.

    YANG Description: Amount of time, in milliseconds, the radio will spend on a
channel during scanning-interval. If a Monitor-mode Radio, it
will cycle through scanning-allowed-channels spending this
amount of time on each.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="scanning-dwell-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning_dwell_time must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="scanning-dwell-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)""",
        })

    self.__scanning_dwell_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning_dwell_time(self):
    self.__scanning_dwell_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="scanning-dwell-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)


  def _get_scanning_defer_clients(self):
    """
    Getter method for scanning_defer_clients, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning_defer_clients (uint8)

    YANG Description: Sets the number of associated stations after which the radio
should not perform scanning.
    """
    return self.__scanning_defer_clients
      
  def _set_scanning_defer_clients(self, v, load=False):
    """
    Setter method for scanning_defer_clients, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning_defer_clients (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning_defer_clients is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning_defer_clients() directly.

    YANG Description: Sets the number of associated stations after which the radio
should not perform scanning.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-defer-clients", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning_defer_clients must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-defer-clients", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)""",
        })

    self.__scanning_defer_clients = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning_defer_clients(self):
    self.__scanning_defer_clients = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="scanning-defer-clients", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)


  def _get_scanning_defer_traffic(self):
    """
    Getter method for scanning_defer_traffic, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning_defer_traffic (boolean)

    YANG Description: Do not perform scanning if any traffic received from an
active Station in the past 100ms marked as AC_VO or AC_VI.
    """
    return self.__scanning_defer_traffic
      
  def _set_scanning_defer_traffic(self, v, load=False):
    """
    Setter method for scanning_defer_traffic, mapped from YANG variable /access_points/access_point/radios/radio/state/scanning_defer_traffic (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scanning_defer_traffic is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scanning_defer_traffic() directly.

    YANG Description: Do not perform scanning if any traffic received from an
active Station in the past 100ms marked as AC_VO or AC_VI.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="scanning-defer-traffic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scanning_defer_traffic must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="scanning-defer-traffic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__scanning_defer_traffic = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scanning_defer_traffic(self):
    self.__scanning_defer_traffic = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="scanning-defer-traffic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_base_radio_mac(self):
    """
    Getter method for base_radio_mac, mapped from YANG variable /access_points/access_point/radios/radio/state/base_radio_mac (oc-yang:mac-address)

    YANG Description: Represents the 'burned-in' base-radio MAC
address for the a Radio interface.
    """
    return self.__base_radio_mac
      
  def _set_base_radio_mac(self, v, load=False):
    """
    Setter method for base_radio_mac, mapped from YANG variable /access_points/access_point/radios/radio/state/base_radio_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_base_radio_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_base_radio_mac() directly.

    YANG Description: Represents the 'burned-in' base-radio MAC
address for the a Radio interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="base-radio-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """base_radio_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="base-radio-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__base_radio_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_base_radio_mac(self):
    self.__base_radio_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="base-radio-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:mac-address', is_config=False)


  def _get_allowed_regulatory_channels(self):
    """
    Getter method for allowed_regulatory_channels, mapped from YANG variable /access_points/access_point/radios/radio/state/allowed_regulatory_channels (oc-wifi-types:channels-type)

    YANG Description: Allowed channels, per regulatory restrictions, this Radio is
capable of using. This is typically a combination of AP
certification and allowed frequencies per country.
    """
    return self.__allowed_regulatory_channels
      
  def _set_allowed_regulatory_channels(self, v, load=False):
    """
    Setter method for allowed_regulatory_channels, mapped from YANG variable /access_points/access_point/radios/radio/state/allowed_regulatory_channels (oc-wifi-types:channels-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_allowed_regulatory_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_allowed_regulatory_channels() directly.

    YANG Description: Allowed channels, per regulatory restrictions, this Radio is
capable of using. This is typically a combination of AP
certification and allowed frequencies per country.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-regulatory-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """allowed_regulatory_channels must be of a type compatible with oc-wifi-types:channels-type""",
          'defined-type': "oc-wifi-types:channels-type",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-regulatory-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)""",
        })

    self.__allowed_regulatory_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_allowed_regulatory_channels(self):
    self.__allowed_regulatory_channels = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="allowed-regulatory-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)


  def _get_software_selectable(self):
    """
    Getter method for software_selectable, mapped from YANG variable /access_points/access_point/radios/radio/state/software_selectable (boolean)

    YANG Description: Indicates whether or not the operating frequency can be
configured by the operator.
    """
    return self.__software_selectable
      
  def _set_software_selectable(self, v, load=False):
    """
    Setter method for software_selectable, mapped from YANG variable /access_points/access_point/radios/radio/state/software_selectable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_software_selectable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_software_selectable() directly.

    YANG Description: Indicates whether or not the operating frequency can be
configured by the operator.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="software-selectable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """software_selectable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="software-selectable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__software_selectable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_software_selectable(self):
    self.__software_selectable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="software-selectable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_dfs_hit_time(self):
    """
    Getter method for dfs_hit_time, mapped from YANG variable /access_points/access_point/radios/radio/state/dfs_hit_time (oc-types:timeticks64)

    YANG Description: Reports the time of the last DFS hit. The value is the
timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    return self.__dfs_hit_time
      
  def _set_dfs_hit_time(self, v, load=False):
    """
    Setter method for dfs_hit_time, mapped from YANG variable /access_points/access_point/radios/radio/state/dfs_hit_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dfs_hit_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dfs_hit_time() directly.

    YANG Description: Reports the time of the last DFS hit. The value is the
timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dfs-hit-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dfs_hit_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dfs-hit-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__dfs_hit_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dfs_hit_time(self):
    self.__dfs_hit_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dfs-hit-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:timeticks64', is_config=False)


  def _get_supported_channels(self):
    """
    Getter method for supported_channels, mapped from YANG variable /access_points/access_point/radios/radio/state/supported_channels (oc-wifi-types:channels-type)

    YANG Description: Channels allowed by a combination of regulatory and AP certification
restrictions.
    """
    return self.__supported_channels
      
  def _set_supported_channels(self, v, load=False):
    """
    Setter method for supported_channels, mapped from YANG variable /access_points/access_point/radios/radio/state/supported_channels (oc-wifi-types:channels-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_channels() directly.

    YANG Description: Channels allowed by a combination of regulatory and AP certification
restrictions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="supported-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_channels must be of a type compatible with oc-wifi-types:channels-type""",
          'defined-type': "oc-wifi-types:channels-type",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="supported-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)""",
        })

    self.__supported_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_channels(self):
    self.__supported_channels = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..14', '17', '21', '25', '29', '33', '36', '37', '40', '41', '44', '45', '48', '49', '52', '53', '56', '57', '60', '61', '64', '65', '69', '73', '77', '81', '85', '89', '93', '97', '100', '101', '104', '105', '108', '109', '112', '113', '116', '117', '120', '121', '124', '125', '128', '129', '132', '133', '136', '137', '140', '141', '144', '145', '149', '153', '157', '161', '165', '169', '173', '177', '181', '185', '189', '193', '197', '201', '205', '209', '213', '217', '221', '225', '229', '233']})), is_leaf=False, yang_name="supported-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-wifi-types:channels-type', is_config=False)


  def _get_channel_change_reason(self):
    """
    Getter method for channel_change_reason, mapped from YANG variable /access_points/access_point/radios/radio/state/channel_change_reason (identityref)

    YANG Description: When an Access Point changes channels, this will
provide the reason that led to the change.
    """
    return self.__channel_change_reason
      
  def _set_channel_change_reason(self, v, load=False):
    """
    Setter method for channel_change_reason, mapped from YANG variable /access_points/access_point/radios/radio/state/channel_change_reason (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_channel_change_reason is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_channel_change_reason() directly.

    YANG Description: When an Access Point changes channels, this will
provide the reason that led to the change.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="channel-change-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """channel_change_reason must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="channel-change-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__channel_change_reason = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_channel_change_reason(self):
    self.__channel_change_reason = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:DFS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:NOISE': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:ERRORS': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:BETTER_CHANNEL': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), is_leaf=True, yang_name="channel-change-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_total_channel_utilization(self):
    """
    Getter method for total_channel_utilization, mapped from YANG variable /access_points/access_point/radios/radio/state/total_channel_utilization (oc-types:percentage)

    YANG Description: Total 802.11 and non-802.11 channel utilization on this
Radio. The total channel utilization should include all time
periods the AP spent actively receiving and transmitting
802.11 frames, and also include all time spent with clear
channel assessment (CCA) in a busy state.
    """
    return self.__total_channel_utilization
      
  def _set_total_channel_utilization(self, v, load=False):
    """
    Setter method for total_channel_utilization, mapped from YANG variable /access_points/access_point/radios/radio/state/total_channel_utilization (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_channel_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_channel_utilization() directly.

    YANG Description: Total 802.11 and non-802.11 channel utilization on this
Radio. The total channel utilization should include all time
periods the AP spent actively receiving and transmitting
802.11 frames, and also include all time spent with clear
channel assessment (CCA) in a busy state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="total-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_channel_utilization must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="total-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__total_channel_utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_channel_utilization(self):
    self.__total_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="total-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)


  def _get_rx_dot11_channel_utilization(self):
    """
    Getter method for rx_dot11_channel_utilization, mapped from YANG variable /access_points/access_point/radios/radio/state/rx_dot11_channel_utilization (oc-types:percentage)

    YANG Description: Received channel-utilization due to any 802.11 frames, destined to this
radio or otherwise.
    """
    return self.__rx_dot11_channel_utilization
      
  def _set_rx_dot11_channel_utilization(self, v, load=False):
    """
    Setter method for rx_dot11_channel_utilization, mapped from YANG variable /access_points/access_point/radios/radio/state/rx_dot11_channel_utilization (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_dot11_channel_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_dot11_channel_utilization() directly.

    YANG Description: Received channel-utilization due to any 802.11 frames, destined to this
radio or otherwise.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_dot11_channel_utilization must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__rx_dot11_channel_utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_dot11_channel_utilization(self):
    self.__rx_dot11_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)


  def _get_rx_noise_channel_utilization(self):
    """
    Getter method for rx_noise_channel_utilization, mapped from YANG variable /access_points/access_point/radios/radio/state/rx_noise_channel_utilization (oc-types:percentage)

    YANG Description: Received channel-utilization percentage due to noise.
    """
    return self.__rx_noise_channel_utilization
      
  def _set_rx_noise_channel_utilization(self, v, load=False):
    """
    Setter method for rx_noise_channel_utilization, mapped from YANG variable /access_points/access_point/radios/radio/state/rx_noise_channel_utilization (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_noise_channel_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_noise_channel_utilization() directly.

    YANG Description: Received channel-utilization percentage due to noise.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-noise-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_noise_channel_utilization must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-noise-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__rx_noise_channel_utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_noise_channel_utilization(self):
    self.__rx_noise_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-noise-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)


  def _get_tx_dot11_channel_utilization(self):
    """
    Getter method for tx_dot11_channel_utilization, mapped from YANG variable /access_points/access_point/radios/radio/state/tx_dot11_channel_utilization (oc-types:percentage)

    YANG Description: Transmit channel-utilization percentage.
    """
    return self.__tx_dot11_channel_utilization
      
  def _set_tx_dot11_channel_utilization(self, v, load=False):
    """
    Setter method for tx_dot11_channel_utilization, mapped from YANG variable /access_points/access_point/radios/radio/state/tx_dot11_channel_utilization (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_dot11_channel_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_dot11_channel_utilization() directly.

    YANG Description: Transmit channel-utilization percentage.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="tx-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_dot11_channel_utilization must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="tx-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__tx_dot11_channel_utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_dot11_channel_utilization(self):
    self.__tx_dot11_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="tx-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)


  def _get_obss_rx(self):
    """
    Getter method for obss_rx, mapped from YANG variable /access_points/access_point/radios/radio/state/obss_rx (oc-types:percentage)

    YANG Description: Received channel utilization due to 802.11 frames NOT destined to a
BSS on this AP ('Overlapping BSS').
    """
    return self.__obss_rx
      
  def _set_obss_rx(self, v, load=False):
    """
    Setter method for obss_rx, mapped from YANG variable /access_points/access_point/radios/radio/state/obss_rx (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_obss_rx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_obss_rx() directly.

    YANG Description: Received channel utilization due to 802.11 frames NOT destined to a
BSS on this AP ('Overlapping BSS').
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="obss-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """obss_rx must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="obss-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__obss_rx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_obss_rx(self):
    self.__obss_rx = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="obss-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /access_points/access_point/radios/radio/state/counters (container)

    YANG Description: A collection of radio-related statistics objects.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /access_points/access_point/radios/radio/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: A collection of radio-related statistics objects.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_access_points__access_points_access_point_radios_radio_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_access_points__access_points_access_point_radios_radio_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_access_points__access_points_access_point_radios_radio_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  operating_frequency = __builtin__.property(_get_operating_frequency)
  enabled = __builtin__.property(_get_enabled)
  transmit_power = __builtin__.property(_get_transmit_power)
  transmit_eirp = __builtin__.property(_get_transmit_eirp)
  channel = __builtin__.property(_get_channel)
  channel_width = __builtin__.property(_get_channel_width)
  bss_coloring = __builtin__.property(_get_bss_coloring)
  bss_color_id = __builtin__.property(_get_bss_color_id)
  dca = __builtin__.property(_get_dca)
  allowed_channels = __builtin__.property(_get_allowed_channels)
  dtp = __builtin__.property(_get_dtp)
  dtp_min = __builtin__.property(_get_dtp_min)
  dtp_max = __builtin__.property(_get_dtp_max)
  antenna_gain = __builtin__.property(_get_antenna_gain)
  scanning = __builtin__.property(_get_scanning)
  scanning_interval = __builtin__.property(_get_scanning_interval)
  scanning_dwell_time = __builtin__.property(_get_scanning_dwell_time)
  scanning_defer_clients = __builtin__.property(_get_scanning_defer_clients)
  scanning_defer_traffic = __builtin__.property(_get_scanning_defer_traffic)
  base_radio_mac = __builtin__.property(_get_base_radio_mac)
  allowed_regulatory_channels = __builtin__.property(_get_allowed_regulatory_channels)
  software_selectable = __builtin__.property(_get_software_selectable)
  dfs_hit_time = __builtin__.property(_get_dfs_hit_time)
  supported_channels = __builtin__.property(_get_supported_channels)
  channel_change_reason = __builtin__.property(_get_channel_change_reason)
  total_channel_utilization = __builtin__.property(_get_total_channel_utilization)
  rx_dot11_channel_utilization = __builtin__.property(_get_rx_dot11_channel_utilization)
  rx_noise_channel_utilization = __builtin__.property(_get_rx_noise_channel_utilization)
  tx_dot11_channel_utilization = __builtin__.property(_get_tx_dot11_channel_utilization)
  obss_rx = __builtin__.property(_get_obss_rx)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('id', id), ('operating_frequency', operating_frequency), ('enabled', enabled), ('transmit_power', transmit_power), ('transmit_eirp', transmit_eirp), ('channel', channel), ('channel_width', channel_width), ('bss_coloring', bss_coloring), ('bss_color_id', bss_color_id), ('dca', dca), ('allowed_channels', allowed_channels), ('dtp', dtp), ('dtp_min', dtp_min), ('dtp_max', dtp_max), ('antenna_gain', antenna_gain), ('scanning', scanning), ('scanning_interval', scanning_interval), ('scanning_dwell_time', scanning_dwell_time), ('scanning_defer_clients', scanning_defer_clients), ('scanning_defer_traffic', scanning_defer_traffic), ('base_radio_mac', base_radio_mac), ('allowed_regulatory_channels', allowed_regulatory_channels), ('software_selectable', software_selectable), ('dfs_hit_time', dfs_hit_time), ('supported_channels', supported_channels), ('channel_change_reason', channel_change_reason), ('total_channel_utilization', total_channel_utilization), ('rx_dot11_channel_utilization', rx_dot11_channel_utilization), ('rx_noise_channel_utilization', rx_noise_channel_utilization), ('tx_dot11_channel_utilization', tx_dot11_channel_utilization), ('obss_rx', obss_rx), ('counters', counters), ])


class yc_state_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/radios/radio/neighbors/neighbor/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for RF neighbors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__bssid','__ssid','__rssi','__channel','__primary_channel','__bss_color_id','__last_seen','__opmode',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__bssid = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:mac-address', is_config=False)
    self.__ssid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    self.__rssi = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="rssi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    self.__channel = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    self.__primary_channel = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="primary-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    self.__bss_color_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    self.__last_seen = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-seen", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:timeticks64', is_config=False)
    self.__opmode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'WPA_PERSONAL': {}, 'WPA_ENTERPRISE': {}, 'WEP': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'radios', 'radio', 'neighbors', 'neighbor', 'state']

  def _get_bssid(self):
    """
    Getter method for bssid, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/bssid (oc-yang:mac-address)

    YANG Description: Neighboring BSSID.
    """
    return self.__bssid
      
  def _set_bssid(self, v, load=False):
    """
    Setter method for bssid, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/bssid (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bssid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bssid() directly.

    YANG Description: Neighboring BSSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bssid must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__bssid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bssid(self):
    self.__bssid = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:mac-address', is_config=False)


  def _get_ssid(self):
    """
    Getter method for ssid, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/ssid (string)

    YANG Description: The SSID of this neighboring BSSID.
    """
    return self.__ssid
      
  def _set_ssid(self, v, load=False):
    """
    Setter method for ssid, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/ssid (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ssid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ssid() directly.

    YANG Description: The SSID of this neighboring BSSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="ssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ssid must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)""",
        })

    self.__ssid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ssid(self):
    self.__ssid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)


  def _get_rssi(self):
    """
    Getter method for rssi, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/rssi (int8)

    YANG Description: The RSSI of this neighboring BSSID, expressed as a negative number.
    """
    return self.__rssi
      
  def _set_rssi(self, v, load=False):
    """
    Setter method for rssi, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/rssi (int8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rssi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rssi() directly.

    YANG Description: The RSSI of this neighboring BSSID, expressed as a negative number.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="rssi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rssi must be of a type compatible with int8""",
          'defined-type': "int8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="rssi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)""",
        })

    self.__rssi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rssi(self):
    self.__rssi = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['-128..127']}, int_size=8), is_leaf=True, yang_name="rssi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='int8', is_config=False)


  def _get_channel(self):
    """
    Getter method for channel, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/channel (uint16)

    YANG Description: The channel of this neighboring BSSID. This is to utilize
802.11ac nomenclature. For example, 40MHz channel 36-40
represented as channel 38. The primary-channel leaf is used to
identify the primary 20MHz channel of a bonded channel.
    """
    return self.__channel
      
  def _set_channel(self, v, load=False):
    """
    Setter method for channel, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/channel (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_channel() directly.

    YANG Description: The channel of this neighboring BSSID. This is to utilize
802.11ac nomenclature. For example, 40MHz channel 36-40
represented as channel 38. The primary-channel leaf is used to
identify the primary 20MHz channel of a bonded channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """channel must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)""",
        })

    self.__channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_channel(self):
    self.__channel = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)


  def _get_primary_channel(self):
    """
    Getter method for primary_channel, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/primary_channel (uint16)

    YANG Description: The primary 20MHz channel, if the neighbor is operating on
bonded channel.
    """
    return self.__primary_channel
      
  def _set_primary_channel(self, v, load=False):
    """
    Setter method for primary_channel, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/primary_channel (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_primary_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_primary_channel() directly.

    YANG Description: The primary 20MHz channel, if the neighbor is operating on
bonded channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="primary-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """primary_channel must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="primary-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)""",
        })

    self.__primary_channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_primary_channel(self):
    self.__primary_channel = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="primary-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)


  def _get_bss_color_id(self):
    """
    Getter method for bss_color_id, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/bss_color_id (uint8)

    YANG Description: Numerical identifier of the BSS.
    """
    return self.__bss_color_id
      
  def _set_bss_color_id(self, v, load=False):
    """
    Setter method for bss_color_id, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/bss_color_id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bss_color_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bss_color_id() directly.

    YANG Description: Numerical identifier of the BSS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bss_color_id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)""",
        })

    self.__bss_color_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bss_color_id(self):
    self.__bss_color_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..63']}), is_leaf=True, yang_name="bss-color-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint8', is_config=False)


  def _get_last_seen(self):
    """
    Getter method for last_seen, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/last_seen (oc-types:timeticks64)

    YANG Description: Reports the time this reading was taken, indicating when
this neighbor was last seen. If a cache is used, it MUST be
updated instantly when a neighbor BSS changes channels, or a
new BSS is seen. The value is the timestamp in nanoseconds
relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_seen
      
  def _set_last_seen(self, v, load=False):
    """
    Setter method for last_seen, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/last_seen (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_seen is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_seen() directly.

    YANG Description: Reports the time this reading was taken, indicating when
this neighbor was last seen. If a cache is used, it MUST be
updated instantly when a neighbor BSS changes channels, or a
new BSS is seen. The value is the timestamp in nanoseconds
relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-seen", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_seen must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-seen", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_seen = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_seen(self):
    self.__last_seen = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-seen", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:timeticks64', is_config=False)


  def _get_opmode(self):
    """
    Getter method for opmode, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/opmode (enumeration)

    YANG Description: Operating mode of the BSS.
    """
    return self.__opmode
      
  def _set_opmode(self, v, load=False):
    """
    Setter method for opmode, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state/opmode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_opmode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_opmode() directly.

    YANG Description: Operating mode of the BSS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'WPA_PERSONAL': {}, 'WPA_ENTERPRISE': {}, 'WEP': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """opmode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-access-points:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'WPA_PERSONAL': {}, 'WPA_ENTERPRISE': {}, 'WEP': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=False)""",
        })

    self.__opmode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_opmode(self):
    self.__opmode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'WPA_PERSONAL': {}, 'WPA_ENTERPRISE': {}, 'WEP': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=False)

  bssid = __builtin__.property(_get_bssid)
  ssid = __builtin__.property(_get_ssid)
  rssi = __builtin__.property(_get_rssi)
  channel = __builtin__.property(_get_channel)
  primary_channel = __builtin__.property(_get_primary_channel)
  bss_color_id = __builtin__.property(_get_bss_color_id)
  last_seen = __builtin__.property(_get_last_seen)
  opmode = __builtin__.property(_get_opmode)


  _pyangbind_elements = OrderedDict([('bssid', bssid), ('ssid', ssid), ('rssi', rssi), ('channel', channel), ('primary_channel', primary_channel), ('bss_color_id', bss_color_id), ('last_seen', last_seen), ('opmode', opmode), ])


class yc_neighbor_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/radios/radio/neighbors/neighbor. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The MAC address, or BSSID, of a neighbor, and
their corresponding RSSI.
  """
  __slots__ = ('_path_helper', '_extmethods', '__bssid','__state',)

  _yang_name = 'neighbor'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__bssid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="bssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'radios', 'radio', 'neighbors', 'neighbor']

  def _get_bssid(self):
    """
    Getter method for bssid, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/bssid (leafref)

    YANG Description: Reference to neighbor BSSID.
    """
    return self.__bssid
      
  def _set_bssid(self, v, load=False):
    """
    Setter method for bssid, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/bssid (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bssid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bssid() directly.

    YANG Description: Reference to neighbor BSSID.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="bssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bssid must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="bssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=False)""",
        })

    self.__bssid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bssid(self):
    self.__bssid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="bssid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state (container)

    YANG Description: State container for RF neighbors.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for RF neighbors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)

  bssid = __builtin__.property(_get_bssid)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('bssid', bssid), ('state', state), ])


class yc_neighbors_openconfig_access_points__access_points_access_point_radios_radio_neighbors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/radios/radio/neighbors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for RF neighbors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__neighbor',)

  _yang_name = 'neighbors'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__neighbor = YANGDynClass(base=YANGListType("bssid",yc_neighbor_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='bssid', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'radios', 'radio', 'neighbors']

  def _get_neighbor(self):
    """
    Getter method for neighbor, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor (list)

    YANG Description: The MAC address, or BSSID, of a neighbor, and
their corresponding RSSI.
    """
    return self.__neighbor
      
  def _set_neighbor(self, v, load=False):
    """
    Setter method for neighbor, mapped from YANG variable /access_points/access_point/radios/radio/neighbors/neighbor (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_neighbor is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_neighbor() directly.

    YANG Description: The MAC address, or BSSID, of a neighbor, and
their corresponding RSSI.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("bssid",yc_neighbor_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='bssid', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """neighbor must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("bssid",yc_neighbor_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='bssid', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='list', is_config=True)""",
        })

    self.__neighbor = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_neighbor(self):
    self.__neighbor = YANGDynClass(base=YANGListType("bssid",yc_neighbor_openconfig_access_points__access_points_access_point_radios_radio_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='bssid', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='list', is_config=True)

  neighbor = __builtin__.property(_get_neighbor, _set_neighbor)


  _pyangbind_elements = OrderedDict([('neighbor', neighbor), ])


class yc_radio_openconfig_access_points__access_points_access_point_radios_radio(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/radios/radio. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The list of radios on the device.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__operating_frequency','__config','__state','__neighbors',)

  _yang_name = 'radio'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)
    self.__operating_frequency = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_access_points__access_points_access_point_radios_radio_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_access_points__access_points_access_point_radios_radio_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)
    self.__neighbors = YANGDynClass(base=yc_neighbors_openconfig_access_points__access_points_access_point_radios_radio_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'radios', 'radio']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /access_points/access_point/radios/radio/id (leafref)

    YANG Description: List key referencing the configured radio id.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /access_points/access_point/radios/radio/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: List key referencing the configured radio id.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)


  def _get_operating_frequency(self):
    """
    Getter method for operating_frequency, mapped from YANG variable /access_points/access_point/radios/radio/operating_frequency (leafref)

    YANG Description: List key referencing the radio operating-frequency.
    """
    return self.__operating_frequency
      
  def _set_operating_frequency(self, v, load=False):
    """
    Setter method for operating_frequency, mapped from YANG variable /access_points/access_point/radios/radio/operating_frequency (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_operating_frequency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_operating_frequency() directly.

    YANG Description: List key referencing the radio operating-frequency.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """operating_frequency must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)""",
        })

    self.__operating_frequency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_operating_frequency(self):
    self.__operating_frequency = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /access_points/access_point/radios/radio/config (container)

    YANG Description: Configurable items at the global, radio interface
level.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /access_points/access_point/radios/radio/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configurable items at the global, radio interface
level.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_access_points__access_points_access_point_radios_radio_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_access_points__access_points_access_point_radios_radio_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_access_points__access_points_access_point_radios_radio_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /access_points/access_point/radios/radio/state (container)

    YANG Description: Operational state data at the global radio level.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /access_points/access_point/radios/radio/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data at the global radio level.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_access_points__access_points_access_point_radios_radio_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_access_points__access_points_access_point_radios_radio_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_access_points__access_points_access_point_radios_radio_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)


  def _get_neighbors(self):
    """
    Getter method for neighbors, mapped from YANG variable /access_points/access_point/radios/radio/neighbors (container)

    YANG Description: Top-level container for RF neighbors.
    """
    return self.__neighbors
      
  def _set_neighbors(self, v, load=False):
    """
    Setter method for neighbors, mapped from YANG variable /access_points/access_point/radios/radio/neighbors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_neighbors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_neighbors() directly.

    YANG Description: Top-level container for RF neighbors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_neighbors_openconfig_access_points__access_points_access_point_radios_radio_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """neighbors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_neighbors_openconfig_access_points__access_points_access_point_radios_radio_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)""",
        })

    self.__neighbors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_neighbors(self):
    self.__neighbors = YANGDynClass(base=yc_neighbors_openconfig_access_points__access_points_access_point_radios_radio_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  operating_frequency = __builtin__.property(_get_operating_frequency, _set_operating_frequency)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  neighbors = __builtin__.property(_get_neighbors, _set_neighbors)


  _pyangbind_elements = OrderedDict([('id', id), ('operating_frequency', operating_frequency), ('config', config), ('state', state), ('neighbors', neighbors), ])


class yc_radios_openconfig_access_points__access_points_access_point_radios(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/radios. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for radios, including configuration
and state data.
  """
  __slots__ = ('_path_helper', '_extmethods', '__radio',)

  _yang_name = 'radios'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__radio = YANGDynClass(base=YANGListType("id operating_frequency",yc_radio_openconfig_access_points__access_points_access_point_radios_radio, yang_name="radio", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id operating-frequency', extensions=None), is_container='list', yang_name="radio", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'radios']

  def _get_radio(self):
    """
    Getter method for radio, mapped from YANG variable /access_points/access_point/radios/radio (list)

    YANG Description: The list of radios on the device.
    """
    return self.__radio
      
  def _set_radio(self, v, load=False):
    """
    Setter method for radio, mapped from YANG variable /access_points/access_point/radios/radio (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_radio is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_radio() directly.

    YANG Description: The list of radios on the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id operating_frequency",yc_radio_openconfig_access_points__access_points_access_point_radios_radio, yang_name="radio", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id operating-frequency', extensions=None), is_container='list', yang_name="radio", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """radio must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id operating_frequency",yc_radio_openconfig_access_points__access_points_access_point_radios_radio, yang_name="radio", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id operating-frequency', extensions=None), is_container='list', yang_name="radio", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='list', is_config=True)""",
        })

    self.__radio = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_radio(self):
    self.__radio = YANGDynClass(base=YANGListType("id operating_frequency",yc_radio_openconfig_access_points__access_points_access_point_radios_radio, yang_name="radio", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id operating-frequency', extensions=None), is_container='list', yang_name="radio", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='list', is_config=True)

  radio = __builtin__.property(_get_radio, _set_radio)


  _pyangbind_elements = OrderedDict([('radio', radio), ])


class yc_config_openconfig_access_points__access_points_access_point_ssids_ssid_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configurable items at the global, SSID level
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled','__hidden','__default_vlan','__vlan_list','__operating_frequency','__basic_data_rates_2g','__supported_data_rates_2g','__basic_data_rates_5g','__supported_data_rates_5g','__basic_data_rates_6g','__supported_data_rates_6g','__broadcast_filter','__multicast_filter','__ipv6_ndp_filter','__ipv6_ndp_filter_timer','__station_isolation','__opmode','__wpa2_psk','__wpa3_psk','__server_group','__dva','__dhcp_required','__qbss_load','__advertise_apname','__csa','__ptk_timeout','__gtk_timeout','__dot11k','__okc','__mfp',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__hidden = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="hidden", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__default_vlan = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="default-vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__vlan_list = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__operating_frequency = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), default=six.text_type("oc-wifi-types:FREQ_2_5_GHZ"), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    self.__basic_data_rates_2g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    self.__supported_data_rates_2g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    self.__basic_data_rates_5g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    self.__supported_data_rates_5g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    self.__basic_data_rates_6g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    self.__supported_data_rates_6g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    self.__broadcast_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="broadcast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__multicast_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="multicast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__ipv6_ndp_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ipv6-ndp-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__ipv6_ndp_filter_timer = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ipv6-ndp-filter-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)
    self.__station_isolation = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="station-isolation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__opmode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=True)
    self.__wpa2_psk = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa2-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)
    self.__wpa3_psk = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa3-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)
    self.__server_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)
    self.__dva = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dva", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__dhcp_required = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dhcp-required", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__qbss_load = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="qbss-load", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__advertise_apname = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="advertise-apname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__csa = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="csa", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__ptk_timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ptk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)
    self.__gtk_timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="gtk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)
    self.__dot11k = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dot11k", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__okc = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="okc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    self.__mfp = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mfp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /access_points/access_point/ssids/ssid/config/name (string)

    YANG Description: The name of the SSID.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /access_points/access_point/ssids/ssid/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /access_points/access_point/ssids/ssid/config/enabled (boolean)

    YANG Description: The desired operational state (up/down) of this SSID.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /access_points/access_point/ssids/ssid/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: The desired operational state (up/down) of this SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_hidden(self):
    """
    Getter method for hidden, mapped from YANG variable /access_points/access_point/ssids/ssid/config/hidden (boolean)

    YANG Description: Whether this SSID IE is hidden within Beacons.
    """
    return self.__hidden
      
  def _set_hidden(self, v, load=False):
    """
    Setter method for hidden, mapped from YANG variable /access_points/access_point/ssids/ssid/config/hidden (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hidden is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hidden() directly.

    YANG Description: Whether this SSID IE is hidden within Beacons.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="hidden", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hidden must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="hidden", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__hidden = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hidden(self):
    self.__hidden = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="hidden", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_default_vlan(self):
    """
    Getter method for default_vlan, mapped from YANG variable /access_points/access_point/ssids/ssid/config/default_vlan (oc-vlan-types:vlan-id)

    YANG Description: Default VLAN tag used by the SSID. When unspecified, SSID
defaults to untagged. If DVA enabled and RADIUS returns a
VLAN not present in 'vlan-list', or RADIUS returns no VLAN
(Tunnel-Private-Group-Id), this VLAN will be used. If DVA
not enabled, all packets are tagged with this VLAN.
    """
    return self.__default_vlan
      
  def _set_default_vlan(self, v, load=False):
    """
    Setter method for default_vlan, mapped from YANG variable /access_points/access_point/ssids/ssid/config/default_vlan (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_default_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_default_vlan() directly.

    YANG Description: Default VLAN tag used by the SSID. When unspecified, SSID
defaults to untagged. If DVA enabled and RADIUS returns a
VLAN not present in 'vlan-list', or RADIUS returns no VLAN
(Tunnel-Private-Group-Id), this VLAN will be used. If DVA
not enabled, all packets are tagged with this VLAN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="default-vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """default_vlan must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="default-vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__default_vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_default_vlan(self):
    self.__default_vlan = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="default-vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_vlan_list(self):
    """
    Getter method for vlan_list, mapped from YANG variable /access_points/access_point/ssids/ssid/config/vlan_list (oc-vlan-types:vlan-id)

    YANG Description: List of VLANs allowed on the SSID, if DVA is enabled. Note,
if DVA enabled and RADIUS returns no VLAN or a VLAN outside
of this list, the SSID will be tagged with the value of
vlan-id (or untagged if 'vlan-id' not configured).
    """
    return self.__vlan_list
      
  def _set_vlan_list(self, v, load=False):
    """
    Setter method for vlan_list, mapped from YANG variable /access_points/access_point/ssids/ssid/config/vlan_list (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_list is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_list() directly.

    YANG Description: List of VLANs allowed on the SSID, if DVA is enabled. Note,
if DVA enabled and RADIUS returns no VLAN or a VLAN outside
of this list, the SSID will be tagged with the value of
vlan-id (or untagged if 'vlan-id' not configured).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_list must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__vlan_list = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_list(self):
    self.__vlan_list = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_operating_frequency(self):
    """
    Getter method for operating_frequency, mapped from YANG variable /access_points/access_point/ssids/ssid/config/operating_frequency (identityref)

    YANG Description: Operating frequency of this SSID. When none specified, the
default is dual-band 2.4 and 5 GHz.
    """
    return self.__operating_frequency
      
  def _set_operating_frequency(self, v, load=False):
    """
    Setter method for operating_frequency, mapped from YANG variable /access_points/access_point/ssids/ssid/config/operating_frequency (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_operating_frequency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_operating_frequency() directly.

    YANG Description: Operating frequency of this SSID. When none specified, the
default is dual-band 2.4 and 5 GHz.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), default=six.text_type("oc-wifi-types:FREQ_2_5_GHZ"), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """operating_frequency must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), default=six.text_type("oc-wifi-types:FREQ_2_5_GHZ"), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)""",
        })

    self.__operating_frequency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_operating_frequency(self):
    self.__operating_frequency = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), default=six.text_type("oc-wifi-types:FREQ_2_5_GHZ"), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)


  def _get_basic_data_rates_2g(self):
    """
    Getter method for basic_data_rates_2g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/basic_data_rates_2g (identityref)

    YANG Description: 2.4GHz Basic data-rates for the SSID.
    """
    return self.__basic_data_rates_2g
      
  def _set_basic_data_rates_2g(self, v, load=False):
    """
    Setter method for basic_data_rates_2g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/basic_data_rates_2g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_basic_data_rates_2g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_basic_data_rates_2g() directly.

    YANG Description: 2.4GHz Basic data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """basic_data_rates_2g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)""",
        })

    self.__basic_data_rates_2g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_basic_data_rates_2g(self):
    self.__basic_data_rates_2g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)


  def _get_supported_data_rates_2g(self):
    """
    Getter method for supported_data_rates_2g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/supported_data_rates_2g (identityref)

    YANG Description: 2.4GHz Supported data-rates for the SSID.
    """
    return self.__supported_data_rates_2g
      
  def _set_supported_data_rates_2g(self, v, load=False):
    """
    Setter method for supported_data_rates_2g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/supported_data_rates_2g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_data_rates_2g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_data_rates_2g() directly.

    YANG Description: 2.4GHz Supported data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_data_rates_2g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)""",
        })

    self.__supported_data_rates_2g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_data_rates_2g(self):
    self.__supported_data_rates_2g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)


  def _get_basic_data_rates_5g(self):
    """
    Getter method for basic_data_rates_5g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/basic_data_rates_5g (identityref)

    YANG Description: 5GHz Basic data-rates for the SSID.
    """
    return self.__basic_data_rates_5g
      
  def _set_basic_data_rates_5g(self, v, load=False):
    """
    Setter method for basic_data_rates_5g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/basic_data_rates_5g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_basic_data_rates_5g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_basic_data_rates_5g() directly.

    YANG Description: 5GHz Basic data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """basic_data_rates_5g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)""",
        })

    self.__basic_data_rates_5g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_basic_data_rates_5g(self):
    self.__basic_data_rates_5g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)


  def _get_supported_data_rates_5g(self):
    """
    Getter method for supported_data_rates_5g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/supported_data_rates_5g (identityref)

    YANG Description: 5GHz Supported data-rates for the SSID.
    """
    return self.__supported_data_rates_5g
      
  def _set_supported_data_rates_5g(self, v, load=False):
    """
    Setter method for supported_data_rates_5g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/supported_data_rates_5g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_data_rates_5g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_data_rates_5g() directly.

    YANG Description: 5GHz Supported data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_data_rates_5g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)""",
        })

    self.__supported_data_rates_5g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_data_rates_5g(self):
    self.__supported_data_rates_5g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)


  def _get_basic_data_rates_6g(self):
    """
    Getter method for basic_data_rates_6g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/basic_data_rates_6g (identityref)

    YANG Description: 6GHz Basic data-rates for the SSID.
    """
    return self.__basic_data_rates_6g
      
  def _set_basic_data_rates_6g(self, v, load=False):
    """
    Setter method for basic_data_rates_6g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/basic_data_rates_6g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_basic_data_rates_6g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_basic_data_rates_6g() directly.

    YANG Description: 6GHz Basic data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """basic_data_rates_6g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)""",
        })

    self.__basic_data_rates_6g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_basic_data_rates_6g(self):
    self.__basic_data_rates_6g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)


  def _get_supported_data_rates_6g(self):
    """
    Getter method for supported_data_rates_6g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/supported_data_rates_6g (identityref)

    YANG Description: 6GHz Supported data-rates for the SSID.
    """
    return self.__supported_data_rates_6g
      
  def _set_supported_data_rates_6g(self, v, load=False):
    """
    Setter method for supported_data_rates_6g, mapped from YANG variable /access_points/access_point/ssids/ssid/config/supported_data_rates_6g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_data_rates_6g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_data_rates_6g() directly.

    YANG Description: 6GHz Supported data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_data_rates_6g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)""",
        })

    self.__supported_data_rates_6g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_data_rates_6g(self):
    self.__supported_data_rates_6g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=True)


  def _get_broadcast_filter(self):
    """
    Getter method for broadcast_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/config/broadcast_filter (boolean)

    YANG Description: Convert all downstream broadcast ARP to unicast
only if Station is associated to the AP. Drop packet
if Station is not associated to the AP. All other
broadcast, except DHCP, is dropped by the AP.

DHCP Offers/ACKs are converted to Unicast, over-the-air.
    """
    return self.__broadcast_filter
      
  def _set_broadcast_filter(self, v, load=False):
    """
    Setter method for broadcast_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/config/broadcast_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_broadcast_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_broadcast_filter() directly.

    YANG Description: Convert all downstream broadcast ARP to unicast
only if Station is associated to the AP. Drop packet
if Station is not associated to the AP. All other
broadcast, except DHCP, is dropped by the AP.

DHCP Offers/ACKs are converted to Unicast, over-the-air.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="broadcast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """broadcast_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="broadcast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__broadcast_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_broadcast_filter(self):
    self.__broadcast_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="broadcast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_multicast_filter(self):
    """
    Getter method for multicast_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/config/multicast_filter (boolean)

    YANG Description: Drop all downstream Multicast packets.
    """
    return self.__multicast_filter
      
  def _set_multicast_filter(self, v, load=False):
    """
    Setter method for multicast_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/config/multicast_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_filter() directly.

    YANG Description: Drop all downstream Multicast packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="multicast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="multicast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__multicast_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_filter(self):
    self.__multicast_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="multicast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_ipv6_ndp_filter(self):
    """
    Getter method for ipv6_ndp_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/config/ipv6_ndp_filter (boolean)

    YANG Description: Neighbor Advertisements will be cached at the AP (or WLC)
and unicast in response to Neighbor Solicitations.

Router Advertisements, in response to a Router Solicitation
are converted to Unicast for over-the-air transmission.
    """
    return self.__ipv6_ndp_filter
      
  def _set_ipv6_ndp_filter(self, v, load=False):
    """
    Setter method for ipv6_ndp_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/config/ipv6_ndp_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6_ndp_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6_ndp_filter() directly.

    YANG Description: Neighbor Advertisements will be cached at the AP (or WLC)
and unicast in response to Neighbor Solicitations.

Router Advertisements, in response to a Router Solicitation
are converted to Unicast for over-the-air transmission.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="ipv6-ndp-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6_ndp_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ipv6-ndp-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__ipv6_ndp_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6_ndp_filter(self):
    self.__ipv6_ndp_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ipv6-ndp-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_ipv6_ndp_filter_timer(self):
    """
    Getter method for ipv6_ndp_filter_timer, mapped from YANG variable /access_points/access_point/ssids/ssid/config/ipv6_ndp_filter_timer (uint16)

    YANG Description: Time, in seconds, the ndp-filter will cache
Neighbor Advertisements (NA).
    """
    return self.__ipv6_ndp_filter_timer
      
  def _set_ipv6_ndp_filter_timer(self, v, load=False):
    """
    Setter method for ipv6_ndp_filter_timer, mapped from YANG variable /access_points/access_point/ssids/ssid/config/ipv6_ndp_filter_timer (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6_ndp_filter_timer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6_ndp_filter_timer() directly.

    YANG Description: Time, in seconds, the ndp-filter will cache
Neighbor Advertisements (NA).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ipv6-ndp-filter-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6_ndp_filter_timer must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ipv6-ndp-filter-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)""",
        })

    self.__ipv6_ndp_filter_timer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6_ndp_filter_timer(self):
    self.__ipv6_ndp_filter_timer = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ipv6-ndp-filter-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)


  def _get_station_isolation(self):
    """
    Getter method for station_isolation, mapped from YANG variable /access_points/access_point/ssids/ssid/config/station_isolation (boolean)

    YANG Description: Block Station peer to peer communication.
    """
    return self.__station_isolation
      
  def _set_station_isolation(self, v, load=False):
    """
    Setter method for station_isolation, mapped from YANG variable /access_points/access_point/ssids/ssid/config/station_isolation (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_station_isolation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_station_isolation() directly.

    YANG Description: Block Station peer to peer communication.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="station-isolation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """station_isolation must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="station-isolation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__station_isolation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_station_isolation(self):
    self.__station_isolation = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="station-isolation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_opmode(self):
    """
    Getter method for opmode, mapped from YANG variable /access_points/access_point/ssids/ssid/config/opmode (enumeration)

    YANG Description: The type of Layer2 authentication in use.
    """
    return self.__opmode
      
  def _set_opmode(self, v, load=False):
    """
    Setter method for opmode, mapped from YANG variable /access_points/access_point/ssids/ssid/config/opmode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_opmode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_opmode() directly.

    YANG Description: The type of Layer2 authentication in use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """opmode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-access-points:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=True)""",
        })

    self.__opmode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_opmode(self):
    self.__opmode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=True)


  def _get_wpa2_psk(self):
    """
    Getter method for wpa2_psk, mapped from YANG variable /access_points/access_point/ssids/ssid/config/wpa2_psk (string)

    YANG Description: The passphrase used on this WPA2-Personal SSID.
    """
    return self.__wpa2_psk
      
  def _set_wpa2_psk(self, v, load=False):
    """
    Setter method for wpa2_psk, mapped from YANG variable /access_points/access_point/ssids/ssid/config/wpa2_psk (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_wpa2_psk is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_wpa2_psk() directly.

    YANG Description: The passphrase used on this WPA2-Personal SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa2-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """wpa2_psk must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa2-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)""",
        })

    self.__wpa2_psk = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_wpa2_psk(self):
    self.__wpa2_psk = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa2-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)


  def _get_wpa3_psk(self):
    """
    Getter method for wpa3_psk, mapped from YANG variable /access_points/access_point/ssids/ssid/config/wpa3_psk (string)

    YANG Description: The passphrase used on this WPA3-SAE SSID.
    """
    return self.__wpa3_psk
      
  def _set_wpa3_psk(self, v, load=False):
    """
    Setter method for wpa3_psk, mapped from YANG variable /access_points/access_point/ssids/ssid/config/wpa3_psk (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_wpa3_psk is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_wpa3_psk() directly.

    YANG Description: The passphrase used on this WPA3-SAE SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa3-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """wpa3_psk must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa3-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)""",
        })

    self.__wpa3_psk = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_wpa3_psk(self):
    self.__wpa3_psk = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa3-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)


  def _get_server_group(self):
    """
    Getter method for server_group, mapped from YANG variable /access_points/access_point/ssids/ssid/config/server_group (string)

    YANG Description: Specifies the RADIUS server-group to be used,
as defined in the openconfig-aaa.yang model.

Including WPA2_PERSONAL and WPA3_SAE as they can be accompanied by
MAB.
    """
    return self.__server_group
      
  def _set_server_group(self, v, load=False):
    """
    Setter method for server_group, mapped from YANG variable /access_points/access_point/ssids/ssid/config/server_group (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_server_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_server_group() directly.

    YANG Description: Specifies the RADIUS server-group to be used,
as defined in the openconfig-aaa.yang model.

Including WPA2_PERSONAL and WPA3_SAE as they can be accompanied by
MAB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """server_group must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)""",
        })

    self.__server_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_server_group(self):
    self.__server_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=True)


  def _get_dva(self):
    """
    Getter method for dva, mapped from YANG variable /access_points/access_point/ssids/ssid/config/dva (boolean)

    YANG Description: Enable/disable Dynamic VLAN Assignment,
using 'Tunnel-Private-Group-Id' RADIUS attribute.
    """
    return self.__dva
      
  def _set_dva(self, v, load=False):
    """
    Setter method for dva, mapped from YANG variable /access_points/access_point/ssids/ssid/config/dva (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dva is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dva() directly.

    YANG Description: Enable/disable Dynamic VLAN Assignment,
using 'Tunnel-Private-Group-Id' RADIUS attribute.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="dva", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dva must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dva", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__dva = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dva(self):
    self.__dva = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dva", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_dhcp_required(self):
    """
    Getter method for dhcp_required, mapped from YANG variable /access_points/access_point/ssids/ssid/config/dhcp_required (boolean)

    YANG Description: Allow a Station to access the network only if
a DHCP exchange has occurred.
    """
    return self.__dhcp_required
      
  def _set_dhcp_required(self, v, load=False):
    """
    Setter method for dhcp_required, mapped from YANG variable /access_points/access_point/ssids/ssid/config/dhcp_required (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_required is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_required() directly.

    YANG Description: Allow a Station to access the network only if
a DHCP exchange has occurred.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="dhcp-required", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_required must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dhcp-required", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__dhcp_required = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_required(self):
    self.__dhcp_required = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dhcp-required", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_qbss_load(self):
    """
    Getter method for qbss_load, mapped from YANG variable /access_points/access_point/ssids/ssid/config/qbss_load (boolean)

    YANG Description: Advertisement of the QBSS Load Information Element.
    """
    return self.__qbss_load
      
  def _set_qbss_load(self, v, load=False):
    """
    Setter method for qbss_load, mapped from YANG variable /access_points/access_point/ssids/ssid/config/qbss_load (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_qbss_load is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_qbss_load() directly.

    YANG Description: Advertisement of the QBSS Load Information Element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="qbss-load", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """qbss_load must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="qbss-load", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__qbss_load = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_qbss_load(self):
    self.__qbss_load = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="qbss-load", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_advertise_apname(self):
    """
    Getter method for advertise_apname, mapped from YANG variable /access_points/access_point/ssids/ssid/config/advertise_apname (boolean)

    YANG Description: Advertise the AP hostname in Beacon and Probe Response frames.
    """
    return self.__advertise_apname
      
  def _set_advertise_apname(self, v, load=False):
    """
    Setter method for advertise_apname, mapped from YANG variable /access_points/access_point/ssids/ssid/config/advertise_apname (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_advertise_apname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_advertise_apname() directly.

    YANG Description: Advertise the AP hostname in Beacon and Probe Response frames.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="advertise-apname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """advertise_apname must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="advertise-apname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__advertise_apname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_advertise_apname(self):
    self.__advertise_apname = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="advertise-apname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_csa(self):
    """
    Getter method for csa, mapped from YANG variable /access_points/access_point/ssids/ssid/config/csa (boolean)

    YANG Description: Enable/Disable 802.11h channel-switch-announcement.
    """
    return self.__csa
      
  def _set_csa(self, v, load=False):
    """
    Setter method for csa, mapped from YANG variable /access_points/access_point/ssids/ssid/config/csa (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_csa is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_csa() directly.

    YANG Description: Enable/Disable 802.11h channel-switch-announcement.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="csa", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """csa must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="csa", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__csa = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_csa(self):
    self.__csa = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="csa", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_ptk_timeout(self):
    """
    Getter method for ptk_timeout, mapped from YANG variable /access_points/access_point/ssids/ssid/config/ptk_timeout (uint16)

    YANG Description: Time, in seconds, for the Pairwise Transient Key.
    """
    return self.__ptk_timeout
      
  def _set_ptk_timeout(self, v, load=False):
    """
    Setter method for ptk_timeout, mapped from YANG variable /access_points/access_point/ssids/ssid/config/ptk_timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ptk_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ptk_timeout() directly.

    YANG Description: Time, in seconds, for the Pairwise Transient Key.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ptk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ptk_timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ptk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)""",
        })

    self.__ptk_timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ptk_timeout(self):
    self.__ptk_timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ptk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)


  def _get_gtk_timeout(self):
    """
    Getter method for gtk_timeout, mapped from YANG variable /access_points/access_point/ssids/ssid/config/gtk_timeout (uint16)

    YANG Description: TTL for the Group Temporal Key.
    """
    return self.__gtk_timeout
      
  def _set_gtk_timeout(self, v, load=False):
    """
    Setter method for gtk_timeout, mapped from YANG variable /access_points/access_point/ssids/ssid/config/gtk_timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_gtk_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_gtk_timeout() directly.

    YANG Description: TTL for the Group Temporal Key.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="gtk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """gtk_timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="gtk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)""",
        })

    self.__gtk_timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_gtk_timeout(self):
    self.__gtk_timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="gtk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=True)


  def _get_dot11k(self):
    """
    Getter method for dot11k, mapped from YANG variable /access_points/access_point/ssids/ssid/config/dot11k (boolean)

    YANG Description: 802.11k neighbor-list enabled/disabled.
    """
    return self.__dot11k
      
  def _set_dot11k(self, v, load=False):
    """
    Setter method for dot11k, mapped from YANG variable /access_points/access_point/ssids/ssid/config/dot11k (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dot11k is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dot11k() directly.

    YANG Description: 802.11k neighbor-list enabled/disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="dot11k", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dot11k must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dot11k", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__dot11k = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dot11k(self):
    self.__dot11k = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dot11k", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_okc(self):
    """
    Getter method for okc, mapped from YANG variable /access_points/access_point/ssids/ssid/config/okc (boolean)

    YANG Description: Enable/disable Opportunistic Key Caching.
    """
    return self.__okc
      
  def _set_okc(self, v, load=False):
    """
    Setter method for okc, mapped from YANG variable /access_points/access_point/ssids/ssid/config/okc (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_okc is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_okc() directly.

    YANG Description: Enable/disable Opportunistic Key Caching.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="okc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """okc must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="okc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__okc = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_okc(self):
    self.__okc = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="okc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)


  def _get_mfp(self):
    """
    Getter method for mfp, mapped from YANG variable /access_points/access_point/ssids/ssid/config/mfp (boolean)

    YANG Description: Management Frame Protection is required for WPA3 and OWE.
    """
    return self.__mfp
      
  def _set_mfp(self, v, load=False):
    """
    Setter method for mfp, mapped from YANG variable /access_points/access_point/ssids/ssid/config/mfp (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mfp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mfp() directly.

    YANG Description: Management Frame Protection is required for WPA3 and OWE.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="mfp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mfp must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mfp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)""",
        })

    self.__mfp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mfp(self):
    self.__mfp = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mfp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  enabled = __builtin__.property(_get_enabled, _set_enabled)
  hidden = __builtin__.property(_get_hidden, _set_hidden)
  default_vlan = __builtin__.property(_get_default_vlan, _set_default_vlan)
  vlan_list = __builtin__.property(_get_vlan_list, _set_vlan_list)
  operating_frequency = __builtin__.property(_get_operating_frequency, _set_operating_frequency)
  basic_data_rates_2g = __builtin__.property(_get_basic_data_rates_2g, _set_basic_data_rates_2g)
  supported_data_rates_2g = __builtin__.property(_get_supported_data_rates_2g, _set_supported_data_rates_2g)
  basic_data_rates_5g = __builtin__.property(_get_basic_data_rates_5g, _set_basic_data_rates_5g)
  supported_data_rates_5g = __builtin__.property(_get_supported_data_rates_5g, _set_supported_data_rates_5g)
  basic_data_rates_6g = __builtin__.property(_get_basic_data_rates_6g, _set_basic_data_rates_6g)
  supported_data_rates_6g = __builtin__.property(_get_supported_data_rates_6g, _set_supported_data_rates_6g)
  broadcast_filter = __builtin__.property(_get_broadcast_filter, _set_broadcast_filter)
  multicast_filter = __builtin__.property(_get_multicast_filter, _set_multicast_filter)
  ipv6_ndp_filter = __builtin__.property(_get_ipv6_ndp_filter, _set_ipv6_ndp_filter)
  ipv6_ndp_filter_timer = __builtin__.property(_get_ipv6_ndp_filter_timer, _set_ipv6_ndp_filter_timer)
  station_isolation = __builtin__.property(_get_station_isolation, _set_station_isolation)
  opmode = __builtin__.property(_get_opmode, _set_opmode)
  wpa2_psk = __builtin__.property(_get_wpa2_psk, _set_wpa2_psk)
  wpa3_psk = __builtin__.property(_get_wpa3_psk, _set_wpa3_psk)
  server_group = __builtin__.property(_get_server_group, _set_server_group)
  dva = __builtin__.property(_get_dva, _set_dva)
  dhcp_required = __builtin__.property(_get_dhcp_required, _set_dhcp_required)
  qbss_load = __builtin__.property(_get_qbss_load, _set_qbss_load)
  advertise_apname = __builtin__.property(_get_advertise_apname, _set_advertise_apname)
  csa = __builtin__.property(_get_csa, _set_csa)
  ptk_timeout = __builtin__.property(_get_ptk_timeout, _set_ptk_timeout)
  gtk_timeout = __builtin__.property(_get_gtk_timeout, _set_gtk_timeout)
  dot11k = __builtin__.property(_get_dot11k, _set_dot11k)
  okc = __builtin__.property(_get_okc, _set_okc)
  mfp = __builtin__.property(_get_mfp, _set_mfp)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ('hidden', hidden), ('default_vlan', default_vlan), ('vlan_list', vlan_list), ('operating_frequency', operating_frequency), ('basic_data_rates_2g', basic_data_rates_2g), ('supported_data_rates_2g', supported_data_rates_2g), ('basic_data_rates_5g', basic_data_rates_5g), ('supported_data_rates_5g', supported_data_rates_5g), ('basic_data_rates_6g', basic_data_rates_6g), ('supported_data_rates_6g', supported_data_rates_6g), ('broadcast_filter', broadcast_filter), ('multicast_filter', multicast_filter), ('ipv6_ndp_filter', ipv6_ndp_filter), ('ipv6_ndp_filter_timer', ipv6_ndp_filter_timer), ('station_isolation', station_isolation), ('opmode', opmode), ('wpa2_psk', wpa2_psk), ('wpa3_psk', wpa3_psk), ('server_group', server_group), ('dva', dva), ('dhcp_required', dhcp_required), ('qbss_load', qbss_load), ('advertise_apname', advertise_apname), ('csa', csa), ('ptk_timeout', ptk_timeout), ('gtk_timeout', gtk_timeout), ('dot11k', dot11k), ('okc', okc), ('mfp', mfp), ])


class yc_state_openconfig_access_points__access_points_access_point_ssids_ssid_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data at the SSID level
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled','__hidden','__default_vlan','__vlan_list','__operating_frequency','__basic_data_rates_2g','__supported_data_rates_2g','__basic_data_rates_5g','__supported_data_rates_5g','__basic_data_rates_6g','__supported_data_rates_6g','__broadcast_filter','__multicast_filter','__ipv6_ndp_filter','__ipv6_ndp_filter_timer','__station_isolation','__opmode','__wpa2_psk','__wpa3_psk','__server_group','__dva','__dhcp_required','__qbss_load','__advertise_apname','__csa','__ptk_timeout','__gtk_timeout','__dot11k','__okc','__mfp',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__hidden = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="hidden", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__default_vlan = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="default-vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__vlan_list = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__operating_frequency = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), default=six.text_type("oc-wifi-types:FREQ_2_5_GHZ"), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__basic_data_rates_2g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__supported_data_rates_2g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__basic_data_rates_5g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__supported_data_rates_5g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__basic_data_rates_6g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__supported_data_rates_6g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    self.__broadcast_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="broadcast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__multicast_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="multicast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__ipv6_ndp_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ipv6-ndp-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__ipv6_ndp_filter_timer = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ipv6-ndp-filter-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    self.__station_isolation = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="station-isolation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__opmode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=False)
    self.__wpa2_psk = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa2-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    self.__wpa3_psk = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa3-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    self.__server_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    self.__dva = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dva", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__dhcp_required = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dhcp-required", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__qbss_load = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="qbss-load", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__advertise_apname = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="advertise-apname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__csa = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="csa", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__ptk_timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ptk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    self.__gtk_timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="gtk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    self.__dot11k = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dot11k", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__okc = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="okc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    self.__mfp = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mfp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /access_points/access_point/ssids/ssid/state/name (string)

    YANG Description: The name of the SSID.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /access_points/access_point/ssids/ssid/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /access_points/access_point/ssids/ssid/state/enabled (boolean)

    YANG Description: The desired operational state (up/down) of this SSID.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /access_points/access_point/ssids/ssid/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: The desired operational state (up/down) of this SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_hidden(self):
    """
    Getter method for hidden, mapped from YANG variable /access_points/access_point/ssids/ssid/state/hidden (boolean)

    YANG Description: Whether this SSID IE is hidden within Beacons.
    """
    return self.__hidden
      
  def _set_hidden(self, v, load=False):
    """
    Setter method for hidden, mapped from YANG variable /access_points/access_point/ssids/ssid/state/hidden (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hidden is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hidden() directly.

    YANG Description: Whether this SSID IE is hidden within Beacons.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="hidden", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hidden must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="hidden", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__hidden = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hidden(self):
    self.__hidden = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="hidden", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_default_vlan(self):
    """
    Getter method for default_vlan, mapped from YANG variable /access_points/access_point/ssids/ssid/state/default_vlan (oc-vlan-types:vlan-id)

    YANG Description: Default VLAN tag used by the SSID. When unspecified, SSID
defaults to untagged. If DVA enabled and RADIUS returns a
VLAN not present in 'vlan-list', or RADIUS returns no VLAN
(Tunnel-Private-Group-Id), this VLAN will be used. If DVA
not enabled, all packets are tagged with this VLAN.
    """
    return self.__default_vlan
      
  def _set_default_vlan(self, v, load=False):
    """
    Setter method for default_vlan, mapped from YANG variable /access_points/access_point/ssids/ssid/state/default_vlan (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_default_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_default_vlan() directly.

    YANG Description: Default VLAN tag used by the SSID. When unspecified, SSID
defaults to untagged. If DVA enabled and RADIUS returns a
VLAN not present in 'vlan-list', or RADIUS returns no VLAN
(Tunnel-Private-Group-Id), this VLAN will be used. If DVA
not enabled, all packets are tagged with this VLAN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="default-vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """default_vlan must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="default-vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__default_vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_default_vlan(self):
    self.__default_vlan = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="default-vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_vlan_list(self):
    """
    Getter method for vlan_list, mapped from YANG variable /access_points/access_point/ssids/ssid/state/vlan_list (oc-vlan-types:vlan-id)

    YANG Description: List of VLANs allowed on the SSID, if DVA is enabled. Note,
if DVA enabled and RADIUS returns no VLAN or a VLAN outside
of this list, the SSID will be tagged with the value of
vlan-id (or untagged if 'vlan-id' not configured).
    """
    return self.__vlan_list
      
  def _set_vlan_list(self, v, load=False):
    """
    Setter method for vlan_list, mapped from YANG variable /access_points/access_point/ssids/ssid/state/vlan_list (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_list is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_list() directly.

    YANG Description: List of VLANs allowed on the SSID, if DVA is enabled. Note,
if DVA enabled and RADIUS returns no VLAN or a VLAN outside
of this list, the SSID will be tagged with the value of
vlan-id (or untagged if 'vlan-id' not configured).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_list must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__vlan_list = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_list(self):
    self.__vlan_list = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_operating_frequency(self):
    """
    Getter method for operating_frequency, mapped from YANG variable /access_points/access_point/ssids/ssid/state/operating_frequency (identityref)

    YANG Description: Operating frequency of this SSID. When none specified, the
default is dual-band 2.4 and 5 GHz.
    """
    return self.__operating_frequency
      
  def _set_operating_frequency(self, v, load=False):
    """
    Setter method for operating_frequency, mapped from YANG variable /access_points/access_point/ssids/ssid/state/operating_frequency (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_operating_frequency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_operating_frequency() directly.

    YANG Description: Operating frequency of this SSID. When none specified, the
default is dual-band 2.4 and 5 GHz.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), default=six.text_type("oc-wifi-types:FREQ_2_5_GHZ"), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """operating_frequency must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), default=six.text_type("oc-wifi-types:FREQ_2_5_GHZ"), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__operating_frequency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_operating_frequency(self):
    self.__operating_frequency = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_6GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:FREQ_2_5_6_GHZ': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},), default=six.text_type("oc-wifi-types:FREQ_2_5_GHZ"), is_leaf=True, yang_name="operating-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_basic_data_rates_2g(self):
    """
    Getter method for basic_data_rates_2g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/basic_data_rates_2g (identityref)

    YANG Description: 2.4GHz Basic data-rates for the SSID.
    """
    return self.__basic_data_rates_2g
      
  def _set_basic_data_rates_2g(self, v, load=False):
    """
    Setter method for basic_data_rates_2g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/basic_data_rates_2g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_basic_data_rates_2g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_basic_data_rates_2g() directly.

    YANG Description: 2.4GHz Basic data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """basic_data_rates_2g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__basic_data_rates_2g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_basic_data_rates_2g(self):
    self.__basic_data_rates_2g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_supported_data_rates_2g(self):
    """
    Getter method for supported_data_rates_2g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/supported_data_rates_2g (identityref)

    YANG Description: 2.4GHz Supported data-rates for the SSID.
    """
    return self.__supported_data_rates_2g
      
  def _set_supported_data_rates_2g(self, v, load=False):
    """
    Setter method for supported_data_rates_2g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/supported_data_rates_2g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_data_rates_2g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_data_rates_2g() directly.

    YANG Description: 2.4GHz Supported data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_data_rates_2g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__supported_data_rates_2g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_data_rates_2g(self):
    self.__supported_data_rates_2g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-2g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_basic_data_rates_5g(self):
    """
    Getter method for basic_data_rates_5g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/basic_data_rates_5g (identityref)

    YANG Description: 5GHz Basic data-rates for the SSID.
    """
    return self.__basic_data_rates_5g
      
  def _set_basic_data_rates_5g(self, v, load=False):
    """
    Setter method for basic_data_rates_5g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/basic_data_rates_5g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_basic_data_rates_5g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_basic_data_rates_5g() directly.

    YANG Description: 5GHz Basic data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """basic_data_rates_5g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__basic_data_rates_5g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_basic_data_rates_5g(self):
    self.__basic_data_rates_5g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_supported_data_rates_5g(self):
    """
    Getter method for supported_data_rates_5g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/supported_data_rates_5g (identityref)

    YANG Description: 5GHz Supported data-rates for the SSID.
    """
    return self.__supported_data_rates_5g
      
  def _set_supported_data_rates_5g(self, v, load=False):
    """
    Setter method for supported_data_rates_5g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/supported_data_rates_5g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_data_rates_5g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_data_rates_5g() directly.

    YANG Description: 5GHz Supported data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_data_rates_5g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__supported_data_rates_5g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_data_rates_5g(self):
    self.__supported_data_rates_5g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-5g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_basic_data_rates_6g(self):
    """
    Getter method for basic_data_rates_6g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/basic_data_rates_6g (identityref)

    YANG Description: 6GHz Basic data-rates for the SSID.
    """
    return self.__basic_data_rates_6g
      
  def _set_basic_data_rates_6g(self, v, load=False):
    """
    Setter method for basic_data_rates_6g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/basic_data_rates_6g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_basic_data_rates_6g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_basic_data_rates_6g() directly.

    YANG Description: 6GHz Basic data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """basic_data_rates_6g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__basic_data_rates_6g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_basic_data_rates_6g(self):
    self.__basic_data_rates_6g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="basic-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_supported_data_rates_6g(self):
    """
    Getter method for supported_data_rates_6g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/supported_data_rates_6g (identityref)

    YANG Description: 6GHz Supported data-rates for the SSID.
    """
    return self.__supported_data_rates_6g
      
  def _set_supported_data_rates_6g(self, v, load=False):
    """
    Setter method for supported_data_rates_6g, mapped from YANG variable /access_points/access_point/ssids/ssid/state/supported_data_rates_6g (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_data_rates_6g is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_data_rates_6g() directly.

    YANG Description: 6GHz Supported data-rates for the SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_data_rates_6g must be of a type compatible with identityref""",
          'defined-type': "openconfig-access-points:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)""",
        })

    self.__supported_data_rates_6g = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_data_rates_6g(self):
    self.__supported_data_rates_6g = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_1MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_2MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_5.5MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_6MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_9MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_11MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_12MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_18MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_24MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_36MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_48MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi-types:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}, 'oc-wifi:RATE_54MB': {'@module': 'openconfig-wifi-types', '@namespace': 'http://openconfig.net/yang/wifi/wifi-types'}},)), is_leaf=False, yang_name="supported-data-rates-6g", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='identityref', is_config=False)


  def _get_broadcast_filter(self):
    """
    Getter method for broadcast_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/state/broadcast_filter (boolean)

    YANG Description: Convert all downstream broadcast ARP to unicast
only if Station is associated to the AP. Drop packet
if Station is not associated to the AP. All other
broadcast, except DHCP, is dropped by the AP.

DHCP Offers/ACKs are converted to Unicast, over-the-air.
    """
    return self.__broadcast_filter
      
  def _set_broadcast_filter(self, v, load=False):
    """
    Setter method for broadcast_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/state/broadcast_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_broadcast_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_broadcast_filter() directly.

    YANG Description: Convert all downstream broadcast ARP to unicast
only if Station is associated to the AP. Drop packet
if Station is not associated to the AP. All other
broadcast, except DHCP, is dropped by the AP.

DHCP Offers/ACKs are converted to Unicast, over-the-air.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="broadcast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """broadcast_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="broadcast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__broadcast_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_broadcast_filter(self):
    self.__broadcast_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="broadcast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_multicast_filter(self):
    """
    Getter method for multicast_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/state/multicast_filter (boolean)

    YANG Description: Drop all downstream Multicast packets.
    """
    return self.__multicast_filter
      
  def _set_multicast_filter(self, v, load=False):
    """
    Setter method for multicast_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/state/multicast_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_filter() directly.

    YANG Description: Drop all downstream Multicast packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="multicast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="multicast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__multicast_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_filter(self):
    self.__multicast_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="multicast-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_ipv6_ndp_filter(self):
    """
    Getter method for ipv6_ndp_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/state/ipv6_ndp_filter (boolean)

    YANG Description: Neighbor Advertisements will be cached at the AP (or WLC)
and unicast in response to Neighbor Solicitations.

Router Advertisements, in response to a Router Solicitation
are converted to Unicast for over-the-air transmission.
    """
    return self.__ipv6_ndp_filter
      
  def _set_ipv6_ndp_filter(self, v, load=False):
    """
    Setter method for ipv6_ndp_filter, mapped from YANG variable /access_points/access_point/ssids/ssid/state/ipv6_ndp_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6_ndp_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6_ndp_filter() directly.

    YANG Description: Neighbor Advertisements will be cached at the AP (or WLC)
and unicast in response to Neighbor Solicitations.

Router Advertisements, in response to a Router Solicitation
are converted to Unicast for over-the-air transmission.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="ipv6-ndp-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6_ndp_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ipv6-ndp-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__ipv6_ndp_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6_ndp_filter(self):
    self.__ipv6_ndp_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ipv6-ndp-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_ipv6_ndp_filter_timer(self):
    """
    Getter method for ipv6_ndp_filter_timer, mapped from YANG variable /access_points/access_point/ssids/ssid/state/ipv6_ndp_filter_timer (uint16)

    YANG Description: Time, in seconds, the ndp-filter will cache
Neighbor Advertisements (NA).
    """
    return self.__ipv6_ndp_filter_timer
      
  def _set_ipv6_ndp_filter_timer(self, v, load=False):
    """
    Setter method for ipv6_ndp_filter_timer, mapped from YANG variable /access_points/access_point/ssids/ssid/state/ipv6_ndp_filter_timer (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6_ndp_filter_timer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6_ndp_filter_timer() directly.

    YANG Description: Time, in seconds, the ndp-filter will cache
Neighbor Advertisements (NA).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ipv6-ndp-filter-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6_ndp_filter_timer must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ipv6-ndp-filter-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)""",
        })

    self.__ipv6_ndp_filter_timer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6_ndp_filter_timer(self):
    self.__ipv6_ndp_filter_timer = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ipv6-ndp-filter-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)


  def _get_station_isolation(self):
    """
    Getter method for station_isolation, mapped from YANG variable /access_points/access_point/ssids/ssid/state/station_isolation (boolean)

    YANG Description: Block Station peer to peer communication.
    """
    return self.__station_isolation
      
  def _set_station_isolation(self, v, load=False):
    """
    Setter method for station_isolation, mapped from YANG variable /access_points/access_point/ssids/ssid/state/station_isolation (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_station_isolation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_station_isolation() directly.

    YANG Description: Block Station peer to peer communication.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="station-isolation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """station_isolation must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="station-isolation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__station_isolation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_station_isolation(self):
    self.__station_isolation = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="station-isolation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_opmode(self):
    """
    Getter method for opmode, mapped from YANG variable /access_points/access_point/ssids/ssid/state/opmode (enumeration)

    YANG Description: The type of Layer2 authentication in use.
    """
    return self.__opmode
      
  def _set_opmode(self, v, load=False):
    """
    Setter method for opmode, mapped from YANG variable /access_points/access_point/ssids/ssid/state/opmode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_opmode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_opmode() directly.

    YANG Description: The type of Layer2 authentication in use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """opmode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-access-points:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=False)""",
        })

    self.__opmode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_opmode(self):
    self.__opmode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'OPEN': {}, 'WPA2_PERSONAL': {}, 'WPA2_ENTERPRISE': {}, 'ENHANCED_OPEN': {}, 'WPA3_SAE': {}, 'WPA3_ENTERPRISE': {}, 'WPA3_ENTERPRISE_192_BIT': {}},), is_leaf=True, yang_name="opmode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='enumeration', is_config=False)


  def _get_wpa2_psk(self):
    """
    Getter method for wpa2_psk, mapped from YANG variable /access_points/access_point/ssids/ssid/state/wpa2_psk (string)

    YANG Description: The passphrase used on this WPA2-Personal SSID.
    """
    return self.__wpa2_psk
      
  def _set_wpa2_psk(self, v, load=False):
    """
    Setter method for wpa2_psk, mapped from YANG variable /access_points/access_point/ssids/ssid/state/wpa2_psk (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_wpa2_psk is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_wpa2_psk() directly.

    YANG Description: The passphrase used on this WPA2-Personal SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa2-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """wpa2_psk must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa2-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)""",
        })

    self.__wpa2_psk = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_wpa2_psk(self):
    self.__wpa2_psk = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa2-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)


  def _get_wpa3_psk(self):
    """
    Getter method for wpa3_psk, mapped from YANG variable /access_points/access_point/ssids/ssid/state/wpa3_psk (string)

    YANG Description: The passphrase used on this WPA3-SAE SSID.
    """
    return self.__wpa3_psk
      
  def _set_wpa3_psk(self, v, load=False):
    """
    Setter method for wpa3_psk, mapped from YANG variable /access_points/access_point/ssids/ssid/state/wpa3_psk (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_wpa3_psk is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_wpa3_psk() directly.

    YANG Description: The passphrase used on this WPA3-SAE SSID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa3-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """wpa3_psk must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa3-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)""",
        })

    self.__wpa3_psk = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_wpa3_psk(self):
    self.__wpa3_psk = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['8..63']}), is_leaf=True, yang_name="wpa3-psk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)


  def _get_server_group(self):
    """
    Getter method for server_group, mapped from YANG variable /access_points/access_point/ssids/ssid/state/server_group (string)

    YANG Description: Specifies the RADIUS server-group to be used,
as defined in the openconfig-aaa.yang model.

Including WPA2_PERSONAL and WPA3_SAE as they can be accompanied by
MAB.
    """
    return self.__server_group
      
  def _set_server_group(self, v, load=False):
    """
    Setter method for server_group, mapped from YANG variable /access_points/access_point/ssids/ssid/state/server_group (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_server_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_server_group() directly.

    YANG Description: Specifies the RADIUS server-group to be used,
as defined in the openconfig-aaa.yang model.

Including WPA2_PERSONAL and WPA3_SAE as they can be accompanied by
MAB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """server_group must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)""",
        })

    self.__server_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_server_group(self):
    self.__server_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='string', is_config=False)


  def _get_dva(self):
    """
    Getter method for dva, mapped from YANG variable /access_points/access_point/ssids/ssid/state/dva (boolean)

    YANG Description: Enable/disable Dynamic VLAN Assignment,
using 'Tunnel-Private-Group-Id' RADIUS attribute.
    """
    return self.__dva
      
  def _set_dva(self, v, load=False):
    """
    Setter method for dva, mapped from YANG variable /access_points/access_point/ssids/ssid/state/dva (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dva is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dva() directly.

    YANG Description: Enable/disable Dynamic VLAN Assignment,
using 'Tunnel-Private-Group-Id' RADIUS attribute.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="dva", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dva must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dva", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__dva = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dva(self):
    self.__dva = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dva", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_dhcp_required(self):
    """
    Getter method for dhcp_required, mapped from YANG variable /access_points/access_point/ssids/ssid/state/dhcp_required (boolean)

    YANG Description: Allow a Station to access the network only if
a DHCP exchange has occurred.
    """
    return self.__dhcp_required
      
  def _set_dhcp_required(self, v, load=False):
    """
    Setter method for dhcp_required, mapped from YANG variable /access_points/access_point/ssids/ssid/state/dhcp_required (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_required is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_required() directly.

    YANG Description: Allow a Station to access the network only if
a DHCP exchange has occurred.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="dhcp-required", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_required must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dhcp-required", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__dhcp_required = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_required(self):
    self.__dhcp_required = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dhcp-required", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_qbss_load(self):
    """
    Getter method for qbss_load, mapped from YANG variable /access_points/access_point/ssids/ssid/state/qbss_load (boolean)

    YANG Description: Advertisement of the QBSS Load Information Element.
    """
    return self.__qbss_load
      
  def _set_qbss_load(self, v, load=False):
    """
    Setter method for qbss_load, mapped from YANG variable /access_points/access_point/ssids/ssid/state/qbss_load (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_qbss_load is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_qbss_load() directly.

    YANG Description: Advertisement of the QBSS Load Information Element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="qbss-load", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """qbss_load must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="qbss-load", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__qbss_load = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_qbss_load(self):
    self.__qbss_load = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="qbss-load", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_advertise_apname(self):
    """
    Getter method for advertise_apname, mapped from YANG variable /access_points/access_point/ssids/ssid/state/advertise_apname (boolean)

    YANG Description: Advertise the AP hostname in Beacon and Probe Response frames.
    """
    return self.__advertise_apname
      
  def _set_advertise_apname(self, v, load=False):
    """
    Setter method for advertise_apname, mapped from YANG variable /access_points/access_point/ssids/ssid/state/advertise_apname (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_advertise_apname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_advertise_apname() directly.

    YANG Description: Advertise the AP hostname in Beacon and Probe Response frames.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="advertise-apname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """advertise_apname must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="advertise-apname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__advertise_apname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_advertise_apname(self):
    self.__advertise_apname = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="advertise-apname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_csa(self):
    """
    Getter method for csa, mapped from YANG variable /access_points/access_point/ssids/ssid/state/csa (boolean)

    YANG Description: Enable/Disable 802.11h channel-switch-announcement.
    """
    return self.__csa
      
  def _set_csa(self, v, load=False):
    """
    Setter method for csa, mapped from YANG variable /access_points/access_point/ssids/ssid/state/csa (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_csa is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_csa() directly.

    YANG Description: Enable/Disable 802.11h channel-switch-announcement.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="csa", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """csa must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="csa", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__csa = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_csa(self):
    self.__csa = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="csa", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_ptk_timeout(self):
    """
    Getter method for ptk_timeout, mapped from YANG variable /access_points/access_point/ssids/ssid/state/ptk_timeout (uint16)

    YANG Description: Time, in seconds, for the Pairwise Transient Key.
    """
    return self.__ptk_timeout
      
  def _set_ptk_timeout(self, v, load=False):
    """
    Setter method for ptk_timeout, mapped from YANG variable /access_points/access_point/ssids/ssid/state/ptk_timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ptk_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ptk_timeout() directly.

    YANG Description: Time, in seconds, for the Pairwise Transient Key.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ptk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ptk_timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ptk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)""",
        })

    self.__ptk_timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ptk_timeout(self):
    self.__ptk_timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ptk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)


  def _get_gtk_timeout(self):
    """
    Getter method for gtk_timeout, mapped from YANG variable /access_points/access_point/ssids/ssid/state/gtk_timeout (uint16)

    YANG Description: TTL for the Group Temporal Key.
    """
    return self.__gtk_timeout
      
  def _set_gtk_timeout(self, v, load=False):
    """
    Setter method for gtk_timeout, mapped from YANG variable /access_points/access_point/ssids/ssid/state/gtk_timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_gtk_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_gtk_timeout() directly.

    YANG Description: TTL for the Group Temporal Key.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="gtk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """gtk_timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="gtk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)""",
        })

    self.__gtk_timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_gtk_timeout(self):
    self.__gtk_timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="gtk-timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='uint16', is_config=False)


  def _get_dot11k(self):
    """
    Getter method for dot11k, mapped from YANG variable /access_points/access_point/ssids/ssid/state/dot11k (boolean)

    YANG Description: 802.11k neighbor-list enabled/disabled.
    """
    return self.__dot11k
      
  def _set_dot11k(self, v, load=False):
    """
    Setter method for dot11k, mapped from YANG variable /access_points/access_point/ssids/ssid/state/dot11k (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dot11k is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dot11k() directly.

    YANG Description: 802.11k neighbor-list enabled/disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="dot11k", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dot11k must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dot11k", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__dot11k = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dot11k(self):
    self.__dot11k = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dot11k", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_okc(self):
    """
    Getter method for okc, mapped from YANG variable /access_points/access_point/ssids/ssid/state/okc (boolean)

    YANG Description: Enable/disable Opportunistic Key Caching.
    """
    return self.__okc
      
  def _set_okc(self, v, load=False):
    """
    Setter method for okc, mapped from YANG variable /access_points/access_point/ssids/ssid/state/okc (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_okc is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_okc() directly.

    YANG Description: Enable/disable Opportunistic Key Caching.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="okc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """okc must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="okc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__okc = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_okc(self):
    self.__okc = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="okc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)


  def _get_mfp(self):
    """
    Getter method for mfp, mapped from YANG variable /access_points/access_point/ssids/ssid/state/mfp (boolean)

    YANG Description: Management Frame Protection is required for WPA3 and OWE.
    """
    return self.__mfp
      
  def _set_mfp(self, v, load=False):
    """
    Setter method for mfp, mapped from YANG variable /access_points/access_point/ssids/ssid/state/mfp (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mfp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mfp() directly.

    YANG Description: Management Frame Protection is required for WPA3 and OWE.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="mfp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mfp must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mfp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)""",
        })

    self.__mfp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mfp(self):
    self.__mfp = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mfp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='boolean', is_config=False)

  name = __builtin__.property(_get_name)
  enabled = __builtin__.property(_get_enabled)
  hidden = __builtin__.property(_get_hidden)
  default_vlan = __builtin__.property(_get_default_vlan)
  vlan_list = __builtin__.property(_get_vlan_list)
  operating_frequency = __builtin__.property(_get_operating_frequency)
  basic_data_rates_2g = __builtin__.property(_get_basic_data_rates_2g)
  supported_data_rates_2g = __builtin__.property(_get_supported_data_rates_2g)
  basic_data_rates_5g = __builtin__.property(_get_basic_data_rates_5g)
  supported_data_rates_5g = __builtin__.property(_get_supported_data_rates_5g)
  basic_data_rates_6g = __builtin__.property(_get_basic_data_rates_6g)
  supported_data_rates_6g = __builtin__.property(_get_supported_data_rates_6g)
  broadcast_filter = __builtin__.property(_get_broadcast_filter)
  multicast_filter = __builtin__.property(_get_multicast_filter)
  ipv6_ndp_filter = __builtin__.property(_get_ipv6_ndp_filter)
  ipv6_ndp_filter_timer = __builtin__.property(_get_ipv6_ndp_filter_timer)
  station_isolation = __builtin__.property(_get_station_isolation)
  opmode = __builtin__.property(_get_opmode)
  wpa2_psk = __builtin__.property(_get_wpa2_psk)
  wpa3_psk = __builtin__.property(_get_wpa3_psk)
  server_group = __builtin__.property(_get_server_group)
  dva = __builtin__.property(_get_dva)
  dhcp_required = __builtin__.property(_get_dhcp_required)
  qbss_load = __builtin__.property(_get_qbss_load)
  advertise_apname = __builtin__.property(_get_advertise_apname)
  csa = __builtin__.property(_get_csa)
  ptk_timeout = __builtin__.property(_get_ptk_timeout)
  gtk_timeout = __builtin__.property(_get_gtk_timeout)
  dot11k = __builtin__.property(_get_dot11k)
  okc = __builtin__.property(_get_okc)
  mfp = __builtin__.property(_get_mfp)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ('hidden', hidden), ('default_vlan', default_vlan), ('vlan_list', vlan_list), ('operating_frequency', operating_frequency), ('basic_data_rates_2g', basic_data_rates_2g), ('supported_data_rates_2g', supported_data_rates_2g), ('basic_data_rates_5g', basic_data_rates_5g), ('supported_data_rates_5g', supported_data_rates_5g), ('basic_data_rates_6g', basic_data_rates_6g), ('supported_data_rates_6g', supported_data_rates_6g), ('broadcast_filter', broadcast_filter), ('multicast_filter', multicast_filter), ('ipv6_ndp_filter', ipv6_ndp_filter), ('ipv6_ndp_filter_timer', ipv6_ndp_filter_timer), ('station_isolation', station_isolation), ('opmode', opmode), ('wpa2_psk', wpa2_psk), ('wpa3_psk', wpa3_psk), ('server_group', server_group), ('dva', dva), ('dhcp_required', dhcp_required), ('qbss_load', qbss_load), ('advertise_apname', advertise_apname), ('csa', csa), ('ptk_timeout', ptk_timeout), ('gtk_timeout', gtk_timeout), ('dot11k', dot11k), ('okc', okc), ('mfp', mfp), ])


class yc_rx_data_dist_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_rx_data_dist(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/bssids/bssid/state/counters/rx-data-dist. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The distribution of Data frame sizes in bytes of
successfully received AMPDU, or MPDU for non-aggregated,
frames. The distribution should characterize frame sizes
starting at 64 bytes or less with the bin size doubling for
each successive bin to a maximum of 1MB or larger, as
represented in the following table:

Lower Bound Upper Bound
  0          64
  65         128
  129        256
  257        512
  513        1024
  1025       2048
  2049       4096
  4097       8192
  8193       16384
  16385      32768
  32769      65536
  65537      131072
  131073     262144
  262145     524288
  524289     1048576
  """
  __slots__ = ('_path_helper', '_extmethods', '__rx_0_64','__rx_65_128','__rx_129_256','__rx_257_512','__rx_513_1024','__rx_1025_2048','__rx_2049_4096','__rx_4097_8192','__rx_8193_16384','__rx_16385_32768','__rx_32769_65536','__rx_65537_131072','__rx_131073_262144','__rx_262145_524288','__rx_524289_1048576',)

  _yang_name = 'rx-data-dist'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__rx_0_64 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-0-64", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_65_128 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-65-128", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_129_256 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-129-256", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_257_512 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-257-512", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_513_1024 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-513-1024", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_1025_2048 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-1025-2048", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_2049_4096 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-2049-4096", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_4097_8192 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-4097-8192", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_8193_16384 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-8193-16384", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_16385_32768 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-16385-32768", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_32769_65536 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-32769-65536", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_65537_131072 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-65537-131072", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_131073_262144 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-131073-262144", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_262145_524288 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-262145-524288", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_524289_1048576 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-524289-1048576", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'bssids', 'bssid', 'state', 'counters', 'rx-data-dist']

  def _get_rx_0_64(self):
    """
    Getter method for rx_0_64, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_0_64 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 0 to 64 Bytes.
    """
    return self.__rx_0_64
      
  def _set_rx_0_64(self, v, load=False):
    """
    Setter method for rx_0_64, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_0_64 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_0_64 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_0_64() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 0 to 64 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-0-64", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_0_64 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-0-64", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_0_64 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_0_64(self):
    self.__rx_0_64 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-0-64", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_65_128(self):
    """
    Getter method for rx_65_128, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_65_128 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 65 to 128 Bytes.
    """
    return self.__rx_65_128
      
  def _set_rx_65_128(self, v, load=False):
    """
    Setter method for rx_65_128, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_65_128 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_65_128 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_65_128() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 65 to 128 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-65-128", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_65_128 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-65-128", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_65_128 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_65_128(self):
    self.__rx_65_128 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-65-128", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_129_256(self):
    """
    Getter method for rx_129_256, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_129_256 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 129 to 256 Bytes.
    """
    return self.__rx_129_256
      
  def _set_rx_129_256(self, v, load=False):
    """
    Setter method for rx_129_256, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_129_256 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_129_256 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_129_256() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 129 to 256 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-129-256", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_129_256 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-129-256", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_129_256 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_129_256(self):
    self.__rx_129_256 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-129-256", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_257_512(self):
    """
    Getter method for rx_257_512, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_257_512 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 257 to 512 Bytes.
    """
    return self.__rx_257_512
      
  def _set_rx_257_512(self, v, load=False):
    """
    Setter method for rx_257_512, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_257_512 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_257_512 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_257_512() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 257 to 512 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-257-512", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_257_512 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-257-512", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_257_512 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_257_512(self):
    self.__rx_257_512 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-257-512", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_513_1024(self):
    """
    Getter method for rx_513_1024, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_513_1024 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 513 to 1024 Bytes.
    """
    return self.__rx_513_1024
      
  def _set_rx_513_1024(self, v, load=False):
    """
    Setter method for rx_513_1024, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_513_1024 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_513_1024 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_513_1024() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 513 to 1024 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-513-1024", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_513_1024 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-513-1024", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_513_1024 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_513_1024(self):
    self.__rx_513_1024 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-513-1024", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_1025_2048(self):
    """
    Getter method for rx_1025_2048, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_1025_2048 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 1025 to 2048 Bytes.
    """
    return self.__rx_1025_2048
      
  def _set_rx_1025_2048(self, v, load=False):
    """
    Setter method for rx_1025_2048, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_1025_2048 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_1025_2048 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_1025_2048() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 1025 to 2048 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-1025-2048", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_1025_2048 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-1025-2048", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_1025_2048 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_1025_2048(self):
    self.__rx_1025_2048 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-1025-2048", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_2049_4096(self):
    """
    Getter method for rx_2049_4096, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_2049_4096 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 2049 to 4096 Bytes.
    """
    return self.__rx_2049_4096
      
  def _set_rx_2049_4096(self, v, load=False):
    """
    Setter method for rx_2049_4096, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_2049_4096 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_2049_4096 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_2049_4096() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 2049 to 4096 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-2049-4096", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_2049_4096 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-2049-4096", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_2049_4096 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_2049_4096(self):
    self.__rx_2049_4096 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-2049-4096", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_4097_8192(self):
    """
    Getter method for rx_4097_8192, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_4097_8192 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 4097 to 8192 Bytes.
    """
    return self.__rx_4097_8192
      
  def _set_rx_4097_8192(self, v, load=False):
    """
    Setter method for rx_4097_8192, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_4097_8192 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_4097_8192 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_4097_8192() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 4097 to 8192 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-4097-8192", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_4097_8192 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-4097-8192", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_4097_8192 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_4097_8192(self):
    self.__rx_4097_8192 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-4097-8192", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_8193_16384(self):
    """
    Getter method for rx_8193_16384, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_8193_16384 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 8193 to 16384 Bytes.
    """
    return self.__rx_8193_16384
      
  def _set_rx_8193_16384(self, v, load=False):
    """
    Setter method for rx_8193_16384, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_8193_16384 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_8193_16384 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_8193_16384() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 8193 to 16384 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-8193-16384", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_8193_16384 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-8193-16384", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_8193_16384 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_8193_16384(self):
    self.__rx_8193_16384 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-8193-16384", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_16385_32768(self):
    """
    Getter method for rx_16385_32768, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_16385_32768 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 16385 to 32768 Bytes.
    """
    return self.__rx_16385_32768
      
  def _set_rx_16385_32768(self, v, load=False):
    """
    Setter method for rx_16385_32768, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_16385_32768 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_16385_32768 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_16385_32768() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 16385 to 32768 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-16385-32768", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_16385_32768 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-16385-32768", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_16385_32768 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_16385_32768(self):
    self.__rx_16385_32768 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-16385-32768", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_32769_65536(self):
    """
    Getter method for rx_32769_65536, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_32769_65536 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 32769 to 65536 Bytes.
    """
    return self.__rx_32769_65536
      
  def _set_rx_32769_65536(self, v, load=False):
    """
    Setter method for rx_32769_65536, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_32769_65536 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_32769_65536 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_32769_65536() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 32769 to 65536 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-32769-65536", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_32769_65536 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-32769-65536", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_32769_65536 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_32769_65536(self):
    self.__rx_32769_65536 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-32769-65536", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_65537_131072(self):
    """
    Getter method for rx_65537_131072, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_65537_131072 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU from 65537 to 131072 Bytes.
    """
    return self.__rx_65537_131072
      
  def _set_rx_65537_131072(self, v, load=False):
    """
    Setter method for rx_65537_131072, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_65537_131072 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_65537_131072 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_65537_131072() directly.

    YANG Description: Transmitted AMPDU from 65537 to 131072 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-65537-131072", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_65537_131072 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-65537-131072", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_65537_131072 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_65537_131072(self):
    self.__rx_65537_131072 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-65537-131072", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_131073_262144(self):
    """
    Getter method for rx_131073_262144, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_131073_262144 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU from 131073 to 262144 Bytes.
    """
    return self.__rx_131073_262144
      
  def _set_rx_131073_262144(self, v, load=False):
    """
    Setter method for rx_131073_262144, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_131073_262144 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_131073_262144 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_131073_262144() directly.

    YANG Description: Transmitted AMPDU from 131073 to 262144 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-131073-262144", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_131073_262144 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-131073-262144", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_131073_262144 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_131073_262144(self):
    self.__rx_131073_262144 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-131073-262144", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_262145_524288(self):
    """
    Getter method for rx_262145_524288, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_262145_524288 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU from 262145 to 524288 Bytes.
    """
    return self.__rx_262145_524288
      
  def _set_rx_262145_524288(self, v, load=False):
    """
    Setter method for rx_262145_524288, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_262145_524288 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_262145_524288 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_262145_524288() directly.

    YANG Description: Transmitted AMPDU from 262145 to 524288 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-262145-524288", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_262145_524288 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-262145-524288", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_262145_524288 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_262145_524288(self):
    self.__rx_262145_524288 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-262145-524288", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_524289_1048576(self):
    """
    Getter method for rx_524289_1048576, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_524289_1048576 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU from 524289 to 1048576 Bytes.
    """
    return self.__rx_524289_1048576
      
  def _set_rx_524289_1048576(self, v, load=False):
    """
    Setter method for rx_524289_1048576, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_dist/rx_524289_1048576 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_524289_1048576 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_524289_1048576() directly.

    YANG Description: Transmitted AMPDU from 524289 to 1048576 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-524289-1048576", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_524289_1048576 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-524289-1048576", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_524289_1048576 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_524289_1048576(self):
    self.__rx_524289_1048576 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-524289-1048576", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

  rx_0_64 = __builtin__.property(_get_rx_0_64)
  rx_65_128 = __builtin__.property(_get_rx_65_128)
  rx_129_256 = __builtin__.property(_get_rx_129_256)
  rx_257_512 = __builtin__.property(_get_rx_257_512)
  rx_513_1024 = __builtin__.property(_get_rx_513_1024)
  rx_1025_2048 = __builtin__.property(_get_rx_1025_2048)
  rx_2049_4096 = __builtin__.property(_get_rx_2049_4096)
  rx_4097_8192 = __builtin__.property(_get_rx_4097_8192)
  rx_8193_16384 = __builtin__.property(_get_rx_8193_16384)
  rx_16385_32768 = __builtin__.property(_get_rx_16385_32768)
  rx_32769_65536 = __builtin__.property(_get_rx_32769_65536)
  rx_65537_131072 = __builtin__.property(_get_rx_65537_131072)
  rx_131073_262144 = __builtin__.property(_get_rx_131073_262144)
  rx_262145_524288 = __builtin__.property(_get_rx_262145_524288)
  rx_524289_1048576 = __builtin__.property(_get_rx_524289_1048576)


  _pyangbind_elements = OrderedDict([('rx_0_64', rx_0_64), ('rx_65_128', rx_65_128), ('rx_129_256', rx_129_256), ('rx_257_512', rx_257_512), ('rx_513_1024', rx_513_1024), ('rx_1025_2048', rx_1025_2048), ('rx_2049_4096', rx_2049_4096), ('rx_4097_8192', rx_4097_8192), ('rx_8193_16384', rx_8193_16384), ('rx_16385_32768', rx_16385_32768), ('rx_32769_65536', rx_32769_65536), ('rx_65537_131072', rx_65537_131072), ('rx_131073_262144', rx_131073_262144), ('rx_262145_524288', rx_262145_524288), ('rx_524289_1048576', rx_524289_1048576), ])


class yc_rx_data_wmm_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_rx_data_wmm(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/bssids/bssid/state/counters/rx-data-wmm. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Received 802.11 Data frames, per WMM Access Category.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vi','__vo','__be','__bk',)

  _yang_name = 'rx-data-wmm'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vi = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__vo = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__be = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="be", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__bk = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'bssids', 'bssid', 'state', 'counters', 'rx-data-wmm']

  def _get_vi(self):
    """
    Getter method for vi, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_wmm/vi (oc-yang:counter64)

    YANG Description: Rx Data frames marked as Access Category Video.
    """
    return self.__vi
      
  def _set_vi(self, v, load=False):
    """
    Setter method for vi, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_wmm/vi (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vi() directly.

    YANG Description: Rx Data frames marked as Access Category Video.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vi must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__vi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vi(self):
    self.__vi = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_vo(self):
    """
    Getter method for vo, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_wmm/vo (oc-yang:counter64)

    YANG Description: Rx Data frames marked as Access Category Voice.
    """
    return self.__vo
      
  def _set_vo(self, v, load=False):
    """
    Setter method for vo, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_wmm/vo (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vo is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vo() directly.

    YANG Description: Rx Data frames marked as Access Category Voice.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vo must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__vo = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vo(self):
    self.__vo = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_be(self):
    """
    Getter method for be, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_wmm/be (oc-yang:counter64)

    YANG Description: Rx Data frames marked as Access Category Best Effort.
    """
    return self.__be
      
  def _set_be(self, v, load=False):
    """
    Setter method for be, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_wmm/be (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_be is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_be() directly.

    YANG Description: Rx Data frames marked as Access Category Best Effort.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="be", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """be must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="be", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__be = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_be(self):
    self.__be = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="be", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_bk(self):
    """
    Getter method for bk, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_wmm/bk (oc-yang:counter64)

    YANG Description: Rx Data frames marked as Access Category Background.
    """
    return self.__bk
      
  def _set_bk(self, v, load=False):
    """
    Setter method for bk, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_data_wmm/bk (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bk is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bk() directly.

    YANG Description: Rx Data frames marked as Access Category Background.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bk must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bk = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bk(self):
    self.__bk = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

  vi = __builtin__.property(_get_vi)
  vo = __builtin__.property(_get_vo)
  be = __builtin__.property(_get_be)
  bk = __builtin__.property(_get_bk)


  _pyangbind_elements = OrderedDict([('vi', vi), ('vo', vo), ('be', be), ('bk', bk), ])


class yc_rx_mcs_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_rx_mcs(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/bssids/bssid/state/counters/rx-mcs. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Received Data frames, per MCS Index. It is expected that
vendors bucketize 802.11n MCS frames in their matching
802.11ac buckets.

Example, 802.11n MCS 15 = 802.11ac MCS 7.
802.11n MCS 20 = 802.11ac MCS 4.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mcs0','__mcs1','__mcs2','__mcs3','__mcs4','__mcs5','__mcs6','__mcs7','__mcs8','__mcs9','__mcs10','__mcs11',)

  _yang_name = 'rx-mcs'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mcs0 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs0", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs1 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs1", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs2 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs3 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs3", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs4 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs5 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs5", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs6 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs7 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs7", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs8 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs8", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs9 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs9", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs10 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs10", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs11 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs11", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'bssids', 'bssid', 'state', 'counters', 'rx-mcs']

  def _get_mcs0(self):
    """
    Getter method for mcs0, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs0 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 0.
    """
    return self.__mcs0
      
  def _set_mcs0(self, v, load=False):
    """
    Setter method for mcs0, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs0 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs0 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs0() directly.

    YANG Description: Rx Data frames at MCS 0.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs0", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs0 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs0", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs0 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs0(self):
    self.__mcs0 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs0", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs1(self):
    """
    Getter method for mcs1, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs1 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 1.
    """
    return self.__mcs1
      
  def _set_mcs1(self, v, load=False):
    """
    Setter method for mcs1, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs1 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs1 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs1() directly.

    YANG Description: Rx Data frames at MCS 1.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs1", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs1 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs1", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs1 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs1(self):
    self.__mcs1 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs1", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs2(self):
    """
    Getter method for mcs2, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs2 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 2.
    """
    return self.__mcs2
      
  def _set_mcs2(self, v, load=False):
    """
    Setter method for mcs2, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs2 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs2 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs2() directly.

    YANG Description: Rx Data frames at MCS 2.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs2 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs2 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs2(self):
    self.__mcs2 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs3(self):
    """
    Getter method for mcs3, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs3 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 3.
    """
    return self.__mcs3
      
  def _set_mcs3(self, v, load=False):
    """
    Setter method for mcs3, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs3 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs3 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs3() directly.

    YANG Description: Rx Data frames at MCS 3.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs3", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs3 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs3", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs3 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs3(self):
    self.__mcs3 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs3", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs4(self):
    """
    Getter method for mcs4, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs4 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 4.
    """
    return self.__mcs4
      
  def _set_mcs4(self, v, load=False):
    """
    Setter method for mcs4, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs4 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs4() directly.

    YANG Description: Rx Data frames at MCS 4.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs4 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs4(self):
    self.__mcs4 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs5(self):
    """
    Getter method for mcs5, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs5 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 5.
    """
    return self.__mcs5
      
  def _set_mcs5(self, v, load=False):
    """
    Setter method for mcs5, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs5 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs5 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs5() directly.

    YANG Description: Rx Data frames at MCS 5.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs5", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs5 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs5", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs5 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs5(self):
    self.__mcs5 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs5", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs6(self):
    """
    Getter method for mcs6, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs6 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 6.
    """
    return self.__mcs6
      
  def _set_mcs6(self, v, load=False):
    """
    Setter method for mcs6, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs6 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs6() directly.

    YANG Description: Rx Data frames at MCS 6.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs6 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs6(self):
    self.__mcs6 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs7(self):
    """
    Getter method for mcs7, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs7 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 7.
    """
    return self.__mcs7
      
  def _set_mcs7(self, v, load=False):
    """
    Setter method for mcs7, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs7 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs7 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs7() directly.

    YANG Description: Rx Data frames at MCS 7.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs7", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs7 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs7", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs7 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs7(self):
    self.__mcs7 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs7", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs8(self):
    """
    Getter method for mcs8, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs8 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 8.
    """
    return self.__mcs8
      
  def _set_mcs8(self, v, load=False):
    """
    Setter method for mcs8, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs8 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs8 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs8() directly.

    YANG Description: Rx Data frames at MCS 8.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs8", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs8 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs8", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs8 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs8(self):
    self.__mcs8 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs8", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs9(self):
    """
    Getter method for mcs9, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs9 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 9.
    """
    return self.__mcs9
      
  def _set_mcs9(self, v, load=False):
    """
    Setter method for mcs9, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs9 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs9 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs9() directly.

    YANG Description: Rx Data frames at MCS 9.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs9", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs9 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs9", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs9 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs9(self):
    self.__mcs9 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs9", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs10(self):
    """
    Getter method for mcs10, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs10 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 10.
    """
    return self.__mcs10
      
  def _set_mcs10(self, v, load=False):
    """
    Setter method for mcs10, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs10 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs10 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs10() directly.

    YANG Description: Rx Data frames at MCS 10.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs10", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs10 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs10", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs10 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs10(self):
    self.__mcs10 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs10", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs11(self):
    """
    Getter method for mcs11, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs11 (oc-yang:counter64)

    YANG Description: Rx Data frames at MCS 11.
    """
    return self.__mcs11
      
  def _set_mcs11(self, v, load=False):
    """
    Setter method for mcs11, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mcs/mcs11 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs11 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs11() directly.

    YANG Description: Rx Data frames at MCS 11.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs11", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs11 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs11", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs11 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs11(self):
    self.__mcs11 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs11", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

  mcs0 = __builtin__.property(_get_mcs0)
  mcs1 = __builtin__.property(_get_mcs1)
  mcs2 = __builtin__.property(_get_mcs2)
  mcs3 = __builtin__.property(_get_mcs3)
  mcs4 = __builtin__.property(_get_mcs4)
  mcs5 = __builtin__.property(_get_mcs5)
  mcs6 = __builtin__.property(_get_mcs6)
  mcs7 = __builtin__.property(_get_mcs7)
  mcs8 = __builtin__.property(_get_mcs8)
  mcs9 = __builtin__.property(_get_mcs9)
  mcs10 = __builtin__.property(_get_mcs10)
  mcs11 = __builtin__.property(_get_mcs11)


  _pyangbind_elements = OrderedDict([('mcs0', mcs0), ('mcs1', mcs1), ('mcs2', mcs2), ('mcs3', mcs3), ('mcs4', mcs4), ('mcs5', mcs5), ('mcs6', mcs6), ('mcs7', mcs7), ('mcs8', mcs8), ('mcs9', mcs9), ('mcs10', mcs10), ('mcs11', mcs11), ])


class yc_tx_data_dist_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_tx_data_dist(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/bssids/bssid/state/counters/tx-data-dist. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The distribution of Data frame sizes in bytes of
successfully transmitted AMPDU, or MPDU for non-aggregated,
frames. The distribution should characterize frame sizes
starting at 64 bytes or less with the bin size doubling for
each successive bin to a maximum of 1MB or larger, as
represented in the following table:

Lower Bound Upper Bound
  0          64
  65         128
  129        256
  257        512
  513        1024
  1025       2048
  2049       4096
  4097       8192
  8193       16384
  16385      32768
  32769      65536
  65537      131072
  131073     262144
  262145     524288
  524289     1048576
  """
  __slots__ = ('_path_helper', '_extmethods', '__tx_0_64','__tx_65_128','__tx_129_256','__tx_257_512','__tx_513_1024','__tx_1025_2048','__tx_2049_4096','__tx_4097_8192','__tx_8193_16384','__tx_16385_32768','__tx_32769_65536','__tx_65537_131072','__tx_131073_262144','__tx_262145_524288','__tx_524289_1048576',)

  _yang_name = 'tx-data-dist'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tx_0_64 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-0-64", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_65_128 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-65-128", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_129_256 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-129-256", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_257_512 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-257-512", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_513_1024 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-513-1024", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_1025_2048 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-1025-2048", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_2049_4096 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-2049-4096", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_4097_8192 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-4097-8192", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_8193_16384 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-8193-16384", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_16385_32768 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-16385-32768", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_32769_65536 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-32769-65536", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_65537_131072 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-65537-131072", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_131073_262144 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-131073-262144", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_262145_524288 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-262145-524288", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_524289_1048576 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-524289-1048576", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'bssids', 'bssid', 'state', 'counters', 'tx-data-dist']

  def _get_tx_0_64(self):
    """
    Getter method for tx_0_64, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_0_64 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 0 to 64 Bytes.
    """
    return self.__tx_0_64
      
  def _set_tx_0_64(self, v, load=False):
    """
    Setter method for tx_0_64, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_0_64 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_0_64 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_0_64() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 0 to 64 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-0-64", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_0_64 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-0-64", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_0_64 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_0_64(self):
    self.__tx_0_64 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-0-64", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_65_128(self):
    """
    Getter method for tx_65_128, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_65_128 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 65 to 128 Bytes.
    """
    return self.__tx_65_128
      
  def _set_tx_65_128(self, v, load=False):
    """
    Setter method for tx_65_128, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_65_128 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_65_128 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_65_128() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 65 to 128 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-65-128", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_65_128 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-65-128", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_65_128 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_65_128(self):
    self.__tx_65_128 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-65-128", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_129_256(self):
    """
    Getter method for tx_129_256, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_129_256 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 129 to 256 Bytes.
    """
    return self.__tx_129_256
      
  def _set_tx_129_256(self, v, load=False):
    """
    Setter method for tx_129_256, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_129_256 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_129_256 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_129_256() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 129 to 256 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-129-256", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_129_256 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-129-256", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_129_256 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_129_256(self):
    self.__tx_129_256 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-129-256", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_257_512(self):
    """
    Getter method for tx_257_512, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_257_512 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 257 to 512 Bytes.
    """
    return self.__tx_257_512
      
  def _set_tx_257_512(self, v, load=False):
    """
    Setter method for tx_257_512, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_257_512 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_257_512 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_257_512() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 257 to 512 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-257-512", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_257_512 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-257-512", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_257_512 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_257_512(self):
    self.__tx_257_512 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-257-512", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_513_1024(self):
    """
    Getter method for tx_513_1024, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_513_1024 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 513 to 1024 Bytes.
    """
    return self.__tx_513_1024
      
  def _set_tx_513_1024(self, v, load=False):
    """
    Setter method for tx_513_1024, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_513_1024 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_513_1024 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_513_1024() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 513 to 1024 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-513-1024", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_513_1024 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-513-1024", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_513_1024 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_513_1024(self):
    self.__tx_513_1024 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-513-1024", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_1025_2048(self):
    """
    Getter method for tx_1025_2048, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_1025_2048 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 1025 to 2048 Bytes.
    """
    return self.__tx_1025_2048
      
  def _set_tx_1025_2048(self, v, load=False):
    """
    Setter method for tx_1025_2048, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_1025_2048 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_1025_2048 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_1025_2048() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 1025 to 2048 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-1025-2048", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_1025_2048 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-1025-2048", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_1025_2048 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_1025_2048(self):
    self.__tx_1025_2048 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-1025-2048", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_2049_4096(self):
    """
    Getter method for tx_2049_4096, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_2049_4096 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 2049 to 4096 Bytes.
    """
    return self.__tx_2049_4096
      
  def _set_tx_2049_4096(self, v, load=False):
    """
    Setter method for tx_2049_4096, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_2049_4096 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_2049_4096 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_2049_4096() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 2049 to 4096 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-2049-4096", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_2049_4096 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-2049-4096", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_2049_4096 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_2049_4096(self):
    self.__tx_2049_4096 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-2049-4096", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_4097_8192(self):
    """
    Getter method for tx_4097_8192, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_4097_8192 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 4097 to 8192 Bytes.
    """
    return self.__tx_4097_8192
      
  def _set_tx_4097_8192(self, v, load=False):
    """
    Setter method for tx_4097_8192, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_4097_8192 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_4097_8192 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_4097_8192() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 4097 to 8192 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-4097-8192", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_4097_8192 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-4097-8192", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_4097_8192 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_4097_8192(self):
    self.__tx_4097_8192 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-4097-8192", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_8193_16384(self):
    """
    Getter method for tx_8193_16384, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_8193_16384 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 8193 to 16384 Bytes.
    """
    return self.__tx_8193_16384
      
  def _set_tx_8193_16384(self, v, load=False):
    """
    Setter method for tx_8193_16384, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_8193_16384 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_8193_16384 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_8193_16384() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 8193 to 16384 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-8193-16384", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_8193_16384 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-8193-16384", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_8193_16384 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_8193_16384(self):
    self.__tx_8193_16384 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-8193-16384", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_16385_32768(self):
    """
    Getter method for tx_16385_32768, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_16385_32768 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 16385 to 32768 Bytes.
    """
    return self.__tx_16385_32768
      
  def _set_tx_16385_32768(self, v, load=False):
    """
    Setter method for tx_16385_32768, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_16385_32768 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_16385_32768 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_16385_32768() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 16385 to 32768 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-16385-32768", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_16385_32768 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-16385-32768", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_16385_32768 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_16385_32768(self):
    self.__tx_16385_32768 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-16385-32768", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_32769_65536(self):
    """
    Getter method for tx_32769_65536, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_32769_65536 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU or MPDUs from 32769 to 65536 Bytes.
    """
    return self.__tx_32769_65536
      
  def _set_tx_32769_65536(self, v, load=False):
    """
    Setter method for tx_32769_65536, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_32769_65536 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_32769_65536 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_32769_65536() directly.

    YANG Description: Transmitted AMPDU or MPDUs from 32769 to 65536 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-32769-65536", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_32769_65536 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-32769-65536", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_32769_65536 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_32769_65536(self):
    self.__tx_32769_65536 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-32769-65536", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_65537_131072(self):
    """
    Getter method for tx_65537_131072, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_65537_131072 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU from 65537 to 131072 Bytes.
    """
    return self.__tx_65537_131072
      
  def _set_tx_65537_131072(self, v, load=False):
    """
    Setter method for tx_65537_131072, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_65537_131072 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_65537_131072 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_65537_131072() directly.

    YANG Description: Transmitted AMPDU from 65537 to 131072 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-65537-131072", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_65537_131072 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-65537-131072", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_65537_131072 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_65537_131072(self):
    self.__tx_65537_131072 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-65537-131072", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_131073_262144(self):
    """
    Getter method for tx_131073_262144, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_131073_262144 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU from 131073 to 262144 Bytes.
    """
    return self.__tx_131073_262144
      
  def _set_tx_131073_262144(self, v, load=False):
    """
    Setter method for tx_131073_262144, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_131073_262144 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_131073_262144 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_131073_262144() directly.

    YANG Description: Transmitted AMPDU from 131073 to 262144 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-131073-262144", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_131073_262144 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-131073-262144", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_131073_262144 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_131073_262144(self):
    self.__tx_131073_262144 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-131073-262144", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_262145_524288(self):
    """
    Getter method for tx_262145_524288, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_262145_524288 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU from 262145 to 524288 Bytes.
    """
    return self.__tx_262145_524288
      
  def _set_tx_262145_524288(self, v, load=False):
    """
    Setter method for tx_262145_524288, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_262145_524288 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_262145_524288 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_262145_524288() directly.

    YANG Description: Transmitted AMPDU from 262145 to 524288 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-262145-524288", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_262145_524288 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-262145-524288", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_262145_524288 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_262145_524288(self):
    self.__tx_262145_524288 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-262145-524288", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_tx_524289_1048576(self):
    """
    Getter method for tx_524289_1048576, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_524289_1048576 (oc-yang:counter64)

    YANG Description: Transmitted AMPDU from 524289 to 1048576 Bytes.
    """
    return self.__tx_524289_1048576
      
  def _set_tx_524289_1048576(self, v, load=False):
    """
    Setter method for tx_524289_1048576, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_dist/tx_524289_1048576 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_524289_1048576 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_524289_1048576() directly.

    YANG Description: Transmitted AMPDU from 524289 to 1048576 Bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-524289-1048576", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_524289_1048576 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-524289-1048576", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_524289_1048576 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_524289_1048576(self):
    self.__tx_524289_1048576 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-524289-1048576", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

  tx_0_64 = __builtin__.property(_get_tx_0_64)
  tx_65_128 = __builtin__.property(_get_tx_65_128)
  tx_129_256 = __builtin__.property(_get_tx_129_256)
  tx_257_512 = __builtin__.property(_get_tx_257_512)
  tx_513_1024 = __builtin__.property(_get_tx_513_1024)
  tx_1025_2048 = __builtin__.property(_get_tx_1025_2048)
  tx_2049_4096 = __builtin__.property(_get_tx_2049_4096)
  tx_4097_8192 = __builtin__.property(_get_tx_4097_8192)
  tx_8193_16384 = __builtin__.property(_get_tx_8193_16384)
  tx_16385_32768 = __builtin__.property(_get_tx_16385_32768)
  tx_32769_65536 = __builtin__.property(_get_tx_32769_65536)
  tx_65537_131072 = __builtin__.property(_get_tx_65537_131072)
  tx_131073_262144 = __builtin__.property(_get_tx_131073_262144)
  tx_262145_524288 = __builtin__.property(_get_tx_262145_524288)
  tx_524289_1048576 = __builtin__.property(_get_tx_524289_1048576)


  _pyangbind_elements = OrderedDict([('tx_0_64', tx_0_64), ('tx_65_128', tx_65_128), ('tx_129_256', tx_129_256), ('tx_257_512', tx_257_512), ('tx_513_1024', tx_513_1024), ('tx_1025_2048', tx_1025_2048), ('tx_2049_4096', tx_2049_4096), ('tx_4097_8192', tx_4097_8192), ('tx_8193_16384', tx_8193_16384), ('tx_16385_32768', tx_16385_32768), ('tx_32769_65536', tx_32769_65536), ('tx_65537_131072', tx_65537_131072), ('tx_131073_262144', tx_131073_262144), ('tx_262145_524288', tx_262145_524288), ('tx_524289_1048576', tx_524289_1048576), ])


class yc_tx_data_wmm_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_tx_data_wmm(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/bssids/bssid/state/counters/tx-data-wmm. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Transmitted QoS Data frames, per WMM AC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vi','__vo','__bk','__be',)

  _yang_name = 'tx-data-wmm'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vi = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__vo = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__bk = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__be = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="be", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'bssids', 'bssid', 'state', 'counters', 'tx-data-wmm']

  def _get_vi(self):
    """
    Getter method for vi, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_wmm/vi (oc-yang:counter64)

    YANG Description: Tx Data frames marked as Access Category Video.
    """
    return self.__vi
      
  def _set_vi(self, v, load=False):
    """
    Setter method for vi, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_wmm/vi (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vi() directly.

    YANG Description: Tx Data frames marked as Access Category Video.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vi must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__vi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vi(self):
    self.__vi = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_vo(self):
    """
    Getter method for vo, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_wmm/vo (oc-yang:counter64)

    YANG Description: Tx Data frames marked as Access Category Voice.
    """
    return self.__vo
      
  def _set_vo(self, v, load=False):
    """
    Setter method for vo, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_wmm/vo (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vo is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vo() directly.

    YANG Description: Tx Data frames marked as Access Category Voice.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vo must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__vo = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vo(self):
    self.__vo = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="vo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_bk(self):
    """
    Getter method for bk, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_wmm/bk (oc-yang:counter64)

    YANG Description: Tx Data frames marked as Access Category Background.
    """
    return self.__bk
      
  def _set_bk(self, v, load=False):
    """
    Setter method for bk, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_wmm/bk (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bk is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bk() directly.

    YANG Description: Tx Data frames marked as Access Category Background.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bk must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bk = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bk(self):
    self.__bk = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bk", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_be(self):
    """
    Getter method for be, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_wmm/be (oc-yang:counter64)

    YANG Description: Tx Data frames marked as Access Category Best Effort.
    """
    return self.__be
      
  def _set_be(self, v, load=False):
    """
    Setter method for be, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_data_wmm/be (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_be is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_be() directly.

    YANG Description: Tx Data frames marked as Access Category Best Effort.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="be", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """be must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="be", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__be = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_be(self):
    self.__be = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="be", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

  vi = __builtin__.property(_get_vi)
  vo = __builtin__.property(_get_vo)
  bk = __builtin__.property(_get_bk)
  be = __builtin__.property(_get_be)


  _pyangbind_elements = OrderedDict([('vi', vi), ('vo', vo), ('bk', bk), ('be', be), ])


class yc_tx_mcs_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_tx_mcs(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/bssids/bssid/state/counters/tx-mcs. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Transmitted Data frames, per MCS Index. It is expected that
vendors bucketize 802.11n MCS frames in their matching
802.11ac buckets.

Example, 802.11n MCS 15 = 802.11ac MCS 7.
802.11n MCS 20 = 802.11ac MCS 4.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mcs0','__mcs1','__mcs2','__mcs3','__mcs4','__mcs5','__mcs6','__mcs7','__mcs8','__mcs9','__mcs10','__mcs11',)

  _yang_name = 'tx-mcs'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mcs0 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs0", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs1 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs1", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs2 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs3 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs3", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs4 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs5 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs5", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs6 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs7 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs7", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs8 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs8", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs9 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs9", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs10 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs10", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__mcs11 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs11", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'bssids', 'bssid', 'state', 'counters', 'tx-mcs']

  def _get_mcs0(self):
    """
    Getter method for mcs0, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs0 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 0.
    """
    return self.__mcs0
      
  def _set_mcs0(self, v, load=False):
    """
    Setter method for mcs0, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs0 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs0 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs0() directly.

    YANG Description: Tx Data frames at MCS 0.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs0", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs0 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs0", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs0 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs0(self):
    self.__mcs0 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs0", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs1(self):
    """
    Getter method for mcs1, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs1 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 1.
    """
    return self.__mcs1
      
  def _set_mcs1(self, v, load=False):
    """
    Setter method for mcs1, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs1 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs1 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs1() directly.

    YANG Description: Tx Data frames at MCS 1.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs1", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs1 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs1", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs1 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs1(self):
    self.__mcs1 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs1", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs2(self):
    """
    Getter method for mcs2, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs2 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 2.
    """
    return self.__mcs2
      
  def _set_mcs2(self, v, load=False):
    """
    Setter method for mcs2, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs2 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs2 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs2() directly.

    YANG Description: Tx Data frames at MCS 2.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs2 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs2 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs2(self):
    self.__mcs2 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs3(self):
    """
    Getter method for mcs3, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs3 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 3.
    """
    return self.__mcs3
      
  def _set_mcs3(self, v, load=False):
    """
    Setter method for mcs3, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs3 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs3 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs3() directly.

    YANG Description: Tx Data frames at MCS 3.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs3", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs3 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs3", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs3 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs3(self):
    self.__mcs3 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs3", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs4(self):
    """
    Getter method for mcs4, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs4 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 4.
    """
    return self.__mcs4
      
  def _set_mcs4(self, v, load=False):
    """
    Setter method for mcs4, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs4 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs4() directly.

    YANG Description: Tx Data frames at MCS 4.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs4 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs4(self):
    self.__mcs4 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs5(self):
    """
    Getter method for mcs5, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs5 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 5.
    """
    return self.__mcs5
      
  def _set_mcs5(self, v, load=False):
    """
    Setter method for mcs5, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs5 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs5 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs5() directly.

    YANG Description: Tx Data frames at MCS 5.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs5", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs5 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs5", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs5 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs5(self):
    self.__mcs5 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs5", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs6(self):
    """
    Getter method for mcs6, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs6 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 6.
    """
    return self.__mcs6
      
  def _set_mcs6(self, v, load=False):
    """
    Setter method for mcs6, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs6 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs6() directly.

    YANG Description: Tx Data frames at MCS 6.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs6 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs6(self):
    self.__mcs6 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs7(self):
    """
    Getter method for mcs7, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs7 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 7.
    """
    return self.__mcs7
      
  def _set_mcs7(self, v, load=False):
    """
    Setter method for mcs7, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs7 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs7 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs7() directly.

    YANG Description: Tx Data frames at MCS 7.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs7", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs7 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs7", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs7 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs7(self):
    self.__mcs7 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs7", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs8(self):
    """
    Getter method for mcs8, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs8 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 8.
    """
    return self.__mcs8
      
  def _set_mcs8(self, v, load=False):
    """
    Setter method for mcs8, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs8 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs8 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs8() directly.

    YANG Description: Tx Data frames at MCS 8.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs8", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs8 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs8", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs8 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs8(self):
    self.__mcs8 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs8", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs9(self):
    """
    Getter method for mcs9, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs9 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 9.
    """
    return self.__mcs9
      
  def _set_mcs9(self, v, load=False):
    """
    Setter method for mcs9, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs9 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs9 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs9() directly.

    YANG Description: Tx Data frames at MCS 9.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs9", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs9 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs9", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs9 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs9(self):
    self.__mcs9 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs9", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs10(self):
    """
    Getter method for mcs10, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs10 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 10.
    """
    return self.__mcs10
      
  def _set_mcs10(self, v, load=False):
    """
    Setter method for mcs10, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs10 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs10 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs10() directly.

    YANG Description: Tx Data frames at MCS 10.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs10", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs10 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs10", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs10 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs10(self):
    self.__mcs10 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs10", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_mcs11(self):
    """
    Getter method for mcs11, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs11 (oc-yang:counter64)

    YANG Description: Tx Data frames at MCS 11.
    """
    return self.__mcs11
      
  def _set_mcs11(self, v, load=False):
    """
    Setter method for mcs11, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/tx_mcs/mcs11 (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mcs11 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mcs11() directly.

    YANG Description: Tx Data frames at MCS 11.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs11", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mcs11 must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs11", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__mcs11 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mcs11(self):
    self.__mcs11 = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="mcs11", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)

  mcs0 = __builtin__.property(_get_mcs0)
  mcs1 = __builtin__.property(_get_mcs1)
  mcs2 = __builtin__.property(_get_mcs2)
  mcs3 = __builtin__.property(_get_mcs3)
  mcs4 = __builtin__.property(_get_mcs4)
  mcs5 = __builtin__.property(_get_mcs5)
  mcs6 = __builtin__.property(_get_mcs6)
  mcs7 = __builtin__.property(_get_mcs7)
  mcs8 = __builtin__.property(_get_mcs8)
  mcs9 = __builtin__.property(_get_mcs9)
  mcs10 = __builtin__.property(_get_mcs10)
  mcs11 = __builtin__.property(_get_mcs11)


  _pyangbind_elements = OrderedDict([('mcs0', mcs0), ('mcs1', mcs1), ('mcs2', mcs2), ('mcs3', mcs3), ('mcs4', mcs4), ('mcs5', mcs5), ('mcs6', mcs6), ('mcs7', mcs7), ('mcs8', mcs8), ('mcs9', mcs9), ('mcs10', mcs10), ('mcs11', mcs11), ])


class yc_counters_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-access-points - based on the path /access-points/access-point/ssids/ssid/bssids/bssid/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: BSS Counters.
  """
  __slots__ = ('_path_helper', '_extmethods', '__rx_bss_dot11_channel_utilization','__rx_mgmt','__rx_control','__rx_data_dist','__rx_data_wmm','__rx_mcs','__rx_retries','__rx_total_frames','__rx_retries_data','__rx_total_data','__rx_retries_subframe','__rx_total_subframe','__rx_bytes_data','__tx_bss_dot11_channel_utilization','__tx_mgmt','__tx_control','__tx_data_dist','__tx_data_wmm','__tx_mcs','__tx_retries','__tx_total_frames','__tx_retries_data','__tx_total_data','__tx_retries_subframe','__tx_total_subframe','__tx_bytes_data','__bss_channel_utilization',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/wifi/access-points'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__rx_bss_dot11_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-bss-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    self.__rx_mgmt = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-mgmt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_control = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-control", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_data_dist = YANGDynClass(base=yc_rx_data_dist_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_rx_data_dist, is_container='container', yang_name="rx-data-dist", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)
    self.__rx_data_wmm = YANGDynClass(base=yc_rx_data_wmm_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_rx_data_wmm, is_container='container', yang_name="rx-data-wmm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)
    self.__rx_mcs = YANGDynClass(base=yc_rx_mcs_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_rx_mcs, is_container='container', yang_name="rx-mcs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)
    self.__rx_retries = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-retries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_total_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-total-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_retries_data = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-retries-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_total_data = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-total-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_retries_subframe = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-retries-subframe", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_total_subframe = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-total-subframe", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_bytes_data = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-bytes-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_bss_dot11_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="tx-bss-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    self.__tx_mgmt = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-mgmt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_control = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-control", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_data_dist = YANGDynClass(base=yc_tx_data_dist_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_tx_data_dist, is_container='container', yang_name="tx-data-dist", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)
    self.__tx_data_wmm = YANGDynClass(base=yc_tx_data_wmm_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_tx_data_wmm, is_container='container', yang_name="tx-data-wmm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)
    self.__tx_mcs = YANGDynClass(base=yc_tx_mcs_openconfig_access_points__access_points_access_point_ssids_ssid_bssids_bssid_state_counters_tx_mcs, is_container='container', yang_name="tx-mcs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='container', is_config=False)
    self.__tx_retries = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-retries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_total_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-total-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_retries_data = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-retries-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_total_data = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-total-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_retries_subframe = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-retries-subframe", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_total_subframe = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-total-subframe", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__tx_bytes_data = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-bytes-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    self.__bss_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="bss-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['access-points', 'access-point', 'ssids', 'ssid', 'bssids', 'bssid', 'state', 'counters']

  def _get_rx_bss_dot11_channel_utilization(self):
    """
    Getter method for rx_bss_dot11_channel_utilization, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_bss_dot11_channel_utilization (oc-types:percentage)

    YANG Description: receive channel utilization percent caused by reception of
any 802.11 frame within this BSS.
    """
    return self.__rx_bss_dot11_channel_utilization
      
  def _set_rx_bss_dot11_channel_utilization(self, v, load=False):
    """
    Setter method for rx_bss_dot11_channel_utilization, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_bss_dot11_channel_utilization (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_bss_dot11_channel_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_bss_dot11_channel_utilization() directly.

    YANG Description: receive channel utilization percent caused by reception of
any 802.11 frame within this BSS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-bss-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_bss_dot11_channel_utilization must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-bss-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__rx_bss_dot11_channel_utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_bss_dot11_channel_utilization(self):
    self.__rx_bss_dot11_channel_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="rx-bss-dot11-channel-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-types:percentage', is_config=False)


  def _get_rx_mgmt(self):
    """
    Getter method for rx_mgmt, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mgmt (oc-yang:counter64)

    YANG Description: Received 802.11 Management frames.
    """
    return self.__rx_mgmt
      
  def _set_rx_mgmt(self, v, load=False):
    """
    Setter method for rx_mgmt, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_mgmt (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_mgmt is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_mgmt() directly.

    YANG Description: Received 802.11 Management frames.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-mgmt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_mgmt must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-mgmt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_mgmt = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_mgmt(self):
    self.__rx_mgmt = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-mgmt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_control(self):
    """
    Getter method for rx_control, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_control (oc-yang:counter64)

    YANG Description: Received 802.11 Control frames.
    """
    return self.__rx_control
      
  def _set_rx_control(self, v, load=False):
    """
    Setter method for rx_control, mapped from YANG variable /access_points/access_point/ssids/ssid/bssids/bssid/state/counters/rx_control (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_control is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_control() directly.

    YANG Description: Received 802.11 Control frames.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-control", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/wifi/access-points', defining_module='openconfig-access-points', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_control must be of a type compatible with oc-yang:counter64