// Copyright 2019 Google LLC. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package storage

import "github.com/google/trillian/merkle/compact"

// Node represents a Merkle tree node.
type Node struct {
	ID   compact.NodeID
	Hash []byte
}

// Entry represents a single log entry, which is also a Merkle tree leaf.
type Entry struct {
	// Data holds the data that the log commits to.
	Data []byte
	// Extra holds data that is attached to the entry, but not committed to by
	// the log, i.e. not accounted for when calculating Merkle tree hashes.
	Extra []byte
	// Hash is the Merkle tree leaf hash of the log entry Data.
	Hash []byte
}
