package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ShowVulnerabilityResponse Response Object
type ShowVulnerabilityResponse struct {

	// 错误码
	Code *string `json:"code,omitempty"`

	// 错误信息
	Message *string `json:"message,omitempty"`

	Data           *VulnerabilityDetail `json:"data,omitempty"`
	HttpStatusCode int                  `json:"-"`
}

func (o ShowVulnerabilityResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ShowVulnerabilityResponse struct{}"
	}

	return strings.Join([]string{"ShowVulnerabilityResponse", string(data)}, " ")
}
