// DO NOT EDIT: This file is autogenerated via the builtin command.

package rows

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   102,
				},
				File:   "map_drop_value_test.flux",
				Source: "package rows_test\n\n\nimport \"testing\"\nimport \"contrib/jsternberg/rows\"\n\noption now = () => 2020-08-02T17:24:00Z\n\ninData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"\noutData = \"\n#datatype,string,long,string,string,string,double\n#group,false,false,true,true,true,false\n#default,,,,,,\n,result,table,_measurement,_field,t0,_value\n,,0,m0,f0,a-0,43.09452210525144\n,,0,m0,f0,a-0,-30.353812994348537\n,,0,m0,f0,a-0,19.17028701626966\n,,0,m0,f0,a-0,31.713408760790323\n,,0,m0,f0,a-0,16.22173130975937\n,,0,m0,f0,a-0,-14.631305556841284\n,,0,m0,f0,a-0,-85.5542463240766\n,,0,m0,f0,a-0,77.18220390886191\n,,0,m0,f0,a-0,-50.062559688977814\n,,0,m0,f0,a-0,-22.17256401464515\n,,0,m0,f0,a-0,112.47430195827386\n,,0,m0,f0,a-0,-16.85801752656638\n,,1,m0,f0,a-1,28.65256634110021\n,,1,m0,f0,a-1,11.021368187315897\n,,1,m0,f0,a-1,-18.04898637542153\n,,1,m0,f0,a-1,-24.555312299824035\n,,1,m0,f0,a-1,-5.543823619638458\n,,1,m0,f0,a-1,64.34272303286494\n,,1,m0,f0,a-1,54.40142609111467\n,,1,m0,f0,a-1,6.68919215397088\n,,1,m0,f0,a-1,36.36364746675186\n,,1,m0,f0,a-1,31.041492590916768\n,,1,m0,f0,a-1,8.461569912796826\n,,1,m0,f0,a-1,-9.025669280720571\n,,2,m0,f0,a-2,8.640246126337203\n,,2,m0,f0,a-2,43.365488430173706\n,,2,m0,f0,a-2,25.198611516637676\n,,2,m0,f0,a-2,-16.593516600485213\n,,2,m0,f0,a-2,76.42451523676915\n,,2,m0,f0,a-2,67.78699694188528\n,,2,m0,f0,a-2,-14.77477027658923\n,,2,m0,f0,a-2,-28.521034402304263\n,,2,m0,f0,a-2,53.47644712761566\n,,2,m0,f0,a-2,-83.38193426782863\n,,2,m0,f0,a-2,92.49751968643372\n,,2,m0,f0,a-2,-2.187536871928522\n\"\nt_map = (table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({_value: -r._value}))\n\ntest _map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "map_drop_value_test.flux",
						Source: "now = () => 2020-08-02T17:24:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "map_drop_value_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "map_drop_value_test.flux",
							Source: "() => 2020-08-02T17:24:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "map_drop_value_test.flux",
								Source: "2020-08-02T17:24:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2020-08-02T17:24:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "map_drop_value_test.flux",
					Source: "option now = () => 2020-08-02T17:24:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "map_drop_value_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "map_drop_value_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "map_drop_value_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   92,
					},
					File:   "map_drop_value_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,string,double\n#group,false,false,true,true,true,false\n#default,,,,,,\n,result,table,_measurement,_field,t0,_value\n,,0,m0,f0,a-0,43.09452210525144\n,,0,m0,f0,a-0,-30.353812994348537\n,,0,m0,f0,a-0,19.17028701626966\n,,0,m0,f0,a-0,31.713408760790323\n,,0,m0,f0,a-0,16.22173130975937\n,,0,m0,f0,a-0,-14.631305556841284\n,,0,m0,f0,a-0,-85.5542463240766\n,,0,m0,f0,a-0,77.18220390886191\n,,0,m0,f0,a-0,-50.062559688977814\n,,0,m0,f0,a-0,-22.17256401464515\n,,0,m0,f0,a-0,112.47430195827386\n,,0,m0,f0,a-0,-16.85801752656638\n,,1,m0,f0,a-1,28.65256634110021\n,,1,m0,f0,a-1,11.021368187315897\n,,1,m0,f0,a-1,-18.04898637542153\n,,1,m0,f0,a-1,-24.555312299824035\n,,1,m0,f0,a-1,-5.543823619638458\n,,1,m0,f0,a-1,64.34272303286494\n,,1,m0,f0,a-1,54.40142609111467\n,,1,m0,f0,a-1,6.68919215397088\n,,1,m0,f0,a-1,36.36364746675186\n,,1,m0,f0,a-1,31.041492590916768\n,,1,m0,f0,a-1,8.461569912796826\n,,1,m0,f0,a-1,-9.025669280720571\n,,2,m0,f0,a-2,8.640246126337203\n,,2,m0,f0,a-2,43.365488430173706\n,,2,m0,f0,a-2,25.198611516637676\n,,2,m0,f0,a-2,-16.593516600485213\n,,2,m0,f0,a-2,76.42451523676915\n,,2,m0,f0,a-2,67.78699694188528\n,,2,m0,f0,a-2,-14.77477027658923\n,,2,m0,f0,a-2,-28.521034402304263\n,,2,m0,f0,a-2,53.47644712761566\n,,2,m0,f0,a-2,-83.38193426782863\n,,2,m0,f0,a-2,92.49751968643372\n,,2,m0,f0,a-2,-2.187536871928522\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   51,
						},
						File:   "map_drop_value_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   92,
						},
						File:   "map_drop_value_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,double\n#group,false,false,true,true,true,false\n#default,,,,,,\n,result,table,_measurement,_field,t0,_value\n,,0,m0,f0,a-0,43.09452210525144\n,,0,m0,f0,a-0,-30.353812994348537\n,,0,m0,f0,a-0,19.17028701626966\n,,0,m0,f0,a-0,31.713408760790323\n,,0,m0,f0,a-0,16.22173130975937\n,,0,m0,f0,a-0,-14.631305556841284\n,,0,m0,f0,a-0,-85.5542463240766\n,,0,m0,f0,a-0,77.18220390886191\n,,0,m0,f0,a-0,-50.062559688977814\n,,0,m0,f0,a-0,-22.17256401464515\n,,0,m0,f0,a-0,112.47430195827386\n,,0,m0,f0,a-0,-16.85801752656638\n,,1,m0,f0,a-1,28.65256634110021\n,,1,m0,f0,a-1,11.021368187315897\n,,1,m0,f0,a-1,-18.04898637542153\n,,1,m0,f0,a-1,-24.555312299824035\n,,1,m0,f0,a-1,-5.543823619638458\n,,1,m0,f0,a-1,64.34272303286494\n,,1,m0,f0,a-1,54.40142609111467\n,,1,m0,f0,a-1,6.68919215397088\n,,1,m0,f0,a-1,36.36364746675186\n,,1,m0,f0,a-1,31.041492590916768\n,,1,m0,f0,a-1,8.461569912796826\n,,1,m0,f0,a-1,-9.025669280720571\n,,2,m0,f0,a-2,8.640246126337203\n,,2,m0,f0,a-2,43.365488430173706\n,,2,m0,f0,a-2,25.198611516637676\n,,2,m0,f0,a-2,-16.593516600485213\n,,2,m0,f0,a-2,76.42451523676915\n,,2,m0,f0,a-2,67.78699694188528\n,,2,m0,f0,a-2,-14.77477027658923\n,,2,m0,f0,a-2,-28.521034402304263\n,,2,m0,f0,a-2,53.47644712761566\n,,2,m0,f0,a-2,-83.38193426782863\n,,2,m0,f0,a-2,92.49751968643372\n,,2,m0,f0,a-2,-2.187536871928522\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   51,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,double\n#group,false,false,true,true,true,false\n#default,,,,,,\n,result,table,_measurement,_field,t0,_value\n,,0,m0,f0,a-0,43.09452210525144\n,,0,m0,f0,a-0,-30.353812994348537\n,,0,m0,f0,a-0,19.17028701626966\n,,0,m0,f0,a-0,31.713408760790323\n,,0,m0,f0,a-0,16.22173130975937\n,,0,m0,f0,a-0,-14.631305556841284\n,,0,m0,f0,a-0,-85.5542463240766\n,,0,m0,f0,a-0,77.18220390886191\n,,0,m0,f0,a-0,-50.062559688977814\n,,0,m0,f0,a-0,-22.17256401464515\n,,0,m0,f0,a-0,112.47430195827386\n,,0,m0,f0,a-0,-16.85801752656638\n,,1,m0,f0,a-1,28.65256634110021\n,,1,m0,f0,a-1,11.021368187315897\n,,1,m0,f0,a-1,-18.04898637542153\n,,1,m0,f0,a-1,-24.555312299824035\n,,1,m0,f0,a-1,-5.543823619638458\n,,1,m0,f0,a-1,64.34272303286494\n,,1,m0,f0,a-1,54.40142609111467\n,,1,m0,f0,a-1,6.68919215397088\n,,1,m0,f0,a-1,36.36364746675186\n,,1,m0,f0,a-1,31.041492590916768\n,,1,m0,f0,a-1,8.461569912796826\n,,1,m0,f0,a-1,-9.025669280720571\n,,2,m0,f0,a-2,8.640246126337203\n,,2,m0,f0,a-2,43.365488430173706\n,,2,m0,f0,a-2,25.198611516637676\n,,2,m0,f0,a-2,-16.593516600485213\n,,2,m0,f0,a-2,76.42451523676915\n,,2,m0,f0,a-2,67.78699694188528\n,,2,m0,f0,a-2,-14.77477027658923\n,,2,m0,f0,a-2,-28.521034402304263\n,,2,m0,f0,a-2,53.47644712761566\n,,2,m0,f0,a-2,-83.38193426782863\n,,2,m0,f0,a-2,92.49751968643372\n,,2,m0,f0,a-2,-2.187536871928522\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 50,
						Line:   96,
					},
					File:   "map_drop_value_test.flux",
					Source: "t_map = (table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({_value: -r._value}))",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   93,
						},
						File:   "map_drop_value_test.flux",
						Source: "t_map",
						Start: ast.Position{
							Column: 1,
							Line:   93,
						},
					},
				},
				Name: "t_map",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   96,
						},
						File:   "map_drop_value_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({_value: -r._value}))",
						Start: ast.Position{
							Column: 9,
							Line:   93,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   93,
										},
										File:   "map_drop_value_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 23,
											Line:   93,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   94,
									},
									File:   "map_drop_value_test.flux",
									Source: "table\n    |> range(start: -2m)",
									Start: ast.Position{
										Column: 23,
										Line:   93,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   94,
											},
											File:   "map_drop_value_test.flux",
											Source: "start: -2m",
											Start: ast.Position{
												Column: 14,
												Line:   94,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   94,
												},
												File:   "map_drop_value_test.flux",
												Source: "start: -2m",
												Start: ast.Position{
													Column: 14,
													Line:   94,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   94,
													},
													File:   "map_drop_value_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   94,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.UnaryExpression{
											Argument: &ast.DurationLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   94,
														},
														File:   "map_drop_value_test.flux",
														Source: "2m",
														Start: ast.Position{
															Column: 22,
															Line:   94,
														},
													},
												},
												Values: []ast.Duration{ast.Duration{
													Magnitude: int64(2),
													Unit:      "m",
												}},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   94,
													},
													File:   "map_drop_value_test.flux",
													Source: "-2m",
													Start: ast.Position{
														Column: 21,
														Line:   94,
													},
												},
											},
											Operator: 6,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   94,
										},
										File:   "map_drop_value_test.flux",
										Source: "range(start: -2m)",
										Start: ast.Position{
											Column: 8,
											Line:   94,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   94,
											},
											File:   "map_drop_value_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   94,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   95,
								},
								File:   "map_drop_value_test.flux",
								Source: "table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 23,
									Line:   93,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   95,
										},
										File:   "map_drop_value_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   95,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   95,
											},
											File:   "map_drop_value_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 13,
												Line:   95,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   95,
												},
												File:   "map_drop_value_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   95,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   95,
												},
												File:   "map_drop_value_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 22,
													Line:   95,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   95,
													},
													File:   "map_drop_value_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   95,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   95,
													},
													File:   "map_drop_value_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   95,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   95,
									},
									File:   "map_drop_value_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 8,
										Line:   95,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   95,
										},
										File:   "map_drop_value_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   95,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   96,
							},
							File:   "map_drop_value_test.flux",
							Source: "table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({_value: -r._value}))",
							Start: ast.Position{
								Column: 23,
								Line:   93,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   96,
									},
									File:   "map_drop_value_test.flux",
									Source: "fn: (r) => ({_value: -r._value})",
									Start: ast.Position{
										Column: 17,
										Line:   96,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   96,
										},
										File:   "map_drop_value_test.flux",
										Source: "fn: (r) => ({_value: -r._value})",
										Start: ast.Position{
											Column: 17,
											Line:   96,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   96,
											},
											File:   "map_drop_value_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 17,
												Line:   96,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   96,
											},
											File:   "map_drop_value_test.flux",
											Source: "(r) => ({_value: -r._value})",
											Start: ast.Position{
												Column: 21,
												Line:   96,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   96,
												},
												File:   "map_drop_value_test.flux",
												Source: "({_value: -r._value})",
												Start: ast.Position{
													Column: 28,
													Line:   96,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   96,
													},
													File:   "map_drop_value_test.flux",
													Source: "{_value: -r._value}",
													Start: ast.Position{
														Column: 29,
														Line:   96,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   96,
														},
														File:   "map_drop_value_test.flux",
														Source: "_value: -r._value",
														Start: ast.Position{
															Column: 30,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   96,
															},
															File:   "map_drop_value_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 30,
																Line:   96,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.UnaryExpression{
													Argument: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   96,
																},
																File:   "map_drop_value_test.flux",
																Source: "r._value",
																Start: ast.Position{
																	Column: 39,
																	Line:   96,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   96,
																	},
																	File:   "map_drop_value_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 39,
																		Line:   96,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   96,
																	},
																	File:   "map_drop_value_test.flux",
																	Source: "_value",
																	Start: ast.Position{
																		Column: 41,
																		Line:   96,
																	},
																},
															},
															Name: "_value",
														},
														Rbrack: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   96,
															},
															File:   "map_drop_value_test.flux",
															Source: "-r._value",
															Start: ast.Position{
																Column: 38,
																Line:   96,
															},
														},
													},
													Operator: 6,
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   96,
												},
												File:   "map_drop_value_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 22,
													Line:   96,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   96,
													},
													File:   "map_drop_value_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 22,
														Line:   96,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   96,
								},
								File:   "map_drop_value_test.flux",
								Source: "rows.map(fn: (r) => ({_value: -r._value}))",
								Start: ast.Position{
									Column: 8,
									Line:   96,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   96,
									},
									File:   "map_drop_value_test.flux",
									Source: "rows.map",
									Start: ast.Position{
										Column: 8,
										Line:   96,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   96,
										},
										File:   "map_drop_value_test.flux",
										Source: "rows",
										Start: ast.Position{
											Column: 8,
											Line:   96,
										},
									},
								},
								Name: "rows",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   96,
										},
										File:   "map_drop_value_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 13,
											Line:   96,
										},
									},
								},
								Name: "map",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   93,
							},
							File:   "map_drop_value_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   93,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   93,
								},
								File:   "map_drop_value_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   93,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   93,
							},
							File:   "map_drop_value_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   93,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   102,
						},
						File:   "map_drop_value_test.flux",
						Source: "_map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   98,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   98,
							},
							File:   "map_drop_value_test.flux",
							Source: "_map",
							Start: ast.Position{
								Column: 6,
								Line:   98,
							},
						},
					},
					Name: "_map",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   102,
							},
							File:   "map_drop_value_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
							Start: ast.Position{
								Column: 13,
								Line:   98,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   102,
								},
								File:   "map_drop_value_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
								Start: ast.Position{
									Column: 19,
									Line:   98,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   102,
									},
									File:   "map_drop_value_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n}",
									Start: ast.Position{
										Column: 20,
										Line:   98,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   99,
										},
										File:   "map_drop_value_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   99,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   99,
											},
											File:   "map_drop_value_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   99,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   99,
												},
												File:   "map_drop_value_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   99,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   99,
													},
													File:   "map_drop_value_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   99,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   99,
														},
														File:   "map_drop_value_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   99,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   99,
														},
														File:   "map_drop_value_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   99,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   99,
											},
											File:   "map_drop_value_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   99,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   99,
												},
												File:   "map_drop_value_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   99,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   99,
													},
													File:   "map_drop_value_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   99,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   99,
													},
													File:   "map_drop_value_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   99,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   100,
										},
										File:   "map_drop_value_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   100,
											},
											File:   "map_drop_value_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   100,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   100,
												},
												File:   "map_drop_value_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   100,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   100,
													},
													File:   "map_drop_value_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   100,
														},
														File:   "map_drop_value_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   100,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   100,
														},
														File:   "map_drop_value_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   100,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   100,
											},
											File:   "map_drop_value_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   100,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   100,
												},
												File:   "map_drop_value_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   100,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   100,
													},
													File:   "map_drop_value_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   100,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   100,
													},
													File:   "map_drop_value_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   100,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   101,
										},
										File:   "map_drop_value_test.flux",
										Source: "fn: t_map",
										Start: ast.Position{
											Column: 5,
											Line:   101,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   101,
											},
											File:   "map_drop_value_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   101,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   101,
											},
											File:   "map_drop_value_test.flux",
											Source: "t_map",
											Start: ast.Position{
												Column: 9,
												Line:   101,
											},
										},
									},
									Name: "t_map",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   102,
					},
					File:   "map_drop_value_test.flux",
					Source: "test _map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   98,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "map_drop_value_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "map_drop_value_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   5,
					},
					File:   "map_drop_value_test.flux",
					Source: "import \"contrib/jsternberg/rows\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   5,
						},
						File:   "map_drop_value_test.flux",
						Source: "\"contrib/jsternberg/rows\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "contrib/jsternberg/rows",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "map_drop_value_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "map_drop_value_test.flux",
					Source: "package rows_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "map_drop_value_test.flux",
						Source: "rows_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "rows_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   102,
				},
				File:   "map_override_type_test.flux",
				Source: "package rows_test\n\n\nimport \"testing\"\nimport \"contrib/jsternberg/rows\"\n\noption now = () => 2020-08-02T17:24:00Z\n\ninData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"\noutData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2\n\"\nt_map = (table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({r with _value: int(v: r._value)}))\n\ntest _map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "map_override_type_test.flux",
						Source: "now = () => 2020-08-02T17:24:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "map_override_type_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "map_override_type_test.flux",
							Source: "() => 2020-08-02T17:24:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "map_override_type_test.flux",
								Source: "2020-08-02T17:24:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2020-08-02T17:24:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "map_override_type_test.flux",
					Source: "option now = () => 2020-08-02T17:24:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "map_override_type_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "map_override_type_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "map_override_type_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   92,
					},
					File:   "map_override_type_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   51,
						},
						File:   "map_override_type_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   92,
						},
						File:   "map_override_type_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   51,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 64,
						Line:   96,
					},
					File:   "map_override_type_test.flux",
					Source: "t_map = (table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({r with _value: int(v: r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   93,
						},
						File:   "map_override_type_test.flux",
						Source: "t_map",
						Start: ast.Position{
							Column: 1,
							Line:   93,
						},
					},
				},
				Name: "t_map",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 64,
							Line:   96,
						},
						File:   "map_override_type_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({r with _value: int(v: r._value)}))",
						Start: ast.Position{
							Column: 9,
							Line:   93,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   93,
										},
										File:   "map_override_type_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 23,
											Line:   93,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   94,
									},
									File:   "map_override_type_test.flux",
									Source: "table\n    |> range(start: -2m)",
									Start: ast.Position{
										Column: 23,
										Line:   93,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   94,
											},
											File:   "map_override_type_test.flux",
											Source: "start: -2m",
											Start: ast.Position{
												Column: 14,
												Line:   94,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   94,
												},
												File:   "map_override_type_test.flux",
												Source: "start: -2m",
												Start: ast.Position{
													Column: 14,
													Line:   94,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   94,
													},
													File:   "map_override_type_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   94,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.UnaryExpression{
											Argument: &ast.DurationLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   94,
														},
														File:   "map_override_type_test.flux",
														Source: "2m",
														Start: ast.Position{
															Column: 22,
															Line:   94,
														},
													},
												},
												Values: []ast.Duration{ast.Duration{
													Magnitude: int64(2),
													Unit:      "m",
												}},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   94,
													},
													File:   "map_override_type_test.flux",
													Source: "-2m",
													Start: ast.Position{
														Column: 21,
														Line:   94,
													},
												},
											},
											Operator: 6,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   94,
										},
										File:   "map_override_type_test.flux",
										Source: "range(start: -2m)",
										Start: ast.Position{
											Column: 8,
											Line:   94,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   94,
											},
											File:   "map_override_type_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   94,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   95,
								},
								File:   "map_override_type_test.flux",
								Source: "table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 23,
									Line:   93,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   95,
										},
										File:   "map_override_type_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   95,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   95,
											},
											File:   "map_override_type_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 13,
												Line:   95,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   95,
												},
												File:   "map_override_type_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   95,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   95,
												},
												File:   "map_override_type_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 22,
													Line:   95,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   95,
													},
													File:   "map_override_type_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   95,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   95,
													},
													File:   "map_override_type_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   95,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   95,
									},
									File:   "map_override_type_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 8,
										Line:   95,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   95,
										},
										File:   "map_override_type_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   95,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   96,
							},
							File:   "map_override_type_test.flux",
							Source: "table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({r with _value: int(v: r._value)}))",
							Start: ast.Position{
								Column: 23,
								Line:   93,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   96,
									},
									File:   "map_override_type_test.flux",
									Source: "fn: (r) => ({r with _value: int(v: r._value)})",
									Start: ast.Position{
										Column: 17,
										Line:   96,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   96,
										},
										File:   "map_override_type_test.flux",
										Source: "fn: (r) => ({r with _value: int(v: r._value)})",
										Start: ast.Position{
											Column: 17,
											Line:   96,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   96,
											},
											File:   "map_override_type_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 17,
												Line:   96,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   96,
											},
											File:   "map_override_type_test.flux",
											Source: "(r) => ({r with _value: int(v: r._value)})",
											Start: ast.Position{
												Column: 21,
												Line:   96,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   96,
												},
												File:   "map_override_type_test.flux",
												Source: "({r with _value: int(v: r._value)})",
												Start: ast.Position{
													Column: 28,
													Line:   96,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   96,
													},
													File:   "map_override_type_test.flux",
													Source: "{r with _value: int(v: r._value)}",
													Start: ast.Position{
														Column: 29,
														Line:   96,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   96,
														},
														File:   "map_override_type_test.flux",
														Source: "_value: int(v: r._value)",
														Start: ast.Position{
															Column: 37,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   96,
															},
															File:   "map_override_type_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 37,
																Line:   96,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   96,
																},
																File:   "map_override_type_test.flux",
																Source: "v: r._value",
																Start: ast.Position{
																	Column: 49,
																	Line:   96,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   96,
																	},
																	File:   "map_override_type_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 49,
																		Line:   96,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   96,
																		},
																		File:   "map_override_type_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 49,
																			Line:   96,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   96,
																		},
																		File:   "map_override_type_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 52,
																			Line:   96,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 53,
																				Line:   96,
																			},
																			File:   "map_override_type_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 52,
																				Line:   96,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   96,
																			},
																			File:   "map_override_type_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 54,
																				Line:   96,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   96,
															},
															File:   "map_override_type_test.flux",
															Source: "int(v: r._value)",
															Start: ast.Position{
																Column: 45,
																Line:   96,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   96,
																},
																File:   "map_override_type_test.flux",
																Source: "int",
																Start: ast.Position{
																	Column: 45,
																	Line:   96,
																},
															},
														},
														Name: "int",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   96,
														},
														File:   "map_override_type_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 30,
															Line:   96,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   96,
												},
												File:   "map_override_type_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 22,
													Line:   96,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   96,
													},
													File:   "map_override_type_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 22,
														Line:   96,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   96,
								},
								File:   "map_override_type_test.flux",
								Source: "rows.map(fn: (r) => ({r with _value: int(v: r._value)}))",
								Start: ast.Position{
									Column: 8,
									Line:   96,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   96,
									},
									File:   "map_override_type_test.flux",
									Source: "rows.map",
									Start: ast.Position{
										Column: 8,
										Line:   96,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   96,
										},
										File:   "map_override_type_test.flux",
										Source: "rows",
										Start: ast.Position{
											Column: 8,
											Line:   96,
										},
									},
								},
								Name: "rows",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   96,
										},
										File:   "map_override_type_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 13,
											Line:   96,
										},
									},
								},
								Name: "map",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   93,
							},
							File:   "map_override_type_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   93,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   93,
								},
								File:   "map_override_type_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   93,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   93,
							},
							File:   "map_override_type_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   93,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   102,
						},
						File:   "map_override_type_test.flux",
						Source: "_map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   98,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   98,
							},
							File:   "map_override_type_test.flux",
							Source: "_map",
							Start: ast.Position{
								Column: 6,
								Line:   98,
							},
						},
					},
					Name: "_map",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   102,
							},
							File:   "map_override_type_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
							Start: ast.Position{
								Column: 13,
								Line:   98,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   102,
								},
								File:   "map_override_type_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
								Start: ast.Position{
									Column: 19,
									Line:   98,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   102,
									},
									File:   "map_override_type_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n}",
									Start: ast.Position{
										Column: 20,
										Line:   98,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   99,
										},
										File:   "map_override_type_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   99,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   99,
											},
											File:   "map_override_type_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   99,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   99,
												},
												File:   "map_override_type_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   99,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   99,
													},
													File:   "map_override_type_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   99,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   99,
														},
														File:   "map_override_type_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   99,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   99,
														},
														File:   "map_override_type_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   99,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   99,
											},
											File:   "map_override_type_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   99,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   99,
												},
												File:   "map_override_type_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   99,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   99,
													},
													File:   "map_override_type_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   99,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   99,
													},
													File:   "map_override_type_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   99,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   100,
										},
										File:   "map_override_type_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   100,
											},
											File:   "map_override_type_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   100,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   100,
												},
												File:   "map_override_type_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   100,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   100,
													},
													File:   "map_override_type_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   100,
														},
														File:   "map_override_type_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   100,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   100,
														},
														File:   "map_override_type_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   100,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   100,
											},
											File:   "map_override_type_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   100,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   100,
												},
												File:   "map_override_type_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   100,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   100,
													},
													File:   "map_override_type_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   100,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   100,
													},
													File:   "map_override_type_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   100,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   101,
										},
										File:   "map_override_type_test.flux",
										Source: "fn: t_map",
										Start: ast.Position{
											Column: 5,
											Line:   101,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   101,
											},
											File:   "map_override_type_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   101,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   101,
											},
											File:   "map_override_type_test.flux",
											Source: "t_map",
											Start: ast.Position{
												Column: 9,
												Line:   101,
											},
										},
									},
									Name: "t_map",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   102,
					},
					File:   "map_override_type_test.flux",
					Source: "test _map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   98,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "map_override_type_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "map_override_type_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   5,
					},
					File:   "map_override_type_test.flux",
					Source: "import \"contrib/jsternberg/rows\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   5,
						},
						File:   "map_override_type_test.flux",
						Source: "\"contrib/jsternberg/rows\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "contrib/jsternberg/rows",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "map_override_type_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "map_override_type_test.flux",
					Source: "package rows_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "map_override_type_test.flux",
						Source: "rows_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "rows_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   102,
				},
				File:   "map_test.flux",
				Source: "package rows_test\n\n\nimport \"testing\"\nimport \"contrib/jsternberg/rows\"\n\noption now = () => 2020-08-02T17:24:00Z\n\ninData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"\noutData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,-30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,-14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,-85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,-50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,-22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,-16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,-18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,-24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,-5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,-9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,-16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,-14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,-28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,-83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,-2.187536871928522\n\"\nt_map = (table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({_time: r._time, _value: -r._value}))\n\ntest _map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "map_test.flux",
						Source: "now = () => 2020-08-02T17:24:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "map_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "map_test.flux",
							Source: "() => 2020-08-02T17:24:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "map_test.flux",
								Source: "2020-08-02T17:24:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2020-08-02T17:24:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "map_test.flux",
					Source: "option now = () => 2020-08-02T17:24:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "map_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "map_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "map_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   92,
					},
					File:   "map_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,-30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,-14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,-85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,-50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,-22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,-16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,-18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,-24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,-5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,-9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,-16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,-14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,-28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,-83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,-2.187536871928522\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   51,
						},
						File:   "map_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   92,
						},
						File:   "map_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,-30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,-14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,-85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,-50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,-22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,-16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,-18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,-24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,-5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,-9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,-16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,-14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,-28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,-83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,-2.187536871928522\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   51,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,-30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,-14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,-85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,-50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,-22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,-16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,-18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,-24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,-5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,-9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,-16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,-14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,-28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,-83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,-2.187536871928522\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 66,
						Line:   96,
					},
					File:   "map_test.flux",
					Source: "t_map = (table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({_time: r._time, _value: -r._value}))",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   93,
						},
						File:   "map_test.flux",
						Source: "t_map",
						Start: ast.Position{
							Column: 1,
							Line:   93,
						},
					},
				},
				Name: "t_map",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   96,
						},
						File:   "map_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({_time: r._time, _value: -r._value}))",
						Start: ast.Position{
							Column: 9,
							Line:   93,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   93,
										},
										File:   "map_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 23,
											Line:   93,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   94,
									},
									File:   "map_test.flux",
									Source: "table\n    |> range(start: -2m)",
									Start: ast.Position{
										Column: 23,
										Line:   93,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   94,
											},
											File:   "map_test.flux",
											Source: "start: -2m",
											Start: ast.Position{
												Column: 14,
												Line:   94,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   94,
												},
												File:   "map_test.flux",
												Source: "start: -2m",
												Start: ast.Position{
													Column: 14,
													Line:   94,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   94,
													},
													File:   "map_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   94,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.UnaryExpression{
											Argument: &ast.DurationLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   94,
														},
														File:   "map_test.flux",
														Source: "2m",
														Start: ast.Position{
															Column: 22,
															Line:   94,
														},
													},
												},
												Values: []ast.Duration{ast.Duration{
													Magnitude: int64(2),
													Unit:      "m",
												}},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   94,
													},
													File:   "map_test.flux",
													Source: "-2m",
													Start: ast.Position{
														Column: 21,
														Line:   94,
													},
												},
											},
											Operator: 6,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   94,
										},
										File:   "map_test.flux",
										Source: "range(start: -2m)",
										Start: ast.Position{
											Column: 8,
											Line:   94,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   94,
											},
											File:   "map_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   94,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   95,
								},
								File:   "map_test.flux",
								Source: "table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 23,
									Line:   93,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   95,
										},
										File:   "map_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   95,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   95,
											},
											File:   "map_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 13,
												Line:   95,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   95,
												},
												File:   "map_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   95,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   95,
												},
												File:   "map_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 22,
													Line:   95,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   95,
													},
													File:   "map_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   95,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   95,
													},
													File:   "map_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   95,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   95,
									},
									File:   "map_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 8,
										Line:   95,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   95,
										},
										File:   "map_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   95,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   96,
							},
							File:   "map_test.flux",
							Source: "table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({_time: r._time, _value: -r._value}))",
							Start: ast.Position{
								Column: 23,
								Line:   93,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   96,
									},
									File:   "map_test.flux",
									Source: "fn: (r) => ({_time: r._time, _value: -r._value})",
									Start: ast.Position{
										Column: 17,
										Line:   96,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   96,
										},
										File:   "map_test.flux",
										Source: "fn: (r) => ({_time: r._time, _value: -r._value})",
										Start: ast.Position{
											Column: 17,
											Line:   96,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   96,
											},
											File:   "map_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 17,
												Line:   96,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   96,
											},
											File:   "map_test.flux",
											Source: "(r) => ({_time: r._time, _value: -r._value})",
											Start: ast.Position{
												Column: 21,
												Line:   96,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   96,
												},
												File:   "map_test.flux",
												Source: "({_time: r._time, _value: -r._value})",
												Start: ast.Position{
													Column: 28,
													Line:   96,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   96,
													},
													File:   "map_test.flux",
													Source: "{_time: r._time, _value: -r._value}",
													Start: ast.Position{
														Column: 29,
														Line:   96,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   96,
														},
														File:   "map_test.flux",
														Source: "_time: r._time",
														Start: ast.Position{
															Column: 30,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   96,
															},
															File:   "map_test.flux",
															Source: "_time",
															Start: ast.Position{
																Column: 30,
																Line:   96,
															},
														},
													},
													Name: "_time",
												},
												Separator: nil,
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   96,
															},
															File:   "map_test.flux",
															Source: "r._time",
															Start: ast.Position{
																Column: 37,
																Line:   96,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   96,
																},
																File:   "map_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 37,
																	Line:   96,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   96,
																},
																File:   "map_test.flux",
																Source: "_time",
																Start: ast.Position{
																	Column: 39,
																	Line:   96,
																},
															},
														},
														Name: "_time",
													},
													Rbrack: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   96,
														},
														File:   "map_test.flux",
														Source: "_value: -r._value",
														Start: ast.Position{
															Column: 46,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   96,
															},
															File:   "map_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 46,
																Line:   96,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.UnaryExpression{
													Argument: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 63,
																	Line:   96,
																},
																File:   "map_test.flux",
																Source: "r._value",
																Start: ast.Position{
																	Column: 55,
																	Line:   96,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   96,
																	},
																	File:   "map_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 55,
																		Line:   96,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 63,
																		Line:   96,
																	},
																	File:   "map_test.flux",
																	Source: "_value",
																	Start: ast.Position{
																		Column: 57,
																		Line:   96,
																	},
																},
															},
															Name: "_value",
														},
														Rbrack: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   96,
															},
															File:   "map_test.flux",
															Source: "-r._value",
															Start: ast.Position{
																Column: 54,
																Line:   96,
															},
														},
													},
													Operator: 6,
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   96,
												},
												File:   "map_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 22,
													Line:   96,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   96,
													},
													File:   "map_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 22,
														Line:   96,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   96,
								},
								File:   "map_test.flux",
								Source: "rows.map(fn: (r) => ({_time: r._time, _value: -r._value}))",
								Start: ast.Position{
									Column: 8,
									Line:   96,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   96,
									},
									File:   "map_test.flux",
									Source: "rows.map",
									Start: ast.Position{
										Column: 8,
										Line:   96,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   96,
										},
										File:   "map_test.flux",
										Source: "rows",
										Start: ast.Position{
											Column: 8,
											Line:   96,
										},
									},
								},
								Name: "rows",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   96,
										},
										File:   "map_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 13,
											Line:   96,
										},
									},
								},
								Name: "map",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   93,
							},
							File:   "map_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   93,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   93,
								},
								File:   "map_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   93,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   93,
							},
							File:   "map_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   93,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   102,
						},
						File:   "map_test.flux",
						Source: "_map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   98,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   98,
							},
							File:   "map_test.flux",
							Source: "_map",
							Start: ast.Position{
								Column: 6,
								Line:   98,
							},
						},
					},
					Name: "_map",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   102,
							},
							File:   "map_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
							Start: ast.Position{
								Column: 13,
								Line:   98,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   102,
								},
								File:   "map_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
								Start: ast.Position{
									Column: 19,
									Line:   98,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   102,
									},
									File:   "map_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n}",
									Start: ast.Position{
										Column: 20,
										Line:   98,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   99,
										},
										File:   "map_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   99,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   99,
											},
											File:   "map_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   99,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   99,
												},
												File:   "map_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   99,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   99,
													},
													File:   "map_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   99,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   99,
														},
														File:   "map_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   99,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   99,
														},
														File:   "map_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   99,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   99,
											},
											File:   "map_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   99,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   99,
												},
												File:   "map_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   99,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   99,
													},
													File:   "map_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   99,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   99,
													},
													File:   "map_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   99,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   100,
										},
										File:   "map_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   100,
											},
											File:   "map_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   100,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   100,
												},
												File:   "map_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   100,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   100,
													},
													File:   "map_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   100,
														},
														File:   "map_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   100,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   100,
														},
														File:   "map_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   100,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   100,
											},
											File:   "map_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   100,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   100,
												},
												File:   "map_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   100,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   100,
													},
													File:   "map_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   100,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   100,
													},
													File:   "map_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   100,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   101,
										},
										File:   "map_test.flux",
										Source: "fn: t_map",
										Start: ast.Position{
											Column: 5,
											Line:   101,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   101,
											},
											File:   "map_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   101,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   101,
											},
											File:   "map_test.flux",
											Source: "t_map",
											Start: ast.Position{
												Column: 9,
												Line:   101,
											},
										},
									},
									Name: "t_map",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   102,
					},
					File:   "map_test.flux",
					Source: "test _map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   98,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "map_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "map_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   5,
					},
					File:   "map_test.flux",
					Source: "import \"contrib/jsternberg/rows\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   5,
						},
						File:   "map_test.flux",
						Source: "\"contrib/jsternberg/rows\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "contrib/jsternberg/rows",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "map_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "map_test.flux",
					Source: "package rows_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "map_test.flux",
						Source: "rows_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "rows_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   102,
				},
				File:   "map_with_test.flux",
				Source: "package rows_test\n\n\nimport \"testing\"\nimport \"contrib/jsternberg/rows\"\n\noption now = () => 2020-08-02T17:24:00Z\n\ninData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"\noutData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,-30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,-14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,-85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,-50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,-22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,-16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,-18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,-24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,-5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,-9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,-16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,-14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,-28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,-83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,-2.187536871928522\n\"\nt_map = (table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({r with _value: -r._value}))\n\ntest _map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "map_with_test.flux",
						Source: "now = () => 2020-08-02T17:24:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "map_with_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "map_with_test.flux",
							Source: "() => 2020-08-02T17:24:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "map_with_test.flux",
								Source: "2020-08-02T17:24:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2020-08-02T17:24:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "map_with_test.flux",
					Source: "option now = () => 2020-08-02T17:24:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "map_with_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "map_with_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "map_with_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,-43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,-19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,-31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,-16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,-77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,-112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,-28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,-11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,-64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,-54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,-6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,-36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,-31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,-8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,-8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,-43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,-25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,-76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,-67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,-53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,-92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,2.187536871928522\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   92,
					},
					File:   "map_with_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,-30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,-14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,-85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,-50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,-22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,-16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,-18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,-24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,-5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,-9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,-16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,-14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,-28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,-83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,-2.187536871928522\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   51,
						},
						File:   "map_with_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   92,
						},
						File:   "map_with_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,-30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,-14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,-85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,-50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,-22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,-16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,-18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,-24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,-5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,-9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,-16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,-14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,-28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,-83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,-2.187536871928522\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   51,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m0,f0,a-0,2020-08-02T17:22:00Z,43.09452210525144\n,,0,m0,f0,a-0,2020-08-02T17:22:10Z,-30.353812994348537\n,,0,m0,f0,a-0,2020-08-02T17:22:20Z,19.17028701626966\n,,0,m0,f0,a-0,2020-08-02T17:22:30Z,31.713408760790323\n,,0,m0,f0,a-0,2020-08-02T17:22:40Z,16.22173130975937\n,,0,m0,f0,a-0,2020-08-02T17:22:50Z,-14.631305556841284\n,,0,m0,f0,a-0,2020-08-02T17:23:00Z,-85.5542463240766\n,,0,m0,f0,a-0,2020-08-02T17:23:10Z,77.18220390886191\n,,0,m0,f0,a-0,2020-08-02T17:23:20Z,-50.062559688977814\n,,0,m0,f0,a-0,2020-08-02T17:23:30Z,-22.17256401464515\n,,0,m0,f0,a-0,2020-08-02T17:23:40Z,112.47430195827386\n,,0,m0,f0,a-0,2020-08-02T17:23:50Z,-16.85801752656638\n,,1,m0,f0,a-1,2020-08-02T17:22:00Z,28.65256634110021\n,,1,m0,f0,a-1,2020-08-02T17:22:10Z,11.021368187315897\n,,1,m0,f0,a-1,2020-08-02T17:22:20Z,-18.04898637542153\n,,1,m0,f0,a-1,2020-08-02T17:22:30Z,-24.555312299824035\n,,1,m0,f0,a-1,2020-08-02T17:22:40Z,-5.543823619638458\n,,1,m0,f0,a-1,2020-08-02T17:22:50Z,64.34272303286494\n,,1,m0,f0,a-1,2020-08-02T17:23:00Z,54.40142609111467\n,,1,m0,f0,a-1,2020-08-02T17:23:10Z,6.68919215397088\n,,1,m0,f0,a-1,2020-08-02T17:23:20Z,36.36364746675186\n,,1,m0,f0,a-1,2020-08-02T17:23:30Z,31.041492590916768\n,,1,m0,f0,a-1,2020-08-02T17:23:40Z,8.461569912796826\n,,1,m0,f0,a-1,2020-08-02T17:23:50Z,-9.025669280720571\n,,2,m0,f0,a-2,2020-08-02T17:22:00Z,8.640246126337203\n,,2,m0,f0,a-2,2020-08-02T17:22:10Z,43.365488430173706\n,,2,m0,f0,a-2,2020-08-02T17:22:20Z,25.198611516637676\n,,2,m0,f0,a-2,2020-08-02T17:22:30Z,-16.593516600485213\n,,2,m0,f0,a-2,2020-08-02T17:22:40Z,76.42451523676915\n,,2,m0,f0,a-2,2020-08-02T17:22:50Z,67.78699694188528\n,,2,m0,f0,a-2,2020-08-02T17:23:00Z,-14.77477027658923\n,,2,m0,f0,a-2,2020-08-02T17:23:10Z,-28.521034402304263\n,,2,m0,f0,a-2,2020-08-02T17:23:20Z,53.47644712761566\n,,2,m0,f0,a-2,2020-08-02T17:23:30Z,-83.38193426782863\n,,2,m0,f0,a-2,2020-08-02T17:23:40Z,92.49751968643372\n,,2,m0,f0,a-2,2020-08-02T17:23:50Z,-2.187536871928522\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 57,
						Line:   96,
					},
					File:   "map_with_test.flux",
					Source: "t_map = (table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({r with _value: -r._value}))",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   93,
						},
						File:   "map_with_test.flux",
						Source: "t_map",
						Start: ast.Position{
							Column: 1,
							Line:   93,
						},
					},
				},
				Name: "t_map",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 57,
							Line:   96,
						},
						File:   "map_with_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({r with _value: -r._value}))",
						Start: ast.Position{
							Column: 9,
							Line:   93,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   93,
										},
										File:   "map_with_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 23,
											Line:   93,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   94,
									},
									File:   "map_with_test.flux",
									Source: "table\n    |> range(start: -2m)",
									Start: ast.Position{
										Column: 23,
										Line:   93,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   94,
											},
											File:   "map_with_test.flux",
											Source: "start: -2m",
											Start: ast.Position{
												Column: 14,
												Line:   94,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   94,
												},
												File:   "map_with_test.flux",
												Source: "start: -2m",
												Start: ast.Position{
													Column: 14,
													Line:   94,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   94,
													},
													File:   "map_with_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   94,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.UnaryExpression{
											Argument: &ast.DurationLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   94,
														},
														File:   "map_with_test.flux",
														Source: "2m",
														Start: ast.Position{
															Column: 22,
															Line:   94,
														},
													},
												},
												Values: []ast.Duration{ast.Duration{
													Magnitude: int64(2),
													Unit:      "m",
												}},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   94,
													},
													File:   "map_with_test.flux",
													Source: "-2m",
													Start: ast.Position{
														Column: 21,
														Line:   94,
													},
												},
											},
											Operator: 6,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   94,
										},
										File:   "map_with_test.flux",
										Source: "range(start: -2m)",
										Start: ast.Position{
											Column: 8,
											Line:   94,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   94,
											},
											File:   "map_with_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   94,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   95,
								},
								File:   "map_with_test.flux",
								Source: "table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 23,
									Line:   93,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   95,
										},
										File:   "map_with_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   95,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   95,
											},
											File:   "map_with_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 13,
												Line:   95,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   95,
												},
												File:   "map_with_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   95,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   95,
												},
												File:   "map_with_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 22,
													Line:   95,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   95,
													},
													File:   "map_with_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   95,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   95,
													},
													File:   "map_with_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   95,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   95,
									},
									File:   "map_with_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 8,
										Line:   95,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   95,
										},
										File:   "map_with_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   95,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   96,
							},
							File:   "map_with_test.flux",
							Source: "table\n    |> range(start: -2m)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> rows.map(fn: (r) => ({r with _value: -r._value}))",
							Start: ast.Position{
								Column: 23,
								Line:   93,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   96,
									},
									File:   "map_with_test.flux",
									Source: "fn: (r) => ({r with _value: -r._value})",
									Start: ast.Position{
										Column: 17,
										Line:   96,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   96,
										},
										File:   "map_with_test.flux",
										Source: "fn: (r) => ({r with _value: -r._value})",
										Start: ast.Position{
											Column: 17,
											Line:   96,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   96,
											},
											File:   "map_with_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 17,
												Line:   96,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   96,
											},
											File:   "map_with_test.flux",
											Source: "(r) => ({r with _value: -r._value})",
											Start: ast.Position{
												Column: 21,
												Line:   96,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   96,
												},
												File:   "map_with_test.flux",
												Source: "({r with _value: -r._value})",
												Start: ast.Position{
													Column: 28,
													Line:   96,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   96,
													},
													File:   "map_with_test.flux",
													Source: "{r with _value: -r._value}",
													Start: ast.Position{
														Column: 29,
														Line:   96,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   96,
														},
														File:   "map_with_test.flux",
														Source: "_value: -r._value",
														Start: ast.Position{
															Column: 37,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   96,
															},
															File:   "map_with_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 37,
																Line:   96,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.UnaryExpression{
													Argument: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   96,
																},
																File:   "map_with_test.flux",
																Source: "r._value",
																Start: ast.Position{
																	Column: 46,
																	Line:   96,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   96,
																	},
																	File:   "map_with_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 46,
																		Line:   96,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   96,
																	},
																	File:   "map_with_test.flux",
																	Source: "_value",
																	Start: ast.Position{
																		Column: 48,
																		Line:   96,
																	},
																},
															},
															Name: "_value",
														},
														Rbrack: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   96,
															},
															File:   "map_with_test.flux",
															Source: "-r._value",
															Start: ast.Position{
																Column: 45,
																Line:   96,
															},
														},
													},
													Operator: 6,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   96,
														},
														File:   "map_with_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 30,
															Line:   96,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   96,
												},
												File:   "map_with_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 22,
													Line:   96,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   96,
													},
													File:   "map_with_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 22,
														Line:   96,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   96,
								},
								File:   "map_with_test.flux",
								Source: "rows.map(fn: (r) => ({r with _value: -r._value}))",
								Start: ast.Position{
									Column: 8,
									Line:   96,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   96,
									},
									File:   "map_with_test.flux",
									Source: "rows.map",
									Start: ast.Position{
										Column: 8,
										Line:   96,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   96,
										},
										File:   "map_with_test.flux",
										Source: "rows",
										Start: ast.Position{
											Column: 8,
											Line:   96,
										},
									},
								},
								Name: "rows",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   96,
										},
										File:   "map_with_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 13,
											Line:   96,
										},
									},
								},
								Name: "map",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   93,
							},
							File:   "map_with_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   93,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   93,
								},
								File:   "map_with_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   93,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   93,
							},
							File:   "map_with_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   93,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   102,
						},
						File:   "map_with_test.flux",
						Source: "_map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   98,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   98,
							},
							File:   "map_with_test.flux",
							Source: "_map",
							Start: ast.Position{
								Column: 6,
								Line:   98,
							},
						},
					},
					Name: "_map",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   102,
							},
							File:   "map_with_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
							Start: ast.Position{
								Column: 13,
								Line:   98,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   102,
								},
								File:   "map_with_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
								Start: ast.Position{
									Column: 19,
									Line:   98,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   102,
									},
									File:   "map_with_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n}",
									Start: ast.Position{
										Column: 20,
										Line:   98,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   99,
										},
										File:   "map_with_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   99,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   99,
											},
											File:   "map_with_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   99,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   99,
												},
												File:   "map_with_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   99,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   99,
													},
													File:   "map_with_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   99,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   99,
														},
														File:   "map_with_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   99,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   99,
														},
														File:   "map_with_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   99,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   99,
											},
											File:   "map_with_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   99,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   99,
												},
												File:   "map_with_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   99,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   99,
													},
													File:   "map_with_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   99,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   99,
													},
													File:   "map_with_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   99,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   100,
										},
										File:   "map_with_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   100,
											},
											File:   "map_with_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   100,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   100,
												},
												File:   "map_with_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   100,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   100,
													},
													File:   "map_with_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   100,
														},
														File:   "map_with_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   100,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   100,
														},
														File:   "map_with_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   100,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   100,
											},
											File:   "map_with_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   100,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   100,
												},
												File:   "map_with_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   100,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   100,
													},
													File:   "map_with_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   100,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   100,
													},
													File:   "map_with_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   100,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   101,
										},
										File:   "map_with_test.flux",
										Source: "fn: t_map",
										Start: ast.Position{
											Column: 5,
											Line:   101,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   101,
											},
											File:   "map_with_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   101,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   101,
											},
											File:   "map_with_test.flux",
											Source: "t_map",
											Start: ast.Position{
												Column: 9,
												Line:   101,
											},
										},
									},
									Name: "t_map",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   102,
					},
					File:   "map_with_test.flux",
					Source: "test _map = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: t_map,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   98,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "map_with_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "map_with_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   5,
					},
					File:   "map_with_test.flux",
					Source: "import \"contrib/jsternberg/rows\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   5,
						},
						File:   "map_with_test.flux",
						Source: "\"contrib/jsternberg/rows\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "contrib/jsternberg/rows",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "map_with_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "map_with_test.flux",
					Source: "package rows_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "map_with_test.flux",
						Source: "rows_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "rows_test",
			},
		},
	}},
	Package: "rows_test",
	Path:    "contrib/jsternberg/rows",
}}
