// DO NOT EDIT: This file is autogenerated via the builtin command.

package bigpanda

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   75,
				},
				File:   "bigpanda.flux",
				Source: "package bigpanda\n\n\nimport \"http\"\nimport \"json\"\nimport \"strings\"\n\noption defaultUrl = \"https://api.bigpanda.io/data/v2/alerts\"\noption defaultTokenPrefix = \"Bearer\"\n\n// `statusFromLevel` turns a level from the status object into a BigPanda status\n// `level` - string - levels on status objects can be one of the following ok,info,warn,crit,unknown\n// BigPanda accepts one of ok,critical,warning,acknowledged.\nstatusFromLevel = (level) => {\n    lvl = strings.toLower(v: level)\n    sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"ok\"\n    else if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"\n\n    return sev\n}\n\n// `sendAlert` sends a single alert to BigPanda as described in https://docs.bigpanda.io/reference#alerts API. \n// `token` - string - BigPanda authorization Bearer token\n// `url` - string - base URL of [BigPanda API](https://docs.bigpanda.io/reference#alerts).\n// `appKey` - string - BigPanda App Key.\n// `status` - string - Status of the BigPanda alert. One of ok, critical, warning, acknowledged.\n// `rec` - record - additional data appended to alert\nsendAlert = (\n        url,\n        token,\n        appKey,\n        status,\n        rec,\n) => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": defaultTokenPrefix + \" \" + token,\n    }\n    data = {rec with app_key: appKey, status: status}\n\n    return http.post(headers: headers, url: url, data: json.encode(v: data))\n}\n\n// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send alert to BigPanda for each table row.\n// `url` - string - base URL of [BigPanda API](https://docs.bigpanda.io/reference#alerts).\n// `token` - string - BigPanda authorization Bearer token\n// `appKey` - string - BigPanda App Key.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with all properties defined in the `sendAlert` function arguments (except url, apiKey and appKey).\nendpoint = (url=defaultUrl, token, appKey) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   8,
						},
						File:   "bigpanda.flux",
						Source: "defaultUrl = \"https://api.bigpanda.io/data/v2/alerts\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   8,
							},
							File:   "bigpanda.flux",
							Source: "defaultUrl",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "defaultUrl",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   8,
							},
							File:   "bigpanda.flux",
							Source: "\"https://api.bigpanda.io/data/v2/alerts\"",
							Start: ast.Position{
								Column: 21,
								Line:   8,
							},
						},
					},
					Value: "https://api.bigpanda.io/data/v2/alerts",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 61,
						Line:   8,
					},
					File:   "bigpanda.flux",
					Source: "option defaultUrl = \"https://api.bigpanda.io/data/v2/alerts\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   9,
						},
						File:   "bigpanda.flux",
						Source: "defaultTokenPrefix = \"Bearer\"",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   9,
							},
							File:   "bigpanda.flux",
							Source: "defaultTokenPrefix",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "defaultTokenPrefix",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   9,
							},
							File:   "bigpanda.flux",
							Source: "\"Bearer\"",
							Start: ast.Position{
								Column: 29,
								Line:   9,
							},
						},
					},
					Value: "Bearer",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   9,
					},
					File:   "bigpanda.flux",
					Source: "option defaultTokenPrefix = \"Bearer\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "bigpanda.flux",
					Source: "statusFromLevel = (level) => {\n    lvl = strings.toLower(v: level)\n    sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"ok\"\n    else if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"\n\n    return sev\n}",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `statusFromLevel` turns a level from the status object into a BigPanda status\n"}, ast.Comment{Text: "// `level` - string - levels on status objects can be one of the following ok,info,warn,crit,unknown\n"}, ast.Comment{Text: "// BigPanda accepts one of ok,critical,warning,acknowledged.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   14,
						},
						File:   "bigpanda.flux",
						Source: "statusFromLevel",
						Start: ast.Position{
							Column: 1,
							Line:   14,
						},
					},
				},
				Name: "statusFromLevel",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "bigpanda.flux",
						Source: "(level) => {\n    lvl = strings.toLower(v: level)\n    sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"ok\"\n    else if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"\n\n    return sev\n}",
						Start: ast.Position{
							Column: 19,
							Line:   14,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   28,
							},
							File:   "bigpanda.flux",
							Source: "{\n    lvl = strings.toLower(v: level)\n    sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"ok\"\n    else if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"\n\n    return sev\n}",
							Start: ast.Position{
								Column: 30,
								Line:   14,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   15,
								},
								File:   "bigpanda.flux",
								Source: "lvl = strings.toLower(v: level)",
								Start: ast.Position{
									Column: 5,
									Line:   15,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   15,
									},
									File:   "bigpanda.flux",
									Source: "lvl",
									Start: ast.Position{
										Column: 5,
										Line:   15,
									},
								},
							},
							Name: "lvl",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   15,
										},
										File:   "bigpanda.flux",
										Source: "v: level",
										Start: ast.Position{
											Column: 27,
											Line:   15,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   15,
											},
											File:   "bigpanda.flux",
											Source: "v: level",
											Start: ast.Position{
												Column: 27,
												Line:   15,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   15,
												},
												File:   "bigpanda.flux",
												Source: "v",
												Start: ast.Position{
													Column: 27,
													Line:   15,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   15,
												},
												File:   "bigpanda.flux",
												Source: "level",
												Start: ast.Position{
													Column: 30,
													Line:   15,
												},
											},
										},
										Name: "level",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   15,
									},
									File:   "bigpanda.flux",
									Source: "strings.toLower(v: level)",
									Start: ast.Position{
										Column: 11,
										Line:   15,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   15,
										},
										File:   "bigpanda.flux",
										Source: "strings.toLower",
										Start: ast.Position{
											Column: 11,
											Line:   15,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   15,
											},
											File:   "bigpanda.flux",
											Source: "strings",
											Start: ast.Position{
												Column: 11,
												Line:   15,
											},
										},
									},
									Name: "strings",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   15,
											},
											File:   "bigpanda.flux",
											Source: "toLower",
											Start: ast.Position{
												Column: 19,
												Line:   15,
											},
										},
									},
									Name: "toLower",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   25,
								},
								File:   "bigpanda.flux",
								Source: "sev = if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"ok\"\n    else if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"",
								Start: ast.Position{
									Column: 5,
									Line:   16,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   16,
									},
									File:   "bigpanda.flux",
									Source: "sev",
									Start: ast.Position{
										Column: 5,
										Line:   16,
									},
								},
							},
							Name: "sev",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.ConditionalExpression{
								Alternate: &ast.ConditionalExpression{
									Alternate: &ast.ConditionalExpression{
										Alternate: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   25,
													},
													File:   "bigpanda.flux",
													Source: "\"critical\"",
													Start: ast.Position{
														Column: 9,
														Line:   25,
													},
												},
											},
											Value: "critical",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   25,
												},
												File:   "bigpanda.flux",
												Source: "if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"",
												Start: ast.Position{
													Column: 10,
													Line:   22,
												},
											},
										},
										Consequent: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   23,
													},
													File:   "bigpanda.flux",
													Source: "\"ok\"",
													Start: ast.Position{
														Column: 9,
														Line:   23,
													},
												},
											},
											Value: "ok",
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   22,
													},
													File:   "bigpanda.flux",
													Source: "lvl == \"ok\"",
													Start: ast.Position{
														Column: 13,
														Line:   22,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   22,
														},
														File:   "bigpanda.flux",
														Source: "lvl",
														Start: ast.Position{
															Column: 13,
															Line:   22,
														},
													},
												},
												Name: "lvl",
											},
											Operator: 17,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   22,
														},
														File:   "bigpanda.flux",
														Source: "\"ok\"",
														Start: ast.Position{
															Column: 20,
															Line:   22,
														},
													},
												},
												Value: "ok",
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   25,
											},
											File:   "bigpanda.flux",
											Source: "if lvl == \"info\" then\n        \"ok\"\n    else if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"",
											Start: ast.Position{
												Column: 10,
												Line:   20,
											},
										},
									},
									Consequent: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   21,
												},
												File:   "bigpanda.flux",
												Source: "\"ok\"",
												Start: ast.Position{
													Column: 9,
													Line:   21,
												},
											},
										},
										Value: "ok",
									},
									Test: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   20,
												},
												File:   "bigpanda.flux",
												Source: "lvl == \"info\"",
												Start: ast.Position{
													Column: 13,
													Line:   20,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   20,
													},
													File:   "bigpanda.flux",
													Source: "lvl",
													Start: ast.Position{
														Column: 13,
														Line:   20,
													},
												},
											},
											Name: "lvl",
										},
										Operator: 17,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   20,
													},
													File:   "bigpanda.flux",
													Source: "\"info\"",
													Start: ast.Position{
														Column: 20,
														Line:   20,
													},
												},
											},
											Value: "info",
										},
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   25,
										},
										File:   "bigpanda.flux",
										Source: "if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"ok\"\n    else if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"",
										Start: ast.Position{
											Column: 10,
											Line:   18,
										},
									},
								},
								Consequent: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   19,
											},
											File:   "bigpanda.flux",
											Source: "\"critical\"",
											Start: ast.Position{
												Column: 9,
												Line:   19,
											},
										},
									},
									Value: "critical",
								},
								Test: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   18,
											},
											File:   "bigpanda.flux",
											Source: "lvl == \"crit\"",
											Start: ast.Position{
												Column: 13,
												Line:   18,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   18,
												},
												File:   "bigpanda.flux",
												Source: "lvl",
												Start: ast.Position{
													Column: 13,
													Line:   18,
												},
											},
										},
										Name: "lvl",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   18,
												},
												File:   "bigpanda.flux",
												Source: "\"crit\"",
												Start: ast.Position{
													Column: 20,
													Line:   18,
												},
											},
										},
										Value: "crit",
									},
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   25,
									},
									File:   "bigpanda.flux",
									Source: "if lvl == \"warn\" then\n        \"warning\"\n    else if lvl == \"crit\" then\n        \"critical\"\n    else if lvl == \"info\" then\n        \"ok\"\n    else if lvl == \"ok\" then\n        \"ok\"\n    else\n        \"critical\"",
									Start: ast.Position{
										Column: 11,
										Line:   16,
									},
								},
							},
							Consequent: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   17,
										},
										File:   "bigpanda.flux",
										Source: "\"warning\"",
										Start: ast.Position{
											Column: 9,
											Line:   17,
										},
									},
								},
								Value: "warning",
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   16,
										},
										File:   "bigpanda.flux",
										Source: "lvl == \"warn\"",
										Start: ast.Position{
											Column: 14,
											Line:   16,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   16,
											},
											File:   "bigpanda.flux",
											Source: "lvl",
											Start: ast.Position{
												Column: 14,
												Line:   16,
											},
										},
									},
									Name: "lvl",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   16,
											},
											File:   "bigpanda.flux",
											Source: "\"warn\"",
											Start: ast.Position{
												Column: 21,
												Line:   16,
											},
										},
									},
									Value: "warn",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   27,
									},
									File:   "bigpanda.flux",
									Source: "sev",
									Start: ast.Position{
										Column: 12,
										Line:   27,
									},
								},
							},
							Name: "sev",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   27,
								},
								File:   "bigpanda.flux",
								Source: "return sev",
								Start: ast.Position{
									Column: 5,
									Line:   27,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   14,
							},
							File:   "bigpanda.flux",
							Source: "level",
							Start: ast.Position{
								Column: 20,
								Line:   14,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   14,
								},
								File:   "bigpanda.flux",
								Source: "level",
								Start: ast.Position{
									Column: 20,
									Line:   14,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "bigpanda.flux",
					Source: "sendAlert = (\n        url,\n        token,\n        appKey,\n        status,\n        rec,\n) => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": defaultTokenPrefix + \" \" + token,\n    }\n    data = {rec with app_key: appKey, status: status}\n\n    return http.post(headers: headers, url: url, data: json.encode(v: data))\n}",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `sendAlert` sends a single alert to BigPanda as described in https://docs.bigpanda.io/reference#alerts API. \n"}, ast.Comment{Text: "// `token` - string - BigPanda authorization Bearer token\n"}, ast.Comment{Text: "// `url` - string - base URL of [BigPanda API](https://docs.bigpanda.io/reference#alerts).\n"}, ast.Comment{Text: "// `appKey` - string - BigPanda App Key.\n"}, ast.Comment{Text: "// `status` - string - Status of the BigPanda alert. One of ok, critical, warning, acknowledged.\n"}, ast.Comment{Text: "// `rec` - record - additional data appended to alert\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   36,
						},
						File:   "bigpanda.flux",
						Source: "sendAlert",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "sendAlert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "bigpanda.flux",
						Source: "(\n        url,\n        token,\n        appKey,\n        status,\n        rec,\n) => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": defaultTokenPrefix + \" \" + token,\n    }\n    data = {rec with app_key: appKey, status: status}\n\n    return http.post(headers: headers, url: url, data: json.encode(v: data))\n}",
						Start: ast.Position{
							Column: 13,
							Line:   36,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   50,
							},
							File:   "bigpanda.flux",
							Source: "{\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": defaultTokenPrefix + \" \" + token,\n    }\n    data = {rec with app_key: appKey, status: status}\n\n    return http.post(headers: headers, url: url, data: json.encode(v: data))\n}",
							Start: ast.Position{
								Column: 6,
								Line:   42,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   46,
								},
								File:   "bigpanda.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": defaultTokenPrefix + \" \" + token,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   43,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   43,
									},
									File:   "bigpanda.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   43,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   46,
									},
									File:   "bigpanda.flux",
									Source: "{\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": defaultTokenPrefix + \" \" + token,\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   43,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   44,
										},
										File:   "bigpanda.flux",
										Source: "\"Content-Type\": \"application/json; charset=utf-8\"",
										Start: ast.Position{
											Column: 9,
											Line:   44,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   44,
											},
											File:   "bigpanda.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   44,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   44,
											},
											File:   "bigpanda.flux",
											Source: "\"application/json; charset=utf-8\"",
											Start: ast.Position{
												Column: 25,
												Line:   44,
											},
										},
									},
									Value: "application/json; charset=utf-8",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   45,
										},
										File:   "bigpanda.flux",
										Source: "\"Authorization\": defaultTokenPrefix + \" \" + token",
										Start: ast.Position{
											Column: 9,
											Line:   45,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   45,
											},
											File:   "bigpanda.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   45,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   45,
											},
											File:   "bigpanda.flux",
											Source: "defaultTokenPrefix + \" \" + token",
											Start: ast.Position{
												Column: 26,
												Line:   45,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   45,
												},
												File:   "bigpanda.flux",
												Source: "defaultTokenPrefix + \" \"",
												Start: ast.Position{
													Column: 26,
													Line:   45,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   45,
													},
													File:   "bigpanda.flux",
													Source: "defaultTokenPrefix",
													Start: ast.Position{
														Column: 26,
														Line:   45,
													},
												},
											},
											Name: "defaultTokenPrefix",
										},
										Operator: 5,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   45,
													},
													File:   "bigpanda.flux",
													Source: "\" \"",
													Start: ast.Position{
														Column: 47,
														Line:   45,
													},
												},
											},
											Value: " ",
										},
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   45,
												},
												File:   "bigpanda.flux",
												Source: "token",
												Start: ast.Position{
													Column: 53,
													Line:   45,
												},
											},
										},
										Name: "token",
									},
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   47,
								},
								File:   "bigpanda.flux",
								Source: "data = {rec with app_key: appKey, status: status}",
								Start: ast.Position{
									Column: 5,
									Line:   47,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   47,
									},
									File:   "bigpanda.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   47,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   47,
									},
									File:   "bigpanda.flux",
									Source: "{rec with app_key: appKey, status: status}",
									Start: ast.Position{
										Column: 12,
										Line:   47,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   47,
										},
										File:   "bigpanda.flux",
										Source: "app_key: appKey",
										Start: ast.Position{
											Column: 22,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   47,
											},
											File:   "bigpanda.flux",
											Source: "app_key",
											Start: ast.Position{
												Column: 22,
												Line:   47,
											},
										},
									},
									Name: "app_key",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   47,
											},
											File:   "bigpanda.flux",
											Source: "appKey",
											Start: ast.Position{
												Column: 31,
												Line:   47,
											},
										},
									},
									Name: "appKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   47,
										},
										File:   "bigpanda.flux",
										Source: "status: status",
										Start: ast.Position{
											Column: 39,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   47,
											},
											File:   "bigpanda.flux",
											Source: "status",
											Start: ast.Position{
												Column: 39,
												Line:   47,
											},
										},
									},
									Name: "status",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   47,
											},
											File:   "bigpanda.flux",
											Source: "status",
											Start: ast.Position{
												Column: 47,
												Line:   47,
											},
										},
									},
									Name: "status",
								},
							}},
							Rbrace: nil,
							With: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   47,
										},
										File:   "bigpanda.flux",
										Source: "rec",
										Start: ast.Position{
											Column: 13,
											Line:   47,
										},
									},
								},
								Name: "rec",
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   49,
										},
										File:   "bigpanda.flux",
										Source: "headers: headers, url: url, data: json.encode(v: data)",
										Start: ast.Position{
											Column: 22,
											Line:   49,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   49,
											},
											File:   "bigpanda.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   49,
												},
												File:   "bigpanda.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   49,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   49,
												},
												File:   "bigpanda.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   49,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   49,
											},
											File:   "bigpanda.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   49,
												},
												File:   "bigpanda.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   49,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   49,
												},
												File:   "bigpanda.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   49,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   49,
											},
											File:   "bigpanda.flux",
											Source: "data: json.encode(v: data)",
											Start: ast.Position{
												Column: 50,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   49,
												},
												File:   "bigpanda.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   49,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   49,
													},
													File:   "bigpanda.flux",
													Source: "v: data",
													Start: ast.Position{
														Column: 68,
														Line:   49,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   49,
														},
														File:   "bigpanda.flux",
														Source: "v: data",
														Start: ast.Position{
															Column: 68,
															Line:   49,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   49,
															},
															File:   "bigpanda.flux",
															Source: "v",
															Start: ast.Position{
																Column: 68,
																Line:   49,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   49,
															},
															File:   "bigpanda.flux",
															Source: "data",
															Start: ast.Position{
																Column: 71,
																Line:   49,
															},
														},
													},
													Name: "data",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   49,
												},
												File:   "bigpanda.flux",
												Source: "json.encode(v: data)",
												Start: ast.Position{
													Column: 56,
													Line:   49,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   49,
													},
													File:   "bigpanda.flux",
													Source: "json.encode",
													Start: ast.Position{
														Column: 56,
														Line:   49,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   49,
														},
														File:   "bigpanda.flux",
														Source: "json",
														Start: ast.Position{
															Column: 56,
															Line:   49,
														},
													},
												},
												Name: "json",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   49,
														},
														File:   "bigpanda.flux",
														Source: "encode",
														Start: ast.Position{
															Column: 61,
															Line:   49,
														},
													},
												},
												Name: "encode",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   49,
									},
									File:   "bigpanda.flux",
									Source: "http.post(headers: headers, url: url, data: json.encode(v: data))",
									Start: ast.Position{
										Column: 12,
										Line:   49,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   49,
										},
										File:   "bigpanda.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   49,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   49,
											},
											File:   "bigpanda.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   49,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   49,
											},
											File:   "bigpanda.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   49,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   49,
								},
								File:   "bigpanda.flux",
								Source: "return http.post(headers: headers, url: url, data: json.encode(v: data))",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   37,
							},
							File:   "bigpanda.flux",
							Source: "url",
							Start: ast.Position{
								Column: 9,
								Line:   37,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   37,
								},
								File:   "bigpanda.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   37,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   38,
							},
							File:   "bigpanda.flux",
							Source: "token",
							Start: ast.Position{
								Column: 9,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   38,
								},
								File:   "bigpanda.flux",
								Source: "token",
								Start: ast.Position{
									Column: 9,
									Line:   38,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   39,
							},
							File:   "bigpanda.flux",
							Source: "appKey",
							Start: ast.Position{
								Column: 9,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   39,
								},
								File:   "bigpanda.flux",
								Source: "appKey",
								Start: ast.Position{
									Column: 9,
									Line:   39,
								},
							},
						},
						Name: "appKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   40,
							},
							File:   "bigpanda.flux",
							Source: "status",
							Start: ast.Position{
								Column: 9,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   40,
								},
								File:   "bigpanda.flux",
								Source: "status",
								Start: ast.Position{
									Column: 9,
									Line:   40,
								},
							},
						},
						Name: "status",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   41,
							},
							File:   "bigpanda.flux",
							Source: "rec",
							Start: ast.Position{
								Column: 9,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   41,
								},
								File:   "bigpanda.flux",
								Source: "rec",
								Start: ast.Position{
									Column: 9,
									Line:   41,
								},
							},
						},
						Name: "rec",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   75,
					},
					File:   "bigpanda.flux",
					Source: "endpoint = (url=defaultUrl, token, appKey) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   58,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send alert to BigPanda for each table row.\n"}, ast.Comment{Text: "// `url` - string - base URL of [BigPanda API](https://docs.bigpanda.io/reference#alerts).\n"}, ast.Comment{Text: "// `token` - string - BigPanda authorization Bearer token\n"}, ast.Comment{Text: "// `appKey` - string - BigPanda App Key.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with all properties defined in the `sendAlert` function arguments (except url, apiKey and appKey).\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   58,
						},
						File:   "bigpanda.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   58,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   75,
						},
						File:   "bigpanda.flux",
						Source: "(url=defaultUrl, token, appKey) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   58,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   75,
							},
							File:   "bigpanda.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 47,
								Line:   58,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   75,
								},
								File:   "bigpanda.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 58,
									Line:   58,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 79,
											Line:   58,
										},
										File:   "bigpanda.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 73,
											Line:   58,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   75,
									},
									File:   "bigpanda.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 73,
										Line:   58,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   74,
											},
											File:   "bigpanda.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   60,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   74,
												},
												File:   "bigpanda.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   60,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   60,
													},
													File:   "bigpanda.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   60,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   74,
													},
													File:   "bigpanda.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   60,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   74,
														},
														File:   "bigpanda.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   60,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   61,
															},
															File:   "bigpanda.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   61,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   61,
																},
																File:   "bigpanda.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   61,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   61,
																	},
																	File:   "bigpanda.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   61,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   61,
																		},
																		File:   "bigpanda.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   61,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   61,
																			},
																			File:   "bigpanda.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   61,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   61,
																			},
																			File:   "bigpanda.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   61,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   61,
																},
																File:   "bigpanda.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   61,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   61,
																	},
																	File:   "bigpanda.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   61,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   73,
																},
																File:   "bigpanda.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   63,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   72,
																	},
																	File:   "bigpanda.flux",
																	Source: "_sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   64,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   64,
																		},
																		File:   "bigpanda.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   64,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   71,
																			},
																			File:   "bigpanda.flux",
																			Source: "v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   65,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   71,
																				},
																				File:   "bigpanda.flux",
																				Source: "v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   65,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   65,
																					},
																					File:   "bigpanda.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   65,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   71,
																					},
																					File:   "bigpanda.flux",
																					Source: "2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   65,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   65,
																						},
																						File:   "bigpanda.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   65,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   71,
																						},
																						File:   "bigpanda.flux",
																						Source: "sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   65,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 33,
																									Line:   70,
																								},
																								File:   "bigpanda.flux",
																								Source: "url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj",
																								Start: ast.Position{
																									Column: 25,
																									Line:   66,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   66,
																									},
																									File:   "bigpanda.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   66,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   66,
																										},
																										File:   "bigpanda.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   66,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   66,
																										},
																										File:   "bigpanda.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   66,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   67,
																									},
																									File:   "bigpanda.flux",
																									Source: "appKey: appKey",
																									Start: ast.Position{
																										Column: 25,
																										Line:   67,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   67,
																										},
																										File:   "bigpanda.flux",
																										Source: "appKey",
																										Start: ast.Position{
																											Column: 25,
																											Line:   67,
																										},
																									},
																								},
																								Name: "appKey",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   67,
																										},
																										File:   "bigpanda.flux",
																										Source: "appKey",
																										Start: ast.Position{
																											Column: 33,
																											Line:   67,
																										},
																									},
																								},
																								Name: "appKey",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   68,
																									},
																									File:   "bigpanda.flux",
																									Source: "token: token",
																									Start: ast.Position{
																										Column: 25,
																										Line:   68,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   68,
																										},
																										File:   "bigpanda.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 25,
																											Line:   68,
																										},
																									},
																								},
																								Name: "token",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   68,
																										},
																										File:   "bigpanda.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 32,
																											Line:   68,
																										},
																									},
																								},
																								Name: "token",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   69,
																									},
																									File:   "bigpanda.flux",
																									Source: "status: obj.status",
																									Start: ast.Position{
																										Column: 25,
																										Line:   69,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   69,
																										},
																										File:   "bigpanda.flux",
																										Source: "status",
																										Start: ast.Position{
																											Column: 25,
																											Line:   69,
																										},
																									},
																								},
																								Name: "status",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   69,
																										},
																										File:   "bigpanda.flux",
																										Source: "obj.status",
																										Start: ast.Position{
																											Column: 33,
																											Line:   69,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 36,
																												Line:   69,
																											},
																											File:   "bigpanda.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 33,
																												Line:   69,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   69,
																											},
																											File:   "bigpanda.flux",
																											Source: "status",
																											Start: ast.Position{
																												Column: 37,
																												Line:   69,
																											},
																										},
																									},
																									Name: "status",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   70,
																									},
																									File:   "bigpanda.flux",
																									Source: "rec: obj",
																									Start: ast.Position{
																										Column: 25,
																										Line:   70,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   70,
																										},
																										File:   "bigpanda.flux",
																										Source: "rec",
																										Start: ast.Position{
																											Column: 25,
																											Line:   70,
																										},
																									},
																								},
																								Name: "rec",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   70,
																										},
																										File:   "bigpanda.flux",
																										Source: "obj",
																										Start: ast.Position{
																											Column: 30,
																											Line:   70,
																										},
																									},
																								},
																								Name: "obj",
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   71,
																							},
																							File:   "bigpanda.flux",
																							Source: "sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   65,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 38,
																									Line:   65,
																								},
																								File:   "bigpanda.flux",
																								Source: "sendAlert",
																								Start: ast.Position{
																									Column: 29,
																									Line:   65,
																								},
																							},
																						},
																						Name: "sendAlert",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   71,
																							},
																							File:   "bigpanda.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   71,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   72,
																		},
																		File:   "bigpanda.flux",
																		Source: "string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   64,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   64,
																			},
																			File:   "bigpanda.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   64,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   63,
																	},
																	File:   "bigpanda.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   63,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   73,
															},
															File:   "bigpanda.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   63,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   60,
														},
														File:   "bigpanda.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   60,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   60,
															},
															File:   "bigpanda.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   60,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   75,
										},
										File:   "bigpanda.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        appKey: appKey,\n                        token: token,\n                        status: obj.status,\n                        rec: obj,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   59,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   59,
											},
											File:   "bigpanda.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   59,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   58,
									},
									File:   "bigpanda.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 59,
										Line:   58,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   58,
										},
										File:   "bigpanda.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 59,
											Line:   58,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   58,
									},
									File:   "bigpanda.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 66,
										Line:   58,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   58,
								},
								File:   "bigpanda.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 48,
									Line:   58,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   58,
									},
									File:   "bigpanda.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 48,
										Line:   58,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   58,
							},
							File:   "bigpanda.flux",
							Source: "url=defaultUrl",
							Start: ast.Position{
								Column: 13,
								Line:   58,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   58,
								},
								File:   "bigpanda.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   58,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   58,
								},
								File:   "bigpanda.flux",
								Source: "defaultUrl",
								Start: ast.Position{
									Column: 17,
									Line:   58,
								},
							},
						},
						Name: "defaultUrl",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   58,
							},
							File:   "bigpanda.flux",
							Source: "token",
							Start: ast.Position{
								Column: 29,
								Line:   58,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   58,
								},
								File:   "bigpanda.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   58,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   58,
							},
							File:   "bigpanda.flux",
							Source: "appKey",
							Start: ast.Position{
								Column: 36,
								Line:   58,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   58,
								},
								File:   "bigpanda.flux",
								Source: "appKey",
								Start: ast.Position{
									Column: 36,
									Line:   58,
								},
							},
						},
						Name: "appKey",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "bigpanda.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "bigpanda.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "bigpanda.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "bigpanda.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "bigpanda.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "bigpanda.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bigpanda.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "bigpanda.flux",
					Source: "package bigpanda",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "bigpanda.flux",
						Source: "bigpanda",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "bigpanda",
			},
		},
	}},
	Package: "bigpanda",
	Path:    "contrib/rhajek/bigpanda",
}
