// DO NOT EDIT: This file is autogenerated via the builtin command.

package teams

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   62,
				},
				File:   "teams.flux",
				Source: "package teams\n\n\nimport \"http\"\nimport \"json\"\nimport \"strings\"\n\n// `summaryCutoff` is used \noption summaryCutoff = 70\n\n// `message` sends a single message to Microsoft Teams via incoming web hook.\n// `url` - string - incoming web hook URL\n// `title` - string - Message card title.\n// `text` - string - Message card text.\n// `summary` - string - Message card summary, it can be an empty string to generate summary from text.\nmessage = (url, title, text, summary=\"\") => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }\n\n    // see https://docs.microsoft.com/en-us/outlook/actionable-messages/message-card-reference#card-fields\n    // using string body, object cannot be used because '@' is an illegal character in the object property key\n    summary2 = if summary == \"\" then\n        text\n    else\n        summary\n    shortSummary = if strings.strlen(v: summary2) > summaryCutoff then\n        \"${strings.substring(v: summary2, start: 0, end: summaryCutoff)}...\"\n    else\n        summary2\n    body = \"{\n\\\"@type\\\": \\\"MessageCard\\\",\n\\\"@context\\\": \\\"http://schema.org/extensions\\\",\n\\\"title\\\": ${string(v: json.encode(v: title))},\n\\\"text\\\": ${string(v: json.encode(v: text))},\n\\\"summary\\\": ${string(v: json.encode(v: shortSummary))}\n}\"\n\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}\n\n// `endpoint` creates the endpoint for the Microsoft Teams external service.\n// `url` - string - URL of the incoming web hook.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `title`, `text`, and `summary`, as defined in the `message` function arguments.\nendpoint = (url) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   9,
						},
						File:   "teams.flux",
						Source: "summaryCutoff = 70",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   9,
							},
							File:   "teams.flux",
							Source: "summaryCutoff",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "summaryCutoff",
				},
				Init: &ast.IntegerLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   9,
							},
							File:   "teams.flux",
							Source: "70",
							Start: ast.Position{
								Column: 24,
								Line:   9,
							},
						},
					},
					Value: int64(70),
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// `summaryCutoff` is used \n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   9,
					},
					File:   "teams.flux",
					Source: "option summaryCutoff = 70",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   40,
					},
					File:   "teams.flux",
					Source: "message = (url, title, text, summary=\"\") => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }\n\n    // see https://docs.microsoft.com/en-us/outlook/actionable-messages/message-card-reference#card-fields\n    // using string body, object cannot be used because '@' is an illegal character in the object property key\n    summary2 = if summary == \"\" then\n        text\n    else\n        summary\n    shortSummary = if strings.strlen(v: summary2) > summaryCutoff then\n        \"${strings.substring(v: summary2, start: 0, end: summaryCutoff)}...\"\n    else\n        summary2\n    body = \"{\n\\\"@type\\\": \\\"MessageCard\\\",\n\\\"@context\\\": \\\"http://schema.org/extensions\\\",\n\\\"title\\\": ${string(v: json.encode(v: title))},\n\\\"text\\\": ${string(v: json.encode(v: text))},\n\\\"summary\\\": ${string(v: json.encode(v: shortSummary))}\n}\"\n\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `message` sends a single message to Microsoft Teams via incoming web hook.\n"}, ast.Comment{Text: "// `url` - string - incoming web hook URL\n"}, ast.Comment{Text: "// `title` - string - Message card title.\n"}, ast.Comment{Text: "// `text` - string - Message card text.\n"}, ast.Comment{Text: "// `summary` - string - Message card summary, it can be an empty string to generate summary from text.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   16,
						},
						File:   "teams.flux",
						Source: "message",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "message",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   40,
						},
						File:   "teams.flux",
						Source: "(url, title, text, summary=\"\") => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }\n\n    // see https://docs.microsoft.com/en-us/outlook/actionable-messages/message-card-reference#card-fields\n    // using string body, object cannot be used because '@' is an illegal character in the object property key\n    summary2 = if summary == \"\" then\n        text\n    else\n        summary\n    shortSummary = if strings.strlen(v: summary2) > summaryCutoff then\n        \"${strings.substring(v: summary2, start: 0, end: summaryCutoff)}...\"\n    else\n        summary2\n    body = \"{\n\\\"@type\\\": \\\"MessageCard\\\",\n\\\"@context\\\": \\\"http://schema.org/extensions\\\",\n\\\"title\\\": ${string(v: json.encode(v: title))},\n\\\"text\\\": ${string(v: json.encode(v: text))},\n\\\"summary\\\": ${string(v: json.encode(v: shortSummary))}\n}\"\n\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
						Start: ast.Position{
							Column: 11,
							Line:   16,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   40,
							},
							File:   "teams.flux",
							Source: "{\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }\n\n    // see https://docs.microsoft.com/en-us/outlook/actionable-messages/message-card-reference#card-fields\n    // using string body, object cannot be used because '@' is an illegal character in the object property key\n    summary2 = if summary == \"\" then\n        text\n    else\n        summary\n    shortSummary = if strings.strlen(v: summary2) > summaryCutoff then\n        \"${strings.substring(v: summary2, start: 0, end: summaryCutoff)}...\"\n    else\n        summary2\n    body = \"{\n\\\"@type\\\": \\\"MessageCard\\\",\n\\\"@context\\\": \\\"http://schema.org/extensions\\\",\n\\\"title\\\": ${string(v: json.encode(v: title))},\n\\\"text\\\": ${string(v: json.encode(v: text))},\n\\\"summary\\\": ${string(v: json.encode(v: shortSummary))}\n}\"\n\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
							Start: ast.Position{
								Column: 45,
								Line:   16,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   19,
								},
								File:   "teams.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   17,
									},
									File:   "teams.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   17,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   19,
									},
									File:   "teams.flux",
									Source: "{\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   17,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   18,
										},
										File:   "teams.flux",
										Source: "\"Content-Type\": \"application/json; charset=utf-8\"",
										Start: ast.Position{
											Column: 9,
											Line:   18,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   18,
											},
											File:   "teams.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   18,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   18,
											},
											File:   "teams.flux",
											Source: "\"application/json; charset=utf-8\"",
											Start: ast.Position{
												Column: 25,
												Line:   18,
											},
										},
									},
									Value: "application/json; charset=utf-8",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   26,
								},
								File:   "teams.flux",
								Source: "summary2 = if summary == \"\" then\n        text\n    else\n        summary",
								Start: ast.Position{
									Column: 5,
									Line:   23,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// see https://docs.microsoft.com/en-us/outlook/actionable-messages/message-card-reference#card-fields\n"}, ast.Comment{Text: "// using string body, object cannot be used because '@' is an illegal character in the object property key\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   23,
									},
									File:   "teams.flux",
									Source: "summary2",
									Start: ast.Position{
										Column: 5,
										Line:   23,
									},
								},
							},
							Name: "summary2",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   26,
										},
										File:   "teams.flux",
										Source: "summary",
										Start: ast.Position{
											Column: 9,
											Line:   26,
										},
									},
								},
								Name: "summary",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   26,
									},
									File:   "teams.flux",
									Source: "if summary == \"\" then\n        text\n    else\n        summary",
									Start: ast.Position{
										Column: 16,
										Line:   23,
									},
								},
							},
							Consequent: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   24,
										},
										File:   "teams.flux",
										Source: "text",
										Start: ast.Position{
											Column: 9,
											Line:   24,
										},
									},
								},
								Name: "text",
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   23,
										},
										File:   "teams.flux",
										Source: "summary == \"\"",
										Start: ast.Position{
											Column: 19,
											Line:   23,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   23,
											},
											File:   "teams.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 19,
												Line:   23,
											},
										},
									},
									Name: "summary",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   23,
											},
											File:   "teams.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 30,
												Line:   23,
											},
										},
									},
									Value: "",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   30,
								},
								File:   "teams.flux",
								Source: "shortSummary = if strings.strlen(v: summary2) > summaryCutoff then\n        \"${strings.substring(v: summary2, start: 0, end: summaryCutoff)}...\"\n    else\n        summary2",
								Start: ast.Position{
									Column: 5,
									Line:   27,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   27,
									},
									File:   "teams.flux",
									Source: "shortSummary",
									Start: ast.Position{
										Column: 5,
										Line:   27,
									},
								},
							},
							Name: "shortSummary",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   30,
										},
										File:   "teams.flux",
										Source: "summary2",
										Start: ast.Position{
											Column: 9,
											Line:   30,
										},
									},
								},
								Name: "summary2",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   30,
									},
									File:   "teams.flux",
									Source: "if strings.strlen(v: summary2) > summaryCutoff then\n        \"${strings.substring(v: summary2, start: 0, end: summaryCutoff)}...\"\n    else\n        summary2",
									Start: ast.Position{
										Column: 20,
										Line:   27,
									},
								},
							},
							Consequent: &ast.StringExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   28,
										},
										File:   "teams.flux",
										Source: "\"${strings.substring(v: summary2, start: 0, end: summaryCutoff)}...\"",
										Start: ast.Position{
											Column: 9,
											Line:   28,
										},
									},
								},
								Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   28,
											},
											File:   "teams.flux",
											Source: "${strings.substring(v: summary2, start: 0, end: summaryCutoff)}",
											Start: ast.Position{
												Column: 10,
												Line:   28,
											},
										},
									},
									Expression: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   28,
													},
													File:   "teams.flux",
													Source: "v: summary2, start: 0, end: summaryCutoff",
													Start: ast.Position{
														Column: 30,
														Line:   28,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   28,
														},
														File:   "teams.flux",
														Source: "v: summary2",
														Start: ast.Position{
															Column: 30,
															Line:   28,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   28,
															},
															File:   "teams.flux",
															Source: "v",
															Start: ast.Position{
																Column: 30,
																Line:   28,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   28,
															},
															File:   "teams.flux",
															Source: "summary2",
															Start: ast.Position{
																Column: 33,
																Line:   28,
															},
														},
													},
													Name: "summary2",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   28,
														},
														File:   "teams.flux",
														Source: "start: 0",
														Start: ast.Position{
															Column: 43,
															Line:   28,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   28,
															},
															File:   "teams.flux",
															Source: "start",
															Start: ast.Position{
																Column: 43,
																Line:   28,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.IntegerLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   28,
															},
															File:   "teams.flux",
															Source: "0",
															Start: ast.Position{
																Column: 50,
																Line:   28,
															},
														},
													},
													Value: int64(0),
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   28,
														},
														File:   "teams.flux",
														Source: "end: summaryCutoff",
														Start: ast.Position{
															Column: 53,
															Line:   28,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   28,
															},
															File:   "teams.flux",
															Source: "end",
															Start: ast.Position{
																Column: 53,
																Line:   28,
															},
														},
													},
													Name: "end",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 71,
																Line:   28,
															},
															File:   "teams.flux",
															Source: "summaryCutoff",
															Start: ast.Position{
																Column: 58,
																Line:   28,
															},
														},
													},
													Name: "summaryCutoff",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   28,
												},
												File:   "teams.flux",
												Source: "strings.substring(v: summary2, start: 0, end: summaryCutoff)",
												Start: ast.Position{
													Column: 12,
													Line:   28,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   28,
													},
													File:   "teams.flux",
													Source: "strings.substring",
													Start: ast.Position{
														Column: 12,
														Line:   28,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   28,
														},
														File:   "teams.flux",
														Source: "strings",
														Start: ast.Position{
															Column: 12,
															Line:   28,
														},
													},
												},
												Name: "strings",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   28,
														},
														File:   "teams.flux",
														Source: "substring",
														Start: ast.Position{
															Column: 20,
															Line:   28,
														},
													},
												},
												Name: "substring",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								}, &ast.TextPart{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   28,
											},
											File:   "teams.flux",
											Source: "...",
											Start: ast.Position{
												Column: 73,
												Line:   28,
											},
										},
									},
									Value: "...",
								}},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   27,
										},
										File:   "teams.flux",
										Source: "strings.strlen(v: summary2) > summaryCutoff",
										Start: ast.Position{
											Column: 23,
											Line:   27,
										},
									},
								},
								Left: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   27,
												},
												File:   "teams.flux",
												Source: "v: summary2",
												Start: ast.Position{
													Column: 38,
													Line:   27,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   27,
													},
													File:   "teams.flux",
													Source: "v: summary2",
													Start: ast.Position{
														Column: 38,
														Line:   27,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   27,
														},
														File:   "teams.flux",
														Source: "v",
														Start: ast.Position{
															Column: 38,
															Line:   27,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   27,
														},
														File:   "teams.flux",
														Source: "summary2",
														Start: ast.Position{
															Column: 41,
															Line:   27,
														},
													},
												},
												Name: "summary2",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   27,
											},
											File:   "teams.flux",
											Source: "strings.strlen(v: summary2)",
											Start: ast.Position{
												Column: 23,
												Line:   27,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   27,
												},
												File:   "teams.flux",
												Source: "strings.strlen",
												Start: ast.Position{
													Column: 23,
													Line:   27,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   27,
													},
													File:   "teams.flux",
													Source: "strings",
													Start: ast.Position{
														Column: 23,
														Line:   27,
													},
												},
											},
											Name: "strings",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   27,
													},
													File:   "teams.flux",
													Source: "strlen",
													Start: ast.Position{
														Column: 31,
														Line:   27,
													},
												},
											},
											Name: "strlen",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
								Operator: 10,
								Right: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   27,
											},
											File:   "teams.flux",
											Source: "summaryCutoff",
											Start: ast.Position{
												Column: 53,
												Line:   27,
											},
										},
									},
									Name: "summaryCutoff",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   37,
								},
								File:   "teams.flux",
								Source: "body = \"{\n\\\"@type\\\": \\\"MessageCard\\\",\n\\\"@context\\\": \\\"http://schema.org/extensions\\\",\n\\\"title\\\": ${string(v: json.encode(v: title))},\n\\\"text\\\": ${string(v: json.encode(v: text))},\n\\\"summary\\\": ${string(v: json.encode(v: shortSummary))}\n}\"",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   31,
									},
									File:   "teams.flux",
									Source: "body",
									Start: ast.Position{
										Column: 5,
										Line:   31,
									},
								},
							},
							Name: "body",
						},
						Init: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   37,
									},
									File:   "teams.flux",
									Source: "\"{\n\\\"@type\\\": \\\"MessageCard\\\",\n\\\"@context\\\": \\\"http://schema.org/extensions\\\",\n\\\"title\\\": ${string(v: json.encode(v: title))},\n\\\"text\\\": ${string(v: json.encode(v: text))},\n\\\"summary\\\": ${string(v: json.encode(v: shortSummary))}\n}\"",
									Start: ast.Position{
										Column: 12,
										Line:   31,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   34,
										},
										File:   "teams.flux",
										Source: "{\n\\\"@type\\\": \\\"MessageCard\\\",\n\\\"@context\\\": \\\"http://schema.org/extensions\\\",\n\\\"title\\\": ",
										Start: ast.Position{
											Column: 13,
											Line:   31,
										},
									},
								},
								Value: "{\n\"@type\": \"MessageCard\",\n\"@context\": \"http://schema.org/extensions\",\n\"title\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   34,
										},
										File:   "teams.flux",
										Source: "${string(v: json.encode(v: title))}",
										Start: ast.Position{
											Column: 12,
											Line:   34,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   34,
												},
												File:   "teams.flux",
												Source: "v: json.encode(v: title)",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   34,
													},
													File:   "teams.flux",
													Source: "v: json.encode(v: title)",
													Start: ast.Position{
														Column: 21,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   34,
														},
														File:   "teams.flux",
														Source: "v",
														Start: ast.Position{
															Column: 21,
															Line:   34,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   34,
															},
															File:   "teams.flux",
															Source: "v: title",
															Start: ast.Position{
																Column: 36,
																Line:   34,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   34,
																},
																File:   "teams.flux",
																Source: "v: title",
																Start: ast.Position{
																	Column: 36,
																	Line:   34,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   34,
																	},
																	File:   "teams.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 36,
																		Line:   34,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   34,
																	},
																	File:   "teams.flux",
																	Source: "title",
																	Start: ast.Position{
																		Column: 39,
																		Line:   34,
																	},
																},
															},
															Name: "title",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   34,
														},
														File:   "teams.flux",
														Source: "json.encode(v: title)",
														Start: ast.Position{
															Column: 24,
															Line:   34,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   34,
															},
															File:   "teams.flux",
															Source: "json.encode",
															Start: ast.Position{
																Column: 24,
																Line:   34,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   34,
																},
																File:   "teams.flux",
																Source: "json",
																Start: ast.Position{
																	Column: 24,
																	Line:   34,
																},
															},
														},
														Name: "json",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   34,
																},
																File:   "teams.flux",
																Source: "encode",
																Start: ast.Position{
																	Column: 29,
																	Line:   34,
																},
															},
														},
														Name: "encode",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   34,
											},
											File:   "teams.flux",
											Source: "string(v: json.encode(v: title))",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   34,
												},
												File:   "teams.flux",
												Source: "string",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "string",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   35,
										},
										File:   "teams.flux",
										Source: ",\n\\\"text\\\": ",
										Start: ast.Position{
											Column: 47,
											Line:   34,
										},
									},
								},
								Value: ",\n\"text\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   35,
										},
										File:   "teams.flux",
										Source: "${string(v: json.encode(v: text))}",
										Start: ast.Position{
											Column: 11,
											Line:   35,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   35,
												},
												File:   "teams.flux",
												Source: "v: json.encode(v: text)",
												Start: ast.Position{
													Column: 20,
													Line:   35,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   35,
													},
													File:   "teams.flux",
													Source: "v: json.encode(v: text)",
													Start: ast.Position{
														Column: 20,
														Line:   35,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   35,
														},
														File:   "teams.flux",
														Source: "v",
														Start: ast.Position{
															Column: 20,
															Line:   35,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   35,
															},
															File:   "teams.flux",
															Source: "v: text",
															Start: ast.Position{
																Column: 35,
																Line:   35,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   35,
																},
																File:   "teams.flux",
																Source: "v: text",
																Start: ast.Position{
																	Column: 35,
																	Line:   35,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   35,
																	},
																	File:   "teams.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 35,
																		Line:   35,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   35,
																	},
																	File:   "teams.flux",
																	Source: "text",
																	Start: ast.Position{
																		Column: 38,
																		Line:   35,
																	},
																},
															},
															Name: "text",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   35,
														},
														File:   "teams.flux",
														Source: "json.encode(v: text)",
														Start: ast.Position{
															Column: 23,
															Line:   35,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   35,
															},
															File:   "teams.flux",
															Source: "json.encode",
															Start: ast.Position{
																Column: 23,
																Line:   35,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   35,
																},
																File:   "teams.flux",
																Source: "json",
																Start: ast.Position{
																	Column: 23,
																	Line:   35,
																},
															},
														},
														Name: "json",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   35,
																},
																File:   "teams.flux",
																Source: "encode",
																Start: ast.Position{
																	Column: 28,
																	Line:   35,
																},
															},
														},
														Name: "encode",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   35,
											},
											File:   "teams.flux",
											Source: "string(v: json.encode(v: text))",
											Start: ast.Position{
												Column: 13,
												Line:   35,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   35,
												},
												File:   "teams.flux",
												Source: "string",
												Start: ast.Position{
													Column: 13,
													Line:   35,
												},
											},
										},
										Name: "string",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   36,
										},
										File:   "teams.flux",
										Source: ",\n\\\"summary\\\": ",
										Start: ast.Position{
											Column: 45,
											Line:   35,
										},
									},
								},
								Value: ",\n\"summary\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   36,
										},
										File:   "teams.flux",
										Source: "${string(v: json.encode(v: shortSummary))}",
										Start: ast.Position{
											Column: 14,
											Line:   36,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   36,
												},
												File:   "teams.flux",
												Source: "v: json.encode(v: shortSummary)",
												Start: ast.Position{
													Column: 23,
													Line:   36,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   36,
													},
													File:   "teams.flux",
													Source: "v: json.encode(v: shortSummary)",
													Start: ast.Position{
														Column: 23,
														Line:   36,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   36,
														},
														File:   "teams.flux",
														Source: "v",
														Start: ast.Position{
															Column: 23,
															Line:   36,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   36,
															},
															File:   "teams.flux",
															Source: "v: shortSummary",
															Start: ast.Position{
																Column: 38,
																Line:   36,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   36,
																},
																File:   "teams.flux",
																Source: "v: shortSummary",
																Start: ast.Position{
																	Column: 38,
																	Line:   36,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   36,
																	},
																	File:   "teams.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 38,
																		Line:   36,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   36,
																	},
																	File:   "teams.flux",
																	Source: "shortSummary",
																	Start: ast.Position{
																		Column: 41,
																		Line:   36,
																	},
																},
															},
															Name: "shortSummary",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   36,
														},
														File:   "teams.flux",
														Source: "json.encode(v: shortSummary)",
														Start: ast.Position{
															Column: 26,
															Line:   36,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   36,
															},
															File:   "teams.flux",
															Source: "json.encode",
															Start: ast.Position{
																Column: 26,
																Line:   36,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   36,
																},
																File:   "teams.flux",
																Source: "json",
																Start: ast.Position{
																	Column: 26,
																	Line:   36,
																},
															},
														},
														Name: "json",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   36,
																},
																File:   "teams.flux",
																Source: "encode",
																Start: ast.Position{
																	Column: 31,
																	Line:   36,
																},
															},
														},
														Name: "encode",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   36,
											},
											File:   "teams.flux",
											Source: "string(v: json.encode(v: shortSummary))",
											Start: ast.Position{
												Column: 16,
												Line:   36,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   36,
												},
												File:   "teams.flux",
												Source: "string",
												Start: ast.Position{
													Column: 16,
													Line:   36,
												},
											},
										},
										Name: "string",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 2,
											Line:   37,
										},
										File:   "teams.flux",
										Source: "\n}",
										Start: ast.Position{
											Column: 56,
											Line:   36,
										},
									},
								},
								Value: "\n}",
							}},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   39,
										},
										File:   "teams.flux",
										Source: "headers: headers, url: url, data: bytes(v: body)",
										Start: ast.Position{
											Column: 22,
											Line:   39,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   39,
											},
											File:   "teams.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   39,
												},
												File:   "teams.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   39,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   39,
												},
												File:   "teams.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   39,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   39,
											},
											File:   "teams.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   39,
												},
												File:   "teams.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   39,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   39,
												},
												File:   "teams.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   39,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   39,
											},
											File:   "teams.flux",
											Source: "data: bytes(v: body)",
											Start: ast.Position{
												Column: 50,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   39,
												},
												File:   "teams.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   39,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   39,
													},
													File:   "teams.flux",
													Source: "v: body",
													Start: ast.Position{
														Column: 62,
														Line:   39,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   39,
														},
														File:   "teams.flux",
														Source: "v: body",
														Start: ast.Position{
															Column: 62,
															Line:   39,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   39,
															},
															File:   "teams.flux",
															Source: "v",
															Start: ast.Position{
																Column: 62,
																Line:   39,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   39,
															},
															File:   "teams.flux",
															Source: "body",
															Start: ast.Position{
																Column: 65,
																Line:   39,
															},
														},
													},
													Name: "body",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   39,
												},
												File:   "teams.flux",
												Source: "bytes(v: body)",
												Start: ast.Position{
													Column: 56,
													Line:   39,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   39,
													},
													File:   "teams.flux",
													Source: "bytes",
													Start: ast.Position{
														Column: 56,
														Line:   39,
													},
												},
											},
											Name: "bytes",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   39,
									},
									File:   "teams.flux",
									Source: "http.post(headers: headers, url: url, data: bytes(v: body))",
									Start: ast.Position{
										Column: 12,
										Line:   39,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   39,
										},
										File:   "teams.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   39,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   39,
											},
											File:   "teams.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   39,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   39,
											},
											File:   "teams.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   39,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   39,
								},
								File:   "teams.flux",
								Source: "return http.post(headers: headers, url: url, data: bytes(v: body))",
								Start: ast.Position{
									Column: 5,
									Line:   39,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   16,
							},
							File:   "teams.flux",
							Source: "url",
							Start: ast.Position{
								Column: 12,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   16,
								},
								File:   "teams.flux",
								Source: "url",
								Start: ast.Position{
									Column: 12,
									Line:   16,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   16,
							},
							File:   "teams.flux",
							Source: "title",
							Start: ast.Position{
								Column: 17,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   16,
								},
								File:   "teams.flux",
								Source: "title",
								Start: ast.Position{
									Column: 17,
									Line:   16,
								},
							},
						},
						Name: "title",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   16,
							},
							File:   "teams.flux",
							Source: "text",
							Start: ast.Position{
								Column: 24,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   16,
								},
								File:   "teams.flux",
								Source: "text",
								Start: ast.Position{
									Column: 24,
									Line:   16,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   16,
							},
							File:   "teams.flux",
							Source: "summary=\"\"",
							Start: ast.Position{
								Column: 30,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   16,
								},
								File:   "teams.flux",
								Source: "summary",
								Start: ast.Position{
									Column: 30,
									Line:   16,
								},
							},
						},
						Name: "summary",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   16,
								},
								File:   "teams.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 38,
									Line:   16,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   62,
					},
					File:   "teams.flux",
					Source: "endpoint = (url) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates the endpoint for the Microsoft Teams external service.\n"}, ast.Comment{Text: "// `url` - string - URL of the incoming web hook.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `title`, `text`, and `summary`, as defined in the `message` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   46,
						},
						File:   "teams.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   62,
						},
						File:   "teams.flux",
						Source: "(url) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   46,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   62,
							},
							File:   "teams.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 21,
								Line:   46,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   62,
								},
								File:   "teams.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 32,
									Line:   46,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   46,
										},
										File:   "teams.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 47,
											Line:   46,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   62,
									},
									File:   "teams.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 47,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   61,
											},
											File:   "teams.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   61,
												},
												File:   "teams.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   48,
													},
													File:   "teams.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   48,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   61,
													},
													File:   "teams.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   48,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   61,
														},
														File:   "teams.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   48,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   49,
															},
															File:   "teams.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   49,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   49,
																},
																File:   "teams.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   49,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   49,
																	},
																	File:   "teams.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   49,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   49,
																		},
																		File:   "teams.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   49,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   49,
																			},
																			File:   "teams.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   49,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   49,
																			},
																			File:   "teams.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   49,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   49,
																},
																File:   "teams.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   49,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   49,
																	},
																	File:   "teams.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   49,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   60,
																},
																File:   "teams.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   51,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   59,
																	},
																	File:   "teams.flux",
																	Source: "_sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   52,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   52,
																		},
																		File:   "teams.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   52,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   58,
																			},
																			File:   "teams.flux",
																			Source: "v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   53,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   58,
																				},
																				File:   "teams.flux",
																				Source: "v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   53,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   53,
																					},
																					File:   "teams.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   53,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   58,
																					},
																					File:   "teams.flux",
																					Source: "2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   53,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   53,
																						},
																						File:   "teams.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   53,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   58,
																						},
																						File:   "teams.flux",
																						Source: "message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   53,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 80,
																									Line:   57,
																								},
																								File:   "teams.flux",
																								Source: "url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\"",
																								Start: ast.Position{
																									Column: 25,
																									Line:   54,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   54,
																									},
																									File:   "teams.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   54,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   54,
																										},
																										File:   "teams.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   54,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   54,
																										},
																										File:   "teams.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   54,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   55,
																									},
																									File:   "teams.flux",
																									Source: "title: obj.title",
																									Start: ast.Position{
																										Column: 25,
																										Line:   55,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   55,
																										},
																										File:   "teams.flux",
																										Source: "title",
																										Start: ast.Position{
																											Column: 25,
																											Line:   55,
																										},
																									},
																								},
																								Name: "title",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   55,
																										},
																										File:   "teams.flux",
																										Source: "obj.title",
																										Start: ast.Position{
																											Column: 32,
																											Line:   55,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   55,
																											},
																											File:   "teams.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   55,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   55,
																											},
																											File:   "teams.flux",
																											Source: "title",
																											Start: ast.Position{
																												Column: 36,
																												Line:   55,
																											},
																										},
																									},
																									Name: "title",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   56,
																									},
																									File:   "teams.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 25,
																										Line:   56,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   56,
																										},
																										File:   "teams.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 25,
																											Line:   56,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   56,
																										},
																										File:   "teams.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 31,
																											Line:   56,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   56,
																											},
																											File:   "teams.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   56,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   56,
																											},
																											File:   "teams.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 35,
																												Line:   56,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 80,
																										Line:   57,
																									},
																									File:   "teams.flux",
																									Source: "summary: if exists obj.summary then obj.summary else \"\"",
																									Start: ast.Position{
																										Column: 25,
																										Line:   57,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   57,
																										},
																										File:   "teams.flux",
																										Source: "summary",
																										Start: ast.Position{
																											Column: 25,
																											Line:   57,
																										},
																									},
																								},
																								Name: "summary",
																							},
																							Separator: nil,
																							Value: &ast.ConditionalExpression{
																								Alternate: &ast.StringLiteral{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 80,
																												Line:   57,
																											},
																											File:   "teams.flux",
																											Source: "\"\"",
																											Start: ast.Position{
																												Column: 78,
																												Line:   57,
																											},
																										},
																									},
																									Value: "",
																								},
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 80,
																											Line:   57,
																										},
																										File:   "teams.flux",
																										Source: "if exists obj.summary then obj.summary else \"\"",
																										Start: ast.Position{
																											Column: 34,
																											Line:   57,
																										},
																									},
																								},
																								Consequent: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 72,
																												Line:   57,
																											},
																											File:   "teams.flux",
																											Source: "obj.summary",
																											Start: ast.Position{
																												Column: 61,
																												Line:   57,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 64,
																													Line:   57,
																												},
																												File:   "teams.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 61,
																													Line:   57,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 72,
																													Line:   57,
																												},
																												File:   "teams.flux",
																												Source: "summary",
																												Start: ast.Position{
																													Column: 65,
																													Line:   57,
																												},
																											},
																										},
																										Name: "summary",
																									},
																									Rbrack: nil,
																								},
																								Test: &ast.UnaryExpression{
																									Argument: &ast.MemberExpression{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 55,
																													Line:   57,
																												},
																												File:   "teams.flux",
																												Source: "obj.summary",
																												Start: ast.Position{
																													Column: 44,
																													Line:   57,
																												},
																											},
																										},
																										Lbrack: nil,
																										Object: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 47,
																														Line:   57,
																													},
																													File:   "teams.flux",
																													Source: "obj",
																													Start: ast.Position{
																														Column: 44,
																														Line:   57,
																													},
																												},
																											},
																											Name: "obj",
																										},
																										Property: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 55,
																														Line:   57,
																													},
																													File:   "teams.flux",
																													Source: "summary",
																													Start: ast.Position{
																														Column: 48,
																														Line:   57,
																													},
																												},
																											},
																											Name: "summary",
																										},
																										Rbrack: nil,
																									},
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 55,
																												Line:   57,
																											},
																											File:   "teams.flux",
																											Source: "exists obj.summary",
																											Start: ast.Position{
																												Column: 37,
																												Line:   57,
																											},
																										},
																									},
																									Operator: 14,
																								},
																								Tk_else: nil,
																								Tk_if:   nil,
																								Tk_then: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   58,
																							},
																							File:   "teams.flux",
																							Source: "message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   53,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 36,
																									Line:   53,
																								},
																								File:   "teams.flux",
																								Source: "message",
																								Start: ast.Position{
																									Column: 29,
																									Line:   53,
																								},
																							},
																						},
																						Name: "message",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   58,
																							},
																							File:   "teams.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   58,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   59,
																		},
																		File:   "teams.flux",
																		Source: "string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   52,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   52,
																			},
																			File:   "teams.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   52,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   51,
																	},
																	File:   "teams.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   51,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   60,
															},
															File:   "teams.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   51,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   48,
														},
														File:   "teams.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   48,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   48,
															},
															File:   "teams.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   48,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   62,
										},
										File:   "teams.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        title: obj.title,\n                        text: obj.text,\n                        summary: if exists obj.summary then obj.summary else \"\",\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   47,
											},
											File:   "teams.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   47,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   46,
									},
									File:   "teams.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 33,
										Line:   46,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   46,
										},
										File:   "teams.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 33,
											Line:   46,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   46,
									},
									File:   "teams.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 40,
										Line:   46,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   46,
								},
								File:   "teams.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 22,
									Line:   46,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   46,
									},
									File:   "teams.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 22,
										Line:   46,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   46,
							},
							File:   "teams.flux",
							Source: "url",
							Start: ast.Position{
								Column: 13,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   46,
								},
								File:   "teams.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   46,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "teams.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "teams.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "teams.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "teams.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "teams.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "teams.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "teams.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   1,
					},
					File:   "teams.flux",
					Source: "package teams",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   1,
						},
						File:   "teams.flux",
						Source: "teams",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "teams",
			},
		},
	}},
	Package: "teams",
	Path:    "contrib/sranka/teams",
}
