// DO NOT EDIT: This file is autogenerated via the builtin command.

package http

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 110,
					Line:   34,
				},
				File:   "http_endpoint_test.flux",
				Source: "package http_test\n\n\nimport \"testing\"\nimport \"http\"\nimport \"json\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,true\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/,true\n\"\nendpoint = http.endpoint(url: \"http://localhost:7777\")\npost = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> endpoint(mapFn: (r) => ({data: json.encode(v: r)}))()\n\ntest _post = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "http_endpoint_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "http_endpoint_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "http_endpoint_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "http_endpoint_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "http_endpoint_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "http_endpoint_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "http_endpoint_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "http_endpoint_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,true\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/,true\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   19,
						},
						File:   "http_endpoint_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   19,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,true\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/,true\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   19,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,true\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/,true\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 55,
						Line:   28,
					},
					File:   "http_endpoint_test.flux",
					Source: "endpoint = http.endpoint(url: \"http://localhost:7777\")",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   28,
						},
						File:   "http_endpoint_test.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   28,
							},
							File:   "http_endpoint_test.flux",
							Source: "url: \"http://localhost:7777\"",
							Start: ast.Position{
								Column: 26,
								Line:   28,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   28,
								},
								File:   "http_endpoint_test.flux",
								Source: "url: \"http://localhost:7777\"",
								Start: ast.Position{
									Column: 26,
									Line:   28,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   28,
									},
									File:   "http_endpoint_test.flux",
									Source: "url",
									Start: ast.Position{
										Column: 26,
										Line:   28,
									},
								},
							},
							Name: "url",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   28,
									},
									File:   "http_endpoint_test.flux",
									Source: "\"http://localhost:7777\"",
									Start: ast.Position{
										Column: 31,
										Line:   28,
									},
								},
							},
							Value: "http://localhost:7777",
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   28,
						},
						File:   "http_endpoint_test.flux",
						Source: "http.endpoint(url: \"http://localhost:7777\")",
						Start: ast.Position{
							Column: 12,
							Line:   28,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   28,
							},
							File:   "http_endpoint_test.flux",
							Source: "http.endpoint",
							Start: ast.Position{
								Column: 12,
								Line:   28,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   28,
								},
								File:   "http_endpoint_test.flux",
								Source: "http",
								Start: ast.Position{
									Column: 12,
									Line:   28,
								},
							},
						},
						Name: "http",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   28,
								},
								File:   "http_endpoint_test.flux",
								Source: "endpoint",
								Start: ast.Position{
									Column: 17,
									Line:   28,
								},
							},
						},
						Name: "endpoint",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 61,
						Line:   32,
					},
					File:   "http_endpoint_test.flux",
					Source: "post = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> endpoint(mapFn: (r) => ({data: json.encode(v: r)}))()",
					Start: ast.Position{
						Column: 1,
						Line:   29,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   29,
						},
						File:   "http_endpoint_test.flux",
						Source: "post",
						Start: ast.Position{
							Column: 1,
							Line:   29,
						},
					},
				},
				Name: "post",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   32,
						},
						File:   "http_endpoint_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> endpoint(mapFn: (r) => ({data: json.encode(v: r)}))()",
						Start: ast.Position{
							Column: 8,
							Line:   29,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   29,
										},
										File:   "http_endpoint_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 22,
											Line:   29,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   30,
									},
									File:   "http_endpoint_test.flux",
									Source: "table\n    |> range(start: 2018-05-22T00:00:00Z)",
									Start: ast.Position{
										Column: 22,
										Line:   29,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   30,
											},
											File:   "http_endpoint_test.flux",
											Source: "start: 2018-05-22T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   30,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   30,
												},
												File:   "http_endpoint_test.flux",
												Source: "start: 2018-05-22T00:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   30,
													},
													File:   "http_endpoint_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   30,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   30,
													},
													File:   "http_endpoint_test.flux",
													Source: "2018-05-22T00:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   30,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   30,
										},
										File:   "http_endpoint_test.flux",
										Source: "range(start: 2018-05-22T00:00:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   30,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   30,
											},
											File:   "http_endpoint_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   30,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   31,
								},
								File:   "http_endpoint_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 22,
									Line:   29,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   31,
										},
										File:   "http_endpoint_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   31,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   31,
											},
											File:   "http_endpoint_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 13,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   31,
												},
												File:   "http_endpoint_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   31,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   31,
												},
												File:   "http_endpoint_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 22,
													Line:   31,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   31,
													},
													File:   "http_endpoint_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   31,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   31,
													},
													File:   "http_endpoint_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   31,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   31,
									},
									File:   "http_endpoint_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 8,
										Line:   31,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   31,
										},
										File:   "http_endpoint_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   31,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   32,
							},
							File:   "http_endpoint_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> endpoint(mapFn: (r) => ({data: json.encode(v: r)}))()",
							Start: ast.Position{
								Column: 22,
								Line:   29,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   32,
								},
								File:   "http_endpoint_test.flux",
								Source: "endpoint(mapFn: (r) => ({data: json.encode(v: r)}))()",
								Start: ast.Position{
									Column: 8,
									Line:   32,
								},
							},
						},
						Callee: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   32,
										},
										File:   "http_endpoint_test.flux",
										Source: "mapFn: (r) => ({data: json.encode(v: r)})",
										Start: ast.Position{
											Column: 17,
											Line:   32,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   32,
											},
											File:   "http_endpoint_test.flux",
											Source: "mapFn: (r) => ({data: json.encode(v: r)})",
											Start: ast.Position{
												Column: 17,
												Line:   32,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   32,
												},
												File:   "http_endpoint_test.flux",
												Source: "mapFn",
												Start: ast.Position{
													Column: 17,
													Line:   32,
												},
											},
										},
										Name: "mapFn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   32,
												},
												File:   "http_endpoint_test.flux",
												Source: "(r) => ({data: json.encode(v: r)})",
												Start: ast.Position{
													Column: 24,
													Line:   32,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   32,
													},
													File:   "http_endpoint_test.flux",
													Source: "({data: json.encode(v: r)})",
													Start: ast.Position{
														Column: 31,
														Line:   32,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   32,
														},
														File:   "http_endpoint_test.flux",
														Source: "{data: json.encode(v: r)}",
														Start: ast.Position{
															Column: 32,
															Line:   32,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   32,
															},
															File:   "http_endpoint_test.flux",
															Source: "data: json.encode(v: r)",
															Start: ast.Position{
																Column: 33,
																Line:   32,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   32,
																},
																File:   "http_endpoint_test.flux",
																Source: "data",
																Start: ast.Position{
																	Column: 33,
																	Line:   32,
																},
															},
														},
														Name: "data",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   32,
																	},
																	File:   "http_endpoint_test.flux",
																	Source: "v: r",
																	Start: ast.Position{
																		Column: 51,
																		Line:   32,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   32,
																		},
																		File:   "http_endpoint_test.flux",
																		Source: "v: r",
																		Start: ast.Position{
																			Column: 51,
																			Line:   32,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 52,
																				Line:   32,
																			},
																			File:   "http_endpoint_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 51,
																				Line:   32,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   32,
																			},
																			File:   "http_endpoint_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 54,
																				Line:   32,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   32,
																},
																File:   "http_endpoint_test.flux",
																Source: "json.encode(v: r)",
																Start: ast.Position{
																	Column: 39,
																	Line:   32,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   32,
																	},
																	File:   "http_endpoint_test.flux",
																	Source: "json.encode",
																	Start: ast.Position{
																		Column: 39,
																		Line:   32,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   32,
																		},
																		File:   "http_endpoint_test.flux",
																		Source: "json",
																		Start: ast.Position{
																			Column: 39,
																			Line:   32,
																		},
																	},
																},
																Name: "json",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   32,
																		},
																		File:   "http_endpoint_test.flux",
																		Source: "encode",
																		Start: ast.Position{
																			Column: 44,
																			Line:   32,
																		},
																	},
																},
																Name: "encode",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   32,
													},
													File:   "http_endpoint_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 25,
														Line:   32,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   32,
														},
														File:   "http_endpoint_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   32,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   32,
									},
									File:   "http_endpoint_test.flux",
									Source: "endpoint(mapFn: (r) => ({data: json.encode(v: r)}))",
									Start: ast.Position{
										Column: 8,
										Line:   32,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   32,
										},
										File:   "http_endpoint_test.flux",
										Source: "endpoint",
										Start: ast.Position{
											Column: 8,
											Line:   32,
										},
									},
								},
								Name: "endpoint",
							},
							Lparen: nil,
							Rparen: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   29,
							},
							File:   "http_endpoint_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 9,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   29,
								},
								File:   "http_endpoint_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 9,
									Line:   29,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   29,
							},
							File:   "http_endpoint_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 15,
								Line:   29,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   34,
						},
						File:   "http_endpoint_test.flux",
						Source: "_post = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
						Start: ast.Position{
							Column: 6,
							Line:   34,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   34,
							},
							File:   "http_endpoint_test.flux",
							Source: "_post",
							Start: ast.Position{
								Column: 6,
								Line:   34,
							},
						},
					},
					Name: "_post",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   34,
							},
							File:   "http_endpoint_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
							Start: ast.Position{
								Column: 14,
								Line:   34,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   34,
								},
								File:   "http_endpoint_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
								Start: ast.Position{
									Column: 20,
									Line:   34,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   34,
									},
									File:   "http_endpoint_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post}",
									Start: ast.Position{
										Column: 21,
										Line:   34,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   34,
										},
										File:   "http_endpoint_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 22,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   34,
											},
											File:   "http_endpoint_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 22,
												Line:   34,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   34,
												},
												File:   "http_endpoint_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 49,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   34,
													},
													File:   "http_endpoint_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 49,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   34,
														},
														File:   "http_endpoint_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 49,
															Line:   34,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   34,
														},
														File:   "http_endpoint_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 54,
															Line:   34,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   34,
											},
											File:   "http_endpoint_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 29,
												Line:   34,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   34,
												},
												File:   "http_endpoint_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 29,
													Line:   34,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   34,
													},
													File:   "http_endpoint_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 29,
														Line:   34,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   34,
													},
													File:   "http_endpoint_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 37,
														Line:   34,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   34,
										},
										File:   "http_endpoint_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 63,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   34,
											},
											File:   "http_endpoint_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 63,
												Line:   34,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 97,
													Line:   34,
												},
												File:   "http_endpoint_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 85,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 97,
														Line:   34,
													},
													File:   "http_endpoint_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 85,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   34,
														},
														File:   "http_endpoint_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 85,
															Line:   34,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   34,
														},
														File:   "http_endpoint_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 90,
															Line:   34,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   34,
											},
											File:   "http_endpoint_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 69,
												Line:   34,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   34,
												},
												File:   "http_endpoint_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 69,
													Line:   34,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   34,
													},
													File:   "http_endpoint_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 69,
														Line:   34,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   34,
													},
													File:   "http_endpoint_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 77,
														Line:   34,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   34,
										},
										File:   "http_endpoint_test.flux",
										Source: "fn: post",
										Start: ast.Position{
											Column: 100,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   34,
											},
											File:   "http_endpoint_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 100,
												Line:   34,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   34,
											},
											File:   "http_endpoint_test.flux",
											Source: "post",
											Start: ast.Position{
												Column: 104,
												Line:   34,
											},
										},
									},
									Name: "post",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 110,
						Line:   34,
					},
					File:   "http_endpoint_test.flux",
					Source: "test _post = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "http_endpoint_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "http_endpoint_test.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   6,
					},
					File:   "http_endpoint_test.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   6,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "http_endpoint_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "http_endpoint_test.flux",
					Source: "package http_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "http_endpoint_test.flux",
						Source: "http_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "http_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 129,
					Line:   33,
				},
				File:   "http_path_encode_endpoint_test.flux",
				Source: "package http_test\n\n\nimport \"testing\"\nimport \"http\"\nimport \"json\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/hellohi!@#\n,,1,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,./random$^%\n,,2,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/#$name#$\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,./random$^%,.%2Frandom$%5E%25\n,,1,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/#$name#$,%2F%23$name%23$\n,,2,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/hellohi!@#,%2Fhellohi%21@%23\n\"\npath_encode_test = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _sent: http.pathEscape(inputString: r.path)}))\n\ntest _path_encode = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: path_encode_test})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "http_path_encode_endpoint_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "http_path_encode_endpoint_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "http_path_encode_endpoint_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/hellohi!@#\n,,1,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,./random$^%\n,,2,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/#$name#$\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/hellohi!@#\n,,1,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,./random$^%\n,,2,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/#$name#$\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/hellohi!@#\n,,1,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,./random$^%\n,,2,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/#$name#$\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,./random$^%,.%2Frandom$%5E%25\n,,1,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/#$name#$,%2F%23$name%23$\n,,2,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/hellohi!@#,%2Fhellohi%21@%23\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   19,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   19,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,./random$^%,.%2Frandom$%5E%25\n,,1,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/#$name#$,%2F%23$name%23$\n,,2,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/hellohi!@#,%2Fhellohi%21@%23\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   19,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,./random$^%,.%2Frandom$%5E%25\n,,1,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/#$name#$,%2F%23$name%23$\n,,2,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/hellohi!@#,%2Fhellohi%21@%23\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 78,
						Line:   31,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "path_encode_test = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _sent: http.pathEscape(inputString: r.path)}))",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   28,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "path_encode_test",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "path_encode_test",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 78,
							Line:   31,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _sent: http.pathEscape(inputString: r.path)}))",
						Start: ast.Position{
							Column: 20,
							Line:   28,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   28,
										},
										File:   "http_path_encode_endpoint_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 34,
											Line:   28,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   29,
									},
									File:   "http_path_encode_endpoint_test.flux",
									Source: "table\n    |> range(start: 2018-05-22T00:00:00Z)",
									Start: ast.Position{
										Column: 34,
										Line:   28,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   29,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "start: 2018-05-22T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   29,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   29,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "start: 2018-05-22T00:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   29,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   29,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   29,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   29,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "2018-05-22T00:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   29,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   29,
										},
										File:   "http_path_encode_endpoint_test.flux",
										Source: "range(start: 2018-05-22T00:00:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   29,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   29,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   29,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   30,
								},
								File:   "http_path_encode_endpoint_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 34,
									Line:   28,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   30,
										},
										File:   "http_path_encode_endpoint_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   30,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   30,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 13,
												Line:   30,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   30,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   30,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   30,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 22,
													Line:   30,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   30,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   30,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   30,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   30,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   30,
									},
									File:   "http_path_encode_endpoint_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 8,
										Line:   30,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   30,
										},
										File:   "http_path_encode_endpoint_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   30,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   31,
							},
							File:   "http_path_encode_endpoint_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T00:00:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _sent: http.pathEscape(inputString: r.path)}))",
							Start: ast.Position{
								Column: 34,
								Line:   28,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   31,
									},
									File:   "http_path_encode_endpoint_test.flux",
									Source: "fn: (r) => ({r with _sent: http.pathEscape(inputString: r.path)})",
									Start: ast.Position{
										Column: 12,
										Line:   31,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   31,
										},
										File:   "http_path_encode_endpoint_test.flux",
										Source: "fn: (r) => ({r with _sent: http.pathEscape(inputString: r.path)})",
										Start: ast.Position{
											Column: 12,
											Line:   31,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   31,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   31,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   31,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "(r) => ({r with _sent: http.pathEscape(inputString: r.path)})",
											Start: ast.Position{
												Column: 16,
												Line:   31,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   31,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "({r with _sent: http.pathEscape(inputString: r.path)})",
												Start: ast.Position{
													Column: 23,
													Line:   31,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   31,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "{r with _sent: http.pathEscape(inputString: r.path)}",
													Start: ast.Position{
														Column: 24,
														Line:   31,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   31,
														},
														File:   "http_path_encode_endpoint_test.flux",
														Source: "_sent: http.pathEscape(inputString: r.path)",
														Start: ast.Position{
															Column: 32,
															Line:   31,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   31,
															},
															File:   "http_path_encode_endpoint_test.flux",
															Source: "_sent",
															Start: ast.Position{
																Column: 32,
																Line:   31,
															},
														},
													},
													Name: "_sent",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   31,
																},
																File:   "http_path_encode_endpoint_test.flux",
																Source: "inputString: r.path",
																Start: ast.Position{
																	Column: 55,
																	Line:   31,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   31,
																	},
																	File:   "http_path_encode_endpoint_test.flux",
																	Source: "inputString: r.path",
																	Start: ast.Position{
																		Column: 55,
																		Line:   31,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   31,
																		},
																		File:   "http_path_encode_endpoint_test.flux",
																		Source: "inputString",
																		Start: ast.Position{
																			Column: 55,
																			Line:   31,
																		},
																	},
																},
																Name: "inputString",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   31,
																		},
																		File:   "http_path_encode_endpoint_test.flux",
																		Source: "r.path",
																		Start: ast.Position{
																			Column: 68,
																			Line:   31,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   31,
																			},
																			File:   "http_path_encode_endpoint_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 68,
																				Line:   31,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   31,
																			},
																			File:   "http_path_encode_endpoint_test.flux",
																			Source: "path",
																			Start: ast.Position{
																				Column: 70,
																				Line:   31,
																			},
																		},
																	},
																	Name: "path",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   31,
															},
															File:   "http_path_encode_endpoint_test.flux",
															Source: "http.pathEscape(inputString: r.path)",
															Start: ast.Position{
																Column: 39,
																Line:   31,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   31,
																},
																File:   "http_path_encode_endpoint_test.flux",
																Source: "http.pathEscape",
																Start: ast.Position{
																	Column: 39,
																	Line:   31,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   31,
																	},
																	File:   "http_path_encode_endpoint_test.flux",
																	Source: "http",
																	Start: ast.Position{
																		Column: 39,
																		Line:   31,
																	},
																},
															},
															Name: "http",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   31,
																	},
																	File:   "http_path_encode_endpoint_test.flux",
																	Source: "pathEscape",
																	Start: ast.Position{
																		Column: 44,
																		Line:   31,
																	},
																},
															},
															Name: "pathEscape",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   31,
														},
														File:   "http_path_encode_endpoint_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   31,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   31,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   31,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   31,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   31,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   31,
								},
								File:   "http_path_encode_endpoint_test.flux",
								Source: "map(fn: (r) => ({r with _sent: http.pathEscape(inputString: r.path)}))",
								Start: ast.Position{
									Column: 8,
									Line:   31,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   31,
									},
									File:   "http_path_encode_endpoint_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   31,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   28,
							},
							File:   "http_path_encode_endpoint_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   28,
								},
								File:   "http_path_encode_endpoint_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   28,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   28,
							},
							File:   "http_path_encode_endpoint_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   28,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 129,
							Line:   33,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "_path_encode = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: path_encode_test})",
						Start: ast.Position{
							Column: 6,
							Line:   33,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   33,
							},
							File:   "http_path_encode_endpoint_test.flux",
							Source: "_path_encode",
							Start: ast.Position{
								Column: 6,
								Line:   33,
							},
						},
					},
					Name: "_path_encode",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 129,
								Line:   33,
							},
							File:   "http_path_encode_endpoint_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: path_encode_test})",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 129,
									Line:   33,
								},
								File:   "http_path_encode_endpoint_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: path_encode_test})",
								Start: ast.Position{
									Column: 27,
									Line:   33,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 128,
										Line:   33,
									},
									File:   "http_path_encode_endpoint_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: path_encode_test}",
									Start: ast.Position{
										Column: 28,
										Line:   33,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   33,
										},
										File:   "http_path_encode_endpoint_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 29,
											Line:   33,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   33,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 29,
												Line:   33,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   33,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 56,
													Line:   33,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   33,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 56,
														Line:   33,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   33,
														},
														File:   "http_path_encode_endpoint_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 56,
															Line:   33,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   33,
														},
														File:   "http_path_encode_endpoint_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 61,
															Line:   33,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   33,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 36,
												Line:   33,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   33,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 36,
													Line:   33,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   33,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 36,
														Line:   33,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   33,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 44,
														Line:   33,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 105,
											Line:   33,
										},
										File:   "http_path_encode_endpoint_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 70,
											Line:   33,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   33,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 70,
												Line:   33,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 104,
													Line:   33,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 92,
													Line:   33,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 104,
														Line:   33,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 92,
														Line:   33,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   33,
														},
														File:   "http_path_encode_endpoint_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 92,
															Line:   33,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   33,
														},
														File:   "http_path_encode_endpoint_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 97,
															Line:   33,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 105,
												Line:   33,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 76,
												Line:   33,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   33,
												},
												File:   "http_path_encode_endpoint_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 76,
													Line:   33,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   33,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 76,
														Line:   33,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   33,
													},
													File:   "http_path_encode_endpoint_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 84,
														Line:   33,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 127,
											Line:   33,
										},
										File:   "http_path_encode_endpoint_test.flux",
										Source: "fn: path_encode_test",
										Start: ast.Position{
											Column: 107,
											Line:   33,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   33,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 107,
												Line:   33,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 127,
												Line:   33,
											},
											File:   "http_path_encode_endpoint_test.flux",
											Source: "path_encode_test",
											Start: ast.Position{
												Column: 111,
												Line:   33,
											},
										},
									},
									Name: "path_encode_test",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 129,
						Line:   33,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "test _path_encode = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: path_encode_test})",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   6,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   6,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "http_path_encode_endpoint_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "http_path_encode_endpoint_test.flux",
					Source: "package http_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "http_path_encode_endpoint_test.flux",
						Source: "http_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "http_test",
			},
		},
	}},
	Package: "http_test",
	Path:    "http",
}}
