// DO NOT EDIT: This file is autogenerated via the builtin command.

package monitor

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 121,
					Line:   58,
				},
				File:   "check_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/v1\"\nimport \"testing\"\n\noption now = () => 2018-05-22T19:54:20Z\noption monitor.write = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,cpu,host\n,,0,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:46Z,4.9,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:56Z,4.7,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:54:06Z,7.0,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:54:16Z,7.1,usage_idle,cpu,cpu-total,host.local\n\"\noutData = \"\n#datatype,string,long,string,string,string,string,string,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,true,true,false,true,false,false,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle\n,,0,000000000000000a,cpu threshold check,crit,statuses,whoa!,cpu,1527018840000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,whoa!,cpu,1527018820000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,whoa!,cpu,1527018860000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05\n\"\ndata = {\n    _check_id: \"000000000000000a\",\n    _check_name: \"cpu threshold check\",\n    _type: \"threshold\",\n    tags: {aaa: \"vaaa\", bbb: \"vbbb\"},\n}\ncrit = (r) => r.usage_idle < 5.0\nwarn = (r) => r.usage_idle < 10.0\ninfo = (r) => r.usage_idle < 25.0\nmessageFn = (r) => \"whoa!\"\nt_check = (table=<-) => table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")\n    |> filter(fn: (r) => r._field == \"usage_idle\")\n    |> filter(fn: (r) => r.cpu == \"cpu-total\")\n    // pivot data so there is a \"usage_idle\" column\n    |> v1.fieldsAsCols()\n    |> aggregateWindow(every: 20s, fn: mean, column: \"usage_idle\")\n    |> monitor.check(\n        data: data,\n        messageFn: messageFn,\n        info: info,\n        warn: warn,\n        crit: crit,\n    )\n\ntest monitor_check = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_check})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "check_test.flux",
						Source: "now = () => 2018-05-22T19:54:20Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "check_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "check_test.flux",
							Source: "() => 2018-05-22T19:54:20Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "check_test.flux",
								Source: "2018-05-22T19:54:20Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2018-05-22T19:54:20Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "check_test.flux",
					Source: "option now = () => 2018-05-22T19:54:20Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 83,
							Line:   9,
						},
						File:   "check_test.flux",
						Source: "monitor.write = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   9,
							},
							File:   "check_test.flux",
							Source: "(tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 24,
								Line:   9,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   9,
									},
									File:   "check_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 39,
										Line:   9,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   9,
								},
								File:   "check_test.flux",
								Source: "tables |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 39,
									Line:   9,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   9,
										},
										File:   "check_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 54,
											Line:   9,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   9,
											},
											File:   "check_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 54,
												Line:   9,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   9,
												},
												File:   "check_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 54,
													Line:   9,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   9,
												},
												File:   "check_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 63,
													Line:   9,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   9,
													},
													File:   "check_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 64,
														Line:   9,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 81,
														Line:   9,
													},
													File:   "check_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 74,
														Line:   9,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   9,
									},
									File:   "check_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 49,
										Line:   9,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   9,
										},
										File:   "check_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 49,
											Line:   9,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   9,
								},
								File:   "check_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   9,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   9,
									},
									File:   "check_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   9,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   9,
								},
								File:   "check_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   9,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   9,
							},
							File:   "check_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   9,
								},
								File:   "check_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   9,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   9,
								},
								File:   "check_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   9,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 83,
						Line:   9,
					},
					File:   "check_test.flux",
					Source: "option monitor.write = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   22,
					},
					File:   "check_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,cpu,host\n,,0,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:46Z,4.9,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:56Z,4.7,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:54:06Z,7.0,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:54:16Z,7.1,usage_idle,cpu,cpu-total,host.local\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   11,
						},
						File:   "check_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   11,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   22,
						},
						File:   "check_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,cpu,host\n,,0,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:46Z,4.9,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:56Z,4.7,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:54:06Z,7.0,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:54:16Z,7.1,usage_idle,cpu,cpu-total,host.local\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   11,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,cpu,host\n,,0,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:46Z,4.9,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:53:56Z,4.7,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:54:06Z,7.0,usage_idle,cpu,cpu-total,host.local\n,,0,2018-05-22T19:54:16Z,7.1,usage_idle,cpu,cpu-total,host.local\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "check_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,string,string,string,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,true,true,false,true,false,false,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle\n,,0,000000000000000a,cpu threshold check,crit,statuses,whoa!,cpu,1527018840000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,whoa!,cpu,1527018820000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,whoa!,cpu,1527018860000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   23,
						},
						File:   "check_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   23,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "check_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,string,string,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,true,true,false,true,false,false,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle\n,,0,000000000000000a,cpu threshold check,crit,statuses,whoa!,cpu,1527018840000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,whoa!,cpu,1527018820000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,whoa!,cpu,1527018860000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   23,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,string,string,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,true,true,false,true,false,false,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle\n,,0,000000000000000a,cpu threshold check,crit,statuses,whoa!,cpu,1527018840000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,whoa!,cpu,1527018820000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,whoa!,cpu,1527018860000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   37,
					},
					File:   "check_test.flux",
					Source: "data = {\n    _check_id: \"000000000000000a\",\n    _check_name: \"cpu threshold check\",\n    _type: \"threshold\",\n    tags: {aaa: \"vaaa\", bbb: \"vbbb\"},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   32,
						},
						File:   "check_test.flux",
						Source: "data",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "data",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   37,
						},
						File:   "check_test.flux",
						Source: "{\n    _check_id: \"000000000000000a\",\n    _check_name: \"cpu threshold check\",\n    _type: \"threshold\",\n    tags: {aaa: \"vaaa\", bbb: \"vbbb\"},\n}",
						Start: ast.Position{
							Column: 8,
							Line:   32,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   33,
							},
							File:   "check_test.flux",
							Source: "_check_id: \"000000000000000a\"",
							Start: ast.Position{
								Column: 5,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   33,
								},
								File:   "check_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 5,
									Line:   33,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   33,
								},
								File:   "check_test.flux",
								Source: "\"000000000000000a\"",
								Start: ast.Position{
									Column: 16,
									Line:   33,
								},
							},
						},
						Value: "000000000000000a",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   34,
							},
							File:   "check_test.flux",
							Source: "_check_name: \"cpu threshold check\"",
							Start: ast.Position{
								Column: 5,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   34,
								},
								File:   "check_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 5,
									Line:   34,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   34,
								},
								File:   "check_test.flux",
								Source: "\"cpu threshold check\"",
								Start: ast.Position{
									Column: 18,
									Line:   34,
								},
							},
						},
						Value: "cpu threshold check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   35,
							},
							File:   "check_test.flux",
							Source: "_type: \"threshold\"",
							Start: ast.Position{
								Column: 5,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   35,
								},
								File:   "check_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 5,
									Line:   35,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   35,
								},
								File:   "check_test.flux",
								Source: "\"threshold\"",
								Start: ast.Position{
									Column: 12,
									Line:   35,
								},
							},
						},
						Value: "threshold",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   36,
							},
							File:   "check_test.flux",
							Source: "tags: {aaa: \"vaaa\", bbb: \"vbbb\"}",
							Start: ast.Position{
								Column: 5,
								Line:   36,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   36,
								},
								File:   "check_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 5,
									Line:   36,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   36,
								},
								File:   "check_test.flux",
								Source: "{aaa: \"vaaa\", bbb: \"vbbb\"}",
								Start: ast.Position{
									Column: 11,
									Line:   36,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   36,
									},
									File:   "check_test.flux",
									Source: "aaa: \"vaaa\"",
									Start: ast.Position{
										Column: 12,
										Line:   36,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   36,
										},
										File:   "check_test.flux",
										Source: "aaa",
										Start: ast.Position{
											Column: 12,
											Line:   36,
										},
									},
								},
								Name: "aaa",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   36,
										},
										File:   "check_test.flux",
										Source: "\"vaaa\"",
										Start: ast.Position{
											Column: 17,
											Line:   36,
										},
									},
								},
								Value: "vaaa",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   36,
									},
									File:   "check_test.flux",
									Source: "bbb: \"vbbb\"",
									Start: ast.Position{
										Column: 25,
										Line:   36,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   36,
										},
										File:   "check_test.flux",
										Source: "bbb",
										Start: ast.Position{
											Column: 25,
											Line:   36,
										},
									},
								},
								Name: "bbb",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   36,
										},
										File:   "check_test.flux",
										Source: "\"vbbb\"",
										Start: ast.Position{
											Column: 30,
											Line:   36,
										},
									},
								},
								Value: "vbbb",
							},
						}},
						Rbrace: nil,
						With:   nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   38,
					},
					File:   "check_test.flux",
					Source: "crit = (r) => r.usage_idle < 5.0",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   38,
						},
						File:   "check_test.flux",
						Source: "crit",
						Start: ast.Position{
							Column: 1,
							Line:   38,
						},
					},
				},
				Name: "crit",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   38,
						},
						File:   "check_test.flux",
						Source: "(r) => r.usage_idle < 5.0",
						Start: ast.Position{
							Column: 8,
							Line:   38,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   38,
							},
							File:   "check_test.flux",
							Source: "r.usage_idle < 5.0",
							Start: ast.Position{
								Column: 15,
								Line:   38,
							},
						},
					},
					Left: &ast.MemberExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   38,
								},
								File:   "check_test.flux",
								Source: "r.usage_idle",
								Start: ast.Position{
									Column: 15,
									Line:   38,
								},
							},
						},
						Lbrack: nil,
						Object: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   38,
									},
									File:   "check_test.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   38,
									},
								},
							},
							Name: "r",
						},
						Property: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   38,
									},
									File:   "check_test.flux",
									Source: "usage_idle",
									Start: ast.Position{
										Column: 17,
										Line:   38,
									},
								},
							},
							Name: "usage_idle",
						},
						Rbrack: nil,
					},
					Operator: 8,
					Right: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   38,
								},
								File:   "check_test.flux",
								Source: "5.0",
								Start: ast.Position{
									Column: 30,
									Line:   38,
								},
							},
						},
						Value: 5.0,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   38,
							},
							File:   "check_test.flux",
							Source: "r",
							Start: ast.Position{
								Column: 9,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   38,
								},
								File:   "check_test.flux",
								Source: "r",
								Start: ast.Position{
									Column: 9,
									Line:   38,
								},
							},
						},
						Name: "r",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 34,
						Line:   39,
					},
					File:   "check_test.flux",
					Source: "warn = (r) => r.usage_idle < 10.0",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   39,
						},
						File:   "check_test.flux",
						Source: "warn",
						Start: ast.Position{
							Column: 1,
							Line:   39,
						},
					},
				},
				Name: "warn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   39,
						},
						File:   "check_test.flux",
						Source: "(r) => r.usage_idle < 10.0",
						Start: ast.Position{
							Column: 8,
							Line:   39,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   39,
							},
							File:   "check_test.flux",
							Source: "r.usage_idle < 10.0",
							Start: ast.Position{
								Column: 15,
								Line:   39,
							},
						},
					},
					Left: &ast.MemberExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   39,
								},
								File:   "check_test.flux",
								Source: "r.usage_idle",
								Start: ast.Position{
									Column: 15,
									Line:   39,
								},
							},
						},
						Lbrack: nil,
						Object: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   39,
									},
									File:   "check_test.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   39,
									},
								},
							},
							Name: "r",
						},
						Property: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   39,
									},
									File:   "check_test.flux",
									Source: "usage_idle",
									Start: ast.Position{
										Column: 17,
										Line:   39,
									},
								},
							},
							Name: "usage_idle",
						},
						Rbrack: nil,
					},
					Operator: 8,
					Right: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   39,
								},
								File:   "check_test.flux",
								Source: "10.0",
								Start: ast.Position{
									Column: 30,
									Line:   39,
								},
							},
						},
						Value: 10.0,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   39,
							},
							File:   "check_test.flux",
							Source: "r",
							Start: ast.Position{
								Column: 9,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   39,
								},
								File:   "check_test.flux",
								Source: "r",
								Start: ast.Position{
									Column: 9,
									Line:   39,
								},
							},
						},
						Name: "r",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 34,
						Line:   40,
					},
					File:   "check_test.flux",
					Source: "info = (r) => r.usage_idle < 25.0",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   40,
						},
						File:   "check_test.flux",
						Source: "info",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "info",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   40,
						},
						File:   "check_test.flux",
						Source: "(r) => r.usage_idle < 25.0",
						Start: ast.Position{
							Column: 8,
							Line:   40,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   40,
							},
							File:   "check_test.flux",
							Source: "r.usage_idle < 25.0",
							Start: ast.Position{
								Column: 15,
								Line:   40,
							},
						},
					},
					Left: &ast.MemberExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   40,
								},
								File:   "check_test.flux",
								Source: "r.usage_idle",
								Start: ast.Position{
									Column: 15,
									Line:   40,
								},
							},
						},
						Lbrack: nil,
						Object: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   40,
									},
									File:   "check_test.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   40,
									},
								},
							},
							Name: "r",
						},
						Property: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   40,
									},
									File:   "check_test.flux",
									Source: "usage_idle",
									Start: ast.Position{
										Column: 17,
										Line:   40,
									},
								},
							},
							Name: "usage_idle",
						},
						Rbrack: nil,
					},
					Operator: 8,
					Right: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   40,
								},
								File:   "check_test.flux",
								Source: "25.0",
								Start: ast.Position{
									Column: 30,
									Line:   40,
								},
							},
						},
						Value: 25.0,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   40,
							},
							File:   "check_test.flux",
							Source: "r",
							Start: ast.Position{
								Column: 9,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   40,
								},
								File:   "check_test.flux",
								Source: "r",
								Start: ast.Position{
									Column: 9,
									Line:   40,
								},
							},
						},
						Name: "r",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   41,
					},
					File:   "check_test.flux",
					Source: "messageFn = (r) => \"whoa!\"",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   41,
						},
						File:   "check_test.flux",
						Source: "messageFn",
						Start: ast.Position{
							Column: 1,
							Line:   41,
						},
					},
				},
				Name: "messageFn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   41,
						},
						File:   "check_test.flux",
						Source: "(r) => \"whoa!\"",
						Start: ast.Position{
							Column: 13,
							Line:   41,
						},
					},
				},
				Body: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   41,
							},
							File:   "check_test.flux",
							Source: "\"whoa!\"",
							Start: ast.Position{
								Column: 20,
								Line:   41,
							},
						},
					},
					Value: "whoa!",
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   41,
							},
							File:   "check_test.flux",
							Source: "r",
							Start: ast.Position{
								Column: 14,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   41,
								},
								File:   "check_test.flux",
								Source: "r",
								Start: ast.Position{
									Column: 14,
									Line:   41,
								},
							},
						},
						Name: "r",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   56,
					},
					File:   "check_test.flux",
					Source: "t_check = (table=<-) => table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")\n    |> filter(fn: (r) => r._field == \"usage_idle\")\n    |> filter(fn: (r) => r.cpu == \"cpu-total\")\n    // pivot data so there is a \"usage_idle\" column\n    |> v1.fieldsAsCols()\n    |> aggregateWindow(every: 20s, fn: mean, column: \"usage_idle\")\n    |> monitor.check(\n        data: data,\n        messageFn: messageFn,\n        info: info,\n        warn: warn,\n        crit: crit,\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   42,
						},
						File:   "check_test.flux",
						Source: "t_check",
						Start: ast.Position{
							Column: 1,
							Line:   42,
						},
					},
				},
				Name: "t_check",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   56,
						},
						File:   "check_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")\n    |> filter(fn: (r) => r._field == \"usage_idle\")\n    |> filter(fn: (r) => r.cpu == \"cpu-total\")\n    // pivot data so there is a \"usage_idle\" column\n    |> v1.fieldsAsCols()\n    |> aggregateWindow(every: 20s, fn: mean, column: \"usage_idle\")\n    |> monitor.check(\n        data: data,\n        messageFn: messageFn,\n        info: info,\n        warn: warn,\n        crit: crit,\n    )",
						Start: ast.Position{
							Column: 11,
							Line:   42,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   42,
														},
														File:   "check_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 25,
															Line:   42,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   43,
													},
													File:   "check_test.flux",
													Source: "table\n    |> range(start: -1m)",
													Start: ast.Position{
														Column: 25,
														Line:   42,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   43,
															},
															File:   "check_test.flux",
															Source: "start: -1m",
															Start: ast.Position{
																Column: 14,
																Line:   43,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   43,
																},
																File:   "check_test.flux",
																Source: "start: -1m",
																Start: ast.Position{
																	Column: 14,
																	Line:   43,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   43,
																	},
																	File:   "check_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 14,
																		Line:   43,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.UnaryExpression{
															Argument: &ast.DurationLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   43,
																		},
																		File:   "check_test.flux",
																		Source: "1m",
																		Start: ast.Position{
																			Column: 22,
																			Line:   43,
																		},
																	},
																},
																Values: []ast.Duration{ast.Duration{
																	Magnitude: int64(1),
																	Unit:      "m",
																}},
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   43,
																	},
																	File:   "check_test.flux",
																	Source: "-1m",
																	Start: ast.Position{
																		Column: 21,
																		Line:   43,
																	},
																},
															},
															Operator: 6,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   43,
														},
														File:   "check_test.flux",
														Source: "range(start: -1m)",
														Start: ast.Position{
															Column: 8,
															Line:   43,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   43,
															},
															File:   "check_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 8,
																Line:   43,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   44,
												},
												File:   "check_test.flux",
												Source: "table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")",
												Start: ast.Position{
													Column: 25,
													Line:   42,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   44,
														},
														File:   "check_test.flux",
														Source: "fn: (r) => r._measurement == \"cpu\"",
														Start: ast.Position{
															Column: 15,
															Line:   44,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   44,
															},
															File:   "check_test.flux",
															Source: "fn: (r) => r._measurement == \"cpu\"",
															Start: ast.Position{
																Column: 15,
																Line:   44,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   44,
																},
																File:   "check_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   44,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   44,
																},
																File:   "check_test.flux",
																Source: "(r) => r._measurement == \"cpu\"",
																Start: ast.Position{
																	Column: 19,
																	Line:   44,
																},
															},
														},
														Body: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   44,
																	},
																	File:   "check_test.flux",
																	Source: "r._measurement == \"cpu\"",
																	Start: ast.Position{
																		Column: 26,
																		Line:   44,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   44,
																		},
																		File:   "check_test.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 26,
																			Line:   44,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 27,
																				Line:   44,
																			},
																			File:   "check_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 26,
																				Line:   44,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   44,
																			},
																			File:   "check_test.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 28,
																				Line:   44,
																			},
																		},
																	},
																	Name: "_measurement",
																},
																Rbrack: nil,
															},
															Operator: 17,
															Right: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   44,
																		},
																		File:   "check_test.flux",
																		Source: "\"cpu\"",
																		Start: ast.Position{
																			Column: 44,
																			Line:   44,
																		},
																	},
																},
																Value: "cpu",
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   44,
																	},
																	File:   "check_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   44,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   44,
																		},
																		File:   "check_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   44,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   44,
													},
													File:   "check_test.flux",
													Source: "filter(fn: (r) => r._measurement == \"cpu\")",
													Start: ast.Position{
														Column: 8,
														Line:   44,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   44,
														},
														File:   "check_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   44,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   45,
											},
											File:   "check_test.flux",
											Source: "table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")\n    |> filter(fn: (r) => r._field == \"usage_idle\")",
											Start: ast.Position{
												Column: 25,
												Line:   42,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   45,
													},
													File:   "check_test.flux",
													Source: "fn: (r) => r._field == \"usage_idle\"",
													Start: ast.Position{
														Column: 15,
														Line:   45,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   45,
														},
														File:   "check_test.flux",
														Source: "fn: (r) => r._field == \"usage_idle\"",
														Start: ast.Position{
															Column: 15,
															Line:   45,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   45,
															},
															File:   "check_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 15,
																Line:   45,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   45,
															},
															File:   "check_test.flux",
															Source: "(r) => r._field == \"usage_idle\"",
															Start: ast.Position{
																Column: 19,
																Line:   45,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   45,
																},
																File:   "check_test.flux",
																Source: "r._field == \"usage_idle\"",
																Start: ast.Position{
																	Column: 26,
																	Line:   45,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   45,
																	},
																	File:   "check_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 26,
																		Line:   45,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 27,
																			Line:   45,
																		},
																		File:   "check_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 26,
																			Line:   45,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   45,
																		},
																		File:   "check_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 28,
																			Line:   45,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   45,
																	},
																	File:   "check_test.flux",
																	Source: "\"usage_idle\"",
																	Start: ast.Position{
																		Column: 38,
																		Line:   45,
																	},
																},
															},
															Value: "usage_idle",
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   45,
																},
																File:   "check_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 20,
																	Line:   45,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   45,
																	},
																	File:   "check_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   45,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   45,
												},
												File:   "check_test.flux",
												Source: "filter(fn: (r) => r._field == \"usage_idle\")",
												Start: ast.Position{
													Column: 8,
													Line:   45,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   45,
													},
													File:   "check_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 8,
														Line:   45,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   46,
										},
										File:   "check_test.flux",
										Source: "table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")\n    |> filter(fn: (r) => r._field == \"usage_idle\")\n    |> filter(fn: (r) => r.cpu == \"cpu-total\")",
										Start: ast.Position{
											Column: 25,
											Line:   42,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   46,
												},
												File:   "check_test.flux",
												Source: "fn: (r) => r.cpu == \"cpu-total\"",
												Start: ast.Position{
													Column: 15,
													Line:   46,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   46,
													},
													File:   "check_test.flux",
													Source: "fn: (r) => r.cpu == \"cpu-total\"",
													Start: ast.Position{
														Column: 15,
														Line:   46,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   46,
														},
														File:   "check_test.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 15,
															Line:   46,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   46,
														},
														File:   "check_test.flux",
														Source: "(r) => r.cpu == \"cpu-total\"",
														Start: ast.Position{
															Column: 19,
															Line:   46,
														},
													},
												},
												Body: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   46,
															},
															File:   "check_test.flux",
															Source: "r.cpu == \"cpu-total\"",
															Start: ast.Position{
																Column: 26,
																Line:   46,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   46,
																},
																File:   "check_test.flux",
																Source: "r.cpu",
																Start: ast.Position{
																	Column: 26,
																	Line:   46,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   46,
																	},
																	File:   "check_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 26,
																		Line:   46,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   46,
																	},
																	File:   "check_test.flux",
																	Source: "cpu",
																	Start: ast.Position{
																		Column: 28,
																		Line:   46,
																	},
																},
															},
															Name: "cpu",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   46,
																},
																File:   "check_test.flux",
																Source: "\"cpu-total\"",
																Start: ast.Position{
																	Column: 35,
																	Line:   46,
																},
															},
														},
														Value: "cpu-total",
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   46,
															},
															File:   "check_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   46,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   46,
																},
																File:   "check_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 20,
																	Line:   46,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   46,
											},
											File:   "check_test.flux",
											Source: "filter(fn: (r) => r.cpu == \"cpu-total\")",
											Start: ast.Position{
												Column: 8,
												Line:   46,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   46,
												},
												File:   "check_test.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 8,
													Line:   46,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// pivot data so there is a \"usage_idle\" column\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   48,
									},
									File:   "check_test.flux",
									Source: "table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")\n    |> filter(fn: (r) => r._field == \"usage_idle\")\n    |> filter(fn: (r) => r.cpu == \"cpu-total\")\n    // pivot data so there is a \"usage_idle\" column\n    |> v1.fieldsAsCols()",
									Start: ast.Position{
										Column: 25,
										Line:   42,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   48,
										},
										File:   "check_test.flux",
										Source: "v1.fieldsAsCols()",
										Start: ast.Position{
											Column: 8,
											Line:   48,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   48,
											},
											File:   "check_test.flux",
											Source: "v1.fieldsAsCols",
											Start: ast.Position{
												Column: 8,
												Line:   48,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   48,
												},
												File:   "check_test.flux",
												Source: "v1",
												Start: ast.Position{
													Column: 8,
													Line:   48,
												},
											},
										},
										Name: "v1",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   48,
												},
												File:   "check_test.flux",
												Source: "fieldsAsCols",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Name: "fieldsAsCols",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   49,
								},
								File:   "check_test.flux",
								Source: "table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")\n    |> filter(fn: (r) => r._field == \"usage_idle\")\n    |> filter(fn: (r) => r.cpu == \"cpu-total\")\n    // pivot data so there is a \"usage_idle\" column\n    |> v1.fieldsAsCols()\n    |> aggregateWindow(every: 20s, fn: mean, column: \"usage_idle\")",
								Start: ast.Position{
									Column: 25,
									Line:   42,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   49,
										},
										File:   "check_test.flux",
										Source: "every: 20s, fn: mean, column: \"usage_idle\"",
										Start: ast.Position{
											Column: 24,
											Line:   49,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   49,
											},
											File:   "check_test.flux",
											Source: "every: 20s",
											Start: ast.Position{
												Column: 24,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   49,
												},
												File:   "check_test.flux",
												Source: "every",
												Start: ast.Position{
													Column: 24,
													Line:   49,
												},
											},
										},
										Name: "every",
									},
									Separator: nil,
									Value: &ast.DurationLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   49,
												},
												File:   "check_test.flux",
												Source: "20s",
												Start: ast.Position{
													Column: 31,
													Line:   49,
												},
											},
										},
										Values: []ast.Duration{ast.Duration{
											Magnitude: int64(20),
											Unit:      "s",
										}},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   49,
											},
											File:   "check_test.flux",
											Source: "fn: mean",
											Start: ast.Position{
												Column: 36,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   49,
												},
												File:   "check_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 36,
													Line:   49,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   49,
												},
												File:   "check_test.flux",
												Source: "mean",
												Start: ast.Position{
													Column: 40,
													Line:   49,
												},
											},
										},
										Name: "mean",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   49,
											},
											File:   "check_test.flux",
											Source: "column: \"usage_idle\"",
											Start: ast.Position{
												Column: 46,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   49,
												},
												File:   "check_test.flux",
												Source: "column",
												Start: ast.Position{
													Column: 46,
													Line:   49,
												},
											},
										},
										Name: "column",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   49,
												},
												File:   "check_test.flux",
												Source: "\"usage_idle\"",
												Start: ast.Position{
													Column: 54,
													Line:   49,
												},
											},
										},
										Value: "usage_idle",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   49,
									},
									File:   "check_test.flux",
									Source: "aggregateWindow(every: 20s, fn: mean, column: \"usage_idle\")",
									Start: ast.Position{
										Column: 8,
										Line:   49,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   49,
										},
										File:   "check_test.flux",
										Source: "aggregateWindow",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Name: "aggregateWindow",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   56,
							},
							File:   "check_test.flux",
							Source: "table\n    |> range(start: -1m)\n    |> filter(fn: (r) => r._measurement == \"cpu\")\n    |> filter(fn: (r) => r._field == \"usage_idle\")\n    |> filter(fn: (r) => r.cpu == \"cpu-total\")\n    // pivot data so there is a \"usage_idle\" column\n    |> v1.fieldsAsCols()\n    |> aggregateWindow(every: 20s, fn: mean, column: \"usage_idle\")\n    |> monitor.check(\n        data: data,\n        messageFn: messageFn,\n        info: info,\n        warn: warn,\n        crit: crit,\n    )",
							Start: ast.Position{
								Column: 25,
								Line:   42,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   55,
									},
									File:   "check_test.flux",
									Source: "data: data,\n        messageFn: messageFn,\n        info: info,\n        warn: warn,\n        crit: crit",
									Start: ast.Position{
										Column: 9,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   51,
										},
										File:   "check_test.flux",
										Source: "data: data",
										Start: ast.Position{
											Column: 9,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   51,
											},
											File:   "check_test.flux",
											Source: "data",
											Start: ast.Position{
												Column: 9,
												Line:   51,
											},
										},
									},
									Name: "data",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   51,
											},
											File:   "check_test.flux",
											Source: "data",
											Start: ast.Position{
												Column: 15,
												Line:   51,
											},
										},
									},
									Name: "data",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   52,
										},
										File:   "check_test.flux",
										Source: "messageFn: messageFn",
										Start: ast.Position{
											Column: 9,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   52,
											},
											File:   "check_test.flux",
											Source: "messageFn",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Name: "messageFn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   52,
											},
											File:   "check_test.flux",
											Source: "messageFn",
											Start: ast.Position{
												Column: 20,
												Line:   52,
											},
										},
									},
									Name: "messageFn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   53,
										},
										File:   "check_test.flux",
										Source: "info: info",
										Start: ast.Position{
											Column: 9,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   53,
											},
											File:   "check_test.flux",
											Source: "info",
											Start: ast.Position{
												Column: 9,
												Line:   53,
											},
										},
									},
									Name: "info",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   53,
											},
											File:   "check_test.flux",
											Source: "info",
											Start: ast.Position{
												Column: 15,
												Line:   53,
											},
										},
									},
									Name: "info",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   54,
										},
										File:   "check_test.flux",
										Source: "warn: warn",
										Start: ast.Position{
											Column: 9,
											Line:   54,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   54,
											},
											File:   "check_test.flux",
											Source: "warn",
											Start: ast.Position{
												Column: 9,
												Line:   54,
											},
										},
									},
									Name: "warn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   54,
											},
											File:   "check_test.flux",
											Source: "warn",
											Start: ast.Position{
												Column: 15,
												Line:   54,
											},
										},
									},
									Name: "warn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   55,
										},
										File:   "check_test.flux",
										Source: "crit: crit",
										Start: ast.Position{
											Column: 9,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   55,
											},
											File:   "check_test.flux",
											Source: "crit",
											Start: ast.Position{
												Column: 9,
												Line:   55,
											},
										},
									},
									Name: "crit",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   55,
											},
											File:   "check_test.flux",
											Source: "crit",
											Start: ast.Position{
												Column: 15,
												Line:   55,
											},
										},
									},
									Name: "crit",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   56,
								},
								File:   "check_test.flux",
								Source: "monitor.check(\n        data: data,\n        messageFn: messageFn,\n        info: info,\n        warn: warn,\n        crit: crit,\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   50,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   50,
									},
									File:   "check_test.flux",
									Source: "monitor.check",
									Start: ast.Position{
										Column: 8,
										Line:   50,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   50,
										},
										File:   "check_test.flux",
										Source: "monitor",
										Start: ast.Position{
											Column: 8,
											Line:   50,
										},
									},
								},
								Name: "monitor",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   50,
										},
										File:   "check_test.flux",
										Source: "check",
										Start: ast.Position{
											Column: 16,
											Line:   50,
										},
									},
								},
								Name: "check",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   42,
							},
							File:   "check_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 12,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   42,
								},
								File:   "check_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 12,
									Line:   42,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   42,
							},
							File:   "check_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   42,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 121,
							Line:   58,
						},
						File:   "check_test.flux",
						Source: "monitor_check = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_check})",
						Start: ast.Position{
							Column: 6,
							Line:   58,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   58,
							},
							File:   "check_test.flux",
							Source: "monitor_check",
							Start: ast.Position{
								Column: 6,
								Line:   58,
							},
						},
					},
					Name: "monitor_check",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 121,
								Line:   58,
							},
							File:   "check_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_check})",
							Start: ast.Position{
								Column: 22,
								Line:   58,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 121,
									Line:   58,
								},
								File:   "check_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_check})",
								Start: ast.Position{
									Column: 28,
									Line:   58,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 120,
										Line:   58,
									},
									File:   "check_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_check}",
									Start: ast.Position{
										Column: 29,
										Line:   58,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   58,
										},
										File:   "check_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 30,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   58,
											},
											File:   "check_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 30,
												Line:   58,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   58,
												},
												File:   "check_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 57,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   58,
													},
													File:   "check_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 57,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   58,
														},
														File:   "check_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 57,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   58,
														},
														File:   "check_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 62,
															Line:   58,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   58,
											},
											File:   "check_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 37,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   58,
												},
												File:   "check_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 37,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   58,
													},
													File:   "check_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 37,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   58,
													},
													File:   "check_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 45,
														Line:   58,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 106,
											Line:   58,
										},
										File:   "check_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 71,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   58,
											},
											File:   "check_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 71,
												Line:   58,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 105,
													Line:   58,
												},
												File:   "check_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 93,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 105,
														Line:   58,
													},
													File:   "check_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 93,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 96,
															Line:   58,
														},
														File:   "check_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 93,
															Line:   58,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 105,
															Line:   58,
														},
														File:   "check_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 98,
															Line:   58,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 106,
												Line:   58,
											},
											File:   "check_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 77,
												Line:   58,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 92,
													Line:   58,
												},
												File:   "check_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 77,
													Line:   58,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   58,
													},
													File:   "check_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 77,
														Line:   58,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 92,
														Line:   58,
													},
													File:   "check_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 85,
														Line:   58,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 119,
											Line:   58,
										},
										File:   "check_test.flux",
										Source: "fn: t_check",
										Start: ast.Position{
											Column: 108,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   58,
											},
											File:   "check_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 108,
												Line:   58,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 119,
												Line:   58,
											},
											File:   "check_test.flux",
											Source: "t_check",
											Start: ast.Position{
												Column: 112,
												Line:   58,
											},
										},
									},
									Name: "t_check",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 121,
						Line:   58,
					},
					File:   "check_test.flux",
					Source: "test monitor_check = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_check})",
					Start: ast.Position{
						Column: 1,
						Line:   58,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   4,
					},
					File:   "check_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   4,
						},
						File:   "check_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   5,
					},
					File:   "check_test.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   5,
						},
						File:   "check_test.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "check_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "check_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "check_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "check_test.flux",
					Source: "package monitor_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "check_test.flux",
						Source: "monitor_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 125,
					Line:   50,
				},
				File:   "deadman_add_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"testing\"\nimport \"experimental\"\n\noption now = () => 2018-05-22T20:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_field,_measurement\n,,0,2018-05-22T19:30:00Z,11,A,cpu\n,,0,2018-05-22T18:30:00Z,11,A,cpu\n,,0,2018-05-22T17:30:00Z,11,A,cpu\n,,0,2018-05-22T16:30:00Z,11,A,cpu\n,,0,2018-05-22T15:30:00Z,11,A,cpu\n,,1,2018-05-22T15:30:00Z,11,B,cpu\n,,1,2018-05-22T16:30:00Z,11,B,cpu\n,,1,2018-05-22T17:30:00Z,11,B,cpu\n,,1,2018-05-22T18:30:00Z,11,B,cpu\n,,1,2018-05-22T19:30:00Z,11,B,cpu\n,,2,2018-05-22T18:30:00Z,11,C,cpu\n,,2,2018-05-22T14:30:00Z,11,C,cpu\n,,2,2018-05-22T17:30:00Z,11,C,cpu\n,,2,2018-05-22T15:30:00Z,11,C,cpu\n,,2,2018-05-22T16:30:00Z,11,C,cpu\n,,3,2018-05-22T18:30:00Z,11,D,cpu\n,,3,2018-05-22T15:30:00Z,11,D,cpu\n,,3,2018-05-22T19:30:00Z,11,D,cpu\n,,3,2018-05-22T16:30:00Z,11,D,cpu\n,,3,2018-05-22T17:30:00Z,11,D,cpu\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,boolean\n#group,false,false,true,true,false,false,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,dead\n,,0,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,A,cpu,false\n,,1,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,B,cpu,false\n,,2,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T18:30:00Z,11,C,cpu,true\n,,3,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,D,cpu,false\n\"\nt_deadman_add = (table=<-) => table\n    |> range(start: -5h)\n    |> monitor.deadman(t: experimental.addDuration(d: -1h, to: now()))\n\ntest deadman_add = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_add})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "deadman_add_test.flux",
						Source: "now = () => 2018-05-22T20:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "deadman_add_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "deadman_add_test.flux",
							Source: "() => 2018-05-22T20:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "deadman_add_test.flux",
								Source: "2018-05-22T20:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2018-05-22T20:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "deadman_add_test.flux",
					Source: "option now = () => 2018-05-22T20:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   35,
					},
					File:   "deadman_add_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_field,_measurement\n,,0,2018-05-22T19:30:00Z,11,A,cpu\n,,0,2018-05-22T18:30:00Z,11,A,cpu\n,,0,2018-05-22T17:30:00Z,11,A,cpu\n,,0,2018-05-22T16:30:00Z,11,A,cpu\n,,0,2018-05-22T15:30:00Z,11,A,cpu\n,,1,2018-05-22T15:30:00Z,11,B,cpu\n,,1,2018-05-22T16:30:00Z,11,B,cpu\n,,1,2018-05-22T17:30:00Z,11,B,cpu\n,,1,2018-05-22T18:30:00Z,11,B,cpu\n,,1,2018-05-22T19:30:00Z,11,B,cpu\n,,2,2018-05-22T18:30:00Z,11,C,cpu\n,,2,2018-05-22T14:30:00Z,11,C,cpu\n,,2,2018-05-22T17:30:00Z,11,C,cpu\n,,2,2018-05-22T15:30:00Z,11,C,cpu\n,,2,2018-05-22T16:30:00Z,11,C,cpu\n,,3,2018-05-22T18:30:00Z,11,D,cpu\n,,3,2018-05-22T15:30:00Z,11,D,cpu\n,,3,2018-05-22T19:30:00Z,11,D,cpu\n,,3,2018-05-22T16:30:00Z,11,D,cpu\n,,3,2018-05-22T17:30:00Z,11,D,cpu\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "deadman_add_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   35,
						},
						File:   "deadman_add_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,long,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_field,_measurement\n,,0,2018-05-22T19:30:00Z,11,A,cpu\n,,0,2018-05-22T18:30:00Z,11,A,cpu\n,,0,2018-05-22T17:30:00Z,11,A,cpu\n,,0,2018-05-22T16:30:00Z,11,A,cpu\n,,0,2018-05-22T15:30:00Z,11,A,cpu\n,,1,2018-05-22T15:30:00Z,11,B,cpu\n,,1,2018-05-22T16:30:00Z,11,B,cpu\n,,1,2018-05-22T17:30:00Z,11,B,cpu\n,,1,2018-05-22T18:30:00Z,11,B,cpu\n,,1,2018-05-22T19:30:00Z,11,B,cpu\n,,2,2018-05-22T18:30:00Z,11,C,cpu\n,,2,2018-05-22T14:30:00Z,11,C,cpu\n,,2,2018-05-22T17:30:00Z,11,C,cpu\n,,2,2018-05-22T15:30:00Z,11,C,cpu\n,,2,2018-05-22T16:30:00Z,11,C,cpu\n,,3,2018-05-22T18:30:00Z,11,D,cpu\n,,3,2018-05-22T15:30:00Z,11,D,cpu\n,,3,2018-05-22T19:30:00Z,11,D,cpu\n,,3,2018-05-22T16:30:00Z,11,D,cpu\n,,3,2018-05-22T17:30:00Z,11,D,cpu\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,long,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_field,_measurement\n,,0,2018-05-22T19:30:00Z,11,A,cpu\n,,0,2018-05-22T18:30:00Z,11,A,cpu\n,,0,2018-05-22T17:30:00Z,11,A,cpu\n,,0,2018-05-22T16:30:00Z,11,A,cpu\n,,0,2018-05-22T15:30:00Z,11,A,cpu\n,,1,2018-05-22T15:30:00Z,11,B,cpu\n,,1,2018-05-22T16:30:00Z,11,B,cpu\n,,1,2018-05-22T17:30:00Z,11,B,cpu\n,,1,2018-05-22T18:30:00Z,11,B,cpu\n,,1,2018-05-22T19:30:00Z,11,B,cpu\n,,2,2018-05-22T18:30:00Z,11,C,cpu\n,,2,2018-05-22T14:30:00Z,11,C,cpu\n,,2,2018-05-22T17:30:00Z,11,C,cpu\n,,2,2018-05-22T15:30:00Z,11,C,cpu\n,,2,2018-05-22T16:30:00Z,11,C,cpu\n,,3,2018-05-22T18:30:00Z,11,D,cpu\n,,3,2018-05-22T15:30:00Z,11,D,cpu\n,,3,2018-05-22T19:30:00Z,11,D,cpu\n,,3,2018-05-22T16:30:00Z,11,D,cpu\n,,3,2018-05-22T17:30:00Z,11,D,cpu\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   45,
					},
					File:   "deadman_add_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,boolean\n#group,false,false,true,true,false,false,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,dead\n,,0,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,A,cpu,false\n,,1,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,B,cpu,false\n,,2,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T18:30:00Z,11,C,cpu,true\n,,3,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,D,cpu,false\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   36,
						},
						File:   "deadman_add_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   45,
						},
						File:   "deadman_add_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,boolean\n#group,false,false,true,true,false,false,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,dead\n,,0,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,A,cpu,false\n,,1,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,B,cpu,false\n,,2,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T18:30:00Z,11,C,cpu,true\n,,3,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,D,cpu,false\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,boolean\n#group,false,false,true,true,false,false,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,dead\n,,0,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,A,cpu,false\n,,1,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,B,cpu,false\n,,2,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T18:30:00Z,11,C,cpu,true\n,,3,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,D,cpu,false\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 71,
						Line:   48,
					},
					File:   "deadman_add_test.flux",
					Source: "t_deadman_add = (table=<-) => table\n    |> range(start: -5h)\n    |> monitor.deadman(t: experimental.addDuration(d: -1h, to: now()))",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   46,
						},
						File:   "deadman_add_test.flux",
						Source: "t_deadman_add",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "t_deadman_add",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   48,
						},
						File:   "deadman_add_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -5h)\n    |> monitor.deadman(t: experimental.addDuration(d: -1h, to: now()))",
						Start: ast.Position{
							Column: 17,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   46,
									},
									File:   "deadman_add_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 31,
										Line:   46,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   47,
								},
								File:   "deadman_add_test.flux",
								Source: "table\n    |> range(start: -5h)",
								Start: ast.Position{
									Column: 31,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   47,
										},
										File:   "deadman_add_test.flux",
										Source: "start: -5h",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   47,
											},
											File:   "deadman_add_test.flux",
											Source: "start: -5h",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   47,
												},
												File:   "deadman_add_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.UnaryExpression{
										Argument: &ast.DurationLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   47,
													},
													File:   "deadman_add_test.flux",
													Source: "5h",
													Start: ast.Position{
														Column: 22,
														Line:   47,
													},
												},
											},
											Values: []ast.Duration{ast.Duration{
												Magnitude: int64(5),
												Unit:      "h",
											}},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   47,
												},
												File:   "deadman_add_test.flux",
												Source: "-5h",
												Start: ast.Position{
													Column: 21,
													Line:   47,
												},
											},
										},
										Operator: 6,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   47,
									},
									File:   "deadman_add_test.flux",
									Source: "range(start: -5h)",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "deadman_add_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   48,
							},
							File:   "deadman_add_test.flux",
							Source: "table\n    |> range(start: -5h)\n    |> monitor.deadman(t: experimental.addDuration(d: -1h, to: now()))",
							Start: ast.Position{
								Column: 31,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   48,
									},
									File:   "deadman_add_test.flux",
									Source: "t: experimental.addDuration(d: -1h, to: now())",
									Start: ast.Position{
										Column: 24,
										Line:   48,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   48,
										},
										File:   "deadman_add_test.flux",
										Source: "t: experimental.addDuration(d: -1h, to: now())",
										Start: ast.Position{
											Column: 24,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   48,
											},
											File:   "deadman_add_test.flux",
											Source: "t",
											Start: ast.Position{
												Column: 24,
												Line:   48,
											},
										},
									},
									Name: "t",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   48,
												},
												File:   "deadman_add_test.flux",
												Source: "d: -1h, to: now()",
												Start: ast.Position{
													Column: 52,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   48,
													},
													File:   "deadman_add_test.flux",
													Source: "d: -1h",
													Start: ast.Position{
														Column: 52,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   48,
														},
														File:   "deadman_add_test.flux",
														Source: "d",
														Start: ast.Position{
															Column: 52,
															Line:   48,
														},
													},
												},
												Name: "d",
											},
											Separator: nil,
											Value: &ast.UnaryExpression{
												Argument: &ast.DurationLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   48,
															},
															File:   "deadman_add_test.flux",
															Source: "1h",
															Start: ast.Position{
																Column: 56,
																Line:   48,
															},
														},
													},
													Values: []ast.Duration{ast.Duration{
														Magnitude: int64(1),
														Unit:      "h",
													}},
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   48,
														},
														File:   "deadman_add_test.flux",
														Source: "-1h",
														Start: ast.Position{
															Column: 55,
															Line:   48,
														},
													},
												},
												Operator: 6,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   48,
													},
													File:   "deadman_add_test.flux",
													Source: "to: now()",
													Start: ast.Position{
														Column: 60,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   48,
														},
														File:   "deadman_add_test.flux",
														Source: "to",
														Start: ast.Position{
															Column: 60,
															Line:   48,
														},
													},
												},
												Name: "to",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   48,
														},
														File:   "deadman_add_test.flux",
														Source: "now()",
														Start: ast.Position{
															Column: 64,
															Line:   48,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   48,
															},
															File:   "deadman_add_test.flux",
															Source: "now",
															Start: ast.Position{
																Column: 64,
																Line:   48,
															},
														},
													},
													Name: "now",
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   48,
											},
											File:   "deadman_add_test.flux",
											Source: "experimental.addDuration(d: -1h, to: now())",
											Start: ast.Position{
												Column: 27,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   48,
												},
												File:   "deadman_add_test.flux",
												Source: "experimental.addDuration",
												Start: ast.Position{
													Column: 27,
													Line:   48,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   48,
													},
													File:   "deadman_add_test.flux",
													Source: "experimental",
													Start: ast.Position{
														Column: 27,
														Line:   48,
													},
												},
											},
											Name: "experimental",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   48,
													},
													File:   "deadman_add_test.flux",
													Source: "addDuration",
													Start: ast.Position{
														Column: 40,
														Line:   48,
													},
												},
											},
											Name: "addDuration",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   48,
								},
								File:   "deadman_add_test.flux",
								Source: "monitor.deadman(t: experimental.addDuration(d: -1h, to: now()))",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   48,
									},
									File:   "deadman_add_test.flux",
									Source: "monitor.deadman",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   48,
										},
										File:   "deadman_add_test.flux",
										Source: "monitor",
										Start: ast.Position{
											Column: 8,
											Line:   48,
										},
									},
								},
								Name: "monitor",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   48,
										},
										File:   "deadman_add_test.flux",
										Source: "deadman",
										Start: ast.Position{
											Column: 16,
											Line:   48,
										},
									},
								},
								Name: "deadman",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "deadman_add_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 18,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   46,
								},
								File:   "deadman_add_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 18,
									Line:   46,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "deadman_add_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 125,
							Line:   50,
						},
						File:   "deadman_add_test.flux",
						Source: "deadman_add = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_add})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   50,
							},
							File:   "deadman_add_test.flux",
							Source: "deadman_add",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "deadman_add",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 125,
								Line:   50,
							},
							File:   "deadman_add_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_add})",
							Start: ast.Position{
								Column: 20,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 125,
									Line:   50,
								},
								File:   "deadman_add_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_add})",
								Start: ast.Position{
									Column: 26,
									Line:   50,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 124,
										Line:   50,
									},
									File:   "deadman_add_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_add}",
									Start: ast.Position{
										Column: 27,
										Line:   50,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   50,
										},
										File:   "deadman_add_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 28,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   50,
											},
											File:   "deadman_add_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 28,
												Line:   50,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   50,
												},
												File:   "deadman_add_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 55,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   50,
													},
													File:   "deadman_add_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 55,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   50,
														},
														File:   "deadman_add_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 55,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   50,
														},
														File:   "deadman_add_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 60,
															Line:   50,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   50,
											},
											File:   "deadman_add_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 35,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   50,
												},
												File:   "deadman_add_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 35,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   50,
													},
													File:   "deadman_add_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 35,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   50,
													},
													File:   "deadman_add_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 43,
														Line:   50,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   50,
										},
										File:   "deadman_add_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 69,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   50,
											},
											File:   "deadman_add_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 69,
												Line:   50,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 103,
													Line:   50,
												},
												File:   "deadman_add_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 91,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 103,
														Line:   50,
													},
													File:   "deadman_add_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 91,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 94,
															Line:   50,
														},
														File:   "deadman_add_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 91,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 103,
															Line:   50,
														},
														File:   "deadman_add_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 96,
															Line:   50,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   50,
											},
											File:   "deadman_add_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 75,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 90,
													Line:   50,
												},
												File:   "deadman_add_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 75,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   50,
													},
													File:   "deadman_add_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 75,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 90,
														Line:   50,
													},
													File:   "deadman_add_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 83,
														Line:   50,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 123,
											Line:   50,
										},
										File:   "deadman_add_test.flux",
										Source: "fn: t_deadman_add",
										Start: ast.Position{
											Column: 106,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   50,
											},
											File:   "deadman_add_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 106,
												Line:   50,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 123,
												Line:   50,
											},
											File:   "deadman_add_test.flux",
											Source: "t_deadman_add",
											Start: ast.Position{
												Column: 110,
												Line:   50,
											},
										},
									},
									Name: "t_deadman_add",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 125,
						Line:   50,
					},
					File:   "deadman_add_test.flux",
					Source: "test deadman_add = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_add})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   4,
					},
					File:   "deadman_add_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   4,
						},
						File:   "deadman_add_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "deadman_add_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "deadman_add_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   6,
					},
					File:   "deadman_add_test.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   6,
						},
						File:   "deadman_add_test.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "deadman_add_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "deadman_add_test.flux",
					Source: "package monitor_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "deadman_add_test.flux",
						Source: "monitor_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 125,
					Line:   50,
				},
				File:   "deadman_sub_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"testing\"\nimport \"experimental\"\n\noption now = () => 2018-05-22T20:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_field,_measurement\n,,0,2018-05-22T19:30:00Z,11,A,cpu\n,,0,2018-05-22T18:30:00Z,11,A,cpu\n,,0,2018-05-22T17:30:00Z,11,A,cpu\n,,0,2018-05-22T16:30:00Z,11,A,cpu\n,,0,2018-05-22T15:30:00Z,11,A,cpu\n,,1,2018-05-22T15:30:00Z,11,B,cpu\n,,1,2018-05-22T16:30:00Z,11,B,cpu\n,,1,2018-05-22T17:30:00Z,11,B,cpu\n,,1,2018-05-22T18:30:00Z,11,B,cpu\n,,1,2018-05-22T19:30:00Z,11,B,cpu\n,,2,2018-05-22T18:30:00Z,11,C,cpu\n,,2,2018-05-22T14:30:00Z,11,C,cpu\n,,2,2018-05-22T17:30:00Z,11,C,cpu\n,,2,2018-05-22T15:30:00Z,11,C,cpu\n,,2,2018-05-22T16:30:00Z,11,C,cpu\n,,3,2018-05-22T18:30:00Z,11,D,cpu\n,,3,2018-05-22T15:30:00Z,11,D,cpu\n,,3,2018-05-22T19:30:00Z,11,D,cpu\n,,3,2018-05-22T16:30:00Z,11,D,cpu\n,,3,2018-05-22T17:30:00Z,11,D,cpu\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,boolean\n#group,false,false,true,true,false,false,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,dead\n,,0,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,A,cpu,false\n,,1,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,B,cpu,false\n,,2,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T18:30:00Z,11,C,cpu,true\n,,3,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,D,cpu,false\n\"\nt_deadman_sub = (table=<-) => table\n    |> range(start: -5h)\n    |> monitor.deadman(t: experimental.subDuration(d: 1h, from: now()))\n\ntest deadman_sub = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_sub})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "deadman_sub_test.flux",
						Source: "now = () => 2018-05-22T20:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "deadman_sub_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "deadman_sub_test.flux",
							Source: "() => 2018-05-22T20:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "deadman_sub_test.flux",
								Source: "2018-05-22T20:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2018-05-22T20:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "deadman_sub_test.flux",
					Source: "option now = () => 2018-05-22T20:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   35,
					},
					File:   "deadman_sub_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_field,_measurement\n,,0,2018-05-22T19:30:00Z,11,A,cpu\n,,0,2018-05-22T18:30:00Z,11,A,cpu\n,,0,2018-05-22T17:30:00Z,11,A,cpu\n,,0,2018-05-22T16:30:00Z,11,A,cpu\n,,0,2018-05-22T15:30:00Z,11,A,cpu\n,,1,2018-05-22T15:30:00Z,11,B,cpu\n,,1,2018-05-22T16:30:00Z,11,B,cpu\n,,1,2018-05-22T17:30:00Z,11,B,cpu\n,,1,2018-05-22T18:30:00Z,11,B,cpu\n,,1,2018-05-22T19:30:00Z,11,B,cpu\n,,2,2018-05-22T18:30:00Z,11,C,cpu\n,,2,2018-05-22T14:30:00Z,11,C,cpu\n,,2,2018-05-22T17:30:00Z,11,C,cpu\n,,2,2018-05-22T15:30:00Z,11,C,cpu\n,,2,2018-05-22T16:30:00Z,11,C,cpu\n,,3,2018-05-22T18:30:00Z,11,D,cpu\n,,3,2018-05-22T15:30:00Z,11,D,cpu\n,,3,2018-05-22T19:30:00Z,11,D,cpu\n,,3,2018-05-22T16:30:00Z,11,D,cpu\n,,3,2018-05-22T17:30:00Z,11,D,cpu\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "deadman_sub_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   35,
						},
						File:   "deadman_sub_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,long,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_field,_measurement\n,,0,2018-05-22T19:30:00Z,11,A,cpu\n,,0,2018-05-22T18:30:00Z,11,A,cpu\n,,0,2018-05-22T17:30:00Z,11,A,cpu\n,,0,2018-05-22T16:30:00Z,11,A,cpu\n,,0,2018-05-22T15:30:00Z,11,A,cpu\n,,1,2018-05-22T15:30:00Z,11,B,cpu\n,,1,2018-05-22T16:30:00Z,11,B,cpu\n,,1,2018-05-22T17:30:00Z,11,B,cpu\n,,1,2018-05-22T18:30:00Z,11,B,cpu\n,,1,2018-05-22T19:30:00Z,11,B,cpu\n,,2,2018-05-22T18:30:00Z,11,C,cpu\n,,2,2018-05-22T14:30:00Z,11,C,cpu\n,,2,2018-05-22T17:30:00Z,11,C,cpu\n,,2,2018-05-22T15:30:00Z,11,C,cpu\n,,2,2018-05-22T16:30:00Z,11,C,cpu\n,,3,2018-05-22T18:30:00Z,11,D,cpu\n,,3,2018-05-22T15:30:00Z,11,D,cpu\n,,3,2018-05-22T19:30:00Z,11,D,cpu\n,,3,2018-05-22T16:30:00Z,11,D,cpu\n,,3,2018-05-22T17:30:00Z,11,D,cpu\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,long,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_field,_measurement\n,,0,2018-05-22T19:30:00Z,11,A,cpu\n,,0,2018-05-22T18:30:00Z,11,A,cpu\n,,0,2018-05-22T17:30:00Z,11,A,cpu\n,,0,2018-05-22T16:30:00Z,11,A,cpu\n,,0,2018-05-22T15:30:00Z,11,A,cpu\n,,1,2018-05-22T15:30:00Z,11,B,cpu\n,,1,2018-05-22T16:30:00Z,11,B,cpu\n,,1,2018-05-22T17:30:00Z,11,B,cpu\n,,1,2018-05-22T18:30:00Z,11,B,cpu\n,,1,2018-05-22T19:30:00Z,11,B,cpu\n,,2,2018-05-22T18:30:00Z,11,C,cpu\n,,2,2018-05-22T14:30:00Z,11,C,cpu\n,,2,2018-05-22T17:30:00Z,11,C,cpu\n,,2,2018-05-22T15:30:00Z,11,C,cpu\n,,2,2018-05-22T16:30:00Z,11,C,cpu\n,,3,2018-05-22T18:30:00Z,11,D,cpu\n,,3,2018-05-22T15:30:00Z,11,D,cpu\n,,3,2018-05-22T19:30:00Z,11,D,cpu\n,,3,2018-05-22T16:30:00Z,11,D,cpu\n,,3,2018-05-22T17:30:00Z,11,D,cpu\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   45,
					},
					File:   "deadman_sub_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,boolean\n#group,false,false,true,true,false,false,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,dead\n,,0,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,A,cpu,false\n,,1,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,B,cpu,false\n,,2,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T18:30:00Z,11,C,cpu,true\n,,3,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,D,cpu,false\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   36,
						},
						File:   "deadman_sub_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   45,
						},
						File:   "deadman_sub_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,boolean\n#group,false,false,true,true,false,false,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,dead\n,,0,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,A,cpu,false\n,,1,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,B,cpu,false\n,,2,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T18:30:00Z,11,C,cpu,true\n,,3,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,D,cpu,false\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,boolean\n#group,false,false,true,true,false,false,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,dead\n,,0,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,A,cpu,false\n,,1,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,B,cpu,false\n,,2,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T18:30:00Z,11,C,cpu,true\n,,3,2018-05-22T15:00:00Z,2018-05-22T20:00:00Z,2018-05-22T19:30:00Z,11,D,cpu,false\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 72,
						Line:   48,
					},
					File:   "deadman_sub_test.flux",
					Source: "t_deadman_sub = (table=<-) => table\n    |> range(start: -5h)\n    |> monitor.deadman(t: experimental.subDuration(d: 1h, from: now()))",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   46,
						},
						File:   "deadman_sub_test.flux",
						Source: "t_deadman_sub",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "t_deadman_sub",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 72,
							Line:   48,
						},
						File:   "deadman_sub_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -5h)\n    |> monitor.deadman(t: experimental.subDuration(d: 1h, from: now()))",
						Start: ast.Position{
							Column: 17,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   46,
									},
									File:   "deadman_sub_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 31,
										Line:   46,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   47,
								},
								File:   "deadman_sub_test.flux",
								Source: "table\n    |> range(start: -5h)",
								Start: ast.Position{
									Column: 31,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   47,
										},
										File:   "deadman_sub_test.flux",
										Source: "start: -5h",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   47,
											},
											File:   "deadman_sub_test.flux",
											Source: "start: -5h",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   47,
												},
												File:   "deadman_sub_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.UnaryExpression{
										Argument: &ast.DurationLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   47,
													},
													File:   "deadman_sub_test.flux",
													Source: "5h",
													Start: ast.Position{
														Column: 22,
														Line:   47,
													},
												},
											},
											Values: []ast.Duration{ast.Duration{
												Magnitude: int64(5),
												Unit:      "h",
											}},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   47,
												},
												File:   "deadman_sub_test.flux",
												Source: "-5h",
												Start: ast.Position{
													Column: 21,
													Line:   47,
												},
											},
										},
										Operator: 6,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   47,
									},
									File:   "deadman_sub_test.flux",
									Source: "range(start: -5h)",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "deadman_sub_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   48,
							},
							File:   "deadman_sub_test.flux",
							Source: "table\n    |> range(start: -5h)\n    |> monitor.deadman(t: experimental.subDuration(d: 1h, from: now()))",
							Start: ast.Position{
								Column: 31,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   48,
									},
									File:   "deadman_sub_test.flux",
									Source: "t: experimental.subDuration(d: 1h, from: now())",
									Start: ast.Position{
										Column: 24,
										Line:   48,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   48,
										},
										File:   "deadman_sub_test.flux",
										Source: "t: experimental.subDuration(d: 1h, from: now())",
										Start: ast.Position{
											Column: 24,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   48,
											},
											File:   "deadman_sub_test.flux",
											Source: "t",
											Start: ast.Position{
												Column: 24,
												Line:   48,
											},
										},
									},
									Name: "t",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   48,
												},
												File:   "deadman_sub_test.flux",
												Source: "d: 1h, from: now()",
												Start: ast.Position{
													Column: 52,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   48,
													},
													File:   "deadman_sub_test.flux",
													Source: "d: 1h",
													Start: ast.Position{
														Column: 52,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   48,
														},
														File:   "deadman_sub_test.flux",
														Source: "d",
														Start: ast.Position{
															Column: 52,
															Line:   48,
														},
													},
												},
												Name: "d",
											},
											Separator: nil,
											Value: &ast.DurationLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   48,
														},
														File:   "deadman_sub_test.flux",
														Source: "1h",
														Start: ast.Position{
															Column: 55,
															Line:   48,
														},
													},
												},
												Values: []ast.Duration{ast.Duration{
													Magnitude: int64(1),
													Unit:      "h",
												}},
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   48,
													},
													File:   "deadman_sub_test.flux",
													Source: "from: now()",
													Start: ast.Position{
														Column: 59,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   48,
														},
														File:   "deadman_sub_test.flux",
														Source: "from",
														Start: ast.Position{
															Column: 59,
															Line:   48,
														},
													},
												},
												Name: "from",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   48,
														},
														File:   "deadman_sub_test.flux",
														Source: "now()",
														Start: ast.Position{
															Column: 65,
															Line:   48,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   48,
															},
															File:   "deadman_sub_test.flux",
															Source: "now",
															Start: ast.Position{
																Column: 65,
																Line:   48,
															},
														},
													},
													Name: "now",
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   48,
											},
											File:   "deadman_sub_test.flux",
											Source: "experimental.subDuration(d: 1h, from: now())",
											Start: ast.Position{
												Column: 27,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   48,
												},
												File:   "deadman_sub_test.flux",
												Source: "experimental.subDuration",
												Start: ast.Position{
													Column: 27,
													Line:   48,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   48,
													},
													File:   "deadman_sub_test.flux",
													Source: "experimental",
													Start: ast.Position{
														Column: 27,
														Line:   48,
													},
												},
											},
											Name: "experimental",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   48,
													},
													File:   "deadman_sub_test.flux",
													Source: "subDuration",
													Start: ast.Position{
														Column: 40,
														Line:   48,
													},
												},
											},
											Name: "subDuration",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   48,
								},
								File:   "deadman_sub_test.flux",
								Source: "monitor.deadman(t: experimental.subDuration(d: 1h, from: now()))",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   48,
									},
									File:   "deadman_sub_test.flux",
									Source: "monitor.deadman",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   48,
										},
										File:   "deadman_sub_test.flux",
										Source: "monitor",
										Start: ast.Position{
											Column: 8,
											Line:   48,
										},
									},
								},
								Name: "monitor",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   48,
										},
										File:   "deadman_sub_test.flux",
										Source: "deadman",
										Start: ast.Position{
											Column: 16,
											Line:   48,
										},
									},
								},
								Name: "deadman",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "deadman_sub_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 18,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   46,
								},
								File:   "deadman_sub_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 18,
									Line:   46,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "deadman_sub_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 125,
							Line:   50,
						},
						File:   "deadman_sub_test.flux",
						Source: "deadman_sub = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_sub})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   50,
							},
							File:   "deadman_sub_test.flux",
							Source: "deadman_sub",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "deadman_sub",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 125,
								Line:   50,
							},
							File:   "deadman_sub_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_sub})",
							Start: ast.Position{
								Column: 20,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 125,
									Line:   50,
								},
								File:   "deadman_sub_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_sub})",
								Start: ast.Position{
									Column: 26,
									Line:   50,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 124,
										Line:   50,
									},
									File:   "deadman_sub_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_sub}",
									Start: ast.Position{
										Column: 27,
										Line:   50,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   50,
										},
										File:   "deadman_sub_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 28,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   50,
											},
											File:   "deadman_sub_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 28,
												Line:   50,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   50,
												},
												File:   "deadman_sub_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 55,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   50,
													},
													File:   "deadman_sub_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 55,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   50,
														},
														File:   "deadman_sub_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 55,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   50,
														},
														File:   "deadman_sub_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 60,
															Line:   50,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   50,
											},
											File:   "deadman_sub_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 35,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   50,
												},
												File:   "deadman_sub_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 35,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   50,
													},
													File:   "deadman_sub_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 35,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   50,
													},
													File:   "deadman_sub_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 43,
														Line:   50,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   50,
										},
										File:   "deadman_sub_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 69,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   50,
											},
											File:   "deadman_sub_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 69,
												Line:   50,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 103,
													Line:   50,
												},
												File:   "deadman_sub_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 91,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 103,
														Line:   50,
													},
													File:   "deadman_sub_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 91,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 94,
															Line:   50,
														},
														File:   "deadman_sub_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 91,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 103,
															Line:   50,
														},
														File:   "deadman_sub_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 96,
															Line:   50,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   50,
											},
											File:   "deadman_sub_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 75,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 90,
													Line:   50,
												},
												File:   "deadman_sub_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 75,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   50,
													},
													File:   "deadman_sub_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 75,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 90,
														Line:   50,
													},
													File:   "deadman_sub_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 83,
														Line:   50,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 123,
											Line:   50,
										},
										File:   "deadman_sub_test.flux",
										Source: "fn: t_deadman_sub",
										Start: ast.Position{
											Column: 106,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   50,
											},
											File:   "deadman_sub_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 106,
												Line:   50,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 123,
												Line:   50,
											},
											File:   "deadman_sub_test.flux",
											Source: "t_deadman_sub",
											Start: ast.Position{
												Column: 110,
												Line:   50,
											},
										},
									},
									Name: "t_deadman_sub",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 125,
						Line:   50,
					},
					File:   "deadman_sub_test.flux",
					Source: "test deadman_sub = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_deadman_sub})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   4,
					},
					File:   "deadman_sub_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   4,
						},
						File:   "deadman_sub_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "deadman_sub_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "deadman_sub_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   6,
					},
					File:   "deadman_sub_test.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   6,
						},
						File:   "deadman_sub_test.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "deadman_sub_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "deadman_sub_test.flux",
					Source: "package monitor_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "deadman_sub_test.flux",
						Source: "monitor_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 123,
					Line:   62,
				},
				File:   "notify_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/v1\"\nimport \"testing\"\nimport \"experimental\"\n\noption now = () => 2018-05-22T19:54:40Z\noption monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])\n\n// Note this input data is identical to the output data of the check test case, post pivot.\ninData = \"\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,7.05\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,long\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018840000000000\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018820000000000\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018860000000000\n\"\noutData = \"\n#datatype,string,long,string,string,string,string,string,string,string,string,string,string,long,long,dateTime:RFC3339,string,string,string,string,string,double,string\n#group,false,false,true,true,true,true,true,true,true,true,false,true,false,false,false,true,true,true,true,true,false,true\n#default,got,,,,,,,,,,,,,,,,,,,,,\n,result,table,_notification_rule_id,_notification_rule_name,_notification_endpoint_id,_notification_endpoint_name,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_status_timestamp,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle,_sent\n,,0,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,crit,notifications,whoa!,cpu,1527018860000000000,1527018840000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001,true\n,,1,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,ok,notifications,whoa!,cpu,1527018860000000000,1527018820000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,90.62382797849732,true\n,,2,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,warn,notifications,whoa!,cpu,1527018860000000000,1527018860000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05,true\n\"\nendpoint = () => (tables=<-) => tables |> experimental.set(o: {_sent: \"true\"})\nnotification = {\n    _notification_rule_id: \"0000000000000001\",\n    _notification_rule_name: \"http-rule\",\n    _notification_endpoint_id: \"00000000000002\",\n    _notification_endpoint_name: \"http-endpoint\",\n}\nt_notify = (table=<-) => table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.notify(\n        data: notification,\n        endpoint: endpoint(),\n    )\n\ntest monitor_notify = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_notify})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   9,
						},
						File:   "notify_test.flux",
						Source: "now = () => 2018-05-22T19:54:40Z",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "notify_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   9,
							},
							File:   "notify_test.flux",
							Source: "() => 2018-05-22T19:54:40Z",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   9,
								},
								File:   "notify_test.flux",
								Source: "2018-05-22T19:54:40Z",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Value: parser.MustParseTime("2018-05-22T19:54:40Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   9,
					},
					File:   "notify_test.flux",
					Source: "option now = () => 2018-05-22T19:54:40Z",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   10,
						},
						File:   "notify_test.flux",
						Source: "monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   10,
							},
							File:   "notify_test.flux",
							Source: "(tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 22,
								Line:   10,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   10,
									},
									File:   "notify_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 37,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   10,
								},
								File:   "notify_test.flux",
								Source: "tables |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 37,
									Line:   10,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   10,
										},
										File:   "notify_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 52,
											Line:   10,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   10,
											},
											File:   "notify_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 52,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   10,
												},
												File:   "notify_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 52,
													Line:   10,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   10,
												},
												File:   "notify_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 61,
													Line:   10,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   10,
													},
													File:   "notify_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 62,
														Line:   10,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   10,
													},
													File:   "notify_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 72,
														Line:   10,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   10,
									},
									File:   "notify_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 47,
										Line:   10,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   10,
										},
										File:   "notify_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 47,
											Line:   10,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "notify_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   10,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   10,
									},
									File:   "notify_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "notify_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   10,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   10,
							},
							File:   "notify_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   10,
								},
								File:   "notify_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   10,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   10,
								},
								File:   "notify_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   10,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   10,
					},
					File:   "notify_test.flux",
					Source: "option monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   37,
					},
					File:   "notify_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,7.05\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,long\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018840000000000\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018820000000000\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018860000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Note this input data is identical to the output data of the check test case, post pivot.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   13,
						},
						File:   "notify_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   13,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   37,
						},
						File:   "notify_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,7.05\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,long\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018840000000000\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018820000000000\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018860000000000\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   13,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,7.05\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,long\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018840000000000\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018820000000000\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018860000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "notify_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,string,string,string,string,string,string,string,string,long,long,dateTime:RFC3339,string,string,string,string,string,double,string\n#group,false,false,true,true,true,true,true,true,true,true,false,true,false,false,false,true,true,true,true,true,false,true\n#default,got,,,,,,,,,,,,,,,,,,,,,\n,result,table,_notification_rule_id,_notification_rule_name,_notification_endpoint_id,_notification_endpoint_name,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_status_timestamp,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle,_sent\n,,0,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,crit,notifications,whoa!,cpu,1527018860000000000,1527018840000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001,true\n,,1,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,ok,notifications,whoa!,cpu,1527018860000000000,1527018820000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,90.62382797849732,true\n,,2,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,warn,notifications,whoa!,cpu,1527018860000000000,1527018860000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05,true\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   38,
						},
						File:   "notify_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   38,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "notify_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,string,string,string,string,string,string,string,long,long,dateTime:RFC3339,string,string,string,string,string,double,string\n#group,false,false,true,true,true,true,true,true,true,true,false,true,false,false,false,true,true,true,true,true,false,true\n#default,got,,,,,,,,,,,,,,,,,,,,,\n,result,table,_notification_rule_id,_notification_rule_name,_notification_endpoint_id,_notification_endpoint_name,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_status_timestamp,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle,_sent\n,,0,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,crit,notifications,whoa!,cpu,1527018860000000000,1527018840000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001,true\n,,1,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,ok,notifications,whoa!,cpu,1527018860000000000,1527018820000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,90.62382797849732,true\n,,2,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,warn,notifications,whoa!,cpu,1527018860000000000,1527018860000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05,true\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   38,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,string,string,string,string,string,string,string,long,long,dateTime:RFC3339,string,string,string,string,string,double,string\n#group,false,false,true,true,true,true,true,true,true,true,false,true,false,false,false,true,true,true,true,true,false,true\n#default,got,,,,,,,,,,,,,,,,,,,,,\n,result,table,_notification_rule_id,_notification_rule_name,_notification_endpoint_id,_notification_endpoint_name,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_status_timestamp,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle,_sent\n,,0,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,crit,notifications,whoa!,cpu,1527018860000000000,1527018840000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001,true\n,,1,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,ok,notifications,whoa!,cpu,1527018860000000000,1527018820000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,90.62382797849732,true\n,,2,0000000000000001,http-rule,00000000000002,http-endpoint,000000000000000a,cpu threshold check,warn,notifications,whoa!,cpu,1527018860000000000,1527018860000000000,2018-05-22T19:54:40Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05,true\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 79,
						Line:   47,
					},
					File:   "notify_test.flux",
					Source: "endpoint = () => (tables=<-) => tables |> experimental.set(o: {_sent: \"true\"})",
					Start: ast.Position{
						Column: 1,
						Line:   47,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   47,
						},
						File:   "notify_test.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   47,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 79,
							Line:   47,
						},
						File:   "notify_test.flux",
						Source: "() => (tables=<-) => tables |> experimental.set(o: {_sent: \"true\"})",
						Start: ast.Position{
							Column: 12,
							Line:   47,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 79,
								Line:   47,
							},
							File:   "notify_test.flux",
							Source: "(tables=<-) => tables |> experimental.set(o: {_sent: \"true\"})",
							Start: ast.Position{
								Column: 18,
								Line:   47,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   47,
									},
									File:   "notify_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 33,
										Line:   47,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   47,
								},
								File:   "notify_test.flux",
								Source: "tables |> experimental.set(o: {_sent: \"true\"})",
								Start: ast.Position{
									Column: 33,
									Line:   47,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   47,
										},
										File:   "notify_test.flux",
										Source: "o: {_sent: \"true\"}",
										Start: ast.Position{
											Column: 60,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   47,
											},
											File:   "notify_test.flux",
											Source: "o: {_sent: \"true\"}",
											Start: ast.Position{
												Column: 60,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   47,
												},
												File:   "notify_test.flux",
												Source: "o",
												Start: ast.Position{
													Column: 60,
													Line:   47,
												},
											},
										},
										Name: "o",
									},
									Separator: nil,
									Value: &ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   47,
												},
												File:   "notify_test.flux",
												Source: "{_sent: \"true\"}",
												Start: ast.Position{
													Column: 63,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   47,
													},
													File:   "notify_test.flux",
													Source: "_sent: \"true\"",
													Start: ast.Position{
														Column: 64,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   47,
														},
														File:   "notify_test.flux",
														Source: "_sent",
														Start: ast.Position{
															Column: 64,
															Line:   47,
														},
													},
												},
												Name: "_sent",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   47,
														},
														File:   "notify_test.flux",
														Source: "\"true\"",
														Start: ast.Position{
															Column: 71,
															Line:   47,
														},
													},
												},
												Value: "true",
											},
										}},
										Rbrace: nil,
										With:   nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   47,
									},
									File:   "notify_test.flux",
									Source: "experimental.set(o: {_sent: \"true\"})",
									Start: ast.Position{
										Column: 43,
										Line:   47,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   47,
										},
										File:   "notify_test.flux",
										Source: "experimental.set",
										Start: ast.Position{
											Column: 43,
											Line:   47,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   47,
											},
											File:   "notify_test.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 43,
												Line:   47,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   47,
											},
											File:   "notify_test.flux",
											Source: "set",
											Start: ast.Position{
												Column: 56,
												Line:   47,
											},
										},
									},
									Name: "set",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   47,
								},
								File:   "notify_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 19,
									Line:   47,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   47,
									},
									File:   "notify_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   47,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   47,
								},
								File:   "notify_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 26,
									Line:   47,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   53,
					},
					File:   "notify_test.flux",
					Source: "notification = {\n    _notification_rule_id: \"0000000000000001\",\n    _notification_rule_name: \"http-rule\",\n    _notification_endpoint_id: \"00000000000002\",\n    _notification_endpoint_name: \"http-endpoint\",\n}",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "notify_test.flux",
						Source: "notification",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "notification",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   53,
						},
						File:   "notify_test.flux",
						Source: "{\n    _notification_rule_id: \"0000000000000001\",\n    _notification_rule_name: \"http-rule\",\n    _notification_endpoint_id: \"00000000000002\",\n    _notification_endpoint_name: \"http-endpoint\",\n}",
						Start: ast.Position{
							Column: 16,
							Line:   48,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   49,
							},
							File:   "notify_test.flux",
							Source: "_notification_rule_id: \"0000000000000001\"",
							Start: ast.Position{
								Column: 5,
								Line:   49,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   49,
								},
								File:   "notify_test.flux",
								Source: "_notification_rule_id",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Name: "_notification_rule_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   49,
								},
								File:   "notify_test.flux",
								Source: "\"0000000000000001\"",
								Start: ast.Position{
									Column: 28,
									Line:   49,
								},
							},
						},
						Value: "0000000000000001",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   50,
							},
							File:   "notify_test.flux",
							Source: "_notification_rule_name: \"http-rule\"",
							Start: ast.Position{
								Column: 5,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   50,
								},
								File:   "notify_test.flux",
								Source: "_notification_rule_name",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
						Name: "_notification_rule_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   50,
								},
								File:   "notify_test.flux",
								Source: "\"http-rule\"",
								Start: ast.Position{
									Column: 30,
									Line:   50,
								},
							},
						},
						Value: "http-rule",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   51,
							},
							File:   "notify_test.flux",
							Source: "_notification_endpoint_id: \"00000000000002\"",
							Start: ast.Position{
								Column: 5,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   51,
								},
								File:   "notify_test.flux",
								Source: "_notification_endpoint_id",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Name: "_notification_endpoint_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   51,
								},
								File:   "notify_test.flux",
								Source: "\"00000000000002\"",
								Start: ast.Position{
									Column: 32,
									Line:   51,
								},
							},
						},
						Value: "00000000000002",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   52,
							},
							File:   "notify_test.flux",
							Source: "_notification_endpoint_name: \"http-endpoint\"",
							Start: ast.Position{
								Column: 5,
								Line:   52,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   52,
								},
								File:   "notify_test.flux",
								Source: "_notification_endpoint_name",
								Start: ast.Position{
									Column: 5,
									Line:   52,
								},
							},
						},
						Name: "_notification_endpoint_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   52,
								},
								File:   "notify_test.flux",
								Source: "\"http-endpoint\"",
								Start: ast.Position{
									Column: 34,
									Line:   52,
								},
							},
						},
						Value: "http-endpoint",
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   60,
					},
					File:   "notify_test.flux",
					Source: "t_notify = (table=<-) => table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.notify(\n        data: notification,\n        endpoint: endpoint(),\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   54,
						},
						File:   "notify_test.flux",
						Source: "t_notify",
						Start: ast.Position{
							Column: 1,
							Line:   54,
						},
					},
				},
				Name: "t_notify",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   60,
						},
						File:   "notify_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.notify(\n        data: notification,\n        endpoint: endpoint(),\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   54,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   54,
										},
										File:   "notify_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 26,
											Line:   54,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   55,
									},
									File:   "notify_test.flux",
									Source: "table\n    |> range(start: -1m)",
									Start: ast.Position{
										Column: 26,
										Line:   54,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   55,
											},
											File:   "notify_test.flux",
											Source: "start: -1m",
											Start: ast.Position{
												Column: 14,
												Line:   55,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   55,
												},
												File:   "notify_test.flux",
												Source: "start: -1m",
												Start: ast.Position{
													Column: 14,
													Line:   55,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   55,
													},
													File:   "notify_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   55,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.UnaryExpression{
											Argument: &ast.DurationLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   55,
														},
														File:   "notify_test.flux",
														Source: "1m",
														Start: ast.Position{
															Column: 22,
															Line:   55,
														},
													},
												},
												Values: []ast.Duration{ast.Duration{
													Magnitude: int64(1),
													Unit:      "m",
												}},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   55,
													},
													File:   "notify_test.flux",
													Source: "-1m",
													Start: ast.Position{
														Column: 21,
														Line:   55,
													},
												},
											},
											Operator: 6,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   55,
										},
										File:   "notify_test.flux",
										Source: "range(start: -1m)",
										Start: ast.Position{
											Column: 8,
											Line:   55,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   55,
											},
											File:   "notify_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   55,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   56,
								},
								File:   "notify_test.flux",
								Source: "table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 26,
									Line:   54,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   56,
									},
									File:   "notify_test.flux",
									Source: "v1.fieldsAsCols()",
									Start: ast.Position{
										Column: 8,
										Line:   56,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   56,
										},
										File:   "notify_test.flux",
										Source: "v1.fieldsAsCols",
										Start: ast.Position{
											Column: 8,
											Line:   56,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   56,
											},
											File:   "notify_test.flux",
											Source: "v1",
											Start: ast.Position{
												Column: 8,
												Line:   56,
											},
										},
									},
									Name: "v1",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   56,
											},
											File:   "notify_test.flux",
											Source: "fieldsAsCols",
											Start: ast.Position{
												Column: 11,
												Line:   56,
											},
										},
									},
									Name: "fieldsAsCols",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   60,
							},
							File:   "notify_test.flux",
							Source: "table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.notify(\n        data: notification,\n        endpoint: endpoint(),\n    )",
							Start: ast.Position{
								Column: 26,
								Line:   54,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   59,
									},
									File:   "notify_test.flux",
									Source: "data: notification,\n        endpoint: endpoint()",
									Start: ast.Position{
										Column: 9,
										Line:   58,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   58,
										},
										File:   "notify_test.flux",
										Source: "data: notification",
										Start: ast.Position{
											Column: 9,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   58,
											},
											File:   "notify_test.flux",
											Source: "data",
											Start: ast.Position{
												Column: 9,
												Line:   58,
											},
										},
									},
									Name: "data",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   58,
											},
											File:   "notify_test.flux",
											Source: "notification",
											Start: ast.Position{
												Column: 15,
												Line:   58,
											},
										},
									},
									Name: "notification",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   59,
										},
										File:   "notify_test.flux",
										Source: "endpoint: endpoint()",
										Start: ast.Position{
											Column: 9,
											Line:   59,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   59,
											},
											File:   "notify_test.flux",
											Source: "endpoint",
											Start: ast.Position{
												Column: 9,
												Line:   59,
											},
										},
									},
									Name: "endpoint",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   59,
											},
											File:   "notify_test.flux",
											Source: "endpoint()",
											Start: ast.Position{
												Column: 19,
												Line:   59,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   59,
												},
												File:   "notify_test.flux",
												Source: "endpoint",
												Start: ast.Position{
													Column: 19,
													Line:   59,
												},
											},
										},
										Name: "endpoint",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   60,
								},
								File:   "notify_test.flux",
								Source: "monitor.notify(\n        data: notification,\n        endpoint: endpoint(),\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   57,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   57,
									},
									File:   "notify_test.flux",
									Source: "monitor.notify",
									Start: ast.Position{
										Column: 8,
										Line:   57,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   57,
										},
										File:   "notify_test.flux",
										Source: "monitor",
										Start: ast.Position{
											Column: 8,
											Line:   57,
										},
									},
								},
								Name: "monitor",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   57,
										},
										File:   "notify_test.flux",
										Source: "notify",
										Start: ast.Position{
											Column: 16,
											Line:   57,
										},
									},
								},
								Name: "notify",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   54,
							},
							File:   "notify_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 13,
								Line:   54,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   54,
								},
								File:   "notify_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 13,
									Line:   54,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   54,
							},
							File:   "notify_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 19,
								Line:   54,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 123,
							Line:   62,
						},
						File:   "notify_test.flux",
						Source: "monitor_notify = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_notify})",
						Start: ast.Position{
							Column: 6,
							Line:   62,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   62,
							},
							File:   "notify_test.flux",
							Source: "monitor_notify",
							Start: ast.Position{
								Column: 6,
								Line:   62,
							},
						},
					},
					Name: "monitor_notify",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 123,
								Line:   62,
							},
							File:   "notify_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_notify})",
							Start: ast.Position{
								Column: 23,
								Line:   62,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 123,
									Line:   62,
								},
								File:   "notify_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_notify})",
								Start: ast.Position{
									Column: 29,
									Line:   62,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 122,
										Line:   62,
									},
									File:   "notify_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_notify}",
									Start: ast.Position{
										Column: 30,
										Line:   62,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   62,
										},
										File:   "notify_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 31,
											Line:   62,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   62,
											},
											File:   "notify_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 31,
												Line:   62,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   62,
												},
												File:   "notify_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 58,
													Line:   62,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   62,
													},
													File:   "notify_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 58,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   62,
														},
														File:   "notify_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 58,
															Line:   62,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   62,
														},
														File:   "notify_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 63,
															Line:   62,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   62,
											},
											File:   "notify_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 38,
												Line:   62,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   62,
												},
												File:   "notify_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 38,
													Line:   62,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   62,
													},
													File:   "notify_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 38,
														Line:   62,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   62,
													},
													File:   "notify_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 46,
														Line:   62,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 107,
											Line:   62,
										},
										File:   "notify_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 72,
											Line:   62,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   62,
											},
											File:   "notify_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 72,
												Line:   62,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 106,
													Line:   62,
												},
												File:   "notify_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 94,
													Line:   62,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 106,
														Line:   62,
													},
													File:   "notify_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 94,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   62,
														},
														File:   "notify_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 94,
															Line:   62,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 106,
															Line:   62,
														},
														File:   "notify_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 99,
															Line:   62,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 107,
												Line:   62,
											},
											File:   "notify_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 78,
												Line:   62,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 93,
													Line:   62,
												},
												File:   "notify_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 78,
													Line:   62,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   62,
													},
													File:   "notify_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 78,
														Line:   62,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 93,
														Line:   62,
													},
													File:   "notify_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 86,
														Line:   62,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 121,
											Line:   62,
										},
										File:   "notify_test.flux",
										Source: "fn: t_notify",
										Start: ast.Position{
											Column: 109,
											Line:   62,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 111,
												Line:   62,
											},
											File:   "notify_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 109,
												Line:   62,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 121,
												Line:   62,
											},
											File:   "notify_test.flux",
											Source: "t_notify",
											Start: ast.Position{
												Column: 113,
												Line:   62,
											},
										},
									},
									Name: "t_notify",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 123,
						Line:   62,
					},
					File:   "notify_test.flux",
					Source: "test monitor_notify = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_notify})",
					Start: ast.Position{
						Column: 1,
						Line:   62,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   4,
					},
					File:   "notify_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   4,
						},
						File:   "notify_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   5,
					},
					File:   "notify_test.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   5,
						},
						File:   "notify_test.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "notify_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "notify_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   7,
					},
					File:   "notify_test.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   7,
						},
						File:   "notify_test.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "notify_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "notify_test.flux",
					Source: "package monitor_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "notify_test.flux",
						Source: "monitor_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 159,
					Line:   55,
				},
				File:   "state_changes_any_to_any_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/v1\"\nimport \"testing\"\nimport \"experimental\"\n\noption now = () => 2018-05-22T19:54:40Z\noption monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])\n\n// Note this input data is identical to the output data of the check test case, post pivot.\ninData = \"\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,7.05\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,long\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018840000000000\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018820000000000\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018860000000000\n\"\noutData = \"\n#datatype,string,long,string,string,string,string,string,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,true,true,false,true,false,false,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle\n,,1,000000000000000a,cpu threshold check,crit,statuses,whoa!,cpu,1527018840000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001\n,,2,000000000000000a,cpu threshold check,warn,statuses,whoa!,cpu,1527018860000000000,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05\n\"\nt_state_changes_any_to_any = (table=<-) => table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )\n    |> drop(columns: [\"_start\", \"_stop\"])\n\ntest monitor_state_changes_any_to_any = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_any_to_any})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   9,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "now = () => 2018-05-22T19:54:40Z",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   9,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "() => 2018-05-22T19:54:40Z",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   9,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "2018-05-22T19:54:40Z",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Value: parser.MustParseTime("2018-05-22T19:54:40Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   9,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "option now = () => 2018-05-22T19:54:40Z",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   10,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   10,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "(tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 22,
								Line:   10,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   10,
									},
									File:   "state_changes_any_to_any_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 37,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   10,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "tables |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 37,
									Line:   10,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   10,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 52,
											Line:   10,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   10,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 52,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   10,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 52,
													Line:   10,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   10,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 61,
													Line:   10,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   10,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 62,
														Line:   10,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   10,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 72,
														Line:   10,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   10,
									},
									File:   "state_changes_any_to_any_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 47,
										Line:   10,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   10,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 47,
											Line:   10,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   10,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   10,
									},
									File:   "state_changes_any_to_any_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   10,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   10,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   10,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   10,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   10,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   10,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   10,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "option monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   37,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,7.05\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,long\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018840000000000\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018820000000000\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018860000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Note this input data is identical to the output data of the check test case, post pivot.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   13,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   13,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   37,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,7.05\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,long\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018840000000000\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018820000000000\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018860000000000\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   13,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,4.800000000000001\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,90.62382797849732\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,usage_idle,7.05\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,_message,whoa!\n\n#datatype,string,long,string,string,string,string,string,dateTime:RFC3339,string,string,string,string,string,string,long\n#group,false,false,true,true,true,true,true,false,true,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_source_measurement,_time,_type,aaa,bbb,cpu,host,_field,_value\n,,0,000000000000000a,cpu threshold check,crit,statuses,cpu,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018840000000000\n,,1,000000000000000a,cpu threshold check,ok,statuses,cpu,2018-05-22T19:54:21Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018820000000000\n,,2,000000000000000a,cpu threshold check,warn,statuses,cpu,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,_source_timestamp,1527018860000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   45,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,string,string,string,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,true,true,false,true,false,false,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle\n,,1,000000000000000a,cpu threshold check,crit,statuses,whoa!,cpu,1527018840000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001\n,,2,000000000000000a,cpu threshold check,warn,statuses,whoa!,cpu,1527018860000000000,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   38,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   38,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   45,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,string,string,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,true,true,false,true,false,false,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle\n,,1,000000000000000a,cpu threshold check,crit,statuses,whoa!,cpu,1527018840000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001\n,,2,000000000000000a,cpu threshold check,warn,statuses,whoa!,cpu,1527018860000000000,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   38,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,string,string,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,true,true,false,true,false,false,true,true,true,true,true,false\n#default,got,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_time,_type,aaa,bbb,cpu,host,usage_idle\n,,1,000000000000000a,cpu threshold check,crit,statuses,whoa!,cpu,1527018840000000000,2018-05-22T19:54:20Z,threshold,vaaa,vbbb,cpu-total,host.local,4.800000000000001\n,,2,000000000000000a,cpu threshold check,warn,statuses,whoa!,cpu,1527018860000000000,2018-05-22T19:54:22Z,threshold,vaaa,vbbb,cpu-total,host.local,7.05\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   53,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "t_state_changes_any_to_any = (table=<-) => table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )\n    |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   46,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "t_state_changes_any_to_any",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "t_state_changes_any_to_any",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   53,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "(table=<-) => table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )\n    |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 30,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   46,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 44,
												Line:   46,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   47,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "table\n    |> range(start: -1m)",
										Start: ast.Position{
											Column: 44,
											Line:   46,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   47,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "start: -1m",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   47,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "start: -1m",
													Start: ast.Position{
														Column: 14,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   47,
														},
														File:   "state_changes_any_to_any_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   47,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.UnaryExpression{
												Argument: &ast.DurationLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   47,
															},
															File:   "state_changes_any_to_any_test.flux",
															Source: "1m",
															Start: ast.Position{
																Column: 22,
																Line:   47,
															},
														},
													},
													Values: []ast.Duration{ast.Duration{
														Magnitude: int64(1),
														Unit:      "m",
													}},
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   47,
														},
														File:   "state_changes_any_to_any_test.flux",
														Source: "-1m",
														Start: ast.Position{
															Column: 21,
															Line:   47,
														},
													},
												},
												Operator: 6,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   47,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "range(start: -1m)",
											Start: ast.Position{
												Column: 8,
												Line:   47,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   47,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   47,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   48,
									},
									File:   "state_changes_any_to_any_test.flux",
									Source: "table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()",
									Start: ast.Position{
										Column: 44,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   48,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "v1.fieldsAsCols()",
										Start: ast.Position{
											Column: 8,
											Line:   48,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   48,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "v1.fieldsAsCols",
											Start: ast.Position{
												Column: 8,
												Line:   48,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   48,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "v1",
												Start: ast.Position{
													Column: 8,
													Line:   48,
												},
											},
										},
										Name: "v1",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   48,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "fieldsAsCols",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Name: "fieldsAsCols",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   52,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )",
								Start: ast.Position{
									Column: 44,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   51,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "fromLevel: \"any\",\n        toLevel: \"any\"",
										Start: ast.Position{
											Column: 9,
											Line:   50,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   50,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "fromLevel: \"any\"",
											Start: ast.Position{
												Column: 9,
												Line:   50,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   50,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "fromLevel",
												Start: ast.Position{
													Column: 9,
													Line:   50,
												},
											},
										},
										Name: "fromLevel",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   50,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "\"any\"",
												Start: ast.Position{
													Column: 20,
													Line:   50,
												},
											},
										},
										Value: "any",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   51,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "toLevel: \"any\"",
											Start: ast.Position{
												Column: 9,
												Line:   51,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   51,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "toLevel",
												Start: ast.Position{
													Column: 9,
													Line:   51,
												},
											},
										},
										Name: "toLevel",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   51,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "\"any\"",
												Start: ast.Position{
													Column: 18,
													Line:   51,
												},
											},
										},
										Value: "any",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   52,
									},
									File:   "state_changes_any_to_any_test.flux",
									Source: "monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   49,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   49,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "monitor.stateChanges",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   49,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "monitor",
											Start: ast.Position{
												Column: 8,
												Line:   49,
											},
										},
									},
									Name: "monitor",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   49,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "stateChanges",
											Start: ast.Position{
												Column: 16,
												Line:   49,
											},
										},
									},
									Name: "stateChanges",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   53,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "table\n    |> range(start: -1m)\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )\n    |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 44,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   53,
									},
									File:   "state_changes_any_to_any_test.flux",
									Source: "columns: [\"_start\", \"_stop\"]",
									Start: ast.Position{
										Column: 13,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   53,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   53,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   53,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   53,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "[\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 22,
												Line:   53,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   53,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "\"_start\"",
												Start: ast.Position{
													Column: 23,
													Line:   53,
												},
											},
										},
										Value: "_start",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   53,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "\"_stop\"",
												Start: ast.Position{
													Column: 33,
													Line:   53,
												},
											},
										},
										Value: "_stop",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   53,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 8,
									Line:   53,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   53,
									},
									File:   "state_changes_any_to_any_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   53,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   46,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 31,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   46,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 31,
									Line:   46,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   46,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 37,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 159,
							Line:   55,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "monitor_state_changes_any_to_any = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_any_to_any})",
						Start: ast.Position{
							Column: 6,
							Line:   55,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   55,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "monitor_state_changes_any_to_any",
							Start: ast.Position{
								Column: 6,
								Line:   55,
							},
						},
					},
					Name: "monitor_state_changes_any_to_any",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 159,
								Line:   55,
							},
							File:   "state_changes_any_to_any_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_any_to_any})",
							Start: ast.Position{
								Column: 41,
								Line:   55,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 159,
									Line:   55,
								},
								File:   "state_changes_any_to_any_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_any_to_any})",
								Start: ast.Position{
									Column: 47,
									Line:   55,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 158,
										Line:   55,
									},
									File:   "state_changes_any_to_any_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_any_to_any}",
									Start: ast.Position{
										Column: 48,
										Line:   55,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   55,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 49,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   55,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 49,
												Line:   55,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   55,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 76,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   55,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 76,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   55,
														},
														File:   "state_changes_any_to_any_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 76,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   55,
														},
														File:   "state_changes_any_to_any_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 81,
															Line:   55,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   55,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 56,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   55,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 56,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   55,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 56,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   55,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 64,
														Line:   55,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 125,
											Line:   55,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 90,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   55,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 90,
												Line:   55,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 124,
													Line:   55,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 112,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 124,
														Line:   55,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 112,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 115,
															Line:   55,
														},
														File:   "state_changes_any_to_any_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 112,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 124,
															Line:   55,
														},
														File:   "state_changes_any_to_any_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 117,
															Line:   55,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 125,
												Line:   55,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 96,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 111,
													Line:   55,
												},
												File:   "state_changes_any_to_any_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 96,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 103,
														Line:   55,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 96,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 111,
														Line:   55,
													},
													File:   "state_changes_any_to_any_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 104,
														Line:   55,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 157,
											Line:   55,
										},
										File:   "state_changes_any_to_any_test.flux",
										Source: "fn: t_state_changes_any_to_any",
										Start: ast.Position{
											Column: 127,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 129,
												Line:   55,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 127,
												Line:   55,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 157,
												Line:   55,
											},
											File:   "state_changes_any_to_any_test.flux",
											Source: "t_state_changes_any_to_any",
											Start: ast.Position{
												Column: 131,
												Line:   55,
											},
										},
									},
									Name: "t_state_changes_any_to_any",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 159,
						Line:   55,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "test monitor_state_changes_any_to_any = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_any_to_any})",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   4,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   4,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   5,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   5,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   7,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   7,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "state_changes_any_to_any_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "state_changes_any_to_any_test.flux",
					Source: "package monitor_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "state_changes_any_to_any_test.flux",
						Source: "monitor_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 167,
					Line:   261,
				},
				File:   "state_changes_big_any_to_any_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/v1\"\nimport \"testing\"\nimport \"experimental\"\n\noption now = () => 2018-05-22T19:54:40Z\noption monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])\n\n// Note this input data is identical to the output data of the check test case, post pivot.\ninData = \"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"\noutData = \"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: info,cpu,1585254420000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,threshold,cpu-total,localhost,23.371648565879127,info\n,,1,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok\n\n\n\"\nt_state_changes_big_any_to_any = (table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )\n\ntest monitor_state_changes_big_any_to_any = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_any_to_any})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   9,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "now = () => 2018-05-22T19:54:40Z",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   9,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "() => 2018-05-22T19:54:40Z",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   9,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "2018-05-22T19:54:40Z",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Value: parser.MustParseTime("2018-05-22T19:54:40Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   9,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "option now = () => 2018-05-22T19:54:40Z",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   10,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   10,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "(tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 22,
								Line:   10,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   10,
									},
									File:   "state_changes_big_any_to_any_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 37,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   10,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "tables |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 37,
									Line:   10,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   10,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 52,
											Line:   10,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   10,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 52,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   10,
												},
												File:   "state_changes_big_any_to_any_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 52,
													Line:   10,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   10,
												},
												File:   "state_changes_big_any_to_any_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 61,
													Line:   10,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   10,
													},
													File:   "state_changes_big_any_to_any_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 62,
														Line:   10,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   10,
													},
													File:   "state_changes_big_any_to_any_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 72,
														Line:   10,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   10,
									},
									File:   "state_changes_big_any_to_any_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 47,
										Line:   10,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   10,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 47,
											Line:   10,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   10,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   10,
									},
									File:   "state_changes_big_any_to_any_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   10,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   10,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   10,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   10,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   10,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   10,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   10,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "option monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   243,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "inData = \"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Note this input data is identical to the output data of the check test case, post pivot.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   13,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   13,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   243,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "\"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   13,
						},
					},
				},
				Value: "\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   253,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: info,cpu,1585254420000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,threshold,cpu-total,localhost,23.371648565879127,info\n,,1,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok\n\n\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   244,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   244,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   244,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   253,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "\"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: info,cpu,1585254420000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,threshold,cpu-total,localhost,23.371648565879127,info\n,,1,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok\n\n\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   244,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: info,cpu,1585254420000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,threshold,cpu-total,localhost,23.371648565879127,info\n,,1,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok\n\n\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   259,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "t_state_changes_big_any_to_any = (table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   254,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 31,
							Line:   254,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "t_state_changes_big_any_to_any",
						Start: ast.Position{
							Column: 1,
							Line:   254,
						},
					},
				},
				Name: "t_state_changes_big_any_to_any",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   259,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "(table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )",
						Start: ast.Position{
							Column: 34,
							Line:   254,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   254,
									},
									File:   "state_changes_big_any_to_any_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 48,
										Line:   254,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   255,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "table\n    |> v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 48,
									Line:   254,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   255,
									},
									File:   "state_changes_big_any_to_any_test.flux",
									Source: "v1.fieldsAsCols()",
									Start: ast.Position{
										Column: 8,
										Line:   255,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   255,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "v1.fieldsAsCols",
										Start: ast.Position{
											Column: 8,
											Line:   255,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   255,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "v1",
											Start: ast.Position{
												Column: 8,
												Line:   255,
											},
										},
									},
									Name: "v1",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   255,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "fieldsAsCols",
											Start: ast.Position{
												Column: 11,
												Line:   255,
											},
										},
									},
									Name: "fieldsAsCols",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   259,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )",
							Start: ast.Position{
								Column: 48,
								Line:   254,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   258,
									},
									File:   "state_changes_big_any_to_any_test.flux",
									Source: "fromLevel: \"any\",\n        toLevel: \"any\"",
									Start: ast.Position{
										Column: 9,
										Line:   257,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   257,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "fromLevel: \"any\"",
										Start: ast.Position{
											Column: 9,
											Line:   257,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   257,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "fromLevel",
											Start: ast.Position{
												Column: 9,
												Line:   257,
											},
										},
									},
									Name: "fromLevel",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   257,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "\"any\"",
											Start: ast.Position{
												Column: 20,
												Line:   257,
											},
										},
									},
									Value: "any",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   258,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "toLevel: \"any\"",
										Start: ast.Position{
											Column: 9,
											Line:   258,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   258,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "toLevel",
											Start: ast.Position{
												Column: 9,
												Line:   258,
											},
										},
									},
									Name: "toLevel",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   258,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "\"any\"",
											Start: ast.Position{
												Column: 18,
												Line:   258,
											},
										},
									},
									Value: "any",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   259,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "monitor.stateChanges(\n        fromLevel: \"any\",\n        toLevel: \"any\",\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   256,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   256,
									},
									File:   "state_changes_big_any_to_any_test.flux",
									Source: "monitor.stateChanges",
									Start: ast.Position{
										Column: 8,
										Line:   256,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   256,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "monitor",
										Start: ast.Position{
											Column: 8,
											Line:   256,
										},
									},
								},
								Name: "monitor",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   256,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "stateChanges",
										Start: ast.Position{
											Column: 16,
											Line:   256,
										},
									},
								},
								Name: "stateChanges",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   254,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 35,
								Line:   254,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   254,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 35,
									Line:   254,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   254,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 41,
								Line:   254,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 167,
							Line:   261,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "monitor_state_changes_big_any_to_any = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_any_to_any})",
						Start: ast.Position{
							Column: 6,
							Line:   261,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   261,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "monitor_state_changes_big_any_to_any",
							Start: ast.Position{
								Column: 6,
								Line:   261,
							},
						},
					},
					Name: "monitor_state_changes_big_any_to_any",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 167,
								Line:   261,
							},
							File:   "state_changes_big_any_to_any_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_any_to_any})",
							Start: ast.Position{
								Column: 45,
								Line:   261,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 167,
									Line:   261,
								},
								File:   "state_changes_big_any_to_any_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_any_to_any})",
								Start: ast.Position{
									Column: 51,
									Line:   261,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 166,
										Line:   261,
									},
									File:   "state_changes_big_any_to_any_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_any_to_any}",
									Start: ast.Position{
										Column: 52,
										Line:   261,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   261,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 53,
											Line:   261,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   261,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 53,
												Line:   261,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   261,
												},
												File:   "state_changes_big_any_to_any_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 80,
													Line:   261,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   261,
													},
													File:   "state_changes_big_any_to_any_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 80,
														Line:   261,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 83,
															Line:   261,
														},
														File:   "state_changes_big_any_to_any_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 80,
															Line:   261,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 91,
															Line:   261,
														},
														File:   "state_changes_big_any_to_any_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 85,
															Line:   261,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   261,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 60,
												Line:   261,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   261,
												},
												File:   "state_changes_big_any_to_any_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 60,
													Line:   261,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   261,
													},
													File:   "state_changes_big_any_to_any_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 60,
														Line:   261,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   261,
													},
													File:   "state_changes_big_any_to_any_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 68,
														Line:   261,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 129,
											Line:   261,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 94,
											Line:   261,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   261,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 94,
												Line:   261,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 128,
													Line:   261,
												},
												File:   "state_changes_big_any_to_any_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 116,
													Line:   261,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 128,
														Line:   261,
													},
													File:   "state_changes_big_any_to_any_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 116,
														Line:   261,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 119,
															Line:   261,
														},
														File:   "state_changes_big_any_to_any_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 116,
															Line:   261,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 128,
															Line:   261,
														},
														File:   "state_changes_big_any_to_any_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 121,
															Line:   261,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 129,
												Line:   261,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 100,
												Line:   261,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 115,
													Line:   261,
												},
												File:   "state_changes_big_any_to_any_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 100,
													Line:   261,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   261,
													},
													File:   "state_changes_big_any_to_any_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 100,
														Line:   261,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 115,
														Line:   261,
													},
													File:   "state_changes_big_any_to_any_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 108,
														Line:   261,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 165,
											Line:   261,
										},
										File:   "state_changes_big_any_to_any_test.flux",
										Source: "fn: t_state_changes_big_any_to_any",
										Start: ast.Position{
											Column: 131,
											Line:   261,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 133,
												Line:   261,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 131,
												Line:   261,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 165,
												Line:   261,
											},
											File:   "state_changes_big_any_to_any_test.flux",
											Source: "t_state_changes_big_any_to_any",
											Start: ast.Position{
												Column: 135,
												Line:   261,
											},
										},
									},
									Name: "t_state_changes_big_any_to_any",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 167,
						Line:   261,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "test monitor_state_changes_big_any_to_any = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_any_to_any})",
					Start: ast.Position{
						Column: 1,
						Line:   261,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   4,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   4,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   5,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   5,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   7,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   7,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "state_changes_big_any_to_any_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "state_changes_big_any_to_any_test.flux",
					Source: "package monitor_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "state_changes_big_any_to_any_test.flux",
						Source: "monitor_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 167,
					Line:   260,
				},
				File:   "state_changes_big_info_to_ok_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/v1\"\nimport \"testing\"\nimport \"experimental\"\n\noption now = () => 2018-05-22T19:54:40Z\noption monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])\n\n// Note this input data is identical to the output data of the check test case, post pivot.\ninData = \"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"\noutData = \"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok\n\n\n\"\nt_state_changes_big_info_to_ok = (table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"info\",\n        toLevel: \"ok\",\n    )\n\ntest monitor_state_changes_big_info_to_ok = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_info_to_ok})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   9,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "now = () => 2018-05-22T19:54:40Z",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   9,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "() => 2018-05-22T19:54:40Z",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   9,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "2018-05-22T19:54:40Z",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Value: parser.MustParseTime("2018-05-22T19:54:40Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   9,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "option now = () => 2018-05-22T19:54:40Z",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   10,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   10,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "(tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 22,
								Line:   10,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   10,
									},
									File:   "state_changes_big_info_to_ok_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 37,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   10,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "tables |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 37,
									Line:   10,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   10,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 52,
											Line:   10,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   10,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 52,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   10,
												},
												File:   "state_changes_big_info_to_ok_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 52,
													Line:   10,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   10,
												},
												File:   "state_changes_big_info_to_ok_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 61,
													Line:   10,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   10,
													},
													File:   "state_changes_big_info_to_ok_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 62,
														Line:   10,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   10,
													},
													File:   "state_changes_big_info_to_ok_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 72,
														Line:   10,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   10,
									},
									File:   "state_changes_big_info_to_ok_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 47,
										Line:   10,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   10,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 47,
											Line:   10,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   10,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   10,
									},
									File:   "state_changes_big_info_to_ok_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   10,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   10,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   10,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   10,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   10,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   10,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   10,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "option monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   243,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "inData = \"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Note this input data is identical to the output data of the check test case, post pivot.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   13,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   13,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   243,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "\"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   13,
						},
					},
				},
				Value: "\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   252,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok\n\n\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   244,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   244,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   244,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   252,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "\"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok\n\n\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   244,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok\n\n\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   258,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "t_state_changes_big_info_to_ok = (table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"info\",\n        toLevel: \"ok\",\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   253,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 31,
							Line:   253,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "t_state_changes_big_info_to_ok",
						Start: ast.Position{
							Column: 1,
							Line:   253,
						},
					},
				},
				Name: "t_state_changes_big_info_to_ok",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   258,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "(table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"info\",\n        toLevel: \"ok\",\n    )",
						Start: ast.Position{
							Column: 34,
							Line:   253,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   253,
									},
									File:   "state_changes_big_info_to_ok_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 48,
										Line:   253,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   254,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "table\n    |> v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 48,
									Line:   253,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   254,
									},
									File:   "state_changes_big_info_to_ok_test.flux",
									Source: "v1.fieldsAsCols()",
									Start: ast.Position{
										Column: 8,
										Line:   254,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   254,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "v1.fieldsAsCols",
										Start: ast.Position{
											Column: 8,
											Line:   254,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   254,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "v1",
											Start: ast.Position{
												Column: 8,
												Line:   254,
											},
										},
									},
									Name: "v1",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   254,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "fieldsAsCols",
											Start: ast.Position{
												Column: 11,
												Line:   254,
											},
										},
									},
									Name: "fieldsAsCols",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   258,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"info\",\n        toLevel: \"ok\",\n    )",
							Start: ast.Position{
								Column: 48,
								Line:   253,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   257,
									},
									File:   "state_changes_big_info_to_ok_test.flux",
									Source: "fromLevel: \"info\",\n        toLevel: \"ok\"",
									Start: ast.Position{
										Column: 9,
										Line:   256,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   256,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "fromLevel: \"info\"",
										Start: ast.Position{
											Column: 9,
											Line:   256,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   256,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "fromLevel",
											Start: ast.Position{
												Column: 9,
												Line:   256,
											},
										},
									},
									Name: "fromLevel",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   256,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "\"info\"",
											Start: ast.Position{
												Column: 20,
												Line:   256,
											},
										},
									},
									Value: "info",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   257,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "toLevel: \"ok\"",
										Start: ast.Position{
											Column: 9,
											Line:   257,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   257,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "toLevel",
											Start: ast.Position{
												Column: 9,
												Line:   257,
											},
										},
									},
									Name: "toLevel",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   257,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "\"ok\"",
											Start: ast.Position{
												Column: 18,
												Line:   257,
											},
										},
									},
									Value: "ok",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   258,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "monitor.stateChanges(\n        fromLevel: \"info\",\n        toLevel: \"ok\",\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   255,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   255,
									},
									File:   "state_changes_big_info_to_ok_test.flux",
									Source: "monitor.stateChanges",
									Start: ast.Position{
										Column: 8,
										Line:   255,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   255,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "monitor",
										Start: ast.Position{
											Column: 8,
											Line:   255,
										},
									},
								},
								Name: "monitor",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   255,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "stateChanges",
										Start: ast.Position{
											Column: 16,
											Line:   255,
										},
									},
								},
								Name: "stateChanges",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   253,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 35,
								Line:   253,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   253,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 35,
									Line:   253,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   253,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 41,
								Line:   253,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 167,
							Line:   260,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "monitor_state_changes_big_info_to_ok = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_info_to_ok})",
						Start: ast.Position{
							Column: 6,
							Line:   260,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   260,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "monitor_state_changes_big_info_to_ok",
							Start: ast.Position{
								Column: 6,
								Line:   260,
							},
						},
					},
					Name: "monitor_state_changes_big_info_to_ok",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 167,
								Line:   260,
							},
							File:   "state_changes_big_info_to_ok_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_info_to_ok})",
							Start: ast.Position{
								Column: 45,
								Line:   260,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 167,
									Line:   260,
								},
								File:   "state_changes_big_info_to_ok_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_info_to_ok})",
								Start: ast.Position{
									Column: 51,
									Line:   260,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 166,
										Line:   260,
									},
									File:   "state_changes_big_info_to_ok_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_info_to_ok}",
									Start: ast.Position{
										Column: 52,
										Line:   260,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   260,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 53,
											Line:   260,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   260,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 53,
												Line:   260,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   260,
												},
												File:   "state_changes_big_info_to_ok_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 80,
													Line:   260,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   260,
													},
													File:   "state_changes_big_info_to_ok_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 80,
														Line:   260,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 83,
															Line:   260,
														},
														File:   "state_changes_big_info_to_ok_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 80,
															Line:   260,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 91,
															Line:   260,
														},
														File:   "state_changes_big_info_to_ok_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 85,
															Line:   260,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   260,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 60,
												Line:   260,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   260,
												},
												File:   "state_changes_big_info_to_ok_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 60,
													Line:   260,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   260,
													},
													File:   "state_changes_big_info_to_ok_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 60,
														Line:   260,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   260,
													},
													File:   "state_changes_big_info_to_ok_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 68,
														Line:   260,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 129,
											Line:   260,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 94,
											Line:   260,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   260,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 94,
												Line:   260,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 128,
													Line:   260,
												},
												File:   "state_changes_big_info_to_ok_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 116,
													Line:   260,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 128,
														Line:   260,
													},
													File:   "state_changes_big_info_to_ok_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 116,
														Line:   260,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 119,
															Line:   260,
														},
														File:   "state_changes_big_info_to_ok_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 116,
															Line:   260,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 128,
															Line:   260,
														},
														File:   "state_changes_big_info_to_ok_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 121,
															Line:   260,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 129,
												Line:   260,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 100,
												Line:   260,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 115,
													Line:   260,
												},
												File:   "state_changes_big_info_to_ok_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 100,
													Line:   260,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   260,
													},
													File:   "state_changes_big_info_to_ok_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 100,
														Line:   260,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 115,
														Line:   260,
													},
													File:   "state_changes_big_info_to_ok_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 108,
														Line:   260,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 165,
											Line:   260,
										},
										File:   "state_changes_big_info_to_ok_test.flux",
										Source: "fn: t_state_changes_big_info_to_ok",
										Start: ast.Position{
											Column: 131,
											Line:   260,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 133,
												Line:   260,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 131,
												Line:   260,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 165,
												Line:   260,
											},
											File:   "state_changes_big_info_to_ok_test.flux",
											Source: "t_state_changes_big_info_to_ok",
											Start: ast.Position{
												Column: 135,
												Line:   260,
											},
										},
									},
									Name: "t_state_changes_big_info_to_ok",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 167,
						Line:   260,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "test monitor_state_changes_big_info_to_ok = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_info_to_ok})",
					Start: ast.Position{
						Column: 1,
						Line:   260,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   4,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   4,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   5,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   5,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   7,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   7,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "state_changes_big_info_to_ok_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "state_changes_big_info_to_ok_test.flux",
					Source: "package monitor_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "state_changes_big_info_to_ok_test.flux",
						Source: "monitor_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 167,
					Line:   260,
				},
				File:   "state_changes_big_ok_to_info_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/v1\"\nimport \"testing\"\nimport \"experimental\"\n\noption now = () => 2018-05-22T19:54:40Z\noption monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])\n\n// Note this input data is identical to the output data of the check test case, post pivot.\ninData = \"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"\noutData = \"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: info,cpu,1585254420000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,threshold,cpu-total,localhost,23.371648565879127,info\n\n\n\"\nt_state_changes_big_ok_to_info = (table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"ok\",\n        toLevel: \"info\",\n    )\n\ntest monitor_state_changes_big_ok_to_info = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_ok_to_info})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   9,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "now = () => 2018-05-22T19:54:40Z",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   9,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   9,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "() => 2018-05-22T19:54:40Z",
							Start: ast.Position{
								Column: 14,
								Line:   9,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   9,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "2018-05-22T19:54:40Z",
								Start: ast.Position{
									Column: 20,
									Line:   9,
								},
							},
						},
						Value: parser.MustParseTime("2018-05-22T19:54:40Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   9,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "option now = () => 2018-05-22T19:54:40Z",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   10,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   10,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "(tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
							Start: ast.Position{
								Column: 22,
								Line:   10,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   10,
									},
									File:   "state_changes_big_ok_to_info_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 37,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   10,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "tables |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 37,
									Line:   10,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   10,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 52,
											Line:   10,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   10,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 52,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   10,
												},
												File:   "state_changes_big_ok_to_info_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 52,
													Line:   10,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   10,
												},
												File:   "state_changes_big_ok_to_info_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 61,
													Line:   10,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   10,
													},
													File:   "state_changes_big_ok_to_info_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 62,
														Line:   10,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   10,
													},
													File:   "state_changes_big_ok_to_info_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 72,
														Line:   10,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   10,
									},
									File:   "state_changes_big_ok_to_info_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 47,
										Line:   10,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   10,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 47,
											Line:   10,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   10,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   10,
									},
									File:   "state_changes_big_ok_to_info_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   10,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   10,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   10,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   10,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   10,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   10,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   10,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   10,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "option monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   243,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "inData = \"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Note this input data is identical to the output data of the check test case, post pivot.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   13,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   13,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   243,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "\"\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   13,
						},
					},
				},
				Value: "\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost\n\n#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string\n#default,got,,,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost\n\n\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   252,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: info,cpu,1585254420000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,threshold,cpu-total,localhost,23.371648565879127,info\n\n\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   244,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   244,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   244,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   252,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "\"\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: info,cpu,1585254420000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,threshold,cpu-total,localhost,23.371648565879127,info\n\n\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   244,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true\n#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level\n,,0,057220dae1443000,cpu,statuses,Check: cpu is: info,cpu,1585254420000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,threshold,cpu-total,localhost,23.371648565879127,info\n\n\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   258,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "t_state_changes_big_ok_to_info = (table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"ok\",\n        toLevel: \"info\",\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   253,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 31,
							Line:   253,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "t_state_changes_big_ok_to_info",
						Start: ast.Position{
							Column: 1,
							Line:   253,
						},
					},
				},
				Name: "t_state_changes_big_ok_to_info",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   258,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "(table=<-) => table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"ok\",\n        toLevel: \"info\",\n    )",
						Start: ast.Position{
							Column: 34,
							Line:   253,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   253,
									},
									File:   "state_changes_big_ok_to_info_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 48,
										Line:   253,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   254,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "table\n    |> v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 48,
									Line:   253,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   254,
									},
									File:   "state_changes_big_ok_to_info_test.flux",
									Source: "v1.fieldsAsCols()",
									Start: ast.Position{
										Column: 8,
										Line:   254,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   254,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "v1.fieldsAsCols",
										Start: ast.Position{
											Column: 8,
											Line:   254,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   254,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "v1",
											Start: ast.Position{
												Column: 8,
												Line:   254,
											},
										},
									},
									Name: "v1",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   254,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "fieldsAsCols",
											Start: ast.Position{
												Column: 11,
												Line:   254,
											},
										},
									},
									Name: "fieldsAsCols",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   258,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "table\n    |> v1.fieldsAsCols()\n    |> monitor.stateChanges(\n        fromLevel: \"ok\",\n        toLevel: \"info\",\n    )",
							Start: ast.Position{
								Column: 48,
								Line:   253,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   257,
									},
									File:   "state_changes_big_ok_to_info_test.flux",
									Source: "fromLevel: \"ok\",\n        toLevel: \"info\"",
									Start: ast.Position{
										Column: 9,
										Line:   256,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   256,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "fromLevel: \"ok\"",
										Start: ast.Position{
											Column: 9,
											Line:   256,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   256,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "fromLevel",
											Start: ast.Position{
												Column: 9,
												Line:   256,
											},
										},
									},
									Name: "fromLevel",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   256,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "\"ok\"",
											Start: ast.Position{
												Column: 20,
												Line:   256,
											},
										},
									},
									Value: "ok",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   257,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "toLevel: \"info\"",
										Start: ast.Position{
											Column: 9,
											Line:   257,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   257,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "toLevel",
											Start: ast.Position{
												Column: 9,
												Line:   257,
											},
										},
									},
									Name: "toLevel",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   257,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "\"info\"",
											Start: ast.Position{
												Column: 18,
												Line:   257,
											},
										},
									},
									Value: "info",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   258,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "monitor.stateChanges(\n        fromLevel: \"ok\",\n        toLevel: \"info\",\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   255,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   255,
									},
									File:   "state_changes_big_ok_to_info_test.flux",
									Source: "monitor.stateChanges",
									Start: ast.Position{
										Column: 8,
										Line:   255,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   255,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "monitor",
										Start: ast.Position{
											Column: 8,
											Line:   255,
										},
									},
								},
								Name: "monitor",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   255,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "stateChanges",
										Start: ast.Position{
											Column: 16,
											Line:   255,
										},
									},
								},
								Name: "stateChanges",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   253,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 35,
								Line:   253,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   253,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 35,
									Line:   253,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   253,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 41,
								Line:   253,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 167,
							Line:   260,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "monitor_state_changes_big_ok_to_info = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_ok_to_info})",
						Start: ast.Position{
							Column: 6,
							Line:   260,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   260,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "monitor_state_changes_big_ok_to_info",
							Start: ast.Position{
								Column: 6,
								Line:   260,
							},
						},
					},
					Name: "monitor_state_changes_big_ok_to_info",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 167,
								Line:   260,
							},
							File:   "state_changes_big_ok_to_info_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_ok_to_info})",
							Start: ast.Position{
								Column: 45,
								Line:   260,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 167,
									Line:   260,
								},
								File:   "state_changes_big_ok_to_info_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_ok_to_info})",
								Start: ast.Position{
									Column: 51,
									Line:   260,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 166,
										Line:   260,
									},
									File:   "state_changes_big_ok_to_info_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_ok_to_info}",
									Start: ast.Position{
										Column: 52,
										Line:   260,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   260,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 53,
											Line:   260,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   260,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 53,
												Line:   260,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   260,
												},
												File:   "state_changes_big_ok_to_info_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 80,
													Line:   260,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   260,
													},
													File:   "state_changes_big_ok_to_info_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 80,
														Line:   260,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 83,
															Line:   260,
														},
														File:   "state_changes_big_ok_to_info_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 80,
															Line:   260,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 91,
															Line:   260,
														},
														File:   "state_changes_big_ok_to_info_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 85,
															Line:   260,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   260,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 60,
												Line:   260,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   260,
												},
												File:   "state_changes_big_ok_to_info_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 60,
													Line:   260,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   260,
													},
													File:   "state_changes_big_ok_to_info_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 60,
														Line:   260,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   260,
													},
													File:   "state_changes_big_ok_to_info_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 68,
														Line:   260,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 129,
											Line:   260,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 94,
											Line:   260,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   260,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 94,
												Line:   260,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 128,
													Line:   260,
												},
												File:   "state_changes_big_ok_to_info_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 116,
													Line:   260,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 128,
														Line:   260,
													},
													File:   "state_changes_big_ok_to_info_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 116,
														Line:   260,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 119,
															Line:   260,
														},
														File:   "state_changes_big_ok_to_info_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 116,
															Line:   260,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 128,
															Line:   260,
														},
														File:   "state_changes_big_ok_to_info_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 121,
															Line:   260,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 129,
												Line:   260,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 100,
												Line:   260,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 115,
													Line:   260,
												},
												File:   "state_changes_big_ok_to_info_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 100,
													Line:   260,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   260,
													},
													File:   "state_changes_big_ok_to_info_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 100,
														Line:   260,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 115,
														Line:   260,
													},
													File:   "state_changes_big_ok_to_info_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 108,
														Line:   260,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 165,
											Line:   260,
										},
										File:   "state_changes_big_ok_to_info_test.flux",
										Source: "fn: t_state_changes_big_ok_to_info",
										Start: ast.Position{
											Column: 131,
											Line:   260,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 133,
												Line:   260,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 131,
												Line:   260,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 165,
												Line:   260,
											},
											File:   "state_changes_big_ok_to_info_test.flux",
											Source: "t_state_changes_big_ok_to_info",
											Start: ast.Position{
												Column: 135,
												Line:   260,
											},
										},
									},
									Name: "t_state_changes_big_ok_to_info",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 167,
						Line:   260,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "test monitor_state_changes_big_ok_to_info = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_ok_to_info})",
					Start: ast.Position{
						Column: 1,
						Line:   260,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   4,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   4,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   5,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   5,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   7,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   7,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "state_changes_big_ok_to_info_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "state_changes_big_ok_to_info_test.flux",
					Source: "package monitor_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "state_changes_big_ok_to_info_test.flux",
						Source: "monitor_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 173,
					Line:   148,
				},
				File:   "state_changes_custom_any_to_any_test.flux",
				Source: "package monitor_test\n\n\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/v1\"\nimport \"testing\"\nimport \"experimental\"\n\noption monitor.log = (tables=<-) => tables |> drop(columns: [\"_start\", \"_stop\"])\n\n// These statuses were produce by custom check query\ninData = \"\n#group,false,false,false,false,true,true,true,true,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,\n,result,table,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,id\n,,0,2020-04-01T13:20:01.055501743Z,GO506_20_8813 is in,000000000000000a,LLIR,_message,ok,statuses,mta,custom,GO506_20_8813\n,,0,2020-04-01T13:20:01.055589553Z,GO506_20_8813 is in,000000000000000a,LLIR,_message,ok,statuses,mta,custom,GO506_20_8813\n,,0,2020-04-01T13:20:01.055681722Z,GO506_20_8813 is in,000000000000000a,LLIR,_message,ok,statuses,mta,custom,GO506_20_8813\n,,0,2020-04-01T13:20:01.055731206Z,GO506_20_8813 is in,000000000000000a,LLIR,_message,ok,statuses,mta,custom,GO506_20_8813\n,,0,2020-04-01T13:20:01.055757119Z,GO506_20_8813 is in,000000000000000a,LLIR,_message,ok,statuses,mta,custom,GO506_20_8813\n,,0,2020-04-01T13:20:01.055841776Z,GO506_20_8813 is in,000000000000000a,LLIR,_message,ok,statuses,mta,custom,GO506_20_8813\n,,0,2020-04-01T13:20:01.055893004Z,GO506_20_8813 is in,000000000000000a,LLIR,_message,ok,statuses,mta,custom,GO506_20_8813\n,,0,2020-04-01T13:20:01.05593662Z,GO506_20_8813 is in,000000000000000a,LLIR,_message,ok,statuses,mta,custom,GO506_20_8813\n,,0,2020