// DO NOT EDIT: This file is autogenerated via the builtin command.

package strings

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 18,
					Line:   744,
				},
				File:   "strings.flux",
				Source: "package strings\n\n\n// title converts a string to title case.\n//\n// ## Parameters\n//\n// - `v` is the string value to convert.\n//\n// ## Convert all values of a column to title case\n//\n// ```\n//  import \"strings\"\n//\n//  data\n//      |> map(fn: (r) => ({ r with pageTitle: strings.title(v: r.pageTitle) }))\n//\nbuiltin title : (v: string) => string\n\n// toUpper converts a string to uppercase.\n//\n// ## Parameters\n//\n// - `v` is the string value to convert.\n//\n// ## Convert all values of a column to upper case\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({ r with envVars: strings.toUpper(v: r.envVars) }))\n// ```\n//\n// The difference between toTitle and toUpper\n//\n//      - The results of toUpper() and toTitle are often the same, however the difference is visible when using special characters:\n//\n//      - str = \"ǳ\"\n//\n//      - strings.toUpper(v: str) // Returns Ǳ\n//      - strings.toTitle(v: str) // Returns ǲ\n//\nbuiltin toUpper : (v: string) => string\n\n// toLower converts a string to lowercase.\n//\n// ## Parameters\n//\n// - `v` is the string value to convert.\n//\n// ## Convert all values of a column to lower case\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//        r with exclamation: strings.toLower(v: r.exclamation)\n//      })\n//    )\n// ```\n//\nbuiltin toLower : (v: string) => string\n\n// trim removes leading and trailing characters specified in the cutset from a string.\n//\n// ## Parameters\n//\n// - `v` is the string to remove characters from.\n// - `cutset` is the  leading and trailing characters to remove from the string.\n//\n//      Only characters that match the cutset string exactly are trimmed.\n//\n// ## Trim leading and trailing periods from all values in a column\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       variables: strings.trim(v: r.variables, cutset: \".\")\n//     })\n//   )\n//\nbuiltin trim : (v: string, cutset: string) => string\n\n// trimPrefix removes a prefix from a string. Strings that do not start with the prefix are returned unchanged.\n//\n// ## Parameters\n//\n// - `v` is the string to trim\n// - `prefix` is the prefix to remove\n//\n// ## Trim leading and trailing periods from all values in a column\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       sensorID: strings.trimPrefix(v: r.sensorId, prefix: \"s12_\")\n//     })\n//   )\n// ```\n//\nbuiltin trimPrefix : (v: string, prefix: string) => string\n\n// trimSpace removes leading and trailing spaces from a string.\n//\n// ## Parameters\n//\n// - `v` is the string to remove spaces from\n//\n// ## Trim leading and trailing spaces from all values in a column\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({ r with userInput: strings.trimSpace(v: r.userInput) }))\n// ```\nbuiltin trimSpace : (v: string) => string\n\n// The trimSuffix removes a suffix from a string. Strings that do not end with the suffix are returned unchanged.\n//\n// ## Parameters\n//\n// - `v` is the string to trim\n// - `suffix` is the suffix to remove.\n//\n// ## Remove a suffix from all values in a column\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       sensorID: strings.trimSuffix(v: r.sensorId, suffix: \"_s12\")\n//     })\n//   )\n// ```\n//\nbuiltin trimSuffix : (v: string, suffix: string) => string\n\n// trimRight removes trailing characters specified in the cutset from a string.\n//\n// ## Parameters\n//\n// - `v` is the string to to remove characters from\n// - `cutset` is the trailing characters to trim from the string.\n//\n//      Only characters that match the cutset string exactly are trimmed.\n//\n// ## Trim trailing periods from all values in a column\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       variables: strings.trimRight(v: r.variables, cutset: \".\")\n//     })\n//   )\n// ```\n//\nbuiltin trimRight : (v: string, cutset: string) => string\n\n// trimLeft removes specified leading characters from a string.\n//\n// ## Parameters\n//\n// - `v` is the string to to remove characters from\n// - `cutset` is the trailing characters to trim from the string.\n//\n// ## Trim leading periods from all values in a column\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       variables: strings.trimLeft(v: r.variables, cutset: \".\")\n//     })\n//   )\n// ```\n//\nbuiltin trimLeft : (v: string, cutset: string) => string\n\n// toTitle converts all characters in a string to title case.\n//\n// ## Parameters\n//\n// - `v` is the string value to convert.\n//\n// ## Convert characters in a string to title case\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({ r with pageTitle: strings.toTitle(v: r.pageTitle) }))\n// ```\n//\nbuiltin toTitle : (v: string) => string\n\n// hasPrefix indicates if a string begins with a specified prefix.\n//\n// ## Parameters\n//\n// - `v` is the string value to search.\n// - `prefix` is the string prefix to search for.\n//\n// ## Filter based on the presence of a prefix in a column value\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> filter(fn:(r) => strings.hasPrefix(v: r.metric, prefix: \"int_\" ))\n// ```\n//\nbuiltin hasPrefix : (v: string, prefix: string) => bool\n\n// hasSuffix indicates if a string ends with a specified suffix.\n//\n// ## Parameters\n//\n// - `v` is the string value to search.\n// - `prefix` is the string suffix to search for.\n//\n// ## Filter based on the presence of a suffix in a column value\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> filter(fn:(r) => strings.hasSuffix(v: r.metric, suffix: \"_count\" ))\n// ```\n//\nbuiltin hasSuffix : (v: string, suffix: string) => bool\n\n// containsStr reports whether a string contains a specified substring.\n//\n// ## Parameters\n//\n// - `v` is the string value to search\n// - `substr` is the substring value to search for\n//\n// ## Report if a string contains a specific substring\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       _value: strings.containsStr(v: r.author, substr: \"John\")\n//     })\n//   )\n// ```\n//\nbuiltin containsStr : (v: string, substr: string) => bool\n\n// containsAny reports whether a specified string contains characters from another string.\n//\n// ## Parameters\n//\n// - `v` is the string value to search\n// - `chars` is the character to search for\n//\n// ## Report if a string contains specific characters\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       _value: strings.containsAny(v: r.price, chars: \"£$¢\")\n//     })\n//   )\n// ```\n//\nbuiltin containsAny : (v: string, chars: string) => bool\n\n// equalFold reports whether two UTF-8 strings are equal under Unicode case-folding.\n//\n// ## Parameters\n//\n// - `v` is the string value to compare\n// - `t` is the string value to compare against\n//\n// ## Ignore case when testing if two strings are the same\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       string1: r.string1,\n//       string2: r.string2,\n//       same: strings.equalFold(v: r.string1, t: r.string2)\n//     })\n//   )\n// ```\n//\nbuiltin equalFold : (v: string, t: string) => bool\n\n// compare compares the lexicographical order of two strings.\n//\n//      Return values\n//      Comparison\tReturn value\n//      v < t\t    -1\n//      v == t\t    0\n//      v > t\t    1\n//\n// ## Parameters\n//\n// - `v` is the string value to compare\n// - `t` is the string value to compare against\n//\n// ## Compare the lexicographical order of column values\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       _value: strings.compare(v: r.tag1, t: r.tag2)\n//     })\n//   )\n// ```\n//\nbuiltin compare : (v: string, t: string) => int\n\n//countStr counts the number of non-overlapping instances of a substring appears in a string.\n//\n// ## Parameters\n//\n// - `v` is the string value to search\n// - `substr` is the substr value to count\n//\n//      The function counts only non-overlapping instances of substr. For example:\n//      strings.coutnStr(v: \"ooooo\", substr: \"oo\")\n//      // Returns 2 -- (oo)(oo)o\n//\n// ## Count instances of a substring within a string\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//        _value: strings.countStr(v: r.message, substr: \"uh\")\n//     })\n//   )\n// ```\n//\nbuiltin countStr : (v: string, substr: string) => int\n\n// index returns the index of the first instance of a substring in a string. If the substring is not present, it returns -1.\n//\n// ## Parameters\n//\n// - `v` is the string value to search\n// - `substr` is the substring to search for\n//\n// ## Find the first occurrence of a substring\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       the_index: strings.index(v: r.pageTitle, substr: \"the\")\n//     })\n//   )\n// ```\n//\nbuiltin index : (v: string, substr: string) => int\n\n// indexAny returns the index of the first instance of specified characters in a string. If none of the specified characters are present, it returns -1.\n//\n// ## Parameters\n//\n// - `v` is the string value to search\n// - `chars` are the chars to search for\n//\n// ## Find the first occurrence of characters from a string\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       charIndex: strings.indexAny(v: r._field, chars: \"_-\")\n//     })\n//   )\n// ```\n//\nbuiltin indexAny : (v: string, chars: string) => int\n\n// lastIndex returns the index of the last instance of a substring in a string. If the substring is not present, the function returns -1.\n//\n// ## Parameters\n//\n// - `v` is the string value to search\n// - `substr` is the substring to search for\n//\n// ## Find the last occurrence of a substring\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       the_index: strings.lastIndex(v: r.pageTitle, substr: \"the\")\n//     })\n//   )\n// ```\n//\nbuiltin lastIndex : (v: string, substr: string) => int\n\n// lastIndexAny returns the index of the last instance of any specified characters in a string. If none of the specified characters are present, the function returns -1.\n//\n// ## Parameters\n//\n// - `v` is the string value to search\n// - `chars` are the characters to search for\n//\n// ## Find the last occurrence of characters from a string\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       charLastIndex: strings.lastIndexAny(v: r._field, chars: \"_-\")\n//     })\n//   )\n// ```\n//\nbuiltin lastIndexAny : (v: string, chars: string) => int\n\n// isDigit tests if a single-character string is a digit (0-9).\n//\n// ## Parameters\n//\n// - `v` is the single-character string to test.\n//\n// ## Filter by columns with digits as values\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> filter(fn: (r) => strings.isDigit(v: r.serverRef))\n// ```\n//\nbuiltin isDigit : (v: string) => bool\n\n// isLetter tests if a single character string is a letter (a-z, A-Z).\n//\n// ## Parameters\n//\n// - `v` is the single-character string to test.\n//\n// ## Filter by columns with digits as values\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> filter(fn: (r) => strings.isLetter(v: r.serverRef))\n// ```\n//\nbuiltin isLetter : (v: string) => bool\n\n// isLower tests if a single-character string is lowercase.\n//\n// ## Parameters\n//\n// - `v` is the single-character string value to test.\n//\n// ## Filter by columns with single-letter lowercase values\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> filter(fn: (r) => strings.isLower(v: r.host))\n// ```\n//\nbuiltin isLower : (v: string) => bool\n\n// isUpper tests if a single character string is uppercase.\n//\n// ## Parameters\n//\n// - `v` is the single-character string value to test.\n//\n// ## Filter by columns with single-letter uppercase values\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> filter(fn: (r) => strings.isUpper(v: r.host))\n// ```\n//\nbuiltin isUpper : (v: string) => bool\n\n// repeat returns a string consisting of i copies of a specified string.\n//\n// ## Parameters\n//\n// - `v` is the string value to repeat.\n// - `i` is the number of times to repeat v.\n//\n// ## Repeat a string based on existing columns\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       laugh: r.laugh\n//       intensity: r.intensity\n//       laughter: strings.repeat(v: r.laugh, i: r.intensity)\n//     })\n//   )\n// ```\n//\nbuiltin repeat : (v: string, i: int) => string\n\n// replace replaces the first i non-overlapping instances of a substring with a specified replacement.\n//\n// ## Parameters\n//\n// - `v` is the string value to search.\n// - `t` is the substring value to replace.\n// - `u` is the replacement for i instances of t.\n// - `i` is the number of non-overlapping t matches to replace.\n//\n// ## Replace a specific number of string matches\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       content: strings.replace(v: r.content, t: \"he\", u: \"her\", i: 3)\n//     })\n//   )\n// ```\n//\nbuiltin replace : (v: string, t: string, u: string, i: int) => string\n\n// replaceAll replaces all non-overlapping instances of a substring with a specified replacement.\n//\n// ## Parameters\n//\n// - `v` is the string value to search.\n// - `t` is the substring to replace.\n// - `u` is the replacement for all instances of t.\n//\n// ## Replace string matches\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       content: strings.replaceAll(v: r.content, t: \"he\", u: \"her\")\n//     })\n//   )\n// ```\n//\nbuiltin replaceAll : (v: string, t: string, u: string) => string\n\n// split splits a string on a specified separator and returns an array of substrings.\n//\n// ## Parameters\n//\n// - `v` is the string value to split.\n// - `t` is the string value that acts as the separator.\n//\n// ## Split a string into an array of substrings\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map (fn:(r) => strings.split(v: r.searchTags, t: \",\"))\n// ```\n//\nbuiltin split : (v: string, t: string) => [string]\n\n// splitAfter splits a string after a specified separator and returns an array of substrings. Split substrings include the separator, t.\n//\n// ## Parameters\n//\n// - `v` is the string value to split.\n// - `t` is the string value that acts as the separator.\n//\n// ## Split a string into an array of substrings\n//\n// ```\n// import \"strings\"\n//\n// data\n//    |> map (fn:(r) => strings.splitAfter(v: r.searchTags, t: \",\"))\n// ```\n//\nbuiltin splitAfter : (v: string, t: string) => [string]\n\n// splitN splits a string on a specified separator and returns an array of i substrings.\n//\n// ## Parameters\n//\n// - `v` is the string value to split.\n// - `t` is the string value that acts as the separator.\n// - `i` is the maximum number of split substrings to return. -1 returns all matching substrings.\n//\n//       - The last substring is the unsplit remainder.\n//\n// ## Split a string into an array of substrings\n//\n// ```\n// import \"strings\"\n//\n// data\n//    |> map (fn:(r) => strings.splitN(v: r.searchTags, t: \",\"))\n// ```\n//\nbuiltin splitN : (v: string, t: string, n: int) => [string]\n\n// splitAfterN splits a string after a specified separator and returns an array of i substrings. Split substrings include the separator t.\n//\n// ## Parameters\n//\n// - `v` is the string value to split.\n// - `t` is the string value that acts as the separator.\n// - `i` is the maximum number of split substrings to return. -1 returns all matching substrings.\n//\n//       - The last substring is the unsplit remainder.\n//\n// ## Split a string into an array of substrings\n//\n// ```\n// import \"strings\"\n//\n// data\n//    |> map (fn:(r) => strings.splitAfterN(v: r.searchTags, t: \",\"))\n// ```\n//\nbuiltin splitAfterN : (v: string, t: string, i: int) => [string]\n\n// joinStr concatenates elements of a string array into a single string using a specified separator.\n//\n// ## Parameters\n//\n// - `arr` is the array of strings to concatenate.\n// - `t` is the separator to use in the concatenated value.\n//\n// ## Join a list of strings into a single string\n//\n// ```\n// import \"strings\"\n//\n// searchTags = [\"tag1\", \"tag2\", \"tag3\"]\n//\n// strings.joinStr(arr: searchTags, v: \",\"))\n// ```\n//\nbuiltin joinStr : (arr: [string], v: string) => string\n\n// strlen returns the length of a string. String length is determined by the number of UTF code points a string contains.\n//\n// ## Parameters\n//\n// - `v` is the string value to measure.\n//\n// ## Filter based on string value length\n//\n// ```\n// import \"strings\"\n//\n// data\n//    |> filter(fn: (r) => strings.strlen(v: r._measurement) <= 4)\n// ```\n//\n// ## Store the length of string values\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       length: strings.strlen(v: r._value)\n//     })\n//   )\n// ```\n//\nbuiltin strlen : (v: string) => int\n\n// substring returns a substring based on start and end parameters. These parameters are represent indices of UTF code points in the string.\n//\n// ## Parameters\n//\n// - `v` is the string value to search for.\n// - `start` is the starting inclusive index of the substring.\n// - `end` is the ending exclusive index of the substring.\n//\n// ## Store the first four characters of a string\n//\n// ```\n// import \"strings\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       abbr: strings.substring(v: r.name, start: 0, end: 4)\n//     })\n//   )\n// ```\nbuiltin substring",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// title converts a string to title case.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to convert.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Convert all values of a column to title case\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//  import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//  data\n"}, ast.Comment{Text: "//      |> map(fn: (r) => ({ r with pageTitle: strings.title(v: r.pageTitle) }))\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   19,
					},
					File:   "strings.flux",
					Source: "builtin title",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   19,
						},
						File:   "strings.flux",
						Source: "title",
						Start: ast.Position{
							Column: 9,
							Line:   19,
						},
					},
				},
				Name: "title",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   19,
						},
						File:   "strings.flux",
						Source: "(v: string) => string",
						Start: ast.Position{
							Column: 17,
							Line:   19,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   19,
							},
							File:   "strings.flux",
							Source: "(v: string) => string",
							Start: ast.Position{
								Column: 17,
								Line:   19,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   19,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 18,
									Line:   19,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   19,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   19,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   19,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   19,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   19,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   19,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   19,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 32,
									Line:   19,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   19,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 32,
										Line:   19,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// toUpper converts a string to uppercase.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to convert.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Convert all values of a column to upper case\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({ r with envVars: strings.toUpper(v: r.envVars) }))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The difference between toTitle and toUpper\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      - The results of toUpper() and toTitle are often the same, however the difference is visible when using special characters:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      - str = \"ǳ\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      - strings.toUpper(v: str) // Returns Ǳ\n"}, ast.Comment{Text: "//      - strings.toTitle(v: str) // Returns ǲ\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   45,
					},
					File:   "strings.flux",
					Source: "builtin toUpper",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   45,
						},
						File:   "strings.flux",
						Source: "toUpper",
						Start: ast.Position{
							Column: 9,
							Line:   45,
						},
					},
				},
				Name: "toUpper",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   45,
						},
						File:   "strings.flux",
						Source: "(v: string) => string",
						Start: ast.Position{
							Column: 19,
							Line:   45,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   45,
							},
							File:   "strings.flux",
							Source: "(v: string) => string",
							Start: ast.Position{
								Column: 19,
								Line:   45,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   45,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   45,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   45,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   45,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   45,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   45,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   45,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   45,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   45,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 34,
									Line:   45,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   45,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 34,
										Line:   45,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// toLower converts a string to lowercase.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to convert.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Convert all values of a column to lower case\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//        r with exclamation: strings.toLower(v: r.exclamation)\n"}, ast.Comment{Text: "//      })\n"}, ast.Comment{Text: "//    )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   65,
					},
					File:   "strings.flux",
					Source: "builtin toLower",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   65,
						},
						File:   "strings.flux",
						Source: "toLower",
						Start: ast.Position{
							Column: 9,
							Line:   65,
						},
					},
				},
				Name: "toLower",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   65,
						},
						File:   "strings.flux",
						Source: "(v: string) => string",
						Start: ast.Position{
							Column: 19,
							Line:   65,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   65,
							},
							File:   "strings.flux",
							Source: "(v: string) => string",
							Start: ast.Position{
								Column: 19,
								Line:   65,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   65,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   65,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   65,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   65,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   65,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   65,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   65,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   65,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   65,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 34,
									Line:   65,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   65,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 34,
										Line:   65,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// trim removes leading and trailing characters specified in the cutset from a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string to remove characters from.\n"}, ast.Comment{Text: "// - `cutset` is the  leading and trailing characters to remove from the string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Only characters that match the cutset string exactly are trimmed.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Trim leading and trailing periods from all values in a column\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       variables: strings.trim(v: r.variables, cutset: \".\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   88,
					},
					File:   "strings.flux",
					Source: "builtin trim",
					Start: ast.Position{
						Column: 1,
						Line:   88,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   88,
						},
						File:   "strings.flux",
						Source: "trim",
						Start: ast.Position{
							Column: 9,
							Line:   88,
						},
					},
				},
				Name: "trim",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 53,
							Line:   88,
						},
						File:   "strings.flux",
						Source: "(v: string, cutset: string) => string",
						Start: ast.Position{
							Column: 16,
							Line:   88,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   88,
							},
							File:   "strings.flux",
							Source: "(v: string, cutset: string) => string",
							Start: ast.Position{
								Column: 16,
								Line:   88,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   88,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 17,
									Line:   88,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   88,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   88,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   88,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 20,
										Line:   88,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   88,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 20,
											Line:   88,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   88,
								},
								File:   "strings.flux",
								Source: "cutset: string",
								Start: ast.Position{
									Column: 28,
									Line:   88,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   88,
									},
									File:   "strings.flux",
									Source: "cutset",
									Start: ast.Position{
										Column: 28,
										Line:   88,
									},
								},
							},
							Name: "cutset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   88,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   88,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   88,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 36,
											Line:   88,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   88,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 47,
									Line:   88,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   88,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 47,
										Line:   88,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// trimPrefix removes a prefix from a string. Strings that do not start with the prefix are returned unchanged.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string to trim\n"}, ast.Comment{Text: "// - `prefix` is the prefix to remove\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Trim leading and trailing periods from all values in a column\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       sensorID: strings.trimPrefix(v: r.sensorId, prefix: \"s12_\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   110,
					},
					File:   "strings.flux",
					Source: "builtin trimPrefix",
					Start: ast.Position{
						Column: 1,
						Line:   110,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   110,
						},
						File:   "strings.flux",
						Source: "trimPrefix",
						Start: ast.Position{
							Column: 9,
							Line:   110,
						},
					},
				},
				Name: "trimPrefix",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   110,
						},
						File:   "strings.flux",
						Source: "(v: string, prefix: string) => string",
						Start: ast.Position{
							Column: 22,
							Line:   110,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   110,
							},
							File:   "strings.flux",
							Source: "(v: string, prefix: string) => string",
							Start: ast.Position{
								Column: 22,
								Line:   110,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   110,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 23,
									Line:   110,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   110,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 23,
										Line:   110,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   110,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 26,
										Line:   110,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   110,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 26,
											Line:   110,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   110,
								},
								File:   "strings.flux",
								Source: "prefix: string",
								Start: ast.Position{
									Column: 34,
									Line:   110,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   110,
									},
									File:   "strings.flux",
									Source: "prefix",
									Start: ast.Position{
										Column: 34,
										Line:   110,
									},
								},
							},
							Name: "prefix",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   110,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   110,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   110,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   110,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   110,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 53,
									Line:   110,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   110,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 53,
										Line:   110,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// trimSpace removes leading and trailing spaces from a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string to remove spaces from\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Trim leading and trailing spaces from all values in a column\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({ r with userInput: strings.trimSpace(v: r.userInput) }))\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   126,
					},
					File:   "strings.flux",
					Source: "builtin trimSpace",
					Start: ast.Position{
						Column: 1,
						Line:   126,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   126,
						},
						File:   "strings.flux",
						Source: "trimSpace",
						Start: ast.Position{
							Column: 9,
							Line:   126,
						},
					},
				},
				Name: "trimSpace",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   126,
						},
						File:   "strings.flux",
						Source: "(v: string) => string",
						Start: ast.Position{
							Column: 21,
							Line:   126,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   126,
							},
							File:   "strings.flux",
							Source: "(v: string) => string",
							Start: ast.Position{
								Column: 21,
								Line:   126,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   126,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 22,
									Line:   126,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   126,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 22,
										Line:   126,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   126,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   126,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   126,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   126,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   126,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 36,
									Line:   126,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   126,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   126,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// The trimSuffix removes a suffix from a string. Strings that do not end with the suffix are returned unchanged.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string to trim\n"}, ast.Comment{Text: "// - `suffix` is the suffix to remove.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Remove a suffix from all values in a column\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       sensorID: strings.trimSuffix(v: r.sensorId, suffix: \"_s12\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   148,
					},
					File:   "strings.flux",
					Source: "builtin trimSuffix",
					Start: ast.Position{
						Column: 1,
						Line:   148,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   148,
						},
						File:   "strings.flux",
						Source: "trimSuffix",
						Start: ast.Position{
							Column: 9,
							Line:   148,
						},
					},
				},
				Name: "trimSuffix",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   148,
						},
						File:   "strings.flux",
						Source: "(v: string, suffix: string) => string",
						Start: ast.Position{
							Column: 22,
							Line:   148,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   148,
							},
							File:   "strings.flux",
							Source: "(v: string, suffix: string) => string",
							Start: ast.Position{
								Column: 22,
								Line:   148,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   148,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 23,
									Line:   148,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   148,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 23,
										Line:   148,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   148,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 26,
										Line:   148,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   148,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 26,
											Line:   148,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   148,
								},
								File:   "strings.flux",
								Source: "suffix: string",
								Start: ast.Position{
									Column: 34,
									Line:   148,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   148,
									},
									File:   "strings.flux",
									Source: "suffix",
									Start: ast.Position{
										Column: 34,
										Line:   148,
									},
								},
							},
							Name: "suffix",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   148,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   148,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   148,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   148,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   148,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 53,
									Line:   148,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   148,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 53,
										Line:   148,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// trimRight removes trailing characters specified in the cutset from a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string to to remove characters from\n"}, ast.Comment{Text: "// - `cutset` is the trailing characters to trim from the string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Only characters that match the cutset string exactly are trimmed.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Trim trailing periods from all values in a column\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       variables: strings.trimRight(v: r.variables, cutset: \".\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   172,
					},
					File:   "strings.flux",
					Source: "builtin trimRight",
					Start: ast.Position{
						Column: 1,
						Line:   172,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   172,
						},
						File:   "strings.flux",
						Source: "trimRight",
						Start: ast.Position{
							Column: 9,
							Line:   172,
						},
					},
				},
				Name: "trimRight",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 58,
							Line:   172,
						},
						File:   "strings.flux",
						Source: "(v: string, cutset: string) => string",
						Start: ast.Position{
							Column: 21,
							Line:   172,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   172,
							},
							File:   "strings.flux",
							Source: "(v: string, cutset: string) => string",
							Start: ast.Position{
								Column: 21,
								Line:   172,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   172,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 22,
									Line:   172,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   172,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 22,
										Line:   172,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   172,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   172,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   172,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   172,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   172,
								},
								File:   "strings.flux",
								Source: "cutset: string",
								Start: ast.Position{
									Column: 33,
									Line:   172,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   172,
									},
									File:   "strings.flux",
									Source: "cutset",
									Start: ast.Position{
										Column: 33,
										Line:   172,
									},
								},
							},
							Name: "cutset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   172,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   172,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   172,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   172,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   172,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 52,
									Line:   172,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   172,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 52,
										Line:   172,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// trimLeft removes specified leading characters from a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string to to remove characters from\n"}, ast.Comment{Text: "// - `cutset` is the trailing characters to trim from the string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Trim leading periods from all values in a column\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       variables: strings.trimLeft(v: r.variables, cutset: \".\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   194,
					},
					File:   "strings.flux",
					Source: "builtin trimLeft",
					Start: ast.Position{
						Column: 1,
						Line:   194,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   194,
						},
						File:   "strings.flux",
						Source: "trimLeft",
						Start: ast.Position{
							Column: 9,
							Line:   194,
						},
					},
				},
				Name: "trimLeft",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 57,
							Line:   194,
						},
						File:   "strings.flux",
						Source: "(v: string, cutset: string) => string",
						Start: ast.Position{
							Column: 20,
							Line:   194,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   194,
							},
							File:   "strings.flux",
							Source: "(v: string, cutset: string) => string",
							Start: ast.Position{
								Column: 20,
								Line:   194,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   194,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 21,
									Line:   194,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   194,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   194,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   194,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   194,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   194,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   194,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   194,
								},
								File:   "strings.flux",
								Source: "cutset: string",
								Start: ast.Position{
									Column: 32,
									Line:   194,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   194,
									},
									File:   "strings.flux",
									Source: "cutset",
									Start: ast.Position{
										Column: 32,
										Line:   194,
									},
								},
							},
							Name: "cutset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   194,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   194,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   194,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   194,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   194,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 51,
									Line:   194,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   194,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 51,
										Line:   194,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// toTitle converts all characters in a string to title case.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to convert.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Convert characters in a string to title case\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({ r with pageTitle: strings.toTitle(v: r.pageTitle) }))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   211,
					},
					File:   "strings.flux",
					Source: "builtin toTitle",
					Start: ast.Position{
						Column: 1,
						Line:   211,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   211,
						},
						File:   "strings.flux",
						Source: "toTitle",
						Start: ast.Position{
							Column: 9,
							Line:   211,
						},
					},
				},
				Name: "toTitle",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   211,
						},
						File:   "strings.flux",
						Source: "(v: string) => string",
						Start: ast.Position{
							Column: 19,
							Line:   211,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   211,
							},
							File:   "strings.flux",
							Source: "(v: string) => string",
							Start: ast.Position{
								Column: 19,
								Line:   211,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   211,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   211,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   211,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   211,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   211,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   211,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   211,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   211,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   211,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 34,
									Line:   211,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   211,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 34,
										Line:   211,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// hasPrefix indicates if a string begins with a specified prefix.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search.\n"}, ast.Comment{Text: "// - `prefix` is the string prefix to search for.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Filter based on the presence of a prefix in a column value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> filter(fn:(r) => strings.hasPrefix(v: r.metric, prefix: \"int_\" ))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   229,
					},
					File:   "strings.flux",
					Source: "builtin hasPrefix",
					Start: ast.Position{
						Column: 1,
						Line:   229,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   229,
						},
						File:   "strings.flux",
						Source: "hasPrefix",
						Start: ast.Position{
							Column: 9,
							Line:   229,
						},
					},
				},
				Name: "hasPrefix",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   229,
						},
						File:   "strings.flux",
						Source: "(v: string, prefix: string) => bool",
						Start: ast.Position{
							Column: 21,
							Line:   229,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   229,
							},
							File:   "strings.flux",
							Source: "(v: string, prefix: string) => bool",
							Start: ast.Position{
								Column: 21,
								Line:   229,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   229,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 22,
									Line:   229,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   229,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 22,
										Line:   229,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   229,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   229,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   229,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   229,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   229,
								},
								File:   "strings.flux",
								Source: "prefix: string",
								Start: ast.Position{
									Column: 33,
									Line:   229,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   229,
									},
									File:   "strings.flux",
									Source: "prefix",
									Start: ast.Position{
										Column: 33,
										Line:   229,
									},
								},
							},
							Name: "prefix",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   229,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   229,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   229,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   229,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   229,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 52,
									Line:   229,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   229,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 52,
										Line:   229,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// hasSuffix indicates if a string ends with a specified suffix.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search.\n"}, ast.Comment{Text: "// - `prefix` is the string suffix to search for.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Filter based on the presence of a suffix in a column value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> filter(fn:(r) => strings.hasSuffix(v: r.metric, suffix: \"_count\" ))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   247,
					},
					File:   "strings.flux",
					Source: "builtin hasSuffix",
					Start: ast.Position{
						Column: 1,
						Line:   247,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   247,
						},
						File:   "strings.flux",
						Source: "hasSuffix",
						Start: ast.Position{
							Column: 9,
							Line:   247,
						},
					},
				},
				Name: "hasSuffix",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   247,
						},
						File:   "strings.flux",
						Source: "(v: string, suffix: string) => bool",
						Start: ast.Position{
							Column: 21,
							Line:   247,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   247,
							},
							File:   "strings.flux",
							Source: "(v: string, suffix: string) => bool",
							Start: ast.Position{
								Column: 21,
								Line:   247,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   247,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 22,
									Line:   247,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   247,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 22,
										Line:   247,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   247,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   247,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   247,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   247,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   247,
								},
								File:   "strings.flux",
								Source: "suffix: string",
								Start: ast.Position{
									Column: 33,
									Line:   247,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   247,
									},
									File:   "strings.flux",
									Source: "suffix",
									Start: ast.Position{
										Column: 33,
										Line:   247,
									},
								},
							},
							Name: "suffix",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   247,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   247,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   247,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   247,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   247,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 52,
									Line:   247,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   247,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 52,
										Line:   247,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// containsStr reports whether a string contains a specified substring.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search\n"}, ast.Comment{Text: "// - `substr` is the substring value to search for\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Report if a string contains a specific substring\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       _value: strings.containsStr(v: r.author, substr: \"John\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   269,
					},
					File:   "strings.flux",
					Source: "builtin containsStr",
					Start: ast.Position{
						Column: 1,
						Line:   269,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   269,
						},
						File:   "strings.flux",
						Source: "containsStr",
						Start: ast.Position{
							Column: 9,
							Line:   269,
						},
					},
				},
				Name: "containsStr",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 58,
							Line:   269,
						},
						File:   "strings.flux",
						Source: "(v: string, substr: string) => bool",
						Start: ast.Position{
							Column: 23,
							Line:   269,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   269,
							},
							File:   "strings.flux",
							Source: "(v: string, substr: string) => bool",
							Start: ast.Position{
								Column: 23,
								Line:   269,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   269,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 24,
									Line:   269,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   269,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 24,
										Line:   269,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   269,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 27,
										Line:   269,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   269,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 27,
											Line:   269,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   269,
								},
								File:   "strings.flux",
								Source: "substr: string",
								Start: ast.Position{
									Column: 35,
									Line:   269,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   269,
									},
									File:   "strings.flux",
									Source: "substr",
									Start: ast.Position{
										Column: 35,
										Line:   269,
									},
								},
							},
							Name: "substr",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   269,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   269,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   269,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   269,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   269,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 54,
									Line:   269,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   269,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 54,
										Line:   269,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// containsAny reports whether a specified string contains characters from another string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search\n"}, ast.Comment{Text: "// - `chars` is the character to search for\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Report if a string contains specific characters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       _value: strings.containsAny(v: r.price, chars: \"£$¢\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   291,
					},
					File:   "strings.flux",
					Source: "builtin containsAny",
					Start: ast.Position{
						Column: 1,
						Line:   291,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   291,
						},
						File:   "strings.flux",
						Source: "containsAny",
						Start: ast.Position{
							Column: 9,
							Line:   291,
						},
					},
				},
				Name: "containsAny",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 57,
							Line:   291,
						},
						File:   "strings.flux",
						Source: "(v: string, chars: string) => bool",
						Start: ast.Position{
							Column: 23,
							Line:   291,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   291,
							},
							File:   "strings.flux",
							Source: "(v: string, chars: string) => bool",
							Start: ast.Position{
								Column: 23,
								Line:   291,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   291,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 24,
									Line:   291,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   291,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 24,
										Line:   291,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   291,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 27,
										Line:   291,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   291,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 27,
											Line:   291,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   291,
								},
								File:   "strings.flux",
								Source: "chars: string",
								Start: ast.Position{
									Column: 35,
									Line:   291,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   291,
									},
									File:   "strings.flux",
									Source: "chars",
									Start: ast.Position{
										Column: 35,
										Line:   291,
									},
								},
							},
							Name: "chars",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   291,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   291,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   291,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   291,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   291,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 53,
									Line:   291,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   291,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 53,
										Line:   291,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// equalFold reports whether two UTF-8 strings are equal under Unicode case-folding.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to compare\n"}, ast.Comment{Text: "// - `t` is the string value to compare against\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Ignore case when testing if two strings are the same\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       string1: r.string1,\n"}, ast.Comment{Text: "//       string2: r.string2,\n"}, ast.Comment{Text: "//       same: strings.equalFold(v: r.string1, t: r.string2)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   315,
					},
					File:   "strings.flux",
					Source: "builtin equalFold",
					Start: ast.Position{
						Column: 1,
						Line:   315,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   315,
						},
						File:   "strings.flux",
						Source: "equalFold",
						Start: ast.Position{
							Column: 9,
							Line:   315,
						},
					},
				},
				Name: "equalFold",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   315,
						},
						File:   "strings.flux",
						Source: "(v: string, t: string) => bool",
						Start: ast.Position{
							Column: 21,
							Line:   315,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   315,
							},
							File:   "strings.flux",
							Source: "(v: string, t: string) => bool",
							Start: ast.Position{
								Column: 21,
								Line:   315,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   315,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 22,
									Line:   315,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   315,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 22,
										Line:   315,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   315,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   315,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   315,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   315,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   315,
								},
								File:   "strings.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 33,
									Line:   315,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   315,
									},
									File:   "strings.flux",
									Source: "t",
									Start: ast.Position{
										Column: 33,
										Line:   315,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   315,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   315,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   315,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 36,
											Line:   315,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   315,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 47,
									Line:   315,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   315,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 47,
										Line:   315,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// compare compares the lexicographical order of two strings.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Return values\n"}, ast.Comment{Text: "//      Comparison\tReturn value\n"}, ast.Comment{Text: "//      v < t\t    -1\n"}, ast.Comment{Text: "//      v == t\t    0\n"}, ast.Comment{Text: "//      v > t\t    1\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to compare\n"}, ast.Comment{Text: "// - `t` is the string value to compare against\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Compare the lexicographical order of column values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       _value: strings.compare(v: r.tag1, t: r.tag2)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   343,
					},
					File:   "strings.flux",
					Source: "builtin compare",
					Start: ast.Position{
						Column: 1,
						Line:   343,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   343,
						},
						File:   "strings.flux",
						Source: "compare",
						Start: ast.Position{
							Column: 9,
							Line:   343,
						},
					},
				},
				Name: "compare",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 48,
							Line:   343,
						},
						File:   "strings.flux",
						Source: "(v: string, t: string) => int",
						Start: ast.Position{
							Column: 19,
							Line:   343,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   343,
							},
							File:   "strings.flux",
							Source: "(v: string, t: string) => int",
							Start: ast.Position{
								Column: 19,
								Line:   343,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   343,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   343,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   343,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   343,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   343,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   343,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   343,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   343,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   343,
								},
								File:   "strings.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 31,
									Line:   343,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   343,
									},
									File:   "strings.flux",
									Source: "t",
									Start: ast.Position{
										Column: 31,
										Line:   343,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   343,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 34,
										Line:   343,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   343,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 34,
											Line:   343,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   343,
								},
								File:   "strings.flux",
								Source: "int",
								Start: ast.Position{
									Column: 45,
									Line:   343,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   343,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 45,
										Line:   343,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "//countStr counts the number of non-overlapping instances of a substring appears in a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search\n"}, ast.Comment{Text: "// - `substr` is the substr value to count\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      The function counts only non-overlapping instances of substr. For example:\n"}, ast.Comment{Text: "//      strings.coutnStr(v: \"ooooo\", substr: \"oo\")\n"}, ast.Comment{Text: "//      // Returns 2 -- (oo)(oo)o\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Count instances of a substring within a string\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//        _value: strings.countStr(v: r.message, substr: \"uh\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   369,
					},
					File:   "strings.flux",
					Source: "builtin countStr",
					Start: ast.Position{
						Column: 1,
						Line:   369,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   369,
						},
						File:   "strings.flux",
						Source: "countStr",
						Start: ast.Position{
							Column: 9,
							Line:   369,
						},
					},
				},
				Name: "countStr",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   369,
						},
						File:   "strings.flux",
						Source: "(v: string, substr: string) => int",
						Start: ast.Position{
							Column: 20,
							Line:   369,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   369,
							},
							File:   "strings.flux",
							Source: "(v: string, substr: string) => int",
							Start: ast.Position{
								Column: 20,
								Line:   369,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   369,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 21,
									Line:   369,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   369,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   369,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   369,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   369,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   369,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   369,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   369,
								},
								File:   "strings.flux",
								Source: "substr: string",
								Start: ast.Position{
									Column: 32,
									Line:   369,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   369,
									},
									File:   "strings.flux",
									Source: "substr",
									Start: ast.Position{
										Column: 32,
										Line:   369,
									},
								},
							},
							Name: "substr",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   369,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   369,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   369,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   369,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   369,
								},
								File:   "strings.flux",
								Source: "int",
								Start: ast.Position{
									Column: 51,
									Line:   369,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   369,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 51,
										Line:   369,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// index returns the index of the first instance of a substring in a string. If the substring is not present, it returns -1.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search\n"}, ast.Comment{Text: "// - `substr` is the substring to search for\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Find the first occurrence of a substring\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       the_index: strings.index(v: r.pageTitle, substr: \"the\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   391,
					},
					File:   "strings.flux",
					Source: "builtin index",
					Start: ast.Position{
						Column: 1,
						Line:   391,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   391,
						},
						File:   "strings.flux",
						Source: "index",
						Start: ast.Position{
							Column: 9,
							Line:   391,
						},
					},
				},
				Name: "index",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   391,
						},
						File:   "strings.flux",
						Source: "(v: string, substr: string) => int",
						Start: ast.Position{
							Column: 17,
							Line:   391,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   391,
							},
							File:   "strings.flux",
							Source: "(v: string, substr: string) => int",
							Start: ast.Position{
								Column: 17,
								Line:   391,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   391,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 18,
									Line:   391,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   391,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   391,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   391,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   391,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   391,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   391,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   391,
								},
								File:   "strings.flux",
								Source: "substr: string",
								Start: ast.Position{
									Column: 29,
									Line:   391,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   391,
									},
									File:   "strings.flux",
									Source: "substr",
									Start: ast.Position{
										Column: 29,
										Line:   391,
									},
								},
							},
							Name: "substr",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   391,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 37,
										Line:   391,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   391,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 37,
											Line:   391,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   391,
								},
								File:   "strings.flux",
								Source: "int",
								Start: ast.Position{
									Column: 48,
									Line:   391,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   391,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 48,
										Line:   391,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// indexAny returns the index of the first instance of specified characters in a string. If none of the specified characters are present, it returns -1.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search\n"}, ast.Comment{Text: "// - `chars` are the chars to search for\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Find the first occurrence of characters from a string\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       charIndex: strings.indexAny(v: r._field, chars: \"_-\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   413,
					},
					File:   "strings.flux",
					Source: "builtin indexAny",
					Start: ast.Position{
						Column: 1,
						Line:   413,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   413,
						},
						File:   "strings.flux",
						Source: "indexAny",
						Start: ast.Position{
							Column: 9,
							Line:   413,
						},
					},
				},
				Name: "indexAny",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 53,
							Line:   413,
						},
						File:   "strings.flux",
						Source: "(v: string, chars: string) => int",
						Start: ast.Position{
							Column: 20,
							Line:   413,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   413,
							},
							File:   "strings.flux",
							Source: "(v: string, chars: string) => int",
							Start: ast.Position{
								Column: 20,
								Line:   413,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   413,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 21,
									Line:   413,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   413,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   413,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   413,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   413,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   413,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   413,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   413,
								},
								File:   "strings.flux",
								Source: "chars: string",
								Start: ast.Position{
									Column: 32,
									Line:   413,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   413,
									},
									File:   "strings.flux",
									Source: "chars",
									Start: ast.Position{
										Column: 32,
										Line:   413,
									},
								},
							},
							Name: "chars",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   413,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 39,
										Line:   413,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   413,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 39,
											Line:   413,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   413,
								},
								File:   "strings.flux",
								Source: "int",
								Start: ast.Position{
									Column: 50,
									Line:   413,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   413,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 50,
										Line:   413,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// lastIndex returns the index of the last instance of a substring in a string. If the substring is not present, the function returns -1.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search\n"}, ast.Comment{Text: "// - `substr` is the substring to search for\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Find the last occurrence of a substring\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       the_index: strings.lastIndex(v: r.pageTitle, substr: \"the\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   435,
					},
					File:   "strings.flux",
					Source: "builtin lastIndex",
					Start: ast.Position{
						Column: 1,
						Line:   435,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   435,
						},
						File:   "strings.flux",
						Source: "lastIndex",
						Start: ast.Position{
							Column: 9,
							Line:   435,
						},
					},
				},
				Name: "lastIndex",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   435,
						},
						File:   "strings.flux",
						Source: "(v: string, substr: string) => int",
						Start: ast.Position{
							Column: 21,
							Line:   435,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   435,
							},
							File:   "strings.flux",
							Source: "(v: string, substr: string) => int",
							Start: ast.Position{
								Column: 21,
								Line:   435,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   435,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 22,
									Line:   435,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   435,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 22,
										Line:   435,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   435,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   435,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   435,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   435,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   435,
								},
								File:   "strings.flux",
								Source: "substr: string",
								Start: ast.Position{
									Column: 33,
									Line:   435,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   435,
									},
									File:   "strings.flux",
									Source: "substr",
									Start: ast.Position{
										Column: 33,
										Line:   435,
									},
								},
							},
							Name: "substr",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   435,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   435,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   435,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   435,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   435,
								},
								File:   "strings.flux",
								Source: "int",
								Start: ast.Position{
									Column: 52,
									Line:   435,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   435,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 52,
										Line:   435,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// lastIndexAny returns the index of the last instance of any specified characters in a string. If none of the specified characters are present, the function returns -1.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search\n"}, ast.Comment{Text: "// - `chars` are the characters to search for\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Find the last occurrence of characters from a string\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       charLastIndex: strings.lastIndexAny(v: r._field, chars: \"_-\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   457,
					},
					File:   "strings.flux",
					Source: "builtin lastIndexAny",
					Start: ast.Position{
						Column: 1,
						Line:   457,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   457,
						},
						File:   "strings.flux",
						Source: "lastIndexAny",
						Start: ast.Position{
							Column: 9,
							Line:   457,
						},
					},
				},
				Name: "lastIndexAny",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 57,
							Line:   457,
						},
						File:   "strings.flux",
						Source: "(v: string, chars: string) => int",
						Start: ast.Position{
							Column: 24,
							Line:   457,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   457,
							},
							File:   "strings.flux",
							Source: "(v: string, chars: string) => int",
							Start: ast.Position{
								Column: 24,
								Line:   457,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   457,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 25,
									Line:   457,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   457,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 25,
										Line:   457,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   457,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 28,
										Line:   457,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   457,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 28,
											Line:   457,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   457,
								},
								File:   "strings.flux",
								Source: "chars: string",
								Start: ast.Position{
									Column: 36,
									Line:   457,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   457,
									},
									File:   "strings.flux",
									Source: "chars",
									Start: ast.Position{
										Column: 36,
										Line:   457,
									},
								},
							},
							Name: "chars",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   457,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   457,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   457,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   457,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   457,
								},
								File:   "strings.flux",
								Source: "int",
								Start: ast.Position{
									Column: 54,
									Line:   457,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   457,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 54,
										Line:   457,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// isDigit tests if a single-character string is a digit (0-9).\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the single-character string to test.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Filter by columns with digits as values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> filter(fn: (r) => strings.isDigit(v: r.serverRef))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   474,
					},
					File:   "strings.flux",
					Source: "builtin isDigit",
					Start: ast.Position{
						Column: 1,
						Line:   474,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   474,
						},
						File:   "strings.flux",
						Source: "isDigit",
						Start: ast.Position{
							Column: 9,
							Line:   474,
						},
					},
				},
				Name: "isDigit",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   474,
						},
						File:   "strings.flux",
						Source: "(v: string) => bool",
						Start: ast.Position{
							Column: 19,
							Line:   474,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   474,
							},
							File:   "strings.flux",
							Source: "(v: string) => bool",
							Start: ast.Position{
								Column: 19,
								Line:   474,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   474,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   474,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   474,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   474,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   474,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   474,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   474,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   474,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   474,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 34,
									Line:   474,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   474,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 34,
										Line:   474,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// isLetter tests if a single character string is a letter (a-z, A-Z).\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the single-character string to test.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Filter by columns with digits as values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> filter(fn: (r) => strings.isLetter(v: r.serverRef))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   491,
					},
					File:   "strings.flux",
					Source: "builtin isLetter",
					Start: ast.Position{
						Column: 1,
						Line:   491,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   491,
						},
						File:   "strings.flux",
						Source: "isLetter",
						Start: ast.Position{
							Column: 9,
							Line:   491,
						},
					},
				},
				Name: "isLetter",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   491,
						},
						File:   "strings.flux",
						Source: "(v: string) => bool",
						Start: ast.Position{
							Column: 20,
							Line:   491,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   491,
							},
							File:   "strings.flux",
							Source: "(v: string) => bool",
							Start: ast.Position{
								Column: 20,
								Line:   491,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   491,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 21,
									Line:   491,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   491,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   491,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   491,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   491,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   491,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   491,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   491,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 35,
									Line:   491,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   491,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 35,
										Line:   491,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// isLower tests if a single-character string is lowercase.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the single-character string value to test.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Filter by columns with single-letter lowercase values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> filter(fn: (r) => strings.isLower(v: r.host))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   508,
					},
					File:   "strings.flux",
					Source: "builtin isLower",
					Start: ast.Position{
						Column: 1,
						Line:   508,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   508,
						},
						File:   "strings.flux",
						Source: "isLower",
						Start: ast.Position{
							Column: 9,
							Line:   508,
						},
					},
				},
				Name: "isLower",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   508,
						},
						File:   "strings.flux",
						Source: "(v: string) => bool",
						Start: ast.Position{
							Column: 19,
							Line:   508,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   508,
							},
							File:   "strings.flux",
							Source: "(v: string) => bool",
							Start: ast.Position{
								Column: 19,
								Line:   508,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   508,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   508,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   508,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   508,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   508,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   508,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   508,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   508,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   508,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 34,
									Line:   508,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   508,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 34,
										Line:   508,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// isUpper tests if a single character string is uppercase.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the single-character string value to test.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Filter by columns with single-letter uppercase values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> filter(fn: (r) => strings.isUpper(v: r.host))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   525,
					},
					File:   "strings.flux",
					Source: "builtin isUpper",
					Start: ast.Position{
						Column: 1,
						Line:   525,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   525,
						},
						File:   "strings.flux",
						Source: "isUpper",
						Start: ast.Position{
							Column: 9,
							Line:   525,
						},
					},
				},
				Name: "isUpper",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   525,
						},
						File:   "strings.flux",
						Source: "(v: string) => bool",
						Start: ast.Position{
							Column: 19,
							Line:   525,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   525,
							},
							File:   "strings.flux",
							Source: "(v: string) => bool",
							Start: ast.Position{
								Column: 19,
								Line:   525,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   525,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   525,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   525,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   525,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   525,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   525,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   525,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   525,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   525,
								},
								File:   "strings.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 34,
									Line:   525,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   525,
									},
									File:   "strings.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 34,
										Line:   525,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// repeat returns a string consisting of i copies of a specified string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to repeat.\n"}, ast.Comment{Text: "// - `i` is the number of times to repeat v.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Repeat a string based on existing columns\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       laugh: r.laugh\n"}, ast.Comment{Text: "//       intensity: r.intensity\n"}, ast.Comment{Text: "//       laughter: strings.repeat(v: r.laugh, i: r.intensity)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   548,
					},
					File:   "strings.flux",
					Source: "builtin repeat",
					Start: ast.Position{
						Column: 1,
						Line:   548,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   548,
						},
						File:   "strings.flux",
						Source: "repeat",
						Start: ast.Position{
							Column: 9,
							Line:   548,
						},
					},
				},
				Name: "repeat",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   548,
						},
						File:   "strings.flux",
						Source: "(v: string, i: int) => string",
						Start: ast.Position{
							Column: 18,
							Line:   548,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   548,
							},
							File:   "strings.flux",
							Source: "(v: string, i: int) => string",
							Start: ast.Position{
								Column: 18,
								Line:   548,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   548,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 19,
									Line:   548,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   548,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 19,
										Line:   548,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   548,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 22,
										Line:   548,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   548,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 22,
											Line:   548,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   548,
								},
								File:   "strings.flux",
								Source: "i: int",
								Start: ast.Position{
									Column: 30,
									Line:   548,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   548,
									},
									File:   "strings.flux",
									Source: "i",
									Start: ast.Position{
										Column: 30,
										Line:   548,
									},
								},
							},
							Name: "i",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   548,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 33,
										Line:   548,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   548,
										},
										File:   "strings.flux",
										Source: "int",
										Start: ast.Position{
											Column: 33,
											Line:   548,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   548,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 41,
									Line:   548,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   548,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   548,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// replace replaces the first i non-overlapping instances of a substring with a specified replacement.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search.\n"}, ast.Comment{Text: "// - `t` is the substring value to replace.\n"}, ast.Comment{Text: "// - `u` is the replacement for i instances of t.\n"}, ast.Comment{Text: "// - `i` is the number of non-overlapping t matches to replace.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Replace a specific number of string matches\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       content: strings.replace(v: r.content, t: \"he\", u: \"her\", i: 3)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   572,
					},
					File:   "strings.flux",
					Source: "builtin replace",
					Start: ast.Position{
						Column: 1,
						Line:   572,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   572,
						},
						File:   "strings.flux",
						Source: "replace",
						Start: ast.Position{
							Column: 9,
							Line:   572,
						},
					},
				},
				Name: "replace",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   572,
						},
						File:   "strings.flux",
						Source: "(v: string, t: string, u: string, i: int) => string",
						Start: ast.Position{
							Column: 19,
							Line:   572,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   572,
							},
							File:   "strings.flux",
							Source: "(v: string, t: string, u: string, i: int) => string",
							Start: ast.Position{
								Column: 19,
								Line:   572,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   572,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   572,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   572,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   572,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   572,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   572,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   572,
								},
								File:   "strings.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 31,
									Line:   572,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "t",
									Start: ast.Position{
										Column: 31,
										Line:   572,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 34,
										Line:   572,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   572,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 34,
											Line:   572,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   572,
								},
								File:   "strings.flux",
								Source: "u: string",
								Start: ast.Position{
									Column: 42,
									Line:   572,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "u",
									Start: ast.Position{
										Column: 42,
										Line:   572,
									},
								},
							},
							Name: "u",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   572,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   572,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 45,
											Line:   572,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   572,
								},
								File:   "strings.flux",
								Source: "i: int",
								Start: ast.Position{
									Column: 53,
									Line:   572,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "i",
									Start: ast.Position{
										Column: 53,
										Line:   572,
									},
								},
							},
							Name: "i",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 56,
										Line:   572,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   572,
										},
										File:   "strings.flux",
										Source: "int",
										Start: ast.Position{
											Column: 56,
											Line:   572,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   572,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 64,
									Line:   572,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   572,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 64,
										Line:   572,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// replaceAll replaces all non-overlapping instances of a substring with a specified replacement.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search.\n"}, ast.Comment{Text: "// - `t` is the substring to replace.\n"}, ast.Comment{Text: "// - `u` is the replacement for all instances of t.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Replace string matches\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       content: strings.replaceAll(v: r.content, t: \"he\", u: \"her\")\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   595,
					},
					File:   "strings.flux",
					Source: "builtin replaceAll",
					Start: ast.Position{
						Column: 1,
						Line:   595,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   595,
						},
						File:   "strings.flux",
						Source: "replaceAll",
						Start: ast.Position{
							Column: 9,
							Line:   595,
						},
					},
				},
				Name: "replaceAll",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   595,
						},
						File:   "strings.flux",
						Source: "(v: string, t: string, u: string) => string",
						Start: ast.Position{
							Column: 22,
							Line:   595,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   595,
							},
							File:   "strings.flux",
							Source: "(v: string, t: string, u: string) => string",
							Start: ast.Position{
								Column: 22,
								Line:   595,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   595,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 23,
									Line:   595,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   595,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 23,
										Line:   595,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   595,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 26,
										Line:   595,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   595,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 26,
											Line:   595,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   595,
								},
								File:   "strings.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 34,
									Line:   595,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   595,
									},
									File:   "strings.flux",
									Source: "t",
									Start: ast.Position{
										Column: 34,
										Line:   595,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   595,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 37,
										Line:   595,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   595,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 37,
											Line:   595,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   595,
								},
								File:   "strings.flux",
								Source: "u: string",
								Start: ast.Position{
									Column: 45,
									Line:   595,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   595,
									},
									File:   "strings.flux",
									Source: "u",
									Start: ast.Position{
										Column: 45,
										Line:   595,
									},
								},
							},
							Name: "u",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   595,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 48,
										Line:   595,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   595,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 48,
											Line:   595,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   595,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 59,
									Line:   595,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   595,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 59,
										Line:   595,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// split splits a string on a specified separator and returns an array of substrings.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to split.\n"}, ast.Comment{Text: "// - `t` is the string value that acts as the separator.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Split a string into an array of substrings\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map (fn:(r) => strings.split(v: r.searchTags, t: \",\"))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   613,
					},
					File:   "strings.flux",
					Source: "builtin split",
					Start: ast.Position{
						Column: 1,
						Line:   613,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   613,
						},
						File:   "strings.flux",
						Source: "split",
						Start: ast.Position{
							Column: 9,
							Line:   613,
						},
					},
				},
				Name: "split",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   613,
						},
						File:   "strings.flux",
						Source: "(v: string, t: string) => [string]",
						Start: ast.Position{
							Column: 17,
							Line:   613,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   613,
							},
							File:   "strings.flux",
							Source: "(v: string, t: string) => [string]",
							Start: ast.Position{
								Column: 17,
								Line:   613,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   613,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 18,
									Line:   613,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   613,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   613,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   613,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   613,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   613,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   613,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   613,
								},
								File:   "strings.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 29,
									Line:   613,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   613,
									},
									File:   "strings.flux",
									Source: "t",
									Start: ast.Position{
										Column: 29,
										Line:   613,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   613,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 32,
										Line:   613,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   613,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 32,
											Line:   613,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   613,
								},
								File:   "strings.flux",
								Source: "[string]",
								Start: ast.Position{
									Column: 43,
									Line:   613,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   613,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 44,
										Line:   613,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   613,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 44,
											Line:   613,
										},
									},
								},
								Name: "string",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// splitAfter splits a string after a specified separator and returns an array of substrings. Split substrings include the separator, t.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to split.\n"}, ast.Comment{Text: "// - `t` is the string value that acts as the separator.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Split a string into an array of substrings\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//    |> map (fn:(r) => strings.splitAfter(v: r.searchTags, t: \",\"))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   631,
					},
					File:   "strings.flux",
					Source: "builtin splitAfter",
					Start: ast.Position{
						Column: 1,
						Line:   631,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   631,
						},
						File:   "strings.flux",
						Source: "splitAfter",
						Start: ast.Position{
							Column: 9,
							Line:   631,
						},
					},
				},
				Name: "splitAfter",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   631,
						},
						File:   "strings.flux",
						Source: "(v: string, t: string) => [string]",
						Start: ast.Position{
							Column: 22,
							Line:   631,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   631,
							},
							File:   "strings.flux",
							Source: "(v: string, t: string) => [string]",
							Start: ast.Position{
								Column: 22,
								Line:   631,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   631,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 23,
									Line:   631,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   631,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 23,
										Line:   631,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   631,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 26,
										Line:   631,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   631,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 26,
											Line:   631,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   631,
								},
								File:   "strings.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 34,
									Line:   631,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   631,
									},
									File:   "strings.flux",
									Source: "t",
									Start: ast.Position{
										Column: 34,
										Line:   631,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   631,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 37,
										Line:   631,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   631,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 37,
											Line:   631,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   631,
								},
								File:   "strings.flux",
								Source: "[string]",
								Start: ast.Position{
									Column: 48,
									Line:   631,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   631,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 49,
										Line:   631,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   631,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 49,
											Line:   631,
										},
									},
								},
								Name: "string",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// splitN splits a string on a specified separator and returns an array of i substrings.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to split.\n"}, ast.Comment{Text: "// - `t` is the string value that acts as the separator.\n"}, ast.Comment{Text: "// - `i` is the maximum number of split substrings to return. -1 returns all matching substrings.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//       - The last substring is the unsplit remainder.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Split a string into an array of substrings\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//    |> map (fn:(r) => strings.splitN(v: r.searchTags, t: \",\"))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   652,
					},
					File:   "strings.flux",
					Source: "builtin splitN",
					Start: ast.Position{
						Column: 1,
						Line:   652,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   652,
						},
						File:   "strings.flux",
						Source: "splitN",
						Start: ast.Position{
							Column: 9,
							Line:   652,
						},
					},
				},
				Name: "splitN",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 60,
							Line:   652,
						},
						File:   "strings.flux",
						Source: "(v: string, t: string, n: int) => [string]",
						Start: ast.Position{
							Column: 18,
							Line:   652,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   652,
							},
							File:   "strings.flux",
							Source: "(v: string, t: string, n: int) => [string]",
							Start: ast.Position{
								Column: 18,
								Line:   652,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   652,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 19,
									Line:   652,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   652,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 19,
										Line:   652,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   652,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 22,
										Line:   652,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   652,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 22,
											Line:   652,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   652,
								},
								File:   "strings.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 30,
									Line:   652,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   652,
									},
									File:   "strings.flux",
									Source: "t",
									Start: ast.Position{
										Column: 30,
										Line:   652,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   652,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 33,
										Line:   652,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   652,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 33,
											Line:   652,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   652,
								},
								File:   "strings.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 41,
									Line:   652,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   652,
									},
									File:   "strings.flux",
									Source: "n",
									Start: ast.Position{
										Column: 41,
										Line:   652,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   652,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 44,
										Line:   652,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   652,
										},
										File:   "strings.flux",
										Source: "int",
										Start: ast.Position{
											Column: 44,
											Line:   652,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   652,
								},
								File:   "strings.flux",
								Source: "[string]",
								Start: ast.Position{
									Column: 52,
									Line:   652,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   652,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 53,
										Line:   652,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   652,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 53,
											Line:   652,
										},
									},
								},
								Name: "string",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// splitAfterN splits a string after a specified separator and returns an array of i substrings. Split substrings include the separator t.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to split.\n"}, ast.Comment{Text: "// - `t` is the string value that acts as the separator.\n"}, ast.Comment{Text: "// - `i` is the maximum number of split substrings to return. -1 returns all matching substrings.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//       - The last substring is the unsplit remainder.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Split a string into an array of substrings\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//    |> map (fn:(r) => strings.splitAfterN(v: r.searchTags, t: \",\"))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   673,
					},
					File:   "strings.flux",
					Source: "builtin splitAfterN",
					Start: ast.Position{
						Column: 1,
						Line:   673,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   673,
						},
						File:   "strings.flux",
						Source: "splitAfterN",
						Start: ast.Position{
							Column: 9,
							Line:   673,
						},
					},
				},
				Name: "splitAfterN",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   673,
						},
						File:   "strings.flux",
						Source: "(v: string, t: string, i: int) => [string]",
						Start: ast.Position{
							Column: 23,
							Line:   673,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   673,
							},
							File:   "strings.flux",
							Source: "(v: string, t: string, i: int) => [string]",
							Start: ast.Position{
								Column: 23,
								Line:   673,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   673,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 24,
									Line:   673,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   673,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 24,
										Line:   673,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   673,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 27,
										Line:   673,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   673,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 27,
											Line:   673,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   673,
								},
								File:   "strings.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 35,
									Line:   673,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   673,
									},
									File:   "strings.flux",
									Source: "t",
									Start: ast.Position{
										Column: 35,
										Line:   673,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   673,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 38,
										Line:   673,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   673,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 38,
											Line:   673,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   673,
								},
								File:   "strings.flux",
								Source: "i: int",
								Start: ast.Position{
									Column: 46,
									Line:   673,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   673,
									},
									File:   "strings.flux",
									Source: "i",
									Start: ast.Position{
										Column: 46,
										Line:   673,
									},
								},
							},
							Name: "i",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   673,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 49,
										Line:   673,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   673,
										},
										File:   "strings.flux",
										Source: "int",
										Start: ast.Position{
											Column: 49,
											Line:   673,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   673,
								},
								File:   "strings.flux",
								Source: "[string]",
								Start: ast.Position{
									Column: 57,
									Line:   673,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   673,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 58,
										Line:   673,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   673,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 58,
											Line:   673,
										},
									},
								},
								Name: "string",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// joinStr concatenates elements of a string array into a single string using a specified separator.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `arr` is the array of strings to concatenate.\n"}, ast.Comment{Text: "// - `t` is the separator to use in the concatenated value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Join a list of strings into a single string\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// searchTags = [\"tag1\", \"tag2\", \"tag3\"]\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// strings.joinStr(arr: searchTags, v: \",\"))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   692,
					},
					File:   "strings.flux",
					Source: "builtin joinStr",
					Start: ast.Position{
						Column: 1,
						Line:   692,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   692,
						},
						File:   "strings.flux",
						Source: "joinStr",
						Start: ast.Position{
							Column: 9,
							Line:   692,
						},
					},
				},
				Name: "joinStr",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   692,
						},
						File:   "strings.flux",
						Source: "(arr: [string], v: string) => string",
						Start: ast.Position{
							Column: 19,
							Line:   692,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   692,
							},
							File:   "strings.flux",
							Source: "(arr: [string], v: string) => string",
							Start: ast.Position{
								Column: 19,
								Line:   692,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   692,
								},
								File:   "strings.flux",
								Source: "arr: [string]",
								Start: ast.Position{
									Column: 20,
									Line:   692,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   692,
									},
									File:   "strings.flux",
									Source: "arr",
									Start: ast.Position{
										Column: 20,
										Line:   692,
									},
								},
							},
							Name: "arr",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   692,
									},
									File:   "strings.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 25,
										Line:   692,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   692,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 26,
											Line:   692,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   692,
											},
											File:   "strings.flux",
											Source: "string",
											Start: ast.Position{
												Column: 26,
												Line:   692,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   692,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 35,
									Line:   692,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   692,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 35,
										Line:   692,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   692,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 38,
										Line:   692,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   692,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 38,
											Line:   692,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   692,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 49,
									Line:   692,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   692,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 49,
										Line:   692,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// strlen returns the length of a string. String length is determined by the number of UTF code points a string contains.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to measure.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Filter based on string value length\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//    |> filter(fn: (r) => strings.strlen(v: r._measurement) <= 4)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Store the length of string values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       length: strings.strlen(v: r._value)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   722,
					},
					File:   "strings.flux",
					Source: "builtin strlen",
					Start: ast.Position{
						Column: 1,
						Line:   722,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   722,
						},
						File:   "strings.flux",
						Source: "strlen",
						Start: ast.Position{
							Column: 9,
							Line:   722,
						},
					},
				},
				Name: "strlen",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   722,
						},
						File:   "strings.flux",
						Source: "(v: string) => int",
						Start: ast.Position{
							Column: 18,
							Line:   722,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   722,
							},
							File:   "strings.flux",
							Source: "(v: string) => int",
							Start: ast.Position{
								Column: 18,
								Line:   722,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   722,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 19,
									Line:   722,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   722,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 19,
										Line:   722,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   722,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 22,
										Line:   722,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   722,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 22,
											Line:   722,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   722,
								},
								File:   "strings.flux",
								Source: "int",
								Start: ast.Position{
									Column: 33,
									Line:   722,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   722,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 33,
										Line:   722,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// substring returns a substring based on start and end parameters. These parameters are represent indices of UTF code points in the string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `v` is the string value to search for.\n"}, ast.Comment{Text: "// - `start` is the starting inclusive index of the substring.\n"}, ast.Comment{Text: "// - `end` is the ending exclusive index of the substring.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Store the first four characters of a string\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"strings\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       abbr: strings.substring(v: r.name, start: 0, end: 4)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   744,
					},
					File:   "strings.flux",
					Source: "builtin substring",
					Start: ast.Position{
						Column: 1,
						Line:   744,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   744,
						},
						File:   "strings.flux",
						Source: "substring",
						Start: ast.Position{
							Column: 9,
							Line:   744,
						},
					},
				},
				Name: "substring",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 64,
							Line:   744,
						},
						File:   "strings.flux",
						Source: "(v: string, start: int, end: int) => string",
						Start: ast.Position{
							Column: 21,
							Line:   744,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   744,
							},
							File:   "strings.flux",
							Source: "(v: string, start: int, end: int) => string",
							Start: ast.Position{
								Column: 21,
								Line:   744,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   744,
								},
								File:   "strings.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 22,
									Line:   744,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   744,
									},
									File:   "strings.flux",
									Source: "v",
									Start: ast.Position{
										Column: 22,
										Line:   744,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   744,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   744,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   744,
										},
										File:   "strings.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   744,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   744,
								},
								File:   "strings.flux",
								Source: "start: int",
								Start: ast.Position{
									Column: 33,
									Line:   744,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   744,
									},
									File:   "strings.flux",
									Source: "start",
									Start: ast.Position{
										Column: 33,
										Line:   744,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   744,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 40,
										Line:   744,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   744,
										},
										File:   "strings.flux",
										Source: "int",
										Start: ast.Position{
											Column: 40,
											Line:   744,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   744,
								},
								File:   "strings.flux",
								Source: "end: int",
								Start: ast.Position{
									Column: 45,
									Line:   744,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   744,
									},
									File:   "strings.flux",
									Source: "end",
									Start: ast.Position{
										Column: 45,
										Line:   744,
									},
								},
							},
							Name: "end",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   744,
									},
									File:   "strings.flux",
									Source: "int",
									Start: ast.Position{
										Column: 50,
										Line:   744,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   744,
										},
										File:   "strings.flux",
										Source: "int",
										Start: ast.Position{
											Column: 50,
											Line:   744,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   744,
								},
								File:   "strings.flux",
								Source: "string",
								Start: ast.Position{
									Column: 58,
									Line:   744,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   744,
									},
									File:   "strings.flux",
									Source: "string",
									Start: ast.Position{
										Column: 58,
										Line:   744,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "strings.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package strings provides functions to manipulate UTF-8 encoded strings.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   2,
					},
					File:   "strings.flux",
					Source: "package strings",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   2,
						},
						File:   "strings.flux",
						Source: "strings",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "strings",
			},
		},
	}},
	Package: "strings",
	Path:    "strings",
}
