// DO NOT EDIT: This file is autogenerated via the builtin command.

package chronograf

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 136,
					Line:   97,
				},
				File:   "aggregate_window_count_test.flux",
				Source: "package chronograf_test\n\n\nimport \"testing\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,long\n#group,false,false,true,true,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.local,3\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.local,3\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,true,true,false,true,true,true,true,false\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,cpu,core1,host.local,3\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,cpu,core1,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,cpu,core2,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,cpu,core2,host.local,3\n\"\nagg_window_count_fn = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\")\n    |> filter(fn: (r) => r.host == \"host.local\")\n    |> aggregateWindow(every: 30s, fn: count)\n\ntest agg_window_count = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_count_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   71,
					},
					File:   "aggregate_window_count_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   71,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   90,
					},
					File:   "aggregate_window_count_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,long\n#group,false,false,true,true,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.local,3\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.local,3\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,true,true,false,true,true,true,true,false\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,cpu,core1,host.local,3\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,cpu,core1,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,cpu,core2,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,cpu,core2,host.local,3\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   72,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   72,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   72,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   90,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,long\n#group,false,false,true,true,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.local,3\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.local,3\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,true,true,false,true,true,true,true,false\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,cpu,core1,host.local,3\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,cpu,core1,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,cpu,core2,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,cpu,core2,host.local,3\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   72,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,long\n#group,false,false,true,true,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.local,3\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.local,3\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,true,true,false,true,true,true,true,false\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,cpu,core1,host.local,3\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,cpu,core1,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,cpu,core2,host.local,3\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,cpu,core2,host.local,3\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 46,
						Line:   95,
					},
					File:   "aggregate_window_count_test.flux",
					Source: "agg_window_count_fn = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\")\n    |> filter(fn: (r) => r.host == \"host.local\")\n    |> aggregateWindow(every: 30s, fn: count)",
					Start: ast.Position{
						Column: 1,
						Line:   91,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   91,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "agg_window_count_fn",
						Start: ast.Position{
							Column: 1,
							Line:   91,
						},
					},
				},
				Name: "agg_window_count_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 46,
							Line:   95,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\")\n    |> filter(fn: (r) => r.host == \"host.local\")\n    |> aggregateWindow(every: 30s, fn: count)",
						Start: ast.Position{
							Column: 23,
							Line:   91,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   91,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 37,
												Line:   91,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   92,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
										Start: ast.Position{
											Column: 37,
											Line:   91,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   92,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   92,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   92,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "start: 2018-05-22T00:00:00Z",
													Start: ast.Position{
														Column: 14,
														Line:   92,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   92,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   92,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   92,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "2018-05-22T00:00:00Z",
														Start: ast.Position{
															Column: 21,
															Line:   92,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   92,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "stop: 2018-05-22T00:01:00Z",
													Start: ast.Position{
														Column: 43,
														Line:   92,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   92,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 43,
															Line:   92,
														},
													},
												},
												Name: "stop",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   92,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "2018-05-22T00:01:00Z",
														Start: ast.Position{
															Column: 49,
															Line:   92,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T00:01:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   92,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
											Start: ast.Position{
												Column: 8,
												Line:   92,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   92,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   92,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   93,
									},
									File:   "aggregate_window_count_test.flux",
									Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\")",
									Start: ast.Position{
										Column: 37,
										Line:   91,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   93,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\"",
											Start: ast.Position{
												Column: 15,
												Line:   93,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   93,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\"",
												Start: ast.Position{
													Column: 15,
													Line:   93,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   93,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 15,
														Line:   93,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   93,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "(r) => r._measurement == \"disk\" or r._measurement == \"cpu\"",
													Start: ast.Position{
														Column: 19,
														Line:   93,
													},
												},
											},
											Body: &ast.LogicalExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   93,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "r._measurement == \"disk\" or r._measurement == \"cpu\"",
														Start: ast.Position{
															Column: 26,
															Line:   93,
														},
													},
												},
												Left: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   93,
															},
															File:   "aggregate_window_count_test.flux",
															Source: "r._measurement == \"disk\"",
															Start: ast.Position{
																Column: 26,
																Line:   93,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   93,
																},
																File:   "aggregate_window_count_test.flux",
																Source: "r._measurement",
																Start: ast.Position{
																	Column: 26,
																	Line:   93,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   93,
																	},
																	File:   "aggregate_window_count_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 26,
																		Line:   93,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   93,
																	},
																	File:   "aggregate_window_count_test.flux",
																	Source: "_measurement",
																	Start: ast.Position{
																		Column: 28,
																		Line:   93,
																	},
																},
															},
															Name: "_measurement",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   93,
																},
																File:   "aggregate_window_count_test.flux",
																Source: "\"disk\"",
																Start: ast.Position{
																	Column: 44,
																	Line:   93,
																},
															},
														},
														Value: "disk",
													},
												},
												Operator: 2,
												Right: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   93,
															},
															File:   "aggregate_window_count_test.flux",
															Source: "r._measurement == \"cpu\"",
															Start: ast.Position{
																Column: 54,
																Line:   93,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   93,
																},
																File:   "aggregate_window_count_test.flux",
																Source: "r._measurement",
																Start: ast.Position{
																	Column: 54,
																	Line:   93,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   93,
																	},
																	File:   "aggregate_window_count_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 54,
																		Line:   93,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   93,
																	},
																	File:   "aggregate_window_count_test.flux",
																	Source: "_measurement",
																	Start: ast.Position{
																		Column: 56,
																		Line:   93,
																	},
																},
															},
															Name: "_measurement",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   93,
																},
																File:   "aggregate_window_count_test.flux",
																Source: "\"cpu\"",
																Start: ast.Position{
																	Column: 72,
																	Line:   93,
																},
															},
														},
														Value: "cpu",
													},
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   93,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   93,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   93,
															},
															File:   "aggregate_window_count_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   93,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   93,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\")",
										Start: ast.Position{
											Column: 8,
											Line:   93,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   93,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 8,
												Line:   93,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   94,
								},
								File:   "aggregate_window_count_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\")\n    |> filter(fn: (r) => r.host == \"host.local\")",
								Start: ast.Position{
									Column: 37,
									Line:   91,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   94,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "fn: (r) => r.host == \"host.local\"",
										Start: ast.Position{
											Column: 15,
											Line:   94,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   94,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "fn: (r) => r.host == \"host.local\"",
											Start: ast.Position{
												Column: 15,
												Line:   94,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   94,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 15,
													Line:   94,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   94,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "(r) => r.host == \"host.local\"",
												Start: ast.Position{
													Column: 19,
													Line:   94,
												},
											},
										},
										Body: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   94,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "r.host == \"host.local\"",
													Start: ast.Position{
														Column: 26,
														Line:   94,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   94,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "r.host",
														Start: ast.Position{
															Column: 26,
															Line:   94,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   94,
															},
															File:   "aggregate_window_count_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 26,
																Line:   94,
															},
														},
													},
													Name: "r",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   94,
															},
															File:   "aggregate_window_count_test.flux",
															Source: "host",
															Start: ast.Position{
																Column: 28,
																Line:   94,
															},
														},
													},
													Name: "host",
												},
												Rbrack: nil,
											},
											Operator: 17,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   94,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "\"host.local\"",
														Start: ast.Position{
															Column: 36,
															Line:   94,
														},
													},
												},
												Value: "host.local",
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   94,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   94,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   94,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   94,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   94,
									},
									File:   "aggregate_window_count_test.flux",
									Source: "filter(fn: (r) => r.host == \"host.local\")",
									Start: ast.Position{
										Column: 8,
										Line:   94,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   94,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 8,
											Line:   94,
										},
									},
								},
								Name: "filter",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   95,
							},
							File:   "aggregate_window_count_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"cpu\")\n    |> filter(fn: (r) => r.host == \"host.local\")\n    |> aggregateWindow(every: 30s, fn: count)",
							Start: ast.Position{
								Column: 37,
								Line:   91,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   95,
									},
									File:   "aggregate_window_count_test.flux",
									Source: "every: 30s, fn: count",
									Start: ast.Position{
										Column: 24,
										Line:   95,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   95,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "every: 30s",
										Start: ast.Position{
											Column: 24,
											Line:   95,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   95,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "every",
											Start: ast.Position{
												Column: 24,
												Line:   95,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.DurationLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   95,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "30s",
											Start: ast.Position{
												Column: 31,
												Line:   95,
											},
										},
									},
									Values: []ast.Duration{ast.Duration{
										Magnitude: int64(30),
										Unit:      "s",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   95,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "fn: count",
										Start: ast.Position{
											Column: 36,
											Line:   95,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   95,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 36,
												Line:   95,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   95,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "count",
											Start: ast.Position{
												Column: 40,
												Line:   95,
											},
										},
									},
									Name: "count",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   95,
								},
								File:   "aggregate_window_count_test.flux",
								Source: "aggregateWindow(every: 30s, fn: count)",
								Start: ast.Position{
									Column: 8,
									Line:   95,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   95,
									},
									File:   "aggregate_window_count_test.flux",
									Source: "aggregateWindow",
									Start: ast.Position{
										Column: 8,
										Line:   95,
									},
								},
							},
							Name: "aggregateWindow",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   91,
							},
							File:   "aggregate_window_count_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 24,
								Line:   91,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   91,
								},
								File:   "aggregate_window_count_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 24,
									Line:   91,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   91,
							},
							File:   "aggregate_window_count_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 30,
								Line:   91,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 136,
							Line:   97,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "agg_window_count = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_count_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   97,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   97,
							},
							File:   "aggregate_window_count_test.flux",
							Source: "agg_window_count",
							Start: ast.Position{
								Column: 6,
								Line:   97,
							},
						},
					},
					Name: "agg_window_count",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   97,
							},
							File:   "aggregate_window_count_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_count_fn})",
							Start: ast.Position{
								Column: 25,
								Line:   97,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   97,
								},
								File:   "aggregate_window_count_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_count_fn})",
								Start: ast.Position{
									Column: 31,
									Line:   97,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 135,
										Line:   97,
									},
									File:   "aggregate_window_count_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_count_fn}",
									Start: ast.Position{
										Column: 32,
										Line:   97,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   97,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 33,
											Line:   97,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   97,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 33,
												Line:   97,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   97,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 60,
													Line:   97,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   97,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 60,
														Line:   97,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   97,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 60,
															Line:   97,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   97,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 65,
															Line:   97,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   97,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 40,
												Line:   97,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   97,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 40,
													Line:   97,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   97,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 40,
														Line:   97,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   97,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 48,
														Line:   97,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   97,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 74,
											Line:   97,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   97,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 74,
												Line:   97,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   97,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 96,
													Line:   97,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   97,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 96,
														Line:   97,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   97,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 96,
															Line:   97,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   97,
														},
														File:   "aggregate_window_count_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 101,
															Line:   97,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   97,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 80,
												Line:   97,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   97,
												},
												File:   "aggregate_window_count_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 80,
													Line:   97,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   97,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 80,
														Line:   97,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   97,
													},
													File:   "aggregate_window_count_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 88,
														Line:   97,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 134,
											Line:   97,
										},
										File:   "aggregate_window_count_test.flux",
										Source: "fn: agg_window_count_fn",
										Start: ast.Position{
											Column: 111,
											Line:   97,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   97,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 111,
												Line:   97,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 134,
												Line:   97,
											},
											File:   "aggregate_window_count_test.flux",
											Source: "agg_window_count_fn",
											Start: ast.Position{
												Column: 115,
												Line:   97,
											},
										},
									},
									Name: "agg_window_count_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 136,
						Line:   97,
					},
					File:   "aggregate_window_count_test.flux",
					Source: "test agg_window_count = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_count_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   97,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "aggregate_window_count_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_count_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "aggregate_window_count_test.flux",
					Source: "package chronograf_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "aggregate_window_count_test.flux",
						Source: "chronograf_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "chronograf_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 134,
					Line:   95,
				},
				File:   "aggregate_window_mean_test.flux",
				Source: "package chronograf_test\n\n\nimport \"testing\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.remote,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,mem,host.remote,35\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,mem,host.remote,35\n\"\nagg_window_mean_fn = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> aggregateWindow(every: 30s, fn: mean)\n\ntest agg_window_mean = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_mean_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   71,
					},
					File:   "aggregate_window_mean_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   71,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   88,
					},
					File:   "aggregate_window_mean_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.remote,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,mem,host.remote,35\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,mem,host.remote,35\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   72,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   72,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   72,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   88,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.remote,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,mem,host.remote,35\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,mem,host.remote,35\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   72,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.remote,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,percentage,mem,host.remote,35\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,percentage,mem,host.remote,35\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   93,
					},
					File:   "aggregate_window_mean_test.flux",
					Source: "agg_window_mean_fn = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> aggregateWindow(every: 30s, fn: mean)",
					Start: ast.Position{
						Column: 1,
						Line:   89,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   89,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "agg_window_mean_fn",
						Start: ast.Position{
							Column: 1,
							Line:   89,
						},
					},
				},
				Name: "agg_window_mean_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   93,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> aggregateWindow(every: 30s, fn: mean)",
						Start: ast.Position{
							Column: 22,
							Line:   89,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   89,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 36,
												Line:   89,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   90,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
										Start: ast.Position{
											Column: 36,
											Line:   89,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   90,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   90,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   90,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "start: 2018-05-22T00:00:00Z",
													Start: ast.Position{
														Column: 14,
														Line:   90,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   90,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   90,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   90,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "2018-05-22T00:00:00Z",
														Start: ast.Position{
															Column: 21,
															Line:   90,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   90,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "stop: 2018-05-22T00:01:00Z",
													Start: ast.Position{
														Column: 43,
														Line:   90,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   90,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 43,
															Line:   90,
														},
													},
												},
												Name: "stop",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   90,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "2018-05-22T00:01:00Z",
														Start: ast.Position{
															Column: 49,
															Line:   90,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T00:01:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   90,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
											Start: ast.Position{
												Column: 8,
												Line:   90,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   90,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   90,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   91,
									},
									File:   "aggregate_window_mean_test.flux",
									Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")",
									Start: ast.Position{
										Column: 36,
										Line:   89,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   91,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\"",
											Start: ast.Position{
												Column: 15,
												Line:   91,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   91,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\"",
												Start: ast.Position{
													Column: 15,
													Line:   91,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   91,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 15,
														Line:   91,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   91,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "(r) => r._measurement == \"disk\" or r._measurement == \"mem\"",
													Start: ast.Position{
														Column: 19,
														Line:   91,
													},
												},
											},
											Body: &ast.LogicalExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   91,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "r._measurement == \"disk\" or r._measurement == \"mem\"",
														Start: ast.Position{
															Column: 26,
															Line:   91,
														},
													},
												},
												Left: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   91,
															},
															File:   "aggregate_window_mean_test.flux",
															Source: "r._measurement == \"disk\"",
															Start: ast.Position{
																Column: 26,
																Line:   91,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   91,
																},
																File:   "aggregate_window_mean_test.flux",
																Source: "r._measurement",
																Start: ast.Position{
																	Column: 26,
																	Line:   91,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   91,
																	},
																	File:   "aggregate_window_mean_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 26,
																		Line:   91,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   91,
																	},
																	File:   "aggregate_window_mean_test.flux",
																	Source: "_measurement",
																	Start: ast.Position{
																		Column: 28,
																		Line:   91,
																	},
																},
															},
															Name: "_measurement",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   91,
																},
																File:   "aggregate_window_mean_test.flux",
																Source: "\"disk\"",
																Start: ast.Position{
																	Column: 44,
																	Line:   91,
																},
															},
														},
														Value: "disk",
													},
												},
												Operator: 2,
												Right: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   91,
															},
															File:   "aggregate_window_mean_test.flux",
															Source: "r._measurement == \"mem\"",
															Start: ast.Position{
																Column: 54,
																Line:   91,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   91,
																},
																File:   "aggregate_window_mean_test.flux",
																Source: "r._measurement",
																Start: ast.Position{
																	Column: 54,
																	Line:   91,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   91,
																	},
																	File:   "aggregate_window_mean_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 54,
																		Line:   91,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   91,
																	},
																	File:   "aggregate_window_mean_test.flux",
																	Source: "_measurement",
																	Start: ast.Position{
																		Column: 56,
																		Line:   91,
																	},
																},
															},
															Name: "_measurement",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   91,
																},
																File:   "aggregate_window_mean_test.flux",
																Source: "\"mem\"",
																Start: ast.Position{
																	Column: 72,
																	Line:   91,
																},
															},
														},
														Value: "mem",
													},
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   91,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   91,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   91,
															},
															File:   "aggregate_window_mean_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   91,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   91,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")",
										Start: ast.Position{
											Column: 8,
											Line:   91,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   91,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 8,
												Line:   91,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   92,
								},
								File:   "aggregate_window_mean_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")",
								Start: ast.Position{
									Column: 36,
									Line:   89,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   92,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "fn: (r) => r.host == \"host.remote\"",
										Start: ast.Position{
											Column: 15,
											Line:   92,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   92,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "fn: (r) => r.host == \"host.remote\"",
											Start: ast.Position{
												Column: 15,
												Line:   92,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   92,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 15,
													Line:   92,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   92,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "(r) => r.host == \"host.remote\"",
												Start: ast.Position{
													Column: 19,
													Line:   92,
												},
											},
										},
										Body: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   92,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "r.host == \"host.remote\"",
													Start: ast.Position{
														Column: 26,
														Line:   92,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   92,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "r.host",
														Start: ast.Position{
															Column: 26,
															Line:   92,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   92,
															},
															File:   "aggregate_window_mean_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 26,
																Line:   92,
															},
														},
													},
													Name: "r",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   92,
															},
															File:   "aggregate_window_mean_test.flux",
															Source: "host",
															Start: ast.Position{
																Column: 28,
																Line:   92,
															},
														},
													},
													Name: "host",
												},
												Rbrack: nil,
											},
											Operator: 17,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   92,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "\"host.remote\"",
														Start: ast.Position{
															Column: 36,
															Line:   92,
														},
													},
												},
												Value: "host.remote",
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   92,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   92,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   92,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   92,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   92,
									},
									File:   "aggregate_window_mean_test.flux",
									Source: "filter(fn: (r) => r.host == \"host.remote\")",
									Start: ast.Position{
										Column: 8,
										Line:   92,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   92,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 8,
											Line:   92,
										},
									},
								},
								Name: "filter",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   93,
							},
							File:   "aggregate_window_mean_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> aggregateWindow(every: 30s, fn: mean)",
							Start: ast.Position{
								Column: 36,
								Line:   89,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   93,
									},
									File:   "aggregate_window_mean_test.flux",
									Source: "every: 30s, fn: mean",
									Start: ast.Position{
										Column: 24,
										Line:   93,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   93,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "every: 30s",
										Start: ast.Position{
											Column: 24,
											Line:   93,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   93,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "every",
											Start: ast.Position{
												Column: 24,
												Line:   93,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.DurationLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   93,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "30s",
											Start: ast.Position{
												Column: 31,
												Line:   93,
											},
										},
									},
									Values: []ast.Duration{ast.Duration{
										Magnitude: int64(30),
										Unit:      "s",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   93,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "fn: mean",
										Start: ast.Position{
											Column: 36,
											Line:   93,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   93,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 36,
												Line:   93,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   93,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "mean",
											Start: ast.Position{
												Column: 40,
												Line:   93,
											},
										},
									},
									Name: "mean",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   93,
								},
								File:   "aggregate_window_mean_test.flux",
								Source: "aggregateWindow(every: 30s, fn: mean)",
								Start: ast.Position{
									Column: 8,
									Line:   93,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   93,
									},
									File:   "aggregate_window_mean_test.flux",
									Source: "aggregateWindow",
									Start: ast.Position{
										Column: 8,
										Line:   93,
									},
								},
							},
							Name: "aggregateWindow",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   89,
							},
							File:   "aggregate_window_mean_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   89,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   89,
								},
								File:   "aggregate_window_mean_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   89,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   89,
							},
							File:   "aggregate_window_mean_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   89,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 134,
							Line:   95,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "agg_window_mean = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_mean_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   95,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   95,
							},
							File:   "aggregate_window_mean_test.flux",
							Source: "agg_window_mean",
							Start: ast.Position{
								Column: 6,
								Line:   95,
							},
						},
					},
					Name: "agg_window_mean",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 134,
								Line:   95,
							},
							File:   "aggregate_window_mean_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_mean_fn})",
							Start: ast.Position{
								Column: 24,
								Line:   95,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 134,
									Line:   95,
								},
								File:   "aggregate_window_mean_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_mean_fn})",
								Start: ast.Position{
									Column: 30,
									Line:   95,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 133,
										Line:   95,
									},
									File:   "aggregate_window_mean_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_mean_fn}",
									Start: ast.Position{
										Column: 31,
										Line:   95,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   95,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   95,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   95,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   95,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   95,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   95,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   95,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   95,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   95,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   95,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   95,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   95,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   95,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   95,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   95,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   95,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   95,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   95,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   95,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   95,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   95,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   95,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   95,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   95,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   95,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   95,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   95,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   95,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   95,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   95,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   95,
														},
														File:   "aggregate_window_mean_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   95,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   95,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   95,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   95,
												},
												File:   "aggregate_window_mean_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   95,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   95,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   95,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   95,
													},
													File:   "aggregate_window_mean_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   95,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 132,
											Line:   95,
										},
										File:   "aggregate_window_mean_test.flux",
										Source: "fn: agg_window_mean_fn",
										Start: ast.Position{
											Column: 110,
											Line:   95,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   95,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   95,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 132,
												Line:   95,
											},
											File:   "aggregate_window_mean_test.flux",
											Source: "agg_window_mean_fn",
											Start: ast.Position{
												Column: 114,
												Line:   95,
											},
										},
									},
									Name: "agg_window_mean_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 134,
						Line:   95,
					},
					File:   "aggregate_window_mean_test.flux",
					Source: "test agg_window_mean = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_mean_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   95,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "aggregate_window_mean_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_mean_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "aggregate_window_mean_test.flux",
					Source: "package chronograf_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "aggregate_window_mean_test.flux",
						Source: "chronograf_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "chronograf_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 138,
					Line:   102,
				},
				File:   "aggregate_window_median_test.flux",
				Source: "package chronograf_test\n\n\nimport \"testing\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,0,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.remote,35\n,,1,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,false,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,mem,host.remote,35\n,,0,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,mem,host.remote,35\n\"\nagg_window_median_fn = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> window(period: 30s)\n    |> median()\n    |> group(columns: [\"_value\", \"_time\", \"_start\", \"_stop\"], mode: \"except\")\n\ntest agg_window_median = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_median_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   76,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   76,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.local,67.1\n,,0,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.local,67.4\n,,0,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.local,67.5\n,,0,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.local,67.6\n,,0,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,0,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.local,67.9\n,,1,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.local,92.2\n,,1,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.local,92.2\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_time,_measurement,_field,device,fstype,host,_value\n,,2,2018-05-22T00:00:00Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:10Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:20Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:30Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:40Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,2,2018-05-22T00:00:50Z,disk,percentage,disk1s1,apfs,host.remote,30\n,,3,2018-05-22T00:00:00Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:10Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:20Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:30Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:40Z,disk,percentage,disk2s1,apfs,host.remote,35\n,,3,2018-05-22T00:00:50Z,disk,percentage,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,device,host,_value\n,,0,2018-05-22T00:00:00Z,cpu,percentage,core1,host.local,89.7\n,,0,2018-05-22T00:00:10Z,cpu,percentage,core1,host.local,73.4\n,,0,2018-05-22T00:00:20Z,cpu,percentage,core1,host.local,88.8\n,,0,2018-05-22T00:00:30Z,cpu,percentage,core1,host.local,91.0\n,,0,2018-05-22T00:00:40Z,cpu,percentage,core1,host.local,81.1\n,,0,2018-05-22T00:00:50Z,cpu,percentage,core1,host.local,87.8\n,,1,2018-05-22T00:00:00Z,cpu,percentage,core2,host.local,70.3\n,,1,2018-05-22T00:00:10Z,cpu,percentage,core2,host.local,80.4\n,,1,2018-05-22T00:00:20Z,cpu,percentage,core2,host.local,95.6\n,,1,2018-05-22T00:00:30Z,cpu,percentage,core2,host.local,94.4\n,,1,2018-05-22T00:00:40Z,cpu,percentage,core2,host.local,91.2\n,,1,2018-05-22T00:00:50Z,cpu,percentage,core2,host.local,90.6\n\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,host,_value\n,,0,2018-05-22T00:00:00Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:10Z,mem,percentage,host.local,82.5\n,,0,2018-05-22T00:00:20Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:30Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:40Z,mem,percentage,host.local,82.6\n,,0,2018-05-22T00:00:50Z,mem,percentage,host.local,82.5\n,,1,2018-05-22T00:00:00Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:10Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:20Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:30Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:40Z,mem,percentage,host.remote,35\n,,1,2018-05-22T00:00:50Z,mem,percentage,host.remote,35\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   93,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,0,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.remote,35\n,,1,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,false,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,mem,host.remote,35\n,,0,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,mem,host.remote,35\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   77,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   77,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   77,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   93,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,0,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.remote,35\n,,1,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,false,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,mem,host.remote,35\n,,0,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,mem,host.remote,35\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   77,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,double\n#group,false,false,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_field,_measurement,device,fstype,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,0,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,disk,disk1s1,apfs,host.remote,30\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,disk,disk2s1,apfs,host.remote,35\n,,1,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,disk,disk2s1,apfs,host.remote,35\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,false,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,host,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:00:30Z,percentage,mem,host.remote,35\n,,0,2018-05-22T00:00:30Z,2018-05-22T00:01:00Z,percentage,mem,host.remote,35\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 78,
						Line:   100,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "agg_window_median_fn = (table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> window(period: 30s)\n    |> median()\n    |> group(columns: [\"_value\", \"_time\", \"_start\", \"_stop\"], mode: \"except\")",
					Start: ast.Position{
						Column: 1,
						Line:   94,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   94,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "agg_window_median_fn",
						Start: ast.Position{
							Column: 1,
							Line:   94,
						},
					},
				},
				Name: "agg_window_median_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 78,
							Line:   100,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> window(period: 30s)\n    |> median()\n    |> group(columns: [\"_value\", \"_time\", \"_start\", \"_stop\"], mode: \"except\")",
						Start: ast.Position{
							Column: 24,
							Line:   94,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   94,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 38,
														Line:   94,
													},
												},
											},
											Name: "table",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   95,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
												Start: ast.Position{
													Column: 38,
													Line:   94,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   95,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z",
														Start: ast.Position{
															Column: 14,
															Line:   95,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   95,
															},
															File:   "aggregate_window_median_test.flux",
															Source: "start: 2018-05-22T00:00:00Z",
															Start: ast.Position{
																Column: 14,
																Line:   95,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   95,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "start",
																Start: ast.Position{
																	Column: 14,
																	Line:   95,
																},
															},
														},
														Name: "start",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   95,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "2018-05-22T00:00:00Z",
																Start: ast.Position{
																	Column: 21,
																	Line:   95,
																},
															},
														},
														Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   95,
															},
															File:   "aggregate_window_median_test.flux",
															Source: "stop: 2018-05-22T00:01:00Z",
															Start: ast.Position{
																Column: 43,
																Line:   95,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   95,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "stop",
																Start: ast.Position{
																	Column: 43,
																	Line:   95,
																},
															},
														},
														Name: "stop",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   95,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "2018-05-22T00:01:00Z",
																Start: ast.Position{
																	Column: 49,
																	Line:   95,
																},
															},
														},
														Value: parser.MustParseTime("2018-05-22T00:01:00Z"),
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   95,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
													Start: ast.Position{
														Column: 8,
														Line:   95,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 13,
															Line:   95,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "range",
														Start: ast.Position{
															Column: 8,
															Line:   95,
														},
													},
												},
												Name: "range",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   96,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")",
											Start: ast.Position{
												Column: 38,
												Line:   94,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   96,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\"",
													Start: ast.Position{
														Column: 15,
														Line:   96,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   96,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\"",
														Start: ast.Position{
															Column: 15,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   96,
															},
															File:   "aggregate_window_median_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 15,
																Line:   96,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   96,
															},
															File:   "aggregate_window_median_test.flux",
															Source: "(r) => r._measurement == \"disk\" or r._measurement == \"mem\"",
															Start: ast.Position{
																Column: 19,
																Line:   96,
															},
														},
													},
													Body: &ast.LogicalExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   96,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "r._measurement == \"disk\" or r._measurement == \"mem\"",
																Start: ast.Position{
																	Column: 26,
																	Line:   96,
																},
															},
														},
														Left: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   96,
																	},
																	File:   "aggregate_window_median_test.flux",
																	Source: "r._measurement == \"disk\"",
																	Start: ast.Position{
																		Column: 26,
																		Line:   96,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   96,
																		},
																		File:   "aggregate_window_median_test.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 26,
																			Line:   96,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 27,
																				Line:   96,
																			},
																			File:   "aggregate_window_median_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 26,
																				Line:   96,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   96,
																			},
																			File:   "aggregate_window_median_test.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 28,
																				Line:   96,
																			},
																		},
																	},
																	Name: "_measurement",
																},
																Rbrack: nil,
															},
															Operator: 17,
															Right: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   96,
																		},
																		File:   "aggregate_window_median_test.flux",
																		Source: "\"disk\"",
																		Start: ast.Position{
																			Column: 44,
																			Line:   96,
																		},
																	},
																},
																Value: "disk",
															},
														},
														Operator: 2,
														Right: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   96,
																	},
																	File:   "aggregate_window_median_test.flux",
																	Source: "r._measurement == \"mem\"",
																	Start: ast.Position{
																		Column: 54,
																		Line:   96,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   96,
																		},
																		File:   "aggregate_window_median_test.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 54,
																			Line:   96,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   96,
																			},
																			File:   "aggregate_window_median_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 54,
																				Line:   96,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   96,
																			},
																			File:   "aggregate_window_median_test.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 56,
																				Line:   96,
																			},
																		},
																	},
																	Name: "_measurement",
																},
																Rbrack: nil,
															},
															Operator: 17,
															Right: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   96,
																		},
																		File:   "aggregate_window_median_test.flux",
																		Source: "\"mem\"",
																		Start: ast.Position{
																			Column: 72,
																			Line:   96,
																		},
																	},
																},
																Value: "mem",
															},
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   96,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 20,
																	Line:   96,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   96,
																	},
																	File:   "aggregate_window_median_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   96,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   96,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")",
												Start: ast.Position{
													Column: 8,
													Line:   96,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   96,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 8,
														Line:   96,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   97,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")",
										Start: ast.Position{
											Column: 38,
											Line:   94,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   97,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "fn: (r) => r.host == \"host.remote\"",
												Start: ast.Position{
													Column: 15,
													Line:   97,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   97,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "fn: (r) => r.host == \"host.remote\"",
													Start: ast.Position{
														Column: 15,
														Line:   97,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   97,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 15,
															Line:   97,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   97,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "(r) => r.host == \"host.remote\"",
														Start: ast.Position{
															Column: 19,
															Line:   97,
														},
													},
												},
												Body: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   97,
															},
															File:   "aggregate_window_median_test.flux",
															Source: "r.host == \"host.remote\"",
															Start: ast.Position{
																Column: 26,
																Line:   97,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   97,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "r.host",
																Start: ast.Position{
																	Column: 26,
																	Line:   97,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   97,
																	},
																	File:   "aggregate_window_median_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 26,
																		Line:   97,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   97,
																	},
																	File:   "aggregate_window_median_test.flux",
																	Source: "host",
																	Start: ast.Position{
																		Column: 28,
																		Line:   97,
																	},
																},
															},
															Name: "host",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   97,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "\"host.remote\"",
																Start: ast.Position{
																	Column: 36,
																	Line:   97,
																},
															},
														},
														Value: "host.remote",
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   97,
															},
															File:   "aggregate_window_median_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   97,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   97,
																},
																File:   "aggregate_window_median_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 20,
																	Line:   97,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   97,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "filter(fn: (r) => r.host == \"host.remote\")",
											Start: ast.Position{
												Column: 8,
												Line:   97,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   97,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 8,
													Line:   97,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   98,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> window(period: 30s)",
									Start: ast.Position{
										Column: 38,
										Line:   94,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   98,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "period: 30s",
											Start: ast.Position{
												Column: 15,
												Line:   98,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   98,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "period: 30s",
												Start: ast.Position{
													Column: 15,
													Line:   98,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   98,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "period",
													Start: ast.Position{
														Column: 15,
														Line:   98,
													},
												},
											},
											Name: "period",
										},
										Separator: nil,
										Value: &ast.DurationLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   98,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "30s",
													Start: ast.Position{
														Column: 23,
														Line:   98,
													},
												},
											},
											Values: []ast.Duration{ast.Duration{
												Magnitude: int64(30),
												Unit:      "s",
											}},
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   98,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "window(period: 30s)",
										Start: ast.Position{
											Column: 8,
											Line:   98,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   98,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "window",
											Start: ast.Position{
												Column: 8,
												Line:   98,
											},
										},
									},
									Name: "window",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   99,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> window(period: 30s)\n    |> median()",
								Start: ast.Position{
									Column: 38,
									Line:   94,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   99,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "median()",
									Start: ast.Position{
										Column: 8,
										Line:   99,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   99,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "median",
										Start: ast.Position{
											Column: 8,
											Line:   99,
										},
									},
								},
								Name: "median",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   100,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n    |> filter(fn: (r) => r._measurement == \"disk\" or r._measurement == \"mem\")\n    |> filter(fn: (r) => r.host == \"host.remote\")\n    |> window(period: 30s)\n    |> median()\n    |> group(columns: [\"_value\", \"_time\", \"_start\", \"_stop\"], mode: \"except\")",
							Start: ast.Position{
								Column: 38,
								Line:   94,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   100,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "columns: [\"_value\", \"_time\", \"_start\", \"_stop\"], mode: \"except\"",
									Start: ast.Position{
										Column: 14,
										Line:   100,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   100,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "columns: [\"_value\", \"_time\", \"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 14,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   100,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 14,
												Line:   100,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   100,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "[\"_value\", \"_time\", \"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 23,
												Line:   100,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   100,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "\"_value\"",
												Start: ast.Position{
													Column: 24,
													Line:   100,
												},
											},
										},
										Value: "_value",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   100,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 34,
													Line:   100,
												},
											},
										},
										Value: "_time",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   100,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "\"_start\"",
												Start: ast.Position{
													Column: 43,
													Line:   100,
												},
											},
										},
										Value: "_start",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   100,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "\"_stop\"",
												Start: ast.Position{
													Column: 53,
													Line:   100,
												},
											},
										},
										Value: "_stop",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   100,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "mode: \"except\"",
										Start: ast.Position{
											Column: 63,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   100,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "mode",
											Start: ast.Position{
												Column: 63,
												Line:   100,
											},
										},
									},
									Name: "mode",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   100,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "\"except\"",
											Start: ast.Position{
												Column: 69,
												Line:   100,
											},
										},
									},
									Value: "except",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   100,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "group(columns: [\"_value\", \"_time\", \"_start\", \"_stop\"], mode: \"except\")",
								Start: ast.Position{
									Column: 8,
									Line:   100,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   100,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "group",
									Start: ast.Position{
										Column: 8,
										Line:   100,
									},
								},
							},
							Name: "group",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   94,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 25,
								Line:   94,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   94,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 25,
									Line:   94,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   94,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 31,
								Line:   94,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 138,
							Line:   102,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "agg_window_median = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_median_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   102,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   102,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "agg_window_median",
							Start: ast.Position{
								Column: 6,
								Line:   102,
							},
						},
					},
					Name: "agg_window_median",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 138,
								Line:   102,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_median_fn})",
							Start: ast.Position{
								Column: 26,
								Line:   102,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 138,
									Line:   102,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_median_fn})",
								Start: ast.Position{
									Column: 32,
									Line:   102,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 137,
										Line:   102,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_median_fn}",
									Start: ast.Position{
										Column: 33,
										Line:   102,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   102,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 34,
											Line:   102,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   102,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 34,
												Line:   102,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   102,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 61,
													Line:   102,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   102,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 61,
														Line:   102,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   102,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 61,
															Line:   102,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   102,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 66,
															Line:   102,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   102,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 41,
												Line:   102,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   102,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 41,
													Line:   102,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   102,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 41,
														Line:   102,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   102,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 49,
														Line:   102,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   102,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 75,
											Line:   102,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   102,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 75,
												Line:   102,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   102,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 97,
													Line:   102,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 109,
														Line:   102,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 97,
														Line:   102,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   102,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 97,
															Line:   102,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 109,
															Line:   102,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 102,
															Line:   102,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   102,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 81,
												Line:   102,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   102,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 81,
													Line:   102,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   102,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 81,
														Line:   102,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   102,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 89,
														Line:   102,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 136,
											Line:   102,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "fn: agg_window_median_fn",
										Start: ast.Position{
											Column: 112,
											Line:   102,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   102,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 112,
												Line:   102,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 136,
												Line:   102,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "agg_window_median_fn",
											Start: ast.Position{
												Column: 116,
												Line:   102,
											},
										},
									},
									Name: "agg_window_median_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 138,
						Line:   102,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "test agg_window_median = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: agg_window_median_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   102,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_median_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "package chronograf_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "chronograf_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "chronograf_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   30,
				},
				File:   "buckets_test.flux",
				Source: "package chronograf_test\n\n\nimport \"testing\"\n\ninData = \"\n#datatype,string,long,string,string,string,string,long,dateTime:RFC3339,string,string\n#group,false,false,true,false,false,false,false,false,true,true\n#default,_result,,0389eade5af4b000,,,,,,,\n,result,table,organizationID,name,id,retentionPolicy,retentionPeriod,_time,_field,_measurement\n,,0,,A,0389eade5b34b000,,0,1970-01-01T00:00:00Z,a,aa\n,,0,,B,042ed3f42d42e000,,0,1970-01-01T00:00:00Z,b,bb\n\"\noutData = \"\n#datatype,string,long,string\n#group,false,false,false\n#default,_result,,\n,result,table,_value\n,,0,A\n,,0,B\n\"\nbuckets_fn = (table=<-) => table\n    |> rename(columns: {name: \"_value\"})\n    |> keep(columns: [\"_value\"])\n\ntest buckets = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: buckets_fn,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   13,
					},
					File:   "buckets_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,string,long,dateTime:RFC3339,string,string\n#group,false,false,true,false,false,false,false,false,true,true\n#default,_result,,0389eade5af4b000,,,,,,,\n,result,table,organizationID,name,id,retentionPolicy,retentionPeriod,_time,_field,_measurement\n,,0,,A,0389eade5b34b000,,0,1970-01-01T00:00:00Z,a,aa\n,,0,,B,042ed3f42d42e000,,0,1970-01-01T00:00:00Z,b,bb\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "buckets_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   13,
						},
						File:   "buckets_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,string,long,dateTime:RFC3339,string,string\n#group,false,false,true,false,false,false,false,false,true,true\n#default,_result,,0389eade5af4b000,,,,,,,\n,result,table,organizationID,name,id,retentionPolicy,retentionPeriod,_time,_field,_measurement\n,,0,,A,0389eade5b34b000,,0,1970-01-01T00:00:00Z,a,aa\n,,0,,B,042ed3f42d42e000,,0,1970-01-01T00:00:00Z,b,bb\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,string,long,dateTime:RFC3339,string,string\n#group,false,false,true,false,false,false,false,false,true,true\n#default,_result,,0389eade5af4b000,,,,,,,\n,result,table,organizationID,name,id,retentionPolicy,retentionPeriod,_time,_field,_measurement\n,,0,,A,0389eade5b34b000,,0,1970-01-01T00:00:00Z,a,aa\n,,0,,B,042ed3f42d42e000,,0,1970-01-01T00:00:00Z,b,bb\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   21,
					},
					File:   "buckets_test.flux",
					Source: "outData = \"\n#datatype,string,long,string\n#group,false,false,false\n#default,_result,,\n,result,table,_value\n,,0,A\n,,0,B\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   14,
						},
						File:   "buckets_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   14,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   21,
						},
						File:   "buckets_test.flux",
						Source: "\"\n#datatype,string,long,string\n#group,false,false,false\n#default,_result,,\n,result,table,_value\n,,0,A\n,,0,B\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   14,
						},
					},
				},
				Value: "\n#datatype,string,long,string\n#group,false,false,false\n#default,_result,,\n,result,table,_value\n,,0,A\n,,0,B\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   24,
					},
					File:   "buckets_test.flux",
					Source: "buckets_fn = (table=<-) => table\n    |> rename(columns: {name: \"_value\"})\n    |> keep(columns: [\"_value\"])",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   22,
						},
						File:   "buckets_test.flux",
						Source: "buckets_fn",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "buckets_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   24,
						},
						File:   "buckets_test.flux",
						Source: "(table=<-) => table\n    |> rename(columns: {name: \"_value\"})\n    |> keep(columns: [\"_value\"])",
						Start: ast.Position{
							Column: 14,
							Line:   22,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   22,
									},
									File:   "buckets_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 28,
										Line:   22,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   23,
								},
								File:   "buckets_test.flux",
								Source: "table\n    |> rename(columns: {name: \"_value\"})",
								Start: ast.Position{
									Column: 28,
									Line:   22,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   23,
										},
										File:   "buckets_test.flux",
										Source: "columns: {name: \"_value\"}",
										Start: ast.Position{
											Column: 15,
											Line:   23,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   23,
											},
											File:   "buckets_test.flux",
											Source: "columns: {name: \"_value\"}",
											Start: ast.Position{
												Column: 15,
												Line:   23,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   23,
												},
												File:   "buckets_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 15,
													Line:   23,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   23,
												},
												File:   "buckets_test.flux",
												Source: "{name: \"_value\"}",
												Start: ast.Position{
													Column: 24,
													Line:   23,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   23,
													},
													File:   "buckets_test.flux",
													Source: "name: \"_value\"",
													Start: ast.Position{
														Column: 25,
														Line:   23,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   23,
														},
														File:   "buckets_test.flux",
														Source: "name",
														Start: ast.Position{
															Column: 25,
															Line:   23,
														},
													},
												},
												Name: "name",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   23,
														},
														File:   "buckets_test.flux",
														Source: "\"_value\"",
														Start: ast.Position{
															Column: 31,
															Line:   23,
														},
													},
												},
												Value: "_value",
											},
										}},
										Rbrace: nil,
										With:   nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   23,
									},
									File:   "buckets_test.flux",
									Source: "rename(columns: {name: \"_value\"})",
									Start: ast.Position{
										Column: 8,
										Line:   23,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   23,
										},
										File:   "buckets_test.flux",
										Source: "rename",
										Start: ast.Position{
											Column: 8,
											Line:   23,
										},
									},
								},
								Name: "rename",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   24,
							},
							File:   "buckets_test.flux",
							Source: "table\n    |> rename(columns: {name: \"_value\"})\n    |> keep(columns: [\"_value\"])",
							Start: ast.Position{
								Column: 28,
								Line:   22,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   24,
									},
									File:   "buckets_test.flux",
									Source: "columns: [\"_value\"]",
									Start: ast.Position{
										Column: 13,
										Line:   24,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   24,
										},
										File:   "buckets_test.flux",
										Source: "columns: [\"_value\"]",
										Start: ast.Position{
											Column: 13,
											Line:   24,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   24,
											},
											File:   "buckets_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   24,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   24,
											},
											File:   "buckets_test.flux",
											Source: "[\"_value\"]",
											Start: ast.Position{
												Column: 22,
												Line:   24,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   24,
												},
												File:   "buckets_test.flux",
												Source: "\"_value\"",
												Start: ast.Position{
													Column: 23,
													Line:   24,
												},
											},
										},
										Value: "_value",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   24,
								},
								File:   "buckets_test.flux",
								Source: "keep(columns: [\"_value\"])",
								Start: ast.Position{
									Column: 8,
									Line:   24,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   24,
									},
									File:   "buckets_test.flux",
									Source: "keep",
									Start: ast.Position{
										Column: 8,
										Line:   24,
									},
								},
							},
							Name: "keep",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   22,
							},
							File:   "buckets_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 15,
								Line:   22,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   22,
								},
								File:   "buckets_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 15,
									Line:   22,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   22,
							},
							File:   "buckets_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 21,
								Line:   22,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   30,
						},
						File:   "buckets_test.flux",
						Source: "buckets = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: buckets_fn,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   26,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   26,
							},
							File:   "buckets_test.flux",
							Source: "buckets",
							Start: ast.Position{
								Column: 6,
								Line:   26,
							},
						},
					},
					Name: "buckets",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   30,
							},
							File:   "buckets_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: buckets_fn,\n})",
							Start: ast.Position{
								Column: 16,
								Line:   26,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   30,
								},
								File:   "buckets_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: buckets_fn,\n})",
								Start: ast.Position{
									Column: 22,
									Line:   26,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   30,
									},
									File:   "buckets_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: buckets_fn,\n}",
									Start: ast.Position{
										Column: 23,
										Line:   26,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   27,
										},
										File:   "buckets_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   27,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   27,
											},
											File:   "buckets_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   27,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   27,
												},
												File:   "buckets_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   27,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   27,
													},
													File:   "buckets_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   27,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   27,
														},
														File:   "buckets_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   27,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   27,
														},
														File:   "buckets_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   27,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   27,
											},
											File:   "buckets_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   27,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   27,
												},
												File:   "buckets_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   27,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   27,
													},
													File:   "buckets_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   27,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   27,
													},
													File:   "buckets_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   27,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   28,
										},
										File:   "buckets_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   28,
											},
											File:   "buckets_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   28,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   28,
												},
												File:   "buckets_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   28,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   28,
													},
													File:   "buckets_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   28,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   28,
														},
														File:   "buckets_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   28,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   28,
														},
														File:   "buckets_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   28,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   28,
											},
											File:   "buckets_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   28,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   28,
												},
												File:   "buckets_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   28,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   28,
													},
													File:   "buckets_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   28,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   28,
													},
													File:   "buckets_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   28,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   29,
										},
										File:   "buckets_test.flux",
										Source: "fn: buckets_fn",
										Start: ast.Position{
											Column: 5,
											Line:   29,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   29,
											},
											File:   "buckets_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   29,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   29,
											},
											File:   "buckets_test.flux",
											Source: "buckets_fn",
											Start: ast.Position{
												Column: 9,
												Line:   29,
											},
										},
									},
									Name: "buckets_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   30,
					},
					File:   "buckets_test.flux",
					Source: "test buckets = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: buckets_fn,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "buckets_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "buckets_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "buckets_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "buckets_test.flux",
					Source: "package chronograf_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "buckets_test.flux",
						Source: "chronograf_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "chronograf_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 142,
					Line:   100,
				},
				File:   "measurement_tag_keys_test.flux",
				Source: "package chronograf_test\n\n\nimport \"testing\"\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,sys,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,sys,host.local,load1,1.72\n,,0,2018-05-22T19:53:46Z,sys,host.local,load1,1.74\n,,0,2018-05-22T19:53:56Z,sys,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,sys,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,sys,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,sys,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,sys,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,sys,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,sys,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,sys,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,sys,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,sys,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,sys,host.local,load5,1.92\n,,2,2018-05-22T19:53:46Z,sys,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,sys,host.local,load5,1.89\n,,2,2018-05-22T19:54:06Z,sys,host.local,load5,1.94\n,,2,2018-05-22T19:54:16Z,sys,host.local,load5,1.93\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,reg,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.local,load1,10\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.local,load1,11\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.local,load1,18\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.local,load1,19\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.local,load1,17\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.local,load1,17\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,region,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.global,load1,10\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.global,load1,11\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.global,load1,18\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.global,load1,19\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.global,load1,17\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.global,load1,17\n\n,,1,2018-05-22T19:53:26Z,swp,us-east,host.global,load3,16\n,,1,2018-05-22T19:53:36Z,swp,us-east,host.global,load3,16\n,,1,2018-05-22T19:53:46Z,swp,us-east,host.global,load3,15\n,,1,2018-05-22T19:53:56Z,swp,us-east,host.global,load3,19\n,,1,2018-05-22T19:54:06Z,swp,us-east,host.global,load3,19\n,,1,2018-05-22T19:54:16Z,swp,us-east,host.global,load3,19\n\n,,2,2018-05-22T19:53:26Z,swp,us-east,host.global,load5,19\n,,2,2018-05-22T19:53:36Z,swp,us-east,host.global,load5,22\n,,2,2018-05-22T19:53:46Z,swp,us-east,host.global,load5,11\n,,2,2018-05-22T19:53:56Z,swp,us-east,host.global,load5,12\n,,2,2018-05-22T19:54:06Z,swp,us-east,host.global,load5,13\n,,2,2018-05-22T19:54:16Z,swp,us-east,host.global,load5,13\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,region,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.global,load2,10.003\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.global,load2,11.873\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.global,load2,18.832\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.global,load2,19.777\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.global,load2,17.190\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.global,load2,17.192\n\"\noutput = \"\n#datatype,string,long,string\n#group,false,false,false\n#default,0,,\n,result,table,_value\n,,0,_field\n,,0,_measurement\n,,0,_start\n,,0,_stop\n,,0,host\n,,0,region\n\"\nmeasurement_tag_keys_fn = (tables=<-) => tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")\n    |> filter(fn: (r) => r.host == \"host.global\")\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()\n    |> sort()\n\ntest measurement_tag_keys = () => ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: measurement_tag_keys_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   78,
					},
					File:   "measurement_tag_keys_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,sys,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,sys,host.local,load1,1.72\n,,0,2018-05-22T19:53:46Z,sys,host.local,load1,1.74\n,,0,2018-05-22T19:53:56Z,sys,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,sys,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,sys,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,sys,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,sys,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,sys,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,sys,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,sys,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,sys,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,sys,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,sys,host.local,load5,1.92\n,,2,2018-05-22T19:53:46Z,sys,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,sys,host.local,load5,1.89\n,,2,2018-05-22T19:54:06Z,sys,host.local,load5,1.94\n,,2,2018-05-22T19:54:16Z,sys,host.local,load5,1.93\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,reg,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.local,load1,10\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.local,load1,11\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.local,load1,18\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.local,load1,19\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.local,load1,17\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.local,load1,17\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,region,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.global,load1,10\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.global,load1,11\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.global,load1,18\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.global,load1,19\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.global,load1,17\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.global,load1,17\n\n,,1,2018-05-22T19:53:26Z,swp,us-east,host.global,load3,16\n,,1,2018-05-22T19:53:36Z,swp,us-east,host.global,load3,16\n,,1,2018-05-22T19:53:46Z,swp,us-east,host.global,load3,15\n,,1,2018-05-22T19:53:56Z,swp,us-east,host.global,load3,19\n,,1,2018-05-22T19:54:06Z,swp,us-east,host.global,load3,19\n,,1,2018-05-22T19:54:16Z,swp,us-east,host.global,load3,19\n\n,,2,2018-05-22T19:53:26Z,swp,us-east,host.global,load5,19\n,,2,2018-05-22T19:53:36Z,swp,us-east,host.global,load5,22\n,,2,2018-05-22T19:53:46Z,swp,us-east,host.global,load5,11\n,,2,2018-05-22T19:53:56Z,swp,us-east,host.global,load5,12\n,,2,2018-05-22T19:54:06Z,swp,us-east,host.global,load5,13\n,,2,2018-05-22T19:54:16Z,swp,us-east,host.global,load5,13\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,region,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.global,load2,10.003\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.global,load2,11.873\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.global,load2,18.832\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.global,load2,19.777\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.global,load2,17.190\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.global,load2,17.192\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   6,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   78,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,sys,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,sys,host.local,load1,1.72\n,,0,2018-05-22T19:53:46Z,sys,host.local,load1,1.74\n,,0,2018-05-22T19:53:56Z,sys,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,sys,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,sys,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,sys,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,sys,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,sys,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,sys,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,sys,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,sys,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,sys,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,sys,host.local,load5,1.92\n,,2,2018-05-22T19:53:46Z,sys,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,sys,host.local,load5,1.89\n,,2,2018-05-22T19:54:06Z,sys,host.local,load5,1.94\n,,2,2018-05-22T19:54:16Z,sys,host.local,load5,1.93\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,reg,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.local,load1,10\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.local,load1,11\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.local,load1,18\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.local,load1,19\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.local,load1,17\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.local,load1,17\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,region,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.global,load1,10\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.global,load1,11\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.global,load1,18\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.global,load1,19\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.global,load1,17\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.global,load1,17\n\n,,1,2018-05-22T19:53:26Z,swp,us-east,host.global,load3,16\n,,1,2018-05-22T19:53:36Z,swp,us-east,host.global,load3,16\n,,1,2018-05-22T19:53:46Z,swp,us-east,host.global,load3,15\n,,1,2018-05-22T19:53:56Z,swp,us-east,host.global,load3,19\n,,1,2018-05-22T19:54:06Z,swp,us-east,host.global,load3,19\n,,1,2018-05-22T19:54:16Z,swp,us-east,host.global,load3,19\n\n,,2,2018-05-22T19:53:26Z,swp,us-east,host.global,load5,19\n,,2,2018-05-22T19:53:36Z,swp,us-east,host.global,load5,22\n,,2,2018-05-22T19:53:46Z,swp,us-east,host.global,load5,11\n,,2,2018-05-22T19:53:56Z,swp,us-east,host.global,load5,12\n,,2,2018-05-22T19:54:06Z,swp,us-east,host.global,load5,13\n,,2,2018-05-22T19:54:16Z,swp,us-east,host.global,load5,13\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,region,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.global,load2,10.003\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.global,load2,11.873\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.global,load2,18.832\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.global,load2,19.777\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.global,load2,17.190\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.global,load2,17.192\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,sys,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,sys,host.local,load1,1.72\n,,0,2018-05-22T19:53:46Z,sys,host.local,load1,1.74\n,,0,2018-05-22T19:53:56Z,sys,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,sys,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,sys,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,sys,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,sys,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,sys,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,sys,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,sys,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,sys,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,sys,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,sys,host.local,load5,1.92\n,,2,2018-05-22T19:53:46Z,sys,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,sys,host.local,load5,1.89\n,,2,2018-05-22T19:54:06Z,sys,host.local,load5,1.94\n,,2,2018-05-22T19:54:16Z,sys,host.local,load5,1.93\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,reg,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.local,load1,10\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.local,load1,11\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.local,load1,18\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.local,load1,19\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.local,load1,17\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.local,load1,17\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,region,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.global,load1,10\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.global,load1,11\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.global,load1,18\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.global,load1,19\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.global,load1,17\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.global,load1,17\n\n,,1,2018-05-22T19:53:26Z,swp,us-east,host.global,load3,16\n,,1,2018-05-22T19:53:36Z,swp,us-east,host.global,load3,16\n,,1,2018-05-22T19:53:46Z,swp,us-east,host.global,load3,15\n,,1,2018-05-22T19:53:56Z,swp,us-east,host.global,load3,19\n,,1,2018-05-22T19:54:06Z,swp,us-east,host.global,load3,19\n,,1,2018-05-22T19:54:16Z,swp,us-east,host.global,load3,19\n\n,,2,2018-05-22T19:53:26Z,swp,us-east,host.global,load5,19\n,,2,2018-05-22T19:53:36Z,swp,us-east,host.global,load5,22\n,,2,2018-05-22T19:53:46Z,swp,us-east,host.global,load5,11\n,,2,2018-05-22T19:53:56Z,swp,us-east,host.global,load5,12\n,,2,2018-05-22T19:54:06Z,swp,us-east,host.global,load5,13\n,,2,2018-05-22T19:54:16Z,swp,us-east,host.global,load5,13\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,region,host,_field,_value\n,,0,2018-05-22T19:53:26Z,swp,us-east,host.global,load2,10.003\n,,0,2018-05-22T19:53:36Z,swp,us-east,host.global,load2,11.873\n,,0,2018-05-22T19:53:46Z,swp,us-east,host.global,load2,18.832\n,,0,2018-05-22T19:53:56Z,swp,us-east,host.global,load2,19.777\n,,0,2018-05-22T19:54:06Z,swp,us-east,host.global,load2,17.190\n,,0,2018-05-22T19:54:16Z,swp,us-east,host.global,load2,17.192\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   90,
					},
					File:   "measurement_tag_keys_test.flux",
					Source: "output = \"\n#datatype,string,long,string\n#group,false,false,false\n#default,0,,\n,result,table,_value\n,,0,_field\n,,0,_measurement\n,,0,_start\n,,0,_stop\n,,0,host\n,,0,region\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   79,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   79,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   79,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   90,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "\"\n#datatype,string,long,string\n#group,false,false,false\n#default,0,,\n,result,table,_value\n,,0,_field\n,,0,_measurement\n,,0,_start\n,,0,_stop\n,,0,host\n,,0,region\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   79,
						},
					},
				},
				Value: "\n#datatype,string,long,string\n#group,false,false,false\n#default,0,,\n,result,table,_value\n,,0,_field\n,,0,_measurement\n,,0,_start\n,,0,_stop\n,,0,host\n,,0,region\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   98,
					},
					File:   "measurement_tag_keys_test.flux",
					Source: "measurement_tag_keys_fn = (tables=<-) => tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")\n    |> filter(fn: (r) => r.host == \"host.global\")\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()\n    |> sort()",
					Start: ast.Position{
						Column: 1,
						Line:   91,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   91,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "measurement_tag_keys_fn",
						Start: ast.Position{
							Column: 1,
							Line:   91,
						},
					},
				},
				Name: "measurement_tag_keys_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   98,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")\n    |> filter(fn: (r) => r.host == \"host.global\")\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()\n    |> sort()",
						Start: ast.Position{
							Column: 27,
							Line:   91,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   91,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "tables",
														Start: ast.Position{
															Column: 42,
															Line:   91,
														},
													},
												},
												Name: "tables",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   92,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)",
													Start: ast.Position{
														Column: 42,
														Line:   91,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   92,
															},
															File:   "measurement_tag_keys_test.flux",
															Source: "start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z",
															Start: ast.Position{
																Column: 14,
																Line:   92,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   92,
																},
																File:   "measurement_tag_keys_test.flux",
																Source: "start: 2018-01-01T00:00:00Z",
																Start: ast.Position{
																	Column: 14,
																	Line:   92,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   92,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 14,
																		Line:   92,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   92,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "2018-01-01T00:00:00Z",
																	Start: ast.Position{
																		Column: 21,
																		Line:   92,
																	},
																},
															},
															Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   92,
																},
																File:   "measurement_tag_keys_test.flux",
																Source: "stop: 2019-01-01T00:00:00Z",
																Start: ast.Position{
																	Column: 43,
																	Line:   92,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   92,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 43,
																		Line:   92,
																	},
																},
															},
															Name: "stop",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   92,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "2019-01-01T00:00:00Z",
																	Start: ast.Position{
																		Column: 49,
																		Line:   92,
																	},
																},
															},
															Value: parser.MustParseTime("2019-01-01T00:00:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   92,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)",
														Start: ast.Position{
															Column: 8,
															Line:   92,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   92,
															},
															File:   "measurement_tag_keys_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 8,
																Line:   92,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   93,
												},
												File:   "measurement_tag_keys_test.flux",
												Source: "tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")",
												Start: ast.Position{
													Column: 42,
													Line:   91,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   93,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "fn: (r) => r._measurement == \"swp\"",
														Start: ast.Position{
															Column: 15,
															Line:   93,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   93,
															},
															File:   "measurement_tag_keys_test.flux",
															Source: "fn: (r) => r._measurement == \"swp\"",
															Start: ast.Position{
																Column: 15,
																Line:   93,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   93,
																},
																File:   "measurement_tag_keys_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   93,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   93,
																},
																File:   "measurement_tag_keys_test.flux",
																Source: "(r) => r._measurement == \"swp\"",
																Start: ast.Position{
																	Column: 19,
																	Line:   93,
																},
															},
														},
														Body: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   93,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "r._measurement == \"swp\"",
																	Start: ast.Position{
																		Column: 26,
																		Line:   93,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   93,
																		},
																		File:   "measurement_tag_keys_test.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 26,
																			Line:   93,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 27,
																				Line:   93,
																			},
																			File:   "measurement_tag_keys_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 26,
																				Line:   93,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   93,
																			},
																			File:   "measurement_tag_keys_test.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 28,
																				Line:   93,
																			},
																		},
																	},
																	Name: "_measurement",
																},
																Rbrack: nil,
															},
															Operator: 17,
															Right: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   93,
																		},
																		File:   "measurement_tag_keys_test.flux",
																		Source: "\"swp\"",
																		Start: ast.Position{
																			Column: 44,
																			Line:   93,
																		},
																	},
																},
																Value: "swp",
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   93,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   93,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   93,
																		},
																		File:   "measurement_tag_keys_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   93,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   93,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "filter(fn: (r) => r._measurement == \"swp\")",
													Start: ast.Position{
														Column: 8,
														Line:   93,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   93,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   93,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   94,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")\n    |> filter(fn: (r) => r.host == \"host.global\")",
											Start: ast.Position{
												Column: 42,
												Line:   91,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   94,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "fn: (r) => r.host == \"host.global\"",
													Start: ast.Position{
														Column: 15,
														Line:   94,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   94,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "fn: (r) => r.host == \"host.global\"",
														Start: ast.Position{
															Column: 15,
															Line:   94,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   94,
															},
															File:   "measurement_tag_keys_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 15,
																Line:   94,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   94,
															},
															File:   "measurement_tag_keys_test.flux",
															Source: "(r) => r.host == \"host.global\"",
															Start: ast.Position{
																Column: 19,
																Line:   94,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   94,
																},
																File:   "measurement_tag_keys_test.flux",
																Source: "r.host == \"host.global\"",
																Start: ast.Position{
																	Column: 26,
																	Line:   94,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   94,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "r.host",
																	Start: ast.Position{
																		Column: 26,
																		Line:   94,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 27,
																			Line:   94,
																		},
																		File:   "measurement_tag_keys_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 26,
																			Line:   94,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 32,
																			Line:   94,
																		},
																		File:   "measurement_tag_keys_test.flux",
																		Source: "host",
																		Start: ast.Position{
																			Column: 28,
																			Line:   94,
																		},
																	},
																},
																Name: "host",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   94,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "\"host.global\"",
																	Start: ast.Position{
																		Column: 36,
																		Line:   94,
																	},
																},
															},
															Value: "host.global",
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   94,
																},
																File:   "measurement_tag_keys_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 20,
																	Line:   94,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   94,
																	},
																	File:   "measurement_tag_keys_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   94,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   94,
												},
												File:   "measurement_tag_keys_test.flux",
												Source: "filter(fn: (r) => r.host == \"host.global\")",
												Start: ast.Position{
													Column: 8,
													Line:   94,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   94,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 8,
														Line:   94,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   95,
										},
										File:   "measurement_tag_keys_test.flux",
										Source: "tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")\n    |> filter(fn: (r) => r.host == \"host.global\")\n    |> keys()",
										Start: ast.Position{
											Column: 42,
											Line:   91,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   95,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "keys()",
											Start: ast.Position{
												Column: 8,
												Line:   95,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   95,
												},
												File:   "measurement_tag_keys_test.flux",
												Source: "keys",
												Start: ast.Position{
													Column: 8,
													Line:   95,
												},
											},
										},
										Name: "keys",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   96,
									},
									File:   "measurement_tag_keys_test.flux",
									Source: "tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")\n    |> filter(fn: (r) => r.host == \"host.global\")\n    |> keys()\n    |> keep(columns: [\"_value\"])",
									Start: ast.Position{
										Column: 42,
										Line:   91,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   96,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "columns: [\"_value\"]",
											Start: ast.Position{
												Column: 13,
												Line:   96,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   96,
												},
												File:   "measurement_tag_keys_test.flux",
												Source: "columns: [\"_value\"]",
												Start: ast.Position{
													Column: 13,
													Line:   96,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   96,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 13,
														Line:   96,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   96,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "[\"_value\"]",
													Start: ast.Position{
														Column: 22,
														Line:   96,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   96,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "\"_value\"",
														Start: ast.Position{
															Column: 23,
															Line:   96,
														},
													},
												},
												Value: "_value",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   96,
										},
										File:   "measurement_tag_keys_test.flux",
										Source: "keep(columns: [\"_value\"])",
										Start: ast.Position{
											Column: 8,
											Line:   96,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   96,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "keep",
											Start: ast.Position{
												Column: 8,
												Line:   96,
											},
										},
									},
									Name: "keep",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   97,
								},
								File:   "measurement_tag_keys_test.flux",
								Source: "tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")\n    |> filter(fn: (r) => r.host == \"host.global\")\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()",
								Start: ast.Position{
									Column: 42,
									Line:   91,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   97,
									},
									File:   "measurement_tag_keys_test.flux",
									Source: "distinct()",
									Start: ast.Position{
										Column: 8,
										Line:   97,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   97,
										},
										File:   "measurement_tag_keys_test.flux",
										Source: "distinct",
										Start: ast.Position{
											Column: 8,
											Line:   97,
										},
									},
								},
								Name: "distinct",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   98,
							},
							File:   "measurement_tag_keys_test.flux",
							Source: "tables\n    |> range(start: 2018-01-01T00:00:00Z, stop: 2019-01-01T00:00:00Z)\n    |> filter(fn: (r) => r._measurement == \"swp\")\n    |> filter(fn: (r) => r.host == \"host.global\")\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()\n    |> sort()",
							Start: ast.Position{
								Column: 42,
								Line:   91,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   98,
								},
								File:   "measurement_tag_keys_test.flux",
								Source: "sort()",
								Start: ast.Position{
									Column: 8,
									Line:   98,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   98,
									},
									File:   "measurement_tag_keys_test.flux",
									Source: "sort",
									Start: ast.Position{
										Column: 8,
										Line:   98,
									},
								},
							},
							Name: "sort",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   91,
							},
							File:   "measurement_tag_keys_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 28,
								Line:   91,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   91,
								},
								File:   "measurement_tag_keys_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 28,
									Line:   91,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   91,
							},
							File:   "measurement_tag_keys_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 35,
								Line:   91,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 142,
							Line:   100,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "measurement_tag_keys = () => ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: measurement_tag_keys_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   100,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   100,
							},
							File:   "measurement_tag_keys_test.flux",
							Source: "measurement_tag_keys",
							Start: ast.Position{
								Column: 6,
								Line:   100,
							},
						},
					},
					Name: "measurement_tag_keys",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 142,
								Line:   100,
							},
							File:   "measurement_tag_keys_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: measurement_tag_keys_fn})",
							Start: ast.Position{
								Column: 29,
								Line:   100,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 142,
									Line:   100,
								},
								File:   "measurement_tag_keys_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: measurement_tag_keys_fn})",
								Start: ast.Position{
									Column: 35,
									Line:   100,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 141,
										Line:   100,
									},
									File:   "measurement_tag_keys_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: measurement_tag_keys_fn}",
									Start: ast.Position{
										Column: 36,
										Line:   100,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   100,
										},
										File:   "measurement_tag_keys_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 37,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   100,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 37,
												Line:   100,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   100,
												},
												File:   "measurement_tag_keys_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 64,
													Line:   100,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   100,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 64,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   100,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 64,
															Line:   100,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   100,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 69,
															Line:   100,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   100,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 44,
												Line:   100,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   100,
												},
												File:   "measurement_tag_keys_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 44,
													Line:   100,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   100,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 44,
														Line:   100,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   100,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 52,
														Line:   100,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 111,
											Line:   100,
										},
										File:   "measurement_tag_keys_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 77,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   100,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 77,
												Line:   100,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 110,
													Line:   100,
												},
												File:   "measurement_tag_keys_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 99,
													Line:   100,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 110,
														Line:   100,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 99,
														Line:   100,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 102,
															Line:   100,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 99,
															Line:   100,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 110,
															Line:   100,
														},
														File:   "measurement_tag_keys_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 104,
															Line:   100,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 111,
												Line:   100,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 83,
												Line:   100,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   100,
												},
												File:   "measurement_tag_keys_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 83,
													Line:   100,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 90,
														Line:   100,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 83,
														Line:   100,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 98,
														Line:   100,
													},
													File:   "measurement_tag_keys_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 91,
														Line:   100,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 140,
											Line:   100,
										},
										File:   "measurement_tag_keys_test.flux",
										Source: "fn: measurement_tag_keys_fn",
										Start: ast.Position{
											Column: 113,
											Line:   100,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 115,
												Line:   100,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 113,
												Line:   100,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 140,
												Line:   100,
											},
											File:   "measurement_tag_keys_test.flux",
											Source: "measurement_tag_keys_fn",
											Start: ast.Position{
												Column: 117,
												Line:   100,
											},
										},
									},
									Name: "measurement_tag_keys_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 142,
						Line:   100,
					},
					File:   "measurement_tag_keys_test.flux",
					Source: "test measurement_tag_keys = () => ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: measurement_tag_keys_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   100,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "measurement_tag_keys_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "measurement_tag_keys_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "measurement_tag_keys_test.flux",
					Source: "package chronograf_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "measurement_tag_keys_test.flux",
						Source: "chronograf_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "chronograf_test",
			},
		},
	}},
	Package: "chronograf_test",
	Path:    "testing/chronograf",
}}
