// Generated by tmpl
// https://github.com/benbjohnson/tmpl
//
// DO NOT EDIT!
// Source: derivative.gen.go.tmpl

package universe

import (
	"github.com/apache/arrow/go/v7/arrow/memory"
	"github.com/influxdata/flux"
	"github.com/influxdata/flux/array"
	"github.com/influxdata/flux/arrow"
)

type derivativeInt struct {
	t           int64
	v           int64
	isValid     bool
	unit        float64
	nonNegative bool
	initialized bool
}

func (d *derivativeInt) Type() flux.ColType {
	return flux.TFloat
}

func (d *derivativeInt) Do(ts *array.Int, in array.Array, mem memory.Allocator) array.Array {
	// Empty column chunk returns an empty array
	// and does not initialize the derivative.
	if in.Len() == 0 {
		return arrow.Empty(flux.TFloat)
	}

	i := 0

	// Initialize by reading the first value.
	vs := in.(*array.Int)
	if !d.initialized {
		d.t = ts.Value(i)
		if vs.IsValid(i) {
			d.v, d.isValid = vs.Value(i), true
		}
		d.initialized = true
		i++
	}

	// Initialize the size of the builder.
	b := array.NewFloatBuilder(mem)
	b.Resize(vs.Len() - i)

	// Process the rest of the rows.
	for l := vs.Len(); i < l; i++ {
		// If the current value is nil, append nil and skip to the
		// next point. We do not modify the previous value when we
		// see null and we do not update the timestamp.
		if vs.IsNull(i) {
			b.AppendNull()
			continue
		}

		t := ts.Value(i)

		// If we haven't yet seen a valid value, append nil and use
		// the current value as the previous for the next iteration.
		// to use the current value.
		if !d.isValid {
			b.AppendNull()
			d.t, d.v, d.isValid = t, vs.Value(i), true
			continue
		}

		// We have seen a valid value so retrieve it now.
		pv, cv := d.v, vs.Value(i)
		if d.nonNegative && pv > cv {
			// The previous value is greater than the current
			// value and non-negative was set.
			b.AppendNull()
		} else {
			// Do the derivative.
			elapsed := float64(t-d.t) / d.unit

			var diff float64
			if pv > cv {
				// Avoid wrapping on unsigned subtraction.
				diff = -float64(pv - cv)
			} else {
				diff = float64(cv - pv)
			}

			b.Append(diff / elapsed)
		}
		d.t, d.v, d.isValid = t, cv, true
	}
	return b.NewArray()
}

type derivativeUint struct {
	t           int64
	v           uint64
	isValid     bool
	unit        float64
	nonNegative bool
	initialized bool
}

func (d *derivativeUint) Type() flux.ColType {
	return flux.TFloat
}

func (d *derivativeUint) Do(ts *array.Int, in array.Array, mem memory.Allocator) array.Array {
	// Empty column chunk returns an empty array
	// and does not initialize the derivative.
	if in.Len() == 0 {
		return arrow.Empty(flux.TFloat)
	}

	i := 0

	// Initialize by reading the first value.
	vs := in.(*array.Uint)
	if !d.initialized {
		d.t = ts.Value(i)
		if vs.IsValid(i) {
			d.v, d.isValid = vs.Value(i), true
		}
		d.initialized = true
		i++
	}

	// Initialize the size of the builder.
	b := array.NewFloatBuilder(mem)
	b.Resize(vs.Len() - i)

	// Process the rest of the rows.
	for l := vs.Len(); i < l; i++ {
		// If the current value is nil, append nil and skip to the
		// next point. We do not modify the previous value when we
		// see null and we do not update the timestamp.
		if vs.IsNull(i) {
			b.AppendNull()
			continue
		}

		t := ts.Value(i)

		// If we haven't yet seen a valid value, append nil and use
		// the current value as the previous for the next iteration.
		// to use the current value.
		if !d.isValid {
			b.AppendNull()
			d.t, d.v, d.isValid = t, vs.Value(i), true
			continue
		}

		// We have seen a valid value so retrieve it now.
		pv, cv := d.v, vs.Value(i)
		if d.nonNegative && pv > cv {
			// The previous value is greater than the current
			// value and non-negative was set.
			b.AppendNull()
		} else {
			// Do the derivative.
			elapsed := float64(t-d.t) / d.unit

			var diff float64
			if pv > cv {
				// Avoid wrapping on unsigned subtraction.
				diff = -float64(pv - cv)
			} else {
				diff = float64(cv - pv)
			}

			b.Append(diff / elapsed)
		}
		d.t, d.v, d.isValid = t, cv, true
	}
	return b.NewArray()
}

type derivativeFloat struct {
	t           int64
	v           float64
	isValid     bool
	unit        float64
	nonNegative bool
	initialized bool
}

func (d *derivativeFloat) Type() flux.ColType {
	return flux.TFloat
}

func (d *derivativeFloat) Do(ts *array.Int, in array.Array, mem memory.Allocator) array.Array {
	// Empty column chunk returns an empty array
	// and does not initialize the derivative.
	if in.Len() == 0 {
		return arrow.Empty(flux.TFloat)
	}

	i := 0

	// Initialize by reading the first value.
	vs := in.(*array.Float)
	if !d.initialized {
		d.t = ts.Value(i)
		if vs.IsValid(i) {
			d.v, d.isValid = vs.Value(i), true
		}
		d.initialized = true
		i++
	}

	// Initialize the size of the builder.
	b := array.NewFloatBuilder(mem)
	b.Resize(vs.Len() - i)

	// Process the rest of the rows.
	for l := vs.Len(); i < l; i++ {
		// If the current value is nil, append nil and skip to the
		// next point. We do not modify the previous value when we
		// see null and we do not update the timestamp.
		if vs.IsNull(i) {
			b.AppendNull()
			continue
		}

		t := ts.Value(i)

		// If we haven't yet seen a valid value, append nil and use
		// the current value as the previous for the next iteration.
		// to use the current value.
		if !d.isValid {
			b.AppendNull()
			d.t, d.v, d.isValid = t, vs.Value(i), true
			continue
		}

		// We have seen a valid value so retrieve it now.
		pv, cv := d.v, vs.Value(i)
		if d.nonNegative && pv > cv {
			// The previous value is greater than the current
			// value and non-negative was set.
			b.AppendNull()
		} else {
			// Do the derivative.
			elapsed := float64(t-d.t) / d.unit

			var diff float64
			if pv > cv {
				// Avoid wrapping on unsigned subtraction.
				diff = -float64(pv - cv)
			} else {
				diff = float64(cv - pv)
			}

			b.Append(diff / elapsed)
		}
		d.t, d.v, d.isValid = t, cv, true
	}
	return b.NewArray()
}
