// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/mrusme/journalist/ent/feed"
	"github.com/mrusme/journalist/ent/item"
	"github.com/mrusme/journalist/ent/subscription"
	"github.com/mrusme/journalist/ent/user"
)

// FeedCreate is the builder for creating a Feed entity.
type FeedCreate struct {
	config
	mutation *FeedMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetURL sets the "url" field.
func (fc *FeedCreate) SetURL(s string) *FeedCreate {
	fc.mutation.SetURL(s)
	return fc
}

// SetUsername sets the "username" field.
func (fc *FeedCreate) SetUsername(s string) *FeedCreate {
	fc.mutation.SetUsername(s)
	return fc
}

// SetNillableUsername sets the "username" field if the given value is not nil.
func (fc *FeedCreate) SetNillableUsername(s *string) *FeedCreate {
	if s != nil {
		fc.SetUsername(*s)
	}
	return fc
}

// SetPassword sets the "password" field.
func (fc *FeedCreate) SetPassword(s string) *FeedCreate {
	fc.mutation.SetPassword(s)
	return fc
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (fc *FeedCreate) SetNillablePassword(s *string) *FeedCreate {
	if s != nil {
		fc.SetPassword(*s)
	}
	return fc
}

// SetFeedTitle sets the "feed_title" field.
func (fc *FeedCreate) SetFeedTitle(s string) *FeedCreate {
	fc.mutation.SetFeedTitle(s)
	return fc
}

// SetFeedDescription sets the "feed_description" field.
func (fc *FeedCreate) SetFeedDescription(s string) *FeedCreate {
	fc.mutation.SetFeedDescription(s)
	return fc
}

// SetFeedLink sets the "feed_link" field.
func (fc *FeedCreate) SetFeedLink(s string) *FeedCreate {
	fc.mutation.SetFeedLink(s)
	return fc
}

// SetFeedFeedLink sets the "feed_feed_link" field.
func (fc *FeedCreate) SetFeedFeedLink(s string) *FeedCreate {
	fc.mutation.SetFeedFeedLink(s)
	return fc
}

// SetFeedUpdated sets the "feed_updated" field.
func (fc *FeedCreate) SetFeedUpdated(t time.Time) *FeedCreate {
	fc.mutation.SetFeedUpdated(t)
	return fc
}

// SetFeedPublished sets the "feed_published" field.
func (fc *FeedCreate) SetFeedPublished(t time.Time) *FeedCreate {
	fc.mutation.SetFeedPublished(t)
	return fc
}

// SetFeedAuthorName sets the "feed_author_name" field.
func (fc *FeedCreate) SetFeedAuthorName(s string) *FeedCreate {
	fc.mutation.SetFeedAuthorName(s)
	return fc
}

// SetNillableFeedAuthorName sets the "feed_author_name" field if the given value is not nil.
func (fc *FeedCreate) SetNillableFeedAuthorName(s *string) *FeedCreate {
	if s != nil {
		fc.SetFeedAuthorName(*s)
	}
	return fc
}

// SetFeedAuthorEmail sets the "feed_author_email" field.
func (fc *FeedCreate) SetFeedAuthorEmail(s string) *FeedCreate {
	fc.mutation.SetFeedAuthorEmail(s)
	return fc
}

// SetNillableFeedAuthorEmail sets the "feed_author_email" field if the given value is not nil.
func (fc *FeedCreate) SetNillableFeedAuthorEmail(s *string) *FeedCreate {
	if s != nil {
		fc.SetFeedAuthorEmail(*s)
	}
	return fc
}

// SetFeedLanguage sets the "feed_language" field.
func (fc *FeedCreate) SetFeedLanguage(s string) *FeedCreate {
	fc.mutation.SetFeedLanguage(s)
	return fc
}

// SetFeedImageTitle sets the "feed_image_title" field.
func (fc *FeedCreate) SetFeedImageTitle(s string) *FeedCreate {
	fc.mutation.SetFeedImageTitle(s)
	return fc
}

// SetNillableFeedImageTitle sets the "feed_image_title" field if the given value is not nil.
func (fc *FeedCreate) SetNillableFeedImageTitle(s *string) *FeedCreate {
	if s != nil {
		fc.SetFeedImageTitle(*s)
	}
	return fc
}

// SetFeedImageURL sets the "feed_image_url" field.
func (fc *FeedCreate) SetFeedImageURL(s string) *FeedCreate {
	fc.mutation.SetFeedImageURL(s)
	return fc
}

// SetNillableFeedImageURL sets the "feed_image_url" field if the given value is not nil.
func (fc *FeedCreate) SetNillableFeedImageURL(s *string) *FeedCreate {
	if s != nil {
		fc.SetFeedImageURL(*s)
	}
	return fc
}

// SetFeedCopyright sets the "feed_copyright" field.
func (fc *FeedCreate) SetFeedCopyright(s string) *FeedCreate {
	fc.mutation.SetFeedCopyright(s)
	return fc
}

// SetFeedGenerator sets the "feed_generator" field.
func (fc *FeedCreate) SetFeedGenerator(s string) *FeedCreate {
	fc.mutation.SetFeedGenerator(s)
	return fc
}

// SetFeedCategories sets the "feed_categories" field.
func (fc *FeedCreate) SetFeedCategories(s string) *FeedCreate {
	fc.mutation.SetFeedCategories(s)
	return fc
}

// SetCreatedAt sets the "created_at" field.
func (fc *FeedCreate) SetCreatedAt(t time.Time) *FeedCreate {
	fc.mutation.SetCreatedAt(t)
	return fc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (fc *FeedCreate) SetNillableCreatedAt(t *time.Time) *FeedCreate {
	if t != nil {
		fc.SetCreatedAt(*t)
	}
	return fc
}

// SetUpdatedAt sets the "updated_at" field.
func (fc *FeedCreate) SetUpdatedAt(t time.Time) *FeedCreate {
	fc.mutation.SetUpdatedAt(t)
	return fc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (fc *FeedCreate) SetNillableUpdatedAt(t *time.Time) *FeedCreate {
	if t != nil {
		fc.SetUpdatedAt(*t)
	}
	return fc
}

// SetDeletedAt sets the "deleted_at" field.
func (fc *FeedCreate) SetDeletedAt(t time.Time) *FeedCreate {
	fc.mutation.SetDeletedAt(t)
	return fc
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (fc *FeedCreate) SetNillableDeletedAt(t *time.Time) *FeedCreate {
	if t != nil {
		fc.SetDeletedAt(*t)
	}
	return fc
}

// SetID sets the "id" field.
func (fc *FeedCreate) SetID(u uuid.UUID) *FeedCreate {
	fc.mutation.SetID(u)
	return fc
}

// SetNillableID sets the "id" field if the given value is not nil.
func (fc *FeedCreate) SetNillableID(u *uuid.UUID) *FeedCreate {
	if u != nil {
		fc.SetID(*u)
	}
	return fc
}

// AddItemIDs adds the "items" edge to the Item entity by IDs.
func (fc *FeedCreate) AddItemIDs(ids ...uuid.UUID) *FeedCreate {
	fc.mutation.AddItemIDs(ids...)
	return fc
}

// AddItems adds the "items" edges to the Item entity.
func (fc *FeedCreate) AddItems(i ...*Item) *FeedCreate {
	ids := make([]uuid.UUID, len(i))
	for j := range i {
		ids[j] = i[j].ID
	}
	return fc.AddItemIDs(ids...)
}

// AddSubscribedUserIDs adds the "subscribed_users" edge to the User entity by IDs.
func (fc *FeedCreate) AddSubscribedUserIDs(ids ...uuid.UUID) *FeedCreate {
	fc.mutation.AddSubscribedUserIDs(ids...)
	return fc
}

// AddSubscribedUsers adds the "subscribed_users" edges to the User entity.
func (fc *FeedCreate) AddSubscribedUsers(u ...*User) *FeedCreate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return fc.AddSubscribedUserIDs(ids...)
}

// AddSubscriptionIDs adds the "subscriptions" edge to the Subscription entity by IDs.
func (fc *FeedCreate) AddSubscriptionIDs(ids ...uuid.UUID) *FeedCreate {
	fc.mutation.AddSubscriptionIDs(ids...)
	return fc
}

// AddSubscriptions adds the "subscriptions" edges to the Subscription entity.
func (fc *FeedCreate) AddSubscriptions(s ...*Subscription) *FeedCreate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return fc.AddSubscriptionIDs(ids...)
}

// Mutation returns the FeedMutation object of the builder.
func (fc *FeedCreate) Mutation() *FeedMutation {
	return fc.mutation
}

// Save creates the Feed in the database.
func (fc *FeedCreate) Save(ctx context.Context) (*Feed, error) {
	fc.defaults()
	return withHooks(ctx, fc.sqlSave, fc.mutation, fc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (fc *FeedCreate) SaveX(ctx context.Context) *Feed {
	v, err := fc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (fc *FeedCreate) Exec(ctx context.Context) error {
	_, err := fc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (fc *FeedCreate) ExecX(ctx context.Context) {
	if err := fc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (fc *FeedCreate) defaults() {
	if _, ok := fc.mutation.Username(); !ok {
		v := feed.DefaultUsername
		fc.mutation.SetUsername(v)
	}
	if _, ok := fc.mutation.Password(); !ok {
		v := feed.DefaultPassword
		fc.mutation.SetPassword(v)
	}
	if _, ok := fc.mutation.CreatedAt(); !ok {
		v := feed.DefaultCreatedAt()
		fc.mutation.SetCreatedAt(v)
	}
	if _, ok := fc.mutation.UpdatedAt(); !ok {
		v := feed.DefaultUpdatedAt()
		fc.mutation.SetUpdatedAt(v)
	}
	if _, ok := fc.mutation.ID(); !ok {
		v := feed.DefaultID()
		fc.mutation.SetID(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (fc *FeedCreate) check() error {
	if _, ok := fc.mutation.URL(); !ok {
		return &ValidationError{Name: "url", err: errors.New(`ent: missing required field "Feed.url"`)}
	}
	if v, ok := fc.mutation.URL(); ok {
		if err := feed.URLValidator(v); err != nil {
			return &ValidationError{Name: "url", err: fmt.Errorf(`ent: validator failed for field "Feed.url": %w`, err)}
		}
	}
	if _, ok := fc.mutation.Username(); !ok {
		return &ValidationError{Name: "username", err: errors.New(`ent: missing required field "Feed.username"`)}
	}
	if _, ok := fc.mutation.Password(); !ok {
		return &ValidationError{Name: "password", err: errors.New(`ent: missing required field "Feed.password"`)}
	}
	if _, ok := fc.mutation.FeedTitle(); !ok {
		return &ValidationError{Name: "feed_title", err: errors.New(`ent: missing required field "Feed.feed_title"`)}
	}
	if _, ok := fc.mutation.FeedDescription(); !ok {
		return &ValidationError{Name: "feed_description", err: errors.New(`ent: missing required field "Feed.feed_description"`)}
	}
	if _, ok := fc.mutation.FeedLink(); !ok {
		return &ValidationError{Name: "feed_link", err: errors.New(`ent: missing required field "Feed.feed_link"`)}
	}
	if _, ok := fc.mutation.FeedFeedLink(); !ok {
		return &ValidationError{Name: "feed_feed_link", err: errors.New(`ent: missing required field "Feed.feed_feed_link"`)}
	}
	if _, ok := fc.mutation.FeedUpdated(); !ok {
		return &ValidationError{Name: "feed_updated", err: errors.New(`ent: missing required field "Feed.feed_updated"`)}
	}
	if _, ok := fc.mutation.FeedPublished(); !ok {
		return &ValidationError{Name: "feed_published", err: errors.New(`ent: missing required field "Feed.feed_published"`)}
	}
	if _, ok := fc.mutation.FeedLanguage(); !ok {
		return &ValidationError{Name: "feed_language", err: errors.New(`ent: missing required field "Feed.feed_language"`)}
	}
	if _, ok := fc.mutation.FeedCopyright(); !ok {
		return &ValidationError{Name: "feed_copyright", err: errors.New(`ent: missing required field "Feed.feed_copyright"`)}
	}
	if _, ok := fc.mutation.FeedGenerator(); !ok {
		return &ValidationError{Name: "feed_generator", err: errors.New(`ent: missing required field "Feed.feed_generator"`)}
	}
	if _, ok := fc.mutation.FeedCategories(); !ok {
		return &ValidationError{Name: "feed_categories", err: errors.New(`ent: missing required field "Feed.feed_categories"`)}
	}
	if _, ok := fc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`ent: missing required field "Feed.created_at"`)}
	}
	if _, ok := fc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`ent: missing required field "Feed.updated_at"`)}
	}
	return nil
}

func (fc *FeedCreate) sqlSave(ctx context.Context) (*Feed, error) {
	if err := fc.check(); err != nil {
		return nil, err
	}
	_node, _spec := fc.createSpec()
	if err := sqlgraph.CreateNode(ctx, fc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	fc.mutation.id = &_node.ID
	fc.mutation.done = true
	return _node, nil
}

func (fc *FeedCreate) createSpec() (*Feed, *sqlgraph.CreateSpec) {
	var (
		_node = &Feed{config: fc.config}
		_spec = sqlgraph.NewCreateSpec(feed.Table, sqlgraph.NewFieldSpec(feed.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = fc.conflict
	if id, ok := fc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := fc.mutation.URL(); ok {
		_spec.SetField(feed.FieldURL, field.TypeString, value)
		_node.URL = value
	}
	if value, ok := fc.mutation.Username(); ok {
		_spec.SetField(feed.FieldUsername, field.TypeString, value)
		_node.Username = value
	}
	if value, ok := fc.mutation.Password(); ok {
		_spec.SetField(feed.FieldPassword, field.TypeString, value)
		_node.Password = value
	}
	if value, ok := fc.mutation.FeedTitle(); ok {
		_spec.SetField(feed.FieldFeedTitle, field.TypeString, value)
		_node.FeedTitle = value
	}
	if value, ok := fc.mutation.FeedDescription(); ok {
		_spec.SetField(feed.FieldFeedDescription, field.TypeString, value)
		_node.FeedDescription = value
	}
	if value, ok := fc.mutation.FeedLink(); ok {
		_spec.SetField(feed.FieldFeedLink, field.TypeString, value)
		_node.FeedLink = value
	}
	if value, ok := fc.mutation.FeedFeedLink(); ok {
		_spec.SetField(feed.FieldFeedFeedLink, field.TypeString, value)
		_node.FeedFeedLink = value
	}
	if value, ok := fc.mutation.FeedUpdated(); ok {
		_spec.SetField(feed.FieldFeedUpdated, field.TypeTime, value)
		_node.FeedUpdated = value
	}
	if value, ok := fc.mutation.FeedPublished(); ok {
		_spec.SetField(feed.FieldFeedPublished, field.TypeTime, value)
		_node.FeedPublished = value
	}
	if value, ok := fc.mutation.FeedAuthorName(); ok {
		_spec.SetField(feed.FieldFeedAuthorName, field.TypeString, value)
		_node.FeedAuthorName = value
	}
	if value, ok := fc.mutation.FeedAuthorEmail(); ok {
		_spec.SetField(feed.FieldFeedAuthorEmail, field.TypeString, value)
		_node.FeedAuthorEmail = value
	}
	if value, ok := fc.mutation.FeedLanguage(); ok {
		_spec.SetField(feed.FieldFeedLanguage, field.TypeString, value)
		_node.FeedLanguage = value
	}
	if value, ok := fc.mutation.FeedImageTitle(); ok {
		_spec.SetField(feed.FieldFeedImageTitle, field.TypeString, value)
		_node.FeedImageTitle = value
	}
	if value, ok := fc.mutation.FeedImageURL(); ok {
		_spec.SetField(feed.FieldFeedImageURL, field.TypeString, value)
		_node.FeedImageURL = value
	}
	if value, ok := fc.mutation.FeedCopyright(); ok {
		_spec.SetField(feed.FieldFeedCopyright, field.TypeString, value)
		_node.FeedCopyright = value
	}
	if value, ok := fc.mutation.FeedGenerator(); ok {
		_spec.SetField(feed.FieldFeedGenerator, field.TypeString, value)
		_node.FeedGenerator = value
	}
	if value, ok := fc.mutation.FeedCategories(); ok {
		_spec.SetField(feed.FieldFeedCategories, field.TypeString, value)
		_node.FeedCategories = value
	}
	if value, ok := fc.mutation.CreatedAt(); ok {
		_spec.SetField(feed.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := fc.mutation.UpdatedAt(); ok {
		_spec.SetField(feed.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if value, ok := fc.mutation.DeletedAt(); ok {
		_spec.SetField(feed.FieldDeletedAt, field.TypeTime, value)
		_node.DeletedAt = &value
	}
	if nodes := fc.mutation.ItemsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   feed.ItemsTable,
			Columns: []string{feed.ItemsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := fc.mutation.SubscribedUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   feed.SubscribedUsersTable,
			Columns: feed.SubscribedUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &SubscriptionCreate{config: fc.config, mutation: newSubscriptionMutation(fc.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := fc.mutation.SubscriptionsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   feed.SubscriptionsTable,
			Columns: []string{feed.SubscriptionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(subscription.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Feed.Create().
//		SetURL(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.FeedUpsert) {
//			SetURL(v+v).
//		}).
//		Exec(ctx)
func (fc *FeedCreate) OnConflict(opts ...sql.ConflictOption) *FeedUpsertOne {
	fc.conflict = opts
	return &FeedUpsertOne{
		create: fc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Feed.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (fc *FeedCreate) OnConflictColumns(columns ...string) *FeedUpsertOne {
	fc.conflict = append(fc.conflict, sql.ConflictColumns(columns...))
	return &FeedUpsertOne{
		create: fc,
	}
}

type (
	// FeedUpsertOne is the builder for "upsert"-ing
	//  one Feed node.
	FeedUpsertOne struct {
		create *FeedCreate
	}

	// FeedUpsert is the "OnConflict" setter.
	FeedUpsert struct {
		*sql.UpdateSet
	}
)

// SetURL sets the "url" field.
func (u *FeedUpsert) SetURL(v string) *FeedUpsert {
	u.Set(feed.FieldURL, v)
	return u
}

// UpdateURL sets the "url" field to the value that was provided on create.
func (u *FeedUpsert) UpdateURL() *FeedUpsert {
	u.SetExcluded(feed.FieldURL)
	return u
}

// SetUsername sets the "username" field.
func (u *FeedUpsert) SetUsername(v string) *FeedUpsert {
	u.Set(feed.FieldUsername, v)
	return u
}

// UpdateUsername sets the "username" field to the value that was provided on create.
func (u *FeedUpsert) UpdateUsername() *FeedUpsert {
	u.SetExcluded(feed.FieldUsername)
	return u
}

// SetPassword sets the "password" field.
func (u *FeedUpsert) SetPassword(v string) *FeedUpsert {
	u.Set(feed.FieldPassword, v)
	return u
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *FeedUpsert) UpdatePassword() *FeedUpsert {
	u.SetExcluded(feed.FieldPassword)
	return u
}

// SetFeedTitle sets the "feed_title" field.
func (u *FeedUpsert) SetFeedTitle(v string) *FeedUpsert {
	u.Set(feed.FieldFeedTitle, v)
	return u
}

// UpdateFeedTitle sets the "feed_title" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedTitle() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedTitle)
	return u
}

// SetFeedDescription sets the "feed_description" field.
func (u *FeedUpsert) SetFeedDescription(v string) *FeedUpsert {
	u.Set(feed.FieldFeedDescription, v)
	return u
}

// UpdateFeedDescription sets the "feed_description" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedDescription() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedDescription)
	return u
}

// SetFeedLink sets the "feed_link" field.
func (u *FeedUpsert) SetFeedLink(v string) *FeedUpsert {
	u.Set(feed.FieldFeedLink, v)
	return u
}

// UpdateFeedLink sets the "feed_link" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedLink() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedLink)
	return u
}

// SetFeedFeedLink sets the "feed_feed_link" field.
func (u *FeedUpsert) SetFeedFeedLink(v string) *FeedUpsert {
	u.Set(feed.FieldFeedFeedLink, v)
	return u
}

// UpdateFeedFeedLink sets the "feed_feed_link" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedFeedLink() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedFeedLink)
	return u
}

// SetFeedUpdated sets the "feed_updated" field.
func (u *FeedUpsert) SetFeedUpdated(v time.Time) *FeedUpsert {
	u.Set(feed.FieldFeedUpdated, v)
	return u
}

// UpdateFeedUpdated sets the "feed_updated" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedUpdated() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedUpdated)
	return u
}

// SetFeedPublished sets the "feed_published" field.
func (u *FeedUpsert) SetFeedPublished(v time.Time) *FeedUpsert {
	u.Set(feed.FieldFeedPublished, v)
	return u
}

// UpdateFeedPublished sets the "feed_published" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedPublished() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedPublished)
	return u
}

// SetFeedAuthorName sets the "feed_author_name" field.
func (u *FeedUpsert) SetFeedAuthorName(v string) *FeedUpsert {
	u.Set(feed.FieldFeedAuthorName, v)
	return u
}

// UpdateFeedAuthorName sets the "feed_author_name" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedAuthorName() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedAuthorName)
	return u
}

// ClearFeedAuthorName clears the value of the "feed_author_name" field.
func (u *FeedUpsert) ClearFeedAuthorName() *FeedUpsert {
	u.SetNull(feed.FieldFeedAuthorName)
	return u
}

// SetFeedAuthorEmail sets the "feed_author_email" field.
func (u *FeedUpsert) SetFeedAuthorEmail(v string) *FeedUpsert {
	u.Set(feed.FieldFeedAuthorEmail, v)
	return u
}

// UpdateFeedAuthorEmail sets the "feed_author_email" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedAuthorEmail() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedAuthorEmail)
	return u
}

// ClearFeedAuthorEmail clears the value of the "feed_author_email" field.
func (u *FeedUpsert) ClearFeedAuthorEmail() *FeedUpsert {
	u.SetNull(feed.FieldFeedAuthorEmail)
	return u
}

// SetFeedLanguage sets the "feed_language" field.
func (u *FeedUpsert) SetFeedLanguage(v string) *FeedUpsert {
	u.Set(feed.FieldFeedLanguage, v)
	return u
}

// UpdateFeedLanguage sets the "feed_language" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedLanguage() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedLanguage)
	return u
}

// SetFeedImageTitle sets the "feed_image_title" field.
func (u *FeedUpsert) SetFeedImageTitle(v string) *FeedUpsert {
	u.Set(feed.FieldFeedImageTitle, v)
	return u
}

// UpdateFeedImageTitle sets the "feed_image_title" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedImageTitle() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedImageTitle)
	return u
}

// ClearFeedImageTitle clears the value of the "feed_image_title" field.
func (u *FeedUpsert) ClearFeedImageTitle() *FeedUpsert {
	u.SetNull(feed.FieldFeedImageTitle)
	return u
}

// SetFeedImageURL sets the "feed_image_url" field.
func (u *FeedUpsert) SetFeedImageURL(v string) *FeedUpsert {
	u.Set(feed.FieldFeedImageURL, v)
	return u
}

// UpdateFeedImageURL sets the "feed_image_url" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedImageURL() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedImageURL)
	return u
}

// ClearFeedImageURL clears the value of the "feed_image_url" field.
func (u *FeedUpsert) ClearFeedImageURL() *FeedUpsert {
	u.SetNull(feed.FieldFeedImageURL)
	return u
}

// SetFeedCopyright sets the "feed_copyright" field.
func (u *FeedUpsert) SetFeedCopyright(v string) *FeedUpsert {
	u.Set(feed.FieldFeedCopyright, v)
	return u
}

// UpdateFeedCopyright sets the "feed_copyright" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedCopyright() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedCopyright)
	return u
}

// SetFeedGenerator sets the "feed_generator" field.
func (u *FeedUpsert) SetFeedGenerator(v string) *FeedUpsert {
	u.Set(feed.FieldFeedGenerator, v)
	return u
}

// UpdateFeedGenerator sets the "feed_generator" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedGenerator() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedGenerator)
	return u
}

// SetFeedCategories sets the "feed_categories" field.
func (u *FeedUpsert) SetFeedCategories(v string) *FeedUpsert {
	u.Set(feed.FieldFeedCategories, v)
	return u
}

// UpdateFeedCategories sets the "feed_categories" field to the value that was provided on create.
func (u *FeedUpsert) UpdateFeedCategories() *FeedUpsert {
	u.SetExcluded(feed.FieldFeedCategories)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *FeedUpsert) SetCreatedAt(v time.Time) *FeedUpsert {
	u.Set(feed.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *FeedUpsert) UpdateCreatedAt() *FeedUpsert {
	u.SetExcluded(feed.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *FeedUpsert) SetUpdatedAt(v time.Time) *FeedUpsert {
	u.Set(feed.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *FeedUpsert) UpdateUpdatedAt() *FeedUpsert {
	u.SetExcluded(feed.FieldUpdatedAt)
	return u
}

// SetDeletedAt sets the "deleted_at" field.
func (u *FeedUpsert) SetDeletedAt(v time.Time) *FeedUpsert {
	u.Set(feed.FieldDeletedAt, v)
	return u
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *FeedUpsert) UpdateDeletedAt() *FeedUpsert {
	u.SetExcluded(feed.FieldDeletedAt)
	return u
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *FeedUpsert) ClearDeletedAt() *FeedUpsert {
	u.SetNull(feed.FieldDeletedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.Feed.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(feed.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *FeedUpsertOne) UpdateNewValues() *FeedUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(feed.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Feed.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *FeedUpsertOne) Ignore() *FeedUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *FeedUpsertOne) DoNothing() *FeedUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the FeedCreate.OnConflict
// documentation for more info.
func (u *FeedUpsertOne) Update(set func(*FeedUpsert)) *FeedUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&FeedUpsert{UpdateSet: update})
	}))
	return u
}

// SetURL sets the "url" field.
func (u *FeedUpsertOne) SetURL(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetURL(v)
	})
}

// UpdateURL sets the "url" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateURL() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateURL()
	})
}

// SetUsername sets the "username" field.
func (u *FeedUpsertOne) SetUsername(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetUsername(v)
	})
}

// UpdateUsername sets the "username" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateUsername() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateUsername()
	})
}

// SetPassword sets the "password" field.
func (u *FeedUpsertOne) SetPassword(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetPassword(v)
	})
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdatePassword() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdatePassword()
	})
}

// SetFeedTitle sets the "feed_title" field.
func (u *FeedUpsertOne) SetFeedTitle(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedTitle(v)
	})
}

// UpdateFeedTitle sets the "feed_title" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedTitle() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedTitle()
	})
}

// SetFeedDescription sets the "feed_description" field.
func (u *FeedUpsertOne) SetFeedDescription(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedDescription(v)
	})
}

// UpdateFeedDescription sets the "feed_description" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedDescription() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedDescription()
	})
}

// SetFeedLink sets the "feed_link" field.
func (u *FeedUpsertOne) SetFeedLink(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedLink(v)
	})
}

// UpdateFeedLink sets the "feed_link" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedLink() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedLink()
	})
}

// SetFeedFeedLink sets the "feed_feed_link" field.
func (u *FeedUpsertOne) SetFeedFeedLink(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedFeedLink(v)
	})
}

// UpdateFeedFeedLink sets the "feed_feed_link" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedFeedLink() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedFeedLink()
	})
}

// SetFeedUpdated sets the "feed_updated" field.
func (u *FeedUpsertOne) SetFeedUpdated(v time.Time) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedUpdated(v)
	})
}

// UpdateFeedUpdated sets the "feed_updated" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedUpdated() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedUpdated()
	})
}

// SetFeedPublished sets the "feed_published" field.
func (u *FeedUpsertOne) SetFeedPublished(v time.Time) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedPublished(v)
	})
}

// UpdateFeedPublished sets the "feed_published" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedPublished() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedPublished()
	})
}

// SetFeedAuthorName sets the "feed_author_name" field.
func (u *FeedUpsertOne) SetFeedAuthorName(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedAuthorName(v)
	})
}

// UpdateFeedAuthorName sets the "feed_author_name" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedAuthorName() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedAuthorName()
	})
}

// ClearFeedAuthorName clears the value of the "feed_author_name" field.
func (u *FeedUpsertOne) ClearFeedAuthorName() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.ClearFeedAuthorName()
	})
}

// SetFeedAuthorEmail sets the "feed_author_email" field.
func (u *FeedUpsertOne) SetFeedAuthorEmail(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedAuthorEmail(v)
	})
}

// UpdateFeedAuthorEmail sets the "feed_author_email" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedAuthorEmail() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedAuthorEmail()
	})
}

// ClearFeedAuthorEmail clears the value of the "feed_author_email" field.
func (u *FeedUpsertOne) ClearFeedAuthorEmail() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.ClearFeedAuthorEmail()
	})
}

// SetFeedLanguage sets the "feed_language" field.
func (u *FeedUpsertOne) SetFeedLanguage(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedLanguage(v)
	})
}

// UpdateFeedLanguage sets the "feed_language" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedLanguage() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedLanguage()
	})
}

// SetFeedImageTitle sets the "feed_image_title" field.
func (u *FeedUpsertOne) SetFeedImageTitle(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedImageTitle(v)
	})
}

// UpdateFeedImageTitle sets the "feed_image_title" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedImageTitle() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedImageTitle()
	})
}

// ClearFeedImageTitle clears the value of the "feed_image_title" field.
func (u *FeedUpsertOne) ClearFeedImageTitle() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.ClearFeedImageTitle()
	})
}

// SetFeedImageURL sets the "feed_image_url" field.
func (u *FeedUpsertOne) SetFeedImageURL(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedImageURL(v)
	})
}

// UpdateFeedImageURL sets the "feed_image_url" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedImageURL() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedImageURL()
	})
}

// ClearFeedImageURL clears the value of the "feed_image_url" field.
func (u *FeedUpsertOne) ClearFeedImageURL() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.ClearFeedImageURL()
	})
}

// SetFeedCopyright sets the "feed_copyright" field.
func (u *FeedUpsertOne) SetFeedCopyright(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedCopyright(v)
	})
}

// UpdateFeedCopyright sets the "feed_copyright" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedCopyright() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedCopyright()
	})
}

// SetFeedGenerator sets the "feed_generator" field.
func (u *FeedUpsertOne) SetFeedGenerator(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedGenerator(v)
	})
}

// UpdateFeedGenerator sets the "feed_generator" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedGenerator() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedGenerator()
	})
}

// SetFeedCategories sets the "feed_categories" field.
func (u *FeedUpsertOne) SetFeedCategories(v string) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedCategories(v)
	})
}

// UpdateFeedCategories sets the "feed_categories" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateFeedCategories() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedCategories()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *FeedUpsertOne) SetCreatedAt(v time.Time) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateCreatedAt() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *FeedUpsertOne) SetUpdatedAt(v time.Time) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateUpdatedAt() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateUpdatedAt()
	})
}

// SetDeletedAt sets the "deleted_at" field.
func (u *FeedUpsertOne) SetDeletedAt(v time.Time) *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.SetDeletedAt(v)
	})
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *FeedUpsertOne) UpdateDeletedAt() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateDeletedAt()
	})
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *FeedUpsertOne) ClearDeletedAt() *FeedUpsertOne {
	return u.Update(func(s *FeedUpsert) {
		s.ClearDeletedAt()
	})
}

// Exec executes the query.
func (u *FeedUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for FeedCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *FeedUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *FeedUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("ent: FeedUpsertOne.ID is not supported by MySQL driver. Use FeedUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *FeedUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// FeedCreateBulk is the builder for creating many Feed entities in bulk.
type FeedCreateBulk struct {
	config
	err      error
	builders []*FeedCreate
	conflict []sql.ConflictOption
}

// Save creates the Feed entities in the database.
func (fcb *FeedCreateBulk) Save(ctx context.Context) ([]*Feed, error) {
	if fcb.err != nil {
		return nil, fcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(fcb.builders))
	nodes := make([]*Feed, len(fcb.builders))
	mutators := make([]Mutator, len(fcb.builders))
	for i := range fcb.builders {
		func(i int, root context.Context) {
			builder := fcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*FeedMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, fcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = fcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, fcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, fcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (fcb *FeedCreateBulk) SaveX(ctx context.Context) []*Feed {
	v, err := fcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (fcb *FeedCreateBulk) Exec(ctx context.Context) error {
	_, err := fcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (fcb *FeedCreateBulk) ExecX(ctx context.Context) {
	if err := fcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Feed.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.FeedUpsert) {
//			SetURL(v+v).
//		}).
//		Exec(ctx)
func (fcb *FeedCreateBulk) OnConflict(opts ...sql.ConflictOption) *FeedUpsertBulk {
	fcb.conflict = opts
	return &FeedUpsertBulk{
		create: fcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Feed.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (fcb *FeedCreateBulk) OnConflictColumns(columns ...string) *FeedUpsertBulk {
	fcb.conflict = append(fcb.conflict, sql.ConflictColumns(columns...))
	return &FeedUpsertBulk{
		create: fcb,
	}
}

// FeedUpsertBulk is the builder for "upsert"-ing
// a bulk of Feed nodes.
type FeedUpsertBulk struct {
	create *FeedCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Feed.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(feed.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *FeedUpsertBulk) UpdateNewValues() *FeedUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(feed.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Feed.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *FeedUpsertBulk) Ignore() *FeedUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *FeedUpsertBulk) DoNothing() *FeedUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the FeedCreateBulk.OnConflict
// documentation for more info.
func (u *FeedUpsertBulk) Update(set func(*FeedUpsert)) *FeedUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&FeedUpsert{UpdateSet: update})
	}))
	return u
}

// SetURL sets the "url" field.
func (u *FeedUpsertBulk) SetURL(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetURL(v)
	})
}

// UpdateURL sets the "url" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateURL() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateURL()
	})
}

// SetUsername sets the "username" field.
func (u *FeedUpsertBulk) SetUsername(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetUsername(v)
	})
}

// UpdateUsername sets the "username" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateUsername() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateUsername()
	})
}

// SetPassword sets the "password" field.
func (u *FeedUpsertBulk) SetPassword(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetPassword(v)
	})
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdatePassword() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdatePassword()
	})
}

// SetFeedTitle sets the "feed_title" field.
func (u *FeedUpsertBulk) SetFeedTitle(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedTitle(v)
	})
}

// UpdateFeedTitle sets the "feed_title" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedTitle() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedTitle()
	})
}

// SetFeedDescription sets the "feed_description" field.
func (u *FeedUpsertBulk) SetFeedDescription(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedDescription(v)
	})
}

// UpdateFeedDescription sets the "feed_description" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedDescription() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedDescription()
	})
}

// SetFeedLink sets the "feed_link" field.
func (u *FeedUpsertBulk) SetFeedLink(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedLink(v)
	})
}

// UpdateFeedLink sets the "feed_link" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedLink() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedLink()
	})
}

// SetFeedFeedLink sets the "feed_feed_link" field.
func (u *FeedUpsertBulk) SetFeedFeedLink(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedFeedLink(v)
	})
}

// UpdateFeedFeedLink sets the "feed_feed_link" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedFeedLink() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedFeedLink()
	})
}

// SetFeedUpdated sets the "feed_updated" field.
func (u *FeedUpsertBulk) SetFeedUpdated(v time.Time) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedUpdated(v)
	})
}

// UpdateFeedUpdated sets the "feed_updated" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedUpdated() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedUpdated()
	})
}

// SetFeedPublished sets the "feed_published" field.
func (u *FeedUpsertBulk) SetFeedPublished(v time.Time) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedPublished(v)
	})
}

// UpdateFeedPublished sets the "feed_published" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedPublished() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedPublished()
	})
}

// SetFeedAuthorName sets the "feed_author_name" field.
func (u *FeedUpsertBulk) SetFeedAuthorName(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedAuthorName(v)
	})
}

// UpdateFeedAuthorName sets the "feed_author_name" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedAuthorName() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedAuthorName()
	})
}

// ClearFeedAuthorName clears the value of the "feed_author_name" field.
func (u *FeedUpsertBulk) ClearFeedAuthorName() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.ClearFeedAuthorName()
	})
}

// SetFeedAuthorEmail sets the "feed_author_email" field.
func (u *FeedUpsertBulk) SetFeedAuthorEmail(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedAuthorEmail(v)
	})
}

// UpdateFeedAuthorEmail sets the "feed_author_email" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedAuthorEmail() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedAuthorEmail()
	})
}

// ClearFeedAuthorEmail clears the value of the "feed_author_email" field.
func (u *FeedUpsertBulk) ClearFeedAuthorEmail() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.ClearFeedAuthorEmail()
	})
}

// SetFeedLanguage sets the "feed_language" field.
func (u *FeedUpsertBulk) SetFeedLanguage(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedLanguage(v)
	})
}

// UpdateFeedLanguage sets the "feed_language" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedLanguage() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedLanguage()
	})
}

// SetFeedImageTitle sets the "feed_image_title" field.
func (u *FeedUpsertBulk) SetFeedImageTitle(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedImageTitle(v)
	})
}

// UpdateFeedImageTitle sets the "feed_image_title" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedImageTitle() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedImageTitle()
	})
}

// ClearFeedImageTitle clears the value of the "feed_image_title" field.
func (u *FeedUpsertBulk) ClearFeedImageTitle() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.ClearFeedImageTitle()
	})
}

// SetFeedImageURL sets the "feed_image_url" field.
func (u *FeedUpsertBulk) SetFeedImageURL(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedImageURL(v)
	})
}

// UpdateFeedImageURL sets the "feed_image_url" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedImageURL() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedImageURL()
	})
}

// ClearFeedImageURL clears the value of the "feed_image_url" field.
func (u *FeedUpsertBulk) ClearFeedImageURL() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.ClearFeedImageURL()
	})
}

// SetFeedCopyright sets the "feed_copyright" field.
func (u *FeedUpsertBulk) SetFeedCopyright(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedCopyright(v)
	})
}

// UpdateFeedCopyright sets the "feed_copyright" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedCopyright() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedCopyright()
	})
}

// SetFeedGenerator sets the "feed_generator" field.
func (u *FeedUpsertBulk) SetFeedGenerator(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedGenerator(v)
	})
}

// UpdateFeedGenerator sets the "feed_generator" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedGenerator() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedGenerator()
	})
}

// SetFeedCategories sets the "feed_categories" field.
func (u *FeedUpsertBulk) SetFeedCategories(v string) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetFeedCategories(v)
	})
}

// UpdateFeedCategories sets the "feed_categories" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateFeedCategories() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateFeedCategories()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *FeedUpsertBulk) SetCreatedAt(v time.Time) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateCreatedAt() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *FeedUpsertBulk) SetUpdatedAt(v time.Time) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateUpdatedAt() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateUpdatedAt()
	})
}

// SetDeletedAt sets the "deleted_at" field.
func (u *FeedUpsertBulk) SetDeletedAt(v time.Time) *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.SetDeletedAt(v)
	})
}

// UpdateDeletedAt sets the "deleted_at" field to the value that was provided on create.
func (u *FeedUpsertBulk) UpdateDeletedAt() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.UpdateDeletedAt()
	})
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (u *FeedUpsertBulk) ClearDeletedAt() *FeedUpsertBulk {
	return u.Update(func(s *FeedUpsert) {
		s.ClearDeletedAt()
	})
}

// Exec executes the query.
func (u *FeedUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the FeedCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for FeedCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *FeedUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
