// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/mrusme/journalist/ent/feed"
	"github.com/mrusme/journalist/ent/item"
	"github.com/mrusme/journalist/ent/predicate"
	"github.com/mrusme/journalist/ent/read"
	"github.com/mrusme/journalist/ent/user"
)

// ItemUpdate is the builder for updating Item entities.
type ItemUpdate struct {
	config
	hooks    []Hook
	mutation *ItemMutation
}

// Where appends a list predicates to the ItemUpdate builder.
func (iu *ItemUpdate) Where(ps ...predicate.Item) *ItemUpdate {
	iu.mutation.Where(ps...)
	return iu
}

// SetItemGUID sets the "item_guid" field.
func (iu *ItemUpdate) SetItemGUID(s string) *ItemUpdate {
	iu.mutation.SetItemGUID(s)
	return iu
}

// SetNillableItemGUID sets the "item_guid" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemGUID(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemGUID(*s)
	}
	return iu
}

// SetItemTitle sets the "item_title" field.
func (iu *ItemUpdate) SetItemTitle(s string) *ItemUpdate {
	iu.mutation.SetItemTitle(s)
	return iu
}

// SetNillableItemTitle sets the "item_title" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemTitle(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemTitle(*s)
	}
	return iu
}

// SetItemDescription sets the "item_description" field.
func (iu *ItemUpdate) SetItemDescription(s string) *ItemUpdate {
	iu.mutation.SetItemDescription(s)
	return iu
}

// SetNillableItemDescription sets the "item_description" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemDescription(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemDescription(*s)
	}
	return iu
}

// SetItemContent sets the "item_content" field.
func (iu *ItemUpdate) SetItemContent(s string) *ItemUpdate {
	iu.mutation.SetItemContent(s)
	return iu
}

// SetNillableItemContent sets the "item_content" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemContent(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemContent(*s)
	}
	return iu
}

// SetItemLink sets the "item_link" field.
func (iu *ItemUpdate) SetItemLink(s string) *ItemUpdate {
	iu.mutation.SetItemLink(s)
	return iu
}

// SetNillableItemLink sets the "item_link" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemLink(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemLink(*s)
	}
	return iu
}

// SetItemUpdated sets the "item_updated" field.
func (iu *ItemUpdate) SetItemUpdated(t time.Time) *ItemUpdate {
	iu.mutation.SetItemUpdated(t)
	return iu
}

// SetNillableItemUpdated sets the "item_updated" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemUpdated(t *time.Time) *ItemUpdate {
	if t != nil {
		iu.SetItemUpdated(*t)
	}
	return iu
}

// SetItemPublished sets the "item_published" field.
func (iu *ItemUpdate) SetItemPublished(t time.Time) *ItemUpdate {
	iu.mutation.SetItemPublished(t)
	return iu
}

// SetNillableItemPublished sets the "item_published" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemPublished(t *time.Time) *ItemUpdate {
	if t != nil {
		iu.SetItemPublished(*t)
	}
	return iu
}

// SetItemAuthorName sets the "item_author_name" field.
func (iu *ItemUpdate) SetItemAuthorName(s string) *ItemUpdate {
	iu.mutation.SetItemAuthorName(s)
	return iu
}

// SetNillableItemAuthorName sets the "item_author_name" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemAuthorName(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemAuthorName(*s)
	}
	return iu
}

// ClearItemAuthorName clears the value of the "item_author_name" field.
func (iu *ItemUpdate) ClearItemAuthorName() *ItemUpdate {
	iu.mutation.ClearItemAuthorName()
	return iu
}

// SetItemAuthorEmail sets the "item_author_email" field.
func (iu *ItemUpdate) SetItemAuthorEmail(s string) *ItemUpdate {
	iu.mutation.SetItemAuthorEmail(s)
	return iu
}

// SetNillableItemAuthorEmail sets the "item_author_email" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemAuthorEmail(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemAuthorEmail(*s)
	}
	return iu
}

// ClearItemAuthorEmail clears the value of the "item_author_email" field.
func (iu *ItemUpdate) ClearItemAuthorEmail() *ItemUpdate {
	iu.mutation.ClearItemAuthorEmail()
	return iu
}

// SetItemImageTitle sets the "item_image_title" field.
func (iu *ItemUpdate) SetItemImageTitle(s string) *ItemUpdate {
	iu.mutation.SetItemImageTitle(s)
	return iu
}

// SetNillableItemImageTitle sets the "item_image_title" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemImageTitle(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemImageTitle(*s)
	}
	return iu
}

// ClearItemImageTitle clears the value of the "item_image_title" field.
func (iu *ItemUpdate) ClearItemImageTitle() *ItemUpdate {
	iu.mutation.ClearItemImageTitle()
	return iu
}

// SetItemImageURL sets the "item_image_url" field.
func (iu *ItemUpdate) SetItemImageURL(s string) *ItemUpdate {
	iu.mutation.SetItemImageURL(s)
	return iu
}

// SetNillableItemImageURL sets the "item_image_url" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemImageURL(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemImageURL(*s)
	}
	return iu
}

// ClearItemImageURL clears the value of the "item_image_url" field.
func (iu *ItemUpdate) ClearItemImageURL() *ItemUpdate {
	iu.mutation.ClearItemImageURL()
	return iu
}

// SetItemCategories sets the "item_categories" field.
func (iu *ItemUpdate) SetItemCategories(s string) *ItemUpdate {
	iu.mutation.SetItemCategories(s)
	return iu
}

// SetNillableItemCategories sets the "item_categories" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemCategories(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemCategories(*s)
	}
	return iu
}

// SetItemEnclosures sets the "item_enclosures" field.
func (iu *ItemUpdate) SetItemEnclosures(s string) *ItemUpdate {
	iu.mutation.SetItemEnclosures(s)
	return iu
}

// SetNillableItemEnclosures sets the "item_enclosures" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableItemEnclosures(s *string) *ItemUpdate {
	if s != nil {
		iu.SetItemEnclosures(*s)
	}
	return iu
}

// SetCrawlerTitle sets the "crawler_title" field.
func (iu *ItemUpdate) SetCrawlerTitle(s string) *ItemUpdate {
	iu.mutation.SetCrawlerTitle(s)
	return iu
}

// SetNillableCrawlerTitle sets the "crawler_title" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableCrawlerTitle(s *string) *ItemUpdate {
	if s != nil {
		iu.SetCrawlerTitle(*s)
	}
	return iu
}

// ClearCrawlerTitle clears the value of the "crawler_title" field.
func (iu *ItemUpdate) ClearCrawlerTitle() *ItemUpdate {
	iu.mutation.ClearCrawlerTitle()
	return iu
}

// SetCrawlerAuthor sets the "crawler_author" field.
func (iu *ItemUpdate) SetCrawlerAuthor(s string) *ItemUpdate {
	iu.mutation.SetCrawlerAuthor(s)
	return iu
}

// SetNillableCrawlerAuthor sets the "crawler_author" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableCrawlerAuthor(s *string) *ItemUpdate {
	if s != nil {
		iu.SetCrawlerAuthor(*s)
	}
	return iu
}

// ClearCrawlerAuthor clears the value of the "crawler_author" field.
func (iu *ItemUpdate) ClearCrawlerAuthor() *ItemUpdate {
	iu.mutation.ClearCrawlerAuthor()
	return iu
}

// SetCrawlerExcerpt sets the "crawler_excerpt" field.
func (iu *ItemUpdate) SetCrawlerExcerpt(s string) *ItemUpdate {
	iu.mutation.SetCrawlerExcerpt(s)
	return iu
}

// SetNillableCrawlerExcerpt sets the "crawler_excerpt" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableCrawlerExcerpt(s *string) *ItemUpdate {
	if s != nil {
		iu.SetCrawlerExcerpt(*s)
	}
	return iu
}

// ClearCrawlerExcerpt clears the value of the "crawler_excerpt" field.
func (iu *ItemUpdate) ClearCrawlerExcerpt() *ItemUpdate {
	iu.mutation.ClearCrawlerExcerpt()
	return iu
}

// SetCrawlerSiteName sets the "crawler_site_name" field.
func (iu *ItemUpdate) SetCrawlerSiteName(s string) *ItemUpdate {
	iu.mutation.SetCrawlerSiteName(s)
	return iu
}

// SetNillableCrawlerSiteName sets the "crawler_site_name" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableCrawlerSiteName(s *string) *ItemUpdate {
	if s != nil {
		iu.SetCrawlerSiteName(*s)
	}
	return iu
}

// ClearCrawlerSiteName clears the value of the "crawler_site_name" field.
func (iu *ItemUpdate) ClearCrawlerSiteName() *ItemUpdate {
	iu.mutation.ClearCrawlerSiteName()
	return iu
}

// SetCrawlerImage sets the "crawler_image" field.
func (iu *ItemUpdate) SetCrawlerImage(s string) *ItemUpdate {
	iu.mutation.SetCrawlerImage(s)
	return iu
}

// SetNillableCrawlerImage sets the "crawler_image" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableCrawlerImage(s *string) *ItemUpdate {
	if s != nil {
		iu.SetCrawlerImage(*s)
	}
	return iu
}

// ClearCrawlerImage clears the value of the "crawler_image" field.
func (iu *ItemUpdate) ClearCrawlerImage() *ItemUpdate {
	iu.mutation.ClearCrawlerImage()
	return iu
}

// SetCrawlerContentHTML sets the "crawler_content_html" field.
func (iu *ItemUpdate) SetCrawlerContentHTML(s string) *ItemUpdate {
	iu.mutation.SetCrawlerContentHTML(s)
	return iu
}

// SetNillableCrawlerContentHTML sets the "crawler_content_html" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableCrawlerContentHTML(s *string) *ItemUpdate {
	if s != nil {
		iu.SetCrawlerContentHTML(*s)
	}
	return iu
}

// ClearCrawlerContentHTML clears the value of the "crawler_content_html" field.
func (iu *ItemUpdate) ClearCrawlerContentHTML() *ItemUpdate {
	iu.mutation.ClearCrawlerContentHTML()
	return iu
}

// SetCrawlerContentText sets the "crawler_content_text" field.
func (iu *ItemUpdate) SetCrawlerContentText(s string) *ItemUpdate {
	iu.mutation.SetCrawlerContentText(s)
	return iu
}

// SetNillableCrawlerContentText sets the "crawler_content_text" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableCrawlerContentText(s *string) *ItemUpdate {
	if s != nil {
		iu.SetCrawlerContentText(*s)
	}
	return iu
}

// ClearCrawlerContentText clears the value of the "crawler_content_text" field.
func (iu *ItemUpdate) ClearCrawlerContentText() *ItemUpdate {
	iu.mutation.ClearCrawlerContentText()
	return iu
}

// SetCreatedAt sets the "created_at" field.
func (iu *ItemUpdate) SetCreatedAt(t time.Time) *ItemUpdate {
	iu.mutation.SetCreatedAt(t)
	return iu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (iu *ItemUpdate) SetNillableCreatedAt(t *time.Time) *ItemUpdate {
	if t != nil {
		iu.SetCreatedAt(*t)
	}
	return iu
}

// SetUpdatedAt sets the "updated_at" field.
func (iu *ItemUpdate) SetUpdatedAt(t time.Time) *ItemUpdate {
	iu.mutation.SetUpdatedAt(t)
	return iu
}

// SetFeedID sets the "feed" edge to the Feed entity by ID.
func (iu *ItemUpdate) SetFeedID(id uuid.UUID) *ItemUpdate {
	iu.mutation.SetFeedID(id)
	return iu
}

// SetNillableFeedID sets the "feed" edge to the Feed entity by ID if the given value is not nil.
func (iu *ItemUpdate) SetNillableFeedID(id *uuid.UUID) *ItemUpdate {
	if id != nil {
		iu = iu.SetFeedID(*id)
	}
	return iu
}

// SetFeed sets the "feed" edge to the Feed entity.
func (iu *ItemUpdate) SetFeed(f *Feed) *ItemUpdate {
	return iu.SetFeedID(f.ID)
}

// AddReadByUserIDs adds the "read_by_users" edge to the User entity by IDs.
func (iu *ItemUpdate) AddReadByUserIDs(ids ...uuid.UUID) *ItemUpdate {
	iu.mutation.AddReadByUserIDs(ids...)
	return iu
}

// AddReadByUsers adds the "read_by_users" edges to the User entity.
func (iu *ItemUpdate) AddReadByUsers(u ...*User) *ItemUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return iu.AddReadByUserIDs(ids...)
}

// AddReadIDs adds the "reads" edge to the Read entity by IDs.
func (iu *ItemUpdate) AddReadIDs(ids ...uuid.UUID) *ItemUpdate {
	iu.mutation.AddReadIDs(ids...)
	return iu
}

// AddReads adds the "reads" edges to the Read entity.
func (iu *ItemUpdate) AddReads(r ...*Read) *ItemUpdate {
	ids := make([]uuid.UUID, len(r))
	for i := range r {
		ids[i] = r[i].ID
	}
	return iu.AddReadIDs(ids...)
}

// Mutation returns the ItemMutation object of the builder.
func (iu *ItemUpdate) Mutation() *ItemMutation {
	return iu.mutation
}

// ClearFeed clears the "feed" edge to the Feed entity.
func (iu *ItemUpdate) ClearFeed() *ItemUpdate {
	iu.mutation.ClearFeed()
	return iu
}

// ClearReadByUsers clears all "read_by_users" edges to the User entity.
func (iu *ItemUpdate) ClearReadByUsers() *ItemUpdate {
	iu.mutation.ClearReadByUsers()
	return iu
}

// RemoveReadByUserIDs removes the "read_by_users" edge to User entities by IDs.
func (iu *ItemUpdate) RemoveReadByUserIDs(ids ...uuid.UUID) *ItemUpdate {
	iu.mutation.RemoveReadByUserIDs(ids...)
	return iu
}

// RemoveReadByUsers removes "read_by_users" edges to User entities.
func (iu *ItemUpdate) RemoveReadByUsers(u ...*User) *ItemUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return iu.RemoveReadByUserIDs(ids...)
}

// ClearReads clears all "reads" edges to the Read entity.
func (iu *ItemUpdate) ClearReads() *ItemUpdate {
	iu.mutation.ClearReads()
	return iu
}

// RemoveReadIDs removes the "reads" edge to Read entities by IDs.
func (iu *ItemUpdate) RemoveReadIDs(ids ...uuid.UUID) *ItemUpdate {
	iu.mutation.RemoveReadIDs(ids...)
	return iu
}

// RemoveReads removes "reads" edges to Read entities.
func (iu *ItemUpdate) RemoveReads(r ...*Read) *ItemUpdate {
	ids := make([]uuid.UUID, len(r))
	for i := range r {
		ids[i] = r[i].ID
	}
	return iu.RemoveReadIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (iu *ItemUpdate) Save(ctx context.Context) (int, error) {
	iu.defaults()
	return withHooks(ctx, iu.sqlSave, iu.mutation, iu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (iu *ItemUpdate) SaveX(ctx context.Context) int {
	affected, err := iu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (iu *ItemUpdate) Exec(ctx context.Context) error {
	_, err := iu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (iu *ItemUpdate) ExecX(ctx context.Context) {
	if err := iu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (iu *ItemUpdate) defaults() {
	if _, ok := iu.mutation.UpdatedAt(); !ok {
		v := item.UpdateDefaultUpdatedAt()
		iu.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (iu *ItemUpdate) check() error {
	if v, ok := iu.mutation.ItemLink(); ok {
		if err := item.ItemLinkValidator(v); err != nil {
			return &ValidationError{Name: "item_link", err: fmt.Errorf(`ent: validator failed for field "Item.item_link": %w`, err)}
		}
	}
	return nil
}

func (iu *ItemUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := iu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(item.Table, item.Columns, sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID))
	if ps := iu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := iu.mutation.ItemGUID(); ok {
		_spec.SetField(item.FieldItemGUID, field.TypeString, value)
	}
	if value, ok := iu.mutation.ItemTitle(); ok {
		_spec.SetField(item.FieldItemTitle, field.TypeString, value)
	}
	if value, ok := iu.mutation.ItemDescription(); ok {
		_spec.SetField(item.FieldItemDescription, field.TypeString, value)
	}
	if value, ok := iu.mutation.ItemContent(); ok {
		_spec.SetField(item.FieldItemContent, field.TypeString, value)
	}
	if value, ok := iu.mutation.ItemLink(); ok {
		_spec.SetField(item.FieldItemLink, field.TypeString, value)
	}
	if value, ok := iu.mutation.ItemUpdated(); ok {
		_spec.SetField(item.FieldItemUpdated, field.TypeTime, value)
	}
	if value, ok := iu.mutation.ItemPublished(); ok {
		_spec.SetField(item.FieldItemPublished, field.TypeTime, value)
	}
	if value, ok := iu.mutation.ItemAuthorName(); ok {
		_spec.SetField(item.FieldItemAuthorName, field.TypeString, value)
	}
	if iu.mutation.ItemAuthorNameCleared() {
		_spec.ClearField(item.FieldItemAuthorName, field.TypeString)
	}
	if value, ok := iu.mutation.ItemAuthorEmail(); ok {
		_spec.SetField(item.FieldItemAuthorEmail, field.TypeString, value)
	}
	if iu.mutation.ItemAuthorEmailCleared() {
		_spec.ClearField(item.FieldItemAuthorEmail, field.TypeString)
	}
	if value, ok := iu.mutation.ItemImageTitle(); ok {
		_spec.SetField(item.FieldItemImageTitle, field.TypeString, value)
	}
	if iu.mutation.ItemImageTitleCleared() {
		_spec.ClearField(item.FieldItemImageTitle, field.TypeString)
	}
	if value, ok := iu.mutation.ItemImageURL(); ok {
		_spec.SetField(item.FieldItemImageURL, field.TypeString, value)
	}
	if iu.mutation.ItemImageURLCleared() {
		_spec.ClearField(item.FieldItemImageURL, field.TypeString)
	}
	if value, ok := iu.mutation.ItemCategories(); ok {
		_spec.SetField(item.FieldItemCategories, field.TypeString, value)
	}
	if value, ok := iu.mutation.ItemEnclosures(); ok {
		_spec.SetField(item.FieldItemEnclosures, field.TypeString, value)
	}
	if value, ok := iu.mutation.CrawlerTitle(); ok {
		_spec.SetField(item.FieldCrawlerTitle, field.TypeString, value)
	}
	if iu.mutation.CrawlerTitleCleared() {
		_spec.ClearField(item.FieldCrawlerTitle, field.TypeString)
	}
	if value, ok := iu.mutation.CrawlerAuthor(); ok {
		_spec.SetField(item.FieldCrawlerAuthor, field.TypeString, value)
	}
	if iu.mutation.CrawlerAuthorCleared() {
		_spec.ClearField(item.FieldCrawlerAuthor, field.TypeString)
	}
	if value, ok := iu.mutation.CrawlerExcerpt(); ok {
		_spec.SetField(item.FieldCrawlerExcerpt, field.TypeString, value)
	}
	if iu.mutation.CrawlerExcerptCleared() {
		_spec.ClearField(item.FieldCrawlerExcerpt, field.TypeString)
	}
	if value, ok := iu.mutation.CrawlerSiteName(); ok {
		_spec.SetField(item.FieldCrawlerSiteName, field.TypeString, value)
	}
	if iu.mutation.CrawlerSiteNameCleared() {
		_spec.ClearField(item.FieldCrawlerSiteName, field.TypeString)
	}
	if value, ok := iu.mutation.CrawlerImage(); ok {
		_spec.SetField(item.FieldCrawlerImage, field.TypeString, value)
	}
	if iu.mutation.CrawlerImageCleared() {
		_spec.ClearField(item.FieldCrawlerImage, field.TypeString)
	}
	if value, ok := iu.mutation.CrawlerContentHTML(); ok {
		_spec.SetField(item.FieldCrawlerContentHTML, field.TypeString, value)
	}
	if iu.mutation.CrawlerContentHTMLCleared() {
		_spec.ClearField(item.FieldCrawlerContentHTML, field.TypeString)
	}
	if value, ok := iu.mutation.CrawlerContentText(); ok {
		_spec.SetField(item.FieldCrawlerContentText, field.TypeString, value)
	}
	if iu.mutation.CrawlerContentTextCleared() {
		_spec.ClearField(item.FieldCrawlerContentText, field.TypeString)
	}
	if value, ok := iu.mutation.CreatedAt(); ok {
		_spec.SetField(item.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := iu.mutation.UpdatedAt(); ok {
		_spec.SetField(item.FieldUpdatedAt, field.TypeTime, value)
	}
	if iu.mutation.FeedCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   item.FeedTable,
			Columns: []string{item.FeedColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(feed.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iu.mutation.FeedIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   item.FeedTable,
			Columns: []string{item.FeedColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(feed.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if iu.mutation.ReadByUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   item.ReadByUsersTable,
			Columns: item.ReadByUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		createE := &ReadCreate{config: iu.config, mutation: newReadMutation(iu.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iu.mutation.RemovedReadByUsersIDs(); len(nodes) > 0 && !iu.mutation.ReadByUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   item.ReadByUsersTable,
			Columns: item.ReadByUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &ReadCreate{config: iu.config, mutation: newReadMutation(iu.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iu.mutation.ReadByUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   item.ReadByUsersTable,
			Columns: item.ReadByUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &ReadCreate{config: iu.config, mutation: newReadMutation(iu.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if iu.mutation.ReadsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   item.ReadsTable,
			Columns: []string{item.ReadsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iu.mutation.RemovedReadsIDs(); len(nodes) > 0 && !iu.mutation.ReadsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   item.ReadsTable,
			Columns: []string{item.ReadsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iu.mutation.ReadsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   item.ReadsTable,
			Columns: []string{item.ReadsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, iu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{item.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	iu.mutation.done = true
	return n, nil
}

// ItemUpdateOne is the builder for updating a single Item entity.
type ItemUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *ItemMutation
}

// SetItemGUID sets the "item_guid" field.
func (iuo *ItemUpdateOne) SetItemGUID(s string) *ItemUpdateOne {
	iuo.mutation.SetItemGUID(s)
	return iuo
}

// SetNillableItemGUID sets the "item_guid" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemGUID(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemGUID(*s)
	}
	return iuo
}

// SetItemTitle sets the "item_title" field.
func (iuo *ItemUpdateOne) SetItemTitle(s string) *ItemUpdateOne {
	iuo.mutation.SetItemTitle(s)
	return iuo
}

// SetNillableItemTitle sets the "item_title" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemTitle(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemTitle(*s)
	}
	return iuo
}

// SetItemDescription sets the "item_description" field.
func (iuo *ItemUpdateOne) SetItemDescription(s string) *ItemUpdateOne {
	iuo.mutation.SetItemDescription(s)
	return iuo
}

// SetNillableItemDescription sets the "item_description" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemDescription(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemDescription(*s)
	}
	return iuo
}

// SetItemContent sets the "item_content" field.
func (iuo *ItemUpdateOne) SetItemContent(s string) *ItemUpdateOne {
	iuo.mutation.SetItemContent(s)
	return iuo
}

// SetNillableItemContent sets the "item_content" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemContent(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemContent(*s)
	}
	return iuo
}

// SetItemLink sets the "item_link" field.
func (iuo *ItemUpdateOne) SetItemLink(s string) *ItemUpdateOne {
	iuo.mutation.SetItemLink(s)
	return iuo
}

// SetNillableItemLink sets the "item_link" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemLink(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemLink(*s)
	}
	return iuo
}

// SetItemUpdated sets the "item_updated" field.
func (iuo *ItemUpdateOne) SetItemUpdated(t time.Time) *ItemUpdateOne {
	iuo.mutation.SetItemUpdated(t)
	return iuo
}

// SetNillableItemUpdated sets the "item_updated" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemUpdated(t *time.Time) *ItemUpdateOne {
	if t != nil {
		iuo.SetItemUpdated(*t)
	}
	return iuo
}

// SetItemPublished sets the "item_published" field.
func (iuo *ItemUpdateOne) SetItemPublished(t time.Time) *ItemUpdateOne {
	iuo.mutation.SetItemPublished(t)
	return iuo
}

// SetNillableItemPublished sets the "item_published" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemPublished(t *time.Time) *ItemUpdateOne {
	if t != nil {
		iuo.SetItemPublished(*t)
	}
	return iuo
}

// SetItemAuthorName sets the "item_author_name" field.
func (iuo *ItemUpdateOne) SetItemAuthorName(s string) *ItemUpdateOne {
	iuo.mutation.SetItemAuthorName(s)
	return iuo
}

// SetNillableItemAuthorName sets the "item_author_name" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemAuthorName(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemAuthorName(*s)
	}
	return iuo
}

// ClearItemAuthorName clears the value of the "item_author_name" field.
func (iuo *ItemUpdateOne) ClearItemAuthorName() *ItemUpdateOne {
	iuo.mutation.ClearItemAuthorName()
	return iuo
}

// SetItemAuthorEmail sets the "item_author_email" field.
func (iuo *ItemUpdateOne) SetItemAuthorEmail(s string) *ItemUpdateOne {
	iuo.mutation.SetItemAuthorEmail(s)
	return iuo
}

// SetNillableItemAuthorEmail sets the "item_author_email" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemAuthorEmail(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemAuthorEmail(*s)
	}
	return iuo
}

// ClearItemAuthorEmail clears the value of the "item_author_email" field.
func (iuo *ItemUpdateOne) ClearItemAuthorEmail() *ItemUpdateOne {
	iuo.mutation.ClearItemAuthorEmail()
	return iuo
}

// SetItemImageTitle sets the "item_image_title" field.
func (iuo *ItemUpdateOne) SetItemImageTitle(s string) *ItemUpdateOne {
	iuo.mutation.SetItemImageTitle(s)
	return iuo
}

// SetNillableItemImageTitle sets the "item_image_title" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemImageTitle(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemImageTitle(*s)
	}
	return iuo
}

// ClearItemImageTitle clears the value of the "item_image_title" field.
func (iuo *ItemUpdateOne) ClearItemImageTitle() *ItemUpdateOne {
	iuo.mutation.ClearItemImageTitle()
	return iuo
}

// SetItemImageURL sets the "item_image_url" field.
func (iuo *ItemUpdateOne) SetItemImageURL(s string) *ItemUpdateOne {
	iuo.mutation.SetItemImageURL(s)
	return iuo
}

// SetNillableItemImageURL sets the "item_image_url" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemImageURL(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemImageURL(*s)
	}
	return iuo
}

// ClearItemImageURL clears the value of the "item_image_url" field.
func (iuo *ItemUpdateOne) ClearItemImageURL() *ItemUpdateOne {
	iuo.mutation.ClearItemImageURL()
	return iuo
}

// SetItemCategories sets the "item_categories" field.
func (iuo *ItemUpdateOne) SetItemCategories(s string) *ItemUpdateOne {
	iuo.mutation.SetItemCategories(s)
	return iuo
}

// SetNillableItemCategories sets the "item_categories" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemCategories(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemCategories(*s)
	}
	return iuo
}

// SetItemEnclosures sets the "item_enclosures" field.
func (iuo *ItemUpdateOne) SetItemEnclosures(s string) *ItemUpdateOne {
	iuo.mutation.SetItemEnclosures(s)
	return iuo
}

// SetNillableItemEnclosures sets the "item_enclosures" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableItemEnclosures(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetItemEnclosures(*s)
	}
	return iuo
}

// SetCrawlerTitle sets the "crawler_title" field.
func (iuo *ItemUpdateOne) SetCrawlerTitle(s string) *ItemUpdateOne {
	iuo.mutation.SetCrawlerTitle(s)
	return iuo
}

// SetNillableCrawlerTitle sets the "crawler_title" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableCrawlerTitle(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetCrawlerTitle(*s)
	}
	return iuo
}

// ClearCrawlerTitle clears the value of the "crawler_title" field.
func (iuo *ItemUpdateOne) ClearCrawlerTitle() *ItemUpdateOne {
	iuo.mutation.ClearCrawlerTitle()
	return iuo
}

// SetCrawlerAuthor sets the "crawler_author" field.
func (iuo *ItemUpdateOne) SetCrawlerAuthor(s string) *ItemUpdateOne {
	iuo.mutation.SetCrawlerAuthor(s)
	return iuo
}

// SetNillableCrawlerAuthor sets the "crawler_author" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableCrawlerAuthor(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetCrawlerAuthor(*s)
	}
	return iuo
}

// ClearCrawlerAuthor clears the value of the "crawler_author" field.
func (iuo *ItemUpdateOne) ClearCrawlerAuthor() *ItemUpdateOne {
	iuo.mutation.ClearCrawlerAuthor()
	return iuo
}

// SetCrawlerExcerpt sets the "crawler_excerpt" field.
func (iuo *ItemUpdateOne) SetCrawlerExcerpt(s string) *ItemUpdateOne {
	iuo.mutation.SetCrawlerExcerpt(s)
	return iuo
}

// SetNillableCrawlerExcerpt sets the "crawler_excerpt" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableCrawlerExcerpt(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetCrawlerExcerpt(*s)
	}
	return iuo
}

// ClearCrawlerExcerpt clears the value of the "crawler_excerpt" field.
func (iuo *ItemUpdateOne) ClearCrawlerExcerpt() *ItemUpdateOne {
	iuo.mutation.ClearCrawlerExcerpt()
	return iuo
}

// SetCrawlerSiteName sets the "crawler_site_name" field.
func (iuo *ItemUpdateOne) SetCrawlerSiteName(s string) *ItemUpdateOne {
	iuo.mutation.SetCrawlerSiteName(s)
	return iuo
}

// SetNillableCrawlerSiteName sets the "crawler_site_name" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableCrawlerSiteName(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetCrawlerSiteName(*s)
	}
	return iuo
}

// ClearCrawlerSiteName clears the value of the "crawler_site_name" field.
func (iuo *ItemUpdateOne) ClearCrawlerSiteName() *ItemUpdateOne {
	iuo.mutation.ClearCrawlerSiteName()
	return iuo
}

// SetCrawlerImage sets the "crawler_image" field.
func (iuo *ItemUpdateOne) SetCrawlerImage(s string) *ItemUpdateOne {
	iuo.mutation.SetCrawlerImage(s)
	return iuo
}

// SetNillableCrawlerImage sets the "crawler_image" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableCrawlerImage(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetCrawlerImage(*s)
	}
	return iuo
}

// ClearCrawlerImage clears the value of the "crawler_image" field.
func (iuo *ItemUpdateOne) ClearCrawlerImage() *ItemUpdateOne {
	iuo.mutation.ClearCrawlerImage()
	return iuo
}

// SetCrawlerContentHTML sets the "crawler_content_html" field.
func (iuo *ItemUpdateOne) SetCrawlerContentHTML(s string) *ItemUpdateOne {
	iuo.mutation.SetCrawlerContentHTML(s)
	return iuo
}

// SetNillableCrawlerContentHTML sets the "crawler_content_html" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableCrawlerContentHTML(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetCrawlerContentHTML(*s)
	}
	return iuo
}

// ClearCrawlerContentHTML clears the value of the "crawler_content_html" field.
func (iuo *ItemUpdateOne) ClearCrawlerContentHTML() *ItemUpdateOne {
	iuo.mutation.ClearCrawlerContentHTML()
	return iuo
}

// SetCrawlerContentText sets the "crawler_content_text" field.
func (iuo *ItemUpdateOne) SetCrawlerContentText(s string) *ItemUpdateOne {
	iuo.mutation.SetCrawlerContentText(s)
	return iuo
}

// SetNillableCrawlerContentText sets the "crawler_content_text" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableCrawlerContentText(s *string) *ItemUpdateOne {
	if s != nil {
		iuo.SetCrawlerContentText(*s)
	}
	return iuo
}

// ClearCrawlerContentText clears the value of the "crawler_content_text" field.
func (iuo *ItemUpdateOne) ClearCrawlerContentText() *ItemUpdateOne {
	iuo.mutation.ClearCrawlerContentText()
	return iuo
}

// SetCreatedAt sets the "created_at" field.
func (iuo *ItemUpdateOne) SetCreatedAt(t time.Time) *ItemUpdateOne {
	iuo.mutation.SetCreatedAt(t)
	return iuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableCreatedAt(t *time.Time) *ItemUpdateOne {
	if t != nil {
		iuo.SetCreatedAt(*t)
	}
	return iuo
}

// SetUpdatedAt sets the "updated_at" field.
func (iuo *ItemUpdateOne) SetUpdatedAt(t time.Time) *ItemUpdateOne {
	iuo.mutation.SetUpdatedAt(t)
	return iuo
}

// SetFeedID sets the "feed" edge to the Feed entity by ID.
func (iuo *ItemUpdateOne) SetFeedID(id uuid.UUID) *ItemUpdateOne {
	iuo.mutation.SetFeedID(id)
	return iuo
}

// SetNillableFeedID sets the "feed" edge to the Feed entity by ID if the given value is not nil.
func (iuo *ItemUpdateOne) SetNillableFeedID(id *uuid.UUID) *ItemUpdateOne {
	if id != nil {
		iuo = iuo.SetFeedID(*id)
	}
	return iuo
}

// SetFeed sets the "feed" edge to the Feed entity.
func (iuo *ItemUpdateOne) SetFeed(f *Feed) *ItemUpdateOne {
	return iuo.SetFeedID(f.ID)
}

// AddReadByUserIDs adds the "read_by_users" edge to the User entity by IDs.
func (iuo *ItemUpdateOne) AddReadByUserIDs(ids ...uuid.UUID) *ItemUpdateOne {
	iuo.mutation.AddReadByUserIDs(ids...)
	return iuo
}

// AddReadByUsers adds the "read_by_users" edges to the User entity.
func (iuo *ItemUpdateOne) AddReadByUsers(u ...*User) *ItemUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return iuo.AddReadByUserIDs(ids...)
}

// AddReadIDs adds the "reads" edge to the Read entity by IDs.
func (iuo *ItemUpdateOne) AddReadIDs(ids ...uuid.UUID) *ItemUpdateOne {
	iuo.mutation.AddReadIDs(ids...)
	return iuo
}

// AddReads adds the "reads" edges to the Read entity.
func (iuo *ItemUpdateOne) AddReads(r ...*Read) *ItemUpdateOne {
	ids := make([]uuid.UUID, len(r))
	for i := range r {
		ids[i] = r[i].ID
	}
	return iuo.AddReadIDs(ids...)
}

// Mutation returns the ItemMutation object of the builder.
func (iuo *ItemUpdateOne) Mutation() *ItemMutation {
	return iuo.mutation
}

// ClearFeed clears the "feed" edge to the Feed entity.
func (iuo *ItemUpdateOne) ClearFeed() *ItemUpdateOne {
	iuo.mutation.ClearFeed()
	return iuo
}

// ClearReadByUsers clears all "read_by_users" edges to the User entity.
func (iuo *ItemUpdateOne) ClearReadByUsers() *ItemUpdateOne {
	iuo.mutation.ClearReadByUsers()
	return iuo
}

// RemoveReadByUserIDs removes the "read_by_users" edge to User entities by IDs.
func (iuo *ItemUpdateOne) RemoveReadByUserIDs(ids ...uuid.UUID) *ItemUpdateOne {
	iuo.mutation.RemoveReadByUserIDs(ids...)
	return iuo
}

// RemoveReadByUsers removes "read_by_users" edges to User entities.
func (iuo *ItemUpdateOne) RemoveReadByUsers(u ...*User) *ItemUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return iuo.RemoveReadByUserIDs(ids...)
}

// ClearReads clears all "reads" edges to the Read entity.
func (iuo *ItemUpdateOne) ClearReads() *ItemUpdateOne {
	iuo.mutation.ClearReads()
	return iuo
}

// RemoveReadIDs removes the "reads" edge to Read entities by IDs.
func (iuo *ItemUpdateOne) RemoveReadIDs(ids ...uuid.UUID) *ItemUpdateOne {
	iuo.mutation.RemoveReadIDs(ids...)
	return iuo
}

// RemoveReads removes "reads" edges to Read entities.
func (iuo *ItemUpdateOne) RemoveReads(r ...*Read) *ItemUpdateOne {
	ids := make([]uuid.UUID, len(r))
	for i := range r {
		ids[i] = r[i].ID
	}
	return iuo.RemoveReadIDs(ids...)
}

// Where appends a list predicates to the ItemUpdate builder.
func (iuo *ItemUpdateOne) Where(ps ...predicate.Item) *ItemUpdateOne {
	iuo.mutation.Where(ps...)
	return iuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (iuo *ItemUpdateOne) Select(field string, fields ...string) *ItemUpdateOne {
	iuo.fields = append([]string{field}, fields...)
	return iuo
}

// Save executes the query and returns the updated Item entity.
func (iuo *ItemUpdateOne) Save(ctx context.Context) (*Item, error) {
	iuo.defaults()
	return withHooks(ctx, iuo.sqlSave, iuo.mutation, iuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (iuo *ItemUpdateOne) SaveX(ctx context.Context) *Item {
	node, err := iuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (iuo *ItemUpdateOne) Exec(ctx context.Context) error {
	_, err := iuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (iuo *ItemUpdateOne) ExecX(ctx context.Context) {
	if err := iuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (iuo *ItemUpdateOne) defaults() {
	if _, ok := iuo.mutation.UpdatedAt(); !ok {
		v := item.UpdateDefaultUpdatedAt()
		iuo.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (iuo *ItemUpdateOne) check() error {
	if v, ok := iuo.mutation.ItemLink(); ok {
		if err := item.ItemLinkValidator(v); err != nil {
			return &ValidationError{Name: "item_link", err: fmt.Errorf(`ent: validator failed for field "Item.item_link": %w`, err)}
		}
	}
	return nil
}

func (iuo *ItemUpdateOne) sqlSave(ctx context.Context) (_node *Item, err error) {
	if err := iuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(item.Table, item.Columns, sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID))
	id, ok := iuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Item.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := iuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, item.FieldID)
		for _, f := range fields {
			if !item.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != item.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := iuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := iuo.mutation.ItemGUID(); ok {
		_spec.SetField(item.FieldItemGUID, field.TypeString, value)
	}
	if value, ok := iuo.mutation.ItemTitle(); ok {
		_spec.SetField(item.FieldItemTitle, field.TypeString, value)
	}
	if value, ok := iuo.mutation.ItemDescription(); ok {
		_spec.SetField(item.FieldItemDescription, field.TypeString, value)
	}
	if value, ok := iuo.mutation.ItemContent(); ok {
		_spec.SetField(item.FieldItemContent, field.TypeString, value)
	}
	if value, ok := iuo.mutation.ItemLink(); ok {
		_spec.SetField(item.FieldItemLink, field.TypeString, value)
	}
	if value, ok := iuo.mutation.ItemUpdated(); ok {
		_spec.SetField(item.FieldItemUpdated, field.TypeTime, value)
	}
	if value, ok := iuo.mutation.ItemPublished(); ok {
		_spec.SetField(item.FieldItemPublished, field.TypeTime, value)
	}
	if value, ok := iuo.mutation.ItemAuthorName(); ok {
		_spec.SetField(item.FieldItemAuthorName, field.TypeString, value)
	}
	if iuo.mutation.ItemAuthorNameCleared() {
		_spec.ClearField(item.FieldItemAuthorName, field.TypeString)
	}
	if value, ok := iuo.mutation.ItemAuthorEmail(); ok {
		_spec.SetField(item.FieldItemAuthorEmail, field.TypeString, value)
	}
	if iuo.mutation.ItemAuthorEmailCleared() {
		_spec.ClearField(item.FieldItemAuthorEmail, field.TypeString)
	}
	if value, ok := iuo.mutation.ItemImageTitle(); ok {
		_spec.SetField(item.FieldItemImageTitle, field.TypeString, value)
	}
	if iuo.mutation.ItemImageTitleCleared() {
		_spec.ClearField(item.FieldItemImageTitle, field.TypeString)
	}
	if value, ok := iuo.mutation.ItemImageURL(); ok {
		_spec.SetField(item.FieldItemImageURL, field.TypeString, value)
	}
	if iuo.mutation.ItemImageURLCleared() {
		_spec.ClearField(item.FieldItemImageURL, field.TypeString)
	}
	if value, ok := iuo.mutation.ItemCategories(); ok {
		_spec.SetField(item.FieldItemCategories, field.TypeString, value)
	}
	if value, ok := iuo.mutation.ItemEnclosures(); ok {
		_spec.SetField(item.FieldItemEnclosures, field.TypeString, value)
	}
	if value, ok := iuo.mutation.CrawlerTitle(); ok {
		_spec.SetField(item.FieldCrawlerTitle, field.TypeString, value)
	}
	if iuo.mutation.CrawlerTitleCleared() {
		_spec.ClearField(item.FieldCrawlerTitle, field.TypeString)
	}
	if value, ok := iuo.mutation.CrawlerAuthor(); ok {
		_spec.SetField(item.FieldCrawlerAuthor, field.TypeString, value)
	}
	if iuo.mutation.CrawlerAuthorCleared() {
		_spec.ClearField(item.FieldCrawlerAuthor, field.TypeString)
	}
	if value, ok := iuo.mutation.CrawlerExcerpt(); ok {
		_spec.SetField(item.FieldCrawlerExcerpt, field.TypeString, value)
	}
	if iuo.mutation.CrawlerExcerptCleared() {
		_spec.ClearField(item.FieldCrawlerExcerpt, field.TypeString)
	}
	if value, ok := iuo.mutation.CrawlerSiteName(); ok {
		_spec.SetField(item.FieldCrawlerSiteName, field.TypeString, value)
	}
	if iuo.mutation.CrawlerSiteNameCleared() {
		_spec.ClearField(item.FieldCrawlerSiteName, field.TypeString)
	}
	if value, ok := iuo.mutation.CrawlerImage(); ok {
		_spec.SetField(item.FieldCrawlerImage, field.TypeString, value)
	}
	if iuo.mutation.CrawlerImageCleared() {
		_spec.ClearField(item.FieldCrawlerImage, field.TypeString)
	}
	if value, ok := iuo.mutation.CrawlerContentHTML(); ok {
		_spec.SetField(item.FieldCrawlerContentHTML, field.TypeString, value)
	}
	if iuo.mutation.CrawlerContentHTMLCleared() {
		_spec.ClearField(item.FieldCrawlerContentHTML, field.TypeString)
	}
	if value, ok := iuo.mutation.CrawlerContentText(); ok {
		_spec.SetField(item.FieldCrawlerContentText, field.TypeString, value)
	}
	if iuo.mutation.CrawlerContentTextCleared() {
		_spec.ClearField(item.FieldCrawlerContentText, field.TypeString)
	}
	if value, ok := iuo.mutation.CreatedAt(); ok {
		_spec.SetField(item.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := iuo.mutation.UpdatedAt(); ok {
		_spec.SetField(item.FieldUpdatedAt, field.TypeTime, value)
	}
	if iuo.mutation.FeedCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   item.FeedTable,
			Columns: []string{item.FeedColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(feed.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iuo.mutation.FeedIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   item.FeedTable,
			Columns: []string{item.FeedColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(feed.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if iuo.mutation.ReadByUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   item.ReadByUsersTable,
			Columns: item.ReadByUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		createE := &ReadCreate{config: iuo.config, mutation: newReadMutation(iuo.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iuo.mutation.RemovedReadByUsersIDs(); len(nodes) > 0 && !iuo.mutation.ReadByUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   item.ReadByUsersTable,
			Columns: item.ReadByUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &ReadCreate{config: iuo.config, mutation: newReadMutation(iuo.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iuo.mutation.ReadByUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   item.ReadByUsersTable,
			Columns: item.ReadByUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &ReadCreate{config: iuo.config, mutation: newReadMutation(iuo.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if iuo.mutation.ReadsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   item.ReadsTable,
			Columns: []string{item.ReadsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iuo.mutation.RemovedReadsIDs(); len(nodes) > 0 && !iuo.mutation.ReadsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   item.ReadsTable,
			Columns: []string{item.ReadsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := iuo.mutation.ReadsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   item.ReadsTable,
			Columns: []string{item.ReadsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Item{config: iuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, iuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{item.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	iuo.mutation.done = true
	return _node, nil
}
