// Copyright 2020 The OpenConfig Contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.6.1
// source: v1/proto/service/gribi.proto

package gribi

import (
	gribi_aft "github.com/openconfig/gribi/v1/proto/gribi_aft"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AFT describes the set of AFTs that are supported in the
// gRIBI protocol.
type AFTType int32

const (
	AFTType_INVALID           AFTType = 0
	AFTType_ALL               AFTType = 1
	AFTType_IPV4              AFTType = 2
	AFTType_IPV6              AFTType = 3
	AFTType_MPLS              AFTType = 4
	AFTType_NEXTHOP           AFTType = 5
	AFTType_NEXTHOP_GROUP     AFTType = 6
	AFTType_MAC               AFTType = 7
	AFTType_POLICY_FORWARDING AFTType = 8
)

// Enum value maps for AFTType.
var (
	AFTType_name = map[int32]string{
		0: "INVALID",
		1: "ALL",
		2: "IPV4",
		3: "IPV6",
		4: "MPLS",
		5: "NEXTHOP",
		6: "NEXTHOP_GROUP",
		7: "MAC",
		8: "POLICY_FORWARDING",
	}
	AFTType_value = map[string]int32{
		"INVALID":           0,
		"ALL":               1,
		"IPV4":              2,
		"IPV6":              3,
		"MPLS":              4,
		"NEXTHOP":           5,
		"NEXTHOP_GROUP":     6,
		"MAC":               7,
		"POLICY_FORWARDING": 8,
	}
)

func (x AFTType) Enum() *AFTType {
	p := new(AFTType)
	*p = x
	return p
}

func (x AFTType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AFTType) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_proto_service_gribi_proto_enumTypes[0].Descriptor()
}

func (AFTType) Type() protoreflect.EnumType {
	return &file_v1_proto_service_gribi_proto_enumTypes[0]
}

func (x AFTType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AFTType.Descriptor instead.
func (AFTType) EnumDescriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{0}
}

// The operation that this request is - either add, replace, or delete
// any entry from the specific AFT.
type AFTOperation_Operation int32

const (
	// INVALID indicates that the sender did not set the operation, and
	// should be considered an error.
	AFTOperation_INVALID AFTOperation_Operation = 0
	// ADD creates an entry within the table. If the entry already exists
	// within the specified table, the ADD should be treated as replacing
	// the existing entry with the entry specified in the operation.
	AFTOperation_ADD AFTOperation_Operation = 1
	// REPLACE replaces an existing entry within a table, it should fail if
	// the entry does not exist. A replace operation should contain all of
	// the relevant fields, such that existing entry is completely replaced
	// with the specified entry.
	AFTOperation_REPLACE AFTOperation_Operation = 2
	// DELETE removes an entry from the table, it should fail if the entry
	// does not exist.
	AFTOperation_DELETE AFTOperation_Operation = 3
)

// Enum value maps for AFTOperation_Operation.
var (
	AFTOperation_Operation_name = map[int32]string{
		0: "INVALID",
		1: "ADD",
		2: "REPLACE",
		3: "DELETE",
	}
	AFTOperation_Operation_value = map[string]int32{
		"INVALID": 0,
		"ADD":     1,
		"REPLACE": 2,
		"DELETE":  3,
	}
)

func (x AFTOperation_Operation) Enum() *AFTOperation_Operation {
	p := new(AFTOperation_Operation)
	*p = x
	return p
}

func (x AFTOperation_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AFTOperation_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_proto_service_gribi_proto_enumTypes[1].Descriptor()
}

func (AFTOperation_Operation) Type() protoreflect.EnumType {
	return &file_v1_proto_service_gribi_proto_enumTypes[1]
}

func (x AFTOperation_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AFTOperation_Operation.Descriptor instead.
func (AFTOperation_Operation) EnumDescriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{1, 0}
}

// Status of the operation. Since this is within a
// stream we do not use status.proto to respond since
// this would fail the entire RPC connection, and hence
// have in-band errors.
type AFTResult_Status int32

const (
	AFTResult_UNSET AFTResult_Status = 0
	// Deprecate the OK status for a modify operation since
	// there are likely to be more different cases that we
	// want to use here - e.g., RIB_PROGRAMMED and FIB_PROGRAMMED.
	//
	// Deprecated: Do not use.
	AFTResult_OK     AFTResult_Status = 1
	AFTResult_FAILED AFTResult_Status = 2
	// RIB programmed indicates that the received operation was
	// syntactically valid, and was programmed successfully into
	// the RIB.
	AFTResult_RIB_PROGRAMMED AFTResult_Status = 3
	// FIB_PROGRAMMED indicates that the received operation was
	// successfully programmed into the FIB. "Programmed into the FIB" is
	// defined as the forwarding entry being operational in the underlying
	// forwarding resources across the system that it is relevant to (e.g.,
	// all linecards that host a particular VRF etc). This notification may
	// not always be sent for a particular operation since:
	//
	//  a) the entry may be duplicate for another gRIBI client.
	//  b) the entry may not be the preferred system route (e.g., there
	//     may be a higher-preference RIB client that has a matching
	//     entry, and hence the FIB is unchanged).
	//
	// In cases where the FIB was meant to be programmed, but an error
	// code was received from the underlying hardware abstraction layer
	// the FAILED error code is returned.
	AFTResult_FIB_PROGRAMMED AFTResult_Status = 4
)

// Enum value maps for AFTResult_Status.
var (
	AFTResult_Status_name = map[int32]string{
		0: "UNSET",
		1: "OK",
		2: "FAILED",
		3: "RIB_PROGRAMMED",
		4: "FIB_PROGRAMMED",
	}
	AFTResult_Status_value = map[string]int32{
		"UNSET":          0,
		"OK":             1,
		"FAILED":         2,
		"RIB_PROGRAMMED": 3,
		"FIB_PROGRAMMED": 4,
	}
)

func (x AFTResult_Status) Enum() *AFTResult_Status {
	p := new(AFTResult_Status)
	*p = x
	return p
}

func (x AFTResult_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AFTResult_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_proto_service_gribi_proto_enumTypes[2].Descriptor()
}

func (AFTResult_Status) Type() protoreflect.EnumType {
	return &file_v1_proto_service_gribi_proto_enumTypes[2]
}

func (x AFTResult_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AFTResult_Status.Descriptor instead.
func (AFTResult_Status) EnumDescriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{3, 0}
}

type ModifyRPCErrorDetails_Reason int32

const (
	// Error with an unknown cause.
	ModifyRPCErrorDetails_UNKNOWN ModifyRPCErrorDetails_Reason = 0
	// The network element cannot support the
	// aft_persistence or aft_result_status_type
	// requested in session parameters in ModifyRequest
	// If the client didn't send any session parameters, then
	// the network element doesn't support the default values.
	ModifyRPCErrorDetails_UNSUPPORTED_PARAMS ModifyRPCErrorDetails_Reason = 1
	// A session_parameters message in a ModifyRequest was received with
	// aft_persistence or aft_result_status_type more
	// than once; or was received after one or more AFTOperations
	// was issued.
	ModifyRPCErrorDetails_MODIFY_NOT_ALLOWED ModifyRPCErrorDetails_Reason = 2
	// The attribute values of atleast one session parameter
	// received in the ModifyRequest differs from the values received
	// from existing clients
	ModifyRPCErrorDetails_PARAMS_DIFFER_FROM_OTHER_CLIENTS ModifyRPCErrorDetails_Reason = 3
	// election_id in a ModifyRequest is not supported in ALL_PRIMARY
	// redundancy mode.
	ModifyRPCErrorDetails_ELECTION_ID_IN_ALL_PRIMARY ModifyRPCErrorDetails_Reason = 4
)

// Enum value maps for ModifyRPCErrorDetails_Reason.
var (
	ModifyRPCErrorDetails_Reason_name = map[int32]string{
		0: "UNKNOWN",
		1: "UNSUPPORTED_PARAMS",
		2: "MODIFY_NOT_ALLOWED",
		3: "PARAMS_DIFFER_FROM_OTHER_CLIENTS",
		4: "ELECTION_ID_IN_ALL_PRIMARY",
	}
	ModifyRPCErrorDetails_Reason_value = map[string]int32{
		"UNKNOWN":                          0,
		"UNSUPPORTED_PARAMS":               1,
		"MODIFY_NOT_ALLOWED":               2,
		"PARAMS_DIFFER_FROM_OTHER_CLIENTS": 3,
		"ELECTION_ID_IN_ALL_PRIMARY":       4,
	}
)

func (x ModifyRPCErrorDetails_Reason) Enum() *ModifyRPCErrorDetails_Reason {
	p := new(ModifyRPCErrorDetails_Reason)
	*p = x
	return p
}

func (x ModifyRPCErrorDetails_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModifyRPCErrorDetails_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_proto_service_gribi_proto_enumTypes[3].Descriptor()
}

func (ModifyRPCErrorDetails_Reason) Type() protoreflect.EnumType {
	return &file_v1_proto_service_gribi_proto_enumTypes[3]
}

func (x ModifyRPCErrorDetails_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModifyRPCErrorDetails_Reason.Descriptor instead.
func (ModifyRPCErrorDetails_Reason) EnumDescriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{4, 0}
}

type SessionParametersResult_Status int32

const (
	// No errors, network element supports requested
	// parameters
	SessionParametersResult_OK SessionParametersResult_Status = 0
)

// Enum value maps for SessionParametersResult_Status.
var (
	SessionParametersResult_Status_name = map[int32]string{
		0: "OK",
	}
	SessionParametersResult_Status_value = map[string]int32{
		"OK": 0,
	}
)

func (x SessionParametersResult_Status) Enum() *SessionParametersResult_Status {
	p := new(SessionParametersResult_Status)
	*p = x
	return p
}

func (x SessionParametersResult_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionParametersResult_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_proto_service_gribi_proto_enumTypes[4].Descriptor()
}

func (SessionParametersResult_Status) Type() protoreflect.EnumType {
	return &file_v1_proto_service_gribi_proto_enumTypes[4]
}

func (x SessionParametersResult_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionParametersResult_Status.Descriptor instead.
func (SessionParametersResult_Status) EnumDescriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{5, 0}
}

// The type of redundancy amongst the external entities
type SessionParameters_ClientRedundancy int32

const (
	// Accept AFTOperations from all clients. The network element assumes
	// that all clients convey the same AFT state. The network element
	// uses "add on first ADD operation and delete on last DELETE operation
	// semantics, ie., it Adds an AFT entry to its gRIBI state when the
	// network element receives the first ADD AFTOperation from any client;
	// and the AFT entry is deleted from the network element's gRIBI state
	// when the network element has processed DELETE for the AFT entry
	// from all clients that issued an ADD for that AFT entry.
	// In other words, the AFT entries are reference counted, where
	// the reference count is the number of clients that have issued
	// ADD AFTOperation for that AFT entry.
	// REPLACE AFTOperations from all clients are processed for any
	// AFT entries.
	SessionParameters_ALL_PRIMARY SessionParameters_ClientRedundancy = 0
	// Clients take part in an election process that leads to
	// a single client becoming the primary client. The
	// primary client has the highest election ID. The network element
	// accepts AFTOperations from the primary client only.
	SessionParameters_SINGLE_PRIMARY SessionParameters_ClientRedundancy = 1
)

// Enum value maps for SessionParameters_ClientRedundancy.
var (
	SessionParameters_ClientRedundancy_name = map[int32]string{
		0: "ALL_PRIMARY",
		1: "SINGLE_PRIMARY",
	}
	SessionParameters_ClientRedundancy_value = map[string]int32{
		"ALL_PRIMARY":    0,
		"SINGLE_PRIMARY": 1,
	}
)

func (x SessionParameters_ClientRedundancy) Enum() *SessionParameters_ClientRedundancy {
	p := new(SessionParameters_ClientRedundancy)
	*p = x
	return p
}

func (x SessionParameters_ClientRedundancy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionParameters_ClientRedundancy) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_proto_service_gribi_proto_enumTypes[5].Descriptor()
}

func (SessionParameters_ClientRedundancy) Type() protoreflect.EnumType {
	return &file_v1_proto_service_gribi_proto_enumTypes[5]
}

func (x SessionParameters_ClientRedundancy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionParameters_ClientRedundancy.Descriptor instead.
func (SessionParameters_ClientRedundancy) EnumDescriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{7, 0}
}

// The desired behavior when a client disconnects from
// the network element.
type SessionParameters_AFTPersistence int32

const (
	// When a client disconnects, the network element deletes
	// all AFT entries received from that client.
	SessionParameters_DELETE SessionParameters_AFTPersistence = 0
	// When the primary client disconects, the network element
	// preserves the gRIBI process' RIB, system RIB and system
	// FIB.
	// When a non primary client disconnects, there's no action
	// required as all network element state is conveyed by the
	// primary client
	SessionParameters_PRESERVE SessionParameters_AFTPersistence = 1
)

// Enum value maps for SessionParameters_AFTPersistence.
var (
	SessionParameters_AFTPersistence_name = map[int32]string{
		0: "DELETE",
		1: "PRESERVE",
	}
	SessionParameters_AFTPersistence_value = map[string]int32{
		"DELETE":   0,
		"PRESERVE": 1,
	}
)

func (x SessionParameters_AFTPersistence) Enum() *SessionParameters_AFTPersistence {
	p := new(SessionParameters_AFTPersistence)
	*p = x
	return p
}

func (x SessionParameters_AFTPersistence) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionParameters_AFTPersistence) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_proto_service_gribi_proto_enumTypes[6].Descriptor()
}

func (SessionParameters_AFTPersistence) Type() protoreflect.EnumType {
	return &file_v1_proto_service_gribi_proto_enumTypes[6]
}

func (x SessionParameters_AFTPersistence) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionParameters_AFTPersistence.Descriptor instead.
func (SessionParameters_AFTPersistence) EnumDescriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{7, 1}
}

// The type of response that the client expects from the
// network element in AFTResult.status
type SessionParameters_AFTResultStatusType int32

const (
	// network element must respond with RIB_PROGRAMMED
	// on a successful update to the gRIBI process' RIB.
	SessionParameters_RIB_ACK SessionParameters_AFTResultStatusType = 0
	// network element must respond with RIB_PROGRAMMED
	// on a successful update to the gRIBI process' RIB.
	// If the AFT entry is also programmed in the network
	// element's FIB, a FIB_PROGRAMMED response must be sent
	// A FIB_PROGRAMMED response is a combined
	// acknowledgement that the AFT entry is programmed in
	// the gRIBI process' RIB and the FIB, so there's no need
	// to send both RIB_PROGRAMMED and FIB_PROGRAMMED when
	// the AFT entry is programmed in the FIB.
	SessionParameters_RIB_AND_FIB_ACK SessionParameters_AFTResultStatusType = 1
)

// Enum value maps for SessionParameters_AFTResultStatusType.
var (
	SessionParameters_AFTResultStatusType_name = map[int32]string{
		0: "RIB_ACK",
		1: "RIB_AND_FIB_ACK",
	}
	SessionParameters_AFTResultStatusType_value = map[string]int32{
		"RIB_ACK":         0,
		"RIB_AND_FIB_ACK": 1,
	}
)

func (x SessionParameters_AFTResultStatusType) Enum() *SessionParameters_AFTResultStatusType {
	p := new(SessionParameters_AFTResultStatusType)
	*p = x
	return p
}

func (x SessionParameters_AFTResultStatusType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionParameters_AFTResultStatusType) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_proto_service_gribi_proto_enumTypes[7].Descriptor()
}

func (SessionParameters_AFTResultStatusType) Type() protoreflect.EnumType {
	return &file_v1_proto_service_gribi_proto_enumTypes[7]
}

func (x SessionParameters_AFTResultStatusType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionParameters_AFTResultStatusType.Descriptor instead.
func (SessionParameters_AFTResultStatusType) EnumDescriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{7, 2}
}

// ModifyRequest is a message used by the client to manipulate the state of
// the RIB on the target device.
type ModifyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A group of requests to add/modify/remove a single AFT entry
	Operation []*AFTOperation `protobuf:"bytes,1,rep,name=operation,proto3" json:"operation,omitempty"`
	// Meta information that the external entity sends to the network
	// element. If a non default set of parameters is required, then
	// `params` MUST be sent by the external entity before
	// it sends the network element any AFTOperations.
	// It's possible that the default set of parameters isn't supported
	// by a network element. In such a case, if the client hasn't sent
	// any session parameters, then the network element closes the Modify RPC
	// stream when the first AFTOperation is received in a ModifyRequest and
	// sets status.code
	// (http://tinyurl.com/grpc-status-proto)
	// to `UNIMPLEMENTED` and reason to `UNSUPPORTED_PARAMS`
	// in ModifyRPCErrorDetails. ModifyRPCErrorDetails is filled in
	// status.details.
	//
	// `params` MUST be sent only once during the lifetime of the session.
	// All clients programming a network element's RIB,
	// MUST send the same values of all the attributes of `params`
	//
	// The network element responds with session_params_result.status = OK in
	// ModifyResponse if it processed `params` without any error.
	//
	// The network element does not respond with session_params_result if
	// there's an error while processing `params`, instead it disconnects
	// the session and sets the RPC error code based on status.proto
	// (http://tinyurl.com/grpc-status-proto)
	// status.code is set to
	//  - UNIMPLEMENTED when it encounters an unsupported `persistence`
	//    or `ack_type`
	//  - FAILED_PRECONDITION for the other cases
	// status.details is filled with the ModifyRPCErrorDetails message with
	// an appropriate `reason`.
	//
	// If the client does not send session_parameters, then the network element
	// assumes the following defaults:
	//   - ALL_PRIMARY for client redundancy
	//   - A client disconnect is treated as if the client issued DELETE
	//     AFTOperation for all the AFT entries that client ADDed.
	//   - Each AFTOperation is acknowledged with OK or FAILED in
	//     in the AFTResult of the ModifyResponse.
	Params *SessionParameters `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// election_id is used by the network element to
	// select a primary client when the client redundancy mode
	// is SINGLE_PRIMARY.
	// A client sends a ModifyRequest with only the election_id
	// field populated after it connects to the network element,
	// and everytime its election_id is updated(usually as a
	// result of an election amongst clients). The network element
	// responds with a ModifyResponse that has only the election_id
	// field populated. The election_id in the ModifyResponse is the
	// highest election_id that the network element has learnt
	// from any client.
	// The network element selects the client with the highest
	// election_id as the primary.
	// Only AFT operations from the primary client are acted upon by
	// the network element. AFT operations from non-primary clients
	// are discarded.
	// If the client redundancy mode is ALL_PRIMARY, but a client
	// sends election_id, the network element closes the connection
	// to the client and responds with FAILED_PRECONDITION in
	// status.proto's `code` and sets ModifyRPCErrorDetails.reason
	// to ELECTION_ID_IN_ALL_PRIMARY
	ElectionId *Uint128 `protobuf:"bytes,3,opt,name=election_id,json=electionId,proto3" json:"election_id,omitempty"`
}

func (x *ModifyRequest) Reset() {
	*x = ModifyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyRequest) ProtoMessage() {}

func (x *ModifyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyRequest.ProtoReflect.Descriptor instead.
func (*ModifyRequest) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{0}
}

func (x *ModifyRequest) GetOperation() []*AFTOperation {
	if x != nil {
		return x.Operation
	}
	return nil
}

func (x *ModifyRequest) GetParams() *SessionParameters {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ModifyRequest) GetElectionId() *Uint128 {
	if x != nil {
		return x.ElectionId
	}
	return nil
}

// A single request to add/modify/remove a single AFT entry
type AFTOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Associate an ID with this specific request since this allows the client
	// to determine exactly which modifications have been completed in the
	// case that are multiple operations within the AFT.
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Network Instance (aka vrf aka routing-instance) to apply to
	NetworkInstance string                 `protobuf:"bytes,2,opt,name=network_instance,json=networkInstance,proto3" json:"network_instance,omitempty"`
	Op              AFTOperation_Operation `protobuf:"varint,3,opt,name=op,proto3,enum=gribi.AFTOperation_Operation" json:"op,omitempty"`
	// Types that are assignable to Entry:
	//	*AFTOperation_Ipv4
	//	*AFTOperation_Ipv6
	//	*AFTOperation_Mpls
	//	*AFTOperation_NextHopGroup
	//	*AFTOperation_NextHop
	//	*AFTOperation_MacEntry
	//	*AFTOperation_PolicyForwardingEntry
	Entry isAFTOperation_Entry `protobuf_oneof:"entry"`
	// Election ID of the client.
	// In SINGLE_PRIMARY redundancy model, used by the server to determine
	// whether to process the AFTOperation.
	// The server processes the AFTOperation if
	// 1. the election_id in the AFTOperation is equal to the election_id last
	//    advertised in a ModifyRequest by the client
	//    AND
	// 2. the election_id in the AFTOperation is the highest election_id
	//    amongst all the election IDs that the server knows about, ie.
	//    the client is the primary client
	// If the election_id in the AFTOperation does not meet these criteria
	// the server discards the AFTOperation and returns FAILED in AFTResult
	ElectionId *Uint128 `protobuf:"bytes,11,opt,name=election_id,json=electionId,proto3" json:"election_id,omitempty"`
}

func (x *AFTOperation) Reset() {
	*x = AFTOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AFTOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AFTOperation) ProtoMessage() {}

func (x *AFTOperation) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AFTOperation.ProtoReflect.Descriptor instead.
func (*AFTOperation) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{1}
}

func (x *AFTOperation) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *AFTOperation) GetNetworkInstance() string {
	if x != nil {
		return x.NetworkInstance
	}
	return ""
}

func (x *AFTOperation) GetOp() AFTOperation_Operation {
	if x != nil {
		return x.Op
	}
	return AFTOperation_INVALID
}

func (m *AFTOperation) GetEntry() isAFTOperation_Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (x *AFTOperation) GetIpv4() *gribi_aft.Afts_Ipv4EntryKey {
	if x, ok := x.GetEntry().(*AFTOperation_Ipv4); ok {
		return x.Ipv4
	}
	return nil
}

func (x *AFTOperation) GetIpv6() *gribi_aft.Afts_Ipv6EntryKey {
	if x, ok := x.GetEntry().(*AFTOperation_Ipv6); ok {
		return x.Ipv6
	}
	return nil
}

func (x *AFTOperation) GetMpls() *gribi_aft.Afts_LabelEntryKey {
	if x, ok := x.GetEntry().(*AFTOperation_Mpls); ok {
		return x.Mpls
	}
	return nil
}

func (x *AFTOperation) GetNextHopGroup() *gribi_aft.Afts_NextHopGroupKey {
	if x, ok := x.GetEntry().(*AFTOperation_NextHopGroup); ok {
		return x.NextHopGroup
	}
	return nil
}

func (x *AFTOperation) GetNextHop() *gribi_aft.Afts_NextHopKey {
	if x, ok := x.GetEntry().(*AFTOperation_NextHop); ok {
		return x.NextHop
	}
	return nil
}

func (x *AFTOperation) GetMacEntry() *gribi_aft.Afts_MacEntryKey {
	if x, ok := x.GetEntry().(*AFTOperation_MacEntry); ok {
		return x.MacEntry
	}
	return nil
}

func (x *AFTOperation) GetPolicyForwardingEntry() *gribi_aft.Afts_PolicyForwardingEntryKey {
	if x, ok := x.GetEntry().(*AFTOperation_PolicyForwardingEntry); ok {
		return x.PolicyForwardingEntry
	}
	return nil
}

func (x *AFTOperation) GetElectionId() *Uint128 {
	if x != nil {
		return x.ElectionId
	}
	return nil
}

type isAFTOperation_Entry interface {
	isAFTOperation_Entry()
}

type AFTOperation_Ipv4 struct {
	// Each openconfig.AFT.* message is a protobuf transformed
	// message corresponding to the OpenConfig AFT for that
	// schema.
	// Schema for IPv4UnicastEntry is generated from
	// /network-instances/network-instance/afts/ipv4-unicast/ipv4-entry
	Ipv4 *gribi_aft.Afts_Ipv4EntryKey `protobuf:"bytes,4,opt,name=ipv4,proto3,oneof"`
}

type AFTOperation_Ipv6 struct {
	// Schema for IPv6UnicastEntry is generated from
	// /network-instances/network-instance/afts/ipv6-unicast/ipv6-entry
	Ipv6 *gribi_aft.Afts_Ipv6EntryKey `protobuf:"bytes,5,opt,name=ipv6,proto3,oneof"`
}

type AFTOperation_Mpls struct {
	// Schema for MPLSLabelEntry is generated from
	// /network-instances/network-instance/afts/mpls/label-entry
	Mpls *gribi_aft.Afts_LabelEntryKey `protobuf:"bytes,6,opt,name=mpls,proto3,oneof"`
}

type AFTOperation_NextHopGroup struct {
	// Schema for NextHopGroup is generated from
	// /network-instances/network-instance/afts/next-hop-groups/next-hop-group
	NextHopGroup *gribi_aft.Afts_NextHopGroupKey `protobuf:"bytes,7,opt,name=next_hop_group,json=nextHopGroup,proto3,oneof"`
}

type AFTOperation_NextHop struct {
	// Schema for NextHop is generated from
	// /network-instances/network-instance/afts/next-hops/next-hop.
	NextHop *gribi_aft.Afts_NextHopKey `protobuf:"bytes,8,opt,name=next_hop,json=nextHop,proto3,oneof"`
}

type AFTOperation_MacEntry struct {
	// Schema for MacEntry is generated from
	// /network-instances/network-instance/afts/ethernet/mac-entry
	MacEntry *gribi_aft.Afts_MacEntryKey `protobuf:"bytes,9,opt,name=mac_entry,json=macEntry,proto3,oneof"`
}

type AFTOperation_PolicyForwardingEntry struct {
	// Schema for PolicyForwardingGroup is generated from
	// /network-instances/network-instance/afts/policy-forwarding/
	// policy-forwarding-entry
	PolicyForwardingEntry *gribi_aft.Afts_PolicyForwardingEntryKey `protobuf:"bytes,10,opt,name=policy_forwarding_entry,json=policyForwardingEntry,proto3,oneof"`
}

func (*AFTOperation_Ipv4) isAFTOperation_Entry() {}

func (*AFTOperation_Ipv6) isAFTOperation_Entry() {}

func (*AFTOperation_Mpls) isAFTOperation_Entry() {}

func (*AFTOperation_NextHopGroup) isAFTOperation_Entry() {}

func (*AFTOperation_NextHop) isAFTOperation_Entry() {}

func (*AFTOperation_MacEntry) isAFTOperation_Entry() {}

func (*AFTOperation_PolicyForwardingEntry) isAFTOperation_Entry() {}

// A set of AFT responses.
type ModifyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One or more responses to requests. Clients should expect that
	// the ModifyResponse *does not* correlate to the ModifyRequest’s
	// contents.
	Result []*AFTResult `protobuf:"bytes,1,rep,name=result,proto3" json:"result,omitempty"`
	// Response to the session_parameters in a ModifyRequest
	// when there are no errors.
	// If there's an error then ModifyRPCErrorDetails is filled
	// in status.proto's `details` attribute.
	SessionParamsResult *SessionParametersResult `protobuf:"bytes,2,opt,name=session_params_result,json=sessionParamsResult,proto3" json:"session_params_result,omitempty"`
	// Response to a ModifyRequest that contains only the election_id field.
	// The network element sends a ModifyResponse with only the election_id
	// populated. The value populated is the highest election_id that the
	// network element has learnt from any client.
	ElectionId *Uint128 `protobuf:"bytes,3,opt,name=election_id,json=electionId,proto3" json:"election_id,omitempty"`
}

func (x *ModifyResponse) Reset() {
	*x = ModifyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyResponse) ProtoMessage() {}

func (x *ModifyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyResponse.ProtoReflect.Descriptor instead.
func (*ModifyResponse) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{2}
}

func (x *ModifyResponse) GetResult() []*AFTResult {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *ModifyResponse) GetSessionParamsResult() *SessionParametersResult {
	if x != nil {
		return x.SessionParamsResult
	}
	return nil
}

func (x *ModifyResponse) GetElectionId() *Uint128 {
	if x != nil {
		return x.ElectionId
	}
	return nil
}

// A response to add/modify/remove a single AFT entry
type AFTResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID corresponds to the operation ID that was
	// specified in the AFTOperation.
	Id     uint64           `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Status AFTResult_Status `protobuf:"varint,2,opt,name=status,proto3,enum=gribi.AFTResult_Status" json:"status,omitempty"`
}

func (x *AFTResult) Reset() {
	*x = AFTResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AFTResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AFTResult) ProtoMessage() {}

func (x *AFTResult) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AFTResult.ProtoReflect.Descriptor instead.
func (*AFTResult) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{3}
}

func (x *AFTResult) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *AFTResult) GetStatus() AFTResult_Status {
	if x != nil {
		return x.Status
	}
	return AFTResult_UNSET
}

// Populated in `details` in status.proto when an error that causes the network
// element to close the stream.
type ModifyRPCErrorDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Reason ModifyRPCErrorDetails_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=gribi.ModifyRPCErrorDetails_Reason" json:"reason,omitempty"`
}

func (x *ModifyRPCErrorDetails) Reset() {
	*x = ModifyRPCErrorDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyRPCErrorDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyRPCErrorDetails) ProtoMessage() {}

func (x *ModifyRPCErrorDetails) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyRPCErrorDetails.ProtoReflect.Descriptor instead.
func (*ModifyRPCErrorDetails) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{4}
}

func (x *ModifyRPCErrorDetails) GetReason() ModifyRPCErrorDetails_Reason {
	if x != nil {
		return x.Reason
	}
	return ModifyRPCErrorDetails_UNKNOWN
}

// Response when ModifyRequest.params is syntactically valid and all
// requested parameters are supported by the network element.
type SessionParametersResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status SessionParametersResult_Status `protobuf:"varint,1,opt,name=status,proto3,enum=gribi.SessionParametersResult_Status" json:"status,omitempty"`
}

func (x *SessionParametersResult) Reset() {
	*x = SessionParametersResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionParametersResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionParametersResult) ProtoMessage() {}

func (x *SessionParametersResult) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionParametersResult.ProtoReflect.Descriptor instead.
func (*SessionParametersResult) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{5}
}

func (x *SessionParametersResult) GetStatus() SessionParametersResult_Status {
	if x != nil {
		return x.Status
	}
	return SessionParametersResult_OK
}

type Uint128 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	High uint64 `protobuf:"varint,1,opt,name=high,proto3" json:"high,omitempty"`
	Low  uint64 `protobuf:"varint,2,opt,name=low,proto3" json:"low,omitempty"`
}

func (x *Uint128) Reset() {
	*x = Uint128{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Uint128) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Uint128) ProtoMessage() {}

func (x *Uint128) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Uint128.ProtoReflect.Descriptor instead.
func (*Uint128) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{6}
}

func (x *Uint128) GetHigh() uint64 {
	if x != nil {
		return x.High
	}
	return 0
}

func (x *Uint128) GetLow() uint64 {
	if x != nil {
		return x.Low
	}
	return 0
}

type SessionParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Redundancy  SessionParameters_ClientRedundancy    `protobuf:"varint,1,opt,name=redundancy,proto3,enum=gribi.SessionParameters_ClientRedundancy" json:"redundancy,omitempty"`
	Persistence SessionParameters_AFTPersistence      `protobuf:"varint,2,opt,name=persistence,proto3,enum=gribi.SessionParameters_AFTPersistence" json:"persistence,omitempty"`
	AckType     SessionParameters_AFTResultStatusType `protobuf:"varint,3,opt,name=ack_type,json=ackType,proto3,enum=gribi.SessionParameters_AFTResultStatusType" json:"ack_type,omitempty"`
}

func (x *SessionParameters) Reset() {
	*x = SessionParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionParameters) ProtoMessage() {}

func (x *SessionParameters) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionParameters.ProtoReflect.Descriptor instead.
func (*SessionParameters) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{7}
}

func (x *SessionParameters) GetRedundancy() SessionParameters_ClientRedundancy {
	if x != nil {
		return x.Redundancy
	}
	return SessionParameters_ALL_PRIMARY
}

func (x *SessionParameters) GetPersistence() SessionParameters_AFTPersistence {
	if x != nil {
		return x.Persistence
	}
	return SessionParameters_DELETE
}

func (x *SessionParameters) GetAckType() SessionParameters_AFTResultStatusType {
	if x != nil {
		return x.AckType
	}
	return SessionParameters_RIB_ACK
}

// Empty is a specific message that is used as a marker where
// presence of a non-nil value indicates a particular function.
type Empty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Empty) Reset() {
	*x = Empty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Empty) ProtoMessage() {}

func (x *Empty) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Empty.ProtoReflect.Descriptor instead.
func (*Empty) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{8}
}

type GetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to NetworkInstance:
	//	*GetRequest_Name
	//	*GetRequest_All
	NetworkInstance isGetRequest_NetworkInstance `protobuf_oneof:"network_instance"`
	// The AFT for which entries should be retrieved. If the AFT is
	// invalid, the server should respond with the INVALID_ARGUMENT
	// error code. If the AFT is unsupported, it should respond with
	// UNSUPPORTED in the status.proto carried along with the RPC
	// response.
	Aft AFTType `protobuf:"varint,3,opt,name=aft,proto3,enum=gribi.AFTType" json:"aft,omitempty"`
}

func (x *GetRequest) Reset() {
	*x = GetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRequest) ProtoMessage() {}

func (x *GetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRequest.ProtoReflect.Descriptor instead.
func (*GetRequest) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{9}
}

func (m *GetRequest) GetNetworkInstance() isGetRequest_NetworkInstance {
	if m != nil {
		return m.NetworkInstance
	}
	return nil
}

func (x *GetRequest) GetName() string {
	if x, ok := x.GetNetworkInstance().(*GetRequest_Name); ok {
		return x.Name
	}
	return ""
}

func (x *GetRequest) GetAll() *Empty {
	if x, ok := x.GetNetworkInstance().(*GetRequest_All); ok {
		return x.All
	}
	return nil
}

func (x *GetRequest) GetAft() AFTType {
	if x != nil {
		return x.Aft
	}
	return AFTType_INVALID
}

type isGetRequest_NetworkInstance interface {
	isGetRequest_NetworkInstance()
}

type GetRequest_Name struct {
	// The network instance from which the entries should be retrieved.
	// If name is specified the empty string "" is considered invalid.
	Name string `protobuf:"bytes,1,opt,name=name,proto3,oneof"`
}

type GetRequest_All struct {
	// all indicates that entries for all network instances for the
	// specified network instance should be returned.
	All *Empty `protobuf:"bytes,2,opt,name=all,proto3,oneof"`
}

func (*GetRequest_Name) isGetRequest_NetworkInstance() {}

func (*GetRequest_All) isGetRequest_NetworkInstance() {}

// An individual AFTEntry that is installed on the device.
type AFTEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The network_instance for which the response is being returned.
	NetworkInstance string `protobuf:"bytes,1,opt,name=network_instance,json=networkInstance,proto3" json:"network_instance,omitempty"`
	// Types that are assignable to Entry:
	//	*AFTEntry_Ipv4
	//	*AFTEntry_Ipv6
	//	*AFTEntry_Mpls
	//	*AFTEntry_NextHopGroup
	//	*AFTEntry_NextHop
	//	*AFTEntry_MacEntry
	//	*AFTEntry_PolicyForwardingEntry
	Entry isAFTEntry_Entry `protobuf_oneof:"entry"`
}

func (x *AFTEntry) Reset() {
	*x = AFTEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AFTEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AFTEntry) ProtoMessage() {}

func (x *AFTEntry) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AFTEntry.ProtoReflect.Descriptor instead.
func (*AFTEntry) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{10}
}

func (x *AFTEntry) GetNetworkInstance() string {
	if x != nil {
		return x.NetworkInstance
	}
	return ""
}

func (m *AFTEntry) GetEntry() isAFTEntry_Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (x *AFTEntry) GetIpv4() *gribi_aft.Afts_Ipv4EntryKey {
	if x, ok := x.GetEntry().(*AFTEntry_Ipv4); ok {
		return x.Ipv4
	}
	return nil
}

func (x *AFTEntry) GetIpv6() *gribi_aft.Afts_Ipv6EntryKey {
	if x, ok := x.GetEntry().(*AFTEntry_Ipv6); ok {
		return x.Ipv6
	}
	return nil
}

func (x *AFTEntry) GetMpls() *gribi_aft.Afts_LabelEntryKey {
	if x, ok := x.GetEntry().(*AFTEntry_Mpls); ok {
		return x.Mpls
	}
	return nil
}

func (x *AFTEntry) GetNextHopGroup() *gribi_aft.Afts_NextHopGroupKey {
	if x, ok := x.GetEntry().(*AFTEntry_NextHopGroup); ok {
		return x.NextHopGroup
	}
	return nil
}

func (x *AFTEntry) GetNextHop() *gribi_aft.Afts_NextHopKey {
	if x, ok := x.GetEntry().(*AFTEntry_NextHop); ok {
		return x.NextHop
	}
	return nil
}

func (x *AFTEntry) GetMacEntry() *gribi_aft.Afts_MacEntryKey {
	if x, ok := x.GetEntry().(*AFTEntry_MacEntry); ok {
		return x.MacEntry
	}
	return nil
}

func (x *AFTEntry) GetPolicyForwardingEntry() *gribi_aft.Afts_PolicyForwardingEntryKey {
	if x, ok := x.GetEntry().(*AFTEntry_PolicyForwardingEntry); ok {
		return x.PolicyForwardingEntry
	}
	return nil
}

type isAFTEntry_Entry interface {
	isAFTEntry_Entry()
}

type AFTEntry_Ipv4 struct {
	// Each openconfig.AFT.* message is a protobuf transformed
	// message corresponding to the OpenConfig AFT for that
	// schema. The auto-generated paths can be found in the definition
	// of the AFTOperation.
	Ipv4 *gribi_aft.Afts_Ipv4EntryKey `protobuf:"bytes,4,opt,name=ipv4,proto3,oneof"`
}

type AFTEntry_Ipv6 struct {
	Ipv6 *gribi_aft.Afts_Ipv6EntryKey `protobuf:"bytes,5,opt,name=ipv6,proto3,oneof"`
}

type AFTEntry_Mpls struct {
	Mpls *gribi_aft.Afts_LabelEntryKey `protobuf:"bytes,6,opt,name=mpls,proto3,oneof"`
}

type AFTEntry_NextHopGroup struct {
	NextHopGroup *gribi_aft.Afts_NextHopGroupKey `protobuf:"bytes,7,opt,name=next_hop_group,json=nextHopGroup,proto3,oneof"`
}

type AFTEntry_NextHop struct {
	NextHop *gribi_aft.Afts_NextHopKey `protobuf:"bytes,8,opt,name=next_hop,json=nextHop,proto3,oneof"`
}

type AFTEntry_MacEntry struct {
	MacEntry *gribi_aft.Afts_MacEntryKey `protobuf:"bytes,9,opt,name=mac_entry,json=macEntry,proto3,oneof"`
}

type AFTEntry_PolicyForwardingEntry struct {
	PolicyForwardingEntry *gribi_aft.Afts_PolicyForwardingEntryKey `protobuf:"bytes,10,opt,name=policy_forwarding_entry,json=policyForwardingEntry,proto3,oneof"`
}

func (*AFTEntry_Ipv4) isAFTEntry_Entry() {}

func (*AFTEntry_Ipv6) isAFTEntry_Entry() {}

func (*AFTEntry_Mpls) isAFTEntry_Entry() {}

func (*AFTEntry_NextHopGroup) isAFTEntry_Entry() {}

func (*AFTEntry_NextHop) isAFTEntry_Entry() {}

func (*AFTEntry_MacEntry) isAFTEntry_Entry() {}

func (*AFTEntry_PolicyForwardingEntry) isAFTEntry_Entry() {}

type GetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of entries that are installed on the device.
	Entry []*AFTEntry `protobuf:"bytes,1,rep,name=entry,proto3" json:"entry,omitempty"`
}

func (x *GetResponse) Reset() {
	*x = GetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_v1_proto_service_gribi_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResponse) ProtoMessage() {}

func (x *GetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_v1_proto_service_gribi_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResponse.ProtoReflect.Descriptor instead.
func (*GetResponse) Descriptor() ([]byte, []int) {
	return file_v1_proto_service_gribi_proto_rawDescGZIP(), []int{11}
}

func (x *GetResponse) GetEntry() []*AFTEntry {
	if x != nil {
		return x.Entry
	}
	return nil
}

var File_v1_proto_service_gribi_proto protoreflect.FileDescriptor

var file_v1_proto_service_gribi_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2f, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05,
	0x67, 0x72, 0x69, 0x62, 0x69, 0x1a, 0x22, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2f, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f,
	0x61, 0x66, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x01, 0x0a, 0x0d, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x09, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x41, 0x46, 0x54, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x12, 0x2f, 0x0a, 0x0b, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x55, 0x69,
	0x6e, 0x74, 0x31, 0x32, 0x38, 0x52, 0x0a, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x22, 0xad, 0x05, 0x0a, 0x0c, 0x41, 0x46, 0x54, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2d, 0x0a,
	0x02, 0x6f, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67, 0x72, 0x69, 0x62,
	0x69, 0x2e, 0x41, 0x46, 0x54, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x32, 0x0a, 0x04,
	0x69, 0x70, 0x76, 0x34, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x72, 0x69,
	0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e, 0x49, 0x70, 0x76, 0x34,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x04, 0x69, 0x70, 0x76, 0x34,
	0x12, 0x32, 0x0a, 0x04, 0x69, 0x70, 0x76, 0x36, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e,
	0x49, 0x70, 0x76, 0x36, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x04,
	0x69, 0x70, 0x76, 0x36, 0x12, 0x33, 0x0a, 0x04, 0x6d, 0x70, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41,
	0x66, 0x74, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b, 0x65,
	0x79, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x70, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x0e, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66,
	0x74, 0x73, 0x2e, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b,
	0x65, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x37, 0x0a, 0x08, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74,
	0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x4b, 0x65, 0x79,
	0x48, 0x00, 0x52, 0x07, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x12, 0x3a, 0x0a, 0x09, 0x6d,
	0x61, 0x63, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e,
	0x4d, 0x61, 0x63, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x08, 0x6d,
	0x61, 0x63, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x62, 0x0a, 0x17, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69,
	0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b,
	0x65, 0x79, 0x48, 0x00, 0x52, 0x15, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2f, 0x0a, 0x0b, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0e, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x55, 0x69, 0x6e, 0x74, 0x31, 0x32, 0x38,
	0x52, 0x0a, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x3a, 0x0a, 0x09,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x44, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x22, 0xbf, 0x01, 0x0a, 0x0e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x41, 0x46, 0x54,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x52,
	0x0a, 0x15, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x13, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x2f, 0x0a, 0x0b, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e,
	0x55, 0x69, 0x6e, 0x74, 0x31, 0x32, 0x38, 0x52, 0x0a, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x22, 0xa1, 0x01, 0x0a, 0x09, 0x41, 0x46, 0x54, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x17, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x41, 0x46, 0x54, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0x53, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x09, 0x0a, 0x05,
	0x55, 0x4e, 0x53, 0x45, 0x54, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x01, 0x1a,
	0x02, 0x08, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x12, 0x0a, 0x0e, 0x52, 0x49, 0x42, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x41, 0x4d, 0x4d, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x49, 0x42, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52,
	0x41, 0x4d, 0x4d, 0x45, 0x44, 0x10, 0x04, 0x22, 0xe2, 0x01, 0x0a, 0x15, 0x4d, 0x6f, 0x64, 0x69,
	0x66, 0x79, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x3b, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x23, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x8b,
	0x01, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50,
	0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x53, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x59, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x4c, 0x4c,
	0x4f, 0x57, 0x45, 0x44, 0x10, 0x02, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x53,
	0x5f, 0x44, 0x49, 0x46, 0x46, 0x45, 0x52, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x4f, 0x54, 0x48,
	0x45, 0x52, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a,
	0x45, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x44, 0x5f, 0x49, 0x4e, 0x5f, 0x41,
	0x4c, 0x4c, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x04, 0x22, 0x6a, 0x0a, 0x17,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x10, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x00, 0x22, 0x2f, 0x0a, 0x07, 0x55, 0x69, 0x6e, 0x74,
	0x31, 0x32, 0x38, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x69, 0x67, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x04, 0x68, 0x69, 0x67, 0x68, 0x12, 0x10, 0x0a, 0x03, 0x6c, 0x6f, 0x77, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x6c, 0x6f, 0x77, 0x22, 0x90, 0x03, 0x0a, 0x11, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x49, 0x0a, 0x0a, 0x72, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x52, 0x0a,
	0x72, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x12, 0x49, 0x0a, 0x0b, 0x70, 0x65,
	0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x27, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x41, 0x46, 0x54, 0x50, 0x65, 0x72,
	0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x2e, 0x41, 0x46, 0x54, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x22, 0x37,
	0x0a, 0x10, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e,
	0x63, 0x79, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x4c, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52,
	0x59, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x50, 0x52,
	0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x22, 0x2a, 0x0a, 0x0e, 0x41, 0x46, 0x54, 0x50, 0x65,
	0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x45, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56,
	0x45, 0x10, 0x01, 0x22, 0x37, 0x0a, 0x13, 0x41, 0x46, 0x54, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x49,
	0x42, 0x5f, 0x41, 0x43, 0x4b, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x49, 0x42, 0x5f, 0x41,
	0x4e, 0x44, 0x5f, 0x46, 0x49, 0x42, 0x5f, 0x41, 0x43, 0x4b, 0x10, 0x01, 0x22, 0x07, 0x0a, 0x05,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x7a, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x03, 0x61, 0x6c, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x03, 0x61, 0x6c, 0x6c, 0x12, 0x20, 0x0a, 0x03, 0x61,
	0x66, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69,
	0x2e, 0x41, 0x46, 0x54, 0x54, 0x79, 0x70, 0x65, 0x52, 0x03, 0x61, 0x66, 0x74, 0x42, 0x12, 0x0a,
	0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0xfd, 0x03, 0x0a, 0x08, 0x41, 0x46, 0x54, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x29,
	0x0a, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x32, 0x0a, 0x04, 0x69, 0x70, 0x76,
	0x34, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f,
	0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e, 0x49, 0x70, 0x76, 0x34, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x04, 0x69, 0x70, 0x76, 0x34, 0x12, 0x32, 0x0a,
	0x04, 0x69, 0x70, 0x76, 0x36, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x72,
	0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e, 0x49, 0x70, 0x76,
	0x36, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x04, 0x69, 0x70, 0x76,
	0x36, 0x12, 0x33, 0x0a, 0x04, 0x6d, 0x70, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x48, 0x00,
	0x52, 0x04, 0x6d, 0x70, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x0e, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68,
	0x6f, 0x70, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e,
	0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x65, 0x79, 0x48,
	0x00, 0x52, 0x0c, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x37, 0x0a, 0x08, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66,
	0x74, 0x73, 0x2e, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52,
	0x07, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x12, 0x3a, 0x0a, 0x09, 0x6d, 0x61, 0x63, 0x5f,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72,
	0x69, 0x62, 0x69, 0x5f, 0x61, 0x66, 0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e, 0x4d, 0x61, 0x63,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x61, 0x63, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x62, 0x0a, 0x17, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x5f, 0x61, 0x66,
	0x74, 0x2e, 0x41, 0x66, 0x74, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x46, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x48,
	0x00, 0x52, 0x15, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x22, 0x34, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x25, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x41, 0x46, 0x54, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2a, 0x7d, 0x0a, 0x07, 0x41, 0x46, 0x54, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x50, 0x56, 0x34,
	0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x50, 0x56, 0x36, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04,
	0x4d, 0x50, 0x4c, 0x53, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x45, 0x58, 0x54, 0x48, 0x4f,
	0x50, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x45, 0x58, 0x54, 0x48, 0x4f, 0x50, 0x5f, 0x47,
	0x52, 0x4f, 0x55, 0x50, 0x10, 0x06, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x41, 0x43, 0x10, 0x07, 0x12,
	0x15, 0x0a, 0x11, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x32, 0x72, 0x0a, 0x05, 0x67, 0x52, 0x49, 0x42, 0x49, 0x12,
	0x39, 0x0a, 0x06, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x12, 0x14, 0x2e, 0x67, 0x72, 0x69, 0x62,
	0x69, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x15, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x30, 0x01, 0x12, 0x2e, 0x0a, 0x03, 0x47, 0x65,
	0x74, 0x12, 0x11, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x12, 0x2e, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x30, 0x01, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x67, 0x72, 0x69, 0x62, 0x69, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x3b, 0x67, 0x72, 0x69, 0x62, 0x69, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_v1_proto_service_gribi_proto_rawDescOnce sync.Once
	file_v1_proto_service_gribi_proto_rawDescData = file_v1_proto_service_gribi_proto_rawDesc
)

func file_v1_proto_service_gribi_proto_rawDescGZIP() []byte {
	file_v1_proto_service_gribi_proto_rawDescOnce.Do(func() {
		file_v1_proto_service_gribi_proto_rawDescData = protoimpl.X.CompressGZIP(file_v1_proto_service_gribi_proto_rawDescData)
	})
	return file_v1_proto_service_gribi_proto_rawDescData
}

var file_v1_proto_service_gribi_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_v1_proto_service_gribi_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_v1_proto_service_gribi_proto_goTypes = []interface{}{
	(AFTType)(0),                                    // 0: gribi.AFTType
	(AFTOperation_Operation)(0),                     // 1: gribi.AFTOperation.Operation
	(AFTResult_Status)(0),                           // 2: gribi.AFTResult.Status
	(ModifyRPCErrorDetails_Reason)(0),               // 3: gribi.ModifyRPCErrorDetails.Reason
	(SessionParametersResult_Status)(0),             // 4: gribi.SessionParametersResult.Status
	(SessionParameters_ClientRedundancy)(0),         // 5: gribi.SessionParameters.ClientRedundancy
	(SessionParameters_AFTPersistence)(0),           // 6: gribi.SessionParameters.AFTPersistence
	(SessionParameters_AFTResultStatusType)(0),      // 7: gribi.SessionParameters.AFTResultStatusType
	(*ModifyRequest)(nil),                           // 8: gribi.ModifyRequest
	(*AFTOperation)(nil),                            // 9: gribi.AFTOperation
	(*ModifyResponse)(nil),                          // 10: gribi.ModifyResponse
	(*AFTResult)(nil),                               // 11: gribi.AFTResult
	(*ModifyRPCErrorDetails)(nil),                   // 12: gribi.ModifyRPCErrorDetails
	(*SessionParametersResult)(nil),                 // 13: gribi.SessionParametersResult
	(*Uint128)(nil),                                 // 14: gribi.Uint128
	(*SessionParameters)(nil),                       // 15: gribi.SessionParameters
	(*Empty)(nil),                                   // 16: gribi.Empty
	(*GetRequest)(nil),                              // 17: gribi.GetRequest
	(*AFTEntry)(nil),                                // 18: gribi.AFTEntry
	(*GetResponse)(nil),                             // 19: gribi.GetResponse
	(*gribi_aft.Afts_Ipv4EntryKey)(nil),             // 20: gribi_aft.Afts.Ipv4EntryKey
	(*gribi_aft.Afts_Ipv6EntryKey)(nil),             // 21: gribi_aft.Afts.Ipv6EntryKey
	(*gribi_aft.Afts_LabelEntryKey)(nil),            // 22: gribi_aft.Afts.LabelEntryKey
	(*gribi_aft.Afts_NextHopGroupKey)(nil),          // 23: gribi_aft.Afts.NextHopGroupKey
	(*gribi_aft.Afts_NextHopKey)(nil),               // 24: gribi_aft.Afts.NextHopKey
	(*gribi_aft.Afts_MacEntryKey)(nil),              // 25: gribi_aft.Afts.MacEntryKey
	(*gribi_aft.Afts_PolicyForwardingEntryKey)(nil), // 26: gribi_aft.Afts.PolicyForwardingEntryKey
}
var file_v1_proto_service_gribi_proto_depIdxs = []int32{
	9,  // 0: gribi.ModifyRequest.operation:type_name -> gribi.AFTOperation
	15, // 1: gribi.ModifyRequest.params:type_name -> gribi.SessionParameters
	14, // 2: gribi.ModifyRequest.election_id:type_name -> gribi.Uint128
	1,  // 3: gribi.AFTOperation.op:type_name -> gribi.AFTOperation.Operation
	20, // 4: gribi.AFTOperation.ipv4:type_name -> gribi_aft.Afts.Ipv4EntryKey
	21, // 5: gribi.AFTOperation.ipv6:type_name -> gribi_aft.Afts.Ipv6EntryKey
	22, // 6: gribi.AFTOperation.mpls:type_name -> gribi_aft.Afts.LabelEntryKey
	23, // 7: gribi.AFTOperation.next_hop_group:type_name -> gribi_aft.Afts.NextHopGroupKey
	24, // 8: gribi.AFTOperation.next_hop:type_name -> gribi_aft.Afts.NextHopKey
	25, // 9: gribi.AFTOperation.mac_entry:type_name -> gribi_aft.Afts.MacEntryKey
	26, // 10: gribi.AFTOperation.policy_forwarding_entry:type_name -> gribi_aft.Afts.PolicyForwardingEntryKey
	14, // 11: gribi.AFTOperation.election_id:type_name -> gribi.Uint128
	11, // 12: gribi.ModifyResponse.result:type_name -> gribi.AFTResult
	13, // 13: gribi.ModifyResponse.session_params_result:type_name -> gribi.SessionParametersResult
	14, // 14: gribi.ModifyResponse.election_id:type_name -> gribi.Uint128
	2,  // 15: gribi.AFTResult.status:type_name -> gribi.AFTResult.Status
	3,  // 16: gribi.ModifyRPCErrorDetails.reason:type_name -> gribi.ModifyRPCErrorDetails.Reason
	4,  // 17: gribi.SessionParametersResult.status:type_name -> gribi.SessionParametersResult.Status
	5,  // 18: gribi.SessionParameters.redundancy:type_name -> gribi.SessionParameters.ClientRedundancy
	6,  // 19: gribi.SessionParameters.persistence:type_name -> gribi.SessionParameters.AFTPersistence
	7,  // 20: gribi.SessionParameters.ack_type:type_name -> gribi.SessionParameters.AFTResultStatusType
	16, // 21: gribi.GetRequest.all:type_name -> gribi.Empty
	0,  // 22: gribi.GetRequest.aft:type_name -> gribi.AFTType
	20, // 23: gribi.AFTEntry.ipv4:type_name -> gribi_aft.Afts.Ipv4EntryKey
	21, // 24: gribi.AFTEntry.ipv6:type_name -> gribi_aft.Afts.Ipv6EntryKey
	22, // 25: gribi.AFTEntry.mpls:type_name -> gribi_aft.Afts.LabelEntryKey
	23, // 26: gribi.AFTEntry.next_hop_group:type_name -> gribi_aft.Afts.NextHopGroupKey
	24, // 27: gribi.AFTEntry.next_hop:type_name -> gribi_aft.Afts.NextHopKey
	25, // 28: gribi.AFTEntry.mac_entry:type_name -> gribi_aft.Afts.MacEntryKey
	26, // 29: gribi.AFTEntry.policy_forwarding_entry:type_name -> gribi_aft.Afts.PolicyForwardingEntryKey
	18, // 30: gribi.GetResponse.entry:type_name -> gribi.AFTEntry
	8,  // 31: gribi.gRIBI.Modify:input_type -> gribi.ModifyRequest
	17, // 32: gribi.gRIBI.Get:input_type -> gribi.GetRequest
	10, // 33: gribi.gRIBI.Modify:output_type -> gribi.ModifyResponse
	19, // 34: gribi.gRIBI.Get:output_type -> gribi.GetResponse
	33, // [33:35] is the sub-list for method output_type
	31, // [31:33] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_v1_proto_service_gribi_proto_init() }
func file_v1_proto_service_gribi_proto_init() {
	if File_v1_proto_service_gribi_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_v1_proto_service_gribi_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AFTOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AFTResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyRPCErrorDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionParametersResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Uint128); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Empty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AFTEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_v1_proto_service_gribi_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_v1_proto_service_gribi_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*AFTOperation_Ipv4)(nil),
		(*AFTOperation_Ipv6)(nil),
		(*AFTOperation_Mpls)(nil),
		(*AFTOperation_NextHopGroup)(nil),
		(*AFTOperation_NextHop)(nil),
		(*AFTOperation_MacEntry)(nil),
		(*AFTOperation_PolicyForwardingEntry)(nil),
	}
	file_v1_proto_service_gribi_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*GetRequest_Name)(nil),
		(*GetRequest_All)(nil),
	}
	file_v1_proto_service_gribi_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*AFTEntry_Ipv4)(nil),
		(*AFTEntry_Ipv6)(nil),
		(*AFTEntry_Mpls)(nil),
		(*AFTEntry_NextHopGroup)(nil),
		(*AFTEntry_NextHop)(nil),
		(*AFTEntry_MacEntry)(nil),
		(*AFTEntry_PolicyForwardingEntry)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_v1_proto_service_gribi_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_v1_proto_service_gribi_proto_goTypes,
		DependencyIndexes: file_v1_proto_service_gribi_proto_depIdxs,
		EnumInfos:         file_v1_proto_service_gribi_proto_enumTypes,
		MessageInfos:      file_v1_proto_service_gribi_proto_msgTypes,
	}.Build()
	File_v1_proto_service_gribi_proto = out.File
	file_v1_proto_service_gribi_proto_rawDesc = nil
	file_v1_proto_service_gribi_proto_goTypes = nil
	file_v1_proto_service_gribi_proto_depIdxs = nil
}
