// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyInstrumentationScope(t *testing.T) {
	for name, src := range genTestEncodingValuesInstrumentationScope() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewInstrumentationScope()
				CopyInstrumentationScope(dest, src)
				assert.Equal(t, src, dest)
				CopyInstrumentationScope(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyInstrumentationScopeSlice(t *testing.T) {
	src := []InstrumentationScope{}
	dest := []InstrumentationScope{}
	// Test CopyTo empty
	dest = CopyInstrumentationScopeSlice(dest, src)
	assert.Equal(t, []InstrumentationScope{}, dest)

	// Test CopyTo larger slice
	src = GenTestInstrumentationScopeSlice()
	dest = CopyInstrumentationScopeSlice(dest, src)
	assert.Equal(t, GenTestInstrumentationScopeSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyInstrumentationScopeSlice(dest, src)
	assert.Equal(t, GenTestInstrumentationScopeSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyInstrumentationScopeSlice(dest, []InstrumentationScope{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyInstrumentationScopeSlice(dest, src)
	assert.Equal(t, GenTestInstrumentationScopeSlice(), dest)
}

func TestCopyInstrumentationScopePtrSlice(t *testing.T) {
	src := []*InstrumentationScope{}
	dest := []*InstrumentationScope{}
	// Test CopyTo empty
	dest = CopyInstrumentationScopePtrSlice(dest, src)
	assert.Equal(t, []*InstrumentationScope{}, dest)

	// Test CopyTo larger slice
	src = GenTestInstrumentationScopePtrSlice()
	dest = CopyInstrumentationScopePtrSlice(dest, src)
	assert.Equal(t, GenTestInstrumentationScopePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyInstrumentationScopePtrSlice(dest, src)
	assert.Equal(t, GenTestInstrumentationScopePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyInstrumentationScopePtrSlice(dest, []*InstrumentationScope{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyInstrumentationScopePtrSlice(dest, src)
	assert.Equal(t, GenTestInstrumentationScopePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONInstrumentationScopeUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewInstrumentationScope()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewInstrumentationScope(), dest)
}

func TestMarshalAndUnmarshalJSONInstrumentationScope(t *testing.T) {
	for name, src := range genTestEncodingValuesInstrumentationScope() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewInstrumentationScope()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteInstrumentationScope(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoInstrumentationScopeFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesInstrumentationScope() {
		t.Run(name, func(t *testing.T) {
			dest := NewInstrumentationScope()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoInstrumentationScopeUnknown(t *testing.T) {
	dest := NewInstrumentationScope()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewInstrumentationScope(), dest)
}

func TestMarshalAndUnmarshalProtoInstrumentationScope(t *testing.T) {
	for name, src := range genTestEncodingValuesInstrumentationScope() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewInstrumentationScope()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteInstrumentationScope(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufInstrumentationScope(t *testing.T) {
	for name, src := range genTestEncodingValuesInstrumentationScope() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.InstrumentationScope{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewInstrumentationScope()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesInstrumentationScope() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"Name/wrong_wire_type":                   {0xc},
		"Name/missing_value":                     {0xa},
		"Version/wrong_wire_type":                {0x14},
		"Version/missing_value":                  {0x12},
		"Attributes/wrong_wire_type":             {0x1c},
		"Attributes/missing_value":               {0x1a},
		"DroppedAttributesCount/wrong_wire_type": {0x24},
		"DroppedAttributesCount/missing_value":   {0x20},
	}
}

func genTestEncodingValuesInstrumentationScope() map[string]*InstrumentationScope {
	return map[string]*InstrumentationScope{
		"empty":                       NewInstrumentationScope(),
		"Name/test":                   {Name: "test_name"},
		"Version/test":                {Version: "test_version"},
		"Attributes/test":             {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
	}
}
