// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyMetricsData(t *testing.T) {
	for name, src := range genTestEncodingValuesMetricsData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewMetricsData()
				CopyMetricsData(dest, src)
				assert.Equal(t, src, dest)
				CopyMetricsData(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyMetricsDataSlice(t *testing.T) {
	src := []MetricsData{}
	dest := []MetricsData{}
	// Test CopyTo empty
	dest = CopyMetricsDataSlice(dest, src)
	assert.Equal(t, []MetricsData{}, dest)

	// Test CopyTo larger slice
	src = GenTestMetricsDataSlice()
	dest = CopyMetricsDataSlice(dest, src)
	assert.Equal(t, GenTestMetricsDataSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyMetricsDataSlice(dest, src)
	assert.Equal(t, GenTestMetricsDataSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyMetricsDataSlice(dest, []MetricsData{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyMetricsDataSlice(dest, src)
	assert.Equal(t, GenTestMetricsDataSlice(), dest)
}

func TestCopyMetricsDataPtrSlice(t *testing.T) {
	src := []*MetricsData{}
	dest := []*MetricsData{}
	// Test CopyTo empty
	dest = CopyMetricsDataPtrSlice(dest, src)
	assert.Equal(t, []*MetricsData{}, dest)

	// Test CopyTo larger slice
	src = GenTestMetricsDataPtrSlice()
	dest = CopyMetricsDataPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricsDataPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyMetricsDataPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricsDataPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyMetricsDataPtrSlice(dest, []*MetricsData{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyMetricsDataPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricsDataPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONMetricsDataUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewMetricsData()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewMetricsData(), dest)
}

func TestMarshalAndUnmarshalJSONMetricsData(t *testing.T) {
	for name, src := range genTestEncodingValuesMetricsData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewMetricsData()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteMetricsData(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoMetricsDataFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesMetricsData() {
		t.Run(name, func(t *testing.T) {
			dest := NewMetricsData()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoMetricsDataUnknown(t *testing.T) {
	dest := NewMetricsData()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewMetricsData(), dest)
}

func TestMarshalAndUnmarshalProtoMetricsData(t *testing.T) {
	for name, src := range genTestEncodingValuesMetricsData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewMetricsData()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteMetricsData(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufMetricsData(t *testing.T) {
	for name, src := range genTestEncodingValuesMetricsData() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.MetricsData{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewMetricsData()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesMetricsData() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                   {0x02},
		"ResourceMetrics/wrong_wire_type": {0xc},
		"ResourceMetrics/missing_value":   {0xa},
	}
}

func genTestEncodingValuesMetricsData() map[string]*MetricsData {
	return map[string]*MetricsData{
		"empty":                NewMetricsData(),
		"ResourceMetrics/test": {ResourceMetrics: []*ResourceMetrics{{}, GenTestResourceMetrics()}},
	}
}
