// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyMetricsRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesMetricsRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewMetricsRequest()
				CopyMetricsRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyMetricsRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyMetricsRequestSlice(t *testing.T) {
	src := []MetricsRequest{}
	dest := []MetricsRequest{}
	// Test CopyTo empty
	dest = CopyMetricsRequestSlice(dest, src)
	assert.Equal(t, []MetricsRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestMetricsRequestSlice()
	dest = CopyMetricsRequestSlice(dest, src)
	assert.Equal(t, GenTestMetricsRequestSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyMetricsRequestSlice(dest, src)
	assert.Equal(t, GenTestMetricsRequestSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyMetricsRequestSlice(dest, []MetricsRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyMetricsRequestSlice(dest, src)
	assert.Equal(t, GenTestMetricsRequestSlice(), dest)
}

func TestCopyMetricsRequestPtrSlice(t *testing.T) {
	src := []*MetricsRequest{}
	dest := []*MetricsRequest{}
	// Test CopyTo empty
	dest = CopyMetricsRequestPtrSlice(dest, src)
	assert.Equal(t, []*MetricsRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestMetricsRequestPtrSlice()
	dest = CopyMetricsRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricsRequestPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyMetricsRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricsRequestPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyMetricsRequestPtrSlice(dest, []*MetricsRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyMetricsRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricsRequestPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONMetricsRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewMetricsRequest()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewMetricsRequest(), dest)
}

func TestMarshalAndUnmarshalJSONMetricsRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesMetricsRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewMetricsRequest()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteMetricsRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoMetricsRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesMetricsRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewMetricsRequest()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoMetricsRequestUnknown(t *testing.T) {
	dest := NewMetricsRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewMetricsRequest(), dest)
}

func TestMarshalAndUnmarshalProtoMetricsRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesMetricsRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewMetricsRequest()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteMetricsRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufMetricsRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesMetricsRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewMetricsRequest()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesMetricsRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"RequestContext/wrong_wire_type": {0x14},
		"RequestContext/missing_value":   {0x12},
		"MetricsData/wrong_wire_type":    {0x1c},
		"MetricsData/missing_value":      {0x1a},
		"FormatVersion/wrong_wire_type":  {0xc},
		"FormatVersion/missing_value":    {0xd},
	}
}

func genTestEncodingValuesMetricsRequest() map[string]*MetricsRequest {
	return map[string]*MetricsRequest{
		"empty":               NewMetricsRequest(),
		"RequestContext/test": {RequestContext: GenTestRequestContext()},
		"MetricsData/test":    {MetricsData: *GenTestMetricsData()},
		"FormatVersion/test":  {FormatVersion: uint32(13)},
	}
}
