// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package classroom provides access to the Google Classroom API.
//
// For product documentation, see: https://developers.google.com/workspace/classroom/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/classroom/v1"
//	...
//	ctx := context.Background()
//	classroomService, err := classroom.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	classroomService, err := classroom.NewService(ctx, option.WithScopes(classroom.ClassroomTopicsReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	classroomService, err := classroom.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	classroomService, err := classroom.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package classroom // import "google.golang.org/api/classroom/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "classroom:v1"
const apiName = "classroom"
const apiVersion = "v1"
const basePath = "https://classroom.googleapis.com/"
const basePathTemplate = "https://classroom.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://classroom.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See and update its own attachments to posts in Google Classroom
	ClassroomAddonsStudentScope = "https://www.googleapis.com/auth/classroom.addons.student"

	// See, create, and update its own attachments to posts in classes you teach in
	// Google Classroom
	ClassroomAddonsTeacherScope = "https://www.googleapis.com/auth/classroom.addons.teacher"

	// View and manage announcements in Google Classroom
	ClassroomAnnouncementsScope = "https://www.googleapis.com/auth/classroom.announcements"

	// View announcements in Google Classroom
	ClassroomAnnouncementsReadonlyScope = "https://www.googleapis.com/auth/classroom.announcements.readonly"

	// See, edit, create, and permanently delete your Google Classroom classes
	ClassroomCoursesScope = "https://www.googleapis.com/auth/classroom.courses"

	// View your Google Classroom classes
	ClassroomCoursesReadonlyScope = "https://www.googleapis.com/auth/classroom.courses.readonly"

	// See, create and edit coursework items including assignments, questions, and
	// grades
	ClassroomCourseworkMeScope = "https://www.googleapis.com/auth/classroom.coursework.me"

	// View your course work and grades in Google Classroom
	ClassroomCourseworkMeReadonlyScope = "https://www.googleapis.com/auth/classroom.coursework.me.readonly"

	// Manage course work and grades for students in the Google Classroom classes
	// you teach and view the course work and grades for classes you administer
	ClassroomCourseworkStudentsScope = "https://www.googleapis.com/auth/classroom.coursework.students"

	// View course work and grades for students in the Google Classroom classes you
	// teach or administer
	ClassroomCourseworkStudentsReadonlyScope = "https://www.googleapis.com/auth/classroom.coursework.students.readonly"

	// See, edit, and create classwork materials in Google Classroom
	ClassroomCourseworkmaterialsScope = "https://www.googleapis.com/auth/classroom.courseworkmaterials"

	// See all classwork materials for your Google Classroom classes
	ClassroomCourseworkmaterialsReadonlyScope = "https://www.googleapis.com/auth/classroom.courseworkmaterials.readonly"

	// View your Google Classroom guardians
	ClassroomGuardianlinksMeReadonlyScope = "https://www.googleapis.com/auth/classroom.guardianlinks.me.readonly"

	// View and manage guardians for students in your Google Classroom classes
	ClassroomGuardianlinksStudentsScope = "https://www.googleapis.com/auth/classroom.guardianlinks.students"

	// View guardians for students in your Google Classroom classes
	ClassroomGuardianlinksStudentsReadonlyScope = "https://www.googleapis.com/auth/classroom.guardianlinks.students.readonly"

	// View the email addresses of people in your classes
	ClassroomProfileEmailsScope = "https://www.googleapis.com/auth/classroom.profile.emails"

	// View the profile photos of people in your classes
	ClassroomProfilePhotosScope = "https://www.googleapis.com/auth/classroom.profile.photos"

	// Receive notifications about your Google Classroom data
	ClassroomPushNotificationsScope = "https://www.googleapis.com/auth/classroom.push-notifications"

	// Manage your Google Classroom class rosters
	ClassroomRostersScope = "https://www.googleapis.com/auth/classroom.rosters"

	// View your Google Classroom class rosters
	ClassroomRostersReadonlyScope = "https://www.googleapis.com/auth/classroom.rosters.readonly"

	// View your course work and grades in Google Classroom
	ClassroomStudentSubmissionsMeReadonlyScope = "https://www.googleapis.com/auth/classroom.student-submissions.me.readonly"

	// View course work and grades for students in the Google Classroom classes you
	// teach or administer
	ClassroomStudentSubmissionsStudentsReadonlyScope = "https://www.googleapis.com/auth/classroom.student-submissions.students.readonly"

	// See, create, and edit topics in Google Classroom
	ClassroomTopicsScope = "https://www.googleapis.com/auth/classroom.topics"

	// View topics in Google Classroom
	ClassroomTopicsReadonlyScope = "https://www.googleapis.com/auth/classroom.topics.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/classroom.addons.student",
		"https://www.googleapis.com/auth/classroom.addons.teacher",
		"https://www.googleapis.com/auth/classroom.announcements",
		"https://www.googleapis.com/auth/classroom.announcements.readonly",
		"https://www.googleapis.com/auth/classroom.courses",
		"https://www.googleapis.com/auth/classroom.courses.readonly",
		"https://www.googleapis.com/auth/classroom.coursework.me",
		"https://www.googleapis.com/auth/classroom.coursework.me.readonly",
		"https://www.googleapis.com/auth/classroom.coursework.students",
		"https://www.googleapis.com/auth/classroom.coursework.students.readonly",
		"https://www.googleapis.com/auth/classroom.courseworkmaterials",
		"https://www.googleapis.com/auth/classroom.courseworkmaterials.readonly",
		"https://www.googleapis.com/auth/classroom.guardianlinks.me.readonly",
		"https://www.googleapis.com/auth/classroom.guardianlinks.students",
		"https://www.googleapis.com/auth/classroom.guardianlinks.students.readonly",
		"https://www.googleapis.com/auth/classroom.profile.emails",
		"https://www.googleapis.com/auth/classroom.profile.photos",
		"https://www.googleapis.com/auth/classroom.push-notifications",
		"https://www.googleapis.com/auth/classroom.rosters",
		"https://www.googleapis.com/auth/classroom.rosters.readonly",
		"https://www.googleapis.com/auth/classroom.student-submissions.me.readonly",
		"https://www.googleapis.com/auth/classroom.student-submissions.students.readonly",
		"https://www.googleapis.com/auth/classroom.topics",
		"https://www.googleapis.com/auth/classroom.topics.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Courses = NewCoursesService(s)
	s.Invitations = NewInvitationsService(s)
	s.Registrations = NewRegistrationsService(s)
	s.UserProfiles = NewUserProfilesService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Courses *CoursesService

	Invitations *InvitationsService

	Registrations *RegistrationsService

	UserProfiles *UserProfilesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCoursesService(s *Service) *CoursesService {
	rs := &CoursesService{s: s}
	rs.Aliases = NewCoursesAliasesService(s)
	rs.Announcements = NewCoursesAnnouncementsService(s)
	rs.CourseWork = NewCoursesCourseWorkService(s)
	rs.CourseWorkMaterials = NewCoursesCourseWorkMaterialsService(s)
	rs.Posts = NewCoursesPostsService(s)
	rs.Students = NewCoursesStudentsService(s)
	rs.Teachers = NewCoursesTeachersService(s)
	rs.Topics = NewCoursesTopicsService(s)
	return rs
}

type CoursesService struct {
	s *Service

	Aliases *CoursesAliasesService

	Announcements *CoursesAnnouncementsService

	CourseWork *CoursesCourseWorkService

	CourseWorkMaterials *CoursesCourseWorkMaterialsService

	Posts *CoursesPostsService

	Students *CoursesStudentsService

	Teachers *CoursesTeachersService

	Topics *CoursesTopicsService
}

func NewCoursesAliasesService(s *Service) *CoursesAliasesService {
	rs := &CoursesAliasesService{s: s}
	return rs
}

type CoursesAliasesService struct {
	s *Service
}

func NewCoursesAnnouncementsService(s *Service) *CoursesAnnouncementsService {
	rs := &CoursesAnnouncementsService{s: s}
	rs.AddOnAttachments = NewCoursesAnnouncementsAddOnAttachmentsService(s)
	return rs
}

type CoursesAnnouncementsService struct {
	s *Service

	AddOnAttachments *CoursesAnnouncementsAddOnAttachmentsService
}

func NewCoursesAnnouncementsAddOnAttachmentsService(s *Service) *CoursesAnnouncementsAddOnAttachmentsService {
	rs := &CoursesAnnouncementsAddOnAttachmentsService{s: s}
	return rs
}

type CoursesAnnouncementsAddOnAttachmentsService struct {
	s *Service
}

func NewCoursesCourseWorkService(s *Service) *CoursesCourseWorkService {
	rs := &CoursesCourseWorkService{s: s}
	rs.AddOnAttachments = NewCoursesCourseWorkAddOnAttachmentsService(s)
	rs.Rubrics = NewCoursesCourseWorkRubricsService(s)
	rs.StudentSubmissions = NewCoursesCourseWorkStudentSubmissionsService(s)
	return rs
}

type CoursesCourseWorkService struct {
	s *Service

	AddOnAttachments *CoursesCourseWorkAddOnAttachmentsService

	Rubrics *CoursesCourseWorkRubricsService

	StudentSubmissions *CoursesCourseWorkStudentSubmissionsService
}

func NewCoursesCourseWorkAddOnAttachmentsService(s *Service) *CoursesCourseWorkAddOnAttachmentsService {
	rs := &CoursesCourseWorkAddOnAttachmentsService{s: s}
	rs.StudentSubmissions = NewCoursesCourseWorkAddOnAttachmentsStudentSubmissionsService(s)
	return rs
}

type CoursesCourseWorkAddOnAttachmentsService struct {
	s *Service

	StudentSubmissions *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsService
}

func NewCoursesCourseWorkAddOnAttachmentsStudentSubmissionsService(s *Service) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsService {
	rs := &CoursesCourseWorkAddOnAttachmentsStudentSubmissionsService{s: s}
	return rs
}

type CoursesCourseWorkAddOnAttachmentsStudentSubmissionsService struct {
	s *Service
}

func NewCoursesCourseWorkRubricsService(s *Service) *CoursesCourseWorkRubricsService {
	rs := &CoursesCourseWorkRubricsService{s: s}
	return rs
}

type CoursesCourseWorkRubricsService struct {
	s *Service
}

func NewCoursesCourseWorkStudentSubmissionsService(s *Service) *CoursesCourseWorkStudentSubmissionsService {
	rs := &CoursesCourseWorkStudentSubmissionsService{s: s}
	return rs
}

type CoursesCourseWorkStudentSubmissionsService struct {
	s *Service
}

func NewCoursesCourseWorkMaterialsService(s *Service) *CoursesCourseWorkMaterialsService {
	rs := &CoursesCourseWorkMaterialsService{s: s}
	rs.AddOnAttachments = NewCoursesCourseWorkMaterialsAddOnAttachmentsService(s)
	return rs
}

type CoursesCourseWorkMaterialsService struct {
	s *Service

	AddOnAttachments *CoursesCourseWorkMaterialsAddOnAttachmentsService
}

func NewCoursesCourseWorkMaterialsAddOnAttachmentsService(s *Service) *CoursesCourseWorkMaterialsAddOnAttachmentsService {
	rs := &CoursesCourseWorkMaterialsAddOnAttachmentsService{s: s}
	return rs
}

type CoursesCourseWorkMaterialsAddOnAttachmentsService struct {
	s *Service
}

func NewCoursesPostsService(s *Service) *CoursesPostsService {
	rs := &CoursesPostsService{s: s}
	rs.AddOnAttachments = NewCoursesPostsAddOnAttachmentsService(s)
	return rs
}

type CoursesPostsService struct {
	s *Service

	AddOnAttachments *CoursesPostsAddOnAttachmentsService
}

func NewCoursesPostsAddOnAttachmentsService(s *Service) *CoursesPostsAddOnAttachmentsService {
	rs := &CoursesPostsAddOnAttachmentsService{s: s}
	rs.StudentSubmissions = NewCoursesPostsAddOnAttachmentsStudentSubmissionsService(s)
	return rs
}

type CoursesPostsAddOnAttachmentsService struct {
	s *Service

	StudentSubmissions *CoursesPostsAddOnAttachmentsStudentSubmissionsService
}

func NewCoursesPostsAddOnAttachmentsStudentSubmissionsService(s *Service) *CoursesPostsAddOnAttachmentsStudentSubmissionsService {
	rs := &CoursesPostsAddOnAttachmentsStudentSubmissionsService{s: s}
	return rs
}

type CoursesPostsAddOnAttachmentsStudentSubmissionsService struct {
	s *Service
}

func NewCoursesStudentsService(s *Service) *CoursesStudentsService {
	rs := &CoursesStudentsService{s: s}
	return rs
}

type CoursesStudentsService struct {
	s *Service
}

func NewCoursesTeachersService(s *Service) *CoursesTeachersService {
	rs := &CoursesTeachersService{s: s}
	return rs
}

type CoursesTeachersService struct {
	s *Service
}

func NewCoursesTopicsService(s *Service) *CoursesTopicsService {
	rs := &CoursesTopicsService{s: s}
	return rs
}

type CoursesTopicsService struct {
	s *Service
}

func NewInvitationsService(s *Service) *InvitationsService {
	rs := &InvitationsService{s: s}
	return rs
}

type InvitationsService struct {
	s *Service
}

func NewRegistrationsService(s *Service) *RegistrationsService {
	rs := &RegistrationsService{s: s}
	return rs
}

type RegistrationsService struct {
	s *Service
}

func NewUserProfilesService(s *Service) *UserProfilesService {
	rs := &UserProfilesService{s: s}
	rs.GuardianInvitations = NewUserProfilesGuardianInvitationsService(s)
	rs.Guardians = NewUserProfilesGuardiansService(s)
	return rs
}

type UserProfilesService struct {
	s *Service

	GuardianInvitations *UserProfilesGuardianInvitationsService

	Guardians *UserProfilesGuardiansService
}

func NewUserProfilesGuardianInvitationsService(s *Service) *UserProfilesGuardianInvitationsService {
	rs := &UserProfilesGuardianInvitationsService{s: s}
	return rs
}

type UserProfilesGuardianInvitationsService struct {
	s *Service
}

func NewUserProfilesGuardiansService(s *Service) *UserProfilesGuardiansService {
	rs := &UserProfilesGuardiansService{s: s}
	return rs
}

type UserProfilesGuardiansService struct {
	s *Service
}

// AddOnAttachment: An add-on attachment on a post.
type AddOnAttachment struct {
	// CopyHistory: Output only. Identifiers of attachments that were previous
	// copies of this attachment. If the attachment was previously copied by virtue
	// of its parent post being copied, this enumerates the identifiers of
	// attachments that were its previous copies in ascending chronological order
	// of copy.
	CopyHistory []*CopyHistory `json:"copyHistory,omitempty"`
	// CourseId: Immutable. Identifier of the course.
	CourseId string `json:"courseId,omitempty"`
	// DueDate: Date, in UTC, that work on this attachment is due. This must be
	// specified if `due_time` is specified.
	DueDate *Date `json:"dueDate,omitempty"`
	// DueTime: Time of day, in UTC, that work on this attachment is due. This must
	// be specified if `due_date` is specified.
	DueTime *TimeOfDay `json:"dueTime,omitempty"`
	// Id: Immutable. Classroom-assigned identifier for this attachment, unique per
	// post.
	Id string `json:"id,omitempty"`
	// ItemId: Immutable. Identifier of the `Announcement`, `CourseWork`, or
	// `CourseWorkMaterial` under which the attachment is attached. Unique per
	// course.
	ItemId string `json:"itemId,omitempty"`
	// MaxPoints: Maximum grade for this attachment. Can only be set if
	// `studentWorkReviewUri` is set. Set to a non-zero value to indicate that the
	// attachment supports grade passback. If set, this must be a non-negative
	// integer value. When set to zero, the attachment will not support grade
	// passback.
	MaxPoints float64 `json:"maxPoints,omitempty"`
	// PostId: Immutable. Deprecated, use `item_id` instead.
	PostId string `json:"postId,omitempty"`
	// StudentViewUri: Required. URI to show the student view of the attachment.
	// The URI will be opened in an iframe with the `courseId`, `itemId`,
	// `itemType`, and `attachmentId` query parameters set.
	StudentViewUri *EmbedUri `json:"studentViewUri,omitempty"`
	// StudentWorkReviewUri: URI for the teacher to see student work on the
	// attachment, if applicable. The URI will be opened in an iframe with the
	// `courseId`, `itemId`, `itemType`, `attachmentId`, and `submissionId` query
	// parameters set. This is the same `submissionId` returned in the
	// `AddOnContext.studentContext`
	// (//devsite.google.com/classroom/reference/rest/v1/AddOnContext#StudentContext
	// ) field when a student views the attachment. If the URI is omitted or
	// removed, `max_points` will also be discarded.
	StudentWorkReviewUri *EmbedUri `json:"studentWorkReviewUri,omitempty"`
	// TeacherViewUri: Required. URI to show the teacher view of the attachment.
	// The URI will be opened in an iframe with the `courseId`, `itemId`,
	// `itemType`, and `attachmentId` query parameters set.
	TeacherViewUri *EmbedUri `json:"teacherViewUri,omitempty"`
	// Title: Required. Title of this attachment. The title must be between 1 and
	// 1000 characters.
	Title string `json:"title,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CopyHistory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CopyHistory") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddOnAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod AddOnAttachment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AddOnAttachment) UnmarshalJSON(data []byte) error {
	type NoMethod AddOnAttachment
	var s1 struct {
		MaxPoints gensupport.JSONFloat64 `json:"maxPoints"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxPoints = float64(s1.MaxPoints)
	return nil
}

// AddOnAttachmentStudentSubmission: Payload for grade update requests.
type AddOnAttachmentStudentSubmission struct {
	// PointsEarned: Student grade on this attachment. If unset, no grade was set.
	PointsEarned float64 `json:"pointsEarned,omitempty"`
	// PostSubmissionState: Submission state of add-on attachment's parent post
	// (i.e. assignment).
	//
	// Possible values:
	//   "SUBMISSION_STATE_UNSPECIFIED" - No state specified. This should never be
	// returned.
	//   "NEW" - The student has never accessed this submission. Attachments are
	// not returned and timestamps is not set.
	//   "CREATED" - Has been created.
	//   "TURNED_IN" - Has been turned in to the teacher.
	//   "RETURNED" - Has been returned to the student.
	//   "RECLAIMED_BY_STUDENT" - Student chose to "unsubmit" the assignment.
	PostSubmissionState string `json:"postSubmissionState,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "PointsEarned") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PointsEarned") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddOnAttachmentStudentSubmission) MarshalJSON() ([]byte, error) {
	type NoMethod AddOnAttachmentStudentSubmission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AddOnAttachmentStudentSubmission) UnmarshalJSON(data []byte) error {
	type NoMethod AddOnAttachmentStudentSubmission
	var s1 struct {
		PointsEarned gensupport.JSONFloat64 `json:"pointsEarned"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PointsEarned = float64(s1.PointsEarned)
	return nil
}

// AddOnContext: Attachment-relevant metadata for Classroom add-ons in the
// context of a specific post.
type AddOnContext struct {
	// CourseId: Immutable. Identifier of the course.
	CourseId string `json:"courseId,omitempty"`
	// ItemId: Immutable. Identifier of the `Announcement`, `CourseWork`, or
	// `CourseWorkMaterial` under which the attachment is attached.
	ItemId string `json:"itemId,omitempty"`
	// PostId: Immutable. Deprecated, use `item_id` instead.
	PostId string `json:"postId,omitempty"`
	// StudentContext: Add-on context corresponding to the requesting user's role
	// as a student. Its presence implies that the requesting user is a student in
	// the course.
	StudentContext *StudentContext `json:"studentContext,omitempty"`
	// SupportsStudentWork: Optional. Whether the post allows the teacher to see
	// student work and passback grades.
	SupportsStudentWork bool `json:"supportsStudentWork,omitempty"`
	// TeacherContext: Add-on context corresponding to the requesting user's role
	// as a teacher. Its presence implies that the requesting user is a teacher in
	// the course.
	TeacherContext *TeacherContext `json:"teacherContext,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CourseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddOnContext) MarshalJSON() ([]byte, error) {
	type NoMethod AddOnContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Announcement: Announcement created by a teacher for students of the course
type Announcement struct {
	// AlternateLink: Absolute link to this announcement in the Classroom web UI.
	// This is only populated if `state` is `PUBLISHED`. Read-only.
	AlternateLink string `json:"alternateLink,omitempty"`
	// AssigneeMode: Assignee mode of the announcement. If unspecified, the default
	// value is `ALL_STUDENTS`.
	//
	// Possible values:
	//   "ASSIGNEE_MODE_UNSPECIFIED" - No mode specified. This is never returned.
	//   "ALL_STUDENTS" - All students can see the item. This is the default state.
	//   "INDIVIDUAL_STUDENTS" - A subset of the students can see the item.
	AssigneeMode string `json:"assigneeMode,omitempty"`
	// CourseId: Identifier of the course. Read-only.
	CourseId string `json:"courseId,omitempty"`
	// CreationTime: Timestamp when this announcement was created. Read-only.
	CreationTime string `json:"creationTime,omitempty"`
	// CreatorUserId: Identifier for the user that created the announcement.
	// Read-only.
	CreatorUserId string `json:"creatorUserId,omitempty"`
	// Id: Classroom-assigned identifier of this announcement, unique per course.
	// Read-only.
	Id string `json:"id,omitempty"`
	// IndividualStudentsOptions: Identifiers of students with access to the
	// announcement. This field is set only if `assigneeMode` is
	// `INDIVIDUAL_STUDENTS`. If the `assigneeMode` is `INDIVIDUAL_STUDENTS`, then
	// only students specified in this field can see the announcement.
	IndividualStudentsOptions *IndividualStudentsOptions `json:"individualStudentsOptions,omitempty"`
	// Materials: Additional materials. Announcements must have no more than 20
	// material items.
	Materials []*Material `json:"materials,omitempty"`
	// ScheduledTime: Optional timestamp when this announcement is scheduled to be
	// published.
	ScheduledTime string `json:"scheduledTime,omitempty"`
	// State: Status of this announcement. If unspecified, the default state is
	// `DRAFT`.
	//
	// Possible values:
	//   "ANNOUNCEMENT_STATE_UNSPECIFIED" - No state specified. This is never
	// returned.
	//   "PUBLISHED" - Status for announcement that has been published. This is the
	// default state.
	//   "DRAFT" - Status for an announcement that is not yet published.
	// Announcement in this state is visible only to course teachers and domain
	// administrators.
	//   "DELETED" - Status for announcement that was published but is now deleted.
	// Announcement in this state is visible only to course teachers and domain
	// administrators. Announcement in this state is deleted after some time.
	State string `json:"state,omitempty"`
	// Text: Description of this announcement. The text must be a valid UTF-8
	// string containing no more than 30,000 characters.
	Text string `json:"text,omitempty"`
	// UpdateTime: Timestamp of the most recent change to this announcement.
	// Read-only.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Announcement) MarshalJSON() ([]byte, error) {
	type NoMethod Announcement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Assignment: Additional details for assignments.
type Assignment struct {
	// StudentWorkFolder: Drive folder where attachments from student submissions
	// are placed. This is only populated for course teachers and administrators.
	StudentWorkFolder *DriveFolder `json:"studentWorkFolder,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StudentWorkFolder") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StudentWorkFolder") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Assignment) MarshalJSON() ([]byte, error) {
	type NoMethod Assignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AssignmentSubmission: Student work for an assignment.
type AssignmentSubmission struct {
	// Attachments: Attachments added by the student. Drive files that correspond
	// to materials with a share mode of STUDENT_COPY may not exist yet if the
	// student has not accessed the assignment in Classroom. Some attachment
	// metadata is only populated if the requesting user has permission to access
	// it. Identifier and alternate_link fields are always available, but others
	// (for example, title) may not be.
	Attachments []*Attachment `json:"attachments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attachments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attachments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AssignmentSubmission) MarshalJSON() ([]byte, error) {
	type NoMethod AssignmentSubmission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Attachment: Attachment added to student assignment work. When creating
// attachments, setting the `form` field is not supported.
type Attachment struct {
	// DriveFile: Google Drive file attachment.
	DriveFile *DriveFile `json:"driveFile,omitempty"`
	// Form: Google Forms attachment.
	Form *Form `json:"form,omitempty"`
	// Link: Link attachment.
	Link *Link `json:"link,omitempty"`
	// YouTubeVideo: Youtube video attachment.
	YouTubeVideo *YouTubeVideo `json:"youTubeVideo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DriveFile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DriveFile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Attachment) MarshalJSON() ([]byte, error) {
	type NoMethod Attachment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudPubsubTopic: A reference to a Cloud Pub/Sub topic. To register for
// notifications, the owner of the topic must grant
// `classroom-notifications@system.gserviceaccount.com` the
// `projects.topics.publish` permission.
type CloudPubsubTopic struct {
	// TopicName: The `name` field of a Cloud Pub/Sub Topic
	// (https://cloud.google.com/pubsub/docs/reference/rest/v1/projects.topics#Topic).
	TopicName string `json:"topicName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TopicName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TopicName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudPubsubTopic) MarshalJSON() ([]byte, error) {
	type NoMethod CloudPubsubTopic
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CopyHistory: Identifier of a previous copy of a given attachment.
type CopyHistory struct {
	// AttachmentId: Immutable. Identifier of the attachment.
	AttachmentId string `json:"attachmentId,omitempty"`
	// CourseId: Immutable. Identifier of the course.
	CourseId string `json:"courseId,omitempty"`
	// ItemId: Immutable. Identifier of the `Announcement`, `CourseWork`, or
	// `CourseWorkMaterial` under which the attachment is attached.
	ItemId string `json:"itemId,omitempty"`
	// PostId: Immutable. Deprecated, use `item_id` instead.
	PostId string `json:"postId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttachmentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttachmentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CopyHistory) MarshalJSON() ([]byte, error) {
	type NoMethod CopyHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Course: A Course in Classroom.
type Course struct {
	// AlternateLink: Absolute link to this course in the Classroom web UI.
	// Read-only.
	AlternateLink string `json:"alternateLink,omitempty"`
	// CalendarId: The Calendar ID for a calendar that all course members can see,
	// to which Classroom adds events for course work and announcements in the
	// course. The Calendar for a course is created asynchronously when the course
	// is set to `CourseState.ACTIVE` for the first time (at creation time or when
	// it is updated to `ACTIVE` through the UI or the API). The Calendar ID will
	// not be populated until the creation process is completed. Read-only.
	CalendarId string `json:"calendarId,omitempty"`
	// CourseGroupEmail: The email address of a Google group containing all members
	// of the course. This group does not accept email and can only be used for
	// permissions. Read-only.
	CourseGroupEmail string `json:"courseGroupEmail,omitempty"`
	// CourseMaterialSets: Sets of materials that appear on the "about" page of
	// this course. Read-only.
	CourseMaterialSets []*CourseMaterialSet `json:"courseMaterialSets,omitempty"`
	// CourseState: State of the course. If unspecified, the default state is
	// `PROVISIONED`.
	//
	// Possible values:
	//   "COURSE_STATE_UNSPECIFIED" - No course state. No returned Course message
	// will use this value.
	//   "ACTIVE" - The course is active.
	//   "ARCHIVED" - The course has been archived. You cannot modify it except to
	// change it to a different state.
	//   "PROVISIONED" - The course has been created, but not yet activated. It is
	// accessible by the primary teacher and domain administrators, who may modify
	// it or change it to the `ACTIVE` or `DECLINED` states. A course may only be
	// changed to `PROVISIONED` if it is in the `DECLINED` state.
	//   "DECLINED" - The course has been created, but declined. It is accessible
	// by the course owner and domain administrators, though it will not be
	// displayed in the web UI. You cannot modify the course except to change it to
	// the `PROVISIONED` state. A course may only be changed to `DECLINED` if it is
	// in the `PROVISIONED` state.
	//   "SUSPENDED" - The course has been suspended. You cannot modify the course,
	// and only the user identified by the `owner_id` can view the course. A course
	// may be placed in this state if it potentially violates the Terms of Service.
	CourseState string `json:"courseState,omitempty"`
	// CreationTime: Creation time of the course. Specifying this field in a course
	// update mask results in an error. Read-only.
	CreationTime string `json:"creationTime,omitempty"`
	// Description: Optional description. For example, "We'll be learning about the
	// structure of living creatures from a combination of textbooks, guest
	// lectures, and lab work. Expect to be excited!" If set, this field must be a
	// valid UTF-8 string and no longer than 30,000 characters.
	Description string `json:"description,omitempty"`
	// DescriptionHeading: Optional heading for the description. For example,
	// "Welcome to 10th Grade Biology." If set, this field must be a valid UTF-8
	// string and no longer than 3600 characters.
	DescriptionHeading string `json:"descriptionHeading,omitempty"`
	// EnrollmentCode: Enrollment code to use when joining this course. Specifying
	// this field in a course update mask results in an error. Read-only.
	EnrollmentCode string `json:"enrollmentCode,omitempty"`
	// GradebookSettings: The gradebook settings that specify how a student's
	// overall grade for the course will be calculated and who it will be displayed
	// to. Read-only.
	GradebookSettings *GradebookSettings `json:"gradebookSettings,omitempty"`
	// GuardiansEnabled: Whether or not guardian notifications are enabled for this
	// course. Read-only.
	GuardiansEnabled bool `json:"guardiansEnabled,omitempty"`
	// Id: Identifier for this course assigned by Classroom. When creating a
	// course, you may optionally set this identifier to an alias string in the
	// request to create a corresponding alias. The `id` is still assigned by
	// Classroom and cannot be updated after the course is created. Specifying this
	// field in a course update mask results in an error.
	Id string `json:"id,omitempty"`
	// Name: Name of the course. For example, "10th Grade Biology". The name is
	// required. It must be between 1 and 750 characters and a valid UTF-8 string.
	Name string `json:"name,omitempty"`
	// OwnerId: The identifier of the owner of a course. When specified as a
	// parameter of a create course request, this field is required. The identifier
	// can be one of the following: * the numeric identifier for the user * the
	// email address of the user * the string literal "me", indicating the
	// requesting user This must be set in a create request. Admins can also
	// specify this field in a patch course request to transfer ownership. In other
	// contexts, it is read-only.
	OwnerId string `json:"ownerId,omitempty"`
	// Room: Optional room location. For example, "301". If set, this field must be
	// a valid UTF-8 string and no longer than 650 characters.
	Room string `json:"room,omitempty"`
	// Section: Section of the course. For example, "Period 2". If set, this field
	// must be a valid UTF-8 string and no longer than 2800 characters.
	Section string `json:"section,omitempty"`
	// TeacherFolder: Information about a Drive Folder that is shared with all
	// teachers of the course. This field will only be set for teachers of the
	// course and domain administrators. Read-only.
	TeacherFolder *DriveFolder `json:"teacherFolder,omitempty"`
	// TeacherGroupEmail: The email address of a Google group containing all
	// teachers of the course. This group does not accept email and can only be
	// used for permissions. Read-only.
	TeacherGroupEmail string `json:"teacherGroupEmail,omitempty"`
	// UpdateTime: Time of the most recent update to this course. Specifying this
	// field in a course update mask results in an error. Read-only.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Course) MarshalJSON() ([]byte, error) {
	type NoMethod Course
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CourseAlias: Alternative identifier for a course. An alias uniquely
// identifies a course. It must be unique within one of the following scopes: *
// domain: A domain-scoped alias is visible to all users within the alias
// creator's domain and can be created only by a domain admin. A domain-scoped
// alias is often used when a course has an identifier external to Classroom. *
// project: A project-scoped alias is visible to any request from an
// application using the Developer Console project ID that created the alias
// and can be created by any project. A project-scoped alias is often used when
// an application has alternative identifiers. A random value can also be used
// to avoid duplicate courses in the event of transmission failures, as
// retrying a request will return `ALREADY_EXISTS` if a previous one has
// succeeded.
type CourseAlias struct {
	// Alias: Alias string. The format of the string indicates the desired alias
	// scoping. * `d:` indicates a domain-scoped alias. Example: `d:math_101` *
	// `p:` indicates a project-scoped alias. Example: `p:abc123` This field has a
	// maximum length of 256 characters.
	Alias string `json:"alias,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CourseAlias) MarshalJSON() ([]byte, error) {
	type NoMethod CourseAlias
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CourseMaterial: A material attached to a course as part of a material set.
type CourseMaterial struct {
	// DriveFile: Google Drive file attachment.
	DriveFile *DriveFile `json:"driveFile,omitempty"`
	// Form: Google Forms attachment.
	Form *Form `json:"form,omitempty"`
	// Link: Link atatchment.
	Link *Link `json:"link,omitempty"`
	// YouTubeVideo: Youtube video attachment.
	YouTubeVideo *YouTubeVideo `json:"youTubeVideo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DriveFile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DriveFile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CourseMaterial) MarshalJSON() ([]byte, error) {
	type NoMethod CourseMaterial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CourseMaterialSet: A set of materials that appears on the "About" page of
// the course. These materials might include a syllabus, schedule, or other
// background information relating to the course as a whole.
type CourseMaterialSet struct {
	// Materials: Materials attached to this set.
	Materials []*CourseMaterial `json:"materials,omitempty"`
	// Title: Title for this set.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Materials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Materials") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CourseMaterialSet) MarshalJSON() ([]byte, error) {
	type NoMethod CourseMaterialSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CourseRosterChangesInfo: Information about a `Feed` with a `feed_type` of
// `COURSE_ROSTER_CHANGES`.
type CourseRosterChangesInfo struct {
	// CourseId: The `course_id` of the course to subscribe to roster changes for.
	CourseId string `json:"courseId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CourseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CourseRosterChangesInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CourseRosterChangesInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CourseWork: Course work created by a teacher for students of the course.
type CourseWork struct {
	// AlternateLink: Absolute link to this course work in the Classroom web UI.
	// This is only populated if `state` is `PUBLISHED`. Read-only.
	AlternateLink string `json:"alternateLink,omitempty"`
	// AssigneeMode: Assignee mode of the coursework. If unspecified, the default
	// value is `ALL_STUDENTS`.
	//
	// Possible values:
	//   "ASSIGNEE_MODE_UNSPECIFIED" - No mode specified. This is never returned.
	//   "ALL_STUDENTS" - All students can see the item. This is the default state.
	//   "INDIVIDUAL_STUDENTS" - A subset of the students can see the item.
	AssigneeMode string `json:"assigneeMode,omitempty"`
	// Assignment: Assignment details. This is populated only when `work_type` is
	// `ASSIGNMENT`. Read-only.
	Assignment *Assignment `json:"assignment,omitempty"`
	// AssociatedWithDeveloper: Whether this course work item is associated with
	// the Developer Console project making the request. See CreateCourseWork for
	// more details. Read-only.
	AssociatedWithDeveloper bool `json:"associatedWithDeveloper,omitempty"`
	// CourseId: Identifier of the course. Read-only.
	CourseId string `json:"courseId,omitempty"`
	// CreationTime: Timestamp when this course work was created. Read-only.
	CreationTime string `json:"creationTime,omitempty"`
	// CreatorUserId: Identifier for the user that created the coursework.
	// Read-only.
	CreatorUserId string `json:"creatorUserId,omitempty"`
	// Description: Optional description of this course work. If set, the
	// description must be a valid UTF-8 string containing no more than 30,000
	// characters.
	Description string `json:"description,omitempty"`
	// DueDate: Optional date, in UTC, that submissions for this course work are
	// due. This must be specified if `due_time` is specified.
	DueDate *Date `json:"dueDate,omitempty"`
	// DueTime: Optional time of day, in UTC, that submissions for this course work
	// are due. This must be specified if `due_date` is specified.
	DueTime *TimeOfDay `json:"dueTime,omitempty"`
	// GradeCategory: The category that this coursework's grade contributes to.
	// Present only when a category has been chosen for the coursework. May be used
	// in calculating the overall grade. Read-only.
	GradeCategory *GradeCategory `json:"gradeCategory,omitempty"`
	// GradingPeriodId: Identifier of the grading period associated with the
	// coursework. * At creation, if unspecified, the grading period ID will be set
	// based on the `dueDate` (or `scheduledTime` if no `dueDate` is set). * To
	// indicate no association to any grading period, set this field to an empty
	// string (""). * If specified, it must match an existing grading period ID in
	// the course.
	GradingPeriodId string `json:"gradingPeriodId,omitempty"`
	// Id: Classroom-assigned identifier of this course work, unique per course.
	// Read-only.
	Id string `json:"id,omitempty"`
	// IndividualStudentsOptions: Identifiers of students with access to the
	// coursework. This field is set only if `assigneeMode` is
	// `INDIVIDUAL_STUDENTS`. If the `assigneeMode` is `INDIVIDUAL_STUDENTS`, then
	// only students specified in this field are assigned the coursework.
	IndividualStudentsOptions *IndividualStudentsOptions `json:"individualStudentsOptions,omitempty"`
	// Materials: Additional materials. CourseWork must have no more than 20
	// material items.
	Materials []*Material `json:"materials,omitempty"`
	// MaxPoints: Maximum grade for this course work. If zero or unspecified, this
	// assignment is considered ungraded. This must be a non-negative integer
	// value.
	MaxPoints float64 `json:"maxPoints,omitempty"`
	// MultipleChoiceQuestion: Multiple choice question details. For read
	// operations, this field is populated only when `work_type` is
	// `MULTIPLE_CHOICE_QUESTION`. For write operations, this field must be
	// specified when creating course work with a `work_type` of
	// `MULTIPLE_CHOICE_QUESTION`, and it must not be set otherwise.
	MultipleChoiceQuestion *MultipleChoiceQuestion `json:"multipleChoiceQuestion,omitempty"`
	// ScheduledTime: Optional timestamp when this course work is scheduled to be
	// published.
	ScheduledTime string `json:"scheduledTime,omitempty"`
	// State: Status of this course work. If unspecified, the default state is
	// `DRAFT`.
	//
	// Possible values:
	//   "COURSE_WORK_STATE_UNSPECIFIED" - No state specified. This is never
	// returned.
	//   "PUBLISHED" - Status for work that has been published. This is the default
	// state.
	//   "DRAFT" - Status for work that is not yet published. Work in this state is
	// visible only to course teachers and domain administrators.
	//   "DELETED" - Status for work that was published but is now deleted. Work in
	// this state is visible only to course teachers and domain administrators.
	// Work in this state is deleted after some time.
	State string `json:"state,omitempty"`
	// SubmissionModificationMode: Setting to determine when students are allowed
	// to modify submissions. If unspecified, the default value is
	// `MODIFIABLE_UNTIL_TURNED_IN`.
	//
	// Possible values:
	//   "SUBMISSION_MODIFICATION_MODE_UNSPECIFIED" - No modification mode
	// specified. This is never returned.
	//   "MODIFIABLE_UNTIL_TURNED_IN" - Submissions can be modified before being
	// turned in.
	//   "MODIFIABLE" - Submissions can be modified at any time.
	SubmissionModificationMode string `json:"submissionModificationMode,omitempty"`
	// Title: Title of this course work. The title must be a valid UTF-8 string
	// containing between 1 and 3000 characters.
	Title string `json:"title,omitempty"`
	// TopicId: Identifier for the topic that this coursework is associated with.
	// Must match an existing topic in the course.
	TopicId string `json:"topicId,omitempty"`
	// UpdateTime: Timestamp of the most recent change to this course work.
	// Read-only.
	UpdateTime string `json:"updateTime,omitempty"`
	// WorkType: Type of this course work. The type is set when the course work is
	// created and cannot be changed.
	//
	// Possible values:
	//   "COURSE_WORK_TYPE_UNSPECIFIED" - No work type specified. This is never
	// returned.
	//   "ASSIGNMENT" - An assignment.
	//   "SHORT_ANSWER_QUESTION" - A short answer question.
	//   "MULTIPLE_CHOICE_QUESTION" - A multiple-choice question.
	WorkType string `json:"workType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CourseWork) MarshalJSON() ([]byte, error) {
	type NoMethod CourseWork
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CourseWork) UnmarshalJSON(data []byte) error {
	type NoMethod CourseWork
	var s1 struct {
		MaxPoints gensupport.JSONFloat64 `json:"maxPoints"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxPoints = float64(s1.MaxPoints)
	return nil
}

// CourseWorkChangesInfo: Information about a `Feed` with a `feed_type` of
// `COURSE_WORK_CHANGES`.
type CourseWorkChangesInfo struct {
	// CourseId: The `course_id` of the course to subscribe to work changes for.
	CourseId string `json:"courseId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CourseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CourseWorkChangesInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CourseWorkChangesInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CourseWorkMaterial: Course work material created by a teacher for students
// of the course
type CourseWorkMaterial struct {
	// AlternateLink: Absolute link to this course work material in the Classroom
	// web UI. This is only populated if `state` is `PUBLISHED`. Read-only.
	AlternateLink string `json:"alternateLink,omitempty"`
	// AssigneeMode: Assignee mode of the course work material. If unspecified, the
	// default value is `ALL_STUDENTS`.
	//
	// Possible values:
	//   "ASSIGNEE_MODE_UNSPECIFIED" - No mode specified. This is never returned.
	//   "ALL_STUDENTS" - All students can see the item. This is the default state.
	//   "INDIVIDUAL_STUDENTS" - A subset of the students can see the item.
	AssigneeMode string `json:"assigneeMode,omitempty"`
	// CourseId: Identifier of the course. Read-only.
	CourseId string `json:"courseId,omitempty"`
	// CreationTime: Timestamp when this course work material was created.
	// Read-only.
	CreationTime string `json:"creationTime,omitempty"`
	// CreatorUserId: Identifier for the user that created the course work
	// material. Read-only.
	CreatorUserId string `json:"creatorUserId,omitempty"`
	// Description: Optional description of this course work material. The text
	// must be a valid UTF-8 string containing no more than 30,000 characters.
	Description string `json:"description,omitempty"`
	// Id: Classroom-assigned identifier of this course work material, unique per
	// course. Read-only.
	Id string `json:"id,omitempty"`
	// IndividualStudentsOptions: Identifiers of students with access to the course
	// work material. This field is set only if `assigneeMode` is
	// `INDIVIDUAL_STUDENTS`. If the `assigneeMode` is `INDIVIDUAL_STUDENTS`, then
	// only students specified in this field can see the course work material.
	IndividualStudentsOptions *IndividualStudentsOptions `json:"individualStudentsOptions,omitempty"`
	// Materials: Additional materials. A course work material must have no more
	// than 20 material items.
	Materials []*Material `json:"materials,omitempty"`
	// ScheduledTime: Optional timestamp when this course work material is
	// scheduled to be published.
	ScheduledTime string `json:"scheduledTime,omitempty"`
	// State: Status of this course work material. If unspecified, the default
	// state is `DRAFT`.
	//
	// Possible values:
	//   "COURSEWORK_MATERIAL_STATE_UNSPECIFIED" - No state specified. This is
	// never returned.
	//   "PUBLISHED" - Status for course work material that has been published.
	// This is the default state.
	//   "DRAFT" - Status for a course work material that is not yet published.
	// Course work material in this state is visible only to course teachers and
	// domain administrators.
	//   "DELETED" - Status for course work material that was published but is now
	// deleted. Course work material in this state is visible only to course
	// teachers and domain administrators. Course work material in this state is
	// deleted after some time.
	State string `json:"state,omitempty"`
	// Title: Title of this course work material. The title must be a valid UTF-8
	// string containing between 1 and 3000 characters.
	Title string `json:"title,omitempty"`
	// TopicId: Identifier for the topic that this course work material is
	// associated with. Must match an existing topic in the course.
	TopicId string `json:"topicId,omitempty"`
	// UpdateTime: Timestamp of the most recent change to this course work
	// material. Read-only.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CourseWorkMaterial) MarshalJSON() ([]byte, error) {
	type NoMethod CourseWorkMaterial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Criterion: A rubric criterion. Each criterion is a dimension on which
// performance is rated.
type Criterion struct {
	// Description: The description of the criterion.
	Description string `json:"description,omitempty"`
	// Id: The criterion ID. On creation, an ID is assigned.
	Id string `json:"id,omitempty"`
	// Levels: The list of levels within this criterion.
	Levels []*Level `json:"levels,omitempty"`
	// Title: The title of the criterion.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Criterion) MarshalJSON() ([]byte, error) {
	type NoMethod Criterion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DriveFile: Representation of a Google Drive file.
type DriveFile struct {
	// AlternateLink: URL that can be used to access the Drive item. Read-only.
	AlternateLink string `json:"alternateLink,omitempty"`
	// Id: Drive API resource ID.
	Id string `json:"id,omitempty"`
	// ThumbnailUrl: URL of a thumbnail image of the Drive item. Read-only.
	ThumbnailUrl string `json:"thumbnailUrl,omitempty"`
	// Title: Title of the Drive item. Read-only.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternateLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DriveFile) MarshalJSON() ([]byte, error) {
	type NoMethod DriveFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DriveFolder: Representation of a Google Drive folder.
type DriveFolder struct {
	// AlternateLink: URL that can be used to access the Drive folder. Read-only.
	AlternateLink string `json:"alternateLink,omitempty"`
	// Id: Drive API resource ID.
	Id string `json:"id,omitempty"`
	// Title: Title of the Drive folder. Read-only.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternateLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DriveFolder) MarshalJSON() ([]byte, error) {
	type NoMethod DriveFolder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EmbedUri: URI to be iframed after being populated with query parameters.
type EmbedUri struct {
	// Uri: Required. URI to be iframed after being populated with query
	// parameters. This must be a valid UTF-8 string containing between 1 and 1800
	// characters.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EmbedUri) MarshalJSON() ([]byte, error) {
	type NoMethod EmbedUri
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Feed: A class of notifications that an application can register to receive.
// For example: "all roster changes for a domain".
type Feed struct {
	// CourseRosterChangesInfo: Information about a `Feed` with a `feed_type` of
	// `COURSE_ROSTER_CHANGES`. This field must be specified if `feed_type` is
	// `COURSE_ROSTER_CHANGES`.
	CourseRosterChangesInfo *CourseRosterChangesInfo `json:"courseRosterChangesInfo,omitempty"`
	// CourseWorkChangesInfo: Information about a `Feed` with a `feed_type` of
	// `COURSE_WORK_CHANGES`. This field must be specified if `feed_type` is
	// `COURSE_WORK_CHANGES`.
	CourseWorkChangesInfo *CourseWorkChangesInfo `json:"courseWorkChangesInfo,omitempty"`
	// FeedType: The type of feed.
	//
	// Possible values:
	//   "FEED_TYPE_UNSPECIFIED" - Should never be returned or provided.
	//   "DOMAIN_ROSTER_CHANGES" - All roster changes for a particular domain.
	// Notifications will be generated whenever a user joins or leaves a course. No
	// notifications will be generated when an invitation is created or deleted,
	// but notifications will be generated when a user joins a course by accepting
	// an invitation.
	//   "COURSE_ROSTER_CHANGES" - All roster changes for a particular course.
	// Notifications will be generated whenever a user joins or leaves a course. No
	// notifications will be generated when an invitation is created or deleted,
	// but notifications will be generated when a user joins a course by accepting
	// an invitation.
	//   "COURSE_WORK_CHANGES" - All course work activity for a particular course.
	// Notifications will be generated when a CourseWork or StudentSubmission
	// object is created or modified. No notification will be generated when a
	// StudentSubmission object is created in connection with the creation or
	// modification of its parent CourseWork object (but a notification will be
	// generated for that CourseWork object's creation or modification).
	FeedType string `json:"feedType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CourseRosterChangesInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseRosterChangesInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Feed) MarshalJSON() ([]byte, error) {
	type NoMethod Feed
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Form: Google Forms item.
type Form struct {
	// FormUrl: URL of the form.
	FormUrl string `json:"formUrl,omitempty"`
	// ResponseUrl: URL of the form responses document. Only set if responses have
	// been recorded and only when the requesting user is an editor of the form.
	// Read-only.
	ResponseUrl string `json:"responseUrl,omitempty"`
	// ThumbnailUrl: URL of a thumbnail image of the Form. Read-only.
	ThumbnailUrl string `json:"thumbnailUrl,omitempty"`
	// Title: Title of the Form. Read-only.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FormUrl") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FormUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Form) MarshalJSON() ([]byte, error) {
	type NoMethod Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GeminiGem: Gemini Gem link.
type GeminiGem struct {
	// Id: Gems resource id.
	Id string `json:"id,omitempty"`
	// Title: Title of the Gem.
	Title string `json:"title,omitempty"`
	// Url: URL that can be used to access the Gem.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GeminiGem) MarshalJSON() ([]byte, error) {
	type NoMethod GeminiGem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GlobalPermission: Global user permission description.
type GlobalPermission struct {
	// Permission: Permission value.
	//
	// Possible values:
	//   "PERMISSION_UNSPECIFIED" - No permission is specified. This is not
	// returned and is not a valid value.
	//   "CREATE_COURSE" - User is permitted to create a course.
	Permission string `json:"permission,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permission") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permission") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlobalPermission) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalPermission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GradeCategory: Details for a grade category in a course. Coursework may have
// zero or one grade category, and the category may be used in computing the
// overall grade. See the help center article
// (https://support.google.com/edu/classroom/answer/9184995) for details.
type GradeCategory struct {
	// DefaultGradeDenominator: Default value of denominator. Only applicable when
	// grade calculation type is TOTAL_POINTS.
	DefaultGradeDenominator int64 `json:"defaultGradeDenominator,omitempty"`
	// Id: ID of the grade category.
	Id string `json:"id,omitempty"`
	// Name: Name of the grade category.
	Name string `json:"name,omitempty"`
	// Weight: The weight of the category average as part of overall average. A
	// weight of 12.34% is represented as 123400 (100% is 1,000,000). The last two
	// digits should always be zero since we use two decimal precision. Only
	// applicable when grade calculation type is WEIGHTED_CATEGORIES.
	Weight int64 `json:"weight,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultGradeDenominator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultGradeDenominator") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GradeCategory) MarshalJSON() ([]byte, error) {
	type NoMethod GradeCategory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GradeHistory: The history of each grade on this submission.
type GradeHistory struct {
	// ActorUserId: The teacher who made the grade change.
	ActorUserId string `json:"actorUserId,omitempty"`
	// GradeChangeType: The type of grade change at this time in the submission
	// grade history.
	//
	// Possible values:
	//   "UNKNOWN_GRADE_CHANGE_TYPE" - No grade change type specified. This should
	// never be returned.
	//   "DRAFT_GRADE_POINTS_EARNED_CHANGE" - A change in the numerator of the
	// draft grade.
	//   "ASSIGNED_GRADE_POINTS_EARNED_CHANGE" - A change in the numerator of the
	// assigned grade.
	//   "MAX_POINTS_CHANGE" - A change in the denominator of the grade.
	GradeChangeType string `json:"gradeChangeType,omitempty"`
	// GradeTimestamp: When the grade of the submission was changed.
	GradeTimestamp string `json:"gradeTimestamp,omitempty"`
	// MaxPoints: The denominator of the grade at this time in the submission grade
	// history.
	MaxPoints float64 `json:"maxPoints,omitempty"`
	// PointsEarned: The numerator of the grade at this time in the submission
	// grade history.
	PointsEarned float64 `json:"pointsEarned,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActorUserId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActorUserId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GradeHistory) MarshalJSON() ([]byte, error) {
	type NoMethod GradeHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GradeHistory) UnmarshalJSON(data []byte) error {
	type NoMethod GradeHistory
	var s1 struct {
		MaxPoints    gensupport.JSONFloat64 `json:"maxPoints"`
		PointsEarned gensupport.JSONFloat64 `json:"pointsEarned"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxPoints = float64(s1.MaxPoints)
	s.PointsEarned = float64(s1.PointsEarned)
	return nil
}

// GradebookSettings: The gradebook settings for a course. See the help center
// article (https://support.google.com/edu/classroom/answer/9184995) for
// details.
type GradebookSettings struct {
	// CalculationType: Indicates how the overall grade is calculated.
	//
	// Possible values:
	//   "CALCULATION_TYPE_UNSPECIFIED" - No method specified. This is never
	// returned.
	//   "TOTAL_POINTS" - Overall grade is the sum of grades divided by the sum of
	// total points regardless of category.
	//   "WEIGHTED_CATEGORIES" - Overall grade is the weighted average by category.
	CalculationType string `json:"calculationType,omitempty"`
	// DisplaySetting: Indicates who can see the overall grade..
	//
	// Possible values:
	//   "DISPLAY_SETTING_UNSPECIFIED" - No setting specified. This is never
	// returned.
	//   "SHOW_OVERALL_GRADE" - Shows overall grade in the gradebook and student
	// profile to both teachers and students.
	//   "HIDE_OVERALL_GRADE" - Does not show overall grade in the gradebook or
	// student profile.
	//   "SHOW_TEACHERS_ONLY" - Shows the overall grade to teachers in the
	// gradebook and student profile. Hides from students in their student profile.
	DisplaySetting string `json:"displaySetting,omitempty"`
	// GradeCategories: Grade categories that are available for coursework in the
	// course.
	GradeCategories []*GradeCategory `json:"gradeCategories,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CalculationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CalculationType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GradebookSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GradebookSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GradingPeriod: An individual grading period. Grading periods must not have
// overlapping date ranges and must be listed in chronological order. For
// example, if the end_date of a grading period is 2024-01-25, then the
// start_date of the next grading period must be 2024-01-26 or later. Each
// grading period must have a unique title within a course.
type GradingPeriod struct {
	// EndDate: Required. End date, in UTC, of the grading period. Inclusive.
	EndDate *Date `json:"endDate,omitempty"`
	// Id: Output only. System generated grading period ID. Read-only.
	Id string `json:"id,omitempty"`
	// StartDate: Required. Start date, in UTC, of the grading period. Inclusive.
	StartDate *Date `json:"startDate,omitempty"`
	// Title: Required. Title of the grading period. For example, “Semester 1”.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndDate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GradingPeriod) MarshalJSON() ([]byte, error) {
	type NoMethod GradingPeriod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GradingPeriodSettings: Grading period settings that include all the
// individual grading periods in a course.
type GradingPeriodSettings struct {
	// ApplyToExistingCoursework: Supports toggling the application of grading
	// periods on existing stream items. Once set, this value is persisted meaning
	// that it does not need to be set in every request to update
	// `GradingPeriodSettings`. If not previously set, the default is False.
	ApplyToExistingCoursework bool `json:"applyToExistingCoursework,omitempty"`
	// GradingPeriods: The list of grading periods in a specific course. Grading
	// periods must not have overlapping date ranges and must be listed in
	// chronological order. Each grading period must have a unique title within a
	// course.
	GradingPeriods []*GradingPeriod `json:"gradingPeriods,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApplyToExistingCoursework")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplyToExistingCoursework") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GradingPeriodSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GradingPeriodSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Guardian: Association between a student and a guardian of that student. The
// guardian may receive information about the student's course work.
type Guardian struct {
	// GuardianId: Identifier for the guardian.
	GuardianId string `json:"guardianId,omitempty"`
	// GuardianProfile: User profile for the guardian.
	GuardianProfile *UserProfile `json:"guardianProfile,omitempty"`
	// InvitedEmailAddress: The email address to which the initial guardian
	// invitation was sent. This field is only visible to domain administrators.
	InvitedEmailAddress string `json:"invitedEmailAddress,omitempty"`
	// StudentId: Identifier for the student to whom the guardian relationship
	// applies.
	StudentId string `json:"studentId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GuardianId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GuardianId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Guardian) MarshalJSON() ([]byte, error) {
	type NoMethod Guardian
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuardianInvitation: An invitation to become the guardian of a specified
// user, sent to a specified email address.
type GuardianInvitation struct {
	// CreationTime: The time that this invitation was created. Read-only.
	CreationTime string `json:"creationTime,omitempty"`
	// InvitationId: Unique identifier for this invitation. Read-only.
	InvitationId string `json:"invitationId,omitempty"`
	// InvitedEmailAddress: Email address that the invitation was sent to. This
	// field is only visible to domain administrators.
	InvitedEmailAddress string `json:"invitedEmailAddress,omitempty"`
	// State: The state that this invitation is in.
	//
	// Possible values:
	//   "GUARDIAN_INVITATION_STATE_UNSPECIFIED" - Should never be returned.
	//   "PENDING" - The invitation is active and awaiting a response.
	//   "COMPLETE" - The invitation is no longer active. It may have been
	// accepted, declined, withdrawn or it may have expired.
	State string `json:"state,omitempty"`
	// StudentId: ID of the student (in standard format)
	StudentId string `json:"studentId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuardianInvitation) MarshalJSON() ([]byte, error) {
	type NoMethod GuardianInvitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IndividualStudentsOptions: Assignee details about a coursework/announcement.
// This field is set if and only if `assigneeMode` is `INDIVIDUAL_STUDENTS`.
type IndividualStudentsOptions struct {
	// StudentIds: Identifiers for the students that have access to the
	// coursework/announcement.
	StudentIds []string `json:"studentIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StudentIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StudentIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IndividualStudentsOptions) MarshalJSON() ([]byte, error) {
	type NoMethod IndividualStudentsOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Invitation: An invitation to join a course.
type Invitation struct {
	// CourseId: Identifier of the course to invite the user to.
	CourseId string `json:"courseId,omitempty"`
	// Id: Identifier assigned by Classroom. Read-only.
	Id string `json:"id,omitempty"`
	// Role: Role to invite the user to have. Must not be
	// `COURSE_ROLE_UNSPECIFIED`.
	//
	// Possible values:
	//   "COURSE_ROLE_UNSPECIFIED" - No course role.
	//   "STUDENT" - Student in the course.
	//   "TEACHER" - Teacher of the course.
	//   "OWNER" - Owner of the course.
	Role string `json:"role,omitempty"`
	// UserId: Identifier of the invited user. When specified as a parameter of a
	// request, this identifier can be set to one of the following: * the numeric
	// identifier for the user * the email address of the user * the string literal
	// "me", indicating the requesting user
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CourseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Invitation) MarshalJSON() ([]byte, error) {
	type NoMethod Invitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Level: A level of the criterion.
type Level struct {
	// Description: The description of the level.
	Description string `json:"description,omitempty"`
	// Id: The level ID. On creation, an ID is assigned.
	Id string `json:"id,omitempty"`
	// Points: Optional points associated with this level. If set, all levels
	// within the rubric must specify points and the value must be distinct across
	// all levels within a single criterion. 0 is distinct from no points.
	Points float64 `json:"points,omitempty"`
	// Title: The title of the level. If the level has no points set, title must be
	// set.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Level) MarshalJSON() ([]byte, error) {
	type NoMethod Level
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Level) UnmarshalJSON(data []byte) error {
	type NoMethod Level
	var s1 struct {
		Points gensupport.JSONFloat64 `json:"points"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Points = float64(s1.Points)
	return nil
}

// Link: URL item.
type Link struct {
	// ThumbnailUrl: URL of a thumbnail image of the target URL. Read-only.
	ThumbnailUrl string `json:"thumbnailUrl,omitempty"`
	// Title: Title of the target of the URL. Read-only.
	Title string `json:"title,omitempty"`
	// Url: URL to link to. This must be a valid UTF-8 string containing between 1
	// and 2024 characters.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ThumbnailUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ThumbnailUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Link) MarshalJSON() ([]byte, error) {
	type NoMethod Link
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAddOnAttachmentsResponse: Response when listing add-on attachments.
type ListAddOnAttachmentsResponse struct {
	// AddOnAttachments: Attachments under the given post.
	AddOnAttachments []*AddOnAttachment `json:"addOnAttachments,omitempty"`
	// NextPageToken: A token, which can be sent as `pageToken` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AddOnAttachments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddOnAttachments") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAddOnAttachmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAddOnAttachmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAnnouncementsResponse: Response when listing course work.
type ListAnnouncementsResponse struct {
	// Announcements: Announcement items that match the request.
	Announcements []*Announcement `json:"announcements,omitempty"`
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Announcements") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Announcements") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAnnouncementsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAnnouncementsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCourseAliasesResponse: Response when listing course aliases.
type ListCourseAliasesResponse struct {
	// Aliases: The course aliases.
	Aliases []*CourseAlias `json:"aliases,omitempty"`
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Aliases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Aliases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCourseAliasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCourseAliasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCourseWorkMaterialResponse: Response when listing course work material.
type ListCourseWorkMaterialResponse struct {
	// CourseWorkMaterial: Course work material items that match the request.
	CourseWorkMaterial []*CourseWorkMaterial `json:"courseWorkMaterial,omitempty"`
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CourseWorkMaterial") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseWorkMaterial") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCourseWorkMaterialResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCourseWorkMaterialResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCourseWorkResponse: Response when listing course work.
type ListCourseWorkResponse struct {
	// CourseWork: Course work items that match the request.
	CourseWork []*CourseWork `json:"courseWork,omitempty"`
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CourseWork") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseWork") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCourseWorkResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCourseWorkResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCoursesResponse: Response when listing courses.
type ListCoursesResponse struct {
	// Courses: Courses that match the list request.
	Courses []*Course `json:"courses,omitempty"`
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Courses") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Courses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCoursesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCoursesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGuardianInvitationsResponse: Response when listing guardian invitations.
type ListGuardianInvitationsResponse struct {
	// GuardianInvitations: Guardian invitations that matched the list request.
	GuardianInvitations []*GuardianInvitation `json:"guardianInvitations,omitempty"`
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GuardianInvitations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GuardianInvitations") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGuardianInvitationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGuardianInvitationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGuardiansResponse: Response when listing guardians.
type ListGuardiansResponse struct {
	// Guardians: Guardians on this page of results that met the criteria specified
	// in the request.
	Guardians []*Guardian `json:"guardians,omitempty"`
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Guardians") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Guardians") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGuardiansResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGuardiansResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInvitationsResponse: Response when listing invitations.
type ListInvitationsResponse struct {
	// Invitations: Invitations that match the list request.
	Invitations []*Invitation `json:"invitations,omitempty"`
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Invitations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Invitations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListInvitationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInvitationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRubricsResponse: Response when listing rubrics.
type ListRubricsResponse struct {
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Rubrics: Rubrics that match the request.
	Rubrics []*Rubric `json:"rubrics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRubricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRubricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListStudentSubmissionsResponse: Response when listing student submissions.
type ListStudentSubmissionsResponse struct {
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// StudentSubmissions: Student work that matches the request.
	StudentSubmissions []*StudentSubmission `json:"studentSubmissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListStudentSubmissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListStudentSubmissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListStudentsResponse: Response when listing students.
type ListStudentsResponse struct {
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Students: Students who match the list request.
	Students []*Student `json:"students,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListStudentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListStudentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTeachersResponse: Response when listing teachers.
type ListTeachersResponse struct {
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Teachers: Teachers who match the list request.
	Teachers []*Teacher `json:"teachers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTeachersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTeachersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTopicResponse: Response when listing topics.
type ListTopicResponse struct {
	// NextPageToken: Token identifying the next page of results to return. If
	// empty, no further results are available.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Topic: Topic items that match the request.
	Topic []*Topic `json:"topic,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTopicResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTopicResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Material: Material attached to course work. When creating attachments,
// setting the `form`, `gem`, or `notebook` field is not supported.
type Material struct {
	// DriveFile: Google Drive file material.
	DriveFile *SharedDriveFile `json:"driveFile,omitempty"`
	// Form: Google Forms material. Read-only.
	Form *Form `json:"form,omitempty"`
	// Gem: Gemini Gem material. Read-only.
	Gem *GeminiGem `json:"gem,omitempty"`
	// Link: Link material. On creation, this is upgraded to a more appropriate
	// type if possible, and this is reflected in the response.
	Link *Link `json:"link,omitempty"`
	// Notebook: NotebookLM Notebook material. Read-only.
	Notebook *NotebookLmNotebook `json:"notebook,omitempty"`
	// YoutubeVideo: YouTube video material.
	YoutubeVideo *YouTubeVideo `json:"youtubeVideo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DriveFile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DriveFile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Material) MarshalJSON() ([]byte, error) {
	type NoMethod Material
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModifyAnnouncementAssigneesRequest: Request to modify assignee mode and
// options of an announcement.
type ModifyAnnouncementAssigneesRequest struct {
	// AssigneeMode: Mode of the announcement describing whether it is accessible
	// by all students or specified individual students.
	//
	// Possible values:
	//   "ASSIGNEE_MODE_UNSPECIFIED" - No mode specified. This is never returned.
	//   "ALL_STUDENTS" - All students can see the item. This is the default state.
	//   "INDIVIDUAL_STUDENTS" - A subset of the students can see the item.
	AssigneeMode string `json:"assigneeMode,omitempty"`
	// ModifyIndividualStudentsOptions: Set which students can view or cannot view
	// the announcement. Must be specified only when `assigneeMode` is
	// `INDIVIDUAL_STUDENTS`.
	ModifyIndividualStudentsOptions *ModifyIndividualStudentsOptions `json:"modifyIndividualStudentsOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssigneeMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssigneeMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyAnnouncementAssigneesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyAnnouncementAssigneesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModifyAttachmentsRequest: Request to modify the attachments of a student
// submission.
type ModifyAttachmentsRequest struct {
	// AddAttachments: Attachments to add. A student submission may not have more
	// than 20 attachments. Form attachments are not supported.
	AddAttachments []*Attachment `json:"addAttachments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddAttachments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddAttachments") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyAttachmentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyAttachmentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModifyCourseWorkAssigneesRequest: Request to modify assignee mode and
// options of a coursework.
type ModifyCourseWorkAssigneesRequest struct {
	// AssigneeMode: Mode of the coursework describing whether it will be assigned
	// to all students or specified individual students.
	//
	// Possible values:
	//   "ASSIGNEE_MODE_UNSPECIFIED" - No mode specified. This is never returned.
	//   "ALL_STUDENTS" - All students can see the item. This is the default state.
	//   "INDIVIDUAL_STUDENTS" - A subset of the students can see the item.
	AssigneeMode string `json:"assigneeMode,omitempty"`
	// ModifyIndividualStudentsOptions: Set which students are assigned or not
	// assigned to the coursework. Must be specified only when `assigneeMode` is
	// `INDIVIDUAL_STUDENTS`.
	ModifyIndividualStudentsOptions *ModifyIndividualStudentsOptions `json:"modifyIndividualStudentsOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssigneeMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssigneeMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyCourseWorkAssigneesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyCourseWorkAssigneesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModifyIndividualStudentsOptions: Contains fields to add or remove students
// from a course work or announcement where the `assigneeMode` is set to
// `INDIVIDUAL_STUDENTS`.
type ModifyIndividualStudentsOptions struct {
	// AddStudentIds: IDs of students to be added as having access to this
	// coursework/announcement.
	AddStudentIds []string `json:"addStudentIds,omitempty"`
	// RemoveStudentIds: IDs of students to be removed from having access to this
	// coursework/announcement.
	RemoveStudentIds []string `json:"removeStudentIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddStudentIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddStudentIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyIndividualStudentsOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyIndividualStudentsOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MultipleChoiceQuestion: Additional details for multiple-choice questions.
type MultipleChoiceQuestion struct {
	// Choices: Possible choices.
	Choices []string `json:"choices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Choices") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Choices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MultipleChoiceQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod MultipleChoiceQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MultipleChoiceSubmission: Student work for a multiple-choice question.
type MultipleChoiceSubmission struct {
	// Answer: Student's select choice.
	Answer string `json:"answer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MultipleChoiceSubmission) MarshalJSON() ([]byte, error) {
	type NoMethod MultipleChoiceSubmission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Name: Details of the user's name.
type Name struct {
	// FamilyName: The user's last name. Read-only.
	FamilyName string `json:"familyName,omitempty"`
	// FullName: The user's full name formed by concatenating the first and last
	// name values. Read-only.
	FullName string `json:"fullName,omitempty"`
	// GivenName: The user's first name. Read-only.
	GivenName string `json:"givenName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FamilyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FamilyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Name) MarshalJSON() ([]byte, error) {
	type NoMethod Name
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NotebookLmNotebook: NotebookLM Notebook link.
type NotebookLmNotebook struct {
	// Id: Notebook resource id.
	Id string `json:"id,omitempty"`
	// Title: Title of the Notebook.
	Title string `json:"title,omitempty"`
	// Url: URL that can be used to access the Notebook.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NotebookLmNotebook) MarshalJSON() ([]byte, error) {
	type NoMethod NotebookLmNotebook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReclaimStudentSubmissionRequest: Request to reclaim a student submission.
type ReclaimStudentSubmissionRequest struct {
}

// Registration: An instruction to Classroom to send notifications from the
// `feed` to the provided destination.
type Registration struct {
	// CloudPubsubTopic: The Cloud Pub/Sub topic that notifications are to be sent
	// to.
	CloudPubsubTopic *CloudPubsubTopic `json:"cloudPubsubTopic,omitempty"`
	// ExpiryTime: The time until which the `Registration` is effective. This is a
	// read-only field assigned by the server.
	ExpiryTime string `json:"expiryTime,omitempty"`
	// Feed: Specification for the class of notifications that Classroom should
	// deliver to the destination.
	Feed *Feed `json:"feed,omitempty"`
	// RegistrationId: A server-generated unique identifier for this
	// `Registration`. Read-only.
	RegistrationId string `json:"registrationId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CloudPubsubTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudPubsubTopic") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Registration) MarshalJSON() ([]byte, error) {
	type NoMethod Registration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReturnStudentSubmissionRequest: Request to return a student submission.
type ReturnStudentSubmissionRequest struct {
}

// Rubric: The rubric of the course work. A rubric is a scoring guide used to
// evaluate student work and give feedback. For further details, see Rubrics
// structure and known limitations (/classroom/rubrics/limitations).
type Rubric struct {
	// CourseId: Identifier of the course. Read-only.
	CourseId string `json:"courseId,omitempty"`
	// CourseWorkId: Identifier for the course work this corresponds to. Read-only.
	CourseWorkId string `json:"courseWorkId,omitempty"`
	// CreationTime: Output only. Timestamp when this rubric was created.
	// Read-only.
	CreationTime string `json:"creationTime,omitempty"`
	// Criteria: List of criteria. Each criterion is a dimension on which
	// performance is rated.
	Criteria []*Criterion `json:"criteria,omitempty"`
	// Id: Classroom-assigned identifier for the rubric. This is unique among
	// rubrics for the relevant course work. Read-only.
	Id string `json:"id,omitempty"`
	// SourceSpreadsheetId: Input only. Immutable. Google Sheets ID of the
	// spreadsheet. This spreadsheet must contain formatted rubric settings. See
	// Create or reuse a rubric for an assignment
	// (https://support.google.com/edu/classroom/answer/9335069). Use of this field
	// requires the `https://www.googleapis.com/auth/spreadsheets.readonly` or
	// `https://www.googleapis.com/auth/spreadsheets` scope.
	SourceSpreadsheetId string `json:"sourceSpreadsheetId,omitempty"`
	// UpdateTime: Output only. Timestamp of the most recent change to this rubric.
	// Read-only.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CourseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Rubric) MarshalJSON() ([]byte, error) {
	type NoMethod Rubric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RubricGrade: A rubric grade set for the student submission. There is at most
// one entry per rubric criterion.
type RubricGrade struct {
	// CriterionId: Optional. Criterion ID.
	CriterionId string `json:"criterionId,omitempty"`
	// LevelId: Optional. Optional level ID of the selected level. If empty, no
	// level was selected.
	LevelId string `json:"levelId,omitempty"`
	// Points: Optional. Optional points assigned for this criterion, typically
	// based on the level. Levels might or might not have points. If unset, no
	// points were set for this criterion.
	Points float64 `json:"points,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CriterionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CriterionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RubricGrade) MarshalJSON() ([]byte, error) {
	type NoMethod RubricGrade
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *RubricGrade) UnmarshalJSON(data []byte) error {
	type NoMethod RubricGrade
	var s1 struct {
		Points gensupport.JSONFloat64 `json:"points"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Points = float64(s1.Points)
	return nil
}

// SharedDriveFile: Drive file that is used as material for course work.
type SharedDriveFile struct {
	// DriveFile: Drive file details.
	DriveFile *DriveFile `json:"driveFile,omitempty"`
	// ShareMode: Mechanism by which students access the Drive item.
	//
	// Possible values:
	//   "UNKNOWN_SHARE_MODE" - No sharing mode specified. This should never be
	// returned.
	//   "VIEW" - Students can view the shared file.
	//   "EDIT" - Students can edit the shared file.
	//   "STUDENT_COPY" - Students have a personal copy of the shared file.
	ShareMode string `json:"shareMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DriveFile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DriveFile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SharedDriveFile) MarshalJSON() ([]byte, error) {
	type NoMethod SharedDriveFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShortAnswerSubmission: Student work for a short answer question.
type ShortAnswerSubmission struct {
	// Answer: Student response to a short-answer question.
	Answer string `json:"answer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShortAnswerSubmission) MarshalJSON() ([]byte, error) {
	type NoMethod ShortAnswerSubmission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StateHistory: The history of each state this submission has been in.
type StateHistory struct {
	// ActorUserId: The teacher or student who made the change.
	ActorUserId string `json:"actorUserId,omitempty"`
	// State: The workflow pipeline stage.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - No state specified. This should never be returned.
	//   "CREATED" - The Submission has been created.
	//   "TURNED_IN" - The student has turned in an assigned document, which may or
	// may not be a template.
	//   "RETURNED" - The teacher has returned the assigned document to the
	// student.
	//   "RECLAIMED_BY_STUDENT" - The student turned in the assigned document, and
	// then chose to "unsubmit" the assignment, giving the student control again as
	// the owner.
	//   "STUDENT_EDITED_AFTER_TURN_IN" - The student edited their submission after
	// turning it in. Currently, only used by Questions, when the student edits
	// their answer.
	State string `json:"state,omitempty"`
	// StateTimestamp: When the submission entered this state.
	StateTimestamp string `json:"stateTimestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActorUserId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActorUserId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StateHistory) MarshalJSON() ([]byte, error) {
	type NoMethod StateHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Student: Student in a course.
type Student struct {
	// CourseId: Identifier of the course. Read-only.
	CourseId string `json:"courseId,omitempty"`
	// Profile: Global user information for the student. Read-only.
	Profile *UserProfile `json:"profile,omitempty"`
	// StudentWorkFolder: Information about a Drive Folder for this student's work
	// in this course. Only visible to the student and domain administrators.
	// Read-only.
	StudentWorkFolder *DriveFolder `json:"studentWorkFolder,omitempty"`
	// UserId: Identifier of the user. When specified as a parameter of a request,
	// this identifier can be one of the following: * the numeric identifier for
	// the user * the email address of the user * the string literal "me",
	// indicating the requesting user
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CourseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Student) MarshalJSON() ([]byte, error) {
	type NoMethod Student
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StudentContext: Role-specific context if the requesting user is a student.
type StudentContext struct {
	// SubmissionId: Requesting user's submission id to be used for grade passback
	// and to identify the student when showing student work to the teacher. This
	// is set exactly when `supportsStudentWork` is `true`.
	SubmissionId string `json:"submissionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SubmissionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SubmissionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StudentContext) MarshalJSON() ([]byte, error) {
	type NoMethod StudentContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StudentSubmission: Student submission for course work. `StudentSubmission`
// items are generated when a `CourseWork` item is created. Student submissions
// that have never been accessed (i.e. with `state` = NEW) may not have a
// creation time or update time.
type StudentSubmission struct {
	// AlternateLink: Absolute link to the submission in the Classroom web UI.
	// Read-only.
	AlternateLink string `json:"alternateLink,omitempty"`
	// AssignedGrade: Optional grade. If unset, no grade was set. This value must
	// be non-negative. Decimal (that is, non-integer) values are allowed, but are
	// rounded to two decimal places. This may be modified only by course teachers.
	AssignedGrade float64 `json:"assignedGrade,omitempty"`
	// AssignedRubricGrades: Assigned rubric grades based on the rubric's Criteria.
	// This map is empty if there is no rubric attached to this course work or if a
	// rubric is attached, but no grades have been set on any Criteria. Entries are
	// only populated for grades that have been set. Key: The rubric's criterion
	// ID. Read-only.
	AssignedRubricGrades map[string]RubricGrade `json:"assignedRubricGrades,omitempty"`
	// AssignmentSubmission: Submission content when course_work_type is
	// ASSIGNMENT. Students can modify this content using ModifyAttachments.
	AssignmentSubmission *AssignmentSubmission `json:"assignmentSubmission,omitempty"`
	// AssociatedWithDeveloper: Whether this student submission is associated with
	// the Developer Console project making the request. See CreateCourseWork for
	// more details. Read-only.
	AssociatedWithDeveloper bool `json:"associatedWithDeveloper,omitempty"`
	// CourseId: Identifier of the course. Read-only.
	CourseId string `json:"courseId,omitempty"`
	// CourseWorkId: Identifier for the course work this corresponds to. Read-only.
	CourseWorkId string `json:"courseWorkId,omitempty"`
	// CourseWorkType: Type of course work this submission is for. Read-only.
	//
	// Possible values:
	//   "COURSE_WORK_TYPE_UNSPECIFIED" - No work type specified. This is never
	// returned.
	//   "ASSIGNMENT" - An assignment.
	//   "SHORT_ANSWER_QUESTION" - A short answer question.
	//   "MULTIPLE_CHOICE_QUESTION" - A multiple-choice question.
	CourseWorkType string `json:"courseWorkType,omitempty"`
	// CreationTime: Creation time of this submission. This may be unset if the
	// student has not accessed this item. Read-only.
	CreationTime string `json:"creationTime,omitempty"`
	// DraftGrade: Optional pending grade. If unset, no grade was set. This value
	// must be non-negative. Decimal (that is, non-integer) values are allowed, but
	// are rounded to two decimal places. This is only visible to and modifiable by
	// course teachers.
	DraftGrade float64 `json:"draftGrade,omitempty"`
	// DraftRubricGrades: Pending rubric grades based on the rubric's criteria.
	// This map is empty if there is no rubric attached to this course work or if a
	// rubric is attached, but no grades have been set on any criteria. Entries are
	// only populated for grades that have been set. Key: The rubric's criterion
	// ID. Read-only.
	DraftRubricGrades map[string]RubricGrade `json:"draftRubricGrades,omitempty"`
	// Id: Classroom-assigned Identifier for the student submission. This is unique
	// among submissions for the relevant course work. Read-only.
	Id string `json:"id,omitempty"`
	// Late: Whether this submission is late. Read-only.
	Late bool `json:"late,omitempty"`
	// MultipleChoiceSubmission: Submission content when course_work_type is
	// MULTIPLE_CHOICE_QUESTION.
	MultipleChoiceSubmission *MultipleChoiceSubmission `json:"multipleChoiceSubmission,omitempty"`
	// ShortAnswerSubmission: Submission content when course_work_type is
	// SHORT_ANSWER_QUESTION.
	ShortAnswerSubmission *ShortAnswerSubmission `json:"shortAnswerSubmission,omitempty"`
	// State: State of this submission. Read-only.
	//
	// Possible values:
	//   "SUBMISSION_STATE_UNSPECIFIED" - No state specified. This should never be
	// returned.
	//   "NEW" - The student has never accessed this submission. Attachments are
	// not returned and timestamps is not set.
	//   "CREATED" - Has been created.
	//   "TURNED_IN" - Has been turned in to the teacher.
	//   "RETURNED" - Has been returned to the student.
	//   "RECLAIMED_BY_STUDENT" - Student chose to "unsubmit" the assignment.
	State string `json:"state,omitempty"`
	// SubmissionHistory: The history of the submission (includes state and grade
	// histories). Read-only.
	SubmissionHistory []*SubmissionHistory `json:"submissionHistory,omitempty"`
	// UpdateTime: Last update time of this submission. This may be unset if the
	// student has not accessed this item. Read-only.
	UpdateTime string `json:"updateTime,omitempty"`
	// UserId: Identifier for the student that owns this submission. Read-only.
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StudentSubmission) MarshalJSON() ([]byte, error) {
	type NoMethod StudentSubmission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *StudentSubmission) UnmarshalJSON(data []byte) error {
	type NoMethod StudentSubmission
	var s1 struct {
		AssignedGrade gensupport.JSONFloat64 `json:"assignedGrade"`
		DraftGrade    gensupport.JSONFloat64 `json:"draftGrade"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AssignedGrade = float64(s1.AssignedGrade)
	s.DraftGrade = float64(s1.DraftGrade)
	return nil
}

// SubmissionHistory: The history of the submission. This currently includes
// state and grade histories.
type SubmissionHistory struct {
	// GradeHistory: The grade history information of the submission, if present.
	GradeHistory *GradeHistory `json:"gradeHistory,omitempty"`
	// StateHistory: The state history information of the submission, if present.
	StateHistory *StateHistory `json:"stateHistory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GradeHistory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GradeHistory") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SubmissionHistory) MarshalJSON() ([]byte, error) {
	type NoMethod SubmissionHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Teacher: Teacher of a course.
type Teacher struct {
	// CourseId: Identifier of the course. Read-only.
	CourseId string `json:"courseId,omitempty"`
	// Profile: Global user information for the teacher. Read-only.
	Profile *UserProfile `json:"profile,omitempty"`
	// UserId: Identifier of the user. When specified as a parameter of a request,
	// this identifier can be one of the following: * the numeric identifier for
	// the user * the email address of the user * the string literal "me",
	// indicating the requesting user
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CourseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Teacher) MarshalJSON() ([]byte, error) {
	type NoMethod Teacher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TeacherContext: Role-specific context if the requesting user is a teacher.
type TeacherContext struct {
}

// TimeOfDay: Represents a time of day. The date and time zone are either not
// significant or are specified elsewhere. An API may choose to allow leap
// seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
type TimeOfDay struct {
	// Hours: Hours of a day in 24 hour format. Must be greater than or equal to 0
	// and typically must be less than or equal to 23. An API may choose to allow
	// the value "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of an hour. Must be greater than or equal to 0 and less
	// than or equal to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
	// to 0 and less than or equal to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of a minute. Must be greater than or equal to 0 and
	// typically must be less than or equal to 59. An API may allow the value 60 if
	// it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod TimeOfDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Topic: Topic created by a teacher for the course
type Topic struct {
	// CourseId: Identifier of the course. Read-only.
	CourseId string `json:"courseId,omitempty"`
	// Name: The name of the topic, generated by the user. Leading and trailing
	// whitespaces, if any, are trimmed. Also, multiple consecutive whitespaces are
	// collapsed into one inside the name. The result must be a non-empty string.
	// Topic names are case sensitive, and must be no longer than 100 characters.
	Name string `json:"name,omitempty"`
	// TopicId: Unique identifier for the topic. Read-only.
	TopicId string `json:"topicId,omitempty"`
	// UpdateTime: The time the topic was last updated by the system. Read-only.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CourseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CourseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Topic) MarshalJSON() ([]byte, error) {
	type NoMethod Topic
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TurnInStudentSubmissionRequest: Request to turn in a student submission.
type TurnInStudentSubmissionRequest struct {
}

// UserProfile: Global information for a user.
type UserProfile struct {
	// EmailAddress: Email address of the user. Must request
	// `https://www.googleapis.com/auth/classroom.profile.emails` scope for this
	// field to be populated in a response body. Read-only.
	EmailAddress string `json:"emailAddress,omitempty"`
	// Id: Identifier of the user. Read-only.
	Id string `json:"id,omitempty"`
	// Name: Name of the user. Read-only.
	Name *Name `json:"name,omitempty"`
	// Permissions: Global permissions of the user. Read-only.
	Permissions []*GlobalPermission `json:"permissions,omitempty"`
	// PhotoUrl: URL of user's profile photo. Must request
	// `https://www.googleapis.com/auth/classroom.profile.photos` scope for this
	// field to be populated in a response body. Read-only.
	PhotoUrl string `json:"photoUrl,omitempty"`
	// VerifiedTeacher: Represents whether a Google Workspace for Education user's
	// domain administrator has explicitly verified them as being a teacher. This
	// field is always false if the user is not a member of a Google Workspace for
	// Education domain. Read-only
	VerifiedTeacher bool `json:"verifiedTeacher,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserProfile) MarshalJSON() ([]byte, error) {
	type NoMethod UserProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// YouTubeVideo: YouTube video item.
type YouTubeVideo struct {
	// AlternateLink: URL that can be used to view the YouTube video. Read-only.
	AlternateLink string `json:"alternateLink,omitempty"`
	// Id: YouTube API resource ID.
	Id string `json:"id,omitempty"`
	// ThumbnailUrl: URL of a thumbnail image of the YouTube video. Read-only.
	ThumbnailUrl string `json:"thumbnailUrl,omitempty"`
	// Title: Title of the YouTube video. Read-only.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternateLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s YouTubeVideo) MarshalJSON() ([]byte, error) {
	type NoMethod YouTubeVideo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CoursesCreateCall struct {
	s          *Service
	course     *Course
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a course. The user specified in `ownerId` is the owner of
// the created course and added as a teacher. A non-admin requesting user can
// only create a course with themselves as the owner. Domain admins can create
// courses owned by any user within their domain. This method returns the
// following error codes: * `PERMISSION_DENIED` if the requesting user is not
// permitted to create courses or for access errors. * `NOT_FOUND` if the
// primary teacher is not a valid user. * `FAILED_PRECONDITION` if the course
// owner's account is disabled or for the following request errors: *
// UserCannotOwnCourse * UserGroupsMembershipLimitReached *
// CourseTitleCannotContainUrl * `ALREADY_EXISTS` if an alias was specified in
// the `id` and already exists.
func (r *CoursesService) Create(course *Course) *CoursesCreateCall {
	c := &CoursesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.course = course
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCreateCall) Fields(s ...googleapi.Field) *CoursesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCreateCall) Context(ctx context.Context) *CoursesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.course)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Course.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCreateCall) Do(opts ...googleapi.CallOption) (*Course, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Course{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesDeleteCall struct {
	s          *Service
	id         string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a course. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not permitted to delete the
// requested course or for access errors. * `NOT_FOUND` if no course exists
// with the requested ID.
//
//   - id: Identifier of the course to delete. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesService) Delete(id string) *CoursesDeleteCall {
	c := &CoursesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesDeleteCall) Fields(s ...googleapi.Field) *CoursesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesDeleteCall) Context(ctx context.Context) *CoursesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"id": c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesGetCall struct {
	s            *Service
	id           string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a course. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not permitted to access the
// requested course or for access errors. * `NOT_FOUND` if no course exists
// with the requested ID.
//
//   - id: Identifier of the course to return. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesService) Get(id string) *CoursesGetCall {
	c := &CoursesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesGetCall) Fields(s ...googleapi.Field) *CoursesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesGetCall) IfNoneMatch(entityTag string) *CoursesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesGetCall) Context(ctx context.Context) *CoursesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"id": c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Course.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesGetCall) Do(opts ...googleapi.CallOption) (*Course, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Course{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesGetGradingPeriodSettingsCall struct {
	s            *Service
	courseId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetGradingPeriodSettings: Returns the grading period settings in a course.
// This method returns the following error codes: * `PERMISSION_DENIED` if the
// requesting user isn't permitted to access the grading period settings in the
// requested course or for access errors. * `NOT_FOUND` if the requested course
// does not exist.
//
// - courseId: The identifier of the course.
func (r *CoursesService) GetGradingPeriodSettings(courseId string) *CoursesGetGradingPeriodSettingsCall {
	c := &CoursesGetGradingPeriodSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesGetGradingPeriodSettingsCall) Fields(s ...googleapi.Field) *CoursesGetGradingPeriodSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesGetGradingPeriodSettingsCall) IfNoneMatch(entityTag string) *CoursesGetGradingPeriodSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesGetGradingPeriodSettingsCall) Context(ctx context.Context) *CoursesGetGradingPeriodSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesGetGradingPeriodSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesGetGradingPeriodSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/gradingPeriodSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.getGradingPeriodSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.getGradingPeriodSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GradingPeriodSettings.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesGetGradingPeriodSettingsCall) Do(opts ...googleapi.CallOption) (*GradingPeriodSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GradingPeriodSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.getGradingPeriodSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of courses that the requesting user is permitted to
// view, restricted to those that match the request. Returned courses are
// ordered by creation time, with the most recently created coming first. This
// method returns the following error codes: * `PERMISSION_DENIED` for access
// errors. * `INVALID_ARGUMENT` if the query argument is malformed. *
// `NOT_FOUND` if any users specified in the query arguments do not exist.
func (r *CoursesService) List() *CoursesListCall {
	c := &CoursesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// CourseStates sets the optional parameter "courseStates": Restricts returned
// courses to those in one of the specified states The default value is ACTIVE,
// ARCHIVED, PROVISIONED, DECLINED.
//
// Possible values:
//
//	"COURSE_STATE_UNSPECIFIED" - No course state. No returned Course message
//
// will use this value.
//
//	"ACTIVE" - The course is active.
//	"ARCHIVED" - The course has been archived. You cannot modify it except to
//
// change it to a different state.
//
//	"PROVISIONED" - The course has been created, but not yet activated. It is
//
// accessible by the primary teacher and domain administrators, who may modify
// it or change it to the `ACTIVE` or `DECLINED` states. A course may only be
// changed to `PROVISIONED` if it is in the `DECLINED` state.
//
//	"DECLINED" - The course has been created, but declined. It is accessible
//
// by the course owner and domain administrators, though it will not be
// displayed in the web UI. You cannot modify the course except to change it to
// the `PROVISIONED` state. A course may only be changed to `DECLINED` if it is
// in the `PROVISIONED` state.
//
//	"SUSPENDED" - The course has been suspended. You cannot modify the course,
//
// and only the user identified by the `owner_id` can view the course. A course
// may be placed in this state if it potentially violates the Terms of Service.
func (c *CoursesListCall) CourseStates(courseStates ...string) *CoursesListCall {
	c.urlParams_.SetMulti("courseStates", append([]string{}, courseStates...))
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *CoursesListCall) PageSize(pageSize int64) *CoursesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesListCall) PageToken(pageToken string) *CoursesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// StudentId sets the optional parameter "studentId": Restricts returned
// courses to those having a student with the specified identifier. The
// identifier can be one of the following: * the numeric identifier for the
// user * the email address of the user * the string literal "me", indicating
// the requesting user
func (c *CoursesListCall) StudentId(studentId string) *CoursesListCall {
	c.urlParams_.Set("studentId", studentId)
	return c
}

// TeacherId sets the optional parameter "teacherId": Restricts returned
// courses to those having a teacher with the specified identifier. The
// identifier can be one of the following: * the numeric identifier for the
// user * the email address of the user * the string literal "me", indicating
// the requesting user
func (c *CoursesListCall) TeacherId(teacherId string) *CoursesListCall {
	c.urlParams_.Set("teacherId", teacherId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesListCall) Fields(s ...googleapi.Field) *CoursesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesListCall) IfNoneMatch(entityTag string) *CoursesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesListCall) Context(ctx context.Context) *CoursesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCoursesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesListCall) Do(opts ...googleapi.CallOption) (*ListCoursesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCoursesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesListCall) Pages(ctx context.Context, f func(*ListCoursesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesPatchCall struct {
	s          *Service
	id         string
	course     *Course
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates one or more fields in a course. This method returns the
// following error codes: * `PERMISSION_DENIED` if the requesting user is not
// permitted to modify the requested course or for access errors. * `NOT_FOUND`
// if no course exists with the requested ID. * `INVALID_ARGUMENT` if invalid
// fields are specified in the update mask or if no update mask is supplied. *
// `FAILED_PRECONDITION` for the following request errors: *
// CourseNotModifiable * InactiveCourseOwner * IneligibleOwner *
// CourseTitleCannotContainUrl
//
//   - id: Identifier of the course to update. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesService) Patch(id string, course *Course) *CoursesPatchCall {
	c := &CoursesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.id = id
	c.course = course
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the course to update. This field is required to do an
// update. The update will fail if invalid fields are specified. The following
// fields are valid: * `courseState` * `description` * `descriptionHeading` *
// `name` * `ownerId` * `room` * `section` * `subject` Note: patches to ownerId
// are treated as being effective immediately, but in practice it may take some
// time for the ownership transfer of all affected resources to complete. When
// set in a query parameter, this field should be specified as
// `updateMask=,,...`
func (c *CoursesPatchCall) UpdateMask(updateMask string) *CoursesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPatchCall) Fields(s ...googleapi.Field) *CoursesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPatchCall) Context(ctx context.Context) *CoursesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.course)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"id": c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Course.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesPatchCall) Do(opts ...googleapi.CallOption) (*Course, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Course{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesUpdateCall struct {
	s          *Service
	id         string
	course     *Course
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a course. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not permitted to modify the
// requested course or for access errors. * `NOT_FOUND` if no course exists
// with the requested ID. * `FAILED_PRECONDITION` for the following request
// errors: * CourseNotModifiable * CourseTitleCannotContainUrl
//
//   - id: Identifier of the course to update. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesService) Update(id string, course *Course) *CoursesUpdateCall {
	c := &CoursesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.id = id
	c.course = course
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesUpdateCall) Fields(s ...googleapi.Field) *CoursesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesUpdateCall) Context(ctx context.Context) *CoursesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.course)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"id": c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Course.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesUpdateCall) Do(opts ...googleapi.CallOption) (*Course, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Course{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesUpdateGradingPeriodSettingsCall struct {
	s                     *Service
	courseId              string
	gradingperiodsettings *GradingPeriodSettings
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// UpdateGradingPeriodSettings: Updates grading period settings of a course.
// Individual grading periods can be added, removed, or modified using this
// method. The requesting user and course owner must be eligible to modify
// Grading Periods. For details, see licensing requirements
// (https://developers.google.com/workspace/classroom/grading-periods/manage-grading-periods#licensing_requirements).
// This method returns the following error codes: * `PERMISSION_DENIED` if the
// requesting user is not permitted to modify the grading period settings in a
// course or for access errors: * UserIneligibleToUpdateGradingPeriodSettings *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if the
// requested course does not exist.
//
// - courseId: The identifier of the course.
func (r *CoursesService) UpdateGradingPeriodSettings(courseId string, gradingperiodsettings *GradingPeriodSettings) *CoursesUpdateGradingPeriodSettingsCall {
	c := &CoursesUpdateGradingPeriodSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.gradingperiodsettings = gradingperiodsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields in the GradingPeriodSettings to update. The
// GradingPeriodSettings `grading_periods` list will be fully replaced by the
// grading periods specified in the update request. For example: * Grading
// periods included in the list without an ID are considered additions, and a
// new ID will be assigned when the request is made. * Grading periods that
// currently exist, but are missing from the request will be considered
// deletions. * Grading periods with an existing ID and modified data are
// considered edits. Unmodified data will be left as is. * Grading periods
// included with an unknown ID will result in an error. The following fields
// may be specified: * `grading_periods` * `apply_to_existing_coursework`
func (c *CoursesUpdateGradingPeriodSettingsCall) UpdateMask(updateMask string) *CoursesUpdateGradingPeriodSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesUpdateGradingPeriodSettingsCall) Fields(s ...googleapi.Field) *CoursesUpdateGradingPeriodSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesUpdateGradingPeriodSettingsCall) Context(ctx context.Context) *CoursesUpdateGradingPeriodSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesUpdateGradingPeriodSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesUpdateGradingPeriodSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.gradingperiodsettings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/gradingPeriodSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.updateGradingPeriodSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.updateGradingPeriodSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GradingPeriodSettings.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesUpdateGradingPeriodSettingsCall) Do(opts ...googleapi.CallOption) (*GradingPeriodSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GradingPeriodSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.updateGradingPeriodSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAliasesCreateCall struct {
	s           *Service
	courseId    string
	coursealias *CourseAlias
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates an alias for a course. This method returns the following
// error codes: * `PERMISSION_DENIED` if the requesting user is not permitted
// to create the alias or for access errors. * `NOT_FOUND` if the course does
// not exist. * `ALREADY_EXISTS` if the alias already exists. *
// `FAILED_PRECONDITION` if the alias requested does not make sense for the
// requesting user or course (for example, if a user not in a domain attempts
// to access a domain-scoped alias).
//
//   - courseId: Identifier of the course to alias. This identifier can be either
//     the Classroom-assigned identifier or an alias.
func (r *CoursesAliasesService) Create(courseId string, coursealias *CourseAlias) *CoursesAliasesCreateCall {
	c := &CoursesAliasesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.coursealias = coursealias
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAliasesCreateCall) Fields(s ...googleapi.Field) *CoursesAliasesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAliasesCreateCall) Context(ctx context.Context) *CoursesAliasesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAliasesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAliasesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.coursealias)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/aliases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.aliases.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.aliases.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *CourseAlias.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAliasesCreateCall) Do(opts ...googleapi.CallOption) (*CourseAlias, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CourseAlias{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.aliases.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAliasesDeleteCall struct {
	s          *Service
	courseId   string
	aliasid    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an alias of a course. This method returns the following
// error codes: * `PERMISSION_DENIED` if the requesting user is not permitted
// to remove the alias or for access errors. * `NOT_FOUND` if the alias does
// not exist. * `FAILED_PRECONDITION` if the alias requested does not make
// sense for the requesting user or course (for example, if a user not in a
// domain attempts to delete a domain-scoped alias).
//
//   - alias: Alias to delete. This may not be the Classroom-assigned identifier.
//   - courseId: Identifier of the course whose alias should be deleted. This
//     identifier can be either the Classroom-assigned identifier or an alias.
func (r *CoursesAliasesService) Delete(courseId string, aliasid string) *CoursesAliasesDeleteCall {
	c := &CoursesAliasesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.aliasid = aliasid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAliasesDeleteCall) Fields(s ...googleapi.Field) *CoursesAliasesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAliasesDeleteCall) Context(ctx context.Context) *CoursesAliasesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAliasesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAliasesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/aliases/{alias}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"alias":    c.aliasid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.aliases.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.aliases.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAliasesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.aliases.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAliasesListCall struct {
	s            *Service
	courseId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of aliases for a course. This method returns the
// following error codes: * `PERMISSION_DENIED` if the requesting user is not
// permitted to access the course or for access errors. * `NOT_FOUND` if the
// course does not exist.
//
//   - courseId: The identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesAliasesService) List(courseId string) *CoursesAliasesListCall {
	c := &CoursesAliasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *CoursesAliasesListCall) PageSize(pageSize int64) *CoursesAliasesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesAliasesListCall) PageToken(pageToken string) *CoursesAliasesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAliasesListCall) Fields(s ...googleapi.Field) *CoursesAliasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesAliasesListCall) IfNoneMatch(entityTag string) *CoursesAliasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAliasesListCall) Context(ctx context.Context) *CoursesAliasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAliasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAliasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/aliases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.aliases.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.aliases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCourseAliasesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesAliasesListCall) Do(opts ...googleapi.CallOption) (*ListCourseAliasesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCourseAliasesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.aliases.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesAliasesListCall) Pages(ctx context.Context, f func(*ListCourseAliasesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesAnnouncementsCreateCall struct {
	s            *Service
	courseId     string
	announcement *Announcement
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates an announcement. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting user is not permitted to
// access the requested course, create announcements in the requested course,
// share a Drive attachment, or for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if the requested course does not exist.
// * `FAILED_PRECONDITION` for the following request error: *
// AttachmentNotVisible
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesAnnouncementsService) Create(courseId string, announcement *Announcement) *CoursesAnnouncementsCreateCall {
	c := &CoursesAnnouncementsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.announcement = announcement
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsCreateCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsCreateCall) Context(ctx context.Context) *CoursesAnnouncementsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.announcement)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Announcement.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAnnouncementsCreateCall) Do(opts ...googleapi.CallOption) (*Announcement, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Announcement{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsDeleteCall struct {
	s          *Service
	courseId   string
	id         string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an announcement. This request must be made by the Developer
// Console project of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding announcement item. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting developer project did not
// create the corresponding announcement, if the requesting user is not
// permitted to delete the requested course or for access errors. *
// `FAILED_PRECONDITION` if the requested announcement has already been
// deleted. * `NOT_FOUND` if no course exists with the requested ID.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the announcement to delete. This identifier is a
//     Classroom-assigned identifier.
func (r *CoursesAnnouncementsService) Delete(courseId string, id string) *CoursesAnnouncementsDeleteCall {
	c := &CoursesAnnouncementsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsDeleteCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsDeleteCall) Context(ctx context.Context) *CoursesAnnouncementsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAnnouncementsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsGetCall struct {
	s            *Service
	courseId     string
	id           string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns an announcement. This method returns the following error codes:
// * `PERMISSION_DENIED` if the requesting user is not permitted to access the
// requested course or announcement, or for access errors. * `INVALID_ARGUMENT`
// if the request is malformed. * `NOT_FOUND` if the requested course or
// announcement does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the announcement.
func (r *CoursesAnnouncementsService) Get(courseId string, id string) *CoursesAnnouncementsGetCall {
	c := &CoursesAnnouncementsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsGetCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesAnnouncementsGetCall) IfNoneMatch(entityTag string) *CoursesAnnouncementsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsGetCall) Context(ctx context.Context) *CoursesAnnouncementsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Announcement.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAnnouncementsGetCall) Do(opts ...googleapi.CallOption) (*Announcement, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Announcement{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsGetAddOnContextCall struct {
	s            *Service
	courseId     string
	itemId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAddOnContext: Gets metadata for Classroom add-ons in the context of a
// specific post. To maintain the integrity of its own data and permissions
// model, an add-on should call this to validate query parameters and the
// requesting user's role whenever the add-on is opened in an iframe
// (https://developers.google.com/workspace/classroom/add-ons/get-started/iframes/iframes-overview).
// This method returns the following error codes: * `PERMISSION_DENIED` for
// access errors. * `INVALID_ARGUMENT` if the request is malformed. *
// `NOT_FOUND` if one of the identified resources does not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesAnnouncementsService) GetAddOnContext(courseId string, itemId string) *CoursesAnnouncementsGetAddOnContextCall {
	c := &CoursesAnnouncementsGetAddOnContextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	return c
}

// AddOnToken sets the optional parameter "addOnToken": Token that authorizes
// the request. The token is passed as a query parameter when the user is
// redirected from Classroom to the add-on's URL. The authorization token is
// required when neither of the following is true: * The add-on has attachments
// on the post. * The developer project issuing the request is the same project
// that created the post.
func (c *CoursesAnnouncementsGetAddOnContextCall) AddOnToken(addOnToken string) *CoursesAnnouncementsGetAddOnContextCall {
	c.urlParams_.Set("addOnToken", addOnToken)
	return c
}

// AttachmentId sets the optional parameter "attachmentId": The identifier of
// the attachment. This field is required for all requests except when the user
// is in the Attachment Discovery iframe
// (https://developers.google.com/workspace/classroom/add-ons/get-started/iframes/attachment-discovery-iframe).
func (c *CoursesAnnouncementsGetAddOnContextCall) AttachmentId(attachmentId string) *CoursesAnnouncementsGetAddOnContextCall {
	c.urlParams_.Set("attachmentId", attachmentId)
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesAnnouncementsGetAddOnContextCall) PostId(postId string) *CoursesAnnouncementsGetAddOnContextCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsGetAddOnContextCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsGetAddOnContextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesAnnouncementsGetAddOnContextCall) IfNoneMatch(entityTag string) *CoursesAnnouncementsGetAddOnContextCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsGetAddOnContextCall) Context(ctx context.Context) *CoursesAnnouncementsGetAddOnContextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsGetAddOnContextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsGetAddOnContextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{itemId}/addOnContext")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.getAddOnContext", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.getAddOnContext" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnContext.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAnnouncementsGetAddOnContextCall) Do(opts ...googleapi.CallOption) (*AddOnContext, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnContext{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.getAddOnContext", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsListCall struct {
	s            *Service
	courseId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of announcements that the requester is permitted to
// view. Course students may only view `PUBLISHED` announcements. Course
// teachers and domain administrators may view all announcements. This method
// returns the following error codes: * `PERMISSION_DENIED` if the requesting
// user is not permitted to access the requested course or for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if the
// requested course does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesAnnouncementsService) List(courseId string) *CoursesAnnouncementsListCall {
	c := &CoursesAnnouncementsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	return c
}

// AnnouncementStates sets the optional parameter "announcementStates":
// Restriction on the `state` of announcements returned. If this argument is
// left unspecified, the default value is `PUBLISHED`.
//
// Possible values:
//
//	"ANNOUNCEMENT_STATE_UNSPECIFIED" - No state specified. This is never
//
// returned.
//
//	"PUBLISHED" - Status for announcement that has been published. This is the
//
// default state.
//
//	"DRAFT" - Status for an announcement that is not yet published.
//
// Announcement in this state is visible only to course teachers and domain
// administrators.
//
//	"DELETED" - Status for announcement that was published but is now deleted.
//
// Announcement in this state is visible only to course teachers and domain
// administrators. Announcement in this state is deleted after some time.
func (c *CoursesAnnouncementsListCall) AnnouncementStates(announcementStates ...string) *CoursesAnnouncementsListCall {
	c.urlParams_.SetMulti("announcementStates", append([]string{}, announcementStates...))
	return c
}

// OrderBy sets the optional parameter "orderBy": Optional sort ordering for
// results. A comma-separated list of fields with an optional sort direction
// keyword. Supported field is `updateTime`. Supported direction keywords are
// `asc` and `desc`. If not specified, `updateTime desc` is the default
// behavior. Examples: `updateTime asc`, `updateTime`
func (c *CoursesAnnouncementsListCall) OrderBy(orderBy string) *CoursesAnnouncementsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *CoursesAnnouncementsListCall) PageSize(pageSize int64) *CoursesAnnouncementsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesAnnouncementsListCall) PageToken(pageToken string) *CoursesAnnouncementsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsListCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesAnnouncementsListCall) IfNoneMatch(entityTag string) *CoursesAnnouncementsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsListCall) Context(ctx context.Context) *CoursesAnnouncementsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAnnouncementsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesAnnouncementsListCall) Do(opts ...googleapi.CallOption) (*ListAnnouncementsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAnnouncementsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesAnnouncementsListCall) Pages(ctx context.Context, f func(*ListAnnouncementsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesAnnouncementsModifyAssigneesCall struct {
	s                                  *Service
	courseId                           string
	id                                 string
	modifyannouncementassigneesrequest *ModifyAnnouncementAssigneesRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// ModifyAssignees: Modifies assignee mode and options of an announcement. Only
// a teacher of the course that contains the announcement may call this method.
// This method returns the following error codes: * `PERMISSION_DENIED` if the
// requesting user is not permitted to access the requested course or course
// work or for access errors. * `INVALID_ARGUMENT` if the request is malformed.
// * `NOT_FOUND` if the requested course or course work does not exist. *
// `FAILED_PRECONDITION` for the following request error: * EmptyAssignees
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the announcement.
func (r *CoursesAnnouncementsService) ModifyAssignees(courseId string, id string, modifyannouncementassigneesrequest *ModifyAnnouncementAssigneesRequest) *CoursesAnnouncementsModifyAssigneesCall {
	c := &CoursesAnnouncementsModifyAssigneesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	c.modifyannouncementassigneesrequest = modifyannouncementassigneesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsModifyAssigneesCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsModifyAssigneesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsModifyAssigneesCall) Context(ctx context.Context) *CoursesAnnouncementsModifyAssigneesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsModifyAssigneesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsModifyAssigneesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.modifyannouncementassigneesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{id}:modifyAssignees")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.modifyAssignees", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.modifyAssignees" call.
// Any non-2xx status code is an error. Response headers are in either
// *Announcement.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAnnouncementsModifyAssigneesCall) Do(opts ...googleapi.CallOption) (*Announcement, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Announcement{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.modifyAssignees", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsPatchCall struct {
	s            *Service
	courseId     string
	id           string
	announcement *Announcement
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates one or more fields of an announcement. This method returns
// the following error codes: * `PERMISSION_DENIED` if the requesting developer
// project did not create the corresponding announcement or for access errors.
// * `INVALID_ARGUMENT` if the request is malformed. * `FAILED_PRECONDITION` if
// the requested announcement has already been deleted. * `NOT_FOUND` if the
// requested course or announcement does not exist
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the announcement.
func (r *CoursesAnnouncementsService) Patch(courseId string, id string, announcement *Announcement) *CoursesAnnouncementsPatchCall {
	c := &CoursesAnnouncementsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	c.announcement = announcement
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the announcement to update. This field is required to do an
// update. The update fails if invalid fields are specified. If a field
// supports empty values, it can be cleared by specifying it in the update mask
// and not in the Announcement object. If a field that does not support empty
// values is included in the update mask and not set in the Announcement
// object, an `INVALID_ARGUMENT` error is returned. The following fields may be
// specified by teachers: * `text` * `state` * `scheduled_time`
func (c *CoursesAnnouncementsPatchCall) UpdateMask(updateMask string) *CoursesAnnouncementsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsPatchCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsPatchCall) Context(ctx context.Context) *CoursesAnnouncementsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.announcement)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Announcement.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAnnouncementsPatchCall) Do(opts ...googleapi.CallOption) (*Announcement, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Announcement{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsAddOnAttachmentsCreateCall struct {
	s               *Service
	courseId        string
	itemId          string
	addonattachment *AddOnAttachment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates an add-on attachment under a post. Requires the add-on to
// have permission to create new attachments on the post. This method returns
// the following error codes: * `PERMISSION_DENIED` for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of the
// identified resources does not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which to create the attachment. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesAnnouncementsAddOnAttachmentsService) Create(courseId string, itemId string, addonattachment *AddOnAttachment) *CoursesAnnouncementsAddOnAttachmentsCreateCall {
	c := &CoursesAnnouncementsAddOnAttachmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.addonattachment = addonattachment
	return c
}

// AddOnToken sets the optional parameter "addOnToken": Token that authorizes
// the request. The token is passed as a query parameter when the user is
// redirected from Classroom to the add-on's URL. This authorization token is
// required for in-Classroom attachment creation but optional for partner-first
// attachment creation. Returns an error if not provided for partner-first
// attachment creation and the developer projects that created the attachment
// and its parent stream item do not match.
func (c *CoursesAnnouncementsAddOnAttachmentsCreateCall) AddOnToken(addOnToken string) *CoursesAnnouncementsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("addOnToken", addOnToken)
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesAnnouncementsAddOnAttachmentsCreateCall) PostId(postId string) *CoursesAnnouncementsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsAddOnAttachmentsCreateCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsAddOnAttachmentsCreateCall) Context(ctx context.Context) *CoursesAnnouncementsAddOnAttachmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsAddOnAttachmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsAddOnAttachmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{itemId}/addOnAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.addOnAttachments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesAnnouncementsAddOnAttachmentsCreateCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsAddOnAttachmentsDeleteCall struct {
	s            *Service
	courseId     string
	itemId       string
	attachmentId string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes an add-on attachment. Requires the add-on to have been the
// original creator of the attachment. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
//   - attachmentId: Identifier of the attachment.
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesAnnouncementsAddOnAttachmentsService) Delete(courseId string, itemId string, attachmentId string) *CoursesAnnouncementsAddOnAttachmentsDeleteCall {
	c := &CoursesAnnouncementsAddOnAttachmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesAnnouncementsAddOnAttachmentsDeleteCall) PostId(postId string) *CoursesAnnouncementsAddOnAttachmentsDeleteCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsAddOnAttachmentsDeleteCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsAddOnAttachmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsAddOnAttachmentsDeleteCall) Context(ctx context.Context) *CoursesAnnouncementsAddOnAttachmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsAddOnAttachmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsAddOnAttachmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.addOnAttachments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesAnnouncementsAddOnAttachmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsAddOnAttachmentsGetCall struct {
	s            *Service
	courseId     string
	itemId       string
	attachmentId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns an add-on attachment. Requires the add-on requesting the
// attachment to be the original creator of the attachment. This method returns
// the following error codes: * `PERMISSION_DENIED` for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of the
// identified resources does not exist.
//
//   - attachmentId: Identifier of the attachment.
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesAnnouncementsAddOnAttachmentsService) Get(courseId string, itemId string, attachmentId string) *CoursesAnnouncementsAddOnAttachmentsGetCall {
	c := &CoursesAnnouncementsAddOnAttachmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesAnnouncementsAddOnAttachmentsGetCall) PostId(postId string) *CoursesAnnouncementsAddOnAttachmentsGetCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsAddOnAttachmentsGetCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsAddOnAttachmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesAnnouncementsAddOnAttachmentsGetCall) IfNoneMatch(entityTag string) *CoursesAnnouncementsAddOnAttachmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsAddOnAttachmentsGetCall) Context(ctx context.Context) *CoursesAnnouncementsAddOnAttachmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsAddOnAttachmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsAddOnAttachmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.addOnAttachments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesAnnouncementsAddOnAttachmentsGetCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesAnnouncementsAddOnAttachmentsListCall struct {
	s            *Service
	courseId     string
	itemId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all attachments created by an add-on under the post. Requires
// the add-on to have active attachments on the post or have permission to
// create new attachments on the post. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` whose attachments should be enumerated. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesAnnouncementsAddOnAttachmentsService) List(courseId string, itemId string) *CoursesAnnouncementsAddOnAttachmentsListCall {
	c := &CoursesAnnouncementsAddOnAttachmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// attachments to return. The service may return fewer than this value. If
// unspecified, at most 20 attachments will be returned. The maximum value is
// 20; values above 20 will be coerced to 20.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) PageSize(pageSize int64) *CoursesAnnouncementsAddOnAttachmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAddOnAttachments` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListAddOnAttachments` must match the call that provided the page token.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) PageToken(pageToken string) *CoursesAnnouncementsAddOnAttachmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// PostId sets the optional parameter "postId": Identifier of the post under
// the course whose attachments to enumerate. Deprecated, use `item_id`
// instead.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) PostId(postId string) *CoursesAnnouncementsAddOnAttachmentsListCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsAddOnAttachmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) IfNoneMatch(entityTag string) *CoursesAnnouncementsAddOnAttachmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) Context(ctx context.Context) *CoursesAnnouncementsAddOnAttachmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsAddOnAttachmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{itemId}/addOnAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.addOnAttachments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAddOnAttachmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) Do(opts ...googleapi.CallOption) (*ListAddOnAttachmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAddOnAttachmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesAnnouncementsAddOnAttachmentsListCall) Pages(ctx context.Context, f func(*ListAddOnAttachmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesAnnouncementsAddOnAttachmentsPatchCall struct {
	s               *Service
	courseId        string
	itemId          string
	attachmentId    string
	addonattachment *AddOnAttachment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates an add-on attachment. Requires the add-on to have been the
// original creator of the attachment. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
// - attachmentId: Identifier of the attachment.
// - courseId: Identifier of the course.
// - itemId: Identifier of the post under which the attachment is attached.
func (r *CoursesAnnouncementsAddOnAttachmentsService) Patch(courseId string, itemId string, attachmentId string, addonattachment *AddOnAttachment) *CoursesAnnouncementsAddOnAttachmentsPatchCall {
	c := &CoursesAnnouncementsAddOnAttachmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	c.addonattachment = addonattachment
	return c
}

// PostId sets the optional parameter "postId": Required. Identifier of the
// post under which the attachment is attached.
func (c *CoursesAnnouncementsAddOnAttachmentsPatchCall) PostId(postId string) *CoursesAnnouncementsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask that
// identifies which fields on the attachment to update. The update fails if
// invalid fields are specified. If a field supports empty values, it can be
// cleared by specifying it in the update mask and not in the `AddOnAttachment`
// object. If a field that does not support empty values is included in the
// update mask and not set in the `AddOnAttachment` object, an
// `INVALID_ARGUMENT` error is returned. The following fields may be specified
// by teachers: * `title` * `teacher_view_uri` * `student_view_uri` *
// `student_work_review_uri` * `due_date` * `due_time` * `max_points`
func (c *CoursesAnnouncementsAddOnAttachmentsPatchCall) UpdateMask(updateMask string) *CoursesAnnouncementsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesAnnouncementsAddOnAttachmentsPatchCall) Fields(s ...googleapi.Field) *CoursesAnnouncementsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesAnnouncementsAddOnAttachmentsPatchCall) Context(ctx context.Context) *CoursesAnnouncementsAddOnAttachmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesAnnouncementsAddOnAttachmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesAnnouncementsAddOnAttachmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/announcements/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.announcements.addOnAttachments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesAnnouncementsAddOnAttachmentsPatchCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.announcements.addOnAttachments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkCreateCall struct {
	s          *Service
	courseId   string
	coursework *CourseWork
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates course work. The resulting course work (and corresponding
// student submissions) are associated with the Developer Console project of
// the OAuth client ID (https://support.google.com/cloud/answer/6158849) used
// to make the request. Classroom API requests to modify course work and
// student submissions must be made with an OAuth client ID from the associated
// Developer Console project. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not permitted to access the
// requested course, create course work in the requested course, share a Drive
// attachment, or for access errors. * `INVALID_ARGUMENT` if the request is
// malformed. * `NOT_FOUND` if the requested course does not exist. *
// `FAILED_PRECONDITION` for the following request error: *
// AttachmentNotVisible
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesCourseWorkService) Create(courseId string, coursework *CourseWork) *CoursesCourseWorkCreateCall {
	c := &CoursesCourseWorkCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.coursework = coursework
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkCreateCall) Fields(s ...googleapi.Field) *CoursesCourseWorkCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkCreateCall) Context(ctx context.Context) *CoursesCourseWorkCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.coursework)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *CourseWork.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkCreateCall) Do(opts ...googleapi.CallOption) (*CourseWork, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CourseWork{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkDeleteCall struct {
	s          *Service
	courseId   string
	id         string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a course work. This request must be made by the Developer
// Console project of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding course work item. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting developer project did not
// create the corresponding course work, if the requesting user is not
// permitted to delete the requested course or for access errors. *
// `FAILED_PRECONDITION` if the requested course work has already been deleted.
// * `NOT_FOUND` if no course exists with the requested ID.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the course work to delete. This identifier is a
//     Classroom-assigned identifier.
func (r *CoursesCourseWorkService) Delete(courseId string, id string) *CoursesCourseWorkDeleteCall {
	c := &CoursesCourseWorkDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkDeleteCall) Fields(s ...googleapi.Field) *CoursesCourseWorkDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkDeleteCall) Context(ctx context.Context) *CoursesCourseWorkDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkGetCall struct {
	s            *Service
	courseId     string
	id           string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns course work. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not permitted to access the
// requested course or course work, or for access errors. * `INVALID_ARGUMENT`
// if the request is malformed. * `NOT_FOUND` if the requested course or course
// work does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the course work.
func (r *CoursesCourseWorkService) Get(courseId string, id string) *CoursesCourseWorkGetCall {
	c := &CoursesCourseWorkGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkGetCall) Fields(s ...googleapi.Field) *CoursesCourseWorkGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkGetCall) IfNoneMatch(entityTag string) *CoursesCourseWorkGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkGetCall) Context(ctx context.Context) *CoursesCourseWorkGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CourseWork.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkGetCall) Do(opts ...googleapi.CallOption) (*CourseWork, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CourseWork{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkGetAddOnContextCall struct {
	s            *Service
	courseId     string
	itemId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAddOnContext: Gets metadata for Classroom add-ons in the context of a
// specific post. To maintain the integrity of its own data and permissions
// model, an add-on should call this to validate query parameters and the
// requesting user's role whenever the add-on is opened in an iframe
// (https://developers.google.com/workspace/classroom/add-ons/get-started/iframes/iframes-overview).
// This method returns the following error codes: * `PERMISSION_DENIED` for
// access errors. * `INVALID_ARGUMENT` if the request is malformed. *
// `NOT_FOUND` if one of the identified resources does not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkService) GetAddOnContext(courseId string, itemId string) *CoursesCourseWorkGetAddOnContextCall {
	c := &CoursesCourseWorkGetAddOnContextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	return c
}

// AddOnToken sets the optional parameter "addOnToken": Token that authorizes
// the request. The token is passed as a query parameter when the user is
// redirected from Classroom to the add-on's URL. The authorization token is
// required when neither of the following is true: * The add-on has attachments
// on the post. * The developer project issuing the request is the same project
// that created the post.
func (c *CoursesCourseWorkGetAddOnContextCall) AddOnToken(addOnToken string) *CoursesCourseWorkGetAddOnContextCall {
	c.urlParams_.Set("addOnToken", addOnToken)
	return c
}

// AttachmentId sets the optional parameter "attachmentId": The identifier of
// the attachment. This field is required for all requests except when the user
// is in the Attachment Discovery iframe
// (https://developers.google.com/workspace/classroom/add-ons/get-started/iframes/attachment-discovery-iframe).
func (c *CoursesCourseWorkGetAddOnContextCall) AttachmentId(attachmentId string) *CoursesCourseWorkGetAddOnContextCall {
	c.urlParams_.Set("attachmentId", attachmentId)
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkGetAddOnContextCall) PostId(postId string) *CoursesCourseWorkGetAddOnContextCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkGetAddOnContextCall) Fields(s ...googleapi.Field) *CoursesCourseWorkGetAddOnContextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkGetAddOnContextCall) IfNoneMatch(entityTag string) *CoursesCourseWorkGetAddOnContextCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkGetAddOnContextCall) Context(ctx context.Context) *CoursesCourseWorkGetAddOnContextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkGetAddOnContextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkGetAddOnContextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{itemId}/addOnContext")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.getAddOnContext", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.getAddOnContext" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnContext.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkGetAddOnContextCall) Do(opts ...googleapi.CallOption) (*AddOnContext, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnContext{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.getAddOnContext", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkListCall struct {
	s            *Service
	courseId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of course work that the requester is permitted to view.
// Course students may only view `PUBLISHED` course work. Course teachers and
// domain administrators may view all course work. This method returns the
// following error codes: * `PERMISSION_DENIED` if the requesting user is not
// permitted to access the requested course or for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if the
// requested course does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesCourseWorkService) List(courseId string) *CoursesCourseWorkListCall {
	c := &CoursesCourseWorkListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	return c
}

// CourseWorkStates sets the optional parameter "courseWorkStates": Restriction
// on the work status to return. Only courseWork that matches is returned. If
// unspecified, items with a work status of `PUBLISHED` is returned.
//
// Possible values:
//
//	"COURSE_WORK_STATE_UNSPECIFIED" - No state specified. This is never
//
// returned.
//
//	"PUBLISHED" - Status for work that has been published. This is the default
//
// state.
//
//	"DRAFT" - Status for work that is not yet published. Work in this state is
//
// visible only to course teachers and domain administrators.
//
//	"DELETED" - Status for work that was published but is now deleted. Work in
//
// this state is visible only to course teachers and domain administrators.
// Work in this state is deleted after some time.
func (c *CoursesCourseWorkListCall) CourseWorkStates(courseWorkStates ...string) *CoursesCourseWorkListCall {
	c.urlParams_.SetMulti("courseWorkStates", append([]string{}, courseWorkStates...))
	return c
}

// OrderBy sets the optional parameter "orderBy": Optional sort ordering for
// results. A comma-separated list of fields with an optional sort direction
// keyword. Supported fields are `updateTime` and `dueDate`. Supported
// direction keywords are `asc` and `desc`. If not specified, `updateTime desc`
// is the default behavior. Examples: `dueDate asc,updateTime desc`,
// `updateTime,dueDate desc`
func (c *CoursesCourseWorkListCall) OrderBy(orderBy string) *CoursesCourseWorkListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *CoursesCourseWorkListCall) PageSize(pageSize int64) *CoursesCourseWorkListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesCourseWorkListCall) PageToken(pageToken string) *CoursesCourseWorkListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkListCall) Fields(s ...googleapi.Field) *CoursesCourseWorkListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkListCall) IfNoneMatch(entityTag string) *CoursesCourseWorkListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkListCall) Context(ctx context.Context) *CoursesCourseWorkListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCourseWorkResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkListCall) Do(opts ...googleapi.CallOption) (*ListCourseWorkResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCourseWorkResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesCourseWorkListCall) Pages(ctx context.Context, f func(*ListCourseWorkResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesCourseWorkModifyAssigneesCall struct {
	s                                *Service
	courseId                         string
	id                               string
	modifycourseworkassigneesrequest *ModifyCourseWorkAssigneesRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// ModifyAssignees: Modifies assignee mode and options of a coursework. Only a
// teacher of the course that contains the coursework may call this method.
// This method returns the following error codes: * `PERMISSION_DENIED` if the
// requesting user is not permitted to access the requested course or course
// work or for access errors. * `INVALID_ARGUMENT` if the request is malformed.
// * `NOT_FOUND` if the requested course or course work does not exist. *
// `FAILED_PRECONDITION` for the following request error: * EmptyAssignees
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the coursework.
func (r *CoursesCourseWorkService) ModifyAssignees(courseId string, id string, modifycourseworkassigneesrequest *ModifyCourseWorkAssigneesRequest) *CoursesCourseWorkModifyAssigneesCall {
	c := &CoursesCourseWorkModifyAssigneesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	c.modifycourseworkassigneesrequest = modifycourseworkassigneesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkModifyAssigneesCall) Fields(s ...googleapi.Field) *CoursesCourseWorkModifyAssigneesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkModifyAssigneesCall) Context(ctx context.Context) *CoursesCourseWorkModifyAssigneesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkModifyAssigneesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkModifyAssigneesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.modifycourseworkassigneesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{id}:modifyAssignees")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.modifyAssignees", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.modifyAssignees" call.
// Any non-2xx status code is an error. Response headers are in either
// *CourseWork.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkModifyAssigneesCall) Do(opts ...googleapi.CallOption) (*CourseWork, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CourseWork{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.modifyAssignees", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkPatchCall struct {
	s          *Service
	courseId   string
	id         string
	coursework *CourseWork
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates one or more fields of a course work. See
// google.classroom.v1.CourseWork for details of which fields may be updated
// and who may change them. This request must be made by the Developer Console
// project of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding course work item. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting developer project did not
// create the corresponding course work, if the user is not permitted to make
// the requested modification to the student submission, or for access errors.
// * `INVALID_ARGUMENT` if the request is malformed. * `FAILED_PRECONDITION` if
// the requested course work has already been deleted. * `NOT_FOUND` if the
// requested course or course work does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the course work.
func (r *CoursesCourseWorkService) Patch(courseId string, id string, coursework *CourseWork) *CoursesCourseWorkPatchCall {
	c := &CoursesCourseWorkPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	c.coursework = coursework
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the course work to update. This field is required to do an
// update. The update fails if invalid fields are specified. If a field
// supports empty values, it can be cleared by specifying it in the update mask
// and not in the `CourseWork` object. If a field that does not support empty
// values is included in the update mask and not set in the `CourseWork`
// object, an `INVALID_ARGUMENT` error is returned. The following fields may be
// specified by teachers: * `title` * `description` * `state` * `due_date` *
// `due_time` * `max_points` * `scheduled_time` *
// `submission_modification_mode` * `topic_id` * `grading_period_id`
func (c *CoursesCourseWorkPatchCall) UpdateMask(updateMask string) *CoursesCourseWorkPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkPatchCall) Fields(s ...googleapi.Field) *CoursesCourseWorkPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkPatchCall) Context(ctx context.Context) *CoursesCourseWorkPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.coursework)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *CourseWork.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkPatchCall) Do(opts ...googleapi.CallOption) (*CourseWork, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CourseWork{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkUpdateRubricCall struct {
	s            *Service
	courseId     string
	courseWorkId string
	rubric       *Rubric
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// UpdateRubric: Updates a rubric. See google.classroom.v1.Rubric for details
// of which fields can be updated. Rubric update capabilities are limited
// (/classroom/rubrics/limitations) once grading has started. The requesting
// user and course owner must have rubrics creation capabilities. For details,
// see licensing requirements
// (https://developers.google.com/workspace/classroom/rubrics/limitations#license-requirements).
// This request must be made by the Google Cloud console of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the parent
// course work item. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting developer project didn't create the
// corresponding course work, if the user isn't permitted to make the requested
// modification to the rubric, or for access errors. This error code is also
// returned if grading has already started on the rubric. * `INVALID_ARGUMENT`
// if the request is malformed and for the following request error: *
// `RubricCriteriaInvalidFormat` * `NOT_FOUND` if the requested course, course
// work, or rubric doesn't exist or if the user doesn't have access to the
// corresponding course work. * `INTERNAL` if grading has already started on
// the rubric.
//
// - courseId: Identifier of the course.
// - courseWorkId: Identifier of the course work.
func (r *CoursesCourseWorkService) UpdateRubric(courseId string, courseWorkId string, rubric *Rubric) *CoursesCourseWorkUpdateRubricCall {
	c := &CoursesCourseWorkUpdateRubricCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.rubric = rubric
	return c
}

// Id sets the optional parameter "id": Identifier of the rubric.
func (c *CoursesCourseWorkUpdateRubricCall) Id(id string) *CoursesCourseWorkUpdateRubricCall {
	c.urlParams_.Set("id", id)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the rubric to update. This field is required to do an
// update. The update fails if invalid fields are specified. There are multiple
// options to define the criteria of a rubric: the `source_spreadsheet_id` and
// the `criteria` list. Only one of these can be used at a time to define a
// rubric. The rubric `criteria` list is fully replaced by the rubric criteria
// specified in the update request. For example, if a criterion or level is
// missing from the request, it is deleted. New criteria and levels are added
// and an ID is assigned. Existing criteria and levels retain the previously
// assigned ID if the ID is specified in the request. The following fields can
// be specified by teachers: * `criteria` * `source_spreadsheet_id`
func (c *CoursesCourseWorkUpdateRubricCall) UpdateMask(updateMask string) *CoursesCourseWorkUpdateRubricCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkUpdateRubricCall) Fields(s ...googleapi.Field) *CoursesCourseWorkUpdateRubricCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkUpdateRubricCall) Context(ctx context.Context) *CoursesCourseWorkUpdateRubricCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkUpdateRubricCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkUpdateRubricCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rubric)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/rubric")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.updateRubric", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.updateRubric" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rubric.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkUpdateRubricCall) Do(opts ...googleapi.CallOption) (*Rubric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rubric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.updateRubric", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkAddOnAttachmentsCreateCall struct {
	s               *Service
	courseId        string
	itemId          string
	addonattachment *AddOnAttachment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates an add-on attachment under a post. Requires the add-on to
// have permission to create new attachments on the post. This method returns
// the following error codes: * `PERMISSION_DENIED` for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of the
// identified resources does not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which to create the attachment. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkAddOnAttachmentsService) Create(courseId string, itemId string, addonattachment *AddOnAttachment) *CoursesCourseWorkAddOnAttachmentsCreateCall {
	c := &CoursesCourseWorkAddOnAttachmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.addonattachment = addonattachment
	return c
}

// AddOnToken sets the optional parameter "addOnToken": Token that authorizes
// the request. The token is passed as a query parameter when the user is
// redirected from Classroom to the add-on's URL. This authorization token is
// required for in-Classroom attachment creation but optional for partner-first
// attachment creation. Returns an error if not provided for partner-first
// attachment creation and the developer projects that created the attachment
// and its parent stream item do not match.
func (c *CoursesCourseWorkAddOnAttachmentsCreateCall) AddOnToken(addOnToken string) *CoursesCourseWorkAddOnAttachmentsCreateCall {
	c.urlParams_.Set("addOnToken", addOnToken)
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkAddOnAttachmentsCreateCall) PostId(postId string) *CoursesCourseWorkAddOnAttachmentsCreateCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkAddOnAttachmentsCreateCall) Fields(s ...googleapi.Field) *CoursesCourseWorkAddOnAttachmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkAddOnAttachmentsCreateCall) Context(ctx context.Context) *CoursesCourseWorkAddOnAttachmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkAddOnAttachmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkAddOnAttachmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{itemId}/addOnAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.addOnAttachments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkAddOnAttachmentsCreateCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkAddOnAttachmentsDeleteCall struct {
	s            *Service
	courseId     string
	itemId       string
	attachmentId string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes an add-on attachment. Requires the add-on to have been the
// original creator of the attachment. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
//   - attachmentId: Identifier of the attachment.
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkAddOnAttachmentsService) Delete(courseId string, itemId string, attachmentId string) *CoursesCourseWorkAddOnAttachmentsDeleteCall {
	c := &CoursesCourseWorkAddOnAttachmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkAddOnAttachmentsDeleteCall) PostId(postId string) *CoursesCourseWorkAddOnAttachmentsDeleteCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkAddOnAttachmentsDeleteCall) Fields(s ...googleapi.Field) *CoursesCourseWorkAddOnAttachmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkAddOnAttachmentsDeleteCall) Context(ctx context.Context) *CoursesCourseWorkAddOnAttachmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkAddOnAttachmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkAddOnAttachmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.addOnAttachments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkAddOnAttachmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkAddOnAttachmentsGetCall struct {
	s            *Service
	courseId     string
	itemId       string
	attachmentId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns an add-on attachment. Requires the add-on requesting the
// attachment to be the original creator of the attachment. This method returns
// the following error codes: * `PERMISSION_DENIED` for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of the
// identified resources does not exist.
//
//   - attachmentId: Identifier of the attachment.
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkAddOnAttachmentsService) Get(courseId string, itemId string, attachmentId string) *CoursesCourseWorkAddOnAttachmentsGetCall {
	c := &CoursesCourseWorkAddOnAttachmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkAddOnAttachmentsGetCall) PostId(postId string) *CoursesCourseWorkAddOnAttachmentsGetCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkAddOnAttachmentsGetCall) Fields(s ...googleapi.Field) *CoursesCourseWorkAddOnAttachmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkAddOnAttachmentsGetCall) IfNoneMatch(entityTag string) *CoursesCourseWorkAddOnAttachmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkAddOnAttachmentsGetCall) Context(ctx context.Context) *CoursesCourseWorkAddOnAttachmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkAddOnAttachmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkAddOnAttachmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.addOnAttachments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkAddOnAttachmentsGetCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkAddOnAttachmentsListCall struct {
	s            *Service
	courseId     string
	itemId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all attachments created by an add-on under the post. Requires
// the add-on to have active attachments on the post or have permission to
// create new attachments on the post. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` whose attachments should be enumerated. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkAddOnAttachmentsService) List(courseId string, itemId string) *CoursesCourseWorkAddOnAttachmentsListCall {
	c := &CoursesCourseWorkAddOnAttachmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// attachments to return. The service may return fewer than this value. If
// unspecified, at most 20 attachments will be returned. The maximum value is
// 20; values above 20 will be coerced to 20.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) PageSize(pageSize int64) *CoursesCourseWorkAddOnAttachmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAddOnAttachments` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListAddOnAttachments` must match the call that provided the page token.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) PageToken(pageToken string) *CoursesCourseWorkAddOnAttachmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// PostId sets the optional parameter "postId": Identifier of the post under
// the course whose attachments to enumerate. Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) PostId(postId string) *CoursesCourseWorkAddOnAttachmentsListCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) Fields(s ...googleapi.Field) *CoursesCourseWorkAddOnAttachmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) IfNoneMatch(entityTag string) *CoursesCourseWorkAddOnAttachmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) Context(ctx context.Context) *CoursesCourseWorkAddOnAttachmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkAddOnAttachmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{itemId}/addOnAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.addOnAttachments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAddOnAttachmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) Do(opts ...googleapi.CallOption) (*ListAddOnAttachmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAddOnAttachmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesCourseWorkAddOnAttachmentsListCall) Pages(ctx context.Context, f func(*ListAddOnAttachmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesCourseWorkAddOnAttachmentsPatchCall struct {
	s               *Service
	courseId        string
	itemId          string
	attachmentId    string
	addonattachment *AddOnAttachment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates an add-on attachment. Requires the add-on to have been the
// original creator of the attachment. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
// - attachmentId: Identifier of the attachment.
// - courseId: Identifier of the course.
// - itemId: Identifier of the post under which the attachment is attached.
func (r *CoursesCourseWorkAddOnAttachmentsService) Patch(courseId string, itemId string, attachmentId string, addonattachment *AddOnAttachment) *CoursesCourseWorkAddOnAttachmentsPatchCall {
	c := &CoursesCourseWorkAddOnAttachmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	c.addonattachment = addonattachment
	return c
}

// PostId sets the optional parameter "postId": Required. Identifier of the
// post under which the attachment is attached.
func (c *CoursesCourseWorkAddOnAttachmentsPatchCall) PostId(postId string) *CoursesCourseWorkAddOnAttachmentsPatchCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask that
// identifies which fields on the attachment to update. The update fails if
// invalid fields are specified. If a field supports empty values, it can be
// cleared by specifying it in the update mask and not in the `AddOnAttachment`
// object. If a field that does not support empty values is included in the
// update mask and not set in the `AddOnAttachment` object, an
// `INVALID_ARGUMENT` error is returned. The following fields may be specified
// by teachers: * `title` * `teacher_view_uri` * `student_view_uri` *
// `student_work_review_uri` * `due_date` * `due_time` * `max_points`
func (c *CoursesCourseWorkAddOnAttachmentsPatchCall) UpdateMask(updateMask string) *CoursesCourseWorkAddOnAttachmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkAddOnAttachmentsPatchCall) Fields(s ...googleapi.Field) *CoursesCourseWorkAddOnAttachmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkAddOnAttachmentsPatchCall) Context(ctx context.Context) *CoursesCourseWorkAddOnAttachmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkAddOnAttachmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkAddOnAttachmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.addOnAttachments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkAddOnAttachmentsPatchCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall struct {
	s            *Service
	courseId     string
	itemId       string
	attachmentId string
	submissionId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a student submission for an add-on attachment. This method
// returns the following error codes: * `PERMISSION_DENIED` for access errors.
// * `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of
// the identified resources does not exist.
//
//   - attachmentId: Identifier of the attachment.
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
//   - submissionId: Identifier of the student’s submission.
func (r *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsService) Get(courseId string, itemId string, attachmentId string, submissionId string) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall {
	c := &CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	c.submissionId = submissionId
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall) PostId(postId string) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall) Fields(s ...googleapi.Field) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall) IfNoneMatch(entityTag string) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall) Context(ctx context.Context) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{itemId}/addOnAttachments/{attachmentId}/studentSubmissions/{submissionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
		"submissionId": c.submissionId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.studentSubmissions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.addOnAttachments.studentSubmissions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachmentStudentSubmission.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsGetCall) Do(opts ...googleapi.CallOption) (*AddOnAttachmentStudentSubmission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachmentStudentSubmission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.studentSubmissions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall struct {
	s                                *Service
	courseId                         string
	itemId                           string
	attachmentId                     string
	submissionId                     string
	addonattachmentstudentsubmission *AddOnAttachmentStudentSubmission
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Patch: Updates data associated with an add-on attachment submission.
// Requires the add-on to have been the original creator of the attachment and
// the attachment to have a positive `max_points` value set. This method
// returns the following error codes: * `PERMISSION_DENIED` for access errors.
// * `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of
// the identified resources does not exist.
//
//   - attachmentId: Identifier of the attachment.
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
//   - submissionId: Identifier of the student's submission.
func (r *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsService) Patch(courseId string, itemId string, attachmentId string, submissionId string, addonattachmentstudentsubmission *AddOnAttachmentStudentSubmission) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall {
	c := &CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	c.submissionId = submissionId
	c.addonattachmentstudentsubmission = addonattachmentstudentsubmission
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall) PostId(postId string) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask that
// identifies which fields on the attachment to update. The update fails if
// invalid fields are specified. If a field supports empty values, it can be
// cleared by specifying it in the update mask and not in the
// `AddOnAttachmentStudentSubmission` object. The following fields may be
// specified by teachers: * `points_earned`
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall) UpdateMask(updateMask string) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall) Fields(s ...googleapi.Field) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall) Context(ctx context.Context) *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachmentstudentsubmission)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{itemId}/addOnAttachments/{attachmentId}/studentSubmissions/{submissionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
		"submissionId": c.submissionId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.studentSubmissions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.addOnAttachments.studentSubmissions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachmentStudentSubmission.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesCourseWorkAddOnAttachmentsStudentSubmissionsPatchCall) Do(opts ...googleapi.CallOption) (*AddOnAttachmentStudentSubmission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachmentStudentSubmission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.addOnAttachments.studentSubmissions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkRubricsCreateCall struct {
	s            *Service
	courseId     string
	courseWorkId string
	rubric       *Rubric
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a rubric. The requesting user and course owner must have
// rubrics creation capabilities. For details, see licensing requirements
// (https://developers.google.com/workspace/classroom/rubrics/limitations#license-requirements).
// For further details, see Rubrics structure and known limitations
// (/classroom/rubrics/limitations). This request must be made by the Google
// Cloud console of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the parent
// course work item. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user isn't permitted to create rubrics
// for course work in the requested course. * `INTERNAL` if the request has
// insufficient OAuth scopes. * `INVALID_ARGUMENT` if the request is malformed
// and for the following request error: * `RubricCriteriaInvalidFormat` *
// `NOT_FOUND` if the requested course or course work don't exist or the user
// doesn't have access to the course or course work. * `FAILED_PRECONDITION`
// for the following request error: * `AttachmentNotVisible`
//
// - courseId: Identifier of the course.
// - courseWorkId: Identifier of the course work.
func (r *CoursesCourseWorkRubricsService) Create(courseId string, courseWorkId string, rubric *Rubric) *CoursesCourseWorkRubricsCreateCall {
	c := &CoursesCourseWorkRubricsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.rubric = rubric
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkRubricsCreateCall) Fields(s ...googleapi.Field) *CoursesCourseWorkRubricsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkRubricsCreateCall) Context(ctx context.Context) *CoursesCourseWorkRubricsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkRubricsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkRubricsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rubric)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/rubrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.rubrics.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rubric.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkRubricsCreateCall) Do(opts ...googleapi.CallOption) (*Rubric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rubric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkRubricsDeleteCall struct {
	s            *Service
	courseId     string
	courseWorkId string
	id           string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes a rubric. The requesting user and course owner must have
// rubrics creation capabilities. For details, see licensing requirements
// (https://developers.google.com/workspace/classroom/rubrics/limitations#license-requirements).
// This request must be made by the Google Cloud console of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding rubric. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting developer project didn't create the
// corresponding rubric, or if the requesting user isn't permitted to delete
// the requested rubric. * `NOT_FOUND` if no rubric exists with the requested
// ID or the user does not have access to the course, course work, or rubric. *
// `INVALID_ARGUMENT` if grading has already started on the rubric.
//
// - courseId: Identifier of the course.
// - courseWorkId: Identifier of the course work.
// - id: Identifier of the rubric.
func (r *CoursesCourseWorkRubricsService) Delete(courseId string, courseWorkId string, id string) *CoursesCourseWorkRubricsDeleteCall {
	c := &CoursesCourseWorkRubricsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkRubricsDeleteCall) Fields(s ...googleapi.Field) *CoursesCourseWorkRubricsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkRubricsDeleteCall) Context(ctx context.Context) *CoursesCourseWorkRubricsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkRubricsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkRubricsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/rubrics/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.rubrics.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkRubricsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkRubricsGetCall struct {
	s            *Service
	courseId     string
	courseWorkId string
	id           string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a rubric. This method returns the following error codes: *
// `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the request
// is malformed. * `NOT_FOUND` if the requested course, course work, or rubric
// doesn't exist or if the user doesn't have access to the corresponding course
// work.
//
// - courseId: Identifier of the course.
// - courseWorkId: Identifier of the course work.
// - id: Identifier of the rubric.
func (r *CoursesCourseWorkRubricsService) Get(courseId string, courseWorkId string, id string) *CoursesCourseWorkRubricsGetCall {
	c := &CoursesCourseWorkRubricsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkRubricsGetCall) Fields(s ...googleapi.Field) *CoursesCourseWorkRubricsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkRubricsGetCall) IfNoneMatch(entityTag string) *CoursesCourseWorkRubricsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkRubricsGetCall) Context(ctx context.Context) *CoursesCourseWorkRubricsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkRubricsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkRubricsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/rubrics/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.rubrics.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rubric.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkRubricsGetCall) Do(opts ...googleapi.CallOption) (*Rubric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rubric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkRubricsListCall struct {
	s            *Service
	courseId     string
	courseWorkId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of rubrics that the requester is permitted to view.
// This method returns the following error codes: * `PERMISSION_DENIED` for
// access errors. * `INVALID_ARGUMENT` if the request is malformed. *
// `NOT_FOUND` if the requested course or course work doesn't exist or if the
// user doesn't have access to the corresponding course work.
//
// - courseId: Identifier of the course.
// - courseWorkId: Identifier of the course work.
func (r *CoursesCourseWorkRubricsService) List(courseId string, courseWorkId string) *CoursesCourseWorkRubricsListCall {
	c := &CoursesCourseWorkRubricsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// rubrics to return. If unspecified, at most 1 rubric is returned. The maximum
// value is 1; values above 1 are coerced to 1.
func (c *CoursesCourseWorkRubricsListCall) PageSize(pageSize int64) *CoursesCourseWorkRubricsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesCourseWorkRubricsListCall) PageToken(pageToken string) *CoursesCourseWorkRubricsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkRubricsListCall) Fields(s ...googleapi.Field) *CoursesCourseWorkRubricsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkRubricsListCall) IfNoneMatch(entityTag string) *CoursesCourseWorkRubricsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkRubricsListCall) Context(ctx context.Context) *CoursesCourseWorkRubricsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkRubricsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkRubricsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/rubrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.rubrics.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRubricsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkRubricsListCall) Do(opts ...googleapi.CallOption) (*ListRubricsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRubricsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesCourseWorkRubricsListCall) Pages(ctx context.Context, f func(*ListRubricsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesCourseWorkRubricsPatchCall struct {
	s            *Service
	courseId     string
	courseWorkId string
	id           string
	rubric       *Rubric
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates a rubric. See google.classroom.v1.Rubric for details of which
// fields can be updated. Rubric update capabilities are limited
// (/classroom/rubrics/limitations) once grading has started. The requesting
// user and course owner must have rubrics creation capabilities. For details,
// see licensing requirements
// (https://developers.google.com/workspace/classroom/rubrics/limitations#license-requirements).
// This request must be made by the Google Cloud console of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the parent
// course work item. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting developer project didn't create the
// corresponding course work, if the user isn't permitted to make the requested
// modification to the rubric, or for access errors. This error code is also
// returned if grading has already started on the rubric. * `INVALID_ARGUMENT`
// if the request is malformed and for the following request error: *
// `RubricCriteriaInvalidFormat` * `NOT_FOUND` if the requested course, course
// work, or rubric doesn't exist or if the user doesn't have access to the
// corresponding course work. * `INTERNAL` if grading has already started on
// the rubric.
//
// - courseId: Identifier of the course.
// - courseWorkId: Identifier of the course work.
// - id: Optional. Identifier of the rubric.
func (r *CoursesCourseWorkRubricsService) Patch(courseId string, courseWorkId string, id string, rubric *Rubric) *CoursesCourseWorkRubricsPatchCall {
	c := &CoursesCourseWorkRubricsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	c.rubric = rubric
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the rubric to update. This field is required to do an
// update. The update fails if invalid fields are specified. There are multiple
// options to define the criteria of a rubric: the `source_spreadsheet_id` and
// the `criteria` list. Only one of these can be used at a time to define a
// rubric. The rubric `criteria` list is fully replaced by the rubric criteria
// specified in the update request. For example, if a criterion or level is
// missing from the request, it is deleted. New criteria and levels are added
// and an ID is assigned. Existing criteria and levels retain the previously
// assigned ID if the ID is specified in the request. The following fields can
// be specified by teachers: * `criteria` * `source_spreadsheet_id`
func (c *CoursesCourseWorkRubricsPatchCall) UpdateMask(updateMask string) *CoursesCourseWorkRubricsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkRubricsPatchCall) Fields(s ...googleapi.Field) *CoursesCourseWorkRubricsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkRubricsPatchCall) Context(ctx context.Context) *CoursesCourseWorkRubricsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkRubricsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkRubricsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rubric)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/rubrics/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.rubrics.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rubric.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkRubricsPatchCall) Do(opts ...googleapi.CallOption) (*Rubric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rubric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.rubrics.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkStudentSubmissionsGetCall struct {
	s            *Service
	courseId     string
	courseWorkId string
	id           string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a student submission. * `PERMISSION_DENIED` if the requesting
// user is not permitted to access the requested course, course work, or
// student submission or for access errors. * `INVALID_ARGUMENT` if the request
// is malformed. * `NOT_FOUND` if the requested course, course work, or student
// submission does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - courseWorkId: Identifier of the course work.
//   - id: Identifier of the student submission.
func (r *CoursesCourseWorkStudentSubmissionsService) Get(courseId string, courseWorkId string, id string) *CoursesCourseWorkStudentSubmissionsGetCall {
	c := &CoursesCourseWorkStudentSubmissionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkStudentSubmissionsGetCall) Fields(s ...googleapi.Field) *CoursesCourseWorkStudentSubmissionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkStudentSubmissionsGetCall) IfNoneMatch(entityTag string) *CoursesCourseWorkStudentSubmissionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkStudentSubmissionsGetCall) Context(ctx context.Context) *CoursesCourseWorkStudentSubmissionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkStudentSubmissionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkStudentSubmissionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.studentSubmissions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *StudentSubmission.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkStudentSubmissionsGetCall) Do(opts ...googleapi.CallOption) (*StudentSubmission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StudentSubmission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkStudentSubmissionsListCall struct {
	s            *Service
	courseId     string
	courseWorkId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of student submissions that the requester is permitted
// to view, factoring in the OAuth scopes of the request. `-` may be specified
// as the `course_work_id` to include student submissions for multiple course
// work items. Course students may only view their own work. Course teachers
// and domain administrators may view all student submissions. This method
// returns the following error codes: * `PERMISSION_DENIED` if the requesting
// user is not permitted to access the requested course or course work, or for
// access errors. * `INVALID_ARGUMENT` if the request is malformed. *
// `NOT_FOUND` if the requested course does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - courseWorkId: Identifier of the student work to request. This may be set
//     to the string literal "-" to request student work for all course work in
//     the specified course.
func (r *CoursesCourseWorkStudentSubmissionsService) List(courseId string, courseWorkId string) *CoursesCourseWorkStudentSubmissionsListCall {
	c := &CoursesCourseWorkStudentSubmissionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	return c
}

// Late sets the optional parameter "late": Requested lateness value. If
// specified, returned student submissions are restricted by the requested
// value. If unspecified, submissions are returned regardless of `late` value.
//
// Possible values:
//
//	"LATE_VALUES_UNSPECIFIED" - No restriction on submission late values
//
// specified.
//
//	"LATE_ONLY" - Return StudentSubmissions where late is true.
//	"NOT_LATE_ONLY" - Return StudentSubmissions where late is false.
func (c *CoursesCourseWorkStudentSubmissionsListCall) Late(late string) *CoursesCourseWorkStudentSubmissionsListCall {
	c.urlParams_.Set("late", late)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *CoursesCourseWorkStudentSubmissionsListCall) PageSize(pageSize int64) *CoursesCourseWorkStudentSubmissionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesCourseWorkStudentSubmissionsListCall) PageToken(pageToken string) *CoursesCourseWorkStudentSubmissionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// States sets the optional parameter "states": Requested submission states. If
// specified, returned student submissions match one of the specified
// submission states.
//
// Possible values:
//
//	"SUBMISSION_STATE_UNSPECIFIED" - No state specified. This should never be
//
// returned.
//
//	"NEW" - The student has never accessed this submission. Attachments are
//
// not returned and timestamps is not set.
//
//	"CREATED" - Has been created.
//	"TURNED_IN" - Has been turned in to the teacher.
//	"RETURNED" - Has been returned to the student.
//	"RECLAIMED_BY_STUDENT" - Student chose to "unsubmit" the assignment.
func (c *CoursesCourseWorkStudentSubmissionsListCall) States(states ...string) *CoursesCourseWorkStudentSubmissionsListCall {
	c.urlParams_.SetMulti("states", append([]string{}, states...))
	return c
}

// UserId sets the optional parameter "userId": Optional argument to restrict
// returned student work to those owned by the student with the specified
// identifier. The identifier can be one of the following: * the numeric
// identifier for the user * the email address of the user * the string literal
// "me", indicating the requesting user
func (c *CoursesCourseWorkStudentSubmissionsListCall) UserId(userId string) *CoursesCourseWorkStudentSubmissionsListCall {
	c.urlParams_.Set("userId", userId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkStudentSubmissionsListCall) Fields(s ...googleapi.Field) *CoursesCourseWorkStudentSubmissionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkStudentSubmissionsListCall) IfNoneMatch(entityTag string) *CoursesCourseWorkStudentSubmissionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkStudentSubmissionsListCall) Context(ctx context.Context) *CoursesCourseWorkStudentSubmissionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkStudentSubmissionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkStudentSubmissionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.studentSubmissions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListStudentSubmissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesCourseWorkStudentSubmissionsListCall) Do(opts ...googleapi.CallOption) (*ListStudentSubmissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListStudentSubmissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesCourseWorkStudentSubmissionsListCall) Pages(ctx context.Context, f func(*ListStudentSubmissionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall struct {
	s                        *Service
	courseId                 string
	courseWorkId             string
	id                       string
	modifyattachmentsrequest *ModifyAttachmentsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// ModifyAttachments: Modifies attachments of student submission. Attachments
// may only be added to student submissions belonging to course work objects
// with a `workType` of `ASSIGNMENT`. This request must be made by the
// Developer Console project of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding course work item. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting user is not permitted to
// access the requested course or course work, if the user is not permitted to
// modify attachments on the requested student submission, or for access
// errors. * `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if
// the requested course, course work, or student submission does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - courseWorkId: Identifier of the course work.
//   - id: Identifier of the student submission.
func (r *CoursesCourseWorkStudentSubmissionsService) ModifyAttachments(courseId string, courseWorkId string, id string, modifyattachmentsrequest *ModifyAttachmentsRequest) *CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall {
	c := &CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	c.modifyattachmentsrequest = modifyattachmentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall) Fields(s ...googleapi.Field) *CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall) Context(ctx context.Context) *CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.modifyattachmentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:modifyAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.modifyAttachments", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.studentSubmissions.modifyAttachments" call.
// Any non-2xx status code is an error. Response headers are in either
// *StudentSubmission.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkStudentSubmissionsModifyAttachmentsCall) Do(opts ...googleapi.CallOption) (*StudentSubmission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StudentSubmission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.modifyAttachments", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkStudentSubmissionsPatchCall struct {
	s                 *Service
	courseId          string
	courseWorkId      string
	id                string
	studentsubmission *StudentSubmission
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Updates one or more fields of a student submission. See
// google.classroom.v1.StudentSubmission for details of which fields may be
// updated and who may change them. This request must be made by the Developer
// Console project of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding course work item. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting developer project did not
// create the corresponding course work, if the user is not permitted to make
// the requested modification to the student submission, or for access errors.
// * `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if the
// requested course, course work, or student submission does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - courseWorkId: Identifier of the course work.
//   - id: Identifier of the student submission.
func (r *CoursesCourseWorkStudentSubmissionsService) Patch(courseId string, courseWorkId string, id string, studentsubmission *StudentSubmission) *CoursesCourseWorkStudentSubmissionsPatchCall {
	c := &CoursesCourseWorkStudentSubmissionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	c.studentsubmission = studentsubmission
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the student submission to update. This field is required to
// do an update. The update fails if invalid fields are specified. The
// following fields may be specified by teachers: * `draft_grade` *
// `assigned_grade`
func (c *CoursesCourseWorkStudentSubmissionsPatchCall) UpdateMask(updateMask string) *CoursesCourseWorkStudentSubmissionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkStudentSubmissionsPatchCall) Fields(s ...googleapi.Field) *CoursesCourseWorkStudentSubmissionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkStudentSubmissionsPatchCall) Context(ctx context.Context) *CoursesCourseWorkStudentSubmissionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkStudentSubmissionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkStudentSubmissionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.studentsubmission)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.studentSubmissions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *StudentSubmission.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkStudentSubmissionsPatchCall) Do(opts ...googleapi.CallOption) (*StudentSubmission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StudentSubmission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkStudentSubmissionsReclaimCall struct {
	s                               *Service
	courseId                        string
	courseWorkId                    string
	id                              string
	reclaimstudentsubmissionrequest *ReclaimStudentSubmissionRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Reclaim: Reclaims a student submission on behalf of the student that owns
// it. Reclaiming a student submission transfers ownership of attached Drive
// files to the student and updates the submission state. Only the student that
// owns the requested student submission may call this method, and only for a
// student submission that has been turned in. This request must be made by the
// Developer Console project of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding course work item. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting user is not permitted to
// access the requested course or course work, unsubmit the requested student
// submission, or for access errors. * `FAILED_PRECONDITION` if the student
// submission has not been turned in. * `INVALID_ARGUMENT` if the request is
// malformed. * `NOT_FOUND` if the requested course, course work, or student
// submission does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - courseWorkId: Identifier of the course work.
//   - id: Identifier of the student submission.
func (r *CoursesCourseWorkStudentSubmissionsService) Reclaim(courseId string, courseWorkId string, id string, reclaimstudentsubmissionrequest *ReclaimStudentSubmissionRequest) *CoursesCourseWorkStudentSubmissionsReclaimCall {
	c := &CoursesCourseWorkStudentSubmissionsReclaimCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	c.reclaimstudentsubmissionrequest = reclaimstudentsubmissionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkStudentSubmissionsReclaimCall) Fields(s ...googleapi.Field) *CoursesCourseWorkStudentSubmissionsReclaimCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkStudentSubmissionsReclaimCall) Context(ctx context.Context) *CoursesCourseWorkStudentSubmissionsReclaimCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkStudentSubmissionsReclaimCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkStudentSubmissionsReclaimCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reclaimstudentsubmissionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:reclaim")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.reclaim", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.studentSubmissions.reclaim" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkStudentSubmissionsReclaimCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.reclaim", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkStudentSubmissionsReturnCall struct {
	s                              *Service
	courseId                       string
	courseWorkId                   string
	id                             string
	returnstudentsubmissionrequest *ReturnStudentSubmissionRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Return: Returns a student submission. Returning a student submission
// transfers ownership of attached Drive files to the student and may also
// update the submission state. Unlike the Classroom application, returning a
// student submission does not set assignedGrade to the draftGrade value. Only
// a teacher of the course that contains the requested student submission may
// call this method. This request must be made by the Developer Console project
// of the OAuth client ID (https://support.google.com/cloud/answer/6158849)
// used to create the corresponding course work item. This method returns the
// following error codes: * `PERMISSION_DENIED` if the requesting user is not
// permitted to access the requested course or course work, return the
// requested student submission, or for access errors. * `INVALID_ARGUMENT` if
// the request is malformed. * `NOT_FOUND` if the requested course, course
// work, or student submission does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - courseWorkId: Identifier of the course work.
//   - id: Identifier of the student submission.
func (r *CoursesCourseWorkStudentSubmissionsService) Return(courseId string, courseWorkId string, id string, returnstudentsubmissionrequest *ReturnStudentSubmissionRequest) *CoursesCourseWorkStudentSubmissionsReturnCall {
	c := &CoursesCourseWorkStudentSubmissionsReturnCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	c.returnstudentsubmissionrequest = returnstudentsubmissionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkStudentSubmissionsReturnCall) Fields(s ...googleapi.Field) *CoursesCourseWorkStudentSubmissionsReturnCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkStudentSubmissionsReturnCall) Context(ctx context.Context) *CoursesCourseWorkStudentSubmissionsReturnCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkStudentSubmissionsReturnCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkStudentSubmissionsReturnCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.returnstudentsubmissionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:return")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.return", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.studentSubmissions.return" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkStudentSubmissionsReturnCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.return", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkStudentSubmissionsTurnInCall struct {
	s                              *Service
	courseId                       string
	courseWorkId                   string
	id                             string
	turninstudentsubmissionrequest *TurnInStudentSubmissionRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// TurnIn: Turns in a student submission. Turning in a student submission
// transfers ownership of attached Drive files to the teacher and may also
// update the submission state. This may only be called by the student that
// owns the specified student submission. This request must be made by the
// Developer Console project of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding course work item. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting user is not permitted to
// access the requested course or course work, turn in the requested student
// submission, or for access errors. * `INVALID_ARGUMENT` if the request is
// malformed. * `NOT_FOUND` if the requested course, course work, or student
// submission does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - courseWorkId: Identifier of the course work.
//   - id: Identifier of the student submission.
func (r *CoursesCourseWorkStudentSubmissionsService) TurnIn(courseId string, courseWorkId string, id string, turninstudentsubmissionrequest *TurnInStudentSubmissionRequest) *CoursesCourseWorkStudentSubmissionsTurnInCall {
	c := &CoursesCourseWorkStudentSubmissionsTurnInCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseWorkId = courseWorkId
	c.id = id
	c.turninstudentsubmissionrequest = turninstudentsubmissionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkStudentSubmissionsTurnInCall) Fields(s ...googleapi.Field) *CoursesCourseWorkStudentSubmissionsTurnInCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkStudentSubmissionsTurnInCall) Context(ctx context.Context) *CoursesCourseWorkStudentSubmissionsTurnInCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkStudentSubmissionsTurnInCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkStudentSubmissionsTurnInCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.turninstudentsubmissionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:turnIn")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"courseWorkId": c.courseWorkId,
		"id":           c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.turnIn", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWork.studentSubmissions.turnIn" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkStudentSubmissionsTurnInCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWork.studentSubmissions.turnIn", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsCreateCall struct {
	s                  *Service
	courseId           string
	courseworkmaterial *CourseWorkMaterial
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Creates a course work material. This method returns the following
// error codes: * `PERMISSION_DENIED` if the requesting user is not permitted
// to access the requested course, create course work material in the requested
// course, share a Drive attachment, or for access errors. * `INVALID_ARGUMENT`
// if the request is malformed or if more than 20 * materials are provided. *
// `NOT_FOUND` if the requested course does not exist. * `FAILED_PRECONDITION`
// for the following request error: * AttachmentNotVisible
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesCourseWorkMaterialsService) Create(courseId string, courseworkmaterial *CourseWorkMaterial) *CoursesCourseWorkMaterialsCreateCall {
	c := &CoursesCourseWorkMaterialsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.courseworkmaterial = courseworkmaterial
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsCreateCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsCreateCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.courseworkmaterial)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *CourseWorkMaterial.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkMaterialsCreateCall) Do(opts ...googleapi.CallOption) (*CourseWorkMaterial, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CourseWorkMaterial{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsDeleteCall struct {
	s          *Service
	courseId   string
	id         string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a course work material. This request must be made by the
// Developer Console project of the OAuth client ID
// (https://support.google.com/cloud/answer/6158849) used to create the
// corresponding course work material item. This method returns the following
// error codes: * `PERMISSION_DENIED` if the requesting developer project did
// not create the corresponding course work material, if the requesting user is
// not permitted to delete the requested course or for access errors. *
// `FAILED_PRECONDITION` if the requested course work material has already been
// deleted. * `NOT_FOUND` if no course exists with the requested ID.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the course work material to delete. This identifier is a
//     Classroom-assigned identifier.
func (r *CoursesCourseWorkMaterialsService) Delete(courseId string, id string) *CoursesCourseWorkMaterialsDeleteCall {
	c := &CoursesCourseWorkMaterialsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsDeleteCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsDeleteCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkMaterialsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsGetCall struct {
	s            *Service
	courseId     string
	id           string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a course work material. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting user is not permitted to
// access the requested course or course work material, or for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if the
// requested course or course work material does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the course work material.
func (r *CoursesCourseWorkMaterialsService) Get(courseId string, id string) *CoursesCourseWorkMaterialsGetCall {
	c := &CoursesCourseWorkMaterialsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsGetCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkMaterialsGetCall) IfNoneMatch(entityTag string) *CoursesCourseWorkMaterialsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsGetCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CourseWorkMaterial.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkMaterialsGetCall) Do(opts ...googleapi.CallOption) (*CourseWorkMaterial, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CourseWorkMaterial{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsGetAddOnContextCall struct {
	s            *Service
	courseId     string
	itemId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAddOnContext: Gets metadata for Classroom add-ons in the context of a
// specific post. To maintain the integrity of its own data and permissions
// model, an add-on should call this to validate query parameters and the
// requesting user's role whenever the add-on is opened in an iframe
// (https://developers.google.com/workspace/classroom/add-ons/get-started/iframes/iframes-overview).
// This method returns the following error codes: * `PERMISSION_DENIED` for
// access errors. * `INVALID_ARGUMENT` if the request is malformed. *
// `NOT_FOUND` if one of the identified resources does not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkMaterialsService) GetAddOnContext(courseId string, itemId string) *CoursesCourseWorkMaterialsGetAddOnContextCall {
	c := &CoursesCourseWorkMaterialsGetAddOnContextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	return c
}

// AddOnToken sets the optional parameter "addOnToken": Token that authorizes
// the request. The token is passed as a query parameter when the user is
// redirected from Classroom to the add-on's URL. The authorization token is
// required when neither of the following is true: * The add-on has attachments
// on the post. * The developer project issuing the request is the same project
// that created the post.
func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) AddOnToken(addOnToken string) *CoursesCourseWorkMaterialsGetAddOnContextCall {
	c.urlParams_.Set("addOnToken", addOnToken)
	return c
}

// AttachmentId sets the optional parameter "attachmentId": The identifier of
// the attachment. This field is required for all requests except when the user
// is in the Attachment Discovery iframe
// (https://developers.google.com/workspace/classroom/add-ons/get-started/iframes/attachment-discovery-iframe).
func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) AttachmentId(attachmentId string) *CoursesCourseWorkMaterialsGetAddOnContextCall {
	c.urlParams_.Set("attachmentId", attachmentId)
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) PostId(postId string) *CoursesCourseWorkMaterialsGetAddOnContextCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsGetAddOnContextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) IfNoneMatch(entityTag string) *CoursesCourseWorkMaterialsGetAddOnContextCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsGetAddOnContextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{itemId}/addOnContext")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.getAddOnContext", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.getAddOnContext" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnContext.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkMaterialsGetAddOnContextCall) Do(opts ...googleapi.CallOption) (*AddOnContext, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnContext{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.getAddOnContext", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsListCall struct {
	s            *Service
	courseId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of course work material that the requester is permitted
// to view. Course students may only view `PUBLISHED` course work material.
// Course teachers and domain administrators may view all course work material.
// This method returns the following error codes: * `PERMISSION_DENIED` if the
// requesting user is not permitted to access the requested course or for
// access errors. * `INVALID_ARGUMENT` if the request is malformed. *
// `NOT_FOUND` if the requested course does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesCourseWorkMaterialsService) List(courseId string) *CoursesCourseWorkMaterialsListCall {
	c := &CoursesCourseWorkMaterialsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	return c
}

// CourseWorkMaterialStates sets the optional parameter
// "courseWorkMaterialStates": Restriction on the work status to return. Only
// course work material that matches is returned. If unspecified, items with a
// work status of `PUBLISHED` is returned.
//
// Possible values:
//
//	"COURSEWORK_MATERIAL_STATE_UNSPECIFIED" - No state specified. This is
//
// never returned.
//
//	"PUBLISHED" - Status for course work material that has been published.
//
// This is the default state.
//
//	"DRAFT" - Status for a course work material that is not yet published.
//
// Course work material in this state is visible only to course teachers and
// domain administrators.
//
//	"DELETED" - Status for course work material that was published but is now
//
// deleted. Course work material in this state is visible only to course
// teachers and domain administrators. Course work material in this state is
// deleted after some time.
func (c *CoursesCourseWorkMaterialsListCall) CourseWorkMaterialStates(courseWorkMaterialStates ...string) *CoursesCourseWorkMaterialsListCall {
	c.urlParams_.SetMulti("courseWorkMaterialStates", append([]string{}, courseWorkMaterialStates...))
	return c
}

// MaterialDriveId sets the optional parameter "materialDriveId": Optional
// filtering for course work material with at least one Drive material whose ID
// matches the provided string. If `material_link` is also specified, course
// work material must have materials matching both filters.
func (c *CoursesCourseWorkMaterialsListCall) MaterialDriveId(materialDriveId string) *CoursesCourseWorkMaterialsListCall {
	c.urlParams_.Set("materialDriveId", materialDriveId)
	return c
}

// MaterialLink sets the optional parameter "materialLink": Optional filtering
// for course work material with at least one link material whose URL partially
// matches the provided string.
func (c *CoursesCourseWorkMaterialsListCall) MaterialLink(materialLink string) *CoursesCourseWorkMaterialsListCall {
	c.urlParams_.Set("materialLink", materialLink)
	return c
}

// OrderBy sets the optional parameter "orderBy": Optional sort ordering for
// results. A comma-separated list of fields with an optional sort direction
// keyword. Supported field is `updateTime`. Supported direction keywords are
// `asc` and `desc`. If not specified, `updateTime desc` is the default
// behavior. Examples: `updateTime asc`, `updateTime`
func (c *CoursesCourseWorkMaterialsListCall) OrderBy(orderBy string) *CoursesCourseWorkMaterialsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *CoursesCourseWorkMaterialsListCall) PageSize(pageSize int64) *CoursesCourseWorkMaterialsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesCourseWorkMaterialsListCall) PageToken(pageToken string) *CoursesCourseWorkMaterialsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsListCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkMaterialsListCall) IfNoneMatch(entityTag string) *CoursesCourseWorkMaterialsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsListCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCourseWorkMaterialResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesCourseWorkMaterialsListCall) Do(opts ...googleapi.CallOption) (*ListCourseWorkMaterialResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCourseWorkMaterialResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesCourseWorkMaterialsListCall) Pages(ctx context.Context, f func(*ListCourseWorkMaterialResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesCourseWorkMaterialsPatchCall struct {
	s                  *Service
	courseId           string
	id                 string
	courseworkmaterial *CourseWorkMaterial
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates one or more fields of a course work material. This method
// returns the following error codes: * `PERMISSION_DENIED` if the requesting
// developer project for access errors. * `INVALID_ARGUMENT` if the request is
// malformed. * `FAILED_PRECONDITION` if the requested course work material has
// already been deleted. * `NOT_FOUND` if the requested course or course work
// material does not exist
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the course work material.
func (r *CoursesCourseWorkMaterialsService) Patch(courseId string, id string, courseworkmaterial *CourseWorkMaterial) *CoursesCourseWorkMaterialsPatchCall {
	c := &CoursesCourseWorkMaterialsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	c.courseworkmaterial = courseworkmaterial
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the course work material to update. This field is required
// to do an update. The update fails if invalid fields are specified. If a
// field supports empty values, it can be cleared by specifying it in the
// update mask and not in the course work material object. If a field that does
// not support empty values is included in the update mask and not set in the
// course work material object, an `INVALID_ARGUMENT` error is returned. The
// following fields may be specified by teachers: * `title` * `description` *
// `state` * `scheduled_time` * `topic_id`
func (c *CoursesCourseWorkMaterialsPatchCall) UpdateMask(updateMask string) *CoursesCourseWorkMaterialsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsPatchCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsPatchCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.courseworkmaterial)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *CourseWorkMaterial.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkMaterialsPatchCall) Do(opts ...googleapi.CallOption) (*CourseWorkMaterial, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CourseWorkMaterial{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall struct {
	s               *Service
	courseId        string
	itemId          string
	addonattachment *AddOnAttachment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates an add-on attachment under a post. Requires the add-on to
// have permission to create new attachments on the post. This method returns
// the following error codes: * `PERMISSION_DENIED` for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of the
// identified resources does not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which to create the attachment. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkMaterialsAddOnAttachmentsService) Create(courseId string, itemId string, addonattachment *AddOnAttachment) *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall {
	c := &CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.addonattachment = addonattachment
	return c
}

// AddOnToken sets the optional parameter "addOnToken": Token that authorizes
// the request. The token is passed as a query parameter when the user is
// redirected from Classroom to the add-on's URL. This authorization token is
// required for in-Classroom attachment creation but optional for partner-first
// attachment creation. Returns an error if not provided for partner-first
// attachment creation and the developer projects that created the attachment
// and its parent stream item do not match.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall) AddOnToken(addOnToken string) *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("addOnToken", addOnToken)
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall) PostId(postId string) *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{itemId}/addOnAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.addOnAttachments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsCreateCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall struct {
	s            *Service
	courseId     string
	itemId       string
	attachmentId string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes an add-on attachment. Requires the add-on to have been the
// original creator of the attachment. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
//   - attachmentId: Identifier of the attachment.
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkMaterialsAddOnAttachmentsService) Delete(courseId string, itemId string, attachmentId string) *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall {
	c := &CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall) PostId(postId string) *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.addOnAttachments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsAddOnAttachmentsGetCall struct {
	s            *Service
	courseId     string
	itemId       string
	attachmentId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns an add-on attachment. Requires the add-on requesting the
// attachment to be the original creator of the attachment. This method returns
// the following error codes: * `PERMISSION_DENIED` for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of the
// identified resources does not exist.
//
//   - attachmentId: Identifier of the attachment.
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` under which the attachment is attached. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkMaterialsAddOnAttachmentsService) Get(courseId string, itemId string, attachmentId string) *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall {
	c := &CoursesCourseWorkMaterialsAddOnAttachmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	return c
}

// PostId sets the optional parameter "postId": Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall) PostId(postId string) *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall) IfNoneMatch(entityTag string) *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.addOnAttachments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsGetCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesCourseWorkMaterialsAddOnAttachmentsListCall struct {
	s            *Service
	courseId     string
	itemId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all attachments created by an add-on under the post. Requires
// the add-on to have active attachments on the post or have permission to
// create new attachments on the post. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
//   - courseId: Identifier of the course.
//   - itemId: Identifier of the `Announcement`, `CourseWork`, or
//     `CourseWorkMaterial` whose attachments should be enumerated. This field is
//     required, but is not marked as such while we are migrating from post_id.
func (r *CoursesCourseWorkMaterialsAddOnAttachmentsService) List(courseId string, itemId string) *CoursesCourseWorkMaterialsAddOnAttachmentsListCall {
	c := &CoursesCourseWorkMaterialsAddOnAttachmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// attachments to return. The service may return fewer than this value. If
// unspecified, at most 20 attachments will be returned. The maximum value is
// 20; values above 20 will be coerced to 20.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) PageSize(pageSize int64) *CoursesCourseWorkMaterialsAddOnAttachmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAddOnAttachments` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListAddOnAttachments` must match the call that provided the page token.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) PageToken(pageToken string) *CoursesCourseWorkMaterialsAddOnAttachmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// PostId sets the optional parameter "postId": Identifier of the post under
// the course whose attachments to enumerate. Deprecated, use `item_id`
// instead.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) PostId(postId string) *CoursesCourseWorkMaterialsAddOnAttachmentsListCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsAddOnAttachmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) IfNoneMatch(entityTag string) *CoursesCourseWorkMaterialsAddOnAttachmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsAddOnAttachmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{itemId}/addOnAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"itemId":   c.itemId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.addOnAttachments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAddOnAttachmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) Do(opts ...googleapi.CallOption) (*ListAddOnAttachmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAddOnAttachmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsListCall) Pages(ctx context.Context, f func(*ListAddOnAttachmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall struct {
	s               *Service
	courseId        string
	itemId          string
	attachmentId    string
	addonattachment *AddOnAttachment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates an add-on attachment. Requires the add-on to have been the
// original creator of the attachment. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
// - attachmentId: Identifier of the attachment.
// - courseId: Identifier of the course.
// - itemId: Identifier of the post under which the attachment is attached.
func (r *CoursesCourseWorkMaterialsAddOnAttachmentsService) Patch(courseId string, itemId string, attachmentId string, addonattachment *AddOnAttachment) *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall {
	c := &CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.itemId = itemId
	c.attachmentId = attachmentId
	c.addonattachment = addonattachment
	return c
}

// PostId sets the optional parameter "postId": Required. Identifier of the
// post under which the attachment is attached.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall) PostId(postId string) *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("postId", postId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask that
// identifies which fields on the attachment to update. The update fails if
// invalid fields are specified. If a field supports empty values, it can be
// cleared by specifying it in the update mask and not in the `AddOnAttachment`
// object. If a field that does not support empty values is included in the
// update mask and not set in the `AddOnAttachment` object, an
// `INVALID_ARGUMENT` error is returned. The following fields may be specified
// by teachers: * `title` * `teacher_view_uri` * `student_view_uri` *
// `student_work_review_uri` * `due_date` * `due_time` * `max_points`
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall) UpdateMask(updateMask string) *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall) Fields(s ...googleapi.Field) *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall) Context(ctx context.Context) *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/courseWorkMaterials/{itemId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"itemId":       c.itemId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.courseWorkMaterials.addOnAttachments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesCourseWorkMaterialsAddOnAttachmentsPatchCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.courseWorkMaterials.addOnAttachments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesPostsGetAddOnContextCall struct {
	s            *Service
	courseId     string
	postId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAddOnContext: Gets metadata for Classroom add-ons in the context of a
// specific post. To maintain the integrity of its own data and permissions
// model, an add-on should call this to validate query parameters and the
// requesting user's role whenever the add-on is opened in an iframe
// (https://developers.google.com/workspace/classroom/add-ons/get-started/iframes/iframes-overview).
// This method returns the following error codes: * `PERMISSION_DENIED` for
// access errors. * `INVALID_ARGUMENT` if the request is malformed. *
// `NOT_FOUND` if one of the identified resources does not exist.
//
// - courseId: Identifier of the course.
// - postId: Optional. Deprecated, use `item_id` instead.
func (r *CoursesPostsService) GetAddOnContext(courseId string, postId string) *CoursesPostsGetAddOnContextCall {
	c := &CoursesPostsGetAddOnContextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.postId = postId
	return c
}

// AddOnToken sets the optional parameter "addOnToken": Token that authorizes
// the request. The token is passed as a query parameter when the user is
// redirected from Classroom to the add-on's URL. The authorization token is
// required when neither of the following is true: * The add-on has attachments
// on the post. * The developer project issuing the request is the same project
// that created the post.
func (c *CoursesPostsGetAddOnContextCall) AddOnToken(addOnToken string) *CoursesPostsGetAddOnContextCall {
	c.urlParams_.Set("addOnToken", addOnToken)
	return c
}

// AttachmentId sets the optional parameter "attachmentId": The identifier of
// the attachment. This field is required for all requests except when the user
// is in the Attachment Discovery iframe
// (https://developers.google.com/workspace/classroom/add-ons/get-started/iframes/attachment-discovery-iframe).
func (c *CoursesPostsGetAddOnContextCall) AttachmentId(attachmentId string) *CoursesPostsGetAddOnContextCall {
	c.urlParams_.Set("attachmentId", attachmentId)
	return c
}

// ItemId sets the optional parameter "itemId": Identifier of the
// `Announcement`, `CourseWork`, or `CourseWorkMaterial` under which the
// attachment is attached. This field is required, but is not marked as such
// while we are migrating from post_id.
func (c *CoursesPostsGetAddOnContextCall) ItemId(itemId string) *CoursesPostsGetAddOnContextCall {
	c.urlParams_.Set("itemId", itemId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPostsGetAddOnContextCall) Fields(s ...googleapi.Field) *CoursesPostsGetAddOnContextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesPostsGetAddOnContextCall) IfNoneMatch(entityTag string) *CoursesPostsGetAddOnContextCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPostsGetAddOnContextCall) Context(ctx context.Context) *CoursesPostsGetAddOnContextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPostsGetAddOnContextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPostsGetAddOnContextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/posts/{postId}/addOnContext")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"postId":   c.postId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.posts.getAddOnContext", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.posts.getAddOnContext" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnContext.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesPostsGetAddOnContextCall) Do(opts ...googleapi.CallOption) (*AddOnContext, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnContext{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.posts.getAddOnContext", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesPostsAddOnAttachmentsCreateCall struct {
	s               *Service
	courseId        string
	postId          string
	addonattachment *AddOnAttachment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates an add-on attachment under a post. Requires the add-on to
// have permission to create new attachments on the post. This method returns
// the following error codes: * `PERMISSION_DENIED` for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of the
// identified resources does not exist.
//
// - courseId: Identifier of the course.
// - postId: Optional. Deprecated, use `item_id` instead.
func (r *CoursesPostsAddOnAttachmentsService) Create(courseId string, postId string, addonattachment *AddOnAttachment) *CoursesPostsAddOnAttachmentsCreateCall {
	c := &CoursesPostsAddOnAttachmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.postId = postId
	c.addonattachment = addonattachment
	return c
}

// AddOnToken sets the optional parameter "addOnToken": Token that authorizes
// the request. The token is passed as a query parameter when the user is
// redirected from Classroom to the add-on's URL. This authorization token is
// required for in-Classroom attachment creation but optional for partner-first
// attachment creation. Returns an error if not provided for partner-first
// attachment creation and the developer projects that created the attachment
// and its parent stream item do not match.
func (c *CoursesPostsAddOnAttachmentsCreateCall) AddOnToken(addOnToken string) *CoursesPostsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("addOnToken", addOnToken)
	return c
}

// ItemId sets the optional parameter "itemId": Identifier of the
// `Announcement`, `CourseWork`, or `CourseWorkMaterial` under which to create
// the attachment. This field is required, but is not marked as such while we
// are migrating from post_id.
func (c *CoursesPostsAddOnAttachmentsCreateCall) ItemId(itemId string) *CoursesPostsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("itemId", itemId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPostsAddOnAttachmentsCreateCall) Fields(s ...googleapi.Field) *CoursesPostsAddOnAttachmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPostsAddOnAttachmentsCreateCall) Context(ctx context.Context) *CoursesPostsAddOnAttachmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPostsAddOnAttachmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPostsAddOnAttachmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/posts/{postId}/addOnAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"postId":   c.postId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.posts.addOnAttachments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesPostsAddOnAttachmentsCreateCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesPostsAddOnAttachmentsDeleteCall struct {
	s            *Service
	courseId     string
	postId       string
	attachmentId string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes an add-on attachment. Requires the add-on to have been the
// original creator of the attachment. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
// - attachmentId: Identifier of the attachment.
// - courseId: Identifier of the course.
// - postId: Optional. Deprecated, use `item_id` instead.
func (r *CoursesPostsAddOnAttachmentsService) Delete(courseId string, postId string, attachmentId string) *CoursesPostsAddOnAttachmentsDeleteCall {
	c := &CoursesPostsAddOnAttachmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.postId = postId
	c.attachmentId = attachmentId
	return c
}

// ItemId sets the optional parameter "itemId": Identifier of the
// `Announcement`, `CourseWork`, or `CourseWorkMaterial` under which the
// attachment is attached. This field is required, but is not marked as such
// while we are migrating from post_id.
func (c *CoursesPostsAddOnAttachmentsDeleteCall) ItemId(itemId string) *CoursesPostsAddOnAttachmentsDeleteCall {
	c.urlParams_.Set("itemId", itemId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPostsAddOnAttachmentsDeleteCall) Fields(s ...googleapi.Field) *CoursesPostsAddOnAttachmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPostsAddOnAttachmentsDeleteCall) Context(ctx context.Context) *CoursesPostsAddOnAttachmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPostsAddOnAttachmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPostsAddOnAttachmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/posts/{postId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"postId":       c.postId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.posts.addOnAttachments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesPostsAddOnAttachmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesPostsAddOnAttachmentsGetCall struct {
	s            *Service
	courseId     string
	postId       string
	attachmentId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns an add-on attachment. Requires the add-on requesting the
// attachment to be the original creator of the attachment. This method returns
// the following error codes: * `PERMISSION_DENIED` for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of the
// identified resources does not exist.
//
// - attachmentId: Identifier of the attachment.
// - courseId: Identifier of the course.
// - postId: Optional. Deprecated, use `item_id` instead.
func (r *CoursesPostsAddOnAttachmentsService) Get(courseId string, postId string, attachmentId string) *CoursesPostsAddOnAttachmentsGetCall {
	c := &CoursesPostsAddOnAttachmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.postId = postId
	c.attachmentId = attachmentId
	return c
}

// ItemId sets the optional parameter "itemId": Identifier of the
// `Announcement`, `CourseWork`, or `CourseWorkMaterial` under which the
// attachment is attached. This field is required, but is not marked as such
// while we are migrating from post_id.
func (c *CoursesPostsAddOnAttachmentsGetCall) ItemId(itemId string) *CoursesPostsAddOnAttachmentsGetCall {
	c.urlParams_.Set("itemId", itemId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPostsAddOnAttachmentsGetCall) Fields(s ...googleapi.Field) *CoursesPostsAddOnAttachmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesPostsAddOnAttachmentsGetCall) IfNoneMatch(entityTag string) *CoursesPostsAddOnAttachmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPostsAddOnAttachmentsGetCall) Context(ctx context.Context) *CoursesPostsAddOnAttachmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPostsAddOnAttachmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPostsAddOnAttachmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/posts/{postId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"postId":       c.postId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.posts.addOnAttachments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesPostsAddOnAttachmentsGetCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesPostsAddOnAttachmentsListCall struct {
	s            *Service
	courseId     string
	postId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all attachments created by an add-on under the post. Requires
// the add-on to have active attachments on the post or have permission to
// create new attachments on the post. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
//   - courseId: Identifier of the course.
//   - postId: Optional. Identifier of the post under the course whose
//     attachments to enumerate. Deprecated, use `item_id` instead.
func (r *CoursesPostsAddOnAttachmentsService) List(courseId string, postId string) *CoursesPostsAddOnAttachmentsListCall {
	c := &CoursesPostsAddOnAttachmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.postId = postId
	return c
}

// ItemId sets the optional parameter "itemId": Identifier of the
// `Announcement`, `CourseWork`, or `CourseWorkMaterial` whose attachments
// should be enumerated. This field is required, but is not marked as such
// while we are migrating from post_id.
func (c *CoursesPostsAddOnAttachmentsListCall) ItemId(itemId string) *CoursesPostsAddOnAttachmentsListCall {
	c.urlParams_.Set("itemId", itemId)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// attachments to return. The service may return fewer than this value. If
// unspecified, at most 20 attachments will be returned. The maximum value is
// 20; values above 20 will be coerced to 20.
func (c *CoursesPostsAddOnAttachmentsListCall) PageSize(pageSize int64) *CoursesPostsAddOnAttachmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAddOnAttachments` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListAddOnAttachments` must match the call that provided the page token.
func (c *CoursesPostsAddOnAttachmentsListCall) PageToken(pageToken string) *CoursesPostsAddOnAttachmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPostsAddOnAttachmentsListCall) Fields(s ...googleapi.Field) *CoursesPostsAddOnAttachmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesPostsAddOnAttachmentsListCall) IfNoneMatch(entityTag string) *CoursesPostsAddOnAttachmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPostsAddOnAttachmentsListCall) Context(ctx context.Context) *CoursesPostsAddOnAttachmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPostsAddOnAttachmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPostsAddOnAttachmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/posts/{postId}/addOnAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"postId":   c.postId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.posts.addOnAttachments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAddOnAttachmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesPostsAddOnAttachmentsListCall) Do(opts ...googleapi.CallOption) (*ListAddOnAttachmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAddOnAttachmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesPostsAddOnAttachmentsListCall) Pages(ctx context.Context, f func(*ListAddOnAttachmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesPostsAddOnAttachmentsPatchCall struct {
	s               *Service
	courseId        string
	postId          string
	attachmentId    string
	addonattachment *AddOnAttachment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates an add-on attachment. Requires the add-on to have been the
// original creator of the attachment. This method returns the following error
// codes: * `PERMISSION_DENIED` for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if one of the identified resources does
// not exist.
//
// - attachmentId: Identifier of the attachment.
// - courseId: Identifier of the course.
// - postId: Identifier of the post under which the attachment is attached.
func (r *CoursesPostsAddOnAttachmentsService) Patch(courseId string, postId string, attachmentId string, addonattachment *AddOnAttachment) *CoursesPostsAddOnAttachmentsPatchCall {
	c := &CoursesPostsAddOnAttachmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.postId = postId
	c.attachmentId = attachmentId
	c.addonattachment = addonattachment
	return c
}

// ItemId sets the optional parameter "itemId": Identifier of the post under
// which the attachment is attached.
func (c *CoursesPostsAddOnAttachmentsPatchCall) ItemId(itemId string) *CoursesPostsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("itemId", itemId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask that
// identifies which fields on the attachment to update. The update fails if
// invalid fields are specified. If a field supports empty values, it can be
// cleared by specifying it in the update mask and not in the `AddOnAttachment`
// object. If a field that does not support empty values is included in the
// update mask and not set in the `AddOnAttachment` object, an
// `INVALID_ARGUMENT` error is returned. The following fields may be specified
// by teachers: * `title` * `teacher_view_uri` * `student_view_uri` *
// `student_work_review_uri` * `due_date` * `due_time` * `max_points`
func (c *CoursesPostsAddOnAttachmentsPatchCall) UpdateMask(updateMask string) *CoursesPostsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPostsAddOnAttachmentsPatchCall) Fields(s ...googleapi.Field) *CoursesPostsAddOnAttachmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPostsAddOnAttachmentsPatchCall) Context(ctx context.Context) *CoursesPostsAddOnAttachmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPostsAddOnAttachmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPostsAddOnAttachmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/posts/{postId}/addOnAttachments/{attachmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"postId":       c.postId,
		"attachmentId": c.attachmentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.posts.addOnAttachments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesPostsAddOnAttachmentsPatchCall) Do(opts ...googleapi.CallOption) (*AddOnAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall struct {
	s            *Service
	courseId     string
	postId       string
	attachmentId string
	submissionId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a student submission for an add-on attachment. This method
// returns the following error codes: * `PERMISSION_DENIED` for access errors.
// * `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of
// the identified resources does not exist.
//
// - attachmentId: Identifier of the attachment.
// - courseId: Identifier of the course.
// - postId: Optional. Deprecated, use `item_id` instead.
// - submissionId: Identifier of the student’s submission.
func (r *CoursesPostsAddOnAttachmentsStudentSubmissionsService) Get(courseId string, postId string, attachmentId string, submissionId string) *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall {
	c := &CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.postId = postId
	c.attachmentId = attachmentId
	c.submissionId = submissionId
	return c
}

// ItemId sets the optional parameter "itemId": Identifier of the
// `Announcement`, `CourseWork`, or `CourseWorkMaterial` under which the
// attachment is attached. This field is required, but is not marked as such
// while we are migrating from post_id.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall) ItemId(itemId string) *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall {
	c.urlParams_.Set("itemId", itemId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall) Fields(s ...googleapi.Field) *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall) IfNoneMatch(entityTag string) *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall) Context(ctx context.Context) *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/posts/{postId}/addOnAttachments/{attachmentId}/studentSubmissions/{submissionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"postId":       c.postId,
		"attachmentId": c.attachmentId,
		"submissionId": c.submissionId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.studentSubmissions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.posts.addOnAttachments.studentSubmissions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachmentStudentSubmission.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsGetCall) Do(opts ...googleapi.CallOption) (*AddOnAttachmentStudentSubmission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachmentStudentSubmission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.studentSubmissions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall struct {
	s                                *Service
	courseId                         string
	postId                           string
	attachmentId                     string
	submissionId                     string
	addonattachmentstudentsubmission *AddOnAttachmentStudentSubmission
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Patch: Updates data associated with an add-on attachment submission.
// Requires the add-on to have been the original creator of the attachment and
// the attachment to have a positive `max_points` value set. This method
// returns the following error codes: * `PERMISSION_DENIED` for access errors.
// * `INVALID_ARGUMENT` if the request is malformed. * `NOT_FOUND` if one of
// the identified resources does not exist.
//
// - attachmentId: Identifier of the attachment.
// - courseId: Identifier of the course.
// - postId: Optional. Deprecated, use `item_id` instead.
// - submissionId: Identifier of the student's submission.
func (r *CoursesPostsAddOnAttachmentsStudentSubmissionsService) Patch(courseId string, postId string, attachmentId string, submissionId string, addonattachmentstudentsubmission *AddOnAttachmentStudentSubmission) *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall {
	c := &CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.postId = postId
	c.attachmentId = attachmentId
	c.submissionId = submissionId
	c.addonattachmentstudentsubmission = addonattachmentstudentsubmission
	return c
}

// ItemId sets the optional parameter "itemId": Identifier of the
// `Announcement`, `CourseWork`, or `CourseWorkMaterial` under which the
// attachment is attached. This field is required, but is not marked as such
// while we are migrating from post_id.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall) ItemId(itemId string) *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall {
	c.urlParams_.Set("itemId", itemId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask that
// identifies which fields on the attachment to update. The update fails if
// invalid fields are specified. If a field supports empty values, it can be
// cleared by specifying it in the update mask and not in the
// `AddOnAttachmentStudentSubmission` object. The following fields may be
// specified by teachers: * `points_earned`
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall) UpdateMask(updateMask string) *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall) Fields(s ...googleapi.Field) *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall) Context(ctx context.Context) *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addonattachmentstudentsubmission)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/posts/{postId}/addOnAttachments/{attachmentId}/studentSubmissions/{submissionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId":     c.courseId,
		"postId":       c.postId,
		"attachmentId": c.attachmentId,
		"submissionId": c.submissionId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.studentSubmissions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.posts.addOnAttachments.studentSubmissions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AddOnAttachmentStudentSubmission.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CoursesPostsAddOnAttachmentsStudentSubmissionsPatchCall) Do(opts ...googleapi.CallOption) (*AddOnAttachmentStudentSubmission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddOnAttachmentStudentSubmission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.posts.addOnAttachments.studentSubmissions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesStudentsCreateCall struct {
	s          *Service
	courseId   string
	student    *Student
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Adds a user as a student of a course. Domain administrators are
// permitted to directly add
// (https://developers.google.com/workspace/classroom/guides/manage-users)
// users within their domain as students to courses within their domain.
// Students are permitted to add themselves to a course using an enrollment
// code. This method returns the following error codes: * `PERMISSION_DENIED`
// if the requesting user is not permitted to create students in this course or
// for access errors. * `NOT_FOUND` if the requested course ID does not exist.
// * `FAILED_PRECONDITION` if the requested user's account is disabled, for the
// following request errors: * CourseMemberLimitReached * CourseNotModifiable *
// UserGroupsMembershipLimitReached * InactiveCourseOwner * `ALREADY_EXISTS` if
// the user is already a student or teacher in the course.
//
//   - courseId: Identifier of the course to create the student in. This
//     identifier can be either the Classroom-assigned identifier or an alias.
func (r *CoursesStudentsService) Create(courseId string, student *Student) *CoursesStudentsCreateCall {
	c := &CoursesStudentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.student = student
	return c
}

// EnrollmentCode sets the optional parameter "enrollmentCode": Enrollment code
// of the course to create the student in. This code is required if userId
// corresponds to the requesting user; it may be omitted if the requesting user
// has administrative permissions to create students for any user.
func (c *CoursesStudentsCreateCall) EnrollmentCode(enrollmentCode string) *CoursesStudentsCreateCall {
	c.urlParams_.Set("enrollmentCode", enrollmentCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesStudentsCreateCall) Fields(s ...googleapi.Field) *CoursesStudentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesStudentsCreateCall) Context(ctx context.Context) *CoursesStudentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesStudentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesStudentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.student)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/students")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.students.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.students.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Student.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesStudentsCreateCall) Do(opts ...googleapi.CallOption) (*Student, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Student{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.students.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesStudentsDeleteCall struct {
	s          *Service
	courseId   string
	userId     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a student of a course. This method returns the following
// error codes: * `PERMISSION_DENIED` if the requesting user is not permitted
// to delete students of this course or for access errors. * `NOT_FOUND` if no
// student of this course has the requested ID or if the course does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - userId: Identifier of the student to delete. The identifier can be one of
//     the following: * the numeric identifier for the user * the email address
//     of the user * the string literal "me", indicating the requesting user.
func (r *CoursesStudentsService) Delete(courseId string, userId string) *CoursesStudentsDeleteCall {
	c := &CoursesStudentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.userId = userId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesStudentsDeleteCall) Fields(s ...googleapi.Field) *CoursesStudentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesStudentsDeleteCall) Context(ctx context.Context) *CoursesStudentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesStudentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesStudentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/students/{userId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"userId":   c.userId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.students.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.students.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesStudentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.students.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesStudentsGetCall struct {
	s            *Service
	courseId     string
	userId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a student of a course. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting user is not permitted to view
// students of this course or for access errors. * `NOT_FOUND` if no student of
// this course has the requested ID or if the course does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - userId: Identifier of the student to return. The identifier can be one of
//     the following: * the numeric identifier for the user * the email address
//     of the user * the string literal "me", indicating the requesting user.
func (r *CoursesStudentsService) Get(courseId string, userId string) *CoursesStudentsGetCall {
	c := &CoursesStudentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.userId = userId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesStudentsGetCall) Fields(s ...googleapi.Field) *CoursesStudentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesStudentsGetCall) IfNoneMatch(entityTag string) *CoursesStudentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesStudentsGetCall) Context(ctx context.Context) *CoursesStudentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesStudentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesStudentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/students/{userId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"userId":   c.userId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.students.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.students.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Student.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesStudentsGetCall) Do(opts ...googleapi.CallOption) (*Student, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Student{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.students.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesStudentsListCall struct {
	s            *Service
	courseId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of students of this course that the requester is
// permitted to view. This method returns the following error codes: *
// `NOT_FOUND` if the course does not exist. * `PERMISSION_DENIED` for access
// errors.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesStudentsService) List(courseId string) *CoursesStudentsListCall {
	c := &CoursesStudentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. The default is 30 if unspecified or `0`. The server may return fewer
// than the specified number of results.
func (c *CoursesStudentsListCall) PageSize(pageSize int64) *CoursesStudentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesStudentsListCall) PageToken(pageToken string) *CoursesStudentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesStudentsListCall) Fields(s ...googleapi.Field) *CoursesStudentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesStudentsListCall) IfNoneMatch(entityTag string) *CoursesStudentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesStudentsListCall) Context(ctx context.Context) *CoursesStudentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesStudentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesStudentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/students")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.students.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.students.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListStudentsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesStudentsListCall) Do(opts ...googleapi.CallOption) (*ListStudentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListStudentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.students.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesStudentsListCall) Pages(ctx context.Context, f func(*ListStudentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesTeachersCreateCall struct {
	s          *Service
	courseId   string
	teacher    *Teacher
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a teacher of a course. Domain administrators are permitted
// to directly add
// (https://developers.google.com/workspace/classroom/guides/manage-users)
// users within their domain as teachers to courses within their domain.
// Non-admin users should send an Invitation instead. This method returns the
// following error codes: * `PERMISSION_DENIED` if the requesting user is not
// permitted to create teachers in this course or for access errors. *
// `NOT_FOUND` if the requested course ID does not exist. *
// `FAILED_PRECONDITION` if the requested user's account is disabled, for the
// following request errors: * CourseMemberLimitReached * CourseNotModifiable *
// CourseTeacherLimitReached * UserGroupsMembershipLimitReached *
// InactiveCourseOwner * `ALREADY_EXISTS` if the user is already a teacher or
// student in the course.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesTeachersService) Create(courseId string, teacher *Teacher) *CoursesTeachersCreateCall {
	c := &CoursesTeachersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.teacher = teacher
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTeachersCreateCall) Fields(s ...googleapi.Field) *CoursesTeachersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTeachersCreateCall) Context(ctx context.Context) *CoursesTeachersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTeachersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTeachersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.teacher)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/teachers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.teachers.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.teachers.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Teacher.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesTeachersCreateCall) Do(opts ...googleapi.CallOption) (*Teacher, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Teacher{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.teachers.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesTeachersDeleteCall struct {
	s          *Service
	courseId   string
	userId     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes the specified teacher from the specified course. This method
// returns the following error codes: * `PERMISSION_DENIED` if the requesting
// user is not permitted to delete teachers of this course or for access
// errors. * `NOT_FOUND` if no teacher of this course has the requested ID or
// if the course does not exist. * `FAILED_PRECONDITION` if the requested ID
// belongs to the primary teacher of this course. * `FAILED_PRECONDITION` if
// the requested ID belongs to the owner of the course Drive folder. *
// `FAILED_PRECONDITION` if the course no longer has an active owner.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - userId: Identifier of the teacher to delete. The identifier can be one of
//     the following: * the numeric identifier for the user * the email address
//     of the user * the string literal "me", indicating the requesting user.
func (r *CoursesTeachersService) Delete(courseId string, userId string) *CoursesTeachersDeleteCall {
	c := &CoursesTeachersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.userId = userId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTeachersDeleteCall) Fields(s ...googleapi.Field) *CoursesTeachersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTeachersDeleteCall) Context(ctx context.Context) *CoursesTeachersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTeachersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTeachersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/teachers/{userId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"userId":   c.userId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.teachers.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.teachers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesTeachersDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.teachers.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesTeachersGetCall struct {
	s            *Service
	courseId     string
	userId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a teacher of a course. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting user is not permitted to view
// teachers of this course or for access errors. * `NOT_FOUND` if no teacher of
// this course has the requested ID or if the course does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - userId: Identifier of the teacher to return. The identifier can be one of
//     the following: * the numeric identifier for the user * the email address
//     of the user * the string literal "me", indicating the requesting user.
func (r *CoursesTeachersService) Get(courseId string, userId string) *CoursesTeachersGetCall {
	c := &CoursesTeachersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.userId = userId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTeachersGetCall) Fields(s ...googleapi.Field) *CoursesTeachersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesTeachersGetCall) IfNoneMatch(entityTag string) *CoursesTeachersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTeachersGetCall) Context(ctx context.Context) *CoursesTeachersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTeachersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTeachersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/teachers/{userId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"userId":   c.userId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.teachers.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.teachers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Teacher.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesTeachersGetCall) Do(opts ...googleapi.CallOption) (*Teacher, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Teacher{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.teachers.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesTeachersListCall struct {
	s            *Service
	courseId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of teachers of this course that the requester is
// permitted to view. This method returns the following error codes: *
// `NOT_FOUND` if the course does not exist. * `PERMISSION_DENIED` for access
// errors.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesTeachersService) List(courseId string) *CoursesTeachersListCall {
	c := &CoursesTeachersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. The default is 30 if unspecified or `0`. The server may return fewer
// than the specified number of results.
func (c *CoursesTeachersListCall) PageSize(pageSize int64) *CoursesTeachersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesTeachersListCall) PageToken(pageToken string) *CoursesTeachersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTeachersListCall) Fields(s ...googleapi.Field) *CoursesTeachersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesTeachersListCall) IfNoneMatch(entityTag string) *CoursesTeachersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTeachersListCall) Context(ctx context.Context) *CoursesTeachersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTeachersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTeachersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/teachers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.teachers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.teachers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTeachersResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesTeachersListCall) Do(opts ...googleapi.CallOption) (*ListTeachersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTeachersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.teachers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesTeachersListCall) Pages(ctx context.Context, f func(*ListTeachersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesTopicsCreateCall struct {
	s          *Service
	courseId   string
	topic      *Topic
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a topic. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not permitted to access the
// requested course, create a topic in the requested course, or for access
// errors. * `INVALID_ARGUMENT` if the request is malformed. * `ALREADY_EXISTS`
// if there exists a topic in the course with the same name. *
// `FAILED_PRECONDITION` for the following request error: *
// CourseTopicLimitReached * `NOT_FOUND` if the requested course does not
// exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesTopicsService) Create(courseId string, topic *Topic) *CoursesTopicsCreateCall {
	c := &CoursesTopicsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.topic = topic
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTopicsCreateCall) Fields(s ...googleapi.Field) *CoursesTopicsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTopicsCreateCall) Context(ctx context.Context) *CoursesTopicsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTopicsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTopicsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.topic)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/topics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.topics.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.topics.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Topic.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesTopicsCreateCall) Do(opts ...googleapi.CallOption) (*Topic, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Topic{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.topics.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesTopicsDeleteCall struct {
	s          *Service
	courseId   string
	id         string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a topic. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not allowed to delete the
// requested topic or for access errors. * `FAILED_PRECONDITION` if the
// requested topic has already been deleted. * `NOT_FOUND` if no course or
// topic exists with the requested ID.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the topic to delete.
func (r *CoursesTopicsService) Delete(courseId string, id string) *CoursesTopicsDeleteCall {
	c := &CoursesTopicsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTopicsDeleteCall) Fields(s ...googleapi.Field) *CoursesTopicsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTopicsDeleteCall) Context(ctx context.Context) *CoursesTopicsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTopicsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTopicsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/topics/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.topics.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.topics.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesTopicsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.topics.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesTopicsGetCall struct {
	s            *Service
	courseId     string
	id           string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a topic. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not permitted to access the
// requested course or topic, or for access errors. * `INVALID_ARGUMENT` if the
// request is malformed. * `NOT_FOUND` if the requested course or topic does
// not exist.
//
// - courseId: Identifier of the course.
// - id: Identifier of the topic.
func (r *CoursesTopicsService) Get(courseId string, id string) *CoursesTopicsGetCall {
	c := &CoursesTopicsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTopicsGetCall) Fields(s ...googleapi.Field) *CoursesTopicsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesTopicsGetCall) IfNoneMatch(entityTag string) *CoursesTopicsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTopicsGetCall) Context(ctx context.Context) *CoursesTopicsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTopicsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTopicsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/topics/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.topics.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.topics.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Topic.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesTopicsGetCall) Do(opts ...googleapi.CallOption) (*Topic, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Topic{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.topics.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CoursesTopicsListCall struct {
	s            *Service
	courseId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of topics that the requester is permitted to view.
// This method returns the following error codes: * `PERMISSION_DENIED` if the
// requesting user is not permitted to access the requested course or for
// access errors. * `INVALID_ARGUMENT` if the request is malformed. *
// `NOT_FOUND` if the requested course does not exist.
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
func (r *CoursesTopicsService) List(courseId string) *CoursesTopicsListCall {
	c := &CoursesTopicsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *CoursesTopicsListCall) PageSize(pageSize int64) *CoursesTopicsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *CoursesTopicsListCall) PageToken(pageToken string) *CoursesTopicsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTopicsListCall) Fields(s ...googleapi.Field) *CoursesTopicsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CoursesTopicsListCall) IfNoneMatch(entityTag string) *CoursesTopicsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTopicsListCall) Context(ctx context.Context) *CoursesTopicsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTopicsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTopicsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/topics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.topics.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.topics.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTopicResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CoursesTopicsListCall) Do(opts ...googleapi.CallOption) (*ListTopicResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTopicResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.topics.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CoursesTopicsListCall) Pages(ctx context.Context, f func(*ListTopicResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CoursesTopicsPatchCall struct {
	s          *Service
	courseId   string
	id         string
	topic      *Topic
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates one or more fields of a topic. This method returns the
// following error codes: * `PERMISSION_DENIED` if the requesting developer
// project did not create the corresponding topic or for access errors. *
// `INVALID_ARGUMENT` if the request is malformed. * `FAILED_PRECONDITION` if
// there exists a topic in the course with the same name. * `NOT_FOUND` if the
// requested course or topic does not exist
//
//   - courseId: Identifier of the course. This identifier can be either the
//     Classroom-assigned identifier or an alias.
//   - id: Identifier of the topic.
func (r *CoursesTopicsService) Patch(courseId string, id string, topic *Topic) *CoursesTopicsPatchCall {
	c := &CoursesTopicsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.courseId = courseId
	c.id = id
	c.topic = topic
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the topic to update. This field is required to do an update.
// The update fails if invalid fields are specified. If a field supports empty
// values, it can be cleared by specifying it in the update mask and not in the
// Topic object. If a field that does not support empty values is included in
// the update mask and not set in the Topic object, an `INVALID_ARGUMENT` error
// is returned. The following fields may be specified: * `name`
func (c *CoursesTopicsPatchCall) UpdateMask(updateMask string) *CoursesTopicsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CoursesTopicsPatchCall) Fields(s ...googleapi.Field) *CoursesTopicsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CoursesTopicsPatchCall) Context(ctx context.Context) *CoursesTopicsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CoursesTopicsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CoursesTopicsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.topic)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/courses/{courseId}/topics/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"courseId": c.courseId,
		"id":       c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.courses.topics.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.courses.topics.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Topic.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CoursesTopicsPatchCall) Do(opts ...googleapi.CallOption) (*Topic, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Topic{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.courses.topics.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InvitationsAcceptCall struct {
	s          *Service
	id         string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Accept: Accepts an invitation, removing it and adding the invited user to
// the teachers or students (as appropriate) of the specified course. Only the
// invited user may accept an invitation. This method returns the following
// error codes: * `PERMISSION_DENIED` if the requesting user is not permitted
// to accept the requested invitation or for access errors. *
// `FAILED_PRECONDITION` for the following request errors: *
// CourseMemberLimitReached * CourseNotModifiable * CourseTeacherLimitReached *
// UserGroupsMembershipLimitReached * `NOT_FOUND` if no invitation exists with
// the requested ID.
//
// - id: Identifier of the invitation to accept.
func (r *InvitationsService) Accept(id string) *InvitationsAcceptCall {
	c := &InvitationsAcceptCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InvitationsAcceptCall) Fields(s ...googleapi.Field) *InvitationsAcceptCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InvitationsAcceptCall) Context(ctx context.Context) *InvitationsAcceptCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InvitationsAcceptCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InvitationsAcceptCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/invitations/{id}:accept")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"id": c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.invitations.accept", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.invitations.accept" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InvitationsAcceptCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.invitations.accept", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InvitationsCreateCall struct {
	s          *Service
	invitation *Invitation
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an invitation. Only one invitation for a user and course may
// exist at a time. Delete and re-create an invitation to make changes. This
// method returns the following error codes: * `PERMISSION_DENIED` if the
// requesting user is not permitted to create invitations for this course or
// for access errors. * `NOT_FOUND` if the course or the user does not exist. *
// `FAILED_PRECONDITION`: * if the requested user's account is disabled. * if
// the user already has this role or a role with greater permissions. * for the
// following request errors: * IneligibleOwner * `ALREADY_EXISTS` if an
// invitation for the specified user and course already exists.
func (r *InvitationsService) Create(invitation *Invitation) *InvitationsCreateCall {
	c := &InvitationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.invitation = invitation
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InvitationsCreateCall) Fields(s ...googleapi.Field) *InvitationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InvitationsCreateCall) Context(ctx context.Context) *InvitationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InvitationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InvitationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.invitation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/invitations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.invitations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.invitations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Invitation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InvitationsCreateCall) Do(opts ...googleapi.CallOption) (*Invitation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Invitation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.invitations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InvitationsDeleteCall struct {
	s          *Service
	id         string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an invitation. This method returns the following error
// codes: * `PERMISSION_DENIED` if the requesting user is not permitted to
// delete the requested invitation or for access errors. * `NOT_FOUND` if no
// invitation exists with the requested ID.
//
// - id: Identifier of the invitation to delete.
func (r *InvitationsService) Delete(id string) *InvitationsDeleteCall {
	c := &InvitationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InvitationsDeleteCall) Fields(s ...googleapi.Field) *InvitationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InvitationsDeleteCall) Context(ctx context.Context) *InvitationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InvitationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InvitationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/invitations/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"id": c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.invitations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.invitations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InvitationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.invitations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InvitationsGetCall struct {
	s            *Service
	id           string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns an invitation. This method returns the following error codes: *
// `PERMISSION_DENIED` if the requesting user is not permitted to view the
// requested invitation or for access errors. * `NOT_FOUND` if no invitation
// exists with the requested ID.
//
// - id: Identifier of the invitation to return.
func (r *InvitationsService) Get(id string) *InvitationsGetCall {
	c := &InvitationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InvitationsGetCall) Fields(s ...googleapi.Field) *InvitationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InvitationsGetCall) IfNoneMatch(entityTag string) *InvitationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InvitationsGetCall) Context(ctx context.Context) *InvitationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InvitationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InvitationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/invitations/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"id": c.id,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.invitations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.invitations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Invitation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InvitationsGetCall) Do(opts ...googleapi.CallOption) (*Invitation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Invitation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.invitations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InvitationsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of invitations that the requesting user is permitted to
// view, restricted to those that match the list request. *Note:* At least one
// of `user_id` or `course_id` must be supplied. Both fields can be supplied.
// This method returns the following error codes: * `PERMISSION_DENIED` for
// access errors.
func (r *InvitationsService) List() *InvitationsListCall {
	c := &InvitationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// CourseId sets the optional parameter "courseId": Restricts returned
// invitations to those for a course with the specified identifier.
func (c *InvitationsListCall) CourseId(courseId string) *InvitationsListCall {
	c.urlParams_.Set("courseId", courseId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. The default is 500 if unspecified or `0`. The server may return
// fewer than the specified number of results.
func (c *InvitationsListCall) PageSize(pageSize int64) *InvitationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *InvitationsListCall) PageToken(pageToken string) *InvitationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// UserId sets the optional parameter "userId": Restricts returned invitations
// to those for a specific user. The identifier can be one of the following: *
// the numeric identifier for the user * the email address of the user * the
// string literal "me", indicating the requesting user
func (c *InvitationsListCall) UserId(userId string) *InvitationsListCall {
	c.urlParams_.Set("userId", userId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InvitationsListCall) Fields(s ...googleapi.Field) *InvitationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InvitationsListCall) IfNoneMatch(entityTag string) *InvitationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InvitationsListCall) Context(ctx context.Context) *InvitationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InvitationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InvitationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/invitations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.invitations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.invitations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInvitationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InvitationsListCall) Do(opts ...googleapi.CallOption) (*ListInvitationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInvitationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.invitations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *InvitationsListCall) Pages(ctx context.Context, f func(*ListInvitationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegistrationsCreateCall struct {
	s            *Service
	registration *Registration
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a `Registration`, causing Classroom to start sending
// notifications from the provided `feed` to the destination provided in
// `cloudPubSubTopic`. Returns the created `Registration`. Currently, this will
// be the same as the argument, but with server-assigned fields such as
// `expiry_time` and `id` filled in. Note that any value specified for the
// `expiry_time` or `id` fields will be ignored. While Classroom may validate
// the `cloudPubSubTopic` and return errors on a best effort basis, it is the
// caller's responsibility to ensure that it exists and that Classroom has
// permission to publish to it. This method may return the following error
// codes: * `PERMISSION_DENIED` if: * the authenticated user does not have
// permission to receive notifications from the requested field; or * the
// current user has not granted access to the current Cloud project with the
// appropriate scope for the requested feed. Note that domain-wide delegation
// of authority is not currently supported for this purpose. If the request has
// the appropriate scope, but no grant exists, a Request Errors is returned. *
// another access error is encountered. * `INVALID_ARGUMENT` if: * no
// `cloudPubsubTopic` is specified, or the specified `cloudPubsubTopic` is not
// valid; or * no `feed` is specified, or the specified `feed` is not valid. *
// `NOT_FOUND` if: * the specified `feed` cannot be located, or the requesting
// user does not have permission to determine whether or not it exists; or *
// the specified `cloudPubsubTopic` cannot be located, or Classroom has not
// been granted permission to publish to it.
func (r *RegistrationsService) Create(registration *Registration) *RegistrationsCreateCall {
	c := &RegistrationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.registration = registration
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegistrationsCreateCall) Fields(s ...googleapi.Field) *RegistrationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegistrationsCreateCall) Context(ctx context.Context) *RegistrationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegistrationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegistrationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.registration)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/registrations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.registrations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.registrations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Registration.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegistrationsCreateCall) Do(opts ...googleapi.CallOption) (*Registration, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Registration{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.registrations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegistrationsDeleteCall struct {
	s              *Service
	registrationId string
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Delete: Deletes a `Registration`, causing Classroom to stop sending
// notifications for that `Registration`.
//
// - registrationId: The `registration_id` of the `Registration` to be deleted.
func (r *RegistrationsService) Delete(registrationId string) *RegistrationsDeleteCall {
	c := &RegistrationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.registrationId = registrationId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegistrationsDeleteCall) Fields(s ...googleapi.Field) *RegistrationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegistrationsDeleteCall) Context(ctx context.Context) *RegistrationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegistrationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegistrationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/registrations/{registrationId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"registrationId": c.registrationId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.registrations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.registrations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegistrationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.registrations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UserProfilesGetCall struct {
	s            *Service
	userId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a user profile. This method returns the following error codes:
// * `PERMISSION_DENIED` if the requesting user is not permitted to access this
// user profile, if no profile exists with the requested ID, or for access
// errors.
//
//   - userId: Identifier of the profile to return. The identifier can be one of
//     the following: * the numeric identifier for the user * the email address
//     of the user * the string literal "me", indicating the requesting user.
func (r *UserProfilesService) Get(userId string) *UserProfilesGetCall {
	c := &UserProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userId = userId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserProfilesGetCall) Fields(s ...googleapi.Field) *UserProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UserProfilesGetCall) IfNoneMatch(entityTag string) *UserProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserProfilesGetCall) Context(ctx context.Context) *UserProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/userProfiles/{userId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userId": c.userId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.userProfiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.userProfiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserProfile.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UserProfilesGetCall) Do(opts ...googleapi.CallOption) (*UserProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.userProfiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UserProfilesGuardianInvitationsCreateCall struct {
	s                  *Service
	studentId          string
	guardianinvitation *GuardianInvitation
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Creates a guardian invitation, and sends an email to the guardian
// asking them to confirm that they are the student's guardian. Once the
// guardian accepts the invitation, their `state` will change to `COMPLETED`
// and they will start receiving guardian notifications. A `Guardian` resource
// will also be created to represent the active guardian. The request object
// must have the `student_id` and `invited_email_address` fields set. Failing
// to set these fields, or setting any other fields in the request, will result
// in an error. This method returns the following error codes: *
// `PERMISSION_DENIED` if the current user does not have permission to manage
// guardians, if the guardian in question has already rejected too many
// requests for that student, if guardians are not enabled for the domain in
// question, or for other access errors. * `RESOURCE_EXHAUSTED` if the student
// or guardian has exceeded the guardian link limit. * `INVALID_ARGUMENT` if
// the guardian email address is not valid (for example, if it is too long), or
// if the format of the student ID provided cannot be recognized (it is not an
// email address, nor a `user_id` from this API). This error will also be
// returned if read-only fields are set, or if the `state` field is set to to a
// value other than `PENDING`. * `NOT_FOUND` if the student ID provided is a
// valid student ID, but Classroom has no record of that student. *
// `ALREADY_EXISTS` if there is already a pending guardian invitation for the
// student and `invited_email_address` provided, or if the provided
// `invited_email_address` matches the Google account of an existing `Guardian`
// for this user.
//
// - studentId: ID of the student (in standard format).
func (r *UserProfilesGuardianInvitationsService) Create(studentId string, guardianinvitation *GuardianInvitation) *UserProfilesGuardianInvitationsCreateCall {
	c := &UserProfilesGuardianInvitationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.studentId = studentId
	c.guardianinvitation = guardianinvitation
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserProfilesGuardianInvitationsCreateCall) Fields(s ...googleapi.Field) *UserProfilesGuardianInvitationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserProfilesGuardianInvitationsCreateCall) Context(ctx context.Context) *UserProfilesGuardianInvitationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserProfilesGuardianInvitationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserProfilesGuardianInvitationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.guardianinvitation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/userProfiles/{studentId}/guardianInvitations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"studentId": c.studentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardianInvitations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.userProfiles.guardianInvitations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GuardianInvitation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *UserProfilesGuardianInvitationsCreateCall) Do(opts ...googleapi.CallOption) (*GuardianInvitation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GuardianInvitation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardianInvitations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UserProfilesGuardianInvitationsGetCall struct {
	s            *Service
	studentId    string
	invitationId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a specific guardian invitation. This method returns the
// following error codes: * `PERMISSION_DENIED` if the requesting user is not
// permitted to view guardian invitations for the student identified by the
// `student_id`, if guardians are not enabled for the domain in question, or
// for other access errors. * `INVALID_ARGUMENT` if a `student_id` is
// specified, but its format cannot be recognized (it is not an email address,
// nor a `student_id` from the API, nor the literal string `me`). * `NOT_FOUND`
// if Classroom cannot find any record of the given student or `invitation_id`.
// May also be returned if the student exists, but the requesting user does not
// have access to see that student.
//
//   - invitationId: The `id` field of the `GuardianInvitation` being requested.
//   - studentId: The ID of the student whose guardian invitation is being
//     requested.
func (r *UserProfilesGuardianInvitationsService) Get(studentId string, invitationId string) *UserProfilesGuardianInvitationsGetCall {
	c := &UserProfilesGuardianInvitationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.studentId = studentId
	c.invitationId = invitationId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserProfilesGuardianInvitationsGetCall) Fields(s ...googleapi.Field) *UserProfilesGuardianInvitationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UserProfilesGuardianInvitationsGetCall) IfNoneMatch(entityTag string) *UserProfilesGuardianInvitationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserProfilesGuardianInvitationsGetCall) Context(ctx context.Context) *UserProfilesGuardianInvitationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserProfilesGuardianInvitationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserProfilesGuardianInvitationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/userProfiles/{studentId}/guardianInvitations/{invitationId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"studentId":    c.studentId,
		"invitationId": c.invitationId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardianInvitations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.userProfiles.guardianInvitations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GuardianInvitation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *UserProfilesGuardianInvitationsGetCall) Do(opts ...googleapi.CallOption) (*GuardianInvitation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GuardianInvitation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardianInvitations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UserProfilesGuardianInvitationsListCall struct {
	s            *Service
	studentId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of guardian invitations that the requesting user is
// permitted to view, filtered by the parameters provided. This method returns
// the following error codes: * `PERMISSION_DENIED` if a `student_id` is
// specified, and the requesting user is not permitted to view guardian
// invitations for that student, if "-" is specified as the `student_id` and
// the user is not a domain administrator, if guardians are not enabled for the
// domain in question, or for other access errors. * `INVALID_ARGUMENT` if a
// `student_id` is specified, but its format cannot be recognized (it is not an
// email address, nor a `student_id` from the API, nor the literal string
// `me`). May also be returned if an invalid `page_token` or `state` is
// provided. * `NOT_FOUND` if a `student_id` is specified, and its format can
// be recognized, but Classroom has no record of that student.
//
//   - studentId: The ID of the student whose guardian invitations are to be
//     returned. The identifier can be one of the following: * the numeric
//     identifier for the user * the email address of the user * the string
//     literal "me", indicating the requesting user * the string literal "-",
//     indicating that results should be returned for all students that the
//     requesting user is permitted to view guardian invitations.
func (r *UserProfilesGuardianInvitationsService) List(studentId string) *UserProfilesGuardianInvitationsListCall {
	c := &UserProfilesGuardianInvitationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.studentId = studentId
	return c
}

// InvitedEmailAddress sets the optional parameter "invitedEmailAddress": If
// specified, only results with the specified `invited_email_address` are
// returned.
func (c *UserProfilesGuardianInvitationsListCall) InvitedEmailAddress(invitedEmailAddress string) *UserProfilesGuardianInvitationsListCall {
	c.urlParams_.Set("invitedEmailAddress", invitedEmailAddress)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *UserProfilesGuardianInvitationsListCall) PageSize(pageSize int64) *UserProfilesGuardianInvitationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *UserProfilesGuardianInvitationsListCall) PageToken(pageToken string) *UserProfilesGuardianInvitationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// States sets the optional parameter "states": If specified, only results with
// the specified `state` values are returned. Otherwise, results with a `state`
// of `PENDING` are returned.
//
// Possible values:
//
//	"GUARDIAN_INVITATION_STATE_UNSPECIFIED" - Should never be returned.
//	"PENDING" - The invitation is active and awaiting a response.
//	"COMPLETE" - The invitation is no longer active. It may have been
//
// accepted, declined, withdrawn or it may have expired.
func (c *UserProfilesGuardianInvitationsListCall) States(states ...string) *UserProfilesGuardianInvitationsListCall {
	c.urlParams_.SetMulti("states", append([]string{}, states...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserProfilesGuardianInvitationsListCall) Fields(s ...googleapi.Field) *UserProfilesGuardianInvitationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UserProfilesGuardianInvitationsListCall) IfNoneMatch(entityTag string) *UserProfilesGuardianInvitationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserProfilesGuardianInvitationsListCall) Context(ctx context.Context) *UserProfilesGuardianInvitationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserProfilesGuardianInvitationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserProfilesGuardianInvitationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/userProfiles/{studentId}/guardianInvitations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"studentId": c.studentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardianInvitations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.userProfiles.guardianInvitations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGuardianInvitationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *UserProfilesGuardianInvitationsListCall) Do(opts ...googleapi.CallOption) (*ListGuardianInvitationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGuardianInvitationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardianInvitations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *UserProfilesGuardianInvitationsListCall) Pages(ctx context.Context, f func(*ListGuardianInvitationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type UserProfilesGuardianInvitationsPatchCall struct {
	s                  *Service
	studentId          string
	invitationId       string
	guardianinvitation *GuardianInvitation
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Modifies a guardian invitation. Currently, the only valid
// modification is to change the `state` from `PENDING` to `COMPLETE`. This has
// the effect of withdrawing the invitation. This method returns the following
// error codes: * `PERMISSION_DENIED` if the current user does not have
// permission to manage guardians, if guardians are not enabled for the domain
// in question or for other access errors. * `FAILED_PRECONDITION` if the
// guardian link is not in the `PENDING` state. * `INVALID_ARGUMENT` if the
// format of the student ID provided cannot be recognized (it is not an email
// address, nor a `user_id` from this API), or if the passed
// `GuardianInvitation` has a `state` other than `COMPLETE`, or if it modifies
// fields other than `state`. * `NOT_FOUND` if the student ID provided is a
// valid student ID, but Classroom has no record of that student, or if the
// `id` field does not refer to a guardian invitation known to Classroom.
//
//   - invitationId: The `id` field of the `GuardianInvitation` to be modified.
//   - studentId: The ID of the student whose guardian invitation is to be
//     modified.
func (r *UserProfilesGuardianInvitationsService) Patch(studentId string, invitationId string, guardianinvitation *GuardianInvitation) *UserProfilesGuardianInvitationsPatchCall {
	c := &UserProfilesGuardianInvitationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.studentId = studentId
	c.invitationId = invitationId
	c.guardianinvitation = guardianinvitation
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask that identifies
// which fields on the course to update. This field is required to do an
// update. The update fails if invalid fields are specified. The following
// fields are valid: * `state` When set in a query parameter, this field should
// be specified as `updateMask=,,...`
func (c *UserProfilesGuardianInvitationsPatchCall) UpdateMask(updateMask string) *UserProfilesGuardianInvitationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserProfilesGuardianInvitationsPatchCall) Fields(s ...googleapi.Field) *UserProfilesGuardianInvitationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserProfilesGuardianInvitationsPatchCall) Context(ctx context.Context) *UserProfilesGuardianInvitationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserProfilesGuardianInvitationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserProfilesGuardianInvitationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.guardianinvitation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/userProfiles/{studentId}/guardianInvitations/{invitationId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"studentId":    c.studentId,
		"invitationId": c.invitationId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardianInvitations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.userProfiles.guardianInvitations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GuardianInvitation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *UserProfilesGuardianInvitationsPatchCall) Do(opts ...googleapi.CallOption) (*GuardianInvitation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GuardianInvitation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardianInvitations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UserProfilesGuardiansDeleteCall struct {
	s          *Service
	studentId  string
	guardianId string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a guardian. The guardian will no longer receive guardian
// notifications and the guardian will no longer be accessible via the API.
// This method returns the following error codes: * `PERMISSION_DENIED` if no
// user that matches the provided `student_id` is visible to the requesting
// user, if the requesting user is not permitted to manage guardians for the
// student identified by the `student_id`, if guardians are not enabled for the
// domain in question, or for other access errors. * `INVALID_ARGUMENT` if a
// `student_id` is specified, but its format cannot be recognized (it is not an
// email address, nor a `student_id` from the API). * `NOT_FOUND` if the
// requesting user is permitted to modify guardians for the requested
// `student_id`, but no `Guardian` record exists for that student with the
// provided `guardian_id`.
//
//   - guardianId: The `id` field from a `Guardian`.
//   - studentId: The student whose guardian is to be deleted. One of the
//     following: * the numeric identifier for the user * the email address of
//     the user * the string literal "me", indicating the requesting user.
func (r *UserProfilesGuardiansService) Delete(studentId string, guardianId string) *UserProfilesGuardiansDeleteCall {
	c := &UserProfilesGuardiansDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.studentId = studentId
	c.guardianId = guardianId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserProfilesGuardiansDeleteCall) Fields(s ...googleapi.Field) *UserProfilesGuardiansDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserProfilesGuardiansDeleteCall) Context(ctx context.Context) *UserProfilesGuardiansDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserProfilesGuardiansDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserProfilesGuardiansDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/userProfiles/{studentId}/guardians/{guardianId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"studentId":  c.studentId,
		"guardianId": c.guardianId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardians.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.userProfiles.guardians.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UserProfilesGuardiansDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardians.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UserProfilesGuardiansGetCall struct {
	s            *Service
	studentId    string
	guardianId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a specific guardian. This method returns the following error
// codes: * `PERMISSION_DENIED` if no user that matches the provided
// `student_id` is visible to the requesting user, if the requesting user is
// not permitted to view guardian information for the student identified by the
// `student_id`, if guardians are not enabled for the domain in question, or
// for other access errors. * `INVALID_ARGUMENT` if a `student_id` is
// specified, but its format cannot be recognized (it is not an email address,
// nor a `student_id` from the API, nor the literal string `me`). * `NOT_FOUND`
// if the requesting user is permitted to view guardians for the requested
// `student_id`, but no `Guardian` record exists for that student that matches
// the provided `guardian_id`.
//
//   - guardianId: The `id` field from a `Guardian`.
//   - studentId: The student whose guardian is being requested. One of the
//     following: * the numeric identifier for the user * the email address of
//     the user * the string literal "me", indicating the requesting user.
func (r *UserProfilesGuardiansService) Get(studentId string, guardianId string) *UserProfilesGuardiansGetCall {
	c := &UserProfilesGuardiansGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.studentId = studentId
	c.guardianId = guardianId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserProfilesGuardiansGetCall) Fields(s ...googleapi.Field) *UserProfilesGuardiansGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UserProfilesGuardiansGetCall) IfNoneMatch(entityTag string) *UserProfilesGuardiansGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserProfilesGuardiansGetCall) Context(ctx context.Context) *UserProfilesGuardiansGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserProfilesGuardiansGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserProfilesGuardiansGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/userProfiles/{studentId}/guardians/{guardianId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"studentId":  c.studentId,
		"guardianId": c.guardianId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardians.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.userProfiles.guardians.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Guardian.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UserProfilesGuardiansGetCall) Do(opts ...googleapi.CallOption) (*Guardian, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Guardian{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardians.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UserProfilesGuardiansListCall struct {
	s            *Service
	studentId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of guardians that the requesting user is permitted to
// view, restricted to those that match the request. To list guardians for any
// student that the requesting user may view guardians for, use the literal
// character `-` for the student ID. This method returns the following error
// codes: * `PERMISSION_DENIED` if a `student_id` is specified, and the
// requesting user is not permitted to view guardian information for that
// student, if "-" is specified as the `student_id` and the user is not a
// domain administrator, if guardians are not enabled for the domain in
// question, if the `invited_email_address` filter is set by a user who is not
// a domain administrator, or for other access errors. * `INVALID_ARGUMENT` if
// a `student_id` is specified, but its format cannot be recognized (it is not
// an email address, nor a `student_id` from the API, nor the literal string
// `me`). May also be returned if an invalid `page_token` is provided. *
// `NOT_FOUND` if a `student_id` is specified, and its format can be
// recognized, but Classroom has no record of that student.
//
//   - studentId: Filter results by the student who the guardian is linked to.
//     The identifier can be one of the following: * the numeric identifier for
//     the user * the email address of the user * the string literal "me",
//     indicating the requesting user * the string literal "-", indicating that
//     results should be returned for all students that the requesting user has
//     access to view.
func (r *UserProfilesGuardiansService) List(studentId string) *UserProfilesGuardiansListCall {
	c := &UserProfilesGuardiansListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.studentId = studentId
	return c
}

// InvitedEmailAddress sets the optional parameter "invitedEmailAddress":
// Filter results by the email address that the original invitation was sent
// to, resulting in this guardian link. This filter can only be used by domain
// administrators.
func (c *UserProfilesGuardiansListCall) InvitedEmailAddress(invitedEmailAddress string) *UserProfilesGuardiansListCall {
	c.urlParams_.Set("invitedEmailAddress", invitedEmailAddress)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of items to
// return. Zero or unspecified indicates that the server may assign a maximum.
// The server may return fewer than the specified number of results.
func (c *UserProfilesGuardiansListCall) PageSize(pageSize int64) *UserProfilesGuardiansListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": nextPageToken value
// returned from a previous list call, indicating that the subsequent page of
// results should be returned. The list request must be otherwise identical to
// the one that resulted in this token.
func (c *UserProfilesGuardiansListCall) PageToken(pageToken string) *UserProfilesGuardiansListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserProfilesGuardiansListCall) Fields(s ...googleapi.Field) *UserProfilesGuardiansListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UserProfilesGuardiansListCall) IfNoneMatch(entityTag string) *UserProfilesGuardiansListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserProfilesGuardiansListCall) Context(ctx context.Context) *UserProfilesGuardiansListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserProfilesGuardiansListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserProfilesGuardiansListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/userProfiles/{studentId}/guardians")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"studentId": c.studentId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardians.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "classroom.userProfiles.guardians.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGuardiansResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *UserProfilesGuardiansListCall) Do(opts ...googleapi.CallOption) (*ListGuardiansResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGuardiansResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "classroom.userProfiles.guardians.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *UserProfilesGuardiansListCall) Pages(ctx context.Context, f func(*ListGuardiansResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
