// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package notebooks provides access to the Notebooks API.
//
// For product documentation, see: https://cloud.google.com/notebooks/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/notebooks/v1"
//	...
//	ctx := context.Background()
//	notebooksService, err := notebooks.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	notebooksService, err := notebooks.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	notebooksService, err := notebooks.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package notebooks // import "google.golang.org/api/notebooks/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "notebooks:v1"
const apiName = "notebooks"
const apiVersion = "v1"
const basePath = "https://notebooks.googleapis.com/"
const basePathTemplate = "https://notebooks.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://notebooks.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Environments = NewProjectsLocationsEnvironmentsService(s)
	rs.Executions = NewProjectsLocationsExecutionsService(s)
	rs.Instances = NewProjectsLocationsInstancesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.Runtimes = NewProjectsLocationsRuntimesService(s)
	rs.Schedules = NewProjectsLocationsSchedulesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Environments *ProjectsLocationsEnvironmentsService

	Executions *ProjectsLocationsExecutionsService

	Instances *ProjectsLocationsInstancesService

	Operations *ProjectsLocationsOperationsService

	Runtimes *ProjectsLocationsRuntimesService

	Schedules *ProjectsLocationsSchedulesService
}

func NewProjectsLocationsEnvironmentsService(s *Service) *ProjectsLocationsEnvironmentsService {
	rs := &ProjectsLocationsEnvironmentsService{s: s}
	return rs
}

type ProjectsLocationsEnvironmentsService struct {
	s *Service
}

func NewProjectsLocationsExecutionsService(s *Service) *ProjectsLocationsExecutionsService {
	rs := &ProjectsLocationsExecutionsService{s: s}
	return rs
}

type ProjectsLocationsExecutionsService struct {
	s *Service
}

func NewProjectsLocationsInstancesService(s *Service) *ProjectsLocationsInstancesService {
	rs := &ProjectsLocationsInstancesService{s: s}
	return rs
}

type ProjectsLocationsInstancesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRuntimesService(s *Service) *ProjectsLocationsRuntimesService {
	rs := &ProjectsLocationsRuntimesService{s: s}
	return rs
}

type ProjectsLocationsRuntimesService struct {
	s *Service
}

func NewProjectsLocationsSchedulesService(s *Service) *ProjectsLocationsSchedulesService {
	rs := &ProjectsLocationsSchedulesService{s: s}
	return rs
}

type ProjectsLocationsSchedulesService struct {
	s *Service
}

// AcceleratorConfig: Definition of a hardware accelerator. Note that not all
// combinations of `type` and `core_count` are valid. See GPUs on Compute
// Engine (https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a
// valid combination. TPUs are not supported.
type AcceleratorConfig struct {
	// CoreCount: Count of cores of this accelerator.
	CoreCount int64 `json:"coreCount,omitempty,string"`
	// Type: Type of this accelerator.
	//
	// Possible values:
	//   "ACCELERATOR_TYPE_UNSPECIFIED" - Accelerator type is not specified.
	//   "NVIDIA_TESLA_K80" - Accelerator type is Nvidia Tesla K80.
	//   "NVIDIA_TESLA_P100" - Accelerator type is Nvidia Tesla P100.
	//   "NVIDIA_TESLA_V100" - Accelerator type is Nvidia Tesla V100.
	//   "NVIDIA_TESLA_P4" - Accelerator type is Nvidia Tesla P4.
	//   "NVIDIA_TESLA_T4" - Accelerator type is Nvidia Tesla T4.
	//   "NVIDIA_TESLA_A100" - Accelerator type is Nvidia Tesla A100.
	//   "NVIDIA_L4" - Accelerator type is Nvidia Tesla L4.
	//   "NVIDIA_A100_80GB" - Accelerator type is Nvidia Tesla A100 80GB.
	//   "NVIDIA_TESLA_T4_VWS" - Accelerator type is NVIDIA Tesla T4 Virtual
	// Workstations.
	//   "NVIDIA_TESLA_P100_VWS" - Accelerator type is NVIDIA Tesla P100 Virtual
	// Workstations.
	//   "NVIDIA_TESLA_P4_VWS" - Accelerator type is NVIDIA Tesla P4 Virtual
	// Workstations.
	//   "NVIDIA_H100_80GB" - Accelerator type is NVIDIA H100 80GB.
	//   "NVIDIA_H100_MEGA_80GB" - Accelerator type is NVIDIA H100 Mega 80GB.
	//   "TPU_V2" - (Coming soon) Accelerator type is TPU V2.
	//   "TPU_V3" - (Coming soon) Accelerator type is TPU V3.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoreCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoreCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AcceleratorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BootImage: Definition of the boot image used by the Runtime. Used to
// facilitate runtime upgradeability.
type BootImage struct {
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// ContainerImage: Definition of a container image for starting a notebook
// instance with the environment installed in a container.
type ContainerImage struct {
	// Repository: Required. The path to the container image repository. For
	// example: `gcr.io/{project_id}/{image_name}`
	Repository string `json:"repository,omitempty"`
	// Tag: The tag of the container image. If not specified, this defaults to the
	// latest tag.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Repository") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Repository") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContainerImage) MarshalJSON() ([]byte, error) {
	type NoMethod ContainerImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataprocParameters: Parameters used in Dataproc JobType executions.
type DataprocParameters struct {
	// Cluster: URI for cluster used to run Dataproc execution. Format:
	// `projects/{PROJECT_ID}/regions/{REGION}/clusters/{CLUSTER_NAME}`
	Cluster string `json:"cluster,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cluster") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cluster") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataprocParameters) MarshalJSON() ([]byte, error) {
	type NoMethod DataprocParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiagnoseInstanceRequest: Request for creating a notebook instance diagnostic
// file.
type DiagnoseInstanceRequest struct {
	// DiagnosticConfig: Required. Defines flags that are used to run the
	// diagnostic tool
	DiagnosticConfig *DiagnosticConfig `json:"diagnosticConfig,omitempty"`
	// TimeoutMinutes: Optional. Maximum amount of time in minutes before the
	// operation times out.
	TimeoutMinutes int64 `json:"timeoutMinutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiagnosticConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiagnosticConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiagnoseInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DiagnoseInstanceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiagnoseRuntimeRequest: Request for creating a notebook instance diagnostic
// file.
type DiagnoseRuntimeRequest struct {
	// DiagnosticConfig: Required. Defines flags that are used to run the
	// diagnostic tool
	DiagnosticConfig *DiagnosticConfig `json:"diagnosticConfig,omitempty"`
	// TimeoutMinutes: Optional. Maximum amount of time in minutes before the
	// operation times out.
	TimeoutMinutes int64 `json:"timeoutMinutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiagnosticConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiagnosticConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiagnoseRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DiagnoseRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiagnosticConfig: Defines flags that are used to run the diagnostic tool
type DiagnosticConfig struct {
	// CopyHomeFilesFlagEnabled: Optional. Enables flag to copy all `/home/jupyter`
	// folder contents
	CopyHomeFilesFlagEnabled bool `json:"copyHomeFilesFlagEnabled,omitempty"`
	// GcsBucket: Required. User Cloud Storage bucket location (REQUIRED). Must be
	// formatted with path prefix (`gs://$GCS_BUCKET`). Permissions: User Managed
	// Notebooks: - storage.buckets.writer: Must be given to the project's service
	// account attached to VM. Google Managed Notebooks: - storage.buckets.writer:
	// Must be given to the project's service account or user credentials attached
	// to VM depending on authentication mode. Cloud Storage bucket Log file will
	// be written to `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
	GcsBucket string `json:"gcsBucket,omitempty"`
	// PacketCaptureFlagEnabled: Optional. Enables flag to capture packets from the
	// instance for 30 seconds
	PacketCaptureFlagEnabled bool `json:"packetCaptureFlagEnabled,omitempty"`
	// RelativePath: Optional. Defines the relative storage path in the Cloud
	// Storage bucket where the diagnostic logs will be written: Default path will
	// be the root directory of the Cloud Storage bucket
	// (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file
	// will be written: `gs://$GCS_BUCKET/$RELATIVE_PATH/`
	RelativePath string `json:"relativePath,omitempty"`
	// RepairFlagEnabled: Optional. Enables flag to repair service for instance
	RepairFlagEnabled bool `json:"repairFlagEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CopyHomeFilesFlagEnabled")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CopyHomeFilesFlagEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiagnosticConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DiagnosticConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Disk: An instance-attached disk resource.
type Disk struct {
	// AutoDelete: Indicates whether the disk will be auto-deleted when the
	// instance is deleted (but not when the disk is detached from the instance).
	AutoDelete bool `json:"autoDelete,omitempty"`
	// Boot: Indicates that this is a boot disk. The virtual machine will use the
	// first partition of the disk for its root filesystem.
	Boot bool `json:"boot,omitempty"`
	// DeviceName: Indicates a unique device name of your choice that is reflected
	// into the `/dev/disk/by-id/google-*` tree of a Linux operating system running
	// within the instance. This name can be used to reference the device for
	// mounting, resizing, and so on, from within the instance. If not specified,
	// the server chooses a default device name to apply to this disk, in the form
	// persistent-disk-x, where x is a number assigned by Google Compute
	// Engine.This field is only applicable for persistent disks.
	DeviceName string `json:"deviceName,omitempty"`
	// DiskSizeGb: Indicates the size of the disk in base-2 GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`
	// GuestOsFeatures: Indicates a list of features to enable on the guest
	// operating system. Applicable only for bootable images. Read Enabling guest
	// operating system features to see a list of available options.
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`
	// Index: A zero-based index to this disk, where 0 is reserved for the boot
	// disk. If you have many disks attached to an instance, each disk would have a
	// unique index number.
	Index int64 `json:"index,omitempty,string"`
	// Interface: Indicates the disk interface to use for attaching this disk,
	// which is either SCSI or NVME. The default is SCSI. Persistent disks must
	// always use SCSI and the request will fail if you attempt to attach a
	// persistent disk in any other format than SCSI. Local SSDs can use either
	// NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local
	// SSD performance. Valid values: * `NVME` * `SCSI`
	Interface string `json:"interface,omitempty"`
	// Kind: Type of the resource. Always compute#attachedDisk for attached disks.
	Kind string `json:"kind,omitempty"`
	// Licenses: A list of publicly visible licenses. Reserved for Google's use. A
	// License represents billing and aggregate usage data for public and
	// marketplace images.
	Licenses []string `json:"licenses,omitempty"`
	// Mode: The mode in which to attach this disk, either `READ_WRITE` or
	// `READ_ONLY`. If not specified, the default is to attach the disk in
	// `READ_WRITE` mode. Valid values: * `READ_ONLY` * `READ_WRITE`
	Mode string `json:"mode,omitempty"`
	// Source: Indicates a valid partial or full URL to an existing Persistent Disk
	// resource.
	Source string `json:"source,omitempty"`
	// Type: Indicates the type of the disk, either `SCRATCH` or `PERSISTENT`.
	// Valid values: * `PERSISTENT` * `SCRATCH`
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoDelete") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoDelete") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Disk) MarshalJSON() ([]byte, error) {
	type NoMethod Disk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EncryptionConfig: Represents a custom encryption key configuration that can
// be applied to a resource. This will encrypt all disks in Virtual Machine.
type EncryptionConfig struct {
	// KmsKey: The Cloud KMS resource identifier of the customer-managed encryption
	// key used to protect a resource, such as a disks. It has the following
	// format:
	// `projects/{PROJECT_ID}/locations/{REGION}/keyRings/{KEY_RING_NAME}/cryptoKeys
	// /{KEY_NAME}`
	KmsKey string `json:"kmsKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EncryptionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Environment: Definition of a software environment that is used to start a
// notebook instance.
type Environment struct {
	// ContainerImage: Use a container image to start the notebook instance.
	ContainerImage *ContainerImage `json:"containerImage,omitempty"`
	// CreateTime: Output only. The time at which this environment was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A brief description of this environment.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name of this environment for the UI.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. Name of this environment. Format:
	// `projects/{project_id}/locations/{location}/environments/{environment_id}`
	Name string `json:"name,omitempty"`
	// PostStartupScript: Path to a Bash script that automatically runs after a
	// notebook instance fully boots up. The path must be a URL or Cloud Storage
	// path. Example: "gs://path-to-file/file-name"
	PostStartupScript string `json:"postStartupScript,omitempty"`
	// VmImage: Use a Compute Engine VM image to start the notebook instance.
	VmImage *VmImage `json:"vmImage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContainerImage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerImage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Environment) MarshalJSON() ([]byte, error) {
	type NoMethod Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Event: The definition of an Event for a managed / semi-managed notebook
// instance.
type Event struct {
	// Details: Optional. Event details. This field is used to pass event
	// information.
	Details map[string]string `json:"details,omitempty"`
	// ReportTime: Event report time.
	ReportTime string `json:"reportTime,omitempty"`
	// Type: Event type.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - Event is not specified.
	//   "IDLE" - The instance / runtime is idle
	//   "HEARTBEAT" - The instance / runtime is available. This event indicates
	// that instance / runtime underlying compute is operational.
	//   "HEALTH" - The instance / runtime health is available. This event
	// indicates that instance / runtime health information.
	//   "MAINTENANCE" - The instance / runtime is available. This event allows
	// instance / runtime to send Host maintenance information to Control Plane.
	// https://cloud.google.com/compute/docs/gpus/gpu-host-maintenance
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Event) MarshalJSON() ([]byte, error) {
	type NoMethod Event
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Execution: The definition of a single executed notebook.
type Execution struct {
	// CreateTime: Output only. Time the Execution was instantiated.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A brief description of this execution.
	Description string `json:"description,omitempty"`
	// DisplayName: Output only. Name used for UI purposes. Name can only contain
	// alphanumeric characters and underscores '_'.
	DisplayName string `json:"displayName,omitempty"`
	// ExecutionTemplate: execute metadata including name, hardware spec, region,
	// labels, etc.
	ExecutionTemplate *ExecutionTemplate `json:"executionTemplate,omitempty"`
	// JobUri: Output only. The URI of the external job used to execute the
	// notebook.
	JobUri string `json:"jobUri,omitempty"`
	// Name: Output only. The resource name of the execute. Format:
	// `projects/{project_id}/locations/{location}/executions/{execution_id}`
	Name string `json:"name,omitempty"`
	// OutputNotebookFile: Output notebook file generated by this execution
	OutputNotebookFile string `json:"outputNotebookFile,omitempty"`
	// State: Output only. State of the underlying AI Platform job.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The job state is unspecified.
	//   "QUEUED" - The job has been just created and processing has not yet begun.
	//   "PREPARING" - The service is preparing to execution the job.
	//   "RUNNING" - The job is in progress.
	//   "SUCCEEDED" - The job completed successfully.
	//   "FAILED" - The job failed. `error_message` should contain the details of
	// the failure.
	//   "CANCELLING" - The job is being cancelled. `error_message` should describe
	// the reason for the cancellation.
	//   "CANCELLED" - The job has been cancelled. `error_message` should describe
	// the reason for the cancellation.
	//   "EXPIRED" - The job has become expired (relevant to Vertex AI jobs)
	// https://cloud.google.com/vertex-ai/docs/reference/rest/v1/JobState
	//   "INITIALIZING" - The Execution is being created.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Time the Execution was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Execution) MarshalJSON() ([]byte, error) {
	type NoMethod Execution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutionTemplate: The description a notebook execution workload.
type ExecutionTemplate struct {
	// AcceleratorConfig: Configuration (count and accelerator type) for hardware
	// running notebook execution.
	AcceleratorConfig *SchedulerAcceleratorConfig `json:"acceleratorConfig,omitempty"`
	// ContainerImageUri: Container Image URI to a DLVM Example:
	// 'gcr.io/deeplearning-platform-release/base-cu100' More examples can be found
	// at:
	// https://cloud.google.com/ai-platform/deep-learning-containers/docs/choosing-container
	ContainerImageUri string `json:"containerImageUri,omitempty"`
	// DataprocParameters: Parameters used in Dataproc JobType executions.
	DataprocParameters *DataprocParameters `json:"dataprocParameters,omitempty"`
	// InputNotebookFile: Path to the notebook file to execute. Must be in a Google
	// Cloud Storage bucket. Format:
	// `gs://{bucket_name}/{folder}/{notebook_file_name}` Ex:
	// `gs://notebook_user/scheduled_notebooks/sentiment_notebook.ipynb`
	InputNotebookFile string `json:"inputNotebookFile,omitempty"`
	// JobType: The type of Job to be used on this execution.
	//
	// Possible values:
	//   "JOB_TYPE_UNSPECIFIED" - No type specified.
	//   "VERTEX_AI" - Custom Job in `aiplatform.googleapis.com`. Default value for
	// an execution.
	//   "DATAPROC" - Run execution on a cluster with Dataproc as a job.
	// https://cloud.google.com/dataproc/docs/reference/rest/v1/projects.regions.jobs
	JobType string `json:"jobType,omitempty"`
	// KernelSpec: Name of the kernel spec to use. This must be specified if the
	// kernel spec name on the execution target does not match the name in the
	// input notebook file.
	KernelSpec string `json:"kernelSpec,omitempty"`
	// Labels: Labels for execution. If execution is scheduled, a field included
	// will be 'nbs-scheduled'. Otherwise, it is an immediate execution, and an
	// included field will be 'nbs-immediate'. Use fields to efficiently index
	// between various types of executions.
	Labels map[string]string `json:"labels,omitempty"`
	// MasterType: Specifies the type of virtual machine to use for your training
	// job's master worker. You must specify this field when `scaleTier` is set to
	// `CUSTOM`. You can use certain Compute Engine machine types directly in this
	// field. The following types are supported: - `n1-standard-4` -
	// `n1-standard-8` - `n1-standard-16` - `n1-standard-32` - `n1-standard-64` -
	// `n1-standard-96` - `n1-highmem-2` - `n1-highmem-4` - `n1-highmem-8` -
	// `n1-highmem-16` - `n1-highmem-32` - `n1-highmem-64` - `n1-highmem-96` -
	// `n1-highcpu-16` - `n1-highcpu-32` - `n1-highcpu-64` - `n1-highcpu-96`
	// Alternatively, you can use the following legacy machine types: - `standard`
	// - `large_model` - `complex_model_s` - `complex_model_m` - `complex_model_l`
	// - `standard_gpu` - `complex_model_m_gpu` - `complex_model_l_gpu` -
	// `standard_p100` - `complex_model_m_p100` - `standard_v100` -
	// `large_model_v100` - `complex_model_m_v100` - `complex_model_l_v100`
	// Finally, if you want to use a TPU for training, specify `cloud_tpu` in this
	// field. Learn more about the special configuration options for training with
	// TPU
	// (https://cloud.google.com/ai-platform/training/docs/using-tpus#configuring_a_custom_tpu_machine).
	MasterType string `json:"masterType,omitempty"`
	// OutputNotebookFolder: Path to the notebook folder to write to. Must be in a
	// Google Cloud Storage bucket path. Format: `gs://{bucket_name}/{folder}` Ex:
	// `gs://notebook_user/scheduled_notebooks`
	OutputNotebookFolder string `json:"outputNotebookFolder,omitempty"`
	// Parameters: Parameters used within the 'input_notebook_file' notebook.
	Parameters string `json:"parameters,omitempty"`
	// ParamsYamlFile: Parameters to be overridden in the notebook during
	// execution. Ref
	// https://papermill.readthedocs.io/en/latest/usage-parameterize.html on how to
	// specifying parameters in the input notebook and pass them here in an YAML
	// file. Ex:
	// `gs://notebook_user/scheduled_notebooks/sentiment_notebook_params.yaml`
	ParamsYamlFile string `json:"paramsYamlFile,omitempty"`
	// ScaleTier: Required. Scale tier of the hardware used for notebook execution.
	// DEPRECATED Will be discontinued. As right now only CUSTOM is supported.
	//
	// Possible values:
	//   "SCALE_TIER_UNSPECIFIED" - Unspecified Scale Tier.
	//   "BASIC" - A single worker instance. This tier is suitable for learning how
	// to use Cloud ML, and for experimenting with new models using small datasets.
	//   "STANDARD_1" - Many workers and a few parameter servers.
	//   "PREMIUM_1" - A large number of workers with many parameter servers.
	//   "BASIC_GPU" - A single worker instance with a K80 GPU.
	//   "BASIC_TPU" - A single worker instance with a Cloud TPU.
	//   "CUSTOM" - The CUSTOM tier is not a set tier, but rather enables you to
	// use your own cluster specification. When you use this tier, set values to
	// configure your processing cluster according to these guidelines: * You
	// _must_ set `ExecutionTemplate.masterType` to specify the type of machine to
	// use for your master node. This is the only required setting.
	ScaleTier string `json:"scaleTier,omitempty"`
	// ServiceAccount: The email address of a service account to use when running
	// the execution. You must have the `iam.serviceAccounts.actAs` permission for
	// the specified service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// Tensorboard: The name of a Vertex AI [Tensorboard] resource to which this
	// execution will upload Tensorboard logs. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Tensorboard string `json:"tensorboard,omitempty"`
	// VertexAiParameters: Parameters used in Vertex AI JobType executions.
	VertexAiParameters *VertexAIParameters `json:"vertexAiParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetInstanceHealthResponse: Response for checking if a notebook instance is
// healthy.
type GetInstanceHealthResponse struct {
	// HealthInfo: Output only. Additional information about instance health.
	// Example: healthInfo": { "docker_proxy_agent_status": "1", "docker_status":
	// "1", "jupyterlab_api_status": "-1", "jupyterlab_status": "-1", "updated":
	// "2020-10-18 09:40:03.573409" }
	HealthInfo map[string]string `json:"healthInfo,omitempty"`
	// HealthState: Output only. Runtime health_state.
	//
	// Possible values:
	//   "HEALTH_STATE_UNSPECIFIED" - The instance substate is unknown.
	//   "HEALTHY" - The instance is known to be in an healthy state (for example,
	// critical daemons are running) Applies to ACTIVE state.
	//   "UNHEALTHY" - The instance is known to be in an unhealthy state (for
	// example, critical daemons are not running) Applies to ACTIVE state.
	//   "AGENT_NOT_INSTALLED" - The instance has not installed health monitoring
	// agent. Applies to ACTIVE state.
	//   "AGENT_NOT_RUNNING" - The instance health monitoring agent is not running.
	// Applies to ACTIVE state.
	HealthState string `json:"healthState,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "HealthInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HealthInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetInstanceHealthResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetInstanceHealthResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuestOsFeature: Guest OS features for boot disk.
type GuestOsFeature struct {
	// Type: The ID of a supported feature. Read Enabling guest operating system
	// features to see a list of available options. Valid values: *
	// `FEATURE_TYPE_UNSPECIFIED` * `MULTI_IP_SUBNET` * `SECURE_BOOT` *
	// `UEFI_COMPATIBLE` * `VIRTIO_SCSI_MULTIQUEUE` * `WINDOWS`
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuestOsFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GuestOsFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Instance: The definition of a notebook instance.
type Instance struct {
	// AcceleratorConfig: The hardware accelerator used on this instance. If you
	// use accelerators, make sure that your configuration has enough vCPUs and
	// memory to support the `machine_type` you have selected
	// (https://cloud.google.com/compute/docs/gpus/#gpus-list).
	AcceleratorConfig *AcceleratorConfig `json:"acceleratorConfig,omitempty"`
	// BootDiskSizeGb: Input only. The size of the boot disk in GB attached to this
	// instance, up to a maximum of 64000 GB (64 TB). The minimum recommended value
	// is 100 GB. If not specified, this defaults to 100.
	BootDiskSizeGb int64 `json:"bootDiskSizeGb,omitempty,string"`
	// BootDiskType: Input only. The type of the boot disk attached to this
	// instance, defaults to standard persistent disk (`PD_STANDARD`).
	//
	// Possible values:
	//   "DISK_TYPE_UNSPECIFIED" - Disk type not set.
	//   "PD_STANDARD" - Standard persistent disk type.
	//   "PD_SSD" - SSD persistent disk type.
	//   "PD_BALANCED" - Balanced persistent disk type.
	//   "PD_EXTREME" - Extreme persistent disk type.
	BootDiskType string `json:"bootDiskType,omitempty"`
	// CanIpForward: Optional. Flag to enable ip forwarding or not, default
	// false/off. https://cloud.google.com/vpc/docs/using-routes#canipforward
	CanIpForward bool `json:"canIpForward,omitempty"`
	// ContainerImage: Use a container image to start the notebook instance.
	ContainerImage *ContainerImage `json:"containerImage,omitempty"`
	// CreateTime: Output only. Instance creation time.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. Email address of entity that sent original
	// CreateInstance request.
	Creator string `json:"creator,omitempty"`
	// CustomGpuDriverPath: Specify a custom Cloud Storage path where the GPU
	// driver is stored. If not specified, we'll automatically choose from official
	// GPU drivers.
	CustomGpuDriverPath string `json:"customGpuDriverPath,omitempty"`
	// DataDiskSizeGb: Input only. The size of the data disk in GB attached to this
	// instance, up to a maximum of 64000 GB (64 TB). You can choose the size of
	// the data disk based on how big your notebooks and data are. If not
	// specified, this defaults to 100.
	DataDiskSizeGb int64 `json:"dataDiskSizeGb,omitempty,string"`
	// DataDiskType: Input only. The type of the data disk attached to this
	// instance, defaults to standard persistent disk (`PD_STANDARD`).
	//
	// Possible values:
	//   "DISK_TYPE_UNSPECIFIED" - Disk type not set.
	//   "PD_STANDARD" - Standard persistent disk type.
	//   "PD_SSD" - SSD persistent disk type.
	//   "PD_BALANCED" - Balanced persistent disk type.
	//   "PD_EXTREME" - Extreme persistent disk type.
	DataDiskType string `json:"dataDiskType,omitempty"`
	// DiskEncryption: Input only. Disk encryption method used on the boot and data
	// disks, defaults to GMEK.
	//
	// Possible values:
	//   "DISK_ENCRYPTION_UNSPECIFIED" - Disk encryption is not specified.
	//   "GMEK" - Use Google managed encryption keys to encrypt the boot disk.
	//   "CMEK" - Use customer managed encryption keys to encrypt the boot disk.
	DiskEncryption string `json:"diskEncryption,omitempty"`
	// Disks: Output only. Attached disks to notebook instance.
	Disks []*Disk `json:"disks,omitempty"`
	// InstallGpuDriver: Whether the end user authorizes Google Cloud to install
	// GPU driver on this instance. If this field is empty or set to false, the GPU
	// driver won't be installed. Only applicable to instances with GPUs.
	InstallGpuDriver bool `json:"installGpuDriver,omitempty"`
	// InstanceMigrationEligibility: Output only. Checks how feasible a migration
	// from UmN to WbI is.
	InstanceMigrationEligibility *InstanceMigrationEligibility `json:"instanceMigrationEligibility,omitempty"`
	// InstanceOwners: Input only. The owner of this instance after creation.
	// Format: `alias@example.com` Currently supports one owner only. If not
	// specified, all of the service account users of your VM instance's service
	// account can use the instance.
	InstanceOwners []string `json:"instanceOwners,omitempty"`
	// KmsKey: Input only. The KMS key used to encrypt the disks, only applicable
	// if disk_encryption is CMEK. Format:
	// `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys
	// /{key_id}` Learn more about using your own encryption keys
	// (/kms/docs/quickstart).
	KmsKey string `json:"kmsKey,omitempty"`
	// Labels: Labels to apply to this instance. These can be later modified by the
	// setLabels method.
	Labels map[string]string `json:"labels,omitempty"`
	// MachineType: Required. The Compute Engine machine type
	// (https://cloud.google.com/compute/docs/machine-resource) of this instance.
	MachineType string `json:"machineType,omitempty"`
	// Metadata: Custom metadata to apply to this instance. For example, to specify
	// a Cloud Storage bucket for automatic backup, you can use the
	// `gcs-data-bucket` metadata tag. Format:
	// "--metadata=gcs-data-bucket=BUCKET".
	Metadata map[string]string `json:"metadata,omitempty"`
	// Migrated: Output only. Bool indicating whether this notebook has been
	// migrated to a Workbench Instance
	Migrated bool `json:"migrated,omitempty"`
	// Name: Output only. The name of this notebook instance. Format:
	// `projects/{project_id}/locations/{location}/instances/{instance_id}`
	Name string `json:"name,omitempty"`
	// Network: The name of the VPC that this instance is in. Format:
	// `projects/{project_id}/global/networks/{network_id}`
	Network string `json:"network,omitempty"`
	// NicType: Optional. The type of vNIC to be used on this interface. This may
	// be gVNIC or VirtioNet.
	//
	// Possible values:
	//   "UNSPECIFIED_NIC_TYPE" - No type specified.
	//   "VIRTIO_NET" - VIRTIO
	//   "GVNIC" - GVNIC
	NicType string `json:"nicType,omitempty"`
	// NoProxyAccess: If true, the notebook instance will not register with the
	// proxy.
	NoProxyAccess bool `json:"noProxyAccess,omitempty"`
	// NoPublicIp: If true, no external IP will be assigned to this instance.
	NoPublicIp bool `json:"noPublicIp,omitempty"`
	// NoRemoveDataDisk: Input only. If true, the data disk will not be auto
	// deleted when deleting the instance.
	NoRemoveDataDisk bool `json:"noRemoveDataDisk,omitempty"`
	// PostStartupScript: Path to a Bash script that automatically runs after a
	// notebook instance fully boots up. The path must be a URL or Cloud Storage
	// path (`gs://path-to-file/file-name`).
	PostStartupScript string `json:"postStartupScript,omitempty"`
	// ProxyUri: Output only. The proxy endpoint that is used to access the Jupyter
	// notebook.
	ProxyUri string `json:"proxyUri,omitempty"`
	// ReservationAffinity: Optional. The optional reservation affinity. Setting
	// this field will apply the specified Zonal Compute Reservation
	// (https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
	// to this notebook instance.
	ReservationAffinity *ReservationAffinity `json:"reservationAffinity,omitempty"`
	// ServiceAccount: The service account on this instance, giving access to other
	// Google Cloud services. You can use any service account within the same
	// project, but you must have the service account user permission to use the
	// instance. If not specified, the Compute Engine default service account
	// (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
	// is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ServiceAccountScopes: Optional. The URIs of service account scopes to be
	// included in Compute Engine instances. If not specified, the following scopes
	// (https://cloud.google.com/compute/docs/access/service-accounts#accesscopesiam)
	// are defined: - https://www.googleapis.com/auth/cloud-platform -
	// https://www.googleapis.com/auth/userinfo.email If not using default scopes,
	// you need at least: https://www.googleapis.com/auth/compute
	ServiceAccountScopes []string `json:"serviceAccountScopes,omitempty"`
	// ShieldedInstanceConfig: Optional. Shielded VM configuration. Images using
	// supported Shielded VM features
	// (https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
	ShieldedInstanceConfig *ShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`
	// State: Output only. The state of this instance.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "STARTING" - The control logic is starting the instance.
	//   "PROVISIONING" - The control logic is installing required frameworks and
	// registering the instance with notebook proxy
	//   "ACTIVE" - The instance is running.
	//   "STOPPING" - The control logic is stopping the instance.
	//   "STOPPED" - The instance is stopped.
	//   "DELETED" - The instance is deleted.
	//   "UPGRADING" - The instance is upgrading.
	//   "INITIALIZING" - The instance is being created.
	//   "REGISTERING" - The instance is getting registered.
	//   "SUSPENDING" - The instance is suspending.
	//   "SUSPENDED" - The instance is suspended.
	State string `json:"state,omitempty"`
	// Subnet: The name of the subnet that this instance is in. Format:
	// `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
	Subnet string `json:"subnet,omitempty"`
	// Tags: Optional. The Compute Engine network tags to add to runtime (see Add
	// network tags (https://cloud.google.com/vpc/docs/add-remove-network-tags)).
	Tags []string `json:"tags,omitempty"`
	// UpdateTime: Output only. Instance update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// UpgradeHistory: The upgrade history of this instance.
	UpgradeHistory []*UpgradeHistoryEntry `json:"upgradeHistory,omitempty"`
	// VmImage: Use a Compute Engine VM image to start the notebook instance.
	VmImage *VmImage `json:"vmImage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Instance) MarshalJSON() ([]byte, error) {
	type NoMethod Instance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceConfig: Notebook instance configurations that can be updated.
type InstanceConfig struct {
	// EnableHealthMonitoring: Verifies core internal services are running.
	EnableHealthMonitoring bool `json:"enableHealthMonitoring,omitempty"`
	// NotebookUpgradeSchedule: Cron expression in UTC timezone, used to schedule
	// instance auto upgrade. Please follow the cron format
	// (https://en.wikipedia.org/wiki/Cron).
	NotebookUpgradeSchedule string `json:"notebookUpgradeSchedule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableHealthMonitoring") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableHealthMonitoring") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceMigrationEligibility: InstanceMigrationEligibility represents the
// feasibility information of a migration from UmN to WbI.
type InstanceMigrationEligibility struct {
	// Errors: Output only. Certain configurations make the UmN ineligible for an
	// automatic migration. A manual migration is required.
	//
	// Possible values:
	//   "ERROR_UNSPECIFIED" - Default type.
	//   "DATAPROC_HUB" - The UmN uses Dataproc Hub and cannot be migrated.
	Errors []string `json:"errors,omitempty"`
	// Warnings: Output only. Certain configurations will be defaulted during the
	// migration.
	//
	// Possible values:
	//   "WARNING_UNSPECIFIED" - Default type.
	//   "UNSUPPORTED_MACHINE_TYPE" - The UmN uses an machine type that's
	// unsupported in WbI. It will be migrated with the default machine type
	// e2-standard-4. Users can change the machine type after the migration.
	//   "UNSUPPORTED_ACCELERATOR_TYPE" - The UmN uses an accelerator type that's
	// unsupported in WbI. It will be migrated without an accelerator. User can
	// attach an accelerator after the migration.
	//   "UNSUPPORTED_OS" - The UmN uses an operating system that's unsupported in
	// WbI (e.g. Debian 10, Ubuntu). It will be replaced with Debian 11 in WbI.
	//   "NO_REMOVE_DATA_DISK" - This UmN is configured with no_remove_data_disk,
	// which is no longer available in WbI.
	//   "GCS_BACKUP" - This UmN is configured with the Cloud Storage backup
	// feature, which is no longer available in WbI.
	//   "POST_STARTUP_SCRIPT" - This UmN is configured with a post startup script.
	// Please optionally provide the `post_startup_script_option` for the
	// migration.
	Warnings []string `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceMigrationEligibility) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceMigrationEligibility
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IsInstanceUpgradeableResponse: Response for checking if a notebook instance
// is upgradeable.
type IsInstanceUpgradeableResponse struct {
	// UpgradeImage: The new image self link this instance will be upgraded to if
	// calling the upgrade endpoint. This field will only be populated if field
	// upgradeable is true.
	UpgradeImage string `json:"upgradeImage,omitempty"`
	// UpgradeInfo: Additional information about upgrade.
	UpgradeInfo string `json:"upgradeInfo,omitempty"`
	// UpgradeVersion: The version this instance will be upgraded to if calling the
	// upgrade endpoint. This field will only be populated if field upgradeable is
	// true.
	UpgradeVersion string `json:"upgradeVersion,omitempty"`
	// Upgradeable: If an instance is upgradeable.
	Upgradeable bool `json:"upgradeable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "UpgradeImage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpgradeImage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IsInstanceUpgradeableResponse) MarshalJSON() ([]byte, error) {
	type NoMethod IsInstanceUpgradeableResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListEnvironmentsResponse: Response for listing environments.
type ListEnvironmentsResponse struct {
	// Environments: A list of returned environments.
	Environments []*Environment `json:"environments,omitempty"`
	// NextPageToken: A page token that can be used to continue listing from the
	// last result in the next list call.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListEnvironmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEnvironmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListExecutionsResponse: Response for listing scheduled notebook executions
type ListExecutionsResponse struct {
	// Executions: A list of returned instances.
	Executions []*Execution `json:"executions,omitempty"`
	// NextPageToken: Page token that can be used to continue listing from the last
	// result in the next list call.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Executions IDs that could not be reached. For example:
	// ['projects/{project_id}/location/{location}/executions/imagenet_test1',
	// 'projects/{project_id}/location/{location}/executions/classifier_train1']
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Executions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Executions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListExecutionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExecutionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInstancesResponse: Response for listing notebook instances.
type ListInstancesResponse struct {
	// Instances: A list of returned instances.
	Instances []*Instance `json:"instances,omitempty"`
	// NextPageToken: Page token that can be used to continue listing from the last
	// result in the next list call.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached. For example,
	// `['us-west1-a', 'us-central1-b']`. A ListInstancesResponse will only contain
	// either instances or unreachables,
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instances") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListInstancesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInstancesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRuntimesResponse: Response for listing Managed Notebook Runtimes.
type ListRuntimesResponse struct {
	// NextPageToken: Page token that can be used to continue listing from the last
	// result in the next list call.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Runtimes: A list of returned Runtimes.
	Runtimes []*Runtime `json:"runtimes,omitempty"`
	// Unreachable: Locations that could not be reached. For example, `['us-west1',
	// 'us-central1']`. A ListRuntimesResponse will only contain either runtimes or
	// unreachables,
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRuntimesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRuntimesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSchedulesResponse: Response for listing scheduled notebook job.
type ListSchedulesResponse struct {
	// NextPageToken: Page token that can be used to continue listing from the last
	// result in the next list call.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Schedules: A list of returned instances.
	Schedules []*Schedule `json:"schedules,omitempty"`
	// Unreachable: Schedules that could not be reached. For example:
	// ['projects/{project_id}/location/{location}/schedules/monthly_digest',
	// 'projects/{project_id}/location/{location}/schedules/weekly_sentiment']
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSchedulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSchedulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalDisk: A Local attached disk resource.
type LocalDisk struct {
	// AutoDelete: Optional. Output only. Specifies whether the disk will be
	// auto-deleted when the instance is deleted (but not when the disk is detached
	// from the instance).
	AutoDelete bool `json:"autoDelete,omitempty"`
	// Boot: Optional. Output only. Indicates that this is a boot disk. The virtual
	// machine will use the first partition of the disk for its root filesystem.
	Boot bool `json:"boot,omitempty"`
	// DeviceName: Optional. Output only. Specifies a unique device name of your
	// choice that is reflected into the `/dev/disk/by-id/google-*` tree of a Linux
	// operating system running within the instance. This name can be used to
	// reference the device for mounting, resizing, and so on, from within the
	// instance. If not specified, the server chooses a default device name to
	// apply to this disk, in the form persistent-disk-x, where x is a number
	// assigned by Google Compute Engine. This field is only applicable for
	// persistent disks.
	DeviceName string `json:"deviceName,omitempty"`
	// GuestOsFeatures: Output only. Indicates a list of features to enable on the
	// guest operating system. Applicable only for bootable images. Read Enabling
	// guest operating system features to see a list of available options.
	GuestOsFeatures []*RuntimeGuestOsFeature `json:"guestOsFeatures,omitempty"`
	// Index: Output only. A zero-based index to this disk, where 0 is reserved for
	// the boot disk. If you have many disks attached to an instance, each disk
	// would have a unique index number.
	Index int64 `json:"index,omitempty"`
	// InitializeParams: Input only. Specifies the parameters for a new disk that
	// will be created alongside the new instance. Use initialization parameters to
	// create boot disks or local SSDs attached to the new instance. This property
	// is mutually exclusive with the source property; you can only define one or
	// the other, but not both.
	InitializeParams *LocalDiskInitializeParams `json:"initializeParams,omitempty"`
	// Interface: Specifies the disk interface to use for attaching this disk,
	// which is either SCSI or NVME. The default is SCSI. Persistent disks must
	// always use SCSI and the request will fail if you attempt to attach a
	// persistent disk in any other format than SCSI. Local SSDs can use either
	// NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local
	// SSD performance. Valid values: * `NVME` * `SCSI`
	Interface string `json:"interface,omitempty"`
	// Kind: Output only. Type of the resource. Always compute#attachedDisk for
	// attached disks.
	Kind string `json:"kind,omitempty"`
	// Licenses: Output only. Any valid publicly visible licenses.
	Licenses []string `json:"licenses,omitempty"`
	// Mode: The mode in which to attach this disk, either `READ_WRITE` or
	// `READ_ONLY`. If not specified, the default is to attach the disk in
	// `READ_WRITE` mode. Valid values: * `READ_ONLY` * `READ_WRITE`
	Mode string `json:"mode,omitempty"`
	// Source: Specifies a valid partial or full URL to an existing Persistent Disk
	// resource.
	Source string `json:"source,omitempty"`
	// Type: Specifies the type of the disk, either `SCRATCH` or `PERSISTENT`. If
	// not specified, the default is `PERSISTENT`. Valid values: * `PERSISTENT` *
	// `SCRATCH`
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoDelete") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoDelete") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalDisk) MarshalJSON() ([]byte, error) {
	type NoMethod LocalDisk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalDiskInitializeParams: Input only. Specifies the parameters for a new
// disk that will be created alongside the new instance. Use initialization
// parameters to create boot disks or local SSDs attached to the new runtime.
// This property is mutually exclusive with the source property; you can only
// define one or the other, but not both.
type LocalDiskInitializeParams struct {
	// Description: Optional. Provide this property when creating the disk.
	Description string `json:"description,omitempty"`
	// DiskName: Optional. Specifies the disk name. If not specified, the default
	// is to use the name of the instance. If the disk with the instance name
	// exists already in the given zone/region, a new name will be automatically
	// generated.
	DiskName string `json:"diskName,omitempty"`
	// DiskSizeGb: Optional. Specifies the size of the disk in base-2 GB. If not
	// specified, the disk will be the same size as the image (usually 10GB). If
	// specified, the size must be equal to or larger than 10GB. Default 100 GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`
	// DiskType: Input only. The type of the boot disk attached to this instance,
	// defaults to standard persistent disk (`PD_STANDARD`).
	//
	// Possible values:
	//   "DISK_TYPE_UNSPECIFIED" - Disk type not set.
	//   "PD_STANDARD" - Standard persistent disk type.
	//   "PD_SSD" - SSD persistent disk type.
	//   "PD_BALANCED" - Balanced persistent disk type.
	//   "PD_EXTREME" - Extreme persistent disk type.
	DiskType string `json:"diskType,omitempty"`
	// Labels: Optional. Labels to apply to this disk. These can be later modified
	// by the disks.setLabels method. This field is only applicable for persistent
	// disks.
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalDiskInitializeParams) MarshalJSON() ([]byte, error) {
	type NoMethod LocalDiskInitializeParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MigrateInstanceRequest: Request for migrating a User-Managed Notebook to
// Workbench Instances.
type MigrateInstanceRequest struct {
	// PostStartupScriptOption: Optional. Specifies the behavior of post startup
	// script during migration.
	//
	// Possible values:
	//   "POST_STARTUP_SCRIPT_OPTION_UNSPECIFIED" - Post startup script option is
	// not specified. Default is POST_STARTUP_SCRIPT_OPTION_SKIP.
	//   "POST_STARTUP_SCRIPT_OPTION_SKIP" - Not migrate the post startup script to
	// the new Workbench Instance.
	//   "POST_STARTUP_SCRIPT_OPTION_RERUN" - Redownload and rerun the same post
	// startup script as the User-Managed Notebook.
	PostStartupScriptOption string `json:"postStartupScriptOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostStartupScriptOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostStartupScriptOption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MigrateInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod MigrateInstanceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MigrateRuntimeRequest: Request for migrating a Runtime to a Workbench
// Instance.
type MigrateRuntimeRequest struct {
	// Network: Optional. Name of the VPC that the new Instance is in. This is
	// required if the Runtime uses google-managed network. If the Runtime uses
	// customer-owned network, it will reuse the same VPC, and this field must be
	// empty. Format: `projects/{project_id}/global/networks/{network_id}`
	Network string `json:"network,omitempty"`
	// PostStartupScriptOption: Optional. Specifies the behavior of post startup
	// script during migration.
	//
	// Possible values:
	//   "POST_STARTUP_SCRIPT_OPTION_UNSPECIFIED" - Post startup script option is
	// not specified. Default is POST_STARTUP_SCRIPT_OPTION_SKIP.
	//   "POST_STARTUP_SCRIPT_OPTION_SKIP" - Not migrate the post startup script to
	// the new Workbench Instance.
	//   "POST_STARTUP_SCRIPT_OPTION_RERUN" - Redownload and rerun the same post
	// startup script as the Google-Managed Notebook.
	PostStartupScriptOption string `json:"postStartupScriptOption,omitempty"`
	// RequestId: Optional. Idempotent request UUID.
	RequestId string `json:"requestId,omitempty"`
	// ServiceAccount: Optional. The service account to be included in the Compute
	// Engine instance of the new Workbench Instance when the Runtime uses "single
	// user only" mode for permission. If not specified, the Compute Engine default
	// service account
	// (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
	// is used. When the Runtime uses service account mode for permission, it will
	// reuse the same service account, and this field must be empty.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// Subnet: Optional. Name of the subnet that the new Instance is in. This is
	// required if the Runtime uses google-managed network. If the Runtime uses
	// customer-owned network, it will reuse the same subnet, and this field must
	// be empty. Format:
	// `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
	Subnet string `json:"subnet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Network") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Network") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MigrateRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod MigrateRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Endpoint: API endpoint name of this operation.
	Endpoint string `json:"endpoint,omitempty"`
	// RequestedCancellation: Identifies whether the user has requested
	// cancellation of the operation. Operations that have successfully been
	// cancelled have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Server-defined resource path for the target of the operation.
	Target string `json:"target,omitempty"`
	// Verb: Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bindings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RefreshRuntimeTokenInternalRequest: Request for getting a new access token.
type RefreshRuntimeTokenInternalRequest struct {
	// VmId: Required. The VM hardware token for authenticating the VM.
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	VmId string `json:"vmId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VmId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VmId") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RefreshRuntimeTokenInternalRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RefreshRuntimeTokenInternalRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RefreshRuntimeTokenInternalResponse: Response with a new access token.
type RefreshRuntimeTokenInternalResponse struct {
	// AccessToken: The OAuth 2.0 access token.
	AccessToken string `json:"accessToken,omitempty"`
	// ExpireTime: Output only. Token expiration time.
	ExpireTime string `json:"expireTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RefreshRuntimeTokenInternalResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RefreshRuntimeTokenInternalResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegisterInstanceRequest: Request for registering a notebook instance.
type RegisterInstanceRequest struct {
	// InstanceId: Required. User defined unique ID of this instance. The
	// `instance_id` must be 1 to 63 characters long and contain only lowercase
	// letters, numeric characters, and dashes. The first character must be a
	// lowercase letter and the last character cannot be a dash.
	InstanceId string `json:"instanceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegisterInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RegisterInstanceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportInstanceEventRequest: Request for reporting a Managed Notebook Event.
type ReportInstanceEventRequest struct {
	// Event: Required. The Event to be reported.
	Event *Event `json:"event,omitempty"`
	// VmId: Required. The VM hardware token for authenticating the VM.
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	VmId string `json:"vmId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportInstanceEventRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReportInstanceEventRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportInstanceInfoRequest: Request for notebook instances to report
// information to Notebooks API.
type ReportInstanceInfoRequest struct {
	// Metadata: The metadata reported to Notebooks API. This will be merged to the
	// instance metadata store
	Metadata map[string]string `json:"metadata,omitempty"`
	// VmId: Required. The VM hardware token for authenticating the VM.
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	VmId string `json:"vmId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportInstanceInfoRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReportInstanceInfoRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportRuntimeEventRequest: Request for reporting a Managed Notebook Event.
type ReportRuntimeEventRequest struct {
	// Event: Required. The Event to be reported.
	Event *Event `json:"event,omitempty"`
	// VmId: Required. The VM hardware token for authenticating the VM.
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	VmId string `json:"vmId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportRuntimeEventRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReportRuntimeEventRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReservationAffinity: Reservation Affinity for consuming Zonal reservation.
type ReservationAffinity struct {
	// ConsumeReservationType: Optional. Type of reservation to consume
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default type.
	//   "NO_RESERVATION" - Do not consume from any allocated capacity.
	//   "ANY_RESERVATION" - Consume any reservation available.
	//   "SPECIFIC_RESERVATION" - Must consume from a specific reservation. Must
	// specify key value fields for specifying the reservations.
	ConsumeReservationType string `json:"consumeReservationType,omitempty"`
	// Key: Optional. Corresponds to the label key of reservation resource.
	Key string `json:"key,omitempty"`
	// Values: Optional. Corresponds to the label values of reservation resource.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsumeReservationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsumeReservationType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReservationAffinity) MarshalJSON() ([]byte, error) {
	type NoMethod ReservationAffinity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResetInstanceRequest: Request for resetting a notebook instance
type ResetInstanceRequest struct {
}

// ResetRuntimeRequest: Request for resetting a Managed Notebook Runtime.
type ResetRuntimeRequest struct {
	// RequestId: Idempotent request UUID.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResetRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ResetRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackInstanceRequest: Request for rollbacking a notebook instance
type RollbackInstanceRequest struct {
	// TargetSnapshot: Required. The snapshot for rollback. Example:
	// `projects/test-project/global/snapshots/krwlzipynril`.
	TargetSnapshot string `json:"targetSnapshot,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSnapshot") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSnapshot") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackInstanceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Runtime: The definition of a Runtime for a managed notebook instance.
type Runtime struct {
	// AccessConfig: The config settings for accessing runtime.
	AccessConfig *RuntimeAccessConfig `json:"accessConfig,omitempty"`
	// CreateTime: Output only. Runtime creation time.
	CreateTime string `json:"createTime,omitempty"`
	// HealthState: Output only. Runtime health_state.
	//
	// Possible values:
	//   "HEALTH_STATE_UNSPECIFIED" - The runtime substate is unknown.
	//   "HEALTHY" - The runtime is known to be in an healthy state (for example,
	// critical daemons are running) Applies to ACTIVE state.
	//   "UNHEALTHY" - The runtime is known to be in an unhealthy state (for
	// example, critical daemons are not running) Applies to ACTIVE state.
	//   "AGENT_NOT_INSTALLED" - The runtime has not installed health monitoring
	// agent. Applies to ACTIVE state.
	//   "AGENT_NOT_RUNNING" - The runtime health monitoring agent is not running.
	// Applies to ACTIVE state.
	HealthState string `json:"healthState,omitempty"`
	// Labels: Optional. The labels to associate with this Managed Notebook or
	// Runtime. Label **keys** must contain 1 to 63 characters, and must conform to
	// RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
	// empty, but, if present, must contain 1 to 63 characters, and must conform to
	// RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can
	// be associated with a cluster.
	Labels map[string]string `json:"labels,omitempty"`
	// Metrics: Output only. Contains Runtime daemon metrics such as Service status
	// and JupyterLab stats.
	Metrics *RuntimeMetrics `json:"metrics,omitempty"`
	// Migrated: Output only. Bool indicating whether this notebook has been
	// migrated to a Workbench Instance
	Migrated bool `json:"migrated,omitempty"`
	// Name: Output only. The resource name of the runtime. Format:
	// `projects/{project}/locations/{location}/runtimes/{runtimeId}`
	Name string `json:"name,omitempty"`
	// RuntimeMigrationEligibility: Output only. Checks how feasible a migration
	// from GmN to WbI is.
	RuntimeMigrationEligibility *RuntimeMigrationEligibility `json:"runtimeMigrationEligibility,omitempty"`
	// SoftwareConfig: The config settings for software inside the runtime.
	SoftwareConfig *RuntimeSoftwareConfig `json:"softwareConfig,omitempty"`
	// State: Output only. Runtime state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "STARTING" - The compute layer is starting the runtime. It is not ready
	// for use.
	//   "PROVISIONING" - The compute layer is installing required frameworks and
	// registering the runtime with notebook proxy. It cannot be used.
	//   "ACTIVE" - The runtime is currently running. It is ready for use.
	//   "STOPPING" - The control logic is stopping the runtime. It cannot be used.
	//   "STOPPED" - The runtime is stopped. It cannot be used.
	//   "DELETING" - The runtime is being deleted. It cannot be used.
	//   "UPGRADING" - The runtime is upgrading. It cannot be used.
	//   "INITIALIZING" - The runtime is being created and set up. It is not ready
	// for use.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Runtime update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// VirtualMachine: Use a Compute Engine VM image to start the managed notebook
	// instance.
	VirtualMachine *VirtualMachine `json:"virtualMachine,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Runtime) MarshalJSON() ([]byte, error) {
	type NoMethod Runtime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeAcceleratorConfig: Definition of the types of hardware accelerators
// that can be used. See Compute Engine AcceleratorTypes
// (https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).
// Examples: * `nvidia-tesla-k80` * `nvidia-tesla-p100` * `nvidia-tesla-v100` *
// `nvidia-tesla-p4` * `nvidia-tesla-t4` * `nvidia-tesla-a100`
type RuntimeAcceleratorConfig struct {
	// CoreCount: Count of cores of this accelerator.
	CoreCount int64 `json:"coreCount,omitempty,string"`
	// Type: Accelerator model.
	//
	// Possible values:
	//   "ACCELERATOR_TYPE_UNSPECIFIED" - Accelerator type is not specified.
	//   "NVIDIA_TESLA_K80" - Accelerator type is Nvidia Tesla K80.
	//   "NVIDIA_TESLA_P100" - Accelerator type is Nvidia Tesla P100.
	//   "NVIDIA_TESLA_V100" - Accelerator type is Nvidia Tesla V100.
	//   "NVIDIA_TESLA_P4" - Accelerator type is Nvidia Tesla P4.
	//   "NVIDIA_TESLA_T4" - Accelerator type is Nvidia Tesla T4.
	//   "NVIDIA_TESLA_A100" - Accelerator type is Nvidia Tesla A100 - 40GB.
	//   "NVIDIA_L4" - Accelerator type is Nvidia L4.
	//   "TPU_V2" - (Coming soon) Accelerator type is TPU V2.
	//   "TPU_V3" - (Coming soon) Accelerator type is TPU V3.
	//   "NVIDIA_TESLA_T4_VWS" - Accelerator type is NVIDIA Tesla T4 Virtual
	// Workstations.
	//   "NVIDIA_TESLA_P100_VWS" - Accelerator type is NVIDIA Tesla P100 Virtual
	// Workstations.
	//   "NVIDIA_TESLA_P4_VWS" - Accelerator type is NVIDIA Tesla P4 Virtual
	// Workstations.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoreCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoreCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeAcceleratorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeAcceleratorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeAccessConfig: Specifies the login configuration for Runtime
type RuntimeAccessConfig struct {
	// AccessType: The type of access mode this instance.
	//
	// Possible values:
	//   "RUNTIME_ACCESS_TYPE_UNSPECIFIED" - Unspecified access.
	//   "SINGLE_USER" - Single user login.
	//   "SERVICE_ACCOUNT" - Service Account mode. In Service Account mode, Runtime
	// creator will specify a SA that exists in the consumer project. Using Runtime
	// Service Account field. Users accessing the Runtime need ActAs (Service
	// Account User) permission.
	AccessType string `json:"accessType,omitempty"`
	// ProxyUri: Output only. The proxy endpoint that is used to access the
	// runtime.
	ProxyUri string `json:"proxyUri,omitempty"`
	// RuntimeOwner: The owner of this runtime after creation. Format:
	// `alias@example.com` Currently supports one owner only.
	RuntimeOwner string `json:"runtimeOwner,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeAccessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeAccessConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeGuestOsFeature: Optional. A list of features to enable on the guest
// operating system. Applicable only for bootable images. Read Enabling guest
// operating system features
// (https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features)
// to see a list of available options. Guest OS features for boot disk.
type RuntimeGuestOsFeature struct {
	// Type: The ID of a supported feature. Read Enabling guest operating system
	// features
	// (https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features)
	// to see a list of available options. Valid values: *
	// `FEATURE_TYPE_UNSPECIFIED` * `MULTI_IP_SUBNET` * `SECURE_BOOT` *
	// `UEFI_COMPATIBLE` * `VIRTIO_SCSI_MULTIQUEUE` * `WINDOWS`
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeGuestOsFeature) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeGuestOsFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeMetrics: Contains runtime daemon metrics, such as OS and kernels and
// sessions stats.
type RuntimeMetrics struct {
	// SystemMetrics: Output only. The system metrics.
	SystemMetrics map[string]string `json:"systemMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SystemMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SystemMetrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeMigrationEligibility: RuntimeMigrationEligibility represents the
// feasibility information of a migration from GmN to WbI.
type RuntimeMigrationEligibility struct {
	// Errors: Output only. Certain configurations make the GmN ineligible for an
	// automatic migration. A manual migration is required.
	//
	// Possible values:
	//   "ERROR_UNSPECIFIED" - Default type.
	//   "CUSTOM_CONTAINER" - The GmN is configured with custom container(s) and
	// cannot be migrated.
	Errors []string `json:"errors,omitempty"`
	// Warnings: Output only. Certain configurations will be defaulted during the
	// migration.
	//
	// Possible values:
	//   "WARNING_UNSPECIFIED" - Default type.
	//   "UNSUPPORTED_ACCELERATOR_TYPE" - The GmN uses an accelerator type that's
	// unsupported in WbI. It will be migrated without an accelerator. Users can
	// attach an accelerator after the migration.
	//   "UNSUPPORTED_OS" - The GmN uses an operating system that's unsupported in
	// WbI (e.g. Debian 10). It will be replaced with Debian 11 in WbI.
	//   "RESERVED_IP_RANGE" - This GmN is configured with reserved IP range, which
	// is no longer applicable in WbI.
	//   "GOOGLE_MANAGED_NETWORK" - This GmN is configured with a Google managed
	// network. Please provide the `network` and `subnet` options for the
	// migration.
	//   "POST_STARTUP_SCRIPT" - This GmN is configured with a post startup script.
	// Please optionally provide the `post_startup_script_option` for the
	// migration.
	//   "SINGLE_USER" - This GmN is configured with single user mode. Please
	// optionally provide the `service_account` option for the migration.
	Warnings []string `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeMigrationEligibility) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeMigrationEligibility
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeShieldedInstanceConfig: A set of Shielded Instance options. See
// Images using supported Shielded VM features
// (https://cloud.google.com/compute/docs/instances/modifying-shielded-vm). Not
// all combinations are valid.
type RuntimeShieldedInstanceConfig struct {
	// EnableIntegrityMonitoring: Defines whether the instance has integrity
	// monitoring enabled. Enables monitoring and attestation of the boot integrity
	// of the instance. The attestation is performed against the integrity policy
	// baseline. This baseline is initially derived from the implicitly trusted
	// boot image when the instance is created. Enabled by default.
	EnableIntegrityMonitoring bool `json:"enableIntegrityMonitoring,omitempty"`
	// EnableSecureBoot: Defines whether the instance has Secure Boot enabled.
	// Secure Boot helps ensure that the system only runs authentic software by
	// verifying the digital signature of all boot components, and halting the boot
	// process if signature verification fails. Disabled by default.
	EnableSecureBoot bool `json:"enableSecureBoot,omitempty"`
	// EnableVtpm: Defines whether the instance has the vTPM enabled. Enabled by
	// default.
	EnableVtpm bool `json:"enableVtpm,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableIntegrityMonitoring")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableIntegrityMonitoring") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeShieldedInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeShieldedInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeSoftwareConfig: Specifies the selection and configuration of software
// inside the runtime. The properties to set on runtime. Properties keys are
// specified in `key:value` format, for example: * `idle_shutdown: true` *
// `idle_shutdown_timeout: 180` * `enable_health_monitoring: true`
type RuntimeSoftwareConfig struct {
	// CustomGpuDriverPath: Specify a custom Cloud Storage path where the GPU
	// driver is stored. If not specified, we'll automatically choose from official
	// GPU drivers.
	CustomGpuDriverPath string `json:"customGpuDriverPath,omitempty"`
	// DisableTerminal: Bool indicating whether JupyterLab terminal will be
	// available or not. Default: False
	DisableTerminal bool `json:"disableTerminal,omitempty"`
	// EnableHealthMonitoring: Verifies core internal services are running.
	// Default: True
	EnableHealthMonitoring bool `json:"enableHealthMonitoring,omitempty"`
	// IdleShutdown: Runtime will automatically shutdown after idle_shutdown_time.
	// Default: True
	IdleShutdown bool `json:"idleShutdown,omitempty"`
	// IdleShutdownTimeout: Time in minutes to wait before shutting down runtime.
	// Default: 180 minutes
	IdleShutdownTimeout int64 `json:"idleShutdownTimeout,omitempty"`
	// InstallGpuDriver: Install Nvidia Driver automatically. Default: True
	InstallGpuDriver bool `json:"installGpuDriver,omitempty"`
	// Kernels: Optional. Use a list of container images to use as Kernels in the
	// notebook instance.
	Kernels []*ContainerImage `json:"kernels,omitempty"`
	// MixerDisabled: Bool indicating whether mixer client should be disabled.
	// Default: False
	MixerDisabled bool `json:"mixerDisabled,omitempty"`
	// NotebookUpgradeSchedule: Cron expression in UTC timezone, used to schedule
	// instance auto upgrade. Please follow the cron format
	// (https://en.wikipedia.org/wiki/Cron).
	NotebookUpgradeSchedule string `json:"notebookUpgradeSchedule,omitempty"`
	// PostStartupScript: Path to a Bash script that automatically runs after a
	// notebook instance fully boots up. The path must be a URL or Cloud Storage
	// path (`gs://path-to-file/file-name`).
	PostStartupScript string `json:"postStartupScript,omitempty"`
	// PostStartupScriptBehavior: Behavior for the post startup script.
	//
	// Possible values:
	//   "POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED" - Unspecified post startup
	// script behavior. Will run only once at creation.
	//   "RUN_EVERY_START" - Runs the post startup script provided during creation
	// at every start.
	//   "DOWNLOAD_AND_RUN_EVERY_START" - Downloads and runs the provided post
	// startup script at every start.
	PostStartupScriptBehavior string `json:"postStartupScriptBehavior,omitempty"`
	// Upgradeable: Output only. Bool indicating whether an newer image is
	// available in an image family.
	Upgradeable bool `json:"upgradeable,omitempty"`
	// Version: Output only. version of boot image such as M100, from release label
	// of the image.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomGpuDriverPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomGpuDriverPath") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeSoftwareConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeSoftwareConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Schedule: The definition of a schedule.
type Schedule struct {
	// CreateTime: Output only. Time the schedule was created.
	CreateTime string `json:"createTime,omitempty"`
	// CronSchedule: Cron-tab formatted schedule by which the job will execute.
	// Format: minute, hour, day of month, month, day of week, e.g. `0 0 * * WED` =
	// every Wednesday More examples: https://crontab.guru/examples.html
	CronSchedule string `json:"cronSchedule,omitempty"`
	// Description: A brief description of this environment.
	Description string `json:"description,omitempty"`
	// DisplayName: Output only. Display name used for UI purposes. Name can only
	// contain alphanumeric characters, hyphens `-`, and underscores `_`.
	DisplayName string `json:"displayName,omitempty"`
	// ExecutionTemplate: Notebook Execution Template corresponding to this
	// schedule.
	ExecutionTemplate *ExecutionTemplate `json:"executionTemplate,omitempty"`
	// Name: Output only. The name of this schedule. Format:
	// `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
	Name string `json:"name,omitempty"`
	// RecentExecutions: Output only. The most recent execution names triggered
	// from this schedule and their corresponding states.
	RecentExecutions []*Execution `json:"recentExecutions,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ENABLED" - The job is executing normally.
	//   "PAUSED" - The job is paused by the user. It will not execute. A user can
	// intentionally pause the job using [Cloud
	// Scheduler](https://cloud.google.com/scheduler/docs/creating#pause).
	//   "DISABLED" - The job is disabled by the system due to error. The user
	// cannot directly set a job to be disabled.
	//   "UPDATE_FAILED" - The job state resulting from a failed
	// [CloudScheduler.UpdateJob](https://cloud.google.com/scheduler/docs/creating#e
	// dit) operation. To recover a job from this state, retry
	// [CloudScheduler.UpdateJob](https://cloud.google.com/scheduler/docs/creating#e
	// dit) until a successful response is received.
	//   "INITIALIZING" - The schedule resource is being created.
	//   "DELETING" - The schedule resource is being deleted.
	State string `json:"state,omitempty"`
	// TimeZone: Timezone on which the cron_schedule. The value of this field must
	// be a time zone name from the tz database. TZ Database:
	// https://en.wikipedia.org/wiki/List_of_tz_database_time_zones Note that some
	// time zones include a provision for daylight savings time. The rules for
	// daylight saving time are determined by the chosen tz. For UTC use the string
	// "utc". If a time zone is not specified, the default will be in UTC (also
	// known as GMT).
	TimeZone string `json:"timeZone,omitempty"`
	// UpdateTime: Output only. Time the schedule was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schedule) MarshalJSON() ([]byte, error) {
	type NoMethod Schedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchedulerAcceleratorConfig: Definition of a hardware accelerator. Note that
// not all combinations of `type` and `core_count` are valid. See GPUs on
// Compute Engine (https://cloud.google.com/compute/docs/gpus) to find a valid
// combination. TPUs are not supported.
type SchedulerAcceleratorConfig struct {
	// CoreCount: Count of cores of this accelerator.
	CoreCount int64 `json:"coreCount,omitempty,string"`
	// Type: Type of this accelerator.
	//
	// Possible values:
	//   "SCHEDULER_ACCELERATOR_TYPE_UNSPECIFIED" - Unspecified accelerator type.
	// Default to no GPU.
	//   "NVIDIA_TESLA_K80" - Nvidia Tesla K80 GPU.
	//   "NVIDIA_TESLA_P100" - Nvidia Tesla P100 GPU.
	//   "NVIDIA_TESLA_V100" - Nvidia Tesla V100 GPU.
	//   "NVIDIA_TESLA_P4" - Nvidia Tesla P4 GPU.
	//   "NVIDIA_TESLA_T4" - Nvidia Tesla T4 GPU.
	//   "NVIDIA_TESLA_A100" - Nvidia Tesla A100 GPU.
	//   "TPU_V2" - TPU v2.
	//   "TPU_V3" - TPU v3.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoreCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoreCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchedulerAcceleratorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SchedulerAcceleratorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetInstanceAcceleratorRequest: Request for setting instance accelerator.
type SetInstanceAcceleratorRequest struct {
	// CoreCount: Required. Count of cores of this accelerator. Note that not all
	// combinations of `type` and `core_count` are valid. See GPUs on Compute
	// Engine (https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a
	// valid combination. TPUs are not supported.
	CoreCount int64 `json:"coreCount,omitempty,string"`
	// Type: Required. Type of this accelerator.
	//
	// Possible values:
	//   "ACCELERATOR_TYPE_UNSPECIFIED" - Accelerator type is not specified.
	//   "NVIDIA_TESLA_K80" - Accelerator type is Nvidia Tesla K80.
	//   "NVIDIA_TESLA_P100" - Accelerator type is Nvidia Tesla P100.
	//   "NVIDIA_TESLA_V100" - Accelerator type is Nvidia Tesla V100.
	//   "NVIDIA_TESLA_P4" - Accelerator type is Nvidia Tesla P4.
	//   "NVIDIA_TESLA_T4" - Accelerator type is Nvidia Tesla T4.
	//   "NVIDIA_TESLA_A100" - Accelerator type is Nvidia Tesla A100.
	//   "NVIDIA_L4" - Accelerator type is Nvidia Tesla L4.
	//   "NVIDIA_A100_80GB" - Accelerator type is Nvidia Tesla A100 80GB.
	//   "NVIDIA_TESLA_T4_VWS" - Accelerator type is NVIDIA Tesla T4 Virtual
	// Workstations.
	//   "NVIDIA_TESLA_P100_VWS" - Accelerator type is NVIDIA Tesla P100 Virtual
	// Workstations.
	//   "NVIDIA_TESLA_P4_VWS" - Accelerator type is NVIDIA Tesla P4 Virtual
	// Workstations.
	//   "NVIDIA_H100_80GB" - Accelerator type is NVIDIA H100 80GB.
	//   "NVIDIA_H100_MEGA_80GB" - Accelerator type is NVIDIA H100 Mega 80GB.
	//   "TPU_V2" - (Coming soon) Accelerator type is TPU V2.
	//   "TPU_V3" - (Coming soon) Accelerator type is TPU V3.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoreCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoreCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetInstanceAcceleratorRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetInstanceAcceleratorRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetInstanceLabelsRequest: Request for setting instance labels.
type SetInstanceLabelsRequest struct {
	// Labels: Labels to apply to this instance. These can be later modified by the
	// setLabels method
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetInstanceLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetInstanceLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetInstanceMachineTypeRequest: Request for setting instance machine type.
type SetInstanceMachineTypeRequest struct {
	// MachineType: Required. The Compute Engine machine type
	// (https://cloud.google.com/compute/docs/machine-resource).
	MachineType string `json:"machineType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MachineType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetInstanceMachineTypeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetInstanceMachineTypeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShieldedInstanceConfig: A set of Shielded Instance options. See Images using
// supported Shielded VM features
// (https://cloud.google.com/compute/docs/instances/modifying-shielded-vm). Not
// all combinations are valid.
type ShieldedInstanceConfig struct {
	// EnableIntegrityMonitoring: Defines whether the instance has integrity
	// monitoring enabled. Enables monitoring and attestation of the boot integrity
	// of the instance. The attestation is performed against the integrity policy
	// baseline. This baseline is initially derived from the implicitly trusted
	// boot image when the instance is created. Enabled by default.
	EnableIntegrityMonitoring bool `json:"enableIntegrityMonitoring,omitempty"`
	// EnableSecureBoot: Defines whether the instance has Secure Boot enabled.
	// Secure Boot helps ensure that the system only runs authentic software by
	// verifying the digital signature of all boot components, and halting the boot
	// process if signature verification fails. Disabled by default.
	EnableSecureBoot bool `json:"enableSecureBoot,omitempty"`
	// EnableVtpm: Defines whether the instance has the vTPM enabled. Enabled by
	// default.
	EnableVtpm bool `json:"enableVtpm,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableIntegrityMonitoring")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableIntegrityMonitoring") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShieldedInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ShieldedInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StartInstanceRequest: Request for starting a notebook instance
type StartInstanceRequest struct {
}

// StartRuntimeRequest: Request for starting a Managed Notebook Runtime.
type StartRuntimeRequest struct {
	// RequestId: Idempotent request UUID.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StartRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod StartRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StopInstanceRequest: Request for stopping a notebook instance
type StopInstanceRequest struct {
}

// StopRuntimeRequest: Request for stopping a Managed Notebook Runtime.
type StopRuntimeRequest struct {
	// RequestId: Idempotent request UUID.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StopRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod StopRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SwitchRuntimeRequest: Request for switching a Managed Notebook Runtime.
type SwitchRuntimeRequest struct {
	// AcceleratorConfig: accelerator config.
	AcceleratorConfig *RuntimeAcceleratorConfig `json:"acceleratorConfig,omitempty"`
	// MachineType: machine type.
	MachineType string `json:"machineType,omitempty"`
	// RequestId: Idempotent request UUID.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SwitchRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SwitchRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerScheduleRequest: Request for created scheduled notebooks
type TriggerScheduleRequest struct {
}

// UpdateInstanceConfigRequest: Request for updating instance configurations.
type UpdateInstanceConfigRequest struct {
	// Config: The instance configurations to be updated.
	Config *InstanceConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateInstanceConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateInstanceConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateInstanceMetadataItemsRequest: Request for adding/changing metadata
// items for an instance.
type UpdateInstanceMetadataItemsRequest struct {
	// Items: Metadata items to add/update for the instance.
	Items map[string]string `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateInstanceMetadataItemsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateInstanceMetadataItemsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateInstanceMetadataItemsResponse: Response for adding/changing metadata
// items for an instance.
type UpdateInstanceMetadataItemsResponse struct {
	// Items: Map of items that were added/updated to/in the metadata.
	Items map[string]string `json:"items,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateInstanceMetadataItemsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateInstanceMetadataItemsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateShieldedInstanceConfigRequest: Request for updating the Shielded
// Instance config for a notebook instance. You can only use this method on a
// stopped instance
type UpdateShieldedInstanceConfigRequest struct {
	// ShieldedInstanceConfig: ShieldedInstance configuration to be updated.
	ShieldedInstanceConfig *ShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ShieldedInstanceConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShieldedInstanceConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateShieldedInstanceConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateShieldedInstanceConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeHistoryEntry: The entry of VM image upgrade history.
type UpgradeHistoryEntry struct {
	// Action: Action. Rolloback or Upgrade.
	//
	// Possible values:
	//   "ACTION_UNSPECIFIED" - Operation is not specified.
	//   "UPGRADE" - Upgrade.
	//   "ROLLBACK" - Rollback.
	Action string `json:"action,omitempty"`
	// ContainerImage: The container image before this instance upgrade.
	ContainerImage string `json:"containerImage,omitempty"`
	// CreateTime: The time that this instance upgrade history entry is created.
	CreateTime string `json:"createTime,omitempty"`
	// Framework: The framework of this notebook instance.
	Framework string `json:"framework,omitempty"`
	// Snapshot: The snapshot of the boot disk of this notebook instance before
	// upgrade.
	Snapshot string `json:"snapshot,omitempty"`
	// State: The state of this instance upgrade history entry.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "STARTED" - The instance upgrade is started.
	//   "SUCCEEDED" - The instance upgrade is succeeded.
	//   "FAILED" - The instance upgrade is failed.
	State string `json:"state,omitempty"`
	// TargetImage: Target VM Image. Format:
	// `ainotebooks-vm/project/image-name/name`.
	TargetImage string `json:"targetImage,omitempty"`
	// TargetVersion: Target VM Version, like m63.
	TargetVersion string `json:"targetVersion,omitempty"`
	// Version: The version of the notebook instance before this upgrade.
	Version string `json:"version,omitempty"`
	// VmImage: The VM image before this instance upgrade.
	VmImage string `json:"vmImage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeHistoryEntry) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeHistoryEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeInstanceInternalRequest: Request for upgrading a notebook instance
// from within the VM
type UpgradeInstanceInternalRequest struct {
	// Type: Optional. The optional UpgradeType. Setting this field will search for
	// additional compute images to upgrade this instance.
	//
	// Possible values:
	//   "UPGRADE_TYPE_UNSPECIFIED" - Upgrade type is not specified.
	//   "UPGRADE_FRAMEWORK" - Upgrade ML framework.
	//   "UPGRADE_OS" - Upgrade Operating System.
	//   "UPGRADE_CUDA" - Upgrade CUDA.
	//   "UPGRADE_ALL" - Upgrade All (OS, Framework and CUDA).
	Type string `json:"type,omitempty"`
	// VmId: Required. The VM hardware token for authenticating the VM.
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	VmId string `json:"vmId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeInstanceInternalRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeInstanceInternalRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeInstanceRequest: Request for upgrading a notebook instance
type UpgradeInstanceRequest struct {
	// Type: Optional. The optional UpgradeType. Setting this field will search for
	// additional compute images to upgrade this instance.
	//
	// Possible values:
	//   "UPGRADE_TYPE_UNSPECIFIED" - Upgrade type is not specified.
	//   "UPGRADE_FRAMEWORK" - Upgrade ML framework.
	//   "UPGRADE_OS" - Upgrade Operating System.
	//   "UPGRADE_CUDA" - Upgrade CUDA.
	//   "UPGRADE_ALL" - Upgrade All (OS, Framework and CUDA).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeInstanceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeRuntimeRequest: Request for upgrading a Managed Notebook Runtime to
// the latest version. option (google.api.message_visibility).restriction =
// "TRUSTED_TESTER,SPECIAL_TESTER";
type UpgradeRuntimeRequest struct {
	// RequestId: Idempotent request UUID.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VertexAIParameters: Parameters used in Vertex AI JobType executions.
type VertexAIParameters struct {
	// Env: Environment variables. At most 100 environment variables can be
	// specified and unique. Example: `GCP_BUCKET=gs://my-bucket/samples/`
	Env map[string]string `json:"env,omitempty"`
	// Network: The full name of the Compute Engine network
	// (https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to
	// which the Job should be peered. For example,
	// `projects/12345/global/networks/myVPC`. Format
	// (https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert) is
	// of the form `projects/{project}/global/networks/{network}`. Where
	// `{project}` is a project number, as in `12345`, and `{network}` is a network
	// name. Private services access must already be configured for the network. If
	// left unspecified, the job is not peered with any network.
	Network string `json:"network,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Env") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Env") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VertexAIParameters) MarshalJSON() ([]byte, error) {
	type NoMethod VertexAIParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VirtualMachine: Runtime using Virtual Machine for computing.
type VirtualMachine struct {
	// InstanceId: Output only. The unique identifier of the Managed Compute Engine
	// instance.
	InstanceId string `json:"instanceId,omitempty"`
	// InstanceName: Output only. The user-friendly name of the Managed Compute
	// Engine instance.
	InstanceName string `json:"instanceName,omitempty"`
	// VirtualMachineConfig: Virtual Machine configuration settings.
	VirtualMachineConfig *VirtualMachineConfig `json:"virtualMachineConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VirtualMachine) MarshalJSON() ([]byte, error) {
	type NoMethod VirtualMachine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VirtualMachineConfig: The config settings for virtual machine.
type VirtualMachineConfig struct {
	// AcceleratorConfig: Optional. The Compute Engine accelerator configuration
	// for this runtime.
	AcceleratorConfig *RuntimeAcceleratorConfig `json:"acceleratorConfig,omitempty"`
	// BootImage: Optional. Boot image metadata used for runtime upgradeability.
	BootImage *BootImage `json:"bootImage,omitempty"`
	// ContainerImages: Optional. Use a list of container images to use as Kernels
	// in the notebook instance.
	ContainerImages []*ContainerImage `json:"containerImages,omitempty"`
	// DataDisk: Required. Data disk option configuration settings.
	DataDisk *LocalDisk `json:"dataDisk,omitempty"`
	// EncryptionConfig: Optional. Encryption settings for virtual machine data
	// disk.
	EncryptionConfig *EncryptionConfig `json:"encryptionConfig,omitempty"`
	// GuestAttributes: Output only. The Compute Engine guest attributes. (see
	// Project and instance guest attributes
	// (https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
	GuestAttributes map[string]string `json:"guestAttributes,omitempty"`
	// InternalIpOnly: Optional. If true, runtime will only have internal IP
	// addresses. By default, runtimes are not restricted to internal IP addresses,
	// and will have ephemeral external IP addresses assigned to each vm. This
	// `internal_ip_only` restriction can only be enabled for subnetwork enabled
	// networks, and all dependencies must be configured to be accessible without
	// external IP addresses.
	InternalIpOnly bool `json:"internalIpOnly,omitempty"`
	// Labels: Optional. The labels to associate with this runtime. Label **keys**
	// must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be empty, but,
	// if present, must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a cluster.
	Labels map[string]string `json:"labels,omitempty"`
	// MachineType: Required. The Compute Engine machine type used for runtimes.
	// Short name is valid. Examples: * `n1-standard-2` * `e2-standard-8`
	MachineType string `json:"machineType,omitempty"`
	// Metadata: Optional. The Compute Engine metadata entries to add to virtual
	// machine. (see Project and instance metadata
	// (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `json:"metadata,omitempty"`
	// Network: Optional. The Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork. If neither `network`
	// nor `subnet` is specified, the "default" network of the project is used, if
	// it exists. A full URL or partial URI. Examples: *
	// `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/
	// default` * `projects/[project_id]/global/networks/default` Runtimes are
	// managed resources inside Google Infrastructure. Runtimes support the
	// following network configurations: * Google Managed Network (Network & subnet
	// are empty) * Consumer Project VPC (network & subnet are required). Requires
	// configuring Private Service Access. * Shared VPC (network & subnet are
	// required). Requires configuring Private Service Access.
	Network string `json:"network,omitempty"`
	// NicType: Optional. The type of vNIC to be used on this interface. This may
	// be gVNIC or VirtioNet.
	//
	// Possible values:
	//   "UNSPECIFIED_NIC_TYPE" - No type specified.
	//   "VIRTIO_NET" - VIRTIO
	//   "GVNIC" - GVNIC
	NicType string `json:"nicType,omitempty"`
	// ReservedIpRange: Optional. Reserved IP Range name is used for VPC Peering.
	// The subnetwork allocation will use the range *name* if it's assigned.
	// Example: managed-notebooks-range-c
	// PEERING_RANGE_NAME_3=managed-notebooks-range-c gcloud compute addresses
	// create $PEERING_RANGE_NAME_3 \ --global \ --prefix-length=24 \
	// --description="Google Cloud Managed Notebooks Range 24 c" \
	// --network=$NETWORK \ --addresses=192.168.0.0 \ --purpose=VPC_PEERING Field
	// value will be: `managed-notebooks-range-c`
	ReservedIpRange string `json:"reservedIpRange,omitempty"`
	// ShieldedInstanceConfig: Optional. Shielded VM Instance configuration
	// settings.
	ShieldedInstanceConfig *RuntimeShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`
	// Subnet: Optional. The Compute Engine subnetwork to be used for machine
	// communications. Cannot be specified with network. A full URL or partial URI
	// are valid. Examples: *
	// `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1
	// /subnetworks/sub0` *
	// `projects/[project_id]/regions/us-east1/subnetworks/sub0`
	Subnet string `json:"subnet,omitempty"`
	// Tags: Optional. The Compute Engine network tags to add to runtime (see Add
	// network tags (https://cloud.google.com/vpc/docs/add-remove-network-tags)).
	Tags []string `json:"tags,omitempty"`
	// Zone: Output only. The zone where the virtual machine is located. If using
	// regional request, the notebooks service will pick a location in the
	// corresponding runtime region. On a get request, zone will always be present.
	// Example: * `us-central1-b`
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VirtualMachineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VirtualMachineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VmImage: Definition of a custom Compute Engine virtual machine image for
// starting a notebook instance with the environment installed directly on the
// VM.
type VmImage struct {
	// ImageFamily: Use this VM image family to find the image; the newest image in
	// this family will be used.
	ImageFamily string `json:"imageFamily,omitempty"`
	// ImageName: Use VM image name to find the image.
	ImageName string `json:"imageName,omitempty"`
	// Project: Required. The name of the Google Cloud project that this VM image
	// belongs to. Format: `{project_id}`
	Project string `json:"project,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageFamily") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageFamily") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VmImage) MarshalJSON() ([]byte, error) {
	type NoMethod VmImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsEnvironmentsCreateCall struct {
	s           *Service
	parent      string
	environment *Environment
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a new Environment.
//
// - parent: Format: `projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsEnvironmentsService) Create(parent string, environment *Environment) *ProjectsLocationsEnvironmentsCreateCall {
	c := &ProjectsLocationsEnvironmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.environment = environment
	return c
}

// EnvironmentId sets the optional parameter "environmentId": Required.
// User-defined unique ID of this environment. The `environment_id` must be 1
// to 63 characters long and contain only lowercase letters, numeric
// characters, and dashes. The first character must be a lowercase letter and
// the last character cannot be a dash.
func (c *ProjectsLocationsEnvironmentsCreateCall) EnvironmentId(environmentId string) *ProjectsLocationsEnvironmentsCreateCall {
	c.urlParams_.Set("environmentId", environmentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEnvironmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEnvironmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEnvironmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.environment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.environments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.environments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.environments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsEnvironmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Environment.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/environments/{environment_id}`.
func (r *ProjectsLocationsEnvironmentsService) Delete(name string) *ProjectsLocationsEnvironmentsDeleteCall {
	c := &ProjectsLocationsEnvironmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEnvironmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEnvironmentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEnvironmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.environments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.environments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.environments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsEnvironmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Environment.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/environments/{environment_id}`.
func (r *ProjectsLocationsEnvironmentsService) Get(name string) *ProjectsLocationsEnvironmentsGetCall {
	c := &ProjectsLocationsEnvironmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEnvironmentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsEnvironmentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsEnvironmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEnvironmentsGetCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEnvironmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.environments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.environments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Environment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsGetCall) Do(opts ...googleapi.CallOption) (*Environment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Environment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.environments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsEnvironmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists environments in a project.
//
// - parent: Format: `projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsEnvironmentsService) List(parent string) *ProjectsLocationsEnvironmentsListCall {
	c := &ProjectsLocationsEnvironmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum return size of the
// list call.
func (c *ProjectsLocationsEnvironmentsListCall) PageSize(pageSize int64) *ProjectsLocationsEnvironmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A previous returned page
// token that can be used to continue listing from the last result.
func (c *ProjectsLocationsEnvironmentsListCall) PageToken(pageToken string) *ProjectsLocationsEnvironmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEnvironmentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsEnvironmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsEnvironmentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsEnvironmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEnvironmentsListCall) Context(ctx context.Context) *ProjectsLocationsEnvironmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEnvironmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEnvironmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.environments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.environments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListEnvironmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEnvironmentsListCall) Do(opts ...googleapi.CallOption) (*ListEnvironmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEnvironmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.environments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsEnvironmentsListCall) Pages(ctx context.Context, f func(*ListEnvironmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsExecutionsCreateCall struct {
	s          *Service
	parent     string
	execution  *Execution
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Execution in a given project and location.
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsExecutionsService) Create(parent string, execution *Execution) *ProjectsLocationsExecutionsCreateCall {
	c := &ProjectsLocationsExecutionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.execution = execution
	return c
}

// ExecutionId sets the optional parameter "executionId": Required.
// User-defined unique ID of this execution.
func (c *ProjectsLocationsExecutionsCreateCall) ExecutionId(executionId string) *ProjectsLocationsExecutionsCreateCall {
	c.urlParams_.Set("executionId", executionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExecutionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsExecutionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExecutionsCreateCall) Context(ctx context.Context) *ProjectsLocationsExecutionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExecutionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExecutionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.execution)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/executions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.executions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.executions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExecutionsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.executions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExecutionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes execution
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/executions/{execution_id}`.
func (r *ProjectsLocationsExecutionsService) Delete(name string) *ProjectsLocationsExecutionsDeleteCall {
	c := &ProjectsLocationsExecutionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExecutionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsExecutionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExecutionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsExecutionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExecutionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExecutionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.executions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.executions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExecutionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.executions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExecutionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of executions
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/executions/{execution_id}`.
func (r *ProjectsLocationsExecutionsService) Get(name string) *ProjectsLocationsExecutionsGetCall {
	c := &ProjectsLocationsExecutionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExecutionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsExecutionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExecutionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsExecutionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExecutionsGetCall) Context(ctx context.Context) *ProjectsLocationsExecutionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExecutionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExecutionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.executions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.executions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Execution.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExecutionsGetCall) Do(opts ...googleapi.CallOption) (*Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.executions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExecutionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists executions in a given project and location
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsExecutionsService) List(parent string) *ProjectsLocationsExecutionsListCall {
	c := &ProjectsLocationsExecutionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter applied to resulting
// executions. Currently only supports filtering executions by a specified
// `schedule_id`. Format: `schedule_id=`
func (c *ProjectsLocationsExecutionsListCall) Filter(filter string) *ProjectsLocationsExecutionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort by field.
func (c *ProjectsLocationsExecutionsListCall) OrderBy(orderBy string) *ProjectsLocationsExecutionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum return size of the
// list call.
func (c *ProjectsLocationsExecutionsListCall) PageSize(pageSize int64) *ProjectsLocationsExecutionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A previous returned page
// token that can be used to continue listing from the last result.
func (c *ProjectsLocationsExecutionsListCall) PageToken(pageToken string) *ProjectsLocationsExecutionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExecutionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsExecutionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExecutionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsExecutionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExecutionsListCall) Context(ctx context.Context) *ProjectsLocationsExecutionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExecutionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExecutionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/executions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.executions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.executions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExecutionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsExecutionsListCall) Do(opts ...googleapi.CallOption) (*ListExecutionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExecutionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.executions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsExecutionsListCall) Pages(ctx context.Context, f func(*ListExecutionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsInstancesCreateCall struct {
	s          *Service
	parent     string
	instance   *Instance
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Instance in a given project and location.
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsInstancesService) Create(parent string, instance *Instance) *ProjectsLocationsInstancesCreateCall {
	c := &ProjectsLocationsInstancesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.instance = instance
	return c
}

// InstanceId sets the optional parameter "instanceId": Required. User-defined
// unique ID of this instance.
func (c *ProjectsLocationsInstancesCreateCall) InstanceId(instanceId string) *ProjectsLocationsInstancesCreateCall {
	c.urlParams_.Set("instanceId", instanceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesCreateCall) Context(ctx context.Context) *ProjectsLocationsInstancesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instance)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/instances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Delete(name string) *ProjectsLocationsInstancesDeleteCall {
	c := &ProjectsLocationsInstancesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesDeleteCall) Context(ctx context.Context) *ProjectsLocationsInstancesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesDiagnoseCall struct {
	s                       *Service
	name                    string
	diagnoseinstancerequest *DiagnoseInstanceRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Diagnose: Creates a Diagnostic File and runs Diagnostic Tool given an
// Instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Diagnose(name string, diagnoseinstancerequest *DiagnoseInstanceRequest) *ProjectsLocationsInstancesDiagnoseCall {
	c := &ProjectsLocationsInstancesDiagnoseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.diagnoseinstancerequest = diagnoseinstancerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesDiagnoseCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesDiagnoseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesDiagnoseCall) Context(ctx context.Context) *ProjectsLocationsInstancesDiagnoseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesDiagnoseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesDiagnoseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.diagnoseinstancerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:diagnose")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.diagnose", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.diagnose" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesDiagnoseCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.diagnose", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Get(name string) *ProjectsLocationsInstancesGetCall {
	c := &ProjectsLocationsInstancesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesGetCall) Context(ctx context.Context) *ProjectsLocationsInstancesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Instance.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesGetCall) Do(opts ...googleapi.CallOption) (*Instance, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Instance{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsInstancesService) GetIamPolicy(resource string) *ProjectsLocationsInstancesGetIamPolicyCall {
	c := &ProjectsLocationsInstancesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsInstancesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsInstancesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsInstancesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesGetInstanceHealthCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetInstanceHealth: Checks whether a notebook instance is healthy.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) GetInstanceHealth(name string) *ProjectsLocationsInstancesGetInstanceHealthCall {
	c := &ProjectsLocationsInstancesGetInstanceHealthCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesGetInstanceHealthCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesGetInstanceHealthCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesGetInstanceHealthCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesGetInstanceHealthCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesGetInstanceHealthCall) Context(ctx context.Context) *ProjectsLocationsInstancesGetInstanceHealthCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesGetInstanceHealthCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesGetInstanceHealthCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getInstanceHealth")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.getInstanceHealth", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.getInstanceHealth" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetInstanceHealthResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesGetInstanceHealthCall) Do(opts ...googleapi.CallOption) (*GetInstanceHealthResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetInstanceHealthResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.getInstanceHealth", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesIsUpgradeableCall struct {
	s                *Service
	notebookInstance string
	urlParams_       gensupport.URLParams
	ifNoneMatch_     string
	ctx_             context.Context
	header_          http.Header
}

// IsUpgradeable: Checks whether a notebook instance is upgradable.
//
//   - notebookInstance: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) IsUpgradeable(notebookInstance string) *ProjectsLocationsInstancesIsUpgradeableCall {
	c := &ProjectsLocationsInstancesIsUpgradeableCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.notebookInstance = notebookInstance
	return c
}

// Type sets the optional parameter "type": The optional UpgradeType. Setting
// this field will search for additional compute images to upgrade this
// instance.
//
// Possible values:
//
//	"UPGRADE_TYPE_UNSPECIFIED" - Upgrade type is not specified.
//	"UPGRADE_FRAMEWORK" - Upgrade ML framework.
//	"UPGRADE_OS" - Upgrade Operating System.
//	"UPGRADE_CUDA" - Upgrade CUDA.
//	"UPGRADE_ALL" - Upgrade All (OS, Framework and CUDA).
func (c *ProjectsLocationsInstancesIsUpgradeableCall) Type(type_ string) *ProjectsLocationsInstancesIsUpgradeableCall {
	c.urlParams_.Set("type", type_)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesIsUpgradeableCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesIsUpgradeableCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesIsUpgradeableCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesIsUpgradeableCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesIsUpgradeableCall) Context(ctx context.Context) *ProjectsLocationsInstancesIsUpgradeableCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesIsUpgradeableCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesIsUpgradeableCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+notebookInstance}:isUpgradeable")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"notebookInstance": c.notebookInstance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.isUpgradeable", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.isUpgradeable" call.
// Any non-2xx status code is an error. Response headers are in either
// *IsInstanceUpgradeableResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesIsUpgradeableCall) Do(opts ...googleapi.CallOption) (*IsInstanceUpgradeableResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IsInstanceUpgradeableResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.isUpgradeable", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists instances in a given project and location.
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsInstancesService) List(parent string) *ProjectsLocationsInstancesListCall {
	c := &ProjectsLocationsInstancesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": List filter.
func (c *ProjectsLocationsInstancesListCall) Filter(filter string) *ProjectsLocationsInstancesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort results. Supported
// values are "name", "name desc" or "" (unsorted).
func (c *ProjectsLocationsInstancesListCall) OrderBy(orderBy string) *ProjectsLocationsInstancesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum return size of the
// list call.
func (c *ProjectsLocationsInstancesListCall) PageSize(pageSize int64) *ProjectsLocationsInstancesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A previous returned page
// token that can be used to continue listing from the last result.
func (c *ProjectsLocationsInstancesListCall) PageToken(pageToken string) *ProjectsLocationsInstancesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesListCall) Context(ctx context.Context) *ProjectsLocationsInstancesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/instances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInstancesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsInstancesListCall) Do(opts ...googleapi.CallOption) (*ListInstancesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInstancesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInstancesListCall) Pages(ctx context.Context, f func(*ListInstancesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsInstancesMigrateCall struct {
	s                      *Service
	name                   string
	migrateinstancerequest *MigrateInstanceRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Migrate: Migrates an existing User-Managed Notebook to Workbench Instances.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Migrate(name string, migrateinstancerequest *MigrateInstanceRequest) *ProjectsLocationsInstancesMigrateCall {
	c := &ProjectsLocationsInstancesMigrateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.migrateinstancerequest = migrateinstancerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesMigrateCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesMigrateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesMigrateCall) Context(ctx context.Context) *ProjectsLocationsInstancesMigrateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesMigrateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesMigrateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.migrateinstancerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:migrate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.migrate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.migrate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesMigrateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.migrate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesRegisterCall struct {
	s                       *Service
	parent                  string
	registerinstancerequest *RegisterInstanceRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Register: Registers an existing legacy notebook instance to the Notebooks
// API server. Legacy instances are instances created with the legacy Compute
// Engine calls. They are not manageable by the Notebooks API out of the box.
// This call makes these instances manageable by the Notebooks API.
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsInstancesService) Register(parent string, registerinstancerequest *RegisterInstanceRequest) *ProjectsLocationsInstancesRegisterCall {
	c := &ProjectsLocationsInstancesRegisterCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.registerinstancerequest = registerinstancerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesRegisterCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesRegisterCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesRegisterCall) Context(ctx context.Context) *ProjectsLocationsInstancesRegisterCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesRegisterCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesRegisterCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.registerinstancerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/instances:register")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.register", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.register" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesRegisterCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.register", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesReportCall struct {
	s                         *Service
	name                      string
	reportinstanceinforequest *ReportInstanceInfoRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Report: Allows notebook instances to report their latest instance
// information to the Notebooks API server. The server will merge the reported
// information to the instance metadata store. Do not use this method directly.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Report(name string, reportinstanceinforequest *ReportInstanceInfoRequest) *ProjectsLocationsInstancesReportCall {
	c := &ProjectsLocationsInstancesReportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.reportinstanceinforequest = reportinstanceinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesReportCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesReportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesReportCall) Context(ctx context.Context) *ProjectsLocationsInstancesReportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesReportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesReportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reportinstanceinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:report")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.report", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.report" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesReportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.report", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesReportEventCall struct {
	s                          *Service
	name                       string
	reportinstanceeventrequest *ReportInstanceEventRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// ReportEvent: Reports and processes an instance event.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) ReportEvent(name string, reportinstanceeventrequest *ReportInstanceEventRequest) *ProjectsLocationsInstancesReportEventCall {
	c := &ProjectsLocationsInstancesReportEventCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.reportinstanceeventrequest = reportinstanceeventrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesReportEventCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesReportEventCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesReportEventCall) Context(ctx context.Context) *ProjectsLocationsInstancesReportEventCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesReportEventCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesReportEventCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reportinstanceeventrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reportEvent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.reportEvent", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.reportEvent" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesReportEventCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.reportEvent", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesResetCall struct {
	s                    *Service
	name                 string
	resetinstancerequest *ResetInstanceRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Reset: Resets a notebook instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Reset(name string, resetinstancerequest *ResetInstanceRequest) *ProjectsLocationsInstancesResetCall {
	c := &ProjectsLocationsInstancesResetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.resetinstancerequest = resetinstancerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesResetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesResetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesResetCall) Context(ctx context.Context) *ProjectsLocationsInstancesResetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesResetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesResetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.resetinstancerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reset")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.reset", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.reset" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesResetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.reset", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesRollbackCall struct {
	s                       *Service
	name                    string
	rollbackinstancerequest *RollbackInstanceRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Rollback: Rollbacks a notebook instance to the previous version.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Rollback(name string, rollbackinstancerequest *RollbackInstanceRequest) *ProjectsLocationsInstancesRollbackCall {
	c := &ProjectsLocationsInstancesRollbackCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rollbackinstancerequest = rollbackinstancerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesRollbackCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesRollbackCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesRollbackCall) Context(ctx context.Context) *ProjectsLocationsInstancesRollbackCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesRollbackCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesRollbackCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rollbackinstancerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:rollback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.rollback", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.rollback" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesRollbackCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.rollback", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesSetAcceleratorCall struct {
	s                             *Service
	name                          string
	setinstanceacceleratorrequest *SetInstanceAcceleratorRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// SetAccelerator: Updates the guest accelerators of a single Instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) SetAccelerator(name string, setinstanceacceleratorrequest *SetInstanceAcceleratorRequest) *ProjectsLocationsInstancesSetAcceleratorCall {
	c := &ProjectsLocationsInstancesSetAcceleratorCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setinstanceacceleratorrequest = setinstanceacceleratorrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesSetAcceleratorCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesSetAcceleratorCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesSetAcceleratorCall) Context(ctx context.Context) *ProjectsLocationsInstancesSetAcceleratorCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesSetAcceleratorCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesSetAcceleratorCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setinstanceacceleratorrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:setAccelerator")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.setAccelerator", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.setAccelerator" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesSetAcceleratorCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.setAccelerator", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsInstancesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsInstancesSetIamPolicyCall {
	c := &ProjectsLocationsInstancesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsInstancesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesSetLabelsCall struct {
	s                        *Service
	name                     string
	setinstancelabelsrequest *SetInstanceLabelsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// SetLabels: Replaces all the labels of an Instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) SetLabels(name string, setinstancelabelsrequest *SetInstanceLabelsRequest) *ProjectsLocationsInstancesSetLabelsCall {
	c := &ProjectsLocationsInstancesSetLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setinstancelabelsrequest = setinstancelabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesSetLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesSetLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesSetLabelsCall) Context(ctx context.Context) *ProjectsLocationsInstancesSetLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesSetLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesSetLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setinstancelabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:setLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.setLabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.setLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesSetLabelsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.setLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesSetMachineTypeCall struct {
	s                             *Service
	name                          string
	setinstancemachinetyperequest *SetInstanceMachineTypeRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// SetMachineType: Updates the machine type of a single Instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) SetMachineType(name string, setinstancemachinetyperequest *SetInstanceMachineTypeRequest) *ProjectsLocationsInstancesSetMachineTypeCall {
	c := &ProjectsLocationsInstancesSetMachineTypeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.setinstancemachinetyperequest = setinstancemachinetyperequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesSetMachineTypeCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesSetMachineTypeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesSetMachineTypeCall) Context(ctx context.Context) *ProjectsLocationsInstancesSetMachineTypeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesSetMachineTypeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesSetMachineTypeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setinstancemachinetyperequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:setMachineType")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.setMachineType", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.setMachineType" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesSetMachineTypeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.setMachineType", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesStartCall struct {
	s                    *Service
	name                 string
	startinstancerequest *StartInstanceRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Start: Starts a notebook instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Start(name string, startinstancerequest *StartInstanceRequest) *ProjectsLocationsInstancesStartCall {
	c := &ProjectsLocationsInstancesStartCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.startinstancerequest = startinstancerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesStartCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesStartCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesStartCall) Context(ctx context.Context) *ProjectsLocationsInstancesStartCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesStartCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesStartCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.startinstancerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:start")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.start", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.start" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesStartCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.start", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesStopCall struct {
	s                   *Service
	name                string
	stopinstancerequest *StopInstanceRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Stop: Stops a notebook instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Stop(name string, stopinstancerequest *StopInstanceRequest) *ProjectsLocationsInstancesStopCall {
	c := &ProjectsLocationsInstancesStopCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.stopinstancerequest = stopinstancerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesStopCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesStopCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesStopCall) Context(ctx context.Context) *ProjectsLocationsInstancesStopCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesStopCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesStopCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.stopinstancerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:stop")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.stop", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.stop" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesStopCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.stop", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsInstancesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsInstancesTestIamPermissionsCall {
	c := &ProjectsLocationsInstancesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsInstancesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesUpdateConfigCall struct {
	s                           *Service
	name                        string
	updateinstanceconfigrequest *UpdateInstanceConfigRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// UpdateConfig: Update Notebook Instance configurations.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) UpdateConfig(name string, updateinstanceconfigrequest *UpdateInstanceConfigRequest) *ProjectsLocationsInstancesUpdateConfigCall {
	c := &ProjectsLocationsInstancesUpdateConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.updateinstanceconfigrequest = updateinstanceconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesUpdateConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesUpdateConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesUpdateConfigCall) Context(ctx context.Context) *ProjectsLocationsInstancesUpdateConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesUpdateConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesUpdateConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updateinstanceconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:updateConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.updateConfig", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.updateConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesUpdateConfigCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.updateConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesUpdateMetadataItemsCall struct {
	s                                  *Service
	name                               string
	updateinstancemetadataitemsrequest *UpdateInstanceMetadataItemsRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// UpdateMetadataItems: Add/update metadata items for an instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) UpdateMetadataItems(name string, updateinstancemetadataitemsrequest *UpdateInstanceMetadataItemsRequest) *ProjectsLocationsInstancesUpdateMetadataItemsCall {
	c := &ProjectsLocationsInstancesUpdateMetadataItemsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.updateinstancemetadataitemsrequest = updateinstancemetadataitemsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesUpdateMetadataItemsCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesUpdateMetadataItemsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesUpdateMetadataItemsCall) Context(ctx context.Context) *ProjectsLocationsInstancesUpdateMetadataItemsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesUpdateMetadataItemsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesUpdateMetadataItemsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updateinstancemetadataitemsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:updateMetadataItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.updateMetadataItems", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.updateMetadataItems" call.
// Any non-2xx status code is an error. Response headers are in either
// *UpdateInstanceMetadataItemsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesUpdateMetadataItemsCall) Do(opts ...googleapi.CallOption) (*UpdateInstanceMetadataItemsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UpdateInstanceMetadataItemsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.updateMetadataItems", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall struct {
	s                                   *Service
	name                                string
	updateshieldedinstanceconfigrequest *UpdateShieldedInstanceConfigRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// UpdateShieldedInstanceConfig: Updates the Shielded instance configuration of
// a single Instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) UpdateShieldedInstanceConfig(name string, updateshieldedinstanceconfigrequest *UpdateShieldedInstanceConfigRequest) *ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall {
	c := &ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.updateshieldedinstanceconfigrequest = updateshieldedinstanceconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall) Context(ctx context.Context) *ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.updateshieldedinstanceconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:updateShieldedInstanceConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.updateShieldedInstanceConfig", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.updateShieldedInstanceConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesUpdateShieldedInstanceConfigCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.updateShieldedInstanceConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesUpgradeCall struct {
	s                      *Service
	name                   string
	upgradeinstancerequest *UpgradeInstanceRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Upgrade: Upgrades a notebook instance to the latest version.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) Upgrade(name string, upgradeinstancerequest *UpgradeInstanceRequest) *ProjectsLocationsInstancesUpgradeCall {
	c := &ProjectsLocationsInstancesUpgradeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.upgradeinstancerequest = upgradeinstancerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesUpgradeCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesUpgradeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesUpgradeCall) Context(ctx context.Context) *ProjectsLocationsInstancesUpgradeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesUpgradeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesUpgradeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.upgradeinstancerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:upgrade")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.upgrade", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.upgrade" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesUpgradeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.upgrade", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesUpgradeInternalCall struct {
	s                              *Service
	name                           string
	upgradeinstanceinternalrequest *UpgradeInstanceInternalRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// UpgradeInternal: Allows notebook instances to call this endpoint to upgrade
// themselves. Do not use this method directly.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
func (r *ProjectsLocationsInstancesService) UpgradeInternal(name string, upgradeinstanceinternalrequest *UpgradeInstanceInternalRequest) *ProjectsLocationsInstancesUpgradeInternalCall {
	c := &ProjectsLocationsInstancesUpgradeInternalCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.upgradeinstanceinternalrequest = upgradeinstanceinternalrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesUpgradeInternalCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesUpgradeInternalCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesUpgradeInternalCall) Context(ctx context.Context) *ProjectsLocationsInstancesUpgradeInternalCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesUpgradeInternalCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesUpgradeInternalCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.upgradeinstanceinternalrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:upgradeInternal")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.upgradeInternal", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.instances.upgradeInternal" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesUpgradeInternalCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.instances.upgradeInternal", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRuntimesCreateCall struct {
	s          *Service
	parent     string
	runtime    *Runtime
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Runtime in a given project and location.
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsRuntimesService) Create(parent string, runtime *Runtime) *ProjectsLocationsRuntimesCreateCall {
	c := &ProjectsLocationsRuntimesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.runtime = runtime
	return c
}

// RequestId sets the optional parameter "requestId": Idempotent request UUID.
func (c *ProjectsLocationsRuntimesCreateCall) RequestId(requestId string) *ProjectsLocationsRuntimesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// RuntimeId sets the optional parameter "runtimeId": Required. User-defined
// unique ID of this Runtime.
func (c *ProjectsLocationsRuntimesCreateCall) RuntimeId(runtimeId string) *ProjectsLocationsRuntimesCreateCall {
	c.urlParams_.Set("runtimeId", runtimeId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesCreateCall) Context(ctx context.Context) *ProjectsLocationsRuntimesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.runtime)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/runtimes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Runtime.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) Delete(name string) *ProjectsLocationsRuntimesDeleteCall {
	c := &ProjectsLocationsRuntimesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": Idempotent request UUID.
func (c *ProjectsLocationsRuntimesDeleteCall) RequestId(requestId string) *ProjectsLocationsRuntimesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesDeleteCall) Context(ctx context.Context) *ProjectsLocationsRuntimesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesDiagnoseCall struct {
	s                      *Service
	name                   string
	diagnoseruntimerequest *DiagnoseRuntimeRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Diagnose: Creates a Diagnostic File and runs Diagnostic Tool given a
// Runtime.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtimes_id}`.
func (r *ProjectsLocationsRuntimesService) Diagnose(name string, diagnoseruntimerequest *DiagnoseRuntimeRequest) *ProjectsLocationsRuntimesDiagnoseCall {
	c := &ProjectsLocationsRuntimesDiagnoseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.diagnoseruntimerequest = diagnoseruntimerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesDiagnoseCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesDiagnoseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesDiagnoseCall) Context(ctx context.Context) *ProjectsLocationsRuntimesDiagnoseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesDiagnoseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesDiagnoseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.diagnoseruntimerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:diagnose")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.diagnose", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.diagnose" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesDiagnoseCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.diagnose", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Runtime. The location must be a regional
// endpoint rather than zonal.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) Get(name string) *ProjectsLocationsRuntimesGetCall {
	c := &ProjectsLocationsRuntimesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRuntimesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRuntimesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesGetCall) Context(ctx context.Context) *ProjectsLocationsRuntimesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Runtime.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesGetCall) Do(opts ...googleapi.CallOption) (*Runtime, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Runtime{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsRuntimesService) GetIamPolicy(resource string) *ProjectsLocationsRuntimesGetIamPolicyCall {
	c := &ProjectsLocationsRuntimesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsRuntimesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsRuntimesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRuntimesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsRuntimesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsRuntimesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Runtimes in a given project and location.
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsRuntimesService) List(parent string) *ProjectsLocationsRuntimesListCall {
	c := &ProjectsLocationsRuntimesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": List filter.
func (c *ProjectsLocationsRuntimesListCall) Filter(filter string) *ProjectsLocationsRuntimesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort results. Supported
// values are "name", "name desc" or "" (unsorted).
func (c *ProjectsLocationsRuntimesListCall) OrderBy(orderBy string) *ProjectsLocationsRuntimesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum return size of the
// list call.
func (c *ProjectsLocationsRuntimesListCall) PageSize(pageSize int64) *ProjectsLocationsRuntimesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A previous returned page
// token that can be used to continue listing from the last result.
func (c *ProjectsLocationsRuntimesListCall) PageToken(pageToken string) *ProjectsLocationsRuntimesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRuntimesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRuntimesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesListCall) Context(ctx context.Context) *ProjectsLocationsRuntimesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/runtimes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRuntimesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRuntimesListCall) Do(opts ...googleapi.CallOption) (*ListRuntimesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRuntimesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRuntimesListCall) Pages(ctx context.Context, f func(*ListRuntimesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRuntimesMigrateCall struct {
	s                     *Service
	name                  string
	migrateruntimerequest *MigrateRuntimeRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Migrate: Migrate an existing Runtime to a new Workbench Instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) Migrate(name string, migrateruntimerequest *MigrateRuntimeRequest) *ProjectsLocationsRuntimesMigrateCall {
	c := &ProjectsLocationsRuntimesMigrateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.migrateruntimerequest = migrateruntimerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesMigrateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesMigrateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesMigrateCall) Context(ctx context.Context) *ProjectsLocationsRuntimesMigrateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesMigrateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesMigrateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.migrateruntimerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:migrate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.migrate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.migrate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesMigrateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.migrate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesPatchCall struct {
	s          *Service
	name       string
	runtime    *Runtime
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update Notebook Runtime configuration.
//
//   - name: Output only. The resource name of the runtime. Format:
//     `projects/{project}/locations/{location}/runtimes/{runtimeId}`.
func (r *ProjectsLocationsRuntimesService) Patch(name string, runtime *Runtime) *ProjectsLocationsRuntimesPatchCall {
	c := &ProjectsLocationsRuntimesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.runtime = runtime
	return c
}

// RequestId sets the optional parameter "requestId": Idempotent request UUID.
func (c *ProjectsLocationsRuntimesPatchCall) RequestId(requestId string) *ProjectsLocationsRuntimesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Specifies the
// path, relative to `Runtime`, of the field to update. For example, to change
// the software configuration kernels, the `update_mask` parameter would be
// specified as `software_config.kernels`, and the `PATCH` request body would
// specify the new value, as follows: { "software_config":{ "kernels": [{
// 'repository': 'gcr.io/deeplearning-platform-release/pytorch-gpu', 'tag':
// 'latest' }], } } Currently, only the following fields can be updated: -
// `software_config.kernels` - `software_config.post_startup_script` -
// `software_config.custom_gpu_driver_path` - `software_config.idle_shutdown` -
// `software_config.idle_shutdown_timeout` - `software_config.disable_terminal`
// - `labels`
func (c *ProjectsLocationsRuntimesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsRuntimesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesPatchCall) Context(ctx context.Context) *ProjectsLocationsRuntimesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.runtime)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall struct {
	s                                  *Service
	name                               string
	refreshruntimetokeninternalrequest *RefreshRuntimeTokenInternalRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// RefreshRuntimeTokenInternal: Gets an access token for the consumer service
// account that the customer attached to the runtime. Only accessible from the
// tenant instance.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) RefreshRuntimeTokenInternal(name string, refreshruntimetokeninternalrequest *RefreshRuntimeTokenInternalRequest) *ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall {
	c := &ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.refreshruntimetokeninternalrequest = refreshruntimetokeninternalrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall) Context(ctx context.Context) *ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.refreshruntimetokeninternalrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:refreshRuntimeTokenInternal")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.refreshRuntimeTokenInternal", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.refreshRuntimeTokenInternal" call.
// Any non-2xx status code is an error. Response headers are in either
// *RefreshRuntimeTokenInternalResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesRefreshRuntimeTokenInternalCall) Do(opts ...googleapi.CallOption) (*RefreshRuntimeTokenInternalResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RefreshRuntimeTokenInternalResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.refreshRuntimeTokenInternal", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesReportEventCall struct {
	s                         *Service
	name                      string
	reportruntimeeventrequest *ReportRuntimeEventRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// ReportEvent: Reports and processes a runtime event.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) ReportEvent(name string, reportruntimeeventrequest *ReportRuntimeEventRequest) *ProjectsLocationsRuntimesReportEventCall {
	c := &ProjectsLocationsRuntimesReportEventCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.reportruntimeeventrequest = reportruntimeeventrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesReportEventCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesReportEventCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesReportEventCall) Context(ctx context.Context) *ProjectsLocationsRuntimesReportEventCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesReportEventCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesReportEventCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reportruntimeeventrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reportEvent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.reportEvent", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.reportEvent" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesReportEventCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.reportEvent", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesResetCall struct {
	s                   *Service
	name                string
	resetruntimerequest *ResetRuntimeRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Reset: Resets a Managed Notebook Runtime.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) Reset(name string, resetruntimerequest *ResetRuntimeRequest) *ProjectsLocationsRuntimesResetCall {
	c := &ProjectsLocationsRuntimesResetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.resetruntimerequest = resetruntimerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesResetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesResetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesResetCall) Context(ctx context.Context) *ProjectsLocationsRuntimesResetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesResetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesResetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.resetruntimerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reset")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.reset", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.reset" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesResetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.reset", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsRuntimesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsRuntimesSetIamPolicyCall {
	c := &ProjectsLocationsRuntimesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsRuntimesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesStartCall struct {
	s                   *Service
	name                string
	startruntimerequest *StartRuntimeRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Start: Starts a Managed Notebook Runtime. Perform "Start" on GPU instances;
// "Resume" on CPU instances See:
// https://cloud.google.com/compute/docs/instances/stop-start-instance
// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) Start(name string, startruntimerequest *StartRuntimeRequest) *ProjectsLocationsRuntimesStartCall {
	c := &ProjectsLocationsRuntimesStartCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.startruntimerequest = startruntimerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesStartCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesStartCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesStartCall) Context(ctx context.Context) *ProjectsLocationsRuntimesStartCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesStartCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesStartCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.startruntimerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:start")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.start", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.start" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesStartCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.start", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesStopCall struct {
	s                  *Service
	name               string
	stopruntimerequest *StopRuntimeRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Stop: Stops a Managed Notebook Runtime. Perform "Stop" on GPU instances;
// "Suspend" on CPU instances See:
// https://cloud.google.com/compute/docs/instances/stop-start-instance
// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) Stop(name string, stopruntimerequest *StopRuntimeRequest) *ProjectsLocationsRuntimesStopCall {
	c := &ProjectsLocationsRuntimesStopCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.stopruntimerequest = stopruntimerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesStopCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesStopCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesStopCall) Context(ctx context.Context) *ProjectsLocationsRuntimesStopCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesStopCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesStopCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.stopruntimerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:stop")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.stop", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.stop" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesStopCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.stop", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesSwitchCall struct {
	s                    *Service
	name                 string
	switchruntimerequest *SwitchRuntimeRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Switch: Switch a Managed Notebook Runtime.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) Switch(name string, switchruntimerequest *SwitchRuntimeRequest) *ProjectsLocationsRuntimesSwitchCall {
	c := &ProjectsLocationsRuntimesSwitchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.switchruntimerequest = switchruntimerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesSwitchCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesSwitchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesSwitchCall) Context(ctx context.Context) *ProjectsLocationsRuntimesSwitchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesSwitchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesSwitchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.switchruntimerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:switch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.switch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.switch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesSwitchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.switch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsRuntimesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsRuntimesTestIamPermissionsCall {
	c := &ProjectsLocationsRuntimesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsRuntimesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimesUpgradeCall struct {
	s                     *Service
	name                  string
	upgraderuntimerequest *UpgradeRuntimeRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Upgrade: Upgrades a Managed Notebook Runtime to the latest version.
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`.
func (r *ProjectsLocationsRuntimesService) Upgrade(name string, upgraderuntimerequest *UpgradeRuntimeRequest) *ProjectsLocationsRuntimesUpgradeCall {
	c := &ProjectsLocationsRuntimesUpgradeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.upgraderuntimerequest = upgraderuntimerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimesUpgradeCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimesUpgradeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimesUpgradeCall) Context(ctx context.Context) *ProjectsLocationsRuntimesUpgradeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimesUpgradeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimesUpgradeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.upgraderuntimerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:upgrade")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.upgrade", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.runtimes.upgrade" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimesUpgradeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.runtimes.upgrade", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSchedulesCreateCall struct {
	s          *Service
	parent     string
	schedule   *Schedule
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Scheduled Notebook in a given project and location.
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsSchedulesService) Create(parent string, schedule *Schedule) *ProjectsLocationsSchedulesCreateCall {
	c := &ProjectsLocationsSchedulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.schedule = schedule
	return c
}

// ScheduleId sets the optional parameter "scheduleId": Required. User-defined
// unique ID of this schedule.
func (c *ProjectsLocationsSchedulesCreateCall) ScheduleId(scheduleId string) *ProjectsLocationsSchedulesCreateCall {
	c.urlParams_.Set("scheduleId", scheduleId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSchedulesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsSchedulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSchedulesCreateCall) Context(ctx context.Context) *ProjectsLocationsSchedulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSchedulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSchedulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.schedule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/schedules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.schedules.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSchedulesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSchedulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes schedule and all underlying jobs
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/schedules/{schedule_id}`.
func (r *ProjectsLocationsSchedulesService) Delete(name string) *ProjectsLocationsSchedulesDeleteCall {
	c := &ProjectsLocationsSchedulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSchedulesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsSchedulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSchedulesDeleteCall) Context(ctx context.Context) *ProjectsLocationsSchedulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSchedulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSchedulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.schedules.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSchedulesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSchedulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of schedule
//
//   - name: Format:
//     `projects/{project_id}/locations/{location}/schedules/{schedule_id}`.
func (r *ProjectsLocationsSchedulesService) Get(name string) *ProjectsLocationsSchedulesGetCall {
	c := &ProjectsLocationsSchedulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSchedulesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsSchedulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSchedulesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsSchedulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSchedulesGetCall) Context(ctx context.Context) *ProjectsLocationsSchedulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSchedulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSchedulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.schedules.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Schedule.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSchedulesGetCall) Do(opts ...googleapi.CallOption) (*Schedule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Schedule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSchedulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists schedules in a given project and location.
//
// - parent: Format: `parent=projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsSchedulesService) List(parent string) *ProjectsLocationsSchedulesListCall {
	c := &ProjectsLocationsSchedulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter applied to resulting
// schedules.
func (c *ProjectsLocationsSchedulesListCall) Filter(filter string) *ProjectsLocationsSchedulesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to order results by.
func (c *ProjectsLocationsSchedulesListCall) OrderBy(orderBy string) *ProjectsLocationsSchedulesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum return size of the
// list call.
func (c *ProjectsLocationsSchedulesListCall) PageSize(pageSize int64) *ProjectsLocationsSchedulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A previous returned page
// token that can be used to continue listing from the last result.
func (c *ProjectsLocationsSchedulesListCall) PageToken(pageToken string) *ProjectsLocationsSchedulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSchedulesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsSchedulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSchedulesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsSchedulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSchedulesListCall) Context(ctx context.Context) *ProjectsLocationsSchedulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSchedulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSchedulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/schedules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.schedules.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSchedulesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSchedulesListCall) Do(opts ...googleapi.CallOption) (*ListSchedulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSchedulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSchedulesListCall) Pages(ctx context.Context, f func(*ListSchedulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSchedulesTriggerCall struct {
	s                      *Service
	name                   string
	triggerschedulerequest *TriggerScheduleRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Trigger: Triggers execution of an existing schedule.
//
//   - name: Format:
//     `parent=projects/{project_id}/locations/{location}/schedules/{schedule_id}`.
func (r *ProjectsLocationsSchedulesService) Trigger(name string, triggerschedulerequest *TriggerScheduleRequest) *ProjectsLocationsSchedulesTriggerCall {
	c := &ProjectsLocationsSchedulesTriggerCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.triggerschedulerequest = triggerschedulerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSchedulesTriggerCall) Fields(s ...googleapi.Field) *ProjectsLocationsSchedulesTriggerCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSchedulesTriggerCall) Context(ctx context.Context) *ProjectsLocationsSchedulesTriggerCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSchedulesTriggerCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSchedulesTriggerCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.triggerschedulerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:trigger")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.trigger", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "notebooks.projects.locations.schedules.trigger" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSchedulesTriggerCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "notebooks.projects.locations.schedules.trigger", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
